/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundleContext;
import org.eclipse.virgo.teststubs.osgi.framework.StubServiceRegistration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;

public class StandardRegionFilterTests {
    private static final String BUNDLE_SYMBOLIC_NAME = "A";
    private static final Version BUNDLE_VERSION = new Version("0");
    private StubBundle stubBundle;
    private String packageImportPolicy = "(osgi.wiring.package=foo)";
    private String serviceImportPolicy = "(objectClass=foo.Service)";
    private BundleCapability fooPackage;
    private BundleCapability barPackage;
    private ServiceRegistration<Object> fooService;
    private ServiceRegistration<Object> barService;

    @Before
    public void setUp() throws Exception {
        this.stubBundle = new StubBundle(BUNDLE_SYMBOLIC_NAME, BUNDLE_VERSION);
        this.fooService = new StubServiceRegistration(new StubBundleContext(), new String[]{"foo.Service"});
        this.barService = new StubServiceRegistration(new StubBundleContext(), new String[]{"bar.Service"});
        this.fooPackage = (BundleCapability)EasyMock.createMock(BundleCapability.class);
        HashMap<String, String> fooAttrs = new HashMap<String, String>();
        fooAttrs.put("osgi.wiring.package", "foo");
        EasyMock.expect((Object)this.fooPackage.getNamespace()).andReturn((Object)"osgi.wiring.package").anyTimes();
        EasyMock.expect((Object)this.fooPackage.getAttributes()).andReturn(fooAttrs).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.fooPackage});
        this.barPackage = (BundleCapability)EasyMock.createMock(BundleCapability.class);
        HashMap<String, String> barAttrs = new HashMap<String, String>();
        barAttrs.put("osgi.wiring.package", "bar");
        EasyMock.expect((Object)this.barPackage.getNamespace()).andReturn((Object)"osgi.wiring.package").anyTimes();
        EasyMock.expect((Object)this.barPackage.getAttributes()).andReturn(barAttrs).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.barPackage});
    }

    private RegionFilter createBundleFilter(String bundleSymbolicName, Version bundleVersion) throws InvalidSyntaxException {
        String filter = "(&(org.eclipse.equinox.allow.bundle=" + bundleSymbolicName + ")(" + "bundle-version" + ">=" + bundleVersion + "))";
        return RegionReflectionUtils.newStandardRegionFilterBuilder().allow("org.eclipse.equinox.allow.bundle", filter).build();
    }

    private RegionFilter createRegionFilter(String namespace, Collection<String> filters) throws InvalidSyntaxException {
        RegionFilterBuilder builder = RegionReflectionUtils.newStandardRegionFilterBuilder();
        for (String filter : filters) {
            builder.allow(namespace, filter);
        }
        return builder.build();
    }

    @Test
    public void testBundleAllow() throws InvalidSyntaxException {
        RegionFilter regionFilter = this.createBundleFilter(BUNDLE_SYMBOLIC_NAME, BUNDLE_VERSION);
        Assert.assertTrue((boolean)regionFilter.isAllowed((Bundle)this.stubBundle));
    }

    @Test
    public void testBundleAllNotAllowed() {
        RegionFilter regionFilter = RegionReflectionUtils.newStandardRegionFilterBuilder().build();
        Assert.assertFalse((boolean)regionFilter.isAllowed((Bundle)this.stubBundle));
    }

    @Test
    public void testBundleAllAllowed() {
        RegionFilter regionFilter = RegionReflectionUtils.newStandardRegionFilterBuilder().allowAll("org.eclipse.equinox.allow.bundle").build();
        Assert.assertTrue((boolean)regionFilter.isAllowed((Bundle)this.stubBundle));
    }

    @Test
    public void testBundleNotAllowedInRange() throws InvalidSyntaxException {
        RegionFilter regionFilter = this.createBundleFilter(BUNDLE_SYMBOLIC_NAME, new Version(1, 0, 0));
        Assert.assertFalse((boolean)regionFilter.isAllowed((Bundle)this.stubBundle));
    }

    @Test
    public void testCapabilityAllowed() throws InvalidSyntaxException {
        RegionFilter regionFilter = this.createRegionFilter("osgi.wiring.package", Arrays.asList(this.packageImportPolicy));
        Assert.assertTrue((boolean)regionFilter.isAllowed(this.fooPackage));
        Assert.assertEquals(Arrays.asList(this.packageImportPolicy), regionFilter.getSharingPolicy().get("osgi.wiring.package"));
    }

    @Test
    public void testCapabilityAllNotAllowed() {
        RegionFilter regionFilter = RegionReflectionUtils.newStandardRegionFilterBuilder().build();
        Assert.assertFalse((boolean)regionFilter.isAllowed(this.barPackage));
    }

    @Test
    public void testCapabilityAllAllowed() {
        RegionFilter regionFilter = RegionReflectionUtils.newStandardRegionFilterBuilder().allowAll("osgi.wiring.package").build();
        Assert.assertTrue((boolean)regionFilter.isAllowed(this.barPackage));
    }

    @Test
    public void testCapabilityNotAllowed() throws InvalidSyntaxException {
        RegionFilter regionFilter = this.createRegionFilter("osgi.wiring.package", Arrays.asList(this.packageImportPolicy));
        Assert.assertFalse((boolean)regionFilter.isAllowed(this.barPackage));
        Assert.assertEquals(Arrays.asList(this.packageImportPolicy), regionFilter.getSharingPolicy().get("osgi.wiring.package"));
    }

    @Test
    public void testServiceAllowed() throws InvalidSyntaxException {
        RegionFilter regionFilter = this.createRegionFilter("org.eclipse.equinox.allow.service", Arrays.asList(this.serviceImportPolicy));
        Assert.assertTrue((boolean)regionFilter.isAllowed(this.fooService.getReference()));
        Assert.assertEquals(Arrays.asList(this.serviceImportPolicy), regionFilter.getSharingPolicy().get("org.eclipse.equinox.allow.service"));
    }

    @Test
    public void testServiceAllNotAllowed() {
        RegionFilter regionFilter = RegionReflectionUtils.newStandardRegionFilterBuilder().build();
        Assert.assertFalse((boolean)regionFilter.isAllowed(this.fooService.getReference()));
    }

    @Test
    public void testServiceAllAllowed() {
        RegionFilter regionFilter = RegionReflectionUtils.newStandardRegionFilterBuilder().allowAll("org.eclipse.equinox.allow.service").build();
        Assert.assertTrue((boolean)regionFilter.isAllowed(this.fooService.getReference()));
    }

    @Test
    public void testServiceNotAllowed() throws InvalidSyntaxException {
        RegionFilter regionFilter = this.createRegionFilter("org.eclipse.equinox.allow.service", Arrays.asList(this.serviceImportPolicy));
        Assert.assertFalse((boolean)regionFilter.isAllowed(this.barService.getReference()));
        Assert.assertEquals(Arrays.asList(this.serviceImportPolicy), regionFilter.getSharingPolicy().get("org.eclipse.equinox.allow.service"));
    }

    @Test
    public void testAllNamespace() throws InvalidSyntaxException {
        RegionFilter regionFilterNotAllowed = RegionReflectionUtils.newStandardRegionFilterBuilder().allow("org.eclipse.equinox.allow.all", "(all=namespace)").build();
        Assert.assertFalse((boolean)regionFilterNotAllowed.isAllowed((Bundle)this.stubBundle));
        Assert.assertFalse((boolean)regionFilterNotAllowed.isAllowed(this.fooPackage));
        Assert.assertFalse((boolean)regionFilterNotAllowed.isAllowed(this.barPackage));
        Assert.assertFalse((boolean)regionFilterNotAllowed.isAllowed(this.fooService.getReference()));
        Assert.assertFalse((boolean)regionFilterNotAllowed.isAllowed(this.barService.getReference()));
        RegionFilter regionFilterAllAllowed = RegionReflectionUtils.newStandardRegionFilterBuilder().allowAll("org.eclipse.equinox.allow.all").build();
        Assert.assertTrue((boolean)regionFilterAllAllowed.isAllowed((Bundle)this.stubBundle));
        Assert.assertTrue((boolean)regionFilterAllAllowed.isAllowed(this.fooPackage));
        Assert.assertTrue((boolean)regionFilterAllAllowed.isAllowed(this.barPackage));
        Assert.assertTrue((boolean)regionFilterAllAllowed.isAllowed(this.fooService.getReference()));
        Assert.assertTrue((boolean)regionFilterAllAllowed.isAllowed(this.barService.getReference()));
    }

    @Test
    public void testNegativeAllNamespace() throws InvalidSyntaxException {
        RegionFilter negateServices = RegionReflectionUtils.newStandardRegionFilterBuilder().allow("org.eclipse.equinox.allow.all", "(!(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.service))").build();
        Assert.assertTrue((boolean)negateServices.isAllowed((Bundle)this.stubBundle));
        Assert.assertTrue((boolean)negateServices.isAllowed(this.fooPackage));
        Assert.assertTrue((boolean)negateServices.isAllowed(this.barPackage));
        Assert.assertFalse((boolean)negateServices.isAllowed(this.fooService.getReference()));
        Assert.assertFalse((boolean)negateServices.isAllowed(this.barService.getReference()));
    }
}

