/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests.hook;

import java.util.Collection;
import java.util.HashSet;
import org.easymock.EasyMock;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundleContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;

public class RegionBundleEventHookTests {
    private BundleEvent bundleEvent;
    private Collection<BundleContext> contexts;
    private Bundle eventBundle;
    private RegionDigraph mockRegionDigraph;
    private ThreadLocal<Region> threadLocal;
    private RegionDigraph digraph;
    private Region mockRegion1;
    private Region mockRegion2;
    private BundleEvent installedEvent1;
    private BundleEvent installedEvent2;
    private StubBundle eventBundle1;
    private StubBundle eventBundle2;

    @Before
    public void setUp() throws Exception {
        this.mockRegionDigraph = (RegionDigraph)EasyMock.createMock(RegionDigraph.class);
        this.eventBundle = new StubBundle();
        this.eventBundle1 = new StubBundle(Long.valueOf(1L), "my.bundle1", new Version("0"), "loc1");
        this.eventBundle2 = new StubBundle(Long.valueOf(2L), "my.bundle2", new Version("0"), "loc2");
        this.bundleEvent = new BundleEvent(2, this.eventBundle, this.eventBundle);
        this.installedEvent1 = new BundleEvent(1, (Bundle)this.eventBundle1, this.eventBundle);
        this.installedEvent2 = new BundleEvent(1, (Bundle)this.eventBundle2, this.eventBundle);
        this.contexts = new HashSet<BundleContext>();
        StubBundleContext stubListenerBundleContext = new StubBundleContext();
        this.contexts.add((BundleContext)stubListenerBundleContext);
        this.threadLocal = new ThreadLocal();
        StubBundle stubSystemBundle = new StubBundle(Long.valueOf(0L), "osgi.framework", new Version("0"), "loc");
        StubBundleContext stubBundleContext = new StubBundleContext();
        stubBundleContext.addInstalledBundle(new StubBundle[]{stubSystemBundle});
        this.digraph = RegionReflectionUtils.newStandardRegionDigraph((BundleContext)stubBundleContext, new ThreadLocal<Region>());
        this.digraph.createRegion("mockRegion1");
        this.digraph.createRegion("mockRegion2");
        this.mockRegion1 = this.digraph.getRegion("mockRegion1");
        this.mockRegion2 = this.digraph.getRegion("mockRegion2");
        this.mockRegion1.addBundle(this.eventBundle);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testEventAllowed() {
        FindHook mockFindHook = new FindHook(){

            public void find(BundleContext context, Collection<Bundle> bundles) {
            }
        };
        EventHook eventHook = RegionReflectionUtils.newRegionBundleEventHook(this.mockRegionDigraph, mockFindHook, this.threadLocal);
        eventHook.event(this.bundleEvent, this.contexts);
        Assert.assertEquals((long)1L, (long)this.contexts.size());
    }

    @Test
    public void testEventNotAllowed() {
        FindHook mockFindHook = new FindHook(){

            public void find(BundleContext context, Collection<Bundle> bundles) {
                bundles.clear();
            }
        };
        EventHook eventHook = RegionReflectionUtils.newRegionBundleEventHook(this.mockRegionDigraph, mockFindHook, this.threadLocal);
        eventHook.event(this.bundleEvent, this.contexts);
        Assert.assertTrue((boolean)this.contexts.isEmpty());
    }

    @Test
    public void testDefaultRegion() {
        FindHook mockFindHook = new FindHook(){

            public void find(BundleContext context, Collection<Bundle> bundles) {
                bundles.clear();
            }
        };
        this.digraph.setDefaultRegion(null);
        EventHook eventHook = RegionReflectionUtils.newRegionBundleEventHook(this.digraph, mockFindHook, this.threadLocal);
        eventHook.event(this.installedEvent1, this.contexts);
        Assert.assertTrue((boolean)this.digraph.getRegion((Bundle)this.eventBundle1).equals(this.mockRegion1));
        this.digraph.setDefaultRegion(this.mockRegion2);
        eventHook = RegionReflectionUtils.newRegionBundleEventHook(this.digraph, mockFindHook, this.threadLocal);
        eventHook.event(this.installedEvent2, this.contexts);
        Assert.assertTrue((boolean)this.digraph.getRegion((Bundle)this.eventBundle2).equals(this.mockRegion2));
    }
}

