/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundleContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.bundle.FindHook;

public class RegionBundleFindHookTests {
    private static final String BUNDLE_X = "X";
    private static final Version BUNDLE_VERSION = new Version("0");
    private long bundleId;
    private static final String REGION_A = "RegionA";
    private static final String BUNDLE_A = "BundleA";
    private static final String REGION_B = "RegionB";
    private static final String BUNDLE_B = "BundleB";
    private static final String REGION_C = "RegionC";
    private static final String BUNDLE_C = "BundleC";
    private static final String REGION_D = "RegionD";
    private static final String BUNDLE_D = "BundleD";
    private RegionDigraph digraph;
    private FindHook bundleFindHook;
    private Map<String, Region> regions;
    private Map<String, Bundle> bundles;
    private Collection<Bundle> candidates;
    private ThreadLocal<Region> threadLocal;

    @Before
    public void setUp() throws Exception {
        this.bundleId = 1L;
        this.regions = new HashMap<String, Region>();
        this.bundles = new HashMap<String, Bundle>();
        StubBundle stubSystemBundle = new StubBundle(Long.valueOf(0L), "osgi.framework", new Version("0"), "loc");
        StubBundleContext stubBundleContext = new StubBundleContext();
        stubBundleContext.addInstalledBundle(new StubBundle[]{stubSystemBundle});
        this.threadLocal = new ThreadLocal();
        this.digraph = RegionReflectionUtils.newStandardRegionDigraph((BundleContext)stubBundleContext, this.threadLocal);
        this.bundleFindHook = RegionReflectionUtils.newRegionBundleFindHook(this.digraph, stubSystemBundle.getBundleId());
        this.candidates = new HashSet<Bundle>();
        this.createRegion(REGION_A, BUNDLE_A);
        this.createRegion(REGION_B, BUNDLE_B);
        this.createRegion(REGION_C, BUNDLE_C);
        this.createRegion(REGION_D, BUNDLE_D);
        this.createBundle(BUNDLE_X);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testFindInSameRegion() {
        this.candidates.add(this.bundle(BUNDLE_A));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_A)));
    }

    @Test
    public void testFindInDisconnectedRegion() {
        this.candidates.add(this.bundle(BUNDLE_B));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), this.candidates);
        Assert.assertFalse((boolean)this.candidates.contains(this.bundle(BUNDLE_B)));
    }

    @Test
    public void testFindConnectedRegionAllowed() throws BundleException, InvalidSyntaxException {
        this.doTestFindConnectedRegionAllowed(false);
    }

    @Test
    public void testFindConnectedRegionAllowedWithNegate() throws BundleException, InvalidSyntaxException {
        this.doTestFindConnectedRegionAllowed(true);
    }

    private void doTestFindConnectedRegionAllowed(boolean negate) throws BundleException, InvalidSyntaxException {
        RegionFilter filter = this.createFilter(negate, BUNDLE_B);
        this.region(REGION_A).connectRegion(this.region(REGION_B), filter);
        this.candidates.add(this.bundle(BUNDLE_B));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_B)));
    }

    @Test
    public void testFindConnectedRegionFiltering() throws BundleException, InvalidSyntaxException {
        this.doTestFindConnectedRegionFiltering(false);
    }

    @Test
    public void testFindConnectedRegionFilteringWithNegate() throws BundleException, InvalidSyntaxException {
        this.doTestFindConnectedRegionFiltering(true);
    }

    private void doTestFindConnectedRegionFiltering(boolean negate) throws BundleException, InvalidSyntaxException {
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(negate, BUNDLE_B));
        Bundle x = this.createBundle(BUNDLE_X);
        this.region(REGION_B).addBundle(x);
        this.candidates.add(this.bundle(BUNDLE_B));
        this.candidates.add(x);
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_B)));
        Assert.assertFalse((boolean)this.candidates.contains(x));
    }

    @Test
    public void testFindTransitive() throws BundleException, InvalidSyntaxException {
        this.doTestFindTransitive(false);
    }

    @Test
    public void testFindTransitiveWithNegate() throws BundleException, InvalidSyntaxException {
        this.doTestFindTransitive(true);
    }

    private void doTestFindTransitive(boolean negate) throws BundleException, InvalidSyntaxException {
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(negate, BUNDLE_C));
        this.region(REGION_B).connectRegion(this.region(REGION_C), this.createFilter(negate, BUNDLE_C));
        this.region(REGION_C).addBundle(this.bundle(BUNDLE_X));
        this.candidates.add(this.bundle(BUNDLE_B));
        this.candidates.add(this.bundle(BUNDLE_C));
        this.candidates.add(this.bundle(BUNDLE_X));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_C)));
        Assert.assertFalse((boolean)this.candidates.contains(this.bundle(BUNDLE_B)));
        Assert.assertFalse((boolean)this.candidates.contains(this.bundle(BUNDLE_X)));
    }

    @Test
    public void testFindInCyclicGraph() throws BundleException, InvalidSyntaxException {
        this.doTestFindInCyclicGraph(false);
    }

    @Test
    public void testFindInCyclicGraphWithNegate() throws BundleException, InvalidSyntaxException {
        this.doTestFindInCyclicGraph(true);
    }

    private void doTestFindInCyclicGraph(boolean negate) throws BundleException, InvalidSyntaxException {
        this.region(REGION_D).addBundle(this.bundle(BUNDLE_X));
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(negate, BUNDLE_D, BUNDLE_X));
        this.region(REGION_B).connectRegion(this.region(REGION_A), this.createFilter(negate, new String[0]));
        this.region(REGION_B).connectRegion(this.region(REGION_D), this.createFilter(negate, BUNDLE_D));
        this.region(REGION_D).connectRegion(this.region(REGION_B), this.createFilter(negate, new String[0]));
        this.region(REGION_B).connectRegion(this.region(REGION_C), this.createFilter(negate, BUNDLE_X));
        this.region(REGION_C).connectRegion(this.region(REGION_B), this.createFilter(negate, new String[0]));
        this.region(REGION_C).connectRegion(this.region(REGION_D), this.createFilter(negate, BUNDLE_X));
        this.region(REGION_D).connectRegion(this.region(REGION_C), this.createFilter(negate, new String[0]));
        this.region(REGION_A).connectRegion(this.region(REGION_C), this.createFilter(negate, new String[0]));
        this.region(REGION_C).connectRegion(this.region(REGION_A), this.createFilter(negate, new String[0]));
        this.region(REGION_D).connectRegion(this.region(REGION_A), this.createFilter(negate, new String[0]));
        this.region(REGION_A).connectRegion(this.region(REGION_D), this.createFilter(negate, new String[0]));
        this.candidates.add(this.bundle(BUNDLE_B));
        this.candidates.add(this.bundle(BUNDLE_C));
        this.candidates.add(this.bundle(BUNDLE_D));
        this.candidates.add(this.bundle(BUNDLE_X));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), this.candidates);
        Assert.assertEquals((long)2L, (long)this.candidates.size());
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_D)));
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_X)));
        this.candidates.add(this.bundle(BUNDLE_B));
        this.candidates.add(this.bundle(BUNDLE_C));
        this.candidates.add(this.bundle(BUNDLE_D));
        this.candidates.add(this.bundle(BUNDLE_X));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_B), this.candidates);
        Assert.assertEquals((long)3L, (long)this.candidates.size());
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_B)));
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_D)));
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_X)));
    }

    @Test
    public void testFindFromSystemBundle() {
        this.candidates.add(this.bundle(BUNDLE_A));
        StubBundle stubBundle = new StubBundle(Long.valueOf(0L), "sys", BUNDLE_VERSION, "");
        this.bundleFindHook.find(stubBundle.getBundleContext(), this.candidates);
        Assert.assertEquals((long)1L, (long)this.candidates.size());
        Assert.assertTrue((boolean)this.candidates.contains(this.bundle(BUNDLE_A)));
    }

    @Test
    public void testFindFromBundleInNoRegion() {
        this.candidates.add(this.bundle(BUNDLE_A));
        Bundle stranger = this.createBundle("stranger");
        this.bundleFindHook.find(stranger.getBundleContext(), this.candidates);
        Assert.assertEquals((long)0L, (long)this.candidates.size());
    }

    private Region createRegion(String regionName, String ... bundleSymbolicNames) throws BundleException {
        Region region = this.digraph.createRegion(regionName);
        String[] stringArray = bundleSymbolicNames;
        int n = bundleSymbolicNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleSymbolicName = stringArray[n2];
            Bundle stubBundle = this.createBundle(bundleSymbolicName);
            region.addBundle(stubBundle);
            ++n2;
        }
        this.regions.put(regionName, region);
        return region;
    }

    private Region region(String regionName) {
        return this.regions.get(regionName);
    }

    private RegionFilter createFilter(boolean negate, String ... bundleSymbolicNames) throws InvalidSyntaxException {
        ArrayList<String> filters = new ArrayList<String>(bundleSymbolicNames.length);
        String[] stringArray = bundleSymbolicNames;
        int n = bundleSymbolicNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleSymbolicName = stringArray[n2];
            filters.add("(org.eclipse.equinox.allow.bundle=" + bundleSymbolicName + ')');
            ++n2;
        }
        RegionFilterBuilder builder = this.digraph.createRegionFilterBuilder();
        for (String filter : filters) {
            builder.allow("org.eclipse.equinox.allow.bundle", filter);
        }
        if (negate) {
            String negateFilter = "(!(|(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.bundle)(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.bundle.lifecycle)))";
            builder.allow("org.eclipse.equinox.allow.all", negateFilter);
        }
        return builder.build();
    }

    private Bundle createBundle(String bundleSymbolicName) {
        StubBundle stubBundle = new StubBundle(Long.valueOf(this.bundleId++), bundleSymbolicName, BUNDLE_VERSION, "loc:" + bundleSymbolicName);
        this.bundles.put(bundleSymbolicName, (Bundle)stubBundle);
        return stubBundle;
    }

    private BundleContext bundleContext(String bundleSymbolicName) {
        return this.bundle(bundleSymbolicName).getBundleContext();
    }

    private Bundle bundle(String bundleSymbolicName) {
        Bundle bundleA = this.bundles.get(bundleSymbolicName);
        return bundleA;
    }
}

