/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundleContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class RegionResolverHookTests {
    private static final String PACKAGE_A = "package.a";
    private static final String PACKAGE_B = "package.b";
    private static final String PACKAGE_C = "package.c";
    private static final String PACKAGE_D = "package.d";
    private static final String PACKAGE_X = "package.x";
    private static final String PACKAGE_DUP = "duplicate";
    private static final String BUNDLE_X = "X";
    private static final Version BUNDLE_VERSION = new Version("0");
    private long bundleId;
    private static final String REGION_A = "RegionA";
    private static final String BUNDLE_A = "BundleA";
    private static final String REGION_B = "RegionB";
    private static final String BUNDLE_B = "BundleB";
    private static final String REGION_C = "RegionC";
    private static final String BUNDLE_C = "BundleC";
    private static final String REGION_D = "RegionD";
    private static final String BUNDLE_D = "BundleD";
    private RegionDigraph digraph;
    private ResolverHook resolverHook;
    private Map<String, Region> regions;
    private Map<String, Bundle> bundles;
    private Collection<BundleCapability> candidates;
    private ThreadLocal<Region> threadLocal;

    @Before
    public void setUp() throws Exception {
        this.bundleId = 1L;
        this.regions = new HashMap<String, Region>();
        this.bundles = new HashMap<String, Bundle>();
        this.threadLocal = new ThreadLocal();
        StubBundle stubSystemBundle = new StubBundle(Long.valueOf(0L), "osgi.framework", new Version("0"), "loc");
        StubBundleContext stubBundleContext = new StubBundleContext();
        stubBundleContext.addInstalledBundle(new StubBundle[]{stubSystemBundle});
        this.digraph = RegionReflectionUtils.newStandardRegionDigraph((BundleContext)stubBundleContext, this.threadLocal);
        this.resolverHook = RegionReflectionUtils.newRegionResolverHook(this.digraph);
        this.candidates = new HashSet<BundleCapability>();
        this.createRegion(REGION_A, BUNDLE_A);
        this.createRegion(REGION_B, BUNDLE_B);
        this.createRegion(REGION_C, BUNDLE_C);
        this.createRegion(REGION_D, BUNDLE_D);
        this.createBundle(BUNDLE_X);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testResolveInSameRegion() {
        this.candidates.add(this.packageCapability(BUNDLE_A, PACKAGE_A));
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_A, PACKAGE_A)));
    }

    @Test
    public void testResolveInDisconnectedRegion() {
        this.candidates.add(this.packageCapability(BUNDLE_B, PACKAGE_B));
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_A), this.candidates);
        Assert.assertFalse((boolean)this.candidates.contains(this.packageCapability(BUNDLE_B, PACKAGE_B)));
    }

    @Test
    public void testResolveConnectedRegionAllowed() throws BundleException, InvalidSyntaxException {
        RegionFilter filter = this.createFilter(PACKAGE_B);
        this.region(REGION_A).connectRegion(this.region(REGION_B), filter);
        this.candidates.add(this.packageCapability(BUNDLE_B, PACKAGE_B));
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_B, PACKAGE_B)));
    }

    @Test
    public void testResolveBundleCapabilityConnectedRegionAllowed() throws BundleException, InvalidSyntaxException {
        RegionFilter filter = this.createBundleFilter(BUNDLE_B, BUNDLE_VERSION);
        this.region(REGION_A).connectRegion(this.region(REGION_B), filter);
        this.candidates.add(this.bundleCapability(BUNDLE_B));
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.bundleCapability(BUNDLE_B)));
    }

    @Test
    public void testResolveConnectedRegionFiltering() throws BundleException, InvalidSyntaxException {
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(PACKAGE_B));
        Bundle x = this.createBundle(BUNDLE_X);
        this.region(REGION_B).addBundle(x);
        this.candidates.add(this.packageCapability(BUNDLE_B, PACKAGE_B));
        this.candidates.add(this.packageCapability(BUNDLE_X, PACKAGE_X));
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_B, PACKAGE_B)));
        Assert.assertFalse((boolean)this.candidates.contains(this.packageCapability(BUNDLE_X, PACKAGE_X)));
    }

    @Test
    public void testResolveBundleConnectedRegionFiltering() throws BundleException, InvalidSyntaxException {
        RegionFilter filter = this.createBundleFilter(BUNDLE_B, BUNDLE_VERSION);
        this.region(REGION_A).connectRegion(this.region(REGION_B), filter);
        Bundle x = this.createBundle(BUNDLE_X);
        this.region(REGION_B).addBundle(x);
        this.candidates.add(this.bundleCapability(BUNDLE_B));
        this.candidates.add(this.bundleCapability(BUNDLE_X));
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.bundleCapability(BUNDLE_B)));
        Assert.assertFalse((boolean)this.candidates.contains(this.bundleCapability(BUNDLE_X)));
    }

    @Test
    public void testResolveSingletonInSameRegions() {
        ArrayList<BundleCapability> collisionCandidates = new ArrayList<BundleCapability>();
        collisionCandidates.add(this.bundleCapability(BUNDLE_B));
        collisionCandidates.add(this.bundleCapability(BUNDLE_C));
        collisionCandidates.add(this.bundleCapability(BUNDLE_D));
        this.resolverHook.filterSingletonCollisions(this.bundleCapability(BUNDLE_A), collisionCandidates);
        Assert.assertEquals((String)"Wrong number of collitions", (long)0L, (long)collisionCandidates.size());
    }

    @Test
    public void testResolveSingletonInDifferentRegions() throws BundleException {
        this.region(REGION_A).addBundle(this.bundle(BUNDLE_X));
        BundleCapability collision = this.bundleCapability(BUNDLE_X);
        ArrayList<BundleCapability> collisionCandidates = new ArrayList<BundleCapability>();
        collisionCandidates.add(collision);
        collisionCandidates.add(this.bundleCapability(BUNDLE_B));
        collisionCandidates.add(this.bundleCapability(BUNDLE_C));
        collisionCandidates.add(this.bundleCapability(BUNDLE_D));
        this.resolverHook.filterSingletonCollisions(this.bundleCapability(BUNDLE_A), collisionCandidates);
        Assert.assertEquals((String)"Wrong number of collitions", (long)1L, (long)collisionCandidates.size());
        collisionCandidates.contains(collision);
    }

    @Test
    public void testResolveSingletonConnectedRegions() throws BundleException, InvalidSyntaxException {
        RegionFilter filter = this.createBundleFilter(BUNDLE_B, BUNDLE_VERSION);
        this.region(REGION_A).connectRegion(this.region(REGION_B), filter);
        this.region(REGION_A).addBundle(this.bundle(BUNDLE_X));
        BundleCapability collisionX = this.bundleCapability(BUNDLE_X);
        BundleCapability collisionB = this.bundleCapability(BUNDLE_B);
        ArrayList<BundleCapability> collisionCandidates = new ArrayList<BundleCapability>();
        collisionCandidates.add(collisionX);
        collisionCandidates.add(collisionB);
        collisionCandidates.add(this.bundleCapability(BUNDLE_C));
        collisionCandidates.add(this.bundleCapability(BUNDLE_D));
        this.resolverHook.filterSingletonCollisions(this.bundleCapability(BUNDLE_A), collisionCandidates);
        Assert.assertEquals((String)"Wrong number of collitions", (long)2L, (long)collisionCandidates.size());
        collisionCandidates.contains(collisionX);
        collisionCandidates.contains(collisionB);
    }

    @Test
    public void testResolveTransitive() throws BundleException, InvalidSyntaxException {
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(PACKAGE_C));
        this.region(REGION_B).connectRegion(this.region(REGION_C), this.createFilter(PACKAGE_C));
        this.region(REGION_C).addBundle(this.bundle(BUNDLE_X));
        this.candidates.add(this.packageCapability(BUNDLE_B, PACKAGE_B));
        this.candidates.add(this.packageCapability(BUNDLE_C, PACKAGE_C));
        this.candidates.add(this.packageCapability(BUNDLE_X, PACKAGE_X));
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_A), this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_C, PACKAGE_C)));
        Assert.assertFalse((boolean)this.candidates.contains(this.packageCapability(BUNDLE_B, PACKAGE_B)));
        Assert.assertFalse((boolean)this.candidates.contains(this.packageCapability(BUNDLE_X, PACKAGE_X)));
    }

    @Test
    public void testResolveTransitiveDups() throws BundleException, InvalidSyntaxException {
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(PACKAGE_B));
        this.region(REGION_A).connectRegion(this.region(REGION_C), this.createFilter(PACKAGE_DUP));
        this.region(REGION_A).connectRegion(this.region(REGION_D), this.createFilter(PACKAGE_DUP));
        this.region(REGION_B).connectRegion(this.region(REGION_C), this.createFilter(PACKAGE_DUP));
        this.region(REGION_C).connectRegion(this.region(REGION_D), this.createFilter(PACKAGE_DUP));
        this.region(REGION_D).connectRegion(this.region(REGION_A), this.createFilter(PACKAGE_DUP));
        this.candidates.add(this.packageCapability(BUNDLE_A, PACKAGE_DUP));
        this.candidates.add(this.packageCapability(BUNDLE_B, PACKAGE_DUP));
        this.candidates.add(this.packageCapability(BUNDLE_C, PACKAGE_DUP));
        this.candidates.add(this.packageCapability(BUNDLE_D, PACKAGE_DUP));
        ArrayList<BundleCapability> testCandidates = new ArrayList<BundleCapability>(this.candidates);
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_A), testCandidates);
        Assert.assertTrue((boolean)testCandidates.contains(this.packageCapability(BUNDLE_A, PACKAGE_DUP)));
        Assert.assertFalse((boolean)testCandidates.contains(this.packageCapability(BUNDLE_B, PACKAGE_DUP)));
        Assert.assertTrue((boolean)testCandidates.contains(this.packageCapability(BUNDLE_C, PACKAGE_DUP)));
        Assert.assertTrue((boolean)testCandidates.contains(this.packageCapability(BUNDLE_D, PACKAGE_DUP)));
        testCandidates = new ArrayList<BundleCapability>(this.candidates);
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_B), testCandidates);
        Assert.assertTrue((boolean)testCandidates.contains(this.packageCapability(BUNDLE_A, PACKAGE_DUP)));
        Assert.assertTrue((boolean)testCandidates.contains(this.packageCapability(BUNDLE_B, PACKAGE_DUP)));
        Assert.assertTrue((boolean)testCandidates.contains(this.packageCapability(BUNDLE_C, PACKAGE_DUP)));
        Assert.assertTrue((boolean)testCandidates.contains(this.packageCapability(BUNDLE_D, PACKAGE_DUP)));
    }

    @Test
    public void testResolveInCyclicGraph() throws BundleException, InvalidSyntaxException {
        this.region(REGION_D).addBundle(this.bundle(BUNDLE_X));
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(PACKAGE_D, PACKAGE_X));
        this.region(REGION_B).connectRegion(this.region(REGION_A), this.createFilter(new String[0]));
        this.region(REGION_B).connectRegion(this.region(REGION_D), this.createFilter(PACKAGE_D));
        this.region(REGION_D).connectRegion(this.region(REGION_B), this.createFilter(new String[0]));
        this.region(REGION_B).connectRegion(this.region(REGION_C), this.createFilter(PACKAGE_X));
        this.region(REGION_C).connectRegion(this.region(REGION_B), this.createFilter(new String[0]));
        this.region(REGION_C).connectRegion(this.region(REGION_D), this.createFilter(PACKAGE_X));
        this.region(REGION_D).connectRegion(this.region(REGION_C), this.createFilter(new String[0]));
        this.region(REGION_A).connectRegion(this.region(REGION_C), this.createFilter(new String[0]));
        this.region(REGION_C).connectRegion(this.region(REGION_A), this.createFilter(new String[0]));
        this.region(REGION_D).connectRegion(this.region(REGION_A), this.createFilter(new String[0]));
        this.region(REGION_A).connectRegion(this.region(REGION_D), this.createFilter(new String[0]));
        this.candidates.add(this.packageCapability(BUNDLE_B, PACKAGE_B));
        this.candidates.add(this.packageCapability(BUNDLE_C, PACKAGE_C));
        this.candidates.add(this.packageCapability(BUNDLE_D, PACKAGE_D));
        this.candidates.add(this.packageCapability(BUNDLE_X, PACKAGE_X));
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_A), this.candidates);
        Assert.assertEquals((long)2L, (long)this.candidates.size());
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_D, PACKAGE_D)));
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_X, PACKAGE_X)));
        this.candidates.add(this.packageCapability(BUNDLE_B, PACKAGE_B));
        this.candidates.add(this.packageCapability(BUNDLE_C, PACKAGE_C));
        this.candidates.add(this.packageCapability(BUNDLE_D, PACKAGE_D));
        this.candidates.add(this.packageCapability(BUNDLE_X, PACKAGE_X));
        this.resolverHook.filterMatches(this.bundleRequirement(BUNDLE_B), this.candidates);
        Assert.assertEquals((long)3L, (long)this.candidates.size());
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_B, PACKAGE_B)));
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_D, PACKAGE_D)));
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_X, PACKAGE_X)));
    }

    @Test
    public void testResolveFromSystemBundle() {
        this.candidates.add(this.packageCapability(BUNDLE_A, PACKAGE_A));
        StubBundle stubBundle = new StubBundle(Long.valueOf(0L), "sys", BUNDLE_VERSION, "");
        this.resolverHook.filterMatches((BundleRequirement)new StubBundleRequirement((Bundle)stubBundle), this.candidates);
        Assert.assertEquals((long)1L, (long)this.candidates.size());
        Assert.assertTrue((boolean)this.candidates.contains(this.packageCapability(BUNDLE_A, PACKAGE_A)));
    }

    @Test
    public void testResolveFromBundleInNoRegion() {
        this.candidates.add(this.packageCapability(BUNDLE_A, PACKAGE_A));
        Bundle stranger = this.createBundle("stranger");
        this.resolverHook.filterMatches((BundleRequirement)new StubBundleRequirement(stranger), this.candidates);
        Assert.assertEquals((long)0L, (long)this.candidates.size());
    }

    @Test
    public void testUnimplementedMethods() {
        this.resolverHook.filterResolvable(null);
        this.resolverHook.end();
    }

    private BundleCapability packageCapability(String bundleSymbolicName, String packageName) {
        return new StubPackageCapability(bundleSymbolicName, packageName);
    }

    private BundleCapability bundleCapability(String bundleSymbolicName) {
        return new StubBundleCapability(bundleSymbolicName);
    }

    private Region createRegion(String regionName, String ... bundleSymbolicNames) throws BundleException {
        Region region = this.digraph.createRegion(regionName);
        String[] stringArray = bundleSymbolicNames;
        int n = bundleSymbolicNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleSymbolicName = stringArray[n2];
            Bundle stubBundle = this.createBundle(bundleSymbolicName);
            region.addBundle(stubBundle);
            ++n2;
        }
        this.regions.put(regionName, region);
        return region;
    }

    private Region region(String regionName) {
        return this.regions.get(regionName);
    }

    private RegionFilter createFilter(String ... packageNames) throws InvalidSyntaxException {
        ArrayList<String> filters = new ArrayList<String>(packageNames.length);
        String[] stringArray = packageNames;
        int n = packageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            filters.add("(osgi.wiring.package=" + pkg + ')');
            ++n2;
        }
        RegionFilterBuilder builder = this.digraph.createRegionFilterBuilder();
        for (String filter : filters) {
            builder.allow("osgi.wiring.package", filter);
        }
        return builder.build();
    }

    private RegionFilter createBundleFilter(String bundleSymbolicName, Version bundleVersion) throws InvalidSyntaxException {
        String bundleFilter = "(&(org.eclipse.equinox.allow.bundle=" + bundleSymbolicName + ')' + '(' + "bundle-version" + ">=" + (bundleVersion == null ? "0" : bundleVersion.toString()) + "))";
        RegionFilterBuilder builder = this.digraph.createRegionFilterBuilder();
        return builder.allow("org.eclipse.equinox.allow.bundle", bundleFilter).build();
    }

    private Bundle createBundle(String bundleSymbolicName) {
        StubBundle stubBundle = new StubBundle(Long.valueOf(this.bundleId++), bundleSymbolicName, BUNDLE_VERSION, "loc:" + bundleSymbolicName);
        this.bundles.put(bundleSymbolicName, (Bundle)stubBundle);
        return stubBundle;
    }

    BundleRequirement bundleRequirement(String bundleSymbolicName) {
        return new StubBundleRequirement(this.bundle(bundleSymbolicName));
    }

    Bundle bundle(String bundleSymbolicName) {
        Bundle bundleA = this.bundles.get(bundleSymbolicName);
        return bundleA;
    }

    final class StubBundleCapability
    implements BundleCapability {
        private final String bundleSymbolicName;

        StubBundleCapability(String bundleSymbolicName) {
            this.bundleSymbolicName = bundleSymbolicName;
        }

        public String getNamespace() {
            return "osgi.wiring.bundle";
        }

        public Map<String, String> getDirectives() {
            return new HashMap<String, String>();
        }

        public Map<String, Object> getAttributes() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("osgi.wiring.bundle", this.bundleSymbolicName);
            return attributes;
        }

        public BundleRevision getResource() {
            return this.getRevision();
        }

        public BundleRevision getRevision() {
            return new StubBundleRevision(RegionResolverHookTests.this.bundle(this.bundleSymbolicName));
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.bundleSymbolicName == null ? 0 : this.bundleSymbolicName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StubBundleCapability)) {
                return false;
            }
            StubBundleCapability other = (StubBundleCapability)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.bundleSymbolicName == null ? other.bundleSymbolicName != null : !this.bundleSymbolicName.equals(other.bundleSymbolicName));
        }

        private RegionResolverHookTests getOuterType() {
            return RegionResolverHookTests.this;
        }
    }

    final class StubBundleRequirement
    implements BundleRequirement {
        private final StubBundleRevision bundleRevision;

        StubBundleRequirement(Bundle bundle) {
            this.bundleRevision = new StubBundleRevision(bundle);
        }

        public String getNamespace() {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> getDirectives() {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> getAttributes() {
            throw new UnsupportedOperationException();
        }

        public BundleRevision getResource() {
            return this.getRevision();
        }

        public BundleRevision getRevision() {
            return this.bundleRevision;
        }

        public boolean matches(BundleCapability capability) {
            throw new UnsupportedOperationException();
        }
    }

    final class StubBundleRevision
    implements BundleRevision {
        private final Bundle bundle;

        StubBundleRevision(Bundle bundle) {
            this.bundle = bundle;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public String getSymbolicName() {
            return this.bundle.getSymbolicName();
        }

        public Version getVersion() {
            return this.bundle.getVersion();
        }

        public List<BundleCapability> getDeclaredCapabilities(String namespace) {
            throw new UnsupportedOperationException();
        }

        public int getTypes() {
            throw new UnsupportedOperationException();
        }

        public List<BundleRequirement> getDeclaredRequirements(String namespace) {
            throw new UnsupportedOperationException();
        }

        public BundleWiring getWiring() {
            throw new UnsupportedOperationException();
        }

        public List<Capability> getCapabilities(String namespace) {
            return this.getDeclaredCapabilities(namespace);
        }

        public List<Requirement> getRequirements(String namespace) {
            return this.getDeclaredRequirements(namespace);
        }
    }

    final class StubPackageCapability
    implements BundleCapability {
        private final String bundleSymbolicName;
        private final String packageName;

        StubPackageCapability(String bundleSymbolicName, String packageName) {
            this.bundleSymbolicName = bundleSymbolicName;
            this.packageName = packageName;
        }

        public String getNamespace() {
            return "osgi.wiring.package";
        }

        public Map<String, String> getDirectives() {
            return new HashMap<String, String>();
        }

        public Map<String, Object> getAttributes() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("osgi.wiring.package", this.packageName);
            return attributes;
        }

        public BundleRevision getResource() {
            return this.getRevision();
        }

        public BundleRevision getRevision() {
            return new StubBundleRevision(RegionResolverHookTests.this.bundle(this.bundleSymbolicName));
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.bundleSymbolicName == null ? 0 : this.bundleSymbolicName.hashCode());
            result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StubPackageCapability)) {
                return false;
            }
            StubPackageCapability other = (StubPackageCapability)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.bundleSymbolicName == null ? other.bundleSymbolicName != null : !this.bundleSymbolicName.equals(other.bundleSymbolicName)) {
                return false;
            }
            return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
        }

        private RegionResolverHookTests getOuterType() {
            return RegionResolverHookTests.this;
        }
    }
}

