/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests.hook;

import java.util.Collection;
import java.util.HashSet;
import org.easymock.EasyMock;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundleContext;
import org.eclipse.virgo.teststubs.osgi.framework.StubServiceReference;
import org.eclipse.virgo.teststubs.osgi.framework.StubServiceRegistration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;

public class RegionServiceEventHookTests {
    private FindHook mockFindHook;
    private ServiceEvent serviceEvent;
    private Collection<BundleContext> contexts;
    private Bundle eventBundle;

    @Before
    public void setUp() throws Exception {
        this.mockFindHook = (FindHook)EasyMock.createMock(FindHook.class);
        this.eventBundle = new StubBundle();
        StubServiceReference stubServiceReference = new StubServiceReference(new StubServiceRegistration((StubBundleContext)this.eventBundle.getBundleContext(), new String[]{Object.class.getName()}));
        this.serviceEvent = new ServiceEvent(1, (ServiceReference)stubServiceReference);
        this.contexts = new HashSet<BundleContext>();
        StubBundleContext stubListenerBundleContext = new StubBundleContext();
        this.contexts.add((BundleContext)stubListenerBundleContext);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testEventAllowed() {
        this.mockFindHook = new FindHook(){

            public void find(BundleContext context, String name, String filter, boolean allServices, Collection<ServiceReference<?>> references) {
            }
        };
        EventHook eventHook = RegionReflectionUtils.newRegionServiceEventHook(this.mockFindHook);
        eventHook.event(this.serviceEvent, this.contexts);
        Assert.assertEquals((long)1L, (long)this.contexts.size());
    }

    @Test
    public void testEventNotAllowed() {
        this.mockFindHook = new FindHook(){

            public void find(BundleContext context, String name, String filter, boolean allServices, Collection<ServiceReference<?>> references) {
                references.clear();
            }
        };
        EventHook eventHook = RegionReflectionUtils.newRegionServiceEventHook(this.mockFindHook);
        eventHook.event(this.serviceEvent, this.contexts);
        Assert.assertTrue((boolean)this.contexts.isEmpty());
    }
}

