/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundleContext;
import org.eclipse.virgo.teststubs.osgi.framework.StubServiceReference;
import org.eclipse.virgo.teststubs.osgi.framework.StubServiceRegistration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.service.FindHook;

public class RegionServiceFindHookTests {
    private static final String BUNDLE_X = "X";
    private static final Version BUNDLE_VERSION = new Version("0");
    private long bundleId;
    private static final String REGION_A = "RegionA";
    private static final String BUNDLE_A = "BundleA";
    private static final String REGION_B = "RegionB";
    private static final String BUNDLE_B = "BundleB";
    private static final String REGION_C = "RegionC";
    private static final String BUNDLE_C = "BundleC";
    private static final String REGION_D = "RegionD";
    private static final String BUNDLE_D = "BundleD";
    private static final String DUPLICATE = "Duplicate";
    private static final String DUPLICATE_FIlTER = "Duplicate*";
    private RegionDigraph digraph;
    private FindHook bundleFindHook;
    private Map<String, Region> regions;
    private Map<String, Bundle> bundles;
    private Map<String, ServiceReference<Object>> serviceReferences;
    private Collection<ServiceReference<?>> candidates;
    private ThreadLocal<Region> threadLocal;

    @Before
    public void setUp() throws Exception {
        this.bundleId = 1L;
        this.regions = new HashMap<String, Region>();
        this.bundles = new HashMap<String, Bundle>();
        this.serviceReferences = new HashMap<String, ServiceReference<Object>>();
        StubBundle stubSystemBundle = new StubBundle(Long.valueOf(0L), "osgi.framework", new Version("0"), "loc");
        StubBundleContext stubBundleContext = new StubBundleContext();
        stubBundleContext.addInstalledBundle(new StubBundle[]{stubSystemBundle});
        this.threadLocal = new ThreadLocal();
        this.digraph = RegionReflectionUtils.newStandardRegionDigraph((BundleContext)stubBundleContext, this.threadLocal);
        this.bundleFindHook = RegionReflectionUtils.newRegionServiceFindHook(this.digraph);
        this.candidates = new HashSet();
        this.createRegion(REGION_A, BUNDLE_A);
        this.createRegion(REGION_B, BUNDLE_B);
        this.createRegion(REGION_C, BUNDLE_C);
        this.createRegion(REGION_D, BUNDLE_D);
        this.createBundle(BUNDLE_X);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testFindInSameRegion() {
        this.candidates.add(this.serviceReference(BUNDLE_A));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), "", "", false, this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_A)));
    }

    @Test
    public void testFindInDisconnectedRegion() {
        this.candidates.add(this.serviceReference(BUNDLE_B));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), "", "", false, this.candidates);
        Assert.assertFalse((boolean)this.candidates.contains(this.serviceReference(BUNDLE_B)));
    }

    @Test
    public void testFindConnectedRegionAllowed() throws BundleException, InvalidSyntaxException {
        RegionFilter filter = this.createFilter(BUNDLE_B);
        this.region(REGION_A).connectRegion(this.region(REGION_B), filter);
        this.candidates.add(this.serviceReference(BUNDLE_B));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), "", "", false, this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_B)));
    }

    @Test
    public void testFindConnectedRegionFiltering() throws BundleException, InvalidSyntaxException {
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(BUNDLE_B));
        Bundle x = this.createBundle(BUNDLE_X);
        this.region(REGION_B).addBundle(x);
        this.candidates.add(this.serviceReference(BUNDLE_B));
        this.candidates.add(this.serviceReference(BUNDLE_X));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), "", "", false, this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_B)));
        Assert.assertFalse((boolean)this.candidates.contains(this.serviceReference(BUNDLE_X)));
    }

    @Test
    public void testFindTransitive() throws BundleException, InvalidSyntaxException {
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(BUNDLE_C));
        this.region(REGION_B).connectRegion(this.region(REGION_C), this.createFilter(BUNDLE_C));
        this.region(REGION_C).addBundle(this.bundle(BUNDLE_X));
        this.candidates.add(this.serviceReference(BUNDLE_B));
        this.candidates.add(this.serviceReference(BUNDLE_C));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), "", "", false, this.candidates);
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_C)));
        Assert.assertFalse((boolean)this.candidates.contains(this.serviceReference(BUNDLE_B)));
        Assert.assertFalse((boolean)this.candidates.contains(this.serviceReference(BUNDLE_X)));
    }

    @Test
    public void testFindTransitiveDups() throws BundleException, InvalidSyntaxException {
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(BUNDLE_C));
        this.region(REGION_A).connectRegion(this.region(REGION_C), this.createFilter(DUPLICATE_FIlTER));
        this.region(REGION_A).connectRegion(this.region(REGION_D), this.createFilter(DUPLICATE_FIlTER));
        this.region(REGION_B).connectRegion(this.region(REGION_C), this.createFilter(DUPLICATE_FIlTER));
        this.region(REGION_C).connectRegion(this.region(REGION_D), this.createFilter(DUPLICATE_FIlTER));
        this.region(REGION_D).connectRegion(this.region(REGION_A), this.createFilter(DUPLICATE_FIlTER));
        this.candidates.add(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_A).getBundleId()));
        this.candidates.add(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_B).getBundleId()));
        this.candidates.add(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_C).getBundleId()));
        this.candidates.add(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_D).getBundleId()));
        ArrayList testCandidates = new ArrayList(this.candidates);
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), "", "", false, testCandidates);
        Assert.assertTrue((boolean)testCandidates.contains(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_A).getBundleId())));
        Assert.assertFalse((boolean)testCandidates.contains(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_B).getBundleId())));
        Assert.assertTrue((boolean)testCandidates.contains(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_C).getBundleId())));
        Assert.assertTrue((boolean)testCandidates.contains(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_D).getBundleId())));
        testCandidates = new ArrayList(this.candidates);
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), "", "", false, testCandidates);
        Assert.assertTrue((boolean)testCandidates.contains(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_A).getBundleId())));
        Assert.assertFalse((boolean)testCandidates.contains(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_B).getBundleId())));
        Assert.assertTrue((boolean)testCandidates.contains(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_C).getBundleId())));
        Assert.assertTrue((boolean)testCandidates.contains(this.serviceReference(DUPLICATE + this.bundle(BUNDLE_D).getBundleId())));
    }

    @Test
    public void testFindInCyclicGraph() throws BundleException, InvalidSyntaxException {
        this.region(REGION_D).addBundle(this.bundle(BUNDLE_X));
        this.region(REGION_A).connectRegion(this.region(REGION_B), this.createFilter(BUNDLE_D, BUNDLE_X));
        this.region(REGION_B).connectRegion(this.region(REGION_A), this.createFilter(new String[0]));
        this.region(REGION_B).connectRegion(this.region(REGION_D), this.createFilter(BUNDLE_D));
        this.region(REGION_D).connectRegion(this.region(REGION_B), this.createFilter(new String[0]));
        this.region(REGION_B).connectRegion(this.region(REGION_C), this.createFilter(BUNDLE_X));
        this.region(REGION_C).connectRegion(this.region(REGION_B), this.createFilter(new String[0]));
        this.region(REGION_C).connectRegion(this.region(REGION_D), this.createFilter(BUNDLE_X));
        this.region(REGION_D).connectRegion(this.region(REGION_C), this.createFilter(new String[0]));
        this.region(REGION_A).connectRegion(this.region(REGION_C), this.createFilter(new String[0]));
        this.region(REGION_C).connectRegion(this.region(REGION_A), this.createFilter(new String[0]));
        this.region(REGION_D).connectRegion(this.region(REGION_A), this.createFilter(new String[0]));
        this.region(REGION_A).connectRegion(this.region(REGION_D), this.createFilter(new String[0]));
        this.candidates.add(this.serviceReference(BUNDLE_B));
        this.candidates.add(this.serviceReference(BUNDLE_C));
        this.candidates.add(this.serviceReference(BUNDLE_D));
        this.candidates.add(this.serviceReference(BUNDLE_X));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_A), "", "", false, this.candidates);
        Assert.assertEquals((long)2L, (long)this.candidates.size());
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_D)));
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_X)));
        this.candidates.add(this.serviceReference(BUNDLE_B));
        this.candidates.add(this.serviceReference(BUNDLE_C));
        this.candidates.add(this.serviceReference(BUNDLE_D));
        this.candidates.add(this.serviceReference(BUNDLE_X));
        this.bundleFindHook.find(this.bundleContext(BUNDLE_B), "", "", false, this.candidates);
        Assert.assertEquals((long)3L, (long)this.candidates.size());
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_B)));
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_D)));
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_X)));
    }

    @Test
    public void testFindFromSystemBundle() {
        this.candidates.add(this.serviceReference(BUNDLE_A));
        StubBundle stubBundle = new StubBundle(Long.valueOf(0L), "sys", BUNDLE_VERSION, "");
        this.bundleFindHook.find(stubBundle.getBundleContext(), "", "", false, this.candidates);
        Assert.assertEquals((long)1L, (long)this.candidates.size());
        Assert.assertTrue((boolean)this.candidates.contains(this.serviceReference(BUNDLE_A)));
    }

    @Test
    public void testFindFromBundleInNoRegion() {
        this.candidates.add(this.serviceReference(BUNDLE_A));
        Bundle stranger = this.createBundle("stranger");
        this.bundleFindHook.find(stranger.getBundleContext(), "", "", false, this.candidates);
        Assert.assertEquals((long)0L, (long)this.candidates.size());
    }

    private Region createRegion(String regionName, String ... bundleSymbolicNames) throws BundleException {
        Region region = this.digraph.createRegion(regionName);
        String[] stringArray = bundleSymbolicNames;
        int n = bundleSymbolicNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleSymbolicName = stringArray[n2];
            Bundle stubBundle = this.createBundle(bundleSymbolicName);
            region.addBundle(stubBundle);
            ++n2;
        }
        this.regions.put(regionName, region);
        return region;
    }

    private Region region(String regionName) {
        return this.regions.get(regionName);
    }

    private RegionFilter createFilter(String ... referenceNames) throws InvalidSyntaxException {
        ArrayList<String> filters = new ArrayList<String>(referenceNames.length);
        String[] stringArray = referenceNames;
        int n = referenceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String referenceName = stringArray[n2];
            filters.add("(objectClass=" + referenceName + ')');
            ++n2;
        }
        RegionFilterBuilder builder = this.digraph.createRegionFilterBuilder();
        for (String filter : filters) {
            builder.allow("org.eclipse.equinox.allow.service", filter);
        }
        String negateFilter = "(!(|(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.service)(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.bundle)))";
        builder.allow("org.eclipse.equinox.allow.all", negateFilter);
        return builder.build();
    }

    private Bundle createBundle(String bundleSymbolicName) {
        StubBundle stubBundle = new StubBundle(Long.valueOf(this.bundleId++), bundleSymbolicName, BUNDLE_VERSION, "loc:" + bundleSymbolicName);
        this.bundles.put(bundleSymbolicName, (Bundle)stubBundle);
        this.createServiceReference((Bundle)stubBundle, bundleSymbolicName);
        return stubBundle;
    }

    private StubServiceReference<Object> createServiceReference(Bundle stubBundle, String referenceName) {
        StubServiceRegistration stubServiceRegistration = new StubServiceRegistration((StubBundleContext)stubBundle.getBundleContext(), new String[]{referenceName});
        StubServiceReference stubServiceReference = new StubServiceReference(stubServiceRegistration);
        this.serviceReferences.put(referenceName, (ServiceReference<Object>)stubServiceReference);
        StubServiceRegistration dupServiceRegistration = new StubServiceRegistration((StubBundleContext)stubBundle.getBundleContext(), new String[]{DUPLICATE + stubBundle.getBundleId()});
        StubServiceReference dupServiceReference = new StubServiceReference(dupServiceRegistration);
        this.serviceReferences.put(DUPLICATE + stubBundle.getBundleId(), (ServiceReference<Object>)dupServiceReference);
        return stubServiceReference;
    }

    private BundleContext bundleContext(String bundleSymbolicName) {
        return this.bundle(bundleSymbolicName).getBundleContext();
    }

    private Bundle bundle(String bundleSymbolicName) {
        Bundle bundleA = this.bundles.get(bundleSymbolicName);
        return bundleA;
    }

    private ServiceReference<Object> serviceReference(String referenceName) {
        return this.serviceReferences.get(referenceName);
    }
}

