/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.tests;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.equinox.region.Region;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.util.tracker.ServiceTracker;

public class BundleInstaller {
    private final BundleContext context;
    private final Bundle testBundle;
    private String rootLocation;
    private Map<String, Bundle> bundles = new HashMap<String, Bundle>();
    private final ServiceTracker<URLConverter, URLConverter> converter;
    private final FrameworkWiring frameworkWiring;

    public BundleInstaller(String bundlesRoot, Bundle testBundle) throws InvalidSyntaxException {
        BundleContext bc = testBundle.getBundleContext();
        Bundle systemBundle = bc.getBundle(0L);
        this.context = systemBundle.getBundleContext();
        this.frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        this.rootLocation = bundlesRoot;
        this.converter = new ServiceTracker(this.context, this.context.createFilter("(&(objectClass=" + URLConverter.class.getName() + ")(protocol=bundleentry))"), null);
        this.converter.open();
        this.testBundle = testBundle;
    }

    public synchronized Bundle installBundle(String name) throws BundleException {
        return this.installBundle(name, null);
    }

    public synchronized Bundle installBundle(String name, Region region) throws BundleException {
        Bundle bundle;
        if (this.bundles == null) {
            return null;
        }
        String location = this.getBundleLocation(name);
        Bundle bundle2 = bundle = region != null ? region.installBundle(location) : this.context.installBundle(location);
        if (this.bundles.containsKey(name)) {
            int offset = 0;
            while (this.bundles.containsKey(String.valueOf(name) + '_' + offset)) {
                ++offset;
            }
            this.bundles.put(String.valueOf(name) + '_' + offset, bundle);
        } else {
            this.bundles.put(name, bundle);
        }
        return bundle;
    }

    public String getBundleLocation(final String name) throws BundleException {
        if (System.getSecurityManager() == null) {
            return this.getBundleLocation0(name);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return BundleInstaller.this.getBundleLocation0(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    String getBundleLocation0(String name) throws BundleException {
        String bundleFileName = String.valueOf(this.rootLocation) + "/" + name;
        URL bundleURL = this.testBundle.getEntry(bundleFileName);
        if (bundleURL == null) {
            bundleURL = this.testBundle.getEntry(String.valueOf(bundleFileName) + ".jar");
        }
        if (bundleURL == null) {
            throw new BundleException("Could not find bundle to install at: " + name);
        }
        try {
            bundleURL = ((URLConverter)this.converter.getService()).resolve(bundleURL);
        }
        catch (IOException e) {
            throw new BundleException("Converter error", (Throwable)e);
        }
        String location = bundleURL.toExternalForm();
        if ("file".equals(bundleURL.getProtocol())) {
            location = "reference:" + location;
        }
        return location;
    }

    public synchronized Bundle updateBundle(String fromName, String toName) throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle fromBundle = this.bundles.get(fromName);
        if (fromBundle == null) {
            throw new BundleException("The bundle to update does not exist!! " + fromName);
        }
        String bundleFileName = String.valueOf(this.rootLocation) + "/" + toName;
        URL bundleURL = this.testBundle.getEntry(bundleFileName);
        if (bundleURL == null) {
            bundleURL = this.testBundle.getEntry(String.valueOf(bundleFileName) + ".jar");
        }
        try {
            bundleURL = ((URLConverter)this.converter.getService()).resolve(bundleURL);
        }
        catch (IOException e) {
            throw new BundleException("Converter error", (Throwable)e);
        }
        String location = bundleURL.toExternalForm();
        if ("file".equals(bundleURL.getProtocol())) {
            location = "reference:" + location;
        }
        try {
            fromBundle.update(new URL(location).openStream());
        }
        catch (Exception e) {
            throw new BundleException("Errors when updating bundle " + fromBundle, (Throwable)e);
        }
        this.bundles.remove(fromName);
        this.bundles.put(toName, fromBundle);
        return fromBundle;
    }

    public synchronized Bundle uninstallBundle(String name) throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle bundle = this.bundles.remove(name);
        if (bundle == null) {
            return null;
        }
        bundle.uninstall();
        return bundle;
    }

    public synchronized Bundle[] uninstallAllBundles() throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        ArrayList<Bundle> result = new ArrayList<Bundle>(this.bundles.size());
        for (Bundle bundle : this.bundles.values()) {
            try {
                bundle.uninstall();
            }
            catch (IllegalStateException illegalStateException) {}
            result.add(bundle);
        }
        this.bundles.clear();
        return result.toArray(new Bundle[result.size()]);
    }

    public synchronized Bundle[] shutdown() throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle[] result = this.uninstallAllBundles();
        this.refreshPackages(result);
        this.converter.close();
        this.bundles = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Bundle[] refreshPackages(Bundle[] refresh) {
        if (refresh == null) {
            return null;
        }
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        final HashSet refreshed = new HashSet();
        SynchronousBundleListener refreshBundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                refreshed.add(event.getBundle());
            }
        };
        this.context.addBundleListener((BundleListener)refreshBundleListener);
        try {
            this.frameworkWiring.refreshBundles(Arrays.asList(refresh), new FrameworkListener[]{listener});
            boolean[] blArray = flag;
            synchronized (flag) {
                while (true) {
                    if (flag[0]) {
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return refreshed.toArray(new Bundle[refreshed.size()]);
                    }
                    try {
                        flag.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            this.context.removeBundleListener((BundleListener)refreshBundleListener);
        }
    }

    public synchronized boolean resolveBundles(Bundle[] resolve) {
        if (resolve == null) {
            return false;
        }
        return this.frameworkWiring.resolveBundles(Arrays.asList(resolve));
    }

    public synchronized Bundle getBundle(String name) {
        if (this.bundles == null) {
            return null;
        }
        return this.bundles.get(name);
    }
}

