/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.tests.system;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.tests.BundleInstaller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class AbstractRegionSystemTest
extends TestCase {
    public static final String PP1 = "PackageProvider1";
    public static final String SP1 = "ServiceProvider1";
    public static final String CP1 = "CapabilityProvider1";
    public static final String PP2 = "PackageProvider2";
    public static final String SP2 = "ServiceProvider2";
    public static final String CP2 = "CapabilityProvider2";
    public static final String PC1 = "PackageClient1";
    public static final String BC1 = "BundleClient1";
    public static final String SC1 = "ServiceClient1";
    public static final String CC1 = "CapabilityClient1";
    public static List<String> ALL = Arrays.asList("PackageProvider1", "ServiceProvider1", "CapabilityProvider1", "PackageProvider2", "ServiceProvider2", "CapabilityProvider2", "PackageClient1", "BundleClient1", "ServiceClient1", "CapabilityClient1");
    public static final String SINGLETON1 = "Singleton1";
    public static final String SINGLETON2 = "Singleton2";
    protected BundleInstaller bundleInstaller;
    protected RegionDigraph digraph;
    protected Bundle testsBundle;
    ServiceReference<RegionDigraph> digraphReference;

    protected void setUp() throws Exception {
        this.testsBundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        BundleContext context = this.getContext();
        this.digraphReference = context.getServiceReference(RegionDigraph.class);
        AbstractRegionSystemTest.assertNotNull((String)"No digraph found", this.digraphReference);
        this.digraph = (RegionDigraph)context.getService(this.digraphReference);
        AbstractRegionSystemTest.assertNotNull((Object)"No digraph found");
        this.bundleInstaller = new BundleInstaller("bundle_tests", this.testsBundle);
    }

    protected void tearDown() throws Exception {
        for (Region region : this.digraph) {
            if (region.contains(0L)) continue;
            this.digraph.removeRegion(region);
        }
        this.bundleInstaller.shutdown();
        if (this.digraphReference != null) {
            this.getContext().ungetService(this.digraphReference);
        }
    }

    protected BundleContext getContext() {
        BundleContext context = this.testsBundle.getBundleContext();
        AbstractRegionSystemTest.assertNotNull((String)"No context available", (Object)context);
        return context;
    }
}

