/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.tests.system;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.tests.system.AbstractRegionSystemTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class Bug346127Test
extends AbstractRegionSystemTest {
    public void testBug346127() throws Exception {
        String location = this.bundleInstaller.getBundleLocation("PackageProvider1");
        location = "regiondigraphtest:" + location;
        Region region = this.digraph.getRegion(this.getContext().getBundle());
        try {
            Bundle bundle = region.installBundle(location);
            Bug346127Test.assertNotNull((Object)bundle);
        }
        catch (BundleException e) {
            e.printStackTrace();
            Bug346127Test.fail((String)("Failed to install a bundle into a region using a custom, non-file URL: " + e.getMessage()));
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{"regiondigraphtest"});
        this.getContext().registerService(URLStreamHandlerService.class.getName(), (Object)new AbstractURLStreamHandlerService(){

            public URLConnection openConnection(URL u) {
                return new URLConnection(u){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        String s = this.getURL().toString();
                        s = s.substring(s.indexOf("regiondigraphtest:") + "regiondigraphtest:".length());
                        return new URL(s).openStream();
                    }
                };
            }
        }, properties);
    }
}

