/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.tests.system;

import junit.framework.TestCase;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.eclipse.equinox.region.tests.system.AbstractRegionSystemTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public class RegionPerformanceTests
extends AbstractRegionSystemTest {
    Bundle testBundle;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testBundle = this.bundleInstaller.installBundle("PackageProvider1");
        this.testBundle.start();
    }

    private void doTestGetBundles(String fingerPrintName, String degradation) {
        final BundleContext context = this.testBundle.getBundleContext();
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() {
                Bundle[] bundles;
                Bundle[] bundleArray = bundles = context.getBundles();
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle = bundleArray[n2];
                    context.getBundle(bundle.getBundleId());
                    ++n2;
                }
            }
        };
        runner.setRegressionReason(degradation);
        runner.run((TestCase)this, fingerPrintName, 10, 300);
    }

    public void testGetBundlesNoRegions() throws BundleException {
        this.doTestGetBundles(null, null);
    }

    public void testGetBundles10Regions() throws BundleException {
        this.createRegions(10);
        this.doTestGetBundles(null, null);
    }

    public void testGetBundles100Regions() throws BundleException {
        this.createRegions(100);
        this.doTestGetBundles(null, null);
    }

    public void testGetBundles1000Regions() throws BundleException {
        this.createRegions(1000);
        this.doTestGetBundles(null, null);
    }

    public void testGetServicesNoRegions() throws BundleException {
        this.doTestGetServices(null, null);
    }

    public void testGetServices10Regions() throws BundleException {
        this.createRegions(10);
        this.doTestGetServices(null, null);
    }

    public void testGetServices100Regions() throws BundleException {
        this.createRegions(100);
        this.doTestGetBundles(null, null);
    }

    public void testGetServices1000Regions() throws BundleException {
        this.createRegions(1000);
        this.doTestGetBundles(null, null);
    }

    private void doTestGetServices(String fingerPrintName, String degradation) {
        final BundleContext context = this.testBundle.getBundleContext();
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() {
                try {
                    context.getServiceReferences(RegionDigraph.class, null);
                }
                catch (InvalidSyntaxException e) {
                    RegionPerformanceTests.fail((String)e.getMessage());
                }
            }
        };
        runner.setRegressionReason(degradation);
        runner.run((TestCase)this, fingerPrintName, 10, 2000);
    }

    private void createRegions(int numRegions) throws BundleException {
        System.out.println("Starting region create: " + numRegions);
        long time = System.currentTimeMillis();
        Region system = this.digraph.getRegion(0L);
        RegionFilterBuilder builder = this.digraph.createRegionFilterBuilder();
        builder.allowAll("org.eclipse.equinox.allow.bundle");
        builder.allowAll("osgi.wiring.host");
        builder.allowAll("osgi.wiring.package");
        builder.allowAll("osgi.wiring.bundle");
        builder.allowAll("org.eclipse.equinox.allow.service");
        RegionFilter filter = builder.build();
        int i = 0;
        while (i < numRegions) {
            Region r = this.digraph.createRegion(String.valueOf(this.getName()) + i);
            this.digraph.connect(system, filter, r);
            ++i;
        }
        System.out.println("Done creating region: " + (System.currentTimeMillis() - time));
    }
}

