/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.tests.system;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.eclipse.equinox.region.tests.system.AbstractRegionSystemTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.util.tracker.ServiceTracker;

public class RegionSystemTests
extends AbstractRegionSystemTest {
    private static final long TEST_BUNDLE_ID = 452345245L;
    private static final String REGION_DOMAIN_PROP = "org.eclipse.equinox.region.domain";

    public void testBasic() throws BundleException, InvalidSyntaxException, InterruptedException {
        Region systemRegion = this.digraph.getRegion(0L);
        Region testRegion = this.digraph.createRegion(this.getName());
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Bundle pp1 = this.bundleInstaller.installBundle("PackageProvider1", testRegion);
        bundles.add(pp1);
        pp1.start();
        RegionSystemTests.assertNull((String)"Found some services.", (Object)pp1.getBundleContext().getAllServiceReferences(null, null));
        RegionSystemTests.assertEquals((String)"Found extra bundles in region", (int)1, (int)pp1.getBundleContext().getBundles().length);
        pp1.stop();
        bundles.add(this.bundleInstaller.installBundle("ServiceProvider1", testRegion));
        bundles.add(this.bundleInstaller.installBundle("CapabilityProvider1", testRegion));
        bundles.add(this.bundleInstaller.installBundle("PackageProvider2", testRegion));
        bundles.add(this.bundleInstaller.installBundle("ServiceProvider2", testRegion));
        Bundle cp2 = this.bundleInstaller.installBundle("CapabilityProvider2", testRegion);
        bundles.add(cp2);
        bundles.add(this.bundleInstaller.installBundle("PackageClient1", testRegion));
        bundles.add(this.bundleInstaller.installBundle("BundleClient1", testRegion));
        Bundle sc1 = this.bundleInstaller.installBundle("ServiceClient1", testRegion);
        bundles.add(sc1);
        bundles.add(this.bundleInstaller.installBundle("CapabilityClient1", testRegion));
        this.digraph.connect(testRegion, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.bundle", "(id=0)").build(), systemRegion);
        this.digraph.connect(systemRegion, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.service", "(objectClass=java.lang.Boolean)").build(), testRegion);
        this.bundleInstaller.resolveBundles(bundles.toArray(new Bundle[bundles.size()]));
        for (Bundle bundle : bundles) {
            RegionSystemTests.assertEquals((String)("Bundle did not resolve: " + bundle.getSymbolicName()), (int)4, (int)bundle.getState());
            bundle.start();
        }
        BundleContext context = this.getContext();
        ServiceTracker cp2Tracker = new ServiceTracker(context, context.createFilter("(&(objectClass=java.lang.Boolean)(bundle.id=" + cp2.getBundleId() + "))"), null);
        ServiceTracker sc1Tracker = new ServiceTracker(context, context.createFilter("(&(objectClass=java.lang.Boolean)(bundle.id=" + sc1.getBundleId() + "))"), null);
        cp2Tracker.open();
        sc1Tracker.open();
        RegionSystemTests.assertNotNull((String)"The cp2 bundle never found the service.", (Object)cp2Tracker.waitForService(2000L));
        RegionSystemTests.assertNotNull((String)"The sc1 bundle never found the service.", (Object)sc1Tracker.waitForService(2000L));
        cp2Tracker.close();
        sc1Tracker.close();
    }

    public void testSingleBundleRegions() throws BundleException, InvalidSyntaxException, InterruptedException {
        Region systemRegion = this.digraph.getRegion(0L);
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (String location : ALL) {
            Region testRegion = this.digraph.createRegion(location);
            bundles.put(location, this.bundleInstaller.installBundle(location, testRegion));
            this.digraph.connect(testRegion, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.bundle", "(id=0)").build(), systemRegion);
            this.digraph.connect(systemRegion, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.service", "(objectClass=java.lang.Boolean)").build(), testRegion);
        }
        this.bundleInstaller.resolveBundles(bundles.values().toArray(new Bundle[bundles.size()]));
        RegionSystemTests.assertEquals((String)"PackageProvider1", (int)4, (int)((Bundle)bundles.get("PackageProvider1")).getState());
        RegionSystemTests.assertEquals((String)"ServiceProvider1", (int)2, (int)((Bundle)bundles.get("ServiceProvider1")).getState());
        RegionSystemTests.assertEquals((String)"CapabilityProvider1", (int)4, (int)((Bundle)bundles.get("CapabilityProvider1")).getState());
        RegionSystemTests.assertEquals((String)"PackageProvider2", (int)2, (int)((Bundle)bundles.get("PackageProvider2")).getState());
        RegionSystemTests.assertEquals((String)"ServiceProvider2", (int)2, (int)((Bundle)bundles.get("ServiceProvider2")).getState());
        RegionSystemTests.assertEquals((String)"CapabilityProvider2", (int)2, (int)((Bundle)bundles.get("CapabilityProvider2")).getState());
        RegionSystemTests.assertEquals((String)"BundleClient1", (int)2, (int)((Bundle)bundles.get("BundleClient1")).getState());
        RegionSystemTests.assertEquals((String)"ServiceClient1", (int)2, (int)((Bundle)bundles.get("ServiceClient1")).getState());
        RegionSystemTests.assertEquals((String)"CapabilityClient1", (int)2, (int)((Bundle)bundles.get("CapabilityClient1")).getState());
        this.digraph.connect(this.digraph.getRegion("ServiceProvider1"), this.digraph.createRegionFilterBuilder().allow("osgi.wiring.package", "(osgi.wiring.package=pkg1.*)").build(), this.digraph.getRegion("PackageProvider1"));
        this.digraph.connect(this.digraph.getRegion("PackageProvider2"), this.digraph.createRegionFilterBuilder().allow("CapabilityProvider1", "(name=CapabilityProvider1)").build(), this.digraph.getRegion("CapabilityProvider1"));
        this.digraph.connect(this.digraph.getRegion("ServiceProvider2"), this.digraph.createRegionFilterBuilder().allow("osgi.wiring.package", "(osgi.wiring.package=pkg2.*)").build(), this.digraph.getRegion("PackageProvider2"));
        this.digraph.connect(this.digraph.getRegion("CapabilityProvider2"), this.digraph.createRegionFilterBuilder().allow("osgi.wiring.package", "(osgi.wiring.package=pkg1.*)").build(), this.digraph.getRegion("PackageProvider1"));
        this.digraph.connect(this.digraph.getRegion("CapabilityProvider2"), this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.service", "(objectClass=pkg1.*)").build(), this.digraph.getRegion("ServiceProvider1"));
        this.digraph.connect(this.digraph.getRegion("PackageClient1"), this.digraph.createRegionFilterBuilder().allow("osgi.wiring.package", "(osgi.wiring.package=pkg2.*)").build(), this.digraph.getRegion("PackageProvider2"));
        this.digraph.connect(this.digraph.getRegion("BundleClient1"), this.digraph.createRegionFilterBuilder().allow("osgi.wiring.bundle", "(osgi.wiring.bundle=PackageProvider2)").build(), this.digraph.getRegion("PackageProvider2"));
        this.digraph.connect(this.digraph.getRegion("ServiceClient1"), this.digraph.createRegionFilterBuilder().allow("osgi.wiring.package", "(osgi.wiring.package=pkg2.*)").build(), this.digraph.getRegion("PackageProvider2"));
        this.digraph.connect(this.digraph.getRegion("ServiceClient1"), this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.service", "(objectClass=pkg2.*)").build(), this.digraph.getRegion("ServiceProvider2"));
        this.digraph.connect(this.digraph.getRegion("CapabilityClient1"), this.digraph.createRegionFilterBuilder().allow("CapabilityProvider2", "(name=CapabilityProvider2)").build(), this.digraph.getRegion("CapabilityProvider2"));
        this.bundleInstaller.resolveBundles(bundles.values().toArray(new Bundle[bundles.size()]));
        for (Bundle bundle : bundles.values()) {
            RegionSystemTests.assertEquals((String)("Bundle did not resolve: " + bundle.getSymbolicName()), (int)4, (int)bundle.getState());
            bundle.start();
        }
        BundleContext context = this.getContext();
        ServiceTracker cp2Tracker = new ServiceTracker(context, context.createFilter("(&(objectClass=java.lang.Boolean)(bundle.id=" + ((Bundle)bundles.get("CapabilityProvider2")).getBundleId() + "))"), null);
        ServiceTracker sc1Tracker = new ServiceTracker(context, context.createFilter("(&(objectClass=java.lang.Boolean)(bundle.id=" + ((Bundle)bundles.get("ServiceClient1")).getBundleId() + "))"), null);
        cp2Tracker.open();
        sc1Tracker.open();
        RegionSystemTests.assertNotNull((String)"The cp2 bundle never found the service.", (Object)cp2Tracker.waitForService(2000L));
        RegionSystemTests.assertNotNull((String)"The sc1 bundle never found the service.", (Object)sc1Tracker.waitForService(2000L));
        cp2Tracker.close();
        sc1Tracker.close();
    }

    public void testCyclicRegions0() throws BundleException, InvalidSyntaxException, InterruptedException {
        this.doCyclicRegions(0);
    }

    public void testCyclicRegions10() throws BundleException, InvalidSyntaxException, InterruptedException {
        this.doCyclicRegions(10);
    }

    public void testCyclicRegions100() throws BundleException, InvalidSyntaxException, InterruptedException {
        this.doCyclicRegions(100);
    }

    private void doCyclicRegions(int numLevels) throws BundleException, InvalidSyntaxException, InterruptedException {
        String regionName1 = String.valueOf(this.getName()) + "_1";
        String regionName2 = String.valueOf(this.getName()) + "_2";
        Region systemRegion = this.digraph.getRegion(0L);
        Region testRegion1 = this.digraph.createRegion(regionName1);
        Region testRegion2 = this.digraph.createRegion(regionName2);
        testRegion1.connectRegion(systemRegion, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.bundle", "(id=0)").build());
        testRegion2.connectRegion(systemRegion, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.bundle", "(id=0)").build());
        systemRegion.connectRegion(testRegion1, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.service", "(objectClass=java.lang.Boolean)").build());
        systemRegion.connectRegion(testRegion2, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.service", "(objectClass=java.lang.Boolean)").build());
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        bundles.put("PackageProvider1", this.bundleInstaller.installBundle("PackageProvider1", testRegion1));
        bundles.put("ServiceProvider2", this.bundleInstaller.installBundle("ServiceProvider2", testRegion1));
        bundles.put("CapabilityProvider2", this.bundleInstaller.installBundle("CapabilityProvider2", testRegion1));
        bundles.put("PackageClient1", this.bundleInstaller.installBundle("PackageClient1", testRegion1));
        bundles.put("BundleClient1", this.bundleInstaller.installBundle("BundleClient1", testRegion1));
        bundles.put("ServiceProvider1", this.bundleInstaller.installBundle("ServiceProvider1", testRegion2));
        bundles.put("CapabilityProvider1", this.bundleInstaller.installBundle("CapabilityProvider1", testRegion2));
        bundles.put("PackageProvider2", this.bundleInstaller.installBundle("PackageProvider2", testRegion2));
        bundles.put("ServiceClient1", this.bundleInstaller.installBundle("ServiceClient1", testRegion2));
        bundles.put("CapabilityClient1", this.bundleInstaller.installBundle("CapabilityClient1", testRegion2));
        RegionFilterBuilder testRegionFilter1 = this.digraph.createRegionFilterBuilder();
        testRegionFilter1.allow("osgi.wiring.package", "(osgi.wiring.package=pkg2.*)");
        testRegionFilter1.allow("org.eclipse.equinox.allow.service", "(objectClass=pkg1.*)");
        testRegionFilter1.allow("osgi.wiring.bundle", "(osgi.wiring.bundle=PackageProvider2)");
        RegionFilterBuilder testRegionFilter2 = this.digraph.createRegionFilterBuilder();
        testRegionFilter2.allow("osgi.wiring.package", "(osgi.wiring.package=pkg1.*)");
        testRegionFilter2.allow("org.eclipse.equinox.allow.service", "(objectClass=pkg2.*)");
        testRegionFilter2.allow("CapabilityProvider2", "(name=CapabilityProvider2)");
        Region r2 = null;
        int i = 0;
        while (i <= numLevels) {
            Region r1 = i > 0 ? r2 : testRegion1;
            r2 = i < numLevels ? this.digraph.createRegion(String.valueOf(this.getName()) + "_level_" + i) : testRegion2;
            r1.connectRegion(r2, testRegionFilter1.build());
            r2.connectRegion(r1, testRegionFilter2.build());
            ++i;
        }
        this.bundleInstaller.resolveBundles(bundles.values().toArray(new Bundle[bundles.size()]));
        for (Bundle bundle : bundles.values()) {
            RegionSystemTests.assertEquals((String)("Bundle did not resolve: " + bundle.getSymbolicName()), (int)4, (int)bundle.getState());
            bundle.start();
        }
        BundleContext context = this.getContext();
        ServiceTracker cp2Tracker = new ServiceTracker(context, context.createFilter("(&(objectClass=java.lang.Boolean)(bundle.id=" + ((Bundle)bundles.get("CapabilityProvider2")).getBundleId() + "))"), null);
        ServiceTracker sc1Tracker = new ServiceTracker(context, context.createFilter("(&(objectClass=java.lang.Boolean)(bundle.id=" + ((Bundle)bundles.get("ServiceClient1")).getBundleId() + "))"), null);
        cp2Tracker.open();
        sc1Tracker.open();
        RegionSystemTests.assertNotNull((String)"The cp2 bundle never found the service.", (Object)cp2Tracker.waitForService(2000L));
        RegionSystemTests.assertNotNull((String)"The sc1 bundle never found the service.", (Object)sc1Tracker.waitForService(2000L));
        cp2Tracker.close();
        sc1Tracker.close();
    }

    private ServiceRegistration<ResolverHookFactory> disableAllResolves() {
        return this.getContext().registerService(ResolverHookFactory.class, (Object)new ResolverHookFactory(){

            public ResolverHook begin(Collection<BundleRevision> triggers) {
                return new ResolverHook(){

                    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                    }

                    public void filterResolvable(Collection<BundleRevision> candidates) {
                        candidates.clear();
                    }

                    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                    }

                    public void end() {
                    }
                };
            }
        }, null);
    }

    public void testSingletons() throws BundleException {
        Region region1 = this.digraph.createRegion(String.valueOf(this.getName()) + "_1");
        Region region2 = this.digraph.createRegion(String.valueOf(this.getName()) + "_2");
        Bundle singleton1 = this.bundleInstaller.installBundle("Singleton1", region1);
        Bundle singleton2 = this.bundleInstaller.installBundle("Singleton2", region1);
        RegionSystemTests.assertFalse((boolean)this.bundleInstaller.resolveBundles(new Bundle[]{singleton1, singleton2}));
        RegionSystemTests.assertEquals((String)"singleton1", (int)2, (int)singleton1.getState());
        RegionSystemTests.assertEquals((String)"singleton2", (int)4, (int)singleton2.getState());
        singleton2.uninstall();
        singleton2 = this.bundleInstaller.installBundle("Singleton2", region2);
        RegionSystemTests.assertTrue((boolean)this.bundleInstaller.resolveBundles(new Bundle[]{singleton1, singleton2}));
        RegionSystemTests.assertEquals((String)"singleton1", (int)4, (int)singleton1.getState());
        RegionSystemTests.assertEquals((String)"singleton2", (int)4, (int)singleton2.getState());
        ServiceRegistration<ResolverHookFactory> disableHook = this.disableAllResolves();
        try {
            this.bundleInstaller.refreshPackages(new Bundle[]{singleton1, singleton2});
            region2.connectRegion(region1, this.digraph.createRegionFilterBuilder().allowAll("org.eclipse.equinox.allow.bundle").build());
            disableHook.unregister();
            disableHook = null;
            RegionSystemTests.assertFalse((boolean)this.bundleInstaller.resolveBundles(new Bundle[]{singleton1, singleton2}));
            RegionSystemTests.assertTrue((String)"One and only singleton bundle should be resolved", (boolean)(singleton1.getState() == 4 ^ singleton2.getState() == 4));
            singleton2.uninstall();
            disableHook = this.disableAllResolves();
            this.bundleInstaller.refreshPackages(new Bundle[]{singleton1, singleton2});
            disableHook.unregister();
            disableHook = null;
            RegionSystemTests.assertTrue((boolean)this.bundleInstaller.resolveBundles(new Bundle[]{singleton1}));
            RegionSystemTests.assertEquals((String)"singleton1", (int)4, (int)singleton1.getState());
            singleton2 = this.bundleInstaller.installBundle("Singleton2", region2);
            RegionSystemTests.assertFalse((boolean)this.bundleInstaller.resolveBundles(new Bundle[]{singleton2}));
            RegionSystemTests.assertEquals((String)"singleton2", (int)2, (int)singleton2.getState());
            singleton1.uninstall();
            disableHook = this.disableAllResolves();
            this.bundleInstaller.refreshPackages(new Bundle[]{singleton1, singleton2});
            disableHook.unregister();
            disableHook = null;
            RegionSystemTests.assertTrue((boolean)this.bundleInstaller.resolveBundles(new Bundle[]{singleton2}));
            RegionSystemTests.assertEquals((String)"singleton2", (int)4, (int)singleton2.getState());
            singleton1 = this.bundleInstaller.installBundle("Singleton1", region1);
            RegionSystemTests.assertFalse((boolean)this.bundleInstaller.resolveBundles(new Bundle[]{singleton1}));
            RegionSystemTests.assertEquals((String)"singleton1", (int)2, (int)singleton1.getState());
        }
        finally {
            if (disableHook != null) {
                disableHook.unregister();
            }
        }
    }

    public void testMbeans() throws MalformedObjectNameException, BundleException, InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName digraphName = new ObjectName("org.eclipse.equinox.region.domain:type=RegionDigraph,*");
        ObjectName regionNameAllQuery = new ObjectName("org.eclipse.equinox.region.domain:type=Region,name=*,*");
        Set<ObjectInstance> digraphs = server.queryMBeans(null, digraphName);
        RegionSystemTests.assertEquals((String)"Expected only one instance of digraph", (int)1, (int)digraphs.size());
        Set<ObjectInstance> regions = server.queryMBeans(null, regionNameAllQuery);
        RegionSystemTests.assertEquals((String)"Expected only one instance of region", (int)1, (int)regions.size());
        Region pp1Region = this.digraph.createRegion("PackageProvider1");
        Bundle pp1Bundle = this.bundleInstaller.installBundle("PackageProvider1", pp1Region);
        Region sp1Region = this.digraph.createRegion("ServiceProvider1");
        Bundle sp1Bundle = this.bundleInstaller.installBundle("ServiceProvider1", sp1Region);
        regions = server.queryMBeans(null, regionNameAllQuery);
        RegionSystemTests.assertEquals((String)"Wrong number of regions", (int)3, (int)regions.size());
        Set<ObjectInstance> pp1Query = server.queryMBeans(null, new ObjectName("org.eclipse.equinox.region.domain:type=Region,name=PackageProvider1,*"));
        RegionSystemTests.assertEquals((String)"Expected only one instance of: PackageProvider1", (int)1, (int)pp1Query.size());
        Set<ObjectInstance> sp1Query = server.queryMBeans(null, new ObjectName("org.eclipse.equinox.region.domain:type=Region,name=ServiceProvider1,*"));
        RegionSystemTests.assertEquals((String)"Expected only one instance of: ServiceProvider1", (int)1, (int)sp1Query.size());
        ObjectName pp1Name = (ObjectName)server.invoke(digraphs.iterator().next().getObjectName(), "getRegion", new Object[]{"PackageProvider1"}, new String[]{String.class.getName()});
        RegionSystemTests.assertEquals((String)"PackageProvider1 regions not equal.", (Object)pp1Query.iterator().next().getObjectName(), (Object)pp1Name);
        ObjectName sp1Name = (ObjectName)server.invoke(digraphs.iterator().next().getObjectName(), "getRegion", new Object[]{"ServiceProvider1"}, new String[]{String.class.getName()});
        RegionSystemTests.assertEquals((String)"ServiceProvider1 regions not equal.", (Object)sp1Query.iterator().next().getObjectName(), (Object)sp1Name);
        ObjectName shouldNotExistName = (ObjectName)server.invoke(digraphs.iterator().next().getObjectName(), "getRegion", new Object[]{"ShouldNotExist"}, new String[]{String.class.getName()});
        RegionSystemTests.assertNull((String)"Should not exist", (Object)shouldNotExistName);
        long[] bundleIds = (long[])server.getAttribute(pp1Name, "BundleIds");
        RegionSystemTests.assertEquals((String)"Wrong number of bundles", (int)1, (int)bundleIds.length);
        RegionSystemTests.assertEquals((String)"Wrong bundle", (long)pp1Bundle.getBundleId(), (long)bundleIds[0]);
        String name = (String)server.getAttribute(pp1Name, "Name");
        RegionSystemTests.assertEquals((String)"Wrong name", (String)"PackageProvider1", (String)name);
        bundleIds = (long[])server.getAttribute(sp1Name, "BundleIds");
        RegionSystemTests.assertEquals((String)"Wrong number of bundles", (int)1, (int)bundleIds.length);
        RegionSystemTests.assertEquals((String)"Wrong bundle", (long)sp1Bundle.getBundleId(), (long)bundleIds[0]);
        name = (String)server.getAttribute(sp1Name, "Name");
        RegionSystemTests.assertEquals((String)"Wrong name", (String)"ServiceProvider1", (String)name);
    }

    public void testBundleCollisionDisconnectedRegions() throws BundleException, InvalidSyntaxException {
        Region region;
        Region systemRegion = this.digraph.getRegion(0L);
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        int numRegions = 4;
        String regionName = "IsolatedRegion_";
        int i = 0;
        while (i < numRegions) {
            region = this.digraph.createRegion(String.valueOf(regionName) + i);
            this.digraph.connect(region, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.bundle", "(id=0)").build(), systemRegion);
            this.digraph.connect(systemRegion, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.service", "(objectClass=java.lang.Boolean)").build(), region);
            for (String location : ALL) {
                Bundle b = this.bundleInstaller.installBundle(location, region);
                bundles.add(b);
            }
            ++i;
        }
        RegionSystemTests.assertEquals((String)"Wrong number of bundles installed", (int)(numRegions * ALL.size()), (int)bundles.size());
        RegionSystemTests.assertTrue((String)"Could not resolve bundles.", (boolean)this.bundleInstaller.resolveBundles(bundles.toArray(new Bundle[bundles.size()])));
        i = 0;
        while (i < numRegions) {
            region = this.digraph.getRegion(String.valueOf(regionName) + i);
            for (String name : ALL) {
                String location = this.bundleInstaller.getBundleLocation(name);
                try {
                    Bundle b = region.installBundle(String.valueOf(this.getName()) + "_expectToFail", new URL(location).openStream());
                    b.uninstall();
                    RegionSystemTests.fail((String)("Expected a bundle exception on duplicate bundle installation: " + name));
                }
                catch (BundleException e) {
                    RegionSystemTests.assertEquals((String)"Wrong exception type.", (int)9, (int)e.getType());
                }
                catch (IOException e) {
                    RegionSystemTests.fail((String)("Failed to open bunldle location: " + e.getMessage()));
                }
            }
            ++i;
        }
        i = 0;
        while (i < numRegions) {
            region = this.digraph.getRegion(String.valueOf(regionName) + i);
            Bundle regionPP1 = region.getBundle("PackageProvider1", new Version(1, 0, 0));
            String locationSP1 = this.bundleInstaller.getBundleLocation("ServiceProvider1");
            try {
                regionPP1.update(new URL(locationSP1).openStream());
                RegionSystemTests.fail((String)("Expected a bundle exception on duplicate bundle update: " + region));
            }
            catch (BundleException e) {
                RegionSystemTests.assertEquals((String)"Wrong exception type.", (int)9, (int)e.getType());
            }
            catch (IOException e) {
                RegionSystemTests.fail((String)("Failed to open bunldle location: " + e.getMessage()));
            }
            Bundle regionSP1 = region.getBundle("ServiceProvider1", new Version(1, 0, 0));
            regionSP1.uninstall();
            try {
                regionPP1.update(new URL(locationSP1).openStream());
            }
            catch (IOException e) {
                RegionSystemTests.fail((String)("Failed to open bunldle location: " + e.getMessage()));
            }
            ++i;
        }
    }

    public void testBundleCollisionConnectedRegions() throws BundleException, InvalidSyntaxException {
        Region systemRegion = this.digraph.getRegion(0L);
        int numRegions = 4;
        String regionName = "ConnectedRegion_";
        int i = 0;
        while (i < numRegions) {
            Region region = this.digraph.createRegion(String.valueOf(regionName) + i);
            this.digraph.connect(region, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.bundle", "(id=0)").build(), systemRegion);
            this.digraph.connect(systemRegion, this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.service", "(objectClass=java.lang.Boolean)").build(), region);
            ++i;
        }
        Region region0 = this.digraph.getRegion(String.valueOf(regionName) + 0);
        Region region1 = this.digraph.getRegion(String.valueOf(regionName) + 1);
        Region region2 = this.digraph.getRegion(String.valueOf(regionName) + 2);
        RegionFilterBuilder filterBuilder = this.digraph.createRegionFilterBuilder();
        filterBuilder.allow("org.eclipse.equinox.allow.bundle", "(bundle-symbolic-name=PackageProvider1)");
        filterBuilder.allow("org.eclipse.equinox.allow.bundle", "(bundle-symbolic-name=ServiceProvider1)");
        filterBuilder.allow("org.eclipse.equinox.allow.bundle", "(bundle-symbolic-name=CapabilityProvider1)");
        region1.connectRegion(region0, filterBuilder.build());
        region2.connectRegion(region1, filterBuilder.build());
        this.bundleInstaller.installBundle("PackageProvider1", region0);
        this.bundleInstaller.installBundle("ServiceProvider1", region1);
        this.bundleInstaller.installBundle("CapabilityProvider1", region2);
        this.assertInstallFail("ServiceProvider1", region0);
        this.assertInstallFail("PackageProvider1", region1);
        this.assertInstallFail("PackageProvider1", region2);
        this.assertInstallFail("CapabilityProvider1", region0);
    }

    private void assertInstallFail(String name, Region region) {
        try {
            Bundle b = this.bundleInstaller.installBundle(name, region);
            b.uninstall();
            RegionSystemTests.fail((String)("Expected a bundle exception on duplicate bundle install: " + region));
        }
        catch (BundleException e) {
            RegionSystemTests.assertEquals((String)"Wrong exception type.", (int)9, (int)e.getType());
        }
    }

    public void testDefaultRegion() throws BundleException {
        this.digraph.setDefaultRegion(null);
        Region systemRegion = this.digraph.getRegion(0L);
        Region pp1Region = this.digraph.createRegion("PackageProvider1");
        Bundle pp1Bundle = this.bundleInstaller.installBundle("PackageProvider1", null);
        Region result = this.digraph.getRegion(pp1Bundle);
        RegionSystemTests.assertEquals((String)"Wrong region", (Object)systemRegion, (Object)result);
        pp1Bundle.uninstall();
        this.digraph.setDefaultRegion(pp1Region);
        pp1Bundle = this.bundleInstaller.installBundle("PackageProvider1", null);
        result = this.digraph.getRegion(pp1Bundle);
        RegionSystemTests.assertEquals((String)"Wrong region", (Object)pp1Region, (Object)result);
        this.digraph.setDefaultRegion(null);
    }

    public void testRemoveDefaultRegion() throws BundleException {
        this.digraph.setDefaultRegion(null);
        Region pp1Region = this.digraph.createRegion("PackageProvider1");
        this.digraph.setDefaultRegion(pp1Region);
        this.digraph.removeRegion(pp1Region);
        RegionSystemTests.assertEquals((String)"DefaultRegion is not null", null, (Object)this.digraph.getDefaultRegion());
    }

    public void testSetNotExistingDefaultRegion() throws BundleException {
        Region pp1Region = this.digraph.createRegion("PackageProvider1");
        this.digraph.removeRegion(pp1Region);
        try {
            this.digraph.setDefaultRegion(pp1Region);
            RegionSystemTests.assertFalse((String)"IllegalArgumentException not thrown for setting non-existing region as default", (boolean)true);
        }
        catch (IllegalStateException illegalStateException) {
            RegionSystemTests.assertNull((String)"DefaultRegion is not null", (Object)this.digraph.getDefaultRegion());
        }
    }

    public void testRemoveRegion() throws BundleException {
        Region pp1Region = this.digraph.createRegion("PackageProvider1");
        pp1Region.addBundle(452345245L);
        RegionSystemTests.assertEquals((String)"Region not associated with bundle id", (Object)pp1Region, (Object)this.digraph.getRegion(452345245L));
        this.digraph.removeRegion(pp1Region);
        RegionSystemTests.assertNull((String)"Region still associated with bundle id", (Object)this.digraph.getRegion(452345245L));
        try {
            pp1Region.addBundle(452345245L);
            RegionSystemTests.fail((String)"Added a bundle to a region which was not part of a digraph");
        }
        catch (IllegalStateException illegalStateException) {}
        RegionSystemTests.assertNull((String)"Region now associated with bundle id", (Object)this.digraph.getRegion(452345245L));
        Region pp2Region = this.digraph.createRegion("PackageProvider2");
        pp2Region.addBundle(452345245L);
        try {
            pp1Region.removeBundle(452345245L);
            RegionSystemTests.fail((String)"Removed a bundle via a region which was not part of a digraph");
        }
        catch (IllegalStateException illegalStateException) {}
        RegionSystemTests.assertEquals((String)"Wrong region found for the bundle id", (Object)pp2Region, (Object)this.digraph.getRegion(452345245L));
    }

    public void testInstallAtLocation() throws BundleException, MalformedURLException, IOException {
        Region r1 = this.digraph.createRegion(String.valueOf(this.getName()) + ".1");
        Region r2 = this.digraph.createRegion(String.valueOf(this.getName()) + ".2");
        String location = this.bundleInstaller.getBundleLocation("PackageProvider1");
        Bundle b1 = null;
        Bundle b2 = null;
        String l1 = null;
        String l2 = null;
        try {
            URL url = new URL(location);
            b1 = r1.installBundle(String.valueOf(location) + ".1", url.openStream());
            l1 = b1.getLocation();
            b2 = r2.installBundleAtLocation(String.valueOf(location) + ".2", url.openStream());
            l2 = b2.getLocation();
        }
        catch (Throwable throwable) {
            if (b1 != null) {
                try {
                    b1.uninstall();
                }
                catch (BundleException bundleException) {}
            }
            if (b2 != null) {
                try {
                    b2.uninstall();
                }
                catch (BundleException bundleException) {}
            }
            throw throwable;
        }
        if (b1 != null) {
            try {
                b1.uninstall();
            }
            catch (BundleException bundleException) {}
        }
        if (b2 != null) {
            try {
                b2.uninstall();
            }
            catch (BundleException bundleException) {}
        }
        RegionSystemTests.assertEquals((String)"Wrong location found.", (String)(String.valueOf(location) + ".1#" + r1.getName()), (String)l1);
        RegionSystemTests.assertEquals((String)"Wrong location found.", (String)(String.valueOf(location) + ".2"), (String)l2);
    }

    public void testInvalidRegionName() {
        ArrayList<String> invalidNames = new ArrayList<String>();
        invalidNames.addAll(Arrays.asList(":", "bad:Name", ":bad::name:", ":badname", "badname:"));
        invalidNames.addAll(Arrays.asList("=", "bad=Name", "=bad==name=", "=badname", "badname="));
        invalidNames.addAll(Arrays.asList("\n", "bad\nName", "\nbad\n\nname\n", "\nbadname", "badname\n"));
        invalidNames.addAll(Arrays.asList("*", "bad*Name", "*bad**name*", "*badname", "badname*"));
        invalidNames.addAll(Arrays.asList("?", "bad?Name", "?bad??name?", "?badname", "badname?"));
        invalidNames.addAll(Arrays.asList(",", "bad,Name", ",bad,,name,", ",badname", "badname,"));
        invalidNames.addAll(Arrays.asList("\"", "bad\"Name", "\"bad\"\"name\"", "\"badname", "badname\""));
        invalidNames.addAll(Arrays.asList("\\", "bad\\Name", "\\bad\\\\name\\", "\\badname", "badname\\"));
        for (String invalidName : invalidNames) {
            try {
                this.digraph.createRegion(invalidName);
                RegionSystemTests.fail((String)"Expected failure to create region.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (BundleException e) {
                RegionSystemTests.fail((String)("Unexpected bundle exception: " + e.getMessage()));
            }
        }
    }
}

