/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.equinox.security.storage.EncodingUtils;

public class Base64Test
extends TestCase {
    private static final int RANDOM_ITERATIONS = 1000;
    private static final String decoded1 = "sample^^*";
    private static final String encoded1 = "c2FtcGxlXl4q";
    private static final String decoded2 = "lazy frog jumped over sleeping dog";
    private static final String encoded2 = "bGF6eSBmcm9nIGp1bXBlZCBvdmVyIHNsZWVwaW5nIGRvZw==";
    private static final byte[] decoded3;
    private static final String encoded3 = "BQAADCABf/8=";
    private static final byte[] decoded4;
    private static final String encoded4 = "";
    private static final String decoded5 = "1.234";
    private static final String encoded5 = "M\u0005S4y\tM\n\rzQ=\r\n";
    private static final String decoded6 = "a";
    private static final String encoded6 = "YQ==";
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[8];
        byArray[0] = 5;
        byArray[3] = 12;
        byArray[4] = 32;
        byArray[5] = 1;
        byArray[6] = 127;
        byArray[7] = -1;
        decoded3 = byArray;
        decoded4 = new byte[0];
    }

    public Base64Test() {
    }

    public Base64Test(String name) {
        super(name);
    }

    public void testHandCoded() {
        String encoded = EncodingUtils.encodeBase64((byte[])decoded1.getBytes());
        Base64Test.assertEquals((String)encoded1, (String)encoded);
        byte[] bytes = EncodingUtils.decodeBase64((String)encoded2);
        String decoded = new String(bytes);
        Base64Test.assertEquals((String)decoded2, (String)decoded);
        String testZeroes = EncodingUtils.encodeBase64((byte[])decoded3);
        Base64Test.assertEquals((String)encoded3, (String)testZeroes);
        byte[] roundtripBytes = EncodingUtils.decodeBase64((String)testZeroes);
        this.compareArrays(decoded3, roundtripBytes);
        byte[] bytesInvalidChars = EncodingUtils.decodeBase64((String)encoded5);
        String decodedInvalidChars = new String(bytesInvalidChars);
        Base64Test.assertEquals((String)decoded5, (String)decodedInvalidChars);
        String shortSample = EncodingUtils.encodeBase64((byte[])decoded6.getBytes());
        Base64Test.assertEquals((String)encoded6, (String)shortSample);
        Base64Test.assertEquals((String)decoded6, (String)new String(EncodingUtils.decodeBase64((String)shortSample)));
    }

    public void testEdge() {
        Base64Test.assertNull((Object)EncodingUtils.encodeBase64(null));
        Base64Test.assertNull((Object)EncodingUtils.decodeBase64(null));
        String encoded = EncodingUtils.encodeBase64((byte[])decoded4);
        Base64Test.assertNotNull((Object)encoded);
        Base64Test.assertEquals((String)encoded4, (String)encoded);
        byte[] decoded = EncodingUtils.decodeBase64((String)encoded);
        this.compareArrays(decoded4, decoded);
    }

    public void testRandom() {
        Random generator = new Random(System.currentTimeMillis());
        int i = 0;
        while (i < 1000) {
            int length = 100 + generator.nextInt(900);
            byte[] bytes = new byte[length];
            generator.nextBytes(bytes);
            String encoded = EncodingUtils.encodeBase64((byte[])bytes);
            byte[] decoded = EncodingUtils.decodeBase64((String)encoded);
            this.compareArrays(bytes, decoded);
            ++i;
        }
    }

    private void compareArrays(byte[] array1, byte[] array2) {
        Base64Test.assertNotNull((Object)array1);
        Base64Test.assertNotNull((Object)array2);
        Base64Test.assertEquals((int)array1.length, (int)array2.length);
        int i = 0;
        while (i < array1.length) {
            Base64Test.assertEquals((byte)array1[i], (byte)array2[i]);
            ++i;
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.security.tests.storage.Base64Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }
}

