/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class ManualTest
extends TestCase {
    private static final String JAVA_MODULE_ID = "org.eclipse.equinox.security.javaCrypt";
    private final String passwordSample = "uYTIU689_~@@/";
    private final String loginSample = "cheburashka";
    static /* synthetic */ Class class$0;

    public ManualTest() {
    }

    public ManualTest(String name) {
        super(name);
    }

    public void testBasic() {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Iterator<Map.Entry<Object, Object>> j = providers[i].entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry<Object, Object> entry = j.next();
                String key = (String)entry.getKey();
                if (key == null || key.indexOf(32) != -1) continue;
                if (key.startsWith("Cipher.")) {
                    String cipher = key.substring(7);
                    System.out.println("[cypher] " + cipher);
                }
                if (!key.startsWith("SecretKeyFactory.")) continue;
                String keyFactory = key.substring(17);
                System.out.println("[keyFactory] " + keyFactory);
            }
            ++i;
        }
    }

    public void testJavaModule() throws IOException, StorageException {
        HashMap<String, String> options = new HashMap<String, String>(1);
        options.put("org.eclipse.equinox.security.storage.requiredID", JAVA_MODULE_ID);
        ISecurePreferences storage = SecurePreferencesFactory.open(null, options);
        ISecurePreferences node = storage.node("/cvs/account1");
        node.put("login", "cheburashka", true);
        node.put("password", "uYTIU689_~@@/", true);
        ManualTest.assertEquals((String)"cheburashka", (String)node.get("login", null));
        ManualTest.assertEquals((String)"uYTIU689_~@@/", (String)node.get("password", null));
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.security.tests.storage.ManualTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }
}

