/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.tests.SecurityTestsActivator;
import org.eclipse.equinox.internal.security.tests.storage.StorageAbstractTest;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.framework.BundleContext;

public abstract class SecurePreferencesTest
extends StorageAbstractTest {
    private static final String sampleLocation = "/SecurePrefsSample/1/secure_storage.equinox";
    private static final String path1 = "/test/abc";
    private static final String path2 = "/test/cvs/eclipse.org";
    private static final String path3 = "/test/cvs/eclipse.org/account1";
    private static final String key = "password";
    private static final String unassignedKey = "unknown";
    private static final String value = "p[[pkknb#";
    private static final String defaultValue = "default";
    private static final String secondKey = "/   sdfdsf / sf";
    private static final String secondValue = "one";
    private static final String clearTextKey = "data";
    private static final String clearTextValue = "-> this should not be encrypted <-";
    private static final String unicodeKey = "unicodeKey";
    private static final String unicodeValue = "va\u0432lue\u0433";
    static /* synthetic */ Class class$0;

    public SecurePreferencesTest() {
    }

    public SecurePreferencesTest(String name) {
        super(name);
    }

    protected Map getOptions() {
        return this.getOptions("password1");
    }

    private void fill(ISecurePreferences preferences) throws StorageException {
        preferences.put(key, value, true);
        ISecurePreferences node1 = preferences.node(path1);
        node1.put(key, value, true);
        node1.put(clearTextKey, clearTextValue, false);
        ISecurePreferences node2 = preferences.node(path2);
        node2.put(key, value, true);
        node2.put(secondKey, secondValue, true);
        ISecurePreferences node3 = preferences.node(path3);
        node3.put(key, value, true);
        node3.put(secondKey, secondValue, true);
        node3.put(clearTextKey, clearTextValue, false);
        node3.put(unicodeKey, unicodeValue, true);
        node2.remove(secondKey);
        SecurePreferencesTest.assertTrue((boolean)this.isModified(node2));
        SecurePreferencesTest.assertTrue((boolean)this.isModified(preferences));
    }

    private boolean isModified(ISecurePreferences node) {
        return InternalExchangeUtils.isModified((ISecurePreferences)node);
    }

    private void check(ISecurePreferences preferences) throws StorageException {
        SecurePreferencesTest.assertFalse((boolean)this.isModified(preferences));
        SecurePreferencesTest.assertEquals((String)value, (String)preferences.get(key, defaultValue));
        SecurePreferencesTest.assertEquals((String)defaultValue, (String)preferences.get(unassignedKey, defaultValue));
        ISecurePreferences node1 = preferences.node(path1);
        SecurePreferencesTest.assertFalse((boolean)this.isModified(node1));
        SecurePreferencesTest.assertEquals((String)value, (String)node1.get(key, defaultValue));
        SecurePreferencesTest.assertEquals((String)defaultValue, (String)node1.get(unassignedKey, defaultValue));
        SecurePreferencesTest.assertEquals((String)clearTextValue, (String)node1.get(clearTextKey, defaultValue));
        ISecurePreferences node2 = preferences.node(path2);
        SecurePreferencesTest.assertFalse((boolean)this.isModified(node2));
        SecurePreferencesTest.assertEquals((String)value, (String)node2.get(key, defaultValue));
        SecurePreferencesTest.assertNull((Object)node2.get(secondKey, null));
        SecurePreferencesTest.assertEquals((String)defaultValue, (String)node2.get(unassignedKey, defaultValue));
        ISecurePreferences node3 = preferences.node(path3);
        SecurePreferencesTest.assertFalse((boolean)this.isModified(node3));
        SecurePreferencesTest.assertEquals((String)value, (String)node3.get(key, defaultValue));
        SecurePreferencesTest.assertEquals((String)secondValue, (String)node3.get(secondKey, defaultValue));
        SecurePreferencesTest.assertEquals((String)defaultValue, (String)node3.get(unassignedKey, defaultValue));
        SecurePreferencesTest.assertEquals((String)clearTextValue, (String)node3.get(clearTextKey, defaultValue));
        SecurePreferencesTest.assertEquals((String)unicodeValue, (String)node3.get(unicodeKey, defaultValue));
        String[] leafKeys = node3.keys();
        SecurePreferencesTest.assertNotNull((Object)leafKeys);
        SecurePreferencesTest.assertEquals((int)leafKeys.length, (int)4);
        this.findAll(new String[]{clearTextKey, key, secondKey, unicodeKey}, leafKeys);
    }

    public void testPreferences() throws IOException, StorageException {
        URL location = this.getStorageLocation();
        SecurePreferencesTest.assertNotNull((Object)location);
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        this.fill(preferences);
        preferences.flush();
        this.closePreferences(preferences);
        preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        this.check(preferences);
    }

    public void testNames() throws IOException, StorageException {
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        this.fill(preferences);
        SecurePreferencesTest.assertNull((Object)preferences.name());
        SecurePreferencesTest.assertEquals((String)"/", (String)preferences.absolutePath());
        String[] childrenNames = preferences.node("test").childrenNames();
        SecurePreferencesTest.assertNotNull((Object)childrenNames);
        boolean order1 = "abc".equals(childrenNames[0]) && "cvs".equals(childrenNames[1]);
        boolean order2 = "abc".equals(childrenNames[1]) && "cvs".equals(childrenNames[0]);
        SecurePreferencesTest.assertTrue((order1 || order2 ? 1 : 0) != 0);
        SecurePreferencesTest.assertEquals((int)childrenNames.length, (int)2);
        ISecurePreferences node1 = preferences.node("test/cvs");
        SecurePreferencesTest.assertEquals((String)"cvs", (String)node1.name());
        SecurePreferencesTest.assertEquals((String)"/test/cvs", (String)node1.absolutePath());
        String[] childrenNames1 = node1.childrenNames();
        SecurePreferencesTest.assertNotNull((Object)childrenNames1);
        SecurePreferencesTest.assertEquals((int)childrenNames1.length, (int)1);
        SecurePreferencesTest.assertEquals((String)"eclipse.org", (String)childrenNames1[0]);
        ISecurePreferences node2 = node1.node("eclipse.org");
        SecurePreferencesTest.assertEquals((String)"eclipse.org", (String)node2.name());
        SecurePreferencesTest.assertEquals((String)path2, (String)node2.absolutePath());
        String[] childrenNames2 = node2.childrenNames();
        SecurePreferencesTest.assertNotNull((Object)childrenNames2);
        SecurePreferencesTest.assertEquals((int)childrenNames2.length, (int)1);
        SecurePreferencesTest.assertEquals((String)"account1", (String)childrenNames2[0]);
        ISecurePreferences node3 = node2.node("account1");
        SecurePreferencesTest.assertEquals((String)"account1", (String)node3.name());
        SecurePreferencesTest.assertEquals((String)path3, (String)node3.absolutePath());
        String[] childrenNames3 = node3.childrenNames();
        SecurePreferencesTest.assertNotNull((Object)childrenNames3);
        SecurePreferencesTest.assertEquals((int)childrenNames3.length, (int)0);
    }

    public void testNodeResolution() throws IOException, StorageException {
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        this.fill(preferences);
        SecurePreferencesTest.assertTrue((boolean)preferences.nodeExists(null));
        ISecurePreferences nodeRoot = preferences.node(null);
        SecurePreferencesTest.assertNotNull((Object)nodeRoot);
        SecurePreferencesTest.assertTrue((boolean)preferences.nodeExists("/test/cvs"));
        SecurePreferencesTest.assertFalse((boolean)preferences.nodeExists("/test/nonExistent"));
        ISecurePreferences node1 = preferences.node("/test/cvs");
        SecurePreferencesTest.assertNotNull((Object)node1);
        SecurePreferencesTest.assertTrue((boolean)preferences.nodeExists(path2));
        SecurePreferencesTest.assertFalse((boolean)preferences.nodeExists("/test/nonExistent/cvs"));
        SecurePreferencesTest.assertFalse((boolean)preferences.nodeExists("/test/cvs/nonExistent"));
        ISecurePreferences node2 = preferences.node(path2);
        SecurePreferencesTest.assertNotNull((Object)node2);
        SecurePreferencesTest.assertTrue((boolean)preferences.nodeExists(path3));
        SecurePreferencesTest.assertFalse((boolean)preferences.nodeExists("/test/cvs/nonExistent/cvs"));
        ISecurePreferences node3 = preferences.node(path3);
        SecurePreferencesTest.assertNotNull((Object)node3);
        SecurePreferencesTest.assertNull((Object)preferences.parent());
        SecurePreferencesTest.assertEquals((Object)nodeRoot, (Object)preferences);
        SecurePreferencesTest.assertTrue((boolean)nodeRoot.nodeExists("test/cvs"));
        SecurePreferencesTest.assertFalse((boolean)nodeRoot.nodeExists("test/nonExistent"));
        ISecurePreferences relativeNode1 = nodeRoot.node("test/cvs");
        SecurePreferencesTest.assertNotNull((Object)relativeNode1);
        SecurePreferencesTest.assertEquals((Object)node1, (Object)relativeNode1);
        SecurePreferencesTest.assertEquals((Object)nodeRoot, (Object)relativeNode1.parent().parent());
        SecurePreferencesTest.assertTrue((boolean)relativeNode1.nodeExists("eclipse.org"));
        SecurePreferencesTest.assertFalse((boolean)relativeNode1.nodeExists("nonExistent"));
        ISecurePreferences relativeNode2 = relativeNode1.node("eclipse.org");
        SecurePreferencesTest.assertNotNull((Object)relativeNode2);
        SecurePreferencesTest.assertEquals((Object)node2, (Object)relativeNode2);
        SecurePreferencesTest.assertEquals((Object)node1, (Object)relativeNode2.parent());
        SecurePreferencesTest.assertTrue((boolean)relativeNode2.nodeExists("account1"));
        SecurePreferencesTest.assertFalse((boolean)relativeNode2.nodeExists("nonExistent"));
        ISecurePreferences relativeNode3 = relativeNode2.node("account1");
        SecurePreferencesTest.assertNotNull((Object)relativeNode3);
        SecurePreferencesTest.assertEquals((Object)node3, (Object)relativeNode3);
        SecurePreferencesTest.assertEquals((Object)relativeNode2, (Object)relativeNode3.parent());
        preferences.flush();
        this.check(preferences);
    }

    public void testNodeRemoval() throws IOException, StorageException {
        URL location = this.getStorageLocation();
        SecurePreferencesTest.assertNotNull((Object)location);
        ISecurePreferences preferences = this.newPreferences(location, this.getOptions());
        this.fill(preferences);
        ISecurePreferences nodeToRemove = preferences.node(path2);
        SecurePreferencesTest.assertNotNull((Object)nodeToRemove);
        nodeToRemove.removeNode();
        SecurePreferencesTest.assertFalse((boolean)preferences.nodeExists(path3));
        SecurePreferencesTest.assertFalse((boolean)preferences.nodeExists(path2));
        preferences.flush();
        this.closePreferences(preferences);
        preferences = this.newPreferences(location, this.getOptions());
        SecurePreferencesTest.assertTrue((boolean)preferences.nodeExists(null));
        SecurePreferencesTest.assertFalse((boolean)preferences.nodeExists(path3));
        SecurePreferencesTest.assertFalse((boolean)preferences.nodeExists(path2));
        ISecurePreferences node = preferences.node("/test/cvs");
        String[] children = node.childrenNames();
        SecurePreferencesTest.assertNotNull((Object)children);
        SecurePreferencesTest.assertEquals((int)children.length, (int)0);
        ISecurePreferences node2 = preferences.node(null).node("test");
        String[] children2 = node2.childrenNames();
        SecurePreferencesTest.assertNotNull((Object)children2);
        SecurePreferencesTest.assertEquals((int)children2.length, (int)2);
        ISecurePreferences nodeToRemove2 = node2.node("/test/cvs");
        SecurePreferencesTest.assertNotNull((Object)nodeToRemove2);
        nodeToRemove2.removeNode();
        String[] children3 = node2.childrenNames();
        SecurePreferencesTest.assertNotNull((Object)children3);
        SecurePreferencesTest.assertEquals((int)children3.length, (int)1);
        SecurePreferencesTest.assertEquals((String)"abc", (String)children3[0]);
        preferences.removeNode();
        boolean exception = false;
        try {
            preferences.nodeExists(null);
        }
        catch (IllegalStateException illegalStateException) {
            exception = true;
        }
        SecurePreferencesTest.assertTrue((boolean)exception);
    }

    public void testPathValidation() throws Throwable {
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        boolean exception = false;
        try {
            preferences.node("/test/cvs/eclipse.org//account1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        SecurePreferencesTest.assertTrue((boolean)exception);
        exception = false;
        try {
            preferences.node("/test/cvs/eclipse.org/");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        SecurePreferencesTest.assertTrue((boolean)exception);
        exception = false;
        try {
            preferences.node("/test/cvs/eclipse.org//");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        SecurePreferencesTest.assertTrue((boolean)exception);
    }

    public void testLocation() throws MalformedURLException {
        URL invalidURL = new URL("http", "eclipse.org", "testEquinoxFile");
        boolean exception = false;
        try {
            this.newPreferences(invalidURL, this.getOptions());
        }
        catch (IOException iOException) {
            exception = true;
        }
        SecurePreferencesTest.assertTrue((boolean)exception);
    }

    public void testDataTypes() throws StorageException, MalformedURLException, IOException {
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        ISecurePreferences node = preferences.node("/test");
        byte[] byArray = new byte[8];
        byArray[1] = 4;
        byArray[2] = 12;
        byArray[3] = 75;
        byArray[4] = 84;
        byArray[5] = 12;
        byArray[6] = 1;
        byArray[7] = -1;
        byte[] testArray = byArray;
        boolean encrypt = true;
        node.putBoolean("trueBoolean", true, encrypt);
        node.putBoolean("falseBoolean", false, encrypt);
        node.putInt("oneInteger", 1, encrypt);
        node.putLong("twoLong", 2L, encrypt);
        node.putFloat("threeFloat", 3.12f, encrypt);
        node.putDouble("fourDouble", 4.1, encrypt);
        SecurePreferencesTest.assertTrue((boolean)node.getBoolean("trueBoolean", false));
        SecurePreferencesTest.assertFalse((boolean)node.getBoolean("falseBoolean", true));
        SecurePreferencesTest.assertTrue((boolean)node.getBoolean("unknownBoolean", true));
        SecurePreferencesTest.assertFalse((boolean)node.getBoolean("unknownBoolean", false));
        SecurePreferencesTest.assertEquals((int)node.getInt("oneInteger", 0), (int)1);
        SecurePreferencesTest.assertEquals((int)node.getInt("unknownInteger", 5), (int)5);
        SecurePreferencesTest.assertEquals((long)node.getLong("twoLong", 0L), (long)2L);
        SecurePreferencesTest.assertEquals((long)node.getLong("unknownLong", 5L), (long)5L);
        SecurePreferencesTest.assertEquals((float)node.getFloat("threeFloat", 0.0f), (float)3.12f, (float)0.0f);
        SecurePreferencesTest.assertEquals((float)node.getFloat("unknownFloat", 1.23f), (float)1.23f, (float)0.0f);
        SecurePreferencesTest.assertEquals((double)node.getDouble("fourDouble", 0.0), (double)4.1, (double)0.0);
        SecurePreferencesTest.assertEquals((double)node.getDouble("unknownDouble", 1.23), (double)1.23, (double)0.0);
        node.putByteArray("fiveArray", testArray, encrypt);
        byte[] array = node.getByteArray("fiveArray", null);
        this.compareArrays(testArray, array);
    }

    public void testIncorrectData() throws IOException {
        URL location = this.getFilePath(sampleLocation);
        ISecurePreferences preferences = this.newPreferences(location, this.getOptions("password1"));
        try {
            ISecurePreferences node = preferences.node("/abc");
            boolean exception = false;
            try {
                node.get("password1", defaultValue);
            }
            catch (StorageException e) {
                SecurePreferencesTest.assertEquals((int)3, (int)e.getErrorCode());
                exception = true;
            }
            SecurePreferencesTest.assertTrue((boolean)exception);
            exception = false;
            try {
                node.get("password2", defaultValue);
            }
            catch (StorageException e) {
                SecurePreferencesTest.assertEquals((int)3, (int)e.getErrorCode());
                exception = true;
            }
            SecurePreferencesTest.assertTrue((boolean)exception);
        }
        finally {
            this.closePreferences(preferences);
        }
    }

    public void testIncorrectPassword() throws IOException {
        URL location = this.getFilePath(sampleLocation);
        Map options = this.getOptions("wrong");
        ISecurePreferences preferences = this.newPreferences(location, options);
        try {
            ISecurePreferences node = preferences.node("/cvs/eclipse.org");
            boolean exception = false;
            try {
                node.get(key, defaultValue);
            }
            catch (StorageException e) {
                SecurePreferencesTest.assertEquals((int)3, (int)e.getErrorCode());
                exception = true;
            }
            SecurePreferencesTest.assertTrue((boolean)exception);
        }
        finally {
            this.closePreferences(preferences);
        }
    }

    public void testModules() throws IOException {
        URL location = this.getFilePath(sampleLocation);
        ISecurePreferences preferences = this.newPreferences(location, this.getOptions(null));
        try {
            ISecurePreferences node = preferences.node("/cvs/eclipse.org/account1");
            boolean exception = false;
            try {
                node.get("password1", defaultValue);
            }
            catch (StorageException e) {
                SecurePreferencesTest.assertEquals((int)1, (int)e.getErrorCode());
                exception = true;
            }
            SecurePreferencesTest.assertTrue((boolean)exception);
            exception = false;
            try {
                node.get("password2", defaultValue);
            }
            catch (StorageException e) {
                SecurePreferencesTest.assertEquals((int)3, (int)e.getErrorCode());
                exception = true;
            }
            SecurePreferencesTest.assertTrue((boolean)exception);
        }
        finally {
            this.closePreferences(preferences);
        }
    }

    public void testEdgeCases() throws StorageException, MalformedURLException, IOException {
        byte[] expectedEmptyArray = new byte[]{};
        byte[] wrongArray = new byte[]{1, 2, 3};
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        ISecurePreferences node = preferences.node("/testEdge");
        node.put("emptyString1", "", true);
        node.put("emptyString2", "", false);
        node.put("nullString1", null, true);
        node.put("nullString2", null, false);
        node.putByteArray("emptyArray1", new byte[0], true);
        node.putByteArray("emptyArray2", new byte[0], false);
        node.putByteArray("nullArray1", null, true);
        node.putByteArray("nullArray2", null, false);
        SecurePreferencesTest.assertEquals((String)"", (String)node.get("emptyString1", "wrong"));
        SecurePreferencesTest.assertEquals((String)"", (String)node.get("emptyString2", "wrong"));
        SecurePreferencesTest.assertNull((Object)node.get("nullString1", "wrong"));
        SecurePreferencesTest.assertNull((Object)node.get("nullString2", "wrong"));
        this.compareArrays(expectedEmptyArray, node.getByteArray("emptyArray1", wrongArray));
        this.compareArrays(expectedEmptyArray, node.getByteArray("emptyArray2", wrongArray));
        SecurePreferencesTest.assertNull((Object)node.getByteArray("nullString1", wrongArray));
        SecurePreferencesTest.assertNull((Object)node.getByteArray("nullString2", wrongArray));
        preferences.flush();
        this.closePreferences(preferences);
        preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        node = preferences.node("/testEdge");
        SecurePreferencesTest.assertEquals((String)"", (String)node.get("emptyString1", "wrong"));
        SecurePreferencesTest.assertEquals((String)"", (String)node.get("emptyString2", "wrong"));
        SecurePreferencesTest.assertNull((Object)node.get("nullString1", "wrong"));
        SecurePreferencesTest.assertNull((Object)node.get("nullString2", "wrong"));
        this.compareArrays(expectedEmptyArray, node.getByteArray("emptyArray1", wrongArray));
        this.compareArrays(expectedEmptyArray, node.getByteArray("emptyArray2", wrongArray));
        SecurePreferencesTest.assertNull((Object)node.getByteArray("nullString1", wrongArray));
        SecurePreferencesTest.assertNull((Object)node.getByteArray("nullString2", wrongArray));
    }

    private void findAll(String[] array1, String[] array2) {
        SecurePreferencesTest.assertNotNull((Object)array1);
        SecurePreferencesTest.assertNotNull((Object)array2);
        SecurePreferencesTest.assertEquals((int)array1.length, (int)array2.length);
        int i = 0;
        while (i < array1.length) {
            boolean found = false;
            int j = 0;
            while (j < array2.length) {
                if (array1[i].equals(array2[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            SecurePreferencesTest.assertTrue((boolean)found);
            ++i;
        }
    }

    private void compareArrays(byte[] array1, byte[] array2) {
        SecurePreferencesTest.assertNotNull((Object)array1);
        SecurePreferencesTest.assertNotNull((Object)array2);
        SecurePreferencesTest.assertEquals((int)array1.length, (int)array2.length);
        int i = 0;
        while (i < array1.length) {
            SecurePreferencesTest.assertEquals((byte)array1[i], (byte)array2[i]);
            ++i;
        }
    }

    private URL getFilePath(String path) throws IOException {
        BundleContext bundleContext = SecurityTestsActivator.getDefault().getBundleContext();
        URL url = bundleContext.getBundle().getEntry(path);
        return FileLocator.toFileURL((URL)url);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.security.tests.storage.SecurePreferencesTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }
}

