/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.equinox.internal.security.storage.StorageUtils;
import org.eclipse.equinox.internal.security.tests.storage.StorageAbstractTest;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;

public class SlashEncodeTest
extends StorageAbstractTest {
    private static final String[] decodedSlash = new String[]{"root", "ro/ot", "/root", "root/", "ro/ot/me", "ro//ot"};
    private static final String[] encodedSlash = new String[]{"root", "ro\\2fot", "\\2froot", "root\\2f", "ro\\2fot\\2fme", "ro\\2f\\2fot"};
    private static final String[] decodedBackSlash = new String[]{"ro\\ot", "\\root", "root\\", "ro\\ot\\me", "ro\\\\ot"};
    private static final String[] encodedBackSlash = new String[]{"ro\\5cot", "\\5croot", "root\\5c", "ro\\5cot\\5cme", "ro\\5c\\5cot"};
    private static final String[] decodedMixSlash = new String[]{"r/o\\ot", "r\\o/ot", "/\\root", "root\\/", "\\5cro\\2f ot"};
    private static final String[] encodedMixSlash = new String[]{"r\\2fo\\5cot", "r\\5co\\2fot", "\\2f\\5croot", "root\\5c\\2f", "\\5c5cro\\5c2f ot"};
    static /* synthetic */ Class class$0;

    public SlashEncodeTest() {
    }

    public SlashEncodeTest(String name) {
        super(name);
    }

    public void testForwardSlash() {
        int i = 0;
        while (i < decodedSlash.length) {
            String tmp = EncodingUtils.encodeSlashes((String)decodedSlash[i]);
            SlashEncodeTest.assertEquals((String)encodedSlash[i], (String)tmp);
            SlashEncodeTest.assertEquals((String)decodedSlash[i], (String)EncodingUtils.decodeSlashes((String)tmp));
            ++i;
        }
    }

    public void testBackwardSlash() {
        int i = 0;
        while (i < decodedBackSlash.length) {
            String tmp = EncodingUtils.encodeSlashes((String)decodedBackSlash[i]);
            SlashEncodeTest.assertEquals((String)encodedBackSlash[i], (String)tmp);
            SlashEncodeTest.assertEquals((String)decodedBackSlash[i], (String)EncodingUtils.decodeSlashes((String)tmp));
            ++i;
        }
    }

    public void testMixSlash() {
        int i = 0;
        while (i < decodedMixSlash.length) {
            String tmp = EncodingUtils.encodeSlashes((String)decodedMixSlash[i]);
            SlashEncodeTest.assertEquals((String)encodedMixSlash[i], (String)tmp);
            SlashEncodeTest.assertEquals((String)decodedMixSlash[i], (String)EncodingUtils.decodeSlashes((String)tmp));
            ++i;
        }
    }

    public void testEdge() {
        SlashEncodeTest.assertNull((Object)EncodingUtils.encodeSlashes(null));
        SlashEncodeTest.assertNull((Object)EncodingUtils.decodeSlashes(null));
        String encoded = EncodingUtils.encodeSlashes((String)"");
        SlashEncodeTest.assertNotNull((Object)encoded);
        SlashEncodeTest.assertEquals((String)"", (String)encoded);
    }

    protected Map getOptions() {
        return this.getOptions("password1");
    }

    public void testPreferencesWithSlashes() throws IOException, StorageException {
        URL location = this.getStorageLocation();
        SlashEncodeTest.assertNotNull((Object)location);
        ISecurePreferences preferences = this.newPreferences(location, this.getOptions());
        String safePath = EncodingUtils.encodeSlashes((String)"ro/ot");
        ISecurePreferences node = preferences.node(safePath);
        node.put("password", "test", true);
        SlashEncodeTest.assertFalse((boolean)preferences.nodeExists("ro"));
        SlashEncodeTest.assertFalse((boolean)preferences.nodeExists("ro/ot"));
        SlashEncodeTest.assertTrue((boolean)preferences.nodeExists(safePath));
        preferences.flush();
        this.closePreferences(preferences);
        preferences = this.newPreferences(location, this.getOptions());
        String[] children = preferences.childrenNames();
        SlashEncodeTest.assertNotNull((Object)children);
        SlashEncodeTest.assertEquals((int)children.length, (int)1);
        ISecurePreferences nodeRet = preferences.node(children[0]);
        String absolutePath = EncodingUtils.decodeSlashes((String)nodeRet.absolutePath());
        SlashEncodeTest.assertEquals((String)"/ro/ot", (String)absolutePath);
        SlashEncodeTest.assertEquals((String)"test", (String)nodeRet.get("password", null));
        StorageUtils.delete((URL)location);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.security.tests.storage.SlashEncodeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }
}

