/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.spec.PBEKeySpec;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesMapper;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesRoot;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesWrapper;
import org.eclipse.equinox.internal.security.storage.StorageUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;

public class StorageAbstractTest
extends TestCase {
    protected final String defaultFileName = "secure_storage_test.equinox";
    private List openPreferences = new ArrayList(5);

    public StorageAbstractTest() {
    }

    public StorageAbstractTest(String name) {
        super(name);
    }

    protected String getModuleID() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        List list = this.openPreferences;
        synchronized (list) {
            Iterator i = this.openPreferences.iterator();
            while (i.hasNext()) {
                ISecurePreferences root = (ISecurePreferences)i.next();
                SecurePreferencesMapper.close((SecurePreferencesRoot)((SecurePreferencesWrapper)root).getContainer().getRootData());
                URL location = ((SecurePreferencesWrapper)root).getContainer().getLocation();
                StorageUtils.delete((URL)location);
            }
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISecurePreferences newPreferences(URL location, Map options) throws IOException {
        List list = this.openPreferences;
        synchronized (list) {
            ISecurePreferences result = SecurePreferencesFactory.open((URL)location, (Map)options);
            this.openPreferences.add(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePreferences(ISecurePreferences root) {
        List list = this.openPreferences;
        synchronized (list) {
            Iterator i = this.openPreferences.iterator();
            while (i.hasNext()) {
                ISecurePreferences element = (ISecurePreferences)i.next();
                if (!element.equals(root)) continue;
                SecurePreferencesMapper.close((SecurePreferencesRoot)((SecurePreferencesWrapper)root).getContainer().getRootData());
                i.remove();
            }
        }
    }

    protected Map getOptions(String defaultPassword) {
        String requiredID;
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (defaultPassword != null) {
            PBEKeySpec password = new PBEKeySpec(defaultPassword.toCharArray());
            options.put("org.eclipse.equinox.security.storage.defaultPassword", password);
        }
        if ((requiredID = this.getModuleID()) != null) {
            options.put("org.eclipse.equinox.security.storage.requiredID", requiredID);
        }
        options.put("org.eclipse.equinox.security.storage.promptUser", new Boolean(false));
        return options;
    }

    protected URL getStorageLocation() throws MalformedURLException {
        IPath tempDir = FileSystemHelper.getTempDir();
        tempDir = tempDir.append("secure_storage_test.equinox");
        return tempDir.toFile().toURL();
    }
}

