/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;

public class WaitingRegistryListener
extends Assert
implements IRegistryEventListener {
    static final long MIN_WAIT_TIME = 100L;
    private List extensionIDs;
    private List extPointIDs;
    private volatile boolean added;
    private volatile boolean removed;
    private volatile int callbacks;
    private String extPointId;

    public WaitingRegistryListener() {
        this.reset();
    }

    public void register(String id) {
        this.extPointId = id;
        if (this.extPointId != null) {
            RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, this.extPointId);
        } else {
            RegistryFactory.getRegistry().addListener((IRegistryEventListener)this);
        }
    }

    public void unregister() {
        RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
    }

    public void reset() {
        this.extensionIDs = null;
        this.extPointIDs = null;
        this.added = false;
        this.removed = false;
        this.callbacks = 0;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public synchronized String[] extensionsReceived(long timeout) {
        if (this.extensionIDs != null) {
            return this.extensionIDs.toArray(new String[this.extensionIDs.size()]);
        }
        try {
            ((Object)((Object)this)).wait(timeout);
        }
        catch (InterruptedException interruptedException) {}
        if (this.extensionIDs == null) {
            return null;
        }
        return this.extensionIDs.toArray(new String[this.extensionIDs.size()]);
    }

    public synchronized String[] extPointsReceived(long timeout) {
        if (this.extPointIDs != null) {
            return this.extPointIDs.toArray(new String[this.extPointIDs.size()]);
        }
        try {
            ((Object)((Object)this)).wait(timeout);
        }
        catch (InterruptedException interruptedException) {}
        if (this.extPointIDs == null) {
            return null;
        }
        return this.extPointIDs.toArray(new String[this.extPointIDs.size()]);
    }

    public synchronized int waitFor(int events, long maxTimeout) {
        long startTime = System.currentTimeMillis();
        try {
            while (this.callbacks < events) {
                long timeToWait;
                long currentTime = System.currentTimeMillis();
                long alreadyWaited = currentTime - startTime;
                if (alreadyWaited < 0L) {
                    alreadyWaited = 0L;
                }
                if ((timeToWait = maxTimeout - alreadyWaited) <= 0L) {
                    ((Object)((Object)this)).wait(100L);
                    break;
                }
                ((Object)((Object)this)).wait(timeToWait);
            }
        }
        catch (InterruptedException interruptedException) {}
        return this.callbacks;
    }

    public synchronized void added(IExtension[] extensions) {
        this.extensionsToString(extensions);
        this.added = true;
        ++this.callbacks;
        ((Object)((Object)this)).notify();
    }

    public synchronized void removed(IExtension[] extensions) {
        this.extensionsToString(extensions);
        this.removed = true;
        ++this.callbacks;
        ((Object)((Object)this)).notify();
    }

    public synchronized void added(IExtensionPoint[] extensionPoints) {
        this.extPointsToString(extensionPoints);
        this.added = true;
        ++this.callbacks;
        ((Object)((Object)this)).notify();
    }

    public synchronized void removed(IExtensionPoint[] extensionPoints) {
        this.extPointsToString(extensionPoints);
        this.removed = true;
        ++this.callbacks;
        ((Object)((Object)this)).notify();
    }

    private void extensionsToString(IExtension[] extensions) {
        this.extensionIDs = new ArrayList(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            this.extensionIDs.add(extension.getUniqueIdentifier());
            String ownerId = extension.getExtensionPointUniqueIdentifier();
            if (this.extPointId != null) {
                WaitingRegistryListener.assertTrue((boolean)this.extPointId.equals(ownerId));
            }
            WaitingRegistryListener.assertTrue((boolean)this.validContents(extension.getConfigurationElements()));
            ++i;
        }
    }

    private boolean validContents(IConfigurationElement[] children) {
        if (children == null) {
            return true;
        }
        int i = 0;
        while (i < children.length) {
            if (!children[i].isValid()) {
                return false;
            }
            if (!this.validContents(children[i].getChildren())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void extPointsToString(IExtensionPoint[] extensionPoints) {
        this.extPointIDs = new ArrayList(extensionPoints.length);
        int i = 0;
        while (i < extensionPoints.length) {
            this.extPointIDs.add(extensionPoints[i].getUniqueIdentifier());
            ++i;
        }
    }
}

