/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.security.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.equinox.internal.security.tests.SecurityTestsActivator;
import org.eclipse.equinox.internal.security.tests.storage.Base64Test;
import org.eclipse.equinox.internal.security.tests.storage.DefaultPreferencesTest;
import org.eclipse.equinox.internal.security.tests.storage.DynamicPreferencesTest;
import org.eclipse.equinox.internal.security.tests.storage.SlashEncodeTest;
import org.eclipse.equinox.internal.security.tests.storage.WinPreferencesTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AllSecurityTests
extends TestCase {
    private static final String WIN_BUNDLE = "org.eclipse.equinox.security.win32.x86";
    static /* synthetic */ Class class$0;

    public AllSecurityTests() {
        super(null);
    }

    public AllSecurityTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.security.tests.AllSecurityTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest(Base64Test.suite());
        suite.addTest(SlashEncodeTest.suite());
        suite.addTest(DefaultPreferencesTest.suite());
        suite.addTest(DynamicPreferencesTest.suite());
        if (AllSecurityTests.hasBundle(WIN_BUNDLE)) {
            suite.addTest(WinPreferencesTest.suite());
        }
        return suite;
    }

    private static boolean hasBundle(String symbolicID) {
        BundleContext context = SecurityTestsActivator.getDefault().getBundleContext();
        Bundle[] bundles = context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            String bundleName = bundles[i].getSymbolicName();
            if (symbolicID.equals(bundleName)) {
                int bundleState = bundles[i].getState();
                return bundleState != 2 && bundleState != 1;
            }
            ++i;
        }
        return false;
    }
}

