/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.util.AptUtil;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.ExpectedProblem;
import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;
import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotationProcessorFactory;
import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldWildcardAnnotationProcessorFactory;
import org.eclipse.jdt.core.IJavaProject;

public class APITests
extends APTTestBase {
    private LogListener _logListener;

    public APITests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(APITests.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this._logListener = new LogListener();
        AptPlugin.getPlugin().getLog().addLogListener((ILogListener)this._logListener);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        AptPlugin.getPlugin().getLog().removeLogListener((ILogListener)this._logListener);
        this._logListener = null;
    }

    public void testAptUtil() throws Exception {
        IJavaProject jproj = env.getJavaProject(this.getProjectName());
        AnnotationProcessorFactory factory = AptUtil.getFactoryForAnnotation((String)HelloWorldAnnotation.class.getName(), (IJavaProject)jproj);
        APITests.assertEquals(factory.getClass(), HelloWorldAnnotationProcessorFactory.class);
        factory = AptUtil.getFactoryForAnnotation((String)(String.valueOf(HelloWorldAnnotation.class.getName()) + "qwerty"), (IJavaProject)jproj);
        APITests.assertEquals(factory.getClass(), HelloWorldWildcardAnnotationProcessorFactory.class);
        HelloWorldWildcardAnnotationProcessorFactory.CLAIM_ALL_ANNOTATIONS = true;
        try {
            factory = AptUtil.getFactoryForAnnotation((String)"org.eclipse.Foo", (IJavaProject)jproj);
            APITests.assertEquals(factory.getClass(), HelloWorldWildcardAnnotationProcessorFactory.class);
        }
        finally {
            HelloWorldWildcardAnnotationProcessorFactory.CLAIM_ALL_ANNOTATIONS = false;
        }
        factory = AptUtil.getFactoryForAnnotation((String)"org.eclipse.Foo", (IJavaProject)jproj);
        APITests.assertNull((Object)factory);
    }

    public void testMessagerAPI() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath code = env.addClass(srcRoot, "messagertestpackage", "MessagerTestClass", "package messagertestpackage;\nimport org.eclipse.jdt.apt.tests.annotations.messager.MessagerAnnotation;\npublic class MessagerTestClass {\n    @MessagerAnnotation(severity=MessagerAnnotation.Severity.INFO)\n    public void Foo() {\n    }\n    @MessagerAnnotation(severity=MessagerAnnotation.Severity.WARNING)\n    public void Bar() {\n    }\n    @MessagerAnnotation(severity=MessagerAnnotation.Severity.ERROR)\n    public void Quux() {\n    }\n}");
        ExpectedProblem prob1 = new ExpectedProblem("", "Annotated with MessagerAnnotation(WARNING)", code, 319, 322);
        ExpectedProblem prob2 = new ExpectedProblem("", "Annotated with MessagerAnnotation(ERROR)", code, 417, 421);
        ExpectedProblem[] problems = new ExpectedProblem[]{prob1, prob2};
        this._logListener.clear();
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemsFor(code, problems);
        this.checkMessagerAnnotationLogEntry("Annotated with MessagerAnnotation(INFO)", 219, 222);
        env.removeClass(code, "MessagerTestClass");
        code = env.addClass(srcRoot, "messagertestpackage", "MessagerTestClass", "package messagertestpackage;\nimport org.eclipse.jdt.apt.tests.annotations.messager.MessagerAnnotation;\npublic class MessagerTestClass {\n    @MessagerAnnotation(severity=MessagerAnnotation.Severity.INFO)\n    public void Foo() {\n    }\n    @MessagerAnnotation(severity=MessagerAnnotation.Severity.WARNING)\n    public void Bar() {\n    }\n}");
        this._logListener.clear();
        this.fullBuild(project.getFullPath());
        problems = new ExpectedProblem[]{prob1};
        this.expectingOnlySpecificProblemsFor(code, problems);
        this.checkMessagerAnnotationLogEntry("Annotated with MessagerAnnotation(INFO)", 219, 222);
        env.removeClass(code, "MessagerTestClass");
        code = env.addClass(srcRoot, "messagertestpackage", "MessagerTestClass", "package messagertestpackage;\nimport org.eclipse.jdt.apt.tests.annotations.messager.MessagerAnnotation;\npublic class MessagerTestClass {\n    @MessagerAnnotation(severity=MessagerAnnotation.Severity.INFO)\n    public void Foo() {\n    }\n}");
        this._logListener.clear();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this.checkMessagerAnnotationLogEntry("Annotated with MessagerAnnotation(INFO)", 219, 222);
        env.removeClass(code, "MessagerTestClass");
        code = env.addClass(srcRoot, "messagertestpackage", "MessagerTestClass", "package messagertestpackage;\nimport org.eclipse.jdt.apt.tests.annotations.messager.MessagerAnnotation;\npublic class MessagerTestClass {\n    @MessagerAnnotation(severity=MessagerAnnotation.Severity.OK)\n    public void Foo() {\n    }\n}");
        this._logListener.clear();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        APITests.assertTrue((boolean)this._logListener.getList().isEmpty());
    }

    private void checkMessagerAnnotationLogEntry(String targetMsg, int start, int end) {
        int count = 0;
        String offsetMsg = "starting offset=" + start + "; ending offset=" + end;
        for (IStatus status : this._logListener.getList()) {
            String logMessage = status.getMessage();
            if (!logMessage.contains(targetMsg) || !logMessage.contains(offsetMsg)) continue;
            ++count;
        }
        APITests.assertEquals((int)1, (int)count);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogListener
    implements ILogListener {
        private final List<IStatus> _messages = new ArrayList<IStatus>();

        private LogListener() {
        }

        public void logging(IStatus status, String plugin) {
            this._messages.add(status);
        }

        public void clear() {
            this._messages.clear();
        }

        public List<IStatus> getList() {
            return this._messages;
        }
    }
}

