/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.apt.tests.external.annotations.classloader.ColorAnnotationProcessor;
import org.eclipse.jdt.apt.tests.external.annotations.loadertest.LoaderTestAnnotationProcessor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class FactoryLoaderTests
extends APTTestBase {
    private File _extJar;
    private IPath _extVarJar;
    private IPath _projectPath;
    private static final String TEMPJARDIR_CPVAR = "FACTORYLOADERTEST_TEMP";

    public FactoryLoaderTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(FactoryLoaderTests.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this._projectPath = env.getProject(this.getProjectName()).getFullPath();
        this._extJar = TestUtil.createAndAddExternalAnnotationJar(env.getJavaProject(this._projectPath));
        File canonicalJar = this._extJar.getCanonicalFile();
        Path jarDir = new Path(canonicalJar.getParent());
        String extJarName = canonicalJar.getName();
        Path varPath = new Path(TEMPJARDIR_CPVAR);
        this._extVarJar = varPath.append(extJarName);
        JavaCore.setClasspathVariable((String)TEMPJARDIR_CPVAR, (IPath)jarDir, null);
        IPath srcRoot = this.getSourcePath();
        String code = "package loadertestpackage;\nimport org.eclipse.jdt.apt.tests.external.annotations.loadertest.LoaderTestAnnotation;\n@LoaderTestAnnotation\npublic class LoaderTestClass {\n    public static void SayHello() {\n        System.out.println(\"hello\");\n    }\n}";
        env.addClass(srcRoot, "loadertestpackage", "LoaderTestClass", code);
        code = "package colortestpackage;\r\n\r\nimport org.eclipse.jdt.apt.tests.external.annotations.classloader.Color;\r\nimport org.eclipse.jdt.apt.tests.external.annotations.classloader.ColorAnnotation;\r\nimport org.eclipse.jdt.apt.tests.external.annotations.classloader.ColorWrapper;\r\n\r\n@ColorAnnotation(color = Color.RED)\r\n@ColorWrapper(colors = {@ColorAnnotation(color = Color.GREEN), @ColorAnnotation(color = Color.BLUE)})\r\npublic class ColorTest {\r\n\r\n}";
        env.addClass(srcRoot, "colortestpackage", "ColorTest", code);
    }

    public void testExternalJarLoader() throws Exception {
        LoaderTestAnnotationProcessor.clearLoaded();
        IProject project = env.getProject(this.getProjectName());
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FactoryLoaderTests.assertFalse((boolean)LoaderTestAnnotationProcessor.isLoaded());
        IJavaProject jproj = env.getJavaProject(this.getProjectName());
        IFactoryPath ifp = AptConfig.getFactoryPath((IJavaProject)jproj);
        ifp.addExternalJar(this._extJar);
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)ifp);
        LoaderTestAnnotationProcessor.clearLoaded();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FactoryLoaderTests.assertTrue((boolean)LoaderTestAnnotationProcessor.isLoaded());
        FactoryLoaderTests.assertTrue((boolean)ColorAnnotationProcessor.wasSuccessful());
        ifp.removeExternalJar(this._extJar);
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)ifp);
        LoaderTestAnnotationProcessor.clearLoaded();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FactoryLoaderTests.assertFalse((boolean)LoaderTestAnnotationProcessor.isLoaded());
        ifp.addVarJar(this._extVarJar);
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)ifp);
        LoaderTestAnnotationProcessor.clearLoaded();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FactoryLoaderTests.assertTrue((boolean)LoaderTestAnnotationProcessor.isLoaded());
        ifp.removeVarJar(this._extVarJar);
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)ifp);
        LoaderTestAnnotationProcessor.clearLoaded();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FactoryLoaderTests.assertFalse((boolean)LoaderTestAnnotationProcessor.isLoaded());
    }

    public void testNonexistentEntry() throws Exception {
        LoaderTestAnnotationProcessor.clearLoaded();
        IProject project = env.getProject(this.getProjectName());
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FactoryLoaderTests.assertFalse((boolean)LoaderTestAnnotationProcessor.isLoaded());
        IJavaProject jproj = env.getJavaProject(this.getProjectName());
        IFactoryPath ifp = AptConfig.getFactoryPath((IJavaProject)jproj);
        File bogusJar = new File("bogusJar.jar");
        ifp.addExternalJar(bogusJar);
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)ifp);
        this.fullBuild(project.getFullPath());
        IMarker[] markers = this.getAllAPTMarkers(this._projectPath);
        FactoryLoaderTests.assertEquals((int)1, (int)markers.length);
        FactoryLoaderTests.assertEquals((String)"org.eclipse.jdt.apt.core.buildproblem", (String)markers[0].getType());
        String message = markers[0].getAttribute("message", "");
        FactoryLoaderTests.assertTrue((boolean)message.contains("bogusJar.jar"));
        ifp.removeExternalJar(bogusJar);
        ifp.addExternalJar(this._extJar);
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)ifp);
        LoaderTestAnnotationProcessor.clearLoaded();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        FactoryLoaderTests.assertTrue((boolean)LoaderTestAnnotationProcessor.isLoaded());
        FactoryLoaderTests.assertTrue((boolean)ColorAnnotationProcessor.wasSuccessful());
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)ifp);
    }

    protected void tearDown() throws Exception {
        JavaCore.removeClasspathVariable((String)TEMPJARDIR_CPVAR, null);
        this._extJar = null;
        this._extVarJar = null;
        this._projectPath = null;
        super.tearDown();
    }
}

