/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;
import org.eclipse.jdt.apt.tests.annotations.mirrortest.MirrorUtilTestAnnotationProcessor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.tests.builder.Problem;

public class MirrorUtilTests
extends APTTestBase {
    public MirrorUtilTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MirrorUtilTests.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        IProject project = env.getProject(this.getProjectName());
        IJavaProject jproj = env.getJavaProject(project.getFullPath());
        this.addEnvOptions(jproj);
        IPath srcRoot = this.getSourcePath();
        String code = "package testpackage;\nimport org.eclipse.jdt.apt.tests.annotations.mirrortest.MirrorUtilTestAnnotation;\n@MirrorUtilTestAnnotation\npublic class DeclarationsTestClass\n{\n    public class A\n    {\n        public int field; \n        public void method(){}\n    }\n    public class B extends A\n    {\n        public int field; \n        public void method(){}\n    }\n    public class C\n    {\n        public int field; \n        public void method(){}\n    }\n    public class D extends A\n    {\n    \tpublic Object field;\n    \tpublic void method(String s){}\n    }\n    public interface I\n    {\n    \tpublic int field = 1;\n       public void method();\n    }\n    public interface J\n    {\n    \tpublic int field = 2;\n    }\n    public class K implements I, J\n    {\n    \tpublic int field;\n       public void method(){}\n    }\n}";
        env.addClass(srcRoot, "testpackage", "DeclarationsTestClass", code);
        this.fullBuild(project.getFullPath());
        this.assertNoUnexpectedProblems();
    }

    private void addEnvOptions(IJavaProject jproj) {
        int i = 0;
        while (i < MirrorUtilTestAnnotationProcessor.ENV_KEYS.length) {
            AptConfig.addProcessorOption((IJavaProject)jproj, (String)MirrorUtilTestAnnotationProcessor.ENV_KEYS[i], (String)MirrorUtilTestAnnotationProcessor.ENV_VALUES[i]);
            ++i;
        }
    }

    private void assertNoUnexpectedProblems() {
        Problem[] problems;
        Problem[] problemArray = problems = env.getProblems();
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (!problem.getMessage().startsWith("The field DeclarationsTestClass")) {
                MirrorUtilTests.fail((String)("Found unexpected problem: " + problem));
            }
            ++n2;
        }
    }

    public void testMirrorUtils() throws Exception {
        MirrorUtilTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }
}

