/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;
import org.eclipse.jdt.apt.tests.plugin.AptTestsPlugin;
import org.eclipse.jdt.core.IJavaProject;

public class ReadAnnotationTests
extends APTTestBase {
    public ReadAnnotationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ReadAnnotationTests.class);
    }

    private void addAllSources() {
        this.addQuestionSources();
        this.addTriggerSource();
        this.addNoTypeSources();
    }

    private void addQuestionSources() {
        IPath srcRoot = this.getSourcePath();
        env.addClass(srcRoot, "question", "SimpleAnnotation", "package question; \n\nimport java.lang.annotation.Retention; \nimport java.lang.annotation.RetentionPolicy; \n\n@Retention(value=RetentionPolicy.RUNTIME) \npublic @interface SimpleAnnotation { \n\n\tString value(); \n}");
        env.addClass(srcRoot, "question", "RTVisibleAnno", "package question; \n\nimport java.lang.annotation.*; \n\n@Retention(value=RetentionPolicy.RUNTIME) \npublic @interface RTVisibleAnno  \n{\t\n\tString name() default \"eclipse\"; \n\tboolean boolValue() default true; \n\tbyte byteValue() default 0x0001; \n\tchar charValue() default 'e'; \n\tdouble doubleValue() default 0.0; \n\tfloat floatValue()  default 0; \n\tint intValue() default 17; \n\tlong longValue() default 43; \n\tshort shortValue() default 1; \n\tColor[] colors() default {Color.RED, Color.WHITE, Color.BLUE}; \n\tSimpleAnnotation anno(); \n\tSimpleAnnotation[] simpleAnnos() default { @SimpleAnnotation(\"org.eclipse.org\") }; \n\tClass<?>[] clazzes(); \n\tClass<?> clazz() default java.lang.String.class; \n\n }");
        env.addClass(srcRoot, "question", "RTInvisibleAnno", "package question;  \n\n   public @interface RTInvisibleAnno{  \n   \tString value(); \n   }");
        env.addClass(srcRoot, "question", "package-info", "@Deprecated package question; ");
        env.addClass(srcRoot, "question", "Color", "package question;\n\npublic enum Color { RED, WHITE, BLUE; } ");
        env.addClass(srcRoot, "question", "AnnotationTest", "package question;\n\n@Deprecated\n@RTVisibleAnno(anno=@SimpleAnnotation(\"test\"), clazzes={})\n@RTInvisibleAnno(\"question\")\npublic interface AnnotationTest{\n\n    @RTVisibleAnno(name = \"Foundation\",\n                   boolValue   = false, \n                   byteValue   = 0x10,  \n                   charValue   = 'c', \n                   doubleValue = 99.0, \n                   floatValue  = (float)9.0, \n                   intValue    = 999, \n                   longValue = 3333,  \n                   shortValue = 3,    \n                   colors ={ Color.RED, Color.BLUE }, \n                   anno = @SimpleAnnotation(\"core\"),\n                   simpleAnnos = {@SimpleAnnotation(\"org\"),    \n              \t                   @SimpleAnnotation(\"eclipse\"),\n        \t\t                   @SimpleAnnotation(\"jdt\") },  \n                   clazzes = {Object.class, String.class},\n \t\t            clazz = Object.class)\n     @RTInvisibleAnno(\"org.eclipse.jdt.core\")\n     @Deprecated \n     public int field0 = 0; \n\n    @Deprecated \n    public int field1 = 1; \n\n    @RTVisibleAnno(anno=@SimpleAnnotation(\"field\"), clazzes={})\n     @RTInvisibleAnno(\"2\") \n     public int field2 = 2; \n\n    @RTInvisibleAnno(\"3\") \n    public int field3 = 3; \n\n    @SimpleAnnotation(\"4\") \n    public int field4 = 4; \n\n    @RTVisibleAnno(anno=@SimpleAnnotation(\"method0\"), clazzes={}) \n    @RTInvisibleAnno(\"0\") \n    @Deprecated \n     public int method0();  \n \n    @Deprecated \n     public int method1(); \n \n    @RTVisibleAnno(anno=@SimpleAnnotation(\"method2\"), clazzes={}) \n     @RTInvisibleAnno(\"2\") \n    public int method2(); \n\n   @RTInvisibleAnno(\"3\") \n   public int method3(); \n\n   @SimpleAnnotation(\"method4\") \n   public int method4(); \n\n   public int method5(int p0, \n   \t\t\t\t   @Deprecated  \n   \t\t\t\t   int p1, \n   \t\t\t\t   @RTVisibleAnno(anno=@SimpleAnnotation(\"param2\"), clazzes={}) \n   \t\t\t\t   @RTInvisibleAnno(\"2\") \n   \t\t\t\t   int p2); \n\n   public int method6(int p0, int p1, int p2); \n\n }");
    }

    private void addNoTypeSources() {
        IPath srcRoot = this.getSourcePath();
        env.addClass(srcRoot, "notypes", "package-info", "@question.SimpleAnnotation(\"foo\") package notypes;\n");
    }

    private void addTriggerSource() {
        IPath srcRoot = this.getSourcePath();
        env.addClass(srcRoot, "trigger", "MyMarkerAnnotation", "package trigger; \n\npublic @interface MyMarkerAnnotation {}");
        env.addClass(srcRoot, "trigger", "Trigger", "package trigger; \n\n@MyMarkerAnnotation \npublic class Trigger {}");
    }

    private IProject setupTest() throws Exception {
        IJavaProject jproj = this.getCurrentJavaProject();
        jproj.setOption("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        return jproj.getProject();
    }

    public void test0() throws Exception {
        IProject project = this.setupTest();
        this.addAllSources();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        ReadAnnotationTests.assertTrue((boolean)ProcessorTestStatus.processorRan());
        ReadAnnotationTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void test1() throws Exception {
        IProject project = this.setupTest();
        File jar = TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path("/resources/question.jar"));
        String path = jar.getAbsolutePath();
        env.addExternalJar(project.getFullPath(), path);
        this.addTriggerSource();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        ReadAnnotationTests.assertTrue((boolean)ProcessorTestStatus.processorRan());
        ReadAnnotationTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }
}

