/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.apt.tests.plugin.AptTestsPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtil {
    private static final String BIN_EXT = "/bin-ext";
    private static final String BIN_ANNOTATIONS = "/bin-annotations";
    private static File ANNO_JAR = null;
    public static final String ANNOTATIONS_PKG = "org.eclipse.jdt.apt.tests.annotations";
    public static final String EXTANNOTATIONS_PKG = "org.eclipse.jdt.apt.tests.external.annotations";

    public static File createAndAddAnnotationJar(IJavaProject project) throws IOException, JavaModelException {
        if (ANNO_JAR == null) {
            IPath statePath = AptPlugin.getPlugin().getStateLocation();
            IPath jarPath = statePath.append("org.eclipse.jdt.apt.tests.TestUtil.jar");
            ANNO_JAR = new File(jarPath.toOSString());
            String classesJarPath = ANNO_JAR.getAbsolutePath();
            if (TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path(BIN_ANNOTATIONS)) != null) {
                PackageFileFilter filter = new PackageFileFilter(ANNOTATIONS_PKG, TestUtil.getAnnotationsClassesDir());
                Map<File, FileFilter> files = Collections.singletonMap(new File(TestUtil.getAnnotationsClassesDir()), filter);
                TestUtil.zip(classesJarPath, files);
            } else {
                File aptJarFile = TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path("/apt.jar"));
                if (aptJarFile == null) {
                    throw new FileNotFoundException("Could not find apt.jar file in org.eclipse.jdt.apt.tests plugin");
                }
                TestUtil.moveFile(aptJarFile, classesJarPath);
            }
            ANNO_JAR.deleteOnExit();
        }
        TestUtil.addLibraryEntry(project, (IPath)new Path(ANNO_JAR.getAbsolutePath()), null, null, true);
        return ANNO_JAR;
    }

    public static File createAndAddExternalAnnotationJar(IJavaProject project) throws IOException, JavaModelException {
        File jarFile = File.createTempFile("org.eclipse.jdt.apt.tests.TestUtil", ".jar");
        String classesJarPath = jarFile.getAbsolutePath();
        File extBinDir = TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path(BIN_EXT));
        if (extBinDir != null) {
            PackageFileFilter classFilter = new PackageFileFilter(EXTANNOTATIONS_PKG, TestUtil.getPluginExtClassesDir());
            PackageFileFilter manifestFilter = new PackageFileFilter("META-INF", TestUtil.getPluginExtSrcDir());
            HashMap<File, FileFilter> files = new HashMap<File, FileFilter>(2);
            files.put(new File(TestUtil.getPluginExtClassesDir()), classFilter);
            files.put(new File(TestUtil.getPluginExtSrcDir()), manifestFilter);
            TestUtil.zip(classesJarPath, files);
        } else {
            File extJarFile = TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path("/aptext.jar"));
            if (extJarFile != null) {
                TestUtil.moveFile(extJarFile, classesJarPath);
            } else {
                throw new FileNotFoundException("Could not find aptext.jar file in org.eclipse.jdt.apt.tests plugin");
            }
        }
        TestUtil.addLibraryEntry(project, (IPath)new Path(classesJarPath), null, null, true);
        jarFile.deleteOnExit();
        return jarFile;
    }

    public static IStatus deleteFile(IPath path) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return Util.delete((IResource)file);
    }

    public static boolean enableAutoBuild(boolean state) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean isAutoBuilding = desc.isAutoBuilding();
        if (isAutoBuilding != state) {
            desc.setAutoBuilding(state);
            try {
                workspace.setDescription(desc);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return isAutoBuilding;
    }

    public static IPath getProjectPath(IJavaProject project) {
        return project.getResource().getLocation();
    }

    public static String getAnnotationsClassesDir() {
        return TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path(BIN_ANNOTATIONS)).getAbsolutePath();
    }

    public static String getPluginExtClassesDir() {
        return TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path(BIN_EXT)).getAbsolutePath();
    }

    public static String getPluginExtSrcDir() {
        return TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path("/src-ext")).getAbsolutePath();
    }

    public static File getFileInPlugin(Plugin plugin, IPath path) {
        URL installURL;
        block3: {
            try {
                installURL = plugin.getBundle().getEntry(path.toString());
                if (installURL != null) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        URL localURL = FileLocator.toFileURL((URL)installURL);
        return new File(localURL.getFile());
    }

    public static void moveFile(File from, String toPath) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int b;
            fis = new FileInputStream(from);
            fos = new FileOutputStream(new File(toPath));
            while ((b = fis.read()) != -1) {
                fos.write(b);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void zip(String zipPath, Map<File, FileFilter> input) throws IOException {
        ZipOutputStream zip = null;
        try {
            zip = new ZipOutputStream(new FileOutputStream(zipPath));
            for (Map.Entry<File, FileFilter> e : input.entrySet()) {
                TestUtil.zip(zip, e.getKey(), e.getKey().getPath().length() + 1, e.getValue());
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    private static void zip(ZipOutputStream zip, File dir, int rootPathLength, FileFilter filter) throws IOException {
        String[] list = dir.list();
        if (list != null) {
            int i = 0;
            int length = list.length;
            while (i < length) {
                String name = list[i];
                File file = new File(dir, name);
                if (filter == null || filter.accept(file)) {
                    if (file.isDirectory()) {
                        TestUtil.zip(zip, file, rootPathLength, filter);
                    } else {
                        String path = file.getPath();
                        path = path.substring(rootPathLength);
                        ZipEntry entry = new ZipEntry(path.replace('\\', '/'));
                        zip.putNextEntry(entry);
                        zip.write(TestUtil.getBytesFromFile(file));
                        zip.closeEntry();
                    }
                }
                ++i;
            }
        }
    }

    private static byte[] getBytesFromFile(File f) throws IOException {
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        byte[] rtrn = new byte[]{};
        try {
            int b;
            fis = new FileInputStream(f);
            baos = new ByteArrayOutputStream();
            while ((b = fis.read()) != -1) {
                baos.write(b);
            }
            rtrn = baos.toByteArray();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return rtrn;
    }

    public static void unzip(File srcZip, File destDir) throws IOException {
        ZipFile zf = new ZipFile(srcZip);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            File dest = new File(destDir, name);
            if (entry.isDirectory()) {
                FileSystemUtil.mkdirs((File)dest);
                continue;
            }
            File parent = dest.getParentFile();
            FileSystemUtil.mkdirs((File)parent);
            InputStream from = null;
            FileOutputStream to = null;
            try {
                int bytesRead;
                from = zf.getInputStream(entry);
                to = new FileOutputStream(dest);
                byte[] buffer = new byte[4096];
                while ((bytesRead = from.read(buffer)) != -1) {
                    ((OutputStream)to).write(buffer, 0, bytesRead);
                }
            }
            catch (Throwable throwable) {
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException iOException) {}
                }
                if (to != null) {
                    try {
                        ((OutputStream)to).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to == null) continue;
            try {
                ((OutputStream)to).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void unzip(ZipInputStream srcZip, File destDir) throws IOException {
        ZipEntry entry;
        while ((entry = srcZip.getNextEntry()) != null) {
            String name = entry.getName();
            File dest = new File(destDir, name);
            if (entry.isDirectory()) {
                FileSystemUtil.mkdirs((File)dest);
                continue;
            }
            File parent = dest.getParentFile();
            FileSystemUtil.mkdirs((File)parent);
            FileOutputStream to = null;
            try {
                int bytesRead;
                to = new FileOutputStream(dest);
                byte[] buffer = new byte[4096];
                while ((bytesRead = srcZip.read(buffer)) != -1) {
                    ((OutputStream)to).write(buffer, 0, bytesRead);
                }
            }
            catch (Throwable throwable) {
                srcZip.closeEntry();
                if (to != null) {
                    try {
                        ((OutputStream)to).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            srcZip.closeEntry();
            if (to == null) continue;
            try {
                ((OutputStream)to).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void addLibraryEntry(IJavaProject project, IPath path, IPath srcAttachmentPath, IPath srcAttachmentPathRoot, boolean exported) throws JavaModelException {
        IClasspathEntry[] entries = project.getRawClasspath();
        int length = entries.length;
        IClasspathEntry newPathEntry = JavaCore.newLibraryEntry((IPath)path, (IPath)srcAttachmentPath, (IPath)srcAttachmentPathRoot, (boolean)exported);
        int i = 0;
        while (i < length) {
            if (newPathEntry.equals(entries[i])) {
                return;
            }
            ++i;
        }
        IClasspathEntry[] iClasspathEntryArray = entries;
        entries = new IClasspathEntry[length + 1];
        System.arraycopy(iClasspathEntryArray, 0, entries, 1, length);
        entries[0] = newPathEntry;
        project.setRawClasspath(entries, null);
    }

    private static class PackageFileFilter
    implements FileFilter {
        private final String[] _packageParts;
        private final Path _binDir;

        public PackageFileFilter(String packageSubset, String binDir) {
            this._packageParts = packageSubset.split("\\.");
            this._binDir = new Path(binDir);
        }

        public boolean accept(File pathname) {
            Path f = new Path(pathname.getAbsolutePath());
            int nsegments = f.matchingFirstSegments((IPath)this._binDir);
            boolean ok = true;
            int min = Math.min(f.segmentCount() - nsegments, this._packageParts.length);
            int i = nsegments;
            int j = 0;
            while (j < min) {
                if (!f.segment(i).equals(this._packageParts[j])) {
                    ok = false;
                    break;
                }
                ++i;
                ++j;
            }
            return ok;
        }
    }
}

