/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.compiler.tool.tests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import junit.framework.Test;
import org.eclipse.jdt.compiler.tool.tests.AbstractCompilerToolTest;
import org.eclipse.jdt.compiler.tool.tests.CompilerToolTests;
import org.eclipse.jdt.compiler.tool.tests.ForwardingStandardJavaFileManager;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;

public class CompilerInvocationTests
extends AbstractCompilerToolTest {
    public CompilerInvocationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return CompilerInvocationTests.buildUniqueComplianceTestSuite(CompilerInvocationTests.class, (long)0x320000L);
    }

    public static Class<CompilerInvocationTests> testClass() {
        return CompilerInvocationTests.class;
    }

    protected void checkClassFiles(String[] fileNames) {
        int i = 0;
        int l = fileNames.length;
        while (i < l) {
            ClassFileReader reader = null;
            try {
                reader = ClassFileReader.read((File)new File(OUTPUT_DIR, fileNames[i]), (boolean)true);
            }
            catch (ClassFormatException classFormatException) {
                CompilerInvocationTests.fail((String)("Class format exception for file " + fileNames[i]));
            }
            catch (IOException iOException) {
                CompilerInvocationTests.fail((String)("IO exception for file " + fileNames[i]));
            }
            CompilerInvocationTests.assertNotNull((String)("Could not read " + fileNames[i]), (Object)reader);
            CompilerInvocationTests.assertEquals((String)("Wrong Java version for " + fileNames[i]), (long)0x320000L, (long)reader.getVersion());
            ++i;
        }
    }

    void runTest(boolean shouldCompileOK, String[] sourceFiles, StandardJavaFileManager standardJavaFileManager, List<String> options, String[] compileFileNames, String expectedOutOutputString, String expectedErrOutputString, boolean shouldFlushOutputDirectory, String[] classFileNames) {
        super.runTest(shouldCompileOK, sourceFiles, (Object)new AbstractCompilerToolTest.CompilerInvocationTestsArguments(standardJavaFileManager, options, compileFileNames), expectedOutOutputString, expectedErrOutputString, shouldFlushOutputDirectory, null);
        if (classFileNames != null) {
            this.checkClassFiles(classFileNames);
        }
    }

    protected void compareFileLocations(String[] expected, Iterator<? extends File> actual) {
        int i = 0;
        while (actual.hasNext() && i < expected.length) {
            CompilerInvocationTests.assertEquals((String)"Path mismatch", (String)expected[i], (String)actual.next().toString());
            ++i;
        }
        CompilerInvocationTests.assertEquals((String)"Incorret no of files in path", (int)i, (int)expected.length);
        CompilerInvocationTests.assertFalse((String)"Incorrect no of files in path", (boolean)actual.hasNext());
    }

    public void test001_basic() {
        this.runTest(true, new String[]{"X.java", "public class X {}"}, null, Arrays.asList("-d", OUTPUT_DIR), new String[]{"X.java"}, "", "", true, new String[]{"X.class"});
    }

    public void test002_dash_d_option() {
        if (JAVAC_COMPILER == null) {
            System.out.println("No system java compiler available");
            return;
        }
        StandardJavaFileManager javacStandardJavaFileManager = JAVAC_COMPILER.getStandardFileManager(null, null, null);
        this.runTest(true, new String[]{"X.java", "public class X {}"}, javacStandardJavaFileManager, Arrays.asList("-d", OUTPUT_DIR), new String[]{"X.java"}, "", "", true, new String[]{"X.class"});
        this.compareFileLocations(new String[]{OUTPUT_DIR}, javacStandardJavaFileManager.getLocation(StandardLocation.CLASS_OUTPUT).iterator());
    }

    public void test003_dash_d_option() {
        if (JAVAC_COMPILER == null) {
            System.out.println("No system java compiler available");
            return;
        }
        StandardJavaFileManager javacStandardJavaFileManager = JAVAC_COMPILER.getStandardFileManager(null, null, null);
        String outputDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        this.runTest(true, new String[]{"src/X.java", "public class X {}"}, javacStandardJavaFileManager, Arrays.asList("-d", outputDir), new String[]{"src/X.java"}, "", "", true, new String[]{"bin/X.class"});
        this.compareFileLocations(new String[]{outputDir}, javacStandardJavaFileManager.getLocation(StandardLocation.CLASS_OUTPUT).iterator());
    }

    public void test004_no_dash_d_option() throws IOException {
        if (JAVAC_COMPILER == null) {
            System.out.println("No system java compiler available");
            return;
        }
        File binDirectory = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin");
        binDirectory.mkdirs();
        StandardJavaFileManager javacStandardJavaFileManager = JAVAC_COMPILER.getStandardFileManager(null, null, null);
        javacStandardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Arrays.asList(binDirectory));
        this.runTest(true, new String[]{"src/X.java", "public class X {}"}, javacStandardJavaFileManager, null, new String[]{"src/X.java"}, "", "", true, new String[]{"bin/X.class"});
    }

    public void test005_dash_d_option_custom_file_manager() {
        if (JAVAC_COMPILER == null) {
            System.out.println("No system java compiler available");
            return;
        }
        StandardJavaFileManager javacJavaFileManager = JAVAC_COMPILER.getStandardFileManager(null, null, null);
        SetLocationDetector customJavaFileManager = new SetLocationDetector(javacJavaFileManager, StandardLocation.CLASS_OUTPUT);
        this.runTest(true, new String[]{"X.java", "public class X {}"}, customJavaFileManager, Arrays.asList("-d", OUTPUT_DIR), new String[]{"X.java"}, "", "", true, new String[]{"X.class"});
        this.compareFileLocations(new String[]{OUTPUT_DIR}, customJavaFileManager.getLocation(StandardLocation.CLASS_OUTPUT).iterator());
        CompilerInvocationTests.assertFalse((boolean)customJavaFileManager.matchFound());
        if (RUN_JAVAC && JAVAC_COMPILER != null) {
            customJavaFileManager = new SetLocationDetector(javacJavaFileManager, StandardLocation.CLASS_OUTPUT);
            CompilerInvocationTests.assertTrue((boolean)JAVAC_COMPILER.getTask(null, customJavaFileManager, null, Arrays.asList("-d", OUTPUT_DIR), null, customJavaFileManager.getJavaFileObjectsFromFiles(Arrays.asList(new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.java")))).call());
            CompilerInvocationTests.assertFalse((boolean)customJavaFileManager.matchFound());
        }
    }

    public void test006_no_dash_d_option_custom_file_manager() throws IOException {
        if (JAVAC_COMPILER == null) {
            System.out.println("No system java compiler available");
            return;
        }
        File binDirectory = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin");
        binDirectory.mkdirs();
        GetLocationDetector customJavaFileManager = new GetLocationDetector(JAVAC_COMPILER.getStandardFileManager(null, null, null), StandardLocation.CLASS_OUTPUT);
        customJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Arrays.asList(binDirectory));
        this.runTest(true, new String[]{"src/X.java", "public class X {}"}, customJavaFileManager, null, new String[]{"src/X.java"}, "", "", true, new String[]{"bin/X.class"});
        CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound());
    }

    public void test007_options_consumption() throws IOException {
        List<String> remainingAsList = Arrays.asList("output", "remainder");
        StandardJavaFileManager ecjStandardJavaFileManager = COMPILER.getStandardFileManager(null, null, null);
        Iterator<String> remaining = remainingAsList.iterator();
        CompilerInvocationTests.assertTrue((String)"does not support -d option", (boolean)ecjStandardJavaFileManager.handleOption("-d", remaining));
        CompilerInvocationTests.assertEquals((String)"unexpected consumption rate", (String)"remainder", (String)remaining.next());
        if (RUN_JAVAC && JAVAC_COMPILER != null) {
            StandardJavaFileManager javacStandardJavaFileManager = JAVAC_COMPILER.getStandardFileManager(null, null, null);
            remaining = remainingAsList.iterator();
            CompilerInvocationTests.assertTrue((String)"does not support -d option", (boolean)javacStandardJavaFileManager.handleOption("-d", remaining));
            CompilerInvocationTests.assertEquals((String)"unexpected consumption rate", (String)"remainder", (String)remaining.next());
            javacStandardJavaFileManager.close();
        }
        ecjStandardJavaFileManager.close();
    }

    public void test008_options_consumption() throws IOException {
        Iterator<String> remaining;
        String option;
        List<String> remainingAsList = Arrays.asList("output", "remainder");
        StandardJavaFileManager ecjStandardJavaFileManager = COMPILER.getStandardFileManager(null, null, null);
        String[] stringArray = CompilerToolTests.ZERO_ARG_OPTIONS;
        int n = CompilerToolTests.ZERO_ARG_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            option = stringArray[n2];
            if (ecjStandardJavaFileManager.isSupportedOption(option) != -1) {
                remaining = remainingAsList.iterator();
                CompilerInvocationTests.assertTrue((String)("does not support " + option + " option"), (boolean)ecjStandardJavaFileManager.handleOption(option, remaining));
                CompilerInvocationTests.assertEquals((String)"unexpected consumption rate", (String)"remainder", (String)remaining.next());
            }
            ++n2;
        }
        stringArray = CompilerToolTests.FAKE_ZERO_ARG_OPTIONS;
        n = CompilerToolTests.FAKE_ZERO_ARG_OPTIONS.length;
        n2 = 0;
        while (n2 < n) {
            option = stringArray[n2];
            if (ecjStandardJavaFileManager.isSupportedOption(option) != -1) {
                remaining = remainingAsList.iterator();
                CompilerInvocationTests.assertTrue((String)("does not support " + option + " option"), (boolean)ecjStandardJavaFileManager.handleOption(option, remaining));
                CompilerInvocationTests.assertEquals((String)"unexpected consumption rate", (String)"remainder", (String)remaining.next());
            }
            ++n2;
        }
        ecjStandardJavaFileManager.close();
    }

    public void test009_options_consumption() throws IOException {
        List<String> remainingAsList = Arrays.asList("utf-8", "remainder");
        StandardJavaFileManager ecjStandardJavaFileManager = COMPILER.getStandardFileManager(null, null, null);
        String[] stringArray = CompilerToolTests.ONE_ARG_OPTIONS;
        int n = CompilerToolTests.ONE_ARG_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (ecjStandardJavaFileManager.isSupportedOption(option) != -1) {
                Iterator<String> remaining = remainingAsList.iterator();
                CompilerInvocationTests.assertTrue((String)("does not support " + option + " option"), (boolean)ecjStandardJavaFileManager.handleOption(option, remaining));
                CompilerInvocationTests.assertEquals((String)"unexpected consumption rate", (String)"remainder", (String)remaining.next());
            }
            ++n2;
        }
        ecjStandardJavaFileManager.close();
    }

    public void test010_inappropriate_encoding_diagnosis() throws IOException {
        List<String> buggyEncoding = Arrays.asList("dummy");
        boolean passed = true;
        try {
            passed = COMPILER.getStandardFileManager(null, null, null).handleOption("-encoding", buggyEncoding.iterator());
        }
        catch (RuntimeException runtimeException) {
            passed = false;
        }
        CompilerInvocationTests.assertFalse((String)"does not catch inappropriate -encoding option", (boolean)passed);
        if (RUN_JAVAC && JAVAC_COMPILER != null) {
            passed = true;
            try {
                passed = JAVAC_COMPILER.getStandardFileManager(null, null, null).handleOption("-encoding", buggyEncoding.iterator());
            }
            catch (Throwable throwable) {
                passed = false;
            }
            CompilerInvocationTests.assertFalse((String)"does not catch inappropriate -encoding option", (boolean)passed);
        }
    }

    public void test011_inappropriate_encoding_diagnosis() {
        List<String> options = Arrays.asList("-d", OUTPUT_DIR, "-encoding", "dummy");
        boolean passed = true;
        try {
            this.runTest(false, new String[]{"X.java", "public class X {}"}, null, options, new String[]{"X.java"}, "", "", true, null);
        }
        catch (RuntimeException runtimeException) {
            passed = false;
        }
        CompilerInvocationTests.assertFalse((String)"does not catch inappropriate -encoding option", (boolean)passed);
        if (RUN_JAVAC && JAVAC_COMPILER != null) {
            passed = true;
            try {
                passed = JAVAC_COMPILER.getTask(null, null, null, options, null, JAVAC_COMPILER.getStandardFileManager(null, null, null).getJavaFileObjectsFromFiles(Arrays.asList(new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.java")))).call();
            }
            catch (Throwable throwable) {
                passed = false;
            }
            CompilerInvocationTests.assertFalse((String)"does not catch inappropriate -encoding option", (boolean)passed);
        }
    }

    public void test012_files_access_read() throws IOException {
        if (JAVAC_COMPILER == null) {
            System.out.println("No system java compiler available");
            return;
        }
        GetJavaFileForInputDetector customJavaFileManager = new GetJavaFileForInputDetector(JAVAC_COMPILER.getStandardFileManager(null, null, null));
        this.runTest(true, new String[]{"X.java", "public class X {}"}, customJavaFileManager, Arrays.asList("-d", OUTPUT_DIR), new String[]{"X.java"}, "", "", true, new String[]{"X.class"});
        CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        if (RUN_JAVAC && JAVAC_COMPILER != null) {
            customJavaFileManager.matchFound = false;
            CompilerInvocationTests.assertTrue((boolean)JAVAC_COMPILER.getTask(null, customJavaFileManager, null, Arrays.asList("-d", OUTPUT_DIR), null, customJavaFileManager.getJavaFileObjectsFromFiles(Arrays.asList(new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.java")))).call());
            CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        }
    }

    public void _test013_files_access_read() throws IOException {
        if (JAVAC_COMPILER == null) {
            System.out.println("No system java compiler available");
            return;
        }
        GetJavaFileForInputDetector customJavaFileManager = new GetJavaFileForInputDetector(COMPILER.getStandardFileManager(null, null, null), "Y.java", JavaFileObject.Kind.SOURCE);
        List<String> options = Arrays.asList("-d", OUTPUT_DIR, "-sourcepath", String.valueOf(OUTPUT_DIR) + File.separator + "src2");
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  Y y;\n}", "src2/Y.java", "public class Y {}"}, customJavaFileManager, options, new String[]{"src1/X.java"}, "", "", true, new String[]{"X.class"});
        CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        if (RUN_JAVAC && JAVAC_COMPILER != null) {
            customJavaFileManager.matchFound = false;
            CompilerInvocationTests.assertTrue((boolean)JAVAC_COMPILER.getTask(null, customJavaFileManager, null, options, null, customJavaFileManager.getJavaFileObjectsFromFiles(Arrays.asList(new File(String.valueOf(OUTPUT_DIR) + File.separator + "src1/X.java")))).call());
            CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        }
    }

    public void _test014_files_access_read() throws IOException {
        GetJavaFileForInputDetector customJavaFileManager = new GetJavaFileForInputDetector(COMPILER.getStandardFileManager(null, null, null), "Y.class", JavaFileObject.Kind.CLASS);
        List<String> options = Arrays.asList("-d", OUTPUT_DIR, "-classpath", OUTPUT_DIR);
        this.runTest(true, new String[]{"src2/Y.java", "public class Y {}"}, customJavaFileManager, options, new String[]{"src2/Y.java"}, "", "", true, new String[]{"Y.class"});
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  Y y;\n}"}, customJavaFileManager, options, new String[]{"src1/X.java"}, "", "", false, new String[]{"X.class"});
        CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        if (RUN_JAVAC && JAVAC_COMPILER != null) {
            customJavaFileManager.matchFound = false;
            CompilerInvocationTests.assertTrue((boolean)JAVAC_COMPILER.getTask(null, customJavaFileManager, null, options, null, customJavaFileManager.getJavaFileObjectsFromFiles(Arrays.asList(new File(String.valueOf(OUTPUT_DIR) + File.separator + "src1/X.java")))).call());
            CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        }
    }

    public void test015_files_access_write() throws IOException {
        GetJavaFileForOutputDetector customJavaFileManager = new GetJavaFileForOutputDetector(COMPILER.getStandardFileManager(null, null, null), "X.class");
        List<String> options = Arrays.asList("-d", OUTPUT_DIR);
        this.runTest(true, new String[]{"src/X.java", "public class X {\n}"}, customJavaFileManager, options, new String[]{"src/X.java"}, "", "", true, new String[]{"X.class"});
        CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        if (RUN_JAVAC && JAVAC_COMPILER != null) {
            customJavaFileManager.matchFound = false;
            CompilerInvocationTests.assertTrue((boolean)JAVAC_COMPILER.getTask(null, customJavaFileManager, null, options, null, customJavaFileManager.getJavaFileObjectsFromFiles(Arrays.asList(new File(String.valueOf(OUTPUT_DIR) + File.separator + "src/X.java")))).call());
            CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        }
    }

    public void test016_files_access_write() throws IOException {
        GetJavaFileForOutputDetector customJavaFileManager = new GetJavaFileForOutputDetector(COMPILER.getStandardFileManager(null, null, null), "Y.class");
        List<String> options = Arrays.asList("-sourcepath", String.valueOf(OUTPUT_DIR) + File.separator + "src2");
        this.runTest(true, new String[]{"src/X.java", "public class X {\n  Y y;\n}", "src2/Y.java", "public class Y {\n}"}, customJavaFileManager, options, new String[]{"src/X.java"}, "", "", true, new String[]{"src/X.class"});
        CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        if (RUN_JAVAC && JAVAC_COMPILER != null) {
            customJavaFileManager.matchFound = false;
            CompilerInvocationTests.assertTrue((boolean)JAVAC_COMPILER.getTask(null, customJavaFileManager, null, options, null, customJavaFileManager.getJavaFileObjectsFromFiles(Arrays.asList(new File(String.valueOf(OUTPUT_DIR) + File.separator + "src/X.java")))).call());
            CompilerInvocationTests.assertTrue((boolean)customJavaFileManager.matchFound);
        }
    }

    public void test017_sourcepath_without_destination() throws IOException {
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  Y y;\n}", "src2/Y.java", "public class Y {}"}, null, Arrays.asList("-d", String.valueOf(OUTPUT_DIR) + "/bin1", "-sourcepath", String.valueOf(OUTPUT_DIR) + "/src2"), new String[]{"src1/X.java"}, "", "", true, new String[]{"bin1/X.class", "bin1/Y.class"});
    }

    public void _test018_sourcepath_with_destination() throws IOException {
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  Y y;\n}", "src2/Y.java", "public class Y {}"}, null, Arrays.asList("-d", String.valueOf(OUTPUT_DIR) + "/bin1", "-sourcepath", "\"" + OUTPUT_DIR + "/src2\"[-d \"" + OUTPUT_DIR + "/bin2\"]"), new String[]{"src1/X.java"}, "", "", true, new String[]{"bin1/X.class", "bin2/Y.class"});
    }

    public void test019_sourcepath_without_destination() throws IOException {
        String sourceDirectoryName = String.valueOf(OUTPUT_DIR) + "/src2";
        File sourceFolder = new File(sourceDirectoryName);
        if (!sourceFolder.exists() && !sourceFolder.mkdirs()) {
            return;
        }
        StandardJavaFileManager ecjStandardJavaFileManager = COMPILER.getStandardFileManager(null, null, null);
        CompilerInvocationTests.assertTrue((boolean)ecjStandardJavaFileManager.handleOption("-sourcepath", Arrays.asList(String.valueOf(OUTPUT_DIR) + "/src2").iterator()));
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  Y y;\n}", "src2/Y.java", "public class Y {}"}, ecjStandardJavaFileManager, Arrays.asList("-d", String.valueOf(OUTPUT_DIR) + "/bin1"), new String[]{"src1/X.java"}, "", "", true, new String[]{"bin1/X.class", "bin1/Y.class"});
    }

    public void _test020_sourcepath_with_destination() throws IOException {
        StandardJavaFileManager ecjStandardJavaFileManager = COMPILER.getStandardFileManager(null, null, null);
        CompilerInvocationTests.assertTrue((boolean)ecjStandardJavaFileManager.handleOption("-sourcepath", Arrays.asList("\"" + OUTPUT_DIR + "/src2\"[-d \"" + OUTPUT_DIR + "/bin2\"]").iterator()));
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  Y y;\n}", "src2/Y.java", "public class Y {}"}, ecjStandardJavaFileManager, Arrays.asList("-d", String.valueOf(OUTPUT_DIR) + "/bin1"), new String[]{"src1/X.java"}, "", "", true, new String[]{"bin1/X.class", "bin2/Y.class"});
    }

    public void test021_output_streams() throws IOException {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        JavaCompiler.CompilationTask task = COMPILER.getTask((Writer)new PrintWriter(outBuffer), (JavaFileManager)COMPILER.getStandardFileManager(null, null, null), (DiagnosticListener)new AbstractCompilerToolTest.CompilerInvocationDiagnosticListener(new PrintWriter(errBuffer)), Arrays.asList("-v"), null, null);
        CompilerInvocationTests.assertTrue((boolean)task.call());
        Properties properties = new Properties();
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = Main.class.getResourceAsStream("messages.properties");
            properties.load(resourceAsStream);
        }
        finally {
            if (resourceAsStream != null) {
                resourceAsStream.close();
            }
        }
        CompilerInvocationTests.assertTrue((boolean)outBuffer.toString().startsWith(properties.getProperty("compiler.name")));
        CompilerInvocationTests.assertTrue((boolean)errBuffer.toString().isEmpty());
    }

    public void test022_output_streams() throws IOException {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        PrintStream systemOut = System.out;
        PrintStream systemErr = System.err;
        System.setOut(new PrintStream(outBuffer));
        System.setErr(new PrintStream(errBuffer));
        JavaCompiler.CompilationTask task = COMPILER.getTask(null, (JavaFileManager)COMPILER.getStandardFileManager(null, null, null), (DiagnosticListener)new AbstractCompilerToolTest.CompilerInvocationDiagnosticListener(new PrintWriter(errBuffer)), Arrays.asList("-v"), null, null);
        try {
            CompilerInvocationTests.assertTrue((boolean)task.call());
            CompilerInvocationTests.assertTrue((boolean)outBuffer.toString().isEmpty());
            CompilerInvocationTests.assertTrue((boolean)errBuffer.toString().startsWith("Eclipse Compiler for Java"));
        }
        finally {
            System.setOut(systemOut);
            System.setErr(systemErr);
        }
    }

    public void _test023_output_streams() throws IOException {
        this.runTest(false, new String[]{"X.java", "public class Y {}"}, null, Arrays.asList("-d", OUTPUT_DIR), new String[]{"X.java"}, "", "----------\n1. ERROR in X.java (at line 1)\n\tpublic class Y {}\n\t             ^\nThe public type Y must be defined in its own file\n----------\n1 problem (1 error)", true, null);
    }

    abstract class GetJavaFileDetector
    extends ForwardingStandardJavaFileManager<StandardJavaFileManager> {
        boolean matchFound;
        String discriminatingSuffix;

        GetJavaFileDetector(StandardJavaFileManager javaFileManager) {
            super(javaFileManager);
        }

        GetJavaFileDetector(StandardJavaFileManager javaFileManager, String discriminatingSuffix) {
            super(javaFileManager);
            this.discriminatingSuffix = discriminatingSuffix;
        }

        abstract JavaFileObject detector(JavaFileObject var1);

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
            return this.getJavaFileObjectsFromFiles(Arrays.asList(files));
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
            return this.getJavaFileObjectsFromStrings(Arrays.asList(names));
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            for (JavaFileObject file : super.getJavaFileObjectsFromFiles(files)) {
                result.add(this.detector(file));
            }
            return result;
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            for (JavaFileObject javaFileObject : this.getJavaFileObjectsFromStrings(names)) {
                result.add(this.detector(javaFileObject));
            }
            return result;
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            for (JavaFileObject file : super.list(location, packageName, kinds, recurse)) {
                result.add(this.detector(file));
            }
            return result;
        }
    }

    class GetJavaFileForInputDetector
    extends GetJavaFileDetector {
        private JavaFileObject.Kind discriminatingKind;

        GetJavaFileForInputDetector(StandardJavaFileManager javaFileManager) {
            super(javaFileManager);
            this.discriminatingKind = JavaFileObject.Kind.SOURCE;
        }

        GetJavaFileForInputDetector(StandardJavaFileManager javaFileManager, String discriminatingSuffix, JavaFileObject.Kind discriminatingKind) {
            super(javaFileManager, discriminatingSuffix);
            this.discriminatingKind = discriminatingKind;
        }

        @Override
        JavaFileObject detector(JavaFileObject original) {
            if (original != null && original.getKind() == this.discriminatingKind && (this.discriminatingSuffix == null || original.getName().endsWith(this.discriminatingSuffix))) {
                return new JavaFileInputDetector(original);
            }
            return original;
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            FileObject result = super.getFileForInput(location, packageName, relativeName);
            if (result instanceof JavaFileObject) {
                return this.detector((JavaFileObject)result);
            }
            return result;
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            return this.detector(super.getJavaFileForInput(location, className, kind));
        }

        class JavaFileInputDetector
        extends ForwardingJavaFileObject<JavaFileObject> {
            JavaFileInputDetector(JavaFileObject fileObject) {
                super(fileObject);
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                GetJavaFileForInputDetector.this.matchFound = true;
                return super.getCharContent(ignoreEncodingErrors);
            }

            @Override
            public InputStream openInputStream() throws IOException {
                GetJavaFileForInputDetector.this.matchFound = true;
                return super.openInputStream();
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                GetJavaFileForInputDetector.this.matchFound = true;
                return super.openReader(ignoreEncodingErrors);
            }
        }
    }

    class GetJavaFileForOutputDetector
    extends GetJavaFileDetector {
        GetJavaFileForOutputDetector(StandardJavaFileManager javaFileManager) {
            super(javaFileManager);
        }

        GetJavaFileForOutputDetector(StandardJavaFileManager javaFileManager, String discriminatingSuffix) {
            super(javaFileManager, discriminatingSuffix);
        }

        @Override
        JavaFileObject detector(JavaFileObject original) {
            if (original != null && original.getKind() == JavaFileObject.Kind.CLASS && (this.discriminatingSuffix == null || original.getName().endsWith(this.discriminatingSuffix))) {
                return new JavaFileOutputDetector(original);
            }
            return original;
        }

        @Override
        public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
            FileObject result = super.getFileForOutput(location, packageName, relativeName, sibling);
            if (result instanceof JavaFileObject) {
                return this.detector((JavaFileObject)result);
            }
            return result;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            return this.detector(super.getJavaFileForOutput(location, className, kind, sibling));
        }

        class JavaFileOutputDetector
        extends ForwardingJavaFileObject<JavaFileObject> {
            JavaFileOutputDetector(JavaFileObject fileObject) {
                super(fileObject);
            }

            @Override
            public OutputStream openOutputStream() throws IOException {
                GetJavaFileForOutputDetector.this.matchFound = true;
                return super.openOutputStream();
            }

            @Override
            public Writer openWriter() throws IOException {
                GetJavaFileForOutputDetector.this.matchFound = true;
                return super.openWriter();
            }
        }
    }

    class GetLocationDetector
    extends ForwardingStandardJavaFileManager<StandardJavaFileManager> {
        private JavaFileManager.Location match;
        private boolean matchFound;

        GetLocationDetector(StandardJavaFileManager javaFileManager, JavaFileManager.Location location) {
            super(javaFileManager);
            this.match = location;
        }

        @Override
        public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
            if (location == this.match) {
                this.matchFound = true;
            }
            return super.getLocation(location);
        }

        boolean matchFound() {
            return this.matchFound;
        }
    }

    class SetLocationDetector
    extends ForwardingStandardJavaFileManager<StandardJavaFileManager> {
        private JavaFileManager.Location match;
        private boolean matchFound;

        SetLocationDetector(StandardJavaFileManager javaFileManager, JavaFileManager.Location location) {
            super(javaFileManager);
            this.match = location;
        }

        @Override
        public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
            if (location == this.match) {
                this.matchFound = true;
            }
            super.setLocation(location, path);
        }

        boolean matchFound() {
            return this.matchFound;
        }
    }

    class SubstringDetector
    extends Logger {
        private String match;
        private boolean matchFound;

        SubstringDetector(String match) {
            super("SubstringDetector", null);
            this.match = match;
        }

        @Override
        public void log(LogRecord record) {
            if (!this.matchFound && record.getMessage().indexOf(this.match) != -1) {
                this.matchFound = true;
            }
        }

        boolean matchFound() {
            return this.matchFound;
        }
    }
}

