/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.compiler.tool.tests;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceLoader;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jdt.compiler.tool.tests.AbstractCompilerToolTest;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;

public class CompilerToolTests
extends TestCase {
    private static final boolean DEBUG = false;
    private static JavaCompiler Compiler;
    static final String[] ONE_ARG_OPTIONS;
    static final String[] ZERO_ARG_OPTIONS;
    static final String[] FAKE_ZERO_ARG_OPTIONS;

    static {
        ONE_ARG_OPTIONS = new String[]{"-cp", "-classpath", "-bootclasspath", "-sourcepath", "-extdirs", "-endorseddirs", "-d", "-encoding", "-source", "-target", "-maxProblems", "-log", "-repeat", "-processorpath", "-s", "-processor", "-classNames"};
        ZERO_ARG_OPTIONS = new String[]{"-1.3", "-1.4", "-1.5", "-1.6", "-1.7", "-7", "-7.0", "-6", "-6.0", "-5", "-5.0", "-deprecation", "-nowarn", "-warn:none", "-?:warn", "-g", "-g:lines", "-g:source", "-g:vars", "-g:lines,vars", "-g:none", "-preserveAllLocals", "-X", "-O", "-proceedOnError", "-proceedOnError:Fatal", "-verbose", "-referenceInfo", "-progress", "-time", "-noExit", "-inlineJSR", "-enableJavadoc", "-Xemacs", "-?", "-help", "-v", "-version", "-showversion", "-XprintRounds", "-XprintProcessorInfo", "-proc:none", "-proc:only", "-parameters", "-genericsignature"};
        FAKE_ZERO_ARG_OPTIONS = new String[]{"-Jignore", "-Xignore", "-Akey=value"};
    }

    public CompilerToolTests(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new CompilerToolTests("testInitializeJavaCompiler"));
        suite.addTest((Test)new CompilerToolTests("testFileManager"));
        suite.addTest((Test)new CompilerToolTests("testFileManager2"));
        suite.addTest((Test)new CompilerToolTests("testInferBinaryName"));
        suite.addTest((Test)new CompilerToolTests("testCheckOptions"));
        suite.addTest((Test)new CompilerToolTests("testCompilerOneClassWithSystemCompiler"));
        suite.addTest((Test)new CompilerToolTests("testCompilerOneClassWithEclipseCompiler"));
        suite.addTest((Test)new CompilerToolTests("testCompilerOneClassWithEclipseCompiler2"));
        suite.addTest((Test)new CompilerToolTests("testCompilerOneClassWithEclipseCompiler3"));
        suite.addTest((Test)new CompilerToolTests("testCompilerOneClassWithEclipseCompiler4"));
        suite.addTest((Test)new CompilerToolTests("testCompilerOneClassWithEclipseCompiler5"));
        suite.addTest((Test)new CompilerToolTests("testCompilerOneClassWithEclipseCompiler6"));
        suite.addTest((Test)new CompilerToolTests("testCompilerOneClassWithEclipseCompiler7"));
        suite.addTest((Test)new CompilerToolTests("testCleanUp"));
        return suite;
    }

    private void displayLocation(StandardJavaFileManager manager, StandardLocation standardLocation) {
        System.out.println(standardLocation.getName());
        Iterable<? extends File> location = manager.getLocation(standardLocation);
        if (location == null) {
            return;
        }
        for (File file : location) {
            System.out.println(file.getAbsolutePath());
        }
    }

    public void testInitializeJavaCompiler() {
        ServiceLoader<JavaCompiler> javaCompilerLoader = ServiceLoader.load(JavaCompiler.class);
        int compilerCounter = 0;
        for (JavaCompiler javaCompiler : javaCompilerLoader) {
            ++compilerCounter;
            if (!(javaCompiler instanceof EclipseCompiler)) continue;
            Compiler = javaCompiler;
        }
        CompilerToolTests.assertEquals((String)"Only one compiler available", (int)1, (int)compilerCounter);
    }

    public void testCheckOptions() {
        String option;
        CompilerToolTests.assertNotNull((String)"No compiler found", (Object)Compiler);
        String[] stringArray = ONE_ARG_OPTIONS;
        int n = ONE_ARG_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            option = stringArray[n2];
            CompilerToolTests.assertEquals((String)(String.valueOf(option) + " requires 1 argument"), (int)1, (int)Compiler.isSupportedOption(option));
            ++n2;
        }
        stringArray = ZERO_ARG_OPTIONS;
        n = ZERO_ARG_OPTIONS.length;
        n2 = 0;
        while (n2 < n) {
            option = stringArray[n2];
            CompilerToolTests.assertEquals((String)(String.valueOf(option) + " requires no argument"), (int)0, (int)Compiler.isSupportedOption(option));
            ++n2;
        }
        stringArray = FAKE_ZERO_ARG_OPTIONS;
        n = FAKE_ZERO_ARG_OPTIONS.length;
        n2 = 0;
        while (n2 < n) {
            option = stringArray[n2];
            CompilerToolTests.assertEquals((String)(String.valueOf(option) + " requires no argument"), (int)0, (int)Compiler.isSupportedOption(option));
            ++n2;
        }
    }

    public void testCompilerOneClassWithSystemCompiler() {
        File inputFile;
        String tmpFolder;
        JavaCompiler systemCompiler;
        block16: {
            systemCompiler = ToolProvider.getSystemJavaCompiler();
            if (systemCompiler == null) {
                System.out.println("No system java compiler available");
                return;
            }
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = systemCompiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ForwardingJavaFileManager<StandardJavaFileManager> forwardingJavaFileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(manager){

            @Override
            public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
                return super.getFileForInput(location, packageName, relativeName);
            }

            @Override
            public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                return super.getJavaFileForInput(location, className, kind);
            }

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                JavaFileObject javaFileForOutput = super.getJavaFileForOutput(location, className, kind, sibling);
                return javaFileForOutput;
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        JavaCompiler.CompilationTask task = systemCompiler.getTask(printWriter, forwardingJavaFileManager, null, options, null, units);
        CompilerToolTests.assertTrue((String)"Has location CLASS_OUPUT ", (boolean)forwardingJavaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT));
        Boolean result = task.call();
        if (!result.booleanValue()) {
            System.err.println("Compilation failed: " + stringWriter.getBuffer().toString());
            CompilerToolTests.assertTrue((String)"Compilation failed ", (boolean)false);
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
    }

    public void _testCompilerOneClassWithSystemCompiler2() {
        File inputFile;
        String tmpFolder;
        JavaCompiler systemCompiler;
        block16: {
            systemCompiler = ToolProvider.getSystemJavaCompiler();
            if (systemCompiler == null) {
                System.out.println("No system java compiler available");
                return;
            }
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ForwardingJavaFileManager<StandardJavaFileManager> forwardingJavaFileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(manager){

            @Override
            public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
                return super.getFileForInput(location, packageName, relativeName);
            }

            @Override
            public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                return super.getJavaFileForInput(location, className, kind);
            }

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                JavaFileObject javaFileForOutput = super.getJavaFileForOutput(location, className, kind, sibling);
                return javaFileForOutput;
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        JavaCompiler.CompilationTask task = systemCompiler.getTask(printWriter, manager, null, options, null, units);
        Boolean result = task.call();
        this.displayLocation(manager, StandardLocation.CLASS_PATH);
        this.displayLocation(manager, StandardLocation.PLATFORM_CLASS_PATH);
        if (!result.booleanValue()) {
            System.err.println("Compilation failed: " + stringWriter.getBuffer().toString());
            CompilerToolTests.assertTrue((String)"Compilation failed ", (boolean)false);
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
    }

    public void testCompilerOneClassWithEclipseCompiler() {
        File inputFile;
        String tmpFolder;
        block18: {
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ForwardingJavaFileManager<StandardJavaFileManager> forwardingJavaFileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(manager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                JavaFileObject javaFileForOutput = super.getJavaFileForOutput(location, className, kind, sibling);
                return javaFileForOutput;
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        JavaCompiler.CompilationTask task = Compiler.getTask(printWriter, forwardingJavaFileManager, null, options, null, units);
        CompilerToolTests.assertTrue((String)"Has no location CLASS_OUPUT", (boolean)forwardingJavaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT));
        Boolean result = task.call();
        printWriter.flush();
        printWriter.close();
        if (!result.booleanValue()) {
            System.err.println("Compilation failed: " + stringWriter.getBuffer().toString());
            CompilerToolTests.assertTrue((String)"Compilation failed ", (boolean)false);
        }
        ClassFileReader reader = null;
        try {
            reader = ClassFileReader.read((File)new File(tmpFolder, "p/X.class"), (boolean)true);
        }
        catch (ClassFormatException classFormatException) {
            CompilerToolTests.assertTrue((String)"Should not happen", (boolean)false);
        }
        catch (IOException iOException) {
            CompilerToolTests.assertTrue((String)"Should not happen", (boolean)false);
        }
        CompilerToolTests.assertNotNull((String)"No reader", (Object)reader);
        CompilerToolTests.assertEquals((String)"Wrong value", (long)0x320000L, (long)reader.getVersion());
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
    }

    public void testCompilerOneClassWithEclipseCompiler2() {
        File inputFile;
        String tmpFolder;
        block19: {
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ForwardingJavaFileManager<StandardJavaFileManager> forwardingJavaFileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(manager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                JavaFileObject javaFileForOutput = super.getJavaFileForOutput(location, className, kind, sibling);
                return javaFileForOutput;
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        options.add("-1.5");
        JavaCompiler.CompilationTask task = Compiler.getTask(printWriter, forwardingJavaFileManager, null, options, null, units);
        CompilerToolTests.assertTrue((String)"Has no location CLASS_OUPUT", (boolean)forwardingJavaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT));
        Boolean result = task.call();
        printWriter.flush();
        printWriter.close();
        if (!result.booleanValue()) {
            System.err.println("Compilation failed: " + stringWriter.getBuffer().toString());
            CompilerToolTests.assertTrue((String)"Compilation failed ", (boolean)false);
        }
        File outputFile = new File(tmpFolder, "p/X.class");
        CompilerToolTests.assertTrue((boolean)outputFile.exists());
        ClassFileReader reader = null;
        try {
            reader = ClassFileReader.read((File)outputFile);
        }
        catch (ClassFormatException classFormatException) {
            CompilerToolTests.assertTrue((String)"Should not happen", (boolean)false);
        }
        catch (IOException iOException) {
            CompilerToolTests.assertTrue((String)"Should not happen", (boolean)false);
        }
        CompilerToolTests.assertNotNull((String)"No reader", (Object)reader);
        CompilerToolTests.assertEquals((String)"Not a 1.5 .class file", (long)0x310000L, (long)reader.getVersion());
        stringWriter = new StringWriter();
        printWriter = new PrintWriter(stringWriter);
        task = Compiler.getTask(printWriter, forwardingJavaFileManager, null, options, null, units);
        CompilerToolTests.assertTrue((String)"Has no location CLASS_OUPUT", (boolean)forwardingJavaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT));
        result = task.call();
        printWriter.flush();
        printWriter.close();
        if (!result.booleanValue()) {
            System.err.println("Compilation failed: " + stringWriter.getBuffer().toString());
            CompilerToolTests.assertTrue((String)"Compilation failed ", (boolean)false);
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
    }

    public void testCompilerOneClassWithEclipseCompiler3() {
        File inputFile;
        String tmpFolder;
        block17: {
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ForwardingJavaFileManager<StandardJavaFileManager> forwardingJavaFileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(manager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                JavaFileObject javaFileForOutput = super.getJavaFileForOutput(location, className, kind, sibling);
                return javaFileForOutput;
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        JavaCompiler.CompilationTask task = Compiler.getTask(printWriter, manager, null, options, null, units);
        CompilerToolTests.assertTrue((String)"Has no location CLASS_OUPUT", (boolean)forwardingJavaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT));
        Boolean result = task.call();
        printWriter.flush();
        printWriter.close();
        if (!result.booleanValue()) {
            System.err.println("Compilation failed: " + stringWriter.getBuffer().toString());
            CompilerToolTests.assertTrue((String)"Compilation failed ", (boolean)false);
        }
        try {
            task.call();
            CompilerToolTests.assertTrue((String)"Should not get there", (boolean)false);
        }
        catch (IllegalStateException illegalStateException) {}
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
    }

    public void testCompilerOneClassWithEclipseCompiler4() throws IOException {
        File inputFile;
        String tmpFolder;
        JavaCompiler systemCompiler;
        block16: {
            systemCompiler = ToolProvider.getSystemJavaCompiler();
            if (systemCompiler == null) {
                System.out.println("No system java compiler available");
                return;
            }
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        StandardJavaFileManager manager = systemCompiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        JavaCompiler.CompilationTask task = Compiler.getTask(null, null, null, options, null, units);
        Boolean result = task.call();
        printWriter.flush();
        printWriter.close();
        if (!result.booleanValue()) {
            System.err.println("Compilation failed: " + stringWriter.getBuffer().toString());
            CompilerToolTests.assertTrue((String)"Compilation failed ", (boolean)false);
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
        manager.close();
    }

    public void testCompilerOneClassWithEclipseCompiler5() {
        File inputFile;
        String tmpFolder;
        block15: {
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X extends File {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        PrintWriter err = new PrintWriter(errBuffer);
        AbstractCompilerToolTest.CompilerInvocationDiagnosticListener compilerInvocationDiagnosticListener = new AbstractCompilerToolTest.CompilerInvocationDiagnosticListener(err);
        JavaCompiler.CompilationTask task = Compiler.getTask(null, manager, compilerInvocationDiagnosticListener, options, null, units);
        Boolean result = task.call();
        err.flush();
        err.close();
        CompilerToolTests.assertFalse((boolean)errBuffer.toString().isEmpty());
        CompilerToolTests.assertTrue((compilerInvocationDiagnosticListener.kind != 0 ? 1 : 0) != 0);
        if (!result.booleanValue()) {
            CompilerToolTests.assertFalse((String)"Compilation did not fail", (boolean)false);
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
    }

    public void testCompilerOneClassWithEclipseCompiler6() {
        File inputFile;
        File packageFolder;
        String tmpFolder;
        block16: {
            tmpFolder = System.getProperty("java.io.tmpdir");
            packageFolder = new File(tmpFolder, "p");
            if (!packageFolder.mkdirs()) {
                return;
            }
            inputFile = new File(packageFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X extends File {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        options.add("-sourcepath");
        options.add(tmpFolder);
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        PrintWriter err = new PrintWriter(errBuffer);
        AbstractCompilerToolTest.CompilerInvocationDiagnosticListener compilerInvocationDiagnosticListener = new AbstractCompilerToolTest.CompilerInvocationDiagnosticListener(err){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                JavaFileObject source = diagnostic.getSource();
                CompilerToolTests.assertNotNull((String)"No source", (Object)source);
                super.report(diagnostic);
            }
        };
        JavaCompiler.CompilationTask task = Compiler.getTask(null, manager, compilerInvocationDiagnosticListener, options, null, units);
        Boolean result = task.call();
        err.flush();
        err.close();
        CompilerToolTests.assertFalse((boolean)errBuffer.toString().isEmpty());
        CompilerToolTests.assertTrue((compilerInvocationDiagnosticListener.kind != 0 ? 1 : 0) != 0);
        if (!result.booleanValue()) {
            CompilerToolTests.assertFalse((String)"Compilation did not fail", (boolean)false);
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)packageFolder.delete());
    }

    public void testCompilerOneClassWithEclipseCompiler7() {
        File inputFile;
        String tmpFolder;
        block15: {
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X extends File {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        options.add("-sourcepath");
        options.add(tmpFolder);
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        PrintWriter err = new PrintWriter(errBuffer);
        AbstractCompilerToolTest.CompilerInvocationDiagnosticListener compilerInvocationDiagnosticListener = new AbstractCompilerToolTest.CompilerInvocationDiagnosticListener(err){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                JavaFileObject source = diagnostic.getSource();
                CompilerToolTests.assertNotNull((String)"No source", (Object)source);
                super.report(diagnostic);
            }
        };
        JavaCompiler.CompilationTask task = Compiler.getTask(null, manager, compilerInvocationDiagnosticListener, options, null, units);
        Boolean result = task.call();
        err.flush();
        err.close();
        CompilerToolTests.assertFalse((boolean)errBuffer.toString().isEmpty());
        CompilerToolTests.assertTrue((compilerInvocationDiagnosticListener.kind != 0 ? 1 : 0) != 0);
        if (!result.booleanValue()) {
            CompilerToolTests.assertFalse((String)"Compilation did not fail", (boolean)false);
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
    }

    public void testInferBinaryName() {
        File inputFile;
        File dir;
        block17: {
            String tmpFolder = System.getProperty("java.io.tmpdir");
            dir = new File(tmpFolder, "src" + System.currentTimeMillis());
            dir.mkdirs();
            inputFile = new File(dir, "test.txt");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("This is not a valid Java file");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            StandardJavaFileManager fileManager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
            ArrayList<File> fins = new ArrayList<File>();
            fins.add(dir);
            StandardLocation sourceLoc = StandardLocation.SOURCE_PATH;
            fileManager.setLocation(sourceLoc, fins);
            HashSet<JavaFileObject.Kind> fileTypes = new HashSet<JavaFileObject.Kind>();
            fileTypes.add(JavaFileObject.Kind.OTHER);
            Iterable<JavaFileObject> compilationUnits = fileManager.list(sourceLoc, "", fileTypes, true);
            JavaFileObject invalid = null;
            Iterator<JavaFileObject> iterator = compilationUnits.iterator();
            if (iterator.hasNext()) {
                JavaFileObject javaFileObject;
                invalid = javaFileObject = iterator.next();
            }
            String inferredName = fileManager.inferBinaryName(sourceLoc, invalid);
            fileManager.close();
            CompilerToolTests.assertNull((String)"Should return null for invalid file", (Object)inferredName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)dir.delete());
    }

    public void testFileManager() {
        File inputFile;
        File dir;
        block19: {
            String tmpFolder = System.getProperty("java.io.tmpdir");
            dir = new File(tmpFolder, "src" + System.currentTimeMillis());
            dir.mkdirs();
            inputFile = new File(dir, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("public class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            StandardJavaFileManager fileManager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
            ArrayList<File> fins = new ArrayList<File>();
            fins.add(dir);
            StandardLocation sourceLoc = StandardLocation.SOURCE_PATH;
            fileManager.setLocation(sourceLoc, fins);
            HashSet<JavaFileObject.Kind> fileTypes = new HashSet<JavaFileObject.Kind>();
            fileTypes.add(JavaFileObject.Kind.SOURCE);
            Iterable<JavaFileObject> compilationUnits = fileManager.list(sourceLoc, "", fileTypes, true);
            Iterator<JavaFileObject> it = compilationUnits.iterator();
            StringBuilder builder = new StringBuilder();
            while (it.hasNext()) {
                JavaFileObject next = it.next();
                String name = next.getName();
                name = name.replace('\\', '/');
                int lastIndexOf = name.lastIndexOf(47);
                builder.append(name.substring(lastIndexOf + 1));
            }
            CompilerToolTests.assertEquals((String)"Wrong contents", (String)"X.java", (String)String.valueOf(builder));
            ArrayList<File> files = new ArrayList<File>();
            files.add(dir);
            try {
                fileManager.getJavaFileObjectsFromFiles(files);
                CompilerToolTests.fail((String)"IllegalArgumentException should be thrown but not");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            fileManager.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)dir.delete());
    }

    public void testFileManager2() {
        File inputFile2;
        File inputFile;
        File dir2;
        File dir;
        block32: {
            BufferedWriter writer;
            block30: {
                String tmpFolder = System.getProperty("java.io.tmpdir");
                dir = new File(tmpFolder, "src" + System.currentTimeMillis());
                dir.mkdirs();
                dir2 = new File(dir, "src2");
                dir2.mkdirs();
                inputFile = new File(dir, "X.java");
                writer = null;
                try {
                    try {
                        writer = new BufferedWriter(new FileWriter(inputFile));
                        writer.write("public class X {}");
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            inputFile2 = new File(dir2, "X2.java");
            writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile2));
                    writer.write("public class X2 {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            StandardJavaFileManager fileManager = Compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
            ArrayList<File> fins = new ArrayList<File>();
            fins.add(dir);
            StandardLocation sourceLoc = StandardLocation.SOURCE_PATH;
            fileManager.setLocation(sourceLoc, fins);
            HashSet<JavaFileObject.Kind> fileTypes = new HashSet<JavaFileObject.Kind>();
            fileTypes.add(JavaFileObject.Kind.SOURCE);
            Iterable<JavaFileObject> compilationUnits = fileManager.list(sourceLoc, "", fileTypes, true);
            Iterator<JavaFileObject> it = compilationUnits.iterator();
            ArrayList<String> names = new ArrayList<String>();
            while (it.hasNext()) {
                JavaFileObject next = it.next();
                String name = next.getName();
                name = name.replace('\\', '/');
                int lastIndexOf = name.lastIndexOf(47);
                names.add(name.substring(lastIndexOf + 1));
            }
            Collections.sort(names);
            CompilerToolTests.assertEquals((String)"Wrong contents", (String)"[X.java, X2.java]", (String)((Object)names).toString());
            fileManager.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile2.delete());
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)dir2.delete());
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
        CompilerToolTests.assertTrue((String)"delete failed", (boolean)dir.delete());
    }

    public void testCleanUp() {
        Compiler = null;
    }
}

