/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IMethodInfo;

public class AbstractMethodTests
extends BuilderTests {
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            int length2;
            IResource resource1 = (IResource)o1;
            IResource resource2 = (IResource)o2;
            String path1 = resource1.getFullPath().toString();
            String path2 = resource2.getFullPath().toString();
            int length1 = path1.length();
            if (length1 != (length2 = path2.length())) {
                return length1 - length2;
            }
            return path1.toString().compareTo(path2.toString());
        }
    };
    static /* synthetic */ Class class$0;

    public AbstractMethodTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.AbstractMethodTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return AbstractMethodTests.buildTestSuite((Class)clazz);
    }

    public void test001() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(project1Path, "");
        env.setOutputFolder(project1Path, "bin");
        IPath root1 = env.addPackageFragmentRoot(project1Path, "src");
        env.addClass(root1, "p1", "IX", "package p1;\npublic interface IX {\n   public abstract void foo(IX x);\n}\n");
        IPath classX = env.addClass(root1, "p2", "X", "package p2;\nimport p1.*;\npublic abstract class X implements IX {\n   public void foo(IX x){}\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        env.removePackageFragmentRoot(project2Path, "");
        IPath root2 = env.addPackageFragmentRoot(project2Path, "src");
        env.setOutputFolder(project2Path, "bin");
        IPath classY = env.addClass(root2, "p3", "Y", "package p3;\nimport p2.*;\npublic class Y extends X{\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClass(root1, "p2", "X", "package p2;\nimport p1.*;\npublic abstract class X implements IX {\n   public void foo(I__X x){}\n}\n");
        this.incrementalBuild();
        this.expectingOnlySpecificProblemFor(classX, new Problem("X.foo(I__X)", "I__X cannot be resolved to a type", classX, 84, 88, 40, 2));
        this.expectingOnlySpecificProblemFor(classY, new Problem("Y", "The type Y must implement the inherited abstract method IX.foo(IX)", classY, 38, 39, 50, 2));
        env.addClass(root1, "p2", "X", "package p2;\nimport p1.*;\npublic abstract class X implements IX {\n   public void foo(IX x){}\n}\n");
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void test002() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.getJavaProject(project1Path).setOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
        env.removePackageFragmentRoot(project1Path, "");
        env.setOutputFolder(project1Path, "bin");
        IPath root1 = env.addPackageFragmentRoot(project1Path, "src");
        env.addClass(root1, "p1", "IX", "package p1;\npublic interface IX {\n   public abstract void foo(IX x);\n}\n");
        IPath classX = env.addClass(root1, "p2", "X", "package p2;\nimport p1.*;\npublic abstract class X implements IX {\n   public void foo(IX x){}\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        env.removePackageFragmentRoot(project2Path, "");
        IPath root2 = env.addPackageFragmentRoot(project2Path, "src");
        env.setOutputFolder(project2Path, "bin");
        IPath classY = env.addClass(root2, "p3", "Y", "package p3;\nimport p2.*;\npublic class Y extends X{\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClass(root1, "p2", "X", "package p2;\nimport p1.*;\npublic abstract class X implements IX {\n   public void foo(I__X x){}\n}\n");
        this.incrementalBuild();
        this.expectingOnlySpecificProblemFor(classX, new Problem("X.foo(I__X)", "I__X cannot be resolved to a type", classX, 84, 88, 40, 2));
        this.expectingOnlySpecificProblemFor(classY, new Problem("Y", "The type Y must implement the inherited abstract method IX.foo(IX)", classY, 38, 39, 50, 2));
        env.addClass(root1, "p2", "X", "package p2;\nimport p1.*;\npublic abstract class X implements IX {\n   public void foo(IX x){}\n}\n");
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void test003() throws JavaModelException {
        IClassFileReader classFileReader;
        block16: {
            IPath project1Path = env.addProject("Project1");
            env.addExternalJars(project1Path, Util.getJavaClassLibs());
            env.getJavaProject(project1Path).setOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            env.removePackageFragmentRoot(project1Path, "");
            env.setOutputFolder(project1Path, "bin");
            IPath root1 = env.addPackageFragmentRoot(project1Path, "src");
            env.addClass(root1, "p1", "IX", "package p1;\npublic interface IX {\n   public abstract void foo(IX x);\n}\n");
            env.addClass(root1, "p2", "X", "package p2;\nimport p1.*;\npublic abstract class X implements IX {\n}\n");
            this.fullBuild();
            this.expectingNoProblems();
            IJavaProject project = env.getJavaProject(project1Path);
            IRegion region = JavaCore.newRegion();
            region.add((IJavaElement)project);
            IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
            AbstractMethodTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
            Arrays.sort(resources, COMPARATOR);
            String actualOutput = this.getResourceOuput(resources);
            String expectedOutput = "/Project1/bin/p2/X.class\n/Project1/bin/p1/IX.class\n";
            AbstractMethodTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
            AbstractMethodTests.assertEquals((String)"Wrong type", (int)1, (int)resources[0].getType());
            IFile classFile = (IFile)resources[0];
            classFileReader = null;
            InputStream stream = null;
            try {
                try {
                    stream = classFile.getContents();
                    classFileReader = ToolFactory.createDefaultClassFileReader((InputStream)stream, (int)65535);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        AbstractMethodTests.assertNotNull((String)"No class file reader", (Object)classFileReader);
        IMethodInfo[] methodInfos = classFileReader.getMethodInfos();
        IMethodInfo found = null;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            IMethodInfo methodInfo = methodInfos[i];
            if (CharOperation.equals((char[])methodInfo.getName(), (char[])"foo".toCharArray())) {
                found = methodInfo;
                break;
            }
            ++i;
        }
        AbstractMethodTests.assertNotNull((String)"No method found", found);
        AbstractMethodTests.assertTrue((String)"Not a synthetic method", (boolean)found.isSynthetic());
    }

    private String getResourceOuput(IResource[] resources) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        int i = 0;
        int max = resources.length;
        while (i < max) {
            writer.println(resources[i].getFullPath().toString());
            ++i;
        }
        writer.flush();
        writer.close();
        return Util.convertToIndependantLineDelimiter((String)String.valueOf(stringWriter));
    }
}

