/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;

public class IncrementalTests
extends BuilderTests {
    static /* synthetic */ Class class$0;

    public IncrementalTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.IncrementalTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return IncrementalTests.buildTestSuite((Class)clazz);
    }

    public void testAddDuplicateSecondaryType() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "C", "package p;\t\npublic class C {}\t\nclass CC {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        IPath pathToD = env.addClass(root, "p", "D", "package p;\t\npublic class D {}\t\nclass CC {}");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(pathToD, "Problem : The type CC is already defined [ resource : </Project/src/p/D.java> range : <37,39> category : <-1> severity : <2>]");
        this.expectingSpecificProblemsFor(pathToD, new Problem[]{new Problem("", "The type CC is already defined", pathToD, 37, 39, -1, 2)});
    }

    public void testDefaultPackage() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        env.addClass(projectPath, "", "A", "public class A {}");
        env.addClass(projectPath, "", "B", "public class B {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(projectPath, "", "B", "public class B {A a;}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testDefaultPackage2() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "bin");
        env.addClass(projectPath, "", "A", "public class A {}");
        env.addClass(projectPath, "", "B", "public class B {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(projectPath, "", "B", "public class B {A a;}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testNewJCL() {
        IPath projectPath = env.addProject("Project");
        IPath root = env.getPackageFragmentRootPath(projectPath, "");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClass(root, "java.lang", "Object", "package java.lang;\npublic class Object {\n}\n");
        this.incrementalBuild();
        this.expectingNoProblems();
        env.addClass(root, "java.lang", "Throwable", "package java.lang;\npublic class Throwable {\n}\n");
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void testRenameMainType() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath pathToA = env.addClass(root, "p", "A", "package p;\t\npublic class A {}");
        IPath pathToB = env.addClass(root, "p", "B", "package p;\t\npublic class B extends A {}");
        IPath pathToC = env.addClass(root, "p", "C", "package p;\t\npublic class C extends B {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        pathToA = env.addClass(root, "p", "A", "package p;\t\npublic class _A {}");
        pathToC = env.addClass(root, "p", "C", "package p;\t\npublic class C extends B { }");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(new IPath[]{pathToA, pathToB, pathToC}, "Problem : A cannot be resolved to a type [ resource : </Project/src/p/B.java> range : <35,36> category : <40> severity : <2>]\nProblem : The hierarchy of the type C is inconsistent [ resource : </Project/src/p/C.java> range : <25,26> category : <40> severity : <2>]\nProblem : The public type _A must be defined in its own file [ resource : </Project/src/p/A.java> range : <25,27> category : <40> severity : <2>]");
        this.expectingSpecificProblemFor(pathToA, new Problem("_A", "The public type _A must be defined in its own file", pathToA, 25, 27, 40, 2));
        this.expectingSpecificProblemFor(pathToB, new Problem("B", "A cannot be resolved to a type", pathToB, 35, 36, 40, 2));
        this.expectingSpecificProblemFor(pathToC, new Problem("C", "The hierarchy of the type C is inconsistent", pathToC, 25, 26, 40, 2));
        pathToA = env.addClass(root, "p", "A", "package p;\t\npublic class A {}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testRemoveSecondaryType() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "AA", "package p;\t\npublic class AA {}\t\nclass AZ {}");
        IPath pathToAB = env.addClass(root, "p", "AB", "package p;\t\npublic class AB extends AZ {}");
        env.addClass(root, "p", "BB", "package p;\t\npublic class BB {\t\n\tvoid foo(){\t\n\t\tSystem.out.println(new AB());\t\n\t\tSystem.out.println(new ZA());\t\n\t}\t\n}");
        env.addClass(root, "p", "ZZ", "package p;\t\npublic class ZZ {}\t\nclass ZA {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p", "AA", "package p;\t\npublic class AA {}");
        env.addClass(root, "p", "BB", "package p;\t\npublic class BB {\t\n\tvoid foo() {\t\n\t\tSystem.out.println(new AB());\t\n\t\tSystem.out.println(new ZA());\t\n\t}\t\n}");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(pathToAB, "Problem : AZ cannot be resolved to a type [ resource : </Project/src/p/AB.java> range : <36,38> category : <40> severity : <2>]");
        this.expectingSpecificProblemFor(pathToAB, new Problem("AB", "AZ cannot be resolved to a type", pathToAB, 36, 38, 40, 2));
        env.addClass(root, "p", "AA", "package p;\t\npublic class AA {}\t\nclass AZ {}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testRemoveSecondaryType2() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "AA", "package p;\t\npublic class AA {}\t\nclass AZ {}");
        env.addClass(root, "p", "AB", "package p;\t\npublic class AB extends AZ {}");
        IPath pathToBB = env.addClass(root, "p", "BB", "package p;\t\npublic class BB {\t\n\tvoid foo(){\t\n\t\tSystem.out.println(new AB());\t\n\t\tSystem.out.println(new ZA());\t\n\t}\t\n}");
        env.addClass(root, "p", "ZZ", "package p;\t\npublic class ZZ {}\t\nclass ZA {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p", "ZZ", "package p;\t\npublic class ZZ {}");
        pathToBB = env.addClass(root, "p", "BB", "package p;\t\npublic class BB {\t\n\tvoid foo() {\t\n\t\tSystem.out.println(new AB());\t\n\t\tSystem.out.println(new ZA());\t\n\t}\t\n}");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(pathToBB, "Problem : ZA cannot be resolved to a type [ resource : </Project/src/p/BB.java> range : <104,106> category : <40> severity : <2>]");
        this.expectingSpecificProblemFor(pathToBB, new Problem("BB.foo()", "ZA cannot be resolved to a type", pathToBB, 104, 106, 40, 2));
        env.addClass(root, "p", "ZZ", "package p;\t\npublic class ZZ {}\t\nclass ZA {}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMoveSecondaryType() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "AA", "package p; \npublic class AA {} \nclass AZ {}");
        env.addClass(root, "p", "AB", "package p; \npublic class AB extends AZ {}");
        env.addClass(root, "p", "ZZ", "package p; \npublic class ZZ {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p", "AA", "package p; \npublic class AA {}");
        env.addClass(root, "p", "ZZ", "package p; \npublic class ZZ {} \nclass AZ {}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p", "AA", "package p; \npublic class AA {} \nclass AZ {}");
        env.addClass(root, "p", "ZZ", "package p; \npublic class ZZ {}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMoveMemberType() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "AA", "package p; \npublic class AA {} \nclass AZ {static class M{}}");
        env.addClass(root, "p", "AB", "package p; \nimport p.AZ.*; \nimport p.ZA.*; \npublic class AB extends M {}");
        env.addClass(root, "p", "ZZ", "package p; \npublic class ZZ {} \nclass ZA {}");
        this.fullBuild(projectPath);
        this.expectingOnlySpecificProblemsFor(root, new Problem[]{new Problem("", "The import p.ZA is never used", (IPath)new Path("/Project/src/p/AB.java"), 35, 39, 120, 1)});
        env.addClass(root, "p", "AA", "package p; \npublic class AA {} \nclass AZ {}");
        env.addClass(root, "p", "ZZ", "package p; \npublic class ZZ {} \nclass ZA {static class M{}}");
        this.incrementalBuild(projectPath);
        this.expectingOnlySpecificProblemsFor(root, new Problem[]{new Problem("", "The import p.AZ is never used", (IPath)new Path("/Project/src/p/AB.java"), 19, 23, 120, 1)});
        env.addClass(root, "p", "AA", "package p; \npublic class AA {} \nclass AZ {static class M{}}");
        env.addClass(root, "p", "ZZ", "package p; \npublic class ZZ {} \nclass ZA {}");
        this.incrementalBuild(projectPath);
        this.expectingOnlySpecificProblemsFor(root, new Problem[]{new Problem("", "The import p.ZA is never used", (IPath)new Path("/Project/src/p/AB.java"), 35, 39, 120, 1)});
    }

    public void testMovePackage() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        Path[] exclusionPatterns = new Path[]{new Path("src2/")};
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1", (IPath[])exclusionPatterns, null);
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src1/src2");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(src1, "p", "A", "package p; \npublic class A {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.removePackage(src1, "p");
        env.addClass(src2, "p", "A", "package p; \npublic class A {}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMovePackage2() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "src");
        IPath other = env.addFolder(projectPath, "other");
        env.setOutputFolder(projectPath, "bin");
        IPath classA = env.addClass(src, "p", "A", "package p; \npublic class A extends Missing {}");
        IPath classB = env.addClass(src, "p.q", "B", "package p.q; \npublic class B extends Missing {}");
        this.fullBuild(projectPath);
        this.expectingSpecificProblemFor(classA, new Problem("", "Missing cannot be resolved to a type", (IPath)new Path("/Project/src/p/A.java"), 35, 42, 40, 2));
        this.expectingSpecificProblemFor(classB, new Problem("", "Missing cannot be resolved to a type", (IPath)new Path("/Project/src/p/q/B.java"), 37, 44, 40, 2));
        try {
            IProject p = env.getProject(projectPath);
            IFolder pFolder = p.getWorkspace().getRoot().getFolder(classA.removeLastSegments(1));
            pFolder.move(other.append("p"), true, false, null);
        }
        catch (CoreException e) {
            env.handle((Exception)((Object)e));
        }
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMemberTypeFromClassFile() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "A", "package p; \npublic class A extends Z {M[] m;}");
        env.addClass(root, "p", "B", "package p; \npublic class B {A a; E e; \nvoid foo() { System.out.println(a.m); }}");
        env.addClass(root, "p", "E", "package p; \npublic class E extends Z { \nvoid foo() { System.out.println(new M()); }}");
        env.addClass(root, "p", "Z", "package p; \npublic class Z {static class M {}}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p", "B", "package p; \npublic class B {A a; E e; \nvoid foo( ) { System.out.println(a.m); }}");
        env.addClass(root, "p", "E", "package p; \npublic class E extends Z { \nvoid foo( ) { System.out.println(new M()); }}");
        env.addClass(root, "p", "Z", "package p; \npublic class Z { static class M {} }");
        int previous = AbstractImageBuilder.MAX_AT_ONCE;
        AbstractImageBuilder.MAX_AT_ONCE = 1;
        this.incrementalBuild(projectPath);
        AbstractImageBuilder.MAX_AT_ONCE = previous;
        this.expectingNoProblems();
    }

    public void testMemberTypeOfOtherProject() throws JavaModelException {
        IPath projectPath1 = env.addProject("Project1", "1.5");
        env.addExternalJars(projectPath1, Util.getJavaClassLibs());
        IPath projectPath2 = env.addProject("Project2", "1.5");
        env.addExternalJars(projectPath2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath1, "");
        IPath root1 = env.addPackageFragmentRoot(projectPath1, "src");
        env.setOutputFolder(projectPath1, "bin");
        env.removePackageFragmentRoot(projectPath2, "");
        IPath root2 = env.addPackageFragmentRoot(projectPath2, "src");
        IPath output2 = env.setOutputFolder(projectPath2, "bin");
        env.addClassFolder(projectPath1, output2, true);
        env.addRequiredProject(projectPath2, projectPath1);
        env.addClass(root1, "pB", "BaseClass", "package pB; \npublic class BaseClass {\n  public static class Builder <T> {\n    public Builder(T t) {\n    }\n  }\n}\n");
        env.addClass(root1, "pR", "ReferencingClass", "package pR; \nimport pD.DerivedClass.Builder;\npublic class ReferencingClass {\n   Builder<String> builder = new Builder<String>(null);\n}\n");
        env.addClass(root2, "pD", "DerivedClass", "package pD; \npublic class DerivedClass extends pB.BaseClass {\n  public static class Builder<T> extends pB.BaseClass.Builder <T> {\n    public Builder(T t) {\n\t\tsuper(t);\n    }\n  }\n}\n");
        int previous = AbstractImageBuilder.MAX_AT_ONCE;
        this.fullBuild();
        AbstractImageBuilder.MAX_AT_ONCE = 1;
        this.cleanBuild();
        this.fullBuild();
        this.cleanBuild("Project1");
        this.fullBuild(projectPath1);
        AbstractImageBuilder.MAX_AT_ONCE = previous;
        this.expectingNoProblems();
    }

    public void test$InTypeName() throws JavaModelException {
        IPath projectPath1 = env.addProject("Project1", "1.5");
        env.addExternalJars(projectPath1, Util.getJavaClassLibs());
        IPath projectPath2 = env.addProject("Project2", "1.5");
        env.addExternalJars(projectPath2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath1, "");
        IPath root1 = env.addPackageFragmentRoot(projectPath1, "src");
        env.setOutputFolder(projectPath1, "bin");
        env.removePackageFragmentRoot(projectPath2, "");
        IPath root2 = env.addPackageFragmentRoot(projectPath2, "src");
        IPath output2 = env.setOutputFolder(projectPath2, "bin");
        env.addClassFolder(projectPath1, output2, true);
        env.addRequiredProject(projectPath2, projectPath1);
        env.addClass(root1, "pB", "Builder$a", "package pB; \npublic class Builder$a<T> {\n    public Builder$a(T t) {\n    }\n}\n");
        env.addClass(root1, "pR", "ReferencingClass", "package pR; \nimport pD.DerivedClass$a;\npublic class ReferencingClass {\n   DerivedClass$a<String> builder = new DerivedClass$a<String>(null);\n}\n");
        env.addClass(root2, "pD", "DerivedClass$a", "package pD; \npublic class DerivedClass$a<T> extends pB.Builder$a<T> {\n    public DerivedClass$a(T t) {\n\t\tsuper(t);\n    }\n}\n");
        int previous = AbstractImageBuilder.MAX_AT_ONCE;
        this.fullBuild();
        AbstractImageBuilder.MAX_AT_ONCE = 1;
        this.cleanBuild();
        this.fullBuild();
        this.cleanBuild("Project1");
        this.fullBuild(projectPath1);
        AbstractImageBuilder.MAX_AT_ONCE = previous;
        this.expectingNoProblems();
    }

    public void testObjectWithSuperInterfaces() throws JavaModelException {
        try {
            IPath projectPath = env.addProject("Project");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            env.removePackageFragmentRoot(projectPath, "");
            IPath root = env.addPackageFragmentRoot(projectPath, "src");
            env.setOutputFolder(projectPath, "bin");
            env.addClass(root, "java.lang", "Object", "package java.lang; \npublic class Object implements I {} \ninterface I {}\t\n");
            this.fullBuild(projectPath);
            this.expectingOnlySpecificProblemsFor(root, new Problem[]{new Problem("", "The type java.lang.Object cannot have a superclass or superinterfaces", (IPath)new Path("/Project/src/java/lang/Object.java"), 33, 39, 60, 2)});
            env.addClass(root, "p", "X", "package p; \npublic class X {}\n");
            this.incrementalBuild(projectPath);
            this.expectingOnlySpecificProblemsFor(root, new Problem[]{new Problem("", "The type java.lang.Object cannot have a superclass or superinterfaces", (IPath)new Path("/Project/src/java/lang/Object.java"), 33, 39, 60, 2)});
            env.addClass(root, "p", "Y", "package p; \npublic class Y extends X {}\n");
            this.incrementalBuild(projectPath);
            this.expectingOnlySpecificProblemsFor(root, new Problem[]{new Problem("", "The type java.lang.Object cannot have a superclass or superinterfaces", (IPath)new Path("/Project/src/java/lang/Object.java"), 33, 39, 60, 2)});
        }
        catch (StackOverflowError e) {
            IncrementalTests.assertTrue((String)"Infinite loop in cycle detection", (boolean)false);
            e.printStackTrace();
        }
    }

    public void _testWrongCompilationUnitLocation() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        IPath x = env.addClass(root, "", "X", "public class X {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(bin.append("X.class"));
        env.addClass(root, "", "X", "package p1;\npublic class X {\n}\n");
        this.incrementalBuild();
        this.expectingProblemsFor(x, "???");
        this.expectingNoPresenceOf(bin.append("X.class"));
    }

    public void testMemberTypeCollisionWithBinary() throws JavaModelException {
        int max = AbstractImageBuilder.MAX_AT_ONCE;
        try {
            IPath projectPath = env.addProject("Project");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            env.removePackageFragmentRoot(projectPath, "");
            IPath root = env.addPackageFragmentRoot(projectPath, "src");
            env.setOutputFolder(projectPath, "bin");
            env.addClass(root, "", "A", "public class A {\n\tObject foo(B b) { return b.i; }\n}");
            env.addClass(root, "", "B", "public class B {\n\tI.InnerType i;\n}");
            env.addClass(root, "", "I", "public interface I {\n\tinterface InnerType {}\n}");
            this.fullBuild(projectPath);
            this.expectingNoProblems();
            AbstractImageBuilder.MAX_AT_ONCE = 1;
            env.addClass(root, "", "A", "public class A {\n\tObject foo(B b) { return b.i; }\n}");
            env.addClass(root, "", "I", "public interface I {\n\tinterface InnerType {}\n}");
            this.incrementalBuild(projectPath);
            this.expectingNoProblems();
        }
        finally {
            AbstractImageBuilder.MAX_AT_ONCE = max;
        }
    }

    public void testMemberTypeCollisionWithBinary2() throws JavaModelException {
        int max = AbstractImageBuilder.MAX_AT_ONCE;
        try {
            IPath projectPath = env.addProject("Project");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            env.removePackageFragmentRoot(projectPath, "");
            IPath src1 = env.addPackageFragmentRoot(projectPath, "src1");
            IPath bin1 = env.setOutputFolder(projectPath, "bin1");
            env.addClass(src1, "p1", "NoSource", "package p1;\t\nimport p2.Foo;\npublic class NoSource {\n\tpublic NoSource(Foo.Bar b) {}\n}");
            IPath src2 = env.addPackageFragmentRoot(projectPath, "src2", null, "bin2");
            env.addClass(src2, "p2", "Foo", "package p2; \npublic class Foo {\n\tpublic static class Bar {\n\t\tpublic static Bar LocalBar = new Bar();\n\t}\n}");
            env.addClass(src2, "p2", "Test", "package p2; \nimport p1.NoSource;\nimport p2.Foo.Bar;\npublic class Test {\n\tNoSource nosrc = new NoSource(Bar.LocalBar);\n}");
            this.fullBuild(projectPath);
            this.expectingNoProblems();
            env.removePackageFragmentRoot(projectPath, "src1");
            env.addClassFolder(projectPath, bin1, false);
            AbstractImageBuilder.MAX_AT_ONCE = 1;
            env.addClass(src2, "p2", "Test", "package p2; \nimport p1.NoSource;\nimport p2.Foo.Bar;\npublic class Test {\n\tNoSource nosrc = new NoSource(Bar.LocalBar);\n}");
            this.incrementalBuild(projectPath);
            this.expectingNoProblems();
        }
        finally {
            AbstractImageBuilder.MAX_AT_ONCE = max;
        }
    }

    public void test129316() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        IPath yPath = env.addClass(projectPath, "p", "Y", "package p;\npublic class Y extends Z {}");
        env.addClass(projectPath, "p", "Z", "package p;\npublic class Z {}");
        env.addClass(projectPath, "", "X", "import p.Y;\npublic class X {\n\tboolean b(Object o) {\n\t\treturn o instanceof Y;\n    }\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(projectPath, "p", "Y", "package p;\npublic class Y extends Zork {}");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(yPath, new Problem("Y", "Zork cannot be resolved to a type", yPath, 34, 38, 40, 2));
        IPath xPath = env.addClass(projectPath, "", "X", "public class X {\n\tboolean b(Object o) {\n\t\treturn o instanceof p.Y;\n    }\n}");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(yPath, new Problem("Y", "Zork cannot be resolved to a type", yPath, 34, 38, 40, 2));
        this.expectingNoProblemsFor(xPath);
    }

    public void testSecondaryType() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "AB", "public class AB { AZ z = new AA();}");
        env.addClass(root, "", "AA", "public class AA extends AZ {} \nclass AZ {}");
        int max = AbstractImageBuilder.MAX_AT_ONCE;
        try {
            AbstractImageBuilder.MAX_AT_ONCE = 1;
            this.fullBuild(projectPath);
        }
        finally {
            AbstractImageBuilder.MAX_AT_ONCE = max;
        }
        this.expectingNoProblems();
    }

    public void testMissingType001() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath xPath = env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo(p2.Y y) {\t\n\t\ty.bar(null);\t}\n\tvoid X() {}\n}\n");
        IPath yPath = env.addClass(root, "p2", "Y", "package p2;\npublic class Y {\n\tpublic void bar(Z z) {}\n}\n");
        this.fullBuild(projectPath);
        this.expectingSpecificProblemFor(xPath, new Problem("X", "This method has a constructor name", xPath, 73, 76, 80, 1));
        this.expectingSpecificProblemFor(yPath, new Problem("Y", "Z cannot be resolved to a type", yPath, 46, 47, 40, 2));
        env.addClass(root, "p2", "Z", "package p2;\npublic class Z {\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(xPath, new Problem("X", "This method has a constructor name", xPath, 73, 76, 80, 1));
    }

    public void testMissingType002() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath yPath = env.addClass(root, "p2", "Y", "package p2;\npublic class Y {\n\tpublic void bar(Z z) {}\n}\n");
        this.fullBuild(projectPath);
        this.expectingSpecificProblemFor(yPath, new Problem("Y", "Z cannot be resolved to a type", yPath, 46, 47, 40, 2));
        IPath xPath = env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo(p2.Y y) {\t\n\t\ty.bar(null);\t}\n\tvoid X() {}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(xPath, new Problem("X", "This method has a constructor name", xPath, 73, 76, 80, 1));
        this.expectingSpecificProblemFor(yPath, new Problem("Y", "Z cannot be resolved to a type", yPath, 46, 47, 40, 2));
        env.addClass(root, "p2", "Z", "package p2;\npublic class Z {\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(xPath, new Problem("X", "This method has a constructor name", xPath, 73, 76, 80, 1));
    }

    public void testMissingType003() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath yPath = env.addClass(root, "p2", "Y", "package p2;\npublic class Y {\n\tpublic void bar(p1.Z z) {}\n}\n");
        this.fullBuild(projectPath);
        this.expectingSpecificProblemFor(yPath, new Problem("Y", "p1 cannot be resolved to a type", yPath, 46, 48, 40, 2));
        IPath xPath = env.addClass(root, "p1", "X", "package p1;\npublic class X {\n\tvoid foo(p2.Y y) {\t\n\t\ty.bar(null);\t}\n\tvoid X() {}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(xPath, new Problem("X", "This method has a constructor name", xPath, 73, 76, 80, 1));
        this.expectingSpecificProblemFor(yPath, new Problem("Y", "p1.Z cannot be resolved to a type", yPath, 46, 50, 40, 2));
        env.addClass(root, "p1", "Z", "package p1;\npublic class Z {\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(xPath, new Problem("X", "This method has a constructor name", xPath, 73, 76, 80, 1));
    }

    public void testBug334377() throws JavaModelException {
        int max = AbstractImageBuilder.MAX_AT_ONCE;
        Hashtable options = null;
        try {
            options = JavaCore.getOptions();
            Hashtable newOptions = JavaCore.getOptions();
            newOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            newOptions.put("org.eclipse.jdt.core.compiler.source", "1.5");
            newOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            JavaCore.setOptions((Hashtable)newOptions);
            IPath projectPath = env.addProject("Project");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            env.removePackageFragmentRoot(projectPath, "");
            IPath root = env.addPackageFragmentRoot(projectPath, "src");
            env.setOutputFolder(projectPath, "bin");
            env.addClass(root, "", "Upper", "public abstract class Upper<T>  {\n    public static enum Mode {IN,OUT;}\n}\n");
            env.addClass(root, "", "Lower", "public class Lower extends Upper<Lower> {};\n");
            env.addClass(root, "", "Bug", "public class Bug {\n    Upper.Mode m1;\n    void usage(){\n        Lower.Mode m3;\n        if (m1 == null){\n            m3 = Lower.Mode.IN;\n        } else {\n            m3 = m1;\n        }\n        Lower.Mode m2 = (m1 == null ?  Lower.Mode.IN : m1);\n        System.out.println(m2);\n        System.out.println(m3);\n    }\n}\n");
            this.fullBuild(projectPath);
            this.expectingNoProblems();
            env.addClass(root, "", "Bug", "public class Bug {\n    Upper.Mode m1;\n    void usage(){\n        Lower.Mode m3;\n        if (m1 == null){\n            m3 = Lower.Mode.IN;\n        } else {\n            m3 = m1;\n        }\n        Lower.Mode m2 = (m1 == null ?  Lower.Mode.IN : m1);\n        System.out.println(m2);\n        System.out.println(m3);\n    }\n}\n");
            this.incrementalBuild(projectPath);
            this.expectingNoProblems();
        }
        finally {
            AbstractImageBuilder.MAX_AT_ONCE = max;
            JavaCore.setOptions((Hashtable)options);
        }
    }

    public void testBug364450() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "bin");
        IPath wPath = env.addClass(projectPath, "w", "W", "package w;\npublic class W {\n\tprivate w.I i;}");
        IPath aPath = env.addClass(projectPath, "a", "A", "package a;\nimport w.I;\nimport w.W;\npublic class A {}");
        this.fullBuild(projectPath);
        this.expectingSpecificProblemFor(wPath, new Problem("W", "w.I cannot be resolved to a type", wPath, 37, 40, 40, 2));
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The import w.I cannot be resolved", aPath, 18, 21, 30, 2));
        aPath = env.addClass(projectPath, "a", "A", "package a;\nimport w.I;\nimport w.W;\npublic class A {}");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The import w.I cannot be resolved", aPath, 18, 21, 30, 2));
    }
}

