/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;

public class IncrementalTests18
extends BuilderTests {
    static /* synthetic */ Class class$0;

    public IncrementalTests18(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.IncrementalTests18");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return AbstractCompilerTest.buildMinimalComplianceTestSuite((Class)clazz, (int)32);
    }

    public void test423122() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "I", "package p;\t\npublic interface I { void foo(); }\t\n");
        env.addClass(root, "p", "X", "package p;\t\npublic class X { I i = () -> {}; }\t\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p", "I", "package p;\t\npublic interface I { }\t\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : The target type of this expression must be a functional interface [ resource : </Project/src/p/X.java> range : <35,40> category : <40> severity : <2>]");
    }

    public void test423122a() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "test1", "I", "package test1;\npublic interface I {\n    int method(int a); // change argument type to Object\n}\n");
        env.addClass(root, "test1", "E", "package test1;\npublic class E {\n    void take(I i) {\n    }\n}\n");
        env.addClass(root, "test1", "Ref", "package test1;\npublic class Ref {\n    void foo(E e) {\n        e.take((x) -> x+2); // not recompiled when I#method changed\n    }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "test1", "I", "package test1;\npublic interface I {\n    int method(Object a); // change argument type to Object\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : The operator + is undefined for the argument type(s) Object, int [ resource : </Project/src/test1/Ref.java> range : <76,79> category : <60> severity : <2>]");
        env.addClass(root, "test1", "I", "package test1;\npublic interface I {\n    int method(int a); // change argument type back to int\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void test427105() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "X", "import java.util.List;\npublic class X implements I {\n\tpublic void f(List x, List<I> ls) {                                      \n\t}\n}\n");
        env.addClass(root, "", "I", "import java.util.List;\npublic interface I {\n\tvoid f(@T List x, List<I> ls);\n}\n");
        env.addClass(root, "", "T", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\npublic @interface T {\n}\n");
        env.getJavaProject("Project").setOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/I.java> range : <55,59> category : <130> severity : <1>]\nProblem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/X.java> range : <68,72> category : <130> severity : <1>]");
        env.addClass(root, "", "X", "import java.util.List;\npublic class X implements I {\n\tpublic void f(List x, List<I> ls) {                                      \n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/I.java> range : <55,59> category : <130> severity : <1>]\nProblem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/X.java> range : <68,72> category : <130> severity : <1>]");
    }

    public void test427105a() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "X", "import java.util.List;\npublic class X implements I {\n\tpublic void f(List x, List<I> ls) {                                      \n\t}\n}\n");
        env.addClass(root, "", "I", "import java.util.List;\npublic interface I {\n\tvoid f(@T List x, List<I> ls);\n}\n");
        env.addClass(root, "", "T", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\npublic @interface T {\n}\n");
        env.getJavaProject("Project").setOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/I.java> range : <55,59> category : <130> severity : <1>]\nProblem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/X.java> range : <68,72> category : <130> severity : <1>]");
        env.addClass(root, "", "X", "import java.util.List;\npublic class X implements I {\n\tpublic void f(@T List x, List<I> ls) {                                      \n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/I.java> range : <55,59> category : <130> severity : <1>]\nProblem : List is a raw type. References to generic type List<E> should be parameterized [ resource : </Project/src/X.java> range : <71,75> category : <130> severity : <1>]");
    }

    public void test428071() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "K1", "import java.util.List;\nimport java.util.Map;\ninterface K1 {\n\tpublic Map<String,List> get();\n}\n");
        env.addClass(root, "", "K", "import java.util.List;\nimport java.util.Map;\npublic class K implements K1 {\n\tpublic Map<String, List> get() {\n\t\treturn null;\n\t}\n}\n");
        env.getJavaProject("Project").setOption("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "", "K", "import java.util.List;\nimport java.util.Map;\npublic class K implements K1 {\n\tpublic Map<String, List> get() {\n\t\treturn null;\n\t}\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void test430425() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.8");
        String jreDirectory = Util.getJREDirectory();
        String jfxJar = Util.toNativePath((String)(String.valueOf(jreDirectory) + "/lib/ext/jfxrt.jar"));
        File file = new File(jfxJar);
        if (!file.exists()) {
            return;
        }
        env.addExternalJars(projectPath, Util.concatWithClassLibs((String)jfxJar, (boolean)false));
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "javafx.css", "StyleConverter", "package javafx.css;\nimport com.sun.javafx.css.converters.InsetsConverter;\nimport javafx.geometry.Insets;\npublic class StyleConverter<F, T> {\n    public static StyleConverter<ParsedValue[], Insets> getInsetsConverter() {\n        return InsetsConverter.getInstance();\n    }\n    void fred5555() {\n    }\n}\n");
        env.addClass(root, "com.sun.javafx.css.converters", "InsetsConverter", "package com.sun.javafx.css.converters;\nimport com.sun.javafx.css.StyleConverterImpl;\nimport javafx.css.ParsedValue;\nimport javafx.css.StyleConverter;\nimport javafx.geometry.Insets;\npublic final class InsetsConverter extends StyleConverterImpl<ParsedValue[], Insets> {\n    public static StyleConverter<ParsedValue[], Insets> getInstance() {\n        return null;\n    }\n}\n");
        env.addClass(root, "javafx.css", "ParsedValue", "package javafx.css;\npublic class ParsedValue<V, T> {\n}\n");
        env.getJavaProject("Project").setOption("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "javafx.css", "StyleConverter", "package javafx.css;\nimport com.sun.javafx.css.converters.InsetsConverter;\nimport javafx.geometry.Insets;\npublic class StyleConverter<F, T> {\n    public static StyleConverter<ParsedValue[], Insets> getInsetsConverter() {\n        return InsetsConverter.getInstance();\n    }\n    void fred555() {\n    }\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }
}

