/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;

public class Java50Tests
extends BuilderTests {
    static /* synthetic */ Class class$0;

    public Java50Tests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.Java50Tests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Java50Tests.buildTestSuite((Class)clazz);
    }

    public void testAnnotation() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        IPath usePath = env.addClass(projectPath, "p", "Use", "package p;\n@q.Ann\npublic class Use {\n}");
        env.addClass(projectPath, "q", "Ann", "package q;\npublic @interface Ann {\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(projectPath, "q", "Ann", "package q;\nimport java.lang.annotation.*;\n@Target(ElementType.METHOD)\npublic @interface Ann {\n}");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(usePath, "Problem : The annotation @Ann is disallowed for this location [ resource : </Project/p/Use.java> range : <11,17> category : <40> severity : <2>]");
    }

    public void testHierarchyCycle() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        env.addClass(projectPath, "", "A", "interface A<T extends C> {}\ninterface B extends A<D> {}\ninterface D extends C {}");
        env.addClass(projectPath, "", "C", "interface C extends B {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testHierarchyCycleInstanceof() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        env.addClass(projectPath, "", "A", "import java.util.Collection;\npublic abstract class A\n<T extends A<T,S>,S extends Collection<T>> {}\nabstract class B extends A<D,Collection<D>> {\n  boolean isD() {return this instanceof D;}\n}\nfinal class D extends C {}\n");
        env.addClass(projectPath, "", "C", "public abstract class C extends B {\n  boolean isD() {return this instanceof D;}\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMissingRequiredBinaries() throws JavaModelException {
        IPath p1 = env.addProject("P1", "1.5");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        IPath p2bin = env.setOutputFolder(p2, "bin");
        env.addClass(root2, "p2", "Y", "package p2;\npublic class Y {\n\tpublic void foo(int i) {}\n\tpublic void foo(int i, Z z) {}\n}\nclass Z {}");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClassFolder(p1, p2bin, false);
        env.removeFile(p2bin.append("p2/Z.class"));
        env.addClass(root1, "p1", "X", "package p1;\npublic class X {\n\tvoid test(p2.Y y) { y.foo(1); }\n}\n");
        this.incrementalBuild(p1);
        this.expectingNoProblems();
        IPath xx = env.addClass(root1, "p1", "XX", "package p1;\npublic class XX {\n\tvoid test(p2.Y y) { y.foo('c', null); }\n}\n");
        this.incrementalBuild(p1);
        this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "The project was not built since its build path is incomplete. Cannot find the class file for p2.Z. Fix the build path then try building this project", p1, -1, -1, 10, 2), new Problem("p1", "The type p2.Z cannot be resolved. It is indirectly referenced from required .class files", xx, 51, 67, 10, 2)});
    }

    public void testParameterizedMemberType() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        IPath xPath = env.addClass(projectPath, "", "X", "class X<T> extends A<T> {}");
        IPath aPath = env.addClass(projectPath, "", "A", "class A<T> extends B<B<T>.M> {}");
        IPath bPath = env.addClass(projectPath, "", "B", "class B<T> extends Missing<T> {\n\tclass M{}\n}\nclass Missing<T> {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(projectPath, "", "B", "class B<T> extends Missing<T> {\n\tclass M{}\n}");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The hierarchy of the type X is inconsistent", xPath, 6, 7, 40, 2));
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The hierarchy of the type A is inconsistent", aPath, 6, 7, 40, 2));
        this.expectingSpecificProblemFor(bPath, new Problem("B", "Missing cannot be resolved to a type", bPath, 19, 26, 40, 2));
        env.addClass(projectPath, "", "X", "class X<T> extends A<T> {}");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The hierarchy of the type X is inconsistent", xPath, 6, 7, 40, 2));
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The hierarchy of the type A is inconsistent", aPath, 6, 7, 40, 2));
        this.expectingSpecificProblemFor(bPath, new Problem("B", "Missing cannot be resolved to a type", bPath, 19, 26, 40, 2));
        env.addClass(projectPath, "", "B", "class B<T> extends Missing<T> {\n\tclass M{}\n}");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The hierarchy of the type X is inconsistent", xPath, 6, 7, 40, 2));
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The hierarchy of the type A is inconsistent", aPath, 6, 7, 40, 2));
        this.expectingSpecificProblemFor(bPath, new Problem("B", "Missing cannot be resolved to a type", bPath, 19, 26, 40, 2));
        env.addClass(projectPath, "", "B", "class B<T> extends Missing<T> {\n\tclass M{}\n}\nclass Missing<T> {}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testParameterizedType1() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        IPath usePath = env.addClass(projectPath, "p", "Use", "package p;\nimport java.util.ArrayList;\nimport q.Other;\npublic class Use {\n\tpublic Use() {\n\t\tnew Other().foo(new ArrayList<String>());\n\t}\n}");
        env.addClass(projectPath, "q", "Other", "package q;\nimport java.util.List;\npublic class Other {\n\tpublic void foo(List<String> ls) {}\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(projectPath, "q", "Other", "package q;\nimport java.util.List;\npublic class Other {\n\tpublic void foo(List<Object> ls) {}\n}");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(usePath, "Problem : The method foo(List<Object>) in the type Other is not applicable for the arguments (ArrayList<String>) [ resource : </Project/p/Use.java> range : <104,107> category : <50> severity : <2>]");
    }

    public void testParameterizedType2() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        IPath usePath = env.addClass(projectPath, "p", "Use", "package p;\nimport java.util.ArrayList;\nimport q.Other;\npublic class Use {\n\tpublic Use() {\n\t\tnew Other().foo(new ArrayList<String>());\n\t}\n}");
        env.addClass(projectPath, "q", "Other", "package q;\nimport java.util.List;\npublic class Other {\n\tpublic void foo(List<String> ls) {}\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(projectPath, "q", "Other", "package q;\nimport java.util.List;\npublic class Other {\n\tpublic void foo(List<String> ls) throws Exception {}\n}");
        this.incrementalBuild(projectPath);
        this.expectingProblemsFor(usePath, "Problem : Unhandled exception type Exception [ resource : </Project/p/Use.java> range : <92,132> category : <40> severity : <2>]");
    }

    public void testHierarchyNonCycle() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        env.addClass(projectPath, "superint", "SuperInterface", "package superint;\npublic interface SuperInterface<G extends SuperInterface.SuperInterfaceGetter,\n\t\t\t\t\t\t\t\t S extends SuperInterface.SuperInterfaceSetter> {\n    public interface SuperInterfaceGetter {}\n    public interface SuperInterfaceSetter {}\n}\n");
        env.addClass(projectPath, "subint", "SubInterface", "package subint;\nimport superint.SuperInterface;\npublic interface SubInterface extends\n    SuperInterface<SubInterface.SubInterfaceGetter,\n                   SubInterface.SubInterfaceSetter> {\n        public interface SubInterfaceGetter extends SuperInterfaceGetter {}\n        public interface SubInterfaceSetter extends SuperInterfaceSetter {}\n}\n");
        this.fullBuild(projectPath);
        this.expectingProblemsFor(projectPath, "Problem : Bound mismatch: The type SubInterface.SubInterfaceGetter is not a valid substitute for the bounded parameter <G extends SuperInterface.SuperInterfaceGetter> of the type SuperInterface<G,S> [ resource : </Project/subint/SubInterface.java> range : <105,136> category : <40> severity : <2>]\nProblem : Bound mismatch: The type SubInterface.SubInterfaceSetter is not a valid substitute for the bounded parameter <S extends SuperInterface.SuperInterfaceSetter> of the type SuperInterface<G,S> [ resource : </Project/subint/SubInterface.java> range : <157,188> category : <40> severity : <2>]\nProblem : SuperInterfaceGetter cannot be resolved to a type [ resource : </Project/subint/SubInterface.java> range : <244,264> category : <40> severity : <2>]\nProblem : SuperInterfaceSetter cannot be resolved to a type [ resource : </Project/subint/SubInterface.java> range : <320,340> category : <40> severity : <2>]");
    }

    public void testHierarchyNonCycle2() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.setOutputFolder(projectPath, "");
        env.addClass(projectPath, "superint", "SuperInterface", "package superint;\npublic interface SuperInterface<G extends SuperInterface.SuperInterfaceGetter,\n\t\t\t\t\t\t\t\t S extends SuperInterface.SuperInterfaceSetter> {\n    public interface SuperInterfaceGetter {}\n    public interface SuperInterfaceSetter {}\n}\n");
        env.addClass(projectPath, "subint", "SubInterface", "package subint;\nimport superint.SuperInterface;\nimport superint.SuperInterface.SuperInterfaceGetter;\nimport superint.SuperInterface.SuperInterfaceSetter;\npublic interface SubInterface extends\n    SuperInterface<SubInterface.SubInterfaceGetter,\n                   SubInterface.SubInterfaceSetter> {\n        public interface SubInterfaceGetter extends SuperInterfaceGetter {}\n        public interface SubInterfaceSetter extends SuperInterfaceSetter {}\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }
}

