/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;

public class MultiProjectTests
extends BuilderTests {
    static /* synthetic */ Class class$0;

    public MultiProjectTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.MultiProjectTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest((Test)new MultiProjectTests("testCompileOnlyDependent"));
        suite.addTest((Test)new MultiProjectTests("testCompileOnlyStructuralDependent"));
        suite.addTest((Test)new MultiProjectTests("testRemoveField"));
        suite.addTest((Test)new MultiProjectTests("testCompileOrder"));
        suite.addTest((Test)new MultiProjectTests("testCycle1"));
        suite.addTest((Test)new MultiProjectTests("testCycle2"));
        suite.addTest((Test)new MultiProjectTests("testCycle3"));
        suite.addTest((Test)new MultiProjectTests("testCycle4"));
        suite.addTest((Test)new MultiProjectTests("testCycle5"));
        suite.addTest((Test)new MultiProjectTests("testCycle6"));
        suite.addTest((Test)new MultiProjectTests("testCycle7"));
        suite.addTest((Test)new MultiProjectTests("testExcludePartOfAnotherProject1"));
        suite.addTest((Test)new MultiProjectTests("testExcludePartOfAnotherProject2"));
        suite.addTest((Test)new MultiProjectTests("testExcludePartOfAnotherProject3"));
        suite.addTest((Test)new MultiProjectTests("testIncludePartOfAnotherProject1"));
        suite.addTest((Test)new MultiProjectTests("testIncludePartOfAnotherProject2"));
        suite.addTest((Test)new MultiProjectTests("testIncludePartOfAnotherProject3"));
        suite.addTest((Test)new MultiProjectTests("testIgnoreIfBetterNonAccessibleRule1"));
        suite.addTest((Test)new MultiProjectTests("testIgnoreIfBetterNonAccessibleRule2"));
        suite.addTest((Test)new MultiProjectTests("testMissingRequiredBinaries"));
        suite.addTest((Test)new MultiProjectTests("test100_class_folder_exported"));
        suite.addTest((Test)new MultiProjectTests("test101_class_folder_non_exported"));
        suite.addTest((Test)new MultiProjectTests("test102_missing_required_binaries"));
        suite.addTest((Test)new MultiProjectTests("test103_missing_required_binaries"));
        return suite;
    }

    public void testCompileOnlyDependent() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "", "A", "public class A {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "B", "public class B extends A {\n}\n");
        IPath project3Path = env.addProject("Project3");
        env.addExternalJars(project3Path, Util.getJavaClassLibs());
        IPath root3 = env.getPackageFragmentRootPath(project3Path, "");
        env.addClass(root3, "", "C", "public class C {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClass(root1, "", "A", "public class A {\n   int x;\n}\n");
        this.incrementalBuild();
        this.expectingCompiledClasses(new String[]{"A", "B"});
    }

    public void testCompileOnlyStructuralDependent() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "", "A", "public class A {\n}\n");
        env.addClass(root1, "", "Unreferenced", "public class Unreferenced {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "B", "public class B extends A {\n}\n");
        IPath project3Path = env.addProject("Project3");
        env.addExternalJars(project3Path, Util.getJavaClassLibs());
        IPath root3 = env.getPackageFragmentRootPath(project3Path, "");
        env.addClass(root3, "", "C", "public class C {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClass(root1, "", "A", "public class A {\n   // add comment (non-structural change)\n}\n");
        env.addClass(root1, "", "Unreferenced", "public class Unreferenced {\n   int x; //structural change\n}\n");
        this.incrementalBuild();
        this.expectingCompiledClasses(new String[]{"A", "Unreferenced"});
    }

    public void testRemoveField() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        JavaCore.setOptions((Hashtable)options);
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "", "A", "public class A {\n   public int x;\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        IPath b = env.addClass(root2, "", "B", "public class B {\n   public void foo(){\n      int x = new A().x;\n   }\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClass(root1, "", "A", "public class A {\n}\n");
        this.incrementalBuild();
        this.expectingSpecificProblemFor(b, new Problem("B.foo()", "x cannot be resolved or is not a field", b, 61, 62, 50, 2));
    }

    public void testCompileOrder() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath c1 = env.addClass(root1, "p1", "X", "package p1;\npublic class X {\n  W w;\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\npublic class Y {\n  W w;\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        IPath c3 = env.addClass(root3, "p3", "Z", "package p3;\npublic class Z {\n  W w;\n}\n");
        env.setBuildOrder(new String[]{"P1", "P3", "P2"});
        this.fullBuild();
        this.expectingCompilingOrder(new String[]{"p1.X", "p3.Z", "p2.Y"});
        IPath workspaceRootPath = env.getWorkspaceRootPath();
        this.expectingOnlySpecificProblemsFor(workspaceRootPath, new Problem[]{new Problem("p3", "W cannot be resolved to a type", c3, 31, 32, 40, 2), new Problem("p2", "W cannot be resolved to a type", c2, 31, 32, 40, 2), new Problem("p1", "W cannot be resolved to a type", c1, 31, 32, 40, 2)});
        JavaCore.setOptions((Hashtable)options);
    }

    public void testCycle1() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y){\n    y.zork();\n  }\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        env.addClass(root2, "p2", "Y", "package p2;\nimport p1.X;\nimport p3.Z;\npublic class Y extends Z{\n  public X zork(){\n    X x = foo();\n    x.bar(this);\n    return x;\n  }\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "p3", "Z", "package p3;\nimport p1.X;\npublic class Z {\n  public X foo(){\n    return null;\n  }\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p1, p3);
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p2, p3);
        env.addRequiredProject(p3, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2", "P3"});
            this.fullBuild();
            this.expectingCompilingOrder(new String[]{"p1.X", "p2.Y", "p3.Z", "p1.X", "p2.Y", "p3.Z", "p1.X"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p2, new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
        }
    }

    public void testCycle2() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y, int i){\n    y.zork();\n  }\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\nimport p1.X;\nimport p3.Z;\npublic class Y extends Z{\n  public X zork(){\n    X x = foo();\n    x.bar(this);\n    return x;\n  }\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "p3", "Z", "package p3;\nimport p1.X;\npublic class Z {\n  public X foo(){\n    return null;\n  }\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p1, p3);
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p2, p3);
        env.addRequiredProject(p3, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2", "P3"});
            this.fullBuild();
            this.expectingCompilingOrder(new String[]{"p1.X", "p2.Y", "p3.Z", "p1.X", "p2.Y", "p3.Z", "p1.X"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "The method bar(Y, int) in the type X is not applicable for the arguments (Y)", c2, 106, 109, 50, 2), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
        }
    }

    public void testCycle3() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y){\n    y.zork();\n  }\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\nimport p1.X;\nimport p3.Z;\npublic class Y extends Z{\n  public X zork(){\n    X x = foo();\n    x.bar(this);\n    return x;\n  }\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "p3", "Z", "package p3;\nimport p1.X;\npublic class Z {\n  public X foo(){\n    return null;\n  }\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p1, p3);
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p2, p3);
        env.addRequiredProject(p3, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2", "P3"});
            this.fullBuild();
            this.expectingCompilingOrder(new String[]{"p1.X", "p2.Y", "p3.Z", "p1.X", "p2.Y", "p3.Z", "p1.X"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p2, new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y, int i){\n    y.zork();\n  }\n}\n");
            this.incrementalBuild();
            this.expectingCompilingOrder(new String[]{"p1.X", "p2.Y", "p3.Z"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "The method bar(Y, int) in the type X is not applicable for the arguments (Y)", c2, 106, 109, 50, 2), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
        }
    }

    public void testCycle4() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\nimport p1.X;\nimport p3.Z;\npublic class Y extends Z{\n  public X zork(){\n    X x = foo();\n    x.bar(this);\n    return x;\n  }\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        IPath c3 = env.addClass(root3, "p3", "Z", "package p3;\nimport p1.X;\npublic class Z {\n  public X foo(){\n    return null;\n  }\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p1, p3);
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p2, p3);
        env.addRequiredProject(p3, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2", "P3"});
            this.fullBuild();
            this.expectingCompilingOrder(new String[]{"p2.Y", "p3.Z", "p2.Y"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "X cannot be resolved to a type", c2, 87, 88, 40, 2), new Problem("p2", "The method foo() from the type Z refers to the missing type X", c2, 93, 96, 50, 2), new Problem("p2", "The import p1 cannot be resolved", c2, 19, 21, 30, 2), new Problem("p2", "X cannot be resolved to a type", c2, 73, 74, 40, 2), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "X cannot be resolved to a type", c3, 51, 52, 40, 2), new Problem("p3", "The import p1 cannot be resolved", c3, 19, 21, 30, 2), new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1)});
            env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y){\n    y.zork();\n  }\n}\n");
            this.incrementalBuild();
            this.expectingCompilingOrder(new String[]{"p1.X", "p2.Y", "p3.Z", "p1.X", "p2.Y"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p2, new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
        }
    }

    public void testCycle5() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath c1 = env.addClass(root1, "p1", "X", "package p1;\nimport p2.*;\nimport p22.*;\npublic class X {\n  Y y;\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\nimport p1.*;\nimport p11.*;\npublic class Y {\n  X x;\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p2, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2"});
            this.fullBuild();
            this.expectingCompilingOrder(new String[]{"p1.X", "p2.Y", "p1.X", "p2.Y"});
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "The import p22 cannot be resolved", c1, 32, 35, 30, 2), new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2}", p1, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "The import p11 cannot be resolved", c2, 32, 35, 30, 2), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2}", p2, -1, -1, 10, 1)});
            env.addClass(root1, "p11", "XX", "package p11;\npublic class XX {\n}\n");
            env.addClass(root2, "p22", "YY", "package p22;\npublic class YY {\n}\n");
            this.incrementalBuild();
            this.expectingCompilingOrder(new String[]{"p11.XX", "p22.YY", "p2.Y", "p1.X"});
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "The import p22 is never used", c1, 32, 35, 120, 1), new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2}", p1, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "The import p11 is never used", c2, 32, 35, 120, 1), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2}", p2, -1, -1, 10, 1)});
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
        }
    }

    public void testCycle6() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "java/lang", "Object", "package java.lang;\npublic class Object {\n  Class getClass() { return null; }\n  String toString() { return \"\"; }\n}\n");
        IPath p2 = env.addProject("P2");
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        env.addClass(root2, "java/lang", "Class", "package java.lang;\npublic class Class {\n  String getName() { return \"\"; };\n}\n");
        IPath p3 = env.addProject("P3");
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "java/lang", "String", "package java.lang;\npublic class String {\n}\n");
        IPath[] accessiblePaths = new IPath[]{new Path("java/lang/*")};
        IPath[] forbiddenPaths = new IPath[]{new Path("**/*")};
        env.addRequiredProject(p1, p2, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p1, p3, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p2, p1, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p2, p3, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p3, p1, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p3, p2, accessiblePaths, forbiddenPaths, false);
        try {
            this.fullBuild();
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1)});
        }
        finally {
            JavaCore.setOptions((Hashtable)options);
        }
    }

    public void testCycle7() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "java/lang", "Object", "package java.lang;\npublic class Object {\n  Class getClass() { return null; }\n  String toString() { return null; }\n}\n");
        IPath p2 = env.addProject("P2");
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        env.addClass(root2, "java/lang", "Class", "package java.lang;\npublic class Class {\n  String getName() { return \"\"; };\n}\n");
        IPath p3 = env.addProject("P3");
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "java/lang", "String", "package java.lang;\npublic class String {\n}\n");
        IPath[] accessiblePaths = new IPath[]{new Path("java/lang/*")};
        IPath[] forbiddenPaths = new IPath[]{new Path("**/*")};
        env.addRequiredProject(p1, p2, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p1, p3, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p2, p1, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p2, p3, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p3, p1, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p3, p2, accessiblePaths, forbiddenPaths, false);
        try {
            this.fullBuild();
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1)});
        }
        finally {
            JavaCore.setOptions((Hashtable)options);
        }
    }

    public void testExcludePartOfAnotherProject1() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[]{new Path("**/internal/")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        this.fullBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
    }

    public void testExcludePartOfAnotherProject2() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[]{new Path("**/internal/")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        this.incrementalBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
    }

    public void testExcludePartOfAnotherProject3() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[]{new Path("**/internal/")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        this.fullBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
        env.removeRequiredProject(project2Path, project1Path);
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[0], false);
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void testIncludePartOfAnotherProject1() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[]{new Path("**/api/")}, new IPath[]{new Path("**")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        this.fullBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
    }

    public void testIncludePartOfAnotherProject2() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[]{new Path("**/api/")}, new IPath[]{new Path("**")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        this.incrementalBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
    }

    public void testIncludePartOfAnotherProject3() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[]{new Path("**/api/")}, new IPath[]{new Path("**")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        this.fullBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
        env.removeRequiredProject(project2Path, project1Path);
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[0], false);
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void testIgnoreIfBetterNonAccessibleRule1() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p", "A", "package p;\npublic class A {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "p", "A", "package p;\npublic class A {\n}\n");
        IPath project3Path = env.addProject("Project3");
        env.addExternalJars(project3Path, Util.getJavaClassLibs());
        env.addRequiredProject(project3Path, project1Path, (IPath)new Path("**/p/"), 257);
        env.addRequiredProject(project3Path, project2Path, (IPath)new Path("**/p/A"), 0);
        IPath root3 = env.getPackageFragmentRootPath(project3Path, "");
        env.addClass(root3, "p3", "B", "package p3;\npublic class B extends p.A {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
    }

    public void testIgnoreIfBetterNonAccessibleRule2() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p", "A", "package p;\npublic class A {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "p", "A", "package p;\npublic class A {\n}\n");
        IPath project3Path = env.addProject("Project3");
        env.addExternalJars(project3Path, Util.getJavaClassLibs());
        env.addRequiredProject(project3Path, project1Path, (IPath)new Path("**/p/"), 257);
        env.addRequiredProject(project3Path, project2Path, (IPath)new Path("**/p/A"), 2);
        IPath root3 = env.getPackageFragmentRootPath(project3Path, "");
        IPath b = env.addClass(root3, "p3", "B", "package p3;\npublic class B extends p.A {\n}\n");
        this.fullBuild();
        this.expectingSpecificProblemFor(project3Path, new Problem("", "Discouraged access: The type 'A' is not API (restriction on required project 'Project2')", b, 35, 38, 150, 1));
    }

    public void testMissingRequiredBinaries() throws JavaModelException {
        IPath p1 = env.addProject("P1");
        IPath p2 = env.addProject("P2");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.addRequiredProject(p1, p2);
        env.setOutputFolder(p1, "bin");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.addRequiredProject(p2, p3);
        env.setOutputFolder(p2, "bin");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        IPath x = env.addClass(root1, "p1", "X", "package p1;\nimport p2.*;\npublic class X extends Y{\n}\n");
        env.addClass(root2, "p2", "Y", "package p2;\nimport p3.*;\npublic class Y extends Z {\n}\n");
        env.addClass(root3, "p3", "Z", "package p3;\npublic class Z {\n}\n");
        try {
            this.fullBuild();
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "The type p3.Z cannot be resolved. It is indirectly referenced from required .class files", x, 48, 49, 10, 2), new Problem("p1", "The project was not built since its build path is incomplete. Cannot find the class file for p3.Z. Fix the build path then try building this project", p1, -1, -1, 10, 2)});
        }
        finally {
            env.setBuildOrder(null);
        }
    }

    public void test100_class_folder_exported() throws JavaModelException {
        IPath P1 = env.addProject("P1");
        env.setOutputFolder(P1, "bin");
        env.addExternalJars(P1, Util.getJavaClassLibs());
        env.addClass(env.addPackage(env.getPackageFragmentRootPath(P1, ""), "p"), "A", "package p;\npublic class A {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.removePackageFragmentRoot(P1, "");
        env.addClassFolder(P1, P1.append("bin"), true);
        IPath P2 = env.addProject("P2");
        env.addExternalJars(P2, Util.getJavaClassLibs());
        env.addRequiredProject(P2, P1);
        env.addClass(env.getPackageFragmentRootPath(P2, ""), "X", "import p.A;\npublic class X {\n  A f;\n}");
        this.fullBuild();
        this.expectingNoProblems();
    }

    public void test101_class_folder_non_exported() throws JavaModelException {
        IPath P1 = env.addProject("P1");
        env.setOutputFolder(P1, "bin");
        env.addExternalJars(P1, Util.getJavaClassLibs());
        env.addClass(env.addPackage(env.getPackageFragmentRootPath(P1, ""), "p"), "A", "package p;\npublic class A {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.removePackageFragmentRoot(P1, "");
        env.addClassFolder(P1, P1.append("bin"), false);
        IPath P2 = env.addProject("P2");
        env.addExternalJars(P2, Util.getJavaClassLibs());
        env.addRequiredProject(P2, P1);
        IPath c = env.addClass(env.getPackageFragmentRootPath(P2, ""), "X", "import p.A;\npublic class X {\n  A f;\n}");
        this.fullBuild();
        this.expectingSpecificProblemsFor(P2, new Problem[]{new Problem("", "The import p cannot be resolved", c, 7, 8, 30, 2), new Problem("", "A cannot be resolved to a type", c, 31, 32, 40, 2)});
    }

    public void test102_missing_required_binaries() throws JavaModelException {
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.addRequiredProject(p2, p1);
        env.setOutputFolder(p2, "bin");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.addRequiredProject(p3, p2);
        env.setOutputFolder(p3, "bin");
        env.addClass(root1, "", "I", "public interface I {\n}\n");
        env.addClass(root2, "", "X", "public class X implements I {\n}\n");
        IPath y = env.addClass(root3, "", "Y", "public class Y extends X {\n  X m = new X() {};\n}\n");
        try {
            this.fullBuild();
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "The project was not built since its build path is incomplete. Cannot find the class file for I. Fix the build path then try building this project", p3, -1, -1, 10, 2), new Problem("p3", "The type I cannot be resolved. It is indirectly referenced from required .class files", y, 23, 24, 10, 2)});
        }
        finally {
            env.setBuildOrder(null);
        }
    }

    public void test103_missing_required_binaries() throws JavaModelException {
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.addRequiredProject(p2, p1);
        env.setOutputFolder(p2, "bin");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.addRequiredProject(p3, p2);
        env.setOutputFolder(p3, "bin");
        env.addClass(root1, "", "I", "public interface I {\n}\n");
        env.addClass(root2, "", "X", "public class X implements I {\n}\n");
        IPath y = env.addClass(root3, "", "Y", "public class Y {\n  X m = new X() {};\n  X n = new X() {};\n}\n");
        try {
            this.fullBuild();
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "The project was not built since its build path is incomplete. Cannot find the class file for I. Fix the build path then try building this project", p3, -1, -1, 10, 2), new Problem("p3", "The type I cannot be resolved. It is indirectly referenced from required .class files", y, 0, 1, 10, 2)});
        }
        finally {
            env.setBuildOrder(null);
        }
    }
}

