/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;

public class OutputFolderTests
extends BuilderTests {
    static /* synthetic */ Class class$0;

    public OutputFolderTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.OutputFolderTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return OutputFolderTests.buildTestSuite((Class)clazz);
    }

    public void testChangeOutputFolder() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        IPath bin1 = env.setOutputFolder(projectPath, "bin1");
        env.addClass(root, "p", "Test", "package p;\npublic class Test {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(bin1.append("p/Test.class"));
        IPath bin2 = env.setOutputFolder(projectPath, "bin2");
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(bin2.append("p/Test.class"));
    }

    public void testDeleteOutputFolder() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IPath root = env.getPackageFragmentRootPath(projectPath, "");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "Test", "public class Test {}");
        env.addFile(root, "Test.txt", "");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{bin.append("Test.class"), bin.append("Test.txt")});
        env.removeFolder(bin);
        this.fullBuild();
        this.expectingPresenceOf(new IPath[]{bin.append("Test.class"), bin.append("Test.txt")});
    }

    public void testInvalidOutput() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(projectPath, "src", "A", "public class A {}");
        this.fullBuild();
        this.expectingNoProblems();
        env.addFile(projectPath, ".classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"src\"/>\n    <classpathentry kind=\"var\" path=\"" + Util.getJavaClassLibs() + "\"/>\n" + "    <classpathentry kind=\"output\" path=\"\"/>\n" + "</classpath>");
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaProject project = (JavaProject)manager.getJavaModel().getJavaProject("P");
        manager.removePerProjectInfo(project, true);
        IPath cuPath = env.addClass(projectPath, "src", "A", "public class A { String s;}");
        this.incrementalBuild();
        this.expectingPresenceOf(new IPath[]{cuPath});
    }

    public void testSimpleProject() throws JavaModelException {
        IPath projectPath = env.addProject("P1");
        IPath bin = env.setOutputFolder(projectPath, "");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(projectPath, "", "A", "public class A {}");
        env.addClass(projectPath, "p", "B", "package p;public class B {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{bin.append("A.class"), bin.append("p/B.class")});
    }

    public void testProjectWithBin() throws JavaModelException {
        IPath projectPath = env.addProject("P2");
        IPath src = env.getPackageFragmentRootPath(projectPath, "");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src, "", "A", "public class A {}");
        env.addClass(src, "p", "B", "package p;public class B {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{bin.append("A.class"), bin.append("p/B.class")});
    }

    public void testProjectWithSrcBin() throws JavaModelException {
        IPath projectPath = env.addProject("P3");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "src");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src, "", "A", "public class A {}");
        env.addClass(src, "p", "B", "package p;public class B {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{bin.append("A.class"), bin.append("p/B.class")});
    }

    public void testProjectWith2SrcBin() throws JavaModelException {
        IPath projectPath = env.addProject("P4");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1");
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src2");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src1, "", "A", "public class A {}");
        env.addClass(src2, "p", "B", "package p;public class B {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{bin.append("A.class"), bin.append("p/B.class")});
    }

    public void testProjectWith2SrcAsBin() throws JavaModelException {
        IPath projectPath = env.addProject("P5");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1", null, "src1");
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src2", null, "src2");
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src1, "", "A", "public class A {}");
        env.addClass(src2, "p", "B", "package p;public class B {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{src1.append("A.class"), src2.append("p/B.class")});
    }

    public void testProjectWith2Src2Bin() throws JavaModelException {
        IPath projectPath = env.addProject("P6");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1", null, "bin1");
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src2", null, "bin2");
        env.setOutputFolder(projectPath, "bin1");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src1, "", "A", "public class A {}");
        env.addClass(src2, "p", "B", "package p;public class B {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{projectPath.append("bin1/A.class"), projectPath.append("bin2/p/B.class")});
    }

    public void testProjectWith3Src2Bin() throws JavaModelException {
        IPath projectPath = env.addProject("P6");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1", null, "bin1");
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src2", null, "bin2");
        IPath src3 = env.addPackageFragmentRoot(projectPath, "src3", null, "bin2");
        env.setOutputFolder(projectPath, "bin1");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src1, "", "A", "public class A {}");
        env.addClass(src2, "p", "B", "package p;public class B {}");
        env.addClass(src3, "", "C", "public class C {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{projectPath.append("bin1/A.class"), projectPath.append("bin2/p/B.class"), projectPath.append("bin2/C.class")});
    }

    public void test2ProjectWith1Bin() throws JavaModelException {
        IPath projectPath = env.addProject("P7");
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IPath projectPath2 = env.addProject("P8");
        IPath binLocation = env.getProject(projectPath).getFolder("bin").getLocation();
        env.setExternalOutputFolder(projectPath2, "externalBin", binLocation);
        env.addExternalJars(projectPath2, Util.getJavaClassLibs());
        env.addRequiredProject(projectPath2, projectPath);
        env.addClass(projectPath2, "p", "B", "package p;public class B {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(bin.append("p/B.class"));
    }
}

