/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import junit.framework.Test;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;

public class PackageTests
extends BuilderTests {
    static /* synthetic */ Class class$0;

    public PackageTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.PackageTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return PackageTests.buildTestSuite((Class)clazz);
    }

    public void testPackageProblem() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "src");
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src2");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(src, "pack", "X", "package pack;\npublic class X {\n}\n");
        env.addClass(src2, "p1", "X", "package p1;\npublic class X {\n}\n");
        env.addClass(src2, "p2", "Y", "package p2;\npublic class Y extends p1.X {\n}\n");
        env.addClass(src2, "p3", "Z", "package p3;\npublic class Z extends p2.Y {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.removeClass(env.getPackagePath(src, "pack"), "X");
        env.removePackage(src2, "p3");
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void testNoPackageProblem() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath aPath = env.addClass(src, "p", "A", "package p;\npublic class A {}");
        IPath bPath = env.addClass(src, "p.A", "B", "public class B {}");
        this.fullBuild();
        this.expectingOnlySpecificProblemFor(aPath, new Problem("", "The type A collides with a package", aPath, 24, 25, 40, 1));
        this.expectingOnlySpecificProblemFor(bPath, new Problem("", "The declared package \"\" does not match the expected package \"p.A\"", bPath, 0, 1, 60, 2));
    }

    public void test001() throws CoreException {
        IPath projectPath = env.addProject("P");
        try {
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            env.removePackageFragmentRoot(projectPath, "");
            IPath src = env.addPackageFragmentRoot(projectPath, "src");
            IPath bin = env.setOutputFolder(projectPath, "bin");
            env.addClass(src, "p", "X", "package p;\npublic class X {\n}\n");
            File tmpDir = env.getTmpDirectory();
            File externalPackageDir = new File(String.valueOf(tmpDir.getAbsolutePath()) + File.separator + "q");
            externalPackageDir.mkdir();
            IFolder folder = env.getWorkspace().getRoot().getFolder(src.append("p/q"));
            folder.createLink(externalPackageDir.toURI(), 0, null);
            env.addClass(src, "p.q", "Y", "package p.q;\npublic class Y extends p.X {\n}\n");
            env.addClass(src, "p.q.r", "Z", "package p.q.r;\npublic class Z extends p.q.Y {\n}\n");
            PackageTests.assertTrue((boolean)new File(String.valueOf(externalPackageDir.getAbsolutePath()) + File.separator + "r" + File.separator + "Z.java").exists());
            this.fullBuild();
            this.expectingPresenceOf(bin.append("p/q/r/Z.class"));
            this.expectingNoProblems();
            env.removeClass(env.getPackagePath(src, "p.q.r"), "Z");
            env.removePackage(src, "p.q.r");
            this.incrementalBuild();
            this.expectingNoProblems();
        }
        finally {
            env.deleteTmpDirectory();
            env.removeProject(projectPath);
        }
    }

    public void test002() throws CoreException {
        IPath projectPath = env.addProject("P");
        IPath externalProjectPath = env.addProject("EP");
        try {
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            env.removePackageFragmentRoot(projectPath, "");
            IPath src = env.addPackageFragmentRoot(projectPath, "src");
            IPath bin = env.setOutputFolder(projectPath, "bin");
            env.addClass(src, "p", "X", "package p;\npublic class X {\n}\n");
            IProject externalProject = env.getProject(externalProjectPath);
            IFolder externalFolder = externalProject.getFolder("q");
            externalFolder.create(false, true, null);
            IFolder folder = env.getWorkspace().getRoot().getFolder(src.append("p/q"));
            folder.createLink(externalFolder.getLocationURI(), 0, null);
            env.addClass(src, "p.q", "Y", "package p.q;\npublic class Y extends p.X {\n}\n");
            env.addClass(src, "p.q.r", "Z", "package p.q.r;\npublic class Z extends p.q.Y {\n}\n");
            PackageTests.assertTrue((boolean)new File(externalFolder.getLocation() + File.separator + "r" + File.separator + "Z.java").exists());
            env.incrementalBuild(projectPath);
            this.expectingPresenceOf(bin.append("p/q/r/Z.class"));
            this.expectingNoProblems();
            env.removeClass(env.getPackagePath(src, "p.q.r"), "Z");
            env.removePackage(src, "p.q.r");
            env.incrementalBuild(projectPath);
            this.expectingNoProblems();
        }
        finally {
            env.deleteTmpDirectory();
            env.removeProject(projectPath);
            env.removeProject(externalProjectPath);
        }
    }
}

