/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;

public class Problem
implements Comparable {
    private String location;
    private String message;
    private IPath resourcePath;
    private int start = -1;
    private int end = -1;
    private int categoryId = -1;
    private String sourceId;
    private int severity = 2;

    public Problem(String location, String message, IPath resourcePath, int start, int end, int categoryId, int severity) {
        this.location = location;
        this.message = message;
        this.resourcePath = resourcePath;
        this.start = start;
        this.end = end;
        this.categoryId = categoryId;
        this.severity = severity;
    }

    public Problem(IMarker marker) {
        this.location = marker.getAttribute("location", "");
        this.message = marker.getAttribute("message", "");
        this.resourcePath = marker.getResource().getFullPath();
        this.start = marker.getAttribute("charStart", -1);
        this.end = marker.getAttribute("charEnd", -1);
        this.categoryId = marker.getAttribute("categoryId", -1);
        this.sourceId = marker.getAttribute("sourceId", "missing");
        this.severity = marker.getAttribute("severity", 2);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.message;
    }

    public IPath getResourcePath() {
        return this.resourcePath;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return "Problem : " + this.message + " [ resource : <" + this.resourcePath + ">" + " range : <" + this.start + "," + this.end + ">" + " category : <" + this.categoryId + ">" + " severity : <" + this.severity + ">" + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof Problem) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof Problem) {
            Problem problem = (Problem)o;
            return this.toString().compareTo(problem.toString());
        }
        return -1;
    }
}

