/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;

public class BasicBuildTests
extends BuilderTests {
    static /* synthetic */ Class class$0;

    public BasicBuildTests(String name) {
        super(name);
        System.setProperty("maxCompiledUnitsAtOnce", "0");
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.BasicBuildTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return BasicBuildTests.buildTestSuite((Class)clazz);
    }

    public void testBuild() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
    }

    public void testToDoMarker() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.taskTags", "todo");
        newOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath pathToA = env.addClass(root, "p", "A", "package p; \n//todo nothing\npublic class A {\n}");
        this.fullBuild(projectPath);
        this.expectingOnlySpecificProblemFor(pathToA, new Problem("A", "todo nothing", pathToA, 14, 26, -1, 2));
        JavaCore.setOptions((Hashtable)options);
    }

    public void testToDoMarker2() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.taskTags", "TODO,FIXME,XXX");
        newOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL,HIGH,LOW");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath pathToA = env.addClass(root, "p", "A", "package p; \n//TODO normal\npublic class A {\n\tpublic void foo() {\n\t\t//FIXME high\n\t}\n\tpublic void foo2() {\n\t\t//XXX low\n\t}\n}");
        this.fullBuild(projectPath);
        IMarker[] markers = env.getTaskMarkersFor(pathToA);
        BasicBuildTests.assertEquals((String)"Wrong size", (int)3, (int)markers.length);
        try {
            IMarker marker = markers[0];
            Object priority = marker.getAttribute("priority");
            String message = (String)marker.getAttribute("message");
            BasicBuildTests.assertTrue((String)"Wrong message", (boolean)message.startsWith("TODO "));
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(1), (Object)priority);
            marker = markers[1];
            priority = marker.getAttribute("priority");
            message = (String)marker.getAttribute("message");
            BasicBuildTests.assertTrue((String)"Wrong message", (boolean)message.startsWith("FIXME "));
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(2), (Object)priority);
            marker = markers[2];
            priority = marker.getAttribute("priority");
            message = (String)marker.getAttribute("message");
            BasicBuildTests.assertTrue((String)"Wrong message", (boolean)message.startsWith("XXX "));
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(0), (Object)priority);
        }
        catch (CoreException coreException) {
            BasicBuildTests.assertTrue((boolean)false);
        }
        JavaCore.setOptions((Hashtable)options);
    }

    public void testTags() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.taskTags", "TODO,FIXME,XXX");
        newOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL,HIGH,LOW");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath pathToA = env.addClass(root, "p", "A", "package p; \n// TODO FIXME need to review the loop TODO should be done\npublic class A {\n}");
        this.fullBuild(projectPath);
        IMarker[] markers = env.getTaskMarkersFor(pathToA);
        BasicBuildTests.assertEquals((String)"Wrong size", (int)3, (int)markers.length);
        try {
            IMarker marker = markers[2];
            Object priority = marker.getAttribute("priority");
            String message = (String)marker.getAttribute("message");
            BasicBuildTests.assertEquals((String)"Wrong message", (String)"TODO should be done", (String)message);
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(1), (Object)priority);
            marker = markers[1];
            priority = marker.getAttribute("priority");
            message = (String)marker.getAttribute("message");
            BasicBuildTests.assertEquals((String)"Wrong message", (String)"FIXME need to review the loop", (String)message);
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(2), (Object)priority);
            marker = markers[0];
            priority = marker.getAttribute("priority");
            message = (String)marker.getAttribute("message");
            BasicBuildTests.assertEquals((String)"Wrong message", (String)"TODO need to review the loop", (String)message);
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(1), (Object)priority);
        }
        catch (CoreException coreException) {
            BasicBuildTests.assertTrue((boolean)false);
        }
        JavaCore.setOptions((Hashtable)options);
    }

    public void testTags2() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.taskTags", "TODO,FIXME,XXX");
        newOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL,HIGH,LOW");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath pathToA = env.addClass(root, "p", "A", "package p; \n// TODO TODO need to review the loop\npublic class A {\n}");
        this.fullBuild(projectPath);
        IMarker[] markers = env.getTaskMarkersFor(pathToA);
        BasicBuildTests.assertEquals((String)"Wrong size", (int)2, (int)markers.length);
        try {
            IMarker marker = markers[1];
            Object priority = marker.getAttribute("priority");
            String message = (String)marker.getAttribute("message");
            BasicBuildTests.assertEquals((String)"Wrong message", (String)"TODO need to review the loop", (String)message);
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(1), (Object)priority);
            marker = markers[0];
            priority = marker.getAttribute("priority");
            message = (String)marker.getAttribute("message");
            BasicBuildTests.assertEquals((String)"Wrong message", (String)"TODO need to review the loop", (String)message);
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(1), (Object)priority);
        }
        catch (CoreException coreException) {
            BasicBuildTests.assertTrue((boolean)false);
        }
        JavaCore.setOptions((Hashtable)options);
    }

    public void testTags3() throws CoreException {
        Hashtable options = JavaCore.getOptions();
        try {
            Hashtable newOptions = JavaCore.getOptions();
            newOptions.put("org.eclipse.jdt.core.compiler.taskTags", "TODO,FIXME,XXX");
            newOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL,HIGH,LOW");
            JavaCore.setOptions((Hashtable)newOptions);
            IPath projectPath = env.addProject("Project");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            env.removePackageFragmentRoot(projectPath, "");
            IPath root = env.addPackageFragmentRoot(projectPath, "src");
            env.setOutputFolder(projectPath, "bin");
            IPath pathToA = env.addClass(root, "p", "A", "package p; \n// TODO need to review\npublic class A {\n}");
            this.fullBuild(projectPath);
            IMarker[] markers = env.getTaskMarkersFor(pathToA);
            BasicBuildTests.assertEquals((String)"Marker should not be editable", (Object)Boolean.FALSE, (Object)markers[0].getAttribute("userEditable"));
        }
        finally {
            JavaCore.setOptions((Hashtable)options);
        }
    }

    public void testUnusedImport() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "util", "MyException", "package util;\npublic class MyException extends Exception {\n\tprivate static final long serialVersionUID = 1L;\n}");
        env.addClass(root, "p", "Test", "package p;\nimport util.MyException;\npublic class Test {\n\t/**\n\t * @throws MyException\n\t */\n\tpublic void bar() {\n\t}\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        JavaCore.setOptions((Hashtable)options);
    }

    public void test98667() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Aaa$Bbb$Ccc", "package p1;\n\npublic class Aaa$Bbb$Ccc {\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testBug164707() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        IJavaProject javaProject = env.getJavaProject(projectPath);
        javaProject.setOption("org.eclipse.jdt.core.compiler.source", "invalid");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }

    public void _testUpdateProjectPreferences() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "util", "MyException", "package util;\npublic class MyException extends Exception {\n\tprivate static final long serialVersionUID = 1L;\n}");
        IPath cuPath = env.addClass(root, "p", "Test", "package p;\nimport util.MyException;\npublic class Test {\n}");
        this.fullBuild(projectPath);
        this.expectingSpecificProblemFor(projectPath, new Problem("", "The import util.MyException is never used", cuPath, 18, 34, 120, 1));
        IJavaProject project = env.getJavaProject(projectPath);
        project.setOption("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void _testUpdateWkspPreferences() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "util", "MyException", "package util;\npublic class MyException extends Exception {\n\tprivate static final long serialVersionUID = 1L;\n}");
        IPath cuPath = env.addClass(root, "p", "Test", "package p;\nimport util.MyException;\npublic class Test {\n}");
        this.fullBuild();
        this.expectingSpecificProblemFor(projectPath, new Problem("", "The import util.MyException is never used", cuPath, 18, 34, 120, 1));
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        IEclipsePreferences preferences = manager.getInstancePreferences();
        String unusedImport = preferences.get("org.eclipse.jdt.core.compiler.problem.unusedImport", null);
        try {
            preferences.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
            this.incrementalBuild();
            this.expectingNoProblems();
        }
        finally {
            if (unusedImport == null) {
                preferences.remove("org.eclipse.jdt.core.compiler.problem.unusedImport");
            } else {
                preferences.put("org.eclipse.jdt.core.compiler.problem.unusedImport", unusedImport);
            }
        }
    }

    public void testTags4() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.taskTags", "TODO!,TODO,TODO?");
        newOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "HIGH,NORMAL,LOW");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath pathToA = env.addClass(root, "p", "A", "package p; \n// TODO! TODO? need to review the loop\npublic class A {\n}");
        this.fullBuild(projectPath);
        IMarker[] markers = env.getTaskMarkersFor(pathToA);
        BasicBuildTests.assertEquals((String)"Wrong size", (int)2, (int)markers.length);
        try {
            IMarker marker = markers[1];
            Object priority = marker.getAttribute("priority");
            String message = (String)marker.getAttribute("message");
            BasicBuildTests.assertEquals((String)"Wrong message", (String)"TODO? need to review the loop", (String)message);
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(0), (Object)priority);
            marker = markers[0];
            priority = marker.getAttribute("priority");
            message = (String)marker.getAttribute("message");
            BasicBuildTests.assertEquals((String)"Wrong message", (String)"TODO! need to review the loop", (String)message);
            BasicBuildTests.assertNotNull((String)"No task priority", (Object)priority);
            BasicBuildTests.assertEquals((String)"Wrong priority", (Object)new Integer(2), (Object)priority);
        }
        catch (CoreException coreException) {
            BasicBuildTests.assertTrue((boolean)false);
        }
        JavaCore.setOptions((Hashtable)options);
    }

    public void testBug392727() throws JavaModelException {
        int save = AbstractImageBuilder.MAX_AT_ONCE;
        try {
            IPath projectPath = env.addProject("Project");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            env.removePackageFragmentRoot(projectPath, "");
            IPath root = env.addPackageFragmentRoot(projectPath, "src");
            env.setOutputFolder(projectPath, "bin");
            env.addClass(root, "pack", "Zork", "package pack;\npublic class Zork { Main main; }\n");
            env.addClass(root, "pack", "Main", "package pack;\npublic class Main {\n\tMain$Sub sub;\n}\n");
            env.addClass(root, "pack", "Main$Sub", "package pack;\npublic class Main$Sub { }\n");
            AbstractImageBuilder.MAX_AT_ONCE = 1;
            this.fullBuild(projectPath);
            this.expectingNoProblems();
        }
        finally {
            AbstractImageBuilder.MAX_AT_ONCE = save;
        }
    }

    public void testbBug386901() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "AA", "package p;\t\npublic class AA {}\t\nclass AZ {}");
        IPath pathToAB = env.addClass(root, "p", "AB", "package p;\t\npublic class AB extends AZ {}");
        int previous = AbstractImageBuilder.MAX_AT_ONCE;
        AbstractImageBuilder.MAX_AT_ONCE = 1;
        this.fullBuild(projectPath);
        this.expectingProblemsFor(pathToAB, "Problem : AZ cannot be resolved to a type [ resource : </Project/src/p/AB.java> range : <36,38> category : <40> severity : <2>]");
        AbstractImageBuilder.MAX_AT_ONCE = 0;
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        BasicBuildTests.assertEquals((String)"Incorrect value", (int)0, (int)previous);
    }

    public void testBug425420() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath path = env.addClass(root, "", "X", "class X {\n  void test() {\n\tint x = 0;\n\tint y = 0 >= 0 ? x : \"\"; \n  }\n}");
        this.fullBuild(projectPath);
        this.expectingProblemsFor(path, "Problem : The type java.lang.Object cannot be resolved. It is indirectly referenced from required .class files [ resource : </Project/src/X.java> range : <0,1> category : <10> severity : <2>]");
    }
}

