/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.builder.EfficiencyCompilerRequestor;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.builder.TestingEnvironment;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.TestVerifier;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.core.util.Util;

public class BuilderTests
extends TestCase {
    protected static boolean DEBUG = false;
    protected static TestingEnvironment env = null;
    protected EfficiencyCompilerRequestor debugRequestor = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;

    public BuilderTests(String name) {
        super(name);
    }

    protected void cleanBuild() {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.cleanBuild();
        this.debugRequestor.deactivate();
    }

    protected void cleanBuild(String name) {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.cleanBuild(name);
        this.debugRequestor.deactivate();
    }

    protected void executeClass(IPath projectPath, String className, String expectingOutput, String expectedError) {
        TestVerifier verifier = new TestVerifier(false);
        Vector<String> classpath = new Vector<String>(5);
        IPath workspacePath = env.getWorkspaceRootPath();
        classpath.addElement(workspacePath.append(env.getOutputLocation(projectPath)).toOSString());
        IClasspathEntry[] cp = env.getClasspath(projectPath);
        int i = 0;
        while (i < cp.length) {
            IPath c = cp[i].getPath();
            String ext = c.getFileExtension();
            if (ext != null && (ext.equals("zip") || ext.equals("jar"))) {
                if (c.getDevice() == null) {
                    classpath.addElement(workspacePath.append(c).toOSString());
                } else {
                    classpath.addElement(c.toOSString());
                }
            }
            ++i;
        }
        verifier.execute(className, classpath.toArray(new String[0]));
        if (DEBUG) {
            System.out.println("ERRORS\n");
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString((String)verifier.getExecutionError()));
            System.out.println("OUTPUT\n");
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString((String)verifier.getExecutionOutput()));
        }
        String actualError = verifier.getExecutionError();
        char[] error = actualError.toCharArray();
        if ((actualError = new String(CharOperation.replace((char[])error, (char[])System.getProperty("line.separator").toCharArray(), (char[])new char[]{'\n'}))).indexOf(expectedError) == -1) {
            System.out.println("ERRORS\n");
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString((String)actualError));
        }
        BuilderTests.assertTrue((String)("unexpected error : " + actualError + " expected : " + expectedError), (actualError.indexOf(expectedError) != -1 ? 1 : 0) != 0);
        String actualOutput = verifier.getExecutionOutput();
        if (actualOutput.indexOf(expectingOutput) == -1) {
            System.out.println("OUTPUT\n");
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString((String)actualOutput));
        }
        BuilderTests.assertTrue((String)("unexpected output :" + actualOutput + " expected: " + expectingOutput), (actualOutput.indexOf(expectingOutput) != -1 ? 1 : 0) != 0);
    }

    protected void expectingParticipantProblems(IPath path, String expected) {
        Problem[] problems = env.getProblemsFor(path, "org.eclipse.jdt.core.tests.compile.problem");
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int length = problems.length;
        while (i < length) {
            Problem problem = problems[i];
            buf.append(problem.getMessage());
            if (i < length - 1) {
                buf.append('\n');
            }
            ++i;
        }
        BuilderTests.assertEquals((String)"Unexpected problems", (String)expected, (String)buf.toString());
    }

    protected void expectingPresenceOf(IPath path) {
        this.expectingPresenceOf(new IPath[]{path});
    }

    protected void expectingPresenceOf(IPath[] paths) {
        IPath wRoot = env.getWorkspaceRootPath();
        int i = 0;
        while (i < paths.length) {
            BuilderTests.assertTrue((String)(paths[i] + " is not present"), (boolean)wRoot.append(paths[i]).toFile().exists());
            ++i;
        }
    }

    protected void expectingNoPresenceOf(IPath path) {
        this.expectingNoPresenceOf(new IPath[]{path});
    }

    protected void expectingNoPresenceOf(IPath[] paths) {
        IPath wRoot = env.getWorkspaceRootPath();
        int i = 0;
        while (i < paths.length) {
            BuilderTests.assertTrue((String)(paths[i] + " is present"), (!wRoot.append(paths[i]).toFile().exists() ? 1 : 0) != 0);
            ++i;
        }
    }

    protected void expectingCompiledClasses(String[] expected) {
        String[] actual = this.debugRequestor.getCompiledClasses();
        Util.sort((String[])actual);
        Util.sort((String[])expected);
        this.expectingCompiling(actual, expected, "unexpected recompiled units");
    }

    protected void expectingUniqueCompiledClasses(String[] expected) {
        String[] actual = this.debugRequestor.getCompiledClasses();
        Util.sort((String[])actual);
        int dups = 0;
        int i = 0;
        while (i < actual.length - 1) {
            if (actual[i + 1].equals(actual[i])) {
                ++dups;
                actual[i] = null;
            }
            ++i;
        }
        String[] uniqueActual = new String[actual.length - dups];
        int i2 = 0;
        int j = 0;
        while (i2 < actual.length) {
            if (actual[i2] != null) {
                uniqueActual[j++] = actual[i2];
            }
            ++i2;
        }
        Util.sort((String[])expected);
        this.expectingCompiling(uniqueActual, expected, "unexpected compiled units");
    }

    protected void expectingCompilingOrder(String[] expected) {
        this.expectingCompiling(this.debugRequestor.getCompiledClasses(), expected, "unexpected compiling order");
    }

    private void expectingCompiling(String[] actual, String[] expected, String message) {
        if (DEBUG) {
            int i = 0;
            while (i < actual.length) {
                System.out.println(actual[i]);
                ++i;
            }
        }
        StringBuffer actualBuffer = new StringBuffer("{");
        int i = 0;
        while (i < actual.length) {
            if (i > 0) {
                actualBuffer.append(",");
            }
            actualBuffer.append(actual[i]);
            ++i;
        }
        actualBuffer.append('}');
        StringBuffer expectedBuffer = new StringBuffer("{");
        int i2 = 0;
        while (i2 < expected.length) {
            if (i2 > 0) {
                expectedBuffer.append(",");
            }
            expectedBuffer.append(expected[i2]);
            ++i2;
        }
        expectedBuffer.append('}');
        BuilderTests.assertEquals((String)message, (String)expectedBuffer.toString(), (String)actualBuffer.toString());
    }

    protected void expectingNoProblems() {
        this.expectingNoProblemsFor(env.getWorkspaceRootPath());
    }

    protected void expectingNoProblemsFor(IPath root) {
        this.expectingNoProblemsFor(new IPath[]{root});
    }

    protected void expectingNoProblemsFor(IPath[] roots) {
        StringBuffer buffer = new StringBuffer();
        Problem[] allProblems = this.allSortedProblems(roots);
        if (allProblems != null) {
            int i = 0;
            int length = allProblems.length;
            while (i < length) {
                buffer.append(allProblems[i] + "\n");
                ++i;
            }
        }
        String actual = buffer.toString();
        this.assumeEquals("Unexpected problem(s)!!!", "", actual);
    }

    protected void expectingOnlyProblemsFor(IPath expected) {
        this.expectingOnlyProblemsFor(new IPath[]{expected});
    }

    protected void expectingOnlyProblemsFor(IPath[] expected) {
        if (DEBUG) {
            this.printProblems();
        }
        Problem[] rootProblems = env.getProblems();
        Hashtable<IPath, IPath> actual = new Hashtable<IPath, IPath>(rootProblems.length * 2 + 1);
        int i = 0;
        while (i < rootProblems.length) {
            IPath culprit = rootProblems[i].getResourcePath();
            actual.put(culprit, culprit);
            ++i;
        }
        i = 0;
        while (i < expected.length) {
            if (!actual.containsKey(expected[i])) {
                BuilderTests.assertTrue((String)("missing expected problem with " + expected[i].toString()), (boolean)false);
            }
            ++i;
        }
        if (actual.size() > expected.length) {
            Enumeration e = actual.elements();
            while (e.hasMoreElements()) {
                IPath path = (IPath)e.nextElement();
                boolean found = false;
                int i2 = 0;
                while (i2 < expected.length) {
                    if (path.equals((Object)expected[i2])) {
                        found = true;
                        break;
                    }
                    ++i2;
                }
                if (found) continue;
                BuilderTests.assertTrue((String)("unexpected problem(s) with " + path.toString()), (boolean)false);
            }
        }
    }

    protected void expectingOnlySpecificProblemFor(IPath root, Problem problem) {
        this.expectingOnlySpecificProblemsFor(root, new Problem[]{problem});
    }

    protected void expectingOnlySpecificProblemsFor(IPath root, Problem[] expectedProblems) {
        if (DEBUG) {
            this.printProblemsFor(root);
        }
        Problem[] rootProblems = env.getProblemsFor(root);
        int i = 0;
        while (i < expectedProblems.length) {
            Problem expectedProblem = expectedProblems[i];
            boolean found = false;
            int j = 0;
            while (j < rootProblems.length) {
                if (expectedProblem.equals(rootProblems[j])) {
                    found = true;
                    rootProblems[j] = null;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.printProblemsFor(root);
            }
            BuilderTests.assertTrue((String)("problem not found: " + expectedProblem.toString()), (boolean)found);
            ++i;
        }
        i = 0;
        while (i < rootProblems.length) {
            if (rootProblems[i] != null) {
                this.printProblemsFor(root);
                BuilderTests.assertTrue((String)("unexpected problem: " + rootProblems[i].toString()), (boolean)false);
            }
            ++i;
        }
    }

    protected void expectingProblemsFor(IPath root, String expected) {
        this.expectingProblemsFor(new IPath[]{root}, expected);
    }

    protected void expectingProblemsFor(IPath[] roots, String expected) {
        Object[] problems = this.allSortedProblems(roots);
        this.assumeEquals("Invalid problem(s)!!!", expected, this.arrayToString(problems));
    }

    protected void expectingProblemsFor(IPath root, List expected) {
        this.expectingProblemsFor(new IPath[]{root}, expected);
    }

    protected void expectingProblemsFor(IPath[] roots, List expected) {
        Object[] allProblems = this.allSortedProblems(roots);
        this.assumeEquals("Invalid problem(s)!!!", this.arrayToString(expected.toArray()), this.arrayToString(allProblems));
    }

    protected void expectingSpecificProblemFor(IPath root, Problem problem) {
        this.expectingSpecificProblemsFor(root, new Problem[]{problem});
    }

    protected void expectingSpecificProblemsFor(IPath root, Problem[] problems) {
        if (DEBUG) {
            this.printProblemsFor(root);
        }
        Object[] rootProblems = env.getProblemsFor(root);
        int i = 0;
        while (i < problems.length) {
            block4: {
                Problem problem = problems[i];
                int j = 0;
                while (j < rootProblems.length) {
                    Problem rootProblem = rootProblems[j];
                    if (rootProblem != null && problem.equals(rootProblem)) {
                        rootProblems[j] = null;
                        break block4;
                    }
                    ++j;
                }
                System.out.println("--------------------------------------------------------------------------------");
                System.out.println("Missing problem while running test " + this.getName() + ":");
                System.out.println("\t- expected : " + problem);
                System.out.println("\t- current: " + this.arrayToString(rootProblems));
                this.assumeTrue("missing expected problem: " + problem, false);
            }
            ++i;
        }
    }

    protected void fullBuild() {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.fullBuild();
        this.debugRequestor.deactivate();
    }

    protected void fullBuild(IPath projectPath) {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.fullBuild(projectPath);
        this.debugRequestor.deactivate();
    }

    protected void incrementalBuild(IPath projectPath) {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.incrementalBuild(projectPath);
        this.debugRequestor.deactivate();
    }

    protected void incrementalBuild() {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.incrementalBuild();
        this.debugRequestor.deactivate();
    }

    protected void printProblems() {
        this.printProblemsFor(env.getWorkspaceRootPath());
    }

    protected void printProblemsFor(IPath root) {
        this.printProblemsFor(new IPath[]{root});
    }

    protected void printProblemsFor(IPath[] roots) {
        int i = 0;
        while (i < roots.length) {
            IPath path = roots[i];
            Object[] problems = env.getProblemsFor(path);
            System.out.println(this.arrayToString(problems));
            System.out.println();
            ++i;
        }
    }

    protected String arrayToString(Object[] array) {
        StringBuffer buffer = new StringBuffer();
        int length = array == null ? 0 : array.length;
        int i = 0;
        while (i < length) {
            if (array[i] != null) {
                if (i > 0) {
                    buffer.append('\n');
                }
                buffer.append(array[i].toString());
            }
            ++i;
        }
        return buffer.toString();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.debugRequestor = new EfficiencyCompilerRequestor();
        Compiler.DebugRequestor = this.debugRequestor;
        if (env == null) {
            env = new TestingEnvironment();
            env.openEmptyWorkspace();
        }
        env.resetWorkspace();
    }

    protected void tearDown() throws Exception {
        env.resetWorkspace();
        JavaCore.setOptions((Hashtable)JavaCore.getDefaultOptions());
        super.tearDown();
    }

    Problem[] allSortedProblems(IPath[] roots) {
        Problem[] allProblems = null;
        int i = 0;
        int max = roots.length;
        while (i < max) {
            Problem[] problems = env.getProblemsFor(roots[i]);
            int length = problems.length;
            if (problems.length != 0) {
                if (allProblems == null) {
                    allProblems = problems;
                } else {
                    int all = allProblems.length;
                    Problem[] problemArray = allProblems;
                    allProblems = new Problem[all + length];
                    System.arraycopy(problemArray, 0, allProblems, 0, all);
                    System.arraycopy(problems, 0, allProblems, all, length);
                }
            }
            ++i;
        }
        if (allProblems != null) {
            Arrays.sort(allProblems);
        }
        return allProblems;
    }

    private static Class[] getAllTestClasses() {
        Class[] classArray = new Class[17];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.AbstractMethodTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.tests.builder.BasicBuildTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.tests.builder.BuildpathTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jdt.core.tests.builder.CopyResourceTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jdt.core.tests.builder.DependencyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.jdt.core.tests.builder.ErrorsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[5] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.jdt.core.tests.builder.EfficiencyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[6] = clazz7;
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.eclipse.jdt.core.tests.builder.ExecutionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[7] = clazz8;
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.eclipse.jdt.core.tests.builder.IncrementalTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[8] = clazz9;
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("org.eclipse.jdt.core.tests.builder.IncrementalTests18");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[9] = clazz10;
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("org.eclipse.jdt.core.tests.builder.MultiProjectTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[10] = clazz11;
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("org.eclipse.jdt.core.tests.builder.MultiSourceFolderAndOutputFolderTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[11] = clazz12;
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("org.eclipse.jdt.core.tests.builder.OutputFolderTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[12] = clazz13;
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("org.eclipse.jdt.core.tests.builder.PackageTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[13] = clazz14;
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("org.eclipse.jdt.core.tests.builder.StaticFinalTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[14] = clazz15;
        Class<?> clazz16 = class$15;
        if (clazz16 == null) {
            try {
                clazz16 = class$15 = Class.forName("org.eclipse.jdt.core.tests.builder.GetResourcesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[15] = clazz16;
        Class<?> clazz17 = class$16;
        if (clazz17 == null) {
            try {
                clazz17 = class$16 = Class.forName("org.eclipse.jdt.core.tests.builder.FriendDependencyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[16] = clazz17;
        Class[] classes = classArray;
        if ((AbstractCompilerTest.getPossibleComplianceLevels() & 4) != 0) {
            int length = classes.length;
            Class[] classArray2 = classes;
            classes = new Class[length + 4];
            System.arraycopy(classArray2, 0, classes, 0, length);
            int n = length++;
            Class<?> clazz18 = class$17;
            if (clazz18 == null) {
                try {
                    clazz18 = class$17 = Class.forName("org.eclipse.jdt.core.tests.builder.Java50Tests");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classes[n] = clazz18;
            int n2 = length++;
            Class<?> clazz19 = class$18;
            if (clazz19 == null) {
                try {
                    clazz19 = class$18 = Class.forName("org.eclipse.jdt.core.tests.builder.PackageInfoTest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classes[n2] = clazz19;
            int n3 = length++;
            Class<?> clazz20 = class$19;
            if (clazz20 == null) {
                try {
                    clazz20 = class$19 = Class.forName("org.eclipse.jdt.core.tests.builder.ParticipantBuildTests");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classes[n3] = clazz20;
            int n4 = length++;
            Class<?> clazz21 = class$20;
            if (clazz21 == null) {
                try {
                    clazz21 = class$20 = Class.forName("org.eclipse.jdt.core.tests.builder.AnnotationDependencyTests");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classes[n4] = clazz21;
        }
        return classes;
    }

    public static Test suite() {
        Class<?> clazz = class$21;
        if (clazz == null) {
            try {
                clazz = class$21 = Class.forName("org.eclipse.jdt.core.tests.builder.BuilderTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class[] classes = BuilderTests.getAllTestClasses();
        TestCase.TESTS_PREFIX = null;
        TestCase.TESTS_NAMES = null;
        TestCase.TESTS_NUMBERS = null;
        TestCase.TESTS_RANGE = null;
        TestCase.RUN_ONLY_ID = null;
        int i = 0;
        int length = classes.length;
        while (i < length) {
            block10: {
                Object test;
                Method suiteMethod;
                Class clazz2 = classes[i];
                try {
                    suiteMethod = clazz2.getDeclaredMethod("suite", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    break block10;
                }
                try {
                    test = suiteMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    break block10;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    break block10;
                }
                suite.addTest((Test)test);
            }
            ++i;
        }
        return suite;
    }
}

