/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;

public class CopyResourceTests
extends BuilderTests {
    static /* synthetic */ Class class$0;

    public CopyResourceTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.CopyResourceTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CopyResourceTests.buildTestSuite((Class)clazz);
    }

    public void testFilteredResources() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "", new IPath[]{new Path("foo/;bar/")}, new IPath[]{new Path("foo/ignored/")}, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src, "foo", "A", "package foo;public class A extends bar.B {}");
        env.addClass(src, "bar", "B", "package bar;public class B {}");
        env.addFolder(src, "foo/skip");
        IPath ignored = env.addFolder(src, "foo/ignored");
        env.addFile(ignored, "test.txt", "test file");
        env.addFile(src.append("bar"), "test.txt", "test file");
        IJavaProject p = env.getJavaProject("P");
        Map options = p.getOptions(true);
        options.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", "bar*");
        options.put("org.eclipse.jdt.core.builder.recreateModifiedClassFileInOutputFolder", "enabled");
        p.setOptions(options);
        int max = AbstractImageBuilder.MAX_AT_ONCE;
        try {
            AbstractImageBuilder.MAX_AT_ONCE = 1;
            this.fullBuild();
            this.expectingNoProblems();
            this.expectingNoPresenceOf(projectPath.append("bin/foo/skip/"));
            this.expectingNoPresenceOf(projectPath.append("bin/foo/ignored/"));
            this.expectingNoPresenceOf(projectPath.append("bin/bar/test.txt"));
            env.removeFolder(projectPath.append("bin/bar"));
            env.addClass(src, "x", "A", "package x;public class A extends bar.B {}");
            env.addFile(src.append("bar"), "test.txt", "changed test file");
            this.incrementalBuild();
            this.expectingNoProblems();
            this.expectingNoPresenceOf(projectPath.append("bin/foo/skip/"));
            this.expectingNoPresenceOf(projectPath.append("bin/foo/ignored/"));
            this.expectingNoPresenceOf(projectPath.append("bin/bar/test.txt"));
        }
        finally {
            AbstractImageBuilder.MAX_AT_ONCE = max;
        }
    }

    public void testSimpleProject() throws JavaModelException {
        IPath projectPath = env.addProject("P1");
        IPath src = env.getPackageFragmentRootPath(projectPath, "");
        env.setOutputFolder(projectPath, "");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addFile(src, "z.txt", "");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(projectPath.append("z.txt"));
        env.removeFile(src.append("z.txt"));
        IPath p = env.addFolder(src, "p");
        env.addFile(p, "p.txt", "");
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingNoPresenceOf(projectPath.append("z.txt"));
        this.expectingPresenceOf(p.append("p.txt"));
    }

    public void testProjectWithBin() throws JavaModelException {
        IPath projectPath = env.addProject("P2");
        IPath src = env.getPackageFragmentRootPath(projectPath, "");
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addFile(src, "z.txt", "");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{projectPath.append("z.txt"), projectPath.append("bin/z.txt")});
        env.removeFile(src.append("z.txt"));
        IPath p = env.addFolder(src, "p");
        env.addFile(p, "p.txt", "");
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingNoPresenceOf(new IPath[]{projectPath.append("z.txt"), projectPath.append("bin/z.txt")});
        this.expectingPresenceOf(new IPath[]{projectPath.append("p/p.txt"), projectPath.append("bin/p/p.txt")});
    }

    public void testProjectWithSrcBin() throws JavaModelException {
        IPath projectPath = env.addProject("P3");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addFile(src, "z.txt", "");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{projectPath.append("src/z.txt"), projectPath.append("bin/z.txt")});
        env.removeFile(src.append("z.txt"));
        env.addFile(src, "zz.txt", "");
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingNoPresenceOf(new IPath[]{projectPath.append("src/z.txt"), projectPath.append("bin/z.txt")});
        this.expectingPresenceOf(new IPath[]{projectPath.append("src/zz.txt"), projectPath.append("bin/zz.txt")});
    }

    public void testProjectWith2SrcBin() throws JavaModelException {
        IPath projectPath = env.addProject("P4");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1");
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src2");
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addFile(src1, "z.txt", "");
        env.addFile(src2, "zz.txt", "");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{projectPath.append("src1/z.txt"), projectPath.append("bin/z.txt"), projectPath.append("src2/zz.txt"), projectPath.append("bin/zz.txt")});
        env.removeFile(src2.append("zz.txt"));
        IPath p = env.addFolder(src2, "p");
        env.addFile(p, "p.txt", "");
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingNoPresenceOf(new IPath[]{projectPath.append("src2/zz.txt"), projectPath.append("bin/zz.txt")});
        this.expectingPresenceOf(new IPath[]{projectPath.append("src2/p/p.txt"), projectPath.append("bin/p/p.txt")});
    }

    public void testProjectWith2SrcAsBin() throws JavaModelException {
        IPath projectPath = env.addProject("P5");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1", null, "src1");
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src2", null, "src2");
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addFile(src1, "z.txt", "");
        env.addFile(src2, "zz.txt", "");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{projectPath.append("src1/z.txt"), projectPath.append("src2/zz.txt")});
        this.expectingNoPresenceOf(new IPath[]{projectPath.append("src2/z.txt"), projectPath.append("bin")});
    }

    public void testProjectWith2Src2Bin() throws JavaModelException {
        IPath projectPath = env.addProject("P6");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1", null, "bin1");
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src2", null, "bin2");
        env.setOutputFolder(projectPath, "bin1");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addFile(src1, "z.txt", "");
        env.addFile(src2, "zz.txt", "");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(new IPath[]{projectPath.append("bin1/z.txt"), projectPath.append("bin2/zz.txt")});
        this.expectingNoPresenceOf(new IPath[]{projectPath.append("bin1/zz.txt"), projectPath.append("bin2/z.txt")});
    }

    public void test2ProjectWith1Bin() throws JavaModelException {
        IPath projectPath = env.addProject("P7");
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IPath projectPath2 = env.addProject("P8");
        IPath binLocation = env.getProject(projectPath).getFolder("bin").getLocation();
        env.setExternalOutputFolder(projectPath2, "externalBin", binLocation);
        env.addExternalJars(projectPath2, Util.getJavaClassLibs());
        env.addFile(projectPath2, "z.txt", "");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(bin.append("z.txt"));
    }

    public void testBug154693() throws JavaModelException {
        IPath projectPath = env.addProject("P9");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IJavaProject p = env.getJavaProject("P9");
        Map options = p.getOptions(true);
        options.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", ".svn/");
        p.setOptions(options);
        IPath folder = env.addFolder(src, "p");
        env.addFolder(folder, ".svn");
        env.addFile(folder, "A.java", "package p;\nclass A{}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingNoPresenceOf(new IPath[]{projectPath.append("bin/p/.svn")});
    }

    public void testBug194420() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "src");
        IPath bin = env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IPath folder = env.addFolder(src, "p");
        String testContents = "incremental test contents";
        IPath zPath = env.addFile(folder, "z.txt", testContents);
        IPath zBinPath = bin.append("p/z.txt");
        IFile zFile = env.getWorkspace().getRoot().getFile(zPath);
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(zBinPath);
        try {
            byte[] contents = new byte[testContents.length()];
            InputStream stream = zFile.getContents();
            stream.read(contents);
            stream.close();
            this.assumeEquals("File was not copied", testContents, new String(contents));
        }
        catch (Exception exception) {
            CopyResourceTests.fail((String)"File was not copied");
        }
        File file = new File(zFile.getLocation().toOSString());
        file.delete();
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingNoPresenceOf(zBinPath);
        testContents = "incremental test contents";
        env.addFile(folder, "z.txt", testContents);
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(zBinPath);
        try {
            byte[] contents = new byte[testContents.length()];
            InputStream stream = zFile.getContents();
            stream.read(contents);
            stream.close();
            this.assumeEquals("File was not copied", testContents, new String(contents));
        }
        catch (Exception exception) {
            CopyResourceTests.fail((String)"File was not copied");
        }
        env.addFile(folder, "z.txt", "about to be deleted");
        file.delete();
        this.incrementalBuild();
        this.expectingNoProblems();
        this.expectingNoPresenceOf(zBinPath);
    }
}

