/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;

public class DependencyTests
extends BuilderTests {
    static /* synthetic */ Class class$0;

    public DependencyTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.DependencyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return DependencyTests.buildTestSuite((Class)clazz);
    }

    public void testAbstractMethod() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Indicted", "package p1;\npublic abstract class Indicted {\n}\n");
        IPath collaboratorPath = env.addClass(root, "p2", "Collaborator", "package p2;\nimport p1.*;\npublic class Collaborator extends Indicted{\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "Indicted", "package p1;\npublic abstract class Indicted {\n   public abstract void foo();\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(collaboratorPath);
        this.expectingOnlySpecificProblemFor(collaboratorPath, new Problem("Collaborator", "The type Collaborator must implement the inherited abstract method Indicted.foo()", collaboratorPath, 38, 50, 50, 2));
    }

    public void testCaseInvariantType() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IJavaProject p = env.getJavaProject("Project");
        Map options = p.getOptions(true);
        options.put("org.eclipse.jdt.core.builder.cleanOutputFolder", "disabled");
        p.setOptions(options);
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tclass Node {}\n}");
        env.addClass(root, "p1", "Bb", "package p1;\nclass Bb {}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tclass node {}\n}");
        env.addClass(root, "p1", "Bb", "package p1;\nclass BB {}");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testExactMethodDeleting() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i(int i) {return 1;};\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{\n\tint j = i(1);\n}\n");
        IPath dPath = env.addClass(root, "p3", "D", "package p3;\npublic class D extends p2.B{\n\tpublic class M {\n\t\tint j = i(1);\n\t}\n}\n");
        IPath xPath = env.addClass(root, "p4", "X", "package p4;\npublic class X {\n\tint foo(p3.C c) { return c.i(1); }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{cPath, dPath, xPath});
        this.expectingSpecificProblemFor(cPath, new Problem("C", "The method i(int) is undefined for the type C", cPath, 50, 51, 50, 2));
        this.expectingSpecificProblemFor(dPath, new Problem("D", "The method i(int) is undefined for the type D.M", dPath, 69, 70, 50, 2));
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The method i(int) is undefined for the type C", xPath, 57, 58, 50, 2));
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n\tprotected int i(long l) throws Exception {return 1;};\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{cPath, dPath, xPath});
        this.expectingSpecificProblemFor(cPath, new Problem("C", "Default constructor cannot handle exception type Exception thrown by implicit super constructor. Must define an explicit constructor", cPath, 50, 54, 40, 2));
        this.expectingSpecificProblemFor(dPath, new Problem("D", "Default constructor cannot handle exception type Exception thrown by implicit super constructor. Must define an explicit constructor", dPath, 69, 73, 40, 2));
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The method i(long) from the type B is not visible", xPath, 57, 58, 50, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i(int i) {return 1;};\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testExactMethodVisibility() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i() {return 1;};\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{\n\tint j = i();\n}\n");
        IPath dPath = env.addClass(root, "p3", "D", "package p3;\npublic class D extends p2.B{\n\tpublic class M {\n\t\tint j = i();\n\t}\n}\n");
        IPath xPath = env.addClass(root, "p4", "X", "package p4;\npublic class X {\n\tint foo(p3.C c) { return c.i(); }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tint i() {return 1;};\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{cPath, dPath, xPath});
        this.expectingSpecificProblemFor(cPath, new Problem("C", "The method i() from the type A is not visible", cPath, 50, 51, 50, 2));
        this.expectingSpecificProblemFor(dPath, new Problem("D", "The method i() from the type A is not visible", dPath, 69, 70, 50, 2));
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The method i() from the type A is not visible", xPath, 57, 58, 50, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tprotected int i() {return 1;};\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{xPath});
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The method i() from the type A is not visible", xPath, 57, 58, 50, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i() {return 1;};\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testExternalJarChanged() throws CoreException, IOException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IPath root = env.getPackageFragmentRootPath(projectPath, "");
        IPath classTest = env.addClass(root, "p", "X", "package p;\npublic class X {\n  void foo() {\n    new q.Y().bar();\n  }\n}");
        String externalJar = String.valueOf(Util.getOutputDirectory()) + File.separator + "test.jar";
        Util.createJar((String[])new String[]{"q/Y.java", "package q;\npublic class Y {\n}"}, new HashMap(), (String)externalJar);
        env.addExternalJar(projectPath, externalJar);
        this.fullBuild();
        this.expectingProblemsFor(classTest, "Problem : The method bar() is undefined for the type Y [ resource : </Project/p/X.java> range : <57,60> category : <50> severity : <2>]");
        Util.createJar((String[])new String[]{"q/Y.java", "package q;\npublic class Y {\n  public void bar() {\n  }\n}"}, new HashMap(), (String)externalJar);
        env.getProject(projectPath).touch(null);
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void testFieldDeleting() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i;\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{\n\tint j = i;\n}\n");
        IPath xPath = env.addClass(root, "p4", "X", "package p4;\npublic class X {\n\tint foo(p3.C c) { return c.i; }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{cPath, xPath});
        this.expectingSpecificProblemFor(cPath, new Problem("C", "i cannot be resolved to a variable", cPath, 50, 51, 50, 2));
        this.expectingSpecificProblemFor(xPath, new Problem("X", "i cannot be resolved or is not a field", xPath, 57, 58, 50, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i;\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testFieldVisibility() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i;\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{\n\tint j = i;\n}\n");
        IPath xPath = env.addClass(root, "p4", "X", "package p4;\npublic class X {\n\tint foo(p3.C c) { return c.i; }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tint i;\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{cPath, xPath});
        this.expectingSpecificProblemFor(cPath, new Problem("C", "The field A.i is not visible", cPath, 50, 51, 50, 2));
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The field A.i is not visible", xPath, 57, 58, 50, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tprotected int i;\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{xPath});
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The field A.i is not visible", xPath, 57, 58, 50, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i;\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testInterfaceDeleting() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Vehicle", "package p1;\npublic interface Vehicle {}\n");
        env.addClass(root, "p1", "Car", "package p1;\npublic interface Car extends Vehicle {}\n");
        env.addClass(root, "p1", "CarImpl", "package p1;\npublic class CarImpl implements Car {}\n");
        IPath testPath = env.addClass(root, "p1", "Test", "package p1;\npublic class Test { public Vehicle createVehicle() { return new CarImpl(); } }\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "Car", "package p1;\npublic interface Car {}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(testPath);
        this.expectingSpecificProblemFor(testPath, new Problem("Test", "Type mismatch: cannot convert from CarImpl to Vehicle", testPath, 72, 85, 40, 2));
        env.addClass(root, "p1", "Car", "package p1;\npublic interface Car extends Vehicle {}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMemberTypeDeleting() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic class M { public int i; };\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{\n\tM m;\n}\n");
        IPath xPath = env.addClass(root, "p4", "X", "package p4;\npublic class X {\n\tint foo(p3.C.M m) { return m.i; }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{cPath, xPath});
        this.expectingSpecificProblemFor(cPath, new Problem("C", "M cannot be resolved to a type", cPath, 42, 43, 40, 2));
        this.expectingSpecificProblemFor(xPath, new Problem("X", "p3.C.M cannot be resolved to a type", xPath, 38, 44, 40, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic class M { public int i; };\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMemberTypeVisibility() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic class M { public int i; };\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{\n\tM m;\n}\n");
        IPath xPath = env.addClass(root, "p4", "X", "package p4;\npublic class X {\n\tint foo(p3.C.M m) { return m.i; }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tclass M { public int i; };\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{cPath, xPath});
        this.expectingSpecificProblemFor(cPath, new Problem("C", "The type M is not visible", cPath, 42, 43, 40, 2));
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The type p3.C.M is not visible", xPath, 38, 44, 40, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tprotected class M { public int i; };\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{xPath});
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The type p3.C.M is not visible", xPath, 38, 44, 40, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic class M { public int i; };\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMethodDeleting() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i(A a) {return 1;};\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{\n\tint j = i(this);\n}\n");
        IPath dPath = env.addClass(root, "p3", "D", "package p3;\npublic class D extends p2.B{\n\tpublic class M {\n\t\tint j = i(new D());\n\t}\n}\n");
        IPath xPath = env.addClass(root, "p4", "X", "package p4;\npublic class X {\n\tint foo(p3.C c) { return c.i(c); }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{cPath, dPath, xPath});
        this.expectingSpecificProblemFor(cPath, new Problem("C", "The method i(C) is undefined for the type C", cPath, 50, 51, 50, 2));
        this.expectingSpecificProblemFor(dPath, new Problem("D", "The method i(D) is undefined for the type D.M", dPath, 69, 70, 50, 2));
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The method i(C) is undefined for the type C", xPath, 57, 58, 50, 2));
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n\tpublic int i(B b) {return 1;};\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i(A a) {return 1;};\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMethodVisibility() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i(A a) {return 1;};\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{\n\tint j = i(this);\n}\n");
        IPath dPath = env.addClass(root, "p3", "D", "package p3;\npublic class D extends p2.B{\n\tpublic class M {\n\t\tint j = i(new D());\n\t}\n}\n");
        IPath xPath = env.addClass(root, "p4", "X", "package p4;\npublic class X {\n\tint foo(p3.C c) { return c.i(c); }\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tint i(A a) {return 1;};\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{cPath, dPath, xPath});
        this.expectingSpecificProblemFor(cPath, new Problem("C", "The method i(A) from the type A is not visible", cPath, 50, 51, 50, 2));
        this.expectingSpecificProblemFor(dPath, new Problem("D", "The method i(A) from the type A is not visible", dPath, 69, 70, 50, 2));
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The method i(A) from the type A is not visible", xPath, 57, 58, 50, 2));
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n\tprotected int i(B b) {return 1;};\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{xPath});
        this.expectingSpecificProblemFor(xPath, new Problem("X", "The method i(B) from the type B is not visible", xPath, 57, 58, 50, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tpublic int i(A a) {return 1;};\n}\n");
        env.addClass(root, "p2", "B", "package p2;\nimport p1.*;\npublic class B extends A{\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testMissingClassFile() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(project1Path, "");
        IPath root1 = env.addPackageFragmentRoot(project1Path, "src");
        env.setOutputFolder(project1Path, "bin");
        env.addClass(root1, "p1", "MissingClass", "package p1;\npublic class MissingClass {}");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        env.removePackageFragmentRoot(project2Path, "");
        IPath root2 = env.addPackageFragmentRoot(project2Path, "src");
        env.setOutputFolder(project2Path, "bin");
        env.addClass(root2, "p2", "A", "package p2;\nimport p1.MissingClass;\npublic class A {\n\tpublic void foo(MissingClass data) {}\n\tpublic void foo(String data) {}\n}\n");
        IPath project3Path = env.addProject("Project3");
        env.addExternalJars(project3Path, Util.getJavaClassLibs());
        env.addRequiredProject(project3Path, project2Path);
        env.removePackageFragmentRoot(project3Path, "");
        IPath root3 = env.addPackageFragmentRoot(project3Path, "src");
        env.setOutputFolder(project3Path, "bin");
        IPath bPath = env.addClass(root3, "p3", "B", "package p3;\nimport p2.A;\npublic class B {\n\tpublic static void main(String[] args) {\n\t\tnew A().foo(new String());\n\t}\n}\n");
        this.fullBuild();
        this.expectingOnlyProblemsFor(new IPath[]{project3Path, bPath});
        this.expectingSpecificProblemFor(project3Path, new Problem("Project3", "The project was not built since its build path is incomplete. Cannot find the class file for p1.MissingClass. Fix the build path then try building this project", project3Path, -1, -1, 10, 2));
        this.expectingSpecificProblemFor(bPath, new Problem("B", "The type p1.MissingClass cannot be resolved. It is indirectly referenced from required .class files", bPath, 86, 111, 10, 2));
        env.addClass(root2, "p2", "A", "package p2;\npublic class A {\n\tpublic void foo(String data) {}\n}\n");
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void testSecondaryTypeDeleting() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A extends Secondary {}\nclass Secondary {}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        IPath typePath = env.addClass(root, "p1", "A", "package p1;\npublic class A extends Secondary {}\n");
        this.incrementalBuild(projectPath);
        this.expectingSpecificProblemFor(typePath, new Problem("A", "Secondary cannot be resolved to a type", typePath, 35, 44, 40, 2));
    }

    public void testTypeDeleting() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {}\n");
        IPath bPath = env.addClass(root, "p2", "B", "package p2;\npublic class B extends p1.A{}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\nclass Deleted {}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{bPath, cPath});
        this.expectingSpecificProblemFor(bPath, new Problem("B", "p1.A cannot be resolved to a type", bPath, 35, 39, 40, 2));
        this.expectingSpecificProblemFor(cPath, new Problem("C", "The hierarchy of the type C is inconsistent", cPath, 25, 26, 40, 2));
        env.addClass(root, "p2", "B", "package p2;\npublic class B {}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testTypeVisibility() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A {}\n");
        IPath bPath = env.addClass(root, "p2", "B", "package p2;\npublic class B extends p1.A{}\n");
        IPath cPath = env.addClass(root, "p3", "C", "package p3;\npublic class C extends p2.B{}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "A", "package p1;\nclass A {}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{bPath, cPath});
        this.expectingSpecificProblemFor(bPath, new Problem("B", "The type p1.A is not visible", bPath, 35, 39, 40, 2));
        this.expectingSpecificProblemFor(cPath, new Problem("C", "The hierarchy of the type C is inconsistent", cPath, 25, 26, 40, 2));
        env.addClass(root, "p2", "B", "package p2;\npublic class B {}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p2", "B", "package p2;\npublic class B extends p1.A{}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{bPath, cPath});
        this.expectingSpecificProblemFor(bPath, new Problem("B", "The type p1.A is not visible", bPath, 35, 39, 40, 2));
        this.expectingSpecificProblemFor(cPath, new Problem("C", "The hierarchy of the type C is inconsistent", cPath, 25, 26, 40, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A {}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testTypeVisibility2() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath aPath = env.addClass(root, "p1", "A", "package p1;\npublic class A {\n\tvoid foo() { p2.FooFactory.createFoo().foo(); }\n\tvoid foos() { p2.FooFactory.createFoos().clone(); }\n}\n");
        env.addClass(root, "p2", "Foo", "package p2;\nclass Foo { public void foo() {} }\n");
        env.addClass(root, "p2", "Foos", "package p2;\nclass Foos {}\n");
        env.addClass(root, "p2", "FooFactory", "package p2;\npublic class FooFactory {\n\tpublic static Foo createFoo() { return null; }\n\tpublic static Foos[] createFoos() { return null; }\n}\n");
        this.fullBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{aPath});
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The type Foo is not visible", aPath, 43, 68, 40, 2));
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The type Foos is not visible", aPath, 93, 119, 40, 2));
        env.addClass(root, "p2", "Foo", "package p2;\npublic class Foo { public void foo() {} }\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{aPath});
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The type Foos is not visible", aPath, 93, 119, 40, 2));
        env.addClass(root, "p2", "Foos", "package p2;\npublic class Foos { }\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p2", "Foo", "package p2;\nclass Foo { public void foo() {} }\n");
        env.addClass(root, "p2", "Foos", "package p2;\nclass Foos {}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{aPath});
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The type Foo is not visible", aPath, 43, 68, 40, 2));
        this.expectingSpecificProblemFor(aPath, new Problem("A", "The type Foos is not visible", aPath, 93, 119, 40, 2));
    }

    public void testTypeVariable() throws JavaModelException {
        if ((AbstractCompilerTest.getPossibleComplianceLevels() & 4) == 0) {
            return;
        }
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "A", "package p1;\npublic class A<T> {}\n");
        IPath bPath = env.addClass(root, "p2", "B", "package p2;\npublic class B<T> extends p1.A<T> {}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        IPath aPath = env.addClass(root, "p1", "A", "package p1;\npublic class A {}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{bPath});
        this.expectingSpecificProblemFor(bPath, new Problem("B", "The type A is not generic; it cannot be parameterized with arguments <T>", bPath, 38, 42, 40, 2));
        env.addClass(root, "p1", "A", "package p1;\npublic class A<T extends Comparable> {}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{aPath, bPath});
        this.expectingSpecificProblemFor(bPath, new Problem("B", "Bound mismatch: The type T is not a valid substitute for the bounded parameter <T extends Comparable> of the type A<T>", bPath, 43, 44, 40, 2));
        this.expectingSpecificProblemFor(aPath, new Problem("A", "Comparable is a raw type. References to generic type Comparable<T> should be parameterized", aPath, 37, 47, 130, 1));
        env.addClass(root, "p1", "A", "package p1;\npublic class A<T> {}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void test0100() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IPath rootPath = env.getPackageFragmentRootPath(projectPath, "");
        env.addClass(rootPath, "a", "N1", "package a;\npublic class N1 {\n  public void foo() {}\n  /** @deprecated */\n  public class N2 {    public void foo() {}    public class N3 {      public void foo() {}    }  }  void bar() {}\n}\n");
        String M1Contents = "package p;\npublic class M1 {\n  public void foo() {}\n  /** @deprecated */\n  public class M2 {    public void foo() {}    public class M3 {      public void foo() {}    }  }  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n";
        IPath M1Path = env.addClass(rootPath, "p", "M1", M1Contents);
        this.fullBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{M1Path});
        this.expectingSpecificProblemFor(M1Path, new Problem("", "The type N1.N2.N3 is deprecated", M1Path, 198, 200, 110, 1));
        this.expectingSpecificProblemFor(M1Path, new Problem("", "The method foo() from the type N1.N2.N3 is deprecated", M1Path, 217, 222, 110, 1));
        M1Path = env.addClass(rootPath, "p", "M1", M1Contents);
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(new IPath[]{M1Path});
        this.expectingSpecificProblemFor(M1Path, new Problem("", "The type N1.N2.N3 is deprecated", M1Path, 198, 200, 110, 1));
        this.expectingSpecificProblemFor(M1Path, new Problem("", "The method foo() from the type N1.N2.N3 is deprecated", M1Path, 217, 222, 110, 1));
    }
}

