/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import junit.framework.Test;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.Util;

public class GetResourcesTests
extends BuilderTests {
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            int length2;
            IResource resource1 = (IResource)o1;
            IResource resource2 = (IResource)o2;
            String path1 = resource1.getFullPath().toString();
            String path2 = resource2.getFullPath().toString();
            int length1 = path1.length();
            if (length1 != (length2 = path2.length())) {
                return length1 - length2;
            }
            return path1.toString().compareTo(path2.toString());
        }
    };
    static /* synthetic */ Class class$0;

    public GetResourcesTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.GetResourcesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return GetResourcesTests.buildTestSuite((Class)clazz);
    }

    public void test001() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit("Hello.java");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)compilationUnit);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)1, (int)resources.length);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test002() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n\tObject foo() {\n\t\treturn new Object() {};\n\t}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit("Hello.java");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)compilationUnit);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$1.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test003() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n\tObject foo() {\n\t\tif(false) {\n\t\t\treturn new Object() {};\n\t\t}\n\t\treturn null;\n\t}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit("Hello.java");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)compilationUnit);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)1, (int)resources.length);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test004() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n\tObject foo() {\n\t\treturn new Object() {};\n\t}\n\tObject foo2() {\n\t\treturn new Object() {};\n\t}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit("Hello.java");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)compilationUnit);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)3, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$1.class\n/Project/bin/p1/Hello$2.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test005() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "a", "Anon", "package a;\n\npublic class Anon {\n\n    Anon() {\n        Object o1 = new Object() {\n            public String toString() {\n                return \"1\"; // a/Anon$3 in 1.5,  a/Anon$11 in 1.4\n            }\n        };\n        Object o2 = new Object() {\n            public String toString() {\n                return \"2\"; // a/Anon$4 in 1.5,  a/Anon$12 in 1.4\n            }\n        };\n    }\n\n    void hello() {\n        Object o3 = new Object() {\n            public String toString() {\n                return \"3\"; // a/Anon$5 in 1.5,  a/Anon$13 in 1.4\n            }\n        };\n        Object o4 = new Object() {\n            public String toString() {\n                return \"4\"; // a/Anon$6 in 1.5,  a/Anon$14 in 1.4\n            }\n        };\n    }\n\n    static void hello2() {\n        Object o5 = new Object() {\n            public String toString() {\n                return \"5\"; // a/Anon$7 in 1.5,  a/Anon$15 in 1.4\n            }\n        };\n        Object o6 = new Object() {\n            public String toString() {\n                return \"6\"; // a/Anon$8 in 1.5,  a/Anon$16 in 1.4\n            }\n        };\n    }\n\n    static {\n        Object o7 = new Object() {\n            public String toString() {\n                return \"7\"; // a/Anon$1 in 1.5,  a/Anon$1 in 1.4\n            }\n        };\n\n        Object o8 = new Object() {\n            public String toString() {\n                return \"8\"; // a/Anon$2 in 1.5,  a/Anon$2 in 1.4\n            }\n        };\n    }\n\n    static class Anon2 {\n        // it's an object init block which has different prio as constructor!\n        {\n            Object o1 = new Object() {\n                public String toString() {\n                    return \"1\"; // a/Anon$Anon2$1 in 1.5,  a/Anon$3 in 1.4\n                }\n            };\n            Object o2 = new Object() {\n                public String toString() {\n                    return \"2\"; // a/Anon$Anon2$2 in 1.5,  a/Anon$4 in 1.4\n                }\n            };\n        }\n\n        void hello() {\n            Object o3 = new Object() {\n                public String toString() {\n                    return \"3\"; // a/Anon$Anon2$5 in 1.5,  a/Anon$7 in 1.4\n                }\n            };\n            Object o4 = new Object() {\n                public String toString() {\n                    return \"4\"; // a/Anon$Anon2$6 in 1.5,  a/Anon$8 in 1.4\n                }\n            };\n        }\n\n        static void hello2() {\n            Object o5 = new Object() {\n                public String toString() {\n                    return \"5\"; // a/Anon$Anon2$7 in 1.5,  a/Anon$9 in 1.4\n                }\n            };\n            Object o6 = new Object() {\n                public String toString() {\n                    return \"6\"; //  a/Anon$Anon2$8 in 1.5,  a/Anon$10 in 1.4\n                }\n            };\n        }\n\n        static {\n            Object o7 = new Object() {\n                public String toString() {\n                    return \"7\"; // a/Anon$Anon2$3 in 1.5,  a/Anon$5 in 1.4\n                }\n            };\n\n            Object o8 = new Object() {\n                public String toString() {\n                    return \"8\"; // a/Anon$Anon2$4 in 1.5,  a/Anon$6 in 1.4\n                }\n            };\n        }\n    }\n}");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("a");
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit("Anon.java");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)compilationUnit);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)18, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/a/Anon.class\n/Project/bin/a/Anon$1.class\n/Project/bin/a/Anon$2.class\n/Project/bin/a/Anon$3.class\n/Project/bin/a/Anon$4.class\n/Project/bin/a/Anon$5.class\n/Project/bin/a/Anon$6.class\n/Project/bin/a/Anon$7.class\n/Project/bin/a/Anon$8.class\n/Project/bin/a/Anon$9.class\n/Project/bin/a/Anon$10.class\n/Project/bin/a/Anon$11.class\n/Project/bin/a/Anon$12.class\n/Project/bin/a/Anon$13.class\n/Project/bin/a/Anon$14.class\n/Project/bin/a/Anon$15.class\n/Project/bin/a/Anon$16.class\n/Project/bin/a/Anon$Anon2.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test006() throws JavaModelException {
        IPath projectPath = null;
        try {
            projectPath = env.addProject("Project", "1.5");
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "a", "Anon", "package a;\n\npublic class Anon {\n\n    Anon() {\n        Object o1 = new Object() {\n            public String toString() {\n                return \"1\"; // a/Anon$3 in 1.5,  a/Anon$11 in 1.4\n            }\n        };\n        Object o2 = new Object() {\n            public String toString() {\n                return \"2\"; // a/Anon$4 in 1.5,  a/Anon$12 in 1.4\n            }\n        };\n    }\n\n    void hello() {\n        Object o3 = new Object() {\n            public String toString() {\n                return \"3\"; // a/Anon$5 in 1.5,  a/Anon$13 in 1.4\n            }\n        };\n        Object o4 = new Object() {\n            public String toString() {\n                return \"4\"; // a/Anon$6 in 1.5,  a/Anon$14 in 1.4\n            }\n        };\n    }\n\n    static void hello2() {\n        Object o5 = new Object() {\n            public String toString() {\n                return \"5\"; // a/Anon$7 in 1.5,  a/Anon$15 in 1.4\n            }\n        };\n        Object o6 = new Object() {\n            public String toString() {\n                return \"6\"; // a/Anon$8 in 1.5,  a/Anon$16 in 1.4\n            }\n        };\n    }\n\n    static {\n        Object o7 = new Object() {\n            public String toString() {\n                return \"7\"; // a/Anon$1 in 1.5,  a/Anon$1 in 1.4\n            }\n        };\n\n        Object o8 = new Object() {\n            public String toString() {\n                return \"8\"; // a/Anon$2 in 1.5,  a/Anon$2 in 1.4\n            }\n        };\n    }\n\n    static class Anon2 {\n        // it's an object init block which has different prio as constructor!\n        {\n            Object o1 = new Object() {\n                public String toString() {\n                    return \"1\"; // a/Anon$Anon2$1 in 1.5,  a/Anon$3 in 1.4\n                }\n            };\n            Object o2 = new Object() {\n                public String toString() {\n                    return \"2\"; // a/Anon$Anon2$2 in 1.5,  a/Anon$4 in 1.4\n                }\n            };\n        }\n\n        void hello() {\n            Object o3 = new Object() {\n                public String toString() {\n                    return \"3\"; // a/Anon$Anon2$5 in 1.5,  a/Anon$7 in 1.4\n                }\n            };\n            Object o4 = new Object() {\n                public String toString() {\n                    return \"4\"; // a/Anon$Anon2$6 in 1.5,  a/Anon$8 in 1.4\n                }\n            };\n        }\n\n        static void hello2() {\n            Object o5 = new Object() {\n                public String toString() {\n                    return \"5\"; // a/Anon$Anon2$7 in 1.5,  a/Anon$9 in 1.4\n                }\n            };\n            Object o6 = new Object() {\n                public String toString() {\n                    return \"6\"; //  a/Anon$Anon2$8 in 1.5,  a/Anon$10 in 1.4\n                }\n            };\n        }\n\n        static {\n            Object o7 = new Object() {\n                public String toString() {\n                    return \"7\"; // a/Anon$Anon2$3 in 1.5,  a/Anon$5 in 1.4\n                }\n            };\n\n            Object o8 = new Object() {\n                public String toString() {\n                    return \"8\"; // a/Anon$Anon2$4 in 1.5,  a/Anon$6 in 1.4\n                }\n            };\n        }\n    }\n}");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("a");
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit("Anon.java");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)compilationUnit);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)18, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/a/Anon.class\n/Project/bin/a/Anon$1.class\n/Project/bin/a/Anon$2.class\n/Project/bin/a/Anon$3.class\n/Project/bin/a/Anon$4.class\n/Project/bin/a/Anon$5.class\n/Project/bin/a/Anon$6.class\n/Project/bin/a/Anon$7.class\n/Project/bin/a/Anon$8.class\n/Project/bin/a/Anon$Anon2.class\n/Project/bin/a/Anon$Anon2$1.class\n/Project/bin/a/Anon$Anon2$2.class\n/Project/bin/a/Anon$Anon2$3.class\n/Project/bin/a/Anon$Anon2$4.class\n/Project/bin/a/Anon$Anon2$5.class\n/Project/bin/a/Anon$Anon2$6.class\n/Project/bin/a/Anon$Anon2$7.class\n/Project/bin/a/Anon$Anon2$8.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    private String getResourceOuput(IResource[] resources) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        int i = 0;
        int max = resources.length;
        while (i < max) {
            writer.println(resources[i].getFullPath().toString());
            ++i;
        }
        writer.flush();
        writer.close();
        return Util.convertToIndependantLineDelimiter((String)String.valueOf(stringWriter));
    }

    public void test007() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\nclass Foo {\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit("Hello.java");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)compilationUnit);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        env.removeProject(projectPath);
    }

    public void test008() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public class Z {}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)packageFragment);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test009() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.setOutputFolder(projectPath, "bin");
        env.addClass(projectPath, "p1", "Hello", "package p1;\npublic class Hello {\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getUnderlyingResource());
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit("Hello.java");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)compilationUnit);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)1, (int)resources.length);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test010() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public class Z {}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        env.addFile(root, "p1/Test.txt", "This is a non-java resource");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)packageFragment);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)3, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        actualOutput = this.getResourceOuput(resources);
        expectedOutput = "/Project/bin/p1/Test.txt\n/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test011() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public class Z {}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)packageFragment);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.addFile(root, "p1/Test.txt", "This is a non-java resource");
        this.incrementalBuild(projectPath);
        resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)3, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        actualOutput = this.getResourceOuput(resources);
        expectedOutput = "/Project/bin/p1/Test.txt\n/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test012() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public class Z {}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)packageFragment);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.addFile(root, "p1/Test.txt", "This is a non-java resource");
        resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        actualOutput = this.getResourceOuput(resources);
        expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test013() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src", (IPath[])new Path[]{new Path("**/*.txt")}, null);
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public class Z {}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)packageFragment);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.addFile(root, "p1/Test.txt", "This is a non-java resource");
        this.incrementalBuild(projectPath);
        resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        actualOutput = this.getResourceOuput(resources);
        expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test014() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src", (IPath[])new Path[]{new Path("**/*.txt")}, null);
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public class Z {}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IPackageFragmentRoot root2 = project.getPackageFragmentRoot(project.getProject().getWorkspace().getRoot().findMember(root.makeAbsolute()));
        IPackageFragment packageFragment = root2.getPackageFragment("p1");
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)packageFragment);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.addFile(root, "p1/Test.txt", "This is an excluded non-java resource");
        env.addFile(root, "p1/Test.log", "This is an included non-java resource");
        this.incrementalBuild(projectPath);
        resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)3, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        actualOutput = this.getResourceOuput(resources);
        expectedOutput = "/Project/bin/p1/Test.log\n/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test015() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src", (IPath[])new Path[]{new Path("**/*.txt")}, null);
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Hello", "package p1;\npublic class Hello {\n   public class Z {}\n   public static void main(String args[]) {\n      System.out.println(\"Hello world\");\n   }\n}\n");
        this.incrementalBuild(projectPath);
        IJavaProject project = env.getJavaProject(projectPath);
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)project);
        IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        String actualOutput = this.getResourceOuput(resources);
        String expectedOutput = "/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.addFile(root, "p1/Test.txt", "This is an excluded non-java resource");
        env.addFile(root, "p1/Test.log", "This is an included non-java resource");
        this.incrementalBuild(projectPath);
        resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)true);
        GetResourcesTests.assertEquals((String)"Wrong size", (int)3, (int)resources.length);
        Arrays.sort(resources, COMPARATOR);
        actualOutput = this.getResourceOuput(resources);
        expectedOutput = "/Project/bin/p1/Test.log\n/Project/bin/p1/Hello.class\n/Project/bin/p1/Hello$Z.class\n";
        GetResourcesTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
        env.removeProject(projectPath);
    }

    public void test016() throws JavaModelException {
        try {
            JavaCore.getGeneratedResources(null, (boolean)true);
            GetResourcesTests.assertTrue((String)"Region cannot be null", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

