/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.builder.TestBuilderParticipant;
import org.eclipse.jdt.core.tests.util.Util;

public class ParticipantBuildTests
extends BuilderTests {
    static final int JLS3_INTERNAL = 3;
    static /* synthetic */ Class class$0;

    public ParticipantBuildTests(String name) {
        super(name);
    }

    public void tearDown() throws Exception {
        TestBuilderParticipant.PARTICIPANT = null;
        super.tearDown();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.builder.ParticipantBuildTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ParticipantBuildTests.buildTestSuite((Class)clazz);
    }

    CompilationUnit buildCompilationUnit(BuildContext file) {
        IJavaProject javaProject = JavaCore.create((IProject)file.getFile().getProject());
        ASTParser p = ASTParser.newParser((int)3);
        p.setProject(javaProject);
        p.setSource(file.getContents());
        p.setResolveBindings(true);
        p.setKind(8);
        p.setUnitName(file.getFile().getName());
        return (CompilationUnit)p.createAST(null);
    }

    public void testBuildStarting() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath test = env.addClass(root, "", "Test", "public class Test extends GeneratedType {}\n");
        new BuildTestParticipant(){
            int buildPass = 0;

            public void buildStarting(BuildContext[] files, boolean isBatchBuild) {
                BuildContext result = files[0];
                IFile genedType = result.getFile().getParent().getFile((IPath)new Path("GeneratedType.java"));
                if (this.buildPass == 0 || this.buildPass == 3) {
                    try {
                        genedType.create((InputStream)new ByteArrayInputStream("public class GeneratedType {}".getBytes()), true, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    result.recordAddedGeneratedFiles(new IFile[]{genedType});
                } else if (this.buildPass == 1) {
                    try {
                        genedType.delete(true, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    result.recordDeletedGeneratedFiles(new IFile[]{genedType});
                }
                ++this.buildPass;
            }
        };
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "", "Test", "public class Test extends GeneratedType {}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlySpecificProblemFor(test, new Problem("", "GeneratedType cannot be resolved to a type", test, 26, 39, 40, 2));
        env.addClass(root, "", "Test", "public class Test extends GeneratedType {}\n");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testDefaultValue() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "test", "EntryPoint", "package test;\npublic class EntryPoint { ClassWithNestedAnnotation nestedAnnotation; }");
        env.addClass(root, "test", "ClassWithNestedAnnotation", "package test;\npublic class ClassWithNestedAnnotation {\n\tpublic final int FOUR = 4; \n \tpublic @interface NestedAnnotation {\n\t\tpublic enum Character { Winnie, Tiger, Piglet, Eore; }\n\t\tCharacter value() default Character.Eore; \n\t}\n}");
        new BuildTestParticipant(){

            public boolean isAnnotationProcessor() {
                return true;
            }

            public void processAnnotations(BuildContext[] files) {
                int i = 0;
                int total = files.length;
                while (i < total) {
                    IFile file = files[i].getFile();
                    if ("EntryPoint.java".equals(file.getName())) {
                        ArrayList<ParticipantProblem> problems = new ArrayList<ParticipantProblem>();
                        CompilationUnit unit = ParticipantBuildTests.this.buildCompilationUnit(files[i]);
                        List types = unit.types();
                        int t = 0;
                        int l = types.size();
                        while (t < l) {
                            AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)types.get(t);
                            ITypeBinding typeBinding = typeDecl.resolveBinding();
                            if (typeBinding != null) {
                                IVariableBinding[] fieldBindings = typeBinding.getDeclaredFields();
                                int f = 0;
                                int fLength = fieldBindings.length;
                                while (f < fLength) {
                                    IVariableBinding field = fieldBindings[f];
                                    if ("nestedAnnotation".equals(field.getName())) {
                                        ITypeBinding fieldType = field.getType();
                                        ITypeBinding[] declaredTypes = fieldType.getDeclaredTypes();
                                        int d = 0;
                                        int dLength = declaredTypes.length;
                                        while (d < dLength) {
                                            if ("NestedAnnotation".equals(declaredTypes[d].getName())) {
                                                IMethodBinding[] annotationMethods = declaredTypes[d].getDeclaredMethods();
                                                int m = 0;
                                                int mLength = annotationMethods.length;
                                                while (m < mLength) {
                                                    if ("value".equals(annotationMethods[m].getName())) {
                                                        Object defaultValue = annotationMethods[m].getDefaultValue();
                                                        ParticipantBuildTests.assertTrue((String)"Wrong class", (boolean)(defaultValue instanceof IVariableBinding));
                                                        IVariableBinding variableBinding = (IVariableBinding)defaultValue;
                                                        String defaultString = variableBinding.getName();
                                                        String expected = "Eore";
                                                        if (!expected.equals(defaultString)) {
                                                            ParticipantProblem problem = new ParticipantProblem("expecting default = " + expected + " not " + defaultString, file.getName());
                                                            problems.add(problem);
                                                        }
                                                    }
                                                    ++m;
                                                }
                                            }
                                            ++d;
                                        }
                                        IVariableBinding[] nestedFields = fieldType.getDeclaredFields();
                                        int nf = 0;
                                        int nfLength = nestedFields.length;
                                        while (nf < nfLength) {
                                            String expected;
                                            Object constant;
                                            String constantStr;
                                            if (nestedFields[nf].getName().equals("FOUR") && !(constantStr = (constant = nestedFields[nf].getConstantValue()) == null ? "" : constant.toString()).equals(expected = "4")) {
                                                problems.add(new ParticipantProblem("expecting constant = " + expected + " not " + constantStr, file.getName()));
                                            }
                                            ++nf;
                                        }
                                    } else {
                                        problems.add(new ParticipantProblem("found unexpected field " + field, file.getName()));
                                    }
                                    ++f;
                                }
                            }
                            ++t;
                        }
                        if (!problems.isEmpty()) {
                            CategorizedProblem[] problemArray = new CategorizedProblem[problems.size()];
                            problemArray = problems.toArray(problemArray);
                            files[i].recordNewProblems(problemArray);
                        }
                    }
                    ++i;
                }
            }
        };
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testParticipantProblems() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "X", "package p;\npublic class X { /* generate problem*/ }");
        new BuildTestParticipant(){

            public void buildStarting(BuildContext[] files, boolean isBatch) {
                int i = 0;
                int total = files.length;
                while (i < total) {
                    BuildContext context = files[i];
                    if (CharOperation.indexOf((char[])"generate problem".toCharArray(), (char[])context.getContents(), (boolean)true) != -1) {
                        context.recordNewProblems(new CategorizedProblem[]{new ParticipantProblem("Participant problem", context.getFile().getFullPath().toString())});
                    }
                    ++i;
                }
            }
        };
        this.fullBuild(projectPath);
        this.expectingParticipantProblems(projectPath, "Participant problem");
        env.addClass(root, "p", "X", "package p;\npublic class X { }");
        this.incrementalBuild(projectPath);
        this.expectingParticipantProblems(projectPath, "");
    }

    public void testProcessAnnotationDeclarations() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "Test", "@interface TestAnnotation {}\npublic class Test extends GeneratedType {}\n");
        env.addClass(root, "", "Other", "public class Other { MissingAnnotation m; }\n");
        new BuildTestParticipant(){
            int count = 2;

            public boolean isAnnotationProcessor() {
                return true;
            }

            public void processAnnotations(BuildContext[] files) {
                if (this.count == 2) {
                    --this.count;
                    BuildContext result = files[0];
                    IFile genedType = result.getFile().getParent().getFile((IPath)new Path("MissingAnnotation.java"));
                    try {
                        genedType.create((InputStream)new ByteArrayInputStream("public @interface MissingAnnotation {}".getBytes()), true, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    result.recordAddedGeneratedFiles(new IFile[]{genedType});
                } else if (this.count == 1) {
                    --this.count;
                    BuildContext result = files[0];
                    IFile genedType = result.getFile().getParent().getFile((IPath)new Path("GeneratedType.java"));
                    try {
                        genedType.create((InputStream)new ByteArrayInputStream("public class GeneratedType {}".getBytes()), true, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    result.recordAddedGeneratedFiles(new IFile[]{genedType});
                }
            }
        };
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testProcessAnnotationQualifiedReferences() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Test", "package p1;\n@GeneratedAnnotation\npublic class Test { public void method() { p1.p2.GeneratedType.method(); } }\n");
        env.addClass(root, "p1", "GeneratedAnnotation", "package p1;\n@interface GeneratedAnnotation{}\n");
        new BuildTestParticipant(){

            public boolean isAnnotationProcessor() {
                return true;
            }

            public void processAnnotations(BuildContext[] files) {
                BuildContext result = files[0];
                IFile genedType = result.getFile().getProject().getFile((IPath)new Path("src/p1/p2/GeneratedType.java"));
                if (genedType.exists()) {
                    return;
                }
                try {
                    IFolder folder = (IFolder)genedType.getParent();
                    if (!folder.exists()) {
                        folder.create(true, true, null);
                    }
                    genedType.create((InputStream)new ByteArrayInputStream("package p1.p2; public class GeneratedType { public static void method(){} }".getBytes()), true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                result.recordAddedGeneratedFiles(new IFile[]{genedType});
            }
        };
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testProcessAnnotationReferences() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "Test", "@GeneratedAnnotation\npublic class Test {}\n");
        new BuildTestParticipant(){

            public boolean isAnnotationProcessor() {
                return true;
            }

            public void processAnnotations(BuildContext[] files) {
                BuildContext result = files[0];
                IFile genedType = result.getFile().getParent().getFile((IPath)new Path("GeneratedAnnotation.java"));
                if (genedType.exists()) {
                    return;
                }
                try {
                    genedType.create((InputStream)new ByteArrayInputStream("@interface GeneratedAnnotation {}".getBytes()), true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                result.recordAddedGeneratedFiles(new IFile[]{genedType});
            }
        };
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }

    public void testResolvedMethod() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "", "Try", "@SuppressWarnings(\"all\")\npublic class Try {}");
        new BuildTestParticipant(){

            public boolean isAnnotationProcessor() {
                return true;
            }

            public void processAnnotations(BuildContext[] files) {
                int i = 0;
                int total = files.length;
                while (i < total) {
                    IFile file = files[i].getFile();
                    if ("Try.java".equals(file.getName())) {
                        ArrayList<ParticipantProblem> problems = new ArrayList<ParticipantProblem>();
                        CompilationUnit unit = ParticipantBuildTests.this.buildCompilationUnit(files[i]);
                        List types = unit.types();
                        int t = 0;
                        int l = types.size();
                        while (t < l) {
                            IAnnotationBinding targetValue;
                            IMethodBinding method;
                            AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)types.get(t);
                            ITypeBinding typeBinding = typeDecl.resolveBinding();
                            if (typeBinding != null && !"value".equals((method = (targetValue = (typeBinding = typeBinding.getAnnotations()[0].getAnnotationType()).getAnnotations()[0]).getDeclaredMemberValuePairs()[0].getMethodBinding()).getName())) {
                                problems.add(new ParticipantProblem("method " + method.getName() + " not found", file.getName()));
                            }
                            ++t;
                        }
                        if (!problems.isEmpty()) {
                            CategorizedProblem[] problemArray = new CategorizedProblem[problems.size()];
                            problemArray = problems.toArray(problemArray);
                            files[i].recordNewProblems(problemArray);
                        }
                    }
                    ++i;
                }
            }
        };
        this.fullBuild(projectPath);
        this.expectingNoProblems();
    }

    public void test1001() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "X", "package p;\npublic class X { /* generate problem*/ }");
        new BuildTestParticipant(){

            public void buildStarting(BuildContext[] files, boolean isBatch) {
                int i = 0;
                int total = files.length;
                while (i < total) {
                    BuildContext context = files[i];
                    if (CharOperation.indexOf((char[])"generate problem".toCharArray(), (char[])context.getContents(), (boolean)true) != -1) {
                        context.recordNewProblems(new CategorizedProblem[]{new ParticipantProblem("Participant problem", context.getFile().getFullPath().toString())});
                    }
                    ++i;
                }
            }
        };
        this.fullBuild(projectPath);
        Problem[] problems = env.getProblemsFor(projectPath, "org.eclipse.jdt.core.tests.compile.problem");
        ParticipantBuildTests.assertNotNull((String)"null problems array", (Object)problems);
        ParticipantBuildTests.assertEquals((String)"unexpected problems count", (int)1, (int)problems.length);
        ParticipantBuildTests.assertEquals((String)"unexpected generated by attribute", (String)"missing", (String)problems[0].getSourceId());
    }

    public void test1002() throws JavaModelException {
        IPath projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p", "X", "package p;\npublic class X { /* generate problem*/ }");
        new BuildTestParticipant(){

            public void buildStarting(BuildContext[] files, boolean isBatch) {
                int i = 0;
                int total = files.length;
                while (i < total) {
                    BuildContext context = files[i];
                    if (CharOperation.indexOf((char[])"generate problem".toCharArray(), (char[])context.getContents(), (boolean)true) != -1) {
                        context.recordNewProblems(new CategorizedProblem[]{new ParticipantProblem(this, "Participant problem", context.getFile().getFullPath().toString()){
                            final /* synthetic */ 9 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public String[] getExtraMarkerAttributeNames() {
                                return new String[]{"sourceId"};
                            }

                            public Object[] getExtraMarkerAttributeValues() {
                                return new String[]{"specific"};
                            }
                        }});
                    }
                    ++i;
                }
            }
        };
        this.fullBuild(projectPath);
        Problem[] problems = env.getProblemsFor(projectPath, "org.eclipse.jdt.core.tests.compile.problem");
        ParticipantBuildTests.assertNotNull((String)"null problems array", (Object)problems);
        ParticipantBuildTests.assertEquals((String)"unexpected problems count", (int)1, (int)problems.length);
        ParticipantBuildTests.assertEquals((String)"unexpected generated by attribute", (String)"specific", (String)problems[0].getSourceId());
    }

    static class BuildTestParticipant
    extends CompilationParticipant {
        BuildTestParticipant() {
            TestBuilderParticipant.PARTICIPANT = this;
        }
    }

    static class ParticipantProblem
    extends CategorizedProblem {
        int counter = 0;
        String message;
        int id;
        char[] filename;

        ParticipantProblem(String message, String filename) {
            this.message = message;
            this.id = this.counter++;
            this.filename = filename.toCharArray();
        }

        public String[] getArguments() {
            return new String[0];
        }

        public int getID() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        public char[] getOriginatingFileName() {
            return this.filename;
        }

        public int getSourceStart() {
            return 0;
        }

        public int getSourceEnd() {
            return 0;
        }

        public int getSourceLineNumber() {
            return 1;
        }

        public boolean isError() {
            return true;
        }

        public boolean isWarning() {
            return false;
        }

        public void setSourceEnd(int sourceEnd) {
        }

        public void setSourceLineNumber(int lineNumber) {
        }

        public void setSourceStart(int sourceStart) {
        }

        public int getCategoryID() {
            return 0;
        }

        public String getMarkerType() {
            return "org.eclipse.jdt.core.tests.compile.problem";
        }
    }
}

