/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractSyntaxTreeTest;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;

public class ReferenceExpressionSyntaxTest
extends AbstractSyntaxTreeTest {
    private static String jsr335TestScratchArea = "c:\\Jsr335TestScratchArea";
    private static String referenceCompiler = "C:\\jdk-7-ea-bin-b75-windows-i586-30_oct_2009\\jdk7\\bin\\javac.exe";
    static /* synthetic */ Class class$0;

    static {
        if (!new File(referenceCompiler).exists()) {
            referenceCompiler = null;
            jsr335TestScratchArea = null;
        }
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.parser.ReferenceExpressionSyntaxTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
    }

    public static Test suite() {
        return ReferenceExpressionSyntaxTest.buildMinimalComplianceTestSuite(ReferenceExpressionSyntaxTest.testClass(), 32);
    }

    public ReferenceExpressionSyntaxTest(String testName) {
        super(testName, referenceCompiler, jsr335TestScratchArea);
        if (referenceCompiler != null) {
            File f = new File(jsr335TestScratchArea);
            if (!f.exists()) {
                f.mkdir();
            }
            CHECK_ALL |= 0x80;
        }
    }

    public void test0001() throws IOException {
        String source = "interface I {\n    void foo(int x);\n}\npublic class X extends Y {\n    public static void main(String [] args) {\n\tnew X().doit();\n    }\n    void doit() {\n        I i = super::foo;\n        i.foo(10); \n    }\n}\nclass Y {\n    public void foo(int x) {\n\tSystem.out.println(x);\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(int x);\n}\npublic class X extends Y {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    new X().doit();\n  }\n  void doit() {\n    I i = super::foo;\n    i.foo(10);\n  }\n}\nclass Y {\n  Y() {\n    super();\n  }\n  public void foo(int x) {\n    System.out.println(x);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0001", expectedUnitToString);
    }

    public void test0002() throws IOException {
        String source = "interface I {\n    void foo(int x);\n}\npublic class X extends Y {\n    public static void main(String [] args) {\n\tnew X().doit();\n    }\n    void doit() {\n        I i = super::<String>foo;\n        i.foo(10); \n    }\n}\nclass Y {\n    public void foo(int x) {\n\tSystem.out.println(x);\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(int x);\n}\npublic class X extends Y {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    new X().doit();\n  }\n  void doit() {\n    I i = super::<String>foo;\n    i.foo(10);\n  }\n}\nclass Y {\n  Y() {\n    super();\n  }\n  public void foo(int x) {\n    System.out.println(x);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0002", expectedUnitToString);
    }

    public void test0003() throws IOException {
        String source = "interface I {\n    void foo(int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y::foo;\n        i.foo(10); \n    }\n}\nclass Y {\n    public static void foo(int x) {\n\tSystem.out.println(x);\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y::foo;\n    i.foo(10);\n  }\n}\nclass Y {\n  Y() {\n    super();\n  }\n  public static void foo(int x) {\n    System.out.println(x);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0003", expectedUnitToString);
    }

    public void test0004() throws IOException {
        String source = "interface I {\n    void foo(int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y::<String>foo;\n        i.foo(10); \n    }\n}\nclass Y {\n    public static void foo(int x) {\n\tSystem.out.println(x);\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y::<String>foo;\n    i.foo(10);\n  }\n}\nclass Y {\n  Y() {\n    super();\n  }\n  public static void foo(int x) {\n    System.out.println(x);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0004", expectedUnitToString);
    }

    public void test0005() throws IOException {
        String source = "interface I {\n    void foo(int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y.Z::foo;\n        i.foo(10); \n    }\n}\nclass Y {\n    static class Z {\n        public static void foo(int x) {\n\t    System.out.println(x);\n        }\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y.Z::foo;\n    i.foo(10);\n  }\n}\nclass Y {\n  static class Z {\n    Z() {\n      super();\n    }\n    public static void foo(int x) {\n      System.out.println(x);\n    }\n  }\n  Y() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0005", expectedUnitToString);
    }

    public void test0006() throws IOException {
        String source = "interface I {\n    void foo(int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y.Z::<String>foo;\n        i.foo(10); \n    }\n}\nclass Y {\n    static class Z {\n        public static void foo(int x) {\n\t    System.out.println(x);\n        }\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y.Z::<String>foo;\n    i.foo(10);\n  }\n}\nclass Y {\n  static class Z {\n    Z() {\n      super();\n    }\n    public static void foo(int x) {\n      System.out.println(x);\n    }\n  }\n  Y() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0006", expectedUnitToString);
    }

    public void test0007() throws IOException {
        String source = "interface I {\n    void foo(int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = new Y()::foo;\n        i.foo(10); \n    }\n}\nclass Y {\n        void foo(int x) {\n\t    System.out.println(x);\n        }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = new Y()::foo;\n    i.foo(10);\n  }\n}\nclass Y {\n  Y() {\n    super();\n  }\n  void foo(int x) {\n    System.out.println(x);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0007", expectedUnitToString);
    }

    public void test0008() throws IOException {
        String source = "interface I {\n    void foo(int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = new Y()::<String>foo;\n        i.foo(10); \n    }\n}\nclass Y {\n        void foo(int x) {\n\t    System.out.println(x);\n        }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = new Y()::<String>foo;\n    i.foo(10);\n  }\n}\nclass Y {\n  Y() {\n    super();\n  }\n  void foo(int x) {\n    System.out.println(x);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0008", expectedUnitToString);
    }

    public void test0009() throws IOException {
        String source = "interface I {\n    void foo(Y<String> y, int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y<String>::foo;\n        i.foo(new Y<String>(), 10); \n    }\n}\nclass Y<T> {\n        void foo(int x) {\n\t    System.out.println(x);\n        }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(Y<String> y, int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y<String>::foo;\n    i.foo(new Y<String>(), 10);\n  }\n}\nclass Y<T> {\n  Y() {\n    super();\n  }\n  void foo(int x) {\n    System.out.println(x);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0009", expectedUnitToString);
    }

    public void test0010() throws IOException {
        String source = "interface I {\n    void foo(Y<String> y, int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y<String>::<String>foo;\n        i.foo(new Y<String>(), 10); \n    }\n}\nclass Y<T> {\n        void foo(int x) {\n\t    System.out.println(x);\n        }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(Y<String> y, int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y<String>::<String>foo;\n    i.foo(new Y<String>(), 10);\n  }\n}\nclass Y<T> {\n  Y() {\n    super();\n  }\n  void foo(int x) {\n    System.out.println(x);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0010", expectedUnitToString);
    }

    public void test0011() throws IOException {
        String source = "interface I {\n    void foo(Y<String>.Z z, int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y<String>.Z::foo;\n        i.foo(new Y<String>().new Z(), 10); \n    }\n}\nclass Y<T> {\n    class Z {\n        void foo(int x) {\n\t    System.out.println(x);\n        }\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(Y<String>.Z z, int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y<String>.Z::foo;\n    i.foo(new Y<String>().new Z(), 10);\n  }\n}\nclass Y<T> {\n  class Z {\n    Z() {\n      super();\n    }\n    void foo(int x) {\n      System.out.println(x);\n    }\n  }\n  Y() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0011", expectedUnitToString);
    }

    public void test0012() throws IOException {
        String source = "interface I {\n    void foo(Y<String>.Z z, int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y<String>.Z::<String>foo;\n        i.foo(new Y<String>().new Z(), 10); \n    }\n}\nclass Y<T> {\n    class Z {\n        void foo(int x) {\n\t    System.out.println(x);\n        }\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(Y<String>.Z z, int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y<String>.Z::<String>foo;\n    i.foo(new Y<String>().new Z(), 10);\n  }\n}\nclass Y<T> {\n  class Z {\n    Z() {\n      super();\n    }\n    void foo(int x) {\n      System.out.println(x);\n    }\n  }\n  Y() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0012", expectedUnitToString);
    }

    public void test0013() throws IOException {
        String source = "interface I {\n    void foo(Y<String>.Z<Integer> z, int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y<String>.Z<Integer>::foo;\n        i.foo(new Y<String>().new Z<Integer>(), 10); \n    }\n}\nclass Y<T> {\n    class Z<K> {\n        void foo(int x) {\n\t    System.out.println(x);\n        }\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(Y<String>.Z<Integer> z, int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y<String>.Z<Integer>::foo;\n    i.foo(new Y<String>().new Z<Integer>(), 10);\n  }\n}\nclass Y<T> {\n  class Z<K> {\n    Z() {\n      super();\n    }\n    void foo(int x) {\n      System.out.println(x);\n    }\n  }\n  Y() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0013", expectedUnitToString);
    }

    public void test0014() throws IOException {
        String source = "interface I {\n    void foo(Y<String>.Z<Integer> z, int x);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y<String>.Z<Integer>::<String>foo;\n        i.foo(new Y<String>().new Z<Integer>(), 10); \n    }\n}\nclass Y<T> {\n    class Z<K> {\n        void foo(int x) {\n\t    System.out.println(x);\n        }\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(Y<String>.Z<Integer> z, int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y<String>.Z<Integer>::<String>foo;\n    i.foo(new Y<String>().new Z<Integer>(), 10);\n  }\n}\nclass Y<T> {\n  class Z<K> {\n    Z() {\n      super();\n    }\n    void foo(int x) {\n      System.out.println(x);\n    }\n  }\n  Y() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0014", expectedUnitToString);
    }

    public void test0015() throws IOException {
        String source = "interface I {\n    void foo(Y<String> y);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y<String>.Z<Integer>::<String>new;\n        i.foo(new Y<String>()); \n    }\n}\nclass Y<T> {\n    class Z<K> {\n        Z() {\n            System.out.println(\"Y<T>.Z<K>::new\");\n        }\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(Y<String> y);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = Y<String>.Z<Integer>::<String>new;\n    i.foo(new Y<String>());\n  }\n}\nclass Y<T> {\n  class Z<K> {\n    Z() {\n      super();\n      System.out.println(\"Y<T>.Z<K>::new\");\n    }\n  }\n  Y() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0015", expectedUnitToString);
    }

    public void test0016() throws IOException {
        String source = "interface I {\n    Object copy(int [] ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = int[]::<String>clone;\n        i.copy(new int[10]); \n    }\n}\n";
        String expectedUnitToString = "interface I {\n  Object copy(int[] ia);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = int[]::<String>clone;\n    i.copy(new int[10]);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0016", expectedUnitToString);
    }

    public void test0017() throws IOException {
        String source = "interface I {\n    Object copy(X [] ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = X[]::<String>clone;\n        i.copy(new X[10]); \n    }\n}\n";
        String expectedUnitToString = "interface I {\n  Object copy(X[] ia);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = X[]::<String>clone;\n    i.copy(new X[10]);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0017", expectedUnitToString);
    }

    public void test0018() throws IOException {
        String source = "interface I {\n    Object copy(X<String>.Y<Integer> [] p);\n}\npublic class X<T>  {\n    class Y<K> {\n    }\n    public static void main(String [] args) {\n        I i = X<String>.Y<Integer>[]::<String>clone;\n        X<String>.Y<Integer>[] xs = null;\n        i.copy(xs); \n    }\n}\n";
        String expectedUnitToString = "interface I {\n  Object copy(X<String>.Y<Integer>[] p);\n}\npublic class X<T> {\n  class Y<K> {\n    Y() {\n      super();\n    }\n  }\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = X<String>.Y<Integer>[]::<String>clone;\n    X<String>.Y<Integer>[] xs = null;\n    i.copy(xs);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0018", expectedUnitToString);
    }

    public void test0019() throws IOException {
        String source = "interface I {\n    void foo(X<String> s, int x);\n}\npublic class X<T> {\n    I i = X<@Foo({\"hello\"}) String>::foo;\n    void foo(int x) {\n    }\n}\n@interface Foo {\n    String [] value();\n}\n";
        String expectedUnitToString = "interface I {\n  void foo(X<String> s, int x);\n}\npublic class X<T> {\n  I i = X<@Foo({\"hello\"}) String>::foo;\n  public X() {\n    super();\n  }\n  void foo(int x) {\n  }\n}\n@interface Foo {\n  String[] value();\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0019", expectedUnitToString);
    }

    public void test0020() throws IOException {
        String source = "interface I {\n    Y foo(int x);\n}\npublic class X  {\n    class Z extends Y {\n        public Z(int x) {\n            super(x);\n            System.out.println(\"Z\"+x);\n        }\n    }\n    public static void main(String [] args) {\n        Y y;\n        I i = Y::new;\n        y = i.foo(10); \n        i = X.Z::new;\n        y = i.foo(20); \n        i = W<Integer>::new;\n        y = i.foo(23);\n    }\n}\nclass W<T> extends Y {\n    public W(T x) {\n        super(0);\n        System.out.println(x);\n    }\n}\nclass Y {\n    public Y(int x) {\n        System.out.println(x);\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  Y foo(int x);\n}\npublic class X {\n  class Z extends Y {\n    public Z(int x) {\n      super(x);\n      System.out.println((\"Z\" + x));\n    }\n  }\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    Y y;\n    I i = Y::new;\n    y = i.foo(10);\n    i = X.Z::new;\n    y = i.foo(20);\n    i = W<Integer>::new;\n    y = i.foo(23);\n  }\n}\nclass W<T> extends Y {\n  public W(T x) {\n    super(0);\n    System.out.println(x);\n  }\n}\nclass Y {\n  public Y(int x) {\n    super();\n    System.out.println(x);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0003", expectedUnitToString);
    }

    public void test385132() throws IOException {
        String source = "::";
        String expectedErrorString = "----------\n1. ERROR in test385132 (at line 1)\n\t::\n\t^^\nSyntax error on token \"::\", delete this token\n----------\n";
        this.checkParse(1, source.toCharArray(), expectedErrorString, "test385132", null);
    }

    public void test385374() throws IOException {
        String source = "interface I {\n\tvoid foo();\n}\n@interface TypeAnnotation {\n}\n\nclass X<T> {\n\t // Primitive array form\n\t I x1 = @TypeAnnotation int []::clone;\n\t // Primitive array form with dimension annotations.\n\t I x2 = @TypeAnnotation int @ArrayAnnotation[]@ArrayAnnotation[]::clone; \n\t // Primitive array form with dimension annotations and type parameter annotations.\n\t I x3 = @TypeAnnotation int @ArrayAnnotation[]@ArrayAnnotation[]::<@TypeParameterAnnotation String>clone; \n\t // Reference type name form\n\t I x4 = @TypeAnnotation X::clone;\n\t // Reference type name array form\n\t I x5 = @TypeAnnotation X []::clone;\n\t // Reference type name array form with dimension annotations.\n\t I x6 = @TypeAnnotation X @ArrayAnnotation[]@ArrayAnnotation[]::clone; \n\t // Reference type name array form with dimension annotations and type parameter annotations.\n\t I x7 = @TypeAnnotation X @ArrayAnnotation[]@ArrayAnnotation[]::<@TypeParameterAnnotation String>clone; \n\t // Generic type array form with dimension annotations and type parameter annotations.\n\t I x8 = @TypeAnnotation X<@TypeParameterAnnotation String> @ArrayAnnotation[]@ArrayAnnotation[]::<@TypeParameterAnnotation String>clone; \n\t // Qualified generic type array form with dimension annotations and type parameter annotations.\n\t I x9 = @TypeAnnotation X<@TypeParameterAnnotation String>.Y<@TypeParameterAnnotation String> @ArrayAnnotation[]@ArrayAnnotation[]::<@TypeParameterAnnotation String>clone; \n}\n";
        String expectedUnitToString = "interface I {\n  void foo();\n}\n@interface TypeAnnotation {\n}\nclass X<T> {\n  I x1 = @TypeAnnotation int[]::clone;\n  I x2 = @TypeAnnotation int @ArrayAnnotation [] @ArrayAnnotation []::clone;\n  I x3 = @TypeAnnotation int @ArrayAnnotation [] @ArrayAnnotation []::<@TypeParameterAnnotation String>clone;\n  I x4 = @TypeAnnotation X::clone;\n  I x5 = @TypeAnnotation X[]::clone;\n  I x6 = @TypeAnnotation X @ArrayAnnotation [] @ArrayAnnotation []::clone;\n  I x7 = @TypeAnnotation X @ArrayAnnotation [] @ArrayAnnotation []::<@TypeParameterAnnotation String>clone;\n  I x8 = @TypeAnnotation X<@TypeParameterAnnotation String> @ArrayAnnotation [] @ArrayAnnotation []::<@TypeParameterAnnotation String>clone;\n  I x9 = @TypeAnnotation X<@TypeParameterAnnotation String>.Y<@TypeParameterAnnotation String> @ArrayAnnotation [] @ArrayAnnotation []::<@TypeParameterAnnotation String>clone;\n  X() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test385374", expectedUnitToString);
    }

    public void test385374a() throws IOException {
    }
}

