/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractSelectionTest;
import org.eclipse.jdt.internal.codeassist.select.SelectionParser;
import org.eclipse.jdt.internal.codeassist.select.SelectionScanner;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class SelectionTest2
extends AbstractSelectionTest {
    boolean thereWasAnNPE = false;

    public SelectionTest2(String testName) {
        super(testName);
    }

    SpecialSelectionParser createParser() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        SpecialSelectionParser parser = new SpecialSelectionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        return parser;
    }

    void checkMethodParse(SelectionParser parser, char[] source, int selectionStart, int selectionEnd, String expectedSelection, String expectedUnitToString, String expectedSelectionIdentifier, String expectedSelectedSource, String testName) {
        char[] chars;
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration unit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult, selectionStart, selectionEnd);
        ASTNode foundMethod = null;
        if (unit.types != null) {
            int i = 0;
            while (i < unit.types.length) {
                TypeDeclaration type = unit.types[i];
                ASTNode method = this.findMethod(type, selectionStart);
                if (method != null) {
                    foundMethod = method;
                    break;
                }
                ++i;
            }
        }
        SelectionTest2.assertTrue((String)"no method found at cursor location", (foundMethod != null ? 1 : 0) != 0);
        if (foundMethod instanceof AbstractMethodDeclaration) {
            parser.parseBlockStatements((AbstractMethodDeclaration)foundMethod, unit);
        } else {
            TypeDeclaration type = (TypeDeclaration)foundMethod;
            if (type.fields != null) {
                int i = 0;
                while (i < type.fields.length) {
                    FieldDeclaration field = type.fields[i];
                    if (field instanceof Initializer && field.sourceStart <= selectionStart && selectionStart <= field.sourceEnd) {
                        parser.parseBlockStatements((Initializer)field, type, unit);
                        break;
                    }
                    ++i;
                }
            }
        }
        String computedUnitToString = unit.toString();
        String computedCompletion = parser.assistNode == null ? "<NONE>" : parser.assistNode.toString();
        SelectionTest2.assertEquals("invalid selection node-" + testName, expectedSelection, computedCompletion);
        SelectionTest2.assertEquals("invalid selection location-" + testName, expectedUnitToString, computedUnitToString);
        if (expectedSelectionIdentifier != null) {
            chars = ((SelectionScanner)parser.scanner).selectionIdentifier;
            String computedSelectionIdentifier = chars == null ? "<NONE>" : new String(chars);
            SelectionTest2.assertEquals("invalid selection identifier-" + testName, expectedSelectionIdentifier, computedSelectionIdentifier);
        }
        if (expectedSelectedSource != null) {
            chars = null;
            if (parser.assistNode != null) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)parser.assistNode.sourceStart, (int)(parser.assistNode.sourceEnd + 1));
            } else if (parser.assistIdentifier() != null && ((SelectionScanner)parser.scanner).selectionEnd >= ((SelectionScanner)parser.scanner).selectionStart) {
                chars = CharOperation.subarray((char[])parser.scanner.source, (int)((SelectionScanner)parser.scanner).selectionStart, (int)(((SelectionScanner)parser.scanner).selectionEnd + 1));
            }
            String computedReplacedSource = chars == null ? "<NONE>" : new String(chars);
            SelectionTest2.assertEquals("invalid replaced source-" + testName, expectedSelectedSource, computedReplacedSource);
        }
    }

    public void testBug30946() {
        final SpecialSelectionParser parser = this.createParser();
        Thread query = new Thread(new Runnable(){

            public void run() {
                String str = "public class A {\n\tvoid foo() {\n\t\tif (true) {\n\t\t\tif()\n\t\t\tswitch (1) {\n\t\t\t\tcase A.B:\n\t\t\t\t\tC d= (C) s;\n\t\t\t\t\there\n\t\t\t}\n\t\t}\n\t}\n}n";
                String selection = "here";
                String expectedCompletionNodeToString = "<SelectOnName:here>";
                String completionIdentifier = "here";
                String expectedUnitDisplayString = "public class A {\n  public A() {\n  }\n  void foo() {\n    {\n      {\n        C d;\n        <SelectOnName:here>;\n      }\n    }\n  }\n}\n";
                String expectedReplacedSource = "here";
                String testName = "<inifinite loop test>";
                int selectionStart = str.lastIndexOf(selection);
                int selectionEnd = str.lastIndexOf(selection) + selection.length() - 1;
                try {
                    SelectionTest2.this.checkMethodParse(parser, str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
                }
                catch (NullPointerException nullPointerException) {
                    SelectionTest2.this.thereWasAnNPE = true;
                }
            }
        });
        query.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        parser.doNPEInParser();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        SelectionTest2.assertTrue((String)"there is an infinite loop", (!this.thereWasAnNPE ? 1 : 0) != 0);
    }

    class SpecialSelectionParser
    extends SelectionParser {
        public SpecialSelectionParser(ProblemReporter problemReporter) {
            super(problemReporter);
        }

        public void doNPEInParser() {
            this.stack = null;
        }
    }
}

