/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;

public class ClassFileComparatorTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public ClassFileComparatorTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassFileComparatorTest.buildAllCompliancesTestSuite(ClassFileComparatorTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.ClassFileComparatorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private void compileAndDeploy(String source, String className) {
        File directory = new File(SOURCE_DIRECTORY);
        if (!directory.exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + SOURCE_DIRECTORY);
            return;
        }
        String fileName = String.valueOf(SOURCE_DIRECTORY) + File.separator + className + ".java";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(source);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\"").append(fileName).append("\" -d \"").append(EVAL_DIRECTORY).append("\" -nowarn -g -classpath \"").append(Util.getJavaClassLibsAsString()).append(SOURCE_DIRECTORY).append("\"");
        BatchCompiler.compile((String)buffer.toString(), (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null);
    }

    /*
     * Loose catch block
     */
    private boolean areStructurallyDifferent(String classFile1, String classFile2, boolean orderRequired, boolean excludeSynthetic) {
        boolean bl;
        FileInputStream stream;
        block16: {
            stream = null;
            ClassFileReader reader = ClassFileReader.read((String)(String.valueOf(EVAL_DIRECTORY) + File.separator + classFile1 + ".class"));
            File file = new File(String.valueOf(EVAL_DIRECTORY) + File.separator + classFile2 + ".class");
            int fileLength = (int)file.length();
            byte[] classFileBytes = new byte[fileLength];
            stream = new FileInputStream(file);
            int bytesRead = 0;
            int lastReadSize = 0;
            while (lastReadSize != -1 && bytesRead != fileLength) {
                lastReadSize = stream.read(classFileBytes, bytesRead, fileLength - bytesRead);
                bytesRead += lastReadSize;
            }
            bl = reader.hasStructuralChanges(classFileBytes, orderRequired, excludeSynthetic);
            if (stream == null) break block16;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
        catch (IOException iOException) {
            block17: {
                if (stream == null) break block17;
                try {
                    stream.close();
                }
                catch (IOException iOException2) {}
            }
            return true;
        }
        catch (ClassFormatException classFormatException) {
            block18: {
                if (stream == null) break block18;
                {
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
    }

    public void test001() {
        try {
            String sourceA001 = "public class A001 {\n  public int foo() {\n    return 2;\n  }\n  public String toString() {\n    return \"hello\";\n  }\n}";
            this.compileAndDeploy(sourceA001, "A001");
            String sourceA001_2 = "public class A001_2 {\n  public int foo() {\n    return 2;\n  }\n  public String toString() {\n    return \"hello\";\n  }\n}";
            this.compileAndDeploy(sourceA001_2, "A001_2");
            ClassFileComparatorTest.assertTrue((!this.areStructurallyDifferent("A001", "A001_2", false, false) ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A001");
        }
    }

    public void test002() {
        try {
            String sourceA002 = "public class A002 {\n  public int foo() {\n    return 2;\n  }\n}";
            this.compileAndDeploy(sourceA002, "A002");
            String sourceA002_2 = "public class A002_2 {\n  public int foo() {\n    return 2;\n  }\n  public String toString() {\n    return \"hello\";\n  }\n}";
            this.compileAndDeploy(sourceA002_2, "A002_2");
            ClassFileComparatorTest.assertTrue((boolean)this.areStructurallyDifferent("A002", "A002_2", false, false));
        }
        finally {
            this.removeTempClass("A002");
        }
    }

    public void test003() {
        try {
            String sourceA003 = "public class A003 {\npublic static final int II = 5;\n}";
            this.compileAndDeploy(sourceA003, "A003");
            String sourceA003_2 = "public class A003_2 {\npublic static final int II = 6;\n}";
            this.compileAndDeploy(sourceA003_2, "A003_2");
            ClassFileComparatorTest.assertTrue((boolean)this.areStructurallyDifferent("A003", "A003_2", false, false));
        }
        finally {
            this.removeTempClass("A003");
        }
    }

    public void test004() {
        try {
            String sourceA004 = "public class A004 {\n  public int foo() {\n    return 2;\n  }\n  public String toString() {\n    return \"hello\";\n  }\n}";
            this.compileAndDeploy(sourceA004, "A004");
            String sourceA004_2 = "public class A004_2 {\n  public int foo() {\n    return 2;\n  }\n  public String toString() {\n    return \"hello\";\n  }\n}";
            this.compileAndDeploy(sourceA004_2, "A004_2");
            ClassFileComparatorTest.assertTrue((!this.areStructurallyDifferent("A004", "A004_2", true, true) ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A004");
        }
    }

    public void test005() {
        try {
            String sourceA005 = "public class A005 {\n  public int foo() {\n    return 2;\n  }\n}";
            this.compileAndDeploy(sourceA005, "A005");
            String sourceA005_2 = "public class A005_2 {\n  public int foo() {\n    return 2;\n  }\n  public String toString() {\n    return \"hello\";\n  }\n}";
            this.compileAndDeploy(sourceA005_2, "A005_2");
            ClassFileComparatorTest.assertTrue((boolean)this.areStructurallyDifferent("A005", "A005_2", true, true));
        }
        finally {
            this.removeTempClass("A005");
        }
    }

    public void test006() {
        try {
            String sourceA006 = "public class A006 {\npublic static final int II = 5;\n}";
            this.compileAndDeploy(sourceA006, "A006");
            String sourceA006_2 = "public class A006_2 {\npublic static final int II = 6;\n}";
            this.compileAndDeploy(sourceA006_2, "A006_2");
            ClassFileComparatorTest.assertTrue((boolean)this.areStructurallyDifferent("A006", "A006_2", true, true));
        }
        finally {
            this.removeTempClass("A006");
        }
    }

    public void test007() {
        try {
            String sourceA007 = "public class A007 {\npublic static final int II = 6;\npublic Runnable foo() {\n\treturn null;\n}\n}";
            this.compileAndDeploy(sourceA007, "A007");
            String sourceA007_2 = "public class A007_2 {\npublic static final int II = 6;\npublic Runnable foo() {\n\treturn new Runnable() {public void run() {}};\n}\n}";
            this.compileAndDeploy(sourceA007_2, "A007_2");
            ClassFileComparatorTest.assertTrue((!this.areStructurallyDifferent("A007", "A007_2", true, true) ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A007");
        }
    }

    public void test008() {
        try {
            String sourceA008 = "public class A008 {\nprivate int i = 6;\npublic int foo() {\n\treturn i;\n}\n}";
            this.compileAndDeploy(sourceA008, "A008");
            String sourceA008_2 = "public class A008_2 {\nprivate int i = 6;\npublic int foo() {\n\treturn 2;\n}\n}";
            this.compileAndDeploy(sourceA008_2, "A008_2");
            ClassFileComparatorTest.assertTrue((!this.areStructurallyDifferent("A008", "A008_2", true, false) ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A008");
        }
    }

    public void test009() {
        try {
            String sourceA009 = "public class A009 {\nprivate int i = 6;\npublic int foo() {\n\tclass A {\n\t\tint get() {\n\t\t\treturn i;\n\t\t}\n\t}\n\treturn new A().get();\n}\n}";
            this.compileAndDeploy(sourceA009, "A009");
            String sourceA009_2 = "public class A009_2 {\nprivate int i = 6;\npublic int foo() {\n\treturn 2;\n}\n}";
            this.compileAndDeploy(sourceA009_2, "A009_2");
            ClassFileComparatorTest.assertTrue((boolean)this.areStructurallyDifferent("A009", "A009_2", true, false));
        }
        finally {
            this.removeTempClass("A009");
        }
    }

    public void test010() {
        try {
            String sourceA010 = "public class A010 {\nprivate int i = 6;\npublic int foo() {\n\tclass A {\n\t\tint get() {\n\t\t\treturn i;\n\t\t}\n\t}\n\treturn new A().get();\n}\n}";
            this.compileAndDeploy(sourceA010, "A010");
            String sourceA010_2 = "public class A010_2 {\nprivate int i = 6;\npublic int foo() {\n\treturn 2;\n}\n}";
            this.compileAndDeploy(sourceA010_2, "A010_2");
            ClassFileComparatorTest.assertTrue((!this.areStructurallyDifferent("A010", "A010_2", true, true) ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A010");
        }
    }

    public void test011() {
        try {
            String sourceA011 = "public class A011 {\nprivate int i = 6;\npublic int foo() {\n\tclass A {\n\t\tint get() {\n\t\t\treturn i;\n\t\t}\n\t}\n\treturn new A().get();\n}\n}";
            this.compileAndDeploy(sourceA011, "A011");
            String sourceA011_2 = "public class A011_2 {\nprivate int i = 6;\npublic int foo() {\n\treturn 2;\n}\n}";
            this.compileAndDeploy(sourceA011_2, "A011_2");
            ClassFileComparatorTest.assertTrue((!this.areStructurallyDifferent("A011", "A011_2", false, true) ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A011");
        }
    }

    public void test012() {
        try {
            String sourceA012 = "public class A012 {\npublic Class foo() {\n\treturn null;\n}\n}";
            this.compileAndDeploy(sourceA012, "A012");
            String sourceA012_2 = "public class A012_2 {\npublic Class foo() {\n\treturn A012_2.class;\n}\n}";
            this.compileAndDeploy(sourceA012_2, "A012_2");
            ClassFileComparatorTest.assertTrue((boolean)this.areStructurallyDifferent("A012", "A012_2", false, false));
        }
        finally {
            this.removeTempClass("A012");
        }
    }

    public void test013() {
        try {
            String sourceA013 = "public class A013 {\npublic Class foo() {\n\treturn null;\n}\n}";
            this.compileAndDeploy(sourceA013, "A013");
            String sourceA013_2 = "public class A013_2 {\npublic Class foo() {\n\treturn A013_2.class;\n}\n}";
            this.compileAndDeploy(sourceA013_2, "A013_2");
            ClassFileComparatorTest.assertTrue((!this.areStructurallyDifferent("A013", "A013_2", false, true) ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A013");
        }
    }

    public void test014() {
        try {
            String sourceA014 = "public class A014 {\npublic Class foo() {\n\treturn null;\n}\n}";
            this.compileAndDeploy(sourceA014, "A014");
            String sourceA014_2 = "public class A014_2 {\npublic Class foo() {\n\treturn A014_2.class;\n}\n}";
            this.compileAndDeploy(sourceA014_2, "A014_2");
            ClassFileComparatorTest.assertTrue((!this.areStructurallyDifferent("A014", "A014_2", true, true) ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A014");
        }
    }

    public void test015() {
        try {
            String sourceA015 = "public class A015 {\n\tpublic class B {\n\t}\n  public int foo() {\n    return 2;\n  }\n  public String toString() {\n    return \"hello\";\n  }\n}";
            this.compileAndDeploy(sourceA015, "A015");
            ClassFileComparatorTest.assertTrue((!this.areStructurallyDifferent("A015$B", "A015$B", false, false) ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A015");
        }
    }

    public void test016() {
        try {
            String sourceA016 = "public class A016 {\npublic void boo() {\n}\n}";
            this.compileAndDeploy(sourceA016, "A016");
            String sourceA016_2 = "public class A016_2 {\npublic void foo() {\n}\n}";
            this.compileAndDeploy(sourceA016_2, "A016_2");
            ClassFileComparatorTest.assertTrue((boolean)this.areStructurallyDifferent("A016", "A016_2", false, false));
        }
        finally {
            this.removeTempClass("A016");
        }
    }
}

