/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;

public class ClassFileReaderTest_1_4
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        return ClassFileReaderTest_1_4.buildUniqueComplianceTestSuite(ClassFileReaderTest_1_4.testClass(), 0x300000L);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.ClassFileReaderTest_1_4");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ClassFileReaderTest_1_4(String name) {
        super(name);
    }

    public void test001() throws Exception {
        String source = "public class A001 {\n\tprivate int i = 6;\n\tpublic int foo() {\n\t\tclass A {\n\t\t\tint get() {\n\t\t\t\treturn i;\n\t\t\t}\n\t\t}\n\t\treturn new A().get();\n\t}\n};";
        String expectedOutput = "  // Method descriptor #19 ()I\n  // Stack: 3, Locals: 1\n  public int foo();\n     0  new A001$1$A [20]\n     3  dup\n     4  aload_0 [this]\n     5  invokespecial A001$1$A(A001) [22]\n     8  invokevirtual A001$1$A.get() : int [25]\n    11  ireturn\n      Line numbers:\n        [pc: 0, line: 9]\n      Local variable table:\n        [pc: 0, pc: 12] local: this index: 0 type: A001\n";
        this.checkClassFile("A001", source, expectedOutput);
    }

    public void test002() throws Exception {
        String source = "public class A002 {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(); /* \\u000d: CARRIAGE RETURN */\n\t\tSystem.out.println();\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  invokevirtual java.io.PrintStream.println() : void [22]\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  invokevirtual java.io.PrintStream.println() : void [22]\n    12  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 6, line: 4]\n        [pc: 12, line: 5]\n      Local variable table:\n        [pc: 0, pc: 13] local: args index: 0 type: java.lang.String[]\n";
        this.checkClassFile("A002", source, expectedOutput);
    }

    public void test003() throws Exception {
        String source = "public class A003 {\n\n\tpublic int bar() {\n\t\treturn 0;\n\t}\n\t\n\tpublic void foo() {\n\t\tSystem.out.println(bar());\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ()I\n  // Stack: 1, Locals: 1\n  public int bar();\n    0  iconst_0\n    1  ireturn\n      Line numbers:\n        [pc: 0, line: 4]\n      Local variable table:\n        [pc: 0, pc: 2] local: this index: 0 type: A003\n  \n  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  public void foo();\n     0  getstatic java.lang.System.out : java.io.PrintStream [17]\n     3  aload_0 [this]\n     4  invokevirtual A003.bar() : int [23]\n     7  invokevirtual java.io.PrintStream.println(int) : void [25]\n    10  return\n      Line numbers:\n        [pc: 0, line: 8]\n        [pc: 10, line: 9]\n      Local variable table:\n        [pc: 0, pc: 11] local: this index: 0 type: A003\n";
        this.checkClassFile("A003", source, expectedOutput);
    }

    public void test004() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   && !b) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  bipush 6\n     4  istore_2 [i]\n     5  iload_2 [i]\n     6  bipush 6\n     8  if_icmpne 22\n    11  iload_1 [b]\n    12  ifne 22\n    15  getstatic java.lang.System.out : java.io.PrintStream [16]\n    18  iload_2 [i]\n    19  invokevirtual java.io.PrintStream.println(int) : void [22]\n    22  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n        [pc: 5, line: 5]\n        [pc: 11, line: 6]\n        [pc: 15, line: 7]\n        [pc: 22, line: 9]\n      Local variable table:\n        [pc: 0, pc: 23] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 23] local: b index: 1 type: boolean\n        [pc: 5, pc: 23] local: i index: 2 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test005() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   && true) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  bipush 6\n     6  if_icmpne 16\n     9  getstatic java.lang.System.out : java.io.PrintStream [16]\n    12  iload_1 [i]\n    13  invokevirtual java.io.PrintStream.println(int) : void [22]\n    16  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 9, line: 6]\n        [pc: 16, line: 8]\n      Local variable table:\n        [pc: 0, pc: 17] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 17] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test006() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   && false) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n    0  bipush 6\n    2  istore_1 [i]\n    3  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 8]\n      Local variable table:\n        [pc: 0, pc: 4] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 4] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test007() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (true\n\t\t   && !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  iload_1 [b]\n     3  ifne 12\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  invokevirtual java.io.PrintStream.println() : void [22]\n    12  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 6, line: 6]\n        [pc: 12, line: 8]\n      Local variable table:\n        [pc: 0, pc: 13] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 13] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test008() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (false\n\t\t   && !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n    0  iconst_0\n    1  istore_1 [b]\n    2  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 8]\n      Local variable table:\n        [pc: 0, pc: 3] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 3] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test009() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   || !b) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  bipush 6\n     4  istore_2 [i]\n     5  iload_2 [i]\n     6  bipush 6\n     8  if_icmpeq 15\n    11  iload_1 [b]\n    12  ifne 22\n    15  getstatic java.lang.System.out : java.io.PrintStream [16]\n    18  iload_2 [i]\n    19  invokevirtual java.io.PrintStream.println(int) : void [22]\n    22  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n        [pc: 5, line: 5]\n        [pc: 11, line: 6]\n        [pc: 15, line: 7]\n        [pc: 22, line: 9]\n      Local variable table:\n        [pc: 0, pc: 23] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 23] local: b index: 1 type: boolean\n        [pc: 5, pc: 23] local: i index: 2 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test010() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   || true) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  getstatic java.lang.System.out : java.io.PrintStream [16]\n     6  iload_1 [i]\n     7  invokevirtual java.io.PrintStream.println(int) : void [22]\n    10  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 6]\n        [pc: 10, line: 8]\n      Local variable table:\n        [pc: 0, pc: 11] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 11] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test011() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   || false) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  bipush 6\n     6  if_icmpne 16\n     9  getstatic java.lang.System.out : java.io.PrintStream [16]\n    12  iload_1 [i]\n    13  invokevirtual java.io.PrintStream.println(int) : void [22]\n    16  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 9, line: 6]\n        [pc: 16, line: 8]\n      Local variable table:\n        [pc: 0, pc: 17] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 17] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test012() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (true\n\t\t   || !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n    0  iconst_0\n    1  istore_1 [b]\n    2  getstatic java.lang.System.out : java.io.PrintStream [16]\n    5  invokevirtual java.io.PrintStream.println() : void [22]\n    8  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 6]\n        [pc: 8, line: 8]\n      Local variable table:\n        [pc: 0, pc: 9] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 9] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test013() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (false\n\t\t   || !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  iload_1 [b]\n     3  ifne 12\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  invokevirtual java.io.PrintStream.println() : void [22]\n    12  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 6, line: 6]\n        [pc: 12, line: 8]\n      Local variable table:\n        [pc: 0, pc: 13] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 13] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test014() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   == !b) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  bipush 6\n     4  istore_2 [i]\n     5  iload_2 [i]\n     6  bipush 6\n     8  if_icmpne 15\n    11  iconst_1\n    12  goto 16\n    15  iconst_0\n    16  iload_1 [b]\n    17  ifeq 24\n    20  iconst_0\n    21  goto 25\n    24  iconst_1\n    25  if_icmpne 35\n    28  getstatic java.lang.System.out : java.io.PrintStream [16]\n    31  iload_2 [i]\n    32  invokevirtual java.io.PrintStream.println(int) : void [22]\n    35  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n        [pc: 5, line: 5]\n        [pc: 16, line: 6]\n        [pc: 28, line: 7]\n        [pc: 35, line: 9]\n      Local variable table:\n        [pc: 0, pc: 36] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 36] local: b index: 1 type: boolean\n        [pc: 5, pc: 36] local: i index: 2 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test015() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   == true) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  bipush 6\n     6  if_icmpne 16\n     9  getstatic java.lang.System.out : java.io.PrintStream [16]\n    12  iload_1 [i]\n    13  invokevirtual java.io.PrintStream.println(int) : void [22]\n    16  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 9, line: 6]\n        [pc: 16, line: 8]\n      Local variable table:\n        [pc: 0, pc: 17] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 17] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test016() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   == false) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  bipush 6\n     6  if_icmpeq 16\n     9  getstatic java.lang.System.out : java.io.PrintStream [16]\n    12  iload_1 [i]\n    13  invokevirtual java.io.PrintStream.println(int) : void [22]\n    16  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 9, line: 6]\n        [pc: 16, line: 8]\n      Local variable table:\n        [pc: 0, pc: 17] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 17] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test017() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (true\n\t\t   == !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  iload_1 [b]\n     3  ifne 12\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  invokevirtual java.io.PrintStream.println() : void [22]\n    12  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 6, line: 6]\n        [pc: 12, line: 8]\n      Local variable table:\n        [pc: 0, pc: 13] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 13] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test018() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (false\n\t\t   == !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  iload_1 [b]\n     3  ifeq 12\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  invokevirtual java.io.PrintStream.println() : void [22]\n    12  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 6, line: 6]\n        [pc: 12, line: 8]\n      Local variable table:\n        [pc: 0, pc: 13] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 13] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test019() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tint i = 6;\n\t\tif ((i == 5)\n\t\t\t? b : !b) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  bipush 6\n     4  istore_2 [i]\n     5  iload_2 [i]\n     6  iconst_5\n     7  if_icmpne 17\n    10  iload_1 [b]\n    11  ifeq 28\n    14  goto 21\n    17  iload_1 [b]\n    18  ifne 28\n    21  getstatic java.lang.System.out : java.io.PrintStream [16]\n    24  iload_2 [i]\n    25  invokevirtual java.io.PrintStream.println(int) : void [22]\n    28  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n        [pc: 5, line: 5]\n        [pc: 10, line: 6]\n        [pc: 21, line: 7]\n        [pc: 28, line: 9]\n      Local variable table:\n        [pc: 0, pc: 29] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 29] local: b index: 1 type: boolean\n        [pc: 5, pc: 29] local: i index: 2 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test020() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (i\n\t\t\t>= 5) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  iconst_5\n     5  if_icmplt 15\n     8  getstatic java.lang.System.out : java.io.PrintStream [16]\n    11  iload_1 [i]\n    12  invokevirtual java.io.PrintStream.println(int) : void [22]\n    15  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 4, line: 5]\n        [pc: 8, line: 6]\n        [pc: 15, line: 8]\n      Local variable table:\n        [pc: 0, pc: 16] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 16] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test021() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (i\n\t\t\t>= 0) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  iflt 14\n     7  getstatic java.lang.System.out : java.io.PrintStream [16]\n    10  iload_1 [i]\n    11  invokevirtual java.io.PrintStream.println(int) : void [22]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 7, line: 6]\n        [pc: 14, line: 8]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 15] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test022() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (0\n\t\t\t>= i) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  ifgt 14\n     7  getstatic java.lang.System.out : java.io.PrintStream [16]\n    10  iload_1 [i]\n    11  invokevirtual java.io.PrintStream.println(int) : void [22]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 5]\n        [pc: 7, line: 6]\n        [pc: 14, line: 8]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 15] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test023() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (i\n\t\t\t> 0) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  ifle 14\n     7  getstatic java.lang.System.out : java.io.PrintStream [16]\n    10  iload_1 [i]\n    11  invokevirtual java.io.PrintStream.println(int) : void [22]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 7, line: 6]\n        [pc: 14, line: 8]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 15] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test024() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (0\n\t\t\t> i) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  ifge 14\n     7  getstatic java.lang.System.out : java.io.PrintStream [16]\n    10  iload_1 [i]\n    11  invokevirtual java.io.PrintStream.println(int) : void [22]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 5]\n        [pc: 7, line: 6]\n        [pc: 14, line: 8]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 15] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test025() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (i\n\t\t\t> 5) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  iconst_5\n     5  if_icmple 15\n     8  getstatic java.lang.System.out : java.io.PrintStream [16]\n    11  iload_1 [i]\n    12  invokevirtual java.io.PrintStream.println(int) : void [22]\n    15  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 4, line: 5]\n        [pc: 8, line: 6]\n        [pc: 15, line: 8]\n      Local variable table:\n        [pc: 0, pc: 16] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 16] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test026() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (i\n\t\t\t< 0) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  ifge 14\n     7  getstatic java.lang.System.out : java.io.PrintStream [16]\n    10  iload_1 [i]\n    11  invokevirtual java.io.PrintStream.println(int) : void [22]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 7, line: 6]\n        [pc: 14, line: 8]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 15] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test027() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (0\n\t\t\t< i) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  ifle 14\n     7  getstatic java.lang.System.out : java.io.PrintStream [16]\n    10  iload_1 [i]\n    11  invokevirtual java.io.PrintStream.println(int) : void [22]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 5]\n        [pc: 7, line: 6]\n        [pc: 14, line: 8]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 15] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test028() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (i\n\t\t\t< 5) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  iconst_5\n     5  if_icmpge 15\n     8  getstatic java.lang.System.out : java.io.PrintStream [16]\n    11  iload_1 [i]\n    12  invokevirtual java.io.PrintStream.println(int) : void [22]\n    15  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 4, line: 5]\n        [pc: 8, line: 6]\n        [pc: 15, line: 8]\n      Local variable table:\n        [pc: 0, pc: 16] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 16] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test029() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (i\n\t\t\t<= 0) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  ifgt 14\n     7  getstatic java.lang.System.out : java.io.PrintStream [16]\n    10  iload_1 [i]\n    11  invokevirtual java.io.PrintStream.println(int) : void [22]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 7, line: 6]\n        [pc: 14, line: 8]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 15] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test030() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (0\n\t\t\t<= i) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  iflt 14\n     7  getstatic java.lang.System.out : java.io.PrintStream [16]\n    10  iload_1 [i]\n    11  invokevirtual java.io.PrintStream.println(int) : void [22]\n    14  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 5]\n        [pc: 7, line: 6]\n        [pc: 14, line: 8]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 15] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test031() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (i\n\t\t\t<= 5) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  iconst_5\n     5  if_icmpgt 15\n     8  getstatic java.lang.System.out : java.io.PrintStream [16]\n    11  iload_1 [i]\n    12  invokevirtual java.io.PrintStream.println(int) : void [22]\n    15  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 4, line: 5]\n        [pc: 8, line: 6]\n        [pc: 15, line: 8]\n      Local variable table:\n        [pc: 0, pc: 16] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 16] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test032() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif (i\n\t\t\t<= 5) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  iconst_5\n     5  if_icmpgt 15\n     8  getstatic java.lang.System.out : java.io.PrintStream [16]\n    11  iload_1 [i]\n    12  invokevirtual java.io.PrintStream.println(int) : void [22]\n    15  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 4, line: 5]\n        [pc: 8, line: 6]\n        [pc: 15, line: 8]\n      Local variable table:\n        [pc: 0, pc: 16] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 16] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test033() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   & !b) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  bipush 6\n     4  istore_2 [i]\n     5  iload_2 [i]\n     6  bipush 6\n     8  if_icmpne 15\n    11  iconst_1\n    12  goto 16\n    15  iconst_0\n    16  iload_1 [b]\n    17  ifeq 24\n    20  iconst_0\n    21  goto 25\n    24  iconst_1\n    25  iand\n    26  ifeq 36\n    29  getstatic java.lang.System.out : java.io.PrintStream [16]\n    32  iload_2 [i]\n    33  invokevirtual java.io.PrintStream.println(int) : void [22]\n    36  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n        [pc: 5, line: 5]\n        [pc: 16, line: 6]\n        [pc: 29, line: 7]\n        [pc: 36, line: 9]\n      Local variable table:\n        [pc: 0, pc: 37] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 37] local: b index: 1 type: boolean\n        [pc: 5, pc: 37] local: i index: 2 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test034() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   & true) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  bipush 6\n     6  if_icmpne 16\n     9  getstatic java.lang.System.out : java.io.PrintStream [16]\n    12  iload_1 [i]\n    13  invokevirtual java.io.PrintStream.println(int) : void [22]\n    16  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 9, line: 6]\n        [pc: 16, line: 8]\n      Local variable table:\n        [pc: 0, pc: 17] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 17] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test035() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   & false) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n    0  bipush 6\n    2  istore_1 [i]\n    3  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 8]\n      Local variable table:\n        [pc: 0, pc: 4] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 4] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test036() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (true\n\t\t   & !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  iload_1 [b]\n     3  ifne 12\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  invokevirtual java.io.PrintStream.println() : void [22]\n    12  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 6, line: 6]\n        [pc: 12, line: 8]\n      Local variable table:\n        [pc: 0, pc: 13] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 13] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test037() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (false\n\t\t   & !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n    0  iconst_0\n    1  istore_1 [b]\n    2  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 8]\n      Local variable table:\n        [pc: 0, pc: 3] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 3] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test038() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   | !b) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  bipush 6\n     4  istore_2 [i]\n     5  iload_2 [i]\n     6  bipush 6\n     8  if_icmpne 15\n    11  iconst_1\n    12  goto 16\n    15  iconst_0\n    16  iload_1 [b]\n    17  ifeq 24\n    20  iconst_0\n    21  goto 25\n    24  iconst_1\n    25  ior\n    26  ifeq 36\n    29  getstatic java.lang.System.out : java.io.PrintStream [16]\n    32  iload_2 [i]\n    33  invokevirtual java.io.PrintStream.println(int) : void [22]\n    36  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n        [pc: 5, line: 5]\n        [pc: 16, line: 6]\n        [pc: 29, line: 7]\n        [pc: 36, line: 9]\n      Local variable table:\n        [pc: 0, pc: 37] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 37] local: b index: 1 type: boolean\n        [pc: 5, pc: 37] local: i index: 2 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test039() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   | true) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  getstatic java.lang.System.out : java.io.PrintStream [16]\n     6  iload_1 [i]\n     7  invokevirtual java.io.PrintStream.println(int) : void [22]\n    10  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 6]\n        [pc: 10, line: 8]\n      Local variable table:\n        [pc: 0, pc: 11] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 11] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test040() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   | false) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  bipush 6\n     6  if_icmpne 16\n     9  getstatic java.lang.System.out : java.io.PrintStream [16]\n    12  iload_1 [i]\n    13  invokevirtual java.io.PrintStream.println(int) : void [22]\n    16  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 9, line: 6]\n        [pc: 16, line: 8]\n      Local variable table:\n        [pc: 0, pc: 17] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 17] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test041() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (true\n\t\t   | !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n    0  iconst_0\n    1  istore_1 [b]\n    2  getstatic java.lang.System.out : java.io.PrintStream [16]\n    5  invokevirtual java.io.PrintStream.println() : void [22]\n    8  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 6]\n        [pc: 8, line: 8]\n      Local variable table:\n        [pc: 0, pc: 9] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 9] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test042() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (false\n\t\t   | !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  iload_1 [b]\n     3  ifne 12\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  invokevirtual java.io.PrintStream.println() : void [22]\n    12  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 6, line: 6]\n        [pc: 12, line: 8]\n      Local variable table:\n        [pc: 0, pc: 13] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 13] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test043() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   ^ !b) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  bipush 6\n     4  istore_2 [i]\n     5  iload_2 [i]\n     6  bipush 6\n     8  if_icmpne 15\n    11  iconst_1\n    12  goto 16\n    15  iconst_0\n    16  iload_1 [b]\n    17  ifeq 24\n    20  iconst_0\n    21  goto 25\n    24  iconst_1\n    25  ixor\n    26  ifeq 36\n    29  getstatic java.lang.System.out : java.io.PrintStream [16]\n    32  iload_2 [i]\n    33  invokevirtual java.io.PrintStream.println(int) : void [22]\n    36  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n        [pc: 5, line: 5]\n        [pc: 16, line: 6]\n        [pc: 29, line: 7]\n        [pc: 36, line: 9]\n      Local variable table:\n        [pc: 0, pc: 37] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 37] local: b index: 1 type: boolean\n        [pc: 5, pc: 37] local: i index: 2 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test044() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   ^ true) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  bipush 6\n     6  if_icmpeq 16\n     9  getstatic java.lang.System.out : java.io.PrintStream [16]\n    12  iload_1 [i]\n    13  invokevirtual java.io.PrintStream.println(int) : void [22]\n    16  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 9, line: 6]\n        [pc: 16, line: 8]\n      Local variable table:\n        [pc: 0, pc: 17] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 17] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test045() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tint i = 6;\n\t\tif ((i == 6) \n\t\t   ^ false) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  bipush 6\n     2  istore_1 [i]\n     3  iload_1 [i]\n     4  bipush 6\n     6  if_icmpne 16\n     9  getstatic java.lang.System.out : java.io.PrintStream [16]\n    12  iload_1 [i]\n    13  invokevirtual java.io.PrintStream.println(int) : void [22]\n    16  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 3, line: 4]\n        [pc: 9, line: 6]\n        [pc: 16, line: 8]\n      Local variable table:\n        [pc: 0, pc: 17] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 17] local: i index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test046() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (true\n\t\t   ^ !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  iload_1 [b]\n     3  ifeq 12\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  invokevirtual java.io.PrintStream.println() : void [22]\n    12  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 6, line: 6]\n        [pc: 12, line: 8]\n      Local variable table:\n        [pc: 0, pc: 13] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 13] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test047() throws Exception {
        String source = "public class A {\n\tpublic static void main(String[] args) {\n\t\tboolean b = false;\n\t\tif (false\n\t\t   ^ !b) {   \t\n\t\t   \tSystem.out.println();\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [b]\n     2  iload_1 [b]\n     3  ifne 12\n     6  getstatic java.lang.System.out : java.io.PrintStream [16]\n     9  invokevirtual java.io.PrintStream.println() : void [22]\n    12  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 6, line: 6]\n        [pc: 12, line: 8]\n      Local variable table:\n        [pc: 0, pc: 13] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 13] local: b index: 1 type: boolean\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test048() throws Exception {
        String source = "public class A {\n\n\tstatic int foo(boolean bool) {\n\t  int j;\n\t  try {\n\t    if (bool) return 1;\n\t    j = 2;\n\t  } finally {\n\t    j = 3;\n\t  }\n\t  return j;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfoo(false);\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 (Z)I\n  // Stack: 1, Locals: 4\n  static int foo(boolean bool);\n     0  iload_0 [bool]\n     1  ifeq 9\n     4  jsr 20\n     7  iconst_1\n     8  ireturn\n     9  iconst_2\n    10  istore_1 [j]\n    11  goto 25\n    14  astore_3\n    15  jsr 20\n    18  aload_3\n    19  athrow\n    20  astore_2\n    21  iconst_3\n    22  istore_1 [j]\n    23  ret 2\n    25  jsr 20\n    28  iload_1 [j]\n    29  ireturn\n      Exception Table:\n        [pc: 0, pc: 7] -> 14 when : any\n        [pc: 9, pc: 14] -> 14 when : any\n        [pc: 25, pc: 28] -> 14 when : any\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 9, line: 7]\n        [pc: 11, line: 8]\n        [pc: 18, line: 10]\n        [pc: 20, line: 8]\n        [pc: 21, line: 9]\n        [pc: 23, line: 10]\n        [pc: 28, line: 11]\n      Local variable table:\n        [pc: 0, pc: 30] local: bool index: 0 type: boolean\n        [pc: 11, pc: 14] local: j index: 1 type: int\n        [pc: 23, pc: 30] local: j index: 1 type: int\n";
        this.checkClassFile("A", source, expectedOutput);
    }

    public void test049() throws Exception {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tfoo();\n\t}\n\tstatic void foo() {\n\t\tint i = 5;\n\t\tif ((i == 6) && false) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  static void foo();\n    0  iconst_5\n    1  istore_0 [i]\n    2  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 2, line: 10]\n      Local variable table:\n        [pc: 2, pc: 3] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test050() throws Exception {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tfoo();\n\t}\n\tstatic void foo() {\n\t\tint i = 5;\n\t\tif ((i == 6) && false) {}\n\t\telse {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void foo();\n     0  iconst_5\n     1  istore_0 [i]\n     2  getstatic java.lang.System.out : java.io.PrintStream [21]\n     5  iload_0 [i]\n     6  invokevirtual java.io.PrintStream.println(int) : void [27]\n     9  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 2, line: 9]\n        [pc: 9, line: 11]\n      Local variable table:\n        [pc: 2, pc: 10] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test051() throws Exception {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tbar();\n\t}\n\tstatic void bar() {\n\t\tint i = 6;\n\t\tif ((i == 6) || true) {\n\t\t} else {\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  static void bar();\n    0  bipush 6\n    2  istore_0 [i]\n    3  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 3, line: 11]\n      Local variable table:\n        [pc: 3, pc: 4] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test052() throws Exception {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tbar();\n\t}\n\tstatic void bar() {\n\t\tint i = 6;\n\t\tif ((i == 6) || true) {\n\t\t   \tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void bar();\n     0  bipush 6\n     2  istore_0 [i]\n     3  getstatic java.lang.System.out : java.io.PrintStream [21]\n     6  iload_0 [i]\n     7  invokevirtual java.io.PrintStream.println(int) : void [27]\n    10  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 3, line: 8]\n        [pc: 10, line: 10]\n      Local variable table:\n        [pc: 3, pc: 11] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test053() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo2();\n\t}\n\tstatic void foo2() {\n\t\tint i = 5;\n\t\tif ((i == 6) && (boom() && false)) {\n\t\t   \tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void foo2();\n     0  iconst_5\n     1  istore_0 [i]\n     2  iload_0 [i]\n     3  bipush 6\n     5  if_icmpne 12\n     8  invokestatic X.boom() : boolean [26]\n    11  pop\n    12  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 2, line: 10]\n        [pc: 12, line: 13]\n      Local variable table:\n        [pc: 2, pc: 13] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test054() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo2();\n\t}\n\tstatic void foo2() {\n\t\tint i = 5;\n\t\tif ((i == 6) && (boom() && false)) {\n\t\t} else {\n\t\t   \tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void foo2();\n     0  iconst_5\n     1  istore_0 [i]\n     2  iload_0 [i]\n     3  bipush 6\n     5  if_icmpne 12\n     8  invokestatic X.boom() : boolean [26]\n    11  pop\n    12  getstatic java.lang.System.out : java.io.PrintStream [28]\n    15  iload_0 [i]\n    16  invokevirtual java.io.PrintStream.println(int) : void [34]\n    19  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 2, line: 10]\n        [pc: 12, line: 12]\n        [pc: 19, line: 14]\n      Local variable table:\n        [pc: 2, pc: 20] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test055() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tbar2();\n\t}\n\tstatic void bar2() {\n\t\tint i = 6;\n\t\tif ((i == 6) || (boom() || true)) {\n\t\t} else {\n\t\t\tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void bar2();\n     0  bipush 6\n     2  istore_0 [i]\n     3  iload_0 [i]\n     4  bipush 6\n     6  if_icmpeq 13\n     9  invokestatic X.boom() : boolean [26]\n    12  pop\n    13  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 3, line: 10]\n        [pc: 13, line: 14]\n      Local variable table:\n        [pc: 3, pc: 14] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test056() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tbar2();\n\t}\n\tstatic void bar2() {\n\t\tint i = 6;\n\t\tif ((i == 6) || (boom() || true)) {\n\t\t\tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void bar2();\n     0  bipush 6\n     2  istore_0 [i]\n     3  iload_0 [i]\n     4  bipush 6\n     6  if_icmpeq 13\n     9  invokestatic X.boom() : boolean [26]\n    12  pop\n    13  getstatic java.lang.System.out : java.io.PrintStream [28]\n    16  iload_0 [i]\n    17  invokevirtual java.io.PrintStream.println(int) : void [34]\n    20  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 3, line: 10]\n        [pc: 13, line: 11]\n        [pc: 20, line: 13]\n      Local variable table:\n        [pc: 3, pc: 21] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test057() throws Exception {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tfoo3();\n\t}\n\tstatic void foo3() {\n\t\tint i = 5;\n\t\tif (false && (i == 6)) {\n\t\t   \tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  static void foo3();\n    0  iconst_5\n    1  istore_0 [i]\n    2  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 2, line: 10]\n      Local variable table:\n        [pc: 2, pc: 3] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test058() throws Exception {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tfoo3();\n\t}\n\tstatic void foo3() {\n\t\tint i = 5;\n\t\tif (false && (i == 6)) {\n\t\t} else {\n\t\t   \tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void foo3();\n     0  iconst_5\n     1  istore_0 [i]\n     2  getstatic java.lang.System.out : java.io.PrintStream [21]\n     5  iload_0 [i]\n     6  invokevirtual java.io.PrintStream.println(int) : void [27]\n     9  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 2, line: 9]\n        [pc: 9, line: 11]\n      Local variable table:\n        [pc: 2, pc: 10] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test059() throws Exception {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tbar3();\n\t}\n\tstatic void bar3() {\n\t\tint i = 6;\n\t\tif (true || (i == 6)) {\n\t\t} else {\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  static void bar3();\n    0  bipush 6\n    2  istore_0 [i]\n    3  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 3, line: 11]\n      Local variable table:\n        [pc: 3, pc: 4] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test060() throws Exception {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tbar3();\n\t}\n\tstatic void bar3() {\n\t\tint i = 6;\n\t\tif (true || (i == 6)) {\n\t\t   System.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void bar3();\n     0  bipush 6\n     2  istore_0 [i]\n     3  getstatic java.lang.System.out : java.io.PrintStream [21]\n     6  iload_0 [i]\n     7  invokevirtual java.io.PrintStream.println(int) : void [27]\n    10  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 3, line: 8]\n        [pc: 10, line: 10]\n      Local variable table:\n        [pc: 3, pc: 11] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test061() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo4();\n\t}\n\tstatic void foo4() {\n\t\tint i = 5;\n\t\tif ((false && boom()) && (i == 6)) {   \t\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  static void foo4();\n    0  iconst_5\n    1  istore_0 [i]\n    2  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 2, line: 13]\n      Local variable table:\n        [pc: 2, pc: 3] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test062() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo4();\n\t}\n\tstatic void foo4() {\n\t\tint i = 5;\n\t\tif ((false && boom()) && (i == 6)) {\n\t\t} else {  \t\n\t\t   System.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void foo4();\n     0  iconst_5\n     1  istore_0 [i]\n     2  getstatic java.lang.System.out : java.io.PrintStream [26]\n     5  iload_0 [i]\n     6  invokevirtual java.io.PrintStream.println(int) : void [32]\n     9  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 2, line: 12]\n        [pc: 9, line: 14]\n      Local variable table:\n        [pc: 2, pc: 10] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test063() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tbar4();\n\t}\n\tstatic void bar4() {\n\t\tint i = 6;\n\t\tif ((true || boom()) || (i == 6)) {\n\t\t} else {\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  static void bar4();\n    0  bipush 6\n    2  istore_0 [i]\n    3  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 3, line: 14]\n      Local variable table:\n        [pc: 3, pc: 4] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test064() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tbar4();\n\t}\n\tstatic void bar4() {\n\t\tint i = 6;\n\t\tif ((true || boom()) || (i == 6)) {\n\t\t   \tSystem.out.println(i);\n\t\t   }\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void bar4();\n     0  bipush 6\n     2  istore_0 [i]\n     3  getstatic java.lang.System.out : java.io.PrintStream [26]\n     6  iload_0 [i]\n     7  invokevirtual java.io.PrintStream.println(int) : void [32]\n    10  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 3, line: 11]\n        [pc: 10, line: 13]\n      Local variable table:\n        [pc: 3, pc: 11] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test065() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo5();\n\t}\n\tstatic void foo5() {\n\t\tint i = 5;\n\t\tif (((i == 6) && (boom() && false)) && false) {\n\t\t\tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void foo5();\n     0  iconst_5\n     1  istore_0 [i]\n     2  iload_0 [i]\n     3  bipush 6\n     5  if_icmpne 12\n     8  invokestatic X.boom() : boolean [26]\n    11  pop\n    12  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 2, line: 10]\n        [pc: 12, line: 13]\n      Local variable table:\n        [pc: 2, pc: 13] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test066() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo5();\n\t}\n\tstatic void foo5() {\n\t\tint i = 5;\n\t\tif (((i == 6) && (boom() && false)) && false) {\n\t\t} else {\n\t\t\tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void foo5();\n     0  iconst_5\n     1  istore_0 [i]\n     2  iload_0 [i]\n     3  bipush 6\n     5  if_icmpne 12\n     8  invokestatic X.boom() : boolean [26]\n    11  pop\n    12  getstatic java.lang.System.out : java.io.PrintStream [28]\n    15  iload_0 [i]\n    16  invokevirtual java.io.PrintStream.println(int) : void [34]\n    19  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 2, line: 10]\n        [pc: 12, line: 12]\n        [pc: 19, line: 14]\n      Local variable table:\n        [pc: 2, pc: 20] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test067() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tbar5();\n\t}\n\tstatic void bar5() {\n\t\tint i = 6;\n\t\tif (((i == 6) || (boom() || true)) && true) {\n\t\t} else {\n\t\t\tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void bar5();\n     0  bipush 6\n     2  istore_0 [i]\n     3  iload_0 [i]\n     4  bipush 6\n     6  if_icmpeq 13\n     9  invokestatic X.boom() : boolean [26]\n    12  pop\n    13  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 3, line: 10]\n        [pc: 13, line: 14]\n      Local variable table:\n        [pc: 3, pc: 14] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test068() throws Exception {
        String source = "public class X {\n\tstatic boolean boom() { \n\t\tthrow new NullPointerException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tbar5();\n\t}\n\tstatic void bar5() {\n\t\tint i = 6;\n\t\tif (((i == 6) || (boom() || true)) && true) {\n\t\t\tSystem.out.println(i);\n\t\t}\n\t}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  static void bar5();\n     0  bipush 6\n     2  istore_0 [i]\n     3  iload_0 [i]\n     4  bipush 6\n     6  if_icmpeq 13\n     9  invokestatic X.boom() : boolean [26]\n    12  pop\n    13  getstatic java.lang.System.out : java.io.PrintStream [28]\n    16  iload_0 [i]\n    17  invokevirtual java.io.PrintStream.println(int) : void [34]\n    20  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 3, line: 10]\n        [pc: 13, line: 11]\n        [pc: 20, line: 13]\n      Local variable table:\n        [pc: 3, pc: 21] local: i index: 0 type: int\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test069() throws Exception {
        String source = "public interface I {\n}";
        String expectedOutput = "// Compiled from I.java (version 1.2 : 46.0, no super bit)\npublic abstract interface I {\n  Constant pool:\n    constant #1 class: #2 I\n    constant #2 utf8: \"I\"\n    constant #3 class: #4 java/lang/Object\n    constant #4 utf8: \"java/lang/Object\"\n    constant #5 utf8: \"SourceFile\"\n    constant #6 utf8: \"I.java\"\n}";
        this.checkClassFile("I", source, expectedOutput);
    }

    public void test072() throws Exception {
        String source = "package p;\npublic abstract class X {\n\tpublic static final double CONST = Double.POSITIVE_INFINITY;\n\tX(X x) {}\n\tint foo() { return 0; }\n\tdouble foo2() { return 0; }\n\tbyte foo3() { return 0; }\n\tchar foo4() { return 0; }\n\tfloat foo5() { return 0; }\n\tlong foo6() { return 0; }\n\tshort foo7() { return 0; }\n\tObject foo8() { return null; }\n\tboolean foo9() { return false; }\n\tvoid foo10() {}\n\tnative void foo11();\n\tabstract String foo12();\n}";
        String expectedOutput = "package p;\npublic abstract class X {\n  \n  public static final double CONST = 1.0 / 0.0;\n  \n  X(p.X x) {\n  }\n  \n  int foo() {\n    return 0;\n  }\n  \n  double foo2() {\n    return 0;\n  }\n  \n  byte foo3() {\n    return 0;\n  }\n  \n  char foo4() {\n    return 0;\n  }\n  \n  float foo5() {\n    return 0;\n  }\n  \n  long foo6() {\n    return 0;\n  }\n  \n  short foo7() {\n    return 0;\n  }\n  \n  java.lang.Object foo8() {\n    return null;\n  }\n  \n  boolean foo9() {\n    return false;\n  }\n  \n  void foo10() {\n  }\n  \n  native void foo11();\n  \n  abstract java.lang.String foo12();\n}";
        this.checkClassFile("p", "X", source, expectedOutput, 16);
    }

    public void test073() throws Exception {
        String source = "public class X {\n\tpublic static final double CONST = Double.POSITIVE_INFINITY;\n\tX(X x) {}\n}";
        String expectedOutput = "public class X {\n  \n  public static final double CONST = 1.0 / 0.0;\n  \n  X(X x) {\n  }\n}";
        this.checkClassFile("", "X", source, expectedOutput, 16);
    }

    public void test074() throws Exception {
        String source = "package p;\npublic class X {\n\tpublic static final double CONST = Double.POSITIVE_INFINITY;\n\tX(X x) {}\n}";
        String expectedOutput = "package p;\npublic class X {\n  \n  public static final double CONST = 1.0 / 0.0;\n  \n  X(X x) {\n  }\n}";
        this.checkClassFile("p", "X", source, expectedOutput, 24);
    }

    public void test075() throws Exception {
        String source = "package p;\npublic class X {\n\tpublic static final String CONST = \"\";\n\tX(X x) {}\n}";
        String expectedOutput = "package p;\npublic class X {\n  \n  public static final String CONST = \"\";\n  \n  X(X x) {\n  }\n}";
        this.checkClassFile("p", "X", source, expectedOutput, 24);
    }

    public void test076() throws Exception {
        String source = "public class X {\n\tvoid foo() {\n\t\ttry {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t} catch(Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}";
        String expectedOutput = "      Exception Table:\n        [pc: 0, pc: 8] -> 11 when : Exception\n";
        this.checkClassFile("", "X", source, expectedOutput, 9);
    }

    public void test077() throws Exception {
        String source = "package p;\npublic class X {\n\tprivate static class A {}\n}";
        String expectedOutput = "private static class p.X$A {\n";
        this.checkClassFile("p", "X", "X$A", source, expectedOutput, 9);
    }

    public void test078() throws Exception {
        String source = "public class X {\n\tX(int i, int j) {}\n\tvoid foo(String s, double d) {}\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod[] methodInfos = classFileReader.getMethods();
        ClassFileReaderTest_1_4.assertNotNull((String)"No method infos", (Object)methodInfos);
        int length = methodInfos.length;
        ClassFileReaderTest_1_4.assertTrue((String)"At least one method", (length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < length) {
            char[][] argNames = methodInfos[i].getArgumentNames();
            ClassFileReaderTest_1_4.assertNotNull((String)"No names", (Object)argNames);
            ClassFileReaderTest_1_4.assertEquals((String)"Wrong size", (int)2, (int)argNames.length);
            if (CharOperation.equals((char[])methodInfos[i].getSelector(), (char[])"<init>".toCharArray())) {
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "i", new String(argNames[0]));
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "j", new String(argNames[1]));
            } else if (CharOperation.equals((char[])methodInfos[i].getSelector(), (char[])"foo".toCharArray())) {
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "s", new String(argNames[0]));
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "d", new String(argNames[1]));
            }
            ++i;
        }
    }

    public void test079() throws Exception {
        String source = "public class X {\n\tX(int i, int j) {}\n\tvoid foo(String s, double d) throws Exception {\n\t\ttry {\n\t\t\tSystem.out.println(s + d);\n\t\t} catch(Exception e) {\n\t\t\te.printStackTrace();\n\t\t\tthrow e;\n\t\t} finally {\n\t\t\tSystem.out.println(\"done\");\n\t\t}\n\t}\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod[] methodInfos = classFileReader.getMethods();
        ClassFileReaderTest_1_4.assertNotNull((String)"No method infos", (Object)methodInfos);
        int length = methodInfos.length;
        ClassFileReaderTest_1_4.assertTrue((String)"At least one method", (length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < length) {
            char[][] argNames = methodInfos[i].getArgumentNames();
            ClassFileReaderTest_1_4.assertNotNull((String)"No names", (Object)argNames);
            ClassFileReaderTest_1_4.assertEquals((String)"Wrong size", (int)2, (int)argNames.length);
            if (CharOperation.equals((char[])methodInfos[i].getSelector(), (char[])"<init>".toCharArray())) {
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "i", new String(argNames[0]));
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "j", new String(argNames[1]));
            } else if (CharOperation.equals((char[])methodInfos[i].getSelector(), (char[])"foo".toCharArray())) {
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "s", new String(argNames[0]));
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "d", new String(argNames[1]));
            }
            ++i;
        }
    }

    public void test080() throws Exception {
        String source = "public class X {\n\tX(int i, int j) {}\n\tvoid foo(String s, double d) throws Exception {\n\t\ttry {\n\t\t\tint k = 0;\n\t\t\tSystem.out.println(s + d + k);\n\t\t} catch(Exception e) {\n\t\t\te.printStackTrace();\n\t\t\tthrow e;\n\t\t} finally {\n\t\t\tSystem.out.println(\"done\");\n\t\t}\n\t}\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod[] methodInfos = classFileReader.getMethods();
        ClassFileReaderTest_1_4.assertNotNull((String)"No method infos", (Object)methodInfos);
        int length = methodInfos.length;
        ClassFileReaderTest_1_4.assertTrue((String)"At least one method", (length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < length) {
            char[][] argNames = methodInfos[i].getArgumentNames();
            ClassFileReaderTest_1_4.assertNotNull((String)"No names", (Object)argNames);
            ClassFileReaderTest_1_4.assertEquals((String)"Wrong size", (int)2, (int)argNames.length);
            if (CharOperation.equals((char[])methodInfos[i].getSelector(), (char[])"<init>".toCharArray())) {
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "i", new String(argNames[0]));
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "j", new String(argNames[1]));
            } else if (CharOperation.equals((char[])methodInfos[i].getSelector(), (char[])"foo".toCharArray())) {
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "s", new String(argNames[0]));
                ClassFileReaderTest_1_4.assertEquals("Wrong argument name", "d", new String(argNames[1]));
            }
            ++i;
        }
    }
}

