/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ForStatementTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public ForStatementTest(String name) {
        super(name);
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        return options;
    }

    public static Test suite() {
        return ForStatementTest.buildAllCompliancesTestSuite(ForStatementTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Object m(int[] arg) {\n\t\tyyLoop: for (int i = 0;; ++i) {\n\t\t\tyyInner: for (;;) {\n\t\t\t\tswitch (arg[i]) {\n\t\t\t\t\tcase 0:\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 1:\n\t\t\t\t\t\tcontinue yyInner;\n\t\t\t\t}\n\t\t\t\tif (i == 32)\n\t\t\t\t\treturn arg;\n\t\t\t\tif (i == 12)\n\t\t\t\t\tbreak;\n\t\t\t\tcontinue yyLoop;\n\t\t\t}\n\t\t\tif (i == 32)\n\t\t\t\treturn null;\n\t\t\tif (i > 7)\n\t\t\t\tcontinue yyLoop;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test002() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo2(int[] array) {\n\t\tfor (int i = 0; i < array.length; i++) {\n\t\t\tSystem.out.println(i);\n\t\t\tbreak;\n\t\t}\n\t}\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #15 ([I)V\n  // Stack: 2, Locals: 3\n  void foo2(int[] array);\n     0  iconst_0\n     1  istore_2 [i]\n     2  iload_2 [i]\n     3  aload_1 [array]\n     4  arraylength\n     5  if_icmpge 15\n     8  getstatic java.lang.System.out : java.io.PrintStream [16]\n    11  iload_2 [i]\n    12  invokevirtual java.io.PrintStream.println(int) : void [22]\n    15  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 8, line: 4]\n        [pc: 15, line: 7]\n      Local variable table:\n        [pc: 0, pc: 16] local: this index: 0 type: X\n        [pc: 0, pc: 16] local: array index: 1 type: int[]\n        [pc: 2, pc: 15] local: i index: 2 type: int\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ForStatementTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test003() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo4(int[] array) {\n\t\tdo {\n\t\t\tSystem.out.println();\n\t\t\tbreak;\n\t\t} while (array.length > 0);\n\t}\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #15 ([I)V\n  // Stack: 1, Locals: 2\n  void foo4(int[] array);\n    0  getstatic java.lang.System.out : java.io.PrintStream [16]\n    3  invokevirtual java.io.PrintStream.println() : void [22]\n    6  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 6, line: 7]\n      Local variable table:\n        [pc: 0, pc: 7] local: this index: 0 type: X\n        [pc: 0, pc: 7] local: array index: 1 type: int[]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ForStatementTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test004() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo1(int[] array) {\n\t\twhile (array.length > 0) {\n\t\t\tSystem.out.println();\n\t\t\tbreak;\n\t\t}\n\t}\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #15 ([I)V\n  // Stack: 1, Locals: 2\n  void foo1(int[] array);\n     0  aload_1 [array]\n     1  arraylength\n     2  ifle 11\n     5  getstatic java.lang.System.out : java.io.PrintStream [16]\n     8  invokevirtual java.io.PrintStream.println() : void [22]\n    11  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 5, line: 4]\n        [pc: 11, line: 7]\n      Local variable table:\n        [pc: 0, pc: 12] local: this index: 0 type: X\n        [pc: 0, pc: 12] local: array index: 1 type: int[]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ForStatementTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test005() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint mode = 1;\n\t\tloop: for (;;) {\n\t\t\tswitch (mode) {\n\t\t\t\tcase 2 :\n\t\t\t\t\treturn;\n\t\t\t\tcase 1:\n\t\t\t\t\tmode = 2;\n\t\t\t\t\tcontinue loop;\n\t\t\t}\n\t\t}\n\t}\n}"}, "");
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 1, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_1\n     1  istore_1 [mode]\n     2  iload_1 [mode]\n     3  tableswitch default: 27\n          case 1: 25\n          case 2: 24\n    24  return\n    25  iconst_2\n    26  istore_1 [mode]\n    27  goto 2\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 24, line: 7]\n        [pc: 25, line: 9]\n        [pc: 27, line: 4]\n      Local variable table:\n        [pc: 0, pc: 30] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 30] local: mode index: 1 type: int\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ForStatementTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.ForStatementTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

