/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;

public class GenericTypeTest
extends AbstractComparableTest {
    static /* synthetic */ Class class$0;

    public GenericTypeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return GenericTypeTest.buildComparableTestSuite(GenericTypeTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.GenericTypeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", "ignore");
        return options;
    }

    public void test0001() {
        this.runConformTest(new String[]{"X.java", "public class X<Tx1 extends String, Tx2 extends Comparable>  extends XS<Tx2> {\n\n    public static void main(String[] args) {\n        Integer w = new X<String,Integer>().get(new Integer(12));\n        System.out.println(\"SUCCESS\");\n    }\n}\nclass XS <Txs> {\n    Txs get(Txs t) {\n        return t;\n    }\n}\n"}, "SUCCESS");
    }

    public void test0002() {
        this.runConformTest(new String[]{"X.java", "public class X<Xp1 extends String, Xp2 extends Comparable>  extends XS<Xp2> {\n\n    public static void main(String[] args) {\n        Integer w = new X<String,Integer>().get(new Integer(12));\n        System.out.println(\"SUCCESS\");\n    }\n    Xp2 get(Xp2 t){\n        System.out.print(\"{X::get}\");\n        return super.get(t);\n    }\n}\n\nclass XS <XSp1> {\n    XSp1 get(XSp1 t) {\n        System.out.print(\"{XS::get}\");\n        return t;\n    }\n}\n"}, "{X::get}{XS::get}SUCCESS");
    }

    public void test0003() {
        this.runNegativeTest(new String[]{"X.java", "public class X <X> extends X {\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <X> extends X {\n\t                ^\nThe type parameter X is hiding the type X<X>\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <X> extends X {\n\t                           ^\nCannot refer to the type parameter X as a supertype\n----------\n");
    }

    public void test0004() {
        this.runNegativeTest(new String[]{"X.java", "public class X <X> implements X {\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <X> implements X {\n\t                ^\nThe type parameter X is hiding the type X<X>\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <X> implements X {\n\t                              ^\nCannot refer to the type parameter X as a supertype\n----------\n");
    }

    public void test0005() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    \n    T t;\n    static {\n        T s;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tT s;\n\t^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void test0006() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    \n    T ok1;\n    static {\n        T wrong1;\n    }\n    static void foo(T wrong2) {\n\t\tT wrong3;\n    }\n    class MX extends T {\n        T ok2;\n    }\n    static class SMX extends T {\n        T wrong4;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tT wrong1;\n\t^\nCannot make a static reference to the non-static type T\n----------\n2. ERROR in X.java (at line 7)\n\tstatic void foo(T wrong2) {\n\t                ^\nCannot make a static reference to the non-static type T\n----------\n3. ERROR in X.java (at line 8)\n\tT wrong3;\n\t^\nCannot make a static reference to the non-static type T\n----------\n4. ERROR in X.java (at line 10)\n\tclass MX extends T {\n\t                 ^\nCannot refer to the type parameter T as a supertype\n----------\n5. ERROR in X.java (at line 13)\n\tstatic class SMX extends T {\n\t                         ^\nCannot make a static reference to the non-static type T\n----------\n6. ERROR in X.java (at line 14)\n\tT wrong4;\n\t^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void test0007() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    \n    T ok1;\n    static class SMX {\n        T wrong4;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tT wrong4;\n\t^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void test0008() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    \n     T ok;\n    static T wrong;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tstatic T wrong;\n\t       ^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void test0009() {
        this.runNegativeTest(new String[]{"Object.java", "package java.lang;\npublic class Object <T> {\n}\n"}, "----------\n1. ERROR in Object.java (at line 2)\n\tpublic class Object <T> {\n\t                     ^\nThe type java.lang.Object cannot be declared as a generic\n----------\n");
    }

    public void test0010() {
        this.runNegativeTest(new String[]{"X.java", "class Foo {} \npublic class X<T extends Object & Comparable<? super T>> {\n    public static void main(String[] args) {\n        new X<Foo>();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew X<Foo>();\n\t      ^^^\nBound mismatch: The type Foo is not a valid substitute for the bounded parameter <T extends Object & Comparable<? super T>> of the type X<T>\n----------\n");
    }

    public void test0011() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Object & Comparable<? super T>> {\n    public static void main(String[] args) {\n        new X<Foo>();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew X<Foo>();\n\t      ^^^\nFoo cannot be resolved to a type\n----------\n");
    }

    public void test0012() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends String> {\n    T foo(T t) {\n        return t;\n    }\n    \n    public static void main(String[] args) {\n        String s = new X<String>().foo(\"SUCCESS\");\n        System.out.println(s);\n    }\n}\n"}, "SUCCESS");
    }

    public void test0013() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends String> {\n    T foo(T t) {\n        return t;\n    }\n    public static void main(String[] args) {\n        new X<String>().baz(\"SUCCESS\");\n    }\n    void baz(final T t) {\n        new Object() {\n            void print() {\n                System.out.println(foo(t));\n            }\n        }.print();\n    }\n}\n"}, "SUCCESS");
    }

    public void test0014() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends Exception> {\n    T foo(T t) throws T {\n        return t;\n    }\n    public static void main(String[] args) {\n        new X<EX>().baz(new EX());\n    }\n    void baz(final T t) {\n        new Object() {\n            void print() {\n                System.out.println(foo(t));\n            }\n        }.print();\n    }\n}\nclass EX extends Exception {\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tSystem.out.println(foo(t));\n\t                   ^^^^^^\nUnhandled exception type T\n----------\n2. WARNING in X.java (at line 16)\n\tclass EX extends Exception {\n\t      ^^\nThe serializable class EX does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test0015() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends Exception> {\n    String foo() throws T {\n        return \"SUCCESS\";\n    }\n    public static void main(String[] args) {\n        new X<EX>().baz(new EX());\n    }\n    void baz(final T t) {\n        new Object() {\n            void print() {\n                try {\n\t                System.out.println(foo());\n                } catch (Exception t) {\n                }\n            }\n        }.print();\n    }\n}\nclass EX extends Exception {\n}\n"}, "SUCCESS");
    }

    public void test0016() {
        this.runConformTest(new String[]{"X.java", "public class X <E extends Exception> {\n    void foo(E e) throws E {\n        throw e;\n    }\n    void bar(E e) {\n        try {\n            foo(e);\n        } catch(Exception ex) {\n\t        System.out.println(\"SUCCESS\");\n        }\n    }\n    public static void main(String[] args) {\n        new X<Exception>().bar(new Exception());\n    }\n}\n"}, "SUCCESS");
    }

    public void test0017() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\npublic class X <E extends Exception> {\n    void foo(E e) throws E {\n        throw e;\n    }\n    void bar(E e) {\n        try {\n            foo(e);\n        } catch(Exception ex) {\n\t        System.out.println(\"SUCCESS\");\n        }\n    }\n    public static void main(String[] args) {\n        new X<IOException>().bar(new Exception());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tnew X<IOException>().bar(new Exception());\n\t                     ^^^\nThe method bar(IOException) in the type X<IOException> is not applicable for the arguments (Exception)\n----------\n");
    }

    public void test0018() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n    T foo(T t) {\n        System.out.println(t);\n        return t;\n    }\n    public static void main(String[] args) {\n        new X<XY>() {\n            void run() {\n                foo(new XY());\n            }\n        }.run();\n    }\n}\nclass XY {\n    public String toString() {\n        return \"SUCCESS\";\n    }\n}\n"}, "SUCCESS");
    }

    public void test0019() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n     private T foo(T t) {\n        System.out.println(t);\n        return t;\n    }\n    public static void main(String[] args) {\n        new X<XY>() {\n            void run() {\n                foo(new XY());\n            }\n        }.run();\n    }\n}\nclass XY {\n    public String toString() {\n        return \"SUCCESS\";\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tfoo(new XY());\n\t^^^\nThe method foo(T) in the type X<T> is not applicable for the arguments (XY)\n----------\n2. WARNING in X.java (at line 15)\n\tpublic String toString() {\n\t              ^^^^^^^^^^\nThe method toString() of type XY should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test0020() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n     void foo(Y<T> y) {\n\t\tSystem.out.print(\"SUCC\");\n    }\n    public static void main(String[] args) {\n        new X<String>().bar();\n    }\n    void bar() {\n        new Y<T>() {\n            @Override\n            public void pre() {\n                foo(this);\n            }\n        }.print(\"ESS\");\n    }\n}\nclass Y <P> {\n\tpublic void print(P p) {\n\t\tpre();\n\t\tSystem.out.println(p);\n\t}\n\tpublic void pre() {\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 14)\n\t}.print(\"ESS\");\n\t  ^^^^^\nThe method print(T) in the type Y<T> is not applicable for the arguments (String)\n----------\n");
    }

    public void test0021() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends String> {\n    void foo(T t) {\n    }\n    void bar(String x) {\n        foo(x);\n    }\n    public static void main(String[] args) {\n        new X<String>().foo(new Object());\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends String> {\n\t                          ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 5)\n\tfoo(x);\n\t^^^\nThe method foo(T) in the type X<T> is not applicable for the arguments (String)\n----------\n3. ERROR in X.java (at line 8)\n\tnew X<String>().foo(new Object());\n\t                ^^^\nThe method foo(String) in the type X<String> is not applicable for the arguments (Object)\n----------\n");
    }

    public void test0022() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends String> {\n    X(T t) {\n        System.out.println(t);\n    }\n    \n    public static void main(String[] args) {\n       new X<String>(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0023() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends String> {\n    X(final T t) {\n        new Object() {\n            void print() {\n                System.out.println(t);\n            }\n        }.print();\n    }\n    public static void main(String[] args) {\n        new X<String>(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0024() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends Exception> {\n    X(final T t) throws T {\n        new Object() {\n            void print() {\n                System.out.println(t);\n            }\n        }.print();\n    }\n    public static void main(String[] args) {\n        new X<EX>(new EX());\n    }\n}\nclass EX extends Exception {\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tnew X<EX>(new EX());\n\t^^^^^^^^^^^^^^^^^^^\nUnhandled exception type EX\n----------\n2. WARNING in X.java (at line 13)\n\tclass EX extends Exception {\n\t      ^^\nThe serializable class EX does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test0025() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends Exception> {\n    String foo() throws T {\n        return \"SUCCESS\";\n    }\n    public static void main(String[] args) {\n        new X<EX>(new EX());\n    }\n    X(final T t) {\n        new Object() {\n            void print() {\n                try {\n\t                System.out.println(foo());\n                } catch (Exception t) {\n                }\n            }\n        }.print();\n    }\n}\nclass EX extends Exception {\n}\n"}, "SUCCESS");
    }

    public void test0026() {
        this.runConformTest(new String[]{"X.java", "public class X <E extends Exception> {\n    void foo(E e) throws E {\n        throw e;\n    }\n    X(E e) {\n        try {\n            foo(e);\n        } catch(Exception ex) {\n\t        System.out.println(\"SUCCESS\");\n        }\n    }\n    public static void main(String[] args) {\n        new X<Exception>(new Exception());\n    }\n}\n"}, "SUCCESS");
    }

    public void test0027() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\npublic class X <E extends Exception> {\n    void foo(E e) throws E {\n        throw e;\n    }\n    X(E e) {\n        try {\n            foo(e);\n        } catch(Exception ex) {\n\t        System.out.println(\"SUCCESS\");\n        }\n    }\n    public static void main(String[] args) {\n        new X<IOException>(new Exception());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tnew X<IOException>(new Exception());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor X<IOException>(Exception) is undefined\n----------\n");
    }

    public void test0028() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n    T t;\n    X(T t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        String s = new X<String>(\"SU\").t;\n        System.out.print(s);\n        s = new X<String>(\"failed\").t = \"CC\";\n        System.out.print(s);\n        s = new X<String>(\"\").t += \"ESS\";\n        System.out.println(s);\n    }\n}\n"}, "SUCCESS");
    }

    public void test0029() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    T t;\n    X() {\n    }\n    T foo(T a, T b) {\n        T s;\n        s = t = a;\n\t\ts = t += b;\n\t\treturn t;\n    }\n    public static void main(String[] args) {\n        System.out.println(new X<String>().foo(\"SUC\", \"CESS\"));\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\ts = t += b;\n\t    ^^^^^^\nThe operator += is undefined for the argument type(s) T, T\n----------\n");
    }

    public void test0030() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n    T t;\n    X() {\n    }\n    T foo(T a) {\n        T s;\n        s = t = a;\n\t\treturn t;\n    }\n    public static void main(String[] args) {\n        System.out.println(new X<String>().foo(\"SUCCESS\"));\n    }\n}\n"}, "SUCCESS");
    }

    public void test0031() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n    T t;\n    X(T t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        new X<String>(\"OUTER\").bar();\n    }\n    void bar() {\n        new X<String>(\"INNER\") {\n            void run() {\n                \n                new Object() {\n                    void run() {\n\t\t                String s = t = \"SUC\";\n\t\t                s = t+= \"CESS\";\n\t\t\t\t        System.out.println(t);\n                    }\n                }.run();\n            }\n        }.run();\n    }\n}\n"}, "SUCCESS");
    }

    public void test0032() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n    T t;\n    X(T t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        new X<String>(\"OUTER\").bar();\n    }\n    void bar() {\n        new X<String>(\"INNER\") {\n            void run() {\n                String s = t = \"SUC\";\n                s = t+= \"CESS\";\n\t\t        System.out.println(t);\n            }\n        }.run();\n    }\n}\n"}, "SUCCESS");
    }

    public void test0033() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E, T> {\n\tvoid foo(E e){}\n\tvoid foo(T t){}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(E e){}\n\t     ^^^^^^^^\nErasure of method foo(E) is the same as another method in type X<E,T>\n----------\n2. ERROR in X.java (at line 3)\n\tvoid foo(T t){}\n\t     ^^^^^^^^\nErasure of method foo(T) is the same as another method in type X<E,T>\n----------\n");
    }

    public void test0034() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E extends Exception, T extends Exception> {\n\tvoid foo(E e){}\n\tvoid foo(T t){}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(E e){}\n\t     ^^^^^^^^\nErasure of method foo(E) is the same as another method in type X<E,T>\n----------\n2. ERROR in X.java (at line 3)\n\tvoid foo(T t){}\n\t     ^^^^^^^^\nErasure of method foo(T) is the same as another method in type X<E,T>\n----------\n");
    }

    public void test0035() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E extends Exception, T extends Thread> {\n\tvoid foo(E e, Thread t){}\n\tvoid foo(Exception e, T t){}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(E e, Thread t){}\n\t     ^^^^^^^^^^^^^^^^^^\nErasure of method foo(E, Thread) is the same as another method in type X<E,T>\n----------\n2. ERROR in X.java (at line 3)\n\tvoid foo(Exception e, T t){}\n\t     ^^^^^^^^^^^^^^^^^^^^^\nErasure of method foo(Exception, T) is the same as another method in type X<E,T>\n----------\n");
    }

    public void test0036() {
        this.runConformTest(new String[]{"X.java", "public class X <E extends Exception, T extends Thread> {\n\tvoid foo(E e){}\n\tvoid foo(T t){}\n    public static void main(String[] args) {\n\t\t System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0037() {
        this.runConformTest(new String[]{"X.java", "public class X <E extends Cloneable, T extends Thread & Cloneable> {\n\tvoid foo(E e){}\n\tvoid foo(T t){}\n    public static void main(String[] args) {\n\t\t System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0038() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E extends Cloneable, T extends Thread & Cloneable> {\n\tvoid foo(E e){}\n\tvoid foo(T t){}\n\tpublic static void main(String[] args) {\n\t\tX<XY,XY> x = new X<XY, XY>();\n\t\tx.foo(new XY());\n\t}\n}\nclass XY extends Thread implements Cloneable {\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tx.foo(new XY());\n\t  ^^^\nThe method foo(XY) is ambiguous for the type X<XY,XY>\n----------\n");
    }

    public void test0039() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E extends Cloneable, T extends Thread> {\n\tvoid foo(L<E> l1){}\n\tvoid foo(L<T> l2){}\n\tvoid foo(L l){}\n}\n\nclass L<E> {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(L<E> l1){}\n\t     ^^^^^^^^^^^^\nErasure of method foo(L<E>) is the same as another method in type X<E,T>\n----------\n2. ERROR in X.java (at line 3)\n\tvoid foo(L<T> l2){}\n\t     ^^^^^^^^^^^^\nErasure of method foo(L<T>) is the same as another method in type X<E,T>\n----------\n3. ERROR in X.java (at line 4)\n\tvoid foo(L l){}\n\t     ^^^^^^^^\nErasure of method foo(L) is the same as another method in type X<E,T>\n----------\n4. WARNING in X.java (at line 4)\n\tvoid foo(L l){}\n\t         ^\nL is a raw type. References to generic type L<E> should be parameterized\n----------\n");
    }

    public void test0040() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends X> {\n    public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n    }    \n}\n"}, "SUCCESS");
    }

    public void test0041() {
        this.runConformTest(new String[]{"X.java", "public class X <T, U extends T> {\n    public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n    }    \n}\n"}, "SUCCESS");
    }

    public void test0042() {
        String[] test = new String[]{"X.java", "public class X <T extends U, U> {}"};
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(test, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T extends U, U> {}\n\t                ^\nIllegal forward reference to type parameter U\n----------\n");
        } else {
            this.runConformTest(test, "");
        }
    }

    public void test0043() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends L<T> , U extends T> {\n    public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\nclass L<E>{}\n"}, "SUCCESS");
    }

    public void test0044() {
        this.runConformTest(new String[]{"X.java", "public class X extends L<X> {\n    public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n    }    \n}\nclass L<E> {}\n"}, "SUCCESS");
    }

    public void test0045() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public Z<T> var;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic Z<T> var;\n\t       ^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tpublic Z<T> var;\n\t         ^\nT cannot be resolved to a type\n----------\n");
    }

    public void test0046() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public Object<T> var;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic Object<T> var;\n\t       ^^^^^^\nThe type Object is not generic; it cannot be parameterized with arguments <T>\n----------\n2. ERROR in X.java (at line 2)\n\tpublic Object<T> var;\n\t              ^\nT cannot be resolved to a type\n----------\n");
    }

    public void test0047() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    private T t;\n    X(T t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        new X<String>(\"OUTER\").bar();\n    }\n    void bar() {\n        new MX<String>(\"INNER\") {\n            void run() {\n                \n                new Object() {\n                    void run() {\n\t\t                String s = t = \"SUC\";\n\t\t                s = t+= \"CESS\";\n\t\t\t\t        System.out.println(t);\n                    }\n                }.run();\n            }\n        }.run();\n    }\n}\nclass MX<U> {\n    MX(U u){}\n}\n"}, "----------\n1. ERROR in X.java (at line 15)\n\tString s = t = \"SUC\";\n\t           ^^^^^^^^^\nType mismatch: cannot convert from T to String\n----------\n2. ERROR in X.java (at line 15)\n\tString s = t = \"SUC\";\n\t               ^^^^^\nType mismatch: cannot convert from String to T\n----------\n3. ERROR in X.java (at line 16)\n\ts = t+= \"CESS\";\n\t    ^^^^^^^^^^\nThe operator += is undefined for the argument type(s) T, String\n----------\n");
    }

    public void test0048() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    private T t;\n    X(T t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        new X<String>(\"OUTER\").bar();\n    }\n    void bar() {\n        new X<X>(this) {\n            void run() {\n                new Object() {\n                    void run() {\n                        X x = t;\n\t\t\t\t        System.out.println(x);\n                    }\n                }.run();\n            }\n        }.run();\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tnew X<X>(this) {\n\t      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 14)\n\tX x = t;\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. ERROR in X.java (at line 14)\n\tX x = t;\n\t      ^\nType mismatch: cannot convert from T to X\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0049() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n    public T t;\n    X(T t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        new X<String>(\"OUTER\").bar();\n    }\n    void bar() {\n        new X<X>(this) {\n            void run() {\n                new Object() {\n                    void run() {\n                        X x = t;\n\t\t\t\t        System.out.println(\"SUCCESS\");\n                    }\n                }.run();\n            }\n        }.run();\n    }\n}\n"}, "SUCCESS");
    }

    public void test0050() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends N> {\n\tstatic class N {}}\nclass Y <T extends Y.N> {\n\tstatic class N {}}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T extends N> {\n\t                          ^\nN cannot be resolved to a type\n----------\n");
    }

    public void test0050a() {
        this.runNegativeTest(new String[]{"X.java", "class Super {class M {}}\npublic class X <T extends M> extends Super {}\nclass Y <T extends Y.M> extends Super {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X <T extends M> extends Super {}\n\t                          ^\nM cannot be resolved to a type\n----------\n");
    }

    public void test0050b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tclass M extends Y implements I {}\n}\nclass Y {\n\tstatic interface I { void foo(); }\n}\ninterface I {}\n"}, "");
    }

    public void test0050c() {
        this.runConformTest(new String[]{"Test.java", "public class Test<T extends Test.InnerTest> implements Base<T> {\n\tstatic class InnerTest implements Inner {}\n}\ninterface Base<T> {\n\tinterface Inner {}\n}\n"}, "");
    }

    public void test0050d() {
        this.runConformTest(new String[]{"X.java", "public class X<I, C extends I> {}\nclass Y extends X<Y.M, Y.N> {\n\tstatic class M {}\n\tstatic class N extends M {}\n}\n"}, "");
    }

    public void test0051() {
        this.runConformTest(new String[]{"X.java", "class Super {class M {}}\npublic class X extends Super {\n\tclass N <T extends M> {}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0052() {
        this.runConformTest(new String[]{"X.java", "public class X <T> extends p.A<T> {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n", "p/A.java", "package p; \npublic class A<P> {\n}\n"}, "SUCCESS");
    }

    public void test0053() {
        this.runConformTest(new String[]{"X.java", "public class X <T> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        new X<String>(\"OUTER\").bar();\n    }\n    void bar() {\n        new X<X>(this) {\n            void run() {\n                new Object() {\n                    void run() {\n                        print(t);\n                    }\n                }.run();\n            }\n        }.run();\n    }\n}\n", "p/A.java", "package p; \npublic class A<P> {\n    protected void print(P p) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0054() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        new X<String>(\"OUTER\").bar();\n    }\n    void bar() {\n        new X<X>(this) {\n            void run() {\n                new Object() {\n                    void run() {\n                        print(X.this.t);\n                    }\n                }.run();\n            }\n        }.run();\n    }\n}\n", "p/A.java", "package p; \npublic class A<P> {\n    protected void print(P p) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tnew X<X>(this) {\n\t      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. ERROR in X.java (at line 14)\n\tprint(X.this.t);\n\t^^^^^\nThe method print(X) in the type A<X> is not applicable for the arguments (T)\n----------\n");
    }

    public void test0055() {
        this.runConformTest(new String[]{"X.java", "public class X <T> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t  X<String> xs = new X<String>(\"SUCCESS\");\n\t  System.out.println(xs.t);\n    }\n}\n", "p/A.java", "package p; \npublic class A<P> {\n\t protected P p;\n    protected A(P p) {\n       this.p = p; \n    } \n    protected void print(P p) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0056() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t  X<String> xs = new X<String>(\"SUCCESS\");\n\t  System.out.println((X)xs.t);\n    }\n}\n", "p/A.java", "package p; \npublic class A<P> {\n\t protected P p;\n    protected A(P p) {\n       this.p = p; \n    } \n    protected void print(P p) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tSystem.out.println((X)xs.t);\n\t                   ^^^^^^^\nCannot cast from String to X\n----------\n----------\n1. WARNING in p\\A.java (at line 7)\n\tprotected void print(P p) {\n\t                       ^\nThe parameter p is hiding a field from type A<P>\n----------\n");
    }

    public void test0057() {
        this.runConformTest(new String[]{"X.java", "public class X <T> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t  X<X<String>> xs = new X<X<String>>(new X<String>(\"SUCCESS\"));\n\t  System.out.println(xs.t.t);\n    }\n}\n", "p/A.java", "package p; \npublic class A<P> {\n\t protected P p;\n    protected A(P p) {\n       this.p = p; \n    } \n    protected void print(P p) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0058() {
        this.runConformTest(new String[]{"test/X.java", "package test;\n// Valid Parameterized Type Declaration\npublic class X<A1, A2, A3> {\n}\n// Valid Type Syntax\nclass Y {\n\tX<String, Number, Integer> x;\n}\n"});
    }

    public void test0059() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n// Valid Parameterized Type Declaration\npublic class X<A1, A2, A3, A4> {\n}\n// Invalid Valid Type Syntax (not enough parameters)\nclass Y {\n\tX<String, Number, Integer> x;\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\tX<String, Number, Integer> x;\n\t^\nIncorrect number of arguments for type X<A1,A2,A3,A4>; it cannot be parameterized with arguments <String, Number, Integer>\n----------\n");
    }

    public void test0060() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n// Valid Parameterized Type Declaration\npublic class X<A1, A2> {\n}\n// Invalid Valid Type Syntax (too many parameters)\nclass Y {\n\tX<String, Number, Integer> x;\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\tX<String, Number, Integer> x;\n\t^\nIncorrect number of arguments for type X<A1,A2>; it cannot be parameterized with arguments <String, Number, Integer>\n----------\n");
    }

    public void test0061() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n// Valid Parameterized Type Declaration\npublic class X<A1, A2, A3, A4, A5, A6, A7> {\n}\n// Invalid Valid Type Syntax (primitive cannot be parameters)\nclass Y {\n\tX<int, short, long, float, double, boolean, char> x;\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\tX<int, short, long, float, double, boolean, char> x;\n\t  ^^^\nSyntax error, insert \"Dimensions\" to complete TypeArgument\n----------\n2. ERROR in test\\X.java (at line 7)\n\tX<int, short, long, float, double, boolean, char> x;\n\t       ^^^^^\nSyntax error, insert \"Dimensions\" to complete TypeArgument\n----------\n3. ERROR in test\\X.java (at line 7)\n\tX<int, short, long, float, double, boolean, char> x;\n\t              ^^^^\nSyntax error, insert \"Dimensions\" to complete TypeArgument\n----------\n4. ERROR in test\\X.java (at line 7)\n\tX<int, short, long, float, double, boolean, char> x;\n\t                    ^^^^^\nSyntax error, insert \"Dimensions\" to complete TypeArgument\n----------\n5. ERROR in test\\X.java (at line 7)\n\tX<int, short, long, float, double, boolean, char> x;\n\t                           ^^^^^^\nSyntax error, insert \"Dimensions\" to complete TypeArgument\n----------\n6. ERROR in test\\X.java (at line 7)\n\tX<int, short, long, float, double, boolean, char> x;\n\t                                   ^^^^^^^\nSyntax error, insert \"Dimensions\" to complete TypeArgument\n----------\n7. ERROR in test\\X.java (at line 7)\n\tX<int, short, long, float, double, boolean, char> x;\n\t                                            ^^^^\nSyntax error, insert \"Dimensions\" to complete ReferenceType\n----------\n");
    }

    public void test0062() {
        this.runConformTest(new String[]{"test/X.java", "package test;\n// Valid Parameterized Type Declaration\npublic class X<A1, A2, A3, A4, A5, A6, A7, A8> {\n}\n// Valid Type Syntax\nclass Y {\n\tX<int[], short[][], long[][][], float[][][][], double[][][][][], boolean[][][][][][], char[][][][][][][], Object[][][][][][][][][]> x;\n}\n"}, "");
    }

    public void test0063() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> extends p.A<T> {\n    \n    X(T t) {\n        super(t);\n    }\n    public static void main(String[] args) {\n        X x = new X(args);\n        X<String> xs = new X<String>(args);\n\t}\n}\n", "p/A.java", "package p; \npublic class A<P> {\n\t protected P p;\n    protected A(P p) {\n       this.p = p; \n    } \n    protected void print(P p) {\n        System.out.println(\"SUCCESS\"+p);\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tX x = new X(args);\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tX x = new X(args);\n\t      ^^^^^^^^^^^\nType safety: The constructor X(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 7)\n\tX x = new X(args);\n\t          ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 8)\n\tX<String> xs = new X<String>(args);\n\t               ^^^^^^^^^^^^^^^^^^^\nThe constructor X<String>(String[]) is undefined\n----------\n----------\n1. WARNING in p\\A.java (at line 7)\n\tprotected void print(P p) {\n\t                       ^\nThe parameter p is hiding a field from type A<P>\n----------\n");
    }

    public void test0064() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Exception & IX> {\n    T t;\n    void bar(T t) {\n        t.getMessage();\n        t.foo();\n    }\n    public static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.t.getMessage();\n\t\tx.t.foo();\n\t}\n}\n\ninterface IX {\n    void foo();\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid bar(T t) {\n\t           ^\nThe parameter t is hiding a field from type X<T>\n----------\n2. WARNING in X.java (at line 8)\n\tX x = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 8)\n\tX x = new X();\n\t          ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 10)\n\tx.t.foo();\n\t    ^^^\nThe method foo() is undefined for the type Exception\n----------\n");
    }

    public void test0065() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X<T extends Exception> {\n\n    public static void main(String[] args) {\n\t\tX x = new X();\n\t\tX<IOException> xioe = new X<IOException>(); // ok\n\t\t\n\t\tX x2 = xioe;\n\t\tX<IOException> xioe2 = x; // unsafe\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tX x = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tX x = new X();\n\t          ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 9)\n\tX x2 = xioe;\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 10)\n\tX<IOException> xioe2 = x; // unsafe\n\t                       ^\nType safety: The expression of type X needs unchecked conversion to conform to X<IOException>\n----------\n", null, true, customOptions);
    }

    public void test0066() {
        this.runNegativeTest(new String[]{"test/X1.java", "package test;\n// Valid Consecutive Parameterized Type Declaration\npublic class X1<A1 extends X2<A2>> {\n\tA1 a1;\n}\n// Valid Parameterized Type Declaration\nclass X2<A2>{\n\tA2 a2;\n}\n"}, "----------\n1. ERROR in test\\X1.java (at line 3)\n\tpublic class X1<A1 extends X2<A2>> {\n\t                              ^^\nA2 cannot be resolved to a type\n----------\n");
    }

    public void test0067() {
        this.runNegativeTest(new String[]{"test/X1.java", "package test;\n// Valid Consecutive Parameterized Type Declaration\npublic class X1< A1 extends X2\t<\tA2\t>     \t\t\t> {\n\tA1 a1;\n}\n// Valid Parameterized Type Declaration\nclass X2<A2>{\n\tA2 a2;\n}\n"}, "----------\n1. ERROR in test\\X1.java (at line 3)\n\tpublic class X1< A1 extends X2\t<\tA2\t>     \t\t\t> {\n\t                              \t \t^^\nA2 cannot be resolved to a type\n----------\n");
    }

    public void _test0068() {
        this.runNegativeTest(new String[]{"test/X1.java", "package test;\n// Invalid Consecutive Parameterized Type Declaration\npublic class X1<A1 extends X2<A2> {\n\tA1 a1;\n}\n// Invalid Parameterized Type Declaration\nclass X2<A2 {\n\tA2 a2;\n}\n"}, "----------\n1. ERROR in test\\X1.java (at line 3)\n\tpublic class X1<A1 extends X2<A2> {\n\t                              ^^\nA2 cannot be resolved to a type\n----------\n2. ERROR in test\\X1.java (at line 3)\n\tpublic class X1<A1 extends X2<A2> {\n\t                                ^\nSyntax error, insert \">\" to complete ReferenceType1\n----------\n3. ERROR in test\\X1.java (at line 7)\n\tclass X2<A2 {\n\t         ^^\nSyntax error on token \"A2\", > expected after this token\n----------\n");
    }

    public void test0069() {
        this.runNegativeTest(new String[]{"test/X1.java", "package test;\n// Invalid Consecutive Parameterized Type Declaration\npublic class X1<A1 extends X2<A2 {\n\tA1 a1;\n}\n// Invalid Parameterized Type Declaration\nclass X2<A2> {\n\tA2 a2;\n}\n"}, "----------\n1. ERROR in test\\X1.java (at line 3)\n\tpublic class X1<A1 extends X2<A2 {\n\t                              ^^\nSyntax error, insert \">>\" to complete ReferenceType2\n----------\n");
    }

    public void test0070() {
        this.runNegativeTest(new String[]{"test/X1.java", "package test;\n// Invalid Consecutive Parameterized Type Declaration\npublic class X1<A1>> {\n\tA1 a1;\n}\n"}, "----------\n1. ERROR in test\\X1.java (at line 3)\n\tpublic class X1<A1>> {\n\t                  ^^\nSyntax error on token \">>\", > expected\n----------\n");
    }

    public void test0071() {
        this.runNegativeTest(new String[]{"test/X1.java", "package test;\n// Invalid Consecutive Parameterized Type Declaration\npublic class X1 < A1 > > {\n\tA1 a1;\n}\n"}, "----------\n1. ERROR in test\\X1.java (at line 3)\n\tpublic class X1 < A1 > > {\n\t                       ^\nSyntax error on token \">\", delete this token\n----------\n");
    }

    public void test0072() {
        this.runNegativeTest(new String[]{"test/X1.java", "package test;\n// Invalid Consecutive Parameterized Type Declaration\npublic class X1<A1>>> {\n\tA1 a1;\n}\n"}, "----------\n1. ERROR in test\\X1.java (at line 3)\n\tpublic class X1<A1>>> {\n\t                  ^^^\nSyntax error on token \">>>\", > expected\n----------\n");
    }

    public void test0073() {
        this.runNegativeTest(new String[]{"test/X1.java", "package test;\n// Invalid Consecutive Parameterized Type Declaration\npublic class X1<A1 extends X2<A1>>> {\n\tA1 a1;\n}\n// Valid Parameterized Type Declaration\nclass X2<A2> {\n\tA2 a2;\n}\n"}, "----------\n1. ERROR in test\\X1.java (at line 3)\n\tpublic class X1<A1 extends X2<A1>>> {\n\t                                ^^^\nSyntax error on token \">>>\", >> expected\n----------\n");
    }

    public void test0074() {
        this.runNegativeTest(new String[]{"test/X1.java", "package test;\n// Invalid Consecutive Parameterized Type Declaration\npublic class X1 < A1 > > > {\n\tA1 a1;\n}\n"}, "----------\n1. ERROR in test\\X1.java (at line 3)\n\tpublic class X1 < A1 > > > {\n\t                       ^^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void test0075() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends Object & p.A<? super T>> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T extends Object & p.A<? super T>> extends p.A<T> {\n\t                                   ^^^\nThe type A<? super T> is not an interface; it cannot be specified as a bounded parameter\n----------\n");
    }

    public void test0076() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends Object & p.A> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends Object & p.A> extends p.A<T> {\n\t                                   ^^^\nA is a raw type. References to generic type A<P> should be parameterized\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T extends Object & p.A> extends p.A<T> {\n\t                                   ^^^\nThe type A is not an interface; it cannot be specified as a bounded parameter\n----------\n");
    }

    public void test0077() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> extends p.A<T> {\n\t X() {\n\t\tsuper(null);\n\t}\n    X(T t) {\n        super(t);\n    }\n    X(X<T> xt) {\n        super(xt.t);\n    }\n    public static void main(String[] args) {\n        X x = new X();\n        X x1 = new X(args);\n        X x2 = new X(x);\n        X<String> xs = new X<String>(args);\n\t}\n}\n", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tsuper(xt.t);\n\t         ^\nt cannot be resolved or is not a field\n----------\n2. WARNING in X.java (at line 12)\n\tX x = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 12)\n\tX x = new X();\n\t          ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 13)\n\tX x1 = new X(args);\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n5. WARNING in X.java (at line 13)\n\tX x1 = new X(args);\n\t       ^^^^^^^^^^^\nType safety: The constructor X(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n6. WARNING in X.java (at line 13)\n\tX x1 = new X(args);\n\t           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n7. WARNING in X.java (at line 14)\n\tX x2 = new X(x);\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n8. WARNING in X.java (at line 14)\n\tX x2 = new X(x);\n\t       ^^^^^^^^\nType safety: The constructor X(X) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n9. WARNING in X.java (at line 14)\n\tX x2 = new X(x);\n\t           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n10. ERROR in X.java (at line 15)\n\tX<String> xs = new X<String>(args);\n\t               ^^^^^^^^^^^^^^^^^^^\nThe constructor X<String>(String[]) is undefined\n----------\n");
    }

    public void test0078() {
        this.runNegativeTest(new String[]{"X.java", "import p.A;\npublic class X {\n    X(A<String> a, A<String> b) {\n    }\n    void foo(A<String> a) {\n    }\n    public static void main(String[] args) {\n        X x = new X((A)null, (A)null);\n        A a = new A((A)null);\n\t\tx.foo(a);\n\t\ta.print(x);\n\t\tA<String> as = new A<String>(null);\n\t\tas.print(\"hello\");\n\t}\n}\n", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n    protected void print(P p) {\n        System.out.println(\"SUCCESS\"+p);\n    }\n    protected void print(A<P> a) {\n        print(a.p);\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tX x = new X((A)null, (A)null);\n\t            ^^^^^^^\nType safety: The expression of type A needs unchecked conversion to conform to A<String>\n----------\n2. WARNING in X.java (at line 8)\n\tX x = new X((A)null, (A)null);\n\t             ^\nA is a raw type. References to generic type A<P> should be parameterized\n----------\n3. WARNING in X.java (at line 8)\n\tX x = new X((A)null, (A)null);\n\t                     ^^^^^^^\nType safety: The expression of type A needs unchecked conversion to conform to A<String>\n----------\n4. WARNING in X.java (at line 8)\n\tX x = new X((A)null, (A)null);\n\t                      ^\nA is a raw type. References to generic type A<P> should be parameterized\n----------\n5. WARNING in X.java (at line 9)\n\tA a = new A((A)null);\n\t^\nA is a raw type. References to generic type A<P> should be parameterized\n----------\n6. ERROR in X.java (at line 9)\n\tA a = new A((A)null);\n\t      ^^^^^^^^^^^^^^\nThe constructor A(P) is not visible\n----------\n7. WARNING in X.java (at line 9)\n\tA a = new A((A)null);\n\t          ^\nA is a raw type. References to generic type A<P> should be parameterized\n----------\n8. WARNING in X.java (at line 9)\n\tA a = new A((A)null);\n\t             ^\nA is a raw type. References to generic type A<P> should be parameterized\n----------\n9. WARNING in X.java (at line 10)\n\tx.foo(a);\n\t      ^\nType safety: The expression of type A needs unchecked conversion to conform to A<String>\n----------\n10. ERROR in X.java (at line 11)\n\ta.print(x);\n\t  ^^^^^\nThe method print(P) from the type A is not visible\n----------\n11. ERROR in X.java (at line 12)\n\tA<String> as = new A<String>(null);\n\t               ^^^^^^^^^^^^^^^^^^^\nThe constructor A<String>(P) is not visible\n----------\n12. ERROR in X.java (at line 13)\n\tas.print(\"hello\");\n\t   ^^^^^\nThe method print(P) from the type A<String> is not visible\n----------\n----------\n1. WARNING in p\\A.java (at line 7)\n\tprotected void print(P p) {\n\t                       ^\nThe parameter p is hiding a field from type A<P>\n----------\n");
    }

    public void test0079() {
        this.runConformTest(new String[]{"test/X.java", "package test;\npublic class X<A extends X1<X2<X3<String>>>> {\n\tA a;\n\tpublic static void main(String[] args) {\n\t\tX<X1<X2<X3<String>>>> x = new X<X1<X2<X3<String>>>>();\n\t\tx.a = new X1<X2<X3<String>>>();\n\t\tx.a.a1 = new X2<X3<String>>();\n\t\tx.a.a1.a2 = new X3<String>();\n\t\tx.a.a1.a2.a3 = \"SUCCESS\";\n\t\tSystem.out.println(x.a.a1.a2.a3);\n\t}\n}\nclass X1<A extends X2<X3<String>>> {\n\tA a1;\n}\nclass X2<A extends X3<String>> {\n\tA a2;\n}\nclass X3<A> {\n\tA a3;\n}\n"}, "SUCCESS");
    }

    public void _test0080() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\npublic class X<A extends X1<X2<X3<String>>> {}\nclass X1<A extends X2<X3<String>> {}\nclass X2<A extends X3<String> {}\nclass X3<A {}\n"}, "----------\n1. ERROR in test\\X.java (at line 2)\n\tpublic class X<A extends X1<X2<X3<String>>> {}\n\t                                        ^^^\nSyntax error, insert \">\" to complete ReferenceType1\n----------\n2. ERROR in test\\X.java (at line 3)\n\tclass X1<A extends X2<X3<String>> {}\n\t                               ^^\nSyntax error, insert \">\" to complete ReferenceType1\n----------\n3. ERROR in test\\X.java (at line 4)\n\tclass X2<A extends X3<String> {}\n\t                            ^\nSyntax error, insert \">\" to complete ReferenceType1\n----------\n4. ERROR in test\\X.java (at line 5)\n\tclass X3<A {}\n\t         ^\nSyntax error on token \"A\", > expected after this token\n----------\n");
    }

    public void test0081() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\npublic class X<A extends X1<X2<X3<String>> {}\nclass X1<A extends X2<X3<String> {}\nclass X2<A extends X3<String {}\nclass X3<A> {}\n"}, "----------\n1. ERROR in test\\X.java (at line 2)\n\tpublic class X<A extends X1<X2<X3<String>> {}\n\t                                        ^^\nSyntax error, insert \">>\" to complete ReferenceType2\n----------\n2. ERROR in test\\X.java (at line 3)\n\tclass X1<A extends X2<X3<String> {}\n\t                               ^\nSyntax error, insert \">>\" to complete ReferenceType2\n----------\n3. ERROR in test\\X.java (at line 4)\n\tclass X2<A extends X3<String {}\n\t                      ^^^^^^\nSyntax error, insert \">>\" to complete ReferenceType2\n----------\n");
    }

    public void test0082() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\npublic class X<A extends X1<X2<X3<String> {}\nclass X1<A extends X2<X3<String {}\nclass X2<A extends X3<String>> {}\nclass X3<A> {}\n"}, "----------\n1. ERROR in test\\X.java (at line 2)\n\tpublic class X<A extends X1<X2<X3<String> {}\n\t                                        ^\nSyntax error, insert \">>>\" to complete ReferenceType3\n----------\n2. ERROR in test\\X.java (at line 3)\n\tclass X1<A extends X2<X3<String {}\n\t                         ^^^^^^\nSyntax error, insert \">>>\" to complete ReferenceType3\n----------\n");
    }

    public void _test0083() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\npublic class X<A extends X1<X2<X3<String {}\nclass X1<A extends X2<X3<String>>> {}\nclass X2<A extends X3<String>> {}\nclass X3<A> {}\n"}, "----------\n1. ERROR in test\\X.java (at line 2)\n\tpublic class X<A extends X1<X2<X3<String {}\n\t                                  ^^^^^^\nSyntax error, insert \">>>\" to complete ReferenceType3\n----------\n2. ERROR in test\\X.java (at line 2)\n\tpublic class X<A extends X1<X2<X3<String {}\n\t                                  ^^^^^^\nSyntax error, insert \">\" to complete ReferenceType1\n----------\n");
    }

    public void test0084() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    X(AX<String> a, AX<String> b) {\n    }\n    void foo(AX<String> a) {\n    }\n    public static void main(String[] args) {\n        X x = new X((AX)null, (AX)null);\n        AX a = new AX((AX)null);\n        AX a2 = new AX(null);\n\t\tx.foo(a);\n\t\ta.foo(a);\n\t\ta.bar(a);\n\t\tAX<String> as = new AX<String>(null);\n\t\tas.print(a);\n\t\tas.bar(a);\n\t}\n}\nclass AX <P> {\n    AX(AX<P> ax){}\n    AX(P p){}\n    void print(P p){}\n    void foo(AX rawAx){}\n    void bar(AX<P> ax){}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tX x = new X((AX)null, (AX)null);\n\t            ^^^^^^^^\nType safety: The expression of type AX needs unchecked conversion to conform to AX<String>\n----------\n2. WARNING in X.java (at line 7)\n\tX x = new X((AX)null, (AX)null);\n\t             ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n3. WARNING in X.java (at line 7)\n\tX x = new X((AX)null, (AX)null);\n\t                      ^^^^^^^^\nType safety: The expression of type AX needs unchecked conversion to conform to AX<String>\n----------\n4. WARNING in X.java (at line 7)\n\tX x = new X((AX)null, (AX)null);\n\t                       ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n5. WARNING in X.java (at line 8)\n\tAX a = new AX((AX)null);\n\t^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n6. WARNING in X.java (at line 8)\n\tAX a = new AX((AX)null);\n\t       ^^^^^^^^^^^^^^^^\nType safety: The constructor AX(AX) belongs to the raw type AX. References to generic type AX<P> should be parameterized\n----------\n7. WARNING in X.java (at line 8)\n\tAX a = new AX((AX)null);\n\t           ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n8. WARNING in X.java (at line 8)\n\tAX a = new AX((AX)null);\n\t               ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n9. WARNING in X.java (at line 9)\n\tAX a2 = new AX(null);\n\t^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n10. WARNING in X.java (at line 9)\n\tAX a2 = new AX(null);\n\t        ^^^^^^^^^^^^\nType safety: The constructor AX(AX) belongs to the raw type AX. References to generic type AX<P> should be parameterized\n----------\n11. WARNING in X.java (at line 9)\n\tAX a2 = new AX(null);\n\t            ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n12. WARNING in X.java (at line 10)\n\tx.foo(a);\n\t      ^\nType safety: The expression of type AX needs unchecked conversion to conform to AX<String>\n----------\n13. WARNING in X.java (at line 12)\n\ta.bar(a);\n\t^^^^^^^^\nType safety: The method bar(AX) belongs to the raw type AX. References to generic type AX<P> should be parameterized\n----------\n14. ERROR in X.java (at line 13)\n\tAX<String> as = new AX<String>(null);\n\t                ^^^^^^^^^^^^^^^^^^^^\nThe constructor AX<String>(AX<String>) is ambiguous\n----------\n15. ERROR in X.java (at line 14)\n\tas.print(a);\n\t   ^^^^^\nThe method print(String) in the type AX<String> is not applicable for the arguments (AX)\n----------\n16. WARNING in X.java (at line 15)\n\tas.bar(a);\n\t       ^\nType safety: The expression of type AX needs unchecked conversion to conform to AX<String>\n----------\n17. WARNING in X.java (at line 22)\n\tvoid foo(AX rawAx){}\n\t         ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n");
    }

    public void test0085() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    \n    public static void main(String[] args) {\n        AX ax = new AX();\n        X x = (X)ax.p;\n        System.out.println(x);\n    }\n}\n\nclass AX <P> {\n    \n    P p;\n}\n"}, "null");
    }

    public void test0086() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    \n    public static void main(String[] args) {\n        AX ax = new AX();\n        AX ax2 = ax.p;\n        ax.p = new AX<String>();\n        System.out.println(ax2);\n    }\n}\n\nclass AX <P> {\n    AX<P> p;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tAX ax = new AX();\n\t^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tAX ax = new AX();\n\t            ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n3. WARNING in X.java (at line 5)\n\tAX ax2 = ax.p;\n\t^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n4. WARNING in X.java (at line 6)\n\tax.p = new AX<String>();\n\t   ^\nType safety: The field p from the raw type AX is assigned a value of type AX<String>. References to generic type AX<P> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test0087() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    \n    public static void main(String[] args) {\n        AX ax = new AX();\n        AX ax2 = ax.p;\n        AX ax3 = new AX<String>();\n        System.out.println(\"SUCCESS\");\n    }\n}\n\nclass AX <P> {\n    AX<P> p;\n}\n"}, "SUCCESS", null, true, null, customOptions, null);
    }

    public void test0088() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n     AX ax = new AX();\n     AX ax2 = ax.p;\n     AX ax3 = new AX<String>();\n}\n\nclass AX <P> {\n    AX<P> p;\n}\n"}, "", null, true, null, customOptions, null);
    }

    public void test0089() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    T q;\n     public static void main(String[] args) {\n         X<String[]> xss = new X<String[]>();\n         X<X<String[]>> xxs = new X<X<String[]>>();\n         xxs.q = xss;\n         System.out.println(\"SUCCESS\");\n     }\n}\n"}, "SUCCESS");
    }

    public void test0090() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    T q;\n    \n     public static void main(String[] args) {\n         X<String[]> xss = new X<String[]>();\n         X<X<String[]>> xxs = new X<X<String[]>>();\n         xxs.q = xss;\n         System.out.println(\"SUCCESS\");\n     }\n      void foo(X[] xs) {\n          xs[0] = new X<String>();\n     }\n}\n"}, "SUCCESS", null, true, null, customOptions, null);
    }

    public void test0091() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n      void foo(X<String>[] xs) {\n     }\n}\n"}, "");
    }

    public void test0092() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    T t;\n    X(T t) {\n        this.t = t;\n    }\n     void foo() {\n         X<String> xs = new X<String>(\"\");\n         X<String> xs2 = (X<String>) xs;\n         \n         ((X)xs).t = this;\n         \n         System.out.prinln((T) this.t);\n     }\n     public static void main(String[] args) {\n\t\tnew X<String>(\"SUCCESS\").foo();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tX<String> xs2 = (X<String>) xs;\n\t                ^^^^^^^^^^^^^^\nUnnecessary cast from X<String> to X<String>\n----------\n2. WARNING in X.java (at line 10)\n\t((X)xs).t = this;\n\t  ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 10)\n\t((X)xs).t = this;\n\t        ^\nType safety: The field t from the raw type X is assigned a value of type X<T>. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 12)\n\tSystem.out.prinln((T) this.t);\n\t           ^^^^^^\nThe method prinln(T) is undefined for the type PrintStream\n----------\n");
    }

    public void test0093() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    public static void main(String[] args) {\n        AX ax = new AX();\n        AX ax2 = new AX();\n        ax.p = ax2.p;\n        System.out.println(\"SUCCESS\");\n    }\n}\nclass AX <P> {\n    AX<P> p;\n}\n"}, "SUCCESS");
    }

    public void test0094() {
        this.runConformTest(new String[]{"X.java", "public class X<Tx1 extends S, Tx2 extends C>  extends XS<Tx2> {\n\n    public static void main(String[] args) {\n        I w = new X<S,I>().get(new I());\n        System.out.println(\"SUCCESS\");\n    }\n}\nclass S {}\nclass I implements C<I> {}\ninterface C<Tc> {}\nclass XS <Txs> {\n    Txs get(Txs t) {\n        return t;\n    }\n}\n"}, "SUCCESS");
    }

    public void test0095() {
        this.runConformTest(new String[]{"X.java", "public class X<Tx1 extends S, Tx2 extends C>  extends XS<Tx2> {\n\n    public static void main(String[] args) {\n        I w = new X<S,I>().get(new I());\n        System.out.println(\"SUCCESS\");\n    }\n}\nclass S {}\nclass I implements C {}\ninterface C<Tc> {}\nclass XS <Txs> {\n    Txs get(Txs t) {\n        return t;\n    }\n}\n"}, "SUCCESS");
    }

    public void test0096() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> extends X {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T> extends X {}\n\t                          ^\nCycle detected: the type X<T> cannot extend/implement itself or one of its own member types\n----------\n");
    }

    public void test0097() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> extends X<String> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T> extends X<String> {}\n\t                          ^\nCycle detected: the type X<T> cannot extend/implement itself or one of its own member types\n----------\n");
    }

    public void test0098() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    \n    public static void main(String[] args) {\n        AX ax = new AX();\n        AX ax2 = ax.p;\n        ax.p = new AX<String>();\n        ax.q = new AX<String>();\n        ax.r = new AX<Object>();\n        ax.s = new AX<String>();\n        System.out.println(ax2);\n    }\n}\n\nclass AX <P> {\n    AX<P> p;\n    AX<Object> q;\n    AX<String> r;\n    BX<String> s;\n}\n\nclass BX<Q> {\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tAX ax = new AX();\n\t^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tAX ax = new AX();\n\t            ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n3. WARNING in X.java (at line 5)\n\tAX ax2 = ax.p;\n\t^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n4. ERROR in X.java (at line 6)\n\tax.p = new AX<String>();\n\t   ^\nType safety: The field p from the raw type AX is assigned a value of type AX<String>. References to generic type AX<P> should be parameterized\n----------\n5. ERROR in X.java (at line 7)\n\tax.q = new AX<String>();\n\t   ^\nType safety: The field q from the raw type AX is assigned a value of type AX<String>. References to generic type AX<P> should be parameterized\n----------\n6. ERROR in X.java (at line 8)\n\tax.r = new AX<Object>();\n\t   ^\nType safety: The field r from the raw type AX is assigned a value of type AX<Object>. References to generic type AX<P> should be parameterized\n----------\n7. ERROR in X.java (at line 9)\n\tax.s = new AX<String>();\n\t       ^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from AX<String> to BX\n----------\n", null, true, customOptions);
    }

    public void test0099() {
        this.runNegativeTest(new String[]{"X.java", "public class X  <T extends AX<? super int>> {\n    public static void main(String[] args) {\n\t\tAX<String> ax;\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tvoid foo(X<?> x) {\n\t}\n}\n\nclass AX<P> {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X  <T extends AX<? super int>> {\n\t                                      ^^^\nSyntax error, insert \"Dimensions\" to complete ArrayType\n----------\n");
    }

    public void test0100() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\tX<? extends AX> x = new X<? extends AX>(new AX<String>());\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n\nclass AX<P> {\n    P foo() { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tX<? extends AX> x = new X<? extends AX>(new AX<String>());\n\t            ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n2. ERROR in X.java (at line 7)\n\tX<? extends AX> x = new X<? extends AX>(new AX<String>());\n\t                        ^\nCannot instantiate the type X<? extends AX>\n----------\n3. WARNING in X.java (at line 7)\n\tX<? extends AX> x = new X<? extends AX>(new AX<String>());\n\t                                    ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n");
    }

    public void test0101() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends String> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\tX<? extends AX> x = new X<AX<String>>(new AX<String>());\n\t\tx.t.foo(\"SUCCESS\");\n\t}\n}\n\nclass AX<P> {\n   void foo(P p) { \n\t\tSystem.out.println(p);\n   }\n}\n\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends String> {\n\t                          ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 7)\n\tX<? extends AX> x = new X<AX<String>>(new AX<String>());\n\t  ^^^^^^^^^^^^\nBound mismatch: The type ? extends AX is not a valid substitute for the bounded parameter <T extends String> of the type X<T>\n----------\n3. WARNING in X.java (at line 7)\n\tX<? extends AX> x = new X<AX<String>>(new AX<String>());\n\t            ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n4. ERROR in X.java (at line 7)\n\tX<? extends AX> x = new X<AX<String>>(new AX<String>());\n\t                          ^^\nBound mismatch: The type AX<String> is not a valid substitute for the bounded parameter <T extends String> of the type X<T>\n----------\n5. WARNING in X.java (at line 8)\n\tx.t.foo(\"SUCCESS\");\n\t^^^^^^^^^^^^^^^^^^\nType safety: The method foo(Object) belongs to the raw type AX. References to generic type AX<P> should be parameterized\n----------\n");
    }

    public void test0102() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends AX> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\tX<?> x = new X<BX<String>>(new BX<String>());\n\t\tx.t.foo(\"SUCC\");\n\t\tx.t.bar(\"ESS\");\n\t}\n}\n\nclass AX<P> {\n   void foo(P p) { \n\t\tSystem.out.print(p);\n   }\n}\n\nclass BX<Q> extends AX<Q> {\n   void bar(Q q) { \n\t\tSystem.out.println(q);\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends AX> {\n\t                          ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\tx.t.foo(\"SUCC\");\n\t^^^^^^^^^^^^^^^\nType safety: The method foo(Object) belongs to the raw type AX. References to generic type AX<P> should be parameterized\n----------\n3. ERROR in X.java (at line 9)\n\tx.t.bar(\"ESS\");\n\t    ^^^\nThe method bar(String) is undefined for the type capture#2-of ?\n----------\n");
    }

    public void test0103() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X <T extends AX> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\tX<? extends BX> x = new X<BX<String>>(new BX<String>());\n\t\tx.t.foo(\"SUCC\");\n\t\tx.t.bar(\"ESS\");\n\t}\n}\n\nclass AX<P> {\n   void foo(P p) { \n\t\tSystem.out.print(p);\n   }\n}\n\nclass BX<Q> extends AX<Q> {\n   void bar(Q q) { \n\t\tSystem.out.println(q);\n   }\n}\n"}, "SUCCESS");
        String expectedOutput = "  // Method descriptor #25 ([Ljava/lang/String;)V\n  // Stack: 4, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  new X [1]\n     3  dup\n     4  new BX [26]\n     7  dup\n     8  invokespecial BX() [28]\n    11  invokespecial X(AX) [29]\n    14  astore_1 [x]\n    15  aload_1 [x]\n    16  getfield X.t : AX [16]\n    19  checkcast BX [26]\n    22  ldc <String \"SUCC\"> [31]\n    24  invokevirtual BX.foo(java.lang.Object) : void [33]\n    27  aload_1 [x]\n    28  getfield X.t : AX [16]\n    31  checkcast BX [26]\n    34  ldc <String \"ESS\"> [37]\n    36  invokevirtual BX.bar(java.lang.Object) : void [39]\n    39  return\n      Line numbers:\n        [pc: 0, line: 7]\n        [pc: 15, line: 8]\n        [pc: 27, line: 9]\n        [pc: 39, line: 10]\n      Local variable table:\n        [pc: 0, pc: 40] local: args index: 0 type: java.lang.String[]\n        [pc: 15, pc: 40] local: x index: 1 type: X\n      Local variable type table:\n        [pc: 15, pc: 40] local: x index: 1 type: X<? extends BX>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0104() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends AX> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\tX<? extends BX> x = new X<AX<String>>(new AX<String>());\n\t\tx.t.foo(\"SUCC\");\n\t\tx.t.bar(\"ESS\");\n\t}\n}\n\nclass AX<P> {\n   void foo(P p) { \n\t\tSystem.out.print(p);\n   }\n}\n\nclass BX<Q> extends AX<Q> {\n   void bar(Q q) { \n\t\tSystem.out.println(q);\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends AX> {\n\t                          ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tX<? extends BX> x = new X<AX<String>>(new AX<String>());\n\t            ^^\nBX is a raw type. References to generic type BX<Q> should be parameterized\n----------\n3. ERROR in X.java (at line 7)\n\tX<? extends BX> x = new X<AX<String>>(new AX<String>());\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X<AX<String>> to X<? extends BX>\n----------\n4. WARNING in X.java (at line 8)\n\tx.t.foo(\"SUCC\");\n\t^^^^^^^^^^^^^^^\nType safety: The method foo(Object) belongs to the raw type AX. References to generic type AX<P> should be parameterized\n----------\n5. WARNING in X.java (at line 9)\n\tx.t.bar(\"ESS\");\n\t^^^^^^^^^^^^^^\nType safety: The method bar(Object) belongs to the raw type BX. References to generic type BX<Q> should be parameterized\n----------\n");
    }

    public void test0105() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends AX> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\tX<? extends AX> x = new X<AX<String>>(new AX<String>());\n\t\tx.t.foo(\"SUCCESS\");\n\t}\n}\n\nclass AX<P> {\n   void foo(P p) { \n\t\tSystem.out.println(p);\n   }\n}\n"}, "SUCCESS");
    }

    public void test0106() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends AX> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        X<BX<String>> x = new X<BX<String>>(new BX<String>());\n\t\tx.t.foo(\"SUCC\");\n\t\tx.t.bar(\"ESS\");\n\t}\n}\n\nclass AX<P> {\n   void foo(P p) { \n\t\tSystem.out.print(p);\n   }\n}\n\nclass BX<Q> extends AX<Q> {\n   void bar(Q q) { \n\t\tSystem.out.println(q);\n   }\n}\n"}, "SUCCESS");
    }

    public void test0107() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X  {\n    \n    public static void main(String[] args) {\n        \n        Iterable<String> is = new ArrayList();\n\t\tis.iterator();\n    }\n}\n\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tIterable<String> is = new ArrayList();\n\t                      ^^^^^^^^^^^^^^^\nType safety: The expression of type ArrayList needs unchecked conversion to conform to Iterable<String>\n----------\n2. WARNING in X.java (at line 7)\n\tIterable<String> is = new ArrayList();\n\t                          ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test0108() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n    Class k;\n    public static void main(String args[]) {\n        new X().foo();\n    }\n    void foo() {\n        Class c = this.getClass();\n        this.k = this.getClass();\n        this.k = Integer.class;\n        try {\n            Integer i = Integer.class.newInstance();\n        } catch (Exception e) {\n        }\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS", null, true, null, customOptions, null);
    }

    public void test0109() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements AX<String> {}\nclass Y extends X implements AX<Thread> {}\ninterface AX<P> {}\n\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends X implements AX<Thread> {}\n\t      ^\nThe interface AX cannot be implemented more than once with different arguments: AX<String> and AX<Thread>\n----------\n");
    }

    public void test0110() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements AX {}\nclass Y extends X implements AX<Thread> {}\ninterface AX<P> {}\n\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X implements AX {}\n\t                          ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tclass Y extends X implements AX<Thread> {}\n\t      ^\nThe interface AX cannot be implemented more than once with different arguments: AX and AX<Thread>\n----------\n");
    }

    public void test0111() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements AX<Object> {}\nclass Y extends X implements AX {}\ninterface AX<P> {}\n\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends X implements AX {}\n\t      ^\nThe interface AX cannot be implemented more than once with different arguments: AX<Object> and AX\n----------\n2. WARNING in X.java (at line 2)\n\tclass Y extends X implements AX {}\n\t                             ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n");
    }

    public void test0112() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n    void foo(X<Thread>.MX<String>.MMX<X> mx) {}\n    class MX <MT> {\n        class MMX <MMT> {}\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                            ^^^^^^^^\nX.MX.MMX is a raw type. References to generic type X<T>.MX<MT>.MMX<MMT> should be parameterized\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                            ^^^^^^^^\nBound mismatch: The type X.MX.MMX is not a valid substitute for the bounded parameter <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>> of the type X<T>\n----------\n3. ERROR in X.java (at line 2)\n\tvoid foo(X<Thread>.MX<String>.MMX<X> mx) {}\n\t           ^^^^^^\nBound mismatch: The type Thread is not a valid substitute for the bounded parameter <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>> of the type X<T>\n----------\n4. WARNING in X.java (at line 2)\n\tvoid foo(X<Thread>.MX<String>.MMX<X> mx) {}\n\t                                  ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n    class MX <MT extends Comparable> {\n        class MMX <MMT> {}\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                            ^^^^^^^^\nX.MX.MMX is a raw type. References to generic type X<T>.MX<MT>.MMX<MMT> should be parameterized\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                            ^^^^^^^^\nBound mismatch: The type X.MX.MMX is not a valid substitute for the bounded parameter <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>> of the type X<T>\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                                         ^^^^^^^^\nBound mismatch: The type Runnable is not a valid substitute for the bounded parameter <MT extends Comparable> of the type X<T>.MX<MT>\n----------\n4. WARNING in X.java (at line 2)\n\tclass MX <MT extends Comparable> {\n\t                     ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n    class MX <MT> {\n        class MMX <MMT extends Comparable> {}\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                            ^^^^^^^^\nX.MX.MMX is a raw type. References to generic type X<T>.MX<MT>.MMX<MMT> should be parameterized\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                            ^^^^^^^^\nBound mismatch: The type X.MX.MMX is not a valid substitute for the bounded parameter <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>> of the type X<T>\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                                                       ^^^^^^^^\nBound mismatch: The type Iterable<String> is not a valid substitute for the bounded parameter <MMT extends Comparable> of the type X<T>.MX<MT>.MMX<MMT>\n----------\n4. WARNING in X.java (at line 3)\n\tclass MMX <MMT extends Comparable> {}\n\t                       ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test0113() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n  class MX<U> {\n  }\n\n  public static void main(String[] args) {\n    new X<Thread>().foo();\n\tSystem.out.println(\"SUCCESS\");\n  }\n  void foo() {\n\t\tnew X<String>().new MX<T>();\n  }\n}\n"}, "SUCCESS");
    }

    public void test0114() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n  class MX<U> {\n  }\n\n  public static void main(String[] args) {\n    new X<Thread>().foo(new X<String>().new MX<Thread>());\n  }\n  void foo(X<String>.MX<Thread> mx) {\n\tSystem.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS");
    }

    public void test0115() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n  class MX<U> {\n  }\n\n  public static void main(String[] args) {\n    new X<Thread>().foo(new X<String>().new MX<Thread>());\n  }\n  void foo(X.MX mx) {\n\tSystem.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS");
    }

    public void test0116() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n  class MX<U> {\n  }\n\n  public static void main(String[] args) {\n    new X<Thread>().foo(new X<String>().new MX<Thread>());\n  }\n  void foo(X<?>.MX<?> mx) {\n\tSystem.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS");
    }

    public void test0117() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n    public static void main(String [] args) {\n        \n        new X<X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>().new MX<Exception>();\n        System.out.println(\"SUCCESS\");\n    }\n    void foo(X<X.MX.MMX>.MX<X>.MMX<X> mx) {\n    }\n    \n    class MX <MT> {\n        class MMX <MMT> {\n        }\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                            ^^^^^^^^\nX.MX.MMX is a raw type. References to generic type X<T>.MX<MT>.MMX<MMT> should be parameterized\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n\t                            ^^^^^^^^\nBound mismatch: The type X.MX.MMX is not a valid substitute for the bounded parameter <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>> of the type X<T>\n----------\n3. WARNING in X.java (at line 4)\n\tnew X<X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>().new MX<Exception>();\n\t        ^^^^^^^^\nX.MX.MMX is a raw type. References to generic type X<T>.MX<MT>.MMX<MMT> should be parameterized\n----------\n4. ERROR in X.java (at line 4)\n\tnew X<X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>().new MX<Exception>();\n\t        ^^^^^^^^\nBound mismatch: The type X.MX.MMX is not a valid substitute for the bounded parameter <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>> of the type X<T>\n----------\n5. WARNING in X.java (at line 7)\n\tvoid foo(X<X.MX.MMX>.MX<X>.MMX<X> mx) {\n\t           ^^^^^^^^\nX.MX.MMX is a raw type. References to generic type X<T>.MX<MT>.MMX<MMT> should be parameterized\n----------\n6. ERROR in X.java (at line 7)\n\tvoid foo(X<X.MX.MMX>.MX<X>.MMX<X> mx) {\n\t           ^^^^^^^^\nBound mismatch: The type X.MX.MMX is not a valid substitute for the bounded parameter <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>> of the type X<T>\n----------\n7. WARNING in X.java (at line 7)\n\tvoid foo(X<X.MX.MMX>.MX<X>.MMX<X> mx) {\n\t                        ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n8. WARNING in X.java (at line 7)\n\tvoid foo(X<X.MX.MMX>.MX<X>.MMX<X> mx) {\n\t                               ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test0118() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        java.util.Collections.sort(new java.util.LinkedList<String>());\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0118a() {
        this.runConformTest(true, new String[]{"X.java", "class A<T> {}\n\npublic class X {\n\tstatic <T extends A<U>, U> void foo() {}\n\tvoid bar(A<?> a) {\n\t\tfoo();\n\t}\n}"}, null, "", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void _test0119() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>{\n    public static void main(String [] args) {\n        \n        new X<X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>>().new MX<Exception>();\n        System.out.println(\"SUCCESS\");\n    }\n    void foo(X<X.MX.MMX>.MX<Object>.MMX<X> mx) {\n    }\n    void foo2(X<X.MX.MMX>.MX<Iterable>.MMX<X> mx) {\n    }\n    void foo3(X<X<X.MX.MMX>.MX<Runnable>.MMX<Iterable<String>>> mx) {\n    }\n    \n    class MX <MT> {\n        class MMX <MMT> {\n        }\n    }\n}\n"}, "SUCCESS");
        this.runConformTest(new String[]{"Y.java", "public class Y extends X {\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test0120() {
        this.runConformTest(new String[]{"X.java", "public class X <T>{\n    public static void main(String[] args) {\n        \n        String s = new X<String>().foo(\"SUCCESS\");\n\t}\n    <U extends String> T foo (U u) {\n        System.out.println(u);\n        return null;\n    }\n}\n"}, "SUCCESS");
    }

    public void test0120a() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n    <U extends X<?>> U foo() {\n    \treturn null;\n    }\n    <V extends X<?>> V bar() {\n        return foo();\n    }\n}"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6302954);
    }

    public void test0121() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n    public static void main(String[] args) {\n\t\tnew X<String>().foo(args);\n\t}\n    \n    void foo(T[] ts) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0122() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n    public static void main(String[] args) {\n\t\tnew X<String>().foo(args, new X<X<String>>());\n\t}\n    <U> void foo(U[] us, X<X<U>> xxu) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0123() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    T<String> ts;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tT<String> ts;\n\t^\nThe type T is not generic; it cannot be parameterized with arguments <String>\n----------\n");
    }

    public void test0124() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    <W> void foo(AX<W> aw) {\n        System.out.println(\"SUCCESS\");\n     }\n    \n    public static void main(String[] args) {\n\t\tnew X().foo(new BX<String,Thread>());\n\t}\n}\n\nclass AX<T> {\n}\nclass BX<U, V> extends AX<V> {\n}\n"}, "SUCCESS");
    }

    public void test0125() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    <W> void foo(AX<W> aw) {\n        System.out.println(\"SUCCESS\");\n     }\n    \n    public static void main(String[] args) {\n\t\tnew X().foo(new CX());\n\t}\n}\n\nclass AX<T> {\n}\nclass BX<U, V> extends AX<V> {\n}\nclass CX extends BX<String, Thread> {\n}\n"}, "SUCCESS");
    }

    public void test0126() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    <W> void foo(AX<W> aw) {\n        System.out.println(\"SUCCESS\");\n     }\n    \n    public static void main(String[] args) {\n\t\tnew X().foo(new CX());\n\t}\n}\n\nclass AX<T> {\n}\nclass BX<U, V> extends AX<V> {\n}\nclass CX extends B<String, Thread> {\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tnew X().foo(new CX());\n\t        ^^^\nThe method foo(AX<W>) in the type X is not applicable for the arguments (CX)\n----------\n2. ERROR in X.java (at line 16)\n\tclass CX extends B<String, Thread> {\n\t                 ^\nB cannot be resolved to a type\n----------\n");
    }

    public void test0127() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        java.util.Arrays.asList(new Object[] {\"1\"});\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0128() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n    public static void main(String[] args) {\n\t\tX x = new X();\n\t\tClass c1 = x.getClass();\n\t\tClass<? extends X> c2 = x.getClass();\n\t\tString s = \"hello\";\n\t\tClass<? extends X> c3 = s.getClass();\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tClass c1 = x.getClass();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 7)\n\tClass<? extends X> c3 = s.getClass();\n\t                        ^^^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#3-of ? extends String> to Class<? extends X>\n----------\n");
    }

    public void test0129() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\n    public static void main(String[] args) {\n\t\tXY xy = new XY();\n\t\tClass c1 = xy.getClass();\n\t\tClass<? extends XY> c2 = xy.getClass();\n\t\tString s = \"hello\";\n\t\tClass<? extends XY> c3 = s.getClass();\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n\nclass XY extends X {\n    public Class <? extends Object> getClass() {\n        return super.getClass();\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tClass c1 = xy.getClass();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 8)\n\tClass<? extends XY> c3 = s.getClass();\n\t                         ^^^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#3-of ? extends String> to Class<? extends XY>\n----------\n3. ERROR in X.java (at line 14)\n\tpublic Class <? extends Object> getClass() {\n\t                                ^^^^^^^^^^\nCannot override the final method from Object\n----------\n4. WARNING in X.java (at line 14)\n\tpublic Class <? extends Object> getClass() {\n\t                                ^^^^^^^^^^\nThe method getClass() of type XY should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test0130() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\n    public static void main(String[] args) {\n\t\tX[] x = new X[0];\n\t\tClass<? extends X[]> c = x.getClass();\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0131() {
        this.runNegativeTest(new String[]{"ArrayList.java", " interface List<T> {\n\t List<T> foo();\n}\n\n class ArrayList<T> implements List<T> {\n\tpublic List<T> foo() {\n\t\tList<T> lt = this;\n\t\tlt.bar();\n\t\treturn this;\n\t}\n}\n"}, "----------\n1. ERROR in ArrayList.java (at line 8)\n\tlt.bar();\n\t   ^^^\nThe method bar() is undefined for the type List<T>\n----------\n");
    }

    public void test0132() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  <T extends X<W>.Z> foo() {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T extends X<W>.Z> foo() {}\n\t           ^\nThe type X is not generic; it cannot be parameterized with arguments <W>\n----------\n2. ERROR in X.java (at line 2)\n\t<T extends X<W>.Z> foo() {}\n\t             ^\nW cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\t<T extends X<W>.Z> foo() {}\n\t                   ^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void test0133() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    public static void main(String[] args) {\n        X x = new Y();\n        System.out.println(x.foo());\n    }\n   T foo() {return null;}\n   void foo(T t) {}\n}\nclass Y extends X<Object> {\n    String foo() {return \"SUCCESS\";}\n    void foo(String s) {}\n}\n"}, "SUCCESS");
    }

    public void test0134() {
        this.runConformTest(new String[]{"Z.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class Z <T extends List> { \n    T t;\n    public static void main(String[] args) {\n        foo(new Z<ArrayList>().set(new ArrayList<String>()));\n        System.out.println(\"SUCCESS\");\n    }\n    Z<T> set(T t) {\n        this.t = t;\n        return this;\n    }\n    T get() { \n        return this.t; \n    }\n    \n    static void foo(Z<? super ArrayList> za) {\n        za.get().isEmpty();\n    }\n}\n"}, "SUCCESS");
    }

    public void test0135() {
        this.runNegativeTest(new String[]{"Z.java", "public class Z <T extends ZA> { \n    public static void main(String[] args) {\n        foo(new Z<ZA>());\n        System.out.println(\"SUCCESS\");\n    }\n    static void foo(Z<? super String> zs) {\n    }\n}\n\nclass ZA {\n    void foo() {}\n}\n\nclass ZB extends ZA {\n}"}, "----------\n1. ERROR in Z.java (at line 3)\n\tfoo(new Z<ZA>());\n\t^^^\nThe method foo(Z<? super String>) in the type Z<T> is not applicable for the arguments (Z<ZA>)\n----------\n2. ERROR in Z.java (at line 6)\n\tstatic void foo(Z<? super String> zs) {\n\t                  ^^^^^^^^^^^^^^\nBound mismatch: The type ? super String is not a valid substitute for the bounded parameter <T extends ZA> of the type Z<T>\n----------\n");
    }

    public void test0136() {
        this.runNegativeTest(new String[]{"Z.java", "public class Z <T extends ZB> { \n    public static void main(String[] args) {\n        foo(new Z<ZB>());\n    }\n    static void foo(Z<? super ZA> zs) {\n        zs.foo();\n    }\n}\nclass ZA {\n}\nclass ZB extends ZA {\n    void foo() {}\n}"}, "----------\n1. ERROR in Z.java (at line 3)\n\tfoo(new Z<ZB>());\n\t^^^\nThe method foo(Z<? super ZA>) in the type Z<T> is not applicable for the arguments (Z<ZB>)\n----------\n2. ERROR in Z.java (at line 5)\n\tstatic void foo(Z<? super ZA> zs) {\n\t                  ^^^^^^^^^^\nBound mismatch: The type ? super ZA is not a valid substitute for the bounded parameter <T extends ZB> of the type Z<T>\n----------\n3. ERROR in Z.java (at line 6)\n\tzs.foo();\n\t   ^^^\nThe method foo(Z<? super ZA>) in the type Z<capture#1-of ? super ZA> is not applicable for the arguments ()\n----------\n");
    }

    public void test0137() {
        this.runConformTest(new String[]{"Z.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class Z <T extends List> { \n    T t;\n    public static void main(String[] args) {\n        foo(new Z<ArrayList>().set(new ArrayList<String>()));\n        System.out.println(\"SUCCESS\");\n    }\n    Z<T> set(T t) {\n        this.t = t;\n        return this;\n    }\n    T get() { \n        return this.t; \n    }\n    \n    static void foo(Z<? extends ArrayList> za) {\n        za.get().isEmpty();\n    }\n}\n"}, "SUCCESS");
    }

    public void test0138() {
        this.runConformTest(new String[]{"Z.java", "public class Z <T extends AX> {\n    T t;\n    Z(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\t Z<AX<String>> zax = new Z<AX<String>>(new AX<String>());\n        System.out.println(\"SUCCESS\");\n\t}\n    void baz(Z<?> zu){\n        zu.t.foo(null);\n    }\n}\n\nclass AX<P> {\n   void foo(P p) { \n\t\tSystem.out.print(p);\n   }\n}\n"}, "SUCCESS");
    }

    public void test0139() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends AX> {\n    T t;\n    X(T t) {\n        this.t = t;\n    }\n    T get() {\n        return this.t;\n    }\n    void bar(X<? extends BX> x) {\n        x.get().afoo();\n        x.get().bfoo();\n    }\n}\nclass AX {\n    void afoo() {}\n}\nclass BX {\n    void bfoo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tvoid bar(X<? extends BX> x) {\n\t           ^^^^^^^^^^^^\nBound mismatch: The type ? extends BX is not a valid substitute for the bounded parameter <T extends AX> of the type X<T>\n----------\n2. ERROR in X.java (at line 10)\n\tx.get().afoo();\n\t        ^^^^\nThe method afoo() is undefined for the type capture#1-of ? extends BX\n----------\n");
    }

    public void test0140() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends AX> {\n    T t;\n    X(T t) {\n        this.t = t;\n    }\n    T get() {\n        return this.t;\n    }\n    void bar(X<? extends BX> x) {\n        x.get().afoo();\n        x.get().bfoo();\n    }\n    public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n\t}\n}\nclass AX {\n    void afoo() {}\n}\nclass BX extends AX {\n    void bfoo() {}\n}\n"}, "SUCCESS");
    }

    public void test0141() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends AX> {\n    T t;\n    X(T t) {\n        this.t = t;\n    }\n    T get() {\n        return this.t;\n    }\n    void bar(X<? super BX> x) {\n        x.get().afoo();\n        x.get().bfoo();\n    }\n}\nclass AX {\n    void afoo() {}\n}\nclass BX extends AX {\n    void bfoo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tx.get().bfoo();\n\t        ^^^^\nThe method bfoo() is undefined for the type capture#2-of ? super BX\n----------\n");
    }

    public void test0142() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends AX> {\n    T t;\n    X(T t) {\n        this.t = t;\n    }\n    T get() {\n        return this.t;\n    }\n    void bar(X<? extends X> x) {\n        x = identity(x);\n    }\n    <P extends AX> X<P> identity(X<P> x) {\n        return x;\n    }\n    public static void main(String[] args) {\n    }\n}\nclass AX {\n    void afoo() {}\n}\nclass BX extends AX {\n    void bfoo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tvoid bar(X<? extends X> x) {\n\t           ^^^^^^^^^^^\nBound mismatch: The type ? extends X is not a valid substitute for the bounded parameter <T extends AX> of the type X<T>\n----------\n2. WARNING in X.java (at line 9)\n\tvoid bar(X<? extends X> x) {\n\t                     ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. ERROR in X.java (at line 10)\n\tx = identity(x);\n\t    ^^^^^^^^\nBound mismatch: The generic method identity(X<P>) of type X<T> is not applicable for the arguments (X<capture#2-of ? extends X>). The inferred type capture#2-of ? extends X is not a valid substitute for the bounded parameter <P extends AX>\n----------\n");
    }

    public void test0143() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        Class<? extends X> xx = null;\n        Class<? extends Object> xo = xx;\n        Class<Object> xo2 = xx;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tClass<Object> xo2 = xx;\n\t                    ^^\nType mismatch: cannot convert from Class<capture#2-of ? extends X> to Class<Object>\n----------\n");
    }

    public void test0144() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        Class<? extends X> xx = null;\n        Class<? extends Object> xo = xx;\n        X x = get(xx);\n        System.out.println(\"SUCCESS\");\n    }\n    static <P> P get(Class<P> cp) {\n        return null;\n    }\n}\n"}, "SUCCESS");
    }

    public void test0145() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tXList<?> lx = new XList<X>();\n\t\tX x = lx.get();\n\t\tlx.add(null);\n\t\tlx.add(x);\n\t\tlx.slot = x;\n\t\tlx.addAll(lx);\n    }    \t\n}\nclass XList<E extends X> {\n    E slot;\n    void add(E e) {}\n    E get() { return null; \n    }\n    void addAll(XList<E> le) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tlx.add(x);\n\t   ^^^\nThe method add(capture#3-of ?) in the type XList<capture#3-of ?> is not applicable for the arguments (X)\n----------\n2. ERROR in X.java (at line 7)\n\tlx.slot = x;\n\t          ^\nType mismatch: cannot convert from X to capture#4-of ?\n----------\n3. ERROR in X.java (at line 8)\n\tlx.addAll(lx);\n\t   ^^^^^^\nThe method addAll(XList<capture#5-of ?>) in the type XList<capture#5-of ?> is not applicable for the arguments (XList<capture#6-of ?>)\n----------\n");
    }

    public void test0146() {
        this.runConformTest(new String[]{"X.java", "import java.util.AbstractList;\npublic class X extends AbstractList {\n    public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n    }\n    public int size() { return 0; }\n    public Object get(int index) { return null; }\n" + ITERABLE_RAW_IMPL_JRE8 + COLLECTION_AND_LIST_RAW_IMPL_JRE8 + "}\n"}, "SUCCESS");
    }

    public void test0147() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t    char[][] tokens = new char[0][];\n\t    ArrayList list = new ArrayList();\n\t\tlist.toArray(tokens);\n      System.out.println(\"SUCCESS\");\n    }    \t\n}\n"}, "SUCCESS");
    }

    public void test0148() {
        this.runConformTest(new String[]{"X.java", "public class X extends AX<String>{\n    \n    String foo(String s) {\n        System.out.println(s);\n        return s;\n    }\n\tpublic static void main(String[] args) {\n\t   new X().bar(\"SUCCESS\");\n    }    \t\n}\nclass AX<T> {\n    T foo(T t) {\n        return null;\n    }\n    void bar(T t) {\n        foo(t);\n    }\n}\n"}, "SUCCESS");
    }

    public void test0149() {
        this.runConformTest(new String[]{"X.java", "public abstract class X implements java.util.Collection {\n\tpublic Object[] toArray(Object[] a) {\n\t\treturn a;\n\t}\n\tpublic static void main(String[] args) {\n\t   System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
        this.runNegativeTest(new String[]{"X.java", "public abstract class X implements java.util.Collection<Object> {\n\tpublic Object[] toArray(Object[] a) {\n\t\treturn a;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic Object[] toArray(Object[] a) {\n\t       ^^^^^^^^\nType safety: The return type Object[] for toArray(Object[]) from the type X needs unchecked conversion to conform to T[] from the type Collection<E>\n----------\n");
    }

    public void test0150() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    \n    <T extends X> void foo(T[] ta, List<T> lt) {\n    }\n    \n    public static void main(String[] args) {\n\t\tnew X().foo(args, new ArrayList<String>());\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tnew X().foo(args, new ArrayList<String>());\n\t        ^^^\nBound mismatch: The generic method foo(T[], List<T>) of type X is not applicable for the arguments (String[], ArrayList<String>). The inferred type String is not a valid substitute for the bounded parameter <T extends X>\n----------\n");
    }

    public void test0151() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X <E>{\n    \n    <T extends X> X(T[] ta, List<T> lt) {\n    }\n    \n    public static void main(String[] args) {\n\t\tnew X<Object>(args, new ArrayList<String>());\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\t<T extends X> X(T[] ta, List<T> lt) {\n\t           ^\nX is a raw type. References to generic type X<E> should be parameterized\n----------\n2. ERROR in X.java (at line 8)\n\tnew X<Object>(args, new ArrayList<String>());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nBound mismatch: The generic constructor X(T[], List<T>) of type X<E> is not applicable for the arguments (String[], ArrayList<String>). The inferred type String is not a valid substitute for the bounded parameter <T extends X>\n----------\n");
    }

    public void test0152() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    \n    public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n\t}\n    List<X> x(List<X> list) {\n        return Collections.unmodifiableList(list);\n    }\n}\n"}, "SUCCESS");
    }

    public void test0153() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>();\n        AX<X> a = bar(ax);\n        System.out.println(\"SUCCESS\");\n\t}\n    public static <T> AX<T> bar(AX<? extends T> a) {\n\t\treturn null;\n    }    \n}\nclass AX<E> {\n}\n"}, "SUCCESS");
    }

    public void test0154() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>();\n        AX<X> a = bar(ax);\n        System.out.println(\"SUCCESS\");\n\t}\n    public static <T> AX<T> bar(AX<? super T> a) {\n\t\treturn null;\n    }    \n}\nclass AX<E> {\n}\n"}, "SUCCESS");
    }

    public void test0155() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>();\n        AX<X> a = bar(ax);\n        System.out.println(\"SUCCESS\");\n\t}\n    public static <T> AX<T> bar(AX<?> a) {\n\t\treturn null;\n    }    \n}\nclass AX<E> {\n}\n"}, "SUCCESS");
    }

    public void test0156() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>();\n        AX<X> a = bar(ax);\n\t}\n    public static <T> AX<T> bar(AX<?> a) {\n\t\treturn null;\n    }    \n}\nclass AX<E extends X> {\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic static <T> AX<T> bar(AX<?> a) {\n\t                     ^\nBound mismatch: The type T is not a valid substitute for the bounded parameter <E extends X> of the type AX<E>\n----------\n");
    }

    public void test0157() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>();\n        AX<String> as = new AX<String>();\n        AX<X> a = bar(ax, as);\n        System.out.println(\"SUCCESS\");\n\t}\n    public static <T,U> AX<T> bar(AX<? extends U> a, AX<? super U> b) {\n\t\treturn null;\n    }    \n}\nclass AX<E> {\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tAX<X> a = bar(ax, as);\n\t          ^^^\nThe method bar(AX<? extends U>, AX<? super U>) in the type X is not applicable for the arguments (AX<X>, AX<String>)\n----------\n");
    }

    public void test0158() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>();\n        AX<String> as = new AX<String>();\n        AX<X> a = bar(ax, as);\n        System.out.println(\"SUCCESS\");\n\t}\n    public static <T,U> AX<T> bar(AX<?> a, AX<? super U> b) {\n\t\treturn null;\n    }    \n}\nclass AX<E> {\n}\n"}, "SUCCESS");
    }

    public void test0159() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>(new X());\n        AX<String> as = new AX<String>(\"SUCCESS\");\n        AX<X> a = bar(ax, as);\n\t}\n    public static <T,U> T bar(AX<?> a, AX<? super U> b) {\n\t\treturn a.get();\n    }    \n}\nclass AX<E> {\n\t E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\treturn a.get();\n\t       ^^^^^^^\nType mismatch: cannot convert from capture#1-of ? to T\n----------\n");
    }

    public void test0160() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        String s = foo(new AX<String>(\"aaa\"));\n\t}\n    static <V> V foo(AX<String> a) {\n        return a.get();\n    }\n}\nclass AX<E> {\n    E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\treturn a.get();\n\t       ^^^^^^^\nType mismatch: cannot convert from String to V\n----------\n");
    }

    public void test0161() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        boolean b = foo(new AX<String>(\"aaa\")).equals(args);\n\t}\n    static <V> V foo(AX<String> a) {\n        return a.get();\n    }\n    String bar() {\n        return \"bbb\";\n    }\n}\nclass AX<E> {\n    E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\treturn a.get();\n\t       ^^^^^^^\nType mismatch: cannot convert from String to V\n----------\n");
    }

    public void test0162() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        String s = foo(new AX<String>(\"aaa\")).bar();\n\t}\n    static <V> V foo(AX<String> a) {\n        return a.get();\n    }\n    String bar() {\n        return \"bbb\";\n    }\n}\nclass AX<E> {\n    E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tString s = foo(new AX<String>(\"aaa\")).bar();\n\t                                      ^^^\nThe method bar() is undefined for the type Object\n----------\n2. ERROR in X.java (at line 7)\n\treturn a.get();\n\t       ^^^^^^^\nType mismatch: cannot convert from String to V\n----------\n");
    }

    public void test0163() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        String s = foo(new AX<String>(\"aaa\")).bar();\n\t}\n    static <V> V foo(AX<String> a) {\n        return a.get();\n    }\n    String bar() {\n        return \"bbb\";\n    }\n}\nclass AX<E> {\n    E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tString s = foo(new AX<String>(\"aaa\")).bar();\n\t                                      ^^^\nThe method bar() is undefined for the type Object\n----------\n2. ERROR in X.java (at line 7)\n\treturn a.get();\n\t       ^^^^^^^\nType mismatch: cannot convert from String to V\n----------\n");
    }

    public void test0164() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n    public static void main(String[] args) {\n        foo(new AX<String>(\"SUCCESS\"));\n\t}\n    static <V> List<V> foo(AX<String> a) {\n        System.out.println(a.get());\n        List<V> v = null;\n        if (a == null) v = foo(a); \n        return v;\n    }\n}\nclass AX<E> {\n    E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "SUCCESS");
    }

    public void test0165() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>();\n        AX<String> a = bar(ax);\n        System.out.println(\"SUCCESS\");\n\t}\n    public static <T> AX<T> bar(AX<?> a) {\n\t\t if (a == null) {\n        \tAX<String> as = bar(a);\n        \tString s = as.get();\n\t\t}\n\t\treturn null;\n    }    \n}\nclass AX<E> {\n    E get() { return null; }\n}\n"}, "SUCCESS");
    }

    public void test0166() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>(new X());\n        AX<String> a = bar(ax, true);\n        String s = a.get();\n        System.out.println(s);\n\t}\n    public static <T> AX<T> bar(AX<?> a, boolean recurse) {\n        if (recurse) {\n\t        AX<String> as = bar(a, false);\n\t\t\tString s = as.get();\n        }\n\t\treturn new AX(\"SUCCESS\");\n    }    \n}\nclass AX<E> {\n    E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "SUCCESS");
    }

    public void test0167() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<String, Thread> a = bar();\n        String s = a.get();\n        System.out.println(s);\n\t}\n    public static <T, U> AX<T, U> bar() {\n\t\treturn new AX(\"SUCCESS\");\n    }    \n}\nclass AX<E, F> {\n    E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "SUCCESS");
    }

    public void test0168() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<String, Thread> a = bar();\n        String s = a.get();\n        System.out.println(s);\n\t}\n    public static <T, U> AX<AX<T, T>, U> bar() {\n\t\treturn new AX(\"SUCCESS\");\n    }    \n}\nclass AX<E, F> {\n    E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tAX<String, Thread> a = bar();\n\t                       ^^^^^\nType mismatch: cannot convert from AX<AX<Object,Object>,Thread> to AX<String,Thread>\n----------\n2. WARNING in X.java (at line 9)\n\treturn new AX(\"SUCCESS\");\n\t       ^^^^^^^^^^^^^^^^^\nType safety: The constructor AX(Object) belongs to the raw type AX. References to generic type AX<E,F> should be parameterized\n----------\n3. WARNING in X.java (at line 9)\n\treturn new AX(\"SUCCESS\");\n\t       ^^^^^^^^^^^^^^^^^\nType safety: The expression of type AX needs unchecked conversion to conform to AX<AX<T,T>,U>\n----------\n4. WARNING in X.java (at line 9)\n\treturn new AX(\"SUCCESS\");\n\t           ^^\nAX is a raw type. References to generic type AX<E,F> should be parameterized\n----------\n");
    }

    public void test0169() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<String> a = bar(new X());\n        String s = a.get();\n        System.out.println(s);\n\t}\n    public static <T> AX<T> bar(T t) {\n\t\treturn new AX(\"SUCCESS\");\n    }    \n}\nclass AX<E> {\n    E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tAX<String> a = bar(new X());\n\t               ^^^^^^^^^^^^\nType mismatch: cannot convert from AX<X> to AX<String>\n----------\n2. WARNING in X.java (at line 9)\n\treturn new AX(\"SUCCESS\");\n\t       ^^^^^^^^^^^^^^^^^\nType safety: The constructor AX(Object) belongs to the raw type AX. References to generic type AX<E> should be parameterized\n----------\n3. WARNING in X.java (at line 9)\n\treturn new AX(\"SUCCESS\");\n\t       ^^^^^^^^^^^^^^^^^\nType safety: The expression of type AX needs unchecked conversion to conform to AX<T>\n----------\n4. WARNING in X.java (at line 9)\n\treturn new AX(\"SUCCESS\");\n\t           ^^\nAX is a raw type. References to generic type AX<E> should be parameterized\n----------\n");
    }

    public void test0170() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>(new X());\n        AX<String> as = new AX<String>(\"\");\n        ax = (AX)bar(ax);\n\t}\n    public static <T> T bar(AX<?> a) {\n\t\treturn a.get();\n    }    \n}\nclass AX<E> {\n\t E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tax = (AX)bar(ax);\n\t     ^^^^^^^^^^^\nType safety: The expression of type AX needs unchecked conversion to conform to AX<X>\n----------\n2. WARNING in X.java (at line 6)\n\tax = (AX)bar(ax);\n\t      ^^\nAX is a raw type. References to generic type AX<E> should be parameterized\n----------\n3. ERROR in X.java (at line 9)\n\treturn a.get();\n\t       ^^^^^^^\nType mismatch: cannot convert from capture#1-of ? to T\n----------\n");
    }

    public void test0171() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>(new X());\n        AX<String> as = new AX<String>(\"\");\n        ax = (AX<X>)bar(ax);\n\t}\n    public static <T> T bar(AX<?> a) {\n\t\treturn a.get();\n    }    \n}\nclass AX<E> {\n\t E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tax = (AX<X>)bar(ax);\n\t     ^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to AX<X>\n----------\n2. ERROR in X.java (at line 9)\n\treturn a.get();\n\t       ^^^^^^^\nType mismatch: cannot convert from capture#1-of ? to T\n----------\n");
    }

    public void test0172() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n        AX<X> ax = new AX<X>(new X());\n        AX<String> as = new AX<String>(\"SUCCESS\");\n        ax = (AX<X>)bar(ax);\n\t}\n    public static <T> String bar(AX<?> a) {\n\t\treturn null;\n    }    \n}\nclass AX<E> {\n\t E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tax = (AX<X>)bar(ax);\n\t     ^^^^^^^^^^^^^^\nCannot cast from String to AX<X>\n----------\n");
    }

    public void test0173() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n    \tfoo();\n    \tSystem.out.println(\"SUCCESS\");\n\t}\n    public static <T> T bar(AX<?> a) {\n\t\treturn null;\n    }    \n    public static AX<X> foo() {\n        AX<X> ax = new AX<X>(new X());\n       return bar(ax);\n    }\n}\nclass AX<E> {\n\t E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n\n"}, "SUCCESS");
    }

    public void test0174() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    \n    public static void main(String[] args) {\n    \tObject o = foo;\n    \tSystem.out.println(\"SUCCESS\");\n\t}\n    public static <T> T bar(AX<?> a) {\n\t\treturn null;\n    }    \n    static AX<X> foo = bar(new AX<X>(new X()));\n}\nclass AX<E> {\n\t E e;\n    AX(E e) { this.e = e; }\n    E get() { return this.e; }\n}\n\n"}, "SUCCESS");
    }

    public void test0175() {
        this.runConformTest(new String[]{"X.java", "    interface A<T> {\n        T[] m1(T x);                          \n    }\n    public class X { \n    \tpublic static void main(String[] args) {\n\t\t\tnew X().m2(new A<X>(){ \n\t\t\t\tpublic X[] m1(X x) { \n\t\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t});\n\t\t}\n        void m2(A<X> x) { \n            m3(x.m1(new X())); \n        }\n        void m3(X[] x) {\n        }                    \n    }\n"}, "SUCCESS");
    }

    public void test0176() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n    <T> Vector<T> valuesOf(Hashtable<?, T> h) {\n        return new Vector();\n    }\n    Vector<Object> data;\n    \n    public void t() {\n        Vector<Object> v = (Vector<Object>) data.elementAt(0);\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\treturn new Vector();\n\t       ^^^^^^^^^^^^\nType safety: The expression of type Vector needs unchecked conversion to conform to Vector<T>\n----------\n2. WARNING in X.java (at line 5)\n\treturn new Vector();\n\t           ^^^^^^\nVector is a raw type. References to generic type Vector<E> should be parameterized\n----------\n3. WARNING in X.java (at line 10)\n\tVector<Object> v = (Vector<Object>) data.elementAt(0);\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Vector<Object>\n----------\n", null, true, customOptions);
    }

    public void test0177() {
        Map options = this.getCompilerOptions();
        this.runConformTest(true, new String[]{"X.java", "public class X <T> {\n\t\n\tT foo(T t) {\n\t\treturn (T) t;\n\t}\n}\n"}, null, options, "----------\n1. WARNING in X.java (at line 4)\n\treturn (T) t;\n\t       ^^^^^\nUnnecessary cast from T to T\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test0178() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n\t\n\tT foo(T t) {\n\t\tif (t instanceof X<T>) {\n\t\t\treturn t;\n\t\t} else if (t instanceof X<String>) {\n\t\t\treturn t;\n\t\t} else if (t instanceof X<?>) {\n\t\t\treturn t;\n\t\t} else \tif (t instanceof T) {\n\t\t\treturn t;\n\t\t} else if (t instanceof X) {\n\t\t\treturn t;\n\t\t}\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (t instanceof X<T>) {\n\t    ^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type X<T>. Use the form X<?> instead since further generic type information will be erased at runtime\n----------\n2. ERROR in X.java (at line 6)\n\t} else if (t instanceof X<String>) {\n\t           ^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type X<String>. Use the form X<?> instead since further generic type information will be erased at runtime\n----------\n3. ERROR in X.java (at line 10)\n\t} else \tif (t instanceof T) {\n\t       \t    ^^^^^^^^^^^^^^\nCannot perform instanceof check against type parameter T. Use its erasure Object instead since further generic type information will be erased at runtime\n----------\n", null, true, customOptions);
    }

    public void test0179() {
        this.runConformTest(new String[]{"X.java", "class U {\n static <T> T notNull(T t) { return t; }\n}\npublic class X {\n void t() {\n  String s = U.notNull(null);\n }\n public static void main(String[] args) {\n\tnew X().t();\n\tSystem.out.println(\"SUCCESS\");\n}\n}\n"}, "SUCCESS");
    }

    public void test0180() {
        this.runConformTest(new String[]{"X.java", "class U {\n static <T> T notNull(T t) { return t; }\n}\npublic class X {\n void t() {\n  String s = U.notNull(\"\");\n }\n public static void main(String[] args) {\n\tnew X().t();\n\tSystem.out.println(\"SUCCESS\");\n}\n}\n"}, "SUCCESS");
    }

    public void test0181() {
        this.runConformTest(new String[]{"X.java", "class U {\n static <T> T notNull(T t, V<T> vt) { return t; }\n}\nclass V<T> {}\n\npublic class X {\n void t() {\n  String s = U.notNull(null, new V<String>());\n }\n public static void main(String[] args) {\n\tnew X().t();\n\tSystem.out.println(\"SUCCESS\");\n}\n}\n"}, "SUCCESS");
    }

    public void test0182() {
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n    X<E> foo() {\n    \treturn (X<E>) this;\n    }\n    X<String> bar() {\n    \treturn (AX<String>) new X<String>();\n    }\n    X<String> bar(Object o) {\n    \treturn (AX<String>) o;\n    }\n    X<E> foo(Object o) {\n    \treturn (AX<E>) o;\n    }    \n    X<E> baz(Object o) {\n    \treturn (AX<E>) null;\n    }\n    X<String> baz2(BX bx) {\n    \treturn (X<String>) bx;\n    }    \n}\nclass AX<F> extends X<F> {}\nclass BX extends AX<String> {}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\treturn (X<E>) this;\n\t       ^^^^^^^^^^^\nUnnecessary cast from X<E> to X<E>\n----------\n2. WARNING in X.java (at line 6)\n\treturn (AX<String>) new X<String>();\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from X<String> to AX<String>\n----------\n3. WARNING in X.java (at line 9)\n\treturn (AX<String>) o;\n\t       ^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to AX<String>\n----------\n4. WARNING in X.java (at line 12)\n\treturn (AX<E>) o;\n\t       ^^^^^^^^^\nType safety: Unchecked cast from Object to AX<E>\n----------\n5. WARNING in X.java (at line 15)\n\treturn (AX<E>) null;\n\t       ^^^^^^^^^^^^\nUnnecessary cast from null to AX<E>\n----------\n6. WARNING in X.java (at line 18)\n\treturn (X<String>) bx;\n\t       ^^^^^^^^^^^^^^\nUnnecessary cast from BX to X<String>\n----------\n");
    }

    public void test0183() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\t\n\t{\n\t\tDictionary<String, Integer> d;\n\t\tObject o;\n\t\t\n\t\tObject a1 = (Hashtable<String,Integer>) d;\n\t\tObject a2 = (Hashtable) o;\n\n\t\tObject a3 = (Hashtable<Float, Double>) d;\n\t\tObject a4 = (Hashtable<String,Integer>) o;\n\t\t\n\t\tabstract class Z1 extends Hashtable<String,Integer> {\n\t\t\tprivate static final long serialVersionUID = 1L;\n\t\t}\n\t\tZ1 z1;\n\t\tObject a5 = (Hashtable<String,Integer>) z1;\n\n\t\tabstract class Z2 extends Z1 {\n\t\t\tprivate static final long serialVersionUID = 1L;\n\t\t}\n\t\tObject a6 = (Z2) z1;\n\n\t\tabstract class Z3 extends Hashtable {\n\t\t\tprivate static final long serialVersionUID = 1L;\n\t\t}\n\t\tZ3 z3;\n\t\tObject a7 = (Hashtable<String,Integer>) z3;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tObject a1 = (Hashtable<String,Integer>) d;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Dictionary<String,Integer> to Hashtable<String,Integer>\n----------\n2. WARNING in X.java (at line 10)\n\tObject a2 = (Hashtable) o;\n\t            ^^^^^^^^^^^^^\nUnnecessary cast from Object to Hashtable\n----------\n3. WARNING in X.java (at line 10)\n\tObject a2 = (Hashtable) o;\n\t             ^^^^^^^^^\nHashtable is a raw type. References to generic type Hashtable<K,V> should be parameterized\n----------\n4. ERROR in X.java (at line 12)\n\tObject a3 = (Hashtable<Float, Double>) d;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from Dictionary<String,Integer> to Hashtable<Float,Double>\n----------\n5. WARNING in X.java (at line 12)\n\tObject a3 = (Hashtable<Float, Double>) d;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Dictionary<String,Integer> to Hashtable<Float,Double>\n----------\n6. WARNING in X.java (at line 13)\n\tObject a4 = (Hashtable<String,Integer>) o;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Hashtable<String,Integer>\n----------\n7. WARNING in X.java (at line 13)\n\tObject a4 = (Hashtable<String,Integer>) o;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object to Hashtable<String,Integer>\n----------\n8. WARNING in X.java (at line 19)\n\tObject a5 = (Hashtable<String,Integer>) z1;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Z1 to Hashtable<String,Integer>\n----------\n9. WARNING in X.java (at line 24)\n\tObject a6 = (Z2) z1;\n\t            ^^^^^^^\nUnnecessary cast from Z1 to Z2\n----------\n10. WARNING in X.java (at line 26)\n\tabstract class Z3 extends Hashtable {\n\t                          ^^^^^^^^^\nHashtable is a raw type. References to generic type Hashtable<K,V> should be parameterized\n----------\n11. WARNING in X.java (at line 30)\n\tObject a7 = (Hashtable<String,Integer>) z3;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Z3 to Hashtable<String,Integer>\n----------\n12. WARNING in X.java (at line 30)\n\tObject a7 = (Hashtable<String,Integer>) z3;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Z3 to Hashtable<String,Integer>\n----------\n");
    }

    public void test0184() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic <T, U> T foo(T t, U u) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.<String,X>foo(\"SUCCESS\", null));\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0185() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t<T, U> T foo(T t, U u) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().<String,X>foo(\"SUCCESS\", null));\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0186() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\t<T, U extends String> T foo(T t, U u) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().<String, X>foo(\"SUCCESS\", null));\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\t<T, U extends String> T foo(T t, U u) {\n\t              ^^^^^^\nThe type parameter U should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 7)\n\tSystem.out.println(new X().<String, X>foo(\"SUCCESS\", null));\n\t                                      ^^^\nBound mismatch: The generic method foo(T, U) of type X is not applicable for the arguments (String, null). The inferred type X is not a valid substitute for the bounded parameter <U extends String>\n----------\n");
    }

    public void test0187() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\t<T, U extends String> T foo(T t, U u) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().<String>foo(\"SUCCESS\", null));\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\t<T, U extends String> T foo(T t, U u) {\n\t              ^^^^^^\nThe type parameter U should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 7)\n\tSystem.out.println(new X().<String>foo(\"SUCCESS\", null));\n\t                                   ^^^\nIncorrect number of type arguments for generic method <T, U>foo(T, U) of type X; it cannot be parameterized with arguments <String>\n----------\n");
    }

    public void test0188() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tvoid foo() {\n\t\treturn;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().<String>foo(\"SUCCESS\", null));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(new X().<String>foo(\"SUCCESS\", null));\n\t                                   ^^^\nThe method foo() in the type X is not applicable for the arguments (String, null)\n----------\n");
    }

    public void test0189() {
        String expectedOutput = this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(new X().<String>foo());\n\t                                   ^^^\nThe method foo() of type X is not generic; it cannot be parameterized with arguments <String>\n----------\n" : "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(new X().<String>foo());\n\t           ^^^^^^^\nThe method println(boolean) in the type PrintStream is not applicable for the arguments (void)\n----------\n2. WARNING in X.java (at line 7)\n\tSystem.out.println(new X().<String>foo());\n\t                            ^^^^^^\nUnused type arguments for the non generic method foo() of type X; it should not be parameterized with arguments <String>\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tvoid foo() {\n\t\treturn;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().<String>foo());\n\t}\n}\n"}, expectedOutput);
    }

    public void test0190() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic <T> X(T t){\n\t\tSystem.out.println(t);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew <String>X(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0191() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic <T> X(T t){\n\t\tSystem.out.println(t);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew <String, String>X(\"FAILED\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew <String, String>X(\"FAILED\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncorrect number of type arguments for generic constructor <T>X(T) of type X; it cannot be parameterized with arguments <String, String>\n----------\n");
    }

    public void test0192() {
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic X(String t){\n\t\tSystem.out.println(t);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew <String>X(\"FAILED\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew <String>X(\"FAILED\");\n\t^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor X(String) of type X is not generic; it cannot be parameterized with arguments <String>\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic X(String t){\n\t\tSystem.out.println(t);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew <String>X(\"FAILED\");\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tnew <String>X(\"FAILED\");\n\t     ^^^^^^\nUnused type arguments for the non generic constructor X(String) of type X; it should not be parameterized with arguments <String>\n----------\n2. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0193() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic <T> X(T t){\n\t\tSystem.out.println(t);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew <String>X(new X(null));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew <String>X(new X(null));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe parameterized constructor <String>X(String) of type X is not applicable for the arguments (X)\n----------\n");
    }

    public void test0194() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\t<T> void foo(T t) {\n\t\treturn;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new X().<String>foo(new X()));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(new X().<String>foo(new X()));\n\t                                   ^^^\nThe parameterized method <String>foo(String) of type X is not applicable for the arguments (X)\n----------\n");
    }

    public void test0195() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic class MX {\n\t\tpublic <T> MX(T t){\n\t\t\tSystem.out.println(t);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new <String>MX(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0196() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic class MX {\n\t\tpublic <T> MX(T t){\n\t\t\tSystem.out.println(t);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new <String,String>MX(\"FAILED\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tnew X().new <String,String>MX(\"FAILED\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncorrect number of type arguments for generic constructor <T>MX(T) of type X.MX; it cannot be parameterized with arguments <String, String>\n----------\n");
    }

    public void test0197() {
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic class MX {\n\t\tpublic MX(String t){\n\t\t\tSystem.out.println(t);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new <String>MX(\"FAILED\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tnew X().new <String>MX(\"FAILED\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor MX(String) of type X.MX is not generic; it cannot be parameterized with arguments <String>\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic class MX {\n\t\tpublic MX(String t){\n\t\t\tSystem.out.println(t);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new <String>MX(\"FAILED\");\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tnew X().new <String>MX(\"FAILED\");\n\t             ^^^^^^\nUnused type arguments for the non generic constructor X.MX(String) of type X.MX; it should not be parameterized with arguments <String>\n----------\n2. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0198() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic class MX {\n\t\tpublic <T>MX(T t){\n\t\t\tSystem.out.println(t);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new <String>MX(new X());\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tnew X().new <String>MX(new X());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe parameterized constructor <String>MX(String) of type X.MX is not applicable for the arguments (X)\n----------\n");
    }

    public void test0199() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic <T> X(T t){\n\t\tSystem.out.println(t);\n\t}\n\tpublic static void main(String[] args) {\n\t\tclass Local extends X {\n\t\t\tLocal() {\n\t\t\t\t<String>super(\"SUCCESS\");\n\t\t\t}\n\t\t};\n\t\tnew Local();\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0200() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic <T> X(T t){\n\t\tSystem.out.println(t);\n\t}\n\tpublic static void main(String[] args) {\n\t\tclass Local extends X {\n\t\t\tLocal() {\n\t\t\t\t<String,String>super(\"FAILED\");\n\t\t\t}\n\t\t};\n\t\tnew Local();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t<String,String>super(\"FAILED\");\n\t               ^^^^^^^^^^^^^^^^\nIncorrect number of type arguments for generic constructor <T>X(T) of type X; it cannot be parameterized with arguments <String, String>\n----------\n");
    }

    public void test0201() {
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic X(String t){\n\t\tSystem.out.println(t);\n\t}\n\tpublic static void main(String[] args) {\n\t\tclass Local extends X {\n\t\t\tLocal() {\n\t\t\t\t<String>super(\"FAILED\");\n\t\t\t}\n\t\t};\n\t\tnew Local();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t<String>super(\"FAILED\");\n\t        ^^^^^^^^^^^^^^^^\nThe constructor X(String) of type X is not generic; it cannot be parameterized with arguments <String>\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic X(String t){\n\t\tSystem.out.println(t);\n\t\tZork z;\n\t}\n\tpublic static void main(String[] args) {\n\t\tclass Local extends X {\n\t\t\tLocal() {\n\t\t\t\t<String>super(\"FAILED\");\n\t\t\t}\n\t\t};\n\t\tnew Local();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 9)\n\t<String>super(\"FAILED\");\n\t ^^^^^^\nUnused type arguments for the non generic constructor X(String) of type X; it should not be parameterized with arguments <String>\n----------\n");
    }

    public void test0202() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic <T> X(T t){\n\t\tSystem.out.println(t);\n\t}\n\tpublic static void main(String[] args) {\n\t\tclass Local extends X {\n\t\t\tLocal() {\n\t\t\t\t<String>super(new X(null));\n\t\t\t}\n\t\t};\n\t\tnew Local();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t<String>super(new X(null));\n\t        ^^^^^^^^^^^^^^^^^^^\nThe parameterized constructor <String>X(String) of type X is not applicable for the arguments (X)\n----------\n");
    }

    public void test0203() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tdemo.AD ad;\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n", "demo/AD.java", "package demo;\npublic interface AD extends LIST<ADXP> {}\n", "demo/ADXP.java", "package demo;\npublic interface ADXP extends BIN {}\n", "demo/ANY.java", "package demo;\npublic interface ANY {}\n", "demo/BL.java", "package demo;\npublic interface BL extends ANY {}\n", "demo/LIST.java", "package demo;\npublic interface LIST<T extends ANY> extends ANY {}\n", "demo/BIN.java", "package demo;\npublic interface BIN extends LIST<BL> {}\n"}, "SUCCESS");
    }

    public void test0204() {
        this.runConformTest(new String[]{"Function.java", "public abstract class Function<Y,X> {\n    public abstract Y eval(X x);\n\n}\n", "FunctionMappedComparator.java", "import java.util.*;\npublic class FunctionMappedComparator<Y,X> implements Comparator<X> {\n\t/*\n\t * 'Function' is highlighted as an error here - the message is:\n\t * The type Function is not generic; it cannot be parameterized with arguments <Y, X>\n\t */\n    protected Function<Y,X> function;\n    protected Comparator<Y> comparator;\n    public FunctionMappedComparator(Function<Y,X> function,Comparator<Y> comparator ) {\n        this.function=function;\n        this.comparator=comparator;\n    }\n\n    public int compare(X x1, X x2) {\n        return comparator.compare(function.eval(x1),function.eval(x2));\n    }\n" + COMPARATOR_RAW_IMPL_JRE8 + "}\n"}, "");
    }

    public void test0205() {
        this.runConformTest(new String[]{"Alpha.java", "public class Alpha {\n\tstatic class Beta<T> {\n\t\tT obj;\n\t}\n}\n"}, "");
    }

    public void test0206() {
        this.runConformTest(new String[]{"Alpha.java", "public class Alpha {\n\tstatic <T> void Beta(T t) {\n\t}\n}\n"}, "");
    }

    public void test0207() {
        this.runNegativeTest(new String[]{"Alpha.java", "public class Alpha<T> extends RuntimeException {\n\tpublic static void main(String[] args) {\n\t\tnew Object() {\n\t\t\tpublic void m() throws Alpha<String> {\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t}\n\t\t}.m();\n\t}\n}\n"}, "----------\n1. WARNING in Alpha.java (at line 1)\n\tpublic class Alpha<T> extends RuntimeException {\n\t             ^^^^^\nThe serializable class Alpha does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in Alpha.java (at line 1)\n\tpublic class Alpha<T> extends RuntimeException {\n\t                              ^^^^^^^^^^^^^^^^\nThe generic class Alpha<T> may not subclass java.lang.Throwable\n----------\n3. ERROR in Alpha.java (at line 4)\n\tpublic void m() throws Alpha<String> {\n\t                       ^^^^^\nCannot use the parameterized type Alpha<String> either in catch block or throws clause\n----------\n");
    }

    public void test0208() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> extends RuntimeException {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new X<String>();\n\t\t} catch(X<String> e) {\n\t\t\tSystem.out.println(\"X<String>\");\n\t\t} catch(X<X<String>> e) {\n\t\t\tSystem.out.println(\"X<X<String>>\");\n\t\t} catch(RuntimeException e) {\n\t\t\tSystem.out.println(\"RuntimeException\");\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X<T> extends RuntimeException {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X<T> extends RuntimeException {\n\t                          ^^^^^^^^^^^^^^^^\nThe generic class X<T> may not subclass java.lang.Throwable\n----------\n3. ERROR in X.java (at line 5)\n\t} catch(X<String> e) {\n\t                  ^\nCannot use the parameterized type X<String> either in catch block or throws clause\n----------\n4. ERROR in X.java (at line 7)\n\t} catch(X<X<String>> e) {\n\t                     ^\nCannot use the parameterized type X<X<String>> either in catch block or throws clause\n----------\n");
    }

    public void test0209() {
        this.runConformTest(new String[]{"X.java", "public class X<A,B,C extends java.util.List<A>> {}\nclass X2<A,C extends java.util.List<A>, B> {}\nclass X3<B, A,C extends java.util.List<A>> {}\n"}, "");
    }

    public void test0210() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Map<? super Object, ? extends String> m){\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Map<? super Object, ? extends String> m){\n\t         ^^^\nMap cannot be resolved to a type\n----------\n");
    }

    public void test0211() {
        this.runConformTest(new String[]{"p/Top.java", "package p;\npublic interface Top<T> {}\n"}, "");
        this.runConformTest(new String[]{"p/Super.java", "package p;\npublic class Super<T> implements Top<T>{\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test0212() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X<T>{\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n\tX<T> _recurse; \n\tpublic List<T> toList(){\n\t\tList<T> result = new ArrayList<T>();\n\t\tresult.addAll(_recurse.toList()); // should be applicable\n\t\treturn result;\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0213() {
        this.runConformTest(new String[]{"X.java", "public class X<R,T extends Comparable<T>>{\n\tT test;\n\tpublic Comparable<? extends T> getThis(){\n\t\treturn test;\n\t}\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0214() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X {\n    public static void main(String[] args) {\n        ArrayList<Object> l;\n        switch (args.length) {\n        case 1:\n            l = new ArrayList<Object>();\n            System.out.println(l);\n            break;\n        default:\n            System.out.println(\"SUCCESS\");\n            return;\n        }\n    }\n}\n"}, "SUCCESS");
    }

    public void test0215() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tjava.util.ArrayList<Object> i;\t\n\t\touter: {\n\t\t\tif (args == null) {\n\t\t\t\ti = null;\n\t\t\t\tbreak outer;\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\t\tSystem.out.println(i);\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  aload_0 [args]\n     1  ifnonnull 9\n     4  aconst_null\n     5  astore_1 [i]\n     6  goto 10\n     9  return\n    10  getstatic java.lang.System.out : java.io.PrintStream [16]\n    13  aload_1 [i]\n    14  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [22]\n    17  getstatic java.lang.System.out : java.io.PrintStream [16]\n    20  ldc <String \"SUCCESS\"> [28]\n    22  invokevirtual java.io.PrintStream.println(java.lang.String) : void [30]\n    25  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 4, line: 6]\n        [pc: 6, line: 7]\n        [pc: 9, line: 9]\n        [pc: 10, line: 11]\n        [pc: 17, line: 12]\n        [pc: 25, line: 13]\n      Local variable table:\n        [pc: 0, pc: 26] local: args index: 0 type: java.lang.String[]\n        [pc: 6, pc: 9] local: i index: 1 type: java.util.ArrayList\n        [pc: 10, pc: 26] local: i index: 1 type: java.util.ArrayList\n      Local variable type table:\n        [pc: 6, pc: 9] local: i index: 1 type: java.util.ArrayList<java.lang.Object>\n        [pc: 10, pc: 26] local: i index: 1 type: java.util.ArrayList<java.lang.Object>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0216() {
        this.runConformTest(new String[]{"test/cheetah/NG.java", "package test.cheetah;\npublic class NG extends G {\n\t\tpublic static void main(String[] args) {\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\n    public boolean test() {\n        return o == null;\n    }\n}\n", "test/cheetah/G.java", "package test.cheetah;\npublic class G<E> {\n    protected Object o;\n}\n"}, "SUCCESS");
    }

    public void test0217() {
        Map customOptions = this.getCompilerOptions();
        this.runConformTest(true, new String[]{"X.java", "import java.util.ArrayList;\npublic class X {\n    public static void main(String [] args) {\n\t\tArrayList<String> l= new ArrayList<String>();\n\t\tString string = (String) l.get(0);\n    }\n}\n"}, null, customOptions, "----------\n1. WARNING in X.java (at line 5)\n\tString string = (String) l.get(0);\n\t                ^^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n", null, "java.lang.IndexOutOfBoundsException", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test0218() {
        this.runConformTest(new String[]{"X.java", "public class X<T>{\n\tprivate final T _data;\n\tprivate X(T data){\n\t\t_data = data;\n\t}\n\tpublic T getData(){\n\t\treturn _data;\n\t}\n\tpublic static <E> X<E> create(E data) {\n\t\treturn new X<E>(data);\n\t}\n\tpublic static void main(String[] args) {\n\t\tcreate(new Object());\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0219() {
        this.runConformTest(new String[]{"X.java", "public class X<T>{\n\tprivate final T _data;\n\tprivate X(T data){\n\t\t_data = data;\n\t}\n\tpublic T getData(){\n\t\treturn _data;\n\t}\n\tpublic static <E> E create(E data) {\n\t\treturn new X<E>(data)._data;\n\t}\n\tpublic static void main(String[] args) {\n\t\tcreate(new Object());\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0220() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\tvoid foo() {\n\t\tArrayList<? super Integer> al = new ArrayList<Object>();\n\t\tal.add(new Integer(1)); // (1)\n\t\tInteger i = al.get(0);  // (2)\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tInteger i = al.get(0);  // (2)\n\t            ^^^^^^^^^\nType mismatch: cannot convert from capture#2-of ? super Integer to Integer\n----------\n");
    }

    public void test0221() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\tvoid foo() {\n\t\tArrayList<? extends Integer> al = new ArrayList<Integer>();\n\t\tal.add(new Integer(1)); // (1)\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tal.add(new Integer(1)); // (1)\n\t   ^^^\nThe method add(capture#1-of ? extends Integer) in the type ArrayList<capture#1-of ? extends Integer> is not applicable for the arguments (Integer)\n----------\n");
    }

    public void test0222() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tXList<? super Integer> lx = new XList<Integer>();\n\t\tlx.slot = new Integer(1);\n\t\tInteger i = lx.slot;\n    }    \t\n}\nclass XList<E> {\n    E slot;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tInteger i = lx.slot;\n\t            ^^^^^^^\nType mismatch: cannot convert from capture#2-of ? super Integer to Integer\n----------\n");
    }

    public void test0223() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\npublic class X {\n    static final Map<String, Class<? extends Object>> classes \n            = new HashMap<String, Class<? extends Object>>();\n    \n    static final Map<String, Class<? extends Object>> classes2 \n            = new HashMap<String, Class>();\n    \n    class MX<E> {\n    \tE get() { return null; }\n    \tvoid foo(E e) {}\n    }\n    \n    void foo() {\n    \tMX<Class<? extends Object>> mx1 = new MX<Class<? extends Object>>();\n    \tMX<Class> mx2 = new MX<Class>();\n    \tmx1.foo(mx2.get());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t= new HashMap<String, Class>();\n\t  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from HashMap<String,Class> to Map<String,Class<? extends Object>>\n----------\n2. WARNING in X.java (at line 8)\n\t= new HashMap<String, Class>();\n\t                      ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n3. WARNING in X.java (at line 17)\n\tMX<Class> mx2 = new MX<Class>();\n\t   ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n4. WARNING in X.java (at line 17)\n\tMX<Class> mx2 = new MX<Class>();\n\t                       ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n5. WARNING in X.java (at line 18)\n\tmx1.foo(mx2.get());\n\t        ^^^^^^^^^\nType safety: The expression of type Class needs unchecked conversion to conform to Class<? extends Object>\n----------\n", null, true, customOptions);
    }

    public void test0224() {
        this.runNegativeTest(new String[]{"test/cheetah/NG.java", "package test.cheetah;\npublic class NG extends G {\n\t\tpublic static void main(String[] args) {\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\n    public boolean test() {\n        return o == null;\n    }\n}\n", "test/cheetah/G.java", "package test.cheetah;\npublic class G<E> {\n    protected final Object o;\n}\n"}, "----------\n1. WARNING in test\\cheetah\\NG.java (at line 2)\n\tpublic class NG extends G {\n\t                        ^\nG is a raw type. References to generic type G<E> should be parameterized\n----------\n----------\n1. ERROR in test\\cheetah\\G.java (at line 3)\n\tprotected final Object o;\n\t                       ^\nThe blank final field o may not have been initialized\n----------\n");
    }

    public void test0225() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends Exception> {\n    String foo() throws T {\n        return \"SUCCESS\";\n    }\n    public static void main(String[] args) {\n        new X<EX>().baz(new EX());\n    }\n    void baz(final T t) {\n        new Object() {\n            void print() {\n                try {\n\t                System.out.println(foo());\n                } catch (T t) {\n                }\n            }\n        }.print();\n    }\n}\nclass EX extends Exception {\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\t} catch (T t) {\n\t           ^\nCannot use the type parameter T in a catch block\n----------\n2. WARNING in X.java (at line 13)\n\t} catch (T t) {\n\t           ^\nThe parameter t is hiding another local variable defined in an enclosing scope\n----------\n3. WARNING in X.java (at line 19)\n\tclass EX extends Exception {\n\t      ^^\nThe serializable class EX does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test0226() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>{\n\t Object x1= new T[0];\n\t Object x2= new X<String>[0];\t \n\t Object x3= new X<T>[0];\t \n\t Object x4= new X[0];\t \n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tObject x1= new T[0];\n\t           ^^^^^^^^\nCannot create a generic array of T\n----------\n2. ERROR in X.java (at line 3)\n\tObject x2= new X<String>[0];\t \n\t           ^^^^^^^^^^^^^^^^\nCannot create a generic array of X<String>\n----------\n3. ERROR in X.java (at line 4)\n\tObject x3= new X<T>[0];\t \n\t           ^^^^^^^^^^^\nCannot create a generic array of X<T>\n----------\n");
    }

    public void test0227() {
        this.runNegativeTest(new String[]{"X.java", " import java.util.*;\n public class X {\n  List list() { return null; }\n  void m() { List<X> l = (List<X>)list(); } // unsafe cast\n  void m0() { List<X> l = list(); } // unsafe conversion\n  void m1() { for (X a : list()); } // type mismatch\n  void m2() { for (Iterator<X> i = list().iterator(); i.hasNext();); }  // unsafe conversion\n  void m3() { Collection c = null; List l = (List<X>)c; } // unsafe cast\n  void m4() { Collection c = null; List l = (List<?>)c; } // ok\n  void m5() { List c = null; List l = (Collection<X>)c; } // type mismatch\n  void m6() { List c = null; List l = (Collection<?>)c; } // type mismatch\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tList list() { return null; }\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tvoid m() { List<X> l = (List<X>)list(); } // unsafe cast\n\t                       ^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List to List<X>\n----------\n3. WARNING in X.java (at line 4)\n\tvoid m() { List<X> l = (List<X>)list(); } // unsafe cast\n\t                       ^^^^^^^^^^^^^^^\nUnnecessary cast from List to List<X>\n----------\n4. WARNING in X.java (at line 5)\n\tvoid m0() { List<X> l = list(); } // unsafe conversion\n\t                        ^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<X>\n----------\n5. ERROR in X.java (at line 6)\n\tvoid m1() { for (X a : list()); } // type mismatch\n\t                       ^^^^^^\nType mismatch: cannot convert from element type Object to X\n----------\n6. WARNING in X.java (at line 7)\n\tvoid m2() { for (Iterator<X> i = list().iterator(); i.hasNext();); }  // unsafe conversion\n\t                                 ^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator needs unchecked conversion to conform to Iterator<X>\n----------\n7. WARNING in X.java (at line 8)\n\tvoid m3() { Collection c = null; List l = (List<X>)c; } // unsafe cast\n\t            ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n8. WARNING in X.java (at line 8)\n\tvoid m3() { Collection c = null; List l = (List<X>)c; } // unsafe cast\n\t                                 ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n9. WARNING in X.java (at line 8)\n\tvoid m3() { Collection c = null; List l = (List<X>)c; } // unsafe cast\n\t                                          ^^^^^^^^^^\nType safety: Unchecked cast from Collection to List<X>\n----------\n10. WARNING in X.java (at line 9)\n\tvoid m4() { Collection c = null; List l = (List<?>)c; } // ok\n\t            ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n11. WARNING in X.java (at line 9)\n\tvoid m4() { Collection c = null; List l = (List<?>)c; } // ok\n\t                                 ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n12. WARNING in X.java (at line 10)\n\tvoid m5() { List c = null; List l = (Collection<X>)c; } // type mismatch\n\t            ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n13. WARNING in X.java (at line 10)\n\tvoid m5() { List c = null; List l = (Collection<X>)c; } // type mismatch\n\t                           ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n14. WARNING in X.java (at line 10)\n\tvoid m5() { List c = null; List l = (Collection<X>)c; } // type mismatch\n\t                                    ^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List to Collection<X>\n----------\n15. ERROR in X.java (at line 10)\n\tvoid m5() { List c = null; List l = (Collection<X>)c; } // type mismatch\n\t                                    ^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Collection<X> to List\n----------\n16. WARNING in X.java (at line 11)\n\tvoid m6() { List c = null; List l = (Collection<?>)c; } // type mismatch\n\t            ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n17. WARNING in X.java (at line 11)\n\tvoid m6() { List c = null; List l = (Collection<?>)c; } // type mismatch\n\t                           ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n18. ERROR in X.java (at line 11)\n\tvoid m6() { List c = null; List l = (Collection<?>)c; } // type mismatch\n\t                                    ^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Collection<capture#2-of ?> to List\n----------\n");
    }

    public void test0228() {
        this.runConformTest(new String[]{"X.java", " import java.util.*;\n public class X {\n \tList<?> list = new ArrayList();\n }\n"}, "");
    }

    public void test0229() {
        this.runConformTest(true, new String[]{"X.java", " public class X <T extends XC> {\n \tT.MXC f;\n \tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n }\n class XC {\n \tclass MXC {}\n }\n"}, null, "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6569404);
    }

    public void test0230() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tvoid foo() {\n\t\tList<? extends Integer> li= null;\n\t\tList<? extends Number> ln= null;\n\t\tln = li;\n\t\tli= ln;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tli= ln;\n\t    ^^\nType mismatch: cannot convert from List<capture#4-of ? extends Number> to List<? extends Integer>\n----------\n");
    }

    public void test0231() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>{\n\t Object x1= new X<?>[0];\t \n\t Object x2= new X<? super String>[0];\t \n\t Object x3= new X<? extends Thread>[0];\t \n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject x2= new X<? super String>[0];\t \n\t           ^^^^^^^^^^^^^^^^^^^^^^^^\nCannot create a generic array of X<? super String>\n----------\n2. ERROR in X.java (at line 4)\n\tObject x3= new X<? extends Thread>[0];\t \n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot create a generic array of X<? extends Thread>\n----------\n");
    }

    public void test0232() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic class Container<T>{\n\t    private T val;\n\t    public T getVal() {\n\t        return val;\n\t    }\n\t    public void setVal(T val) {\n\t        this.val = val;\n\t    }\n\t}\n\tpublic static void badMethod(Container<?> param){\n\t    Container x=param;\n\t    x.setVal(\"BAD\");\n\t}\n\tpublic static void main(String[] args) {\n\t    Container<Integer> cont=new Container<Integer>();\n\t    cont.setVal(new Integer(0));\n\t    badMethod(cont);\n\t    Object someVal = cont.getVal(); // no cast \n\t    System.out.println(cont.getVal()); // no cast \n\t}\n}\n"}, "BAD");
    }

    public void test0233() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic class Container<T>{\n\t    private T val;\n\t    public T getVal() {\n\t        return val;\n\t    }\n\t    public void setVal(T val) {\n\t        this.val = val;\n\t    }\n\t}\n\tpublic static void badMethod(Container<?> param){\n\t    Container x=param;\n\t    x.setVal(new Long(0));\n\t}\n\tpublic static void main(String[] args) {\n\t    Container<Integer> cont=new Container<Integer>();\n\t    cont.setVal(new Integer(0));\n\t    badMethod(cont);\n\t    Number someVal = cont.getVal();// only cast to Number \n\t    System.out.println(\"SUCCESS\"); \n\t}\n}\n"}, "SUCCESS");
    }

    public void test0234() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic class Container<T>{\n\t    public T val;\n\t    public T getVal() {\n\t        return val;\n\t    }\n\t    public void setVal(T val) {\n\t        this.val = val;\n\t    }\n\t}\n\tpublic static void badMethod(Container<?> param){\n\t    Container x=param;\n\t    x.setVal(\"BAD\");\n\t}\n\tpublic static void main(String[] args) {\n\t    Container<Integer> cont=new Container<Integer>();\n\t    cont.setVal(new Integer(0));\n\t    badMethod(cont);\n\t    Object someVal = cont.val; // no cast \n\t    System.out.println(cont.val); // no cast \n\t}\n}\n"}, "BAD");
    }

    public void test0235() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic class Container<T>{\n\t    public T val;\n\t    public T getVal() {\n\t        return val;\n\t    }\n\t    public void setVal(T val) {\n\t        this.val = val;\n\t    }\n\t}\n\tpublic static void badMethod(Container<?> param){\n\t    Container x=param;\n\t    x.setVal(new Long(0));\n\t}\n\tpublic static void main(String[] args) {\n\t    Container<Integer> cont=new Container<Integer>();\n\t    cont.setVal(new Integer(0));\n\t    badMethod(cont);\n\t    Number someVal = cont.val;// only cast to Number \n\t    System.out.println(\"SUCCESS\"); \n\t}\n}\n"}, "SUCCESS");
    }

    public void test0236() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic class Container<T>{\n\t    public T val;\n\t    public T getVal() {\n\t        return val;\n\t    }\n\t    public void setVal(T val) {\n\t        this.val = val;\n\t    }\n\t}\n\tpublic static void badMethod(Container<?> param){\n\t    Container x=param;\n\t    x.setVal(\"BAD\");\n\t}\n\tpublic static void main(String[] args) {\n\t    Container<Integer> cont=new Container<Integer>();\n\t    cont.setVal(new Integer(0));\n\t    badMethod(cont);\n\t    Object someVal = (cont).val; // no cast \n\t    System.out.println((cont).val); // no cast \n\t}\n}\n"}, "BAD");
    }

    public void test0237() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic class Container<T>{\n\t    public T val;\n\t    public T getVal() {\n\t        return val;\n\t    }\n\t    public void setVal(T val) {\n\t        this.val = val;\n\t    }\n\t}\n\tpublic static void badMethod(Container<?> param){\n\t    Container x=param;\n\t    x.setVal(new Long(0));\n\t}\n\tpublic static void main(String[] args) {\n\t    Container<Integer> cont=new Container<Integer>();\n\t    cont.setVal(new Integer(0));\n\t    badMethod(cont);\n\t    Number someVal = (cont).val;// only cast to Number \n\t    System.out.println(\"SUCCESS\"); \n\t}\n}\n"}, "SUCCESS");
    }

    public void test0238() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic class Container<T>{\n\t    public T val;\n\t\tContainer<T> next;\n\t    public T getVal() {\n\t        return val;\n\t    }\n\t    public void setVal(T val) {\n\t        this.val = val;\n\t    }\n\t}\n\tpublic static void badMethod(Container<?> param){\n\t    Container x=param;\n\t    x.setVal(\"BAD\");\n\t}\n\tpublic static void main(String[] args) {\n\t    Container<Integer> cont = new Container<Integer>();\n\t\tcont.next = new Container<Integer>();\n\t    cont.next.setVal(new Integer(0));\n\t    badMethod(cont.next);\n\t    Object someVal = cont.next.val; // no cast \n\t    System.out.println(cont.next.val); // no cast \n\t}\n}\n"}, "BAD");
    }

    public void test0239() {
        this.runConformTest(new String[]{"X.java", "public class X {\n \tstatic class Container<T>{\n\t    public T val;\n\t\tContainer<T> next;\n\t    public T getVal() {\n\t        return val;\n\t    }\n\t    public void setVal(T val) {\n\t        this.val = val;\n\t    }\n\t}\n\tpublic static void badMethod(Container<?> param){\n\t    Container x=param;\n\t    x.setVal(new Long(0));\n\t}\n\tpublic static void main(String[] args) {\n\t    Container<Integer> cont = new Container<Integer>();\n\t\tcont.next = new Container<Integer>();\n\t    cont.next.setVal(new Integer(0));\n\t    badMethod(cont.next);\n\t    Number someVal = cont.next.val;// only cast to Number \n\t    System.out.println(\"SUCCESS\"); \n\t}\n}\n"}, "SUCCESS");
    }

    public void test0240() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    String[] elements = null;\n\t\n    public X() {\n        String s = \"a, b, c, d\";\n        elements = s.split(\",\");\n        if(elements.length = 3) {\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tif(elements.length = 3) {\n\t   ^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from int to boolean\n----------\n");
    }

    public void test0241() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\npublic class X {\n    private static final Map<String, Class> classes = new HashMap<String, Class>();\n    public static void main(String[] args) throws Exception {\n    \tclasses.put(\"test\", X.class);\n        final Class<? extends Object> clazz = (Class<? extends Object>) classes.get(\"test\");\n        Object o = clazz.newInstance();\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0242() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\npublic class X {\n    @SuppressWarnings(\"rawtypes\")\n    private static final Map<String, Class> classes = new HashMap<String, Class>();\n    public static void main(String[] args) throws Exception {\n    \tclasses.put(\"test\", X.class);\n        final Class<? extends Object> clazz = (Class<? extends Object>) classes.get(\"test\");\n        final Class<? extends String> clazz2 = (Class<? extends String>) classes.get(\"test\");\n        final Class<String> clazz3 = (Class<String>) classes.get(\"test\");\n        Object o = clazz.newInstance();\n    }\n}"}, "----------\n1. WARNING in X.java (at line 8)\n\tfinal Class<? extends Object> clazz = (Class<? extends Object>) classes.get(\"test\");\n\t                                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Class to Class<? extends Object>\n----------\n2. WARNING in X.java (at line 8)\n\tfinal Class<? extends Object> clazz = (Class<? extends Object>) classes.get(\"test\");\n\t                                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Class to Class<? extends Object>\n----------\n3. WARNING in X.java (at line 9)\n\tfinal Class<? extends String> clazz2 = (Class<? extends String>) classes.get(\"test\");\n\t                                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Class to Class<? extends String>\n----------\n4. WARNING in X.java (at line 9)\n\tfinal Class<? extends String> clazz2 = (Class<? extends String>) classes.get(\"test\");\n\t                                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Class to Class<? extends String>\n----------\n5. WARNING in X.java (at line 10)\n\tfinal Class<String> clazz3 = (Class<String>) classes.get(\"test\");\n\t                             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Class to Class<String>\n----------\n6. WARNING in X.java (at line 10)\n\tfinal Class<String> clazz3 = (Class<String>) classes.get(\"test\");\n\t                             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Class to Class<String>\n----------\n");
    }

    public void test0243() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public X foo() {\n        System.out.println(\"Did NOT add bridge method\");\n        return this;\n    }\n    public static void main(String[] args) throws Exception {\n        X x = new A();\n        x.foo();\n        System.out.print(\" + \");\n        I i = new A();\n        i.foo();\n    }\n}\ninterface I {\n    public I foo();\n}\nclass A extends X implements I {\n    public A foo() {\n        System.out.print(\"Added bridge method\");\n        return this;\n    }\n}\n"}, "Added bridge method + Added bridge method");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public X foo() { return this; }\n    public static void main(String[] args) throws Exception {\n        System.out.println(\"SUCCESS\");\n    }\n}\n", "SubTypes.java", "class A extends X {\n    @Override public A foo() { return this; }\n}\nclass B extends X {\n    @Override public X foo() { return new X(); }\n    @Override public B foo() { return this; }\n}\nclass C extends A {\n    @Override public X foo() { return new X(); }\n}\n"}, "----------\n1. ERROR in SubTypes.java (at line 5)\n\t@Override public X foo() { return new X(); }\n\t                   ^^^^^\nDuplicate method foo() in type B\n----------\n2. ERROR in SubTypes.java (at line 6)\n\t@Override public B foo() { return this; }\n\t                   ^^^^^\nDuplicate method foo() in type B\n----------\n3. ERROR in SubTypes.java (at line 9)\n\t@Override public X foo() { return new X(); }\n\t                 ^\nThe return type is incompatible with A.foo()\n----------\n");
    }

    public void test0244() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> { \n\t<G> T foo(G g) {\n\t\treturn null;\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tX rx = new X();\n\t\trx.foo(\"hello\");\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tX rx = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tX rx = new X();\n\t           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 8)\n\trx.foo(\"hello\");\n\t^^^^^^^^^^^^^^^\nType safety: The method foo(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test0245() {
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X <T> { \n        <G> T foo(G g) {\n            return null;\n        }\n        T bar(T t) {\n        \treturn zork;\n        }\n\n        public static void main(String[] args) {\n                X rx = new X();\n                rx.<String>foo(\"hello\"); // Eclipse error here\n                rx.<String>bar(\"hello\"); // Eclipse error here\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\treturn zork;\n\t       ^^^^\nzork cannot be resolved to a variable\n----------\n2. WARNING in X.java (at line 10)\n\tX rx = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 10)\n\tX rx = new X();\n\t           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 11)\n\trx.<String>foo(\"hello\"); // Eclipse error here\n\t           ^^^\nThe method foo(Object) of raw type X is no longer generic; it cannot be parameterized with arguments <String>\n----------\n5. ERROR in X.java (at line 12)\n\trx.<String>bar(\"hello\"); // Eclipse error here\n\t           ^^^\nThe method bar(Object) of type X is not generic; it cannot be parameterized with arguments <String>\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236242);
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X <T> { \n        <G> T foo(G g) {\n            return null;\n        }\n        T bar(T t) {\n        \treturn zork;\n        }\n\n        public static void main(String[] args) {\n                X rx = new X();\n                rx.<String>foo(\"hello\"); // Eclipse error here\n                rx.<String>bar(\"hello\"); // Eclipse error here\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\treturn zork;\n\t       ^^^^\nzork cannot be resolved to a variable\n----------\n2. WARNING in X.java (at line 10)\n\tX rx = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 10)\n\tX rx = new X();\n\t           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 11)\n\trx.<String>foo(\"hello\"); // Eclipse error here\n\t^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method foo(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n5. WARNING in X.java (at line 12)\n\trx.<String>bar(\"hello\"); // Eclipse error here\n\t^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method bar(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n6. WARNING in X.java (at line 12)\n\trx.<String>bar(\"hello\"); // Eclipse error here\n\t    ^^^^^^\nUnused type arguments for the non generic method bar(Object) of type X; it should not be parameterized with arguments <String>\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236242);
    }

    public void test0246() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n    class MX<E> {\n    }\n    void foo() {\n      MX<Class<? extends Object>> mx2 = new MX<Class>();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tMX<Class<? extends Object>> mx2 = new MX<Class>();\n\t                                  ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X.MX<Class> to X.MX<Class<? extends Object>>\n----------\n2. WARNING in X.java (at line 5)\n\tMX<Class<? extends Object>> mx2 = new MX<Class>();\n\t                                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void test0247() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n    void foo() {\n      MX<Class<? extends Object>> mx2 = new MX<Class>(); // wrong\n      MX<Class<? extends Object>> mx3 = new MX<Class<? extends String>>(); // wrong\n      MX<Class<? extends Object>> mx4 = new MX<Class<String>>(); // wrong\n      MX<? extends Class> mx5 = new MX<Class>(); // ok\n      MX<? super Class> mx6 = new MX<Class>(); // ok\n      MX<Class<? extends Class>> mx7 = new MX<Class<Class>>(); // wrong\n      MX<MX<? extends Class>> mx8 = new MX<MX<Class>>(); // wrong\n    }\n}\n\nclass MX<E> {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tMX<Class<? extends Object>> mx2 = new MX<Class>(); // wrong\n\t                                  ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from MX<Class> to MX<Class<? extends Object>>\n----------\n2. WARNING in X.java (at line 3)\n\tMX<Class<? extends Object>> mx2 = new MX<Class>(); // wrong\n\t                                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n3. ERROR in X.java (at line 4)\n\tMX<Class<? extends Object>> mx3 = new MX<Class<? extends String>>(); // wrong\n\t                                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from MX<Class<? extends String>> to MX<Class<? extends Object>>\n----------\n4. ERROR in X.java (at line 5)\n\tMX<Class<? extends Object>> mx4 = new MX<Class<String>>(); // wrong\n\t                                  ^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from MX<Class<String>> to MX<Class<? extends Object>>\n----------\n5. WARNING in X.java (at line 6)\n\tMX<? extends Class> mx5 = new MX<Class>(); // ok\n\t             ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n6. WARNING in X.java (at line 6)\n\tMX<? extends Class> mx5 = new MX<Class>(); // ok\n\t                                 ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n7. WARNING in X.java (at line 7)\n\tMX<? super Class> mx6 = new MX<Class>(); // ok\n\t           ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n8. WARNING in X.java (at line 7)\n\tMX<? super Class> mx6 = new MX<Class>(); // ok\n\t                               ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n9. WARNING in X.java (at line 8)\n\tMX<Class<? extends Class>> mx7 = new MX<Class<Class>>(); // wrong\n\t                   ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n10. ERROR in X.java (at line 8)\n\tMX<Class<? extends Class>> mx7 = new MX<Class<Class>>(); // wrong\n\t                                 ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from MX<Class<Class>> to MX<Class<? extends Class>>\n----------\n11. WARNING in X.java (at line 8)\n\tMX<Class<? extends Class>> mx7 = new MX<Class<Class>>(); // wrong\n\t                                              ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n12. WARNING in X.java (at line 9)\n\tMX<MX<? extends Class>> mx8 = new MX<MX<Class>>(); // wrong\n\t                ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n13. ERROR in X.java (at line 9)\n\tMX<MX<? extends Class>> mx8 = new MX<MX<Class>>(); // wrong\n\t                              ^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from MX<MX<Class>> to MX<MX<? extends Class>>\n----------\n14. WARNING in X.java (at line 9)\n\tMX<MX<? extends Class>> mx8 = new MX<MX<Class>>(); // wrong\n\t                                        ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void test0248() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<T> extends Vector<? super X<int[]>>{}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X<T> extends Vector<? super X<int[]>>{}\n\t                          ^^^^^^\nThe type X cannot extend or implement Vector<? super X<int[]>>. A supertype may not specify any wildcard\n----------\n");
    }

    public void test0249() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<T> implements List<? super X<int[]>>{}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X<T> implements List<? super X<int[]>>{}\n\t                             ^^^^\nThe type X cannot extend or implement List<? super X<int[]>>. A supertype may not specify any wildcard\n----------\n");
    }

    public void test0250() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    void test(Object o) {\n        X.class.isAssignableFrom(o.getClass());\n    }\n}\n"}, "");
    }

    public void test0251() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n    static class A {\n    }\n    A test() throws Exception {\n        Class<? extends Object> clazz = null;\n        return clazz.newInstance(); // ? extends Object\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\treturn clazz.newInstance(); // ? extends Object\n\t       ^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from capture#1-of ? extends Object to X.A\n----------\n");
    }

    public void test0252() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSet<X> channel = channels.get(0);\n\t    for (Iterator<X> iter = channel.iterator(); iter.hasNext();) {\n\t        Set<X> element;\n\t        element = (Set<X>) iter.next();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tSet<X> channel = channels.get(0);\n\t                 ^^^^^^^^\nchannels cannot be resolved\n----------\n2. WARNING in X.java (at line 7)\n\telement = (Set<X>) iter.next();\n\t          ^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X to Set<X>\n----------\n");
    }

    public void test0253() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public static void main(String[] args) {\n        List<Integer> li= new ArrayList<Integer>();\n        List<? extends Number> ls= li;       \n        List<Number> x2= (List<Number>)ls;//unsafe\n        x2.add(new Float(1.0));\n        \n        Integer i= li.get(0);//ClassCastException!\n        \n        List<Number> ls2 = (List<? extends Number>)ls;\n        List<? extends Number> ls3 = (List<? extends Number>) li;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tList<Number> x2= (List<Number>)ls;//unsafe\n\t                 ^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List<capture#1-of ? extends Number> to List<Number>\n----------\n2. ERROR in X.java (at line 11)\n\tList<Number> ls2 = (List<? extends Number>)ls;\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<capture#3-of ? extends Number> to List<Number>\n----------\n3. WARNING in X.java (at line 12)\n\tList<? extends Number> ls3 = (List<? extends Number>) li;\n\t                             ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from List<Integer> to List<? extends Number>\n----------\n");
    }

    public void test0254() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n public static void main(String[] args) {\n  X x = new X();\n  System.out.print(\"S\" + x.a() + \"U\" + x.b().get(0) + \"C\" + x.a() + \"C\");\n  System.out.println(new StringBuilder(\"E\").append(x.a()).append(\"S\").append(x.b().get(0)).append(\"S\").append(x.a()).append(\"!\"));  \n }\n String a() { return \"\"; }\n List<String> b() { \n  ArrayList<String> als = new ArrayList<String>(1);\n  als.add(a());\n  return als;\n }\n}\n"}, "SUCCESS!");
    }

    public void test0255() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, U> extends Throwable {\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X<T, U> extends Throwable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X<T, U> extends Throwable {\n\t                             ^^^^^^^^^\nThe generic class X<T,U> may not subclass java.lang.Throwable\n----------\n");
    }

    public void test0256() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n\n\t\tEnum<X> ex = null;\n\t\tString s = ex.name();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tEnum<X> ex = null;\n\t     ^\nBound mismatch: The type X is not a valid substitute for the bounded parameter <E extends Enum<E>> of the type Enum<E>\n----------\n");
    }

    public void test0257() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    public abstract class M extends java.util.AbstractList<T> {}\n}\nclass Y<T> extends T {}\nclass Z<T> {\n    class M extends T {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tclass Y<T> extends T {}\n\t                   ^\nCannot refer to the type parameter T as a supertype\n----------\n2. ERROR in X.java (at line 6)\n\tclass M extends T {}\n\t                ^\nCannot refer to the type parameter T as a supertype\n----------\n");
    }

    public void test0258() {
        this.runConformTest(new String[]{"X.java", "abstract class X<K,V> implements java.util.Map<K,V> {\n    static abstract class M<K,V> implements Entry<K,V> {}\n}\n"}, "");
    }

    public void test0259() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\t\n\t<E> X(E e) {\n\t\t<E> this();\n\t}\n\t\n\t<E> X() {\n\t}\n}\n"}, "");
    }

    public void test0260() {
        this.runConformTest(new String[]{"X.java", "public class X <E> {\n\tclass MX <F> {\n\t}\n}\n\nclass XC<G> extends X<G> {\n\tclass MXC<H> extends MX<H> {\n\t}\n}\n"}, "");
    }

    public void test0261() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E> {\n\tvoid foo(){\n\t\tX<Integer> xi = (X<Integer>) new X<String>();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX<Integer> xi = (X<Integer>) new X<String>();\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from X<String> to X<Integer>\n----------\n");
    }

    public void test0262() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E,F> {\n\tvoid foo(){\n\t\tX<E,String> xe = (X<E,String>) new X<String,String>();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tX<E,String> xe = (X<E,String>) new X<String,String>();\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X<String,String> to X<E,String>\n----------\n");
    }

    public void test0263() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E,F> {\n\tvoid foo(){\n\t\tXC<E,String> xe = (XC<E,String>) new X<String,String>();\n\t}\n}\nclass XC<G,H> extends X<G,H> {\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tXC<E,String> xe = (XC<E,String>) new X<String,String>();\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X<String,String> to XC<E,String>\n----------\n");
    }

    public void test0264() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E,F> {\n\tvoid foo(){\n\t\tXC<E,String> xe = (XC<E,String>) new X<String,Integer>();\n\t}\n}\nclass XC<G,H> extends X<G,H> {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tXC<E,String> xe = (XC<E,String>) new X<String,Integer>();\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from X<String,Integer> to XC<E,String>\n----------\n");
    }

    public void test0265() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E> {\n\t<U> void foo(){\n\t\t\tXC<U> xcu = (XC<U>) new X<E>();\n\t\t\tXC<U> xcu1 = (XC<?>) new X<E>();\t\t\t\n\t\t\tXC<?> xcu2 = (XC<? extends X>) new X<E>();\t\t\t\t\t\t\n\t}\n}\nclass XC<G> extends X<G> {\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tXC<U> xcu = (XC<U>) new X<E>();\n\t            ^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X<E> to XC<U>\n----------\n2. ERROR in X.java (at line 4)\n\tXC<U> xcu1 = (XC<?>) new X<E>();\t\t\t\n\t             ^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from XC<capture#1-of ?> to XC<U>\n----------\n3. WARNING in X.java (at line 5)\n\tXC<?> xcu2 = (XC<? extends X>) new X<E>();\t\t\t\t\t\t\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X<E> to XC<? extends X>\n----------\n4. WARNING in X.java (at line 5)\n\tXC<?> xcu2 = (XC<? extends X>) new X<E>();\t\t\t\t\t\t\n\t                           ^\nX is a raw type. References to generic type X<E> should be parameterized\n----------\n");
    }

    public void test0266() {
        this.runConformTest(new String[]{"X.java", "public class X <E> {\n\tvoid bar() {\n\t\tX<? extends E> xe = new X<E>();\n\t}\n}\n"}, "");
    }

    public void test0267() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n\tstatic void foo(X<?> xany) { \n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X<Object[]>());\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0268() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X <T> {\n\tX[] foo() {\n\t\tArrayList<X> list = new ArrayList();\n\t\treturn list.toArray(new X[list.size()]);\n\t}\n\tpublic static void main(String[] args) {\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tX[] foo() {\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tArrayList<X> list = new ArrayList();\n\t          ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tArrayList<X> list = new ArrayList();\n\t                    ^^^^^^^^^^^^^^^\nType safety: The expression of type ArrayList needs unchecked conversion to conform to ArrayList<X>\n----------\n4. WARNING in X.java (at line 4)\n\tArrayList<X> list = new ArrayList();\n\t                        ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n");
    }

    public void test0269() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\n\t<U> U[] bar(U[] u)  { \n\t\tSystem.out.println(\"SUCCESS\");\n\t\treturn null; }\n\n\tstatic String[] foo() {\n\t\tX<String> xs = new X<String>();\n\t\treturn xs.bar(new String[0]);\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo();\n\t}\n}\n"}, "SUCCESS");
        this.runConformTest(new String[]{"Y.java", "public class Y {\n    public static void main(String [] args) {\n\t\tX<String> xs = new X<String>();\n\t\tString[] s = xs.bar(new String[0]);\n    }\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test0270() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n    public void test(boolean param) {\n        ArrayList<?> ls = (param) \n        \t\t? new ArrayList<String>()\n        \t\t: new ArrayList<Object>();\n        \t\t\n        X x = param ? new XY() : new XZ();\n        XY y = (XY) new XZ();\n    }\n}\nclass XY extends X {}\nclass XZ extends X {}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tXY y = (XY) new XZ();\n\t       ^^^^^^^^^^^^^\nCannot cast from XZ to XY\n----------\n");
    }

    public void test0271() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends Enum<T>> {\n}\n"}, "");
    }

    public void test0272() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends XY<T>> {\n}\n\nclass XY<U extends Cloneable> implements Cloneable {\n}\n"}, "");
    }

    public void test0273() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends XY<T> & Cloneable> {\n}\n\nclass XY<U extends Cloneable> {\n}\n"}, "");
    }

    public void test0274() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n    public List useList(List l) {\n        l.add(\"asdf\");\n        return l;\n    }\n}\nclass Y extends X {\n    public List<String> useList(List<String> l) {\n        l.add(\"asdf\");\n        return l;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic List useList(List l) {\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tpublic List useList(List l) {\n\t                    ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tl.add(\"asdf\");\n\t^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n4. ERROR in X.java (at line 9)\n\tpublic List<String> useList(List<String> l) {\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method useList(List<String>) of type Y has the same erasure as useList(List) of type X but does not override it\n----------\n");
    }

    public void test0275() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n    public List<String> useList(List<String> l) {\n        l.add(\"asdf\");\n        return l;\n    }\n}\nclass Y extends X {\n    public List useList(List l) {\n        l.add(\"asdf\");\n        return l;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tpublic List useList(List l) {\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 9)\n\tpublic List useList(List l) {\n\t       ^^^^\nType safety: The return type List for useList(List) from the type Y needs unchecked conversion to conform to List<String> from the type X\n----------\n3. WARNING in X.java (at line 9)\n\tpublic List useList(List l) {\n\t            ^^^^^^^^^^^^^^^\nThe method useList(List) of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n4. WARNING in X.java (at line 9)\n\tpublic List useList(List l) {\n\t                    ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n5. WARNING in X.java (at line 10)\n\tl.add(\"asdf\");\n\t^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test0276() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n    public void useList(List l) {}\n}\nclass Y extends X {\n    public void useList(List<String> l) {\n\t\tsuper.useList(l);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void useList(List l) {}\n\t                    ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in X.java (at line 6)\n\tpublic void useList(List<String> l) {\n\t            ^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method useList(List<String>) of type Y has the same erasure as useList(List) of type X but does not override it\n----------\n");
    }

    public void test0277() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n    public void useList(List<String> l) {}\n}\nclass Y extends X {\n    public void useList(List l) {\n\t\tsuper.useList(l);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tpublic void useList(List l) {\n\t            ^^^^^^^^^^^^^^^\nThe method useList(List) of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n2. WARNING in X.java (at line 6)\n\tpublic void useList(List l) {\n\t                    ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 7)\n\tsuper.useList(l);\n\t              ^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n");
    }

    public void test0278() {
        this.runConformTest(new String[]{"X.java", "public class X<T> implements I {\n    public Class<T> getDeclaringClass() { return null; }\n}\nclass Y implements I {\n    public Class<?> getDeclaringClass() { return null; }\n}\ninterface I {\n\tpublic Class getDeclaringClass();\n}\n"}, "");
    }

    public void test0279() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements ISomething {\n    public Class getSomething() { return null; }\n}\nclass Y {}\ninterface ISomething {\n    public Class<? extends Y> getSomething();\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic Class getSomething() { return null; }\n\t       ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tpublic Class getSomething() { return null; }\n\t       ^^^^^\nType safety: The return type Class for getSomething() from the type X needs unchecked conversion to conform to Class<? extends Y> from the type ISomething\n----------\n");
    }

    public void test0280() {
        this.runConformTest(new String[]{"X.java", "interface X<T1 extends Y<T2>, T2 extends Z> {}\ninterface Y<T3 extends Z> {}\ninterface Z {}\n"}, "");
    }

    public void test0281() {
        this.runNegativeTest(new String[]{"X.java", "interface X<T1 extends Y<T2>, T2 extends Z> {}\ninterface Y<T3 extends Comparable> {}\ninterface Z {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface X<T1 extends Y<T2>, T2 extends Z> {}\n\t                         ^^\nBound mismatch: The type T2 is not a valid substitute for the bounded parameter <T3 extends Comparable> of the type Y<T3>\n----------\n2. WARNING in X.java (at line 2)\n\tinterface Y<T3 extends Comparable> {}\n\t                       ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test0282() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y.Member<String> {}\nclass Y { static class Member<T> {} }\n"}, "");
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic class X extends p1.Y.Member<String> {}\nclass Y { static class Member<T> {} }\n"}, "");
    }

    public void test0283() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y.Missing<String> {}\nclass Y { static class Member<T> {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y.Missing<String> {}\n\t                       ^^^^^^^^^\nY.Missing cannot be resolved to a type\n----------\n");
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic class X extends Y.Missing<String> {}\nclass Y { static class Member<T> {} }\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic class X extends Y.Missing<String> {}\n\t                       ^^^^^^^^^\nY.Missing cannot be resolved to a type\n----------\n");
    }

    public void test0284() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\npublic class A <T1 extends A<T1, T2>, T2 extends B<T1, T2>> {\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n", "p1/B.java", "package p1;\npublic class B <T3 extends A<T3, T4>, T4 extends B<T3, T4>> {}\n"}, "SUCCESS");
        this.runConformTest(new String[]{"p1/A.java", "package p1;\npublic class A <T1 extends B<T1, T2>, T2 extends A<T1, T2>> {\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n", "p1/B.java", "package p1;\npublic class B <T3 extends B<T3, T4>, T4 extends A<T3, T4>> {}\n"}, "SUCCESS");
    }

    public void test0285() {
        this.runConformTest(new String[]{"X.java", "import java.util.Vector;\npublic class X {\n  public static void main(String[] args){\n    Vector<Integer[]> v = new Vector<Integer[]>();\n    Integer[] array1 = new Integer[5];\n    array1[0] = new Integer(17);\n    array1[1] = new Integer(42);\n    v.add(array1);\n    Integer twentyfour = v.get(0)[1];  // responsible for the crash\n    System.out.println(twentyfour);\n  }\n}"}, "42");
    }

    public void test0286() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t<T extends Object> T foo(Class<T> c) {return null;}\n}\nclass Y extends X {\n\t<T extends Object> T foo(Class<T> c) {return null;}\n}"}, "");
    }

    public void test0287() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\n\tpublic class A <U> {\n\t\t\n\t\tpublic class B <V> {\n\t\t\t\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\t\n\t\tX.A.B<String> bs;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tX.A.B<String> bs;\n\t^^^^^\nThe member type X.A.B<String> must be qualified with a parameterized type, since it is not static\n----------\n");
    }

    public void test0288() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\n\tpublic static class A <U> {\n\t\t\n\t\tpublic static class B <V> {\n\t\t\t\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\t\n\t\tX.A.B<String> bs;\n\t}\n}\n"}, "");
    }

    public void test0289() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\n\tpublic class A <U> {\n\t\t\n\t\tpublic class B <V> {\n\t\t\t\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\t\n\t\tX<String>.A.B<String> bs;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tX<String>.A.B<String> bs;\n\t^^^^^^^^^^^\nThe member type X<String>.A must be parameterized, since it is qualified with a parameterized type\n----------\n");
    }

    public void test0290() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\n\tpublic static class A <U> {\n\t\t\n\t\tpublic class B <V> {\n\t\t\t\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\t\n\t\tX<String>.A.B<String> bs;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tX<String>.A.B<String> bs;\n\t^^^^^^^^^^^\nThe member type X<String>.A cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type X<String>\n----------\n");
    }

    public void test0291() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T extends Iterable>{\n\tclass MX<U extends Iterable> {\n\t}\n}\nclass SX extends X<Thread>.MX<Object> {\n\tSX(X x){\n\t\tx.super();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T extends Iterable>{\n\t                          ^^^^^^^^\nIterable is a raw type. References to generic type Iterable<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tclass MX<U extends Iterable> {\n\t                   ^^^^^^^^\nIterable is a raw type. References to generic type Iterable<T> should be parameterized\n----------\n3. ERROR in X.java (at line 5)\n\tclass SX extends X<Thread>.MX<Object> {\n\t                   ^^^^^^\nBound mismatch: The type Thread is not a valid substitute for the bounded parameter <T extends Iterable> of the type X<T>\n----------\n4. ERROR in X.java (at line 5)\n\tclass SX extends X<Thread>.MX<Object> {\n\t                              ^^^^^^\nBound mismatch: The type Object is not a valid substitute for the bounded parameter <U extends Iterable> of the type X<T>.MX<U>\n----------\n5. WARNING in X.java (at line 6)\n\tSX(X x){\n\t   ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test0292() {
        this.runConformTest(new String[]{"X.java", "public class X <T> {\n\tclass Y {\n\t\tclass Z<U> {\n\t\t}\n\t}\n    public static void main(String[] args) {\n\t\tX<Object>.Y.Z<Object> zo;\n\t}\n}\n"}, "");
    }

    public void test0293() {
        this.runConformTest(new String[]{"B.java", "public class B<X>{\n    public B(X str,D dValue){}\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n", "D.java", "public class D<Y>{}\n"}, "SUCCESS");
        this.runConformTest(new String[]{"C.java", "public class C<Z,Y> {\n    public B<Z> test(Z zValue,D<Y> yValue){ return new B<Z>(zValue,yValue); }\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test0294() {
        this.runConformTest(new String[]{"B.java", "public class B<X>{\n    public B(X str, B<D> dValue){}\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n", "D.java", "public class D<Y>{}\n"}, "SUCCESS");
        this.runNegativeTest(new String[]{"C.java", "public class C<Z,Y> {\n    public B<Z> test(Z zValue,B<D<Y>> yValue){ return new B<Z>(zValue,yValue); }\n}\n"}, "----------\n1. ERROR in C.java (at line 2)\n\tpublic B<Z> test(Z zValue,B<D<Y>> yValue){ return new B<Z>(zValue,yValue); }\n\t                                                  ^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor B<Z>(Z, B<D<Y>>) is undefined\n----------\n", null, false, null);
    }

    public void test0295() {
        this.runNegativeTest(new String[]{"C.java", "public class C<U> {\n\n\tvoid bar() {\n\t\tnew B().start().get(new B().start()).get(new B().start());\n\t}\n}\n", "B.java", "public class B<X>{\n\tX get(B<X> bx) { return null; }\n\tB<B<D>> start() { return null; }\n}", "D.java", "public class D<Y>{}\n"}, "----------\n1. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method get(B) belongs to the raw type B. References to generic type B<X> should be parameterized\n----------\n2. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t    ^\nB is a raw type. References to generic type B<X> should be parameterized\n----------\n3. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t                        ^\nB is a raw type. References to generic type B<X> should be parameterized\n----------\n4. ERROR in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t                                     ^^^\nThe method get(B) is undefined for the type Object\n----------\n5. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t                                             ^\nB is a raw type. References to generic type B<X> should be parameterized\n----------\n----------\n1. WARNING in B.java (at line 3)\n\tB<B<D>> start() { return null; }\n\t    ^\nD is a raw type. References to generic type D<Y> should be parameterized\n----------\n");
    }

    public void test0296() {
        this.runNegativeTest(new String[]{"C.java", "public class C<U> {\n\n\tvoid bar() {\n\t\tnew B().start().get(new B().start()).get(new B().start());\n\t}\n}\n", "B.java", "public class B<X>{\n\tX get(B<X> bx) { return null; }\n\tstatic B<B<D>> start() { return null; }\n}", "D.java", "public class D<Y>{}\n"}, "----------\n1. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t^^^^^^^^^^^^^^^\nThe static method start() from the type B should be accessed in a static way\n----------\n2. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t    ^\nB is a raw type. References to generic type B<X> should be parameterized\n----------\n3. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t                    ^^^^^^^^^^^^^^^\nThe static method start() from the type B should be accessed in a static way\n----------\n4. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t                        ^\nB is a raw type. References to generic type B<X> should be parameterized\n----------\n5. ERROR in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t                                     ^^^\nThe method get(B<D>) in the type B<D> is not applicable for the arguments (B<B<D>>)\n----------\n6. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t                                         ^^^^^^^^^^^^^^^\nThe static method start() from the type B should be accessed in a static way\n----------\n7. WARNING in C.java (at line 4)\n\tnew B().start().get(new B().start()).get(new B().start());\n\t                                             ^\nB is a raw type. References to generic type B<X> should be parameterized\n----------\n----------\n1. WARNING in B.java (at line 3)\n\tstatic B<B<D>> start() { return null; }\n\t           ^\nD is a raw type. References to generic type D<Y> should be parameterized\n----------\n");
    }

    public void test0297() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Iterator;\nimport java.util.Map;\n\npublic class X {\n\t\t public static void main(String[] args) {\n\t\t \t\t Map<String, String> map = new HashMap<String, String>();\n\t\t \t\t \n\t\t \t\t map.put(\"foo\", \"bar\");\n\t\t \t\t \n\t\t \t\t // Error reported on the following line\n\t\t \t\t Iterator<Map.Entry<String,String>> i = map.entrySet().iterator();\n\t\t \t\t while (i.hasNext()) {\n\t\t \t\t \t\t Map.Entry<String, String> entry = i.next();\n\t\t \t\t \t\t System.out.println(entry.getKey() + \", \" + entry.getValue());\n\t\t \t\t }\n\t\t }\n}\n"}, "foo, bar");
    }

    public void test0298() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.Map;\nimport java.util.Set;\n\npublic class X<V> implements Map<String, V> {\n   private Map<String, V> backingMap;\n   public int size() { return 0; }\n   public boolean isEmpty() { return false; }\n   public boolean containsKey(Object key) { return false; }\n   public boolean containsValue(Object value) { return false; }\n   public V get(Object key) { return null; }\n   public V put(String key, V value) { return null; }\n   public V remove(Object key) { return null; }\n   public void clear() { }\n   public Set<String> keySet() { return null; }\n   public Collection<V> values() { return null; }\n   public void putAll(Map<String, ? extends V> t) { }\n   public Set<Map.Entry<String, V>> entrySet() {\n      return this.backingMap.entrySet();\n   }\n" + MAP_IMPL_JRE8.replaceAll("\\*", "String").replaceAll("\\%", "V") + "}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic class X<V> implements Map<String, V> {\n\t             ^\nThe type X<V> must implement the inherited abstract method Map<String,V>.putAll(Map<? extends String,? extends V>)\n----------\n2. ERROR in X.java (at line 17)\n\tpublic void putAll(Map<String, ? extends V> t) { }\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method putAll(Map<String,? extends V>) of type X<V> has the same erasure as putAll(Map<? extends K,? extends V>) of type Map<K,V> but does not override it\n----------\n");
        this.runConformTest(new String[]{"X.java", "public abstract class X<S, V> implements java.util.Map<Object, Object> {\n   public void putAll(java.util.Map<?, ?> t) { }\n}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "public abstract class X<S, V> implements java.util.Map<S, V> {\n   public void putAll(java.util.Map<? extends String, ? extends V> t) { }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void putAll(java.util.Map<? extends String, ? extends V> t) { }\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method putAll(Map<? extends String,? extends V>) of type X<S,V> has the same erasure as putAll(Map<? extends K,? extends V>) of type Map<K,V> but does not override it\n----------\n");
    }

    public void test0299() {
        this.runConformTest(new String[]{"X.java", "public class X {\n public static void main(String argv[]) {\n \tSystem.out.println(Boolean.class == boolean.class ? \"FAILED\" : \"SUCCESS\");\n }\n}\n"}, "SUCCESS");
    }

    public void test0300() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static interface I extends Visitible<I> {\n    }\n    static interface Visitible<T> {\n        void acceptVisitor(Visitor<? super T> visitor);\n    }\n    static interface Visitor<T> {\n        void visit(T t);\n    }\n    static class C implements I {\n        public void acceptVisitor(Visitor<? super I> visitor) {\n            visitor.visit(this); // should be ok\n            visitor.visit((I) this); // (2) This is a workaround\n        }\n    }\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0301() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tpublic static void reverse(List<?> list) { \n\t\trev(list);\n\t}\n\tprivate static <T> void rev(List<T> list) {\n\t}\n\tZork foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tZork foo() {\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0302() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Enumeration;\nimport java.util.Iterator;\nimport java.util.List;\npublic class X {\n\tpublic void test02() {\n\t\tList<String> l= new ArrayList<String>();\n\t\tfor (Iterator<String> i= l.iterator(); i.next(); ) {\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tfor (Iterator<String> i= l.iterator(); i.next(); ) {\n\t                                       ^^^^^^^^\nType mismatch: cannot convert from String to boolean\n----------\n");
    }

    public void test0303() {
        this.runConformTest(new String[]{"X.java", "public  class X {\n  \tpublic static void main(String[] args) {\n  \t\tY<String> ys = new Y<String>();\n\t    Y<String>.Member m = ys.new Member();\n\t    m.foo();\n  \t}    \n  }\n  class Y<T> {\n    class Member {\n    \tvoid foo(){\n    \t\tSystem.out.println(\"SUCCESS\");\n    \t}\n    }\n  }\n\n"}, "SUCCESS");
    }

    public void test0304() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends Y> {}\nclass Y extends X {}"}, "");
    }

    public void test0305() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n  \tT x;\n  \t<U extends T> T foo(U u) { return u; }\n}\n"}, "");
    }

    public void test0306() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends X<T>> {\n  \tstatic int CONSTANT = 1;\n  \tprivate int i = 1;\n  \tprivate int i() {return i;}\n  \tprivate static class M { private static int j = 2; }\n  \tpublic int foo(T t) { return t.i + t.i() + T.M.j; }\n  \tpublic int foo2(T t) { return T.CONSTANT; }\n}\nclass Y extends Zork {\n}\n"}, this.complianceLevel <= 0x320000L ? "----------\n1. WARNING in X.java (at line 6)\n\tpublic int foo(T t) { return t.i + t.i() + T.M.j; }\n\t                                           ^^^^^\nRead access to enclosing field X<T>.M.j is emulated by a synthetic accessor method\n----------\n2. ERROR in X.java (at line 9)\n\tclass Y extends Zork {\n\t                ^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 6)\n\tpublic int foo(T t) { return t.i + t.i() + T.M.j; }\n\t                               ^\nThe field X<T>.i is not visible\n----------\n2. ERROR in X.java (at line 6)\n\tpublic int foo(T t) { return t.i + t.i() + T.M.j; }\n\t                                     ^\nThe method i() from the type X<T> is not visible\n----------\n3. ERROR in X.java (at line 6)\n\tpublic int foo(T t) { return t.i + t.i() + T.M.j; }\n\t                                           ^^^\nThe type T.M is not visible\n----------\n4. ERROR in X.java (at line 9)\n\tclass Y extends Zork {\n\t                ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0307() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic <T> T foo(T t1, T t2){ return t1; }\n\tpublic static void main(String[] args) {\n\t\tIX s = null;\n\t\t foo(new Object(), s);\n\t}\n}\ninterface IX {}\n"}, "");
    }

    public void test0308() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X<T> {\n\tclass Member {}\n}\n", "p/Y.java", "package p;\npublic class Y {\n\tp.X.Member m;\n\tp.X<String>.Member ms = m;\n}\n"});
    }

    public void test0309() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X<T> {\n\tclass Member {\n\t\tclass Sub {}\n\t}\n}\n", "p/Y.java", "package p;\npublic class Y {\n\tp.X.Member.Sub s;\n\tp.X<Exception>.Member.Sub es = s;\n}\n"});
    }

    public void test0310() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X extends X2 {\n\tvoid foo(List<X> lx) { }\n}\n\nabstract class X2 {\n\tvoid foo(List<Object> lo) { }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo(List<X> lx) { }\n\t     ^^^^^^^^^^^^^^^\nName clash: The method foo(List<X>) of type X has the same erasure as foo(List<Object>) of type X2 but does not override it\n----------\n");
    }

    public void test0311() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X extends X2 {\n\tvoid foo(List<X> lx) { }\n\tvoid bar(){\n\t\tthis.foo((List)null);\n\t}\n}\n\nabstract class X2 {\n\tvoid foo(List<Object> lo) { }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo(List<X> lx) { }\n\t     ^^^^^^^^^^^^^^^\nName clash: The method foo(List<X>) of type X has the same erasure as foo(List<Object>) of type X2 but does not override it\n----------\n2. ERROR in X.java (at line 5)\n\tthis.foo((List)null);\n\t     ^^^\nThe method foo(List<X>) is ambiguous for the type X\n----------\n3. WARNING in X.java (at line 5)\n\tthis.foo((List)null);\n\t          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test0312() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X extends X2 {\n\tvoid foo(List<X> lx) { }\n}\n\nabstract class X2 {\n\tfinal void foo(List<Object> lo) { }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo(List<X> lx) { }\n\t     ^^^^^^^^^^^^^^^\nName clash: The method foo(List<X>) of type X has the same erasure as foo(List<Object>) of type X2 but does not override it\n----------\n");
    }

    public void test0313() {
        this.runConformTest(new String[]{"X.java", "import java.net.Inet6Address;\nimport java.net.InetAddress;\nimport java.util.AbstractList;\nimport java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\nvoid takeAbstract(AbstractList<? extends InetAddress> arg) { }\n\nvoid takeList(List<? extends InetAddress> arg) { }\n\nvoid construct() {\n\tAbstractList<InetAddress> a= new ArrayList<InetAddress>();\n\ttakeAbstract(a);\n\ttakeAbstract(new ArrayList<InetAddress>()); // a inlined: error 1:\n//The method takeAbstract(AbstractList<? extends InetAddress>) in the type A\n// is not applicable for the arguments (ArrayList<InetAddress>)\n\t\n\tList<InetAddress> l= new ArrayList<InetAddress>();\n\ttakeList(l);\n\ttakeList(new ArrayList<InetAddress>()); // l inlined: ok\n\t\n\tArrayList<? extends InetAddress> aw= new ArrayList<InetAddress>();\n\ttakeAbstract(aw);\n\ttakeAbstract(new ArrayList<Inet6Address>()); // aw inlined: error 2:\n//The method takeAbstract(AbstractList<? extends InetAddress>) in the type A\n// is not applicable for the arguments (ArrayList<Inet6Address>)\n\n\ttakeList(aw);\n\ttakeList(new ArrayList<Inet6Address>()); //aw inlined: ok\n}\n}"}, "");
    }

    public void test0314() {
        this.runConformTest(new String[]{"X.java", "public class X <E> {\n\tstatic class XMember<F> {}\n\n\t// with toplevel element type\n\tvoid foo() {\n\t\tXIter<XElement<E>> iter = fooSet().iterator();\n\t}\n\tXSet<XElement<E>> fooSet()\t { return null; }\n\n\t// with member element type\n\tvoid bar() {\n\t\tXIter<XMember<E>> iter = barSet().iterator();\n\t}\n\tXSet<XMember<E>> barSet()\t { return null; }\n\n\t\n}\n\nclass XSet<G> {\n\tXIter<G> iterator() { return null; }\n}\nclass XIter<H> {\n}\nclass XElement<I> {\n}\n"}, "");
    }

    public void test0315() {
        this.runConformTest(new String[]{"X.java", "public class X <E> {\n\tstatic class XMember<F> {}\n\n\t// with member element type\n\tvoid bar() {\n\t\tXIter<X.XMember<E>> iter = barSet().iterator();\n\t}\n\tXSet<XMember<E>> barSet()\t { return null; }\n\n\t\n}\n\nclass XSet<G> {\n\tXIter<G> iterator() { return null; }\n}\nclass XIter<H> {\n}\nclass XElement<I> {\n}\n"}, "");
    }

    public void test0316() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X <E extends List & Runnable> {\n\t\n\tE element() { return null; }\n\t\n\tvoid bar(X<E> xe) {\n\t\txe.element().add(this);\n\t\txe.element().run();\n\t}\n\tvoid foo(X<?> xe) {\n\t\txe.element().add(this);\n\t\txe.element().run();\n\t}\n\tvoid baz(X<? extends XM> xe) {\n\t\txe.element().add(this);\n\t\txe.element().run();\n\t}\n\tabstract class XM implements List, Runnable {}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic class X <E extends List & Runnable> {\n\t                          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\txe.element().add(this);\n\t^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 12)\n\txe.element().add(this);\n\t^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n4. WARNING in X.java (at line 16)\n\txe.element().add(this);\n\t^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n5. WARNING in X.java (at line 19)\n\tabstract class XM implements List, Runnable {}\n\t                             ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n6. ERROR in X.java (at line 20)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0317() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X <E extends List & Runnable> {\n\t\n\tE element() { return null; }\n\t\n\tvoid foo(X<? extends XI> xe) {\n\t\txe.element().add(this);\n\t\txe.element().run();\n\t}\n\tvoid baz(X<? extends XM> xe) {\n\t\txe.element().add(this);\n\t\txe.element().run();\n\t}\n\tinterface XI extends Runnable {}\n\t\n\tclass XM {\n\t\tvoid foo() {}\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic class X <E extends List & Runnable> {\n\t                          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\txe.element().add(this);\n\t^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 12)\n\txe.element().add(this);\n\t^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n4. ERROR in X.java (at line 20)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0318() {
        this.runConformTest(new String[]{"MyCache.java", "class Cache<K, V> {\n}\n\nclass Index<K, V> {\n  public Index(Cache<?, V> parentCache) {\n  }\n}\n\npublic class MyCache extends Cache<Integer, String> {\n  class AnIndex extends Index<String, String> {\n    public AnIndex() {\n      super(MyCache.this); // <-- Eclipse cannot find the constructor!\n    }\n  }\n}\n"}, "");
    }

    public void test0319() {
        this.runConformTest(new String[]{"test/Test1.java", "package test;\n\nclass A<BB extends B>\n{}\n\nclass B<AA extends A>\n{}\n\npublic interface Test1<C extends B<?>, D extends A<?>>\n{}\n\nclass AbstractA extends A<AbstractB> {};\nclass AbstractB extends B<AbstractA> {};\n\nclass Test2<E extends AbstractB, F extends AbstractA> implements Test1<E, F>\n{}"}, "");
    }

    public void test0320() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nclass TestElement extends ArrayList implements Runnable {\n  public void run() {\n  }\n}\npublic class X <E extends List & Runnable> {\n  public X(E element) {\n    element.run();\n  }\n  public static void main(String[] args) {\n    new X<TestElement>(new TestElement());\n    System.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS");
    }

    public void test0321() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nclass TestElement extends ArrayList implements Runnable {\n  static final long serialVersionUID = 1l;\n  public void run() {\n  \t// empty\n  }\n}\npublic class X <E extends List & Runnable> {\n\tE element;\n  public X(E element) {\n  \tthis.element = element;\n    element.run();\n  }\n  public X(X<?> x) {\n    x.element.run();\n  }\n  public static void main(String[] args) {\n    new X<TestElement>(new TestElement());\n    System.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS");
    }

    public void test0322() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X<A> {\n\n  A v2;\n  X(A a) { v2 = a; }\n  \n  void func() {\n    List<B<A>> l = new ArrayList<B<A>>();\n  }\n\n  class B<T> {\n    T v1;\n    B(T b) {  v1 = b; }\n  }\n  \n}\n"}, "");
    }

    public void test0323() {
        this.runNegativeTest(new String[]{"X.java", "class G<T> {\n\tclass Member {}\n}\npublic class X {\n\tG<String> g = new G();\n\tG<String>.Member gsm = g.new Member();\n\tG.Member gm = null;\n\tG<Thread>.Member gtm = gm;\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tG<String> g = new G();\n\t              ^^^^^^^\nType safety: The expression of type G needs unchecked conversion to conform to G<String>\n----------\n2. WARNING in X.java (at line 5)\n\tG<String> g = new G();\n\t                  ^\nG is a raw type. References to generic type G<T> should be parameterized\n----------\n3. WARNING in X.java (at line 7)\n\tG.Member gm = null;\n\t^^^^^^^^\nG.Member is a raw type. References to generic type G<T>.Member should be parameterized\n----------\n4. WARNING in X.java (at line 8)\n\tG<Thread>.Member gtm = gm;\n\t                       ^^\nType safety: The expression of type G.Member needs unchecked conversion to conform to G<Thread>.Member\n----------\n5. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0324() {
        this.runConformTest(new String[]{"X.java", "import java.util.Iterator;\nimport java.util.Set;\n\npublic class X<E> {\n   private TreeNode<E> root;\n\n   public void doSomething() {\n      for (TreeNode<E> child : root.children()) {\n         // root.children() should work??\n      }\n   }\n\n   public void doSomethingElse() {\n      for (Iterator<TreeNode<E>> it = root.children().iterator(); it.hasNext();) {\n         // this also should work\n      }\n   }\n}\n\nclass TreeNode<E> {\n   private Set<TreeNode<E>> children;\n   \n   public Set<TreeNode<E>> children() {\n      return children;\n   }\n}\n"}, "");
    }

    public void test0325() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n\tvoid foo1() {\n\t\tX<String>.Item<Thread> i = new X<Exception>().new Item<Thread>();\n\t}\n\tvoid foo2() {\n\t\tX<Exception>.Item<Thread> j = new X<Exception>.Item<Thread>();\n\t}\n\tvoid foo3() {\n\t\tX.Item k = new X.Item();\n\t}\n\tstatic void foo4() {\n\t\tX.Item k = new X.Item();\n\t}\n\tclass Item <E> {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX<String>.Item<Thread> i = new X<Exception>().new Item<Thread>();\n\t                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X<Exception>.Item<Thread> to X<String>.Item<Thread>\n----------\n2. ERROR in X.java (at line 6)\n\tX<Exception>.Item<Thread> j = new X<Exception>.Item<Thread>();\n\t                                  ^^^^^^^^^^^^^^^^^\nCannot allocate the member type X<Exception>.Item<Thread> using a parameterized compound name; use its simple name and an enclosing instance of type X<Exception>\n----------\n3. WARNING in X.java (at line 9)\n\tX.Item k = new X.Item();\n\t^^^^^^\nX.Item is a raw type. References to generic type X<T>.Item<E> should be parameterized\n----------\n4. WARNING in X.java (at line 9)\n\tX.Item k = new X.Item();\n\t               ^^^^^^\nX.Item is a raw type. References to generic type X<T>.Item<E> should be parameterized\n----------\n5. WARNING in X.java (at line 12)\n\tX.Item k = new X.Item();\n\t^^^^^^\nX.Item is a raw type. References to generic type X<T>.Item<E> should be parameterized\n----------\n6. ERROR in X.java (at line 12)\n\tX.Item k = new X.Item();\n\t           ^^^^^^^^^^^^\nNo enclosing instance of type X<T> is accessible. Must qualify the allocation with an enclosing instance of type X<T> (e.g. x.new A() where x is an instance of X<T>).\n----------\n7. WARNING in X.java (at line 12)\n\tX.Item k = new X.Item();\n\t               ^^^^^^\nX.Item is a raw type. References to generic type X<T>.Item<E> should be parameterized\n----------\n");
    }

    public void test0326() {
        this.runConformTest(new String[]{"X.java", "public class X<T> implements I<T> {\n    public I.A foo() {\n        return a;\n    }\n}    \ninterface I<T> {\n    A a = new A();\n    class A {\n    }\n}\n\nclass XM<T> {\n    A a = new A();\n    class A {\n    }\n}\t\n\nclass XMSub<T> extends XM<T> {\n    public XM.A foo() {\n        return a;\n    }\n}    \n\n"}, "");
    }

    public void test0327() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends IFoo> {\n\t\n\tT element() { return null; }\n\tvoid baz(X<? extends IBar> x) {\n\t\tx.element().foo();\n\t\tx.element().bar();\n\t}\n}\ninterface IFoo {\n\tvoid foo();\n}\ninterface IBar {\n\tvoid bar();\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0328() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends IFoo> {\n\tT element;\n\tX(T element) { \n\t\tthis.element = element; \n\t}\n\tstatic void baz(X<? extends IBar> x) {\n\t\tx.element.foo();\n\t\tx.element.bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<Foo> x1 = new X<Foo>(new Foo());\n\t\tbaz(x1);\n\t\tX<Bar> x2 = new X<Bar>(new Bar());\n\t\tbaz(x2);\n\t\tX<FooBar> x3 = new X<FooBar>(new FooBar());\n\t\tbaz(x3);\n\t}\n}\ninterface IFoo {\n\tvoid foo();\n}\ninterface IBar {\n\tvoid bar();\n}\nclass Foo implements IFoo {\n\tpublic void foo() {\n\t\tSystem.out.print(\"FOO\");\n\t}\n}\nclass Bar implements IBar {\n\tpublic void bar() {\n\t\tSystem.out.print(\"BAR\");\n\t}\n}\nclass FooBar extends Foo implements IBar {\n\tpublic void bar() {\n\t\tSystem.out.print(\"BAR\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tbaz(x1);\n\t^^^\nThe method baz(X<? extends IBar>) in the type X<T> is not applicable for the arguments (X<Foo>)\n----------\n2. ERROR in X.java (at line 13)\n\tX<Bar> x2 = new X<Bar>(new Bar());\n\t  ^^^\nBound mismatch: The type Bar is not a valid substitute for the bounded parameter <T extends IFoo> of the type X<T>\n----------\n3. ERROR in X.java (at line 13)\n\tX<Bar> x2 = new X<Bar>(new Bar());\n\t                  ^^^\nBound mismatch: The type Bar is not a valid substitute for the bounded parameter <T extends IFoo> of the type X<T>\n----------\n");
    }

    public void test0329() {
        this.runConformTest(true, new String[]{"X.java", "public class X<T extends IFoo> {\n\tT element;\n\tX(T element) { \n\t\tthis.element = element; \n\t}\n\tstatic void baz(X<? extends IBar> x) {\n\t\tx.element.foo();\n\t\tx.element.bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<FooBar> x3 = new X<FooBar>(new FooBar());\n\t\tbaz(x3);\n\t}\n}\ninterface IFoo {\n\tvoid foo();\n}\ninterface IBar {\n\tvoid bar();\n}\nclass FooBar implements IFoo, IBar {\n\tpublic void foo() {\n\t\tSystem.out.print(\"FOO\");\n\t}\n\tpublic void bar() {\n\t\tSystem.out.print(\"BAR\");\n\t}\n}\n"}, null, "FOOBAR", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0330() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends Foo> {\n\tT element;\n\tX(T element) { \n\t\tthis.element = element; \n\t}\n\tstatic void baz(X<? extends FooBar> x) {\n\t\tx.element.foo();\n\t\tx.element.bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<FooBar> x3 = new X<FooBar>(new FooBar());\n\t\tbaz(x3);\n\t}\n}\ninterface IBar {\n\tvoid bar();\n}\nclass Foo {\n\tpublic void foo() {\n\t\tSystem.out.print(\"FOO\");\n\t}\n}\nclass FooBar extends Foo implements IBar {\n\tpublic void bar() {\n\t\tSystem.out.print(\"BAR\");\n\t}\n}\n"}, "FOOBAR");
    }

    public void test0331() {
        this.runConformTest(true, new String[]{"X.java", "public class X<T extends Foo> {\n\tT element;\n\tX(T element) { \n\t\tthis.element = element; \n\t}\n\tstatic void baz(X<? extends IBar> x) {\n\t\tx.element.foo();\n\t\tx.element.bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<FooBar> x3 = new X<FooBar>(new FooBar());\n\t\tbaz(x3);\n\t}\n}\ninterface IBar {\n\tvoid bar();\n}\nclass Foo {\n\tpublic void foo() {\n\t\tSystem.out.print(\"FOO\");\n\t}\n}\nclass FooBar extends Foo implements IBar {\n\tpublic void bar() {\n\t\tSystem.out.print(\"BAR\");\n\t}\n}\n"}, null, "FOOBAR", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0332() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Foo> {\n\tT element;\n\tX(T element) { \n\t\tthis.element = element; \n\t}\n\tstatic void baz(X<? extends IBar> x) {\n\t\tx.element.foo();\n\t\tx.element.bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tbaz(new X<FooBar>(new FooBar()));\n\t\tbaz(new X<Bar>(new Bar()));\n\t}\n}\ninterface IBar {\n\tvoid bar();\n}\n\nclass Bar implements IBar {\n\tpublic void bar() {\n\t\tSystem.out.print(\"BAR\");\n\t}\n}\n\nclass Foo {\n\tpublic void foo() {\n\t\tSystem.out.print(\"FOO\");\n\t}\n}\n\nclass FooBar extends Foo implements IBar {\n\tpublic void bar() {\n\t\tSystem.out.print(\"BAR\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tbaz(new X<Bar>(new Bar()));\n\t          ^^^\nBound mismatch: The type Bar is not a valid substitute for the bounded parameter <T extends Foo> of the type X<T>\n----------\n");
    }

    public void test0333() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tT element;\n\tX(T element) { this.element = element; }\n\tT element() { return this.element; }\n\tpublic static void main(String[] args) {\n\t\tnew X<XB>(new XB()).element().afoo();\n\t}\n}\n\nclass XA {\n\tvoid afoo() {\n\t\tSystem.out.println(\"SUCCESS\");\n   }\n}\nclass XB extends XA {\n\tvoid bfoo() {}\n}\n"}, "SUCCESS");
    }

    public void test0334() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E> {\n  public X() {\n  \tnew E();\n  \tnew E() {\n  \t\tvoid perform() {\n  \t\t\trun();\n  \t\t}\n  \t}.perform();\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew E();\n\t    ^\nCannot instantiate the type E\n----------\n2. ERROR in X.java (at line 4)\n\tnew E() {\n  \t\tvoid perform() {\n  \t\t\trun();\n  \t\t}\n  \t}.perform();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot refer to the type parameter E as a supertype\n----------\n");
    }

    public void test0335() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E extends String> {\n  public X() {\n  \tnew E();\n  \tnew E() {\n  \t\tvoid perform() {\n  \t\t\trun();\n  \t\t}\n  \t}.perform();\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <E extends String> {\n\t                          ^^^^^^\nThe type parameter E should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 3)\n\tnew E();\n\t    ^\nCannot instantiate the type E\n----------\n3. ERROR in X.java (at line 4)\n\tnew E() {\n  \t\tvoid perform() {\n  \t\t\trun();\n  \t\t}\n  \t}.perform();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot refer to the type parameter E as a supertype\n----------\n");
    }

    public void test0336() {
        this.runNegativeTest(new String[]{"X.java", "interface IMyInterface {\n}\nclass MyClass <Type> {\n\n\tpublic <Type> Type myMethod(Object obj, Class type) {\n\t\treturn null;\n\t}\n\tpublic static <Type> Type myStaticMethod(Object obj, Class type) {\n\t\treturn null;\n\t}\n}\npublic class X {\n    public IMyInterface getThis() {\n\t\tif (true)\n\t\t\treturn new MyClass().myMethod(this, IMyInterface.class);\n\t\telse\n\t\t\treturn MyClass.myStaticMethod(this, IMyInterface.class);\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic <Type> Type myMethod(Object obj, Class type) {\n\t        ^^^^\nThe type parameter Type is hiding the type Type\n----------\n2. WARNING in X.java (at line 5)\n\tpublic <Type> Type myMethod(Object obj, Class type) {\n\t                                        ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n3. WARNING in X.java (at line 8)\n\tpublic static <Type> Type myStaticMethod(Object obj, Class type) {\n\t                                                     ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n4. ERROR in X.java (at line 15)\n\treturn new MyClass().myMethod(this, IMyInterface.class);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to IMyInterface\n----------\n5. WARNING in X.java (at line 15)\n\treturn new MyClass().myMethod(this, IMyInterface.class);\n\t           ^^^^^^^\nMyClass is a raw type. References to generic type MyClass<Type> should be parameterized\n----------\n");
    }

    public void test0337() {
        this.runConformTest(new String[]{"X.java", "import java.util.Vector;\npublic class X {\n    public void foo() {\n        Vector<Object> objectVector = new Vector<Object>() {\n            protected void bar() {\n                baz(this); /* ERROR */\n            }\n        };\n        baz(objectVector);\n        baz(new Vector<Object>());\n    }\n    public void baz(Vector<?> mysteryVector) { }\n}\n"}, "");
    }

    public void test0338() {
        this.runConformTest(new String[]{"X.java", "interface M<X> { }\n\nclass N<C> { \n  M<N<C>> pni = null;\n}\n\npublic class X<I> {\n  N<I> var1 = null;\n\n  M<N<I>> var2 = var1.pni;\n  // Above line reports as error in Eclipse. \n  // \"var2\" is underlined and the error message is: \n  // Type mismatch: cannot convert from M<N<C>> to M<N<I>>\n}\n"}, "");
    }

    public void test0339() {
        this.runConformTest(new String[]{"X.java", "import java.util.Iterator;\nimport java.util.Set;\n\nclass X <K, V> {\n\tstatic class Entry<K, V> {}\n\tvoid foo() {\n\t\tIterator<Entry<K,V>> i = entrySet().iterator();\n\t}\n\tSet<Entry<K,V>> entrySet()\t { return null; }\n}\n"}, "");
    }

    public void test0340() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tprivate T data;\n\tprivate X(T data){ this.data=data; }\n\tpublic static <S> X<S> createObject(S data){\n\t\tSystem.out.println(data);\n\t\treturn new X<S>(data);\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> res=X.createObject(\"Hallo\");\n\t}\n}\n"}, "Hallo");
    }

    public void test0341() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic Object getItem() { return null; }\n}\n", "Y.java", "public class Y extends X {\n\tpublic String getItem() { return null; }\n}\n", "Z.java", "public class Z extends X {\n\tpublic Comparable getItem() { return null; }\n}\n"}, "");
    }

    public void test0342() {
        this.runNegativeTest(new String[]{"Test.java", "class MyClass<T> {\n\t\t \n\t\t private T thing;\n       { Zork z; }\n\t\t \n\t\t public\n\t\t MyClass(T thing) {\n\t\t \t\t this.thing = thing;\n\t\t }\n\t\t \n\t\t public static <U> MyClass<U>\n\t\t factoryMakeMyClass(U thing)\t\t {\n\t\t \t\t return new MyClass<U>(thing);\n\t\t }\n}\n\nclass External {\n\n\t\t public static <U> MyClass<U>\n\t\t factoryMakeMyClass(U thing)\t\t {\n\t\t \t\t return new MyClass<U>(thing);\n\t\t }\n}\n\npublic class Test {\n\t\t public static void\n\t\t test()\n\t\t {\n\t\t \t\t // No problem with this line:\n\t\t \t\t MyClass<String> foo = External.factoryMakeMyClass(\"hi\");\n\t\t \t\t \n\t\t \t\t // This line gives me an error:\n\t\t \t\t // Type mismatch: cannot convert from MyClass<Object> to MyClass<String>\n\t\t \t\t MyClass<String> bar = MyClass.factoryMakeMyClass(\"hi\");\n\t\t \t\t MyClass<String> bar2 = MyClass.<String>factoryMakeMyClass(\"hi\");\n\t\t }\n}\n"}, "----------\n1. ERROR in Test.java (at line 4)\n\t{ Zork z; }\n\t  ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0343() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends Number> {\n    T m;\n\n    class Y<T> {\n        void test() {\n            new Y<Integer>() {\n                void test() {\n                    System.out.println(X.this.m);\n                }\n            }.test();\n        }\n    }\n}\n\n"}, "");
    }

    public void test0344() {
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\npublic abstract class X<T extends Runnable> {\n\t\n\tpublic abstract <T extends Exception> T bar(T t);\n\n\tstatic void foo(X x) {\n\t\tx.<Exception>bar(null);\n\t\t\n\t\tclass R implements Runnable {\n\t\t\tpublic void run() {\n\t\t\t}\n\t\t}\n\t\tX<R> xr = new X<R>(){  \n\t\t\tpublic <T> T bar(T t) { \n\t\t\t\treturn t; \n\t\t\t}\n\t\t};\n\t\tIOException e = xr.bar(new IOException());\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic abstract <T extends Exception> T bar(T t);\n\t                 ^\nThe type parameter T is hiding the type T\n----------\n2. WARNING in X.java (at line 7)\n\tstatic void foo(X x) {\n\t                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. ERROR in X.java (at line 8)\n\tx.<Exception>bar(null);\n\t             ^^^\nThe method bar(Exception) of raw type X is no longer generic; it cannot be parameterized with arguments <Exception>\n----------\n4. ERROR in X.java (at line 14)\n\tX<R> xr = new X<R>(){  \n\t              ^^^^^^\nThe type new X<R>(){} must implement the inherited abstract method X<R>.bar(T)\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\npublic abstract class X<T extends Runnable> {\n\t\n\tpublic abstract <T extends Exception> T bar(T t);\n\n\tstatic void foo(X x) {\n\t\tx.<Exception>bar(null);\n\t\t\n\t\tclass R implements Runnable {\n\t\t\tpublic void run() {\n\t\t\t}\n\t\t}\n\t\tX<R> xr = new X<R>(){  \n\t\t\tpublic <T> T bar(T t) { \n\t\t\t\treturn t; \n\t\t\t}\n\t\t};\n\t\tIOException e = xr.bar(new IOException());\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic abstract <T extends Exception> T bar(T t);\n\t                 ^\nThe type parameter T is hiding the type T\n----------\n2. WARNING in X.java (at line 7)\n\tstatic void foo(X x) {\n\t                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 8)\n\tx.<Exception>bar(null);\n\t^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method bar(Exception) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 14)\n\tX<R> xr = new X<R>(){  \n\t              ^^^^^^\nThe type new X<R>(){} must implement the inherited abstract method X<R>.bar(T)\n----------\n");
    }

    public void test0345() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n       X1<Integer> o1 = new X1<Integer>();\n        ((J<Integer>)o1).get();\n    }\n}\n\nclass X1<T> implements I<T> {\n    public X1 get() {\n    \tSystem.out.println(\"SUCCESS\");\n        return this;\n    }\n}\n\ninterface I<T> extends J<T> {\n    I get();\n}\n\ninterface J<T>  {\n    J get();\n}"}, "SUCCESS");
    }

    public void test0346() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n       X1<Integer> o1 = new X1<Integer>(new Integer(4));\n        System.out.println(o1.get().t);\n    }\n}\n\nclass X1<T> implements I<T> {\n    T t;\n    X1(T arg) {\n        t = arg;\n    }\n    public X1 get() {\n        return this;\n    }\n}\n\ninterface I<T> extends J<T> {\n    I get();\n}\n\ninterface J<T>  {\n    J get();\n}"}, "4");
    }

    public void test0347() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n        X1<Integer> o = new X1<Integer>(new Integer(4));\n        System.out.println(o.get().t);\n    }\n}\n\nclass X1<T> implements I<T> {\n    T t;\n    X1(T arg) {\n        t = arg;\n    }\n    public X1 get() {\n        return this;\n    }\n}    \n\ninterface I<T> extends K<T>, L<T> {\n    I get();\n}\n\ninterface J<T>  {\n    J get();\n}\n\ninterface K<T> extends J<T> {\n}\n\ninterface L<T>  {\n    K get();\n}"}, "4");
    }

    public void test0348() {
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\npublic abstract class X<T extends Runnable> {\n\tpublic abstract <T extends Exception> T bar(T t);\n\tstatic void foo(X x) {\n\t\tx.<Exception>bar(null);\n\t\tclass R implements Runnable {\n\t\t\tpublic void run() {}\n\t\t}\n\t\tX<R> xr = new X<R>(){  \n\t\t\tpublic <T extends Exception> T bar(T t) { return t; }\n\t\t};\n\t\tIOException e = xr.bar(new IOException());\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic abstract <T extends Exception> T bar(T t);\n\t                 ^\nThe type parameter T is hiding the type T\n----------\n2. WARNING in X.java (at line 4)\n\tstatic void foo(X x) {\n\t                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. ERROR in X.java (at line 5)\n\tx.<Exception>bar(null);\n\t             ^^^\nThe method bar(Exception) of raw type X is no longer generic; it cannot be parameterized with arguments <Exception>\n----------\n4. WARNING in X.java (at line 10)\n\tpublic <T extends Exception> T bar(T t) { return t; }\n\t                               ^^^^^^^^\nThe method bar(T) of type new X<R>(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236242);
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\npublic abstract class X<T extends Runnable> {\n\tpublic abstract <T extends Exception> T bar(T t);\n\tstatic void foo(X x) {\n\t\tx.<Exception>bar(null);\n\t\tclass R implements Runnable {\n\t\t\tpublic void run() { zork = 0; }\n\t\t}\n\t\tX<R> xr = new X<R>(){  \n\t\t\tpublic <T extends Exception> T bar(T t) { return t; }\n\t\t};\n\t\tIOException e = xr.bar(new IOException());\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic abstract <T extends Exception> T bar(T t);\n\t                 ^\nThe type parameter T is hiding the type T\n----------\n2. WARNING in X.java (at line 4)\n\tstatic void foo(X x) {\n\t                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 5)\n\tx.<Exception>bar(null);\n\t^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method bar(Exception) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 7)\n\tpublic void run() { zork = 0; }\n\t                    ^^^^\nzork cannot be resolved to a variable\n----------\n5. WARNING in X.java (at line 10)\n\tpublic <T extends Exception> T bar(T t) { return t; }\n\t                               ^^^^^^^^\nThe method bar(T) of type new X<R>(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236242);
    }

    public void test0349() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tT element;\n\tstatic void foo(X<? super Exception> out, X1<? extends Exception> in) {\n\t\tout.element = in.element;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\nclass X1<U>{\n\tU element;\n}\n"}, "SUCCESS");
    }

    public void test0350() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tT element;\n\tstatic void foo(X<?> out, X1<?> in) {\n\t\tout.element = in.element;\n\t}\n}\nclass X1<U>{\n\tU element;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tout.element = in.element;\n\t              ^^^^^^^^^^\nType mismatch: cannot convert from capture#2-of ? to capture#1-of ?\n----------\n");
    }

    public void test0351() {
        this.runConformTest(new String[]{"X.java", "interface Intf<D extends Comparable<D>, I extends Comparable<D>> { \n  public void f(Intf<D,?> val);\n}\n\npublic class X <M extends Comparable<M>, P extends Comparable<M>>  implements Intf<M,P> {\n\n  public void f(Intf<M,?> val) { } \n}\n"}, "");
    }

    public void test0352() {
        this.runConformTest(new String[]{"X.java", "interface C<A> { }\ninterface PC<X> extends C<X> { } \ninterface PO<Y>  {  \n\t  C<Y> proc1();\n\t  C<? super Y> proc2();\n\t  C<? extends Y> proc3();\n}\nabstract class X<Z> implements PO<Z> {\n\t  public C<Z> proc1() { return result1; }\n\t  private final PC<Z> result1 = null;\n\t  public C<? super Z> proc2() { return result2; }\n\t  private final PC<? super Z> result2 = null;\n\t  public C<? extends Z> proc3() { return result3; }\n\t  private final PC<? extends Z> result3 = null;\n}\n"}, "");
    }

    public void test0353() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n\t<T> T foo(Class<T> c) { return null; }\n}\nclass Y {\n\t<T> T foo(Class<T> c) { return null; }\n}"}, "");
    }

    public void test0354() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n\t<T, S> S foo(Class<T> c) { return null; }\n}\nclass Y {\n\t<S, T> T foo(Class<S> c) { return null; }\n}"}, "");
    }

    public void test0355() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n\t<T, S> S foo(Class<S> c) { return null; }\n}\nclass Y {\n\t<S, T> S foo(Class<S> c) { return null; }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T, S> S foo(Class<S> c) { return null; }\n\t         ^^^^^^^^^^^^^^^\nName clash: The method foo(Class<S>) of type X has the same erasure as foo(Class<S>) of type Y but does not override it\n----------\n");
    }

    public void test0356() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n\t<T, S> T foo(Class<T> c) { return null; }\n}\nclass Y {\n\t<T> T foo(Class<T> c) { return null; }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T, S> T foo(Class<T> c) { return null; }\n\t         ^^^^^^^^^^^^^^^\nName clash: The method foo(Class<T>) of type X has the same erasure as foo(Class<T>) of type Y but does not override it\n----------\n");
    }

    public void test0357() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n\t<T> T foo(Class<T> c) { return null; }\n}\nclass Y {\n\t<T, S> T foo(Class<T> c) { return null; }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T> T foo(Class<T> c) { return null; }\n\t      ^^^^^^^^^^^^^^^\nName clash: The method foo(Class<T>) of type X has the same erasure as foo(Class<T>) of type Y but does not override it\n----------\n");
    }

    public void test0358() {
        this.runConformTest(new String[]{"MyClass.java", "public class MyClass {}\n", "A.java", "public interface A<M extends MyClass> {}\n", "B.java", "public interface B<M extends MyClass> extends A<M> {}\n", "C.java", "public class C implements B<MyClass> {}\n", "D.java", "public class D implements A<MyClass>{}\n"}, "");
        this.runConformTest(new String[]{"C.java", "public class C implements B<MyClass> {}\n", "D.java", "public class D implements A<MyClass>{}\n"}, "", null, false, null);
    }

    public void test0359() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    class List1<E> extends LinkedList<E> {};\n    public static void main (String[] args) {\n        Map<String, List<Integer>> x = new HashMap<String, List<Integer>>();\n        Map<String, List1<Integer>> m = new HashMap<String, List1<Integer>>();\n    }\n}"});
    }

    public void test0360() {
        this.runConformTest(new String[]{"Test.java", "import java.lang.Comparable;\npublic class Test {\n    private static final class X<T1, T2> implements Comparable<X<T1, T2>> {\n        public int compareTo(X<T1, T2> arg0) { return 0; }\n    };\n    private static class Y<T1, T2> {};\n    private static final class Z<T1, T2> extends Y<T1, T2> implements Comparable<Z<T1, T2>> {\n        public int compareTo(Z<T1, T2> arg0) { return 0; }\n    };\n    public static <T> void doSomething(Comparable<? super T> a, Comparable<? super T> b) {}\n    public static <V1, V2> void doSomethingElse(Z<V1, V2> a, Z<V1, V2> b) {\n        doSomething(a, b);\n    }\n    private static final class W { };\n    public static void main(String[] args) {\n        doSomething(new X<Integer, String>(), new X<Integer, String>());\n        doSomething(new Z<Integer, String>(), new Z<Integer, String>());\n        doSomethingElse(new Z<Integer, String>(), new Z<Integer, String>());\n        doSomethingElse(new Z<W, String>(), new Z<W, String>());\n        // The next line won't compile.  It's the generic<generic which seems\n        // to be the problem\n        doSomethingElse(new Z<X<W, W>, String>(), new Z<X<W, W>, String>());\n    }\n}"});
    }

    public void test0361() {
        this.runConformTest(new String[]{"Test.java", "import java.util.AbstractSet;\nimport java.util.Iterator;\nimport java.util.Map.Entry;\npublic class Test extends AbstractSet<Entry<String,Integer>> {\n\tpublic Iterator<Entry<String, Integer>> iterator() {\n\t\treturn new Iterator<Entry<String,Integer>>() {\n\t\t\tpublic boolean hasNext() {return false;}\n\t\t\tpublic Entry<String, Integer> next() {return null;}\n\t\t\tpublic void remove() {}\t\n" + ITERATOR_IMPL_JRE8.replaceAll("\\*", "Entry<String,Integer>") + "\t\t};\n" + "\t}\n" + "\tpublic int size() {return 0;}\n" + COLLECTION_RAW_IMPL_JRE8 + ITERABLE_IMPL_JRE8.replaceAll("\\*", "Entry<String,Integer>") + "}"});
    }

    public void test0362() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class Test {\n   public void a() {\n      List<String> list1 = new ArrayList<String>();\n      List<String> list2 = new ArrayList<String>();\n      compare(list1, list2);\n   }\n   private <E> void compare(List<E> list1, List<E> list2) {\n      // do some comparing logic...\n   }\n}\n\n"}, "", null, true, null, customOptions, null);
    }

    public void test0363() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\nimport java.util.Set;\npublic class X {\n  Set<Map.Entry<Integer, ?>> m_values;\n  X(Map<Integer, ?> values) {\n    m_values = values.entrySet();\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tm_values = values.entrySet();\n\t           ^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Set<Map.Entry<Integer,capture#1-of ?>> to Set<Map.Entry<Integer,?>>\n----------\n");
    }

    public void test0364() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\t\n\tvoid bar1(MX<Class<? extends String>> mxcs, MX<Class<? extends Object>> mxco) {\n\t\tmxco = mxcs;\n\t}\n\tvoid bar1(Class<? extends String> cs, Class<? extends Object> co) {\n\t\tco = cs;\n\t}\n\t\n}\nclass MX<E> {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tmxco = mxcs;\n\t       ^^^^\nType mismatch: cannot convert from MX<Class<? extends String>> to MX<Class<? extends Object>>\n----------\n");
    }

    public void test0365() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Runnable> {\n\t\n\tclass MX <U> {\n\t}\n\t\n\tMX<T> createMX() { return new MX<T>(); }\n\n\tvoid foo(X<?> x, MX<?> mx) {\n\t\tmx = x.createMX();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tmx = x.createMX();\n\t     ^^^^^^^^^^^^\nType mismatch: cannot convert from X<capture#2-of ?>.MX<capture#2-of ?> to X<T>.MX<?>\n----------\n");
    }

    public void test0366() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\t\n\tvoid foo1(MX<Class<? extends Object>> target, MX<Class> value) {\n\t\ttarget= value; // foo1 - wrong\n\t}\n\tvoid foo2(MX<Class<? extends Object>> target, MX<Class<? extends String>> value) {\n\t\ttarget= value; // foo2 - wrong\n\t}\n\tvoid foo3(MX<Class<? extends Object>> target, MX<Class<? extends String>> value) {\n\t\ttarget= value; // foo3 - wrong\n\t}\n\tvoid foo4(MX<Class<? extends Object>> target, MX<Class<String>> value) {\n\t\ttarget= value; // foo4 - wrong\n\t}\n\tvoid foo5(MX<? extends Class> target, MX<Class> value) {\n\t\ttarget= value; // foo5\n\t}\n\tvoid foo6(MX<? super Class> target, MX<Class> value) {\n\t\ttarget= value; // foo6\n\t}\n\tvoid foo7(MX<Class<? extends Class>> target, MX<Class<Class>> value) {\n\t\ttarget= value; // foo7 - wrong\n\t}\n\tvoid foo8(MX<MX<? extends Class>> target, MX<MX<Class>> value) {\n\t\ttarget= value; // foo8 - wrong\n\t}\n\tvoid foo9(MX<? extends Object> target, MX<? extends String> value) {\n\t\ttarget= value; // foo9\n\t}\n\tvoid foo10(MX<? extends String> target, MX<? extends Object> value) {\n\t\ttarget= value; // foo10 - wrong\n\t}\n\tvoid foo11(MX<? super Object> target, MX<? super String> value) {\n\t\ttarget= value; // foo11 - wrong\n\t}\n\tvoid foo12(MX<? super String> target, MX<? super Object> value) {\n\t\ttarget= value; // foo12\n\t}\n}\n\nclass MX<E> {\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo1(MX<Class<? extends Object>> target, MX<Class> value) {\n\t                                                 ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 4)\n\ttarget= value; // foo1 - wrong\n\t        ^^^^^\nType mismatch: cannot convert from MX<Class> to MX<Class<? extends Object>>\n----------\n3. ERROR in X.java (at line 7)\n\ttarget= value; // foo2 - wrong\n\t        ^^^^^\nType mismatch: cannot convert from MX<Class<? extends String>> to MX<Class<? extends Object>>\n----------\n4. ERROR in X.java (at line 10)\n\ttarget= value; // foo3 - wrong\n\t        ^^^^^\nType mismatch: cannot convert from MX<Class<? extends String>> to MX<Class<? extends Object>>\n----------\n5. ERROR in X.java (at line 13)\n\ttarget= value; // foo4 - wrong\n\t        ^^^^^\nType mismatch: cannot convert from MX<Class<String>> to MX<Class<? extends Object>>\n----------\n6. WARNING in X.java (at line 15)\n\tvoid foo5(MX<? extends Class> target, MX<Class> value) {\n\t                       ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n7. WARNING in X.java (at line 15)\n\tvoid foo5(MX<? extends Class> target, MX<Class> value) {\n\t                                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n8. WARNING in X.java (at line 18)\n\tvoid foo6(MX<? super Class> target, MX<Class> value) {\n\t                     ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n9. WARNING in X.java (at line 18)\n\tvoid foo6(MX<? super Class> target, MX<Class> value) {\n\t                                       ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n10. WARNING in X.java (at line 21)\n\tvoid foo7(MX<Class<? extends Class>> target, MX<Class<Class>> value) {\n\t                             ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n11. WARNING in X.java (at line 21)\n\tvoid foo7(MX<Class<? extends Class>> target, MX<Class<Class>> value) {\n\t                                                      ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n12. ERROR in X.java (at line 22)\n\ttarget= value; // foo7 - wrong\n\t        ^^^^^\nType mismatch: cannot convert from MX<Class<Class>> to MX<Class<? extends Class>>\n----------\n13. WARNING in X.java (at line 24)\n\tvoid foo8(MX<MX<? extends Class>> target, MX<MX<Class>> value) {\n\t                          ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n14. WARNING in X.java (at line 24)\n\tvoid foo8(MX<MX<? extends Class>> target, MX<MX<Class>> value) {\n\t                                                ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n15. ERROR in X.java (at line 25)\n\ttarget= value; // foo8 - wrong\n\t        ^^^^^\nType mismatch: cannot convert from MX<MX<Class>> to MX<MX<? extends Class>>\n----------\n16. ERROR in X.java (at line 31)\n\ttarget= value; // foo10 - wrong\n\t        ^^^^^\nType mismatch: cannot convert from MX<capture#6-of ? extends Object> to MX<? extends String>\n----------\n17. ERROR in X.java (at line 34)\n\ttarget= value; // foo11 - wrong\n\t        ^^^^^\nType mismatch: cannot convert from MX<capture#7-of ? super String> to MX<? super Object>\n----------\n");
    }

    public void test0367() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\t\n\tvoid foo1(MX<? extends MX> target, MX<MX<String>> value) {\n\t\ttarget= value; // foo1\n\t}\n\tvoid foo2(MX<?> target, MX<MX<String>> value) {\n\t\ttarget= value; // foo2\n\t}\n\tvoid foo3(MX<? super MX> target, MX<MX<String>> value) {\n\t\ttarget= value; // foo3\n\t}\n}\n\nclass MX<E> {\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo1(MX<? extends MX> target, MX<MX<String>> value) {\n\t                       ^^\nMX is a raw type. References to generic type MX<E> should be parameterized\n----------\n2. WARNING in X.java (at line 9)\n\tvoid foo3(MX<? super MX> target, MX<MX<String>> value) {\n\t                     ^^\nMX is a raw type. References to generic type MX<E> should be parameterized\n----------\n3. ERROR in X.java (at line 10)\n\ttarget= value; // foo3\n\t        ^^^^^\nType mismatch: cannot convert from MX<MX<String>> to MX<? super MX>\n----------\n");
    }

    public void test0368() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends Runnable> {\n\t\n\tstatic class MX <U> {\n\t}\n\t\n\tMX<T> createMX() { return new MX<T>(); }\n\n\tvoid foo(X<?> x, MX<?> mx) {\n\t\tmx = x.createMX();\n\t}\n}\n"}, "");
    }

    public void test0369() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\t<T extends Enum<T>> T foo(T t) { return null; }\n}\n"}, "");
    }

    public void test0370() {
        this.runConformTest(new String[]{"p/B.java", "package p;\nimport java.util.Map;\npublic class B {\n\tpublic static Map<Class, String> foo(byte[] byteArray, Object o, Class c) {\n\t\treturn null;\n\t}\n}"}, "");
        this.runConformTest(new String[]{"X.java", "import java.util.Map;\n\nimport p.B;\n\npublic class X {\n\t{\n\t\tMap<Class, String> map = B.foo(null, null, null);\n\t}\n}\n"}, "", null, false, null);
    }

    public void test0371() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   \tpublic void foo(XC<Runnable> target, XC<? extends Runnable> value) {\n   \t\ttarget = value;\n   \t}\n}\nclass XC <E>{\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttarget = value;\n\t         ^^^^^\nType mismatch: cannot convert from XC<capture#1-of ? extends Runnable> to XC<Runnable>\n----------\n");
    }

    public void test0372() {
        this.runConformTest(new String[]{"X.java", "import java.util.Iterator;\nimport java.util.Map;\nimport java.util.Map.Entry;\n\npublic class X <K, V> {\n\n\tvoid foo(Iterator<Map.Entry<K,V>> iter) {\n\t\tnew XA.MXA<K,V>(iter.next());\n\t}\n}\nclass XA <K, V> {\n\tstatic class MXA <K, V>  implements Entry<K,V> {\n\t\tMXA(Entry<K,V> e) {\n\t\t}\n\t\tpublic K getKey() {\n\t\t\treturn null;\n\t\t}\n\t\tpublic V getValue() {\n\t\t\treturn null;\n\t\t}\n\t\tpublic V setValue(V value) {\n\t\t\treturn null;\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test0373() {
        this.runConformTest(new String[]{"XA.java", "import java.util.Map.Entry;\n\npublic class XA <K, V> {\n\tstatic class MXA <K, V>  implements Entry<K,V> {\n\t\tMXA(Entry<K,V> e) {\n\t\t}\n\t\tpublic K getKey() {\n\t\t\treturn null;\n\t\t}\n\t\tpublic V getValue() {\n\t\t\treturn null;\n\t\t}\n\t\tpublic V setValue(V value) {\n\t\t\treturn null;\n\t\t}\n\t}\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "import java.util.Iterator;\nimport java.util.Map;\nimport java.util.Map.Entry;\n\npublic class X <K, V> {\n\n\tvoid foo(Iterator<Map.Entry<K,V>> iter) {\n\t\tnew XA.MXA<K,V>(iter.next());\n\t}\n}\n"}, "", null, false, null);
    }

    public void test0374() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends Exception> {\n\n\tvoid foo1(X <? extends Exception> target, X<?> value) {\n\t\ttarget = value; // foo1\n\t}\n\tvoid foo2(X <? extends Exception> target, X<? super RuntimeException> value) {\n\t\ttarget = value;  // foo2\n\t}\t\n}\n"}, "");
    }

    public void test0375() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n\n\tvoid foo1(X <? super Exception> target, X<? extends Exception> value) {\n\t\ttarget = value; // foo1\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\ttarget = value; // foo1\n\t         ^^^^^\nType mismatch: cannot convert from X<capture#2-of ? extends Exception> to X<? super Exception>\n----------\n");
    }

    public void test0376() {
        this.runConformTest(new String[]{"XA.java", "import java.util.Map.Entry;\n\npublic class XA <K, V> {\n   XA<K,V> self() { return this; } \n\tstatic class MXA <K, V>  implements Entry<K,V> {\n\t\tMXA(Entry<K,V> e) {\n\t\t}\n\t\tpublic K getKey() {\n\t\t\treturn null;\n\t\t}\n\t\tpublic V getValue() {\n\t\t\treturn null;\n\t\t}\n\t\tpublic V setValue(V value) {\n\t\t\treturn null;\n\t\t}\n\t}\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "import java.util.Iterator;\nimport java.util.Map;\nimport java.util.Map.Entry;\n\npublic class X <K, V> {\n\n\tvoid foo(Iterator<Map.Entry<K,V>> iter) {\n\t\tnew XA.MXA<K,V>(iter.next());\n\t}\n}\n"}, "", null, false, null);
    }

    public void test0377() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n public static void main (String[] args) {\n  final String val = (args == null||args.length==0 ? \"SUCC\" : args[0]) + \"ESS\";\n  class AllegedBoundMismatch<E2 extends SuperI<E2>> {\n   String field = val;\n  }\n  System.out.println(new Object() {\n   AllegedBoundMismatch<SubI<Q>> trial = new AllegedBoundMismatch<SubI<Q>>();\n  }.trial.field);\n }\n}\nclass Q {}\ninterface SubI<Q> extends SuperI<SubI<Q>> {}\ninterface SuperI<Q> {}"}, "SUCCESS");
    }

    public void test0378() {
        this.runConformTest(new String[]{"BB.java", "interface AA<W, Z extends AA<W, Z>> { \n public boolean m(AA<W, ?> that); \n public Z z(); \n public boolean b(); \n}\nabstract class BB<U, V extends AA<U, V>> implements AA<U,V> { \n public boolean m(AA<U, ?> wht) { return wht.z().b(); } \n}\n"});
    }

    public void test0379() {
        this.runConformTest(new String[]{"Test.java", "import java.util.AbstractSet;\nimport java.util.Iterator;\npublic class Test extends AbstractSet<Runnable>{\n    public static void main(String[] args) {\n        Test t=new Test();\n        t.add(null);\n    }\n    public boolean add(Runnable run) {\n        System.out.println(\"success\");\n        return true;\n    }\n    public Iterator<Runnable> iterator() {return null;}\n    public int size() {return 0;}\n" + COLLECTION_RAW_IMPL_JRE8 + ITERABLE_IMPL_JRE8.replaceAll("\\*", "Runnable") + "}"});
    }

    public void test0380() {
        this.runConformTest(new String[]{"Test.java", "import java.util.List;\npublic class Test {\n\tList<? super Number> wsn= null; // Contravariance\n\tList<? super Integer> wsi= wsn; // should work!\n}\n"});
    }

    public void test0381() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n\tvoid foo(Class<? extends String> s) {}\n}\nclass Y {\n\tvoid foo(Class<String> s) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Class<? extends String> s) {}\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method foo(Class<? extends String>) of type X has the same erasure as foo(Class<String>) of type Y but does not override it\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n\tvoid foo(Class<String> s) {}\n}\nclass Y {\n\tvoid foo(Class<? extends String> s) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Class<String> s) {}\n\t     ^^^^^^^^^^^^^^^^^^^^\nName clash: The method foo(Class<String>) of type X has the same erasure as foo(Class<? extends String>) of type Y but does not override it\n----------\n");
    }

    public void test0382() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y implements I {}\ninterface I { void foo(Class<? extends String> s); }\nclass Y { void foo(Class<String> s) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y implements I {}\n\t             ^\nName clash: The method foo(Class<String>) of type Y has the same erasure as foo(Class<? extends String>) of type I but does not override it\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X extends Y implements I {}\n\t             ^\nThe type X must implement the inherited abstract method I.foo(Class<? extends String>)\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public abstract class X extends Y implements I {}\ninterface I { void foo(Class<String> s); }\nclass Y { void foo(Class<? extends String> s) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X extends Y implements I {}\n\t                      ^\nName clash: The method foo(Class<? extends String>) of type Y has the same erasure as foo(Class<String>) of type I but does not override it\n----------\n");
    }

    public void test0383() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y implements I { public <T> void foo(Class<T> s) {} }\ninterface I { <T, S> void foo(Class<T> s); }\nclass Y { public <T> void foo(Class<T> s) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y implements I { public <T> void foo(Class<T> s) {} }\n\t             ^\nThe type X must implement the inherited abstract method I.foo(Class<T>)\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X extends Y implements I { public <T> void foo(Class<T> s) {} }\n\t                                                        ^^^^^^^^^^^^^^^\nName clash: The method foo(Class<T>) of type X has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n3. WARNING in X.java (at line 1)\n\tpublic class X extends Y implements I { public <T> void foo(Class<T> s) {} }\n\t                                                        ^^^^^^^^^^^^^^^\nThe method foo(Class<T>) of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y implements I {}\ninterface I { <T, S> void foo(Class<T> s); }\nclass Y { public <T> void foo(Class<T> s) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y implements I {}\n\t             ^\nName clash: The method foo(Class<T>) of type Y has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X extends Y implements I {}\n\t             ^\nThe type X must implement the inherited abstract method I.foo(Class<T>)\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public abstract class X extends Y implements I {}\ninterface I { <T> void foo(Class<T> s); }\nclass Y { public <T, S> void foo(Class<T> s) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X extends Y implements I {}\n\t                      ^\nName clash: The method foo(Class<T>) of type Y has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n");
    }

    public void test0384a() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n\t<T> java.util.List<T> foo3(java.util.List<T> t) { return t; }\n\tClass<String> foo4() { return null; }\n\tClass<String>[] foo5() { return null; }\n}\nclass Y {\n\t<T> java.util.List<T> foo3(java.util.List<T> t) { return t; }\n\tClass<? extends String> foo4() { return null; }\n\tClass<? extends String>[] foo5() { return null; }\n}\n"}, "");
    }

    public void test0384b() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n\t@Override Class<? extends String> foo() { return null; }\n\t@Override Class<? extends String>[] foo2() { return null; }\n}\nclass Y {\n\tClass<String> foo() { return null; }\n\tClass<String>[] foo2() { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Override Class<? extends String> foo() { return null; }\n\t          ^^^^^^^^^^^^^^^^^^^^^^^\nThe return type is incompatible with Y.foo()\n----------\n2. ERROR in X.java (at line 3)\n\t@Override Class<? extends String>[] foo2() { return null; }\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^\nThe return type is incompatible with Y.foo2()\n----------\n");
    }

    public void test0385() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface IDoubles { List<Double> getList(); }\nclass A implements IDoubles {\n\tpublic List<String> getList() { return null; }\n}\nclass B {\n\t public List<String> getList() { return null; }\n}\nclass C extends B implements IDoubles {\n\tvoid use() { List<String> l= getList(); }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic List<String> getList() { return null; }\n\t       ^^^^^^^^^^^^\nThe return type is incompatible with IDoubles.getList()\n----------\n2. ERROR in X.java (at line 9)\n\tclass C extends B implements IDoubles {\n\t      ^\nThe return types are incompatible for the inherited methods IDoubles.getList(), B.getList()\n----------\n");
    }

    public void test0386() {
        this.runNegativeTest(new String[]{"X.java", "class X <R,U,V, T> {\n\tprivate U u;\n\tprivate V v;\n\tpublic X(U u,V v) { this.u= u; this.v= v; }\n\tpublic R getU() { return (R)u; } // Warning\n\tpublic R getV() { return (R)v; } // Warning\n\tObject o;\n\tpublic T getT() { return (T)o; } // Warning\n}"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic R getU() { return (R)u; } // Warning\n\t                         ^^^^\nType safety: Unchecked cast from U to R\n----------\n2. WARNING in X.java (at line 6)\n\tpublic R getV() { return (R)v; } // Warning\n\t                         ^^^^\nType safety: Unchecked cast from V to R\n----------\n3. WARNING in X.java (at line 8)\n\tpublic T getT() { return (T)o; } // Warning\n\t                         ^^^^\nType safety: Unchecked cast from Object to T\n----------\n");
    }

    public void test0387() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X<T>\n{\n\n\tpublic boolean test1()\n\t{\n\t\t\ttest2(\"test\", null, 0);\n\t}\n\n\tpublic <F> List<F> test2(final List<F> list, final String... strings)\n\t{\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\ttest2(\"test\", null, 0);\n\t^^^^^\nThe method test2(List<F>, String...) in the type X<T> is not applicable for the arguments (String, null, int)\n----------\n");
    }

    public void test0388() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X<T>\n{\n\n\tpublic boolean test01()\n\t{\n\t\t\ttest02(null, null, \"test\");\n\t\t\treturn false;\n\t}\n\n\tpublic <F> List<F> test02(final List<F> list, final String... strings)\n\t{\n\t\treturn null;\n\t}\n}\n"}, "");
    }

    public void test0389() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic boolean test01()\t{\n\t\tString s = foo(\"hello\");\n\t\treturn s != null;\n\t}\n\n\tpublic <F> F foo(F f, F... others) {\n\t\treturn f;\n\t}\n}\n"}, "");
    }

    public void test0390() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic boolean test01()\t{\n\t\tString s = foo(null, \"hello\");\n\t\treturn s != null;\n\t}\n\n\tpublic <F> F foo(F f, F... others) {\n\t\treturn f;\n\t}\n}\n"}, "");
    }

    public void test0391() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic boolean test01()\t{\n\t\tString[] s = foo(null, new String[]{ \"hello\" });\n\t\treturn s != null;\n\t}\n\n\tpublic <F> F foo(F f, F... others) {\n\t\treturn f;\n\t}\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 4)\n\tString[] s = foo(null, new String[]{ \"hello\" });\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from String to String[]\n----------\n" : "----------\n1. ERROR in X.java (at line 4)\n\tString[] s = foo(null, new String[]{ \"hello\" });\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from String to String[]\n----------\n2. WARNING in X.java (at line 8)\n\tpublic <F> F foo(F f, F... others) {\n\t                           ^^^^^^\nType safety: Potential heap pollution via varargs parameter others\n----------\n");
    }

    public void test0392() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic boolean test01()\t{\n\t\tfoo(null, \"hello\");\n\t\treturn true;\n\t}\n\n\tpublic <F> F foo(F f, F... others) {\n\t\treturn f;\n\t}\n}\n"}, "");
    }

    public void test0393() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic boolean test01()\t{\n\t\tfoo(null, \"hello\");\n\t\treturn true;\n\t}\n\n\tpublic <F> F foo(F f, F... others) {\n\t\treturn f;\n\t}\n}\n"}, "");
    }

    public void test0394() {
        this.runConformTest(new String[]{"X.java", "public class X \n{\n}\n\ninterface ITest<C extends X>\n{ \n}\n\nabstract class Test<C extends X> implements ITest<C>\n{\n  protected Manager<C> m_manager;\n  \n  public ITest<C> get()\n  {\n    return m_manager.getById(getClass(), new Integer(1));\n  }\n    \n  public static class Manager<C extends X>\n  {\n    public <T extends ITest<C>> T getById(Class<T> cls, Integer id)\n    {\n      return null;\n    }\n  }\n}\n"}, "");
    }

    public void test0395() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Exception> {\n\tT element;\n\t\n\tvoid foo(X<? super NullPointerException> xnpe) {\n\t\txnpe.element = new java.io.IOException();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\txnpe.element = new java.io.IOException();\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from IOException to capture#1-of ? super NullPointerException\n----------\n");
    }

    public void test0396() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.ArrayList;\n\npublic class X\n{\n    public static <T> List<T> emptyList() {\n        return new ArrayList<T>();\n    }\n    public static <T> Collection<T> emptyCollection() {\n        return new ArrayList<T>();\n    }\n    public static <T> Iterable<T> emptyIterable() {\n        return new ArrayList<T>();\n    }\n    \n    public static void main(String[] args) {\n    \t // generic inference using expected lhs type: T --> String\n        final List<String> lL = emptyList(); // 1\n        \n    \t // generic inference using expected cast type: T --> String\n        final Collection<String> cL = (Collection<String>)emptyList(); // 2\n        \n    \t // generic inference using expected cast type: T --> String\n        final Iterable<String> iL = (Iterable<String>)emptyList(); // 3\n        \n    \t // generic inference using expected lhs type: T --> String\n        final Collection<String> cC = emptyCollection(); // 4\n        \n    \t // generic inference using expected cast type: T --> String\n        final Iterable<String> iC = (Iterable<String>)emptyCollection(); // 5\n        \n    \t // generic inference using expected lhs type: T --> String\n        final Iterable<String> iI = emptyIterable(); // 6\n        \n    \t // generic inference using expected lhs type: T --> String\n        final Collection<String> cL2 = emptyList(); // 7\n        \n    \t // generic inference using expected lhs type: T --> String\n        final Iterable<String> iC2 = emptyCollection(); // 8\n    }\n}"}, "----------\n1. ERROR in X.java (at line 22)\n\tfinal Collection<String> cL = (Collection<String>)emptyList(); // 2\n\t                              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object> to Collection<String>\n----------\n2. ERROR in X.java (at line 25)\n\tfinal Iterable<String> iL = (Iterable<String>)emptyList(); // 3\n\t                            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object> to Iterable<String>\n----------\n3. ERROR in X.java (at line 31)\n\tfinal Iterable<String> iC = (Iterable<String>)emptyCollection(); // 5\n\t                            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from Collection<Object> to Iterable<String>\n----------\n");
    }

    public void test0397() {
        this.runNegativeTest(new String[]{"X.java", "interface K1<A> { \n        public <B extends A> void kk(K1<B> x); \n} \n \nclass K2<C> implements K1<C> { \n        public <D extends C> void kk(K1<D> y) { \n                System.out.println(\"K2::kk(\" + y.toString() + \")\"); \n        } \n} \n \n// --------------------------------------------------- \n \ninterface L1<E> { \n        public void ll(L1<? extends E> a); \n} \n \nclass L2<KK> implements L1<KK> { \n        public void ll(L1<? extends KK> b) { \n                ll2(b); \n        } \n \n        private <LL extends KK> void ll2(L1<LL> c) { \n                System.out.println(\"L2::ll2(\" + c.toString() + \")\"); \n        } \n} \n \n// --------------------------------------------------- \n \ninterface M1<H> { \n        public void mm(M1<? extends H> p); \n} \n \nclass M2<I> implements M1<I> { \n        public <J extends I> void mm(M1<J> q) { \n                System.out.println(\"M2::mm(\" + q.toString() + \")\"); \n        } \n} \n \n// =================================================== \n \nclass XX            { public String toString() { return \"XX\"; } } \nclass YY extends XX { public String toString() { return \"YY\"; } } \nclass ZZ extends YY { public String toString() { return \"ZZ\"; } } \n \n// --------------------------------------------------- \n \npublic class X { \n        public static void main(String arg[]) { \n                goK(new K2<YY>()); \n                goL(new L2<YY>()); \n                goM(new M2<YY>()); \n        } \n \n \n        public static void goK(K1<YY> k) { \n                // k.kk(new K2<XX>()); // Would fail \n                k.kk(new K2<YY>()); \n                k.kk(new K2<ZZ>()); \n        } \n \n \n        public static void goL(L1<YY> l) { \n                // l.ll(new L2<XX>()); // Would fail \n                l.ll(new L2<YY>()); \n                l.ll(new L2<ZZ>()); \n        } \n \n \n        public static void goM(M1<YY> m) { \n                // m.mm(new M2<XX>()); // Would fail \n                m.mm(new M2<YY>()); \n                m.mm(new M2<ZZ>()); \n        } \n}"}, "----------\n1. ERROR in X.java (at line 33)\n\tclass M2<I> implements M1<I> { \n\t      ^^\nThe type M2<I> must implement the inherited abstract method M1<I>.mm(M1<? extends I>)\n----------\n2. ERROR in X.java (at line 34)\n\tpublic <J extends I> void mm(M1<J> q) { \n\t                          ^^^^^^^^^^^\nName clash: The method mm(M1<J>) of type M2<I> has the same erasure as mm(M1<? extends H>) of type M1<H> but does not override it\n----------\n3. WARNING in X.java (at line 41)\n\tclass XX            { public String toString() { return \"XX\"; } } \n\t                                    ^^^^^^^^^^\nThe method toString() of type XX should be tagged with @Override since it actually overrides a superclass method\n----------\n4. WARNING in X.java (at line 42)\n\tclass YY extends XX { public String toString() { return \"YY\"; } } \n\t                                    ^^^^^^^^^^\nThe method toString() of type YY should be tagged with @Override since it actually overrides a superclass method\n----------\n5. WARNING in X.java (at line 43)\n\tclass ZZ extends YY { public String toString() { return \"ZZ\"; } } \n\t                                    ^^^^^^^^^^\nThe method toString() of type ZZ should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test0398() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    X(){\n    }\n    public static void main(String[] args) {\n\t\tnew X<?>();\n\t\tnew X<? extends String>();\n\t\tnew X<?>(){};\n\t\tnew X<? extends String>(){};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew X<?>();\n\t    ^\nCannot instantiate the type X<?>\n----------\n2. ERROR in X.java (at line 6)\n\tnew X<? extends String>();\n\t    ^\nCannot instantiate the type X<? extends String>\n----------\n3. ERROR in X.java (at line 7)\n\tnew X<?>(){};\n\t    ^\nThe type new X(){} cannot extend or implement X<?>. A supertype may not specify any wildcard\n----------\n4. ERROR in X.java (at line 8)\n\tnew X<? extends String>(){};\n\t    ^\nThe type new X(){} cannot extend or implement X<? extends String>. A supertype may not specify any wildcard\n----------\n");
    }

    public void test0399() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\tX<? extends AX> x = new X<AX<Math>>(new AX<String>());\n\t}\n}\n\nclass AX<P> {\n    P foo() { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tX<? extends AX> x = new X<AX<Math>>(new AX<String>());\n\t            ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n2. ERROR in X.java (at line 7)\n\tX<? extends AX> x = new X<AX<Math>>(new AX<String>());\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor X<AX<Math>>(AX<String>) is undefined\n----------\n");
    }

    public void test0400() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n    T t;\n    X(X<? extends T> xt){\n        this.t = xt.t;\n    }\n    public static void main(String[] args) {\n\t\tX<? extends AX> x = new X<AX<Math>>(new X<AX<String>>(null));\n\t}\n}\nclass AX<P> {\n    P foo() { return null; }\n}"}, "----------\n1. WARNING in X.java (at line 7)\n\tX<? extends AX> x = new X<AX<Math>>(new X<AX<String>>(null));\n\t            ^^\nAX is a raw type. References to generic type AX<P> should be parameterized\n----------\n2. ERROR in X.java (at line 7)\n\tX<? extends AX> x = new X<AX<Math>>(new X<AX<String>>(null));\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor X<AX<Math>>(X<AX<String>>) is undefined\n----------\n");
    }

    public void test0401() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tvoid foo() {\n\t\tnew X<X<?>>();\n\t\tnew X<X<? extends String>>();\n\t\tnew X<X<?>>(){};\n\t\tnew X<X<? extends String>>(){};\n\t}\n}"}, "");
    }

    public void test0402() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y<Y<?>> {\n}\nclass Y<T> {}"}, "");
    }

    public void test0403() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n\t\n\tvoid foo(X<X<? extends String>> xs) {\n\t\tX<X<String>> x = (X<X<String>>) xs;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX<X<String>> x = (X<X<String>>) xs;\n\t                 ^^^^^^^^^^^^^^^^^\nCannot cast from X<X<? extends String>> to X<X<String>>\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0404() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n\t\n\tvoid foo(X<? extends String> xs) {\n\t\tX<String> x = (X<String>) xs;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tX<String> x = (X<String>) xs;\n\t              ^^^^^^^^^^^^^^\nType safety: Unchecked cast from X<capture#1-of ? extends String> to X<String>\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0405() {
        this.runNegativeTest(new String[]{"X.java", "public class X <E> {\n\t\n\t<T> void foo(X<X<T>> xs) {\n\t\tX<X<String>> x = (X<X<String>>) xs;\n\t}\n\t<T> void bar(X<T> xs) {\n\t\tX<String> x = (X<String>) xs;\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX<X<String>> x = (X<X<String>>) xs;\n\t                 ^^^^^^^^^^^^^^^^^\nCannot cast from X<X<T>> to X<X<String>>\n----------\n2. WARNING in X.java (at line 7)\n\tX<String> x = (X<String>) xs;\n\t              ^^^^^^^^^^^^^^\nType safety: Unchecked cast from X<T> to X<String>\n----------\n");
    }

    public void test0406() {
        this.runConformTest(new String[]{"X.java", "public abstract class X<K1,V1> implements M<K1,V1> {\n\tabstract M<K1,V1> other();\n\tpublic S<E<K1,V1>> entrySet() {\n\t\treturn other().entrySet();\n\t}\n}\ninterface M<K2,V2> {\n\t interface E<K3,V3> { }\n\t S<E<K2, V2>> entrySet();\n}\ninterface S<T> {}"}, "");
    }

    public void test0407() {
        this.runConformTest(new String[]{"X.java", "public abstract class X<K1,V1> implements M<K1,V1> {\n\tabstract M<K1,V1> other();\n\tpublic S<M.E<K1,V1>> entrySet() {\n\t\treturn other().entrySet();\n\t}\n}\ninterface M<K2,V2> {\n\t interface E<K3,V3> { }\n\t S<E<K2, V2>> entrySet();\n}\ninterface S<T> {}"}, "");
    }

    public void test0408() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public Integer[] getTypes() {\n        List<Integer> list = new ArrayList<Integer>();\n        return list == null \n            ? new Integer[0] \n            : list.toArray(new Integer[list.size()]);\n    }\n    public static void main(String[] args) {\n        Class clazz = null;\n        try {\n            clazz = Class.forName(\"X\");\n    \t     System.out.println(\"SUCCESS\");\n        } catch (Throwable e) {\n            e.printStackTrace();\n        }\n    }\n}"}, "SUCCESS");
    }

    public void test0409() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public Number getTypes() {\n        List<Integer> list = new ArrayList<Integer>();\n        return list == null \n            ? Float.valueOf(0)\n            : list.get(0);\n    }\n    public static void main(String[] args) {\n        Class clazz = null;\n        try {\n            clazz = Class.forName(\"X\");\n    \t     System.out.println(\"SUCCESS\");\n        } catch (Throwable e) {\n            e.printStackTrace();\n        }\n    }\n}"}, "SUCCESS");
    }

    public void test0410() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\npublic void write(List<? super Exception> list) {\n\t\n  list.add(new RuntimeException());             // works\n  list.add(new IllegalMonitorStateException()); // works\n  Exception exc = new Exception();\n  list.add(exc);                                // works\n  list.add(new Object());                       // should fail\n  list.add(new Throwable());                    // should fail\n  list.add(new Exception());                    // works\n}\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tlist.add(new Object());                       // should fail\n\t     ^^^\nThe method add(capture#4-of ? super Exception) in the type List<capture#4-of ? super Exception> is not applicable for the arguments (Object)\n----------\n2. ERROR in X.java (at line 12)\n\tlist.add(new Throwable());                    // should fail\n\t     ^^^\nThe method add(capture#5-of ? super Exception) in the type List<capture#5-of ? super Exception> is not applicable for the arguments (Throwable)\n----------\n");
    }

    public void test0411() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n    void m1(T t);\n    void m2(T t);\n}\n\nclass A {};\n\nclass B implements I<A> {\n    public void m1(A a) {\n    \tSystem.out.println(\"SUCCESS\");\n    }\n    public void m2(A a) {}\n}\n\npublic class X {\n    public static void main(String[] args) {\n        m(new B());\n    }\n\n    public static void m(I<A> x) {\n        x.m1(null);\n    }\n}"}, "SUCCESS");
    }

    public void test0412() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n    public static <T> T first(T... args) {\n        return args[0];\n    }\n    \n    public static void main(String[] args) {\n    \tif (false) { \n    \t\tString s = first(); \n    \t\tint i; \n    \t\ti++; \n    \t}\n        System.out.println(first(\"SUCCESS\", \"List\"));\n    }\n   Zork z;\n}"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 15)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 3)\n\tpublic static <T> T first(T... args) {\n\t                               ^^^^\nType safety: Potential heap pollution via varargs parameter args\n----------\n2. ERROR in X.java (at line 15)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0412a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\n    public static <T> T first(T... args) {\n        return args[0];\n    }\n    \n    public static void main(String[] args) {\n    \tif (false) { \n    \t\tList<String> ls = first(); \n    \t\tint i; \n    \t\ti++; \n    \t}\n        System.out.println(first(\"SUCCESS\", \"List\"));\n    }\n   Zork z;\n}"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in X.java (at line 10)\n\tList<String> ls = first(); \n\t                  ^^^^^^^\nType safety: A generic array of List<String> is created for a varargs parameter\n----------\n2. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 4)\n\tpublic static <T> T first(T... args) {\n\t                               ^^^^\nType safety: Potential heap pollution via varargs parameter args\n----------\n2. WARNING in X.java (at line 10)\n\tList<String> ls = first(); \n\t                  ^^^^^^^\nType safety: A generic array of List<String> is created for a varargs parameter\n----------\n3. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0413() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tstatic class TLM {\n\t}\n    TLM getMap(TL t) {\n        return t.tls;\n    }\n    static TLM createInheritedMap(TLM parentMap) {\n        return new TLM();\n    }  \n}\n\nclass TL {\n   X.TLM tls = null;\n}"}, "");
    }

    public void test0414() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(L l, C<? super X> c) {\n\t\tbar(l, c);\n\t}\n\t<T> void bar(L<T> l, C<? super T> c) { \n\t}\t\n}\nclass C<E> {}\nclass L<E> {}"}, "");
    }

    public void test0415() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public S<M.E<Object,Object>> foo(HM hm) {\n\t\treturn C.bar(hm).foo();\n    }\n}\nclass C {\n    public static <K,V> M<K,V> bar(M<? extends K,? extends V> m) {\n\t\treturn null;\n    }\n}\nclass S<E> {\n}\nabstract class HM<U,V> implements M<U,V>{\n}\ninterface M<A,B> {\n\tstatic class E<S,T> {}\n\tS<E<A,B>> foo();\t\n}"}, "");
    }

    public void test0416() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public S<M.E<Object,String>> foo(HM hm) {\n    \tM<Object, String> m = C.bar(hm);\n    \tif (false) return m.foo();\n\t\treturn C.bar(hm).foo();\n    }\n}\nclass C {\n    public static <K,V> M<K,V> bar(M<? extends K,? extends V> m) {\n\t\treturn null;\n    }\n}\nclass S<E> {\n}\nabstract class HM<U,V> implements M<U,V>{\n}\ninterface M<A,B> {\n\tstatic class E<S,T> {}\n\tS<E<A,B>> foo();\t\n}"}, "");
    }

    public void test0417() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\t\n\t<T> X<T> foo(X<T> xt) {\n\t\treturn null;\n\t}\n\tX<E> identity() {\n\t\treturn this;\n\t}\n\tvoid bar(X x) {\n\t\tX<String> xs = foo(x).identity();\n\t}\n}\n"}, "");
    }

    public void test0418() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\t\n\t<T> X<T> foo(X<T> xt, X<T> xt2) {\n\t\treturn null;\n\t}\n\tX<E> identity() {\n\t\treturn this;\n\t}\n\tvoid bar(X x, X<String> xs) {\n\t\tX<String> xs2 = foo(x, xs).identity();\n\t}\n}\n"}, "");
    }

    public void test0419() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\t\n\t<T,U> X<T> foo(X<T> xt, X<U> xt2) {\n\t\treturn null;\n\t}\n\tX<E> identity() {\n\t\treturn this;\n\t}\n\tvoid bar(X x, X<String> xs) {\n\t\tX<String> xs2 = foo(x, xs).identity();\n\t}\n}\n"}, "");
    }

    public void test0420() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\t\n\t<T,U> X<U> foo(X<T> xt, X<U> xt2) {\n\t\treturn null;\n\t}\n\tX<E> identity() {\n\t\treturn this;\n\t}\n\tvoid bar(X x, X<String> xs) {\n\t\tX<String> xs2 = foo(x, xs).identity();\n\t}\n}\n"}, "");
    }

    public void test0421() {
        this.runConformTest(new String[]{"Test.java", "import java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\n\npublic class Test\n{\n  protected Map<Class<? extends Object>, List<Object>> m_test\n    = new HashMap<Class<? extends Object>, List<Object>>();\n}\n", "Test2.java", "import java.util.List;\nimport java.util.Map;\n\npublic class Test2 extends Test\n{\n  public Map<Class<? extends Object>, List<Object>> test()\n  {\n    return m_test;\n  }\n}\n"}, "");
    }

    public void test0422() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tString foo() {\n\t\treturn new X();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn new X();\n\t       ^^^^^^^\nType mismatch: cannot convert from X to String\n----------\n2. WARNING in X.java (at line 3)\n\treturn new X();\n\t           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test0423() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    static <T extends X> T bar() {\n        return null;\n    }\n    static <U extends X&Runnable> U foo() {\n        return null;\n    }\n\n    public static void main(String argv[]) {\n    \tbar();\n        foo();\n    }\n\n}"}, "");
    }

    public void test0424() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\t<T extends A> T foo(T t) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().bar();\n\t}\n\tvoid bar() {\n\t\tB b = foo(new B());\n\t}\n}\n\nclass A {}\nclass B extends A {}\n\n"}, "");
    }

    public void test0425() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X {\n    static <E extends A> void m(E e) { System.out.println(\"A:\"+e.getClass()); }\n    static <F extends B> void m(F f) throws Exception { System.out.println(\"B:\"+f.getClass()); }\n    static <G extends C> void m(G g) throws IOException { System.out.println(\"C:\"+g.getClass()); }\n\n    public static void main(String[] args) {\n        m(new A());\n        m(new B());\n        m(new C());\n    }\n}\n\nclass A {}\nclass B extends A {}\nclass C extends A {}\n\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tm(new B());\n\t^^^^^^^^^^\nUnhandled exception type Exception\n----------\n2. ERROR in X.java (at line 11)\n\tm(new C());\n\t^^^^^^^^^^\nUnhandled exception type IOException\n----------\n");
    }

    public void test0426() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static <E extends A> E m(E e) { System.out.print(\"[A:\"+e.getClass()+\"]\"); return e; }\n\n    public static void main(String[] args) {\n        A a = m(new A());\n        B b = m(new B());\n        C c = m(new C());\n    }\n}\n\nclass A {}\nclass B extends A {}\nclass C extends A {}\n"}, "[A:class A][A:class B][A:class C]");
    }

    public void test0427() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static <E extends A> E m(E e, E... e2) { System.out.print(\"[A:\"+e.getClass()+\"]\"); return e; }\n    static <F extends B> F m(F f, F... f2) { System.out.print(\"[B:\"+f.getClass()+\"]\"); return f; }\n    static <G extends C> G m(G g, G... g2) { System.out.print(\"[C:\"+g.getClass()+\"]\"); return g; }\n\n    public static void main(String[] args) {\n        A a = m(new A(), new A());\n        B b = m(new B(), new B());\n        C c = m(new C(), new C());\n    }\n}\n\nclass A {}\nclass B extends A {}\nclass C extends A {}\n"}, "[A:class A][B:class B][C:class C]");
    }

    public void test0428() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   Zork z;\n\tpublic static void foo() {\n\t\tclass A<T extends Number> {\n\t\t\tT t = null;\n\t\t\tT get() {\n\t\t\t\treturn t;\n\t\t\t}\n\t\t}\n\t\tA<Long> a = new A<Long>() {\n\t\t\t@Override\n\t\t\tLong get() {\n\t\t\t\treturn new Long(5);\n\t\t\t}\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0429() {
        this.runConformTest(new String[]{"X1.java", "class X1 <T extends Y & Comparable<Y>> {}\nabstract class Y implements Comparable<Y> {}"}, "");
    }

    public void test0429a() {
        this.runConformTest(new String[]{"X2.java", "class X2 <T extends Y & Comparable<Y>> {}\nabstract class Y extends Z {}\nabstract class Z implements Comparable<Y> {}"}, "");
    }

    public void test0429b() {
        this.runConformTest(new String[]{"X3.java", "class X3 <T extends Y & Comparable<Z>> {}\nabstract class Y extends Z {}\nabstract class Z implements Comparable<Z> {}"}, "");
    }

    public void test0429c() {
        this.runNegativeTest(new String[]{"X4.java", "class X4 <T extends Comparable<Z> & Comparable<Z>> {}\nabstract class Y extends Z {}\nabstract class Z implements Comparable<Z> {}"}, "----------\n1. ERROR in X4.java (at line 1)\n\tclass X4 <T extends Comparable<Z> & Comparable<Z>> {}\n\t                                    ^^^^^^^^^^\nDuplicate bound Comparable<Z>\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test0429d() {
        this.runNegativeTest(new String[]{"X5.java", "class X5 <T extends Y & Comparable<X5>> {}\nabstract class Y implements Comparable<Y> {}"}, "----------\n1. ERROR in X5.java (at line 1)\n\tclass X5 <T extends Y & Comparable<X5>> {}\n\t                        ^^^^^^^^^^\nThe interface Comparable cannot be implemented more than once with different arguments: Comparable<X5> and Comparable<Y>\n----------\n2. WARNING in X5.java (at line 1)\n\tclass X5 <T extends Y & Comparable<X5>> {}\n\t                                   ^^\nX5 is a raw type. References to generic type X5<T> should be parameterized\n----------\n");
    }

    public void test0429e() {
        this.runNegativeTest(new String[]{"X6.java", "class X6 <T extends Y & Comparable<X6>> {}\nabstract class Y extends Z {}\nabstract class Z implements Comparable<Z> {}"}, "----------\n1. ERROR in X6.java (at line 1)\n\tclass X6 <T extends Y & Comparable<X6>> {}\n\t                        ^^^^^^^^^^\nThe interface Comparable cannot be implemented more than once with different arguments: Comparable<X6> and Comparable<Z>\n----------\n2. WARNING in X6.java (at line 1)\n\tclass X6 <T extends Y & Comparable<X6>> {}\n\t                                   ^^\nX6 is a raw type. References to generic type X6<T> should be parameterized\n----------\n");
    }

    public void test0429f() {
        this.runNegativeTest(new String[]{"X7.java", "class X7 <T extends Comparable<Z> & Comparable<X7>> {}\nabstract class Y extends Z {}\nabstract class Z implements Comparable<Z> {}"}, "----------\n1. ERROR in X7.java (at line 1)\n\tclass X7 <T extends Comparable<Z> & Comparable<X7>> {}\n\t                                    ^^^^^^^^^^\nThe interface Comparable cannot be implemented more than once with different arguments: Comparable<X7> and Comparable<Z>\n----------\n2. WARNING in X7.java (at line 1)\n\tclass X7 <T extends Comparable<Z> & Comparable<X7>> {}\n\t                                               ^^\nX7 is a raw type. References to generic type X7<T> should be parameterized\n----------\n");
    }

    public void test0429g() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T> {}\n\nclass A implements I<A>, I<A> {}\npublic class X<E extends A & I<E> & I<E>>  {\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass A implements I<A>, I<A> {}\n\t                         ^\nDuplicate interface I<A> for the type A\n----------\n2. ERROR in X.java (at line 4)\n\tpublic class X<E extends A & I<E> & I<E>>  {\n\t                             ^\nThe interface I cannot be implemented more than once with different arguments: I<E> and I<A>\n----------\n3. ERROR in X.java (at line 4)\n\tpublic class X<E extends A & I<E> & I<E>>  {\n\t                                    ^\nDuplicate bound I<E>\n----------\n");
    }

    public void test0430() {
        this.runConformTest(new String[]{"p/MMM.java", "package p;\npublic interface MMM< F extends MMM<F,G>, G extends NNN> { } \n", "p/NNN.java", "package p;\npublic interface NNN { } \n"}, "");
        this.runConformTest(new String[]{"X.java", "import p.MMM;\nimport p.NNN;\n\ninterface RRR< A extends MMM<A, B>, B extends NNN> {}\n\nclass J1 implements MMM<J1, J2> { }\nclass J2 implements NNN { }\n\nclass J3 implements RRR<J1,J2> {} \n\npublic class X {\n  public static void main(String[] args) {\n    J3 thing = null;\n  }\n}\n"}, "", null, false, null);
    }

    public void test0431() {
        this.runNegativeTest(new String[]{"X.java", "public class X<Type> {\n  private class Element {\n  }\n  public X() {\n    Element[] eArray = new Element[10];\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tElement[] eArray = new Element[10];\n\t                   ^^^^^^^^^^^^^^^\nCannot create a generic array of X<Type>.Element\n----------\n");
    }

    public void test0432() {
        this.runConformTest(new String[]{"X.java", "public class X<Type> {\n  private static class Element {\n  }\n  public X() {\n    Element[] eArray = new Element[10];\n  }\n}\n"}, "");
    }

    public void test0433() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\ninterface Alpha<\n\tA1 extends Alpha<A1, B1>, \n\tB1 extends Beta<A1, B1>> {\n}\ninterface Beta<\n\tA2 extends Alpha<A2, B2>, \n\tB2 extends Beta<A2, B2>> {\n}\ninterface Phi<\n\tA3 extends Alpha<A3, B3>, \n\tB3 extends Beta<A3, B3>> {\n\t\n\tpublic void latinize(A3 s);\n}\n\npublic class X<\n\tA extends Alpha<A, B>, \n\tB extends Beta<A, B>, \n\tP extends Phi<A, B>> extends ArrayList<P> implements Phi<A, B> {\n\t\n\tpublic final void latinize(A a) {\n\t\tfrenchify(this, a); // (X<A,B,P>, A)\n\t}\n\t// -----------------------------------------------------------------\n\tpublic static final <AA extends Alpha<AA, BB>, BB extends Beta<AA, BB>> \n\tvoid frenchify(Collection< ? extends Phi<AA, BB>> phis, AA aa) {\n\t\tfor (final Phi<AA, BB> phi : phis)\n\t\t\tphi.latinize(aa);\n\t}\n}\n"}, "");
    }

    public void test0434() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X\n{\n\n  public static void main(String[] args)\n  {\n    ArrayList<String> l = new ArrayList<String>();\n    l.add(\"x\");\n    String s = \"\";\n    s += l.get(0); // X\n    System.out.println(\"SUCCESS\");\n  }\n\n}\n"}, "SUCCESS");
    }

    public void test0435() {
        this.runNegativeTest(new String[]{"Test.java", "import java.lang.reflect.InvocationTargetException;\nimport java.lang.reflect.Method;\n\nimport orders.DiscreteOrder;\nimport orders.impl.IntegerOrder;\nimport orders.impl.IntegerOrder2;\n\npublic class Test {\n\n    public static void main(String[] args) throws SecurityException,\n            NoSuchMethodException, IllegalArgumentException,\n            IllegalAccessException {\n        Test test = new Test();\n\n        for (String method : new String[] { \"test01\", \"test02\", \"test03\", \"test04\" }) {\n            Method m = test.getClass().getMethod(method);\n            try {\n                m.invoke(test);\n                System.out.print(\"*** \" + m + \": success\");\n            } catch (InvocationTargetException e) {\n                System.out.print(\"*** \" + m + \": failed, stacktrace follows\");\n                e.getCause().printStackTrace(System.out);\n            }\n        }\n    }\n\n    public void test01() { // works\n        new IntegerOrder().next(new Integer(0)); // works\n    }\n\n    public void test02() { // doesn't work\n        final DiscreteOrder<Integer> order = new IntegerOrder();\n        order.next(new Integer(0));\n    }\n\n    public void test03() { // works\n        new IntegerOrder2().next(new Integer(0)); // works\n    }\n\n    public void test04() { // doesn't work\n        final DiscreteOrder<Integer> order = new IntegerOrder2();\n        order.next(new Integer(0));\n    }\n}\n", "orders/DiscreteOrder.java", "package orders;\npublic interface DiscreteOrder<E extends Comparable<E>> {\n    /**\n     * @return The element immediately before <code>element</code> in the\n     *         discrete ordered space.\n     */\n    public E previous(E element);\n    /**\n     * @return The element immediately after <code>element</code> in the\n     *         discrete ordered space.\n     */\n    public E next(E element);\n}\n", "orders/impl/IntegerOrder.java", "package orders.impl;\nimport orders.DiscreteOrder;\n\npublic class IntegerOrder implements DiscreteOrder<Integer> {\n\n    public IntegerOrder() {\n        super();\n    }\n\n    public Integer previous(Integer arg0) {\n        return new Integer(arg0.intValue() - 1);\n    }\n\n    public Integer next(Integer arg0) {\n        return new Integer(arg0.intValue() + 1);\n    }\n}\n", "orders/impl/IntegerOrder2.java", "package orders.impl;\n\n\npublic class IntegerOrder2 extends IntegerOrder {\n\n    public IntegerOrder2() {\n        super();\n    }\n\n    public Comparable previous(Comparable arg0) {\n        return previous((Integer) arg0);\n    }\n\n    public Comparable next(Comparable arg0) {\n        return next((Integer) arg0);\n    }\n\n}\n"}, "----------\n1. WARNING in orders\\impl\\IntegerOrder2.java (at line 10)\n\tpublic Comparable previous(Comparable arg0) {\n\t       ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. ERROR in orders\\impl\\IntegerOrder2.java (at line 10)\n\tpublic Comparable previous(Comparable arg0) {\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method previous(Comparable) of type IntegerOrder2 has the same erasure as previous(E) of type DiscreteOrder<E> but does not override it\n----------\n3. WARNING in orders\\impl\\IntegerOrder2.java (at line 10)\n\tpublic Comparable previous(Comparable arg0) {\n\t                           ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n4. WARNING in orders\\impl\\IntegerOrder2.java (at line 14)\n\tpublic Comparable next(Comparable arg0) {\n\t       ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n5. ERROR in orders\\impl\\IntegerOrder2.java (at line 14)\n\tpublic Comparable next(Comparable arg0) {\n\t                  ^^^^^^^^^^^^^^^^^^^^^\nName clash: The method next(Comparable) of type IntegerOrder2 has the same erasure as next(E) of type DiscreteOrder<E> but does not override it\n----------\n6. WARNING in orders\\impl\\IntegerOrder2.java (at line 14)\n\tpublic Comparable next(Comparable arg0) {\n\t                       ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test0436() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tNumber n= new Integer(1);\n\t\tX x = new X<Number>();\n\t\tx.m(n);\n\t\tx.m(new Integer(2));\n\t\tY y= new Y();\n\t\ty.m(n);\n\t\ty.m(new Integer(2));\n\t}\n}\n", "X.java", "class X<T> {\n\tpublic void m(Number num) { System.out.print(\"X.m(Number) = \" + num + ','); }\n\tpublic void m(T t) { System.out.print(\"X.m(T) = \" + t + ','); }\n}\n", "Y.java", "class Y extends X<Number> {\n\tpublic void m(Number num) { System.out.print(\"Y.m(Number) = \" + num + ','); }\n}\n"}, "X.m(Number) = 1,X.m(Number) = 2,Y.m(Number) = 1,Y.m(Number) = 2,");
    }

    public void test0437() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static void main(String[] args) {\n\t\tNumber n= new Integer(1);\n\t\tX x = new X<Number>();\n\t\tx.m(n);\n\t\tx.m(new Integer(2));\n\t\tY y= new Y();\n\t\ty.m(n);\n\t\ty.m(new Integer(2));\n\t}\n}\n", "X.java", "class X<T> {\n\tpublic void m(Number num) { System.out.print(\"X.m(Number) = \" + num + ','); }\n\tpublic void m(T t) { System.out.print(\"X.m(T) = \" + t + ','); }\n}\n", "Y.java", "class Y extends X<Number> {\n\tpublic void m(Number num) { System.out.print(\"Y.m(Number) = \" + num + ','); }\n}\n"}, "X.m(Number) = 1,X.m(Number) = 2,Y.m(Number) = 1,Y.m(Number) = 2,");
    }

    public void test0438() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X<T> {\n    Zork z;\n    List<T> list;\n    void add(Object abs) {\n        list.add((T) list.get(0)); // checked cast\n        list.add((T) abs); // unchecked cast\n    }\n    void bar(List<? extends T> other) {\n    \tlist.add((T) other.get(0)); // checked cast\n    }\n    void baz(List<? super T> other) {\n    \tlist.add((T) other.get(0)); // unchecked cast\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 6)\n\tlist.add((T) list.get(0)); // checked cast\n\t         ^^^^^^^^^^^^^^^\nUnnecessary cast from T to T\n----------\n3. WARNING in X.java (at line 7)\n\tlist.add((T) abs); // unchecked cast\n\t         ^^^^^^^\nType safety: Unchecked cast from Object to T\n----------\n4. WARNING in X.java (at line 10)\n\tlist.add((T) other.get(0)); // checked cast\n\t         ^^^^^^^^^^^^^^^^\nUnnecessary cast from capture#1-of ? extends T to T\n----------\n5. WARNING in X.java (at line 13)\n\tlist.add((T) other.get(0)); // unchecked cast\n\t         ^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from capture#2-of ? super T to T\n----------\n");
    }

    public void test0439() {
        this.runNegativeTest(new String[]{"X.java", "class Node {\n}\nclass Composite<E> {\n}\nclass Concrete extends Composite {\n}\npublic class X {\n    Composite<Node> comp = new Concrete(); // unchecked cast\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tclass Concrete extends Composite {\n\t                       ^^^^^^^^^\nComposite is a raw type. References to generic type Composite<E> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\tComposite<Node> comp = new Concrete(); // unchecked cast\n\t                       ^^^^^^^^^^^^^^\nType safety: The expression of type Concrete needs unchecked conversion to conform to Composite<Node>\n----------\n3. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0440() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass Y<U> {\n\t\tpublic void foo(X<T> xt) {\n\t\t\tU u = (U) xt;\n\t\t}\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tU u = (U) xt;\n\t      ^^^^^^\nType safety: Unchecked cast from X<T> to U\n----------\n2. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0441() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Number> {\n    T[] array;\n    X(int s) {\n        array = (T[]) new Number[s];   // Unnecessary cast from Number[] to T[]\n        array = new Number[s];   // Type mismatch: cannot convert from Number[] to T[]\n     }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tarray = (T[]) new Number[s];   // Unnecessary cast from Number[] to T[]\n\t        ^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Number[] to T[]\n----------\n2. ERROR in X.java (at line 5)\n\tarray = new Number[s];   // Type mismatch: cannot convert from Number[] to T[]\n\t        ^^^^^^^^^^^^^\nType mismatch: cannot convert from Number[] to T[]\n----------\n");
    }

    public void test0442() {
        this.runConformTest(new String[]{"X.java", "class Foo {\n\tpublic interface Model {\n\t}\n\tpublic interface View<M extends Model> {\n\t\tM getTarget() ;\n\t}\n}\nclass Bar {\n\tpublic interface Model extends Foo.Model {\n\t}\n\tpublic interface View<M extends Model> extends Foo.View<M> {\n\t}\n}\npublic class X {\n\tpublic void baz() {\n\t\tBar.View<?> bv = null ;\n\t\tBar.Model m = bv.getTarget() ;\n\t}\n}\n"}, "");
    }

    public void test0443() {
        this.runConformTest(new String[]{"X.java", "import java.util.Iterator;\npublic class X implements Iterator<String> {\n    public boolean hasNext() { return false; }\n    public String next() { return null; }\n    public void remove() {}\n" + ITERATOR_IMPL_JRE8.replaceAll("\\*", "String") + "}\n"}, "");
    }

    public void test0444() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements I<Integer>, I<String> {}\ninterface I<T> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements I<Integer>, I<String> {}\n\t             ^\nThe interface I cannot be implemented more than once with different arguments: I<String> and I<Integer>\n----------\n");
    }

    public void test0445() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X {\n    public abstract Object getProperty(final Object src, final String name);\n    Zork z;\n    public <T> T getTheProperty(final Object src, final String name)\n    {\n        final T val = (T) getProperty(src, name); // this gives erroneous cast warning\n        return val;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 6)\n\tfinal T val = (T) getProperty(src, name); // this gives erroneous cast warning\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to T\n----------\n");
    }

    public void test0446() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n  class Inner<B> { }\n\n  void method() {\n    X<String>.Inner<Integer> a= new X<String>().new Inner<Integer>();\n    Inner<Integer> b= new X<A>().new Inner<Integer>();\n    Inner<Integer> c= new Inner<Integer>();\n    // OK\n\n    X<String>.Inner<Integer> d= new X<String>.Inner<Integer>();\n    //eclipse: OK\n    //other: error: '(' or '[' expected\n\n    X<A>.Inner<Integer> e= new X<A>().new Inner<Integer>();\n    X<A>.Inner<Integer> f= new Inner<Integer>();\n    e= b;\n    f= c;\n    //other: OK\n    //eclipse: Type mismatch: cannot convert from X<A>.Inner<Integer> to X<A>.Inner<Integer>\n\n  }\n}\n\nclass External {\n  void m() {\n    X<String>.Inner<Integer> x= new X<String>().new Inner<Integer>();\n    // OK\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tX<String>.Inner<Integer> d= new X<String>.Inner<Integer>();\n\t                                ^^^^^^^^^^^^^^^\nCannot allocate the member type X<String>.Inner<Integer> using a parameterized compound name; use its simple name and an enclosing instance of type X<String>\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236243);
    }

    public void test0447() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n  class Inner<B> { }\n\n  void method() {\n    X<String>.Inner<Integer> d1 = new X<String>.Inner<Integer>();\n    X.Inner d2 = new X.Inner();\n    X.Inner<Integer> d3 = new X.Inner<Integer>();\n    d1 = d2;\n    d2 = d1;\n    d1 = d3;\n    d3 = d1;\n    d2 = d3;\n    d3 = d2;\n\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tX<String>.Inner<Integer> d1 = new X<String>.Inner<Integer>();\n\t                                  ^^^^^^^^^^^^^^^\nCannot allocate the member type X<String>.Inner<Integer> using a parameterized compound name; use its simple name and an enclosing instance of type X<String>\n----------\n2. WARNING in X.java (at line 6)\n\tX.Inner d2 = new X.Inner();\n\t^^^^^^^\nX.Inner is a raw type. References to generic type X<A>.Inner<B> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tX.Inner d2 = new X.Inner();\n\t                 ^^^^^^^\nX.Inner is a raw type. References to generic type X<A>.Inner<B> should be parameterized\n----------\n4. ERROR in X.java (at line 7)\n\tX.Inner<Integer> d3 = new X.Inner<Integer>();\n\t^^^^^^^\nThe member type X.Inner<Integer> must be qualified with a parameterized type, since it is not static\n----------\n5. ERROR in X.java (at line 7)\n\tX.Inner<Integer> d3 = new X.Inner<Integer>();\n\t                          ^^^^^^^\nThe member type X.Inner<Integer> must be qualified with a parameterized type, since it is not static\n----------\n6. WARNING in X.java (at line 8)\n\td1 = d2;\n\t     ^^\nType safety: The expression of type X.Inner needs unchecked conversion to conform to X<String>.Inner<Integer>\n----------\n7. ERROR in X.java (at line 10)\n\td1 = d3;\n\t     ^^\nType mismatch: cannot convert from X.Inner<Integer> to X<String>.Inner<Integer>\n----------\n8. ERROR in X.java (at line 11)\n\td3 = d1;\n\t     ^^\nType mismatch: cannot convert from X<String>.Inner<Integer> to X.Inner<Integer>\n----------\n9. WARNING in X.java (at line 13)\n\td3 = d2;\n\t     ^^\nType safety: The expression of type X.Inner needs unchecked conversion to conform to X.Inner<Integer>\n----------\n");
    }

    public void test0448() {
        this.runConformTest(new String[]{"X.java", "public class X<A> {\n  static class Inner<B> { }\n\n  void method() {\n    X.Inner<Integer> d = new X.Inner<Integer>();    \n  }\n}\n"}, "");
    }

    public void test0448a() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tclass Y {}\n\tX<?>.Y[] tab = new X<?>.Y[] {};\n}"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test0449() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n  class Inner<B> { \n  }\n\n  void method() {\n    X<String>.Inner<Integer> d4 = new X.Inner<Integer>();\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tX<String>.Inner<Integer> d4 = new X.Inner<Integer>();\n\t                              ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X.Inner<Integer> to X<String>.Inner<Integer>\n----------\n2. ERROR in X.java (at line 6)\n\tX<String>.Inner<Integer> d4 = new X.Inner<Integer>();\n\t                                  ^^^^^^^\nThe member type X.Inner<Integer> must be qualified with a parameterized type, since it is not static\n----------\n");
    }

    public void test0450() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n  static class Inner<B> { \n  }\n\n  void method() {\n    X<String>.Inner<Integer> d4 = new X<String>.Inner<Integer>();\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tX<String>.Inner<Integer> d4 = new X<String>.Inner<Integer>();\n\t^^^^^^^^^^^^^^^\nThe member type X<String>.Inner cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type X<String>\n----------\n2. ERROR in X.java (at line 6)\n\tX<String>.Inner<Integer> d4 = new X<String>.Inner<Integer>();\n\t                                  ^^^^^^^^^^^^^^^\nThe member type X<String>.Inner cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type X<String>\n----------\n");
    }

    public void test0451() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n  class Inner<B> { \n  }\n\n  void method() {\n    X<String>.Inner<Integer> d4 = new X<String>.Inner<Integer>() {};\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tX<String>.Inner<Integer> d4 = new X<String>.Inner<Integer>() {};\n\t                                  ^^^^^^^^^^^^^^^\nCannot allocate the member type X<String>.Inner<Integer> using a parameterized compound name; use its simple name and an enclosing instance of type X<String>\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236243);
    }

    public void test0452() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\t\n\t public <E extends Object, S extends Collection<E>> S test01(S param){\n\t \tSystem.out.println(\"SUCCESS\");\n\t \treturn null;\n\t }\n\t \n\t public void test02() {\n\t \ttest01(new Vector<String>());\n\t }\n\n\t public static void main(String[] args) {\n\t\tnew X().test02();\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0453() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends I & I> {}\ninterface I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends I & I> {}\n\t                             ^\nDuplicate bound I\n----------\n");
    }

    public void test0454() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, U extends X> {\n\tObject[] objectArr;\n\tvoid foo(T t) {\n\t\tT x1= (T) objectArr;\n\t\tU x2= (U) objectArr;\n\t\tint[] x= (int[]) t;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X<T, U extends X> {\n\t                            ^\nX is a raw type. References to generic type X<T,U> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tT x1= (T) objectArr;\n\t      ^^^^^^^^^^^^^\nType safety: Unchecked cast from Object[] to T\n----------\n3. ERROR in X.java (at line 5)\n\tU x2= (U) objectArr;\n\t      ^^^^^^^^^^^^^\nCannot cast from Object[] to U\n----------\n");
    }

    public void test0455() {
        this.runConformTest(new String[]{"AbstractTest.java", "public abstract class AbstractTest<T> {\n  abstract void array(T[] a);\n  abstract void type(T a);\n  abstract T[] foo();\n}\n"}, "");
        this.runConformTest(new String[]{"Test.java", "public class Test<T> extends AbstractTest<T> {\n  void array(T[] a) {}\n  void type(T a) {}\n  T[] foo() { return null; }\n}\n"}, "", null, false, null);
    }

    public void test0456() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\t<S extends T> void doTest(S[] a);\n}\n\nabstract class AbstractTest<U> implements I<U> {\n\tpublic <V extends U> void doTest(V[] a) {}\n}\n\npublic class X<M> extends AbstractTest<M> {}\n"}, "");
    }

    public void test0457() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\t\n void add(List<? super X> l) { \n \tl.add(new X()); \n }\n void add2(List<? extends X> l) { \n \tl.add(new X()); \n }\n \n static <T> void add3(List<T> l, List<T> l2) { \n }\n public static void main(String[] args) {\n\tList<X> lx = null;\n\tList<String> ls = null;\n\tadd3(lx, ls);\n } \n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tl.add(new X()); \n\t  ^^^\nThe method add(capture#2-of ? extends X) in the type List<capture#2-of ? extends X> is not applicable for the arguments (X)\n----------\n2. ERROR in X.java (at line 17)\n\tadd3(lx, ls);\n\t^^^^\nThe method add3(List<T>, List<T>) in the type X is not applicable for the arguments (List<X>, List<String>)\n----------\n");
    }

    public void test0458() {
        this.runNegativeTest(new String[]{"X.java", "interface A<E>{\n\tE getOne();\n}\n\n\nabstract class B<T extends Number> implements A<T> {\n\tNumber getTwo() {\n\t\treturn getOne(); // succeeds\n\t}\n}\n\nabstract class C extends B<Integer> {\n}\n\npublic class X {\n\tvoid foo(A a, B b, C c){\n\t\tObject o= a.getOne();\n\t\tNumber n1= b.getOne(); // fails\n\t\tNumber n2= b.getTwo(); // succeeds, but inlining fails\n\t\tInteger i = c.getOne(); // succeeds\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 16)\n\tvoid foo(A a, B b, C c){\n\t         ^\nA is a raw type. References to generic type A<E> should be parameterized\n----------\n2. WARNING in X.java (at line 16)\n\tvoid foo(A a, B b, C c){\n\t              ^\nB is a raw type. References to generic type B<T> should be parameterized\n----------\n3. ERROR in X.java (at line 18)\n\tNumber n1= b.getOne(); // fails\n\t           ^^^^^^^^^^\nType mismatch: cannot convert from Object to Number\n----------\n");
    }

    public void test0459() {
        this.runNegativeTest(new String[]{"X.java", "public class X \n{\nZork z;\n}\n\ninterface ITest<C extends X>\n{ \n}\n\nabstract class Test<C extends X> implements ITest<C>\n{\n  protected Manager<C> m_manager;\n  \n  public ITest<C> get()\n  {\n    return m_manager.getById(getClass(), new Integer(1));\n  }\n    \n  public static class Manager<C extends X>\n  {\n    public <T extends ITest<C>> T getById(Class<T> cls, Integer id)\n    {\n      return null;\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 16)\n\treturn m_manager.getById(getClass(), new Integer(1));\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation getById(Class<capture#1-of ? extends Test>, Integer) of the generic method getById(Class<T>, Integer) of type Test.Manager<C>\n----------\n3. WARNING in X.java (at line 16)\n\treturn m_manager.getById(getClass(), new Integer(1));\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Test needs unchecked conversion to conform to ITest<C>\n----------\n");
    }

    public void test0460() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\n\tpublic <E extends Object, S extends Collection<E>> S test(S param) {\n\t\t\n\t\tClass<? extends Collection> c = param.getClass(); // ok\n\t\tClass<? extends Collection> d = getClazz(); // ko\n\t\treturn null;\n\t}\n\tClass<? extends Object> getClazz() {\n\t\treturn null;\n\t}\n}\nabstract class Z implements Collection<String> {\n\tvoid foo() {\n\t\tClass<? extends Collection> c = getClass(); // ok\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tClass<? extends Collection> c = param.getClass(); // ok\n\t                ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\tClass<? extends Collection> d = getClazz(); // ko\n\t                ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in X.java (at line 8)\n\tClass<? extends Collection> d = getClazz(); // ko\n\t                                ^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#2-of ? extends Object> to Class<? extends Collection>\n----------\n4. WARNING in X.java (at line 17)\n\tClass<? extends Collection> c = getClass(); // ok\n\t                ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n");
    }

    public void test0461() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends int[]> {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends int[]> {\n\t                         ^^^^^\nThe array type int[] cannot be used as a type parameter bound\n----------\n");
    }

    public void test0462() {
        this.runConformTest(new String[]{"PropertiedObject.java", "interface PropertiedObject<B extends PropertiedObject<B>> {}\ninterface Model extends PropertiedObject<Model> {}\ninterface View<T extends Model,U> extends PropertiedObject<View<?,?>> {}\n"}, "");
    }

    public void test0463() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Set;\npublic class X {\n   Zork z;\n\tpublic Set<String>[] test() {\n\t   Set[] sets = new Set[10];\n\t   return sets;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 5)\n\tSet[] sets = new Set[10];\n\t^^^\nSet is a raw type. References to generic type Set<E> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\treturn sets;\n\t       ^^^^\nType safety: The expression of type Set[] needs unchecked conversion to conform to Set<String>[]\n----------\n");
    }

    public void test0464() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n    Zork z;\n    public static void main(String[] args) {\n        List<Integer>[] nums = new List[] {Collections.singletonList(\"Uh oh\")};\n        System.out.println(nums[0].get(0).intValue());\n    } \n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 6)\n\tList<Integer>[] nums = new List[] {Collections.singletonList(\"Uh oh\")};\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type List[] needs unchecked conversion to conform to List<Integer>[]\n----------\n");
    }

    public void test0465() {
        this.runNegativeTest(new String[]{"Cla.java", "class Cla<T> {\n    T getT() {\n        return null;\n    }\n    \n    void m() {\n        String s= new Cla<String>.getT();\n    }\n}\n"}, "----------\n1. ERROR in Cla.java (at line 7)\n\tString s= new Cla<String>.getT();\n\t              ^^^^^^^^^^^^^^^^\nCla.getT cannot be resolved to a type\n----------\n");
    }

    public void test0466() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A, A> { }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<A, A> { }\n\t                  ^\nDuplicate type parameter A\n----------\n");
    }

    public void test0467() {
        this.runConformTest(new String[]{"test/Foo.java", "package test; \npublic class Foo { \n   protected String s; \n   protected String dosomething(){ return \"done\"; } \n   protected class Bar {} \n} \n", "test02/FooBar.java", "package test02; \nimport test.Foo; \npublic class FooBar<R> extends Foo { \n   void fail() { \n      FooBar f = new FooBar(); \n      f.s = \"foo\"; \n      this.s = \"foo\";\n      f.dosomething(); \n      this.dosomething();  \n      Bar b1; \n      FooBar.Bar b2; \n      Foo.Bar b3; \n   } \n}\n"}, "");
    }

    public void test0468() {
        this.runConformTest(new String[]{"test/Foo.java", "package test; \npublic class Foo { \n   String s; \n   String dosomething(){ return \"done\"; } \n   class Bar {} \n} \n", "test/FooBar.java", "package test; \nimport test.Foo; \npublic class FooBar<R> extends Foo { \n   void fail() { \n      FooBar f = new FooBar(); \n      f.s = \"foo\"; \n      this.s = \"foo\";\n      f.dosomething(); \n      this.dosomething();  \n      Bar b1; \n      FooBar.Bar b2; \n      Foo.Bar b3; \n   } \n}\n"}, "");
    }

    public void test0469() {
        this.runConformTest(new String[]{"a/C.java", "package a; \nimport p.B; \npublic class C extends B { \n\tpublic void foo(Object obj) {} \n} \n", "p/B.java", "package p; \npublic class B<E> extends A<E> {} \n", "p/A.java", "package p; \npublic class A<E> { \n\tpublic void foo(E e) {} \n}\n"}, "");
        this.runConformTest(new String[]{"a/C.java", "package a; \nimport p.B; \npublic class C extends B { \n\tpublic void foo(Object obj) {} \n} \n", "p/A.java", "package p; \npublic class A<E> { \n\tpublic void foo(E e) {} \n}\n"}, "", null, false, null);
    }

    public void test0470() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static <T> T choose(boolean b, T t1, T t2) {\n\t\tif (b)\n\t\t\treturn t1;\n\t\treturn t2;\n\t}\n\n\tpublic static void foo() {\n\t\tComparable s1 = choose(true, \"string\", new Integer(1));\n\t\tNumber s2 = choose(true, new Integer(1), new Float(2));\n\t\tComparable s3 = choose(true, new Integer(1), new Float(2));\n\t\tCloneable s4 = choose(true, new Integer(1), new Float(2));\n\t\tCloneable s5 = choose(true, \"string\", new Integer(1));\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tComparable s1 = choose(true, \"string\", new Integer(1));\n\t^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. WARNING in X.java (at line 11)\n\tComparable s3 = choose(true, new Integer(1), new Float(2));\n\t^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n3. ERROR in X.java (at line 12)\n\tCloneable s4 = choose(true, new Integer(1), new Float(2));\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Number&Comparable<?> to Cloneable\n----------\n4. ERROR in X.java (at line 13)\n\tCloneable s5 = choose(true, \"string\", new Integer(1));\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object&Serializable&Comparable<?> to Cloneable\n----------\n");
    }

    public void test0471() {
        this.runNegativeTest(new String[]{"test/Foo.java", "package test; \npublic class Foo<R> { \n   protected R s; \n   protected R dosomething(){ return s; } \n   protected class Bar {} \n} \n", "test02/FooBar.java", "package test02; \nimport test.Foo; \npublic class FooBar<R> extends Foo<R> { \n   void fail() { \n      FooBar<String> f = new FooBar<String>(); \n      f.s = \"foo\"; \n      this.s = \"foo\";\n      f.dosomething(); \n      this.dosomething();  \n      Bar b1; \n      FooBar<String>.Bar b2; \n      Foo<String>.Bar b3; \n   } \n}\n"}, "----------\n1. ERROR in test02\\FooBar.java (at line 7)\n\tthis.s = \"foo\";\n\t         ^^^^^\nType mismatch: cannot convert from String to R\n----------\n");
    }

    public void test0472() {
        this.runNegativeTest(new String[]{"test/Foo.java", "package test; \npublic class Foo<R> { \n   private R s; \n   private R dosomething(){ return s; } \n   private class Bar {} \n} \n", "test02/FooBar.java", "package test02; \nimport test.Foo; \npublic class FooBar<R> extends Foo<R> { \n   void fail() { \n      FooBar<String> f = new FooBar<String>(); \n      f.s = \"foo\"; \n      this.s = \"foo\";\n      f.dosomething(); \n      this.dosomething();  \n      Bar b1; \n      FooBar<String>.Bar b2; \n      Foo<String>.Bar b3; \n   } \n}\n"}, "----------\n1. ERROR in test02\\FooBar.java (at line 6)\n\tf.s = \"foo\"; \n\t  ^\nThe field Foo<String>.s is not visible\n----------\n2. ERROR in test02\\FooBar.java (at line 7)\n\tthis.s = \"foo\";\n\t     ^\nThe field Foo<R>.s is not visible\n----------\n3. ERROR in test02\\FooBar.java (at line 7)\n\tthis.s = \"foo\";\n\t         ^^^^^\nType mismatch: cannot convert from String to R\n----------\n4. ERROR in test02\\FooBar.java (at line 8)\n\tf.dosomething(); \n\t  ^^^^^^^^^^^\nThe method dosomething() from the type Foo<String> is not visible\n----------\n5. ERROR in test02\\FooBar.java (at line 9)\n\tthis.dosomething();  \n\t     ^^^^^^^^^^^\nThe method dosomething() from the type Foo<R> is not visible\n----------\n6. ERROR in test02\\FooBar.java (at line 10)\n\tBar b1; \n\t^^^\nThe type Bar is not visible\n----------\n7. ERROR in test02\\FooBar.java (at line 11)\n\tFooBar<String>.Bar b2; \n\t^^^^^^^^^^^^^^^^^^\nThe type FooBar.Bar is not visible\n----------\n8. ERROR in test02\\FooBar.java (at line 12)\n\tFoo<String>.Bar b3; \n\t^^^^^^^^^^^^^^^\nThe type Foo.Bar is not visible\n----------\n");
    }

    public void test0473() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X\n{\n\tList<B> itsList;\n\tB itsB;\n\tMyTyped itsTyped;\n\t\n\t\n\tpublic void test()\n\t{\n\t\tmethod (itsList, itsB, itsTyped);\n\t}\n\t\n\tpublic <T> void method (List<? extends T> arg1, T arg2, Typed<? super T> arg3)\n\t{\n\t}\n\t\n\tinterface A{}\n\tclass B implements A{}\n\tclass Typed<T>{}\n\tclass MyTyped extends Typed<A>{}\n\n}\n"}, "");
    }

    public void test0474() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tTyped<B> itsList;\n\tTyped<A> itsTyped;\n\tpublic void test() {\n\t\tmethod(itsList, itsTyped);\n\t}\n\tpublic <T> void method(Typed<? extends T> arg1, Typed<? super T> arg3) {\n\t}\n\tinterface A {\n\t}\n\tclass B implements A {\n\t}\n\tclass Typed<T> {\n\t}\n}\n"}, "");
    }

    public void test0475() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n    void method(List<? super Number> list) {\n        list.add(new Object());   // should fail\n        list.add(new Integer(3)); // correct\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tlist.add(new Object());   // should fail\n\t     ^^^\nThe method add(capture#1-of ? super Number) in the type List<capture#1-of ? super Number> is not applicable for the arguments (Object)\n----------\n");
    }

    public void test0476() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n    void method(List<? super Number> list, List<Object> lo) {\n    \tlist = lo;\n    \tlo = list;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tlo = list;\n\t     ^^^^\nType mismatch: cannot convert from List<capture#2-of ? super Number> to List<Object>\n----------\n");
    }

    public void test0477() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<T extends Number> {\n\tList<? super T> lhs;\n\tList<? extends Number> rhs;\n\t{\n\t\tlhs.add(rhs.get(0));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tlhs.add(rhs.get(0));\n\t    ^^^\nThe method add(capture#1-of ? super T) in the type List<capture#1-of ? super T> is not applicable for the arguments (capture#2-of ? extends Number)\n----------\n");
    }

    public void test0478() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<U extends Number> {\n\tList<? super Number> lhs;\n\tList<? super U> rhs;\n\t{\n\t\tlhs.add(rhs.get(0));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tlhs.add(rhs.get(0));\n\t    ^^^\nThe method add(capture#1-of ? super Number) in the type List<capture#1-of ? super Number> is not applicable for the arguments (capture#2-of ? super U)\n----------\n");
    }

    public void test0479() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X<U extends Number> {\n\tList<? super Number> lhs;\n\tList<? extends U> rhs;\n\t{\n\t\tlhs.add(rhs.get(0));\n\t}\n}\n"}, "");
    }

    public void test0480() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<U extends Number> {\n\tList<? super Integer> lhs;\n\tList<? extends Number> rhs;\n\t{\n\t\tlhs.add(rhs.get(0));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tlhs.add(rhs.get(0));\n\t    ^^^\nThe method add(capture#1-of ? super Integer) in the type List<capture#1-of ? super Integer> is not applicable for the arguments (capture#2-of ? extends Number)\n----------\n");
    }

    public void test0481() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<U extends Number> {\n\tList<? super Number> lhs;\n\tList<? super Integer> rhs;\n\t{\n\t\tlhs.add(rhs.get(0));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tlhs.add(rhs.get(0));\n\t    ^^^\nThe method add(capture#1-of ? super Number) in the type List<capture#1-of ? super Number> is not applicable for the arguments (capture#2-of ? super Integer)\n----------\n");
    }

    public void test0482() {
        this.runConformTest(new String[]{"X.java", "public final class X {\n\tpublic <T> void testEquals(final String x, T one, T two) {\n\t}\n\n\tpublic <T1, T2> void testEqualsAlt(final String x, T1 one, T2 two) {\n\t}\n\n\tpublic interface Fooey {\n\t}\n\n\tpublic interface Bar extends Fooey {\n\t}\n\n\tpublic interface GenericFooey<T> {\n\t}\n\n\tpublic interface GenericBar<T> extends GenericFooey<T> {\n\t}\n\n\tpublic void testGeneric() {\n\t\ttestEquals(\"Should work\", new GenericBar<Long>() {\n\t\t}, new GenericBar<Long>() {\n\t\t});\n\t\tfinal GenericBar<Long> child = new GenericBar<Long>() {\n\t\t};\n\t\tfinal GenericFooey<Long> parent = child;\n\t\ttestEquals(\"Doesn't work but should\", child, parent); // this\n\t\t// fails\n\t\t// but should work it's identical to next line.\n\t\ttestEquals(\"Doesn't work but should\", (GenericFooey<Long>) child, parent);\n\t\ttestEqualsAlt(\"Should work\", child, parent);\n\t}\n\tpublic void test() {\n\t\ttestEquals(\"Should work\", new Bar() {\n\t\t}, new Bar() {\n\t\t});\n\t\tfinal Bar child = new Bar() {\n\t\t};\n\t\tfinal Fooey parent = child;\n\t\ttestEquals(\"Doesn't work but should\", child, parent);\n\t\ttestEquals(\"Doesn't work but should\", (Fooey) child, parent);\n\t\ttestEqualsAlt(\"Should work\", child, parent);\n\t}\n}\n"}, "");
    }

    public void test0483() {
        this.runNegativeTest(new String[]{"X.java", "class Y<T extends Number> {\n}\n\npublic class X {\n    public static void main(String argv[]) {\n        m(new Y<Short>(), new Y<Integer>());\n    }\n\n    public static <T extends Number> void m(Y<T> x, Y<T> y) {\n    }\n}\n\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tm(new Y<Short>(), new Y<Integer>());\n\t^\nThe method m(Y<T>, Y<T>) in the type X is not applicable for the arguments (Y<Short>, Y<Integer>)\n----------\n");
    }

    public void test0484() {
        this.runConformTest(new String[]{"X.java", "class Base<T> {\n\tpublic class Inner {\n\t}\n\tInner a;\n}\n\npublic class X extends Base<Integer> {\n\tclass DerivedInner extends Inner {\n\t}\n\tX() {\n\t\ta = new DerivedInner();\n\t}\n}\n"}, "");
    }

    public void test0485() {
        this.runConformTest(new String[]{"X.java", "class Base<T> {\n\tpublic class Inner<U> {\n\t}\n\tInner a;\n}\n\npublic class X extends Base<Integer> {\n\tclass DerivedInner extends Inner {\n\t}\n\tX() {\n\t\ta = new DerivedInner();\n\t}\n}\n"}, "");
    }

    public void test0486() {
        this.runConformTest(new String[]{"X.java", "class Base<T> {\n\tpublic class Inner<U> {\n\t}\n\tInner a;\n}\n\npublic class X extends Base<Integer> {\n\tclass DerivedInner extends Inner<Float> {\n\t}\n\tX() {\n\t\ta = new DerivedInner();\n\t}\n}\n"}, "");
    }

    public void test0487() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tvoid foo(List<String> ls) {\n\t\tList<?> l = ls;\n\t\tbar(l, \"\"); \n\t}\n\t<T> void bar(List<? super T> l, T t) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tbar(l, \"\"); \n\t^^^\nThe method bar(List<? super T>, T) in the type X is not applicable for the arguments (List<capture#1-of ?>, String)\n----------\n");
    }

    public void test0488() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        Foo<?> f1 = new Foo<Integer>();\n        Foo<?> f2 = new Foo<String>();\n        f1.bar = f2.bar;\n    }\n    static class Foo<T> {\n       Bar<T> bar = new Bar<T>();\n    }\n    static class Bar<T> {\n        T t;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tf1.bar = f2.bar;\n\t         ^^^^^^\nType mismatch: cannot convert from X.Bar<capture#2-of ?> to X.Bar<capture#1-of ?>\n----------\n");
    }

    public void test0489() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        Foo<?> f1 = new Foo<Integer>();\n        f1.bar = f1.bar;\n    }\n    static class Foo<T> {\n       Bar<T> bar = new Bar<T>();\n    }\n    static class Bar<T> {\n        T t;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tf1.bar = f1.bar;\n\t         ^^^^^^\nType mismatch: cannot convert from X.Bar<capture#2-of ?> to X.Bar<capture#1-of ?>\n----------\n");
    }

    public void test0490() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tT t;\n\tvoid foo(X<?> lhs, X<?> rhs) {\n\t\tlhs = rhs;\n\t\tlhs.t = rhs.t;\n\t}\n\tvoid bar(X<X<?>> lhs, X<X<?>> rhs) {\n\t\tlhs = rhs;\n\t\tlhs.t = rhs.t;\n\t}}\n\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tlhs.t = rhs.t;\n\t        ^^^^^\nType mismatch: cannot convert from capture#4-of ? to capture#3-of ?\n----------\n");
    }

    public void test0491() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tT t;\n\tvoid foo(X<?> lhs, X<?> rhs) {\n\t\tlhs = rhs;\n\t\tlhs.t = rhs.t;\n\t}\n\tvoid bar(X<X<?>> lhs, X<X<?>> rhs) {\n\t\tlhs = rhs;\n\t\tlhs.t = rhs.t;\n\t}\n\tvoid baz(X<? super Number> lhs, X<? extends Number> rhs) {\n\t\tlhs = rhs;\n\t\tlhs.t = rhs.t;\n\t}\n\tvoid baz2(X<? extends Number> lhs, X<? extends Number> rhs) {\n\t\tlhs = rhs;\n\t\tlhs.t = rhs.t;\n\t}\n\tvoid baz3(X<? extends Number> lhs, X<? super Number> rhs) {\n\t\tlhs = rhs;\n\t\tlhs.t = rhs.t;\n\t}\n\tvoid baz4(X<? super Number> lhs, X<? super Number> rhs) {\n\t\tlhs = rhs;\n\t\tlhs.t = rhs.t;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tlhs.t = rhs.t;\n\t        ^^^^^\nType mismatch: cannot convert from capture#4-of ? to capture#3-of ?\n----------\n2. ERROR in X.java (at line 12)\n\tlhs = rhs;\n\t      ^^^\nType mismatch: cannot convert from X<capture#8-of ? extends Number> to X<? super Number>\n----------\n3. ERROR in X.java (at line 17)\n\tlhs.t = rhs.t;\n\t        ^^^^^\nType mismatch: cannot convert from capture#14-of ? extends Number to capture#13-of ? extends Number\n----------\n4. ERROR in X.java (at line 20)\n\tlhs = rhs;\n\t      ^^^\nType mismatch: cannot convert from X<capture#16-of ? super Number> to X<? extends Number>\n----------\n5. ERROR in X.java (at line 21)\n\tlhs.t = rhs.t;\n\t        ^^^^^\nType mismatch: cannot convert from capture#18-of ? super Number to capture#17-of ? extends Number\n----------\n6. ERROR in X.java (at line 25)\n\tlhs.t = rhs.t;\n\t        ^^^^^\nType mismatch: cannot convert from capture#22-of ? super Number to capture#21-of ? super Number\n----------\n");
    }

    public void test0492() {
        this.runConformTest(new String[]{"SuperType.java", "public class SuperType<T> {\n\tprotected InnerType valueWrapper;\n\tprotected class InnerType {\n\t\tprivate T value;\n\t\tprotected InnerType(T value) {\n\t\t\tthis.value = value;\n\t\t}\n\t}\n\tpublic SuperType(T value) {\n\t\t/*\n\t\t * This constructor exists only to show that the usage of the inner\n\t\t * class within its enclosing class makes no problems\n\t\t */\n\t\tthis.valueWrapper = new InnerType(value);\n\t}\n\tprotected SuperType() {\n\t\t// Provided for the convenience of subclasses\n\t}\n}\n", "SubType.java", "public class SubType<T> extends SuperType<T> {\n\n\tpublic SubType(T value) {\n\n\t\t/* The constructor SuperType <T>.InnerType(T) is undefined */\n\t\tInnerType localValueWrapper = new InnerType(value);\n\n\t\t/*\n\t\t * Type mismatch: cannot convert from SuperType <T>.InnerType to\n\t\t * SuperType <T>.InnerType\n\t\t * \n\t\t * Type safety: The expression of raw type SuperType.InnerType is\n\t\t * converted to SuperType <T>.InnerType. References to generic type\n\t\t * SuperType <T>.InnerType should be parametrized.\n\t\t */\n\t\tlocalValueWrapper = super.valueWrapper;\n\t}\n\n}\n"}, "");
    }

    public void test0493() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic class M<T> { M(Class<T> templateClass) {} }\n}\n", "Y.java", "public class Y extends X {\n\tvoid test() { M<X> m = new M<X>(X.class); }\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "public class Y extends X {\n\tvoid test() { M<X> m = new M<X>(X.class); }\n}\n"}, "", null, false, null);
    }

    public void test0494() {
        String xSource = "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tNumber n= null;\n\t\tInteger i= null;\n\t\tnew X().nextTry(i, n);\n\t\tnew X().nextTry2(n, i);\n\t}\t\n\t\n\t<I, N extends I> void nextTry(I i, N n) {}\n\t\n\t<N, I extends N> void nextTry2(N n, I i) {}\t\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 6)\n\tnew X().nextTry(i, n);\n\t        ^^^^^^^\nBound mismatch: The generic method nextTry(I, N) of type X is not applicable for the arguments (Integer, Number). The inferred type Number is not a valid substitute for the bounded parameter <N extends I>\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", xSource});
        }
    }

    public void test0495() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tList l= null; \n\n\tvoid add(String s) {\n\t\tl.add(s);\n\t}\n\t\n\tvoid addAll(String[] ss) {\n\t\tl.addAll(Arrays.asList(ss));\n\t}\n\t\n\tString[] get() {\n\t\treturn (String[])l.toArray(new String[l.size()]);\n\t}\n}\n"}, "");
    }

    public void test0496() {
        this.runConformTest(new String[]{"X.java", "class Super<S> {\n\tclass A<E> { }\n\t<T> void take(A<S> o) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\nclass Sub extends Super<Double> {\n\tvoid test() {\n\t\ttake(new A());\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew Sub().test();\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0497() {
        this.runNegativeTest(new String[]{"X.java", "class Super<S> {\n\tclass A<E> { }\n\t<T> void take(A<S> o) {\n\t}\n}\nclass Sub extends Super<Double> {\n\tvoid test() {\n\t\ttake(new A());\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew Sub().test();\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\ttake(new A());\n\t^^^^^^^^^^^^^\nType safety: Unchecked invocation take(Super.A) of the generic method take(Super<S>.A<S>) of type Super<Double>\n----------\n2. WARNING in X.java (at line 8)\n\ttake(new A());\n\t     ^^^^^^^\nType safety: The expression of type Super.A needs unchecked conversion to conform to Super<Double>.A<Double>\n----------\n3. WARNING in X.java (at line 8)\n\ttake(new A());\n\t         ^\nSuper.A is a raw type. References to generic type Super<S>.A<E> should be parameterized\n----------\n4. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0498() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.source", "1.4");
        this.runNegativeTest(true, new String[]{"X.java", "interface I {\n   String foo();\n}\ninterface J {\n   Object foo();\n}\n \npublic class X implements I {\n   public String foo() {\n \treturn \"\";\n   }\n   public static void main(String[] args) {\n         I i = new X();\n         try {\n\t        J j = (J) i;\n         } catch(ClassCastException e) {\n\t        System.out.println(\"SUCCESS\");\n         }\n  }\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 15)\n\tJ j = (J) i;\n\t      ^^^^^\nCannot cast from I to J\n----------\n", RUN_JAVAC ? new AbstractRegressionTest.JavacTestOptions("-source 1.4") : AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void test0499() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t public static void main(String argv[]) {\n\t\t \t\t String[] tab1 = new String[0];\n\t\t \t\t Integer[] tab2 = new Integer[0];\n\t\t \t\t boolean cond = true;\n\t\t \t\t Integer[] var = cond ? tab1 : tab2;\n\t\t \t\t System.out.println(var);\n\t\t }\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 6)\n\tInteger[] var = cond ? tab1 : tab2;\n\t                ^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object&Serializable&Comparable<? extends Object&Serializable&Comparable<?>>[] to Integer[]\n----------\n" : "----------\n1. ERROR in X.java (at line 6)\n\tInteger[] var = cond ? tab1 : tab2;\n\t                       ^^^^\nType mismatch: cannot convert from String[] to Integer[]\n----------\n");
    }

    public void test0500() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\n\ninterface Sink<T> { \n\tvoid flush(T t);\n}\nclass SimpleSinkImpl<T> implements Sink<T> {\n\tpublic void flush(T t) {}\n}\npublic class X {\n\n    private <T> T writeAll(Collection<T> coll, Sink<? super T> snk) { \n        T last = null;\n        for (T t : coll) { \n            last = t;\n            snk.flush(last);\n        }\n        return last;\n    }\n\n    public void test01() {\n        Sink<Object> s = new SimpleSinkImpl<Object>();\n        Collection<String> cs = new ArrayList<String>();\n        cs.add(\"hello!\");\n        cs.add(\"goodbye\");\n        cs.add(\"see you\");\n        \n        String str = this.writeAll(cs, s);  \n    }\n\n    public static void main(String[] args) {\n        X test = new X();\n        \n        test.test01();\n    }\n}\n"}, "");
    }

    public void test0501() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X <T extends AX> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\tX<? extends BX> x = new X<BX<String>>(new BX<String>());\n\t\tSystem.out.print(x.t.ax);\n\t\tSystem.out.print(x.t.bx);\n\t}\n}\n\nclass AX<P> {\n\tP ax;\n}\n\nclass BX<Q> extends AX<Q> {\n\tQ bx;\n}\n"}, "nullnull");
        String expectedOutput = "  // Method descriptor #25 ([Ljava/lang/String;)V\n  // Stack: 4, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  new X [1]\n     3  dup\n     4  new BX [26]\n     7  dup\n     8  invokespecial BX() [28]\n    11  invokespecial X(AX) [29]\n    14  astore_1 [x]\n    15  getstatic java.lang.System.out : java.io.PrintStream [31]\n    18  aload_1 [x]\n    19  getfield X.t : AX [16]\n    22  checkcast BX [26]\n    25  getfield BX.ax : java.lang.Object [37]\n    28  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [41]\n    31  getstatic java.lang.System.out : java.io.PrintStream [31]\n    34  aload_1 [x]\n    35  getfield X.t : AX [16]\n    38  checkcast BX [26]\n    41  getfield BX.bx : java.lang.Object [47]\n    44  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [41]\n    47  return\n      Line numbers:\n        [pc: 0, line: 7]\n        [pc: 15, line: 8]\n        [pc: 31, line: 9]\n        [pc: 47, line: 10]\n      Local variable table:\n        [pc: 0, pc: 48] local: args index: 0 type: java.lang.String[]\n        [pc: 15, pc: 48] local: x index: 1 type: X\n      Local variable type table:\n        [pc: 15, pc: 48] local: x index: 1 type: X<? extends BX>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0502() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X <T extends AX> {\n    T t;\n    X(T t){\n        this.t = t;\n    }\n    public static void main(String[] args) {\n\t\tX<? extends BX> x = new X<BX<String>>(new BX<String>());\n\t\tSystem.out.print(x.self().t.ax);\n\t\tSystem.out.print(x.self().t.bx);\n\t}\n\tX<T> self() {\n\t\treturn this;\n\t}\n}\n\nclass AX<P> {\n\tP ax;\n}\n\nclass BX<Q> extends AX<Q> {\n\tQ bx;\n}\n"}, "nullnull");
        String expectedOutput = "  // Method descriptor #25 ([Ljava/lang/String;)V\n  // Stack: 4, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  new X [1]\n     3  dup\n     4  new BX [26]\n     7  dup\n     8  invokespecial BX() [28]\n    11  invokespecial X(AX) [29]\n    14  astore_1 [x]\n    15  getstatic java.lang.System.out : java.io.PrintStream [31]\n    18  aload_1 [x]\n    19  invokevirtual X.self() : X [37]\n    22  getfield X.t : AX [16]\n    25  checkcast BX [26]\n    28  getfield BX.ax : java.lang.Object [41]\n    31  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [45]\n    34  getstatic java.lang.System.out : java.io.PrintStream [31]\n    37  aload_1 [x]\n    38  invokevirtual X.self() : X [37]\n    41  getfield X.t : AX [16]\n    44  checkcast BX [26]\n    47  getfield BX.bx : java.lang.Object [51]\n    50  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [45]\n    53  return\n      Line numbers:\n        [pc: 0, line: 7]\n        [pc: 15, line: 8]\n        [pc: 34, line: 9]\n        [pc: 53, line: 10]\n      Local variable table:\n        [pc: 0, pc: 54] local: args index: 0 type: java.lang.String[]\n        [pc: 15, pc: 54] local: x index: 1 type: X\n      Local variable type table:\n        [pc: 15, pc: 54] local: x index: 1 type: X<? extends BX>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0503() throws Exception {
        this.runConformTest(new String[]{"X.java", "class XA {}\ninterface XB {\n\tXB CONST = new XB(){ public String toString() { return \"SUCCESS\"; }};\n}\nclass XAB extends XA implements XB {}\n\npublic class X <E extends XA&XB> {\n\tE e;\n  public static void main(String[] args) {\n\t  System.out.print(new X<XAB>().e.CONST);\n\t  new X<XAB>().foo();\n  }\n  public void foo() {\n    System.out.print(this.e.CONST);\n  }\n}\n"}, "SUCCESSSUCCESS");
        String expectedOutput = "// Signature: <E:LXA;:LXB;>Ljava/lang/Object;\npublic class X {\n  \n  // Field descriptor #6 LXA;\n  // Signature: TE;\n  XA e;\n  \n  // Method descriptor #10 ()V\n  // Stack: 1, Locals: 1\n  public X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [12]\n    4  return\n      Line numbers:\n        [pc: 0, line: 7]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n      Local variable type table:\n        [pc: 0, pc: 5] local: this index: 0 type: X<E>\n  \n  // Method descriptor #21 ([Ljava/lang/String;)V\n  // Stack: 3, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [22]\n     3  new X [1]\n     6  dup\n     7  invokespecial X() [28]\n    10  getfield X.e : XA [29]\n    13  checkcast XAB [31]\n    16  pop\n    17  getstatic XAB.CONST : XB [33]\n    20  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [37]\n    23  new X [1]\n    26  dup\n    27  invokespecial X() [28]\n    30  invokevirtual X.foo() : void [43]\n    33  return\n      Line numbers:\n        [pc: 0, line: 10]\n        [pc: 23, line: 11]\n        [pc: 33, line: 12]\n      Local variable table:\n        [pc: 0, pc: 34] local: args index: 0 type: java.lang.String[]\n  \n  // Method descriptor #10 ()V\n  // Stack: 2, Locals: 1\n  public void foo();\n     0  getstatic java.lang.System.out : java.io.PrintStream [22]\n     3  aload_0 [this]\n     4  getfield X.e : XA [29]\n     7  checkcast XB [48]\n    10  pop\n    11  getstatic XB.CONST : XB [50]\n    14  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [37]\n    17  return\n      Line numbers:\n        [pc: 0, line: 14]\n        [pc: 17, line: 15]\n      Local variable table:\n        [pc: 0, pc: 18] local: this index: 0 type: X\n      Local variable type table:\n        [pc: 0, pc: 18] local: this index: 0 type: X<E>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0504() throws Exception {
        this.runConformTest(new String[]{"X.java", "class XA {}\ninterface XB {\n\tXB CONST = new XB(){ public String toString() { return \"SUCCESS\"; }};\n}\nclass XAB extends XA implements XB {}\n\npublic class X <E extends XA&XB> {\n  E e() { return null; }\n  public static void main(String[] args) {\n\t  System.out.print(new X<XAB>().e().CONST);\n\t  new X<XAB>().foo();\n  }\n  public void foo() {\n    System.out.print(this.e().CONST);\n  }\n}\n"}, "SUCCESSSUCCESS");
        String expectedOutput = "// Signature: <E:LXA;:LXB;>Ljava/lang/Object;\npublic class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  public X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 7]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n      Local variable type table:\n        [pc: 0, pc: 5] local: this index: 0 type: X<E>\n  \n  // Method descriptor #17 ()LXA;\n  // Signature: ()TE;\n  // Stack: 1, Locals: 1\n  XA e();\n    0  aconst_null\n    1  areturn\n      Line numbers:\n        [pc: 0, line: 8]\n      Local variable table:\n        [pc: 0, pc: 2] local: this index: 0 type: X\n      Local variable type table:\n        [pc: 0, pc: 2] local: this index: 0 type: X<E>\n  \n  // Method descriptor #21 ([Ljava/lang/String;)V\n  // Stack: 3, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [22]\n     3  new X [1]\n     6  dup\n     7  invokespecial X() [28]\n    10  invokevirtual X.e() : XA [29]\n    13  checkcast XAB [31]\n    16  pop\n    17  getstatic XAB.CONST : XB [33]\n    20  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [37]\n    23  new X [1]\n    26  dup\n    27  invokespecial X() [28]\n    30  invokevirtual X.foo() : void [43]\n    33  return\n      Line numbers:\n        [pc: 0, line: 10]\n        [pc: 23, line: 11]\n        [pc: 33, line: 12]\n      Local variable table:\n        [pc: 0, pc: 34] local: args index: 0 type: java.lang.String[]\n  \n  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  public void foo();\n     0  getstatic java.lang.System.out : java.io.PrintStream [22]\n     3  aload_0 [this]\n     4  invokevirtual X.e() : XA [29]\n     7  checkcast XB [48]\n    10  pop\n    11  getstatic XB.CONST : XB [50]\n    14  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [37]\n    17  return\n      Line numbers:\n        [pc: 0, line: 14]\n        [pc: 17, line: 15]\n      Local variable table:\n        [pc: 0, pc: 18] local: this index: 0 type: X\n      Local variable type table:\n        [pc: 0, pc: 18] local: this index: 0 type: X<E>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0505() throws Exception {
        this.runConformTest(new String[]{"X.java", "class XA {}\ninterface XB {\n\tXB CONST = new XB(){ public String toString() { return \"SUCCESS\"; }};\n}\nclass XAB extends XA implements XB {}\n\npublic class X <E extends XA&XB> {\n  E e;\n  public static void main(String[] args) {\n\t  new X<XAB>().foo();\n  }\n  public void foo() {\n\tnew Object() {\n\t\tvoid run() {\n\t\t\tSystem.out.print(e.CONST);\n\t\t}\n\t}.run();\n    System.out.print(e.CONST);\n  }\n}\n"}, "SUCCESSSUCCESS");
        String expectedOutput = "// Signature: <E:LXA;:LXB;>Ljava/lang/Object;\npublic class X {\n  \n  // Field descriptor #6 LXA;\n  // Signature: TE;\n  XA e;\n  \n  // Method descriptor #10 ()V\n  // Stack: 1, Locals: 1\n  public X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [12]\n    4  return\n      Line numbers:\n        [pc: 0, line: 7]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n      Local variable type table:\n        [pc: 0, pc: 5] local: this index: 0 type: X<E>\n  \n  // Method descriptor #21 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  new X [1]\n     3  dup\n     4  invokespecial X() [22]\n     7  invokevirtual X.foo() : void [23]\n    10  return\n      Line numbers:\n        [pc: 0, line: 10]\n        [pc: 10, line: 11]\n      Local variable table:\n        [pc: 0, pc: 11] local: args index: 0 type: java.lang.String[]\n  \n  // Method descriptor #10 ()V\n  // Stack: 3, Locals: 1\n  public void foo();\n     0  new X$1 [28]\n     3  dup\n     4  aload_0 [this]\n     5  invokespecial X$1(X) [30]\n     8  invokevirtual X$1.run() : void [33]\n    11  getstatic java.lang.System.out : java.io.PrintStream [36]\n    14  aload_0 [this]\n    15  getfield X.e : XA [42]\n    18  checkcast XB [44]\n    21  pop\n    22  getstatic XB.CONST : XB [46]\n    25  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [50]\n    28  return\n      Line numbers:\n        [pc: 0, line: 13]\n        [pc: 8, line: 17]\n        [pc: 11, line: 18]\n        [pc: 28, line: 19]\n      Local variable table:\n        [pc: 0, pc: 29] local: this index: 0 type: X\n      Local variable type table:\n        [pc: 0, pc: 29] local: this index: 0 type: X<E>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0506() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collections;\nimport java.util.Comparator;\nimport java.util.List;\n\npublic final class X<E> {\n\tpublic void test(List list,final Comparator comparator, X x) {\n\t\tfoo(list, comparator);\n\t\tbar(list, comparator);\n\t\t\n\t\tx.foo(list, comparator);\n\t\tx.bar(list, comparator);\n\t}\n\n\t<T> void foo(List<T> lt, Comparator<? super T> ct) {\n\t}\n\tstatic <T> void bar(List<T> lt, Comparator<? super T> ct) {\n\t}\n Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tpublic void test(List list,final Comparator comparator, X x) {\n\t                 ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tpublic void test(List list,final Comparator comparator, X x) {\n\t                                 ^^^^^^^^^^\nComparator is a raw type. References to generic type Comparator<T> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tpublic void test(List list,final Comparator comparator, X x) {\n\t                                                        ^\nX is a raw type. References to generic type X<E> should be parameterized\n----------\n4. WARNING in X.java (at line 7)\n\tfoo(list, comparator);\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation foo(List, Comparator) of the generic method foo(List<T>, Comparator<? super T>) of type X<E>\n----------\n5. WARNING in X.java (at line 7)\n\tfoo(list, comparator);\n\t    ^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n6. WARNING in X.java (at line 7)\n\tfoo(list, comparator);\n\t          ^^^^^^^^^^\nType safety: The expression of type Comparator needs unchecked conversion to conform to Comparator<? super Object>\n----------\n7. WARNING in X.java (at line 8)\n\tbar(list, comparator);\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation bar(List, Comparator) of the generic method bar(List<T>, Comparator<? super T>) of type X<E>\n----------\n8. WARNING in X.java (at line 8)\n\tbar(list, comparator);\n\t    ^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n9. WARNING in X.java (at line 8)\n\tbar(list, comparator);\n\t          ^^^^^^^^^^\nType safety: The expression of type Comparator needs unchecked conversion to conform to Comparator<? super Object>\n----------\n10. WARNING in X.java (at line 10)\n\tx.foo(list, comparator);\n\t^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method foo(List, Comparator) belongs to the raw type X. References to generic type X<E> should be parameterized\n----------\n11. WARNING in X.java (at line 11)\n\tx.bar(list, comparator);\n\t^^^^^^^^^^^^^^^^^^^^^^^\nThe static method bar(List<Object>, Comparator<? super Object>) from the type X should be accessed in a static way\n----------\n12. WARNING in X.java (at line 11)\n\tx.bar(list, comparator);\n\t^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation bar(List, Comparator) of the generic method bar(List<T>, Comparator<? super T>) of type X\n----------\n13. WARNING in X.java (at line 11)\n\tx.bar(list, comparator);\n\t      ^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n14. WARNING in X.java (at line 11)\n\tx.bar(list, comparator);\n\t            ^^^^^^^^^^\nType safety: The expression of type Comparator needs unchecked conversion to conform to Comparator<? super Object>\n----------\n15. ERROR in X.java (at line 18)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0507() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\n\npublic class X {\n\tvoid foo1(List<? extends int[]> l) {\n\t\tint i = l.get(0).length;\n\t}\n\tvoid foo2(List<? extends int[]> l) {\n\t\tObject o = l.get(0).toString();\n\t}\n\tvoid foo3(List<? extends int[]> l, Serializable s) {\n\t\tboolean b = true;\n\t\tSerializable s2 = b ? l.get(0) : s;\n\t}\n}\n"}, "");
    }

    public void test0508() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\n\npublic class X {\n\tvoid foo1(List<? super int[]> l) {\n\t\tint i = l.get(0).length;\n\t}\n\tvoid foo2(List<? super int[]> l) {\n\t\tObject o = l.get(0).toString();\n\t}\n\tvoid foo3(List<? super int[]> l, Serializable s) {\n\t\tboolean b = true;\n\t\tSerializable s2 = b ? l.get(0) : s;\n\t}\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 6)\n\tint i = l.get(0).length;\n\t                 ^^^^^^\nlength cannot be resolved or is not a field\n----------\n2. ERROR in X.java (at line 13)\n\tSerializable s2 = b ? l.get(0) : s;\n\t                  ^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to Serializable\n----------\n" : "----------\n1. ERROR in X.java (at line 6)\n\tint i = l.get(0).length;\n\t                 ^^^^^^\nlength cannot be resolved or is not a field\n----------\n2. ERROR in X.java (at line 13)\n\tSerializable s2 = b ? l.get(0) : s;\n\t                      ^^^^^^^^\nType mismatch: cannot convert from capture#3-of ? super int[] to Serializable\n----------\n");
    }

    public void test0509() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n        List<MyTigerSimpleObject> list = new ArrayList<MyTigerSimpleObject>();\n        list.add(new MyTigerSimpleObject(\"a\"));\n        list.add(new MyTigerSimpleObject(\"b\"));\n        \n        for (MyTigerSimpleObject so : list)\n            System.out.println(so.getSomeAttribute());\t\t\n\t}\n}\nclass MyTigerSimpleObject<E> {\n\tMyTigerSimpleObject(String s) {}\n\tE getSomeAttribute() { return null; }\n}\n\nclass TigerList<MyTigerSimpleObject> extends ArrayList<MyTigerSimpleObject> {\n    public void listAll() {\n        for (MyTigerSimpleObject so : this)\n            System.out.println(so.getSomeAttribute());\n    }\n\t\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tList<MyTigerSimpleObject> list = new ArrayList<MyTigerSimpleObject>();\n\t     ^^^^^^^^^^^^^^^^^^^\nMyTigerSimpleObject is a raw type. References to generic type MyTigerSimpleObject<E> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tList<MyTigerSimpleObject> list = new ArrayList<MyTigerSimpleObject>();\n\t                                               ^^^^^^^^^^^^^^^^^^^\nMyTigerSimpleObject is a raw type. References to generic type MyTigerSimpleObject<E> should be parameterized\n----------\n3. WARNING in X.java (at line 5)\n\tlist.add(new MyTigerSimpleObject(\"a\"));\n\t             ^^^^^^^^^^^^^^^^^^^\nMyTigerSimpleObject is a raw type. References to generic type MyTigerSimpleObject<E> should be parameterized\n----------\n4. WARNING in X.java (at line 6)\n\tlist.add(new MyTigerSimpleObject(\"b\"));\n\t             ^^^^^^^^^^^^^^^^^^^\nMyTigerSimpleObject is a raw type. References to generic type MyTigerSimpleObject<E> should be parameterized\n----------\n5. WARNING in X.java (at line 8)\n\tfor (MyTigerSimpleObject so : list)\n\t     ^^^^^^^^^^^^^^^^^^^\nMyTigerSimpleObject is a raw type. References to generic type MyTigerSimpleObject<E> should be parameterized\n----------\n6. WARNING in X.java (at line 17)\n\tclass TigerList<MyTigerSimpleObject> extends ArrayList<MyTigerSimpleObject> {\n\t      ^^^^^^^^^\nThe serializable class TigerList does not declare a static final serialVersionUID field of type long\n----------\n7. WARNING in X.java (at line 17)\n\tclass TigerList<MyTigerSimpleObject> extends ArrayList<MyTigerSimpleObject> {\n\t                ^^^^^^^^^^^^^^^^^^^\nThe type parameter MyTigerSimpleObject is hiding the type MyTigerSimpleObject<E>\n----------\n8. ERROR in X.java (at line 20)\n\tSystem.out.println(so.getSomeAttribute());\n\t                      ^^^^^^^^^^^^^^^^\nThe method getSomeAttribute() is undefined for the type MyTigerSimpleObject\n----------\n");
    }

    public void test0510() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\n\npublic class X {\n\tpublic X() {\n\t\tString[] strings = new String[]{\"test\"};\n\n\t\t// this fails\n\t\tObject obj = ClassB.doSomething((String) strings[0]);\n\n\t\t// this works fine\n\t\tString intermediate = ClassB.doSomething((String) strings[0]);\n\t\tObject obj1 = intermediate;\n\t}\n}\n\nclass ClassB {\n\tpublic static <T extends Serializable> T doSomething(String value) {\n\t\treturn (T) value;\n\t}\n}\n"}, "");
    }

    public void test0511() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\n\npublic class X {\n\n\tstatic HashMap<Character, Character> substitutionList(String s1, String s2) {\n\n\t\tHashMap<Character, Character> subst = new HashMap<Character, Character>();\n\n\t\tfor (int i = 0; i < s1.length(); i++) {\n\t\t\tchar key = s1.charAt(i);\n\t\t\tchar value = s2.charAt(i);\n\t\t\tif (subst.containsKey(key)) {\n\t\t\t\tif (value != subst.get(key)) {\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t} else if (subst.containsValue(value)) {\n\t\t\t\treturn null;\n\t\t\t} else {\n\t\t\t\tsubst.put(key, value);\n\t\t\t}\n\t\t}\n\n\t\treturn subst;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0512() {
        this.runConformTest(new String[]{"X.java", "public class X { \n    public static void main(String argv[]) {\n\t\t\n\t\tnew X().new M<Exception>(null) {\n\t\t\tvoid run() {\n\t\t\t\tException e = ex;\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t}\n\t\t}.run();\n    }\n    class M<E extends Throwable> {\n        E ex;\n        M(E ex) {\n            this.ex = ex;\n        }\n    }\n}\n"}, "SUCCESS");
    }

    public void test0513() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n    public static void main(String argv[]) {\n\t\t\n\t\tnew X().new M(null) {\n\t\t\tvoid run() {\n\t\t\t\tException e = ex;\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t}\n\t\t}.run();\n    }\n    class M<E extends Throwable> {\n        E ex;\n        M(E ex) {\n            this.ex = ex;\n        }\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tnew X().new M(null) {\n\t\t\tvoid run() {\n\t\t\t\tException e = ex;\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t}\n\t\t}.run();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The constructor X.M(Throwable) belongs to the raw type X.M. References to generic type X.M<E> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tnew X().new M(null) {\n\t            ^\nX.M is a raw type. References to generic type X.M<E> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tnew X().new M(null) {\n\t            ^^^^^^^\nType safety: The constructor X.M(Throwable) belongs to the raw type X.M. References to generic type X.M<E> should be parameterized\n----------\n4. ERROR in X.java (at line 6)\n\tException e = ex;\n\t              ^^\nType mismatch: cannot convert from Throwable to Exception\n----------\n");
    }

    public void test0514() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tstatic <T extends Base> T infer( T t1, T t2 ) { return null; }\n\tpublic static void main( String [] args ) {\n\t\tBase base = infer( new Sub1(), new Sub2() );\n\t\t// Note: Eclipse 3.1 says this is an error, but it's not\n\t\tRunnable runnable = infer( new Sub1(), new Sub2() );\n\t}\n}\nclass Base { }\nclass Sub1 extends Base implements Runnable { public void run() { } }\nclass Sub2 extends Base implements Runnable { public void run() { } }\n"});
    }

    public void test0515() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tpublic static <T> void myMethod(final List<? extends File> fileList) {\n\t\tCollections.sort(fileList, new Comparator<File>(){\n\t\t\tpublic int compare(File f1, File f2) { return 0; }\n\t\t});\n\t}\n}\n\nclass List<T> {}\nclass File {}\ninterface Comparator<T> {}\nclass Collections {\n\tstatic <T> void sort(List<T> list, Comparator<? super T> c) {}\n}"});
    }

    public void test0516() {
        this.runConformTest(new String[]{"parser/AbstractParser.java", "package parser;\npublic abstract class AbstractParser<T> implements ValueParser<T> {\n\tpublic T parse( final String string ) {\n\t\treturn valueOf(string); \n\t}\n\tprotected abstract T valueOf(final String string);\t\n}\ninterface ValueParser<T> {\n\tT parse(final String string);\n}\n", "parser/BooleanParser.java", "package parser;\npublic class BooleanParser extends AbstractParser<Boolean> {\n\tprotected Boolean valueOf(final String string ) {\n\t\treturn Boolean.valueOf(string); \t\t\n\t}\n}\n"});
        this.runConformTest(new String[]{"test/BooleanParserTest.java", "package test;\nimport parser.BooleanParser;\npublic class BooleanParserTest {\n\tstatic final boolean getBoolean(final String value) {\n\t\treturn new BooleanParser().parse(value).booleanValue(); // The type Boolean is not visible\n\t}\n}\n"}, null, null, false, null);
    }

    public void test0517() {
        this.runNegativeTest(new String[]{"X.java", "class Base<T> {\n\tclass InnerBase {\n\t\tjava.util.List<String> list;\n\t}\n  Zork z;\n}\n\npublic class X extends Base<Integer> {\n\tclass InnerDerived extends InnerBase {\n\t\tvoid method() {\n\t\t\tlist.add(\"Hi\"); // Warning on this method call\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0518() {
        this.runNegativeTest(new String[]{"X.java", "interface Callable<T> {\n\tpublic enum Result {\n\t\tGOOD, BAD\n\t};\n\tpublic Result call(T arg);\n}\n\npublic class X implements Callable<String> {\n\tpublic Result call(String arg) {\n\t\treturn Result.GOOD;\n\t}\n  Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0519() {
        this.runConformTest(new String[]{"FooImpl.java", "interface Bar<R extends Foo<R>>  {} \n \nclass BarImpl<S extends Foo<S>> implements Bar<S> {} \n \ninterface Foo<T extends Foo<T>> extends Bar<T> {} \n \npublic class FooImpl<U extends Foo<U>> extends BarImpl<U> implements Foo<U> {}\n\n"}, "");
    }

    public void test0520() {
        this.runConformTest(new String[]{"Bar.java", "public interface Bar<R extends Foo<R>>  {} \n", "BarImpl.java", "public class BarImpl<S extends Foo<S>> implements Bar<S> {} \n", "Foo.java", "public interface Foo<T extends Foo<T>> extends Bar<T> {} \n"}, "");
        this.runConformTest(new String[]{"FooImpl.java", "public class FooImpl<U extends Foo<U>> extends BarImpl<U> implements Foo<U> {}\n"}, "", null, false, null);
    }

    public void test0521() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tstatic public <T extends Collection> void addAll(T a, T b) {\n\t\ta.addAll(b);\n\t}\n\tstatic public void main(String[] args) {\n\t\tCollection<Integer> a = new ArrayList<Integer>();\n\t\tCollection<String> b = new ArrayList<String>();\n\t\tb.add(\"string\");\n\t\taddAll(a, b);\n\t\ttry {\n\t\t\tSystem.out.println(a.iterator().next().intValue()); // ClassCastException\n\t\t} catch(ClassCastException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0522() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tstatic public <T extends Collection> void addAll(T a, T b) {\n\t\ta.addAll(b);\n\t}\n\tstatic public void main(String[] args) {\n\t\tCollection<Integer> a = new ArrayList<Integer>();\n\t\tCollection<String> b = new ArrayList<String>();\n\t\tb.add(\"string\");\n\t\taddAll(a, b);\n\t\ttry {\n\t\t\tSystem.out.println(a.iterator().next().intValue()); // ClassCastException\n\t\t} catch(ClassCastException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tstatic public <T extends Collection> void addAll(T a, T b) {\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\ta.addAll(b);\n\t^^^^^^^^^^^\nType safety: The method addAll(Collection) belongs to the raw type Collection. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in X.java (at line 18)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0523() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic X() {\n\t\tM m = new M();\n\t\tList<String> ls = m.list(); // rawified even though wasn't using T parameter\n\t}\n\tZork z;\n\tstatic class M<T> {\n\t\tList<String> list() {\n\t\t\treturn null;\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tM m = new M();\n\t^\nX.M is a raw type. References to generic type X.M<T> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tM m = new M();\n\t          ^\nX.M is a raw type. References to generic type X.M<T> should be parameterized\n----------\n3. WARNING in X.java (at line 5)\n\tList<String> ls = m.list(); // rawified even though wasn't using T parameter\n\t                  ^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n4. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0524() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\nclass MyList extends ArrayList<String> {\n}\n\npublic class X {\n    public static void main(String[] args) {\n        List<? extends String> a = new MyList();\n        List<String> b = (MyList) a;     \n    }\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tclass MyList extends ArrayList<String> {\n\t      ^^^^^^\nThe serializable class MyList does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0525() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tList list = new ArrayList();\n\t\t\tString s = \"this shouldn't work\";\n\t\t\tlist.add(s);\n\t\t\tList<Integer> listInt = list;\n\t\t\tint i = listInt.get(0);\n\t\t} catch(ClassCastException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0526() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    Zork z;\n    <T> T f(Object o) {\n\treturn (T) o; // OK\n    }\n\n    <U, T extends U> T g(Object o) {\n\treturn (T) o; // bug???\n    }\n\n    <U, T extends U> T h(Object o) {\n\treturn X.<T>castTo(o); // workaround\n    }\n\n    private static <T> T castTo(Object o) {\n\treturn (T) o;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 4)\n\treturn (T) o; // OK\n\t       ^^^^^\nType safety: Unchecked cast from Object to T\n----------\n3. WARNING in X.java (at line 8)\n\treturn (T) o; // bug???\n\t       ^^^^^\nType safety: Unchecked cast from Object to T\n----------\n4. WARNING in X.java (at line 16)\n\treturn (T) o;\n\t       ^^^^^\nType safety: Unchecked cast from Object to T\n----------\n");
    }

    public void test0527() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T, U extends T, V extends T> T foo(U u, V v) {\n\t\treturn this == null ? (T) u : (T)v;\n\t}\n\tZork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0528() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends X.M> extends Y {}\nclass Y { static class M {} }\n"}, "");
    }

    public void test0529() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<T extends List> {\n\tvoid bar() {\n\t\tT t = new ArrayList(); // BUG!!!\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic class X<T extends List> {\n\t                         ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in X.java (at line 4)\n\tT t = new ArrayList(); // BUG!!!\n\t      ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from ArrayList to T\n----------\n3. WARNING in X.java (at line 4)\n\tT t = new ArrayList(); // BUG!!!\n\t          ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n");
    }

    public void test0530() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\nabstract class Foo<T extends List>\n {\n  abstract void foo(T t);\n  void foo2()\n  {\n    List l = new LinkedList();\n    foo(l); // BUG!!!\n  }\n}\n\npublic class X extends Foo<ArrayList>\n{\n  void foo(ArrayList l)\n  {\n    System.out.println(l);\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tabstract class Foo<T extends List>\n\t                             ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\tList l = new LinkedList();\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 8)\n\tList l = new LinkedList();\n\t             ^^^^^^^^^^\nLinkedList is a raw type. References to generic type LinkedList<E> should be parameterized\n----------\n4. ERROR in X.java (at line 9)\n\tfoo(l); // BUG!!!\n\t^^^\nThe method foo(T) in the type Foo<T> is not applicable for the arguments (List)\n----------\n5. WARNING in X.java (at line 13)\n\tpublic class X extends Foo<ArrayList>\n\t                           ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n6. WARNING in X.java (at line 15)\n\tvoid foo(ArrayList l)\n\t     ^^^^^^^^^^^^^^^^\nThe method foo(ArrayList) of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n7. WARNING in X.java (at line 15)\n\tvoid foo(ArrayList l)\n\t         ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n");
    }

    public void test0531() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Vector;\n\npublic class X<T> {\n\tpublic T f1(T l) {\n\t\tVector<T> v = new Vector<T>();\n\t\tv.add(l);\n\t\treturn (T) v.get(0); // Expect warning here\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\treturn (T) v.get(0); // Expect warning here\n\t       ^^^^^^^^^^^^\nUnnecessary cast from T to T\n----------\n2. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0532() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X extends Z<Boolean> {\n\t@Override public Boolean value() { return true; }\n}\nabstract class Z<T> {\n\tpublic T foo() { return value(); }\n\tpublic abstract T value();\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "import p.X;\npublic class Y { boolean test() { return new X().foo().booleanValue(); } }\n"}, "", null, false, null);
    }

    public void test0533() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.EnumSet;\n\nenum Foo {\n\tblargh, baz, boz;\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = Foo.class;\n\t\tEnumSet<Enum> eSet = EnumSet.allOf(c);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tClass c = Foo.class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. WARNING in X.java (at line 10)\n\tEnumSet<Enum> eSet = EnumSet.allOf(c);\n\t        ^^^^\nEnum is a raw type. References to generic type Enum<E> should be parameterized\n----------\n3. ERROR in X.java (at line 10)\n\tEnumSet<Enum> eSet = EnumSet.allOf(c);\n\t        ^^^^\nBound mismatch: The type Enum is not a valid substitute for the bounded parameter <E extends Enum<E>> of the type EnumSet<E>\n----------\n4. WARNING in X.java (at line 10)\n\tEnumSet<Enum> eSet = EnumSet.allOf(c);\n\t                     ^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation allOf(Class) of the generic method allOf(Class<E>) of type EnumSet\n----------\n5. WARNING in X.java (at line 10)\n\tEnumSet<Enum> eSet = EnumSet.allOf(c);\n\t                     ^^^^^^^^^^^^^^^^\nType safety: The expression of type EnumSet needs unchecked conversion to conform to EnumSet<Enum>\n----------\n6. WARNING in X.java (at line 10)\n\tEnumSet<Enum> eSet = EnumSet.allOf(c);\n\t                                   ^\nType safety: The expression of type Class needs unchecked conversion to conform to Class<Enum>\n----------\n");
    }

    public void test0534() {
        this.runConformTest(new String[]{"X.java", "import java.util.EnumSet;\n\nenum Foo {\n\tblargh, baz, boz;\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = Foo.class;\n\t\tEnumSet<Foo> eSet = EnumSet.allOf(c);\n\t}\n}\n"}, "");
    }

    public void test0535() {
        this.runConformTest(new String[]{"X.java", "import java.util.EnumSet;\n\nenum Foo {\n\tblargh, baz, boz;\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = Foo.class;\n\t\tEnumSet<? extends Enum> eSet = EnumSet.allOf(c);\n\t}\n}\n"}, "");
    }

    public void test0536() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.EnumSet;\n\nenum Foo {\n\tblargh, baz, boz;\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = Foo.class;\n\t\tEnumSet<?> eSet = (EnumSet<?>) EnumSet.allOf(c);\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tClass c = Foo.class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. WARNING in X.java (at line 10)\n\tEnumSet<?> eSet = (EnumSet<?>) EnumSet.allOf(c);\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from EnumSet to EnumSet<?>\n----------\n3. WARNING in X.java (at line 10)\n\tEnumSet<?> eSet = (EnumSet<?>) EnumSet.allOf(c);\n\t                               ^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation allOf(Class) of the generic method allOf(Class<E>) of type EnumSet\n----------\n4. WARNING in X.java (at line 10)\n\tEnumSet<?> eSet = (EnumSet<?>) EnumSet.allOf(c);\n\t                                             ^\nType safety: The expression of type Class needs unchecked conversion to conform to Class<Enum<Enum<E>>>\n----------\n5. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0537() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.EnumSet;\n\nenum Foo {\n\tblargh, baz, boz;\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = Foo.class;\n\t\tEnumSet<?> eSet = EnumSet.allOf(c);\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tClass c = Foo.class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. WARNING in X.java (at line 10)\n\tEnumSet<?> eSet = EnumSet.allOf(c);\n\t                  ^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation allOf(Class) of the generic method allOf(Class<E>) of type EnumSet\n----------\n3. WARNING in X.java (at line 10)\n\tEnumSet<?> eSet = EnumSet.allOf(c);\n\t                                ^\nType safety: The expression of type Class needs unchecked conversion to conform to Class<Enum<Enum<E>>>\n----------\n4. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0538() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.EnumSet;\n\nenum Foo {\n\tblargh, baz, boz;\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = Foo.class;\n\t\tEnumSet<Enum<?>> eSet = EnumSet.allOf(c);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tClass c = Foo.class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 10)\n\tEnumSet<Enum<?>> eSet = EnumSet.allOf(c);\n\t        ^^^^\nBound mismatch: The type Enum<?> is not a valid substitute for the bounded parameter <E extends Enum<E>> of the type EnumSet<E>\n----------\n3. WARNING in X.java (at line 10)\n\tEnumSet<Enum<?>> eSet = EnumSet.allOf(c);\n\t                        ^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation allOf(Class) of the generic method allOf(Class<E>) of type EnumSet\n----------\n4. WARNING in X.java (at line 10)\n\tEnumSet<Enum<?>> eSet = EnumSet.allOf(c);\n\t                        ^^^^^^^^^^^^^^^^\nType safety: The expression of type EnumSet needs unchecked conversion to conform to EnumSet<Enum<?>>\n----------\n5. WARNING in X.java (at line 10)\n\tEnumSet<Enum<?>> eSet = EnumSet.allOf(c);\n\t                                      ^\nType safety: The expression of type Class needs unchecked conversion to conform to Class<Enum<?>>\n----------\n");
    }

    public void test0539() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t static class B<C> {\n\t\t \t\t public <T extends I1> T willBe(Class<T> c) {\n\t\t \t\t \t\t return (T)null;\n\t\t \t\t }\n\t\t }\n\t\t interface I1  {\n\t\t }\n\t\t interface I2  extends I1 {\n\t\t }\n\t\t \n\t\t public static void m1(String[] args) {\n\t\t \t\t B b = new B();\n\t\t \t\t I2 v = b.willBe(I2.class);\n\t\t }\n\t\t public static void m2(String[] args) {\n\t\t \t\t B<Void> b = new B<Void>();\n\t\t \t\t I2 v = b.willBe(I2.class);\n\t\t }\n\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\treturn (T)null;\n\t       ^^^^^^^\nUnnecessary cast from null to T\n----------\n2. WARNING in X.java (at line 13)\n\tB b = new B();\n\t^\nX.B is a raw type. References to generic type X.B<C> should be parameterized\n----------\n3. WARNING in X.java (at line 13)\n\tB b = new B();\n\t          ^\nX.B is a raw type. References to generic type X.B<C> should be parameterized\n----------\n4. WARNING in X.java (at line 14)\n\tI2 v = b.willBe(I2.class);\n\t       ^^^^^^^^^^^^^^^^^^\nType safety: The method willBe(Class) belongs to the raw type X.B. References to generic type X.B<C> should be parameterized\n----------\n5. ERROR in X.java (at line 14)\n\tI2 v = b.willBe(I2.class);\n\t       ^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X.I1 to X.I2\n----------\n");
    }

    public void test0540() {
        this.runNegativeTest(new String[]{"Baz.java", "import java.util.*;\ninterface Foo<X> {}\ninterface Bar extends Foo {\n}\npublic class Baz<R,D>  {\n    public R visit(Collection<? extends Foo<?>> trees, D d) {\n\treturn null;\n    }\n    R test(Collection<Bar> c, D d) {\n\treturn visit(c, d);\n    }\n}\n"}, "----------\n1. WARNING in Baz.java (at line 3)\n\tinterface Bar extends Foo {\n\t                      ^^^\nFoo is a raw type. References to generic type Foo<X> should be parameterized\n----------\n2. ERROR in Baz.java (at line 10)\n\treturn visit(c, d);\n\t       ^^^^^\nThe method visit(Collection<? extends Foo<?>>, D) in the type Baz<R,D> is not applicable for the arguments (Collection<Bar>, D)\n----------\n");
    }

    public void test0541() {
        this.runConformTest(new String[]{"X.java", "import java.util.Map;\npublic class X {\n   public static void main(String[] args) {\n     Map m = null;\n\t try {\n\t     Map m2 = m.getClass().newInstance();\n\t } catch(Exception e) {\n\t }\n   }\n}\n"}, "");
    }

    public void test0542() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic <T> boolean isOK(T x) {\n\t\treturn isOK(x);\n\t}\n\n\tstatic <T> boolean isStillOK(T x) {\n\t\treturn true && isOK(x);\n\t}\n\n\tstatic <T> boolean isNoMoreOK(T x) {\n\t\treturn true && isNoMoreOK(x);\n\t}\n\n\tstatic <T> boolean isOKAgain(T x) {\n\t\tboolean res;\n\t\treturn true && (res = isOKAgain(x));\n\t}\n}\n"}, "");
    }

    public void test0543() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tObject obj = null;\n\t\tList<String> ls = (List<String>) obj;\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tList<String> ls = (List<String>) obj;\n\t                  ^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to List<String>\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0544() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Vector;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tVector<Integer> a = new Vector<Integer>();\n\t\tVector b = new Vector();\n\t\tb.add(new Object());\n\t\ta = b;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tVector b = new Vector();\n\t^^^^^^\nVector is a raw type. References to generic type Vector<E> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tVector b = new Vector();\n\t               ^^^^^^\nVector is a raw type. References to generic type Vector<E> should be parameterized\n----------\n3. WARNING in X.java (at line 7)\n\tb.add(new Object());\n\t^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type Vector. References to generic type Vector<E> should be parameterized\n----------\n4. WARNING in X.java (at line 8)\n\ta = b;\n\t    ^\nType safety: The expression of type Vector needs unchecked conversion to conform to Vector<Integer>\n----------\n5. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0545() {
        this.runNegativeTest(new String[]{"X.java", "class B extends A<Object> {\n\tvoid m2() {\n\t\tm3((X2) m());  // A<Object>.m() --> X<? extends Object> - cannot cast to X2\n\t}\n\tvoid m3(X2 i) {}\n}\nclass A<T> {\n\tX<? extends T> m() {\n\t\treturn null;\n\t}\n}\n\nclass X2 extends X<String> {\n}\n\npublic class X<T> {\n\tvoid foo(X<String> lhs, X<? extends Object> rhs) {\n\t\tlhs = rhs; // cannot convert\n\t}\n\tvoid bar(X2 lhs, X<? extends Object> rhs) {\n\t\tlhs = rhs; // cannot convert\n\t}\n}\nclass C {\n\tvoid foo(X<? extends Object> xo) {}\n\tvoid bar(X<String> xs) {}\n}\nclass D extends C {\n\tvoid foo(X<String> xs) {}\n\tvoid bar(X<? extends Object> xo) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tlhs = rhs; // cannot convert\n\t      ^^^\nType mismatch: cannot convert from X<capture#2-of ? extends Object> to X<String>\n----------\n2. ERROR in X.java (at line 21)\n\tlhs = rhs; // cannot convert\n\t      ^^^\nType mismatch: cannot convert from X<capture#3-of ? extends Object> to X2\n----------\n3. ERROR in X.java (at line 29)\n\tvoid foo(X<String> xs) {}\n\t     ^^^^^^^^^^^^^^^^^\nName clash: The method foo(X<String>) of type D has the same erasure as foo(X<? extends Object>) of type C but does not override it\n----------\n4. ERROR in X.java (at line 30)\n\tvoid bar(X<? extends Object> xo) {}\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method bar(X<? extends Object>) of type D has the same erasure as bar(X<String>) of type C but does not override it\n----------\n");
    }

    public void test0546() {
        this.runNegativeTest(new String[]{"X.java", "class StringList extends java.util.LinkedList<String> {\n}\n\npublic class X {\n    public static void main(String[] args) {\n        java.util.List<? extends String> a = new StringList();\n        java.util.List<String> b = (StringList) a;      // warned but safe.\n    }\n   Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tclass StringList extends java.util.LinkedList<String> {\n\t      ^^^^^^^^^^\nThe serializable class StringList does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0547() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic <K> TreeMap<K,K> essai(K type) {\n\t\tTreeMap<K,K> treeMap = new TreeMap<K,K>();\n\t\treturn treeMap;\n\t}\n\tpublic static void main(String args[]) {\n\t\tX x = new X();\n\t\tTreeMap<?,?> treeMap = x.essai(null);\n\t}\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0548() {
        this.runNegativeTest(new String[]{"X.java", "interface DA<T> {\n}\ninterface DB<T> extends DA<T> {\n}\ninterface DC<T> extends DA<Integer> {\n}\n\npublic class X {\n\tObject o = (DC<?>) (DA<?>) null;\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tObject o = (DC<?>) (DA<?>) null;\n\t           ^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from DA<capture#1-of ?> to DC<?>\n----------\n2. WARNING in X.java (at line 9)\n\tObject o = (DC<?>) (DA<?>) null;\n\t                   ^^^^^^^^^^^^\nUnnecessary cast from null to DA<?>\n----------\n3. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0549() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tboolean DEBUG = this instanceof Special;\n\n\tpublic static class Special extends X<String> {\n\t}\n}\n"}, "");
    }

    public void test0550() {
        this.runNegativeTest(new String[]{"X.java", "class A {}\nclass B extends A {}\n\npublic class X<T> {\n    public <U extends B> void foo(X<? super A> param) {\n        X<U> foo = (X<U>)param;\n    }\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tX<U> foo = (X<U>)param;\n\t           ^^^^^^^^^^^\nCannot cast from X<capture#1-of ? super A> to X<U>\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0551() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    <T, U extends T, V extends T> T cond1(boolean z, U x1, V x2) {\n        return (z? (T) x1: x2);\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\t<T, U extends T, V extends T> T cond1(boolean z, U x1, V x2) {\n\t                                              ^\nThe parameter z is hiding a field from type X\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0552() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tComparable<?> x;\n\n\tvoid put(Comparable<?> c) {\n\t\tthis.x = c;\n\t}\n\n\tComparable<?> get() {\n\t\treturn x;\n\t}\n\n\tvoid test() {\n\t\tX ci = new X();\n\t\tci.put(new Integer(3));\n\t\tInteger i = (Integer) ci.get();\n\t}\n\n}\n"}, "");
    }

    public void test0553() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String args[]) throws Exception {\n      doIt();\n      System.out.println(\"SUCCESS\");\n   }\n   public static void doIt() {\n      Holder<Integer> association = new Holder<Integer>(new Integer(0));\n      Integer sizeHolder = (Integer)(association.getValue()); //Cast to Integer is redundant!!!\n      System.out.print(sizeHolder.intValue());\n   }\n   static class Holder<V> {\n      V value;\n      Holder(V value) {\n         this.value = value;\n      }\n      V getValue() {\n         return value;\n      }\n   }\n}\n"}, "0SUCCESS");
    }

    public void test0554() {
        this.runNegativeTest(new String[]{"X.java", " import java.util.*;\n public class X<T> {\n public static void main(String[] args) {\n\t\tX<? extends Object> xo = null;\n\t\tX<String> xs = null;\n\t\tX2 x2 = null;\n\t\t\n\t\tObject o1 = (X<String>) xo;\n\t\tObject o2 = (X<? extends Object>) xs;\n\t\tObject o3 = (X2) xo;\n\t\tObject o4 = (X<? extends Object>) x2;\n\t\tObject o5 = (X3<String>) xo;\n\t}\n}\nclass X2 extends X<String> {\n}\nclass X3<U> extends X<U> {\n   Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tObject o1 = (X<String>) xo;\n\t            ^^^^^^^^^^^^^^\nType safety: Unchecked cast from X<capture#1-of ? extends Object> to X<String>\n----------\n2. WARNING in X.java (at line 8)\n\tObject o1 = (X<String>) xo;\n\t            ^^^^^^^^^^^^^^\nUnnecessary cast from X<capture#1-of ? extends Object> to X<String>\n----------\n3. WARNING in X.java (at line 9)\n\tObject o2 = (X<? extends Object>) xs;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from X<String> to X<? extends Object>\n----------\n4. WARNING in X.java (at line 10)\n\tObject o3 = (X2) xo;\n\t            ^^^^^^^\nUnnecessary cast from X<capture#3-of ? extends Object> to X2\n----------\n5. WARNING in X.java (at line 11)\n\tObject o4 = (X<? extends Object>) x2;\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from X2 to X<? extends Object>\n----------\n6. WARNING in X.java (at line 12)\n\tObject o5 = (X3<String>) xo;\n\t            ^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X<capture#5-of ? extends Object> to X3<String>\n----------\n7. WARNING in X.java (at line 12)\n\tObject o5 = (X3<String>) xo;\n\t            ^^^^^^^^^^^^^^^\nUnnecessary cast from X<capture#5-of ? extends Object> to X3<String>\n----------\n8. ERROR in X.java (at line 18)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0555() {
        this.runNegativeTest(new String[]{"X.java", " import java.util.List;\n public class X<U extends Number> {\n U u;\n void foo(X<? extends Number> xn, X<? extends U> xu) {\n\t\txn = xu;\n\t\txu = xn;\n\t\txu.u = xn.u; // ko\n\t\txn.u = xu.u; // ko\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\txu = xn;\n\t     ^^\nType mismatch: cannot convert from X<capture#4-of ? extends Number> to X<? extends U>\n----------\n2. ERROR in X.java (at line 7)\n\txu.u = xn.u; // ko\n\t       ^^^^\nType mismatch: cannot convert from capture#6-of ? extends Number to capture#5-of ? extends U\n----------\n3. ERROR in X.java (at line 8)\n\txn.u = xu.u; // ko\n\t       ^^^^\nType mismatch: cannot convert from capture#8-of ? extends U to capture#7-of ? extends Number\n----------\n");
    }

    public void test0556() {
        this.runConformTest(new String[]{"X.java", "interface Foo {\n\tObject get();\n}\n\ninterface MyList<F> extends Foo {\n\tpublic F get();\n}\n\nclass MyListImpl<G> implements MyList<G> {\n\tpublic G get() {\n\t\tSystem.out.println(\"SUCCESS\");\n\t\treturn null;\n\t}\n}\n\ninterface StringList extends MyList<String> {\n}\n\nclass StringListImpl extends MyListImpl<String> implements StringList {\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tFoo f = new StringListImpl();\n\t\tf.get();\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0557() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic <T extends Exception> void foo(T t) throws T {\n\t}\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "import java.io.*;\npublic class Y {\n\tvoid foo() {\n\t\ttry {\n\t\t\tX.foo(new IOException());\n\t\t} catch(IOException e){\n\t\t}\n\t}\n}\n"}, "", null, false, null);
    }

    public void test0558() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic <T extends Exception, U extends Exception> void foo(T t, U u) throws T, U {\n\t}\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "import java.io.*;\npublic class Y {\n\tvoid foo() {\n\t\ttry {\n\t\t\tX.foo(new IOException(), new ClassNotFoundException());\n\t\t} catch(IOException e){\n\t\t} catch(ClassNotFoundException e){\n\t\t}\n\t}\n}\n"}, "", null, false, null);
    }

    public void test0559() {
        this.runNegativeTest(new String[]{"X.java", "class Cell<T> {\n\tT t;\n\tpublic void setT(T t) {\n\t\tthis.t= t;\n\t}\n\tpublic T getT() {\n\t\treturn t;\n\t}\n}\n\npublic class X {\n  Zork z;\n\tpublic static void main(String[] args) {\n\t\tCell c= new Cell();\n\t\tc.setT(Boolean.FALSE); // other: warning: [unchecked] unchecked\n\t\t\t// call to setT(T) as a member of the raw type p.Cell\n\t\tc.t= Boolean.TRUE; // other: warning: [unchecked] unchecked call\n\t\t\t// to setT(T) as a member of the raw type p.Cell\n\t\tboolean b1= (Boolean) c.getT();\n\t\tboolean b2= (Boolean) c.t;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 14)\n\tCell c= new Cell();\n\t^^^^\nCell is a raw type. References to generic type Cell<T> should be parameterized\n----------\n3. WARNING in X.java (at line 14)\n\tCell c= new Cell();\n\t            ^^^^\nCell is a raw type. References to generic type Cell<T> should be parameterized\n----------\n4. WARNING in X.java (at line 15)\n\tc.setT(Boolean.FALSE); // other: warning: [unchecked] unchecked\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: The method setT(Object) belongs to the raw type Cell. References to generic type Cell<T> should be parameterized\n----------\n5. WARNING in X.java (at line 17)\n\tc.t= Boolean.TRUE; // other: warning: [unchecked] unchecked call\n\t  ^\nType safety: The field t from the raw type Cell is assigned a value of type Boolean. References to generic type Cell<T> should be parameterized\n----------\n");
    }

    public void test0560() {
        this.runConformTest(new String[]{"X.java", "interface IController<U extends IView<?>>  {\n    public U getView() ;\n}\ninterface IView<U>  {\n}\nclass MatGroup   {\n\tpublic abstract static class View implements IView<String> {\n\t\tpublic void setTempAppearance() {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n\t\n\tpublic abstract static class Ctrl<U extends View> implements IController<U>  {\n\t}\n}\npublic class X {\n\tpublic static void main(String []args) {\n\t\tMatGroup.Ctrl<?>children[] = { \n\t\t\t\tnew MatGroup.Ctrl<MatGroup.View>(){\n\t\t\t\t\tpublic MatGroup.View getView() { return new MatGroup.View(){}; }\t\n\t\t\t\t}} ;\n\t    for(MatGroup.Ctrl<?> glmat: children) {\n\t\t\tglmat.getView().setTempAppearance() ;\n\t    }\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0561() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(A<String> a) {}\n\t     ^^^^^^^^^^^^^^^^\nErasure of method foo(A<String>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 3)\n\tObject foo(A<Integer> a) { return null; }\n\t       ^^^^^^^^^^^^^^^^^\nErasure of method foo(A<Integer>) is the same as another method in type X\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(A<String> a) {}\n\t     ^^^^^^^^^^^^^^^^\nErasure of method foo(A<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\tObject foo(A<Integer> a) { return null; }\n\t       ^^^^^^^^^^^^^^^^^\nErasure of method foo(A<Integer>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 4)\n\tvoid test(A<Integer> a) { foo(a); }\n\t                          ^^^\nThe method foo(A<String>) in the type X is not applicable for the arguments (A<Integer>)\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(A<String> a) {}\n\tObject foo(A<Integer> a) { return null; }\n\t void test(A<Integer> a) { foo(a); }\n}\nclass A<T> {}\n"}, expectedCompilerLog);
        String expectedCompilerLog2 = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\tNumber foo(A<String> a) { return null; }\n\t       ^^^^^^^^^^^^^^^^\nErasure of method foo(A<String>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 3)\n\tInteger foo(A<Integer> a) { return null; }\n\t        ^^^^^^^^^^^^^^^^^\nErasure of method foo(A<Integer>) is the same as another method in type X\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\tNumber foo(A<String> a) { return null; }\n\t       ^^^^^^^^^^^^^^^^\nErasure of method foo(A<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\tInteger foo(A<Integer> a) { return null; }\n\t        ^^^^^^^^^^^^^^^^^\nErasure of method foo(A<Integer>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 4)\n\tvoid test(A<Integer> a) { foo(a); }\n\t                          ^^^\nThe method foo(A<String>) in the type X is not applicable for the arguments (A<Integer>)\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tNumber foo(A<String> a) { return null; }\n\tInteger foo(A<Integer> a) { return null; }\n\tvoid test(A<Integer> a) { foo(a); }\n}\nclass A<T> {}\n"}, expectedCompilerLog2);
    }

    public void test0562() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\ninterface Inter<A, B> {}\npublic class X<T, U, V extends X<T, U, V>> extends ArrayList<V> implements Inter<T, U> {\n\tpublic final void foo(U u) {\n\t\tX.bar(this, u);\n\t}\n\tpublic static final <P, Q> void bar(Collection<? extends Inter<P, Q>> c, Q q) {}\n}\n"}, "");
    }

    public void test0563() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\ninterface Inter<A, B> {}\npublic class X<T, U, V extends X<T, U, V>> extends ArrayList<V> implements Inter<T, U> {\n\tpublic final void foo(U u) {\n\t\tX.bar(this, u);\n\t}\n\tpublic static final <P, Q, R> void bar(Collection<R> c, Q q) {}\n}\n"}, "");
    }

    public void test0564() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\ninterface Inter<A, B> {}\npublic class X<T, U, V extends X<T, U, V>> extends ArrayList<V> implements Inter<T, U> {\n\tpublic final void foo(U u) {\n\t\tX.bar(this, u);\n\t}\n\tpublic static final <P, Q> void bar(Collection<? extends Inter<P, Q>> c, Q q) {}\n}\n"}, "");
    }

    public void test0565() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\ninterface IFoo<T> {\n    public T get(Class<T> clazz);\n   Zork z;\n}\n\nclass Bar implements IFoo<Integer> {\n    public Integer get(Class<Integer> arg0) {\n        return new Integer(3);\n    }\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0566() {
        String xSource = "import java.util.*;\n\npublic class X {\n\n\tvoid bar2() {\n\t\tList<X1> le = new ArrayList<X1>(5);\n\t\tle = fill(le, new X2());\n\t}\n\t<T> List<T> fill(List<? super T> lt, T t) { return null; }\n}\nclass X1 {}\nclass X2 extends X1 {\n\tvoid foo(){}\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 7)\n\tle = fill(le, new X2());\n\t     ^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<X2> to List<X1>\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", xSource});
        }
    }

    public void test0567() {
        this.runConformTest(new String[]{"Thrower.java", "public interface Thrower<E extends Exception> {\n    public void throwIt() throws E;\n}\n"}, "");
        this.runConformTest(new String[]{"GenericsTest.java", "public class GenericsTest {\n    public static void main(String[] args) throws MyException {\n        Thrower<MyException> thrower = new Thrower<MyException>() {\n            public void throwIt() throws MyException {\n                throw new MyException();\n            }\n        };\n        try {\n           thrower.throwIt();\n        } catch(Exception e) {\n          System.out.println(\"SUCCESS\");\n        }\n    }\n}\nclass MyException extends Exception {\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test0568() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\n    public static void main(String[] args) {\n\n        ArrayList<ArrayList<Long>> n = new ArrayList<ArrayList<Long>>();\n        ArrayList<Long> arr = new ArrayList<Long>();\n        arr.add(new Long(5));\n        n.add(arr);\n        \n        List<? extends List<Long>> m = n; // Whoa!\n        \n        for(Long l : m.get(0)) {\n            System.out.println(l);\n        }\n    }\n\n}\n"}, "5");
    }

    public void test0569() {
        this.runNegativeTest(new String[]{"X.java", "public class X\n{\n    protected static <T extends Exception> void foo() throws T, Exce {\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tprotected static <T extends Exception> void foo() throws T, Exce {\n\t                                                            ^^^^\nExce cannot be resolved to a type\n----------\n");
    }

    public void test0570() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Object> {\n  public class InnerClass implements Comparable<T> {\n    public int compareTo(T other) {\n      return -1;\n    }\n  }\n  \n  public void foo() {\n    InnerClass a = new InnerClass();\n    InnerClass b = new InnerClass();\n    // The following line does not compile (anymore):\n    a.compareTo(b);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\ta.compareTo(b);\n\t  ^^^^^^^^^\nThe method compareTo(T) in the type X<T>.InnerClass is not applicable for the arguments (X<T>.InnerClass)\n----------\n");
    }

    public void test0571() {
        this.runConformTest(true, new String[]{"X.java", "interface IFoo {\n\tvoid foo();\n}\nclass Box<T extends IFoo> {\n\tT value() {\n\t\treturn null;\n\t}\n}\n\ninterface IBar {\n\tvoid bar();\n}\n\npublic class X {\n\tvoid test01(Box<?> box) {\n\t\tbox.value().foo();\n\t}\n\tvoid test02(Box<? extends IBar> box) {\n\t\tbox.value().foo();\n\t\tbox.value().bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, null, null, null, "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0572() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic <T extends Enum<T>> void doWithEnumClass(Class<T> enumClass) {\n\t}\n\n\tpublic void f() {\n\t\tClass<?> cl = null; // Returned by Class.forName(\"xyz\");\n\t\tdoWithEnumClass((Class<Enum>) cl);\n\t}\n}\n"}, "");
    }

    public void test0573() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic <T extends Enum<T>> void doWithEnumClass(Class<T> enumClass) {\n\t\tZork z;\n\t}\n\n\tpublic void f() {\n\t\tClass<?> cl = null; // Returned by Class.forName(\"xyz\");\n\t\tdoWithEnumClass((Class<Enum>) cl);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 8)\n\tdoWithEnumClass((Class<Enum>) cl);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation doWithEnumClass(Class<Enum>) of the generic method doWithEnumClass(Class<T>) of type X\n----------\n3. WARNING in X.java (at line 8)\n\tdoWithEnumClass((Class<Enum>) cl);\n\t                ^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Class<capture#1-of ?> to Class<Enum>\n----------\n4. WARNING in X.java (at line 8)\n\tdoWithEnumClass((Class<Enum>) cl);\n\t                       ^^^^\nEnum is a raw type. References to generic type Enum<E> should be parameterized\n----------\n");
    }

    public void test0574() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 6)\n\t<T extends Integer> T foo(Object o) {  return null; } // ok\n\t           ^^^^^^^\nThe type parameter T should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n2. WARNING in X.java (at line 6)\n\t<T extends Integer> T foo(Object o) {  return null; } // ok\n\t                      ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C2\n----------\n3. WARNING in X.java (at line 7)\n\t<T extends String> T foo(Object o) {  return null; } // ok\n\t           ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n4. WARNING in X.java (at line 7)\n\t<T extends String> T foo(Object o) {  return null; } // ok\n\t                     ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C2\n----------\n5. ERROR in X.java (at line 10)\n\tnew X().new C2().foo((List<String>) null);\n\t                 ^^^\nThe method foo(Object) is ambiguous for the type X.C2\n----------\n" : "----------\n1. WARNING in X.java (at line 6)\n\t<T extends Integer> T foo(Object o) {  return null; } // ok\n\t           ^^^^^^^\nThe type parameter T should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 6)\n\t<T extends Integer> T foo(Object o) {  return null; } // ok\n\t                      ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C2\n----------\n3. WARNING in X.java (at line 7)\n\t<T extends String> T foo(Object o) {  return null; } // ok\n\t           ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n4. ERROR in X.java (at line 7)\n\t<T extends String> T foo(Object o) {  return null; } // ok\n\t                     ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C2\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\n\tclass C2 {\n\t\t<T extends Integer> T foo(Object o) {  return null; } // ok\n\t\t<T extends String> T foo(Object o) {  return null; } // ok\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new C2().foo((List<String>) null);\n\t}\n}\n"}, expectedCompilerLog);
    }

    public void test0575() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        Foo<?> f1 = new Foo<Integer>();\n        (f1).bar = (f1).bar;\n    }\n    static class Foo<T> {\n       Bar<T> bar = new Bar<T>();\n    }\n    static class Bar<T> {\n        T t;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t(f1).bar = (f1).bar;\n\t           ^^^^^^^^\nType mismatch: cannot convert from X.Bar<capture#2-of ?> to X.Bar<capture#1-of ?>\n----------\n");
    }

    public void test0576() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        Foo<?> f1 = new Foo<Integer>();\n        Foo<?> f2 = new Foo<String>();\n\t\tf1 = f1;\n\t\tf1 = f2;\n    }\n    static class Foo<T> {\n    }\n}\n"}, "");
    }

    public void test0577() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        Foo<?> f1 = new Foo<Integer>();\n        (f1).bar = f1.bar;\n    }\n    static class Foo<T> {\n       Bar<T> bar = new Bar<T>();\n    }\n    static class Bar<T> {\n        T t;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t(f1).bar = f1.bar;\n\t           ^^^^^^\nType mismatch: cannot convert from X.Bar<capture#2-of ?> to X.Bar<capture#1-of ?>\n----------\n");
    }

    public void test0578() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(Box<? extends int[]> box) {\n\t\tint[] ints = box.get();\n\t}\n}\nclass Box<T> {\n\tT get() { return null; }\n}\n"}, "");
    }

    public void test0579() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Box<? super int[]> box) {\n\t\tint[] ints = box.get();\n\t}\n}\nclass Box<T> {\n\tT get() { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint[] ints = box.get();\n\t             ^^^^^^^^^\nType mismatch: cannot convert from capture#1-of ? super int[] to int[]\n----------\n");
    }

    public void test0580() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Box<?> box) {\n\t\tint[] ints = box.get();\n\t}\n}\nclass Box<T> {\n\tT get() { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint[] ints = box.get();\n\t             ^^^^^^^^^\nType mismatch: cannot convert from capture#1-of ? to int[]\n----------\n");
    }

    public void test0581() {
        this.runNegativeTest(new String[]{"X.java", "class X {  public static void main(String[] args) {\n    Foo<?> f1 = new Foo<Integer>();\n    f1.bar = f1.bar;\n   }\n }\nclass Foo<T> {\n  Bar<T> bar = new Bar<T>();\n}\nclass Bar<T> {\n  T t;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tf1.bar = f1.bar;\n\t         ^^^^^^\nType mismatch: cannot convert from Bar<capture#2-of ?> to Bar<capture#1-of ?>\n----------\n");
    }

    public void test0582() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nclass X {\n  void foo(List<? extends I1> l1) {\n    C1 c1 = (C1)l1.get(0);\n  }\n}\ninterface I1{}\nclass C1{}\n"}, "");
    }

    public void test0583() {
        this.runNegativeTest(new String[]{"X.java", "class D<U> {\n\t\t public D (D<U> anotherD) {\n\t\t }\n}\n\npublic class X<S> {\n\t\t public static class C<T> {\n\t\t \t\t public C(C<T> anotherC) {\n\t\t \t\t }\n\t\t }\n\n\t\t public void mD(D<S> d) {\n\t\t \t\t //the following line is OK (no warning reported)\n\t\t \t\t new D<S>(d);\n\t\t }\n\t\t \n\t\t public void mC(C<S> c) {\n\t\t \t\t /* type safety warning\n\t\t \t\t  * (The expression of type X.C<S>\n\t\t \t\t  * needs unchecked conversion to conform to\n\t\t \t\t  * XSB<S>.C<S>)\n\t\t \t\t  */\n\t\t \t\t new C<S>(c);\n\t\t }\n\t\tZork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 25)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0584() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\t\t public static void main(String[] args) {\n\t\t \t\t List<String> stringList = new ArrayList<String>();\n\t\t \t\t stringList.add(\"foo\");\n\t\t \t\t List<Integer> intList = new ArrayList<Integer>();\n\t\t \t\t intList.add(1);\n\n\t\t \t\t List<?> untypedList = stringList;\n\t\t \t\t List<?> untypedList2 = intList;\n\n\t\t \t\t //correctly flagged as error: untypedList.add(new Object());\n\t\t \t\t //ditto: untypedList.add(untypedList2.get(0));\n\n\t\t \t\t //but this is not flagged at all by eclipse:\n\t\t \t\t untypedList.addAll(untypedList2);\n\n\t\t \t\t for(String s : stringList){\n\t\t \t\t \t\t //next line generates runtime ClassCastException\n\t\t \t\t \t\t Logger.log(\"Test_Lists.main: s: \" + s);\n\t\t \t\t }\n\t\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tuntypedList.addAll(untypedList2);\n\t            ^^^^^^\nThe method addAll(Collection<? extends capture#1-of ?>) in the type List<capture#1-of ?> is not applicable for the arguments (List<capture#2-of ?>)\n----------\n2. ERROR in X.java (at line 22)\n\tLogger.log(\"Test_Lists.main: s: \" + s);\n\t^^^^^^\nLogger cannot be resolved\n----------\n");
    }

    public void test0585() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n        public static void main(String[] args) {\n                Outer.Comparator<String> i = new Outer.Comparator<String>() {\n\n                        public boolean equals(String a, String b) {\n                                return false;\n                        }\n\n                        public int hashCode(String a) {\n                                return 0;\n                        }\n                };\n\n        }\n}\n\nclass Outer {}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tOuter.Comparator<String> i = new Outer.Comparator<String>() {\n\t^^^^^^^^^^^^^^^^\nOuter.Comparator cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tOuter.Comparator<String> i = new Outer.Comparator<String>() {\n\t                                 ^^^^^^^^^^^^^^^^\nOuter.Comparator cannot be resolved to a type\n----------\n");
    }

    public void test0586() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static class BB<T, S> { }\n    static class BD<T> extends BB<T, T> { }\n    void f() {\n        BB<? extends Number, ? super Integer> bb = null;\n        Object o = (BD<Number>) bb;\n    }\n}\n"}, "");
    }

    public void test0587() {
        this.runConformTest(new String[]{"X.java", "interface DA<T> {\n}\ninterface DB<T> extends DA<T> {\n}\ninterface DC<T> extends DA<Integer> {\n}\n\npublic class X {\n\tObject o = (DC<?>) (DA<?>) null;\n}\n"}, "");
    }

    public void test0588() {
        this.runNegativeTest(new String[]{"X.java", "public class X<S extends Comparable<S>> {\n\tpublic void f() {\n\t\tClass<? extends Comparable<?>> cc = Long.class;\n\t\tClass<S> currentClass = null;\n\t\tboolean b = currentClass == Long.class;\n\t\tboolean c = X.class == Long.class;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tboolean c = X.class == Long.class;\n\t            ^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<X> and Class<Long>\n----------\n");
    }

    public void test0589() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\n\tvoid addAll(List<? extends Number> target, List<? extends Number> source) {\n\t\ttarget.addAll(source);\n\t}\n\n\tpublic static void main(String... args) {\n\t\tList<Integer> ints = new ArrayList<Integer>();\n\t\tints.add(3);\n\n\t\tList<Float> floats = new ArrayList<Float>();\n\t\tfloats.add(3f);\n\n\t\tnew X().addAll(ints, floats);\n\n\t\tfor (Integer integer : ints) {\n\t\t\tSystem.out.println(integer.intValue());\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\ttarget.addAll(source);\n\t       ^^^^^^\nThe method addAll(Collection<? extends capture#1-of ? extends Number>) in the type List<capture#1-of ? extends Number> is not applicable for the arguments (List<capture#2-of ? extends Number>)\n----------\n");
    }

    public void test0590() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\n\tvoid assignAll(Class<? super Number> sup, Class<? extends Number> ext) {\n\t\tClass<? super Number> superSup = sup.getSuperclass();\n\t\tClass<?> superExt = ext.getSuperclass();\n\t\tClass<? super Number> superSup2 = ext.getSuperclass();\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tClass<? super Number> superSup2 = ext.getSuperclass();\n\t                                  ^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#6-of ? super capture#5-of ? extends Number> to Class<? super Number>\n----------\n");
    }

    public void test0591() {
        this.runConformTest(new String[]{"X.java", "public class X<U> {\n\n\tpublic Values<U> foo(Box<? extends U> box) {\n\t\treturn selectedValues(box.getValues());\n\t}\n\tpublic static <G> Values<G> selectedValues(Values<? extends G> v) {\n\t\treturn null;\n\t}\n}\n\nabstract class Box<V> {\n\t  abstract Values<V> getValues();\n}\nabstract class Values<T> {\n}\n"}, "");
    }

    public void test0592() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    List<?> l;\n    void m() {\n\tm2(l);\n    }\n    <T> void m2(List<T> l2) {\n\tl2.add(l2.remove(0));\n    }\n}\n"}, "");
    }

    public void test0593() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        String xSource = "import java.util.*;\npublic class X {\n\t    List<Class<?>> classes1 = Arrays.asList(String.class, Boolean.class);\n\t    List<? extends Class<?>> classes2 = Arrays.asList(String.class, Boolean.class);\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 3)\n\tList<Class<?>> classes1 = Arrays.asList(String.class, Boolean.class);\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Class<? extends Object&Serializable&Comparable<?>>> to List<Class<?>>\n----------\n", null, true, options);
        } else {
            this.runConformTest(new String[]{"X.java", xSource}, options);
        }
    }

    public void test0594() {
        this.runNegativeTest(new String[]{"X.java", " import java.util.*;\nimport static java.util.Map.*;\n\nabstract class MyIterator<E> implements Iterator<E> {\n\tSet<E> iteratedSet;\n}\npublic class X {\n\t\n\tvoid foo() {\n\t\tMap<String, ?> map;\n\t\tIterator<Entry<String, ?>> it = map.entrySet().iterator();\n\n\t\tEntry<String, Number> unrelatedEntry;\n\t\tMyIterator<Entry<String, ?>> mit = (MyIterator<Entry<String, ?>>) it;\n\t\tmit.iteratedSet.add(unrelatedEntry);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tIterator<Entry<String, ?>> it = map.entrySet().iterator();\n\t                                ^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Iterator<Map.Entry<String,capture#1-of ?>> to Iterator<Map.Entry<String,?>>\n----------\n");
    }

    public void test0595() {
        this.runNegativeTest(new String[]{"X.java", " import java.util.*;\nimport static java.util.Map.*;\n\nabstract class MyIterator<E> implements Iterator<E> {\n\tSet<E> iteratedSet;\n}\npublic class X {\n\t\n\tvoid bar() {\n\t\tMap<? extends String, ?> map;\n\t\tIterator<Entry<? extends String, ?>> it = map.entrySet().iterator();\n\n\t\tEntry<String, Number> unrelatedEntry;\n\t\tMyIterator<Entry<? extends String, ?>> mit = (MyIterator<Entry<? extends String, ?>>) it;\n\t\tmit.iteratedSet.add(unrelatedEntry);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tIterator<Entry<? extends String, ?>> it = map.entrySet().iterator();\n\t                                          ^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Iterator<Map.Entry<capture#1-of ? extends String,capture#2-of ?>> to Iterator<Map.Entry<? extends String,?>>\n----------\n");
    }

    public void test0596() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\t<T> Set<T> unmodifiableSet(Set<T> set) {\n\t\treturn set;\n\t}\n\tpublic void foo(Set<?> s) {\n\t\tSet<?> s2 = unmodifiableSet(s);\n\t}\n}\n"}, "");
    }

    public void test0597() {
        this.runNegativeTest(new String[]{"X.java", "public class X<U> {\n\tPair<U,U> m() { \n\t\treturn null; \n\t}\n\tvoid foo(X<?> x) {\n\t\tx.m().first = x.m().second;\n\t}\n}\n\t\nclass Pair<E, F> {\n\tE first;\n\tF second;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tx.m().first = x.m().second;\n\t              ^^^^^^^^^^^^\nType mismatch: cannot convert from capture#2-of ? to capture#1-of ?\n----------\n");
    }

    public void test0598() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\nclass X implements Comparable {\n\n\tpublic int compareTo(Object o) {\n\t\treturn 0;\n\t}\n\n}\n\nclass Y {\n\tpublic static void main(String[] args) {\n\t\tList<X> lx = null;\n\t\tCollections.sort(lx);\n\t}\n}\n"}, "");
    }

    public void test0599() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X implements Comparable {\n\tpublic static void main(String[] args) {\n\t\tZork z;\n\t\t\n\t\tList<X> lx = null;\n\t\tsort1(lx);\n\t\tsort2(lx);\n\t\tsort3(lx);\n\t\tsort4(lx);\n\t\tsort5(lx);\n\t}\n\tpublic int compareTo(Object o) {\n\t\treturn 0;\n\t}\n\tstatic <T extends Comparable<? super T>> void sort1(List<T> list) {}\n\tstatic <T extends Comparable<? extends T>> void sort2(List<T> list) {}\n\tstatic <T extends Comparable<?>> void sort3(List<T> list) {}\n\tstatic <T extends Comparable<T>> void sort4(List<T> list) {}\n\tstatic <T extends Comparable> void sort5(List<T> list) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic class X implements Comparable {\n\t                          ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. WARNING in X.java (at line 8)\n\tsort1(lx);\n\t^^^^^^^^^\nType safety: Unchecked invocation sort1(List<X>) of the generic method sort1(List<T>) of type X\n----------\n4. WARNING in X.java (at line 9)\n\tsort2(lx);\n\t^^^^^^^^^\nType safety: Unchecked invocation sort2(List<X>) of the generic method sort2(List<T>) of type X\n----------\n5. WARNING in X.java (at line 11)\n\tsort4(lx);\n\t^^^^^^^^^\nType safety: Unchecked invocation sort4(List<X>) of the generic method sort4(List<T>) of type X\n----------\n6. WARNING in X.java (at line 21)\n\tstatic <T extends Comparable> void sort5(List<T> list) {}\n\t                  ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test0600() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X implements Comparable {\n\tpublic static void main(String[] args) {\n\t\tZork z;\n\t\t\n\t\tList<MyEnum> le = null;\n\t\tsort6(le);\n\t\tsort7(le);\n\t\tsort8(le);\n\t\tsort9(le);\n\t\tsort10(le);\n\t}\n\tpublic int compareTo(Object o) {\n\t\treturn 0;\n\t}\n\tstatic <T extends MyEnum<? super T>> void sort6(List<T> list) {}\n\tstatic <T extends MyEnum<? extends T>> void sort7(List<T> list) {}\n\tstatic <T extends MyEnum<?>> void sort8(List<T> list) {}\n\tstatic <T extends MyEnum<T>> void sort9(List<T> list) {}\n\tstatic <T extends MyEnum> void sort10(List<T> list) {}\n}\nclass MyEnum<E extends MyEnum<E>> {}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic class X implements Comparable {\n\t                          ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. WARNING in X.java (at line 7)\n\tList<MyEnum> le = null;\n\t     ^^^^^^\nMyEnum is a raw type. References to generic type MyEnum<E> should be parameterized\n----------\n4. WARNING in X.java (at line 8)\n\tsort6(le);\n\t^^^^^^^^^\nType safety: Unchecked invocation sort6(List<MyEnum>) of the generic method sort6(List<T>) of type X\n----------\n5. WARNING in X.java (at line 9)\n\tsort7(le);\n\t^^^^^^^^^\nType safety: Unchecked invocation sort7(List<MyEnum>) of the generic method sort7(List<T>) of type X\n----------\n6. WARNING in X.java (at line 11)\n\tsort9(le);\n\t^^^^^^^^^\nType safety: Unchecked invocation sort9(List<MyEnum>) of the generic method sort9(List<T>) of type X\n----------\n7. WARNING in X.java (at line 21)\n\tstatic <T extends MyEnum> void sort10(List<T> list) {}\n\t                  ^^^^^^\nMyEnum is a raw type. References to generic type MyEnum<E> should be parameterized\n----------\n");
    }

    public void test0601() {
        this.runNegativeTest(new String[]{"X.java", "public class X<U> {\n\n\tpublic Values<U> foo(Box<? extends U> box) {\n\t\treturn selectedValues(box.getValues());\n\t}\n\tpublic static <G> Values<G> selectedValues(Values<G> v) {\n\t\treturn null;\n\t}\n}\n\nabstract class Box<V> {\n\t  abstract Values<V> getValues();\n}\nabstract class Values<T> {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn selectedValues(box.getValues());\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Values<capture#1-of ? extends U> to Values<U>\n----------\n");
    }

    public void test0602() {
        this.runNegativeTest(new String[]{"X.java", "public class X<U> {\n\n\tpublic void foo(Box<? extends U> box) {\n\t\tbox.getValues()[0] = box.getValues()[1];\n\t}\n}\n\nabstract class Box<V> {\n\t  abstract Values<V>[] getValues();\n}\nabstract class Values<T> {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tbox.getValues()[0] = box.getValues()[1];\n\t                     ^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Values<capture#2-of ? extends U> to Values<capture#1-of ? extends U>\n----------\n");
    }

    public void test0603() {
        this.runConformTest(new String[]{"X.java", "public class X<U> {\n\n\tpublic void foo(Box<? extends U>[] boxes) {\n\t\tboxes[0] = boxes[1];\n\t}\n}\n\nabstract class Box<V> {\n\t  abstract Values<V>[] getValues();\n}\nabstract class Values<T> {\n}\n"}, "");
    }

    public void test0604() {
        this.runConformTest(new String[]{"X.java", "public class X<U> {\n\n\tpublic void foo(Box<? extends U>[] boxes) {\n\t\tbar(boxes[0], boxes[1]);\n\t}\n\t<V> void bar(V v1, V v2) {}\n}\n\nabstract class Box<V> {\n\t  abstract Values<V>[] getValues();\n}\nabstract class Values<T> {\n}\n"}, "");
    }

    public void test0605() {
        this.runNegativeTest(new String[]{"X.java", "public class X<U> {\n\n\tpublic void foo(Box<? extends U> box) {\n\t\tbox.getValues()[1] = box.getValues()[2];\n\t}\n}\n\nabstract class Box<V> {\n\t  abstract Values<V>[] getValues();\n}\nabstract class Values<T> {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tbox.getValues()[1] = box.getValues()[2];\n\t                     ^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Values<capture#2-of ? extends U> to Values<capture#1-of ? extends U>\n----------\n");
    }

    public void test0606() {
        this.runNegativeTest(new String[]{"X.java", "public class X<U> {\n\n\tpublic void foo(Box<? extends U> box) {\n\t\tbox.getValues()[1] = (Values<? extends U>) box.getValues()[2];\n\t}\n\t<V> void bar(V v1, V v2) {}\n}\n\nabstract class Box<V> {\n\t  abstract Values<V>[] getValues();\n}\nabstract class Values<T> {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tbox.getValues()[1] = (Values<? extends U>) box.getValues()[2];\n\t                     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Values<capture#3-of ? extends U> to Values<capture#1-of ? extends U>\n----------\n");
    }

    public void test0607() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\n\tvoid test01() {\n\t\tList<Comparable<Object>> lObj = new ArrayList<Comparable<Object>> ();\n\t\tCollections.sort (lObj);\t\n\t}\n\tvoid test02() {\n\t\tList<Comparable> lComp = new ArrayList<Comparable> ();\n\t\tCollections.sort (lComp);\t\t\n\t}\n\tvoid test03() {\n\t\tList<Comparable<String>> lStr = new ArrayList<Comparable<String>> ();\n\t\tCollections.sort (lStr);\n\t}\n }\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tList<Comparable> lComp = new ArrayList<Comparable> ();\n\t     ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. WARNING in X.java (at line 10)\n\tList<Comparable> lComp = new ArrayList<Comparable> ();\n\t                                       ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n3. WARNING in X.java (at line 11)\n\tCollections.sort (lComp);\t\t\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation sort(List<Comparable>) of the generic method sort(List<T>) of type Collections\n----------\n4. ERROR in X.java (at line 15)\n\tCollections.sort (lStr);\n\t            ^^^^\nBound mismatch: The generic method sort(List<T>) of type Collections is not applicable for the arguments (List<Comparable<String>>). The inferred type Comparable<String> is not a valid substitute for the bounded parameter <T extends Comparable<? super T>>\n----------\n");
    }

    public void test0608() {
        this.runNegativeTest(new String[]{"Ball.java", "import java.util.*;\nclass Ball implements Comparable {\n\n    public int compareTo(Object o) {\n    \treturn 0;\n    }\n    \n    public static void main(String[] args) {\n    \tLinkedList<Ball> foo = new LinkedList<Ball>();\n    \tCollections.sort(foo);\n    }\n\tZork z;\n}\n"}, "----------\n1. WARNING in Ball.java (at line 2)\n\tclass Ball implements Comparable {\n\t                      ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. WARNING in Ball.java (at line 10)\n\tCollections.sort(foo);\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation sort(LinkedList<Ball>) of the generic method sort(List<T>) of type Collections\n----------\n3. ERROR in Ball.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0609() {
        this.runConformTest(new String[]{"I.java", "interface I<T extends I<? super T>> {}\n"}, "");
    }

    public void test0610() {
        this.runNegativeTest(new String[]{"X.java", " import java.util.List;\n\npublic class X {\n\tvoid foo(List<Object> objects, List raw) {\n\n\t    List<Number> numbers;\n\t    List<? extends Number> ext;\n\t    \n\t    numbers= (List<Number>) objects; // correct - cast error\n\t    ext= (List<? extends Number>) objects; // wrong, should fail\n\n\t    ext= raw; // correct - raw conversion warning issued\n\t    numbers= raw; // correct - raw conversion warning issued\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid foo(List<Object> objects, List raw) {\n\t                               ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in X.java (at line 9)\n\tnumbers= (List<Number>) objects; // correct - cast error\n\t         ^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object> to List<Number>\n----------\n3. ERROR in X.java (at line 10)\n\text= (List<? extends Number>) objects; // wrong, should fail\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object> to List<? extends Number>\n----------\n4. WARNING in X.java (at line 12)\n\text= raw; // correct - raw conversion warning issued\n\t     ^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<? extends Number>\n----------\n5. WARNING in X.java (at line 13)\n\tnumbers= raw; // correct - raw conversion warning issued\n\t         ^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Number>\n----------\n");
    }

    public void test0611() {
        this.runConformTest(new String[]{"C.java", "import java.io.Serializable;\n\ninterface A<K extends A.BK<S>, S extends A.BS> {\n\tpublic interface BS extends Serializable {\n\t}\n\tpublic interface BK<SS> extends Serializable {\n\t\tpublic void put(SS a);\n\t}\n\n\tpublic P<K, S> getP();\n}\n\nclass P<K extends A.BK<S>, S extends A.BS> {\n\tK k;\n\tS s;\n\n\tpublic void put() {\n\t\tk.put(s);\n\t}\n}\n\npublic class C<T> implements A<C.K, C.S> {\n\tpublic static class K implements A.BK<C.S> {\n\t\tpublic void put(S a) {\n\t\t}\n\t}\n\tprotected static class S implements A.BS {\n\t}\n\n\tpublic P<K, S> getP() {\n\t\treturn null;\n\t}\n}\n"}, "");
    }

    public void test0612() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\nclass MPair<A,B> {}\n\npublic class X<K,V> {\n    private static class Bucket extends LinkedList<MPair<K,V>> {}\n    private Bucket[] buckets = new X.Bucket[100];\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tprivate static class Bucket extends LinkedList<MPair<K,V>> {}\n\t                                                     ^\nCannot make a static reference to the non-static type K\n----------\n2. ERROR in X.java (at line 6)\n\tprivate static class Bucket extends LinkedList<MPair<K,V>> {}\n\t                                                       ^\nCannot make a static reference to the non-static type V\n----------\n");
    }

    public void test0613() {
        this.runNegativeTest(new String[]{"Map.java", "package xy;\nimport xy.Map.Entry;\n\nclass Map<M> {\n    class Entry<E> { }\n}\nclass User {\n    void a(Entry<String> e) { } // Entry<String> is illegal (eclipse accepts)\n    void c(Map.Entry<String> e) { } // illegal (correctly flagged)\n    void b(Entry e) { } // OK\n    void d(Map<Integer>.Entry<String> e) { } // OK\n}\n"}, "----------\n1. ERROR in Map.java (at line 8)\n\tvoid a(Entry<String> e) { } // Entry<String> is illegal (eclipse accepts)\n\t       ^^^^^\nThe member type Map.Entry<String> must be qualified with a parameterized type, since it is not static\n----------\n2. ERROR in Map.java (at line 9)\n\tvoid c(Map.Entry<String> e) { } // illegal (correctly flagged)\n\t       ^^^^^^^^^\nThe member type Map.Entry<String> must be qualified with a parameterized type, since it is not static\n----------\n3. WARNING in Map.java (at line 10)\n\tvoid b(Entry e) { } // OK\n\t       ^^^^^\nMap.Entry is a raw type. References to generic type Map<M>.Entry<E> should be parameterized\n----------\n");
    }

    public void test0614() {
        this.runNegativeTest(new String[]{"X1.java", "class X1 {\n\tstatic class X2<T> {\n\t\tclass X3<U> {\n\t\t}\n\t}\n}\nclass Y1 {\n\tclass Y2 extends X1.X2<Exception> {\n\t\tvoid foo() {\n\t\t\tX3<String> x;\n\t\t}\n\t}\n\tZork z;\n}\n"}, "----------\n1. ERROR in X1.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0615() {
        this.runNegativeTest(new String[]{"X1.java", "class X1 {\n\tstatic class X2<T> {\n\t\tclass X3<U> {\n\t\t}\n\t}\n}\nclass Y1 {\n\tclass Y2 extends X1.X2 {\n\t\tvoid foo() {\n\t\t\tX3<String> x;\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X1.java (at line 8)\n\tclass Y2 extends X1.X2 {\n\t                 ^^^^^\nX1.X2 is a raw type. References to generic type X1.X2<T> should be parameterized\n----------\n2. ERROR in X1.java (at line 10)\n\tX3<String> x;\n\t^^\nThe member type X1.X2.X3<String> must be qualified with a parameterized type, since it is not static\n----------\n");
    }

    public void test0616() {
        this.runNegativeTest(new String[]{"Map.java", "package xy;\nimport xy.Map.Entry;\n\nclass Map<M> {\n    class Entry<E> { }\n}\nclass User extends Map<String> {\n    void a(Entry<String> e) { } // Entry<String> is illegal (eclipse accepts)\n    void c(Map.Entry<String> e) { } // illegal (correctly flagged)\n    void b(Entry e) { } // OK\n    void d(Map<Integer>.Entry<String> e) { } // OK\n}\n"}, "----------\n1. ERROR in Map.java (at line 9)\n\tvoid c(Map.Entry<String> e) { } // illegal (correctly flagged)\n\t       ^^^^^^^^^\nThe member type Map.Entry<String> must be qualified with a parameterized type, since it is not static\n----------\n2. WARNING in Map.java (at line 10)\n\tvoid b(Entry e) { } // OK\n\t       ^^^^^\nMap.Entry is a raw type. References to generic type Map<M>.Entry<E> should be parameterized\n----------\n");
    }

    public void test0617() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n   public void foo() {\n       String s = null;\n       ZZZ1<?>.ZZZ2<?>.ZZZ3<?> var = null;\n       s = var;\n   }\n}\n\nclass ZZZ1<T1> {\n  class ZZZ2<T2> {\n    class ZZZ3<T3> {}\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\ts = var;\n\t    ^^^\nType mismatch: cannot convert from ZZZ1<?>.ZZZ2<?>.ZZZ3<capture#1-of ?> to String\n----------\n");
    }

    public void test0618() {
        this.runNegativeTest(new String[]{"Map.java", "class Map<M> {\n    class Entry<E> { }\n    class Foo {\n    \tEntry<String> entry;\n    \tstatic void foo(Entry<String> e) { } // invalid static ref\n    }\n    static class Bar {\n    \tEntry<String> entry; // invalid static ref\n    }\n    void a(Entry<String> e) { } // OK\n    void c(Map.Entry<String> e) { } // illegal \n    void b(Entry e) { } // OK\n    void d(Map<Integer>.Entry<String> e) { } // OK\n}\n"}, "----------\n1. ERROR in Map.java (at line 5)\n\tstatic void foo(Entry<String> e) { } // invalid static ref\n\t            ^^^^^^^^^^^^^^^^^^^^\nThe method foo cannot be declared static; static methods can only be declared in a static or top level type\n----------\n2. ERROR in Map.java (at line 5)\n\tstatic void foo(Entry<String> e) { } // invalid static ref\n\t                ^^^^^\nCannot make a static reference to the non-static type Entry\n----------\n3. ERROR in Map.java (at line 8)\n\tEntry<String> entry; // invalid static ref\n\t^^^^^\nCannot make a static reference to the non-static type Entry\n----------\n4. ERROR in Map.java (at line 11)\n\tvoid c(Map.Entry<String> e) { } // illegal \n\t       ^^^^^^^^^\nThe member type Map.Entry<String> must be qualified with a parameterized type, since it is not static\n----------\n5. WARNING in Map.java (at line 12)\n\tvoid b(Entry e) { } // OK\n\t       ^^^^^\nMap.Entry is a raw type. References to generic type Map<M>.Entry<E> should be parameterized\n----------\n");
    }

    public void test0619() {
        this.runConformTest(new String[]{"X.java", "interface ISample<V> {\n\tpublic static enum Stuff {\n\t\tFIRST, SECOND, THIRD\n\t};\n}\n\nclass SampleClass {\n\tpublic void doSomething(ISample.Stuff thing) {\n\n\t}\n}\n\npublic class X {\n\tpublic void doSomething() {\n\t\tSampleClass sample = new SampleClass();\n\t\tsample.doSomething(ISample.Stuff.FIRST);\n\t}\n}\n"}, "");
    }

    public void test0620() {
        this.runNegativeTest(new String[]{"Outer.java", "public class Outer<O> {\n\tclass Inner { }\n\t\n\tstatic void test(Inner i) { }\n}\n"}, "----------\n1. ERROR in Outer.java (at line 4)\n\tstatic void test(Inner i) { }\n\t                 ^^^^^\nCannot make a static reference to the non-static type Inner\n----------\n");
    }

    public void test0621() {
        this.runConformTest(new String[]{"Outer.java", "public class Outer {\n\tclass Inner { }\n\t\n\tstatic void test(Inner i) { }\n}\n"}, "");
    }

    public void test0622() {
        this.runConformTest(new String[]{"Outer.java", "public class Outer<O> {\n\tstatic class Inner { }\n\t\n\tstatic void test(Inner i) { }\n}\n"}, "");
    }

    public void test0623() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tstatic class Outer {\n\t\tclass Inner { }\n\t\tstatic void test(Inner i) { }\n\t}\n}\n"}, "");
    }

    public void test0624() {
        this.runConformTest(new String[]{"X.java", " interface IFoo<U, V extends X<U, V>> {\n\tV bar(int i);\n}\n\npublic class X<E, F extends X<E, F>> {\n\t\n\tpublic boolean foo(X<E, ?> x) {\n\t\treturn false;\n\t}\n\tpublic boolean baz(IFoo<E, ?> f) {\n\t\treturn foo(f.bar(0));\n\t}\n}\n"}, "");
    }

    public void test0625() {
        this.runConformTest(new String[]{"Foo.java", "public class Foo<K> {\n\tpublic enum Mode {\n\t\tA\n\t};\n\tpublic void test(Mode mode) {\n\t}\n} \n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tenum Keys {\n\t\tB\n\t};\n\tpublic void test() {\n\t\tFoo<Keys> foo = new Foo<Keys>();\n\t\tfoo.test(Foo.Mode.A); // error\n\t}\n} \n"}, "", null, false, null);
    }

    public void test0626() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tprivate static class A {\n\n\t}\n\n\tprivate static class B<A> {\n\n\t}\n\n\tprivate static class AA extends A {\n\n\t}\n\n\tprivate static class C extends B<AA> {\n\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tB<A> b = new B<A>();\n\t\tSystem.out.println(b instanceof C);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tprivate static class B<A> {\n\t                       ^\nThe type parameter A is hiding the type X.A\n----------\n2. WARNING in X.java (at line 11)\n\tprivate static class AA extends A {\n\t                     ^^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n3. WARNING in X.java (at line 15)\n\tprivate static class C extends B<AA> {\n\t                     ^\nAccess to enclosing constructor X.B<A>() is emulated by a synthetic accessor method\n----------\n4. ERROR in X.java (at line 21)\n\tSystem.out.println(b instanceof C);\n\t                   ^^^^^^^^^^^^^^\nIncompatible conditional operand types X.B<X.A> and X.C\n----------\n");
    }

    public void test0627() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\n\t<T> List<? extends T> foo(List<? extends T> l1, List<? extends T> l2) {\n\t\treturn l1;\n\t}\n\tvoid bar(List<String> l1, List<Integer> l2) {\n\t\tString s = foo(l1, l2);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tString s = foo(l1, l2);\n\t           ^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from List<capture#2-of ? extends Object&Serializable&Comparable<?>> to String\n" : "Type mismatch: cannot convert from List<? extends Object&Serializable&Comparable<?>> to String\n") + "----------\n");
    }

    public void test0628() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\n\t<T> List<? extends T> foo(List<? extends T> l1, List<? extends T> l2) {\n\t\treturn l1;\n\t}\n\tvoid bar(List<Float> l1, List<Integer> l2) {\n\t\tList<?> l3 = null;\n\t\tString s = l1 != null ? foo(l1, l2) : l3;\n\t}\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 10)\n\tString s = l1 != null ? foo(l1, l2) : l3;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<capture#4-of ? extends Object> to String\n----------\n" : "----------\n1. ERROR in X.java (at line 10)\n\tString s = l1 != null ? foo(l1, l2) : l3;\n\t                        ^^^^^^^^^^^\nType mismatch: cannot convert from List<? extends Number&Comparable<?>> to String\n----------\n");
    }

    public void test0629() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic abstract class Context<N extends Number> {\n\t\tprivate Strategy<N, ? super Context<N>> strategy;\n\t\tpublic void setStrategy(Strategy<N, ? super Context<N>> strategy) {\n\t\t\tthis.strategy = strategy;\n\t\t}\n\t\t// m?thode qui utilise la strat?gie\n\t\tpublic N call() throws Exception {\n\t\t\treturn this.strategy.call(this);\n\t\t}\n\t}\n\tpublic interface Strategy<N extends Number, C extends Context<N>> {\n\t\tpublic abstract N call(C context);\n\t}\n\n} \n"}, "");
    }

    public void test0630() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\n@SuppressWarnings(\"null\")\npublic class X {\n\n\tvoid test0() {\n\t\tList<? super Number[]> arrays= new ArrayList<Number[]>();\n\t\tNumber[] a= null;\n\t\tarrays.add(null);\n\t\tarrays.add(a); // Error: The method add(capture-of ? super Number[]) in the type List<capture-of ? super Number[]> is not applicable for the arguments (Number[])\n\t}\n\n\tvoid test01() {\n\t\tList<? extends Number[]> arrays= new ArrayList<Number[]>();\n\t\tNumber[] a= null;\n\t\tarrays.add(null);\n\t\tarrays.add(a); // Error: The method add(capture-of ? extends Number[]) in the type List<capture-of ? super Number[]> is not applicable for the arguments (Number[])\n\t}\n\t\n\tvoid test02() {\n\t\tList<? super Number> nums= null;\n\t\tNumber n= null;\n\t\tnums.add(null);\n\t\tnums.add(n);\n\t}\n\n\tvoid test3() {\n\t\tList<? super List<Number>> nums= null;\n\t\tList<Number> n= null;\n\t\tnums.add(null);\n\t\tnums.add(n);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tarrays.add(a); // Error: The method add(capture-of ? extends Number[]) in the type List<capture-of ? super Number[]> is not applicable for the arguments (Number[])\n\t       ^^^\nThe method add(capture#4-of ? extends Number[]) in the type List<capture#4-of ? extends Number[]> is not applicable for the arguments (Number[])\n----------\n");
    }

    public void test0631() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.RetentionPolicy;\n\npublic class X\n{\n\t\t public static void main(String[] args)\n\t\t {\n\t\t \t\t Class<? extends Enum<?>> c = RetentionPolicy.class;\n\t\t \t\t System.out.println(Enum.valueOf(c, \"CLASS\"));\n\t\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(Enum.valueOf(c, \"CLASS\"));\n\t                        ^^^^^^^\nBound mismatch: The generic method valueOf(Class<T>, String) of type Enum<E> is not applicable for the arguments (Class<capture#1-of ? extends Enum<?>>, String). The inferred type capture#1-of ? extends Enum<?> is not a valid substitute for the bounded parameter <T extends Enum<T>>\n----------\n");
    }

    public void test0632() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Vector;\n\n@SuppressWarnings(\"null\")\npublic class X {\n\tvoid test01() {\n\t\tVector<? super java.lang.Object[]> lhs = null;\n\t\tVector<? extends java.lang.Object[]> rhs = null;\n\t\tlhs.add(rhs.get(0));\n\t}\n\tvoid test02() {\n\t\tVector<? extends java.lang.Object[]> lhs = null;\n\t\tVector<? extends java.lang.Object[]> rhs = null;\n\t\tlhs.add(rhs.get(0));\n\t}\n\tvoid test3() {\n\t\tVector<? super java.lang.Object[]> lhs = null;\n\t\tVector<? super java.lang.Object[]> rhs = null;\n\t\tlhs.add(rhs.get(0));\n\t}\n\tvoid test4() {\n\t\tVector<?  extends java.lang.Object[]> lhs = null;\n\t\tVector<? super java.lang.Object[]> rhs = null;\n\t\tlhs.add(rhs.get(0));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tlhs.add(rhs.get(0));\n\t    ^^^\nThe method add(capture#3-of ? extends Object[]) in the type Vector<capture#3-of ? extends Object[]> is not applicable for the arguments (capture#4-of ? extends Object[])\n----------\n2. ERROR in X.java (at line 18)\n\tlhs.add(rhs.get(0));\n\t    ^^^\nThe method add(capture#5-of ? super Object[]) in the type Vector<capture#5-of ? super Object[]> is not applicable for the arguments (capture#6-of ? super Object[])\n----------\n3. ERROR in X.java (at line 23)\n\tlhs.add(rhs.get(0));\n\t    ^^^\nThe method add(capture#7-of ? extends Object[]) in the type Vector<capture#7-of ? extends Object[]> is not applicable for the arguments (capture#8-of ? super Object[])\n----------\n");
    }

    public void test0633() {
        this.runConformTest(true, new String[]{"X.java", "import java.util.Vector;\n\npublic class X {\n\tvoid test1() {\n\t\tVector<? super Object[]> lhs = null;\n\t\tVector<Object[]> rhs = null;\n\t\tlhs.add(rhs.get(0)); \n\t\tfoo(rhs.get(0)); // ok #foo(Object[])\n\t}\n\tvoid foo(Object[] objs) {\n\t}\n}\n"}, null, "", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0634() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.reflect.Array;\n\npublic class X<T> {\n\n\tT[] theArray;\n\n\tpublic X(Class<T> clazz) {\n\t\ttheArray = (T[]) Array.newInstance(clazz, 10); // Compiler warning\n\t}\n\n\tpublic T get(int i) {\n\t\treturn theArray[i];\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tX<Integer> t = new X<Integer>(Integer.class);\n\t\t// GenericsArray1<Integer> t = new GenericsArray1<Integer>( int.class );\n\t\tObject[] o = t.theArray;\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\ttheArray = (T[]) Array.newInstance(clazz, 10); // Compiler warning\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to T[]\n----------\n2. ERROR in X.java (at line 20)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0635() {
        this.runConformTest(new String[]{"X.java", "import java.util.Iterator;\npublic class X {\n\tpublic static class Indexed <U>  {\n\t\tpublic Iterator<U> foo() {\n\t\t\treturn new IndexedIter();\n\t\t}\n\t\tclass IndexedIter implements Iterator<U> {\n\t\t\tpublic boolean hasNext() {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tpublic U next() {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tpublic void remove() {\n\t\t\t}\n" + ITERATOR_IMPL_JRE8.replaceAll("\\*", "U") + "\t\t}\n" + "\t}\n" + "}\n"}, "");
    }

    public void test0636() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X<T> {\n  public final T element() {\n    T result = (T) customElement(); // reports unnecessary cast\n    return result;\n  }\n  protected abstract Object customElement();\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tT result = (T) customElement(); // reports unnecessary cast\n\t           ^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to T\n----------\n2. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0637() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\tpublic static final class Ex1 extends Exception {\n\t\tprivate static final long serialVersionUID = 1;\n\t}\n\n\tprivate void a1() {\n\t\ttry {\n\t\t\ta1_1();\n\t\t} catch (Ex1 si) {\n\t\t\tassert si != null;\n\t\t}\n\t}\n\n\tprotected Object a1_1() throws Ex1 {\n\t\treturn null;\n\t}\n\n\tprivate void a2() {\n\t\ttry {\n\t\t\ta2_1();\n\t\t} catch (Ex2 si) {\n\t\t\tassert si != null;\n\t\t}\n\t}\n\n\tprotected Object a2_1() throws Ex2 {\n\t\treturn null;\n\t}\n\n\tpublic final static class Ex3 extends Exception {\n\t\tprivate static final long serialVersionUID = 1;\n\t}\n\n\tprivate void a3() {\n\t\ttry {\n\t\t\ta3_1();\n\t\t} catch (Ex3 si) {\n\t\t\tassert si != null;\n\t\t}\n\t}\n\n\tprotected Object a3_1() throws Ex3 {\n\t\treturn null;\n\t}\n\n}\n\nfinal class Ex2 extends Exception {\n\tprivate static final long serialVersionUID = 1;\n}\n"}, "");
    }

    public void test0638() {
        this.runConformTest(new String[]{"X.java", "import java.util.concurrent.BlockingQueue;\n\npublic class X {\n\tstatic interface IMX<S, L> {\n\t\tvoid call(L a, S b);\n\t}\n\tstatic interface Y<S, L> {\n\t\tvoid addX(final IMX<S, L> a);\n\t\tvoid removeX(final IMX<S, L> a);\n\t}\n\tstatic final class Pair<T, V> {\n\t\tT first;\n\n\t\tV second;\n\t}\n\tstatic class Bar<P> {\n\t\tBar(final BlockingQueue<P> a) {\n\n\t\t}\n\t}\n}\n\nfinal class Foo<S, L> extends X.Bar<X.Pair<L[], S>> implements X.IMX<S, L> {\n\tFoo(final BlockingQueue<X.Pair<L[], S>> in) {\n\t\tsuper(in);\n\t}\n\tpublic void call(L a, S b) {\n\t}\n}\n"}, "");
    }

    public void test0639() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.reflect.*;\n\n@interface MyAnnotation {\n}\npublic class X {\n\tvoid test() throws Exception {\n\t\tClass type = X.class;\n\t\tMethod method = type.getMethod(\"test\");\n\t\tConstructor constructor = type.getConstructor();\n\t\tField field = type.getField(\"field\");\n\t\tPackage packge = type.getPackage();\n\t\tMyAnnotation typeAnnot = getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation methodAnnot = getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation constrAnnot = getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation fieldAnnot = getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation packgeAnnot = getAnnotation(MyAnnotation.class);\n\t}\n\n\tint field;\n\t\n\t<U extends Annotation> U getAnnotation(Class<U> annotatedType) {\n\t\treturn null;\n\t}\n}\n"}, "");
    }

    public void test0640() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.reflect.*;\n\n@interface MyAnnotation {\n}\npublic class X {\n\tvoid test() throws Exception {\n\t\tClass<?> type = X.class;\n\t\tMethod method = type.getMethod(\"test\");\n\t\tConstructor constructor = type.getConstructor();\n\t\tField field = type.getField(\"field\");\n\t\tPackage packge = type.getPackage();\n\t\tMyAnnotation typeAnnot = getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation methodAnnot = getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation constrAnnot = getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation fieldAnnot = getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation packgeAnnot = getAnnotation(MyAnnotation.class);\n\t}\n\n\tint field;\n\t\n\t<U extends Annotation> U getAnnotation(Class<U> annotatedType) {\n\t\treturn null;\n\t}\n}\n"}, "");
    }

    public void test0641() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.reflect.*;\n\n@interface MyAnnotation {\n}\n@SuppressWarnings(\"all\")\npublic class X {\n\tvoid test() throws Exception {\n\t\tClass type = X.class;\n\t\tMethod method = type.getMethod(\"test\");\n\t\tConstructor constructor = type.getConstructor();\n\t\tField field = type.getField(\"field\");\n\t\tPackage packge = type.getPackage();\n\t\tMyAnnotation typeAnnot = type.getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation methodAnnot = method.getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation constrAnnot = constructor.getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation fieldAnnot = field.getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation packgeAnnot = packge.getAnnotation(MyAnnotation.class);\n\t}\n\n\tint field;\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tMyAnnotation typeAnnot = type.getAnnotation(MyAnnotation.class);\n\t                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Annotation to MyAnnotation\n----------\n2. ERROR in X.java (at line 15)\n\tMyAnnotation constrAnnot = constructor.getAnnotation(MyAnnotation.class);\n\t                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Annotation to MyAnnotation\n----------\n");
    }

    public void test0642() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.*;\n\n@interface MyAnnotation {\n}\n@SuppressWarnings(\"all\")\npublic class X {\n\tvoid test() throws Exception {\n\t\tClass<?> type = X.class;\n\t\tMethod method = type.getMethod(\"test\");\n\t\tConstructor<?> constructor = type.getConstructor();\n\t\tField field = type.getField(\"field\");\n\t\tPackage packge = type.getPackage();\n\t\tMyAnnotation typeAnnot = type.getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation methodAnnot = method.getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation constrAnnot = constructor.getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation fieldAnnot = field.getAnnotation(MyAnnotation.class);\n\t\tMyAnnotation packgeAnnot = packge.getAnnotation(MyAnnotation.class);\n\t}\n\n\tint field;\n}\n"}, "");
    }

    public void test0643() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\t\n\tstatic <U> U foo(U u) {\n\t\treturn u;\n\t}\n\t\n\tvoid bar(X x) {\n\t\tString str = x.foo(\"hello\");\n\t}\n}\n"}, "");
    }

    public void test0644() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\t\n\t<U> U foo(U u) {\n\t\treturn u;\n\t}\n\t\n\tvoid bar(X x) {\n\t\tString str = x.foo(\"hello\");\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tvoid bar(X x) {\n\t         ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\tString str = x.foo(\"hello\");\n\t             ^^^^^^^^^^^^^^\nType safety: The method foo(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n3. ERROR in X.java (at line 8)\n\tString str = x.foo(\"hello\");\n\t             ^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to String\n----------\n");
    }

    public void test0645() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\n\n@interface MyAnnotation {\n}\n\nclass X {\n\tvoid bar(XClass<String> arg) {\n\t\tXClass xc = new XClass();\n\t\tString str = xc.getConstructor().getAnnotation(arg);\n\t}\n}\n\nclass XClass<U> {\n\tXConstructor<U> getConstructor() {\n\t\treturn null;\n\t}\n}\nclass XConstructor<V> {\n\t<W extends Annotation> W getAnnotation(XClass<W> cl) {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tXClass xc = new XClass();\n\t^^^^^^\nXClass is a raw type. References to generic type XClass<U> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\tXClass xc = new XClass();\n\t                ^^^^^^\nXClass is a raw type. References to generic type XClass<U> should be parameterized\n----------\n3. WARNING in X.java (at line 9)\n\tString str = xc.getConstructor().getAnnotation(arg);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method getAnnotation(XClass) belongs to the raw type XConstructor. References to generic type XConstructor<V> should be parameterized\n----------\n4. ERROR in X.java (at line 9)\n\tString str = xc.getConstructor().getAnnotation(arg);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Annotation to String\n----------\n");
    }

    public void test0646() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tOuter.Inner inner = new Outer().new Inner();\n\t\tX x = inner.setOuterT(new X());\n\t\t\n\t\tOuter<String>.Inner innerS = inner;\n\t}\n}\n\nclass Outer<T> {\n\tT t;\n\tclass Inner {\n\t\tT setOuterT(T t1) {\n\t\t\tt = t1;\n\t\t\treturn t;\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tOuter.Inner inner = new Outer().new Inner();\n\t^^^^^^^^^^^\nOuter.Inner is a raw type. References to generic type Outer<T>.Inner should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tOuter.Inner inner = new Outer().new Inner();\n\t                        ^^^^^\nOuter is a raw type. References to generic type Outer<T> should be parameterized\n----------\n3. WARNING in X.java (at line 3)\n\tOuter.Inner inner = new Outer().new Inner();\n\t                                    ^^^^^\nOuter.Inner is a raw type. References to generic type Outer<T>.Inner should be parameterized\n----------\n4. WARNING in X.java (at line 4)\n\tX x = inner.setOuterT(new X());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method setOuterT(Object) belongs to the raw type Outer.Inner. References to generic type Outer<T>.Inner should be parameterized\n----------\n5. ERROR in X.java (at line 4)\n\tX x = inner.setOuterT(new X());\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to X\n----------\n6. WARNING in X.java (at line 6)\n\tOuter<String>.Inner innerS = inner;\n\t                             ^^^^^\nType safety: The expression of type Outer.Inner needs unchecked conversion to conform to Outer<String>.Inner\n----------\n");
    }

    public void test0647() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tOuter.Inner inner = new Outer().new Inner();\n\t\tX x = inner.set(new X());\n\t\t\n\t\tOuter<String>.Inner innerS = inner;\n\t}\n}\n\nclass Outer<T> {\n\tT t;\n\tstatic class Inner<U> {\n\t\tU set(U u) {\n\t\t\treturn u;\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tOuter.Inner inner = new Outer().new Inner();\n\t^^^^^^^^^^^\nOuter.Inner is a raw type. References to generic type Outer<T>.Inner<U> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tOuter.Inner inner = new Outer().new Inner();\n\t                        ^^^^^\nOuter is a raw type. References to generic type Outer<T> should be parameterized\n----------\n3. WARNING in X.java (at line 3)\n\tOuter.Inner inner = new Outer().new Inner();\n\t                                    ^^^^^\nOuter.Inner is a raw type. References to generic type Outer<T>.Inner<U> should be parameterized\n----------\n4. WARNING in X.java (at line 4)\n\tX x = inner.set(new X());\n\t      ^^^^^^^^^^^^^^^^^^\nType safety: The method set(Object) belongs to the raw type Outer.Inner. References to generic type Outer<T>.Inner<U> should be parameterized\n----------\n5. ERROR in X.java (at line 4)\n\tX x = inner.set(new X());\n\t      ^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to X\n----------\n6. ERROR in X.java (at line 6)\n\tOuter<String>.Inner innerS = inner;\n\t^^^^^^^^^^^^^^^^^^^\nThe member type Outer<String>.Inner cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type Outer<String>\n----------\n");
    }

    public void test0648() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tOuter.Inner inner = new Sub().get();\n\t}\n\tZork z;\n}\nclass Outer<T> {\n\tclass Inner<U> {\n\t}\n}\nclass Sub extends Outer {\n\tInner get() { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tOuter.Inner inner = new Sub().get();\n\t^^^^^^^^^^^\nOuter.Inner is a raw type. References to generic type Outer<T>.Inner<U> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. WARNING in X.java (at line 11)\n\tclass Sub extends Outer {\n\t                  ^^^^^\nOuter is a raw type. References to generic type Outer<T> should be parameterized\n----------\n4. WARNING in X.java (at line 12)\n\tInner get() { return null; }\n\t^^^^^\nOuter.Inner is a raw type. References to generic type Outer<T>.Inner<U> should be parameterized\n----------\n");
    }

    public void test0649() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tOuter<String>.Inner inner = new Sub().get();\n\t}\n\tZork z;\n}\nclass Outer<T> {\n\tclass Inner {\n\t}\n}\nclass Sub extends Outer {\n\tInner get() { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tOuter<String>.Inner inner = new Sub().get();\n\t                            ^^^^^^^^^^^^^^^\nType safety: The expression of type Outer.Inner needs unchecked conversion to conform to Outer<String>.Inner\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. WARNING in X.java (at line 11)\n\tclass Sub extends Outer {\n\t                  ^^^^^\nOuter is a raw type. References to generic type Outer<T> should be parameterized\n----------\n4. WARNING in X.java (at line 12)\n\tInner get() { return null; }\n\t^^^^^\nOuter.Inner is a raw type. References to generic type Outer<T>.Inner should be parameterized\n----------\n");
    }

    public void test0650() {
        this.runConformTest(new String[]{"p/A.java", "package p;\n\npublic interface A<V> {\n\tpublic static enum Stuff {\n\t\tFIRST, SECOND, THIRD\n\t};\n}"}, "");
        this.runConformTest(new String[]{"q/SampleClass2.java", "package q;\n\nimport p.A.Stuff;\n\npublic class SampleClass2 {\n  public void doSomething(Stuff thing) {\n    \n  }\n}"}, "", null, false, null);
        this.runConformTest(new String[]{"q/SampleClass3.java", "package q;\n\nimport p.A;\n\npublic class SampleClass3 {\n\tpublic void doSomething() {\n\t\tSampleClass2 sample = new SampleClass2();\n\t\tsample.doSomething(A.Stuff.FIRST);\n\t}\n}"}, "", null, false, null);
    }

    public void test0651() {
        this.runConformTest(new String[]{"X.java", "public class X<U> {\n\n\tint field;\n\tstatic int FIELD;\n\n\t{\n\t\tfield = 1;\n\t}\n\tstatic {\n\t\tFIELD = 1;\n\t}\n\n\tpublic Values<U> foo(Box<? extends U> box) {\n\t\treturn selectedValues(box.getValues()); // 1\n\t}\n\tpublic static <G> Values<G> selectedValues(Values<? extends G> v) {\n\t\treturn null;\n\t}\n}\nabstract class Box<V extends java.io.Serializable> { // Added bound for V\n\tabstract Values<V> getValues();\n}\nabstract class Values<T> {\n}\n"}, AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236217);
    }

    public void test0652() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n    public static void main(String[] args) {\n        Collection<?> c = new HashSet<String>();\n        Set<?> s = (Set<?>)c;\n    }\n}\n"}, "");
    }

    public void test0653() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tstatic public <T extends Collection> void workaround(T a, T b) {\n\t\ta.addAll(b);\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tstatic public <T extends Collection> void workaround(T a, T b) {\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\ta.addAll(b);\n\t^^^^^^^^^^^\nType safety: The method addAll(Collection) belongs to the raw type Collection. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0654() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tMap myMap = new HashMap();\n\t\tmyMap.put(\"key1\", \"1\");\n\n\t\tfor (Map.Entry e : myMap.entrySet())\n\t\t\tSystem.out.println(\"Key = \" + e.getKey() + \" Value = \" + e.getValue());\n\t\tSet<Map.Entry> set = myMap.entrySet();\n\t\tfor (Map.Entry e : set)\n\t\t\tSystem.out.println(\"Key = \" + e.getKey() + \" Value = \" + e.getValue());\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tMap myMap = new HashMap();\n\t^^^\nMap is a raw type. References to generic type Map<K,V> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tMap myMap = new HashMap();\n\t                ^^^^^^^\nHashMap is a raw type. References to generic type HashMap<K,V> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tmyMap.put(\"key1\", \"1\");\n\t^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method put(Object, Object) belongs to the raw type Map. References to generic type Map<K,V> should be parameterized\n----------\n4. WARNING in X.java (at line 8)\n\tfor (Map.Entry e : myMap.entrySet())\n\t     ^^^^^^^^^\nMap.Entry is a raw type. References to generic type Map<K,V>.Entry<K,V> should be parameterized\n----------\n5. ERROR in X.java (at line 8)\n\tfor (Map.Entry e : myMap.entrySet())\n\t                   ^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from element type Object to Map.Entry\n----------\n6. WARNING in X.java (at line 10)\n\tSet<Map.Entry> set = myMap.entrySet();\n\t    ^^^^^^^^^\nMap.Entry is a raw type. References to generic type Map<K,V>.Entry<K,V> should be parameterized\n----------\n7. WARNING in X.java (at line 10)\n\tSet<Map.Entry> set = myMap.entrySet();\n\t                     ^^^^^^^^^^^^^^^^\nType safety: The expression of type Set needs unchecked conversion to conform to Set<Map.Entry>\n----------\n8. WARNING in X.java (at line 11)\n\tfor (Map.Entry e : set)\n\t     ^^^^^^^^^\nMap.Entry is a raw type. References to generic type Map<K,V>.Entry<K,V> should be parameterized\n----------\n");
    }

    public void test0655() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static class BB<T, S> { }\n    static class BD<T> extends BB<T, T> { }\n    void f() {\n        BB<? extends Number, ? super Integer> bb = null;\n        Object o = (BD<Number>) bb;\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tObject o = (BD<Number>) bb;\n\t           ^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X.BB<capture#1-of ? extends Number,capture#2-of ? super Integer> to X.BD<Number>\n----------\n2. WARNING in X.java (at line 6)\n\tObject o = (BD<Number>) bb;\n\t           ^^^^^^^^^^^^^^^\nUnnecessary cast from X.BB<capture#1-of ? extends Number,capture#2-of ? super Integer> to X.BD<Number>\n----------\n3. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0656() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tprotected Vector<String> v = null;\n\n\tpublic void f() {\n\t\t((String) (v.elementAt(0))).charAt(0);\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0657() {
        this.runConformTest(new String[]{"X.java", "public class X{\n\t\n\tprivate static class GenericWrapper<Elem>  {\n\t\tprivate Elem theObject;\n\t\tpublic GenericWrapper(Elem arg) {\n\t\t\ttheObject = arg;\n\t\t}\n\t\tpublic <T extends Elem> GenericWrapper (GenericWrapper<T> other) {\n\t\t\tthis.theObject = other.theObject;\n\t\t}\n\t\tpublic String toString() {\n\t\t\treturn theObject.toString();\n\t\t}\n\t}\n\tprivate static GenericWrapper<String> method (Object wrappedString) {\n\t\treturn (GenericWrapper<String>) wrappedString;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(method(new GenericWrapper<String>(\"abc\")));\n\t\tSystem.out.println(method(new GenericWrapper<Exception>(new Exception())));\n\t}\n}\n"}, "abcjava.lang.Exception");
    }

    public void test0658() {
        this.runNegativeTest(new String[]{"X.java", "public class X{\n\t\n\tprivate static class GenericWrapper<Elem>  {\n\t\tZork z;\n\t\tprivate Elem theObject;\n\t\tpublic GenericWrapper(Elem arg) {\n\t\t\ttheObject = arg;\n\t\t}\n\t\tpublic <T extends Elem> GenericWrapper (GenericWrapper<T> other) {\n\t\t\tthis.theObject = other.theObject;\n\t\t}\n\t\tpublic String toString() {\n\t\t\treturn theObject.toString();\n\t\t}\n\t}\n\tprivate static GenericWrapper<String> method (Object wrappedString) {\n\t\treturn (GenericWrapper<String>) wrappedString;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(method(new GenericWrapper<String>(\"abc\")));\n\t\tSystem.out.println(method(new GenericWrapper<Exception>(new Exception())));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 12)\n\tpublic String toString() {\n\t              ^^^^^^^^^^\nThe method toString() of type X.GenericWrapper<Elem> should be tagged with @Override since it actually overrides a superclass method\n----------\n3. WARNING in X.java (at line 17)\n\treturn (GenericWrapper<String>) wrappedString;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to X.GenericWrapper<String>\n----------\n");
    }

    public void test0659() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.ref.*;\n\n@SuppressWarnings(\"unused\")\npublic class X<K, V> extends WeakReference<V> {\n\tZork z;\n\tstatic ReferenceQueue<Integer> queue = new ReferenceQueue<Integer>();\n\n\tprivate K key;\n\n\tpublic X(K key, V value, ReferenceQueue<V> queue) {\n\t\tsuper(value, queue);\n\t}\n\n\tpublic K getKey() {\n\t\treturn key;\n\t}\n\t@Override\n\tpublic String toString() {\n\t\treturn \"key:\" + key;\n\t}\n\n\tpublic static void main(String[] arg) throws Exception {\n\t\tX<String, Integer> ref = new X<String, Integer>(\"Dummy Key\", new Integer(5), queue);\n\t\tnew Thread() {\n\t\t\t@Override\n\t\t\tpublic void run() {\n\t\t\t\tfor (;;) {\n\t\t\t\t\t// force ref to be cleared\n\t\t\t\t\tSystem.gc();\n\t\t\t\t}\n\t\t\t}\n\t\t}.start();\n\n\t\tX<String, Integer> fromQueue = (X<String, Integer>) queue.remove();\n\t\tSystem.out.println(fromQueue);\n\t\tSystem.exit(0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 34)\n\tX<String, Integer> fromQueue = (X<String, Integer>) queue.remove();\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Reference<capture#1-of ? extends Integer> to X<String,Integer>\n----------\n");
    }

    public void test0660() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tboolean run(X x) {\n\t\treturn false;\n\t}\n\t<T> void run(Class<T> ct) {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tboolean b = new X().run(new X(){});\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0661() {
        this.runNegativeTest(new String[]{"X.java", "public class X<S extends Comparable<S>> {\n   public X() {\n       S a = (S)(Integer)3;\n   }\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tS a = (S)(Integer)3;\n\t      ^^^^^^^^^^^^^\nType safety: Unchecked cast from Integer to S\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0662() {
        this.runNegativeTest(new String[]{"X.java", "public class X<S extends Comparable<String>> {\n   public X() {\n       S a = (S)(Integer)3; // this should fail\n   }\n\tZork z;\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tS a = (S)(Integer)3; // this should fail\n\t      ^^^^^^^^^^^^^\nCannot cast from Integer to S\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0663() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n   Object foo(Comparable<Integer> c) {\n\t   return (Comparable<S>) c;\n   }\n   <U extends Throwable, V extends Runnable> void foo(List<V> lv) {\n\t   List l = (List<U>) lv;\n   }\n   <U extends Throwable, V extends Runnable> void foo2(List<List<V>> lv) {\n\t   List l = (List<List<U>>) lv;\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn (Comparable<S>) c;\n\t                   ^\nS cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 8)\n\tList l = (List<U>) lv;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 8)\n\tList l = (List<U>) lv;\n\t         ^^^^^^^^^^^^\nType safety: Unchecked cast from List<V> to List<U>\n----------\n4. WARNING in X.java (at line 8)\n\tList l = (List<U>) lv;\n\t         ^^^^^^^^^^^^\nUnnecessary cast from List<V> to List<U>\n----------\n5. WARNING in X.java (at line 11)\n\tList l = (List<List<U>>) lv;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n6. ERROR in X.java (at line 11)\n\tList l = (List<List<U>>) lv;\n\t         ^^^^^^^^^^^^^^^^^^\nCannot cast from List<List<V>> to List<List<U>>\n----------\n7. WARNING in X.java (at line 11)\n\tList l = (List<List<U>>) lv;\n\t         ^^^^^^^^^^^^^^^^^^\nUnnecessary cast from List<List<V>> to List<List<U>>\n----------\n");
    }

    public void test0664() {
        this.runNegativeTest(new String[]{"X.java", "public class X<S extends Comparable<String>> {\n   public X(X2 x2) {\n       S a = (S)x2;\n   }\n}\nabstract class X2 implements Comparable<X2> {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tS a = (S)x2;\n\t      ^^^^^\nCannot cast from X2 to S\n----------\n");
    }

    public void test0665() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test<S> {\n\tvoid foo() {\n\t\tA a = new A();\n\t\tComparable<Object> c = (Comparable<Object>) a; // Fails as expected\n\t\tComparable<S> c2 = (Comparable<S>) a; // Should fail?\n\t}\n\n}\n\nfinal class A implements Comparable<A> {\n\tpublic int compareTo(A o) {\n\t\treturn 0;\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 4)\n\tComparable<Object> c = (Comparable<Object>) a; // Fails as expected\n\t                       ^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from A to Comparable<Object>\n----------\n2. WARNING in Test.java (at line 5)\n\tComparable<S> c2 = (Comparable<S>) a; // Should fail?\n\t                   ^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from A to Comparable<S>\n----------\n");
    }

    public void test0666() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tvoid foo(List<Object> objects, List raw) {\n\n\t    List<Number> numbers;\n\t    List<? extends Number> ext;\n\t    \n\t    numbers= (List<Number>) objects; // correct - cast error\n\t    ext= (List<? extends Number>) objects; // wrong, should fail\n\n\t    ext= raw; // correct - raw conversion warning issued\n\t    numbers= raw; // correct - raw conversion warning issued\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid foo(List<Object> objects, List raw) {\n\t                               ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in X.java (at line 9)\n\tnumbers= (List<Number>) objects; // correct - cast error\n\t         ^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object> to List<Number>\n----------\n3. ERROR in X.java (at line 10)\n\text= (List<? extends Number>) objects; // wrong, should fail\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object> to List<? extends Number>\n----------\n4. WARNING in X.java (at line 12)\n\text= raw; // correct - raw conversion warning issued\n\t     ^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<? extends Number>\n----------\n5. WARNING in X.java (at line 13)\n\tnumbers= raw; // correct - raw conversion warning issued\n\t         ^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Number>\n----------\n");
    }

    public void _test0667() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n    public static void foo(List<? super Object[]> l) {    }\n \n    public static void foo2(List<Object[]> l) {    }\n \n    public static void foo3(List<? extends Object[]> l) {    }\n \n    public static void bar(List<? super Object> l) {    }\n \n    public static void bar2(List<Object> l) {    }\n \n    public static void bar3(List<? extends Object> l) {    }\n \n    public static void bar4(List<?> l) {    }\n \n    public static void main(String[] args) {\n        {   // can be { Object, Object[] }\n            List<? super Object[]> l = new ArrayList<Object[]>();\n            l.add(l.get(0));  // illegal [01]\n            l.add((Object) null);  // illegal [02]\n            l.add((Integer) null);  // illegal [03]\n            l.add((Object []) null); // illegal [04]\n            l.add((Integer []) null); // illegal [05]\n            l.add((Integer [][]) null); // illegal [06]\n \n            foo(l); // List<? super Object[]> - legal [07]\n            foo2(l); // List<Object[]> - illegal [08]\n            foo3(l); // List<? extends Object[]> - illegal [09]\n            bar(l); // List<? super Object> - illegal [10]\n            bar2(l); // List<Object> - illegal [11]\n            bar3(l); // List<? extends Object> - legal [12]\n            bar4(l); // List<?> - legal [13]\n        }\n        {   // can be Object[] or (? extends Object)[]\n            List<Object[]> l = new ArrayList<Object[]>();\n            l.add(l.get(0));  // legal [14]\n            l.add((Object) null);  // illegal [15]\n            l.add((Integer) null);  // illegal [16]\n            l.add((Object []) null); // legal [17]\n            l.add((Integer []) null); // legal [18]\n            l.add((Integer [][]) null); // legal [19]\n \n            foo(l); // List<? super Object[]> - legal [20]\n            foo2(l); // List<Object[]> - legal [21]\n            foo3(l); // List<? extends Object[]> - legal [22]\n            bar(l); // List<? super Object> - illegal [23]\n            bar2(l); // List<Object> - illegal [24]\n            bar3(l); // List<? extends Object> - legal [25]\n            bar4(l); // List<?> - legal [26]\n        }\n        {   // Only allows wildcards, Object is illegal.\n            List<? extends Object[]> l = new ArrayList<Object[]>();\n            l.add(l.get(0));  // illegal [27]\n            l.add((Object) null);  // illegal [28]\n            l.add((Integer) null);  // illegal [29]\n            l.add((Object []) null); // illegal [30]\n            l.add((Integer []) null); // illegal [31]\n            l.add((Integer [][]) null); // illegal [32]\n \n            foo(l); // List<? super Object[]> - illegal [33]\n            foo2(l); // List<Object[]> - illegal [34]\n            foo3(l); // List<? extends Object[]> - legal [35]\n            bar(l); // List<? super Object> - illegal [36]\n            bar2(l); // List<Object> - illegal [37]\n            bar3(l); // List<? extends Object> - legal [38]\n            bar4(l); // List<?> - legal [39]\n        }\n        {   // can add non-arrays but can only match ? super Object, ? super Object[], or ? extends Object, but not Object  \n            List<? super Object> l = new ArrayList<Object>();\n            l.add(l.get(0));  // legal [40]\n            l.add((Object) null);  // legal [41]\n            l.add((Integer) null);  // legal [42]\n            l.add((Object []) null); // illegal [43]\n            l.add((Integer []) null); // illegal [44]\n            l.add((Integer [][]) null); // illegal [45]\n \n            foo(l); // legal [46]\n            foo2(l); // illegal [47]\n            foo3(l); // illegal [48]\n            bar(l); // legal [49]\n            bar2(l); // illegal [50]\n            bar3(l); // legal [51]\n            bar4(l); // legal [52]\n        }\n        {   // can add array but cannot call a method which expects an array. 100% !\n            List<Object> l = new ArrayList<Object>();\n            l.get(0).toString();\n            l.add(l.get(0));  // legal [53]\n            l.add((Object) null);  // legal [54]\n            l.add((Integer) null);  // legal [55]\n            l.add((Object []) null); // legal [56]\n            l.add((Integer []) null); // legal [57]\n            l.add((Integer [][]) null); // legal [58]\n \n            foo(l); // legal [59]\n            foo2(l); // illegal [60]\n            foo3(l); // illegal [61]\n            bar(l); // legal [62]\n            bar2(l); // legal [63]\n            bar3(l); // legal [64]\n            bar4(l); // legal [65]\n        }\n        {   // cannot add any type but can match ? or ? extends Object.\n            List<? extends Object> l = new ArrayList<Object>();\n            l.add(l.get(0));  // illegal [66]\n            l.add((Object) null);  // illegal [67]\n            l.add((Integer) null);  // illegal [68]\n            l.add((Object []) null); // illegal [69]\n            l.add((Integer []) null); // illegal [70]\n            l.add((Integer [][]) null); // illegal [71]\n \n            foo(l); // List<? super Object[]> - illegal [72]\n            foo2(l); // List<Object[]> - illegal [73]\n            foo3(l); // List<? extends Object[]> - illegal [74]\n            bar(l); // List<? super Object> - illegal [75]\n            bar2(l); // List<Object> - illegal [76]\n            bar3(l); // List<? extends Object> - legal [77]\n            bar4(l); // List<?> - legal [78]\n        }\n        {   // same as ? extends Object.\n            List<?> l = new ArrayList<Object>();\n            l.add(l.get(0));  // illegal [79]\n            l.add((Object) null);  // illegal [80]\n            l.add((Integer) null);  // illegal [81]\n            l.add((Object []) null); // illegal [82]\n            l.add((Integer []) null); // illegal [83]\n            l.add((Integer [][]) null); // illegal [84]\n \n            foo(l); // List<? super Object[]> - illegal [85]\n            foo2(l); // List<Object[]> - illegal [86]\n            foo3(l); // List<? extends Object[]> - illegal [87]\n            bar(l); // List<? super Object> - illegal [88]\n            bar2(l); // List<Object> - illegal [89]\n            bar3(l); // List<? extends Object> - legal [90]\n            bar4(l); // List<?> - legal [91]\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 21)\n\tl.add(l.get(0));  // illegal [01]\n\t  ^^^\nThe method add(capture-of ? super Object[]) in the type List<capture-of ? super Object[]> is not applicable for the arguments (capture-of ? super Object[])\n----------\n2. ERROR in X.java (at line 22)\n\tl.add((Object) null);  // illegal [02]\n\t  ^^^\nThe method add(capture-of ? super Object[]) in the type List<capture-of ? super Object[]> is not applicable for the arguments (Object)\n----------\n3. ERROR in X.java (at line 23)\n\tl.add((Integer) null);  // illegal [03]\n\t  ^^^\nThe method add(capture-of ? super Object[]) in the type List<capture-of ? super Object[]> is not applicable for the arguments (Integer)\n----------\n4. ERROR in X.java (at line 24)\n\tl.add((Object []) null); // illegal [04]\n\t  ^^^\nThe method add(capture-of ? super Object[]) in the type List<capture-of ? super Object[]> is not applicable for the arguments (Object[])\n----------\n5. ERROR in X.java (at line 25)\n\tl.add((Integer []) null); // illegal [05]\n\t  ^^^\nThe method add(capture-of ? super Object[]) in the type List<capture-of ? super Object[]> is not applicable for the arguments (Integer[])\n----------\n6. ERROR in X.java (at line 26)\n\tl.add((Integer [][]) null); // illegal [06]\n\t  ^^^\nThe method add(capture-of ? super Object[]) in the type List<capture-of ? super Object[]> is not applicable for the arguments (Integer[][])\n----------\n7. ERROR in X.java (at line 28)\n\tfoo(l); // List<? super Object[]> - legal [07]\n\t^^^\nThe method foo(List<? super Object[]>) in the type X is not applicable for the arguments (List<capture-of ? super Object[]>)\n----------\n8. ERROR in X.java (at line 29)\n\tfoo2(l); // List<Object[]> - illegal [08]\n\t^^^^\nThe method foo2(List<Object[]>) in the type X is not applicable for the arguments (List<capture-of ? super Object[]>)\n----------\n9. ERROR in X.java (at line 30)\n\tfoo3(l); // List<? extends Object[]> - illegal [09]\n\t^^^^\nThe method foo3(List<? extends Object[]>) in the type X is not applicable for the arguments (List<capture-of ? super Object[]>)\n----------\n10. ERROR in X.java (at line 31)\n\tbar(l); // List<? super Object> - illegal [10]\n\t^^^\nThe method bar(List<? super Object>) in the type X is not applicable for the arguments (List<capture-of ? super Object[]>)\n----------\n11. ERROR in X.java (at line 32)\n\tbar2(l); // List<Object> - illegal [11]\n\t^^^^\nThe method bar2(List<Object>) in the type X is not applicable for the arguments (List<capture-of ? super Object[]>)\n----------\n12. ERROR in X.java (at line 39)\n\tl.add((Object) null);  // illegal [15]\n\t  ^^^\nThe method add(Object[]) in the type List<Object[]> is not applicable for the arguments (Object)\n----------\n13. ERROR in X.java (at line 40)\n\tl.add((Integer) null);  // illegal [16]\n\t  ^^^\nThe method add(Object[]) in the type List<Object[]> is not applicable for the arguments (Integer)\n----------\n14. ERROR in X.java (at line 48)\n\tbar(l); // List<? super Object> - illegal [23]\n\t^^^\nThe method bar(List<? super Object>) in the type X is not applicable for the arguments (List<Object[]>)\n----------\n15. ERROR in X.java (at line 49)\n\tbar2(l); // List<Object> - illegal [24]\n\t^^^^\nThe method bar2(List<Object>) in the type X is not applicable for the arguments (List<Object[]>)\n----------\n16. ERROR in X.java (at line 55)\n\tl.add(l.get(0));  // illegal [27]\n\t  ^^^\nThe method add(capture-of ? extends Object[]) in the type List<capture-of ? extends Object[]> is not applicable for the arguments (capture-of ? extends Object[])\n----------\n17. ERROR in X.java (at line 56)\n\tl.add((Object) null);  // illegal [28]\n\t  ^^^\nThe method add(capture-of ? extends Object[]) in the type List<capture-of ? extends Object[]> is not applicable for the arguments (Object)\n----------\n18. ERROR in X.java (at line 57)\n\tl.add((Integer) null);  // illegal [29]\n\t  ^^^\nThe method add(capture-of ? extends Object[]) in the type List<capture-of ? extends Object[]> is not applicable for the arguments (Integer)\n----------\n19. ERROR in X.java (at line 58)\n\tl.add((Object []) null); // illegal [30]\n\t  ^^^\nThe method add(capture-of ? extends Object[]) in the type List<capture-of ? extends Object[]> is not applicable for the arguments (Object[])\n----------\n20. ERROR in X.java (at line 59)\n\tl.add((Integer []) null); // illegal [31]\n\t  ^^^\nThe method add(capture-of ? extends Object[]) in the type List<capture-of ? extends Object[]> is not applicable for the arguments (Integer[])\n----------\n21. ERROR in X.java (at line 60)\n\tl.add((Integer [][]) null); // illegal [32]\n\t  ^^^\nThe method add(capture-of ? extends Object[]) in the type List<capture-of ? extends Object[]> is not applicable for the arguments (Integer[][])\n----------\n22. ERROR in X.java (at line 62)\n\tfoo(l); // List<? super Object[]> - illegal [33]\n\t^^^\nThe method foo(List<? super Object[]>) in the type X is not applicable for the arguments (List<capture-of ? extends Object[]>)\n----------\n23. ERROR in X.java (at line 63)\n\tfoo2(l); // List<Object[]> - illegal [34]\n\t^^^^\nThe method foo2(List<Object[]>) in the type X is not applicable for the arguments (List<capture-of ? extends Object[]>)\n----------\n24. ERROR in X.java (at line 65)\n\tbar(l); // List<? super Object> - illegal [36]\n\t^^^\nThe method bar(List<? super Object>) in the type X is not applicable for the arguments (List<capture-of ? extends Object[]>)\n----------\n25. ERROR in X.java (at line 66)\n\tbar2(l); // List<Object> - illegal [37]\n\t^^^^\nThe method bar2(List<Object>) in the type X is not applicable for the arguments (List<capture-of ? extends Object[]>)\n----------\n26. ERROR in X.java (at line 75)\n\tl.add((Object []) null); // illegal [43]\n\t  ^^^\nThe method add(capture-of ? super Object) in the type List<capture-of ? super Object> is not applicable for the arguments (Object[])\n----------\n27. ERROR in X.java (at line 76)\n\tl.add((Integer []) null); // illegal [44]\n\t  ^^^\nThe method add(capture-of ? super Object) in the type List<capture-of ? super Object> is not applicable for the arguments (Integer[])\n----------\n28. ERROR in X.java (at line 77)\n\tl.add((Integer [][]) null); // illegal [45]\n\t  ^^^\nThe method add(capture-of ? super Object) in the type List<capture-of ? super Object> is not applicable for the arguments (Integer[][])\n----------\n29. ERROR in X.java (at line 79)\n\tfoo(l); // legal [46]\n\t^^^\nThe method foo(List<? super Object[]>) in the type X is not applicable for the arguments (List<capture-of ? super Object>)\n----------\n30. ERROR in X.java (at line 80)\n\tfoo2(l); // illegal [47]\n\t^^^^\nThe method foo2(List<Object[]>) in the type X is not applicable for the arguments (List<capture-of ? super Object>)\n----------\n31. ERROR in X.java (at line 81)\n\tfoo3(l); // illegal [48]\n\t^^^^\nThe method foo3(List<? extends Object[]>) in the type X is not applicable for the arguments (List<capture-of ? super Object>)\n----------\n32. ERROR in X.java (at line 83)\n\tbar2(l); // illegal [50]\n\t^^^^\nThe method bar2(List<Object>) in the type X is not applicable for the arguments (List<capture-of ? super Object>)\n----------\n33. ERROR in X.java (at line 98)\n\tfoo2(l); // illegal [60]\n\t^^^^\nThe method foo2(List<Object[]>) in the type X is not applicable for the arguments (List<Object>)\n----------\n34. ERROR in X.java (at line 99)\n\tfoo3(l); // illegal [61]\n\t^^^^\nThe method foo3(List<? extends Object[]>) in the type X is not applicable for the arguments (List<Object>)\n----------\n35. ERROR in X.java (at line 107)\n\tl.add(l.get(0));  // illegal [66]\n\t  ^^^\nThe method add(capture-of ? extends Object) in the type List<capture-of ? extends Object> is not applicable for the arguments (capture-of ? extends Object)\n----------\n36. ERROR in X.java (at line 108)\n\tl.add((Object) null);  // illegal [67]\n\t  ^^^\nThe method add(capture-of ? extends Object) in the type List<capture-of ? extends Object> is not applicable for the arguments (Object)\n----------\n37. ERROR in X.java (at line 109)\n\tl.add((Integer) null);  // illegal [68]\n\t  ^^^\nThe method add(capture-of ? extends Object) in the type List<capture-of ? extends Object> is not applicable for the arguments (Integer)\n----------\n38. ERROR in X.java (at line 110)\n\tl.add((Object []) null); // illegal [69]\n\t  ^^^\nThe method add(capture-of ? extends Object) in the type List<capture-of ? extends Object> is not applicable for the arguments (Object[])\n----------\n39. ERROR in X.java (at line 111)\n\tl.add((Integer []) null); // illegal [70]\n\t  ^^^\nThe method add(capture-of ? extends Object) in the type List<capture-of ? extends Object> is not applicable for the arguments (Integer[])\n----------\n40. ERROR in X.java (at line 112)\n\tl.add((Integer [][]) null); // illegal [71]\n\t  ^^^\nThe method add(capture-of ? extends Object) in the type List<capture-of ? extends Object> is not applicable for the arguments (Integer[][])\n----------\n41. ERROR in X.java (at line 114)\n\tfoo(l); // List<? super Object[]> - illegal [72]\n\t^^^\nThe method foo(List<? super Object[]>) in the type X is not applicable for the arguments (List<capture-of ? extends Object>)\n----------\n42. ERROR in X.java (at line 115)\n\tfoo2(l); // List<Object[]> - illegal [73]\n\t^^^^\nThe method foo2(List<Object[]>) in the type X is not applicable for the arguments (List<capture-of ? extends Object>)\n----------\n43. ERROR in X.java (at line 116)\n\tfoo3(l); // List<? extends Object[]> - illegal [74]\n\t^^^^\nThe method foo3(List<? extends Object[]>) in the type X is not applicable for the arguments (List<capture-of ? extends Object>)\n----------\n44. ERROR in X.java (at line 117)\n\tbar(l); // List<? super Object> - illegal [75]\n\t^^^\nThe method bar(List<? super Object>) in the type X is not applicable for the arguments (List<capture-of ? extends Object>)\n----------\n45. ERROR in X.java (at line 118)\n\tbar2(l); // List<Object> - illegal [76]\n\t^^^^\nThe method bar2(List<Object>) in the type X is not applicable for the arguments (List<capture-of ? extends Object>)\n----------\n46. ERROR in X.java (at line 124)\n\tl.add(l.get(0));  // illegal [79]\n\t  ^^^\nThe method add(capture-of ?) in the type List<capture-of ?> is not applicable for the arguments (capture-of ?)\n----------\n47. ERROR in X.java (at line 125)\n\tl.add((Object) null);  // illegal [80]\n\t  ^^^\nThe method add(capture-of ?) in the type List<capture-of ?> is not applicable for the arguments (Object)\n----------\n48. ERROR in X.java (at line 126)\n\tl.add((Integer) null);  // illegal [81]\n\t  ^^^\nThe method add(capture-of ?) in the type List<capture-of ?> is not applicable for the arguments (Integer)\n----------\n49. ERROR in X.java (at line 127)\n\tl.add((Object []) null); // illegal [82]\n\t  ^^^\nThe method add(capture-of ?) in the type List<capture-of ?> is not applicable for the arguments (Object[])\n----------\n50. ERROR in X.java (at line 128)\n\tl.add((Integer []) null); // illegal [83]\n\t  ^^^\nThe method add(capture-of ?) in the type List<capture-of ?> is not applicable for the arguments (Integer[])\n----------\n51. ERROR in X.java (at line 129)\n\tl.add((Integer [][]) null); // illegal [84]\n\t  ^^^\nThe method add(capture-of ?) in the type List<capture-of ?> is not applicable for the arguments (Integer[][])\n----------\n52. ERROR in X.java (at line 131)\n\tfoo(l); // List<? super Object[]> - illegal [85]\n\t^^^\nThe method foo(List<? super Object[]>) in the type X is not applicable for the arguments (List<capture-of ?>)\n----------\n53. ERROR in X.java (at line 132)\n\tfoo2(l); // List<Object[]> - illegal [86]\n\t^^^^\nThe method foo2(List<Object[]>) in the type X is not applicable for the arguments (List<capture-of ?>)\n----------\n54. ERROR in X.java (at line 133)\n\tfoo3(l); // List<? extends Object[]> - illegal [87]\n\t^^^^\nThe method foo3(List<? extends Object[]>) in the type X is not applicable for the arguments (List<capture-of ?>)\n----------\n55. ERROR in X.java (at line 134)\n\tbar(l); // List<? super Object> - illegal [88]\n\t^^^\nThe method bar(List<? super Object>) in the type X is not applicable for the arguments (List<capture-of ?>)\n----------\n56. ERROR in X.java (at line 135)\n\tbar2(l); // List<Object> - illegal [89]\n\t^^^^\nThe method bar2(List<Object>) in the type X is not applicable for the arguments (List<capture-of ?>)\n----------\n");
    }

    public void test0668() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n \npublic class X {\n    void foo(List<? super Object[]> l) {\n        l.add(new Object[0]);\n    }\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0669() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\nprivate static<T> int indexOf(final T[] array,final T elem) {\n\treturn 0;\n}\npublic static void meth(AContainer ac, AInfo[] aiArray) {\n  for(AInfo ai: aiArray) {\n\tint index1 = indexOf(ac.getAs(),ai.a);\n\tint index2 = indexOf(ac.getAs(),ai); // ai.class!=ai.a.class!!!\n  }\n}\n}\n\nclass AContainer {\n   public A[] getAs(){ return null; }\n}\n\nclass AInfo {\n   public A a;\n}\n\nclass A {\n}\n"}, "");
    }

    public void test0670() {
        this.runConformTest(true, new String[]{"X.java", "import java.util.Map;\n\ninterface MethodProperty<ActualType extends MethodProperty<ActualType>> {\n\tpublic void copyFrom(ActualType other);\n}\n\nclass MethodPropertyDatabase<Property extends MethodProperty<Property>> {\n\tMap<String, Property> propertyMap;\n\t\n\tvoid read(String fileName) {\n\t}\n}\n\nclass FooProperty implements MethodProperty<FooProperty> {\n\tString value;\n\n\tpublic void copyFrom(FooProperty other) {\n\t\tthis.value = other.value;\n\t}\n}\n\nclass FooPropertyDatabase extends MethodPropertyDatabase<FooProperty> {\n}\n\npublic class X {\n\tFooPropertyDatabase fooDatabase;\n\t\n\tpublic void readDatabase() {\n\t\tFooPropertyDatabase database = new FooPropertyDatabase();\n\t\t\n\t\tfooDatabase = readDatabase(database, \"foodatabase.db\"); // Bug reported on this line\n\t}\n\t\n\tprivate<\n\t\tProperty extends MethodProperty<Property>,\n\t\tDatabaseType extends MethodPropertyDatabase<Property>\n\t\t> DatabaseType readDatabase(DatabaseType database, String fileName) {\n\t\t\tdatabase.read(fileName);\n\t\t\treturn database;\n\t\t}\n\t\n}\n"}, "", null, null, AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug95021);
    }

    public void test0671() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\n\ninterface MethodProperty<ActualType extends MethodProperty<ActualType>> {\n\tpublic void copyFrom(ActualType other);\n}\n\nclass MethodPropertyDatabase<Property extends MethodProperty<Property>> {\n\tMap<String, Property> propertyMap;\n\t\n\tvoid read(String fileName) {\n\t}\n}\n\nclass FooProperty implements MethodProperty<FooProperty> {\n\tString value;\n\n\tpublic void copyFrom(FooProperty other) {\n\t\tthis.value = other.value;\n\t}\n}\n\nclass FooPropertyDatabase extends MethodPropertyDatabase<FooProperty> {\n}\n\npublic class X {\n  Zork z;\n\tFooPropertyDatabase fooDatabase;\n\t\n\tpublic void readDatabase() {\n\t\tFooPropertyDatabase database = new FooPropertyDatabase();\n\t\t\n\t\tfooDatabase = readDatabase(database, \"foodatabase.db\"); // Bug reported on this line\n\t}\n\t\n\tprivate<\n\t\tProperty extends MethodProperty<Property>,\n\t\tDatabaseType extends MethodPropertyDatabase<Property>\n\t\t> DatabaseType readDatabase(DatabaseType database, String fileName) {\n\t\t\tdatabase.read(fileName);\n\t\t\treturn database;\n\t\t}\n\t\n}\n"}, "----------\n1. ERROR in X.java (at line 26)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0672() {
        this.runNegativeTest(new String[]{"X.java", "interface Foo<T extends Foo<T>> {\n}\n\nclass Bar<Q> {\n}\n\n\npublic class X {\n\tZork z;\n\tvoid readDatabase() {\n\t\tBar<Foo> bar = new Bar<Foo>();\n\t\tread(bar, \"sadasd\");\n\t}\n\t\n\t<P extends Foo<P>, D extends Bar<P>> \n\tD read(D d, String s) {\n\t\t\treturn d;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 11)\n\tBar<Foo> bar = new Bar<Foo>();\n\t    ^^^\nFoo is a raw type. References to generic type Foo<T> should be parameterized\n----------\n3. WARNING in X.java (at line 11)\n\tBar<Foo> bar = new Bar<Foo>();\n\t                       ^^^\nFoo is a raw type. References to generic type Foo<T> should be parameterized\n----------\n4. WARNING in X.java (at line 12)\n\tread(bar, \"sadasd\");\n\t^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation read(Bar<Foo>, String) of the generic method read(D, String) of type X\n----------\n");
    }

    public void test0673() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\nclass Key<E, F extends Type<E, F>> {\n}\n\nclass State<S extends State> {\n}\n\nclass Type<T, U extends Type<T, U>> {\n}\n\nclass Store<A, B extends Type<A, B>, C extends Key<A, B>, D extends State<D>> {\n}\n\npublic class X<K> {\n\tList<Store<K, ?, ? extends Key<K, ?>, ? extends State<?>>> stores;\n}\n"}, "");
    }

    public void test0674() {
        this.runConformTest(new String[]{"X.java", "class Key<E extends Key<E>> {}\nclass Store<F extends Key<F>> {}\n\npublic class X<T extends Key<T>> {\n\tStore<? extends Key<T>> store;\n}\n"}, "");
    }

    public void test0675() {
        this.runNegativeTest(new String[]{"X.java", "class Key<E extends Key<E>> {}\nclass Store<F extends Key<F>> {}\n\npublic class X<T> {\n\tStore<? extends Key<T>> store1;\n\tStore<? extends Key<? extends T>> store2;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tStore<? extends Key<T>> store1;\n\t                    ^\nBound mismatch: The type T is not a valid substitute for the bounded parameter <E extends Key<E>> of the type Key<E>\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0676() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Throwable> {\n\tT get() { return null; }\n\t\n\tvoid foo(X<String> xs) {\n\t\txs.get().printStackTrace();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tvoid foo(X<String> xs) {\n\t           ^^^^^^\nBound mismatch: The type String is not a valid substitute for the bounded parameter <T extends Throwable> of the type X<T>\n----------\n2. ERROR in X.java (at line 5)\n\txs.get().printStackTrace();\n\t         ^^^^^^^^^^^^^^^\nThe method printStackTrace() is undefined for the type String\n----------\n");
    }

    public void test0677() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t{\n\t\t\tArrayList<Number> arrayList = new ArrayList<Integer>(); // compile error\n\t\t\tNumber number = arrayList.get(0);\n\t\t}\n\t\t{\n\t\t\tArrayList<? extends Number> arrayList = new ArrayList<Integer>(); //correct\n\t\t\tNumber number = arrayList.get(0);\n\t\t}\n\t\t{\n\t\t\tArrayList<? super Integer> arrayList = new ArrayList<Number>();\n\t\t\tObject number = arrayList.get(0); //returns java.lang.Object\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tArrayList<Number> arrayList = new ArrayList<Integer>(); // compile error\n\t                              ^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from ArrayList<Integer> to ArrayList<Number>\n----------\n");
    }

    public void test0678() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\n\npublic class X<T, T2 extends T & Serializable > {\n\t\n\tX<Object, Serializable> right1;\n\tX<String, Serializable> wrong1;\n\tX<Y, Y> right2;\n\t\n\tstatic class Y implements Serializable {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic class X<T, T2 extends T & Serializable > {\n\t                                 ^^^^^^^^^^^^\nCannot specify any additional bound Serializable when first bound is a type parameter\n----------\n2. ERROR in X.java (at line 6)\n\tX<String, Serializable> wrong1;\n\t          ^^^^^^^^^^^^\nBound mismatch: The type Serializable is not a valid substitute for the bounded parameter <T2 extends T & Serializable> of the type X<T,T2>\n----------\n3. WARNING in X.java (at line 9)\n\tstatic class Y implements Serializable {\n\t             ^\nThe serializable class Y does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test0679() {
        this.runConformTest(new String[]{"X.java", "class Key<E, F extends Key<E, F>> {}\nclass Store<A, B extends Key<A, B>> {}\n\npublic class X<K extends Key<?, K>> {\n\tStore<K, ? extends Key<K, ?>> store;\n}\n"}, "");
    }

    public void test0680() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\nclass Key<E, F extends Type<E, F, G, H>, G extends Key<E, F, G, H>, H extends State<H>> {}\nclass State<S extends State> {}\nclass Type<T, U extends Type<T, U, V, W>, V extends Key<T, U, V, W>, W extends State<W>> {}\nclass Store<A, B extends Type<A, B, C, D>, C extends Key<A, B, C, D>, D extends State<D>> {}\n\npublic class X<K extends Key<K, ?,?,?>> {\n\tList<Store<K, ?, ? extends Key<K, ?, ?, ?>, ? extends State<?>>> stores;\n}\n"}, "");
    }

    public void test0681() {
        this.runConformTest(new String[]{"X.java", "class Key<E, K extends Key<E, K>> {\n}\nclass Store<E, K extends Key<E, K>> {\n}\nclass X<E> {\n\tStore<E, ?> store1;\n\tStore<E, ? extends Key<E, ?>> store2;\n\n\tclass StoreHolder <F extends Key<E, F>> {\n\t\tStore<E, F> store;\n\t}\n}\nclass Y<T, U extends Y<T, U>> {\n\tY<?, ?> y;\n}\n"}, "");
    }

    public void test0682() {
        this.runNegativeTest(new String[]{"X.java", "class X extends A<X.M> {}\nclass A<T> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends A<X.M> {}\n\t                  ^^^\nX.M cannot be resolved to a type\n----------\n");
    }

    public void test0683() {
        this.runConformTest(new String[]{"P.java", "public interface P<V> {\n    interface A {}\n}\n", "P2.java", "public class P2 implements P.A {\n    P2(P.A problem) {}\n}\n", "P3.java", "public class P3 {\n    void test() {P.A o = new P2((P.A) null);}\n}\n"}, "");
        this.runConformTest(new String[]{"P3.java", "class P3 {\n    void test() {P.A o = new P2((P.A) null);}\n}\n"}, "", null, false, null);
    }

    public void test0684() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\t<U> U foo(U u1, U u2) {\n\t\treturn u1;\n\t}\n\tvoid bar(X<? extends Throwable> x1, X<? extends Runnable> x2) {\n\t\tX<String> x = foo(x1, x2);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tX<String> x = foo(x1, x2);\n\t              ^^^^^^^^^^^\nType mismatch: cannot convert from X<capture#3-of ? extends Object> to X<String>\n----------\n");
    }

    public void test0685() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\t<U> U foo(U u1, U u2) {\n\t\treturn u1;\n\t}\n\tvoid bar(X<? extends Throwable> x1, X<? extends Runnable> x2) {\n\t\tX<String> x = foo(x1, x2);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tX<String> x = foo(x1, x2);\n\t              ^^^^^^^^^^^\nType mismatch: cannot convert from X<capture#3-of ? extends Object> to X<String>\n----------\n");
    }

    public void test0686() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass Other<T extends List<? extends Runnable>> {\n}\n\npublic class X {\n\tOther<? extends List<? extends Throwable>> other1;\n\tOther<? extends List<? super String>> other2;\t\n\tOther<? extends List<? extends String>> other3;\t\t\n\tOther<? extends List<? extends Runnable>> other7 = other1;\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tOther<? extends List<? super String>> other2;\t\n\t      ^^^^^^^^^^^^^^\nBound mismatch: The type ? extends List<? super String> is not a valid substitute for the bounded parameter <T extends List<? extends Runnable>> of the type Other<T>\n----------\n2. ERROR in X.java (at line 8)\n\tOther<? extends List<? extends String>> other3;\t\t\n\t      ^^^^^^^^^^^^^^\nBound mismatch: The type ? extends List<? extends String> is not a valid substitute for the bounded parameter <T extends List<? extends Runnable>> of the type Other<T>\n----------\n");
    }

    public void test0687() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass Other<T extends List<? extends Runnable>> {\n}\n\npublic class X {\n\tOther<? extends List<?>> other2;\n\tOther<? extends List<? super Throwable>> other3;\n\tOther<? super List<? extends Throwable>> other4;\n\tOther<? super List<?>> other5;\n\tOther<? super List<? super Throwable>> other6;\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tOther<? extends List<? super Throwable>> other3;\n\t      ^^^^^^^^^^^^^^\nBound mismatch: The type ? extends List<? super Throwable> is not a valid substitute for the bounded parameter <T extends List<? extends Runnable>> of the type Other<T>\n----------\n2. ERROR in X.java (at line 8)\n\tOther<? super List<? extends Throwable>> other4;\n\t      ^^^^^^^^^^^^\nBound mismatch: The type ? super List<? extends Throwable> is not a valid substitute for the bounded parameter <T extends List<? extends Runnable>> of the type Other<T>\n----------\n3. ERROR in X.java (at line 9)\n\tOther<? super List<?>> other5;\n\t      ^^^^^^^^^^^^\nBound mismatch: The type ? super List<?> is not a valid substitute for the bounded parameter <T extends List<? extends Runnable>> of the type Other<T>\n----------\n4. ERROR in X.java (at line 10)\n\tOther<? super List<? super Throwable>> other6;\n\t      ^^^^^^^^^^^^\nBound mismatch: The type ? super List<? super Throwable> is not a valid substitute for the bounded parameter <T extends List<? extends Runnable>> of the type Other<T>\n----------\n");
    }

    public void test0688() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nclass Other<T extends List<? extends Runnable>> {\n}\n\npublic class X {\n\tOther<? super List<? extends Runnable>> other5;\n}\n"}, "");
    }

    public void test0689() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass Other<T extends List<? extends Runnable>> {\n}\n\npublic class X {\n\tOther<? super List<? super Runnable>> other5;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tOther<? super List<? super Runnable>> other5;\n\t      ^^^^^^^^^^^^\nBound mismatch: The type ? super List<? super Runnable> is not a valid substitute for the bounded parameter <T extends List<? extends Runnable>> of the type Other<T>\n----------\n");
    }

    public void test0690() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tvoid foo(List<? extends Runnable> lr, List<?> la) {\n\t\tlr = la;\n\t\tla = lr;\n\t}\n}         \n\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tlr = la;\n\t     ^^\nType mismatch: cannot convert from List<capture#2-of ?> to List<? extends Runnable>\n----------\n");
    }

    public void test0691() {
        this.runNegativeTest(new String[]{"XX.java", "public class XX<T extends Runnable> {\n\tvoid foo(XX<?> lhs, XX<? extends String> rhs) {\n\t\tlhs = rhs;\n\t}\n}\n"}, "----------\n1. ERROR in XX.java (at line 2)\n\tvoid foo(XX<?> lhs, XX<? extends String> rhs) {\n\t                       ^^^^^^^^^^^^^^^^\nBound mismatch: The type ? extends String is not a valid substitute for the bounded parameter <T extends Runnable> of the type XX<T>\n----------\n");
    }

    public void test0692() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X<T extends List<Object>> {\n\t\n\tvoid foo(X<? extends List<String>> x) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo(X<? extends List<String>> x) {\n\t           ^^^^^^^^^^^^^^\nBound mismatch: The type ? extends List<String> is not a valid substitute for the bounded parameter <T extends List<Object>> of the type X<T>\n----------\n");
    }

    public void test0693() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Runnable> {\n\tX<X<String>> x1;\n\tX<? extends String> x2;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tX<X<String>> x1;\n\t  ^\nBound mismatch: The type X<String> is not a valid substitute for the bounded parameter <T extends Runnable> of the type X<T>\n----------\n2. ERROR in X.java (at line 2)\n\tX<X<String>> x1;\n\t    ^^^^^^\nBound mismatch: The type String is not a valid substitute for the bounded parameter <T extends Runnable> of the type X<T>\n----------\n3. ERROR in X.java (at line 3)\n\tX<? extends String> x2;\n\t  ^^^^^^^^^^^^^^^^\nBound mismatch: The type ? extends String is not a valid substitute for the bounded parameter <T extends Runnable> of the type X<T>\n----------\n");
    }

    public void test0694() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends X<T>> {\n\tX<X<X<String>>> x1;\n\tX<? extends X<? extends X<String>>> x2;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tX<X<X<String>>> x1;\n\t  ^\nBound mismatch: The type X<X<String>> is not a valid substitute for the bounded parameter <T extends X<T>> of the type X<T>\n----------\n2. ERROR in X.java (at line 2)\n\tX<X<X<String>>> x1;\n\t    ^\nBound mismatch: The type X<String> is not a valid substitute for the bounded parameter <T extends X<T>> of the type X<T>\n----------\n3. ERROR in X.java (at line 2)\n\tX<X<X<String>>> x1;\n\t      ^^^^^^\nBound mismatch: The type String is not a valid substitute for the bounded parameter <T extends X<T>> of the type X<T>\n----------\n4. ERROR in X.java (at line 3)\n\tX<? extends X<? extends X<String>>> x2;\n\t  ^^^^^^^^^^^\nBound mismatch: The type ? extends X<? extends X<String>> is not a valid substitute for the bounded parameter <T extends X<T>> of the type X<T>\n----------\n5. ERROR in X.java (at line 3)\n\tX<? extends X<? extends X<String>>> x2;\n\t              ^^^^^^^^^^^\nBound mismatch: The type ? extends X<String> is not a valid substitute for the bounded parameter <T extends X<T>> of the type X<T>\n----------\n6. ERROR in X.java (at line 3)\n\tX<? extends X<? extends X<String>>> x2;\n\t                          ^^^^^^\nBound mismatch: The type String is not a valid substitute for the bounded parameter <T extends X<T>> of the type X<T>\n----------\n");
    }

    public void test0695() {
        this.runConformTest(new String[]{"I.java", "interface I<T extends I<? extends T>> {\n}\n"}, "");
    }

    public void test0696() {
        this.runNegativeTest(new String[]{"X.java", "class Key<E extends Key<E>> {}\nclass Store<F extends Key<F>> {}\n\npublic class X<T> {\n\tStore<? extends Key<T>> store = new Store<Key<T>>();\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tStore<? extends Key<T>> store = new Store<Key<T>>();\n\t                    ^\nBound mismatch: The type T is not a valid substitute for the bounded parameter <E extends Key<E>> of the type Key<E>\n----------\n2. ERROR in X.java (at line 5)\n\tStore<? extends Key<T>> store = new Store<Key<T>>();\n\t                                          ^^^\nBound mismatch: The type Key<T> is not a valid substitute for the bounded parameter <F extends Key<F>> of the type Store<F>\n----------\n3. ERROR in X.java (at line 5)\n\tStore<? extends Key<T>> store = new Store<Key<T>>();\n\t                                              ^\nBound mismatch: The type T is not a valid substitute for the bounded parameter <E extends Key<E>> of the type Key<E>\n----------\n");
    }

    public void test0697() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\npublic class X<U, V extends List<U>> {\n\tV v;\n\t\n\tvoid foo(X<String, ?> x1, X<Object, ?> x2) {\n\t\tString s =x1.v.get(0);\n\t\tObject o = x2.v.get(0);\n\t\t\n\t}\n}\n"}, "");
    }

    public void test0698() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X<U extends List<Object>, V extends List<String>> {\n\t\n\tX<? super Exception, ? super Exception> x;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tX<? super Exception, ? super Exception> x;\n\t  ^^^^^^^^^^^^^^^^^\nBound mismatch: The type ? super Exception is not a valid substitute for the bounded parameter <U extends List<Object>> of the type X<U,V>\n----------\n2. ERROR in X.java (at line 5)\n\tX<? super Exception, ? super Exception> x;\n\t                     ^^^^^^^^^^^^^^^^^\nBound mismatch: The type ? super Exception is not a valid substitute for the bounded parameter <V extends List<String>> of the type X<U,V>\n----------\n");
    }

    public void test0699() {
        this.runNegativeTest(new String[]{"X2.java", "import java.util.List;\nclass Other2<T extends List< Runnable>> {\n}\n\nclass X2 {\n\tOther2<? extends List<Throwable>> other1;\n\tOther2<? extends List<? super String>> other2;\t\n\tOther2<? extends List<? extends String>> other3;\t\t\n\tOther2<? extends List<? extends Runnable>> other7 = other1;\n}\n"}, "----------\n1. ERROR in X2.java (at line 6)\n\tOther2<? extends List<Throwable>> other1;\n\t       ^^^^^^^^^^^^^^\nBound mismatch: The type ? extends List<Throwable> is not a valid substitute for the bounded parameter <T extends List<Runnable>> of the type Other2<T>\n----------\n2. ERROR in X2.java (at line 7)\n\tOther2<? extends List<? super String>> other2;\t\n\t       ^^^^^^^^^^^^^^\nBound mismatch: The type ? extends List<? super String> is not a valid substitute for the bounded parameter <T extends List<Runnable>> of the type Other2<T>\n----------\n3. ERROR in X2.java (at line 8)\n\tOther2<? extends List<? extends String>> other3;\t\t\n\t       ^^^^^^^^^^^^^^\nBound mismatch: The type ? extends List<? extends String> is not a valid substitute for the bounded parameter <T extends List<Runnable>> of the type Other2<T>\n----------\n");
    }

    public void test0700() {
        this.runConformTest(new String[]{"X.java", "abstract class BaseFactory<T> {\n\tpublic T create() throws Exception {\n\t\treturn getType().newInstance();\n\t}\n\tpublic abstract Class<T> getType();\n}\ninterface StringFactory {\n\tpublic String create() throws Exception;\n}\npublic class X extends BaseFactory<String> implements StringFactory {\n\t@Override\n\tpublic Class<String> getType() {\n\t\treturn String.class;\n\t}\n\tpublic static void main(String[] args) throws Exception {\n\t\tString emptyString = new X().create();\n\t\tSystem.out.printf(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0701() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\n\nclass Deejay {\n\tclass Counter<T> {}\n\n\tCounter<Song> songCounter = new Counter<Song>();\n\tCounter<Genre> genreCounter = new Counter<Genre>();\n\n\tList<Counter<?>> list1 = Arrays.asList(songCounter, genreCounter);\n\tList<Counter<? extends Object>> list2 = Arrays.asList(songCounter, genreCounter);\n\tList<Counter<?>> list3 = Arrays.<Counter<?>>asList(songCounter, genreCounter);\n\tList<Counter<?>> list4 = Arrays.asList(new Counter<?>[] {songCounter, genreCounter});\n\tList<Counter<? extends String>> list5 = Arrays.asList(songCounter, genreCounter);\n}\nclass Genre {}\nclass Song {}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tList<Counter<? extends String>> list5 = Arrays.asList(songCounter, genreCounter);\n\t                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Deejay.Counter<? extends Object>> to List<Deejay.Counter<? extends String>>\n----------\n", null, true, options);
    }

    public void test0702() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Runnable> implements Runnable {\n\t\n\tvoid foo0(X<X<?>> lhs, X<X<? extends Runnable>> rhs) {\n\t\tlhs = rhs; // 0\n\t}\n\tvoid foo1(X<X<?>> lhs, X<X<? extends Object>> rhs) {\n\t\tlhs = rhs; // 1\n\t}\n\tvoid foo2(X<X<? extends Cloneable>> lhs, X<X<? extends Object>> rhs) {\n\t\tlhs = rhs; // 2\n\t}\n\tvoid foo3(X<X<? extends Runnable>> lhs, X<X<? extends Object>> rhs) {\n\t\tlhs = rhs; // 3\n\t}\n\tvoid foo4(X<X<? extends Runnable>> lhs, X<X<?>> rhs) {\n\t\tlhs = rhs; // 4\n\t}\n\tvoid foo5(X<X<?>> lhs, X<X<? extends Cloneable>> rhs) {\n\t\tlhs = rhs; // 5\n\t}\n\tvoid foo6(X<X<X<X<X<?>>>>> lhs, X<X<X<X<X<? extends Runnable>>>>> rhs) {\n\t\tlhs = rhs; // 6\n\t}\t\n\tpublic void run() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tlhs = rhs; // 1\n\t      ^^^\nType mismatch: cannot convert from X<X<? extends Object>> to X<X<?>>\n----------\n2. ERROR in X.java (at line 10)\n\tlhs = rhs; // 2\n\t      ^^^\nType mismatch: cannot convert from X<X<? extends Object>> to X<X<? extends Cloneable>>\n----------\n3. ERROR in X.java (at line 13)\n\tlhs = rhs; // 3\n\t      ^^^\nType mismatch: cannot convert from X<X<? extends Object>> to X<X<? extends Runnable>>\n----------\n4. ERROR in X.java (at line 19)\n\tlhs = rhs; // 5\n\t      ^^^\nType mismatch: cannot convert from X<X<? extends Cloneable>> to X<X<?>>\n----------\n");
    }

    public void test0703() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends X<T>> {}\nclass Y extends X<Y> {\n    X<?> p = (Y)null;\n}\n"}, "");
    }

    public void test0704() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\t\t public static void main(String[] args) {\n\t\t \t\t List<String> l = (List<String>)Collections.emptyList();\n\t\t }\t \n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tList<String> l = (List<String>)Collections.emptyList();\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object> to List<String>\n----------\n");
    }

    public void test0705() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n  void f(Object o){\n\t\t ((Map.Entry)o).setValue(\"bug\");\n\t\t \t\t \n\t\t Map.Entry me= (Map.Entry)o; \n\t\t me.setValue(\"ok\");\n\t\t \t\t \n\t\t ((Vector)o).add(\"ok\");\n  }\n Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\t((Map.Entry)o).setValue(\"bug\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method setValue(Object) belongs to the raw type Map.Entry. References to generic type Map<K,V>.Entry<K,V> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\t((Map.Entry)o).setValue(\"bug\");\n\t  ^^^^^^^^^\nMap.Entry is a raw type. References to generic type Map<K,V>.Entry<K,V> should be parameterized\n----------\n3. WARNING in X.java (at line 7)\n\tMap.Entry me= (Map.Entry)o; \n\t^^^^^^^^^\nMap.Entry is a raw type. References to generic type Map<K,V>.Entry<K,V> should be parameterized\n----------\n4. WARNING in X.java (at line 7)\n\tMap.Entry me= (Map.Entry)o; \n\t               ^^^^^^^^^\nMap.Entry is a raw type. References to generic type Map<K,V>.Entry<K,V> should be parameterized\n----------\n5. WARNING in X.java (at line 8)\n\tme.setValue(\"ok\");\n\t^^^^^^^^^^^^^^^^^\nType safety: The method setValue(Object) belongs to the raw type Map.Entry. References to generic type Map<K,V>.Entry<K,V> should be parameterized\n----------\n6. WARNING in X.java (at line 10)\n\t((Vector)o).add(\"ok\");\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type Vector. References to generic type Vector<E> should be parameterized\n----------\n7. WARNING in X.java (at line 10)\n\t((Vector)o).add(\"ok\");\n\t  ^^^^^^\nVector is a raw type. References to generic type Vector<E> should be parameterized\n----------\n8. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0706() {
        String outputExpectedBelow17 = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 9)\n\tclass BB extends AA<CC> { <U> BB test() {return null;} }\n\t                                 ^^^^^^\nName clash: The method test() of type BB has the same erasure as test() of type AA<T> but does not override it\n----------\n" : "----------\n1. ERROR in X.java (at line 9)\n\tclass BB extends AA<CC> { <U> BB test() {return null;} }\n\t                                 ^^^^^^\nName clash: The method test() of type BB has the same erasure as test() of type AA<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tBB bb = new BB();\n\t\tbb.<Object>test();\n\t\t((AA<CC>) bb).test();\n\t}\n}\nclass AA<T> { AA<Object> test() {return null;} }\nclass BB extends AA<CC> { <U> BB test() {return null;} }\nclass CC {}\n"}, this.complianceLevel < 0x330000L ? outputExpectedBelow17 : "----------\n1. ERROR in X.java (at line 4)\n\tbb.<Object>test();\n\t           ^^^^\nThe method test() is ambiguous for the type BB\n----------\n2. ERROR in X.java (at line 9)\n\tclass BB extends AA<CC> { <U> BB test() {return null;} }\n\t                                 ^^^^^^\nName clash: The method test() of type BB has the same erasure as test() of type AA<T> but does not override it\n----------\n");
    }

    public void test0706a() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. ERROR in X.java (at line 4)\n\tAA<Object> res1 = bb.test();\n\t                     ^^^^\nThe method test() is ambiguous for the type BB\n----------\n2. WARNING in X.java (at line 5)\n\tAA res3 = bb.test();\n\t^^\nAA is a raw type. References to generic type AA<T> should be parameterized\n----------\n3. ERROR in X.java (at line 5)\n\tAA res3 = bb.test();\n\t             ^^^^\nThe method test() is ambiguous for the type BB\n----------\n4. WARNING in X.java (at line 9)\n\tclass BB extends AA<CC> { <U> BB test() {return null;} }\n\t                                 ^^^^^^\nName clash: The method test() of type BB has the same erasure as test() of type AA<T> but does not override it\n----------\n" : "----------\n1. ERROR in X.java (at line 4)\n\tAA<Object> res1 = bb.test();\n\t                     ^^^^\nThe method test() is ambiguous for the type BB\n----------\n2. WARNING in X.java (at line 5)\n\tAA res3 = bb.test();\n\t^^\nAA is a raw type. References to generic type AA<T> should be parameterized\n----------\n3. ERROR in X.java (at line 5)\n\tAA res3 = bb.test();\n\t             ^^^^\nThe method test() is ambiguous for the type BB\n----------\n4. ERROR in X.java (at line 9)\n\tclass BB extends AA<CC> { <U> BB test() {return null;} }\n\t                                 ^^^^^^\nName clash: The method test() of type BB has the same erasure as test() of type AA<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tBB bb = new BB();\n\t\tAA<Object> res1 = bb.test();\n\t\tAA res3 = bb.test();\n\t}\n}\nclass AA<T> { AA<Object> test() {return null;} }\nclass BB extends AA<CC> { <U> BB test() {return null;} }\nclass CC {}\n"}, expectedCompilerLog);
    }

    public void test0706b() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. ERROR in X.java (at line 4)\n\tAA<CC> res = bb.test();\n\t                ^^^^\nThe method test() is ambiguous for the type BB\n----------\n2. ERROR in X.java (at line 5)\n\tBB res2 = bb.test();\n\t             ^^^^\nThe method test() is ambiguous for the type BB\n----------\n3. WARNING in X.java (at line 9)\n\tclass BB extends AA<CC> { <U> BB test() {return null;} }\n\t                                 ^^^^^^\nName clash: The method test() of type BB has the same erasure as test() of type AA<T> but does not override it\n----------\n" : "----------\n1. ERROR in X.java (at line 4)\n\tAA<CC> res = bb.test();\n\t                ^^^^\nThe method test() is ambiguous for the type BB\n----------\n2. ERROR in X.java (at line 5)\n\tBB res2 = bb.test();\n\t             ^^^^\nThe method test() is ambiguous for the type BB\n----------\n3. ERROR in X.java (at line 9)\n\tclass BB extends AA<CC> { <U> BB test() {return null;} }\n\t                                 ^^^^^^\nName clash: The method test() of type BB has the same erasure as test() of type AA<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tBB bb = new BB();\n\t\tAA<CC> res = bb.test();\n\t\tBB res2 = bb.test();\n\t}\n}\nclass AA<T> { AA<Object> test() {return null;} }\nclass BB extends AA<CC> { <U> BB test() {return null;} }\nclass CC {}\n"}, expectedCompilerLog);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tBB bb = new BB();\n\t\tAA<CC> res = bb.test();\n\t\tBB res2 = bb.test();\n\t}\n}\nclass AA<T> { AA<Object> test() {return null;} }\nclass BB extends AA<CC> { }\nclass CC {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tAA<CC> res = bb.test();\n\t             ^^^^^^^^^\nType mismatch: cannot convert from AA<Object> to AA<CC>\n----------\n2. ERROR in X.java (at line 5)\n\tBB res2 = bb.test();\n\t          ^^^^^^^^^\nType mismatch: cannot convert from AA<Object> to BB\n----------\n");
    }

    public void test0707() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\n    B<? extends T> b() {\n        return a();\n    }\n    \n    <U extends T> B<U> a() {\n        return null;\n    }\n    \n    static class B<V> { }\n}\n"}, "");
    }

    public void test0708() {
        this.runConformTest(new String[]{"UserClass.java", "public class UserClass<K> {\n    protected class DataHolder {}\n    protected void loadHook(DataHolder data) {}\n}\n"}, "");
        this.runConformTest(new String[]{"ChildClass.java", "public class ChildClass extends UserClass<Object> {\n    @Override protected void loadHook(DataHolder data) {}\n}\n"}, "", null, false, null);
    }

    public void test0709() {
        this.runConformTest(new String[]{"UserClass.java", "public class UserClass<K> {\n    protected class DataHolder {}\n    protected void loadHook(DataHolder[] data) {}\n}\n"}, "");
        this.runConformTest(new String[]{"ChildClass.java", "public class ChildClass extends UserClass<Object> {\n    @Override protected void loadHook(DataHolder[] data) {}\n}\n"}, "", null, false, null);
    }

    public void test0710() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static <V, P extends Persistent<V>> P createDataObject(V value) {\n\t\treturn null;\n\t}\n\tpublic static void testCreateDataObject(Object v) {\n\t\tPersistent d = createDataObject(v);\n\t}\n\n\tprivate interface Persistent<V> {\n\t\tpublic V getValueObject();\n\t}\n}\n"}, "");
    }

    public void test0711() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\n\npublic class X<T> {\n\tstatic private Map<String, XX> m1 = new HashMap<String, XX>();\n\tprivate List<XX> m2 = new ArrayList<XX>();\n\tstatic protected XX foo()\n\t{\n\t\treturn null;\n\t}\n\tstatic public abstract class XX<TT>\n\t{\n\t}\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "public class Y extends X<Object>  \n{        \n}\n"}, "", null, false, null);
    }

    public void test0712() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\n\npublic class X<T> {\n\tstatic private Map<String, XX> m1 = new HashMap<String, XX>();\n\tprivate List<XX<T>> m2 = new ArrayList<XX<T>>();\n\tstatic protected XX foo()\n\t{\n\t\treturn null;\n\t}\n\tstatic public abstract class XX<TT>\n\t{\n\t}\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "public class Y extends X<Object>  \n{        \n}\n"}, "", null, false, null);
    }

    public void test0713() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tint i = 0;\n\tinterface Y {\n\t\tjava.util.List<T> lt = null;\n\t\tint j = i;\n\t\tvoid m1(T t);\t\t\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tjava.util.List<T> lt = null;\n\t               ^\nCannot make a static reference to the non-static type T\n----------\n2. ERROR in X.java (at line 5)\n\tint j = i;\n\t        ^\nCannot make a static reference to the non-static field i\n----------\n3. ERROR in X.java (at line 6)\n\tvoid m1(T t);\t\t\n\t        ^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void test0714() {
        this.runConformTest(new String[]{"B.java", "import java.util.Map;\nimport java.util.Set;\nimport java.util.SortedSet;\n\npublic class B  {\n\tstatic Set<Map.Entry> foo(SortedSet<Map.Entry> set) {\n\t\treturn null;\n\t}\n}\n\n"}, "");
        this.runConformTest(new String[]{"A.java", "public class A {\n\tA() {\n\t\tB.foo(null);\n\t}\n}\n"}, "", null, false, null);
    }

    public void test0715() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void foo() {\n    \tComparable<String> c = (java.util.List)bar(5, 5.0);\n    }\n    \n    <T> T bar(T t1, T t2) { return t1; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tComparable<String> c = (java.util.List)bar(5, 5.0);\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List to Comparable<String>\n----------\n2. WARNING in X.java (at line 3)\n\tComparable<String> c = (java.util.List)bar(5, 5.0);\n\t                        ^^^^^^^^^^^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test0716() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Number & Comparable<String>> {\n    void foo(T t) {\n    \t\t Comparable<Integer> ci = (Comparable<Integer>) t;  \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tComparable<Integer> ci = (Comparable<Integer>) t;  \n\t                         ^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from T to Comparable<Integer>\n----------\n");
    }

    public void test0717() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X<T extends Comparable<String> & List<Integer>> {\n    void foo(T t) {\n    \t\t Comparable<Integer> ci = (Comparable<Integer>) t;  \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tComparable<Integer> ci = (Comparable<Integer>) t;  \n\t                         ^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from T to Comparable<Integer>\n----------\n");
    }

    public void test0718() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collections;\nimport java.util.Set;\nimport java.util.TreeSet;\n\npublic class X {\n    \n    public interface Base {\n    }\n    \n    abstract class Action<T extends Base> {\n    }\n\n    public class ActionImpl<T extends Base> extends Action<T> implements Comparable<ActionImpl> {\n        public int compareTo(ActionImpl o) {\n            return 0;\n        }\n    }\n\n    public void test() {\n        Set<ActionImpl> set = new TreeSet<ActionImpl>();\n        Collections.max(set);\n    }\n   Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 13)\n\tpublic class ActionImpl<T extends Base> extends Action<T> implements Comparable<ActionImpl> {\n\t                                                                                ^^^^^^^^^^\nX.ActionImpl is a raw type. References to generic type X.ActionImpl<T> should be parameterized\n----------\n2. WARNING in X.java (at line 14)\n\tpublic int compareTo(ActionImpl o) {\n\t                     ^^^^^^^^^^\nX.ActionImpl is a raw type. References to generic type X.ActionImpl<T> should be parameterized\n----------\n3. WARNING in X.java (at line 20)\n\tSet<ActionImpl> set = new TreeSet<ActionImpl>();\n\t    ^^^^^^^^^^\nX.ActionImpl is a raw type. References to generic type X.ActionImpl<T> should be parameterized\n----------\n4. WARNING in X.java (at line 20)\n\tSet<ActionImpl> set = new TreeSet<ActionImpl>();\n\t                                  ^^^^^^^^^^\nX.ActionImpl is a raw type. References to generic type X.ActionImpl<T> should be parameterized\n----------\n5. WARNING in X.java (at line 21)\n\tCollections.max(set);\n\t^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation max(Set<X.ActionImpl>) of the generic method max(Collection<? extends T>) of type Collections\n----------\n6. ERROR in X.java (at line 23)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0719() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Iterator;\nimport java.util.ListIterator;\n\ninterface IntegerIterator extends Iterator {}\ninterface IntegerListIterator extends ListIterator<Integer>, IntegerIterator {}\n\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tinterface IntegerIterator extends Iterator {}\n\t                                  ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tinterface IntegerListIterator extends ListIterator<Integer>, IntegerIterator {}\n\t          ^^^^^^^^^^^^^^^^^^^\nThe interface Iterator cannot be implemented more than once with different arguments: Iterator and Iterator<Integer>\n----------\n");
    }

    public void test0720() {
        this.runNegativeTest(new String[]{"X.java", "interface Foo<T> {}\ninterface Bar extends Foo<Integer> {}\ninterface Baz extends Bar, Foo {}\n\nclass XSuper implements Foo {}\nclass XSub extends XSuper implements Foo<Integer> {}\n\npublic class X implements Bar, Foo {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tinterface Baz extends Bar, Foo {}\n\t          ^^^\nThe interface Foo cannot be implemented more than once with different arguments: Foo and Foo<Integer>\n----------\n2. WARNING in X.java (at line 3)\n\tinterface Baz extends Bar, Foo {}\n\t                           ^^^\nFoo is a raw type. References to generic type Foo<T> should be parameterized\n----------\n3. WARNING in X.java (at line 5)\n\tclass XSuper implements Foo {}\n\t                        ^^^\nFoo is a raw type. References to generic type Foo<T> should be parameterized\n----------\n4. ERROR in X.java (at line 6)\n\tclass XSub extends XSuper implements Foo<Integer> {}\n\t      ^^^^\nThe interface Foo cannot be implemented more than once with different arguments: Foo and Foo<Integer>\n----------\n5. ERROR in X.java (at line 8)\n\tpublic class X implements Bar, Foo {}\n\t             ^\nThe interface Foo cannot be implemented more than once with different arguments: Foo and Foo<Integer>\n----------\n6. WARNING in X.java (at line 8)\n\tpublic class X implements Bar, Foo {}\n\t                               ^^^\nFoo is a raw type. References to generic type Foo<T> should be parameterized\n----------\n");
    }

    public void test0721() {
        this.runConformTest(new String[]{"Foo.java", "public class Foo<T>\n{\n\tprotected abstract class InnerFoo\n\t{\n\t\tprotected abstract void doSomething();\n\t}\n\t\n\tprotected void run( InnerFoo innerFoo )\n\t{\n\t\tinnerFoo.doSomething();\n\t}\n}"}, "");
        this.runConformTest(new String[]{"Bar.java", "public class Bar extends Foo<Integer>\n{\n\tpublic void go()\n\t{\n\t\tInnerFoo inner = new InnerFoo()\n\t\t{\n\t\t\tprotected void doSomething()\n\t\t\t{\n\t\t\t\tSystem.out.println( \"hello\" );\n\t\t\t}\n\t\t};\n\t\trun( inner );\n\t}\n}"}, "", null, false, null);
    }

    public void test0722() {
        this.runNegativeTest(new String[]{"X.java", "interface I1<T1> {\n}\n\ninterface I2<T2> extends I1<T2> {\n}\n\npublic class X<U1> implements I1<U1>, I2<U1> {\n}\n"}, "");
    }

    public void test0723() {
        this.runConformTest(new String[]{"X.java", "interface IA<E> {}\ninterface IB<E> extends IA<E> {}\nclass A<E> implements IA<E> {}\nclass B<E> implements IB<E> {}\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tA<Integer> x = new A<Integer>();\n\t\tB<Integer> y = new B<Integer>();\n\t\tprint(x);\n\t\tprint(y);\n\t}\n\tpublic static <T extends IA<?>> void print(T a) {\n\t\tSystem.out.print(\"A\");\n\t}\n\tpublic static <T extends IB<?>> void print(T a) {\n\t\tSystem.out.println(\"B\");\n\t}\n}\n"}, "AB");
    }

    public void test0724() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tHashMap<Byte, Byte> subst = new HashMap<Byte, Byte>();\n\t\tsubst.put((byte)1, (byte)1);\n\t\tif (1 + subst.get((byte)1) > 0.f) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\t\t\n\t}\n}\n"}, "SUCCESS");
    }

    public void test0725() {
        this.runNegativeTest(new String[]{"X.java", "class AbsC {\n\tpublic <T> T[] resize(T[] src, T[] dest) {\n\t\treturn dest;\n\t}\n}\n\nclass ConrC<T> extends AbsC {\n\tT[][] data;\n\tprotected void allocateChunkSlots(int maxChunkNo) {\n\t\tdata = resize(data, new Object[maxChunkNo][]);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tdata = resize(data, new Object[maxChunkNo][]);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object[][] to T[][]\n----------\n");
    }

    public void test0726() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tvoid foo() {\n\t\t\n\t\tController<?> ctrl = null;\n\t\tfoobar(ctrl.getView().getContent()); \n\t} \n\t\n\tstatic void foobar(X x) {\n\t}\n}\ninterface Controller<T extends View<?>> {\n    public T getView() ;\n}\ninterface View<U extends X> {\n\tpublic U getContent();\n}\n"}, "");
    }

    public void test0727() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\t\n\tvoid foo() {\n\t\t\n\t\tController<?> ctrl = null;\n\t\tfoobar(ctrl.getView().getContent()); \n\t} \n\t\n\tstatic void foobar(X<String> x) {\n\t}\n}\ninterface Controller<T extends View<?>> {\n    public T getView() ;\n}\ninterface View<U extends X<String>> {\n\tpublic U getContent();\n}\n"}, "");
    }

    public void test0728() {
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n\t\n\tpublic static void main(String[] args) {\n\t\t\n\t\tController<?> ctrl = null;\n\t\tfoobar(ctrl.getView().getContent()); \n\t} \n\t\n\tstatic void foobar(X<String> x) {\n\t}\n}\ninterface Controller<T extends View<?>> {\n    public T getView() ;\n}\ninterface View<U extends X<U>> {\n\tpublic U getContent();\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tfoobar(ctrl.getView().getContent()); \n\t^^^^^^\nThe method foobar(X<String>) in the type X<E> is not applicable for the arguments (capture#2-of ?)\n----------\n");
    }

    public void test0729() {
        this.runConformTest(new String[]{"X.java", "public class X implements I<Y> {}\ninterface I<T> {}\nclass Y extends X implements I<Y> {}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "public class X implements I<Y> {}\ninterface I<T extends I<? super T>> {}\nclass Y extends X implements I<X> {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass Y extends X implements I<X> {}\n\t      ^\nThe interface I cannot be implemented more than once with different arguments: I<Y> and I<X>\n----------\n2. ERROR in X.java (at line 3)\n\tclass Y extends X implements I<X> {}\n\t                               ^\nBound mismatch: The type X is not a valid substitute for the bounded parameter <T extends I<? super T>> of the type I<T>\n----------\n");
    }

    public void test0730() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n    Zork z;\n    public interface SuperInterface<A> {\n    }\n\n    public interface SubInterface extends SuperInterface<String> {\n        public String getString();\n    }\n\n    private SuperInterface< ? extends SuperInterface> x = null;\n\n    public void f() {\n        ((SubInterface) this.x).getString();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 11)\n\tprivate SuperInterface< ? extends SuperInterface> x = null;\n\t                                  ^^^^^^^^^^^^^^\nX.SuperInterface is a raw type. References to generic type X.SuperInterface<A> should be parameterized\n----------\n3. ERROR in X.java (at line 14)\n\t((SubInterface) this.x).getString();\n\t^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from X.SuperInterface<capture#1-of ? extends X.SuperInterface> to X.SubInterface\n----------\n");
    }

    public void test0731() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\tX<? super E> parent;\n\tX<? super E> current;\n\n\tX<? extends E> parent2;\n\tX<? extends E> current2;\n\n\tvoid foo() {\n\t\tcurrent = current.parent;\n\t}\n\n\tvoid bar() {\n\t\tcurrent2 = current2.parent2;\n\t}\n}\n"}, "");
    }

    public void test0732() {
        this.runNegativeTest(new String[]{"X.java", "interface B<T> {}\ninterface C extends B<String>{}\ninterface D extends B<Integer>{}\n\npublic class X {\n             public static void main(String[] args) {\n                         D d = null;\n                         C c = (C)d; // illegal\n             }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tC c = (C)d; // illegal\n\t      ^^^^\nCannot cast from D to C\n----------\n");
    }

    public void test0733() {
        this.runConformTest(new String[]{"X.java", "interface B<T> {}\ninterface C extends B<String>{}\ninterface D<E> extends B<E>{}\n\n\npublic class X {\n\t\t\tObject foo(C c) {\n\t\t\t\t\treturn (D<? extends String>) c;\n             }\n}\n"}, "");
    }

    public void test0734() {
        this.runConformTest(new String[]{"X.java", "interface B<T> {}\ninterface C extends B<String>{}\ninterface D<E> extends B<E>{}\n\n\npublic class X {\n\t\t\tObject foo(C c, D<? extends String> d) {\n\t\t\t\t\treturn c != null ? c : d; \n             }\n}\n"}, "");
    }

    public void test0735() {
        this.runConformTest(new String[]{"X.java", "interface B<T> {}\ninterface C extends B<String>{}\ninterface D<E> extends B<E>{}\n\n\npublic class X {\n\t\t\tObject foo(C c, D<? extends Exception> d) {\n\t\t\t\t\treturn c != null ? c : d; \n             }\n}\n"}, "");
    }

    public void test0736() {
        this.runNegativeTest(new String[]{"X.java", "interface B<T> {}\ninterface C extends B<String>{}\ninterface D<E> extends B<E>{}\n\n\npublic class X {\n\t\t\tvoid bar(C c) {\n\t\t\t\t\tD<? extends Exception> d = (D<? extends Exception>) c;\n\t\t\t\t\tfoo(d, c);\n             }\n\t\t\t<U> void foo(U u1, U u2) {\n\t\t\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tD<? extends Exception> d = (D<? extends Exception>) c;\n\t                           ^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from C to D<? extends Exception>\n----------\n");
    }

    public void test0737() {
        this.runConformTest(new String[]{"X.java", "class Sup {\n}\n\nclass Sub1 extends Sup {\n}\n\nclass Sub2 extends Sup {\n\n}\nabstract class X {\n\tabstract <S, A extends S, B extends S> S method(A la, B lb);\n\n\tvoid m2() {\n\t\tSup Sup = method(new Sub1(), new Sub2());// <-- compiles?? ( A=Sub1, B=Sub2, S=Sup)\n\t\tObject obj = method(1, \"32\");// <--doesn't compile?? ( A=Integer, B=String, S=Object)\n\t}\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test0738() {
        this.runNegativeTest(new String[]{"X.java", "interface B<T> {}\nclass C implements B<String>{}\ninterface D extends B<Integer>{}\n\npublic class X {\n             public static void main(String[] args) {\n                         D d = null;\n                         C c = (C)d; // illegal\n             }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tC c = (C)d; // illegal\n\t      ^^^^\nCannot cast from D to C\n----------\n");
    }

    public void test0739() {
        this.runNegativeTest(new String[]{"X.java", "interface B<T> {}\ninterface C extends B<String>{}\nclass D implements B<Integer>{}\n\npublic class X {\n             public static void main(String[] args) {\n                         D d = null;\n                         C c = (C)d; // illegal\n             }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tC c = (C)d; // illegal\n\t      ^^^^\nCannot cast from D to C\n----------\n");
    }

    public void test0740() {
        this.runNegativeTest(new String[]{"X.java", "interface B<T> {}\nfinal class C implements B<String>{}\n\npublic class X {\n             public static void main(String[] args) {\n                         B<Integer> d = null;\n                         C c = (C)d; // illegal\n             }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tC c = (C)d; // illegal\n\t      ^^^^\nCannot cast from B<Integer> to C\n----------\n");
    }

    public void test0741() {
        this.runNegativeTest(new String[]{"X.java", "interface B<T> {}\nfinal class D implements B<Integer>{}\n\npublic class X {\n             public static void main(String[] args) {\n                         D d = null;\n                         B<String> c = (B<String>)d; // illegal\n             }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tB<String> c = (B<String>)d; // illegal\n\t              ^^^^^^^^^^^^\nCannot cast from D to B<String>\n----------\n");
    }

    public void test0742() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\n public class X {\n \n\tstatic abstract class SelfType<T extends SelfType<T>>{\n\t}\n \n\tstatic class SuperType extends SelfType<SuperType>{\n\t}\n \n\tstatic class SubType extends SuperType{}\n \n\tstatic <T extends SelfType<T>> List<T> makeSingletonList(T t){\n\t\treturn Collections.singletonList(t);\n\t}\n \n\tstatic <T extends SelfType<T>,S extends T> List<T> makeSingletonList2(S s){\n\t\treturn Collections.singletonList((T)s); // #0\n\t}\n \n\tpublic static void main(String[] args){\n\t\tmakeSingletonList(new SuperType()); // #1 - OK\n\t\tList<SuperType> lsup = makeSingletonList(new SuperType()); // #2 - OK\n\t\tList<SubType> lsub = makeSingletonList(new SubType()); // #3 - ERROR\n\t\tmakeSingletonList(new SubType()); // #4 - ERROR\n \t\tmakeSingletonList2(new SubType()); // #5 - ERROR\n\t\tlsup = makeSingletonList2(new SubType()); // #6 - OK\n\t\tlsub = makeSingletonList2(new SubType()); // #7 - ERROR\n\t\tmakeSingletonList2(new SuperType()); // #8 - OK\n\t\tlsup = makeSingletonList2(new SuperType()); // #9 - OK\n\t}\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 24)\n\tList<SubType> lsub = makeSingletonList(new SubType()); // #3 - ERROR\n\t                     ^^^^^^^^^^^^^^^^^\nBound mismatch: The generic method makeSingletonList(T) of type X is not applicable for the arguments (X.SubType). The inferred type X.SubType is not a valid substitute for the bounded parameter <T extends X.SelfType<T>>\n----------\n2. ERROR in X.java (at line 25)\n\tmakeSingletonList(new SubType()); // #4 - ERROR\n\t^^^^^^^^^^^^^^^^^\nBound mismatch: The generic method makeSingletonList(T) of type X is not applicable for the arguments (X.SubType). The inferred type X.SubType is not a valid substitute for the bounded parameter <T extends X.SelfType<T>>\n----------\n3. ERROR in X.java (at line 26)\n\tmakeSingletonList2(new SubType()); // #5 - ERROR\n\t^^^^^^^^^^^^^^^^^^\nBound mismatch: The generic method makeSingletonList2(S) of type X is not applicable for the arguments (X.SubType). The inferred type X.SubType is not a valid substitute for the bounded parameter <T extends X.SelfType<T>>\n----------\n4. ERROR in X.java (at line 28)\n\tlsub = makeSingletonList2(new SubType()); // #7 - ERROR\n\t       ^^^^^^^^^^^^^^^^^^\nBound mismatch: The generic method makeSingletonList2(S) of type X is not applicable for the arguments (X.SubType). The inferred type X.SubType is not a valid substitute for the bounded parameter <T extends X.SelfType<T>>\n----------\n" : "----------\n1. ERROR in X.java (at line 24)\n\tList<SubType> lsub = makeSingletonList(new SubType()); // #3 - ERROR\n\t                     ^^^^^^^^^^^^^^^^^\nBound mismatch: The generic method makeSingletonList(T) of type X is not applicable for the arguments (X.SubType). The inferred type X.SubType is not a valid substitute for the bounded parameter <T extends X.SelfType<T>>\n----------\n2. ERROR in X.java (at line 28)\n\tlsub = makeSingletonList2(new SubType()); // #7 - ERROR\n\t       ^^^^^^^^^^^^^^^^^^\nBound mismatch: The generic method makeSingletonList2(S) of type X is not applicable for the arguments (X.SubType). The inferred type X.SubType is not a valid substitute for the bounded parameter <T extends X.SelfType<T>>\n----------\n");
    }

    public void test0743() {
        this.runNegativeTest(new String[]{"X.java", "interface TestGeneric2<A> {\n\tNested<A> getNested2(); // super\n\n\tclass Nested<B> implements TestGeneric2<B> {\n\t\tpublic Nested<B> getNested2() { // sub\n\t\t\treturn this;//2\n\t\t}\n\t}\n}\n \nclass TestGeneric3<A> {\n\tNested<A> getNested3() { return null; } // super\n\n\tclass Nested<B> extends TestGeneric3<B> {\n\t\t@Override public Nested<B> getNested3() { // sub\n\t\t\treturn this;//3\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\treturn this;//3\n\t       ^^^^\nType mismatch: cannot convert from TestGeneric3<A>.Nested<B> to TestGeneric3<B>.Nested<B>\n----------\n");
    }

    public void test0744() {
        this.runNegativeTest(new String[]{"java/util/X.java", "package java.util;\n\nimport java.io.*;\n\nclass Super<U, V> {\n\tstatic class Entry<U,V> {\n\t\tEntry(int i, U u, V v, Entry<U,V> entry) {}\n\t\tvoid recordAccess(Super<U,V> s) {\n\t\t}\n\t}\n}\npublic abstract class X<K1, V1> extends Super<K1, V1> {\n\n\tEntry<K1, V1> h;\n\n\tprivate static class Entry<K2, V2> extends Super.Entry<K2, V2> {\n\n\t\tEntry() {\n\t\t\tsuper(0, null, null, null);\n\t\t}\n\n\t\tvoid ab(Entry<K2, V2> e) {\n\t\t}\n\n\t\t@Override void recordAccess(Super<K2, V2> m) {\n\t\t\tX<K2, V2> x = (X<K2, V2>) m;\n\t\t\tab(x.h);\n\t\t}\n\t}\n  Zork z;\n}\n"}, "----------\n1. ERROR in java\\util\\X.java (at line 30)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0745() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid test() {\n\t\tjava.util.Arrays.asList(3, 3.1);\n\t}\n}\n"}, "");
    }

    public void test0746() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test() {\n\t\tString s = java.util.Arrays.asList(3, 3.1);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tString s = java.util.Arrays.asList(3, 3.1);\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Number&Comparable<?>> to String\n----------\n", null, true, options);
    }

    public void test0747() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  interface I {}\n  class Y<U extends T & I> {\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass Y<U extends T & I> {\n\t                      ^\nCannot specify any additional bound X.I when first bound is a type parameter\n----------\n");
    }

    public void test0748() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 5)\n\tpublic byte[] create(Class<byte[]> cl) { return null; }\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method create(Class<byte[]>) of type X has the same erasure as create(Class<U>) of type Factory<T> but does not override it\n----------\n" : "----------\n1. ERROR in X.java (at line 5)\n\tpublic byte[] create(Class<byte[]> cl) { return null; }\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method create(Class<byte[]>) of type X has the same erasure as create(Class<U>) of type Factory<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "interface Factory<T> {\n\t<U extends T> U create(Class<U> cl);\n}\nabstract class X implements Factory<byte[]> {\n\tpublic byte[] create(Class<byte[]> cl) { return null; }\n}\n"}, expectedCompilerLog);
    }

    public void test0749() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X<T extends X<?>> {\n\tT get() { return null; }\n\tvoid foo(X x) {\n\t\tString s = x.get();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid foo(X x) {\n\t         ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. ERROR in X.java (at line 6)\n\tString s = x.get();\n\t           ^^^^^^^\nType mismatch: cannot convert from X to String\n----------\n");
    }

    public void test0750() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X<T extends List<String>> {\n\tT get() { return null; }\n\tvoid foo(X x) {\n\t\tList<Object> l = x.get();\n\t}\n  Zork z ;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid foo(X x) {\n\t         ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tList<Object> l = x.get();\n\t                 ^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n3. ERROR in X.java (at line 8)\n\tZork z ;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0751() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends X<T>> {\n\t\n\tvoid foo(X<? extends T> x) {\n\t\tX<T> x2 = x;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX<T> x2 = x;\n\t          ^\nType mismatch: cannot convert from X<capture#1-of ? extends T> to X<T>\n----------\n");
    }

    public void test0752() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\n\npublic class X<E extends Serializable> {\n\tX<? extends I<E>> parent;\n\tX<? extends I<E>> current;\n\tvoid foo() {\n\t\tcurrent = current.parent;\n\t}\n}\n\ninterface I<T> {\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tcurrent = current.parent;\n\t          ^^^^^^^^^^^^^^\nType mismatch: cannot convert from X<capture#3-of ? extends I<capture#2-of ? extends I<E>>> to X<? extends I<E>>\n----------\n");
    }

    public void test0753() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\n\npublic class X<E extends Serializable> {\n\tX<? super I<E>> parent;\n\tX<? super I<E>> current;\n\tvoid foo() {\n\t\tcurrent = current.parent;\n\t}\n}\n\ninterface I<T> {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX<? super I<E>> parent;\n\t  ^^^^^^^^^\nBound mismatch: The type ? super I<E> is not a valid substitute for the bounded parameter <E extends Serializable> of the type X<E>\n----------\n2. ERROR in X.java (at line 5)\n\tX<? super I<E>> current;\n\t  ^^^^^^^^^\nBound mismatch: The type ? super I<E> is not a valid substitute for the bounded parameter <E extends Serializable> of the type X<E>\n----------\n3. ERROR in X.java (at line 7)\n\tcurrent = current.parent;\n\t          ^^^^^^^^^^^^^^\nType mismatch: cannot convert from X<capture#3-of ? super I<capture#2-of ? super I<E>>> to X<? super I<E>>\n----------\n");
    }

    public void test0754() {
        this.runNegativeTest(new String[]{"X.java", "class bugSuper<T extends Object> {\n\tpublic T getData(){\n\t\treturn null;\n\t}\n}\n\nclass bugElement {\n}\n\nclass bugClass<T extends bugElement> extends bugSuper<T>{\n}\n\npublic class X{\n\tpublic void method(bugClass bc){\n\t\tbugElement be = bc.getData();   //<< here\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 14)\n\tpublic void method(bugClass bc){\n\t                   ^^^^^^^^\nbugClass is a raw type. References to generic type bugClass<T> should be parameterized\n----------\n2. ERROR in X.java (at line 15)\n\tbugElement be = bc.getData();   //<< here\n\t                ^^^^^^^^^^^^\nType mismatch: cannot convert from Object to bugElement\n----------\n");
    }

    public void test0755() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  public static class B {}\n  public static void main (String... args) {\n    X<?>.B[] b = new X<?>.B[1];\n  }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tX<?>.B[] b = new X<?>.B[1];\n\t^^^^^^\nThe member type X<?>.B cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type X<?>\n----------\n2. ERROR in X.java (at line 4)\n\tX<?>.B[] b = new X<?>.B[1];\n\t                 ^^^^^^\nThe member type X<?>.B cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type X<?>\n----------\n");
    }

    public void test0756() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n  public class B {}\n  public static void main (String... args) {\n    X<?>.B[] b = new X<?>.B[1];\n  }\n}"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test0757() {
        this.runNegativeTest(new String[]{"X.java", "public class X<K, V> {\n\tstatic class EntryMap<K, V> {\n\t\tclass Entry {\n\t\t}\n\t}\n\n\tEntryMap.Entry internalGet(Object key) {\n\t\treturn null;\n\t}\n\t\n\tvoid foo(Object key) {\n\t\tEntryMap<K,V>.Entry entry = internalGet(key);\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tEntryMap.Entry internalGet(Object key) {\n\t^^^^^^^^^^^^^^\nX.EntryMap.Entry is a raw type. References to generic type X<K,V>.EntryMap<K,V>.Entry should be parameterized\n----------\n2. WARNING in X.java (at line 12)\n\tEntryMap<K,V>.Entry entry = internalGet(key);\n\t                            ^^^^^^^^^^^^^^^^\nType safety: The expression of type X.EntryMap.Entry needs unchecked conversion to conform to X.EntryMap<K,V>.Entry\n----------\n3. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0758() {
        this.runNegativeTest(new String[]{"X.java", "public class X<K, V> {\n\tstatic class EntryMap<K, V> {\n\t\tclass Entry {\n\t\t}\n\t}\n\n\tEntryMap.Entry internalGet(Object key) {\n\t\treturn null;\n\t}\n\t\n\tvoid foo(Object key) {\n\t\tEntryMap<K,V>.Entry entry = (EntryMap.Entry) internalGet(key);\n\t}\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tEntryMap.Entry internalGet(Object key) {\n\t^^^^^^^^^^^^^^\nX.EntryMap.Entry is a raw type. References to generic type X<K,V>.EntryMap<K,V>.Entry should be parameterized\n----------\n2. WARNING in X.java (at line 12)\n\tEntryMap<K,V>.Entry entry = (EntryMap.Entry) internalGet(key);\n\t                            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from X.EntryMap.Entry to X.EntryMap.Entry\n----------\n3. WARNING in X.java (at line 12)\n\tEntryMap<K,V>.Entry entry = (EntryMap.Entry) internalGet(key);\n\t                            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type X.EntryMap.Entry needs unchecked conversion to conform to X.EntryMap<K,V>.Entry\n----------\n4. WARNING in X.java (at line 12)\n\tEntryMap<K,V>.Entry entry = (EntryMap.Entry) internalGet(key);\n\t                             ^^^^^^^^^^^^^^\nX.EntryMap.Entry is a raw type. References to generic type X<K,V>.EntryMap<K,V>.Entry should be parameterized\n----------\n5. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0759() {
        this.runConformTest(new String[]{"X.java", "public class X<E>\n{\n  E[] m;\n  public X()\n  {\n\tX<? extends E> x = null;\n\tSystem.out.println(x.m.length);\n  }\n}\n"}, "");
    }

    public void test0760() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X<U> {\n\tpublic static <T> X<T> make() {\n\t\treturn null;\n\t}\n\tpublic static <T> T itself(T t) {\n\t\treturn t;\n\t}\n\n\tvoid foo() {\n\t\tX<Integer> x1 = make();\n\t\tX<Integer> x2 = itself(x1);\n\t}\n\tvoid bar() {\n\t\tX<Integer> x2 = itself(make());\n\t}\n\tvoid baz() {\n\t\tX<Integer> x2 = itself((X<Integer>)make());\n\t}\t\n} \n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 16)\n\tX<Integer> x2 = itself(make());\n\t                ^^^^^^^^^^^^^^\nType mismatch: cannot convert from X<Object> to X<Integer>\n----------\n2. ERROR in X.java (at line 19)\n\tX<Integer> x2 = itself((X<Integer>)make());\n\t                       ^^^^^^^^^^^^^^^^^^\nCannot cast from X<Object> to X<Integer>\n----------\n" : "----------\n1. ERROR in X.java (at line 19)\n\tX<Integer> x2 = itself((X<Integer>)make());\n\t                       ^^^^^^^^^^^^^^^^^^\nCannot cast from X<Object> to X<Integer>\n----------\n");
    }

    public void test0761() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n  public abstract class ClassA<A, B> {\n    public abstract B method(A param);\n  }\n\n  public class ClassB<C, D extends C> {\n    // the following field declaration causes an error\n    ClassA<? super C, ? extends D> classA;\n\n    public D method(D d) {\n      return classA.method(d);\n    }\n  }\n}\n"}, "");
    }

    public void test0762() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n  public abstract class ClassA<A, B extends Number> {\n    public abstract B method(A param);\n  }\n\n  public class ClassB<C extends Number, D extends C> {\n    // the following field declaration causes an error\n    ClassA<? super C, ? extends D> classA;\n\n    public D method(D d) {\n      return classA.method(d);\n    }\n  }\n}\n"}, "");
    }

    public void test0763() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\tpublic static class InnerClass {\n\t\tpublic InnerClass() {\n\t\t\tSystem.out.println(\"class : \" + InnerClass.this);\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test0764() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n \ninterface IIfClosure {}\n \npublic class X {\n    public X(String label, HashMap<String,Object> bindings) {\n        this(label, bindings, (List<IIfClosure>)Collections.emptyList());\n    }\n    \n    public X(String label, HashMap<String,Object> bindings, Collection<IIfClosure> coll) {\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tthis(label, bindings, (List<IIfClosure>)Collections.emptyList());\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object> to List<IIfClosure>\n----------\n");
    }

    public void test0765() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static <T extends X> T f1() throws Exception{\n    \treturn null;\n    }\n    static <U extends X> U f2() throws Exception {\n        return f1();\n    }\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6302954);
    }

    public void test0766() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\ninterface Cloneable<T extends Cloneable<T>> {\n\tpublic T clone();\n}\n\ninterface CloneableMap<K, V extends Cloneable<V>> extends Map<K, V>, Cloneable<CloneableMap<K, V>> {\n}\n\ninterface C<T extends C<T>> extends Cloneable<T> {\n}\npublic class X {\n\tvoid foo() {\n\t\tCloneableMap<String, C<?>> map = null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tCloneableMap<String, C<?>> map = null;\n\t                     ^\nBound mismatch: The type C<?> is not a valid substitute for the bounded parameter <V extends Cloneable<V>> of the type CloneableMap<K,V>\n----------\n");
    }

    public void test0767() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\ninterface Cloneable<T extends Cloneable<T>> {\n\tpublic T clone();\n}\n\ninterface CloneableMap<K, V extends Cloneable<V>> extends Map<K, V>, Cloneable<CloneableMap<K, V>> {\n}\n\ninterface C extends Cloneable<C> {\n}\npublic class X {\n\tvoid foo() {\n\t\tCloneableMap<String, C> map = null;\n\t}\n}\n"}, "");
    }

    public void test0768() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T extends Runnable, U extends Runnable & T>  T foo1() { return null; }\n\t<T extends Y<Object>, U extends Z & T>  T foo2() { return null; }\n\t<T extends Y<Object>, U extends T & Z>  T foo3() { return null; }\n\t<T extends Y<Object>, U extends W & Z>  T foo4() { return null; }\n}\n\ninterface Y<T> {\n}\n\ninterface Z extends Y<String> {}\ninterface W extends Y<Object> {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T extends Runnable, U extends Runnable & T>  T foo1() { return null; }\n\t                                          ^\nThe type T is not an interface; it cannot be specified as a bounded parameter\n----------\n2. ERROR in X.java (at line 3)\n\t<T extends Y<Object>, U extends Z & T>  T foo2() { return null; }\n\t                                    ^\nThe type T is not an interface; it cannot be specified as a bounded parameter\n----------\n3. ERROR in X.java (at line 4)\n\t<T extends Y<Object>, U extends T & Z>  T foo3() { return null; }\n\t                                    ^\nCannot specify any additional bound Z when first bound is a type parameter\n----------\n4. ERROR in X.java (at line 4)\n\t<T extends Y<Object>, U extends T & Z>  T foo3() { return null; }\n\t                                    ^\nThe interface Y cannot be implemented more than once with different arguments: Y<String> and Y<Object>\n----------\n5. ERROR in X.java (at line 5)\n\t<T extends Y<Object>, U extends W & Z>  T foo4() { return null; }\n\t                                    ^\nThe interface Y cannot be implemented more than once with different arguments: Y<String> and Y<Object>\n----------\n");
    }

    public void test0769() {
        this.runConformTest(new String[]{"X.java", "class XSuper<T> {\n\tT value;\n}\npublic class X extends XSuper<String>{\n\tpublic void a() {\n\t\tvalue += 1;\n\t\tvalue = value + 1;\n\t\tSystem.out.println(value);\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tX x = new X();\n\t\tx.value = \"[\";\n\t\tx.a();\n\t}\n}\n"}, "[11");
    }

    public void test0770() {
        this.runConformTest(new String[]{"X.java", "class XSuper<T> {\n\tT value;\n}\npublic class X extends XSuper<String>{\n\tpublic void a() {\n\t\tthis.value += 1;\n\t\tthis.value = this.value + 1;\n\t\tSystem.out.println(this.value);\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tX x = new X();\n\t\tx.value = \"[\";\n\t\tx.a();\n\t}\n}\n"}, "[11");
    }

    public void test0771() {
        this.runConformTest(new String[]{"X.java", "class XSuper<T> {\n\tT value;\n}\npublic class X extends XSuper<String>{\n\tpublic static void a(X x) {\n\t\tx.value += 1;\n\t\tx.value = x.value + 1;\n\t\tSystem.out.println(x.value);\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tX x = new X();\n\t\tx.value = \"[\";\n\t\ta(x);\n\t}\n}\n"}, "[11");
    }

    public void test0772() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface Foo<T> {\n  public T getIt();\n}\n\nclass FooImpl implements Foo {\n  public String getIt() {\n    return null;\n  }\n}\npublic class X {\n  public void doIt() {\n    Object s = new FooImpl().getIt();\n  }\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public void doIt() {\n    Object s = new FooImpl().getIt();\n  }\n}\n"}, "", null, false, null);
        String expectedOutput = "  // Method descriptor #18 ()Ljava/lang/Object;\n  // Stack: 1, Locals: 1\n  public bridge synthetic java.lang.Object getIt();\n    0  aload_0 [this]\n    1  invokevirtual FooImpl.getIt() : java.lang.String [19]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 1]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "FooImpl.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0773() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface Foo<T extends Exception> {\n  public T getIt() throws T;\n}\n\nclass FooImpl implements Foo {\n  public NullPointerException getIt() {\n    return null;\n  }\n}\npublic class X {\n  public void doIt() {\n    Object s = new FooImpl().getIt();\n  }\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n  public void doIt() {\n    Object s = new FooImpl().getIt();\n  }\n}\n"}, "", null, false, null);
        String expectedOutput = "  // Method descriptor #18 ()Ljava/lang/Exception;\n  // Stack: 1, Locals: 1\n  public bridge synthetic java.lang.Exception getIt() throws java.lang.Exception;\n    0  aload_0 [this]\n    1  invokevirtual FooImpl.getIt() : java.lang.NullPointerException [22]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 1]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "FooImpl.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0774() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tstatic class StaticInnerNoParam {\n\t\tT x;\n\t}\n\tclass NonStaticInnerParam<T> {}\t\n\tstatic class StaticInnerParam<T> {\t}\n\t<T> void foo(T t) {}\n\tstatic <T> void bar(T t) {}\n\t<T> X(T t) {}\n\t\n\tclass U {}\n\t<U> void foo2(U t) {}\n\tstatic <U> void bar2(U t) {}\n\tclass NonStaticInnerParam2<U> {}\t\n\tstatic class StaticInnerParam2<U> {}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tT x;\n\t^\nCannot make a static reference to the non-static type T\n----------\n2. WARNING in X.java (at line 5)\n\tclass NonStaticInnerParam<T> {}\t\n\t                          ^\nThe type parameter T is hiding the type T\n----------\n3. WARNING in X.java (at line 7)\n\t<T> void foo(T t) {}\n\t ^\nThe type parameter T is hiding the type T\n----------\n4. WARNING in X.java (at line 9)\n\t<T> X(T t) {}\n\t ^\nThe type parameter T is hiding the type T\n----------\n5. WARNING in X.java (at line 12)\n\t<U> void foo2(U t) {}\n\t ^\nThe type parameter U is hiding the type X<T>.U\n----------\n6. WARNING in X.java (at line 13)\n\tstatic <U> void bar2(U t) {}\n\t        ^\nThe type parameter U is hiding the type X<T>.U\n----------\n7. WARNING in X.java (at line 14)\n\tclass NonStaticInnerParam2<U> {}\t\n\t                           ^\nThe type parameter U is hiding the type X<T>.U\n----------\n8. WARNING in X.java (at line 15)\n\tstatic class StaticInnerParam2<U> {}\t\n\t                               ^\nThe type parameter U is hiding the type X<T>.U\n----------\n");
    }

    public void test0775() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends X<T>> {\n\tvoid foo1(X<? extends T> x) {}\n\tvoid foo2(X<? super T> x) {}\n}\n"}, "");
    }

    public void test0776() {
        this.runConformTest(true, new String[]{"X.java", "import java.util.*;\n\npublic class X<T extends Comparable<? super T>> {\n\n    abstract class Foo<E> implements I<Foo<? extends E>> {}\n\n    abstract class Bar<E> implements I<Bar<? extends E>> {}\n\n    public void bar(List<Foo<T>> f, List<Bar<T>> b) {\n\tfoo(f, b);\n    }\n\n    <C> void foo(List<? extends C> f, List<? extends C> b) {\n\tSystem.out.println(\"SUCCESS\");\n    }\n    public static void main(String... args) {\n\tnew X().bar(null, null);\n    }\n}\ninterface I<U> {}\n"}, null, "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0777() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic interface B<T> {\n\t\tpublic T a();\n\t}\n\n\tpublic interface C extends B {\n\t}\n\n\tpublic class D implements B<Integer> {\n\t\tpublic Integer a() {\n\t\t\treturn 0;\n\t\t}\n\t}\n\n\t// Illegal\n\tpublic class E implements B<Integer>, C {\n\t\tpublic Integer a() {\n\t\t\treturn 0;\n\t\t}\n\t}\n\n\t// why is this allowed?\n\tpublic class F extends D implements C {\n\t\tpublic Integer a() {\n\t\t\treturn 0;\n\t\t}\n\t}\n\n\tpublic interface G<T> {\n\t\tpublic void a(T pArg);\n\t}\n\n\tpublic interface H extends G {\n\t\tpublic Object b();\n\t}\n\n\tpublic class I implements G<Integer> {\n\t\tpublic void a(Integer pInt) {\n\t\t}\n\t}\n\n\t// Illegal. Huh?\n\tpublic class J extends I implements G {\n\t\tpublic Integer a() {\n\t\t\treturn 0;\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tpublic interface C extends B {\n\t                           ^\nX.B is a raw type. References to generic type X.B<T> should be parameterized\n----------\n2. ERROR in X.java (at line 16)\n\tpublic class E implements B<Integer>, C {\n\t             ^\nThe interface B cannot be implemented more than once with different arguments: X.B and X.B<Integer>\n----------\n3. ERROR in X.java (at line 23)\n\tpublic class F extends D implements C {\n\t             ^\nThe interface B cannot be implemented more than once with different arguments: X.B<Integer> and X.B\n----------\n4. WARNING in X.java (at line 24)\n\tpublic Integer a() {\n\t               ^^^\nThe method a() of type X.F should be tagged with @Override since it actually overrides a superclass method\n----------\n5. WARNING in X.java (at line 33)\n\tpublic interface H extends G {\n\t                           ^\nX.G is a raw type. References to generic type X.G<T> should be parameterized\n----------\n6. ERROR in X.java (at line 43)\n\tpublic class J extends I implements G {\n\t             ^\nThe interface G cannot be implemented more than once with different arguments: X.G<Integer> and X.G\n----------\n7. WARNING in X.java (at line 43)\n\tpublic class J extends I implements G {\n\t                                    ^\nX.G is a raw type. References to generic type X.G<T> should be parameterized\n----------\n");
    }

    public void test0778() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tinterface B<T> {}\n\n\tinterface C extends B {}\n\n\tclass D implements B<Integer> {}\n\n\tclass F extends D implements C {}\n\t\n\tclass V<U extends D & C> {}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tinterface C extends B {}\n\t                    ^\nX.B is a raw type. References to generic type X.B<T> should be parameterized\n----------\n2. ERROR in X.java (at line 8)\n\tclass F extends D implements C {}\n\t      ^\nThe interface B cannot be implemented more than once with different arguments: X.B<Integer> and X.B\n----------\n3. ERROR in X.java (at line 10)\n\tclass V<U extends D & C> {}\n\t                      ^\nThe interface B cannot be implemented more than once with different arguments: X.B and X.B<Integer>\n----------\n");
    }

    public void test0779() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.AbstractList;\nimport java.util.List;\n\npublic class X {\n\tprivate static class Entry {\n\t\tpublic void doIt(final List<? extends String> args) {\n\t\t\tList<String> list = new AbstractList<String>() {\n\t\t\t\t@Override public int size() { return 0; }\n\t\t\t\t@Override public String get(int i) { return args.get(i); }\n" + COLLECTION_AND_LIST_IMPL_JRE8.replaceAll("\\*", "String") + ITERABLE_IMPL_JRE8.replaceAll("\\*", "String") + "\t\t\t};\n" + "\t\t}\n" + "\t}\n" + "\tpublic static void main(String[] args) {\n" + "\t\tnew Entry().doIt(null);\n" + "\t\tSystem.out.println(\"SUCCESS\");\n" + "\t}\n" + "}\n"}, "SUCCESS");
        String constantPoolIdx = IS_JRE_8 ? "73" : "36";
        String expectedOutput = "  // Method descriptor #31 (I)Ljava/lang/Object;\n  // Stack: 2, Locals: 2\n  public bridge synthetic java.lang.Object get(int arg0);\n    0  aload_0 [this]\n    1  iload_1 [arg0]\n    2  invokevirtual X$Entry$1.get(int) : java.lang.String [" + constantPoolIdx + "]\n" + "    5  areturn\n" + "      Line numbers:\n" + "        [pc: 0, line: 1]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Entry$1.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0780() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tlong foo(List<? extends Long> list) {\n\t\treturn list.get(0);\n\t}\n\tpublic static void main(String[] args) {\n\t\tList<Long> list = new ArrayList<Long>();\n\t\tlist.add(123L);\n\t\tSystem.out.println(new X().foo(list));\n\t}\n}\n"}, "123");
    }

    public void test0781() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n    public static <E, T extends E & Comparable<? super T>> Foo<E> doIt(T t) {\n        return null;\n    }\n    \n    interface Foo<E> {\n        boolean ok(E e);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic static <E, T extends E & Comparable<? super T>> Foo<E> doIt(T t) {\n\t                                ^^^^^^^^^^\nCannot specify any additional bound Comparable<? super T> when first bound is a type parameter\n----------\n");
    }

    public void test0782() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.*;\nimport java.util.*;\n\ninterface StoredObject {\n\tString getUid();\n\tString getName();\n\tString getDescription();\n}\n\ninterface GraphDiagramNode // extends Comparable\n{\n}\n\npublic class X<ObjectType extends StoredObject, ParentType extends StoredObject> implements GraphDiagramNode {\n\tprivate final JccsGraphDiagramModel model;\n\tprivate final X<? extends ParentType, ?> parent;\n\tprivate final ObjectType object;\n\n\tpublic class JccsGraphDiagramModel {\n\t}\n\n\tpublic interface GraphDiagramModel {\n\t}\n\n\tpublic class Dependency {\n\n\t}\n\n\tpublic X(JccsGraphDiagramModel argModel, X<? extends ParentType, ?> argParent, ObjectType argObject) {\n\t\tmodel = argModel;\n\t\tparent = argParent;\n\t\tobject = argObject;\n\t}\n\n\tprotected <ChildType extends StoredObject> Collection<? extends X<ChildType, ? super ObjectType>> createChildren(\n\t\t\tIterator<ChildType> argData, Class<? extends X<ChildType, ? super ObjectType>> argChildNodeClass,\n\t\t\tClass<? extends StoredObject> argInterface) {\n\t\tCollection<X<ChildType, ? super ObjectType>> output = new LinkedList<X<ChildType, ? super ObjectType>>();\n\n\t\ttry {\n\t\t\twhile (argData.hasNext()) {\n\t\t\t\tChildType next = argData.next();\n\t\t\t\tConstructor<? extends X<ChildType, ? super ObjectType>> constructor = argChildNodeClass.getConstructor(\n\t\t\t\t\t\tJccsGraphDiagramModel.class, getClass(), argInterface);\n\n\t\t\t\toutput.add(constructor.newInstance(model, this, next));\n\t\t\t}\n\t\t} catch (Exception x) {\n\t\t\tx.printStackTrace();\n\t\t}\n\n\t\treturn output;\n\t}\n}\n"}, "");
    }

    public void test0783() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  private static class B{\n    private int foo; //incorrectly identified as unused\n  }\n  void bar(B b){\n    if (b.foo == 0)\n      return;\n  }\n  Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0784() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, U> {\n\tX<? extends U, ?> parent;\n\n\tpublic X(X<? extends U, ?> parent) {\n\t\tthis.parent = parent;\n\t}\n}\n"}, "");
    }

    public void test0785() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    <T extends Collection<? extends Number>> T getLonger(T t1, T t2) {\n        return t1.size() > t2.size() ? t1 : t2;\n    }\n    \n    void m(HashSet<?> list, ArrayList<?> set) {\n        getLonger(list, set);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgetLonger(list, set);\n\t^^^^^^^^^\nBound mismatch: The generic method getLonger(T, T) of type X is not applicable for the arguments (HashSet<capture#3-of ?>, ArrayList<capture#4-of ?>). The inferred type AbstractCollection<? extends Object>&Cloneable&Serializable is not a valid substitute for the bounded parameter <T extends Collection<? extends Number>>\n----------\n");
    }

    public void test0786() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    <T extends Collection<? extends Object>> T getLonger(T t1, T t2) {\n        return t1.size() > t2.size() ? t1 : t2;\n    }\n    \n    void m(HashSet<?> list, ArrayList<?> set) {\n        getLonger(list, set);\n    }\n}\n"}, "");
    }

    public void test0787() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<U> {\n    <T extends Collection<? extends U>> T getLonger(T t1, T t2) {\n        return t1.size() > t2.size() ? t1 : t2;\n    }\n    \n    void m(HashSet<?> list, ArrayList<?> set) {\n        getLonger(list, set);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgetLonger(list, set);\n\t^^^^^^^^^\nBound mismatch: The generic method getLonger(T, T) of type X<U> is not applicable for the arguments (HashSet<capture#3-of ?>, ArrayList<capture#4-of ?>). The inferred type AbstractCollection<? extends Object>&Cloneable&Serializable is not a valid substitute for the bounded parameter <T extends Collection<? extends U>>\n----------\n");
    }

    public void test0788() {
        this.runConformTest(new String[]{"test/A.java", "package test;\n\npublic class A<C extends java.nio.channels.Channel>\n{\n\tclass B\n\t\textends A<java.nio.channels.SocketChannel>\n\t{\n\t}\n}\n", "java/nio/channels/spi/AbstractSelectableChannel.java", "package java.nio.channels.spi;\n\npublic abstract class AbstractSelectableChannel\n\textends java.nio.channels.SelectableChannel\n{\n}\n"}, "");
    }

    public void test0789() {
        this.runConformTest(new String[]{"java/nio/channels/spi/AbstractSelectableChannel.java", "package java.nio.channels.spi;\n\npublic abstract class AbstractSelectableChannel\n\textends java.nio.channels.SelectableChannel\n{\n}\n", "test/A.java", "package test;\n\npublic class A<C extends java.nio.channels.Channel>\n{\n\tclass B\n\t\textends A<java.nio.channels.SocketChannel>\n\t{\n\t}\n}\n"}, "");
    }

    public void test0790() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T extends Comparable<T>> boolean isGreater(T t1, T t2) {\n\t\treturn t1.compareTo(t2) > 0 ? true : false; \n\t}\n\n\tvoid method1(Integer i, Double d) {\n\t\tif (isGreater(i, d)) \n\t\t\tSystem.out.println(\"GREATER\");\n\t\telse\n\t\t\tSystem.out.println(\"LOWER\");\n\t}\n\tvoid method2(Integer i, Double d) {\n\t\tComparable<? extends Number> c1= i;\n\t\tComparable<? extends Number> c2= d;\n\t\tisGreater(c1, c2);\n\t}\t\n\tvoid method3(Integer i, Double d) {\n\t\tComparable c1= i;\n\t\tComparable c2= d;\n\t\tisGreater(c1, c2);\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tInteger i = 1;\n\t\tDouble d = 2.0;\n\t\tnew X().method1(i, d);\n\t\tnew X().method2(i, d);\n\t\tnew X().method3(i, d);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tif (isGreater(i, d)) \n\t    ^^^^^^^^^\nBound mismatch: The generic method isGreater(T, T) of type X is not applicable for the arguments (Integer, Double). The inferred type Number&Comparable<?> is not a valid substitute for the bounded parameter <T extends Comparable<T>>\n----------\n2. ERROR in X.java (at line 15)\n\tisGreater(c1, c2);\n\t^^^^^^^^^\nBound mismatch: The generic method isGreater(T, T) of type X is not applicable for the arguments (Comparable<capture#1-of ? extends Number>, Comparable<capture#2-of ? extends Number>). The inferred type Comparable<? extends Number> is not a valid substitute for the bounded parameter <T extends Comparable<T>>\n----------\n3. WARNING in X.java (at line 18)\n\tComparable c1= i;\n\t^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n4. WARNING in X.java (at line 19)\n\tComparable c2= d;\n\t^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n5. WARNING in X.java (at line 20)\n\tisGreater(c1, c2);\n\t^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation isGreater(Comparable, Comparable) of the generic method isGreater(T, T) of type X\n----------\n");
    }

    public void test0791() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n  <Sup, E1 extends Sup, E2 extends Sup> Sup method1(boolean b, E1 e1, E2 e2) {\n    if (b)\n      return e1;\n    else\n      return e2;\n  }\n\n  <Sup, E1 extends Sup, E2 extends Sup> Sup method2(boolean b, E1 e1, E2 e2) {\n    return b ? e1 : e2;\n  }\n}\n"}, null, "", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test0792() {
        this.runConformTest(new String[]{"X.java", "public class X<E> {\n\tvoid shouldcompile() {\n\t\tjava.util.Collections.max(null);\n\t}\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test0793() {
        this.runNegativeTest(new String[]{"X.java", "class X { \n\tpublic java.util.List<Integer> i,j[],k;\n\tvoid m() {\n\t\t  i[0] = null;\n\t\t  j[0] = null;\n\t\t  k[0] = null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\ti[0] = null;\n\t^^^^\nThe type of the expression must be an array type but it resolved to List<Integer>\n----------\n2. ERROR in X.java (at line 6)\n\tk[0] = null;\n\t^^^^\nThe type of the expression must be an array type but it resolved to List<Integer>\n----------\n");
    }

    public void test0794() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass X { \n\tpublic List<Integer> i,j[],k;\n\tvoid m() {\n\t\t  i[0] = null;\n\t\t  j[0] = null;\n\t\t  k[0] = null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\ti[0] = null;\n\t^^^^\nThe type of the expression must be an array type but it resolved to List<Integer>\n----------\n2. ERROR in X.java (at line 7)\n\tk[0] = null;\n\t^^^^\nThe type of the expression must be an array type but it resolved to List<Integer>\n----------\n");
    }

    public void test0795() {
        this.runConformTest(new String[]{"X.java", "public class X<T> { \n\t\t class B {\n\t\t\t B() {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t\t }\n\t\t }\n\t\t static { \n\t\t \t\t new X<String>().new B() {};\n\t\t }\n\t\t public static void main(String[] args) {\n\t\t\t\n\t\t}\n}\n"}, "SUCCESS");
    }

    public void test0796() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> { \n\t\t class B {\n\t\t\t B(T t) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t\t }\n\t\t }\n\t\t static { \n\t\t \t\t new X<String>().new B(12) {};\n\t\t }\n\t\t public static void main(String[] args) {\n\t\t\t\n\t\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tnew X<String>().new B(12) {};\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor X<String>.B(int) is undefined\n----------\n");
    }

    public void test0797() {
        this.runConformTest(new String[]{"X.java", "public class X<T> { \n\t\t class B {\n\t\t\t B() {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t\t }\n\t\t }\n\t\t static { \n\t\t \t\t new X<String>().new B();\n\t\t }\n\t\t public static void main(String[] args) {\n\t\t\t\n\t\t}\n}\n"}, "SUCCESS");
    }

    public void test0798() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.math.BigDecimal;\n\npublic class X\n{\n    private static <T extends Comparable<? super T>> T max(T... elems)\n    {\n        T max=null;\n        for (T elem : elems)\n            if (max == null || max.compareTo(elem) < 0)\n                max=elem;\n        return max;\n    }\n\n    public static void main(String[] args)\n    {\n        System.out.println(max(1, 2.0, new BigDecimal(Math.PI)));\n    }\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 16)\n\tSystem.out.println(max(1, 2.0, new BigDecimal(Math.PI)));\n\t                   ^^^\nBound mismatch: The generic method max(T...) of type X is not applicable for the arguments (Integer, Double, BigDecimal). The inferred type Number&Comparable<?> is not a valid substitute for the bounded parameter <T extends Comparable<? super T>>\n----------\n" : "----------\n1. WARNING in X.java (at line 5)\n\tprivate static <T extends Comparable<? super T>> T max(T... elems)\n\t                                                            ^^^^^\nType safety: Potential heap pollution via varargs parameter elems\n----------\n2. ERROR in X.java (at line 16)\n\tSystem.out.println(max(1, 2.0, new BigDecimal(Math.PI)));\n\t                   ^^^\nBound mismatch: The generic method max(T...) of type X is not applicable for the arguments (Integer, Double, BigDecimal). The inferred type Number&Comparable<?> is not a valid substitute for the bounded parameter <T extends Comparable<? super T>>\n----------\n");
    }

    public void test0799() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tY first;\n\tY first2;\n\n\t<U> U foo(U u1, U u2) {\n\t\treturn u1;\n\t}\n\tvoid bar2(Y<? extends T> ref) {\n\t\tString s = foo(ref, first);\n\t}\n\t\n\tvoid foo(Y<? extends T> ref) {\n\t\tref.next = first == null ? ref : first;\n\t\tString s = first == null ? ref : first;\n\t\tref.next = first2 == null ? ref : first2;\n\t}\n\tY<? extends T> bar(Y<? extends T> ref) {\n\t\treturn first == null ? ref : first;\n\t}\n}\n\nclass Y<E> {\n\tY<E> next;\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. WARNING in X.java (at line 2)\n\tY first;\n\t^\nY is a raw type. References to generic type Y<E> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tY first2;\n\t^\nY is a raw type. References to generic type Y<E> should be parameterized\n----------\n3. ERROR in X.java (at line 9)\n\tString s = foo(ref, first);\n\t           ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Y to String\n----------\n4. WARNING in X.java (at line 13)\n\tref.next = first == null ? ref : first;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<capture#2-of ? extends T>\n----------\n5. ERROR in X.java (at line 14)\n\tString s = first == null ? ref : first;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Y to String\n----------\n6. WARNING in X.java (at line 15)\n\tref.next = first2 == null ? ref : first2;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<capture#5-of ? extends T>\n----------\n7. WARNING in X.java (at line 18)\n\treturn first == null ? ref : first;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<? extends T>\n----------\n" : "----------\n1. WARNING in X.java (at line 2)\n\tY first;\n\t^\nY is a raw type. References to generic type Y<E> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tY first2;\n\t^\nY is a raw type. References to generic type Y<E> should be parameterized\n----------\n3. ERROR in X.java (at line 9)\n\tString s = foo(ref, first);\n\t           ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Y to String\n----------\n4. ERROR in X.java (at line 13)\n\tref.next = first == null ? ref : first;\n\t                           ^^^\nType mismatch: cannot convert from Y<capture#3-of ? extends T> to Y<capture#2-of ? extends T>\n----------\n5. WARNING in X.java (at line 13)\n\tref.next = first == null ? ref : first;\n\t                                 ^^^^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<capture#2-of ? extends T>\n----------\n6. ERROR in X.java (at line 14)\n\tString s = first == null ? ref : first;\n\t                           ^^^\nType mismatch: cannot convert from Y<capture#4-of ? extends T> to String\n----------\n7. ERROR in X.java (at line 14)\n\tString s = first == null ? ref : first;\n\t                                 ^^^^^\nType mismatch: cannot convert from Y to String\n----------\n8. ERROR in X.java (at line 15)\n\tref.next = first2 == null ? ref : first2;\n\t                            ^^^\nType mismatch: cannot convert from Y<capture#6-of ? extends T> to Y<capture#5-of ? extends T>\n----------\n9. WARNING in X.java (at line 15)\n\tref.next = first2 == null ? ref : first2;\n\t                                  ^^^^^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<capture#5-of ? extends T>\n----------\n10. WARNING in X.java (at line 18)\n\treturn first == null ? ref : first;\n\t                             ^^^^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<? extends T>\n----------\n");
    }

    public void test0800() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.reflect.Constructor;\n\npublic class X {\n\tpublic static void main(String[] args) {\n        final Class<Ann> AnnClass = Ann.class;\n\t    Constructor[] constrs = X.class.getConstructors();\n        for (Constructor constructor  : constrs) {\n            final String message = constructor.getAnnotation(AnnClass).message();\n            System.out.println(message);\n        }\n\t}\n}\n\n@interface Ann {\n\tString message();\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tConstructor[] constrs = X.class.getConstructors();\n\t^^^^^^^^^^^\nConstructor is a raw type. References to generic type Constructor<T> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tfor (Constructor constructor  : constrs) {\n\t     ^^^^^^^^^^^\nConstructor is a raw type. References to generic type Constructor<T> should be parameterized\n----------\n3. WARNING in X.java (at line 8)\n\tfinal String message = constructor.getAnnotation(AnnClass).message();\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method getAnnotation(Class) belongs to the raw type Constructor. References to generic type Constructor<T> should be parameterized\n----------\n4. ERROR in X.java (at line 8)\n\tfinal String message = constructor.getAnnotation(AnnClass).message();\n\t                                                           ^^^^^^^\nThe method message() is undefined for the type Annotation\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6400189);
    }

    public void test0801() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t    X.class.getConstructor(new Class[0]).getAnnotation(Ann.class).message();\n\t\t} catch(Exception e) {\n\t\t}\n\t}\n}\n\n@interface Ann {\n\tString message();\n}\n"}, "");
    }

    public void test0802() {
        this.runNegativeTest(new String[]{"X.java", "public class X<U> {\n    void bar(Y y, X<ZZ> x) {\n    \ty.foo(x).zz();\n    }\n}\nclass Y<V> {\n    <T extends Z> T foo(X<T> x) { return null; }\n}\n\nclass Z {\n}\nclass ZZ extends Z {\n\tvoid zz() {}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid bar(Y y, X<ZZ> x) {\n\t         ^\nY is a raw type. References to generic type Y<V> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\ty.foo(x).zz();\n\t^^^^^^^^\nType safety: The method foo(X) belongs to the raw type Y. References to generic type Y<V> should be parameterized\n----------\n3. ERROR in X.java (at line 3)\n\ty.foo(x).zz();\n\t         ^^\nThe method zz() is undefined for the type Z\n----------\n");
    }

    public void test0803() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X<A> {\n  ArrayList<A> list = new ArrayList<A>();\n  ArrayList<? super A> superList = new ArrayList<A>();\n  ArrayList<? extends A> extendsList = new ArrayList<A>();\n\n  ArrayList<A> getList() {\n    return true ? list : list;\n  }\n\n  ArrayList<? super A> getSuperList() {\n    return true ? superList : superList;\n  }\n\n  ArrayList<? extends A> getExtendsList() {\n    return true ? extendsList : extendsList;\n  }\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. WARNING in X.java (at line 9)\n\treturn true ? list : list;\n\t                     ^^^^\nDead code\n----------\n2. ERROR in X.java (at line 13)\n\treturn true ? superList : superList;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from ArrayList<capture#3-of ? extends Object> to ArrayList<? super A>\n----------\n3. WARNING in X.java (at line 17)\n\treturn true ? extendsList : extendsList;\n\t                            ^^^^^^^^^^^\nDead code\n----------\n" : "----------\n1. WARNING in X.java (at line 9)\n\treturn true ? list : list;\n\t                     ^^^^\nDead code\n----------\n2. WARNING in X.java (at line 13)\n\treturn true ? superList : superList;\n\t                          ^^^^^^^^^\nDead code\n----------\n3. WARNING in X.java (at line 17)\n\treturn true ? extendsList : extendsList;\n\t                            ^^^^^^^^^^^\nDead code\n----------\n");
    }

    public void test0804() {
        this.runNegativeTest(new String[]{"X.java", "class Y<E> {\n\tvoid foo(E e) {\n\t}\n}\npublic class X {\n    void method1(Y<? super Object[]> y, Object[] os) {\n        y.foo(os);\n    }\n    void method2(Y<? super Cloneable> y, Cloneable c) {\n        y.foo(c);\n    }    \n    void method3(Y<? extends Object[]> y, Object[] os) {\n        y.foo(os);\n    }\n    void method4(Y<? extends Cloneable> y, Cloneable c) {\n        y.foo(c);\n    }    \n    \n    void bar(Y<Object> y) {\n    \tmethod2(y, null);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\ty.foo(os);\n\t  ^^^\nThe method foo(capture#3-of ? extends Object[]) in the type Y<capture#3-of ? extends Object[]> is not applicable for the arguments (Object[])\n----------\n2. ERROR in X.java (at line 16)\n\ty.foo(c);\n\t  ^^^\nThe method foo(capture#4-of ? extends Cloneable) in the type Y<capture#4-of ? extends Cloneable> is not applicable for the arguments (Cloneable)\n----------\n");
    }

    public void test0805() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n \tstatic <T> T foo(T t1, T t2) { return t1; }\n \tpublic static void main(String[] args) {\n\t\tNumber[] numbers = {}, numbers2, numbers3;\n\t\tFloat[] floats = {};\n\t\tInteger[] integers = {};\n\n\t\tnumbers2 = foo(numbers, floats);\n \t\tnumbers3 = numbers != null ? numbers : floats;\n \t\tString s = foo(numbers, floats); \t\t\n\n \t\tnumbers2 = foo(integers, floats);\n \t\tnumbers3 = integers != null ? integers : floats;\n \t\tString s2 = foo(integers, floats);\n \t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tString s = foo(numbers, floats); \t\t\n\t           ^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Number[] to String\n----------\n2. ERROR in X.java (at line 14)\n\tString s2 = foo(integers, floats);\n\t            ^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Number&Comparable<? extends Number&Comparable<?>>[] to String\n----------\n");
    }

    public void test0806() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\n/**\n * This class demonstrates a generic program that Eclipse must not compile as it\n * can lead to a ClassCastException despite having no explicit type casts.\n */\npublic class X {\n\tprivate static class ValueHolder<T> {\n\t\tpublic T value;\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tList<ValueHolder<?>> multiList = new ArrayList<ValueHolder<?>>();\n\n\t\tValueHolder<Integer> intHolder = new ValueHolder<Integer>();\n\t\tintHolder.value = 1;\n\n\t\tValueHolder<Double> doubleHolder = new ValueHolder<Double>();\n\t\tdoubleHolder.value = 1.5;\n\n\t\tmultiList.add(intHolder);\n\t\tmultiList.add(doubleHolder);\n\n\t\t// I believe this line is being erroneously treated as a capture\n        // conversion under 3.1 JDT.\n\t\t// I believe the problem is that ? cannot be captured except in a first\n        // level wildcard.\n\t\tswapFirstTwoValues(multiList);\n\n\t\t// this line causes a ClassCastException when checked.\n\t\tInteger value = intHolder.value;\n\t\tSystem.out.println(value);\n\t}\n\n\tprivate static <T> void swapFirstTwoValues(List<ValueHolder<T>> multiList) {\n\t\tValueHolder<T> intHolder = multiList.get(0);\n\t\tValueHolder<T> doubleHolder = multiList.get(1);\n\n\t\tintHolder.value = doubleHolder.value;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 29)\n\tswapFirstTwoValues(multiList);\n\t^^^^^^^^^^^^^^^^^^\nThe method swapFirstTwoValues(List<X.ValueHolder<T>>) in the type X is not applicable for the arguments (List<X.ValueHolder<?>>)\n----------\n");
    }

    public void test0807() {
        this.runConformTest(new String[]{"X.java", "interface Prop<BeanT> {\n\tUnmarshaller.Handler createHandler();\n}\n\nabstract class Unmarshaller {\n\tpublic static abstract class Handler {}\n}\n\npublic class X {\n\tvoid foo(Prop p) {\n\t\tUnmarshaller.Handler h = p.createHandler(); \n\t}\n}\n"}, "");
    }

    public void test0808() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    \n    public static void main(String[] args) {\n        X x = new X();\n        x.ax = new AX<String>();\n    }\n    \n    AX<T> ax;\n}\n\nclass AX <P> {\n    AX<P> p;\n}\n"}, "");
    }

    public void test0809() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Iterator;\n\nclass Node {}\ninterface Set1<N extends Node> extends Iterable<N> {}\ninterface Set2 extends Iterable<Node> {}\n\nclass SetIterator<N extends Node> implements Iterator<N> {\n\tpublic N next() {\n\t\treturn null;\n\t}\n\tpublic boolean hasNext() {\n\t\treturn true;\n\t}\n\tpublic void remove() {\n\t}\n" + ITERATOR_IMPL_JRE8.replaceAll("\\*", "N") + "}\n" + "interface Set3<N extends Node> extends Iterable<N> {\n" + "\tSetIterator<N> iterator();\n" + "}\n" + "public class X {\n" + "\tvoid f1(Set1 s) {\n" + "\t\tNode n_ = s.iterator().next();\n" + "\t\t// ^Type mismatch: cannot convert from Object to Node\n" + "\t\t// this was unexpected (s can only contain types derivered from Node)\n" + "\t\tfor (Node n : s) {\n" + "\t\t\t// ^Type mismatch: cannot convert from Object to Node\n" + "\t\t\t// this was unexpected\n" + "\t\t}\n" + "\t}\n" + "\tvoid f2(Set2 s) {\n" + "\t\tNode n_ = s.iterator().next();\n" + "\t\tfor (Node n : s) {\n" + "\t\t}\n" + "\t}\n" + "\tvoid f3(Set3 s) {\n" + "\t\tNode n_ = s.iterator().next();\n" + "\t\t// (^ no error here)\n" + "\t\tfor (Node n : s) {\n" + "\t\t\t// ^Type mismatch: cannot convert from Object to Node\n" + "\t\t\t// this is even stranger as we already know that s.iterator().next()\n" + "            // have the right type\n" + "\t\t}\n" + "\t}\n" + "}\n"}, "----------\n1. WARNING in X.java (at line 23)\n\tvoid f1(Set1 s) {\n\t        ^^^^\nSet1 is a raw type. References to generic type Set1<N> should be parameterized\n----------\n2. ERROR in X.java (at line 24)\n\tNode n_ = s.iterator().next();\n\t          ^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to Node\n----------\n3. ERROR in X.java (at line 27)\n\tfor (Node n : s) {\n\t              ^\nType mismatch: cannot convert from element type Object to Node\n----------\n4. WARNING in X.java (at line 37)\n\tvoid f3(Set3 s) {\n\t        ^^^^\nSet3 is a raw type. References to generic type Set3<N> should be parameterized\n----------\n5. ERROR in X.java (at line 40)\n\tfor (Node n : s) {\n\t              ^\nType mismatch: cannot convert from element type Object to Node\n----------\n");
    }

    public void test0810() {
        this.runConformTest(true, new String[]{"X.java", "class A<T, U> {\n\tpublic String toString() {\n\t\treturn \"SUCCESS\";\n\t}\n}\npublic class X {\n\n\tpublic <K> A<K,K> foo(K type) {\n\t\treturn new A<K,K>();\n\t}\n\n\tpublic static void main(String args[]) {\n\t\tX x = new X();\n\t\tA<?,?> a = x.foo(null);\n\t\tSystem.out.println(a);\n\t}\n}"}, null, "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0811() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    private T t;\n    private X.Inner inner;\n    private X.Inner[] inners;\n    public X(T t,  X.Inner in, X.Inner[] ins) {\n        this.t = t;\n        this.inner = in;\n        this.inner = new X(null, null, null).new Inner();\n        this.inners = ins;\n        this.inners = new X.Inner[10];\n        //Type mismatch: cannot convert from X.Inner[] to X<T>.Inner[]\n    }\n    private class Inner {\n    }\n}\n"}, "");
    }

    public void test0812() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    private T t;\n    private X<?>.Inner inner;\n    private X<?>.Inner[] inners;\n    public X(T t) {\n        this.t = t;\n        this.inner = new X.Inner();\n        this.inners = new X.Inner[10];\n        Zork z;\n    }\n    private class Inner {\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tthis.inner = new X.Inner();\n\t                 ^^^^^^^\nX.Inner is a raw type. References to generic type X<T>.Inner should be parameterized\n----------\n2. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0813() {
        this.runConformTest(true, new String[]{"X.java", "public class X<T> {\n    private T t;\n    private X<?>.Inner[] inners;\n    public X(T t) {\n        this.t = t;\n        this.inners = new X<?>.Inner[10];\n    }\n    private class Inner {\n    }\n}\n"}, null, "", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test0814() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<E> {\n    void method(Object o) {\n        if (o instanceof E[]) { //incorrect: cannot test non-reifiable type\n            E[] es = (E[]) o;\n        }\n        if (o instanceof List<E>[]) { //incorrect too\n            List<E>[] es = (List<E>[]) o; \n        }\n        if (o instanceof List<?>[]) { // unbound is ok\n            List<?>[] es = (List<?>[]) o;\n        }\n    }\n    void method(ArrayList<E>[] al) {\n        if (al instanceof List<E>[]) { //incorrect too\n            List<E>[] es = (List<E>[]) al; \n        }        \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o instanceof E[]) { //incorrect: cannot test non-reifiable type\n\t    ^^^^^^^^^^^^^^^^\nCannot perform instanceof check against type parameter E[]. Use its erasure Object[] instead since further generic type information will be erased at runtime\n----------\n2. WARNING in X.java (at line 5)\n\tE[] es = (E[]) o;\n\t         ^^^^^^^\nType safety: Unchecked cast from Object to E[]\n----------\n3. ERROR in X.java (at line 7)\n\tif (o instanceof List<E>[]) { //incorrect too\n\t    ^^^^^^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type List<E>[]. Use the form List<?>[] instead since further generic type information will be erased at runtime\n----------\n4. WARNING in X.java (at line 8)\n\tList<E>[] es = (List<E>[]) o; \n\t               ^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to List<E>[]\n----------\n5. ERROR in X.java (at line 15)\n\tif (al instanceof List<E>[]) { //incorrect too\n\t    ^^^^^^^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type List<E>[]. Use the form List<?>[] instead since further generic type information will be erased at runtime\n----------\n6. WARNING in X.java (at line 16)\n\tList<E>[] es = (List<E>[]) al; \n\t               ^^^^^^^^^^^^^^\nUnnecessary cast from ArrayList<E>[] to List<E>[]\n----------\n");
    }

    public void test0815() {
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n\tvoid foo(Object[][] e) {\n\t\tE[] o = (E[]) e;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tE[] o = (E[]) e;\n\t        ^^^^^^^\nType safety: Unchecked cast from Object[][] to E[]\n----------\n2. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0816() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<E> {\n    void method(Object[] o) {\n        if (o instanceof List<E>[][]) { //incorrect too\n            List<E>[][] es = (List<E>[][]) o; \n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o instanceof List<E>[][]) { //incorrect too\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type List<E>[][]. Use the form List<?>[][] instead since further generic type information will be erased at runtime\n----------\n2. WARNING in X.java (at line 5)\n\tList<E>[][] es = (List<E>[][]) o; \n\t                 ^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object[] to List<E>[][]\n----------\n");
    }

    public void test0817() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X<T> {\n    private T t;\n    private X<?>.Inner inner;\n    private X<?>.Inner[] inners;\n    public X(T t) {\n        this.t = t;\n        if (this.inner instanceof X<?>.Inner) {}\n        if (this.inners instanceof X<?>.Inner[]) {}\n    }\n    private class Inner {\n    }\n    void foo(List l) {\n    \tif (l instanceof List<?>) {}\n    \tif (l instanceof List<? extends String>) {}\n    }\n    void foo(List[] ls) {\n    \tif (ls instanceof List<?>[]) {}\n    \tif (ls instanceof List<? extends String>[]) {}\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tif (this.inner instanceof X<?>.Inner) {}\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type X<?>.Inner is already an instance of type X<?>.Inner\n----------\n2. WARNING in X.java (at line 10)\n\tif (this.inners instanceof X<?>.Inner[]) {}\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type X<?>.Inner[] is already an instance of type X<?>.Inner[]\n----------\n3. WARNING in X.java (at line 14)\n\tvoid foo(List l) {\n\t         ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in X.java (at line 15)\n\tif (l instanceof List<?>) {}\n\t    ^^^^^^^^^^^^^^^^^\nThe expression of type List is already an instance of type List<?>\n----------\n5. ERROR in X.java (at line 16)\n\tif (l instanceof List<? extends String>) {}\n\t    ^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type List<? extends String>. Use the form List<?> instead since further generic type information will be erased at runtime\n----------\n6. WARNING in X.java (at line 18)\n\tvoid foo(List[] ls) {\n\t         ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n7. WARNING in X.java (at line 19)\n\tif (ls instanceof List<?>[]) {}\n\t    ^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type List[] is already an instance of type List<?>\n----------\n8. ERROR in X.java (at line 20)\n\tif (ls instanceof List<? extends String>[]) {}\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type List<? extends String>[]. Use the form List<?>[] instead since further generic type information will be erased at runtime\n----------\n");
    }

    public void test0818() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    boolean b = this instanceof Y;\n    static class Y extends X<Object> {\n    }\n}\n"}, "");
    }

    public void test0819() {
        this.runConformTest(new String[]{"X.java", "public class X implements MyInterface {\n\tpublic void myMethod(myEnum value) {\n\t\tSystem.out.println(\"value is \"+value);\n\t}\n\tpublic static void main(String[] args){\n\t\tnew X().myMethod(myEnum.one);\t\t\n\t}\n}\n\ninterface MyInterface<T> {\n\tenum myEnum {one,two};\n\tpublic void myMethod(myEnum value); \n}\n"}, "value is one");
    }

    public void test0820() {
        this.runConformTest(new String[]{"X.java", "public class X implements I {\n  public void x(M value) {}\n}\ninterface I<T> {\n  class M {}\n  void x(M value); \n}\n"}, "");
    }

    public void test0821() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\n\npublic class X<T extends Serializable & Runnable> {\n\tT t;\n\tX(T t) {\n\t\tthis.t = t;\n\t}\n\tvoid foo() {\n\t\tt.run();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X<A>(new A()).foo();\n\t}\n}\nclass A implements Serializable, Runnable {\n\tpublic void run() {\n\t\tSystem.out.println(\"AA\");\n\t}\n}\n"}, "AA");
        String expectedOutput = "  // Method descriptor #15 ()V\n  // Stack: 1, Locals: 1\n  void foo();\n     0  aload_0 [this]\n     1  getfield X.t : java.io.Serializable [16]\n     4  checkcast java.lang.Runnable [25]\n     7  invokeinterface java.lang.Runnable.run() : void [27] [nargs: 1]\n    12  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 12, line: 10]\n      Local variable table:\n        [pc: 0, pc: 13] local: this index: 0 type: X\n      Local variable type table:\n        [pc: 0, pc: 13] local: this index: 0 type: X<T>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0822() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\n\npublic class X<T extends Serializable & Runnable> {\n\tvoid foo(T t) {\n\t\tt.run();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X<A>().foo(new A());\n\t}\n}\nclass A implements Serializable, Runnable {\n\tpublic void run() {\n\t\tSystem.out.println(\"AA\");\n\t}\n}\n"}, "AA");
        String expectedOutput = "  // Method descriptor #17 (Ljava/io/Serializable;)V\n  // Signature: (TT;)V\n  // Stack: 1, Locals: 2\n  void foo(java.io.Serializable t);\n     0  aload_1 [t]\n     1  checkcast java.lang.Runnable [20]\n     4  invokeinterface java.lang.Runnable.run() : void [22] [nargs: 1]\n     9  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 9, line: 6]\n      Local variable table:\n        [pc: 0, pc: 10] local: this index: 0 type: X\n        [pc: 0, pc: 10] local: t index: 1 type: java.io.Serializable\n      Local variable type table:\n        [pc: 0, pc: 10] local: this index: 0 type: X<T>\n        [pc: 0, pc: 10] local: t index: 1 type: T\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0823() throws Exception {
        this.runConformTest(true, new String[]{"X.java", "import java.io.Serializable;\n\npublic class X<T extends Serializable & Runnable, V extends T> {\n\tT t;\n\tX(T t) {\n\t\tthis.t = t;\n\t}\n\tvoid foo() {\n\t\t(this == null ? t : t).run();\n\t\t((V) t).run();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X<A, A>(new A()).foo();\n\t}\n}\nclass A implements Serializable, Runnable {\n\tpublic void run() {\n\t\tSystem.out.print(\"AA\");\n\t}\n}\n"}, null, "AAAA", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6531075);
        String expectedOutput = "  // Method descriptor #15 ()V\n  // Stack: 1, Locals: 1\n  void foo();\n     0  aload_0 [this]\n     1  ifnonnull 11\n     4  aload_0 [this]\n     5  getfield X.t : java.io.Serializable [16]\n     8  goto 15\n    11  aload_0 [this]\n    12  getfield X.t : java.io.Serializable [16]\n    15  checkcast java.lang.Runnable [25]\n    18  invokeinterface java.lang.Runnable.run() : void [27] [nargs: 1]\n    23  aload_0 [this]\n    24  getfield X.t : java.io.Serializable [16]\n    27  checkcast java.lang.Runnable [25]\n    30  invokeinterface java.lang.Runnable.run() : void [27] [nargs: 1]\n    35  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 23, line: 10]\n        [pc: 35, line: 11]\n      Local variable table:\n        [pc: 0, pc: 36] local: this index: 0 type: X\n      Local variable type table:\n        [pc: 0, pc: 36] local: this index: 0 type: X<T,V>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0824() throws Exception {
        this.runConformTest(true, new String[]{"X.java", "import java.io.Serializable;\n\npublic class X<T extends Serializable & Runnable, V extends T> {\n\tvoid foo(T t) {\n\t\t(this == null ? t : t).run();\n\t\t((V) t).run();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X<A, A>().foo(new A());\n\t}\n}\nclass A implements Serializable, Runnable {\n\tpublic void run() {\n\t\tSystem.out.print(\"AA\");\n\t}\n}\n"}, null, "AAAA", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6531075);
        String expectedOutput = "  // Method descriptor #17 (Ljava/io/Serializable;)V\n  // Signature: (TT;)V\n  // Stack: 1, Locals: 2\n  void foo(java.io.Serializable t);\n     0  aload_0 [this]\n     1  ifnonnull 8\n     4  aload_1 [t]\n     5  goto 9\n     8  aload_1 [t]\n     9  checkcast java.lang.Runnable [20]\n    12  invokeinterface java.lang.Runnable.run() : void [22] [nargs: 1]\n    17  aload_1 [t]\n    18  checkcast java.lang.Runnable [20]\n    21  invokeinterface java.lang.Runnable.run() : void [22] [nargs: 1]\n    26  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 17, line: 6]\n        [pc: 26, line: 7]\n      Local variable table:\n        [pc: 0, pc: 27] local: this index: 0 type: X\n        [pc: 0, pc: 27] local: t index: 1 type: java.io.Serializable\n      Local variable type table:\n        [pc: 0, pc: 27] local: this index: 0 type: X<T,V>\n        [pc: 0, pc: 27] local: t index: 1 type: T\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0825() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\n\npublic class X<T extends Serializable & Runnable, V extends T> {\n\tvoid foo(T t) {\n\t\tRunnable r1 = t;\n\t\tRunnable r2 = (this == null ? t : t);\n\t\tRunnable r3 = ((V) t);\n\t\t\n\t\tbar(t);\n\t\tbar(this == null ? t : t);\n\t\tbar((V)t);\n\t}\n\tvoid bar(Runnable r) {}\t\n\tpublic static void main(String[] args) {\n\t\tnew X<A, A>().foo(new A());\n\t}\n}\nclass A implements Serializable, Runnable {\n\tpublic void run() {\n\t\tSystem.out.println(\"AA\");\n\t}\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #17 (Ljava/io/Serializable;)V\n  // Signature: (TT;)V\n  // Stack: 2, Locals: 5\n  void foo(java.io.Serializable t);\n     0  aload_1 [t]\n     1  astore_2 [r1]\n     2  aload_0 [this]\n     3  ifnonnull 10\n     6  aload_1 [t]\n     7  goto 11\n    10  aload_1 [t]\n    11  astore_3 [r2]\n    12  aload_1 [t]\n    13  astore 4 [r3]\n    15  aload_0 [this]\n    16  aload_1 [t]\n    17  invokevirtual X.bar(java.lang.Runnable) : void [20]\n    20  aload_0 [this]\n    21  aload_0 [this]\n    22  ifnonnull 29\n    25  aload_1 [t]\n    26  goto 30\n    29  aload_1 [t]\n    30  invokevirtual X.bar(java.lang.Runnable) : void [20]\n    33  aload_0 [this]\n    34  aload_1 [t]\n    35  invokevirtual X.bar(java.lang.Runnable) : void [20]\n    38  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 2, line: 6]\n        [pc: 12, line: 7]\n        [pc: 15, line: 9]\n        [pc: 20, line: 10]\n        [pc: 33, line: 11]\n        [pc: 38, line: 12]\n      Local variable table:\n        [pc: 0, pc: 39] local: this index: 0 type: X\n        [pc: 0, pc: 39] local: t index: 1 type: java.io.Serializable\n        [pc: 2, pc: 39] local: r1 index: 2 type: java.lang.Runnable\n        [pc: 12, pc: 39] local: r2 index: 3 type: java.lang.Runnable\n        [pc: 15, pc: 39] local: r3 index: 4 type: java.lang.Runnable\n      Local variable type table:\n        [pc: 0, pc: 39] local: this index: 0 type: X<T,V>\n        [pc: 0, pc: 39] local: t index: 1 type: T\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0826() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\n  public <V1, V2 extends V1> void test(V1 p1, V2 p2) {}\n\t\n  public static void main(String[] args) {\n    XA a = new XA(){};\n    XB b = new XB(){};\n\n    X t1 = new X();\n    t1.test(a, b); //this gives an error but should be OK\n    \n    X<Object> t2 = new X<Object>();\n    t2.test(a, b); //this compiles OK\n    Zork z;\n  }\n}\n\ninterface XA {}\ninterface XB extends XA {}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tX t1 = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 9)\n\tX t1 = new X();\n\t           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 10)\n\tt1.test(a, b); //this gives an error but should be OK\n\t^^^^^^^^^^^^^\nType safety: The method test(Object, Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0827() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X<T> {\n  public <V1, V2 extends List<String>> void test(V1 p1, V2 p2) {}\n  public static void main(String[] args) {\n    XA a = new XA(){};\n    List<Object> b = null;\n    X t1 = new X();\n    t1.test(a, b); //this gives an error but should be OK\n    X<Object> t2 = new X<Object>();\n    t2.test(a, b); //this compiles OK\n  }\n}\ninterface XA {}\n\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tX t1 = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tX t1 = new X();\n\t           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 8)\n\tt1.test(a, b); //this gives an error but should be OK\n\t^^^^^^^^^^^^^\nType safety: The method test(Object, List) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 10)\n\tt2.test(a, b); //this compiles OK\n\t   ^^^^\nBound mismatch: The generic method test(V1, V2) of type X<T> is not applicable for the arguments (XA, List<Object>). The inferred type List<Object> is not a valid substitute for the bounded parameter <V2 extends List<String>>\n----------\n");
    }

    public void test0828() {
        this.runNegativeTest(new String[]{"X.java", "interface Transformable<T extends Transformable>\n{\n\tpublic T transform();\n}\ninterface Volume<V extends Volume> extends Transformable<V>\n{\n//\tpublic V transform();\n}\n@SuppressWarnings(\"null\")\npublic class X {\n\tvoid foo(){\n\t\tVolume v1 = null;\n\t\tVolume v2 = v1.transform();\n\t}\n\tvoid bar(){\n\t\tVolume<Volume> v1 = null;\n\t\tVolume v2 = v1.transform();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tinterface Transformable<T extends Transformable>\n\t                                  ^^^^^^^^^^^^^\nTransformable is a raw type. References to generic type Transformable<T> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tinterface Volume<V extends Volume> extends Transformable<V>\n\t                           ^^^^^^\nVolume is a raw type. References to generic type Volume<V> should be parameterized\n----------\n3. WARNING in X.java (at line 12)\n\tVolume v1 = null;\n\t^^^^^^\nVolume is a raw type. References to generic type Volume<V> should be parameterized\n----------\n4. WARNING in X.java (at line 13)\n\tVolume v2 = v1.transform();\n\t^^^^^^\nVolume is a raw type. References to generic type Volume<V> should be parameterized\n----------\n5. ERROR in X.java (at line 13)\n\tVolume v2 = v1.transform();\n\t            ^^^^^^^^^^^^^^\nType mismatch: cannot convert from Transformable to Volume\n----------\n6. WARNING in X.java (at line 16)\n\tVolume<Volume> v1 = null;\n\t       ^^^^^^\nVolume is a raw type. References to generic type Volume<V> should be parameterized\n----------\n7. WARNING in X.java (at line 17)\n\tVolume v2 = v1.transform();\n\t^^^^^^\nVolume is a raw type. References to generic type Volume<V> should be parameterized\n----------\n");
    }

    public void test0829() {
        this.runConformTest(new String[]{"X.java", "interface Transformable<T extends Transformable>\n{\n\tpublic T transform();\n}\ninterface Volume<V extends Volume> extends Transformable<V>\n{\n\tpublic V transform();\n}\npublic class X {\n\tvoid foo(){\n\t\tVolume v1 = null;\n\t\tVolume v2 = v1.transform();\n\t}\n\tvoid bar(){\n\t\tVolume<Volume> v1 = null;\n\t\tVolume v2 = v1.transform();\n\t}\n}\n"}, "");
    }

    public void test0830() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<T> {\n\tvoid foo(Object o) {\n\t\tboolean b = o instanceof X;\n\t\tX x = (X) o;\n\t\tX<String> xs = (X<String>)o;\n\t\tZork z;\n\t}\n\tvoid bar(ArrayList<String> al) {\n\t\tList l = (List) al;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tX x = (X) o;\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tX x = (X) o;\n\t       ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tX<String> xs = (X<String>)o;\n\t               ^^^^^^^^^^^^\nType safety: Unchecked cast from Object to X<String>\n----------\n4. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n5. WARNING in X.java (at line 10)\n\tList l = (List) al;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n6. WARNING in X.java (at line 10)\n\tList l = (List) al;\n\t         ^^^^^^^^^\nUnnecessary cast from ArrayList<String> to List\n----------\n7. WARNING in X.java (at line 10)\n\tList l = (List) al;\n\t          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test0831() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid foo(Object o1) {\n\t\tObject o2 = (List<String>) o1;\n\t\t\n\t\tfoo((List<String>)o2);\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tObject o2 = (List<String>) o1;\n\t            ^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to List<String>\n----------\n2. WARNING in X.java (at line 4)\n\tObject o2 = (List<String>) o1;\n\t            ^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object to List<String>\n----------\n3. WARNING in X.java (at line 6)\n\tfoo((List<String>)o2);\n\t    ^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to List<String>\n----------\n4. WARNING in X.java (at line 6)\n\tfoo((List<String>)o2);\n\t    ^^^^^^^^^^^^^^^^\nUnnecessary cast from Object to List<String>\n----------\n5. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0832() {
        this.runNegativeTest(new String[]{"X.java", "class C1<T> {\n\tclass C11 {\t}\n\tclass C12 {\n\t\tT t;\n\t\tC1<T>.C11[] m() {\n\t\t\tC1<T>.C11[] ts = (C1<T>.C11[]) new C1<?>.C11[5];\n\t\t\treturn ts;\n\t\t}\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tC1<T>.C11[] ts = (C1<T>.C11[]) new C1<?>.C11[5];\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from C1<?>.C11[] to C1<T>.C11[]\n----------\n2. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0833() {
        this.runConformTest(new String[]{"A.java", "class A<T1> {}\n", "B.java", "class B<T2> extends A<B<T2>.Inner> { class Inner {} }\n", "C.java", "class C { B<Integer> b; }\n"}, "");
        this.runConformTest(new String[]{"C.java", "class C { B<Integer> b; }\n"}, "", null, false, null);
    }

    public void test0834() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public static void main(String[] args) {\n        Set<Integer> set = new HashSet<Integer>();\n        set.add(42);\n        Collection<Number> collection;\n        collection = (Collection) set;\n        System.out.println(collection.iterator().next());\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tcollection = (Collection) set;\n\t             ^^^^^^^^^^^^^^^^\nType safety: The expression of type Collection needs unchecked conversion to conform to Collection<Number>\n----------\n2. WARNING in X.java (at line 7)\n\tcollection = (Collection) set;\n\t              ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0835() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid foo(List<String> ls) {\n\t\tArrayList<?> als = (ArrayList) ls;\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tArrayList<?> als = (ArrayList) ls;\n\t                    ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n2. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0836() {
        this.runConformTest(new String[]{"X.java", " import java.util.Iterator;\n import java.util.List;\n\n public class X<A> {\n\n interface Factory<T> {\n T invoke();\n\t}\n\n\tpublic static <E> Iterator<E> iterate(Iterable<E> iterable) {\n\t\treturn iterable.iterator();\n\t}\n\n\tpublic Factory<Iterator<? extends A>> factory(final Factory<? extends List<? extends A>> factory) {\n\t\treturn new Factory<Iterator<? extends A>>() {\n\t\t\tpublic Iterator<? extends A> invoke() {\n\t\t\t\t//String s = iterate(factory.invoke());\n\t\t\t\treturn iterate(factory.invoke());\n\t\t\t}\n\t\t};\n\t}\n}\n"}, "");
    }

    public void test0837() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tpublic void foo(List<? extends List<? extends Number>> l) {\n\t\tbar(l.get(0));\n\t\tswap(l.get(0));\n\t}\n\tvoid bar(String s) {}\n\tprivate static <T> void swap(List<T> l) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tbar(l.get(0));\n\t^^^\nThe method bar(String) in the type X is not applicable for the arguments (capture#1-of ? extends List<? extends Number>)\n----------\n");
    }

    public void test0838() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic class CClass<T extends AClass.BClass<T>> {\n\t}\n}\n", "AClass.java", "public interface AClass<X extends AClass> {\n\tpublic interface BClass<T extends BClass> extends AClass<T> {\n\t}\n}\n"}, "");
    }

    public void test0839() {
        this.runConformTest(new String[]{"com/test/Tester.java", "package com.test;\n\nimport com.test.TestClass.MyException;\n\npublic class Tester {\n\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tTestClass<String> test = new TestClass<String>();\n\t\t} catch (MyException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}", "com/test/TestClass.java", "package com.test;\n\npublic class TestClass<T> {\n\t\n\tpublic TestClass() throws MyException {\n\t\tthrow new MyException();\n\t}\n\n\tpublic static class MyException extends Exception {\n\t\t\n\t\tpublic MyException() {\n\t\t\tsuper();\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test0840() {
        this.runNegativeTest(new String[]{"generics/NodeList.java", "package generics;\npublic class NodeList<E> {\n    public class Cursor { }\n}", "generics/user/User.java", "package generics.user;\nimport generics.NodeList;\nimport generics.NodeList.Cursor;\npublic class User {\n    Cursor raw;\n    NodeList.Cursor rawQualified;\n    NodeList<String>.Cursor parameterized;\n\n    void foo() {\n        parameterized= rawQualified; //unchecked warning (OK)\n        rawQualified= parameterized;\n\n        parameterized= raw; //should just give unchecked warning, but errors\n        raw= parameterized; //should not error\n\n        raw= rawQualified; //should not error\n        rawQualified= raw;\n    }\n    Zork z;\n}"}, "----------\n1. WARNING in generics\\user\\User.java (at line 5)\n\tCursor raw;\n\t^^^^^^\nNodeList.Cursor is a raw type. References to generic type NodeList<E>.Cursor should be parameterized\n----------\n2. WARNING in generics\\user\\User.java (at line 6)\n\tNodeList.Cursor rawQualified;\n\t^^^^^^^^^^^^^^^\nNodeList.Cursor is a raw type. References to generic type NodeList<E>.Cursor should be parameterized\n----------\n3. WARNING in generics\\user\\User.java (at line 10)\n\tparameterized= rawQualified; //unchecked warning (OK)\n\t               ^^^^^^^^^^^^\nType safety: The expression of type NodeList.Cursor needs unchecked conversion to conform to NodeList<String>.Cursor\n----------\n4. WARNING in generics\\user\\User.java (at line 13)\n\tparameterized= raw; //should just give unchecked warning, but errors\n\t               ^^^\nType safety: The expression of type NodeList.Cursor needs unchecked conversion to conform to NodeList<String>.Cursor\n----------\n5. ERROR in generics\\user\\User.java (at line 19)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0841() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n  List<? extends Comparator> bar() {\n\t  List<? extends Comparator> l = foo();\n\t  return foo();\n  }\n  <T> List<T> foo() {\n\t  return null;\n  }\n}\n"}, "");
    }

    public void test0842() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tstatic <T> List<T> merge(List<? extends T> a, List<? extends T> b) {\n\t\treturn null;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tList<String> list1 = null;\n\t\tList<StringBuilder> list2 = null;\n\t\tList<? extends CharSequence> result = merge(list1, list2);\n\t\tList<? extends String> result2 = merge(list1, list2);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tList<? extends String> result2 = merge(list1, list2);\n\t                                 ^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Object&Serializable&CharSequence> to List<? extends String>\n----------\n");
    }

    public void test0843() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tstatic <T> List<T> merge(List<? extends T> a, List<? extends T> b) {\n\t\treturn null;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tList<String> list1 = null;\n\t\tList<StringBuilder> list2 = null;\n\t\tObject result3 = (List<? extends CharSequence>)merge(list1, list2);\n\t\tObject result4 = (List<? extends String>)merge(list1, list2);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tObject result3 = (List<? extends CharSequence>)merge(list1, list2);\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from List<Object&Serializable&CharSequence> to List<? extends CharSequence>\n----------\n2. ERROR in X.java (at line 12)\n\tObject result4 = (List<? extends String>)merge(list1, list2);\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object&Serializable&CharSequence> to List<? extends String>\n----------\n3. WARNING in X.java (at line 12)\n\tObject result4 = (List<? extends String>)merge(list1, list2);\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from List<Object&Serializable&CharSequence> to List<? extends String>\n----------\n");
    }

    public void test0844() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public Set< ? extends X> getModifiers()\n    {\n        return Collections.emptySet();\n    }\n}\n"}, "");
    }

    public void test0845() {
        this.runConformTest(new String[]{"Generic.java", "public class Generic<T> {\n\tpublic int size() {\n\t\treturn 0;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\tpublic void testList(ArrayList aList) {\n\t\taList.size();\n\t}\n\tpublic void testGeneric(Generic aGeneric) {\n\t\taGeneric.size();\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tpublic void testList(ArrayList aList) {\n\t                     ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n2. ERROR in X.java (at line 7)\n\tpublic void testGeneric(Generic aGeneric) {\n\t                        ^^^^^^^\nGeneric cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0846() {
        this.runConformTest(new String[]{"X.java", "import java.util.Collection;\npublic class X {\n\tvoid m() {\n\t\tCollection<? super Collection<? super Number>> col = null;\n\t\tjava.util.List<java.lang.Number> n = null;\n\t\tcol.add(n);\n\t}\n}\n"}, "");
    }

    public void test0847() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\n\npublic class X {\n\tvoid m() {\n\t\tCollection<? extends Collection<? super Number>> col = null;\n\t\tjava.util.List<java.lang.Number> n = null;\n\t\tcol.add(n);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tcol.add(n);\n\t    ^^^\nThe method add(capture#1-of ? extends Collection<? super Number>) in the type Collection<capture#1-of ? extends Collection<? super Number>> is not applicable for the arguments (List<Number>)\n----------\n");
    }

    public void test0848() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X<E> {\n\tpublic static <T> List<T> asList(T a) { return null; }\n\tCollection<? extends Number> asList= asList(1);\n\tList<Number> nums= (List<Number>) asList; // correct warning\n\tList<Number> numz= (LinkedList<Number>) asList; // type safety warning missing\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tList<Number> nums= (List<Number>) asList; // correct warning\n\t                   ^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Collection<capture#1-of ? extends Number> to List<Number>\n----------\n2. WARNING in X.java (at line 7)\n\tList<Number> numz= (LinkedList<Number>) asList; // type safety warning missing\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Collection<capture#2-of ? extends Number> to LinkedList<Number>\n----------\n3. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X<E> {\n\tCollection<? extends Number> asList= Arrays.asList(1, 2.2);\n\tList<Number> nums= (List<Number>) asList; // correct warning\n\tList<Number> numz= (LinkedList<Number>) asList; // type safety warning missing\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #14 ()V\n  // Stack: 6, Locals: 1\n  public X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [16]\n     4  aload_0 [this]\n     5  iconst_2\n     6  anewarray java.lang.Number [18]\n     9  dup\n    10  iconst_0\n    11  iconst_1\n    12  invokestatic java.lang.Integer.valueOf(int) : java.lang.Integer [20]\n    15  aastore\n    16  dup\n    17  iconst_1\n    18  ldc2_w <Double 2.2> [26]\n    21  invokestatic java.lang.Double.valueOf(double) : java.lang.Double [28]\n    24  aastore\n    25  invokestatic java.util.Arrays.asList(java.lang.Object[]) : java.util.List [33]\n    28  putfield X.asList : java.util.Collection [38]\n    31  aload_0 [this]\n    32  aload_0 [this]\n    33  getfield X.asList : java.util.Collection [38]\n    36  checkcast java.util.List [40]\n    39  putfield X.nums : java.util.List [42]\n    42  aload_0 [this]\n    43  aload_0 [this]\n    44  getfield X.asList : java.util.Collection [38]\n    47  checkcast java.util.LinkedList [44]\n    50  putfield X.numz : java.util.List [46]\n    53  return\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0849() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static <T, U extends T> T[] cast(U[] a) { return (T[]) a; }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tstatic <T, U extends T> T[] cast(U[] a) { return (T[]) a; }\n\t                                                 ^^^^^^^\nUnnecessary cast from U[] to T[]\n----------\n2. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0850() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    <T> T f(Object o) {\n\treturn (T) o; // OK\n    }\n\n    <U, T extends U> T g(Object o) {\n\treturn (T) o; // bug???\n    }\n\n    <U, T extends U> T h(Object o) {\n\treturn X.<T>castTo(o); // workaround\n    }\n\n    private static <T> T castTo(Object o) {\n\treturn (T) o;\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\treturn (T) o; // OK\n\t       ^^^^^\nType safety: Unchecked cast from Object to T\n----------\n2. WARNING in X.java (at line 7)\n\treturn (T) o; // bug???\n\t       ^^^^^\nType safety: Unchecked cast from Object to T\n----------\n3. WARNING in X.java (at line 15)\n\treturn (T) o;\n\t       ^^^^^\nType safety: Unchecked cast from Object to T\n----------\n4. ERROR in X.java (at line 17)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0851() {
        this.runNegativeTest(new String[]{"X.java", "interface Foo {}\ninterface Bar<T> {}\npublic class X {\n    Object m(Foo f) {\n        return (Bar<Object>)f;\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\treturn (Bar<Object>)f;\n\t       ^^^^^^^^^^^^^^\nType safety: Unchecked cast from Foo to Bar<Object>\n----------\n2. WARNING in X.java (at line 5)\n\treturn (Bar<Object>)f;\n\t       ^^^^^^^^^^^^^^\nUnnecessary cast from Foo to Bar<Object>\n----------\n3. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0852() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T extends Runnable, U extends T & Runnable>  T foo() { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T extends Runnable, U extends T & Runnable>  T foo() { return null; }\n\t                                   ^^^^^^^^\nCannot specify any additional bound Runnable when first bound is a type parameter\n----------\n");
    }

    public void test0853() {
        this.runConformTest(new String[]{"X.java", "public class X<C extends I> {\n\tvoid test(java.util.List<C> list) { list.get(0).notify(null); }\n}\ninterface I { Object notify(Object o); }"}, "");
    }

    public void test0854() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tField field = new Field();\n\t\tForm form = new Form(field);\n\t\tString result = form.getField().toString();\n\t\tSystem.out.print(result);\n\t}\n}", "Form.java", "public class Form {\n\tprivate final Field field;\n\tpublic Form(Field field) {\n\t\tthis.field = field;\n\t}\n\tpublic <T extends Field> T getField() {\n\t\treturn (T) field;\n\t}\n}", "Field.java", "public class Field {\n\t@Override\n\tpublic String toString() {\n\t\treturn \"SUCCESS\";\n\t}\n}"}, null, "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0855() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tFieldManager manager = new FieldManagerImpl();\n\t\tFieldMeta<FieldImpl> meta = new FieldMeta<FieldImpl>(manager);\n\t\tField<? extends Field> field = new FieldImpl(meta);\n\t\tFieldMeta<? extends Field> meta2 = field.getFieldMeta();\n\t\tSystem.out.print(meta2.getFieldManager() instanceof ExtFieldManager);\n\t}\n}", "FieldMeta.java", "public class FieldMeta<F extends Field> {\n\tprivate final FieldManager<F> fieldManager;\n\tpublic FieldMeta(FieldManager<F> fieldManager) {\n\t\tthis.fieldManager = fieldManager;\n\t}\n\tpublic <FB extends FieldManager<F>> FB getFieldManager() {\n\t\treturn (FB) fieldManager;\n\t}\n}", "FieldManagerImpl.java", "public class FieldManagerImpl extends FieldManager<FieldImpl> implements\n\tExtFieldManager<FieldImpl> {\n}", "FieldManager.java", "public abstract class FieldManager<F extends Field> {}", "FieldImpl.java", "public class FieldImpl extends Field<FieldImpl> {\n\tpublic FieldImpl(FieldMeta<FieldImpl> fieldMeta) {\n\t\tsuper(fieldMeta);\n\t}\n}", "Field.java", "public class Field<F extends Field> {\n\tprivate final FieldManager<F> fieldManager;\n\tprivate final FieldMeta<F> fieldMeta;\n\tpublic FieldMeta<F> getFieldMeta() {\n\t\treturn fieldMeta;\n\t}\n\tpublic Field(FieldMeta<F> fieldMeta) {\n\t\tthis.fieldMeta = fieldMeta;\n\t\tthis.fieldManager = fieldMeta.getFieldManager();\n\t}\n\tpublic FieldManager<F> getFieldManager() {\n\t\treturn fieldManager;\n\t}\n}", "ExtFieldManager.java", "public interface ExtFieldManager<F extends Field> {}"}, null, "true", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0856() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tstatic class MX<T> {\n\t\tT t = null;\n\t}\n\tstatic <T> T getT() {\n\t\treturn (new MX<T>()).t;\n\t}\n\tpublic static void test() {\n\t\tgetT().getClass(); // error: java.lang.Object cannot be dereferenced\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "", "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0857() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic <U, T extends U & Cloneable & Runnable> void m(T t) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic <U, T extends U & Cloneable & Runnable> void m(T t) {\n\t                         ^^^^^^^^^\nCannot specify any additional bound Cloneable when first bound is a type parameter\n----------\n");
    }

    public void test0858() {
        this.runConformTest(new String[]{"X.java", "interface ExtCloneable extends Cloneable {\n\tpublic ExtCloneable clone( String arg) throws CloneNotSupportedException;\n}\npublic class X {\n\tpublic static <V extends ExtCloneable> ExtCloneable cloneItem1( V value) throws CloneNotSupportedException {\n\t\treturn value.clone( \"\");\n\t}\n\tpublic static <V extends ExtCloneable> ExtCloneable cloneItem2( ExtCloneable value) throws CloneNotSupportedException {\n\t\treturn value.clone( \"\");\n\t}\n\tpublic static <V extends ExtCloneable> ExtCloneable cloneItem3( V value) throws CloneNotSupportedException {\n\t\treturn ((ExtCloneable)value).clone( \"\");\n\t}\n}"}, "");
    }

    public void test0859() {
        this.runConformTest(new String[]{"X.java", "import java.awt.Graphics2D;\nimport java.awt.Shape;\npublic class X<V extends DrawObject> {\n   /** Base object for wrapping */\n   protected V draw;\n   /**\n    * Draw the object with its attached text\n    * \n    * @param graphics the graphics object to draw into\n    */\n   public void draw( Graphics2D graphics ) {\n      draw.draw(graphics);\n   }\n}\nabstract class DrawObject implements Drawable {\n   protected void draw( Graphics2D graphics, Shape shape ) {\n   }\n}\ninterface Drawable {\n   void draw( Graphics2D graphics );\n}"}, "");
    }

    public void test0860() {
        this.runConformTest(new String[]{"A.java", "interface A {\n    A.I foo();\n    interface I { }\n}\n\ninterface B<T> extends A { }\n\ninterface C extends B<Object> {\n    C.J foo();\n    interface J extends B.I { }\n}\n"}, "");
    }

    public void test0861() {
        this.runConformTest(new String[]{"A.java", "interface A {\n    A.I foo();\n    interface I { }\n}\n\ninterface B<T> extends A { }\n\ninterface C extends B<Object> {\n    C.J foo();\n    interface J extends A.I { }\n}\n"}, "");
    }

    public void test0862() {
        this.runConformTest(new String[]{"A.java", "interface A {\n    interface I { }\n\n    A.I foo();\n}\n\ninterface B<T> extends A { \n    interface J extends B.I { }\n}\n\ninterface C extends B<Object> {\n    C.J foo();\n}\n"}, "");
    }

    public void test0863() {
        this.runConformTest(new String[]{"A.java", "interface A {\n    interface I { }\n\n    A.I foo();\n}\n\ninterface B<T> extends A { \n    interface J extends B.I { }\n}\n\ninterface C extends B<Object> {\n    B.J foo();\n}\n"}, "");
    }

    public void test0864() {
        this.runNegativeTest(new String[]{"A.java", "interface A {\n    interface I<T> { }\n\n    A.I<Object> foo();\n}\n\ninterface B<T> extends A { \n    interface J<E> extends B.I<E> { }\n}\n\ninterface C extends B<Object> {\n    C.J<Object> foo();\n    B<Object>.J<Object> bar();\n}\n"}, "----------\n1. ERROR in A.java (at line 13)\n\tB<Object>.J<Object> bar();\n\t^^^^^^^^^^^\nThe member type B<Object>.J cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type B<Object>\n----------\n");
    }

    public void test0865() {
        this.runConformTest(new String[]{"A.java", "class A {\n    interface I { }\n\n    A.I foo() { return null; }\n}\n\nclass B<T> extends A { \n    interface J extends B.I { }\n}\n\nclass C extends B<Object> {\n\t@Override\n    C.J foo() { return (B.J)super.foo(); }\n}\n"}, "");
    }

    public void test0866() {
        this.runConformTest(new String[]{"X.java", "import java.util.Collections;\nimport java.util.List;\n\npublic class X {\n  public interface Interface {\n\t  // nothing\n  }\n  public List<? extends Interface> field = Collections.emptyList();\n}\n"}, "");
    }

    public void test0867() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\nclass Foo {\n\n\tstatic <T extends Runnable> List<List<T>> foo1() {\n\t\treturn null;\n\t}\n\tstatic <T extends Runnable> void bar1(List<List<T>> l) {\n\t}\n\tstatic <T extends Runnable> List<T> foo2() {\n\t\treturn null;\n\t}\n\tstatic <T extends Runnable> void bar2(List<T> l) {\n\t}\n}\n\npublic class X {\n\n\t{\n\t\tList<List> o = Foo.foo1();\n\t\tFoo.bar1(o);\n\t}\n\t{\n\t\tList o = Foo.foo2();\n\t\tFoo.bar2(o);\n\t}\n\n}\n"}, "----------\n1. WARNING in X.java (at line 20)\n\tList<List> o = Foo.foo1();\n\t     ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in X.java (at line 20)\n" + (this.complianceLevel < 0x340000L ? "\tList<List> o = Foo.foo1();\n\t                   ^^^^\nThe method foo1() in the type Foo is not applicable for the arguments ()\n" : "\tList<List> o = Foo.foo1();\n\t               ^^^^^^^^^^\nType mismatch: cannot convert from List<List<Runnable>> to List<List>\n") + "----------\n" + "3. ERROR in X.java (at line 21)\n" + "\tFoo.bar1(o);\n" + "\t    ^^^^\n" + "The method bar1(List<List<T>>) in the type Foo is not applicable for the arguments (List<List>)\n" + "----------\n" + "4. WARNING in X.java (at line 24)\n" + "\tList o = Foo.foo2();\n" + "\t^^^^\n" + "List is a raw type. References to generic type List<E> should be parameterized\n" + "----------\n" + "5. WARNING in X.java (at line 25)\n" + "\tFoo.bar2(o);\n" + "\t^^^^^^^^^^^\n" + "Type safety: Unchecked invocation bar2(List) of the generic method bar2(List<T>) of type Foo\n" + "----------\n" + "6. WARNING in X.java (at line 25)\n" + "\tFoo.bar2(o);\n" + "\t         ^\n" + "Type safety: The expression of type List needs unchecked conversion to conform to List<Runnable>\n" + "----------\n");
    }

    public void test0868() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runConformTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.Iterator;\nimport java.io.Serializable;\nimport java.lang.Cloneable;\npublic class X<A extends Collection & Serializable > implements Collection {\n\tpublic int size() {\n\t\t// TODO Auto-generated method stub\n\t\treturn 0;\n\t}\n\tpublic boolean isEmpty() {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\tpublic boolean contains(Object arg0) {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\tpublic Iterator iterator() {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\tpublic Object[] toArray() {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\tpublic Object[] toArray(Object[] arg0) {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\tpublic boolean add(Object arg0) {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\tpublic boolean remove(Object arg0) {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\tpublic boolean containsAll(Collection arg0) {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\tpublic boolean addAll(Collection arg0) {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\tpublic boolean removeAll(Collection arg0) {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\tpublic boolean retainAll(Collection arg0) {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\tpublic void clear() {\n\t\t// TODO Auto-generated method stub\n\t\t\n\t}" + COLLECTION_RAW_IMPL_JRE8 + ITERABLE_RAW_IMPL_JRE8 + "}"}, "", null, true, null, options, null);
    }

    public void test0869() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Comparator;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass<?> c = Comparator.class;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0870() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tpublic interface I<T> {\n\t        public <S extends T> void foo(List<S> ls);\n\t}\n\n\tpublic abstract class A<T> implements I<T> {\n\t        public <S extends T> void foo(List<S> ls) { }\n\t}\n\n\tpublic class C<T> extends A<List<T>> { }\n}\n"}, "");
    }

    public void test0871() {
        this.runConformTest(new String[]{"Lister.java", "interface Lister<BeanT, PropT, PackT> {\n\tvoid endPacking(PackT p, BeanT b, Accessor<BeanT, PropT> acc);\n\n\tstatic class IDRefs<BeanT, PropT> implements\n\t\t\tLister<BeanT, PropT, IDRefs<BeanT, PropT>.Pack> {\n\t\tpublic void endPacking(Pack p, BeanT b, Accessor<BeanT, PropT> acc) {\n\t\t}\n\n\t\tprivate class Pack {\n\t\t}\n\t}\n}\n\nclass Accessor<BeanT, PropT> {\n}\n"}, "");
    }

    public void test0872() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.PrintStream;\n\npublic class X {\n\tpublic void foo1(){\n\t\tM1<X> m = new M1<X>();\n\t\tM1<X>.N1<X> n = m.new N1<X>();\n\t}\n\tstatic class M1<T> {\n\t\tclass N1<U> {\n\t\t}\n\t}\n\tpublic void foo2(){\n\t\tM2<X> m = new M2<X>();\n\t\tM2<X>.N2<X> n = m.new N2<X>();\n\t}\n\tclass M2<T> {\n\t\tclass N2<U> {\n\t\t}\n\t}\n\tpublic void foo3(){\n\t\tM3<X> m = new M3<X>();\n\t\tM3<X>.N3<X> n = m.new N3<X>();\n\t}\n\tclass M3<T> {\n\t\tstatic class N3<U> {\n\t\t}\n\t}\n\tpublic void foo4(){\n\t\tM4<X> m = new M4<X>();\n\t\tM4<X>.N4<X> n = m.new N4<X>();\n\t}\n\tstatic class M4<T> {\n\t\tstatic class N4<U> {\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 22)\n\tM3<X>.N3<X> n = m.new N3<X>();\n\t^^^^^^^^\nThe member type X.M3<X>.N3 cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type X.M3<X>\n----------\n2. ERROR in X.java (at line 25)\n\tstatic class N3<U> {\n\t             ^^\nThe member type N3 cannot be declared static; static types can only be declared in static or top level types\n----------\n3. ERROR in X.java (at line 30)\n\tM4<X>.N4<X> n = m.new N4<X>();\n\t^^^^^^^^\nThe member type X.M4<X>.N4 cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type X.M4<X>\n----------\n");
    }

    public void test0873() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    static class XMap {\n        XEntry[] table;\n        static class XEntry {}    \n        void foo() {\n            XEntry e = table[0];\n        }\t\n    }        \n}\n"}, "");
    }

    public void test0874() throws Exception {
        this.runConformTest(new String[]{"X.java", "class A {}\nabstract class B<T> {\n    public B<T> label(String s) { return this; }\n}\nfinal class C extends B<A> {\n    public static C instance(String s) { return new C(); }\n    @Override public String toString() {\n    \treturn \"SUCCESS\";\n    }\n}\npublic class X {\n    public static void main(String[] args) {\n        C c = (C)C.instance(\"X\").label(\"Y\");\n        System.out.println(c.toString());\n    }\n}\n"}, "SUCCESS");
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  ldc <String \"X\"> [16]\n     2  invokestatic C.instance(java.lang.String) : C [17]\n     5  ldc <String \"Y\"> [23]\n     7  invokevirtual C.label(java.lang.String) : B [25]\n    10  checkcast C [18]\n    13  astore_1 [c]\n    14  getstatic java.lang.System.out : java.io.PrintStream [29]\n    17  aload_1 [c]\n    18  invokevirtual C.toString() : java.lang.String [35]\n    21  invokevirtual java.io.PrintStream.println(java.lang.String) : void [39]\n    24  return\n      Line numbers:\n        [pc: 0, line: 13]\n        [pc: 14, line: 14]\n        [pc: 24, line: 15]\n      Local variable table:\n        [pc: 0, pc: 25] local: args index: 0 type: java.lang.String[]\n        [pc: 14, pc: 25] local: c index: 1 type: C\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0875() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\n\tpublic static class DatabaseObject {}\n\tpublic static class ObjectFormUI<T extends DatabaseObject> {}\n\tprivate static final Map<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>> uiMap = new HashMap<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>>();\n\n\tpublic static <T extends DatabaseObject> Class<? extends ObjectFormUI<T>> getUI(\n\t\t\tClass<T> persistentClass) {\n\t\treturn null != null \n\t\t\t? uiMap.get(persistentClass)\n\t\t\t: (Class<? extends ObjectFormUI<T>>) uiMap.get(persistentClass);\n\t}\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. WARNING in X.java (at line 6)\n\tprivate static final Map<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>> uiMap = new HashMap<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>>();\n\t                                                                          ^^^^^^^^^^^^\nX.ObjectFormUI is a raw type. References to generic type X.ObjectFormUI<T> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tprivate static final Map<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>> uiMap = new HashMap<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>>();\n\t                                                                                                                                                              ^^^^^^^^^^^^\nX.ObjectFormUI is a raw type. References to generic type X.ObjectFormUI<T> should be parameterized\n----------\n3. ERROR in X.java (at line 10)\n\treturn null != null \n\t\t\t? uiMap.get(persistentClass)\n\t\t\t: (Class<? extends ObjectFormUI<T>>) uiMap.get(persistentClass);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#4-of ? extends X.ObjectFormUI> to Class<? extends X.ObjectFormUI<T>>\n----------\n4. WARNING in X.java (at line 12)\n\t: (Class<? extends ObjectFormUI<T>>) uiMap.get(persistentClass);\n\t  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Class<capture#2-of ? extends X.ObjectFormUI> to Class<? extends X.ObjectFormUI<T>>\n----------\n" : "----------\n1. WARNING in X.java (at line 6)\n\tprivate static final Map<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>> uiMap = new HashMap<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>>();\n\t                                                                          ^^^^^^^^^^^^\nX.ObjectFormUI is a raw type. References to generic type X.ObjectFormUI<T> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tprivate static final Map<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>> uiMap = new HashMap<Class<? extends DatabaseObject>, Class<? extends ObjectFormUI>>();\n\t                                                                                                                                                              ^^^^^^^^^^^^\nX.ObjectFormUI is a raw type. References to generic type X.ObjectFormUI<T> should be parameterized\n----------\n3. ERROR in X.java (at line 11)\n\t? uiMap.get(persistentClass)\n\t  ^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#1-of ? extends X.ObjectFormUI> to Class<? extends X.ObjectFormUI<T>>\n----------\n4. WARNING in X.java (at line 12)\n\t: (Class<? extends ObjectFormUI<T>>) uiMap.get(persistentClass);\n\t  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Class<capture#2-of ? extends X.ObjectFormUI> to Class<? extends X.ObjectFormUI<T>>\n----------\n");
    }

    public void test0876() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid foo(){\n\t\tClass<Class<Object>> cco = null;\n\t\tClass<Class> cc = cco; // ko\n\t\tClass<Class<Object>> cco2 = cc; // ko\n\t\t\n\t\tClass<? extends Class<Object>> ceco = null;\n\t\tClass<? extends Class> cec = ceco; // ok\n\t\tClass<? extends Class<Object>> ceco2 = cec; // ko\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tClass<Class> cc = cco; // ko\n\t      ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tClass<Class> cc = cco; // ko\n\t                  ^^^\nType mismatch: cannot convert from Class<Class<Object>> to Class<Class>\n----------\n3. ERROR in X.java (at line 6)\n\tClass<Class<Object>> cco2 = cc; // ko\n\t                            ^^\nType mismatch: cannot convert from Class<Class> to Class<Class<Object>>\n----------\n4. WARNING in X.java (at line 9)\n\tClass<? extends Class> cec = ceco; // ok\n\t                ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n5. ERROR in X.java (at line 10)\n\tClass<? extends Class<Object>> ceco2 = cec; // ko\n\t                                       ^^^\nType mismatch: cannot convert from Class<capture#2-of ? extends Class> to Class<? extends Class<Object>>\n----------\n");
    }

    public void test0877() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\t<T extends Class> void bar(T t) {\n\t\tClass<Object> c = t; // ok - unchecked\n\t}\n\t<T extends Class> void bar2(List<? extends T> let) {\n\t\tClass<Object> c = let.get(0); // ok - unchecked\n\t}\n\tvoid bar3(List<? extends Class> lec) {\n\t\tClass<Object> c = lec.get(0); // ok - unchecked\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\t<T extends Class> void bar(T t) {\n\t           ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\t<T extends Class> void bar(T t) {\n\t           ^^^^^\nThe type parameter T should not be bounded by the final type Class. Final types cannot be further extended\n----------\n3. WARNING in X.java (at line 4)\n\tClass<Object> c = t; // ok - unchecked\n\t                  ^\nType safety: The expression of type T needs unchecked conversion to conform to Class<Object>\n----------\n4. WARNING in X.java (at line 6)\n\t<T extends Class> void bar2(List<? extends T> let) {\n\t           ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n5. WARNING in X.java (at line 6)\n\t<T extends Class> void bar2(List<? extends T> let) {\n\t           ^^^^^\nThe type parameter T should not be bounded by the final type Class. Final types cannot be further extended\n----------\n6. WARNING in X.java (at line 7)\n\tClass<Object> c = let.get(0); // ok - unchecked\n\t                  ^^^^^^^^^^\nType safety: The expression of type capture#1-of ? extends T needs unchecked conversion to conform to Class<Object>\n----------\n7. WARNING in X.java (at line 9)\n\tvoid bar3(List<? extends Class> lec) {\n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n8. WARNING in X.java (at line 10)\n\tClass<Object> c = lec.get(0); // ok - unchecked\n\t                  ^^^^^^^^^^\nType safety: The expression of type capture#2-of ? extends Class needs unchecked conversion to conform to Class<Object>\n----------\n9. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0878() throws Exception {
        this.runConformTest(new String[]{"X.java", "class A {}\nclass D extends A {}\nabstract class B<T> {\n    public T label(String s) { return null; }\n}\nfinal class C extends B<A> {\n    public static C instance(String s) { return new C(); }\n    @Override public String toString() {\n    \treturn \"SUCCESS\"; \n    }\n}\npublic class X {\n    public static void main(String[] args) {\n        D d = (D)C.instance(\"X\").label(\"Y\");\n        System.out.println(d);\n    }\n}\n"}, "null");
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  ldc <String \"X\"> [16]\n     2  invokestatic C.instance(java.lang.String) : C [17]\n     5  ldc <String \"Y\"> [23]\n     7  invokevirtual C.label(java.lang.String) : java.lang.Object [25]\n    10  checkcast D [29]\n    13  astore_1 [d]\n    14  getstatic java.lang.System.out : java.io.PrintStream [31]\n    17  aload_1 [d]\n    18  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [37]\n    21  return\n      Line numbers:\n        [pc: 0, line: 14]\n        [pc: 14, line: 15]\n        [pc: 21, line: 16]\n      Local variable table:\n        [pc: 0, pc: 22] local: args index: 0 type: java.lang.String[]\n        [pc: 14, pc: 22] local: d index: 1 type: D\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test0879() {
        this.runConformTest(new String[]{"X.java", "public class X<V, R> {\n\n    private class InnerClass1 {\n            void foo() {\n                    X<V, R> c = X.this;\n            }\n    }\n}\n"}, "");
    }

    public void test0880() {
        this.runNegativeTest(new String[]{"X.java", "class Foo {\n\tstatic <T, U extends java.util.List<T>> U foo() {\n\t\treturn null;\n\t}\n}\n\npublic class X {\n\t{\n\t\tString s = (String) Foo.foo();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tString s = (String) Foo.foo();\n\t           ^^^^^^^^^^^^^^^^^^\nCannot cast from List<Object> to String\n----------\n");
    }

    public void test0881() {
        this.runNegativeTest(new String[]{"X.java", "class Foo {\n\tstatic <T, U extends java.util.List<U>> U foo() {\n\t\treturn null;\n\t}\n}\n\npublic class X {\n\t{\n\t\tString s = (String) Foo.foo();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tString s = (String) Foo.foo();\n\t           ^^^^^^^^^^^^^^^^^^\nCannot cast from List<List<U>> to String\n----------\n");
    }

    public void test0882() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tstatic <U extends List<U>> U foo(U u) {\n\t\tString s = (String) foo(u);\n\t\treturn u;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tString s = (String) foo(u);\n\t           ^^^^^^^^^^^^^^^\nCannot cast from U to String\n----------\n");
    }

    public void test0883() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tstatic <U extends List<U>> U foo(U u) {\n\t\tList<U> listu = null;\n\t\tString s = (String)foo(listu);\n\t\treturn u;\n\t}\n\tstatic <V extends List<V>> V bar(V v) {\n\t\tList<V> listv = null;\n\t\tString s = (String)foo(listv);\n\t\treturn v;\n\t}\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 6)\n\tString s = (String)foo(listu);\n\t           ^^^^^^^^^^^^^^^^^^\nCannot cast from List<U> to String\n----------\n2. ERROR in X.java (at line 6)\n\tString s = (String)foo(listu);\n\t                   ^^^\nBound mismatch: The generic method foo(U) of type X is not applicable for the arguments (List<U>). The inferred type List<U> is not a valid substitute for the bounded parameter <U extends List<U>>\n----------\n3. ERROR in X.java (at line 11)\n\tString s = (String)foo(listv);\n\t           ^^^^^^^^^^^^^^^^^^\nCannot cast from List<V> to String\n----------\n4. ERROR in X.java (at line 11)\n\tString s = (String)foo(listv);\n\t                   ^^^\nBound mismatch: The generic method foo(U) of type X is not applicable for the arguments (List<V>). The inferred type List<V> is not a valid substitute for the bounded parameter <U extends List<U>>\n----------\n" : "----------\n1. ERROR in X.java (at line 6)\n\tString s = (String)foo(listu);\n\t                   ^^^\nBound mismatch: The generic method foo(U) of type X is not applicable for the arguments (List<U>). The inferred type List<U> is not a valid substitute for the bounded parameter <U extends List<U>>\n----------\n2. ERROR in X.java (at line 11)\n\tString s = (String)foo(listv);\n\t                   ^^^\nBound mismatch: The generic method foo(U) of type X is not applicable for the arguments (List<V>). The inferred type List<V> is not a valid substitute for the bounded parameter <U extends List<U>>\n----------\n");
    }

    public void test0884() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X<C extends X<C>> {\n\tpublic static <T extends X<T>> T getDefault(Class<T> clz) {\n\t\treturn null;\n\t}\n\n\tpublic Object getDefault() {\n\t\tString s = getClass();\n\t\treturn (String) getDefault(getClass());\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tString s = getClass();\n\t           ^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#1-of ? extends X> to String\n----------\n2. ERROR in X.java (at line 8)\n\treturn (String) getDefault(getClass());\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from X to String\n----------\n3. WARNING in X.java (at line 8)\n\treturn (String) getDefault(getClass());\n\t                ^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation getDefault(Class<capture#2-of ? extends X>) of the generic method getDefault(Class<T>) of type X<C>\n----------\n");
    }

    public void test0885() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static <C extends Number, A extends C & Comparable<C>> int m(\n\t\t\tA comparableNumberObj) {\n\t\treturn comparableNumberObj.compareTo(comparableNumberObj);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static <C extends Number, A extends C & Comparable<C>> int m(\n\t                                               ^^^^^^^^^^\nCannot specify any additional bound Comparable<C> when first bound is a type parameter\n----------\n");
    }

    public void test0886() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.source", "1.4");
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tvoid test() {\n\t\t\"Hello\".compareTo((Object) \"Hello\");\n\t}\n}\n"}, null, customOptions, "", "", null, new AbstractRegressionTest.JavacTestOptions("-source 1.4 -Xlint:-options"));
    }

    public void test0887() {
        this.runNegativeTest(new String[]{"Bar.java", "class Foo<T> {}\npublic class Bar<X extends Foo<Foo<? super X>>>{\n    Bar(X x){\n        Foo<? super X> f = x;\n    }\n}\n"}, "----------\n1. ERROR in Bar.java (at line 4)\n\tFoo<? super X> f = x;\n\t                   ^\nType mismatch: cannot convert from X to Foo<? super X>\n----------\n");
    }

    public void test0888() {
        this.runNegativeTest(new String[]{"Bar.java", "class Foo<T> {}\npublic class Bar<X extends Foo<Foo<? super X>>>{\n    Bar(X x){\n        Foo<? extends X> f = x;\n    }\n}\n"}, "----------\n1. ERROR in Bar.java (at line 4)\n\tFoo<? extends X> f = x;\n\t                     ^\nType mismatch: cannot convert from X to Foo<? extends X>\n----------\n");
    }

    public void test0889() {
        this.runConformTest(true, new String[]{"Test.java", "import java.util.*;\n\nclass Group<E extends Comparable<? super E>> extends ArrayList<E> implements\n\t\tComparable<Group<? extends E>> {\n\tpublic int compareTo(Group<? extends E> o) {\n\t\treturn 0;\n\t}\n}\n\nclass Sequence<E extends Comparable<? super E>> extends TreeSet<E> implements\n\t\tComparable<Sequence<? extends E>> {\n\tpublic int compareTo(Sequence<? extends E> o) {\n\t\treturn 0;\n\t}\n}\n\nclass Test<T extends Comparable<? super T>> {\n\t<C extends Collection<T>> void foo(SortedSet<? extends C> setToCheck,\n\t\t\tSortedSet<? extends C> validSet) {\n\t}\n\n\tpublic void containsCombination(SortedSet<Group<T>> groups,\n\t\t\tSortedSet<Sequence<T>> sequences) {\n\t\tfoo(groups, sequences);\n\t}\n}\n"}, null, "", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0890() {
        this.runConformTest(new String[]{"Simple.java", "class A<T extends A<T>> {}\nclass B extends A<B> {}\nclass C extends B {}\nclass D<T> {}\n\npublic class Simple {\n\t<T extends A<T>, S extends T> D<T> m(S s) {\n\t\tC c = null;\n\t\tD<B> d = m(c);\n\t\treturn null;\n\t}\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test0891() {
        String xSource = "interface Function<A, B> {\n\tB apply(A x);\n}\nclass Id<A> implements Function<A, A> {\n\tpublic A apply(A x) {\n\t\treturn x;\n\t}\n}\nclass Test {\n\t<A> Id<A> identity() {\n\t\treturn new Id<A>();\n\t}\n\n\t<B> B applyToString(Function<String, B> f) {\n\t\treturn f.apply(\"abc\");\n\t}\n\tvoid test() {\n\t\tString s = applyToString(identity());\n\t}\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"Test.java", xSource}, "----------\n1. ERROR in Test.java (at line 18)\n\tString s = applyToString(identity());\n\t           ^^^^^^^^^^^^^\nThe method applyToString(Function<String,B>) in the type Test is not applicable for the arguments (Id<Object>)\n----------\n");
        } else {
            this.runConformTest(new String[]{"Test.java", xSource});
        }
    }

    public void test0892() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tC2 c2 = null;\n\t\tC3 c3 = null;\n\t\tObject oc1 = m1(c2, c3).new C1Member();\n\t}\n\n\tpublic static <T> T m1(T t1, T t2) {\n\t\treturn null;\n\t}\n\n\tclass C1 {}\n\tinterface I1 {}\n\tclass C2 extends C1 implements I1 {}\n\tclass C3 extends C1 implements I1 {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tObject oc1 = m1(c2, c3).new C1Member();\n\t                            ^^^^^^^^\nX.C1&X.I1.C1Member cannot be resolved to a type\n----------\n");
    }

    public void test0893() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic String foo;\n\n\tpublic static void main(String[] args) {\n\t\tC2 c2 = null;\n\t\tC3 c3 = null;\n\t\t// method access\n\t\tm1(c2, c3).c1m1();\n\t\tm1(c2, c3).i1m1();\n\t\tm1(c2, c3).i2m1();\n\n\t\t// field access\n\t\tint ic1 = m1(c2, c3).c1f1;\n\t\tint ii1 = m1(c2, c3).i1f1;\n\t\tint ii2 = m1(c2, c3).i2f1;\n\t\n\t\t// member type access\n\t\tObject oc1 = m1(c2, c3).new C1Member();\n\t\tObject oi1 = m1(c2, c3).new I1Member(); \n\t\tObject oi2 = m1(c2, c3).new I2Member();\n\t}\n\n\tpublic static <T> T m1(T t1, T t2) {\n\t\treturn null;\n\t}\n\n\tclass C1 {\n\t\tvoid c1m1() {}\n\t\tint c1f1 = 0;\n\t\tclass C1Member {}\n\t}\n\n\tinterface I1 {\n\t\tvoid i1m1();\n\t\tint i1f1 = 1;\n\t\tclass I1Member {}\n\t}\n\n\tinterface I2 {\n\t\tvoid i2m1();\n\t\tint i2f1 = 2;\n\t\tclass I2Member {}\n\t}\n\n\tclass C2 extends C1 implements I1, I2 {\n\t\tpublic void i1m1() {\n\t\t}\n\t\tpublic void i2m1() {\n\t\t}\n\t}\n\n\tclass C3 extends C1 implements I1, I2 {\n\t\tpublic void i1m1() {\n\t\t}\n\t\tpublic void i2m1() {\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 14)\n\tint ii1 = m1(c2, c3).i1f1;\n\t                     ^^^^\nThe static field X.I1.i1f1 should be accessed in a static way\n----------\n2. WARNING in X.java (at line 15)\n\tint ii2 = m1(c2, c3).i2f1;\n\t                     ^^^^\nThe static field X.I2.i2f1 should be accessed in a static way\n----------\n3. ERROR in X.java (at line 19)\n\tObject oi1 = m1(c2, c3).new I1Member(); \n\t             ^^^^^^^^^^\nIllegal enclosing instance specification for type X.I1.I1Member\n----------\n4. ERROR in X.java (at line 20)\n\tObject oi2 = m1(c2, c3).new I2Member();\n\t             ^^^^^^^^^^\nIllegal enclosing instance specification for type X.I2.I2Member\n----------\n");
    }

    public void test0894() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n        static class C1 {\n                void c1m1() {\n                        System.out.print(\"[c1m1]\");\n                }\n        }\n        static interface I {}\n        static class C2 extends C1 implements I {}\n        static class C3 extends C1 implements I {}\n\n        public <T> T m1(T t1, T t2) {\n                return t1;\n        }\n\n        public <T extends C1 & I> void test(C2 c2, C3 c3, T t) {\n                m1(c2, c3).c1m1(); // 1\n                t.c1m1(); // 2\n                (t != null ? c2 : c3).c1m1(); // 3\n        }\n\n        public static void main(String... args) {\n                X x = new X();\n                x.test(new C2(), new C3(), new C2()); // 4\n                System.out.println();\n        }\n}\n"}, "", "[c1m1][c1m1][c1m1]", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0895() {
        if (this.complianceLevel < 0x330000L) {
            this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic class X {\n    Object o = new <Object> I() {};\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new <Object> I() {};\n\t           ^^^^^^^^^^^^^^^^^^^\nThe constructor Object() of type Object is not generic; it cannot be parameterized with arguments <Object>\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic class X {\n    Object o = new <Object> I() {};\n}\n", "Y.java", "class Y extends Zork {}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tObject o = new <Object> I() {};\n\t                ^^^^^^\nUnused type arguments for the non generic constructor Object() of type Object; it should not be parameterized with arguments <Object>\n----------\n----------\n1. ERROR in Y.java (at line 1)\n\tclass Y extends Zork {}\n\t                ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0896() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tinterface I {\t\tvoid f(); \t}\n\tinterface J {\t\tvoid g(); }\n\n\tstatic class A implements I, J {\n\t\tpublic void f() {\tSystem.out.print(\"[A#f()]\");}\n\t\tpublic void g() {\tSystem.out.print(\"[A#g()]\");}\n\t}\n\n\tstatic class B implements J, I {\n\t\tpublic void f() {\tSystem.out.print(\"[B#f()]\");}\n\t\tpublic void g() {\tSystem.out.print(\"[B#g()]\");}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tf(true, new A(), new B());\n\t\tf(false, new A(), new B());\n\t\tSystem.out.println();\n\t}\n\n\tstatic void f(boolean cond, A a, B b) {\n\t\t(cond ? a : b).f();\n\t\t(cond ? a : b).g();\n\t}\n}\n"}, "", "[A#f()][A#g()][B#f()][B#g()]", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0897() {
        this.runConformTest(new String[]{"Test.java", "interface I { }\nclass X { }\nclass A extends X implements I { }\nclass B extends X implements I { }\npublic class Test {\n    void test(A a, B b) {\n\tX x = (a.hashCode() == b.hashCode()) ? a : b;\n    }\n}\n\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0898() {
        this.runConformTest(new String[]{"X.java", "interface I1 {\n\tvoid i1();\n}\nclass G1<T extends I1> {\n\tT get() {\n\t\treturn null;\n\t}\n}\ninterface I2 {\n\tvoid i2();\n}\npublic class X {\n\tvoid f1(G1<?> g1) {\n\t\tg1.get().i1();\n\t}\n\tvoid f2(G1<? extends I2> g1) {\n\t\tg1.get().i1();\n\t\tg1.get().i2();\n\t}\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0899() {
        this.runConformTest(new String[]{"A.java", "public class A<T extends A<T>> extends SomeArbitraryClass<T> {\n  public static class B {\n    private C c;\n    protected void set(C val) {\n      c = val;\n    }\n    protected class C {\n    }\n  }\n}", "C.java", "public class C {\n  \n  public C() {\n    //do nothing\n  }\n  \n}", "ObjThatExtendsB.java", "public class ObjThatExtendsB extends A.B {\n  protected void doSomeSetting() {\n    super.set(new ObjThatExtendsC());\n  }\n  protected class ObjThatExtendsC extends C {\n  }\n}", "ObjThatExtendsC.java", "public class ObjThatExtendsC extends C {\n  public ObjThatExtendsC() {\n    //do nothing\n  }\n}", "SomeArbitraryClass.java", "public class SomeArbitraryClass<T extends SomeArbitraryClass<T>> {\n  public SomeArbitraryClass() {\n    //do nothing\n  }\n}"}, "");
    }

    public void test0900() {
        this.runNegativeTest(new String[]{"X.java", "public class X<R> {\n\tstatic interface Interface extends Comparable<String> {}\n\n\tstatic final class Implements implements Interface {\n\t\tpublic int compareTo(String o) {\n\t\t\treturn 0;\n\t\t}\n\t}\n\n\tvoid method() {\n\t\t((Comparable<R>) new Implements()).toString();\n\t\t((Comparable) new Implements()).toString();\n\t\t((Comparable<?>) new Implements()).toString();\n\t\t((Comparable<? extends String>) new Implements()).toString();\n\t\t((Comparable<? super String>) new Implements()).toString();\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\t((Comparable<R>) new Implements()).toString();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X.Implements to Comparable<R>\n----------\n2. WARNING in X.java (at line 12)\n\t((Comparable) new Implements()).toString();\n\t  ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n3. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0901() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static <T> T foo(T p1, T p2) {\n        return p1;\n    }\n    static Object[] bar(int[] i, float[] f) {\n        return foo(i, f);\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\treturn foo(i, f);\n\t       ^^^^^^^^^\nType mismatch: cannot convert from Object&Serializable&Cloneable to Object[]\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0902() {
        this.runConformTest(new String[]{"I.java", "public interface I<U extends J<? extends I<U>>> {\n}", "J.java", "public interface J<T extends I<? extends J<T>>> {\n}", "CI.java", "class CI<U extends CJ<T, U> & J<T>,\n\t\t\tT extends CI<U, T> & I<U>>\n\timplements I<U> {\n}", "CJ.java", "class CJ<T extends CI<U, T> & I<U>,\n\t\t\tU extends CJ<T, U> & J<T>>\n\timplements J<T> {\n}"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0903() {
        this.runConformTest(new String[]{"X.java", "interface I<T extends J<T,U>, U extends I<T,U>> {\n    // empty\n}\ninterface J<T extends J<T,U>, U extends I<T,U>> {\n    // empty\n}\nfinal class Y<T, U> extends X<T, U> implements I<X<T, U>, Y<T, U>> {\n    // empty\n}\nabstract class X<T, U> implements J<X<T, U>, Y<T, U>> {\n    // empty\n}\n"}, "");
    }

    public void test0904() {
        this.runConformTest(new String[]{"X.java", "interface I<T extends J<T,U>, U extends I<T,U>> {\n    // empty\n}\ninterface J<T extends J<T,U>, U extends I<T,U>> {\n    // empty\n}\nabstract class X<T, U> implements J<X<T, U>, Y<T, U>> {\n    // empty\n}\nfinal class Y<T, U> extends X<T, U> implements I<X<T, U>, Y<T, U>> {\n    // empty\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0905() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n \nclass X {\n    void foo(List<? super Object[]> p) {\n        p.add(new Object[0]);\n    }\n}"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0906() {
        this.runNegativeTest(new String[]{"X.java", "interface I<V> {\n    // empty\n}         \npublic class X implements I {\n    I<Integer> x1 = (I<Integer>) (X) null;\n    I<Integer> x2 = (I<Integer>) new X();\n    I<Integer> x3 = (I<Integer>) null;\n    X x4 = (X) (I<Integer>) null;\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tpublic class X implements I {\n\t                          ^\nI is a raw type. References to generic type I<V> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tI<Integer> x1 = (I<Integer>) (X) null;\n\t                ^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X to I<Integer>\n----------\n3. WARNING in X.java (at line 5)\n\tI<Integer> x1 = (I<Integer>) (X) null;\n\t                ^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from X to I<Integer>\n----------\n4. WARNING in X.java (at line 5)\n\tI<Integer> x1 = (I<Integer>) (X) null;\n\t                             ^^^^^^^^\nUnnecessary cast from null to X\n----------\n5. WARNING in X.java (at line 6)\n\tI<Integer> x2 = (I<Integer>) new X();\n\t                ^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X to I<Integer>\n----------\n6. WARNING in X.java (at line 6)\n\tI<Integer> x2 = (I<Integer>) new X();\n\t                ^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from X to I<Integer>\n----------\n7. WARNING in X.java (at line 7)\n\tI<Integer> x3 = (I<Integer>) null;\n\t                ^^^^^^^^^^^^^^^^^\nUnnecessary cast from null to I<Integer>\n----------\n8. WARNING in X.java (at line 8)\n\tX x4 = (X) (I<Integer>) null;\n\t           ^^^^^^^^^^^^^^^^^\nUnnecessary cast from null to I<Integer>\n----------\n");
    }

    public void test0907() {
        this.runConformTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.Collections;\npublic class X<T extends X<T, V>, V> {\n    public void foo() {\n        Y o = (new Z<Object>()).<Y, double[]> bar(Collections\n                .singleton(new Y()));\n        o.toString();\n    }\n}\nclass Y extends X<Y, double[]> {\n    // empty\n}\nclass Z<V> {\n    public <U extends X<U, W>, W extends V> U bar(Collection<U> c) {\n        return null;\n    }\n}\n"}, "");
    }

    public void test0908() {
        this.runConformTest(new String[]{"X.java", "public abstract class X {\n    protected <T> void foo(Class<? extends T> clazz) {\n        Class<? extends T> l = clazz.isInterface() ? bar(clazz) : clazz;\n    }\n    abstract public <T> Class<? extends T> bar(Class<T> p);\n}"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0909() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate static class B<T> {\n\t\tprivate Object x;\n\n\t\tpublic B(T x) {\n\t\t\tthis.x = x;\n\t\t}\n\t}\n\n\tprivate static class C {\n\t\tprivate Object x;\n\n\t\tpublic C(Object x) {\n\t\t\tthis.x = x;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) throws Throwable {\n\t\tB<String> b = new B<String>(\"foo\");\n\t\tSystem.out.println(b.x);\n\n\t\tC c = new C(\"foo\");\n\t\tSystem.out.println(c.x);\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 24)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0910() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\n\npublic class X {\n\n\tvoid bar() {\n\t\tList<Collection> lc1 = null;\n\t\tList<Collection<?>> lc2 = null;\n\t\tList<? extends Collection<?>> lc3 = null;\n\t\tList<? extends Collection> lc4 = null;\n\t\tlc1 = lc2; //1 ko\n\t\tlc1 = lc3; //2 ko\n\t\tlc1 = lc4; //3 ko\n\t\tlc2 = lc1; //4 ko\n\t\tlc2 = lc3; //5 ko\n\t\tlc2 = lc4; //6 ko\n\t\tlc3 = lc1; //7 ko\n\t\tlc3 = lc2; //8 ok\n\t\tlc3 = lc4; //9 ko\n\t\tlc4 = lc1; //10 ok\n\t\tlc4 = lc2; //11 ok\n\t\tlc4 = lc3; //12 ok\n\t}\n\tprivate final List<Collection> aList = new ArrayList<Collection>();\n\tpublic void foo() {\n\t\tfinal List<Collection<?>> listCopy = new ArrayList<Collection<?>>(this.aList); // ko\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tList<Collection> lc1 = null;\n\t     ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in X.java (at line 11)\n\tList<? extends Collection> lc4 = null;\n\t               ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in X.java (at line 12)\n\tlc1 = lc2; //1 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection<?>> to List<Collection>\n----------\n4. ERROR in X.java (at line 13)\n\tlc1 = lc3; //2 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#1-of ? extends Collection<?>> to List<Collection>\n----------\n5. ERROR in X.java (at line 14)\n\tlc1 = lc4; //3 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#3-of ? extends Collection> to List<Collection>\n----------\n6. ERROR in X.java (at line 15)\n\tlc2 = lc1; //4 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection> to List<Collection<?>>\n----------\n7. ERROR in X.java (at line 16)\n\tlc2 = lc3; //5 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#4-of ? extends Collection<?>> to List<Collection<?>>\n----------\n8. ERROR in X.java (at line 17)\n\tlc2 = lc4; //6 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#6-of ? extends Collection> to List<Collection<?>>\n----------\n9. ERROR in X.java (at line 18)\n\tlc3 = lc1; //7 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection> to List<? extends Collection<?>>\n----------\n10. ERROR in X.java (at line 20)\n\tlc3 = lc4; //9 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#13-of ? extends Collection> to List<? extends Collection<?>>\n----------\n11. WARNING in X.java (at line 25)\n\tprivate final List<Collection> aList = new ArrayList<Collection>();\n\t                   ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n12. WARNING in X.java (at line 25)\n\tprivate final List<Collection> aList = new ArrayList<Collection>();\n\t                                                     ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n13. ERROR in X.java (at line 27)\n\tfinal List<Collection<?>> listCopy = new ArrayList<Collection<?>>(this.aList); // ko\n\t                                     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor ArrayList<Collection<?>>(List<Collection>) is undefined\n----------\n");
    }

    public void test0911() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\n\npublic class X {\n\tvoid bar() {\n\t\tList<Collection> lc1 = null;\n\t\tList<Collection<?>> lc2 = null;\n\t\tList<? super Collection<?>> lc3 = null;\n\t\tList<? super Collection> lc4 = null;\n\t\tlc1 = lc2; //1 ko\n\t\tlc1 = lc3; //2 ko\n\t\tlc1 = lc4; //3 ko\n\t\tlc2 = lc1; //4 ko\n\t\tlc2 = lc3; //5 ko\n\t\tlc2 = lc4; //6 ko\n\t\tlc3 = lc1; //7 ok\n\t\tlc3 = lc2; //8 ok\n\t\tlc3 = lc4; //9 ok\n\t\tlc4 = lc1; //10 ok\n\t\tlc4 = lc2; //11 ko\n\t\tlc4 = lc3; //12 ko\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tList<Collection> lc1 = null;\n\t     ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in X.java (at line 10)\n\tList<? super Collection> lc4 = null;\n\t             ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in X.java (at line 11)\n\tlc1 = lc2; //1 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection<?>> to List<Collection>\n----------\n4. ERROR in X.java (at line 12)\n\tlc1 = lc3; //2 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#1-of ? super Collection<?>> to List<Collection>\n----------\n5. ERROR in X.java (at line 13)\n\tlc1 = lc4; //3 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#2-of ? super Collection> to List<Collection>\n----------\n6. ERROR in X.java (at line 14)\n\tlc2 = lc1; //4 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection> to List<Collection<?>>\n----------\n7. ERROR in X.java (at line 15)\n\tlc2 = lc3; //5 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#3-of ? super Collection<?>> to List<Collection<?>>\n----------\n8. ERROR in X.java (at line 16)\n\tlc2 = lc4; //6 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#4-of ? super Collection> to List<Collection<?>>\n----------\n9. ERROR in X.java (at line 21)\n\tlc4 = lc2; //11 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection<?>> to List<? super Collection>\n----------\n10. ERROR in X.java (at line 22)\n\tlc4 = lc3; //12 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#12-of ? super Collection<?>> to List<? super Collection>\n----------\n");
    }

    public void test0912() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tvoid foo(List<? extends Collection<String>[]> l1, List<Collection[]> l2) {\n\t\tl1 = l2;\n\t\tl2 = l1;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid foo(List<? extends Collection<String>[]> l1, List<Collection[]> l2) {\n\t                                                       ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tl1 = l2;\n\t     ^^\nType mismatch: cannot convert from List<Collection[]> to List<? extends Collection<String>[]>\n----------\n3. ERROR in X.java (at line 6)\n\tl2 = l1;\n\t     ^^\nType mismatch: cannot convert from List<capture#2-of ? extends Collection<String>[]> to List<Collection[]>\n----------\n");
    }

    public void test0913() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid bar() {\n\t\tList<Collection[]> lc1 = null;\n\t\tList<Collection<?>[]> lc2 = null;\n\t\tList<? extends Collection<?>[]> lc3 = null;\n\t\tList<? extends Collection[]> lc4 = null;\n\t\tlc1 = lc2; //1 ko\n\t\tlc1 = lc3; //2 ko\n\t\tlc1 = lc4; //3 ko\n\t\tlc2 = lc1; //4 ko\n\t\tlc2 = lc3; //5 ko\n\t\tlc2 = lc4; //6 ko\n\t\tlc3 = lc1; //7 ko\n\t\tlc3 = lc2; //8 ok\n\t\tlc3 = lc4; //9 ko\n\t\tlc4 = lc1; //10 ok\n\t\tlc4 = lc2; //11 ok\n\t\tlc4 = lc3; //12 ok\t\t\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tList<Collection[]> lc1 = null;\n\t     ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tList<? extends Collection[]> lc4 = null;\n\t               ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in X.java (at line 8)\n\tlc1 = lc2; //1 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection<?>[]> to List<Collection[]>\n----------\n4. ERROR in X.java (at line 9)\n\tlc1 = lc3; //2 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#1-of ? extends Collection<?>[]> to List<Collection[]>\n----------\n5. ERROR in X.java (at line 10)\n\tlc1 = lc4; //3 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#2-of ? extends Collection[]> to List<Collection[]>\n----------\n6. ERROR in X.java (at line 11)\n\tlc2 = lc1; //4 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection[]> to List<Collection<?>[]>\n----------\n7. ERROR in X.java (at line 12)\n\tlc2 = lc3; //5 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#3-of ? extends Collection<?>[]> to List<Collection<?>[]>\n----------\n8. ERROR in X.java (at line 13)\n\tlc2 = lc4; //6 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#4-of ? extends Collection[]> to List<Collection<?>[]>\n----------\n9. ERROR in X.java (at line 14)\n\tlc3 = lc1; //7 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection[]> to List<? extends Collection<?>[]>\n----------\n10. ERROR in X.java (at line 16)\n\tlc3 = lc4; //9 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#8-of ? extends Collection[]> to List<? extends Collection<?>[]>\n----------\n");
    }

    public void test0914() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid bar() {\n\t\tList<Collection[]> lc1 = null;\n\t\tList<Collection<?>[]> lc2 = null;\n\t\tList<? super Collection<?>[]> lc3 = null;\n\t\tList<? super Collection[]> lc4 = null;\n\t\tlc1 = lc2; //1 ko\n\t\tlc1 = lc3; //2 ko\n\t\tlc1 = lc4; //3 ko\n\t\tlc2 = lc1; //4 ko\n\t\tlc2 = lc3; //5 ko\n\t\tlc2 = lc4; //6 ko\n\t\tlc3 = lc1; //7 ok\n\t\tlc3 = lc2; //8 ok\n\t\tlc3 = lc4; //9 ok\n\t\tlc4 = lc1; //10 ok\n\t\tlc4 = lc2; //11 ko\n\t\tlc4 = lc3; //12 ko\t\t\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tList<Collection[]> lc1 = null;\n\t     ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tList<? super Collection[]> lc4 = null;\n\t             ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in X.java (at line 8)\n\tlc1 = lc2; //1 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection<?>[]> to List<Collection[]>\n----------\n4. ERROR in X.java (at line 9)\n\tlc1 = lc3; //2 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#1-of ? super Collection<?>[]> to List<Collection[]>\n----------\n5. ERROR in X.java (at line 10)\n\tlc1 = lc4; //3 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#2-of ? super Collection[]> to List<Collection[]>\n----------\n6. ERROR in X.java (at line 11)\n\tlc2 = lc1; //4 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection[]> to List<Collection<?>[]>\n----------\n7. ERROR in X.java (at line 12)\n\tlc2 = lc3; //5 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#3-of ? super Collection<?>[]> to List<Collection<?>[]>\n----------\n8. ERROR in X.java (at line 13)\n\tlc2 = lc4; //6 ko\n\t      ^^^\nType mismatch: cannot convert from List<capture#4-of ? super Collection[]> to List<Collection<?>[]>\n----------\n9. ERROR in X.java (at line 18)\n\tlc4 = lc2; //11 ko\n\t      ^^^\nType mismatch: cannot convert from List<Collection<?>[]> to List<? super Collection[]>\n----------\n10. ERROR in X.java (at line 19)\n\tlc4 = lc3; //12 ko\t\t\n\t      ^^^\nType mismatch: cannot convert from List<capture#12-of ? super Collection<?>[]> to List<? super Collection[]>\n----------\n");
    }

    public void test0915() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass Y1 extends Throwable {\n\t\tprivate static final long serialVersionUID = 1L;\n\t\tT t;\n\t}\n\tstatic class Y2 extends Throwable {\n\t\tprivate static final long serialVersionUID = 1L;\n\t}\n\tclass Y3<U> extends Throwable {\n\t\tprivate static final long serialVersionUID = 1L;\n\n\t\tT t;\n\t}\n}\nclass Y4<E> extends Throwable {}\n\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y1 extends Throwable {\n\t                 ^^^^^^^^^\nThe generic class X<T>.Y1 may not subclass java.lang.Throwable\n----------\n2. ERROR in X.java (at line 9)\n\tclass Y3<U> extends Throwable {\n\t                    ^^^^^^^^^\nThe generic class X<T>.Y3<U> may not subclass java.lang.Throwable\n----------\n3. WARNING in X.java (at line 15)\n\tclass Y4<E> extends Throwable {}\n\t      ^^\nThe serializable class Y4 does not declare a static final serialVersionUID field of type long\n----------\n4. ERROR in X.java (at line 15)\n\tclass Y4<E> extends Throwable {}\n\t                    ^^^^^^^^^\nThe generic class Y4<E> may not subclass java.lang.Throwable\n----------\n");
    }

    public void test0916() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends X2<?>> {\n    T m2;\n    T getX2() {\n        return this.m2;\n    }\n}\nclass X2<T extends X3> {\n    T m3;\n    T getX3() {\n        return this.m3;\n    }\n}\nclass X3 {\n}\nclass Y1<T extends Y2<?>> extends X<T> {\n    public void foo() {\n        getX2().getX3().bar(); // getX3 appropriately returns an Y3\n    }\n}\nclass Y2<T extends Y3> extends X2<T> {\n}\nclass Y3 extends X3 {\n    public void bar() {\n    }\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0917() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends A> extends X2<T.M> { }\nclass X2<T> { }\nclass A { static class M {} }"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends A> extends X2<T.M> { }\n\t                                       ^^^\nIllegal qualified access from the type parameter T\n----------\n");
    }

    public void test0917a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> extends X2<T.clazz> { }\nclass X2<T> { }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T> extends X2<T.clazz> { }\n\t                             ^^^^^^^\nIllegal qualified access from the type parameter T\n----------\n");
    }

    public void test0917b() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> { Class<T> c = T.class; }"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T> { Class<T> c = T.class; }\n\t                                 ^^^^^^^\nIllegal class literal for the type parameter T\n----------\n");
    }

    public void test0917c() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> extends X2<T.class> { }\nclass X2<T> { }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T> extends X2<T.class> { }\n\t                               ^^^^^\nSyntax error on token \"class\", Identifier expected\n----------\n");
    }

    public void test0918() {
        this.runConformTest(new String[]{"BasicNode.java", "class BasicEdge<N extends BasicNode<E, N> & Node<E>, E extends BasicEdge<N, E> & Edge<N>>\n\t\timplements Edge<N> {\n}\n\npublic class BasicNode<E extends BasicEdge<N, E> & Edge<N>, N extends BasicNode<E, N> & Node<E>>\n\t\timplements Node<E> {\n}\n\ninterface Edge<N extends Node<? extends Edge<N>>> {\n}\n\ninterface Node<E extends Edge<? extends Node<E>>> {\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0919() {
        this.runConformTest(new String[]{"X.java", "class Box<E> {\n\tprivate E element;\n\tvoid put(E elem) {\n\t\tthis.element = elem;\n\t}\n\tE get() {\n\t\treturn this.element;\n\t}\n\tPair<E, E> asPair() {\n\t\treturn new Pair<E, E>(this.element, this.element);\n\t}\n\tBox<Box<E>> nest() {\n\t\tBox<Box<E>> wrapper = new Box<Box<E>>();\n\t\twrapper.put(this);\n\t\treturn wrapper;\n\t}\n}\n\nclass Pair<U, V> {\n\tPair(U u, V v) {\n\t}\n}\n\nclass PandoraBox<T extends Box<T>> extends Box<T> {\n}\n\npublic class X {\n\tvoid test(PandoraBox<?> pbox) {\n\t\tBox<?> box = pbox.get();\n\t\tPair<?,?> pair = pbox.asPair();\n\t\tBox<?> nbox = pbox.nest();\n\t}\n}\n"}, "");
    }

    public void test0920() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nclass Stack<E> {\n\tprivate List<E> contents = new ArrayList<E>();\n\tvoid push(E e) {\n\t\tthis.contents.add(e);\n\t}\n\tE pop() {\n\t\tint last = this.contents.size() - 1;\n\t\tif (last < 0) throw new EmptyStackException();\n\t\treturn this.contents.remove(last);\n\t}\n\tprivate static <T> void doSwap(Stack<T> s) {\n\t\tT t1 = s.pop();\n\t\tT t2 = s.pop();\n\t\ts.push(t1);\n\t\ts.push(t2);\n\t}\n\tstatic void swap(Stack<?> s) { doSwap(s); }\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tStack<Integer> si = new Stack<Integer>();\n\t\tInteger[] ints = { 12, 13, 14, 15, };\n\t\tfor (Integer i : ints) si.push(i);\n\t\ttry {\n\t\t\twhile(true) {\n\t\t\t\tSystem.out.print(\"[\"+si.pop()+\"]\");\n\t\t\t}\n\t\t} catch(EmptyStackException e) {\n\t\t\tSystem.out.println(\"[done]\");\n\t\t}\n\t}\n}\n"}, "[15][14][13][12][done]");
    }

    public void test0921() {
        this.runConformTest(new String[]{"Graph.java", "class Node<N extends Node<N,E>, E extends Edge<N,E>> {\n}\nclass Edge<N extends Node<N,E>, E extends Edge<N,E>> {\n}\nclass Graph<N extends Node<N,E>, E extends Edge<N,E>>{\n\tN n;\n\tE e;\n\tprivate Graph(N n, E e) {\n\t\tthis.n = n;\n\t\tthis.e = e;\n\t}\n\tstatic <N extends Node<N,E>, E extends Edge<N,E>>\n\tGraph<N,E> copy(Graph<N,E> g) {\n\t\treturn create(g.n,g.e);\n\t}\n\tstatic <N extends Node<N,E>, E extends Edge<N,E>>\n\tGraph<N,E> create(N n, E e) {\n\t\treturn new Graph<N,E>(n,e);\n\t}\n\tGraph<?,?> builder() {\n\t\tGraph<?,?> g = null;\n\t\treturn copy(g);\n\t}\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0922() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.*;\npublic class Test {\n\tList<List> list_raw_list;\n\t{\n\t\tCollection<? extends Collection<? extends Number>> col = list_raw_list;\n\t}\n}\n"}, "----------\n1. WARNING in Test.java (at line 3)\n\tList<List> list_raw_list;\n\t     ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in Test.java (at line 5)\n\tCollection<? extends Collection<? extends Number>> col = list_raw_list;\n\t                                                         ^^^^^^^^^^^^^\nType mismatch: cannot convert from List<List> to Collection<? extends Collection<? extends Number>>\n----------\n");
    }

    public void test0923() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\n  static void a(Class<? extends X<?>> c) {}\n\n  static void b(X<?> t) {\n    X.a(t.getClass());\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tX.a(t.getClass());\n\t  ^\nThe method a(Class<? extends X<?>>) in the type X is not applicable for the arguments (Class<capture#2-of ? extends X>)\n----------\n");
    }

    public void test0924() {
        this.runConformTest(true, new String[]{"ExtendedOuter.java", "class Outer<O> {\n\tclass Inner {\n\t}\n\n\tstatic void method(Outer<?>.Inner x) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n\npublic class ExtendedOuter<E> extends Outer<E> {\n\tclass ExtendedInner extends Inner {\n\t\t{\n\t\t\tOuter.method(this);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew ExtendedOuter<String>().new ExtendedInner();\n\t}\n}\n"}, "", "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0925() {
        this.runConformTest(true, new String[]{"X.java", "import java.util.*;\n\npublic class X<A, B> {\n\tprivate List<A> toAdd;\n\n\tpublic X(List<A> toAdd) {\n\t\tthis.toAdd = toAdd;\n\t}\n\n\tprivate List<A> getRelated(B b) {\n\t\t// some application logic\n\t\t// for demo\n\t\treturn toAdd;\n\t}\n\n\t@SuppressWarnings(\"unchecked\")\n\tpublic <L extends List<? super A>, LF extends Factory<L>> L addOrCreate4(\n\t\t\tB b, L l, LF lf) {\n\t\tif (l == null) {\n\t\t\tl = lf.create();\n\t\t}\n\t\t((List<? super A>) l).addAll(getRelated(b)); \n\t\tl.addAll(getRelated(b));\n\t\treturn l;\n\t}\n\n\tpublic static class ListFactory<T> implements Factory<List<T>> {\n\t\tpublic List<T> create() {\n\t\t\treturn new ArrayList<T>();\n\t\t}\n\t}\n\n\tpublic static interface Factory<T> {\n\t\tpublic T create();\n\t}\n\n\tpublic static void main(String... args) {\n\t\tListFactory<Number> lf = new ListFactory<Number>();\n\t\tList<Long> longs = new ArrayList<Long>();\n\t\tlongs.add(new Long(1));\n\t\tX<Long, Number> test = new X<Long, Number>(longs);\n\t\tList<Number> ret4 = null;\n\t\tret4 = test.addOrCreate4(1, ret4, lf);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, null, "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10_b24);
    }

    public void test0926() {
        String xSource = "public class X {\n\t@SuppressWarnings(\"null\")\n\tpublic void foo() {\n\t\tNonTerminalSourcePart<? extends Tuple<Boolean, Term>> RESULT = null;\n\t\tNonTerminalSourcePart<? extends Tuple<? extends Term, ? extends Formula>> t = null;\n\t\tRESULT = NonTerminalSourcePart.create(Tuple.create(true, t.value().fst()));\n\t}\n}\n\nclass Term {\n}\n\nclass Formula {\n}\n\nfinal class NonTerminalSourcePart<V> {\n\tstatic <V> NonTerminalSourcePart<V> create(final V _value) {\n\t\treturn null;\n\t}\n\tfinal V value() {\n\t\treturn null;\n\t}\n}\n\nclass Tuple<A, B> {\n\tpublic static <A, B> Tuple<A, B> create(final A a, final B b) {\n\t\treturn null;\n\t}\n\tpublic A fst() {\n\t\treturn null;\n\t}\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 6)\n\tRESULT = NonTerminalSourcePart.create(Tuple.create(true, t.value().fst()));\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from NonTerminalSourcePart<Tuple<Boolean,capture#3-of ? extends Term>> to NonTerminalSourcePart<? extends Tuple<Boolean,Term>>\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6557661);
        } else {
            this.runConformTest(new String[]{"X.java", xSource});
        }
    }

    public void test0927() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n@SuppressWarnings(\"null\") public class X {\n\tpublic void foo() {\n\t\tList<? extends List<Object>> RESULT = null;\n\t\tList<? extends Object> lst = null;\n\t\tRESULT = Collections.singletonList(Collections.singletonList(lst.get(0)));\n\t}\n\tpublic void bar() {\n\t\tList<List<Object>> RESULT = null;\n\t\tList<? extends Object> lst = null;\n\t\tRESULT = Collections.singletonList(Collections.singletonList(lst.get(0)));\n\t}\n\tpublic void baz() {\n\t\tList<List<Object>> RESULT = null;\n\t\tList<?> lst = null;\n\t\tRESULT = Collections.singletonList(Collections.singletonList(lst.get(0)));\n\t}\n\tpublic void bar2(List<? extends Object> lst) {\n\t\tList<Object> RESULT = null;\n\t\tRESULT = lst;\n\t\tRESULT = Collections.singletonList(lst.get(0));\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tList<String> ls = new ArrayList<String>();\n\t\tls.add(\"str\");\n\t\tnew X().bar2(ls);\n\t}\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 6)\n\tRESULT = Collections.singletonList(Collections.singletonList(lst.get(0)));\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<List<capture#2-of ? extends Object>> to List<? extends List<Object>>\n----------\n2. ERROR in X.java (at line 11)\n\tRESULT = Collections.singletonList(Collections.singletonList(lst.get(0)));\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<List<capture#3-of ? extends Object>> to List<List<Object>>\n----------\n3. ERROR in X.java (at line 16)\n\tRESULT = Collections.singletonList(Collections.singletonList(lst.get(0)));\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<List<capture#4-of ?>> to List<List<Object>>\n----------\n4. ERROR in X.java (at line 20)\n\tRESULT = lst;\n\t         ^^^\nType mismatch: cannot convert from List<capture#5-of ? extends Object> to List<Object>\n----------\n5. ERROR in X.java (at line 21)\n\tRESULT = Collections.singletonList(lst.get(0));\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<capture#6-of ? extends Object> to List<Object>\n----------\n" : "----------\n1. ERROR in X.java (at line 20)\n\tRESULT = lst;\n\t         ^^^\nType mismatch: cannot convert from List<capture#5-of ? extends Object> to List<Object>\n----------\n");
    }

    public void test0928() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public static void main(String[] args) throws Throwable {\n\tList<?> x1 = new ArrayList<Integer>();\n\tList<?> x2 = new ArrayList<Integer>();\n\tx1.addAll(x2);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tx1.addAll(x2);\n\t   ^^^^^^\nThe method addAll(Collection<? extends capture#1-of ?>) in the type List<capture#1-of ?> is not applicable for the arguments (List<capture#2-of ?>)\n----------\n");
    }

    public void test0929() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\n\npublic class X {\n  \n  public static <E extends Enum<E>> void fails () {\n    Class<? extends Enum> enumType = null;\n    final Collection<E> test = allOf(enumType);\n\n    Collection<? extends Enum> colType = null;\n    final Collection<E> test2 = colType;\n  }\n  \n  public static <E extends Enum<E>> Collection<E> allOf(final Class<E> enumType) {\n    return null;\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tClass<? extends Enum> enumType = null;\n\t                ^^^^\nEnum is a raw type. References to generic type Enum<E> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tfinal Collection<E> test = allOf(enumType);\n\t                           ^^^^^^^^^^^^^^^\nType safety: Unchecked invocation allOf(Class<capture#1-of ? extends Enum>) of the generic method allOf(Class<E>) of type X\n----------\n3. WARNING in X.java (at line 7)\n\tfinal Collection<E> test = allOf(enumType);\n\t                           ^^^^^^^^^^^^^^^\nType safety: The expression of type Collection needs unchecked conversion to conform to Collection<E>\n----------\n4. WARNING in X.java (at line 9)\n\tCollection<? extends Enum> colType = null;\n\t                     ^^^^\nEnum is a raw type. References to generic type Enum<E> should be parameterized\n----------\n5. ERROR in X.java (at line 10)\n\tfinal Collection<E> test2 = colType;\n\t                            ^^^^^^^\nType mismatch: cannot convert from Collection<capture#2-of ? extends Enum> to Collection<E>\n----------\n");
    }

    public void test0930() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n        public static int I;\n        public void foo() {\n                X.I= 10;\n        }\n\t\t {  Zork z; }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t{  Zork z; }\n\t   ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0931() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n        public static int I;\n        public void foo() {\n                X<T>.I= 10;\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX<T>.I= 10;\n\t     ^\nSyntax error on token \"I\", VariableDeclaratorId expected after this token\n----------\n");
    }

    public void _test0932() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n        public static int Method() { return 0; }\n        public void foo() {\n                X.Method();\n        }\n        public void bar() {\n                X<String>.Method();\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tX<String>.Method();\n\t^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n");
    }

    public void test0933() {
        this.runNegativeTest(new String[]{"a/AbstractFoo.java", "package a;\npublic abstract class AbstractFoo<T extends AbstractFoo<T>> {\n\tprotected static class Inner<T extends AbstractFoo<T>> {\n\t\tpublic Inner() {\n\t\t}\n\n\t\tpublic final void doSmth() {\n\t\t}\n\t}\n}\n", "b/CustomFoo.java", "package b;\nimport a.AbstractFoo;\npublic final class CustomFoo extends AbstractFoo<CustomFoo> {\n\tprivate Inner<DefaultFoo> defaultInner;\n\n\tInner<DefaultFoo> getDefaultInner() {\n\t\treturn (this.defaultInner == null)\n\t\t\t\t? this.defaultInner = new Inner<DefaultFoo>()\n\t\t\t\t: this.defaultInner;\n\t}\t\n\n\tprivate Inner<CustomFoo> customInner;\n\n\tInner<CustomFoo> getCustomInner() {\n\t\treturn (this.customInner == null)\n\t\t\t\t? this.customInner = new Inner<CustomFoo>()\n\t\t\t\t: this.customInner;\n\t}\t\n}\n", "b/DefaultFoo.java", "package b;\nimport a.AbstractFoo;\npublic final class DefaultFoo extends AbstractFoo<DefaultFoo> {\n\tprivate Inner<DefaultFoo> defaultInner;\n\n\tInner<DefaultFoo> getDefaultInner() {\n\t\treturn (this.defaultInner == null)\n\t\t\t\t? this.defaultInner = new Inner<DefaultFoo>()\n\t\t\t\t: this.defaultInner;\n\t}\t\n\n\tprivate Inner<CustomFoo> customInner;\n\n\tInner<CustomFoo> getCustomInner() {\n\t\treturn (this.customInner == null)\n\t\t\t\t? this.customInner = new Inner<CustomFoo>()\n\t\t\t\t: this.customInner;\n\t}\n\n\t///////////////////////////////////////////////////////////////////////\n\tpublic void testCompilationFailure(final CustomFoo foo) {\n\t\tfinal DefaultFoo foo1 = this;\n\t\tfinal CustomFoo foo2 = foo;\n\n\t\t// These get compiled w/o error:\n\t\tfoo1.getCustomInner().doSmth();\n\t\tfoo1.getDefaultInner().doSmth();\n\n\t\t// These do not (Eclipse 3.2.0 M4):\n\t\tfoo2.getCustomInner().doSmth();\n\t\tfoo2.getDefaultInner().doSmth();\n\n\t\t// Expect error\n\t\tString s11 = foo1.getCustomInner();\n\t\tString s12 = foo2.getDefaultInner();\n\t\tString s21 = foo2.getCustomInner();\n\t\tString s22 = foo2.getDefaultInner();\n\n\t\t// However, if we split statements, everything's ok: \n\t\tfinal Inner<CustomFoo> customInner2 = foo2.getCustomInner();\n\t\tcustomInner2.doSmth();\n\n\t\tfinal Inner<DefaultFoo> defaultInner2 = foo2.getDefaultInner();\n\t\tdefaultInner2.doSmth();\n\t}\n}\n"}, "----------\n1. ERROR in b\\DefaultFoo.java (at line 34)\n\tString s11 = foo1.getCustomInner();\n\t             ^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from AbstractFoo.Inner<CustomFoo> to String\n----------\n2. ERROR in b\\DefaultFoo.java (at line 35)\n\tString s12 = foo2.getDefaultInner();\n\t             ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from AbstractFoo.Inner<DefaultFoo> to String\n----------\n3. ERROR in b\\DefaultFoo.java (at line 36)\n\tString s21 = foo2.getCustomInner();\n\t             ^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from AbstractFoo.Inner<CustomFoo> to String\n----------\n4. ERROR in b\\DefaultFoo.java (at line 37)\n\tString s22 = foo2.getDefaultInner();\n\t             ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from AbstractFoo.Inner<DefaultFoo> to String\n----------\n");
    }

    public void test0934() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tstatic class Inner<U> {\n\t\tstatic class InInner <V> {\n\t\t}\n\t}\n}\nclass Y<W> extends X<W> {\n\tvoid foo() {\n\t\tInner<W> inner = null;\n\t\tString s = inner;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tString s = inner;\n\t           ^^^^^\nType mismatch: cannot convert from X.Inner<W> to String\n----------\n");
    }

    public void test0935() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tstatic class Inner<U> {\n\t\tclass InInner <V> {\n\t\t}\n\t}\n}\nclass Y<W> extends X<W> {\n\tvoid foo() {\n\t\tInner<W>.InInner<W> inner = null;\n\t\tString s = inner;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tString s = inner;\n\t           ^^^^^\nType mismatch: cannot convert from X.Inner<W>.InInner<W> to String\n----------\n");
    }

    public void test0936() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass Inner<U> {\n\t\tclass InInner <V> {\n\t\t}\n\t}\n}\nclass Y<W> extends X<W> {\n\tvoid foo() {\n\t\tInner<W> inner = null;\n\t\tString s = inner;\n\t\t\n\t\tInner<W>.InInner<W> inner2 = null;\n\t\ts = inner2;\n\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tString s = inner;\n\t           ^^^^^\nType mismatch: cannot convert from X<W>.Inner<W> to String\n----------\n2. ERROR in X.java (at line 13)\n\ts = inner2;\n\t    ^^^^^^\nType mismatch: cannot convert from X<W>.Inner<W>.InInner<W> to String\n----------\n");
    }

    public void test0937() {
        this.runNegativeTest(new String[]{"ExtendedOuter.java", "class Outer<O> {\n  class Inner {}\n\n  static void method(Outer.Inner x) {}\n}\n\npublic class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    {\n      Outer.method(this);\n    }\n  }\n  void foo() {\n    Zork zk;\n  }\n}\n"}, "----------\n1. WARNING in ExtendedOuter.java (at line 4)\n\tstatic void method(Outer.Inner x) {}\n\t                   ^^^^^^^^^^^\nOuter.Inner is a raw type. References to generic type Outer<O>.Inner should be parameterized\n----------\n2. ERROR in ExtendedOuter.java (at line 14)\n\tZork zk;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0938() {
        this.runNegativeTest(new String[]{"ExtendedOuter.java", "class Outer<O> {\n  class Inner {}\n\n  static void method(Outer<?>.Inner x) {}\n}\n\npublic class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    {\n      Outer.method(this);\n    }\n  }\n  void foo() {\n    Zork zk;\n  }\n}\n"}, "----------\n1. ERROR in ExtendedOuter.java (at line 14)\n\tZork zk;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0939() {
        this.runNegativeTest(new String[]{"ExtendedOuter.java", "class Outer<O> {\n  class Inner {}\n\n  static <I> void method(Outer<I>.Inner x) {}\n}\n\npublic class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    {\n      Outer.method(this);\n    }\n  }\n  void foo() {\n    Zork zk;\n  }\n}\n"}, "----------\n1. ERROR in ExtendedOuter.java (at line 14)\n\tZork zk;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0939b() {
        this.runNegativeTest(new String[]{"ExtendedOuter.java", "class Outer<O> {\n  class Inner {}\n\n  static <I> I method(Outer<I>.Inner x) { return null; }\n}\n\npublic class ExtendedOuter<E extends A> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    {\n      Outer.method(this).bar();\n    }\n  }\n  void foo() {\n    Zork zk;\n  }\n}\nclass A { void bar() {} }\n"}, "----------\n1. ERROR in ExtendedOuter.java (at line 14)\n\tZork zk;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0940() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n        <U extends Object> void bar3(List<U> lst) {\n            List<Object> RESULT = null;\n            RESULT = lst; // 1\n            RESULT = Collections.singletonList(lst.get(0)); // 2\n    }              \n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tRESULT = lst; // 1\n\t         ^^^\nType mismatch: cannot convert from List<U> to List<Object>\n----------\n" + (this.complianceLevel < 0x340000L ? "2. ERROR in X.java (at line 6)\n\tRESULT = Collections.singletonList(lst.get(0)); // 2\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<U> to List<Object>\n----------\n" : ""));
    }

    public void test0941() {
        String xSource = "import java.util.*;\n\npublic class X {\n\t<T> Map<T,T> foo(T t1, T t2) {\n\t\treturn null;\n\t}\n\t<U extends Object, V extends U> void bar(U u, V v) {\n\t\tMap<Object,Object> map1 = foo(u, v);\n\t\tMap<U,U> map2 = foo(u, v);\n\t}\t\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 8)\n\tMap<Object,Object> map1 = foo(u, v);\n\t                          ^^^^^^^^^\nType mismatch: cannot convert from Map<U,U> to Map<Object,Object>\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", xSource});
        }
    }

    public void test0942() {
        String xSource = "import java.util.*;\n\npublic class X {\n\t<T> Map<T,T> foo(T t1, T t2, T t3) {\n\t\treturn null;\n\t}\n\t<U extends Object, V extends U> void bar(U u, V v) {\n\t\tMap<Object,Object> map1 = foo(u, v, null);\n\t\tMap<U,U> map2 = foo(u, v, null);\n\t}\t\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 8)\n\tMap<Object,Object> map1 = foo(u, v, null);\n\t                          ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Map<U,U> to Map<Object,Object>\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", xSource});
        }
    }

    public void test0943() {
        String xSource = "import java.util.*;\n\npublic class X {\n\t<T> Map<T,T> foo(T t1, T t2, T t3) {\n\t\treturn null;\n\t}\n\t<U extends Object, V extends U> void bar(U u, V v, List<? extends V> lv) {\n\t\tMap<Object,Object> map1 = foo(u, v, lv.get(0));\n\t\tMap<U,U> map2 = foo(u, v, lv.get(0));\n\t}\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 8)\n\tMap<Object,Object> map1 = foo(u, v, lv.get(0));\n\t                          ^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Map<U,U> to Map<Object,Object>\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", xSource});
        }
    }

    public void test0944() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static <A> Set<A> method(List<? super A> list) {\n\t\treturn new HashSet<A>();\n\t}\n\tpublic static void main(String[] args) {\n\t\tArrayList<Number> l = new ArrayList<Number>();\n\t\tSet<Integer> s1 = method(l);\n\t\tSet<Integer> s2 = (Set<Integer>) method(l);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tSet<Integer> s2 = (Set<Integer>) method(l);\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from Set<Number> to Set<Integer>\n----------\n");
    }

    public void test0945() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n    public static void main(String[] args){\n        Object[] objArray = {new Object()};\n        ArrayList<String> strList = new ArrayList<String>();\n        transferBug(objArray, strList);\n        String str = strList.get(0);\n}\npublic static <Var> void  transferBug(Var[] src, Collection<Var> dest){\n    dest.add(src[0]);\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\ttransferBug(objArray, strList);\n\t^^^^^^^^^^^\nThe method transferBug(Var[], Collection<Var>) in the type X is not applicable for the arguments (Object[], ArrayList<String>)\n----------\n");
    }

    public void test0946() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\toperate(Operations.create());\n\t}\n\tstatic <O extends Num<O>> void operate(Operators<O> operators) {\n\t\tSystem.out.println(operators.spawn());\n\t}\n}\nclass Operations {\n\tstatic Operators<?> create() {\n\t\treturn new IntOperators();\n\t}\n}\ninterface Num<O> {\n\tpublic O spawn();\n}\nclass Int implements Num<Int> {\n\tpublic Int spawn() {\n\t\treturn new Int();\n\t}\n  public String toString() {\n    return \"Int\";\n  }\n}\ninterface Operators<O extends Num<O>> {\n\tO spawn();\n}\nclass IntOperators implements Operators<Int> {\n\tpublic Int spawn() {\n\t\treturn new Int();\n\t}\n}\n"}, null, "Int", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0947() {
        String xSource = "public class X {\n        public void bar2(Box<?> b) {\n        \tBox<Runnable> bx = box(b.element);\n        \tbox(b.element).element.run();\n        }\n        static <U extends Runnable> Box<U> box(U u) {\n        \treturn new Box<U>(u);\n        }\n}\nclass Box<E extends Runnable> {\n\tE element;\n\tBox(E element) {\n\t\tthis.element = element;\n\t}\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 3)\n\tBox<Runnable> bx = box(b.element);\n\t                   ^^^^^^^^^^^^^^\nType mismatch: cannot convert from Box<capture#1-of ?> to Box<Runnable>\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236236);
        } else {
            this.runConformTest(new String[]{"X.java", xSource});
        }
    }

    public void test0948() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n        public void bar2(Box<?> b1, Box<Runnable> b2) {\n        \tPair<Runnable,Runnable> blist = pair(b1.element, b2.element);\n        }\n        static <U> Pair<U,U> pair(U u1, U u2) {\n        \treturn new Pair<U,U>(u1,u2);\n        }\n}\nclass Pair<E,F> {\n\tPair(E e, F f){}\n}\nclass Box<E extends Runnable> {\n\tE element;\n\tBox(E element) {\n\t\tthis.element = element;\n\t}\n}\n"}, "");
    }

    public void test0949() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\n\npublic class X {\n\tpublic <T> Iterable<T> m(T... ts) {\n\t\treturn Arrays.asList(ts);\n\t}\n\tpublic <T> void m3(Iterable<T>... ts) {\n\t}\n\tpublic void m2() {\n\t\tm3(m(3, 3, 3));\n\t\tm3(m());\n\t\tm3(m(new Object[]{}));\n\t\tZork z;\n\t}\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in X.java (at line 10)\n\tm3(m(3, 3, 3));\n\t^^^^^^^^^^^^^^\nType safety: A generic array of Iterable<Integer> is created for a varargs parameter\n----------\n2. WARNING in X.java (at line 11)\n\tm3(m());\n\t^^^^^^^\nType safety: A generic array of Iterable<Object> is created for a varargs parameter\n----------\n3. WARNING in X.java (at line 12)\n\tm3(m(new Object[]{}));\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterable<Object> is created for a varargs parameter\n----------\n4. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 4)\n\tpublic <T> Iterable<T> m(T... ts) {\n\t                              ^^\nType safety: Potential heap pollution via varargs parameter ts\n----------\n2. WARNING in X.java (at line 7)\n\tpublic <T> void m3(Iterable<T>... ts) {\n\t                                  ^^\nType safety: Potential heap pollution via varargs parameter ts\n----------\n3. WARNING in X.java (at line 10)\n\tm3(m(3, 3, 3));\n\t^^^^^^^^^^^^^^\nType safety: A generic array of Iterable<Integer> is created for a varargs parameter\n----------\n4. WARNING in X.java (at line 11)\n\tm3(m());\n\t^^^^^^^\nType safety: A generic array of Iterable<Object> is created for a varargs parameter\n----------\n5. WARNING in X.java (at line 12)\n\tm3(m(new Object[]{}));\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterable<Object> is created for a varargs parameter\n----------\n6. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0950() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\n\npublic class X {\n\tpublic <T> Iterable<T> m(T[]... ts) {\n\t\treturn Arrays.asList(ts[0]);\n\t}\n\tpublic <T> void m3(Iterable<T>... ts) {\n\t}\n\tpublic void m2() {\n\t\tm3(m(new Integer[]{3, 3, 3}));\n\t\tm3(m());\n\t\tm3(m(new Object[][]{}));\n\t\tZork z;\n\t}\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in X.java (at line 10)\n\tm3(m(new Integer[]{3, 3, 3}));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterable<Object> is created for a varargs parameter\n----------\n2. WARNING in X.java (at line 11)\n\tm3(m());\n\t^^^^^^^\nType safety: A generic array of Iterable<Object> is created for a varargs parameter\n----------\n3. WARNING in X.java (at line 12)\n\tm3(m(new Object[][]{}));\n\t^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterable<Object> is created for a varargs parameter\n----------\n4. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 4)\n\tpublic <T> Iterable<T> m(T[]... ts) {\n\t                                ^^\nType safety: Potential heap pollution via varargs parameter ts\n----------\n2. WARNING in X.java (at line 7)\n\tpublic <T> void m3(Iterable<T>... ts) {\n\t                                  ^^\nType safety: Potential heap pollution via varargs parameter ts\n----------\n3. WARNING in X.java (at line 10)\n\tm3(m(new Integer[]{3, 3, 3}));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel == 0x330000L ? "Type safety: A generic array of Iterable<Object> is created for a varargs parameter\n" : "Type safety: A generic array of Iterable<Integer> is created for a varargs parameter\n") + "----------\n" + "4. WARNING in X.java (at line 11)\n" + "\tm3(m());\n" + "\t^^^^^^^\n" + "Type safety: A generic array of Iterable<Object> is created for a varargs parameter\n" + "----------\n" + "5. WARNING in X.java (at line 12)\n" + "\tm3(m(new Object[][]{}));\n" + "\t^^^^^^^^^^^^^^^^^^^^^^^\n" + "Type safety: A generic array of Iterable<Object> is created for a varargs parameter\n" + "----------\n" + "6. ERROR in X.java (at line 13)\n" + "\tZork z;\n" + "\t^^^^\n" + "Zork cannot be resolved to a type\n" + "----------\n");
    }

    public void test0951() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\n\npublic class X {\n\tpublic <T> Iterable<T> m(T[]... ts) {\n\t\treturn Arrays.asList(ts[0]);\n\t}\n\tpublic <T> void m3(Iterable<T>... ts) {\n\t}\n\t@SuppressWarnings(\"unchecked\")\n\tpublic void m2() {\n\t\tm3(m(new Integer[]{3, 3, 3}));\n\t\tm3(m());\n\t\tm3(m(new Object[][]{}));\n\t\tZork z;\n\t}\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 4)\n\tpublic <T> Iterable<T> m(T[]... ts) {\n\t                                ^^\nType safety: Potential heap pollution via varargs parameter ts\n----------\n2. WARNING in X.java (at line 7)\n\tpublic <T> void m3(Iterable<T>... ts) {\n\t                                  ^^\nType safety: Potential heap pollution via varargs parameter ts\n----------\n3. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0952() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic <T> Iterable<T> m(T... ts) {\n\t\treturn null;\n\t}\n\tpublic <T> void m3(Iterable<T>... ts) {\n\t}\n\tpublic void m2() {\n\t\tm3(m(null));\n\t\tZork z;\n\t}\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in X.java (at line 8)\n\tm3(m(null));\n\t^^^^^^^^^^^\nType safety: A generic array of Iterable<Object> is created for a varargs parameter\n----------\n2. WARNING in X.java (at line 8)\n\tm3(m(null));\n\t   ^^^^^^^\nType null of the last argument to method m(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n3. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 2)\n\tpublic <T> Iterable<T> m(T... ts) {\n\t                              ^^\nType safety: Potential heap pollution via varargs parameter ts\n----------\n2. WARNING in X.java (at line 5)\n\tpublic <T> void m3(Iterable<T>... ts) {\n\t                                  ^^\nType safety: Potential heap pollution via varargs parameter ts\n----------\n3. WARNING in X.java (at line 8)\n\tm3(m(null));\n\t^^^^^^^^^^^\nType safety: A generic array of Iterable<Object> is created for a varargs parameter\n----------\n4. WARNING in X.java (at line 8)\n\tm3(m(null));\n\t   ^^^^^^^\nType null of the last argument to method m(Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n----------\n5. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0953() {
        if (this.complianceLevel >= 0x330000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.lang.ref.WeakReference;\nimport java.util.Arrays;\nimport java.util.List;\n\npublic class X {\n  void m(WeakReference<Integer> ref) {\n    List<WeakReference<Integer>> list= Arrays.asList(ref);\n    Zork z;\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tList<WeakReference<Integer>> list= Arrays.asList(ref);\n\t                                   ^^^^^^^^^^^^^^^^^^\nType safety: A generic array of WeakReference<Integer> is created for a varargs parameter\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0954() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X<A,B> {\n\tclass Member<C,D> {}\n\tstatic class SMember<U,V> {}\n\tvoid foo1() {\n\t\tX<?,?>[] xs = new X<?,?>[]{};//1\n\t\tfor(X<?,?> x : xs) {\n\t\t\tSystem.out.println(x);\n\t\t}\n\t}\n\tvoid bar1() {\n\t\tMember<?,?>[] members = new Member<?,?>[]{};//2\n\t\tfor(Member<?,?> m : members) {\n\t\t\tSystem.out.println(m);\n\t\t}\n\t}\n\tvoid bas1() {\n\t\tSMember<?,?>[] members = new SMember<?,?>[]{};//3\n\t\tfor(SMember<?,?> m : members) {\n\t\t\tSystem.out.println(m);\n\t\t}\n\t}\n\tvoid baz1() {\n\t\tclass Local<E,F>{}\n\t\tLocal<?,?>[] locals = new Local<?,?>[]{};//4\n\t\tfor(Local<?,?> l : locals) {\n\t\t\tSystem.out.println(l);\n\t\t}\n\t}\n\tvoid foo2() {\n\t\tX<?,?>[] xs = new X<?,?>[5];//5\n\t\tfor(X<?,?> x : xs) {\n\t\t\tSystem.out.println(x);\n\t\t}\n\t}\n\tvoid bar2() {\n\t\tMember<?,?>[] members = new Member<?,?>[5];//6\n\t\tfor(Member<?,?> m : members) {\n\t\t\tSystem.out.println(m);\n\t\t}\n\t}\n\tvoid bas2() {\n\t\tSMember<?,?>[] members = new SMember<?,?>[5];//7\n\t\tfor(SMember<?,?> m : members) {\n\t\t\tSystem.out.println(m);\n\t\t}\n\t}\n\tvoid baz2() {\n\t\tclass Local<E,F>{}\n\t\tLocal<?,?>[] locals = new Local<?,?>[5];//8\n\t\tfor(Local<?,?> l : locals) {\n\t\t\tSystem.out.println(l);\n\t\t}\n\t}\n\tvoid foo3() {\n\t\tX<?,?>[] xs = new X<?,?>[5];//9\n\t\tfor(X<?,?> x : xs) {\n\t\t\tSystem.out.println(x);\n\t\t}\n\t}\n\tvoid bar3() {\n\t\tX<?,?>.Member<?,?>[] members = new X<?,?>.Member<?,?>[5];//10\n\t\tfor(X<?,?>.Member<?,?> m : members) {\n\t\t\tSystem.out.println(m);\n\t\t}\n\t}\n\tstatic void baz3() {\n\t\tclass Local<E,F>{}\n\t\tLocal<?,?>[] locals = new Local<?,?>[5];//11\n\t\tfor(Local<?,?> l : locals) {\n\t\t\tSystem.out.println(l);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tMember<?,?>[] members = new Member<?,?>[]{};//2\n\t                                         ^^\nCannot create a generic array of X<A,B>.Member<?,?>\n----------\n2. ERROR in X.java (at line 26)\n\tLocal<?,?>[] locals = new Local<?,?>[]{};//4\n\t                                      ^^\nCannot create a generic array of Local<?,?>\n----------\n3. ERROR in X.java (at line 38)\n\tMember<?,?>[] members = new Member<?,?>[5];//6\n\t                        ^^^^^^^^^^^^^^^^^^\nCannot create a generic array of X<A,B>.Member<?,?>\n----------\n4. ERROR in X.java (at line 51)\n\tLocal<?,?>[] locals = new Local<?,?>[5];//8\n\t                      ^^^^^^^^^^^^^^^^^\nCannot create a generic array of Local<?,?>\n----------\n");
    }

    public void test0955() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X<E> {\n    void method(Object o) {\n        if (o instanceof List<E>[]) { //incorrect: bug 104695\n            List<E>[] es= (List<E>[]) o; //unchecked\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o instanceof List<E>[]) { //incorrect: bug 104695\n\t    ^^^^^^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type List<E>[]. Use the form List<?>[] instead since further generic type information will be erased at runtime\n----------\n2. WARNING in X.java (at line 5)\n\tList<E>[] es= (List<E>[]) o; //unchecked\n\t              ^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to List<E>[]\n----------\n");
    }

    public void test0956() {
        this.runConformTest(new String[]{"X.java", "public class X<F> {\n\n    public void printNickname(Person<F> person) {\n        Person<F>.Nickname nickname = person.getNickname();\n        System.out.println(nickname);\n    }\n\n    static class Person<E> {\n        private Nickname nickname;\n\n        public Nickname getNickname() {\n            return nickname;\n        }\n\n        public void setNickname(Nickname nickname) {\n            this.nickname = nickname;\n        }\n\n        class Nickname {\n            private String name;\n            private boolean insulting;\n        }\n    }\n}\n"}, "");
    }

    public void test0957() {
        this.runNegativeTest(new String[]{"AnyInterface.java", "public interface AnyInterface {\n        public void doSomething();\n}", "UsingGenericsClass", "public class UsingGenericsClass<A,B extends A & AnyInterface> {\n        public UsingGenericsClass(){\n        }\n}"}, "----------\n1. ERROR in UsingGenericsClass (at line 1)\n\tpublic class UsingGenericsClass<A,B extends A & AnyInterface> {\n\t                                                ^^^^^^^^^^^^\nCannot specify any additional bound AnyInterface when first bound is a type parameter\n----------\n");
    }

    public void test0958() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.ref.ReferenceQueue;\nimport java.lang.ref.SoftReference;\nimport java.util.Hashtable;\n\npublic class X {\n\tprivate static final Hashtable<Integer, Soft> cache = new Hashtable<Integer, Soft>();\n\n\tprivate static final ReferenceQueue<String> trash = new ReferenceQueue<String>();\n\n\tprivate static final class Soft extends SoftReference<String> {\n\t\tint key;\n\n\t\tSoft() {\n\t\t\tsuper(null);\n\t\t}\n\t}\n\n\tfinal Thread clean = new Thread(\"BigTableModel cleaner\") {\n\t\t@Override\n\t\tpublic void run() {\n\t\t\tfor (;;)\n\t\t\t\ttry {\n\t\t\t\t\tcache.remove(((Soft) trash.remove()).key);\n\t\t\t\t} catch (final InterruptedException e) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tZork z;\n\t\t}\n\t};\n}\n"}, "----------\n1. ERROR in X.java (at line 27)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0959() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.ref.*;\n\nclass Soft extends SoftReference<String> {\n    Soft() { super(null); }\n}\n\nclass Bug {\n    void m(Reference<? extends Number> remove) {\n        Soft soft= (Soft) remove;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tSoft soft= (Soft) remove;\n\t           ^^^^^^^^^^^^^\nCannot cast from Reference<capture#1-of ? extends Number> to Soft\n----------\n");
    }

    public void test0960() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n        <B extends Comparable<B>> X<B> newInstance() {\n                return new X<B>();\n        }\n\n        X<String>[] bugDemo() {\n                X x = newInstance();\n                return new X[] { x };\n        }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tX x = newInstance();\n\t^\nX is a raw type. References to generic type X<A> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\treturn new X[] { x };\n\t       ^^^^^^^^^^^^^\nType safety: The expression of type X[] needs unchecked conversion to conform to X<String>[]\n----------\n3. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0961() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n    <B extends Comparable<B>> B newInstance2(X<B> xb) {\n            return null;\n    }\n    void foo() {\n        X x = new X();\n        Comparable c = newInstance2(x);\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tX x = new X();\n\t^\nX is a raw type. References to generic type X<A> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tX x = new X();\n\t          ^\nX is a raw type. References to generic type X<A> should be parameterized\n----------\n3. WARNING in X.java (at line 7)\n\tComparable c = newInstance2(x);\n\t^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n4. WARNING in X.java (at line 7)\n\tComparable c = newInstance2(x);\n\t               ^^^^^^^^^^^^^^^\nType safety: Unchecked invocation newInstance2(X) of the generic method newInstance2(X<B>) of type X<A>\n----------\n5. WARNING in X.java (at line 7)\n\tComparable c = newInstance2(x);\n\t                            ^\nType safety: The expression of type X needs unchecked conversion to conform to X<Comparable>\n----------\n6. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0962() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    public void bug() throws Exception {\n        throw new Exception(\"Bug134645\") {\n            @Override\n            public String toString() {\n                return \"Bug134645\";\n            }\n        };\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthrow new Exception(\"Bug134645\") {\n\t          ^^^^^^^^^\nThe generic class new Exception(){} may not subclass java.lang.Throwable\n----------\n2. WARNING in X.java (at line 3)\n\tthrow new Exception(\"Bug134645\") {\n\t          ^^^^^^^^^^^^^^^^^^^^^^\nThe serializable class  does not declare a static final serialVersionUID field of type long\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0963() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void bug() throws Exception {\n        throw new Exception(\"Bug134645\") {\n            @Override\n            public String toString() {\n                return \"Bug134645\";\n            }\n        };\n    }\n}\n"}, "");
    }

    public void test0964() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    public static void bug() throws Exception {\n        throw new Exception(\"Bug134645\") {\n            @Override\n            public String toString() {\n                return \"Bug134645\";\n            }\n        };\n    }\n}\n"}, "");
    }

    public void test0965() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  protected static final Class<X<?>> theClass = (Class<X<?>>) X.class;\n  void foo(Class<X> cx) {\n\t  Class<X<?>> cx1 = cx;\n\t  Class<X<?>> cx2 = (Class<X<?>>) cx;\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tprotected static final Class<X<?>> theClass = (Class<X<?>>) X.class;\n\t                                              ^^^^^^^^^^^^^^^^^^^^^\nCannot cast from Class<X> to Class<X<?>>\n----------\n2. WARNING in X.java (at line 3)\n\tvoid foo(Class<X> cx) {\n\t               ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. ERROR in X.java (at line 4)\n\tClass<X<?>> cx1 = cx;\n\t                  ^^\nType mismatch: cannot convert from Class<X> to Class<X<?>>\n----------\n4. ERROR in X.java (at line 5)\n\tClass<X<?>> cx2 = (Class<X<?>>) cx;\n\t                  ^^^^^^^^^^^^^^^^\nCannot cast from Class<X> to Class<X<?>>\n----------\n");
    }

    public void test0966() {
        this.runConformTest(new String[]{"Child.java", "public class Child extends Parent implements Comparable<Child> {\n  public int compareTo(Child o) { return 0; }\n}\nclass Parent extends Base<Child> {}\nclass Base<T extends Base> {}\n"}, "");
    }

    public void test0967() {
        this.runConformTest(new String[]{"CSS.java", "interface Ac<S extends St<S,A>,A extends Ac<S,A>> {}\ninterface St<S extends St<S,A>,A extends Ac<S,A>> {}\nclass CSN<X, Y> extends CSS<X, Y> implements Ac<CSS<X, Y>, CSN<X, Y>> {}\npublic class CSS<X, Y> implements St<CSS<X, Y>, CSN<X, Y>> {}\n"}, "");
    }

    public void test0968() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<T0> extends ArrayList<T0> implements I<T0> {\n}\ninterface I<T1> extends Collection {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X<T0> extends ArrayList<T0> implements I<T0> {\n\t             ^\nThe interface Collection cannot be implemented more than once with different arguments: Collection<T0> and Collection\n----------\n2. WARNING in X.java (at line 2)\n\tpublic class X<T0> extends ArrayList<T0> implements I<T0> {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 4)\n\tinterface I<T1> extends Collection {\n\t                        ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n");
    }

    public void test0969() {
        this.runConformTest(new String[]{"B.java", "class B<T extends C> extends A<T> {}\nclass C extends B<C> {}\nclass A<T extends C> {}"}, "");
    }

    public void test0970() {
        this.runNegativeTest(new String[]{"X.java", "public interface X<T> { \n        interface I1<T> extends X<T> {\n                interface I2<T> extends I1<T> {\n                }\n\n                interface I3<T> extends I1<T> {\n                }\n\n                interface I4<T> extends I1.I2<T>, I1.I3<T> {    \n                }\n        }\n}\nclass XSub<E> implements X<E> {\n    I1<E> i1 = null;\n    I1.I2<E> i2 = null;\n    I1<E>.I2<E> i1i2 = null;\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\tI1<E>.I2<E> i1i2 = null;\n\t^^^^^^^^\nThe member type X.I1<E>.I2 cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type X.I1<E>\n----------\n");
    }

    public void test0971() {
        this.runNegativeTest(new String[]{"X.java", "public interface X<T> { \n        interface I1<T> extends X {\n                interface I2<T> extends I1 {\n                }\n\n                interface I3<T> extends I1 {\n                }\n\n                interface I4<T> extends I1.I2, I1.I3 {    \n                }\n        }\n}\nclass XSub<E> implements X<E> {\n    I1 i1 = null;\n    I1.I2 i2 = null;\n    I1<E>.I2 i1i2 = null;\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tinterface I1<T> extends X {\n\t                        ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tinterface I2<T> extends I1 {\n\t                        ^^\nX.I1 is a raw type. References to generic type X<T>.I1<T> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tinterface I3<T> extends I1 {\n\t                        ^^\nX.I1 is a raw type. References to generic type X<T>.I1<T> should be parameterized\n----------\n4. WARNING in X.java (at line 9)\n\tinterface I4<T> extends I1.I2, I1.I3 {    \n\t                        ^^^^^\nX.I1.I2 is a raw type. References to generic type X<T>.I1<T>.I2<T> should be parameterized\n----------\n5. WARNING in X.java (at line 9)\n\tinterface I4<T> extends I1.I2, I1.I3 {    \n\t                               ^^^^^\nX.I1.I3 is a raw type. References to generic type X<T>.I1<T>.I3<T> should be parameterized\n----------\n6. WARNING in X.java (at line 14)\n\tI1 i1 = null;\n\t^^\nX.I1 is a raw type. References to generic type X<T>.I1<T> should be parameterized\n----------\n7. WARNING in X.java (at line 15)\n\tI1.I2 i2 = null;\n\t^^^^^\nX.I1.I2 is a raw type. References to generic type X<T>.I1<T>.I2<T> should be parameterized\n----------\n8. ERROR in X.java (at line 16)\n\tI1<E>.I2 i1i2 = null;\n\t^^^^^^^^\nThe member type X.I1<E>.I2 cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type X.I1<E>\n----------\n");
    }

    public void test0972() {
        this.runConformTest(true, new String[]{"Outer.java", "//Outer.java\npublic class Outer<O> {\n  public class Inner {}\n\n  public static void method(Outer<?>.Inner x) {\n    System.out.println(\"SUCCESS\");\n  }\n  public static void main(String[] args) {\n    Outer<?>.Inner x = null;\n    method(x);\n  }\n}\n\n", "ExtendedOuter.java", "public class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    {\n      Outer.method(this);\n    }\n  }\n}\n"}, "", "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
        this.runConformTest(new String[]{"Outer.java", "//Outer.java\npublic class Outer<O> {\n  public class Inner {}\n\n  public static void method(Outer.Inner x) {\n    System.out.println(\"SUCCESS\");\n  }\n  public static void main(String[] args) {\n    Outer.Inner x = null;\n    method(x);\n  }\n}\n\n"}, "SUCCESS", null, false, null);
        this.runConformTest(new String[]{"ExtendedOuter.java", "public class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    {\n      Outer.method(this);\n    }\n  }\n  public static void main(String[] args) {\n    System.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test0973() {
        this.runConformTest(new String[]{"Outer.java", "//Outer.java\npublic class Outer<O> {\n  public class Inner {}\n\n  public static void method(Outer.Inner x) {\n    System.out.println(\"SUCCESS\");\n  }\n  public static void main(String[] args) {\n    Outer.Inner x = null;\n    method(x);\n  }\n}\n\n", "ExtendedOuter.java", "public class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    {\n      Outer.method(this);\n    }\n  }\n}\n"}, "SUCCESS");
    }

    public void test0974() {
        this.runConformTest(new String[]{"Outer.java", "//Outer.java\npublic class Outer<O> {\n  public class Inner {}\n\n  public static void method(Outer.Inner x) {\n    System.out.println(\"SUCCESS\");\n  }\n  public static void main(String[] args) {\n    Outer.Inner x = null;\n    method(x);\n  }\n}\n\n", "ExtendedOuter.java", "public class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    {\n      Outer.method(this);\n    }\n  }\n}\n"}, "SUCCESS");
        this.runConformTest(new String[]{"ExtendedOuter.java", "public class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    {\n\t\tOuter.Inner in;\n      Outer.method(this);\n    }\n  }\n  public static void main(String[] args) {\n    System.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test0975() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X extends ArrayList<Bean> {\n   public static class Bean {}\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic class X extends ArrayList<Bean> {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 3)\n\tpublic class X extends ArrayList<Bean> {\n\t                                 ^^^^\nBean cannot be resolved to a type\n----------\n");
    }

    public void test0976() {
        this.runConformTest(new String[]{"S.java", "import java.util.Collection;\npublic class S {\n        public static void cow(IDA<?, ?, ?, ?, ?, ?> s) {\n                Collection<IDA.Enum1> ids = s.getIds();  // Error here\n        }\n\t\tpublic static void main(String[] args) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n        }\n}\n", "ID.java", "import java.util.Collection;\npublic interface ID {\n        Collection<? extends Comparable<?>> getIds();\n}\n", "IDA.java", "import java.util.Collection;\npublic interface IDA<T1, C1, E1, E2, C2, T2> extends ID {\n        enum Enum1 {\n                ONE, TWO\n        }\n        Collection<IDA.Enum1> getIds();\n}\n"}, "SUCCESS");
        this.runConformTest(new String[]{"S.java", "import java.util.Collection;\npublic class S {\n        public static void cow(IDA<?, ?, ?, ?, ?, ?> s) {\n                Collection<IDA.Enum1> ids = s.getIds();  // Error here\n        }\n\t\tpublic static void main(String[] args) {\n\t\t\tSystem.out.println(\"SUCCESS2\");\n        }\n}\n"}, "SUCCESS2", null, false, null);
    }

    public void test0977() {
        this.runConformTest(new String[]{"MMTPProtocol.java", "import java.io.InputStream;\nimport java.util.HashSet;\nimport bug.ProtocolManager;\nabstract class AbstractProtocol<R, O> implements ProtocolManager<R, O> {\n    public AbstractProtocol(HashSet<O> manager, String grp) {}\n    AbstractProtocol(){} \n     public void connect(ConnectType type) { }\n}\npublic abstract class MMTPProtocol extends AbstractProtocol<InputStream, String> {\n    public void connect(ConnectType type) {}\n}\n", "bug/ProtocolManager.java", "package bug;\npublic interface ProtocolManager<R, O>{\n    public enum ConnectType {Client,Server}\n    public void connect(ConnectType type) ;\n    public boolean receive(R input) throws Exception;\n}"}, "");
        this.runConformTest(new String[]{"MMTPProtocol.java", "import java.io.InputStream;\nimport java.util.HashSet;\nimport bug.ProtocolManager;\nabstract class AbstractProtocol<R, O> implements ProtocolManager<R, O> {\n    public AbstractProtocol(HashSet<O> manager, String grp) {}\n    AbstractProtocol(){} \n     public void connect(ConnectType type) { }\n}\npublic abstract class MMTPProtocol extends AbstractProtocol<InputStream, String> {\n    public void connect(ConnectType type) {}\n}\n"}, "", null, false, null);
    }

    public void test0978() {
        this.runConformTest(new String[]{"B.java", "public class B<T> implements A<T> {\n  public void foo(A.C c) {}\n}", "A.java", "public interface A<T> {\n  void foo(A.C c);\n  class C {}\n}"}, "");
        this.runConformTest(new String[]{"A.java", "public interface A<T> {\n  void foo(A.C c);\n  class C {}\n}"}, "", null, false, null);
    }

    public void test0979() {
        this.runConformTest(new String[]{"B.java", "public class B<T> extends A<T> {\n  @Override\n  public void foo(A.C c) {}\n}", "A.java", "public class A<T> {\n  public void foo(A.C c) {}\n  public static class C {}\n}"}, "");
        this.runConformTest(new String[]{"A.java", "public class A<T> {\n  public void foo(A.C c) {}\n  public static class C {}\n}"}, "", null, false, null);
    }

    public void test0980() {
        this.runConformTest(new String[]{"X.java", "import java.util.Collections;\nimport java.util.Set;\n\npublic class X {\n        public Set<Object> keySet() {\n                return Collections.<Object> emptySet();\n        }\n}"}, "");
    }

    public void test0981() {
        this.runConformTest(new String[]{"Outer.java", "//Outer.java\npublic class Outer<O> {\n  public class Inner {}\n\n  public static void main(String[] args) {\n    System.out.println(\"SUCCESS\");\n  }\n}\n\n", "ExtendedOuter.java", "public class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    public void method(){\n      Worker.method(this);\n    }\n  }\n}\n", "Worker.java", "public class Worker {\n  public static void method(Outer.Inner i) {}\n}\n"}, "SUCCESS");
        this.runConformTest(new String[]{"ExtendedOuter.java", "public class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    public void method(){\n      Worker.method(this);\n    }\n  }\n  public static void main(String[] args) {\n    System.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test0982() {
        this.runConformTest(new String[]{"Outer.java", "//Outer.java\npublic class Outer<O> {\n  public class Inner {\n  \t\tpublic class Inner2 {}\n\t}\n\n  public static void main(String[] args) {\n    System.out.println(\"SUCCESS\");\n  }\n}\n\n", "ExtendedOuter.java", "public class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    class ExtendedInner2 extends Inner2 {\n      public void method(){\n        Worker.method(this);\n      }\n    }\n  }\n}\n", "Worker.java", "public class Worker {\n  public static void method(Outer.Inner.Inner2 i) {}\n}\n"}, "SUCCESS");
        this.runConformTest(new String[]{"ExtendedOuter.java", "public class ExtendedOuter<E> extends Outer<E> {\n  class ExtendedInner extends Inner {\n    class ExtendedInner2 extends Inner2 {\n      public void method(){\n        Worker.method(this);\n      }\n    }\n  }\n  public static void main(String[] args) {\n    System.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test0983() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n    public static void main(String[] args) throws Throwable {\n\tList<?> l1 = new ArrayList<Integer>();\n\tList<?> l2 = new ArrayList<Integer>();\n\tl1.addAll(l2);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tl1.addAll(l2);\n\t   ^^^^^^\nThe method addAll(Collection<? extends capture#1-of ?>) in the type List<capture#1-of ?> is not applicable for the arguments (List<capture#2-of ?>)\n----------\n");
    }

    public void test0984() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public class XX<T> {}\n}", "I.java", "public interface I {\n    X.XX<String> foo();\n}", "Y.java", "public class Y extends X implements I {\n  public XX<String> foo() {\n    return null;\n  }\n}"}, "");
        this.runConformTest(false, new String[]{"Y.java", "public class Y extends X implements I {\n  public XX<String> foo() {\n    return null;\n  }\n}"}, "", "", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test0985() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public void testBreak() {\n        List<Class<Object>>  lco = Arrays.asList(String.class, Integer.class, Long.class);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tList<Class<Object>>  lco = Arrays.asList(String.class, Integer.class, Long.class);\n\t                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Class<? extends Object&Serializable&Comparable<?>>> to List<Class<Object>>\n----------\n", null, true, options);
    }

    public void test0986() {
        this.runConformTest(new String[]{"T.java", "public class T {\n\tpublic T() {\n\t\tS<String> s = new S<String>();\n\t\ts.setObj(\"S\");\n\t\tSystem.out.print(s.getObj());\n\t\tS<Integer> i = new S<Integer>();\n\t\ti.setObj(new Integer(100));\n\t\tSystem.out.print(i.getObj());\n\t\tS<MyClass> m = new S<MyClass>();\n\t\tm.setObj(new MyClass(\"[Terry]\"));\n\t\tSystem.out.print(m.getObj());\n\t\tS<MyClass> x = new S<MyClass>(new MyClass(\"[Corbet]\"));\n\t\tSystem.out.print(x.getObj());\n\t} // End of Constructor for T.\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew T();\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t} catch (Exception ex) {\n\t\t\tex.printStackTrace();\n\t\t}\n\t} // End of main().\n\n\tclass MyClass {\n\t\tprivate String str;\n\t\tpublic MyClass(String str) {\n\t\t\tthis.str = str;\n\t\t} // End of Constructor for MyClass.\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn (\"MyClass = \" + str);\n\t\t} // End of toString().\n\t} // End of Embedded MyClass Class.\n} // End of T Class.\n", "S.java", "public class S<$T> extends B<$T> {\n\tpublic S() {\n\t\tsuper();\n\t} // End of Constructor for S.\n\tpublic S($T obj) {\n\t\tsuper(obj);\n\t} // End of Constructor for S.\n} // End of S Class.\n", "B.java", "public abstract class B<$T> {\n\t$T obj;\n\tpublic B() {\n\t\t;\n\t} // End of Constructor for B.\n\tpublic B($T obj) {\n\t\tthis.obj = obj;\n\t} // End ofg Constructor of B.\n\tpublic $T getObj() {\n\t\treturn (obj);\n\t} // End of getObj().\n\tpublic void setObj($T obj) {\n\t\tthis.obj = obj;\n\t} // End of setObj().\n} // End of B Class."}, "S100MyClass = [Terry]MyClass = [Corbet]SUCCESS");
    }

    public void test0987() {
        String expectedOutput = new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? "----------\n1. ERROR in X.java (at line 11)\n\tpublic ISheetViewer getViewer() { return null; }\t\n\t       ^^^^^^^^^^^^\nThe return type is incompatible with EditPart.getViewer()\n----------\n2. ERROR in X.java (at line 11)\n\tpublic ISheetViewer getViewer() { return null; }\t\n\t                    ^^^^^^^^^^^\nThe method getViewer() of type AbstractLinkView<M> must override a superclass method\n----------\n" : "----------\n1. ERROR in X.java (at line 11)\n\tpublic ISheetViewer getViewer() { return null; }\t\n\t       ^^^^^^^^^^^^\nThe return type is incompatible with EditPart.getViewer()\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar(GLinkElementView<?,?> g) {\n\t\tg.getViewer();\n\t}\n}\n\nabstract class GLinkElementView<M,CM> extends AbstractLinkView<M> {}\n\nabstract class AbstractLinkView<M> extends AbstractConnectionEditPart implements ILinkViewElement {\n\t@Override\n\tpublic ISheetViewer getViewer() { return null; }\t\n}\n\nabstract class AbstractConnectionEditPart implements EditPart {}\n\nabstract class AbstractEditPart implements EditPart {\n\tpublic EditPartViewer getViewer() { return null; }\n}\n\ninterface ILinkViewElement {\n\tpublic ISheetViewer getViewer();\n}\n\ninterface ISheetViewer {}\n\ninterface EditPart {\n\tEditPartViewer getViewer();\n}\n\ninterface EditPartViewer {}\n"}, expectedOutput);
    }

    public void test0988() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar(GLinkElementView<?,?> g) {\n\t\tg.getViewer();\n\t}\n}\n\nabstract class GLinkElementView<M,CM> extends AbstractLinkView<M> {}\n\nabstract class AbstractLinkView<M> extends AbstractConnectionEditPart implements ILinkViewElement, IModelChangeListener {\n\t@Override\n\tpublic SheetViewer getViewer() { return null; }\t\n}\n\nabstract class AbstractConnectionEditPart extends AbstractGraphicalEditPart implements ConnectionEditPart {}\n\nabstract class AbstractGraphicalEditPart extends AbstractEditPart implements GraphicalEditPart {}\n\nabstract class AbstractEditPart implements EditPart {\n\tpublic EditPartViewer getViewer() { return null; }\n}\n\ninterface ILinkViewElement extends INodeViewElement {\n\tpublic ISheetViewer getViewer();\n}\n\nclass SheetViewer implements ISheetViewer {}\n\ninterface ISheetViewer {}\n\ninterface EditPart {\n\tEditPartViewer getViewer();\n}\n\ninterface ConnectionEditPart extends GraphicalEditPart {}\ninterface GraphicalEditPart extends EditPart {}\ninterface EditPartViewer {}\ninterface IModelChangeListener {}\n\ninterface INodeViewElement {\n\tpublic ISheetViewer getViewer();\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tpublic SheetViewer getViewer() { return null; }\t\n\t       ^^^^^^^^^^^\nThe return type is incompatible with AbstractEditPart.getViewer()\n----------\n");
    }

    public void test0989() {
        this.runNegativeTest(new String[]{"Child.java", "public class Child extends Parent<Object> {}\nabstract class Parent<T> extends Grandparent<T> implements IParent {}\ninterface IParent<T> extends IGrandparent<T> {}\nabstract class Grandparent<T> implements IGrandparent<T> {}\ninterface IGrandparent<T> {}"}, "----------\n1. ERROR in Child.java (at line 2)\n\tabstract class Parent<T> extends Grandparent<T> implements IParent {}\n\t               ^^^^^^\nThe interface IGrandparent cannot be implemented more than once with different arguments: IGrandparent<T> and IGrandparent\n----------\n2. WARNING in Child.java (at line 2)\n\tabstract class Parent<T> extends Grandparent<T> implements IParent {}\n\t                                                           ^^^^^^^\nIParent is a raw type. References to generic type IParent<T> should be parameterized\n----------\n");
    }

    public void test0990() {
        this.runNegativeTest(new String[]{"Child.java", "public class Child extends Parent<Object> {}\nabstract class Parent<T> extends Grandparent<T> implements IParent<?> {}\ninterface IParent<T> extends IGrandparent<T> {}\nabstract class Grandparent<T> implements IGrandparent<T> {}\ninterface IGrandparent<T> {}"}, "----------\n1. ERROR in Child.java (at line 1)\n\tpublic class Child extends Parent<Object> {}\n\t             ^^^^^\nThe hierarchy of the type Child is inconsistent\n----------\n2. ERROR in Child.java (at line 2)\n\tabstract class Parent<T> extends Grandparent<T> implements IParent<?> {}\n\t                                                           ^^^^^^^\nThe type Parent cannot extend or implement IParent<?>. A supertype may not specify any wildcard\n----------\n");
    }

    public void test0991() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends SX<String> implements IX<Object> {}\nclass SX<T> extends TX<Thread> implements IX<T> {}\nclass TX<U> implements IX<U> {}\ninterface IX<V> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends SX<String> implements IX<Object> {}\n\t             ^\nThe interface IX cannot be implemented more than once with different arguments: IX<Thread> and IX<Object>\n----------\n2. ERROR in X.java (at line 2)\n\tclass SX<T> extends TX<Thread> implements IX<T> {}\n\t      ^^\nThe interface IX cannot be implemented more than once with different arguments: IX<Thread> and IX<T>\n----------\n");
    }

    public void test0992() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic abstract class X<T0> implements Collection, I<T0> {\n\t\n\tvoid foo() {\n\t\tthis.add(new Object());\n\t\tthis.add(null);\n\t}\n}\ninterface I<T1> extends Collection<String> {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic abstract class X<T0> implements Collection, I<T0> {\n\t                      ^\nThe interface Collection cannot be implemented more than once with different arguments: Collection<String> and Collection\n----------\n2. WARNING in X.java (at line 2)\n\tpublic abstract class X<T0> implements Collection, I<T0> {\n\t                                       ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. WARNING in X.java (at line 5)\n\tthis.add(new Object());\n\t^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type Collection. References to generic type Collection<E> should be parameterized\n----------\n4. WARNING in X.java (at line 6)\n\tthis.add(null);\n\t^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type Collection. References to generic type Collection<E> should be parameterized\n----------\n");
    }

    public void test0993() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n  public class Inner {\n    Inner() {\n      System.out.println(\"SUCCESS\");\n    }\n  }\n  public static void main(String[] args) {\n    new ATest<X>();\n  }\n}\n\nclass ATest<T extends X> {\n   public ATest() {\n      T instance = makeInstance();\n      X.Inner peq = instance.new Inner(); //**\n   }\n\n   private T makeInstance() {\n      return (T) new X();\n   }\n}"}, null, "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6569404);
    }

    public void test0994() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public class Inner {\n    Inner() {\n      System.out.println(\"SUCCESS\");\n    }\n  }\n  void foo(boolean b, X1 x1, X2 x2) {\n\t  (b ? x1 : x2).new Inner();\n  }\n  public static void main(String[] args) {\n    new X().foo(true, new X1(), new X2());\n  }\n}\n\nclass X1 extends X implements Comparable<X1> {\n  public int compareTo(X1 other) {\n    return 0;\n  }\n}\nclass X2 extends X implements Comparable<X2> {\n  public int compareTo(X2 other) {\n    return 0;\n  }\n}\n"}, "SUCCESS");
    }

    public void _test0995() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public class Inner {\n  }\n  void foo(boolean b, X1 x1, X2 x2) {\n\t  Comparable<? extends X> cx1 = b ? x1 : x2;\n\t  Comparable<X> cx2 = b ? x1 : x2;\n\t  String s = b ? x1 : x2;\n  }\n}\n\nabstract class X1 extends X implements Comparable<X1> {}\nabstract class X2 extends X implements Comparable<X2> {}"}, "SUCCESS");
    }

    public void test0996() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X<T> {\n  private T aObject = null;\n  public static <U> List<U> castList(final List<? extends Object> pList, final Class<U> pClass) {\n    final List<U> result = new ArrayList<U>();\n    for (Object o:pList) {\n      if (pClass.isInstance(o)) {\n        result.add(pClass.cast(o));\n      }\n    }\n    return result;\n  }\n\n  public static void main(final String[] pArgs) {\n    final List<Object> l1 = new ArrayList<Object>();\n    l1.add(new X<String>());\n    l1.add(new X<String>());\n    final List<X<?>> l2 = castList(l1, List.class);\n    \n    List<X> l3 = l2;\n    List<X<String>> l4 = null;\n    l3 = l4;\n  }\n\n}\n"}, "----------\n1. ERROR in X.java (at line 20)\n\tfinal List<X<?>> l2 = castList(l1, List.class);\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<List> to List<X<?>>\n----------\n2. WARNING in X.java (at line 22)\n\tList<X> l3 = l2;\n\t     ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. ERROR in X.java (at line 22)\n\tList<X> l3 = l2;\n\t             ^^\nType mismatch: cannot convert from List<X<?>> to List<X>\n----------\n4. ERROR in X.java (at line 24)\n\tl3 = l4;\n\t     ^^\nType mismatch: cannot convert from List<X<String>> to List<X>\n----------\n");
    }

    public void test0997() {
        this.runConformTest(true, new String[]{"X.java", "public class X implements Outer {\n  public static void main(String[] args) {\n    new ATest<X>();\n  }\n}\ninterface Outer {\n  public class Inner {\n    Inner() {\n      System.out.println(\"SUCCESS\");\n    }\n  }\n}\n\nclass ATest<T extends Outer> {\n   public ATest() {\n      Outer.Inner peq = new T.Inner(); //**\n   }\n\n   private T makeInstance() {\n      return (T) new X();\n   }\n}"}, null, "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6569404);
    }

    public void test0998() {
        this.runConformTest(new String[]{"X.java", "class X {\n    static abstract class Generic<F> {\n        static class Inner {\n            static class InnerInner { }\n            InnerInner createTableModel() {\n                return new InnerInner();\n            }\n        }\n    }\n    static class SubGeneric<S> extends Generic<S> {\n        static class SubInner extends Inner {\n            InnerInner createTableModel() {\n                return super.createTableModel(); \n            }\n        }\n    }\n}"}, "");
    }

    public void test0999() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static final <T,E extends T> Iterator<T> chain(Iterator<E>... it) {\n\t\treturn null;\n\t}\n\tvoid foo1() {\n\t\tList<Integer> l1 = Arrays.asList(1, 2, 3);\n\t\tList<Float> l2 = Arrays.asList(4f, 5f, 6f);\n\t\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t}\n\tvoid foo2() {\n\t\tList<Integer> l1 = Arrays.asList(1, 2, 3);\n\t\tList<Float> l2 = Arrays.asList(4f, 5f, 6f);\n\t\tIterator<Number> it2 = X.chain(l1.iterator(), l2.iterator());\n\t}\n\tvoid foo3() {\n\t\tList<Integer> l1 = Arrays.asList(1, 2, 3);\n\t\tIterator<Number> it2 = X.chain(l1.iterator(), l1.iterator());\n\t}\n}"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation chain(Iterator[]) of the generic method chain(Iterator<E>...) of type X\n----------\n2. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator needs unchecked conversion to conform to Iterator<Number>\n----------\n3. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator[] needs unchecked conversion to conform to Iterator<Number>[]\n----------\n4. ERROR in X.java (at line 14)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l2.iterator());\n\t                         ^^^^^\nThe method chain(Iterator<E>...) in the type X is not applicable for the arguments (Iterator<Integer>, Iterator<Float>)\n----------\n5. WARNING in X.java (at line 18)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l1.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterator<Integer> is created for a varargs parameter\n----------\n" : "----------\n1. WARNING in X.java (at line 3)\n\tpublic static final <T,E extends T> Iterator<T> chain(Iterator<E>... it) {\n\t                                                                     ^^\nType safety: Potential heap pollution via varargs parameter it\n----------\n2. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation chain(Iterator[]) of the generic method chain(Iterator<E>...) of type X\n----------\n3. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator needs unchecked conversion to conform to Iterator<Number>\n----------\n4. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator[] needs unchecked conversion to conform to Iterator<Number>[]\n----------\n5. ERROR in X.java (at line 14)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l2.iterator());\n\t                         ^^^^^\nThe method chain(Iterator<E>...) in the type X is not applicable for the arguments (Iterator<Integer>, Iterator<Float>)\n----------\n6. WARNING in X.java (at line 18)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l1.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterator<Integer> is created for a varargs parameter\n----------\n");
    }

    public void test1000() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static final <T> Iterator<T> chain(Iterator<? extends T>... it) {\n\t\treturn null;\n\t}\n\tvoid foo1() {\n\t\tList<Integer> l1 = Arrays.asList(1, 2, 3);\n\t\tList<Float> l2 = Arrays.asList(4f, 5f, 6f);\n\t\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t}\n\tvoid foo2() {\n\t\tList<Integer> l1 = Arrays.asList(1, 2, 3);\n\t\tList<Float> l2 = Arrays.asList(4f, 5f, 6f);\n\t\tIterator<Number> it2 = X.chain(l1.iterator(), l2.iterator());\n\t}\n\tvoid foo3() {\n\t\tList<Integer> l1 = Arrays.asList(1, 2, 3);\n\t\tIterator<Number> it2 = X.chain(l1.iterator(), l1.iterator());\n\t}\n}"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation chain(Iterator[]) of the generic method chain(Iterator<? extends T>...) of type X\n----------\n2. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator needs unchecked conversion to conform to Iterator<Number>\n----------\n3. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator[] needs unchecked conversion to conform to Iterator<? extends Number>[]\n----------\n4. WARNING in X.java (at line 14)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l2.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterator<? extends Number&Comparable<?>> is created for a varargs parameter\n----------\n5. ERROR in X.java (at line 14)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l2.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Iterator<Number&Comparable<?>> to Iterator<Number>\n----------\n6. WARNING in X.java (at line 18)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l1.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterator<? extends Integer> is created for a varargs parameter\n----------\n7. ERROR in X.java (at line 18)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l1.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Iterator<Integer> to Iterator<Number>\n----------\n" : (this.complianceLevel == 0x330000L ? "----------\n1. WARNING in X.java (at line 3)\n\tpublic static final <T> Iterator<T> chain(Iterator<? extends T>... it) {\n\t                                                                   ^^\nType safety: Potential heap pollution via varargs parameter it\n----------\n2. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation chain(Iterator[]) of the generic method chain(Iterator<? extends T>...) of type X\n----------\n3. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator needs unchecked conversion to conform to Iterator<Number>\n----------\n4. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator[] needs unchecked conversion to conform to Iterator<? extends Number>[]\n----------\n5. WARNING in X.java (at line 14)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l2.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterator<? extends Number&Comparable<?>> is created for a varargs parameter\n----------\n6. ERROR in X.java (at line 14)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l2.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Iterator<Number&Comparable<?>> to Iterator<Number>\n----------\n7. WARNING in X.java (at line 18)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l1.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterator<? extends Integer> is created for a varargs parameter\n----------\n8. ERROR in X.java (at line 18)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l1.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Iterator<Integer> to Iterator<Number>\n----------\n" : "----------\n1. WARNING in X.java (at line 3)\n\tpublic static final <T> Iterator<T> chain(Iterator<? extends T>... it) {\n\t                                                                   ^^\nType safety: Potential heap pollution via varargs parameter it\n----------\n2. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation chain(Iterator[]) of the generic method chain(Iterator<? extends T>...) of type X\n----------\n3. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator needs unchecked conversion to conform to Iterator<Number>\n----------\n4. WARNING in X.java (at line 9)\n\tIterator<Number> it1 = X.chain(new Iterator[] { l1.iterator(), l2.iterator() });\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Iterator[] needs unchecked conversion to conform to Iterator<? extends Number>[]\n----------\n5. WARNING in X.java (at line 14)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l2.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterator<? extends Number> is created for a varargs parameter\n----------\n6. WARNING in X.java (at line 18)\n\tIterator<Number> it2 = X.chain(l1.iterator(), l1.iterator());\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of Iterator<? extends Number> is created for a varargs parameter\n----------\n"));
    }

    public void test1001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic class Box<T> {}\n\tstatic class ABox<T extends A> {}\n\tstatic class A {}\n\t\n\tvoid foo(ABox<? extends A> a1, ABox<?> a2) {\n\t\ta1 = a2;\t\n\t}\n}"}, "");
    }

    public void test1002() {
        this.runNegativeTest(new String[]{"Base.java", "class Base {\n}\nclass Foo<U extends Base, V extends Bar<U, Foo<U, V>>> {\n\tU u;\n\tV v;\n}\nclass Bar<E extends Base, F extends Foo<E, Bar<E, F>>> {\n\tE e;\n\tF f;\n}\n"}, "----------\n1. ERROR in Base.java (at line 3)\n\tclass Foo<U extends Base, V extends Bar<U, Foo<U, V>>> {\n\t                                           ^^^\nBound mismatch: The type Foo<U,V> is not a valid substitute for the bounded parameter <F extends Foo<E,Bar<E,F>>> of the type Bar<E,F>\n----------\n2. ERROR in Base.java (at line 7)\n\tclass Bar<E extends Base, F extends Foo<E, Bar<E, F>>> {\n\t                                           ^^^\nBound mismatch: The type Bar<E,F> is not a valid substitute for the bounded parameter <V extends Bar<U,Foo<U,V>>> of the type Foo<U,V>\n----------\n");
    }

    public void test1003() {
        this.runConformTest(new String[]{"B.java", "class B {\n}\nclass S<BB extends B, SS extends S<BB, SS, TT>, TT extends T<BB, SS, TT>> {\n\tBB b;\n\tTT t;\n}\nclass T<BB extends B, SS extends S<BB, SS, TT>, TT extends T<BB, SS, TT>> {\n\tBB b;\n\tSS t;\n}\n"}, "");
    }

    public void test1004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t<B> B getOtherValue() {\n\t\treturn null;\n\t}\n\t<A> A getValue() {\n\t\treturn getOtherValue();\n\t}\n}"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1005() {
        this.runConformTest(true, new String[]{"X.java", "public class X<T1,T2> {\n\n    private static final Object NULL_REF = new Object();\n    private Object data;\n\n    private static <RT> RT unwrap(Object obj) {\n        return (RT)(obj == NULL_REF ? null : obj);\n    }\n\n    public T1 getAsT1() {\n        return unwrap(data);\n    }\n\n    public T2 getAsT2() {\n        return unwrap(data);\n    }\n}"}, null, "", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1005b() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T1,T2> {\n\n    private static final Object NULL_REF = new Object();\n    private Object data;\n\n    private static <RT> RT unwrap(Object obj) {\n        return (RT)(obj == NULL_REF ? null : obj);\n    }\n\n    public T1 getAsT1() {\n        return unwrap(data);\n    }\n\n    public T2 getAsT2() {\n        return unwrap(data);\n    }\n    Zork z;\n}"}, "----------\n1. WARNING in X.java (at line 7)\n\treturn (RT)(obj == NULL_REF ? null : obj);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to RT\n----------\n2. ERROR in X.java (at line 17)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1006() {
        this.runConformTest(new String[]{"X.java", "class Reference<T> {\n\tT target;\n\tReference(T target) {\n\t\tthis.target = target;\n\t}\n\tT deref() {\n\t\treturn this.target;\n\t}\n\tstatic <U> Reference<U> create(U u) {\n\t\treturn new Reference<U>(u);\n\t}\n}\nclass BaseObject {}\nclass Person extends BaseObject {}\nclass Building extends BaseObject {}\n\npublic class X {\n\tvoid foo(Building b, Person p) {\n\t\tReference<Building> bRef = Reference.create(b);\n\t\tReference<Person> pRef = Reference.create(p);\n\n\t\tfinal Building building = bRef.deref();\n\t\tfinal Person person = pRef.deref();\n\t}\n}"}, "");
    }

    public void test1007() {
        this.runNegativeTest(new String[]{"GenericsProblem.java", "public class GenericsProblem {\n\tpublic <T> void test(T val) {\n\t\tGenericsProblem gp = new GenericsProblem();\n\t\tClass<? extends GenericsProblem> cl2 = gp.getClass();\n\t\tClass<? extends T> cl = val.getClass();\n\t}\n}\n"}, "----------\n1. ERROR in GenericsProblem.java (at line 5)\n\tClass<? extends T> cl = val.getClass();\n\t                        ^^^^^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#2-of ? extends Object> to Class<? extends T>\n----------\n");
    }

    public void test1008() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(L l, C<? extends X> c) {\n\t\tX x = bar(l, c);\n\t}\n\t<T> T bar(L<T> l, C<? extends T> c) { \n\t\treturn zork;\n\t}\t\n}\nclass C<E> {}\nclass L<E> {}\n\n\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(L l, C<? extends X> c) {\n\t         ^\nL is a raw type. References to generic type L<E> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tX x = bar(l, c);\n\t      ^^^^^^^^^\nType safety: Unchecked invocation bar(L, C<capture#1-of ? extends X>) of the generic method bar(L<T>, C<? extends T>) of type X\n----------\n3. WARNING in X.java (at line 3)\n\tX x = bar(l, c);\n\t          ^\nType safety: The expression of type L needs unchecked conversion to conform to L<X>\n----------\n4. ERROR in X.java (at line 6)\n\treturn zork;\n\t       ^^^^\nzork cannot be resolved to a variable\n----------\n");
    }

    public void test1009() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\npublic class X {\n\n\tvoid foo(Map<String,Map> map) {\n\t\tbar(map);\n\t}\n\t<U,V> void bar(Map<U,Map<U,V>> map) {\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid foo(Map<String,Map> map) {\n\t                    ^^^\nMap is a raw type. References to generic type Map<K,V> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tbar(map);\n\t^^^\nThe method bar(Map<U,Map<U,V>>) in the type X is not applicable for the arguments (Map<String,Map>)\n----------\n");
    }

    public void test1010() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\npublic class X {\n\n\tvoid foo(Map<String,Map> map) {\n\t\tbar(map);\n\t}\n\t<U,V> void bar(Map<U,? extends Map<U,V>> map) {\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid foo(Map<String,Map> map) {\n\t                    ^^^\nMap is a raw type. References to generic type Map<K,V> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tbar(map);\n\t^^^\nThe method bar(Map<U,? extends Map<U,V>>) in the type X is not applicable for the arguments (Map<String,Map>)\n----------\n");
    }

    public void test1011() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid foo(HashMap map, String s, Map<String,String> map2) {\n\t\tbar(map, s, map2); //1\n\t\tbar(map2, s, map2); //2\n\t\tbar2(map, s, map2); //3\n\t\tbar3(map, s, map2); //4\n\t}\n\t<U> void bar(Map<U,U> map, U u, Map<U,U> map2) {}\n\tvoid bar2(Map<String,String> map, String s, Map<String,String> map2) {}\n\t<U> void bar3(Map<String,String> map, U s, Map<U,U> map2) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo(HashMap map, String s, Map<String,String> map2) {\n\t         ^^^^^^^\nHashMap is a raw type. References to generic type HashMap<K,V> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tbar(map, s, map2); //1\n\t^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation bar(HashMap, String, Map<String,String>) of the generic method bar(Map<U,U>, U, Map<U,U>) of type X\n----------\n3. WARNING in X.java (at line 4)\n\tbar(map, s, map2); //1\n\t    ^^^\nType safety: The expression of type HashMap needs unchecked conversion to conform to Map<String,String>\n----------\n4. WARNING in X.java (at line 6)\n\tbar2(map, s, map2); //3\n\t     ^^^\nType safety: The expression of type HashMap needs unchecked conversion to conform to Map<String,String>\n----------\n5. WARNING in X.java (at line 7)\n\tbar3(map, s, map2); //4\n\t^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation bar3(HashMap, String, Map<String,String>) of the generic method bar3(Map<String,String>, U, Map<U,U>) of type X\n----------\n6. WARNING in X.java (at line 7)\n\tbar3(map, s, map2); //4\n\t     ^^^\nType safety: The expression of type HashMap needs unchecked conversion to conform to Map<String,String>\n----------\n");
    }

    public void test1012() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(L l, C<X> c) {\n\t\tX x = bar1(l, c);\n\t\tL<X> lx = bar2(l, c);\n\t\tC<X> cx = bar3(l, c);\n\t}\n\t<T> T bar1(L<T> l, C<T> c) {\n\t\treturn null;\n\t}\n\t<T> L<T> bar2(L<T> l, C<T> c) {\n\t\treturn null;\n\t}\n\t<T> C<T> bar3(L<T> l, C<T> c) {\n\t\treturn zork;\n\t}\n}\n\nclass C<E> {}\nclass L<E> {}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(L l, C<X> c) {\n\t         ^\nL is a raw type. References to generic type L<E> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tX x = bar1(l, c);\n\t      ^^^^^^^^^^\nType safety: Unchecked invocation bar1(L, C<X>) of the generic method bar1(L<T>, C<T>) of type X\n----------\n3. WARNING in X.java (at line 3)\n\tX x = bar1(l, c);\n\t           ^\nType safety: The expression of type L needs unchecked conversion to conform to L<X>\n----------\n4. WARNING in X.java (at line 4)\n\tL<X> lx = bar2(l, c);\n\t          ^^^^^^^^^^\nType safety: Unchecked invocation bar2(L, C<X>) of the generic method bar2(L<T>, C<T>) of type X\n----------\n5. WARNING in X.java (at line 4)\n\tL<X> lx = bar2(l, c);\n\t          ^^^^^^^^^^\nType safety: The expression of type L needs unchecked conversion to conform to L<X>\n----------\n6. WARNING in X.java (at line 4)\n\tL<X> lx = bar2(l, c);\n\t               ^\nType safety: The expression of type L needs unchecked conversion to conform to L<X>\n----------\n7. WARNING in X.java (at line 5)\n\tC<X> cx = bar3(l, c);\n\t          ^^^^^^^^^^\nType safety: Unchecked invocation bar3(L, C<X>) of the generic method bar3(L<T>, C<T>) of type X\n----------\n8. WARNING in X.java (at line 5)\n\tC<X> cx = bar3(l, c);\n\t          ^^^^^^^^^^\nType safety: The expression of type C needs unchecked conversion to conform to C<X>\n----------\n9. WARNING in X.java (at line 5)\n\tC<X> cx = bar3(l, c);\n\t               ^\nType safety: The expression of type L needs unchecked conversion to conform to L<X>\n----------\n10. ERROR in X.java (at line 14)\n\treturn zork;\n\t       ^^^^\nzork cannot be resolved to a variable\n----------\n");
    }

    public void test1013() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<String> ls = new ArrayList<String>();\n\t\tls.add(\"foo\");\n\t\tList<X> lx = new ArrayList<X>();\n\t\tlx.add(new X());\n\t\tnew X().foo(ls, lx);\n\t}\n\tvoid done() {\n\t\tSystem.out.println(zork);\n\t}\n\tvoid foo(List l1, List<X> l2) {\n\t\tX x = bar1(l1, l2);\n\t\tx.done();\n\t\tList<X> lx = bar2(l1, l2);\n\t\tlx.get(0).done();\n\t}\n\t<T> T bar1(List<T> l1, List<T> l2) {\n\t\treturn l1.get(0);\n\t}\n\t<T> List<T> bar2(List<T> l1, List<T> l2) {\n\t\treturn l1;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tSystem.out.println(zork);\n\t                   ^^^^\nzork cannot be resolved to a variable\n----------\n2. WARNING in X.java (at line 14)\n\tvoid foo(List l1, List<X> l2) {\n\t         ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 15)\n\tX x = bar1(l1, l2);\n\t      ^^^^^^^^^^^^\nType safety: Unchecked invocation bar1(List, List<X>) of the generic method bar1(List<T>, List<T>) of type X\n----------\n4. WARNING in X.java (at line 15)\n\tX x = bar1(l1, l2);\n\t           ^^\nType safety: The expression of type List needs unchecked conversion to conform to List<X>\n----------\n5. WARNING in X.java (at line 17)\n\tList<X> lx = bar2(l1, l2);\n\t             ^^^^^^^^^^^^\nType safety: Unchecked invocation bar2(List, List<X>) of the generic method bar2(List<T>, List<T>) of type X\n----------\n6. WARNING in X.java (at line 17)\n\tList<X> lx = bar2(l1, l2);\n\t             ^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<X>\n----------\n7. WARNING in X.java (at line 17)\n\tList<X> lx = bar2(l1, l2);\n\t                  ^^\nType safety: The expression of type List needs unchecked conversion to conform to List<X>\n----------\n");
    }

    public void test1014() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tvoid foo1(List l, List<String> ls) {\n\t\tSet<Map.Entry<String,String>> mss1 = bar(l, ls).entrySet();\n\t\tString s = bar(l, ls).entrySet();\n\t}\n\t<U,V> Map<U,V> bar(List<U> lu, List<V> lv) { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid foo1(List l, List<String> ls) {\n\t          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tSet<Map.Entry<String,String>> mss1 = bar(l, ls).entrySet();\n\t                                     ^^^^^^^^^^\nType safety: Unchecked invocation bar(List, List<String>) of the generic method bar(List<U>, List<V>) of type X\n----------\n3. WARNING in X.java (at line 5)\n\tSet<Map.Entry<String,String>> mss1 = bar(l, ls).entrySet();\n\t                                     ^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Set needs unchecked conversion to conform to Set<Map.Entry<String,String>>\n----------\n4. WARNING in X.java (at line 5)\n\tSet<Map.Entry<String,String>> mss1 = bar(l, ls).entrySet();\n\t                                         ^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n5. WARNING in X.java (at line 6)\n\tString s = bar(l, ls).entrySet();\n\t           ^^^^^^^^^^\nType safety: Unchecked invocation bar(List, List<String>) of the generic method bar(List<U>, List<V>) of type X\n----------\n6. ERROR in X.java (at line 6)\n\tString s = bar(l, ls).entrySet();\n\t           ^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Set to String\n----------\n7. WARNING in X.java (at line 6)\n\tString s = bar(l, ls).entrySet();\n\t               ^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n");
    }

    public void test1015() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid foo1(List l, List<String> ls) {\n\t\tList<String> ls1 = bar(l, ls);\n\t\tString s = bar(l, ls);\n\t}\n\t<U,V> List<V> bar(List<U> lu, List<V> lv) { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo1(List l, List<String> ls) {\n\t          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tList<String> ls1 = bar(l, ls);\n\t                   ^^^^^^^^^^\nType safety: Unchecked invocation bar(List, List<String>) of the generic method bar(List<U>, List<V>) of type X\n----------\n3. WARNING in X.java (at line 4)\n\tList<String> ls1 = bar(l, ls);\n\t                   ^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n4. WARNING in X.java (at line 4)\n\tList<String> ls1 = bar(l, ls);\n\t                       ^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n5. WARNING in X.java (at line 5)\n\tString s = bar(l, ls);\n\t           ^^^^^^^^^^\nType safety: Unchecked invocation bar(List, List<String>) of the generic method bar(List<U>, List<V>) of type X\n----------\n6. ERROR in X.java (at line 5)\n\tString s = bar(l, ls);\n\t           ^^^^^^^^^^\nType mismatch: cannot convert from List to String\n----------\n7. WARNING in X.java (at line 5)\n\tString s = bar(l, ls);\n\t               ^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n");
    }

    public void test1016() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid foo1() {\n\t\tList ls1 = bar(null);\n\t\tList<String> ls2 = bar(null);\n\t\tString s = bar(null);\n\t}\n\t<U> List<U> bar(List<U> lu) { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tList ls1 = bar(null);\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in X.java (at line 6)\n\tString s = bar(null);\n\t           ^^^^^^^^^\nType mismatch: cannot convert from List<Object> to String\n----------\n");
    }

    public void test1017() {
        this.runNegativeTest(new String[]{"SortedList.java", "import java.util.*;\n\npublic class SortedList<E extends Comparable> extends LinkedList<E>\n{\n    public boolean add(E e){\n      int index = Collections.binarySearch(this,e);\n      if (index<0)\n      super.add(-index-1,e);\n      return true;\n  }\n}"}, "----------\n1. WARNING in SortedList.java (at line 3)\n\tpublic class SortedList<E extends Comparable> extends LinkedList<E>\n\t             ^^^^^^^^^^\nThe serializable class SortedList does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in SortedList.java (at line 3)\n\tpublic class SortedList<E extends Comparable> extends LinkedList<E>\n\t                                  ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n3. WARNING in SortedList.java (at line 5)\n\tpublic boolean add(E e){\n\t               ^^^^^^^^\nThe method add(E) of type SortedList<E> should be tagged with @Override since it actually overrides a superclass method\n----------\n4. ERROR in SortedList.java (at line 6)\n\tint index = Collections.binarySearch(this,e);\n\t                        ^^^^^^^^^^^^\nThe method binarySearch(List<? extends Comparable<? super T>>, T) in the type Collections is not applicable for the arguments (SortedList<E>, E)\n----------\n");
    }

    public void test1018() {
        this.runConformTest(new String[]{"X.java", "public class X<U,V> {\n\n\tvoid foo(U u) {\n\t\tbar(u, new Exception());\n\t}\n\t<T extends Exception> T bar(U u, T t) { return null; }\n}"}, "");
    }

    public void test1018a() {
        this.runConformTest(true, new String[]{"X.java", "class A<T> {}\n\nclass B<E> extends A<X<String>> {}\n\npublic class X<E extends String> extends B<E> {\n    public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}"}, null, "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tdouble[] d1 = new double[] { 1.0, 2.0, 3.0, 4.0 };\n\t\tSystem.out.println(deepToString(d1));\n\n\t\tDouble[] d2 = new Double[] { 1.0, 2.0, 3.0, 4.0 };\n\t\tSystem.out.println(deepToString(d2));\n\t\n\t}\n\n\tpublic static <T> String deepToString(T[] array) {\n\t\tStringBuffer s = new StringBuffer();\n\t\tfor (T t : array) {\n\t\t\ts.append(t.toString());\n\t\t\ts.append(\",\");\n\t\t}\n\t\tif (s.length() > 0) {\n\t\t\ts.setLength(s.length() - 1); // removes last \",\"\n\t\t}\n\t\treturn s.toString();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tSystem.out.println(deepToString(d1));\n\t                   ^^^^^^^^^^^^\nThe method deepToString(T[]) in the type X is not applicable for the arguments (double[])\n----------\n");
    }

    public void test1020() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tvoid foo(List<? extends Exception> l1, List<? extends Exception> l2) {\n\t\tl1.add(l2.get(0));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tl1.add(l2.get(0));\n\t   ^^^\nThe method add(capture#1-of ? extends Exception) in the type List<capture#1-of ? extends Exception> is not applicable for the arguments (capture#2-of ? extends Exception)\n----------\n");
    }

    public void test1021() {
        this.runConformTest(new String[]{"p/SomeClass.java", "package p;\nimport static p.SomeClass.SomeEnum.*;\npublic abstract class SomeClass<T> extends Object {\n\tpublic enum SomeEnum {\n\t\tA;\n\t};\n}\n"}, "");
    }

    public void test1021b() {
        this.runNegativeTest(new String[]{"p/SomeClass2.java", "package p;\nimport static p.SomeClass2.M1.*;\npublic abstract class SomeClass2<T> extends M {\n\tpublic static class M1 extends M2 {}\n\tpublic static class M2 extends M3 {}\n\tpublic static class M3 {\n\t\tpublic static class M {}\n\t}\n}\n"}, "----------\n1. ERROR in p\\SomeClass2.java (at line 3)\n\tpublic abstract class SomeClass2<T> extends M {\n\t                                            ^\nCycle detected: the type SomeClass2<T> cannot extend/implement itself or one of its own member types\n----------\n");
    }

    public void test1021c() {
        this.runConformTest(new String[]{"ccs/jdtbug/filters/NameRF.java", "package ccs.jdtbug.filters;\nimport static ccs.jdtbug.ResultFilter.Action.*;\nimport ccs.jdtbug.*;\npublic class NameRF implements ResultFilter<String> {\n\tpublic NameRF() {}\n\tpublic Action getAction(String in, int ntotal, int naccept) {\n\t\treturn YES;\n\t}\n} // end class\n", "ccs/jdtbug/ResultFilter.java", "package ccs.jdtbug;\nimport java.io.*;\npublic interface ResultFilter<T> {\n\tpublic enum Action {\n\t\tYES, NO, CANCEL\n\t}\n\tpublic Action getAction(T in, int ntotal, int naccept) throws IOException;\n} // end interface\n"});
    }

    public void test1022() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tString testString = \"test string\";\n\n\t\ttestWithNonGeneric(testString);\n\t\ttestWithGeneric(testString);\n\t}\n\n\tprivate static void testWithNonGeneric(String input) {\n\t\tClass<? extends String> clazz = input.getClass();\n\n\t\tSystem.out.println(clazz.getName());\n\t}\n\n\tprivate static <T> void testWithGeneric(T input) {\n\t\tClass<? extends T> clazz = input.getClass();\n\n\t\tSystem.out.println(clazz.getName());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 16)\n\tClass<? extends T> clazz = input.getClass();\n\t                           ^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#3-of ? extends Object> to Class<? extends T>\n----------\n");
    }

    public void test1023() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\nimport java.util.Properties;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tProperties props = new Properties();\n\t\tfor (Map.Entry<String, ?> entry : props.entrySet()) {\n\t\t\tSystem.out.println(entry);\n\t\t}\n\t\tfor (Map.Entry<String, ?> entry : ((Map<String, ?>) props).entrySet()) {\n\t\t\tSystem.out.println(entry);\n\t\t}\n\t\tfor (Map.Entry<Object, ?> entry : ((Map<Object, ?>) props).entrySet()) {\n\t\t\tSystem.out.println(entry);\n\t\t}\n\t\tfor (Map.Entry<Object, ?> entry : props.entrySet()) {\n\t\t\tSystem.out.println(entry);\n\t\t}\n\t\tfor (Map.Entry<?, ?> entry : ((Map<?, ?>) props).entrySet()) {\n\t\t\tSystem.out.println(entry);\n\t\t}\n\t\tfor (Map.Entry<?, ?> entry : props.entrySet()) {\n\t\t\tSystem.out.println(entry);\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tfor (Map.Entry<String, ?> entry : props.entrySet()) {\n\t                                  ^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from element type Map.Entry<Object,Object> to Map.Entry<String,?>\n----------\n2. ERROR in X.java (at line 11)\n\tfor (Map.Entry<String, ?> entry : ((Map<String, ?>) props).entrySet()) {\n\t                                  ^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from Properties to Map<String,?>\n----------\n");
    }

    public void test1024() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger castInteger = genericCast(1); // works\n\t\tint castInt1 = genericCast(1); // fails in javac but works in Eclipse\n\t\tint castInt2 = X.<Integer> genericCast(1); // workaround for javac\n\t\tint castInt3 = (Integer) genericCast(1); // workaround for javac\n\t}\n\tprivate static <T> T genericCast(Object input) {\n\t\t@SuppressWarnings(\"unchecked\")\n\t\tT castValue = (T) input;\n\t\treturn castValue;\n\t}\n}"}, null, "", null, AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug151275);
    }

    public void test1025() {
        this.runConformTest(new String[]{"GenericBaseClass.java", "public class GenericBaseClass<P, C> {\n  public GenericBaseClass() {\n    if (!(this instanceof ASubGenericClass)) {\n      System.out.println(\"I'm not ASubClass\");\n    }\n  }\n}\n\nclass ASubGenericClass extends GenericBaseClass<GenericBaseClass, GenericBaseClass> {\n  public ASubGenericClass() {\n    // This compiles with both\n    GenericBaseClass<GenericBaseClass, GenericBaseClass> hey = this;\n  }\n}"}, "");
    }

    public void test1026() {
        this.runConformTest(new String[]{"X.java", "import java.util.LinkedHashSet;\nimport java.util.Set;\n\npublic class X {\n\n    public class A {};\n    public class B extends A {};\n\n\tpublic static void main(String[] args) {\n        X g = new X();\n        Set<A> set = g.newSet(g.new B());\n    }\n    public <T, V extends T> Set<T> newSet(V v) {\n        Set<T> set = new LinkedHashSet<T>();\n        set.add(v);\n        return set;\n    }\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1027() {
        this.runConformTest(new String[]{"X.java", this.complianceLevel < 0x330000L ? "import java.util.LinkedHashSet;\nimport java.util.Set;\n\npublic class X {\n\n    public class A {};\n    public class B extends A {};\n\n    public static void main(String[] args) {\n        X g = new X();\n        Set<A> set = g.newSet(g.new B());\n    }\n    public <T, V extends T> Set<T> newSet(V... objects) {\n        Set<T> set = new LinkedHashSet<T>();\n        for (T t : objects) {\n            set.add(t);\n        }\n        return set;\n    }\n}\n\n" : "import java.util.LinkedHashSet;\nimport java.util.Set;\n\npublic class X {\n\n    public class A {};\n    public class B extends A {};\n\n    public static void main(String[] args) {\n        X g = new X();\n        Set<A> set = g.newSet(g.new B());\n    }\n    @SuppressWarnings(\"unchecked\")\n    public <T, V extends T> Set<T> newSet(V... objects) {\n        Set<T> set = new LinkedHashSet<T>();\n        for (T t : objects) {\n            set.add(t);\n        }\n        return set;\n    }\n}\n\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1028() {
        this.runConformTest(new String[]{"X.java", "import java.util.LinkedHashSet;\nimport java.util.Set;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n        X g = new X();\n        Set<A> set = g.newSet(new B());\n    }\n    public <T, V extends T> Set<T> newSet(V v) {\n        Set<T> set = new LinkedHashSet<T>();\n        set.add(v);\n        return set;\n    }\n}\n\nclass A {};\nclass B extends A {};\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1029() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        String xSource = "import java.util.Arrays;\nimport java.util.List;\n\npublic class X {\n        public static <T extends Number> List<T> makeNumberList(T a, T b) {\n                return Arrays.asList(a, b);\n        }\n\n        public static void main(String... args) {\n                List<Number> name = makeNumberList(5, 5D);\n        }\n}";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 10)\n\tList<Number> name = makeNumberList(5, 5D);\n\t                    ^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Number&Comparable<?>> to List<Number>\n----------\n", null, true, options);
        } else {
            this.runConformTest(new String[]{"X.java", xSource});
        }
    }

    public void test1030() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tpublic class PointList<W> extends Object implements Iterable<W> {\n\t\tprivate List<W> theList = new ArrayList<W>();\n\n\t\tpublic Iterator<W> iterator() {\n\t\t\treturn theList.iterator();\n\t\t}\n" + ITERABLE_IMPL_JRE8.replace('*', 'W') + "\t}\n" + "\n" + "\tprivate PointList<Waypoint> waypoints = new PointList<Waypoint>();\n" + "\n" + "\tpublic void printWaypoints() {\n" + "\t\tfor (Waypoint waypoint : waypoints) { // ***** This line does not compile *****\n" + "\t\t\tSystem.out.println(waypoint.toString());\n" + "\t\t}\n" + "\t\tfor (Iterator<Waypoint> it = waypoints.iterator(); it.hasNext();) {\n" + "\t\t\tWaypoint waypoint = it.next();\n" + "\t\t\tSystem.out.println(waypoint.toString());\n" + "\t\t}\n" + "\t}\n" + "}\n" + "\n" + "class Waypoint {}"}, "");
    }

    public void test1031() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\n\ninterface IValue extends Serializable {\n\tpublic <T extends Comparable<? super T>> T getComparableValue();\n}\n\n@SuppressWarnings(\"null\")\npublic class X {\n\tpublic static void foo0() {\n\t\tIValue val1 = null;\n\t\tObject o = val1.getComparableValue(); // 0\n\t}\n\tpublic static void foo1() {\n\t\tIValue val1 = null;\n\t\tString s = val1.getComparableValue(); // 1\n\t}\n\tpublic static int foo2() {\n\t\tIValue val1 = null;\n\t\tIValue val2 = null;\n\t\treturn val1.getComparableValue().compareTo(val2.getComparableValue()); // 2\n\t}\t\n\tpublic static int foo3() {\n\t\tComparable<? super String> c = \"aaa\"; // 3\n\t\tComparable<? super Object> o = new Object(); // 4\n\t\treturn 0;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 24)\n\tComparable<? super Object> o = new Object(); // 4\n\t                               ^^^^^^^^^^^^\nType mismatch: cannot convert from Object to Comparable<? super Object>\n----------\n");
    }

    public void test1032() {
        this.runConformTest(true, new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\t<T> T test(String name) {\n\n\t\ttry {\n\t\t\tInputStream in = new FileInputStream(name);\n\t\t\treturn (T) new ObjectInputStream(in).readObject();\n\t\t} catch (Exception e) {\n\t\t}\n\t\treturn null;\n\t}\n\n\t<U> U text() {\n\t\treturn test(\"data\");\n\t}\n}"}, null, "", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1032a() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\t<T> T test(String name) {\n\n\t\ttry {\n\t\t\tInputStream in = new FileInputStream(name);\n\t\t\treturn (T) new ObjectInputStream(in).readObject();\n\t\t} catch (Exception e) {\n\t\t}\n\t\treturn null;\n\t}\n\n\t<U> U text() {\n\t\treturn test(\"data\");\n\t}\n\tZork z;\n}"}, "----------\n1. WARNING in X.java (at line 8)\n\treturn (T) new ObjectInputStream(in).readObject();\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to T\n----------\n2. ERROR in X.java (at line 17)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1033() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.bar1(Integer.TYPE);\n\t\tx.bar2(Integer.TYPE);\n\t\tx.bar2(\"\");\n\t} \n\t void bar1(Class<?>... classes) {}\n\t void bar2(Class... classes) {}\n\t \n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tX x = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tX x = new X();\n\t          ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tx.bar1(Integer.TYPE);\n\t^^^^^^^^^^^^^^^^^^^^\nType safety: The method bar1(Class...) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 6)\n\tx.bar2(\"\");\n\t  ^^^^\nThe method bar2(Class...) in the type X is not applicable for the arguments (String)\n----------\n5. WARNING in X.java (at line 9)\n\tvoid bar2(Class... classes) {}\n\t          ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void test1034() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"ChainedClosure.java", "interface Closure<I> {\n    public void execute(I input);\n}\n\nclass ChainedClosure<I> implements Closure<I> {\n    private final Closure<? super I>[] iClosures;\n    @SuppressWarnings(\"unchecked\")\n    public static <I> Closure<I> getInstance(Closure<? super I> closure1, Closure<? super I> closure2) {\n        if (closure1 == null || closure2 == null) {\n            throw new IllegalArgumentException(\"Closures must not be null\");\n        }\n        Closure<I>[] closures = new Closure[] { closure1, closure2 };\n        return new ChainedClosure<I>(closures);\n    }\n    public ChainedClosure(Closure<? super I>[] closures) {\n        super();\n        iClosures = closures;\n    }\n    public void execute(I input) {\n        for (int i = 0; i < iClosures.length; i++) {\n            iClosures[i].execute(input);\n        }\n    }\n}\nclass ClosureUtils {\n    public static <J> Closure<J> chainedClosure(Closure<? super J> closure1, Closure<? super J> closure2) {\n        return ChainedClosure.getInstance(closure1, closure2);\n    }\n    public static Closure<String> chainedClosure2(Closure<? super String> closure1, Closure<? super String> closure2) {\n        return ChainedClosure.getInstance(closure1, closure2);\n    }\n    public static <J> Closure<String> chainedClosure3(Closure<? super J> closure1, Closure<? super J> closure2) {\n        return ChainedClosure.getInstance(closure1, closure2);\n    }\n}"}, "----------\n1. ERROR in ChainedClosure.java (at line 33)\n\treturn ChainedClosure.getInstance(closure1, closure2);\n\t                      ^^^^^^^^^^^\nThe method getInstance(Closure<? super I>, Closure<? super I>) in the type ChainedClosure is not applicable for the arguments (Closure<capture#10-of ? super J>, Closure<capture#11-of ? super J>)\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug236370);
    }

    public void test1035() {
        this.runConformTest(new String[]{"ComparableComparator.java", "import java.util.Comparator;\n\n@SuppressWarnings({\"unchecked\", \"rawtypes\"})\nclass ComparableComparator<T extends Comparable<? super T>> implements Comparator<T> {\n\n\tstatic ComparableComparator instance = new ComparableComparator();\n\npublic static <W extends Comparable<? super W>> ComparableComparator<W> getInstance() {\n\treturn instance;\n}\nstatic <M extends Comparable<M>> Comparator<M> bar() {\n\treturn null;\n}\nstatic <M extends String> Comparator<M> baz() {\n\treturn null;\n}\npublic int compare(T obj1, T obj2) {\n\treturn obj1.compareTo(obj2);\n}\n" + COMPARATOR_IMPL_JRE8.replace('*', 'T').replace('%', 'U').replace('$', 'S') + "}\n" + "\n" + "@SuppressWarnings({\"unchecked\", \"rawtypes\"})\n" + "class ComparatorUtils {\n" + "\n" + "\tstatic Comparator BAR = ComparableComparator.bar();//0\n" + "\tstatic Comparator NATURAL_COMPARATOR = ComparableComparator.getInstance();//1\n" + "\tstatic Object BAR2 = ComparableComparator.bar();//1a\n" + "\tstatic Comparator BAR3 = ComparableComparator.baz();//1b\n" + "\n" + "public static <T extends Comparable<? super T>> Comparator<T> naturalComparator() {\n" + "\treturn NATURAL_COMPARATOR;\n" + "}\n" + "\n" + "public static <U> Comparator<U> nullLowComparator(Comparator<U> comparator) {\n" + "\tif (comparator == null)\n" + "\t\tcomparator = (Comparator<U>) naturalComparator();//2\n" + "\treturn new NullComparator<U>(comparator, false);\n" + "}\n" + "}\n" + "\n" + "@SuppressWarnings(\"unchecked\")\n" + "class NullComparator<V> implements Comparator<V> {\n" + "\n" + "\tComparator<V> nonNullComparator;\n" + "\tboolean nullsAreHigh;\n" + "\n" + "public NullComparator() {\n" + "\tthis((Comparator<V>) ComparableComparator.getInstance(), true);//3\n" + "}\n" + "\n" + "public NullComparator(Comparator<V> nonNullComparator) {\n" + "\tthis(nonNullComparator, true);\n" + "}\n" + "\n" + "public NullComparator(boolean nullsAreHigh) {\n" + "\tthis((Comparator<V>) ComparableComparator.getInstance(), nullsAreHigh);//4\n" + "}\n" + "\n" + "public NullComparator(Comparator<V> nonNullComparator, boolean nullsAreHigh) {\n" + "\tthis.nonNullComparator = nonNullComparator;\n" + "\tthis.nullsAreHigh = nullsAreHigh;\n" + "\tif (nonNullComparator == null) {\n" + "\t\tthrow new NullPointerException(\"null nonNullComparator\");\n" + "\t}\n" + "}\n" + "\n" + "public int compare(V obj1, V obj2) {\n" + "\treturn 0;\n" + "}\n" + COMPARATOR_IMPL_JRE8.replace('*', 'V').replace('%', 'U').replace('$', 'S') + "}"});
    }

    public void test1036() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends String> {\n\t\n\tList<Zork> list;\n\tMap<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry;\n\tjaavaa.util.Map<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry2;\n\t\n\tp.q.Map.Entry entry3;\n\t\n\tString<Object>.Y<List> y; // wrong\n\tX<Object>.Y<List> y1; // wrong\n\tX<String>.Y<List> y2;\n}"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X<T extends String> {\n\t                         ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 3)\n\tList<Zork> list;\n\t^^^^\nList cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 3)\n\tList<Zork> list;\n\t     ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 4)\n\tMap<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry;\n\t^^^\nMap cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 4)\n\tMap<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry;\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\tMap<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry;\n\t         ^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 4)\n\tMap<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry;\n\t                     ^^^^\nList cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 4)\n\tMap<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry;\n\t                          ^^^^\nZork cannot be resolved to a type\n----------\n9. ERROR in X.java (at line 4)\n\tMap<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry;\n\t                                ^^^^\nList cannot be resolved to a type\n----------\n10. ERROR in X.java (at line 4)\n\tMap<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry;\n\t                                     ^^^^\nZork cannot be resolved to a type\n----------\n11. ERROR in X.java (at line 5)\n\tjaavaa.util.Map<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry2;\n\t^^^^^^\njaavaa cannot be resolved to a type\n----------\n12. ERROR in X.java (at line 5)\n\tjaavaa.util.Map<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry2;\n\t                ^^^^\nZork cannot be resolved to a type\n----------\n13. ERROR in X.java (at line 5)\n\tjaavaa.util.Map<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry2;\n\t                     ^^^^\nZork cannot be resolved to a type\n----------\n14. ERROR in X.java (at line 5)\n\tjaavaa.util.Map<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry2;\n\t                                 ^^^^\nList cannot be resolved to a type\n----------\n15. ERROR in X.java (at line 5)\n\tjaavaa.util.Map<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry2;\n\t                                      ^^^^\nZork cannot be resolved to a type\n----------\n16. ERROR in X.java (at line 5)\n\tjaavaa.util.Map<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry2;\n\t                                            ^^^^\nList cannot be resolved to a type\n----------\n17. ERROR in X.java (at line 5)\n\tjaavaa.util.Map<Zork,Zork>.Entry<List<Zork>,List<Zork>>\tentry2;\n\t                                                 ^^^^\nZork cannot be resolved to a type\n----------\n18. ERROR in X.java (at line 7)\n\tp.q.Map.Entry entry3;\n\t^\np cannot be resolved to a type\n----------\n19. ERROR in X.java (at line 9)\n\tString<Object>.Y<List> y; // wrong\n\t^^^^^^\nThe type String is not generic; it cannot be parameterized with arguments <Object>\n----------\n20. ERROR in X.java (at line 10)\n\tX<Object>.Y<List> y1; // wrong\n\t^^^^^^^^^^^\nX.Y cannot be resolved to a type\n----------\n21. ERROR in X.java (at line 10)\n\tX<Object>.Y<List> y1; // wrong\n\t  ^^^^^^\nBound mismatch: The type Object is not a valid substitute for the bounded parameter <T extends String> of the type X<T>\n----------\n22. ERROR in X.java (at line 10)\n\tX<Object>.Y<List> y1; // wrong\n\t            ^^^^\nList cannot be resolved to a type\n----------\n23. ERROR in X.java (at line 11)\n\tX<String>.Y<List> y2;\n\t^^^^^^^^^^^\nX.Y cannot be resolved to a type\n----------\n24. ERROR in X.java (at line 11)\n\tX<String>.Y<List> y2;\n\t            ^^^^\nList cannot be resolved to a type\n----------\n");
    }

    public void test1037() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends String> {\n\t\n\tList<? extends Zork> list;\n\tMap.Entry<?,? super Zork>\tentry;\n}"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X<T extends String> {\n\t                         ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 3)\n\tList<? extends Zork> list;\n\t^^^^\nList cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 3)\n\tList<? extends Zork> list;\n\t               ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 4)\n\tMap.Entry<?,? super Zork>\tentry;\n\t^^^\nMap cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 4)\n\tMap.Entry<?,? super Zork>\tentry;\n\t                    ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1038() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n    int CONST = A.foo();\n}\n\nclass A<U> {\n        static int foo() {\n        System.out.println(\"SUCCESS\");\n        return 0;\n    }\n}\nclass B<V> implements I<V> {\n\tstatic int LOCAL_STATIC;\n\tint local_field;\n    B(int param) {\n        int i = CONST; // keep for possible <clinit>\n        int j = param; // may optimize out\n        int k = LOCAL_STATIC; // may optimize out\n        int l = local_field; // may optimize out\n    }\n}\npublic class X {\n    public static void main(String[] args) {\n        new B<String>(12);\n    }\n}"}, "SUCCESS", null, false, null, options, null);
        String expectedOutput = "  // Method descriptor #10 (I)V\n  // Stack: 1, Locals: 2\n  B(int param);\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [12]\n    4  getstatic B.CONST : int [15]\n    7  pop\n    8  return\n      Line numbers:\n        [pc: 0, line: 14]\n        [pc: 4, line: 15]\n        [pc: 8, line: 19]\n      Local variable table:\n        [pc: 0, pc: 9] local: this index: 0 type: B\n        [pc: 0, pc: 9] local: param index: 1 type: int\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "B.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test1039() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tValue<String> CONST = A.foo(\"[I.CONST]\");\n}\nclass Value<V> {\n\tstatic String NAME = \"\";\n\tV v;\n\tValue(V v) {\n\t\tthis.v = v;\n\t}\n}\nclass A {\n\tstatic Value<String> foo(String str) {\n\t\tSystem.out.print(str);\n\t\treturn new Value<String>(\"str\");\n\t}\n}\nclass B<V> implements I<V> {\n\tstatic Value<String> LOCAL_STATIC = A.foo(\"[B.LOCAL_STATIC]\");\n\tValue<String> local_field = A.foo(\"[B.local_field]\");\n\tB(Value<String> param) {\n\t\tString i = CONST.NAME; // keep for possible <clinit>\n\t\tString j = param.NAME; // may optimize out\n\t\tString k = LOCAL_STATIC.NAME; // may optimize out\n\t\tString l = local_field.NAME; // may optimize out\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew B<String>(new Value<String>(\"[PARAM]\"));\n\t}\n}"}, "[B.LOCAL_STATIC][B.local_field][I.CONST]", null, false, null, options, null);
        String expectedOutput = "  // Method descriptor #28 (LValue;)V\n  // Signature: (LValue<Ljava/lang/String;>;)V\n  // Stack: 2, Locals: 2\n  B(Value param);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [30]\n     4  aload_0 [this]\n     5  ldc <String \"[B.local_field]\"> [32]\n     7  invokestatic A.foo(java.lang.String) : Value [17]\n    10  putfield B.local_field : Value [34]\n    13  getstatic B.CONST : Value [36]\n    16  pop\n    17  getstatic Value.NAME : java.lang.String [39]\n    20  pop\n    21  getstatic Value.NAME : java.lang.String [39]\n    24  pop\n    25  getstatic Value.NAME : java.lang.String [39]\n    28  pop\n    29  getstatic Value.NAME : java.lang.String [39]\n    32  pop\n    33  return\n      Line numbers:\n        [pc: 0, line: 20]\n        [pc: 4, line: 19]\n        [pc: 13, line: 21]\n        [pc: 21, line: 22]\n        [pc: 25, line: 23]\n        [pc: 29, line: 24]\n        [pc: 33, line: 25]\n      Local variable table:\n        [pc: 0, pc: 34] local: this index: 0 type: B\n        [pc: 0, pc: 34] local: param index: 1 type: Value\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "B.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test1040() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tValue<String> CONST = A.foo(\"[I.CONST]\");\n}\nclass Value<V> {\n\tstatic String NAME = \"\";\n\tV v;\n\tValue(V v) {\n\t\tthis.v = v;\n\t}\n}\nclass A {\n\tstatic Value<String> foo(String str) {\n\t\tSystem.out.print(str);\n\t\treturn new Value<String>(\"str\");\n\t}\n}\nclass B<V> implements I<V> {\n\tstatic Value<String> LOCAL_STATIC = A.foo(\"[B.LOCAL_STATIC]\");\n\tValue<String> local_field = A.foo(\"[B.local_field]\");\n\tB(Value<String> param) {\n\t\tString i = this.CONST.NAME; // keep for possible <clinit>\n\t\tString k = this.LOCAL_STATIC.NAME; // may optimize out\n\t\tString l = this.local_field.NAME; // may optimize out\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew B<String>(new Value<String>(\"[PARAM]\"));\n\t}\n}"}, "[B.LOCAL_STATIC][B.local_field][I.CONST]", null, false, null, options, null);
        String expectedOutput = "  // Method descriptor #28 (LValue;)V\n  // Signature: (LValue<Ljava/lang/String;>;)V\n  // Stack: 2, Locals: 2\n  B(Value param);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [30]\n     4  aload_0 [this]\n     5  ldc <String \"[B.local_field]\"> [32]\n     7  invokestatic A.foo(java.lang.String) : Value [17]\n    10  putfield B.local_field : Value [34]\n    13  getstatic B.CONST : Value [36]\n    16  pop\n    17  getstatic Value.NAME : java.lang.String [39]\n    20  pop\n    21  getstatic Value.NAME : java.lang.String [39]\n    24  pop\n    25  getstatic Value.NAME : java.lang.String [39]\n    28  pop\n    29  return\n      Line numbers:\n        [pc: 0, line: 20]\n        [pc: 4, line: 19]\n        [pc: 13, line: 21]\n        [pc: 21, line: 22]\n        [pc: 25, line: 23]\n        [pc: 29, line: 24]\n      Local variable table:\n        [pc: 0, pc: 30] local: this index: 0 type: B\n        [pc: 0, pc: 30] local: param index: 1 type: Value\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "B.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test1041() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\n\npublic class X<T> {\n\t{\n\t\tX rawx = null;\n\t\tX[] rawxs = { rawx };\n\t\tSystem.out.println(rawxs.length);\n\t}\n\t{\n\t\tp.X rawx = null;\n\t\tp.X[] rawxs = { rawx };\n\t\tSystem.out.println(rawxs.length);\n\t}\n\tZork z;\n}"}, "----------\n1. WARNING in p\\X.java (at line 5)\n\tX rawx = null;\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in p\\X.java (at line 6)\n\tX[] rawxs = { rawx };\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in p\\X.java (at line 10)\n\tp.X rawx = null;\n\t^^^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in p\\X.java (at line 11)\n\tp.X[] rawxs = { rawx };\n\t^^^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n5. ERROR in p\\X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1042() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic <T extends Object> void foo(T x) {\n\t    Class<? extends T> c = x.getClass();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tClass<? extends T> c = x.getClass();\n\t                       ^^^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#1-of ? extends Object> to Class<? extends T>\n----------\n");
    }

    public void test1043() {
        this.runNegativeTest(new String[]{"A.java", "class A<T extends Number, S extends T> {\n  T t;\n  S s;\n  void test(A<? extends Long, ? extends S> a) {\n    this.t = this.s; //fine\n    a.t = a.s;\n  }\n}"}, "----------\n1. ERROR in A.java (at line 6)\n\ta.t = a.s;\n\t      ^^^\nType mismatch: cannot convert from capture#4-of ? extends S to capture#1-of ? extends Long\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug159214);
    }

    public void test1044() {
        this.runConformTest(new String[]{"X.java", "class X<T extends Number> {\n    X<? extends Object> x;\n}"}, "");
    }

    public void test1045() {
        this.runConformTest(new String[]{"X.java", "class X<T extends Number, S extends T> {\n        X<? extends Long,? extends S> x;\n}"}, "");
    }

    public void test1046() {
        this.runConformTest(new String[]{"X.java", "public interface X<E extends Object & X.Entry> {\n  interface Entry {\n    interface Internal extends Entry {\n      Internal createEntry();\n    }\n  }\n}\n", "Y.java", "public class Y implements X.Entry.Internal {\n  public Internal createEntry() {\n    return null;\n  }\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "public class Y implements X.Entry.Internal {\n  public Internal createEntry() {\n    return null;\n  }\n}\n"}, "", null, false, null);
    }

    public void test1047() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic interface X<E extends Object & X.Entry> {\n  interface Entry {\n    interface Internal extends Entry {\n      Internal createEntry();\n    }\n  }\n}\n", "Y.java", "import p.X.Entry.Internal;\npublic class Y implements Internal {\n  public Internal createEntry() {\n    return null;\n  }\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "import p.X.Entry.Internal;\npublic class Y implements Internal {\n  public Internal createEntry() {\n    return null;\n  }\n}\n"}, "", null, false, null);
    }

    public void test1048() {
        this.runConformTest(new String[]{"X.java", "public interface X {\n  static class Entry {\n    static abstract class Internal extends Entry {\n      abstract Internal createEntry();\n    }\n  }\n}\n", "Y.java", "public class Y extends  X.Entry.Internal {\n  @Override public Internal createEntry() {\n    return null;\n  }\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "public class Y extends X.Entry.Internal {\n  @Override public Internal createEntry() {\n    return null;\n  }\n}\n"}, "", null, false, null);
    }

    public void test1049() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n}\n\n//===================\ninterface FooHandle<T extends Foo<T>> extends BarHandle<T> {}\ninterface Foo<T extends Foo<T>> extends FooHandle<T>, Bar<T> {\n\tFooHandle<T> foo();\n}\n//===================\ninterface EveHandle<T extends Baz<T>> extends SimpleHandle {}\ninterface Eve<T extends Baz<T>> extends Simple, EveHandle<T> {\n\tList<BobHandle> foo();\n\tBazHandle<T> handles();\n}\n\n//===================\ninterface BobHandle extends BillHandle {}\ninterface Bob extends BobHandle, Bill {}\n\n//===================\ninterface BarHandle<T extends Bar<T>> extends BazHandle<T> {\n\tboolean same(BarHandle<?> o);\n}\ninterface Bar<T extends Bar<T>> extends Baz<T>, BarHandle<T> {\n\tBarHandle<T> handle();\n}\n\n//===================\ninterface BazHandle<T extends Baz<T>> {\n\tT baz();\n\tboolean same(BazHandle<?> o);\n}\ninterface Baz<T extends Baz<T>> extends BazHandle<T> {\n\tBazHandle<T> handle();\n\tT baz();\n}\n\n//===================\ninterface BillHandle extends FooHandle<Bill> {}\ninterface Bill extends BillHandle, Foo<Bill> {}\n\n//===================\ninterface SimpleHandle extends BazHandle<Simple> {}\ninterface Simple extends Baz<Simple>, SimpleHandle {}\n\n//===================\ninterface KeyHandle extends FooHandle<Key> {}\ninterface Key extends Foo<Key>, KeyHandle {}\n\n//===================\ninterface ClydeHandle extends BillHandle {}\ninterface Clyde extends ClydeHandle, Bill {\n\tvoid add(BobHandle h);\n\tpublic List<BobHandle> handles();\n}\n\n//===================\ninterface FredHandle<T extends Fred<T>> extends BarHandle<T> {}\ninterface Fred<T extends Fred<T>> extends FredHandle<T>, Bar<T> {}\n\n"}, "");
    }

    public void test1050() {
        String expectedOutput = "xxx\ntrue\nClassCastException: Object[] cannot be cast to String[]\nClassCastException: Object[] cannot be cast to String[]";
        this.runConformTest(new String[]{"X.java", "class Container<E> {\n  public Container() {\n    data = (E[]) new Object[100];\n  }\n  protected E[] data;\n  protected int size;\n  E get(int index) {\n    return data[index];\n  }\n  void add(E object) {\n    data[size++] = object;\n  }\n  E[] data() {\n    return data;\n  }\n}\nclass StringContainer extends Container<String> {\n  public StringContainer() {\n  }\n  public void doSomething() {\n    add(\"xxx\");\n    System.out.println(get(0));\n    System.out.println((\"\" + data()).\n      startsWith(\"[Ljava.lang.Object;@\"));\n    try {\n      System.out.println(data[0]);\n    } catch (ClassCastException e) {\n      System.out.println(\"ClassCastException: Object[] cannot be cast to String[]\");\n    }\n    try {\n      System.out.println(data()[0]);\n    } catch (ClassCastException e) {\n      System.out.println(\"ClassCastException: Object[] cannot be cast to String[]\");\n    }\n  }\n}\npublic class X {\n  public static void main(String[] args) {\n    StringContainer x = new StringContainer();\n    x.doSomething();\n  }\n}"}, expectedOutput);
    }

    public void test1051() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tpublic interface Intf<N> {\n\t\tvoid foo(List<Conc<N>.Inner> ls);\n\t}\n\n\tpublic class Conc<N> {\n\t\tIntf<N> impl;\n\t\tpublic Conc(Intf<N> impl) {\n\t\t\tthis.impl = impl;\n\t\t}\n\t\tpublic class Inner { }\n\n\t\tpublic void bar(List<Conc<N>.Inner> ls) {\n\t\t\timpl.foo(ls);\n\t\t}\n\t}\n}"}, "");
    }

    public void test1052() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runConformTest(new String[]{"X.java", "public class X extends java.util.ArrayList<Integer> {\n\tprivate static final long serialVersionUID = 713223190582506215L;\n\tstatic void test() {\n\t\tjava.util.ArrayList<?> a1 = new X();\n\t\tX b1 = (X) a1;\n\t\tX c1 = X.class.cast(a1);\n\t\tjava.util.ArrayList<Integer> a2 = new X();\n\t\tX b2 = (X) a2;\n\t}\n}"}, "", null, true, null, options, null);
    }

    public void test1053() {
        this.runConformTest(new String[]{"X.java", "class X<V,R> {\n    class innerclass {\n        void foo() {\n            X<V,R> c = X.this;\n        }\n    }\n}"}, "");
    }

    public void test1054() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        String expectedOutput = "----------\n1. ERROR in X.java (at line 11)\n\tBar bar= clazz.getAnnotation(Bar.class);\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Annotation to Bar\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.reflect.Method;\n\n@Bar\npublic class X {\n\n        @Bar\n        public void bar() throws Exception {\n                Class clazz= X.class;\n                Bar bar= clazz.getAnnotation(Bar.class);\n                Method method= clazz.getMethod(\"bar\");\n                Bar bar2= method.getAnnotation(Bar.class);\n        }\n}\n\n@Retention(RetentionPolicy.RUNTIME)\n@interface Bar {\n}"}, expectedOutput, null, true, customOptions);
    }

    public void test1055() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.reflect.Method;\n\n@Bar\npublic class X {\n\n        @Bar\n        public void bar() throws Exception {\n                Class<X> clazz= X.class;\n                Bar bar= clazz.getAnnotation(Bar.class);\n                Method method= clazz.getMethod(\"bar\");\n                Bar bar2= method.getAnnotation(Bar.class);\n        }\n}\n\n@Retention(RetentionPolicy.RUNTIME)\n@interface Bar {\n}"}, "");
    }

    public void test1056() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic <T> T foo() {\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tString[] s = { foo() };\n\t}\t\n}\n"}, "");
    }

    public void test1057() {
        this.runConformTest(new String[]{"X.java", "import java.util.Map;\n\nclass GenericType<E extends Object & Comparable<E> & Map.Entry<String, E>> {\n\tpublic void doSomething(E e) {\n\t\tSystem.out.println(e.compareTo(e.getValue()));\n\t}\n}\nclass ConcreteType {\n\tpublic void doSomething(Object obj) {\n\t\tSystem.out.println(((Comparable) obj).compareTo(((Map.Entry) obj).getValue()));\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew GenericType().doSomething(\"a1\");\n\t\t} catch (Throwable e) {\n\t\t\tSystem.out.print(\"[\" + e.getClass().getSimpleName() + \":1]\");\n\t\t}\n\t\ttry {\n\t\t\tnew ConcreteType().doSomething(\"a2\");\n\t\t} catch (Throwable e) {\n\t\t\tSystem.out.print(\"[\" + e.getClass().getSimpleName() + \":2]\");\n\t\t}\n\t}\n}\n"}, "[ClassCastException:1][ClassCastException:2]");
    }

    public void test1058() throws Exception {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n        public static void main(String[] args) {\n        \ttry {\n                int foo = 0;\n                String bar = \"zero\";\n                System.out.println((foo != 0 ? foo : bar).compareTo(null));\n        \t} catch(NullPointerException e) {\n        \t\tSystem.out.println(\"SUCCESS\");\n        \t}\n        }\n}"}, "", "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 3, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [foo]\n     2  ldc <String \"zero\"> [16]\n     4  astore_2 [bar]\n     5  getstatic java.lang.System.out : java.io.PrintStream [18]\n     8  iload_1 [foo]\n     9  ifeq 19\n    12  iload_1 [foo]\n    13  invokestatic java.lang.Integer.valueOf(int) : java.lang.Integer [24]\n    16  goto 20\n    19  aload_2 [bar]\n    20  aconst_null\n    21  invokeinterface java.lang.Comparable.compareTo(java.lang.Object) : int [30] [nargs: 2]\n    26  invokevirtual java.io.PrintStream.println(int) : void [36]\n    29  goto 41\n    32  astore_1 [e]\n    33  getstatic java.lang.System.out : java.io.PrintStream [18]\n    36  ldc <String \"SUCCESS\"> [42]\n    38  invokevirtual java.io.PrintStream.println(java.lang.String) : void [44]\n    41  return\n      Exception Table:\n        [pc: 0, pc: 29] -> 32 when : java.lang.NullPointerException\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 2, line: 5]\n        [pc: 5, line: 6]\n        [pc: 29, line: 7]\n        [pc: 33, line: 8]\n        [pc: 41, line: 10]\n      Local variable table:\n        [pc: 0, pc: 42] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 29] local: foo index: 1 type: int\n        [pc: 5, pc: 29] local: bar index: 2 type: java.lang.String\n        [pc: 33, pc: 41] local: e index: 1 type: java.lang.NullPointerException\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test1059() {
        this.runNegativeTest(new String[]{"A.java", "class A<T> {\n    <S> S test(A<S> a) {\n        return null;\n    }\n\n    void m() {\n        A<?> a = null;\n        Number b = test(a);\n    }\n}"}, "----------\n1. ERROR in A.java (at line 8)\n\tNumber b = test(a);\n\t           ^^^^^^^\nType mismatch: cannot convert from capture#1-of ? to Number\n----------\n");
    }

    public void test1060() {
        this.runConformTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.List;\n\npublic class X {\n    public static <B> void m(List<? super B> list,Collection<? super B> coll) {\n        m(list,coll);\n    }\n}"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1061() {
        this.runConformTest(new String[]{"predicate/Predicate.java", "package predicate;\npublic interface Predicate<T> {\n\tpublic boolean evaluate(T object);\n}\nfinal class AndPredicate<T> implements Predicate<T> {\n\tprivate final Predicate<? super T> iPredicate1;\n\tprivate final Predicate<? super T> iPredicate2;\n\tpublic static <T> Predicate<T> getInstance(Predicate<? super T> predicate1,\n\t\t\tPredicate<? super T> predicate2) {\n\t\tif (predicate1 == null || predicate2 == null) {\n\t\t\tthrow new IllegalArgumentException(\"Predicate must not be null\");\n\t\t}\n\t\treturn new AndPredicate<T>(predicate1, predicate2);\n\t}\n\tpublic AndPredicate(Predicate<? super T> predicate1,\n\t\t\tPredicate<? super T> predicate2) {\n\t\tsuper();\n\t\tiPredicate1 = predicate1;\n\t\tiPredicate2 = predicate2;\n\t}\n\tpublic boolean evaluate(T object) {\n\t\treturn iPredicate1.evaluate(object) && iPredicate2.evaluate(object);\n\t}\n}\nclass PredicateUtils {\n\n\tpublic static <T> Predicate<T> andPredicate(\n\t\t\tPredicate<? super T> predicate1, Predicate<? super T> predicate2) {\n\t\treturn AndPredicate.getInstance(predicate1, predicate2);\n\t}\n}"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1062() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.HashSet;\nimport java.util.Iterator;\nimport java.util.Set;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSet<X> set = new HashSet<X>();\n\t\tfor (Iterator<X> iterator = set.iterator(); iterator.hasNext();) {\n\t\t\tSet<X> element1 = iterator.next();\n\t\t\tSet<X> element2 = (Set<X>) iterator.next(); // warning\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tSet<X> element1 = iterator.next();\n\t                  ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X to Set<X>\n----------\n2. WARNING in X.java (at line 10)\n\tSet<X> element2 = (Set<X>) iterator.next(); // warning\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X to Set<X>\n----------\n");
    }

    public void test1063() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.HashSet;\nimport java.util.Iterator;\nimport java.util.Set;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSet<Cloneable> set = new HashSet<Cloneable>();\n\t\tfor (Iterator<Cloneable> iterator = set.iterator(); iterator.hasNext();) {\n\t\t\tSet<Cloneable> element1 = iterator.next();\n\t\t\tSet<Cloneable> element2 = (Set<Cloneable>) iterator.next(); // warning\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tSet<Cloneable> element1 = iterator.next();\n\t                          ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Cloneable to Set<Cloneable>\n----------\n2. WARNING in X.java (at line 10)\n\tSet<Cloneable> element2 = (Set<Cloneable>) iterator.next(); // warning\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Cloneable to Set<Cloneable>\n----------\n");
    }

    public void test1064() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.HashSet;\nimport java.util.Iterator;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tHashSet<X> set = new HashSet<X>();\n\t\tfor (Iterator<X> iterator = set.iterator(); iterator.hasNext();) {\n\t\t\tHashSet<X> element1 = iterator.next();\n\t\t\tHashSet<X> element2 = (HashSet<X>) iterator.next();\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tHashSet<X> element1 = iterator.next();\n\t                      ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X to HashSet<X>\n----------\n2. ERROR in X.java (at line 9)\n\tHashSet<X> element2 = (HashSet<X>) iterator.next();\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot cast from X to HashSet<X>\n----------\n");
    }

    public void test1065() throws Exception {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tvoid testFoo(boolean t, A a, B b) {\n\t\tSystem.out.print((t ? a : b).foo());\n\t}\n\tvoid testBar(boolean t, A a, B b) {\n\t\tSystem.out.print((t ? a : b).bar());\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tA a = new A();\n\t\tB b = new B();\n\t\tx.testFoo(true, a, b);\n\t\tx.testFoo(false, a, b);\n\t\tx.testBar(true, a, b);\n\t\tx.testBar(false, a, b);\n\t}\n}\ninterface Foo { \tString foo(); }\ninterface Bar { String bar(); }\nclass A implements Foo, Bar {\n\tpublic String foo() { return \"[A#foo()]\"; }\n\tpublic String bar() { return \"[A#bar()]\"; }\n}\nclass B implements Foo, Bar {\n\tpublic String foo() { return \"[B#foo()]\"; }\n\tpublic String bar() { return \"[B#bar()]\"; }\n}\n"}, "", "[A#foo()][B#foo()][A#bar()][B#bar()]", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
        String expectedOutput = this.complianceLevel == 0x310000L ? "  // Method descriptor #15 (ZLA;LB;)V\n  // Stack: 2, Locals: 4\n  void testFoo(boolean t, A a, B b);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  iload_1 [t]\n     4  ifeq 11\n     7  aload_2 [a]\n     8  goto 12\n    11  aload_3 [b]\n    12  invokeinterface Foo.foo() : java.lang.String [22] [nargs: 1]\n    17  invokevirtual java.io.PrintStream.print(java.lang.String) : void [28]\n    20  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 20, line: 4]\n      Local variable table:\n        [pc: 0, pc: 21] local: this index: 0 type: X\n        [pc: 0, pc: 21] local: t index: 1 type: boolean\n        [pc: 0, pc: 21] local: a index: 2 type: A\n        [pc: 0, pc: 21] local: b index: 3 type: B\n  \n  // Method descriptor #15 (ZLA;LB;)V\n  // Stack: 2, Locals: 4\n  void testBar(boolean t, A a, B b);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  iload_1 [t]\n     4  ifeq 11\n     7  aload_2 [a]\n     8  goto 12\n    11  aload_3 [b]\n    12  checkcast Bar [41]\n    15  invokeinterface Bar.bar() : java.lang.String [43] [nargs: 1]\n    20  invokevirtual java.io.PrintStream.print(java.lang.String) : void [28]\n    23  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 23, line: 7]\n      Local variable table:\n        [pc: 0, pc: 24] local: this index: 0 type: X\n        [pc: 0, pc: 24] local: t index: 1 type: boolean\n        [pc: 0, pc: 24] local: a index: 2 type: A\n        [pc: 0, pc: 24] local: b index: 3 type: B\n" : "  // Method descriptor #15 (ZLA;LB;)V\n  // Stack: 2, Locals: 4\n  void testFoo(boolean t, A a, B b);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  iload_1 [t]\n     4  ifeq 11\n     7  aload_2 [a]\n     8  goto 12\n    11  aload_3 [b]\n    12  invokeinterface Foo.foo() : java.lang.String [22] [nargs: 1]\n    17  invokevirtual java.io.PrintStream.print(java.lang.String) : void [28]\n    20  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 20, line: 4]\n      Local variable table:\n        [pc: 0, pc: 21] local: this index: 0 type: X\n        [pc: 0, pc: 21] local: t index: 1 type: boolean\n        [pc: 0, pc: 21] local: a index: 2 type: A\n        [pc: 0, pc: 21] local: b index: 3 type: B\n      Stack map table: number of frames 2\n        [pc: 11, same_locals_1_stack_item, stack: {java.io.PrintStream}]\n        [pc: 12, full, stack: {java.io.PrintStream, Foo}, locals: {X, int, A, B}]\n  \n  // Method descriptor #15 (ZLA;LB;)V\n  // Stack: 2, Locals: 4\n  void testBar(boolean t, A a, B b);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  iload_1 [t]\n     4  ifeq 11\n     7  aload_2 [a]\n     8  goto 12\n    11  aload_3 [b]\n    12  checkcast Bar [46]\n    15  invokeinterface Bar.bar() : java.lang.String [48] [nargs: 1]\n    20  invokevirtual java.io.PrintStream.print(java.lang.String) : void [28]\n    23  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 23, line: 7]\n      Local variable table:\n        [pc: 0, pc: 24] local: this index: 0 type: X\n        [pc: 0, pc: 24] local: t index: 1 type: boolean\n        [pc: 0, pc: 24] local: a index: 2 type: A\n        [pc: 0, pc: 24] local: b index: 3 type: B\n      Stack map table: number of frames 2\n        [pc: 11, same_locals_1_stack_item, stack: {java.io.PrintStream}]\n        [pc: 12, full, stack: {java.io.PrintStream, Foo}, locals: {X, int, A, B}]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test1066() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tList l = new ArrayList();\n\t\tl.add(\"zork\");\n\t\tList<A> la = l;\n\t\tList<B> lb = l;\n\t\tboolean t = true, f = false;\n\t\ttry {\n\t\t\tSystem.out.print((t ? la.get(0) : lb.get(0)).foo());\n\t\t} catch (Throwable e) {\n\t\t\tSystem.out.print(\"[\" + e.getClass().getSimpleName() + \":foo(1)]\");\n\t\t}\t\t\n\t\ttry {\n\t\t\tSystem.out.print((f ? la.get(0) : lb.get(0)).foo());\n\t\t} catch (Throwable e) {\n\t\t\tSystem.out.print(\"[\" + e.getClass().getSimpleName() + \":foo(2)]\");\n\t\t}\t\t\n\t\ttry {\n\t\t\tSystem.out.print((t ? la.get(0) : lb.get(0)).bar());\n\t\t} catch (Throwable e) {\n\t\t\tSystem.out.print(\"[\" + e.getClass().getSimpleName() + \":bar(1)]\");\n\t\t}\t\t\n\t\ttry {\n\t\t\tSystem.out.print((f ? la.get(0) : lb.get(0)).bar());\n\t\t} catch (Throwable e) {\n\t\t\tSystem.out.print(\"[\" + e.getClass().getSimpleName() + \":bar(2)]\");\n\t\t}\t\t\n\t}\n}\ninterface Foo { \tString foo(); }\ninterface Bar { String bar(); }\nabstract class A implements Foo, Bar { }\nabstract class B implements Foo, Bar { }\n"}, "[ClassCastException:foo(1)][ClassCastException:foo(2)][ClassCastException:bar(1)][ClassCastException:bar(2)]");
        String expectedOutput = this.complianceLevel == 0x310000L ? "  // Stack: 4, Locals: 8\n  public static void main(java.lang.String[] args);\n      0  new X [1]\n      3  dup\n      4  invokespecial X() [16]\n      7  astore_1 [x]\n      8  new java.util.ArrayList [17]\n     11  dup\n     12  invokespecial java.util.ArrayList() [19]\n     15  astore_2 [l]\n     16  aload_2 [l]\n     17  ldc <String \"zork\"> [20]\n     19  invokeinterface java.util.List.add(java.lang.Object) : boolean [22] [nargs: 2]\n     24  pop\n     25  aload_2 [l]\n     26  astore_3 [la]\n     27  aload_2 [l]\n     28  astore 4 [lb]\n     30  iconst_1\n     31  istore 5 [t]\n     33  iconst_0\n     34  istore 6 [f]\n     36  getstatic java.lang.System.out : java.io.PrintStream [28]\n     39  iload 5 [t]\n     41  ifeq 57\n     44  aload_3 [la]\n     45  iconst_0\n     46  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n     51  checkcast Foo [38]\n     54  goto 68\n     57  aload 4 [lb]\n     59  iconst_0\n     60  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n     65  checkcast Foo [38]\n     68  invokeinterface Foo.foo() : java.lang.String [40] [nargs: 1]\n     73  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n     76  goto 115\n     79  astore 7 [e]\n     81  getstatic java.lang.System.out : java.io.PrintStream [28]\n     84  new java.lang.StringBuilder [50]\n     87  dup\n     88  ldc <String \"[\"> [52]\n     90  invokespecial java.lang.StringBuilder(java.lang.String) [54]\n     93  aload 7 [e]\n     95  invokevirtual java.lang.Object.getClass() : java.lang.Class [56]\n     98  invokevirtual java.lang.Class.getSimpleName() : java.lang.String [60]\n    101  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    104  ldc <String \":foo(1)]\"> [69]\n    106  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    109  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [71]\n    112  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    115  getstatic java.lang.System.out : java.io.PrintStream [28]\n    118  iload 6 [f]\n    120  ifeq 136\n    123  aload_3 [la]\n    124  iconst_0\n    125  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    130  checkcast Foo [38]\n    133  goto 147\n    136  aload 4 [lb]\n    138  iconst_0\n    139  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    144  checkcast Foo [38]\n    147  invokeinterface Foo.foo() : java.lang.String [40] [nargs: 1]\n    152  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    155  goto 194\n    158  astore 7 [e]\n    160  getstatic java.lang.System.out : java.io.PrintStream [28]\n    163  new java.lang.StringBuilder [50]\n    166  dup\n    167  ldc <String \"[\"> [52]\n    169  invokespecial java.lang.StringBuilder(java.lang.String) [54]\n    172  aload 7 [e]\n    174  invokevirtual java.lang.Object.getClass() : java.lang.Class [56]\n    177  invokevirtual java.lang.Class.getSimpleName() : java.lang.String [60]\n    180  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    183  ldc <String \":foo(2)]\"> [74]\n    185  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    188  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [71]\n    191  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    194  getstatic java.lang.System.out : java.io.PrintStream [28]\n    197  iload 5 [t]\n    199  ifeq 215\n    202  aload_3 [la]\n    203  iconst_0\n    204  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    209  checkcast Foo [38]\n    212  goto 226\n    215  aload 4 [lb]\n    217  iconst_0\n    218  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    223  checkcast Foo [38]\n    226  checkcast Bar [76]\n    229  invokeinterface Bar.bar() : java.lang.String [78] [nargs: 1]\n    234  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    237  goto 276\n    240  astore 7 [e]\n    242  getstatic java.lang.System.out : java.io.PrintStream [28]\n    245  new java.lang.StringBuilder [50]\n    248  dup\n    249  ldc <String \"[\"> [52]\n    251  invokespecial java.lang.StringBuilder(java.lang.String) [54]\n    254  aload 7 [e]\n    256  invokevirtual java.lang.Object.getClass() : java.lang.Class [56]\n    259  invokevirtual java.lang.Class.getSimpleName() : java.lang.String [60]\n    262  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    265  ldc <String \":bar(1)]\"> [81]\n    267  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    270  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [71]\n    273  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    276  getstatic java.lang.System.out : java.io.PrintStream [28]\n    279  iload 6 [f]\n    281  ifeq 297\n    284  aload_3 [la]\n    285  iconst_0\n    286  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    291  checkcast Foo [38]\n    294  goto 308\n    297  aload 4 [lb]\n    299  iconst_0\n    300  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    305  checkcast Foo [38]\n    308  checkcast Bar [76]\n    311  invokeinterface Bar.bar() : java.lang.String [78] [nargs: 1]\n    316  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    319  goto 358\n    322  astore 7 [e]\n    324  getstatic java.lang.System.out : java.io.PrintStream [28]\n    327  new java.lang.StringBuilder [50]\n    330  dup\n    331  ldc <String \"[\"> [52]\n    333  invokespecial java.lang.StringBuilder(java.lang.String) [54]\n    336  aload 7 [e]\n    338  invokevirtual java.lang.Object.getClass() : java.lang.Class [56]\n    341  invokevirtual java.lang.Class.getSimpleName() : java.lang.String [60]\n    344  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    347  ldc <String \":bar(2)]\"> [83]\n    349  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    352  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [71]\n    355  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    358  return\n      Exception Table:\n        [pc: 36, pc: 76] -> 79 when : java.lang.Throwable\n        [pc: 115, pc: 155] -> 158 when : java.lang.Throwable\n        [pc: 194, pc: 237] -> 240 when : java.lang.Throwable\n        [pc: 276, pc: 319] -> 322 when : java.lang.Throwable\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 8, line: 5]\n        [pc: 16, line: 6]\n        [pc: 25, line: 7]\n        [pc: 27, line: 8]\n        [pc: 30, line: 9]\n        [pc: 36, line: 11]\n        [pc: 76, line: 12]\n        [pc: 81, line: 13]\n        [pc: 115, line: 16]\n        [pc: 155, line: 17]\n        [pc: 160, line: 18]\n        [pc: 194, line: 21]\n        [pc: 237, line: 22]\n        [pc: 242, line: 23]\n        [pc: 276, line: 26]\n        [pc: 319, line: 27]\n        [pc: 324, line: 28]\n        [pc: 358, line: 30]\n      Local variable table:\n        [pc: 0, pc: 359] local: args index: 0 type: java.lang.String[]\n        [pc: 8, pc: 359] local: x index: 1 type: X\n        [pc: 16, pc: 359] local: l index: 2 type: java.util.List\n        [pc: 27, pc: 359] local: la index: 3 type: java.util.List\n        [pc: 30, pc: 359] local: lb index: 4 type: java.util.List\n        [pc: 33, pc: 359] local: t index: 5 type: boolean\n        [pc: 36, pc: 359] local: f index: 6 type: boolean\n        [pc: 81, pc: 115] local: e index: 7 type: java.lang.Throwable\n        [pc: 160, pc: 194] local: e index: 7 type: java.lang.Throwable\n        [pc: 242, pc: 276] local: e index: 7 type: java.lang.Throwable\n        [pc: 324, pc: 358] local: e index: 7 type: java.lang.Throwable\n      Local variable type table:\n        [pc: 27, pc: 359] local: la index: 3 type: java.util.List<A>\n        [pc: 30, pc: 359] local: lb index: 4 type: java.util.List<B>\n" : "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 4, Locals: 8\n  public static void main(java.lang.String[] args);\n      0  new X [1]\n      3  dup\n      4  invokespecial X() [16]\n      7  astore_1 [x]\n      8  new java.util.ArrayList [17]\n     11  dup\n     12  invokespecial java.util.ArrayList() [19]\n     15  astore_2 [l]\n     16  aload_2 [l]\n     17  ldc <String \"zork\"> [20]\n     19  invokeinterface java.util.List.add(java.lang.Object) : boolean [22] [nargs: 2]\n     24  pop\n     25  aload_2 [l]\n     26  astore_3 [la]\n     27  aload_2 [l]\n     28  astore 4 [lb]\n     30  iconst_1\n     31  istore 5 [t]\n     33  iconst_0\n     34  istore 6 [f]\n     36  getstatic java.lang.System.out : java.io.PrintStream [28]\n     39  iload 5 [t]\n     41  ifeq 57\n     44  aload_3 [la]\n     45  iconst_0\n     46  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n     51  checkcast Foo [38]\n     54  goto 68\n     57  aload 4 [lb]\n     59  iconst_0\n     60  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n     65  checkcast Foo [38]\n     68  invokeinterface Foo.foo() : java.lang.String [40] [nargs: 1]\n     73  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n     76  goto 115\n     79  astore 7 [e]\n     81  getstatic java.lang.System.out : java.io.PrintStream [28]\n     84  new java.lang.StringBuilder [50]\n     87  dup\n     88  ldc <String \"[\"> [52]\n     90  invokespecial java.lang.StringBuilder(java.lang.String) [54]\n     93  aload 7 [e]\n     95  invokevirtual java.lang.Object.getClass() : java.lang.Class [56]\n     98  invokevirtual java.lang.Class.getSimpleName() : java.lang.String [60]\n    101  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    104  ldc <String \":foo(1)]\"> [69]\n    106  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    109  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [71]\n    112  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    115  getstatic java.lang.System.out : java.io.PrintStream [28]\n    118  iload 6 [f]\n    120  ifeq 136\n    123  aload_3 [la]\n    124  iconst_0\n    125  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    130  checkcast Foo [38]\n    133  goto 147\n    136  aload 4 [lb]\n    138  iconst_0\n    139  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    144  checkcast Foo [38]\n    147  invokeinterface Foo.foo() : java.lang.String [40] [nargs: 1]\n    152  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    155  goto 194\n    158  astore 7 [e]\n    160  getstatic java.lang.System.out : java.io.PrintStream [28]\n    163  new java.lang.StringBuilder [50]\n    166  dup\n    167  ldc <String \"[\"> [52]\n    169  invokespecial java.lang.StringBuilder(java.lang.String) [54]\n    172  aload 7 [e]\n    174  invokevirtual java.lang.Object.getClass() : java.lang.Class [56]\n    177  invokevirtual java.lang.Class.getSimpleName() : java.lang.String [60]\n    180  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    183  ldc <String \":foo(2)]\"> [74]\n    185  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    188  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [71]\n    191  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    194  getstatic java.lang.System.out : java.io.PrintStream [28]\n    197  iload 5 [t]\n    199  ifeq 215\n    202  aload_3 [la]\n    203  iconst_0\n    204  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    209  checkcast Foo [38]\n    212  goto 226\n    215  aload 4 [lb]\n    217  iconst_0\n    218  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    223  checkcast Foo [38]\n    226  checkcast Bar [76]\n    229  invokeinterface Bar.bar() : java.lang.String [78] [nargs: 1]\n    234  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    237  goto 276\n    240  astore 7 [e]\n    242  getstatic java.lang.System.out : java.io.PrintStream [28]\n    245  new java.lang.StringBuilder [50]\n    248  dup\n    249  ldc <String \"[\"> [52]\n    251  invokespecial java.lang.StringBuilder(java.lang.String) [54]\n    254  aload 7 [e]\n    256  invokevirtual java.lang.Object.getClass() : java.lang.Class [56]\n    259  invokevirtual java.lang.Class.getSimpleName() : java.lang.String [60]\n    262  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    265  ldc <String \":bar(1)]\"> [81]\n    267  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    270  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [71]\n    273  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    276  getstatic java.lang.System.out : java.io.PrintStream [28]\n    279  iload 6 [f]\n    281  ifeq 297\n    284  aload_3 [la]\n    285  iconst_0\n    286  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    291  checkcast Foo [38]\n    294  goto 308\n    297  aload 4 [lb]\n    299  iconst_0\n    300  invokeinterface java.util.List.get(int) : java.lang.Object [34] [nargs: 2]\n    305  checkcast Foo [38]\n    308  checkcast Bar [76]\n    311  invokeinterface Bar.bar() : java.lang.String [78] [nargs: 1]\n    316  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    319  goto 358\n    322  astore 7 [e]\n    324  getstatic java.lang.System.out : java.io.PrintStream [28]\n    327  new java.lang.StringBuilder [50]\n    330  dup\n    331  ldc <String \"[\"> [52]\n    333  invokespecial java.lang.StringBuilder(java.lang.String) [54]\n    336  aload 7 [e]\n    338  invokevirtual java.lang.Object.getClass() : java.lang.Class [56]\n    341  invokevirtual java.lang.Class.getSimpleName() : java.lang.String [60]\n    344  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    347  ldc <String \":bar(2)]\"> [83]\n    349  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [65]\n    352  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [71]\n    355  invokevirtual java.io.PrintStream.print(java.lang.String) : void [44]\n    358  return\n      Exception Table:\n        [pc: 36, pc: 76] -> 79 when : java.lang.Throwable\n        [pc: 115, pc: 155] -> 158 when : java.lang.Throwable\n        [pc: 194, pc: 237] -> 240 when : java.lang.Throwable\n        [pc: 276, pc: 319] -> 322 when : java.lang.Throwable\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 8, line: 5]\n        [pc: 16, line: 6]\n        [pc: 25, line: 7]\n        [pc: 27, line: 8]\n        [pc: 30, line: 9]\n        [pc: 36, line: 11]\n        [pc: 76, line: 12]\n        [pc: 81, line: 13]\n        [pc: 115, line: 16]\n        [pc: 155, line: 17]\n        [pc: 160, line: 18]\n        [pc: 194, line: 21]\n        [pc: 237, line: 22]\n        [pc: 242, line: 23]\n        [pc: 276, line: 26]\n        [pc: 319, line: 27]\n        [pc: 324, line: 28]\n        [pc: 358, line: 30]\n      Local variable table:\n        [pc: 0, pc: 359] local: args index: 0 type: java.lang.String[]\n        [pc: 8, pc: 359] local: x index: 1 type: X\n        [pc: 16, pc: 359] local: l index: 2 type: java.util.List\n        [pc: 27, pc: 359] local: la index: 3 type: java.util.List\n        [pc: 30, pc: 359] local: lb index: 4 type: java.util.List\n        [pc: 33, pc: 359] local: t index: 5 type: boolean\n        [pc: 36, pc: 359] local: f index: 6 type: boolean\n        [pc: 81, pc: 115] local: e index: 7 type: java.lang.Throwable\n        [pc: 160, pc: 194] local: e index: 7 type: java.lang.Throwable\n        [pc: 242, pc: 276] local: e index: 7 type: java.lang.Throwable\n        [pc: 324, pc: 358] local: e index: 7 type: java.lang.Throwable\n      Local variable type table:\n        [pc: 27, pc: 359] local: la index: 3 type: java.util.List<A>\n        [pc: 30, pc: 359] local: lb index: 4 type: java.util.List<B>\n      Stack map table: number of frames 16\n        [pc: 57, full, stack: {java.io.PrintStream}, locals: {java.lang.String[], X, java.util.List, java.util.List, java.util.List, int, int}]\n        [pc: 68, full, stack: {java.io.PrintStream, Foo}, locals: {java.lang.String[], X, java.util.List, java.util.List, java.util.List, int, int}]\n        [pc: 79, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 115, same]\n        [pc: 136, same_locals_1_stack_item, stack: {java.io.PrintStream}]\n        [pc: 147, full, stack: {java.io.PrintStream, Foo}, locals: {java.lang.String[], X, java.util.List, java.util.List, java.util.List, int, int}]\n        [pc: 158, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 194, same]\n        [pc: 215, same_locals_1_stack_item, stack: {java.io.PrintStream}]\n        [pc: 226, full, stack: {java.io.PrintStream, Foo}, locals: {java.lang.String[], X, java.util.List, java.util.List, java.util.List, int, int}]\n        [pc: 240, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 276, same]\n        [pc: 297, same_locals_1_stack_item, stack: {java.io.PrintStream}]\n        [pc: 308, full, stack: {java.io.PrintStream, Foo}, locals: {java.lang.String[], X, java.util.List, java.util.List, java.util.List, int, int}]\n        [pc: 322, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 358, same]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test1067() {
        this.runConformTest(new String[]{"Something.java", "public interface Something {\n\n}", "Doing.java", "public interface Doing {\n        public <S extends Something, T extends S> T get(Class<S> clazz);\n}", "DoingImpl.java", "public class DoingImpl implements Doing {\n        public <S extends Something, T extends S> T get(Class<S> clazz) {\n                return null;\n        }\n}"}, "");
    }

    public void test1068() {
        this.runConformTest(new String[]{"Something.java", "public interface Something {\n\n}", "Doing.java", "public interface Doing {\n        public <S extends Something, T extends S> T get(Class<S> clazz);\n}"}, "");
        this.runConformTest(new String[]{"DoingImpl.java", "public class DoingImpl implements Doing {\n        public <S extends Something, T extends S> T get(Class<S> clazz) {\n                return null;\n        }\n}"}, "", null, false, null);
    }

    public void test1069() {
        this.runConformTest(new String[]{"Bug.java", "public class Bug<A> {\n   void bug() {\n      new Runnable() {\n         public void run() {\n            Bug<A> bug = Bug.this;\n         }\n      };\n   }\n}"}, "");
    }

    public void test1070() {
        this.runConformTest(new String[]{"Bug.java", "public class Bug<A> {\n   Bug<A> reproduce() {\n      return Bug.this;\n   }\n}"}, "");
    }

    public void test1071() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n        List<void[]> x = null;\n        void[] y;\n        void[] foo(void[] arg) {\n                void[] local;\n        }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tList<void[]> x = null;\n\t     ^^^^^^\nvoid[] is an invalid type\n----------\n2. ERROR in X.java (at line 4)\n\tvoid[] y;\n\t^^^^^^\nvoid[] is an invalid type\n----------\n3. ERROR in X.java (at line 5)\n\tvoid[] foo(void[] arg) {\n\t^^^^^^\nvoid[] is an invalid type\n----------\n4. ERROR in X.java (at line 5)\n\tvoid[] foo(void[] arg) {\n\t           ^^^^^^\nvoid[] is an invalid type\n----------\n5. ERROR in X.java (at line 6)\n\tvoid[] local;\n\t^^^^^^\nvoid[] is an invalid type\n----------\n");
    }

    public void test1072() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n        List<void[]> x = null;\n        void[] y;\n        void[] foo(void[] arg) {\n                void[] local;\n                Class c = void[].class;\n        }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tList<void[]> x = null;\n\t     ^^^^^^\nvoid[] is an invalid type\n----------\n2. ERROR in X.java (at line 4)\n\tvoid[] y;\n\t^^^^^^\nvoid[] is an invalid type\n----------\n3. ERROR in X.java (at line 5)\n\tvoid[] foo(void[] arg) {\n\t^^^^^^\nvoid[] is an invalid type\n----------\n4. ERROR in X.java (at line 5)\n\tvoid[] foo(void[] arg) {\n\t           ^^^^^^\nvoid[] is an invalid type\n----------\n5. ERROR in X.java (at line 6)\n\tvoid[] local;\n\t^^^^^^\nvoid[] is an invalid type\n----------\n6. ERROR in X.java (at line 7)\n\tClass c = void[].class;\n\t          ^^^^^^\nvoid[] is an invalid type\n----------\n", null, true, options);
    }

    public void test1073() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n        List<void[]> x = null;\n        void[] y;\n        void[] foo(void[] arg) {\n                try {\n                        void[] local;\n                        Class c = void[].class;\n                } catch(void[] e) {\n                }\n        }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tList<void[]> x = null;\n\t     ^^^^^^\nvoid[] is an invalid type\n----------\n2. ERROR in X.java (at line 4)\n\tvoid[] y;\n\t^^^^^^\nvoid[] is an invalid type\n----------\n3. ERROR in X.java (at line 5)\n\tvoid[] foo(void[] arg) {\n\t^^^^^^\nvoid[] is an invalid type\n----------\n4. ERROR in X.java (at line 5)\n\tvoid[] foo(void[] arg) {\n\t           ^^^^^^\nvoid[] is an invalid type\n----------\n5. ERROR in X.java (at line 7)\n\tvoid[] local;\n\t^^^^^^\nvoid[] is an invalid type\n----------\n6. ERROR in X.java (at line 8)\n\tClass c = void[].class;\n\t          ^^^^^^\nvoid[] is an invalid type\n----------\n7. ERROR in X.java (at line 9)\n\t} catch(void[] e) {\n\t        ^^^^^^\nvoid[] is an invalid type\n----------\n", null, true, options);
    }

    public void test1074() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n        List<void[]> x = null;\n        void[] y;\n        void[] foo(void[] arg) {\n                try {\n                        void[] local = new void[0];\n                        void[] local1 = new void[]{ null, null };\n                        void[] local2 = { null, null };\n                        System.out.println((void[]) null);\n                        Class c = void[].class;\n                } catch(void[] e) {\n                }\n        }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tList<void[]> x = null;\n\t     ^^^^^^\nvoid[] is an invalid type\n----------\n2. ERROR in X.java (at line 4)\n\tvoid[] y;\n\t^^^^^^\nvoid[] is an invalid type\n----------\n3. ERROR in X.java (at line 5)\n\tvoid[] foo(void[] arg) {\n\t^^^^^^\nvoid[] is an invalid type\n----------\n4. ERROR in X.java (at line 5)\n\tvoid[] foo(void[] arg) {\n\t           ^^^^^^\nvoid[] is an invalid type\n----------\n5. ERROR in X.java (at line 7)\n\tvoid[] local = new void[0];\n\t^^^^^^\nvoid[] is an invalid type\n----------\n6. ERROR in X.java (at line 7)\n\tvoid[] local = new void[0];\n\t               ^^^^^^^^^^^\nvoid[] is an invalid type\n----------\n7. ERROR in X.java (at line 8)\n\tvoid[] local1 = new void[]{ null, null };\n\t^^^^^^\nvoid[] is an invalid type\n----------\n8. ERROR in X.java (at line 8)\n\tvoid[] local1 = new void[]{ null, null };\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^\nvoid[] is an invalid type\n----------\n9. ERROR in X.java (at line 9)\n\tvoid[] local2 = { null, null };\n\t^^^^^^\nvoid[] is an invalid type\n----------\n10. ERROR in X.java (at line 10)\n\tSystem.out.println((void[]) null);\n\t                    ^^^^^^\nvoid[] is an invalid type\n----------\n11. ERROR in X.java (at line 11)\n\tClass c = void[].class;\n\t          ^^^^^^\nvoid[] is an invalid type\n----------\n12. ERROR in X.java (at line 12)\n\t} catch(void[] e) {\n\t        ^^^^^^\nvoid[] is an invalid type\n----------\n", null, true, options);
    }

    public void test1075() {
        this.runConformTest(new String[]{"X.java", "public class X <T extends X<?>.J>{\n\tpublic class J implements I<T>{}\n}\n", "I.java", "public interface I <T> {}\n", "Y.java", "public class Y extends X {}\n"}, "");
        this.runConformTest(false, new String[]{"Y.java", "public class Y extends X {}"}, null, "", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test1076() {
        if (this.complianceLevel >= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tList<Thread> threads;\n\tvoid foo(String[] strings) {}\n\tvoid bar() {\n\t\tfoo(this.threads.toArray(new String[this.threads.size()]));\n\t\tfoo(myToArray(this.threads, new String[this.threads.size()]));\n\t\tfoo(myToArray2(this.threads, new String[this.threads.size()]));\n\t}\n\t\n\tstatic <T, E> T[] myToArray(List<E> list, T[] a) {\n\t\treturn list.toArray(a);\n\t}\n\tstatic <T, E extends T> T[] myToArray2(List<E> list, T[] a) {\n\t\treturn list.toArray(a);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tfoo(myToArray2(this.threads, new String[this.threads.size()]));\n\t    ^^^^^^^^^^\nBound mismatch: The generic method myToArray2(List<E>, T[]) of type X is not applicable for the arguments (List<Thread>, String[]). The inferred type Thread is not a valid substitute for the bounded parameter <E extends T>\n----------\n");
    }

    public void test1077() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic class Y<T> {\n\t\tstatic int foo;\n\t}\n\tstatic class Z<U> extends Y<U> {\n\t\tint foo;\n\t\t{\n\t\t\tfoo = 1;\n\t\t}\n\t}\n\tZork z;\n}\n\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tint foo;\n\t    ^^^\nThe field X.Z<U>.foo is hiding a field from type X.Y<U>\n----------\n2. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1078() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.Map;\n\npublic class X \n{\n  public static void main(String[] args)\n  {\n    Object object = null;\n\n    List list = (List)object;//[1]\n\n    foo((List)object);//[2]\n    foo((List<?>)object);//[3]\n    foo((List<Object>)object);//[4]unchecked cast\n    foo((List<? extends Object>)object);//[5]\n\n    foo((Map)object);//[6]\n    foo((Map<?, ?>)object);//[7]\n    foo((Map<Object, ?>)object);//[8]unchecked cast\n    foo((Map<?, Object>)object);//[9]unchecked cast\n    foo((Map<Object, Object>)object);//[10]unchecked cast\n    foo((Map<? extends Object, Object>)object);//[11]unchecked cast\n    foo((Map<? extends Object, ? extends Object>)object);//[12]\n    Zork z;\n  }\n\n  public static void foo(List<?> list) {\n  }\n\n  public static void foo(Map<?, ?> map) {\n  }\n}"}, "----------\n1. WARNING in X.java (at line 10)\n\tList list = (List)object;//[1]\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 10)\n\tList list = (List)object;//[1]\n\t             ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 12)\n\tfoo((List)object);//[2]\n\t     ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in X.java (at line 14)\n\tfoo((List<Object>)object);//[4]unchecked cast\n\t    ^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to List<Object>\n----------\n5. WARNING in X.java (at line 15)\n\tfoo((List<? extends Object>)object);//[5]\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to List<? extends Object>\n----------\n6. WARNING in X.java (at line 17)\n\tfoo((Map)object);//[6]\n\t     ^^^\nMap is a raw type. References to generic type Map<K,V> should be parameterized\n----------\n7. WARNING in X.java (at line 19)\n\tfoo((Map<Object, ?>)object);//[8]unchecked cast\n\t    ^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Map<Object,?>\n----------\n8. WARNING in X.java (at line 20)\n\tfoo((Map<?, Object>)object);//[9]unchecked cast\n\t    ^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Map<?,Object>\n----------\n9. WARNING in X.java (at line 21)\n\tfoo((Map<Object, Object>)object);//[10]unchecked cast\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Map<Object,Object>\n----------\n10. WARNING in X.java (at line 22)\n\tfoo((Map<? extends Object, Object>)object);//[11]unchecked cast\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Map<? extends Object,Object>\n----------\n11. WARNING in X.java (at line 23)\n\tfoo((Map<? extends Object, ? extends Object>)object);//[12]\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Map<? extends Object,? extends Object>\n----------\n12. ERROR in X.java (at line 24)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1079() {
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n    X<? extends String> bar(Object o) {\n    \treturn (AX<? extends String>) o;\n   \t Zork z;\n    }\n}\nclass AX<F> extends X<F> {}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\treturn (AX<? extends String>) o;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to AX<? extends String>\n----------\n2. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1080() {
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n\tCX<E> foo(X<String> x) {\n\t\treturn (CX<E>) x; // unchecked\n\t}\n\tBX bar(X<String> x) {\n\t\treturn (BX) x;\n\t}\n   Zork z;\n}\nclass AX<F> extends X<F> {}\nclass BX extends AX<String> {}\nclass CX<G> extends AX<String> {}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\treturn (CX<E>) x; // unchecked\n\t       ^^^^^^^^^\nType safety: Unchecked cast from X<String> to CX<E>\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1081() {
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n\tAX<Object> foo(X<String> x) {\n\t\treturn (BX) x;\n\t}\n}\nclass AX<F> extends X<F> {}\nclass BX extends AX<Object> {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\treturn (BX) x;\n\t       ^^^^^^\nCannot cast from X<String> to BX\n----------\n");
    }

    public void test1082() {
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n\tCX<E> foo(X<String> x) {\n\t\treturn (CX<E>) x; // unchecked\n\t}\n   Zork z;\n}\nclass AX<F> extends X<F> {}\nclass CX<G> extends AX {}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\treturn (CX<E>) x; // unchecked\n\t       ^^^^^^^^^\nType safety: Unchecked cast from X<String> to CX<E>\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. WARNING in X.java (at line 8)\n\tclass CX<G> extends AX {}\n\t                    ^^\nAX is a raw type. References to generic type AX<F> should be parameterized\n----------\n");
    }

    public void test1083() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.LinkedList;\n\nclass SerializableList extends LinkedList<Serializable> {\n\tprivate static final long serialVersionUID = 1L; \n}\npublic class X {\n    @SuppressWarnings({\"nls\", \"unused\"})\n    public static void main(String[] args) {\n        LinkedList<String> linkedList= new LinkedList<String>();\n        linkedList.add(\"Hello\");\n        java.util.List<? extends Serializable> a = linkedList;\n        java.util.List<String> b = (LinkedList<String>) a; // unchecked\n        java.util.List<Integer> c = (LinkedList<Integer>) a; // unchecked\n        java.util.List<Runtime> d = (LinkedList<Runtime>) a; // inconvertible / unchecked ?\n        c.get(0).intValue(); // fails at run time\n        d.get(0).gc(); // fails at run time\n        Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 13)\n\tjava.util.List<String> b = (LinkedList<String>) a; // unchecked\n\t                           ^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List<capture#1-of ? extends Serializable> to LinkedList<String>\n----------\n2. WARNING in X.java (at line 14)\n\tjava.util.List<Integer> c = (LinkedList<Integer>) a; // unchecked\n\t                            ^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List<capture#2-of ? extends Serializable> to LinkedList<Integer>\n----------\n3. WARNING in X.java (at line 15)\n\tjava.util.List<Runtime> d = (LinkedList<Runtime>) a; // inconvertible / unchecked ?\n\t                            ^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List<capture#3-of ? extends Serializable> to LinkedList<Runtime>\n----------\n4. ERROR in X.java (at line 18)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1084() {
        this.runNegativeTest(new String[]{"X.java", "class Y<T> {\n}\nclass Z<T> {\n}\nclass X {\n  void foo() {\n    Z<Y<?>> l1 = null;\n    Z<Y> l2 = (Z<Y>) l1;\n  }\n}"}, "----------\n1. WARNING in X.java (at line 8)\n\tZ<Y> l2 = (Z<Y>) l1;\n\t  ^\nY is a raw type. References to generic type Y<T> should be parameterized\n----------\n2. ERROR in X.java (at line 8)\n\tZ<Y> l2 = (Z<Y>) l1;\n\t          ^^^^^^^^^\nCannot cast from Z<Y<?>> to Z<Y>\n----------\n3. WARNING in X.java (at line 8)\n\tZ<Y> l2 = (Z<Y>) l1;\n\t             ^\nY is a raw type. References to generic type Y<T> should be parameterized\n----------\n");
    }

    public void test1085() {
        this.runNegativeTest(new String[]{"Y.java", "class Z {\n        Z z1 = z1;\n        Z[] z2 = z2;\n}\npublic class Y<E> {\n\t\tE e0 = es[0];\n\t\tE e = e;\n        E[] es = es;\n\t\tE e2 = e2.e;\n}"}, "----------\n1. ERROR in Y.java (at line 2)\n\tZ z1 = z1;\n\t       ^^\nCannot reference a field before it is defined\n----------\n2. ERROR in Y.java (at line 3)\n\tZ[] z2 = z2;\n\t         ^^\nCannot reference a field before it is defined\n----------\n3. ERROR in Y.java (at line 6)\n\tE e0 = es[0];\n\t       ^^\nCannot reference a field before it is defined\n----------\n4. ERROR in Y.java (at line 7)\n\tE e = e;\n\t      ^\nCannot reference a field before it is defined\n----------\n5. ERROR in Y.java (at line 8)\n\tE[] es = es;\n\t         ^^\nCannot reference a field before it is defined\n----------\n6. ERROR in Y.java (at line 9)\n\tE e2 = e2.e;\n\t       ^^\nCannot reference a field before it is defined\n----------\n7. ERROR in Y.java (at line 9)\n\tE e2 = e2.e;\n\t          ^\ne cannot be resolved or is not a field\n----------\n");
    }

    public void test1086() {
        this.runNegativeTest(new String[]{"X.java", "interface IFoo { void foo(); }\ninterface IBar { void bar(); }\npublic class X<Bar extends IFoo> {\n\tclass Bar implements IBar { public void bar(){} }\n\tvoid foo(Bar b) {\n\t\tb.foo(); // unbound (Bar is member type)\n\t\tb.bar(); // ok\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tb.foo(); // unbound (Bar is member type)\n\t  ^^^\nThe method foo() is undefined for the type X<Bar>.Bar\n----------\n");
    }

    public void test1087() {
        this.runConformTest(new String[]{"X.java", "public class X<M> {\n\tstatic public class M {\n\t}\n\tstatic public class M2 extends M {\n\t}\n}\n\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1088() {
        this.runNegativeTest(new String[]{"X.java", "public class X<M> {\n\tstatic public class M {}\n\tZork z;\n\tvoid foo() {\n\t\tclass M {} // hides member\n\t}\n}\nclass Y <T> {\n\tclass Local {}\n\tvoid foo() {\n\t\tclass T {}; // hiding warning\n\t\tclass Local {};\n\t}\n\tstatic void bar() {\n\t\tclass T {}; // no hiding warning\n\t\tclass Local {}; // no hiding warning\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 5)\n\tclass M {} // hides member\n\t      ^\nThe type M is hiding the type X<M>.M\n----------\n3. WARNING in X.java (at line 11)\n\tclass T {}; // hiding warning\n\t      ^\nThe nested type T is hiding the type parameter T of type Y<T>\n----------\n4. WARNING in X.java (at line 12)\n\tclass Local {};\n\t      ^^^^^\nThe type Local is hiding the type Y<T>.Local\n----------\n");
    }

    public void test1089() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass U {}\n\t<T> void foo(T t) {\n\t\tclass T {\n\t\t\tT t = t;\n\t\t}\n\t\tclass U {\n\t\t}\n\t}\n}\n\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tclass T {\n\t      ^\nThe nested type T is hiding the type parameter T of the generic method foo(T) of type X\n----------\n2. WARNING in X.java (at line 5)\n\tT t = t;\n\t  ^\nThe field T.t is hiding another local variable defined in an enclosing scope\n----------\n3. ERROR in X.java (at line 5)\n\tT t = t;\n\t      ^\nCannot reference a field before it is defined\n----------\n4. WARNING in X.java (at line 7)\n\tclass U {\n\t      ^\nThe type U is hiding the type X.U\n----------\n");
    }

    public void _test1090() {
        this.runNegativeTest(new String[]{"X.java", "public class X <T,U> {\n\tclass T {} // warn hiding type parameter\n\tclass U<U> {}// warn hiding type parameter+warn param hiding member type\n\t\n\tvoid foo() {\n\t\tclass Local {\n\t\t\tclass T {} // warn hiding type parameter\n\t\t\tclass U<U> {}// warn hiding type parameter+warn param hiding member type\n\t\t}\n\t}\n\tstatic void bar() {\n\t\tclass Local {\n\t\t\tclass T {} // no warn\n\t\t\tclass U<U> {} // no warn\n\t\t}\n\t}\n}"}, "???");
    }

    public void test1091() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\n\npublic class X {\n\tvoid foo() {\n\t\t  Object a = null;\n\t\t  Map.Entry<String, String> aa = (Map.Entry<String, String>)a;\t\t\n\t}\n\tvoid bar() {\n\t\t  Number a = null;\n\t\t  Map.Entry<String, String> aa = (Map.Entry<String, String>)a;\t\t\n\t\t  Zork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tMap.Entry<String, String> aa = (Map.Entry<String, String>)a;\t\t\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Map.Entry<String,String>\n----------\n2. WARNING in X.java (at line 10)\n\tMap.Entry<String, String> aa = (Map.Entry<String, String>)a;\t\t\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Number to Map.Entry<String,String>\n----------\n3. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1092() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runConformTest(new String[]{"Class_01.java", "public interface Class_01<H extends Class_02<? extends Class_01>> extends\n\t\tClass_09<H> {\n}", "Class_02.java", "public interface Class_02<E extends Class_01<? extends Class_02>> extends\n\t\tClass_10<E> {\n}", "Class_03.java", "public abstract class Class_03<E extends Class_01<? super H>, H extends Class_02<? super E>, P extends Class_06<? extends Class_07>>\n\t\textends Class_08<E, H, P> implements Class_05 {\n}", "Class_04.java", "public interface Class_04 extends Class_06<Class_18>, Class_19{\n}", "Class_05.java", "public interface Class_05{\n}", "Class_06.java", "public interface Class_06<H extends Class_07<? extends Class_06>> extends\n\t\tClass_13<H, Class_12>, Class_17 {\n}", "Class_07.java", "public interface Class_07<P extends Class_06<? extends Class_07>> extends\n\t\tClass_14<P, Class_12> {\n}", "Class_08.java", "public abstract class Class_08<E extends Class_09<? super H>, H extends Class_10<? super E>, P extends Class_06<? extends Class_07>>\n\t\textends Class_11<E, H, Class_12> implements Class_05 {\n}", "Class_09.java", "public interface Class_09<H extends Class_10<? extends Class_09>> extends\n\t\tClass_13<H, Class_12>, Class_17 {\n}", "Class_10.java", "public interface Class_10<E extends Class_09<? extends Class_10>> extends\n\t\tClass_14<E, Class_12> {\n}", "Class_11.java", "public abstract class Class_11<E extends Class_13<? super H, O>, H extends Class_14<? super E, O>, O>\n\t\textends Class_15<E, H, O> implements Class_05 {\n}", "Class_12.java", "public final class Class_12 {\n}", "Class_13.java", "public interface Class_13<H extends Class_14<?, O>, O>{\n}", "Class_14.java", "public interface Class_14<E extends Class_13<?, O>, O>{\n}", "Class_15.java", "public abstract class Class_15<E extends Class_13<? super H, O>, H extends Class_14<? super E, O>, O>\n\t\textends Class_16 {\n}", "Class_16.java", "public abstract class Class_16{\n}", "Class_17.java", "public interface Class_17{\n}", "Class_18.java", "public interface Class_18 extends Class_07<Class_04>{\n}", "Class_19.java", "public interface Class_19{\n}", "MyClass.java", "abstract class MyClass<E extends Class_01<? super H>, H extends Class_02<? super E>>\n\t\textends Class_03<E, H, Class_04> implements Class_05 {\n}"}, "", null, true, null, customOptions, null);
        this.runConformTest(new String[]{"Class_01.java", "public interface Class_01<H extends Class_02<? extends Class_01>> extends\n\t\tClass_09<H> {\n}"}, "", null, false, null, customOptions, null);
    }

    public void test1093() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n  X<T> foo() {\n    return this;\n  }\n  T bar(T p) {\n    return p;\n  }\n  public static void main (String args) {\n    X<String> x1 = new X<String>();\n    System.out.println(x1.foo().bar(\"OK\"));\n    X x2 = new X<String>();\n    System.out.println(x2.foo().bar(\"OK\"));\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 12)\n\tSystem.out.println(x2.foo().bar(\"OK\"));\n\t                   ^^^^^^^^^^^^^^^^^^\nType safety: The method bar(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n", null, true, customOptions, false, false, false, false, false);
    }

    public void test1094() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runConformTest(new String[]{"Crazy.java", "public interface Crazy<O extends Other, T extends O> {}", "ExampleFactory.java", "public interface ExampleFactory {\n\t<O extends Other, T extends O> Crazy<O, T> createCrazy();\n}", "Other.java", "public interface Other {}", "ExampleFactoryImpl.java", "public class ExampleFactoryImpl implements ExampleFactory {\n\tpublic <O extends Other, T extends O> Crazy<O, T> createCrazy() {\n\t\treturn null;\n\t}\n}"}, "", null, true, null, customOptions, null);
        this.runConformTest(new String[]{"ExampleFactoryImpl.java", "public class ExampleFactoryImpl implements ExampleFactory {\n\tpublic <O extends Other, T extends O> Crazy<O, T> createCrazy() {\n\t\treturn null;\n\t}\n}"}, "", null, false, null, customOptions, null);
    }

    public void test1095() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        this.runNegativeTest(true, new String[]{"X.java", "import java.lang.reflect.Constructor;\n\n@interface Annot {\n\tString message() default \"\"; //$NON-NLS-1$\n}\n\npublic class X {\n\tX() {\n\t}\n\tpublic String getAnnotationValue(Constructor constructor){\n\t\tAnnot annotation = constructor.getAnnotation(Annot.class);\n\t\treturn (annotation != null) ? annotation.message() : null;\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 11)\n\tAnnot annotation = constructor.getAnnotation(Annot.class);\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Annotation to Annot\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6400189);
    }

    public void test1096() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Constructor;\n\n@interface Annot {\n\tString message() default \"\"; //$NON-NLS-1$\n}\n\npublic class X {\n\tX() {\n\t}\n\tpublic String getAnnotationValue(Constructor<X> constructor){\n\t\tAnnot annotation = constructor.getAnnotation(Annot.class);\n\t\treturn (annotation != null) ? annotation.message() : null;\n\t}\n}"}, "", null, true, null, customOptions, null);
    }

    public void _test1097() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString[] foo = new <Zork>String[] {};\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tString[] foo = new <Zork>String[] {};\n\t               ^^^^^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in X.java (at line 2)\n\tString[] foo = new <Zork>String[] {};\n\t                        ^\nSyntax error on token \">\", , expected\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1098() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n   private class A {\n    class B {}\n  }\n  private class Y<T> extends A {\n  }\n  Y<String>.B d = null;\n}\nclass Y extends Zork {}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tprivate class Y<T> extends A {\n\t              ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n2. ERROR in X.java (at line 9)\n\tclass Y extends Zork {}\n\t                ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1099() {
        this.runConformTest(true, new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\n    public class A {};\n    public class B extends A {\n    \t@Override\n    \tpublic String toString() {\n    \t\treturn \"SUCCESS\";\n    \t}\n    }\n\n    public static void main(String[] args) {\n        X x = new X();\n        List<A> l = x.newList(x.new B());\n\t\tfor (A a: l) {\n\t\t\tSystem.out.println(a);\n\t\t}\n    }\n\n    public <U, V extends U> List<U> newList(V... values) {\n        List<U> l = new ArrayList<U>();\n        for (V v : values) {\n            l.add(v);\n        }\n        return l;\n    }\n\n}\n"}, this.complianceLevel < 0x330000L ? "" : "----------\n1. WARNING in X.java (at line 21)\n\tpublic <U, V extends U> List<U> newList(V... values) {\n\t                                             ^^^^^^\nType safety: Potential heap pollution via varargs parameter values\n----------\n", "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_7);
    }

    public void test1100() {
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n}\nclass Y<T> {\n  public void foo(final X<?> x) {\n  }\n}\nclass Z extends Y {\n  public void foo(final X<?> x) {\n    super.foo(x);\n  }\n}"}, "----------\n1. WARNING in X.java (at line 7)\n\tclass Z extends Y {\n\t                ^\nY is a raw type. References to generic type Y<T> should be parameterized\n----------\n2. ERROR in X.java (at line 8)\n\tpublic void foo(final X<?> x) {\n\t            ^^^^^^^^^^^^^^^^^\nName clash: The method foo(X<?>) of type Z has the same erasure as foo(X) of type Y but does not override it\n----------\n3. WARNING in X.java (at line 9)\n\tsuper.foo(x);\n\t^^^^^^^^^^^^\nType safety: The method foo(X) belongs to the raw type Y. References to generic type Y<T> should be parameterized\n----------\n");
    }

    public void test1101() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic final class X<A, B> {\n    public A a;\n    public B b;\n    public X(A pa, B pb) {\n        a = pa;\n        b = pb;\n    }\n    public static <A, B> X<A, B> create(A pa, B pb) {\n        return new X<A, B>(pa, pb);\n    }\n    public static void main(String[] args) {\n        List<X<String, Object>> list = new ArrayList<X<String,Object>>();\n        list.add(X.<?, Object>create(\"\", \"\"));\n    }\n}"}, "----------\n1. ERROR in X.java (at line 15)\n\tlist.add(X.<?, Object>create(\"\", \"\"));\n\t            ^\nWildcard is not allowed at this location\n----------\n");
    }

    public void test1102() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T> X(T t) {\n\t}\n\n\tclass A {\n\t\t<T> A(T t) {\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew<?> X(null);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tnew<?> X(null);\n\t    ^\nWildcard is not allowed at this location\n----------\n");
    }

    public void test1103() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T> X(T t) {\n\t}\n\tX(int i) {\n\t\t<?>this(null);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t<?>this(null);\n\t ^\nWildcard is not allowed at this location\n----------\n");
    }

    public void test1104() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T> X(T t) { }\n\t\n\tclass A {\n\t\t<T> A(T t) { }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew X(null).new <?> A(null);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tnew X(null).new <?> A(null);\n\t                 ^\nWildcard is not allowed at this location\n----------\n");
    }

    public void test1105() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tClass foo = Class.<? extends Object>forName(Integer.class.getName());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tClass foo = Class.<? extends Object>forName(Integer.class.getName());\n\t                   ^^^^^^^^^^^^^^^^\nWildcard is not allowed at this location\n----------\n", null, true, customOptions);
    }

    public void test1106() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic class Y extends Exception {\n     private static final long serialVersionUID = 1L;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class Y extends Exception {\n\t                       ^^^^^^^^^\nThe generic class X<T>.Y may not subclass java.lang.Throwable\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test1107() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.HashMap;\nimport java.util.Iterator;\nimport java.util.List;\n\npublic class X {\n  private void processLocks(HashMap locksMap, Object key) {\n    for (Iterator iter = locksMap.keySet().iterator(); iter.hasNext();) {\n      Object call = iter.next();\n      List locks = externLocks((Collection) locksMap.get(call), call);\n      // ...\n    }\n  }\n  private List externLocks(Collection locks, Object call) {\n    List result = new ArrayList();\n    // ..\n    return result;\n  }\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #15 (Ljava/util/HashMap;Ljava/lang/Object;)V\n  // Stack: 3, Locals: 6\n  private void processLocks(java.util.HashMap locksMap, java.lang.Object key);\n     0  aload_1 [locksMap]\n     1  invokevirtual java.util.HashMap.keySet() : java.util.Set [16]\n     4  invokeinterface java.util.Set.iterator() : java.util.Iterator [22] [nargs: 1]\n     9  astore_3 [iter]\n    10  goto 38\n    13  aload_3 [iter]\n    14  invokeinterface java.util.Iterator.next() : java.lang.Object [28] [nargs: 1]\n    19  astore 4 [call]\n    21  aload_0 [this]\n    22  aload_1 [locksMap]\n    23  aload 4 [call]\n    25  invokevirtual java.util.HashMap.get(java.lang.Object) : java.lang.Object [34]\n    28  checkcast java.util.Collection [38]\n    31  aload 4 [call]\n    33  invokespecial X.externLocks(java.util.Collection, java.lang.Object) : java.util.List [40]\n    36  astore 5\n    38  aload_3 [iter]\n    39  invokeinterface java.util.Iterator.hasNext() : boolean [44] [nargs: 1]\n    44  ifne 13\n    47  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 13, line: 10]\n        [pc: 21, line: 11]\n        [pc: 38, line: 9]\n        [pc: 47, line: 14]\n      Local variable table:\n        [pc: 0, pc: 48] local: this index: 0 type: X\n        [pc: 0, pc: 48] local: locksMap index: 1 type: java.util.HashMap\n        [pc: 0, pc: 48] local: key index: 2 type: java.lang.Object\n        [pc: 10, pc: 47] local: iter index: 3 type: java.util.Iterator\n        [pc: 21, pc: 38] local: call index: 4 type: java.lang.Object\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test1108() {
        this.runConformTest(new String[]{"X.java", "interface UnaryFunction <A, R, X extends Throwable> {\n    public R invoke(A o) throws X;\n}\n \npublic class X implements UnaryFunction<String,Void,RuntimeException> {\n    public Void invoke(String o) throws RuntimeException {\n        return null;\n    }\n}\n"}, "");
    }

    public void test1109() {
        String xSource = "class X {\n  public Y<String> foo()\n  {\n    return true ? Z.bar() : null;\n  }\n}\nclass Y<T> {\n}\nclass Z {\n  static <U> Y<U> bar() {\n    return null;\n  }\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 4)\n\treturn true ? Z.bar() : null;\n\t       ^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Y<Object> to Y<String>\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", xSource});
        }
    }

    public void test1110() {
        this.runConformTest(new String[]{"X.java", "class X {\n  public Y<String> foo()\n  {\n    return true ? Z.<String>bar() : null;\n  }\n}\nclass Y<T> {\n}\nclass Z {\n  static <U> Y<U> bar() {\n    return null;\n  }\n}\n"}, "");
    }

    public void test1111() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo(Object o) {\n                return (T) o; // should get unchecked warning\n        }\n}\n\npublic class X {\n        public static void main(String[] args) {\n                A<X> a = new A<X>();\n                try {\n\t                X s = a.foo(new Object());\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test1112() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo;\n}\n\npublic class X {\n        public static void main(String[] args) {\n                A<X> a = new A<X>();\n\t\t\t\t A ua = a;\n\t\t\t\t ua.foo = new Object();\n                try {\n\t                X s = a.foo;\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test1113() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo;\n}\n\npublic class X extends A<X>{\n        public static void main(String[] args) {\n\t\t\tnew X().foo();\n\t\t }\n \t\t public void foo() {\n\t\t\t\t A ua = this;\n\t\t\t\t ua.foo = new Object();\n                try {\n\t                X s = foo;\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test1114() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo;\n}\n\npublic class X extends A<X>{\n        public static void main(String[] args) {\n\t\t\tnew X().foo();\n\t\t }\n \t\t public void foo() {\n\t\t\t\t A ua = this;\n\t\t\t\t ua.foo = new Object();\n                try {\n\t                X s = this.foo;\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test1115() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo;\n}\n\npublic class X {\n\t\t static X ROOT;\n        public static void main(String[] args) {\n                A<X> a = new A<X>();\n\t\t\t\t A ua = a;\n\t\t\t\t ua.foo = new Object();\n                try {\n\t                X s = a.foo.ROOT;\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test1116() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\n\ninterface I {\n    int CONST = 1;\n}\n\nclass Z<T extends Serializable&I> {\n    T c;\n    Z(T c) {\n        this.c = c;\n    }\n    int foo() {\n        return c.CONST;\n    }\n}\n\npublic class X implements Serializable, I {\n    public static void main(String argv[]) {\n        Z<X> z = new Z<X>(new X());\n        Z rawz = z;\n        rawz.c = new Serializable(){};\n        try {\n\t        z.foo();\n        } catch(ClassCastException e) {\n        \tSystem.out.println(\"SUCCESS\");\n        }\n    }\n}\n"}, "SUCCESS");
    }

    public void test1117() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tValue<String> CONST = null;\n}\nclass Value<V> {\n\tString NAME = \"VALUE\";\n}\nclass B<V> implements I<V> {\n\tB(Value<String> param) {\n\t\tValue<String> v0 = CONST;\n\t\tValue<String> v1 = this.CONST;\n\t\tString s2 = CONST.NAME;\n\t\tValue<String> v3 = I.CONST;\n\t\tValue<String> v4 = B.CONST;\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew B<String>(new Value<String>());\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS", null, false, null, options, null);
        String expectedOutput = "  // Method descriptor #8 (LValue;)V\n  // Signature: (LValue<Ljava/lang/String;>;)V\n  // Stack: 1, Locals: 2\n  B(Value param);\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [12]\n     4  getstatic B.CONST : Value [15]\n     7  pop\n     8  getstatic B.CONST : Value [15]\n    11  pop\n    12  getstatic B.CONST : Value [15]\n    15  getfield Value.NAME : java.lang.String [19]\n    18  pop\n    19  getstatic I.CONST : Value [25]\n    22  pop\n    23  getstatic B.CONST : Value [15]\n    26  pop\n    27  return\n      Line numbers:\n        [pc: 0, line: 8]\n        [pc: 4, line: 9]\n        [pc: 8, line: 10]\n        [pc: 12, line: 11]\n        [pc: 19, line: 12]\n        [pc: 23, line: 13]\n        [pc: 27, line: 14]\n      Local variable table:\n        [pc: 0, pc: 28] local: this index: 0 type: B\n        [pc: 0, pc: 28] local: param index: 1 type: Value\n      Local variable type table:\n        [pc: 0, pc: 28] local: this index: 0 type: B<V>\n        [pc: 0, pc: 28] local: param index: 1 type: Value<java.lang.String>\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "B.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            GenericTypeTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test1118() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tX() {\n\t\tClass<? extends List<?>> cls = null;\n\t\tfoo(cls);\n\t}\n\n\t<I, T extends List<I>> T foo(Class<T> pClass) {\n\t\treturn null;\n\t}\n}\n"}, AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug177715);
    }

    public void test1119() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Comparable<T> & Runnable> {\n\tT get() {\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\t\n\t\tX<OnlyRunnable> x1 = null; // error\n\t\tX<OnlyComparable> x2 = null; // error\n\t\tX<ComparableRunnable> x3 = null; // ok\n\t\tX<ComparableRunnableThrowable> x4 = null; // ok\n\t\t\n\t\tfoo1(x1); // ok\n\t\tfoo1(x2); // ok\n\t\tfoo1(x3); // ok\n\t\tfoo1(x4); // ok\n\n\t\tfoo2(x1); // error\n\t\tfoo2(x2); // error\n\t\tfoo2(x3); // error\n\t\tfoo2(x4); // ok\n\t}\n\t\n\tstatic void foo1(X<?> x) {\n\t\tx.get().run(); // ok\n\t\tx.get().compareTo(null); // ok\n\t\tx.get().compareTo(x.get()); // error\n\t}\n\tstatic void foo2(X<? extends Throwable> x) {\n\t\tx.get().run(); // ok\n\t\tx.get().compareTo(null); // ok\n\t\tx.get().compareTo(x.get()); // error\n\t}\t\n}\n\nabstract class OnlyRunnable implements Runnable {}\nabstract class OnlyComparable implements Comparable<OnlyComparable> {}\nabstract class ComparableRunnable implements Comparable<ComparableRunnable>, Runnable {}\nabstract class ComparableRunnableThrowable extends Throwable implements Comparable<ComparableRunnable>, Runnable {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tX<OnlyRunnable> x1 = null; // error\n\t  ^^^^^^^^^^^^\nBound mismatch: The type OnlyRunnable is not a valid substitute for the bounded parameter <T extends Comparable<T> & Runnable> of the type X<T>\n----------\n2. ERROR in X.java (at line 8)\n\tX<OnlyComparable> x2 = null; // error\n\t  ^^^^^^^^^^^^^^\nBound mismatch: The type OnlyComparable is not a valid substitute for the bounded parameter <T extends Comparable<T> & Runnable> of the type X<T>\n----------\n3. ERROR in X.java (at line 10)\n\tX<ComparableRunnableThrowable> x4 = null; // ok\n\t  ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nBound mismatch: The type ComparableRunnableThrowable is not a valid substitute for the bounded parameter <T extends Comparable<T> & Runnable> of the type X<T>\n----------\n4. ERROR in X.java (at line 17)\n\tfoo2(x1); // error\n\t^^^^\nThe method foo2(X<? extends Throwable>) in the type X<T> is not applicable for the arguments (X<OnlyRunnable>)\n----------\n5. ERROR in X.java (at line 18)\n\tfoo2(x2); // error\n\t^^^^\nThe method foo2(X<? extends Throwable>) in the type X<T> is not applicable for the arguments (X<OnlyComparable>)\n----------\n6. ERROR in X.java (at line 19)\n\tfoo2(x3); // error\n\t^^^^\nThe method foo2(X<? extends Throwable>) in the type X<T> is not applicable for the arguments (X<ComparableRunnable>)\n----------\n7. ERROR in X.java (at line 26)\n\tx.get().compareTo(x.get()); // error\n\t        ^^^^^^^^^\nThe method compareTo(capture#3-of ?) in the type Comparable<capture#3-of ?> is not applicable for the arguments (capture#4-of ?)\n----------\n8. ERROR in X.java (at line 31)\n\tx.get().compareTo(x.get()); // error\n\t        ^^^^^^^^^\nThe method compareTo(capture#7-of ? extends Throwable) in the type Comparable<capture#7-of ? extends Throwable> is not applicable for the arguments (capture#8-of ? extends Throwable)\n----------\n");
    }

    public void test1120() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic X() {\n\t\tSystem.out.println();\n\t\tthis(zork);\n\t\tZork.this.this();\n\t\t<Zork>this();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tthis(zork);\n\t^^^^^^^^^^^\nConstructor call must be the first statement in a constructor\n----------\n2. ERROR in X.java (at line 4)\n\tthis(zork);\n\t     ^^^^\nzork cannot be resolved to a variable\n----------\n3. ERROR in X.java (at line 5)\n\tZork.this.this();\n\t^^^^^^^^^^^^^^^^^\nConstructor call must be the first statement in a constructor\n----------\n4. ERROR in X.java (at line 5)\n\tZork.this.this();\n\t^^^^\nZork cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 6)\n\t<Zork>this();\n\t ^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 6)\n\t<Zork>this();\n\t      ^^^^^^^\nConstructor call must be the first statement in a constructor\n----------\n");
    }

    public void test1121() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tvoid foo() {\n\t\tSystem.out.println(T[].class);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(T[].class);\n\t                   ^^^^^^^^^\nIllegal class literal for the type parameter T\n----------\n");
    }

    public void test1122() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T> void foo() {\n\t\tSystem.out.println(T[].class);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(T[].class);\n\t                   ^^^^^^^^^\nIllegal class literal for the type parameter T\n----------\n");
    }

    public void test1123() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tClass<Integer> c1 = int.class;\n\t\tClass<Integer> c2 = Integer.class;\n\t\tClass<Integer[]> c3 = int[].class;\n\t\tClass<int[]> c4 = int[].class;\n\t\tClass<Void> c5 = void.class;\n\t\tClass<void[]> c6 = void[].class;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tClass<Integer[]> c3 = int[].class;\n\t                      ^^^^^^^^^^^\nType mismatch: cannot convert from Class<int[]> to Class<Integer[]>\n----------\n2. ERROR in X.java (at line 8)\n\tClass<void[]> c6 = void[].class;\n\t      ^^^^^^\nvoid[] is an invalid type\n----------\n3. ERROR in X.java (at line 8)\n\tClass<void[]> c6 = void[].class;\n\t                   ^^^^^^\nvoid[] is an invalid type\n----------\n");
    }

    public void test1124() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\n\npublic class X<T> {\n\n\tstatic protected final Map<String, String> myMap = new HashMap<String, String>();\n\tprivate final T theGenericThing;\n\n\tprivate X(T something) {\n\t\tthis.theGenericThing = something;\n\t}\n\n\tpublic static class InnerClassThatShowsBug extends X {\n\t\tpublic InnerClassThatShowsBug() {\n\t\t\tsuper(null);\n\t\t}\n\n\t\tpublic void printMap() {\n\t\t\tfor (Map.Entry<String, String> entry : myMap().entrySet()) {\n\t\t\t\tSystem.out.println(entry.getKey() + \" => \" + entry.getValue());\n\t\t\t}\n\t\t}\n\t\tprotected Map<String, String> myMap2() {\n\t\t\treturn myMap;\n\t\t}\n\t\tpublic void printMap2() {\n\t\t\tfor (Map.Entry<String, String> entry : myMap2().entrySet()) {\n\t\t\t\tSystem.out.println(entry.getKey() + \" => \" + entry.getValue());\n\t\t\t}\n\t\t}\n\t}\n\n\tprotected Map<String, String> myMap() {\n\t\treturn myMap;\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 13)\n\tpublic static class InnerClassThatShowsBug extends X {\n\t                                                   ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 15)\n\tsuper(null);\n\t^^^^^^^^^^^^\nType safety: The constructor X(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 15)\n\tsuper(null);\n\t^^^^^^^^^^^^\nAccess to enclosing constructor X<T>(T) is emulated by a synthetic accessor method\n----------\n4. ERROR in X.java (at line 19)\n\tfor (Map.Entry<String, String> entry : myMap().entrySet()) {\n\t                                       ^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from element type Object to Map.Entry<String,String>\n----------\n");
    }

    public void test1125() {
        this.runNegativeTest(new String[]{"X.java", "class A {\n    class B<T> {\n        T t;\n        T getValue() {\n            return t;\n        }\n    }\n}\n\nclass C<T> extends A {\n\tZork z;\n}\n\npublic class X {\n    static C.B<Double> c = new C().new B<Double>();\n\n    public static void main(String[] args) {\n        C.B<String> temp = new C().new B<String>();\n        String s = temp.getValue();\n        System.out.println(s);\n        foo(bar());\n    }\n\n    static C.B<? extends Number> bar() {\n        return new C().new B<Integer>();\n    }\n\n    static void foo(C.B<?> arg) {\n        Object o = arg.getValue();\n        Double d = c.getValue();\n        System.out.println(o);\n        System.out.println(d);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 15)\n\tstatic C.B<Double> c = new C().new B<Double>();\n\t                           ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n3. WARNING in X.java (at line 18)\n\tC.B<String> temp = new C().new B<String>();\n\t                       ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n4. WARNING in X.java (at line 25)\n\treturn new C().new B<Integer>();\n\t           ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n");
    }

    public void test1126() {
        this.runConformTest(new String[]{"X.java", "class A {\n    class B<T> {\n        T t;\n        T getValue() {\n            return t;\n        }\n    }\n}\n\npublic class X {\n    static A.B<Double> c = new A().new B<Double>();\n\n    public static void main(String[] args) {\n        A.B<String> temp = new A().new B<String>();\n        String s = temp.getValue();\n        System.out.print(s);\n        foo(bar());\n    }\n\n    static A.B<? extends Number> bar() {\n        return new A().new B<Integer>();\n    }\n\n    static void foo(A.B<?> arg) {\n        Object o = arg.getValue();\n        Double d = c.getValue();\n        System.out.print(o);\n        System.out.print(d);\n    }\n}\n"}, "nullnullnull");
    }

    public void test1127() {
        this.runNegativeTest(new String[]{"X.java", "class A<E> {\n    class B<T> {\n        T t;\n        T getValue() {\n            return t;\n        }\n    }\n}\n\nclass C<T> extends A<T> {\n}\n\npublic class X {\n    static C.B<Double> c = new C().new B<Double>();\n\n    public static void main(String[] args) {\n        C.B<String> temp = new C().new B<String>();\n        String s = temp.getValue();\n        System.out.println(s);\n        foo(bar());\n    }\n\n    static C.B<? extends Number> bar() {\n        return new C().new B<Integer>();\n    }\n\n    static void foo(C.B<?> arg) {\n        Object o = arg.getValue();\n        Double d = c.getValue();\n        System.out.println(o);\n        System.out.println(d);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tstatic C.B<Double> c = new C().new B<Double>();\n\t       ^^^\nThe member type A.B<Double> must be qualified with a parameterized type, since it is not static\n----------\n2. WARNING in X.java (at line 14)\n\tstatic C.B<Double> c = new C().new B<Double>();\n\t                           ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n3. ERROR in X.java (at line 14)\n\tstatic C.B<Double> c = new C().new B<Double>();\n\t                                   ^\nThe member type A.B<Double> must be qualified with a parameterized type, since it is not static\n----------\n4. ERROR in X.java (at line 17)\n\tC.B<String> temp = new C().new B<String>();\n\t^^^\nThe member type A.B<String> must be qualified with a parameterized type, since it is not static\n----------\n5. WARNING in X.java (at line 17)\n\tC.B<String> temp = new C().new B<String>();\n\t                       ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n6. ERROR in X.java (at line 17)\n\tC.B<String> temp = new C().new B<String>();\n\t                               ^\nThe member type A.B<String> must be qualified with a parameterized type, since it is not static\n----------\n7. ERROR in X.java (at line 23)\n\tstatic C.B<? extends Number> bar() {\n\t       ^^^\nThe member type A.B<? extends Number> must be qualified with a parameterized type, since it is not static\n----------\n8. WARNING in X.java (at line 24)\n\treturn new C().new B<Integer>();\n\t           ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n9. ERROR in X.java (at line 24)\n\treturn new C().new B<Integer>();\n\t                   ^\nThe member type A.B<Integer> must be qualified with a parameterized type, since it is not static\n----------\n10. ERROR in X.java (at line 27)\n\tstatic void foo(C.B<?> arg) {\n\t                ^^^\nThe member type A.B<?> must be qualified with a parameterized type, since it is not static\n----------\n");
    }

    public void test1128() {
        this.runNegativeTest(new String[]{"X.java", "class A<T> {\n\tclass Member<U> {}\n}\n\npublic class X extends A {\n\tvoid foo() {\n\t\tnew Member<String>();\n\t\tnew X().new Member<String>();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic class X extends A {\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. ERROR in X.java (at line 7)\n\tnew Member<String>();\n\t    ^^^^^^\nThe member type A.Member<String> must be qualified with a parameterized type, since it is not static\n----------\n3. ERROR in X.java (at line 8)\n\tnew X().new Member<String>();\n\t            ^^^^^^\nThe member type A.Member<String> must be qualified with a parameterized type, since it is not static\n----------\n");
    }

    public void test1129() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\n\nabstract class Arg1 implements Comparable<Arg1>, Serializable {\n\tprivate static final long serialVersionUID = 1L;\n}\nabstract class Arg2 implements Serializable, Comparable<Arg2> {\n\tprivate static final long serialVersionUID = 1L;\n}\n\ninterface IX<T> {}\n\npublic class X {\n\tvoid foo1(boolean b, IX<String> arg2) {\n\t\tIX<String> o = b ? null : arg2;\n\t\tIX<String> o2 = b ? arg2 : null;\n\t}\n\tvoid foo2(boolean b, IX<String> arg1, IX<? extends Object> arg2) {\n\t\tString s = b ? arg1 : arg2;\n\t}\n\tvoid foo3(boolean b, Arg1 arg1, Arg2 arg2) {\n\t\tString s = b ? arg1 : arg2;\n\t}\n}  "}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 18)\n\tString s = b ? arg1 : arg2;\n\t           ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from IX<capture#2-of ? extends Object> to String\n----------\n2. ERROR in X.java (at line 21)\n\tString s = b ? arg1 : arg2;\n\t           ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object&Comparable<?>&Serializable to String\n----------\n" : "----------\n1. ERROR in X.java (at line 18)\n\tString s = b ? arg1 : arg2;\n\t               ^^^^\nType mismatch: cannot convert from IX<String> to String\n----------\n2. ERROR in X.java (at line 18)\n\tString s = b ? arg1 : arg2;\n\t                      ^^^^\nType mismatch: cannot convert from IX<capture#1-of ? extends Object> to String\n----------\n3. ERROR in X.java (at line 21)\n\tString s = b ? arg1 : arg2;\n\t               ^^^^\nType mismatch: cannot convert from Arg1 to String\n----------\n4. ERROR in X.java (at line 21)\n\tString s = b ? arg1 : arg2;\n\t                      ^^^^\nType mismatch: cannot convert from Arg2 to String\n----------\n");
    }

    public void test1130() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\n\ninterface IX<T extends Comparable<T>&Serializable> {}\n\npublic class X<T extends Comparable<T>&Serializable> {\n\tvoid foo4(boolean b, List<? extends T> l1, List<? extends Comparable<T>> l2) {\n\t\tString s = b ? l1.get(0) : l2.get(0);\n\t}\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 8)\n\tString s = b ? l1.get(0) : l2.get(0);\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Comparable<T> to String\n----------\n" : "----------\n1. ERROR in X.java (at line 8)\n\tString s = b ? l1.get(0) : l2.get(0);\n\t               ^^^^^^^^^\nType mismatch: cannot convert from capture#1-of ? extends T to String\n----------\n2. ERROR in X.java (at line 8)\n\tString s = b ? l1.get(0) : l2.get(0);\n\t                           ^^^^^^^^^\nType mismatch: cannot convert from capture#2-of ? extends Comparable<T> to String\n----------\n");
    }

    public void test1131() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\n\npublic class X<T extends Comparable<T>&Serializable> {\n\t<V extends T> void foo4(boolean b, List<? extends V> l1, List<? extends Comparable<V>> l2) {\n\t\tString s = b ? l1.get(0) : l2.get(0);\n\t}\n} \n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 6)\n\tString s = b ? l1.get(0) : l2.get(0);\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Comparable<capture#3-of ? extends T> to String\n----------\n" : "----------\n1. ERROR in X.java (at line 6)\n\tString s = b ? l1.get(0) : l2.get(0);\n\t               ^^^^^^^^^\nType mismatch: cannot convert from capture#1-of ? extends V to String\n----------\n2. ERROR in X.java (at line 6)\n\tString s = b ? l1.get(0) : l2.get(0);\n\t                           ^^^^^^^^^\nType mismatch: cannot convert from capture#2-of ? extends Comparable<V> to String\n----------\n");
    }

    public void test1132() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\npublic class X<T> {\n\n\tpublic void thisDoesntCompile() {\n\t\tX myThing = new X<Object>();\n\t\tInteger i = myThing.getList().get(0); // Type Mismatch error - Since\n\t\t\t\t\t\t\t\t\t\t\t\t// myThing is unbounded, return\n\t\t\t\t\t\t\t\t\t\t\t\t// type List<Integer> becomes unbounded\n\t}\n\n\tpublic List<Integer> getList() {\n\t\tArrayList<Integer> l = new ArrayList<Integer>();\n\t\tl.add(new Integer(0));\n\t\treturn l;\n\t}\n\n\tpublic void thisMethodCompilesOk() {\n\t\tX<Object> myThing = new X<Object>();\n\t\tInteger i = myThing.getList().get(0);\n\t}\n\n\tpublic void thisMethodAlsoCompilesOk() {\n\t\tX myThing = new X<Object>();\n\t\tList<Integer> l = myThing.getList();\n\t\tInteger i = l.get(0);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tX myThing = new X<Object>();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. ERROR in X.java (at line 7)\n\tInteger i = myThing.getList().get(0); // Type Mismatch error - Since\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to Integer\n----------\n3. WARNING in X.java (at line 24)\n\tX myThing = new X<Object>();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 25)\n\tList<Integer> l = myThing.getList();\n\t                  ^^^^^^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Integer>\n----------\n");
    }

    public void test1133() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\nclass Y {\n\tList<String> foo() { return null; }\n}\n\npublic class X<T> extends Y {\n\tList<String> bar() { return null; }\n\t\n\tvoid m(X x) {\n\t\tList<Object> l1 = x.foo();\n\t\tList<Object> l2 = x.bar();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tvoid m(X x) {\n\t       ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. ERROR in X.java (at line 11)\n\tList<Object> l1 = x.foo();\n\t                  ^^^^^^^\nType mismatch: cannot convert from List<String> to List<Object>\n----------\n3. WARNING in X.java (at line 12)\n\tList<Object> l2 = x.bar();\n\t                  ^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n");
    }

    public void test1134() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n\nclass Y<U> {\n\tList<String> foo() { return null; }\n}\n\npublic class X<T> extends Y<T> {\n\tList<String> bar() { return null; }\n\t\n\tvoid m(X x) {\n\t\tList<Object> l1 = x.foo();\n\t\tList<Object> l2 = x.bar();\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tvoid m(X x) {\n\t       ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 11)\n\tList<Object> l1 = x.foo();\n\t                  ^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n3. WARNING in X.java (at line 12)\n\tList<Object> l2 = x.bar();\n\t                  ^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n4. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test1135() {
        this.runNegativeTest(new String[]{"X.java", "class Foo <T>{\n    private T myT;\n\n    public T getT() {\n        return myT;\n    }\n\n    public void setT(T aT) {\n        myT = aT;\n    }\n}\n\npublic class X extends Foo<X.Baz> {\n\tX.Baz baz;\n    public static void main(String[] args) {\n        X myBar = new X();\n        myBar.setT(new Baz());\n        System.out.println(myBar.getT().toString());\n    }\n\n    private static class Baz {\n        @Override\n        public String toString() {\n            return \"Baz\";\n        }\n    }    \n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tpublic class X extends Foo<X.Baz> {\n\t                           ^^^^^\nThe type X.Baz is not visible\n----------\n");
    }

    public void test1136() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        String xSource = "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<Object>  l1 = Arrays.asList(1, \"X\");\n\t\t\n\t\tB<String> b = null;\n\t\tC<String>c = null;\n\t\tList<Object>  l2 = Arrays.asList(b, c);\n\t}\n}\nclass A<T> {}\ninterface I {}\nclass B<T> extends A<T> implements I {}\nclass C<T> extends A<T> implements I {}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", xSource}, "----------\n1. ERROR in X.java (at line 4)\n\tList<Object>  l1 = Arrays.asList(1, \"X\");\n\t                   ^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Object&Comparable<?>&Serializable> to List<Object>\n----------\n2. ERROR in X.java (at line 8)\n\tList<Object>  l2 = Arrays.asList(b, c);\n\t                   ^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<A<String>&I> to List<Object>\n----------\n", null, true, options);
        } else {
            this.runConformTest(new String[]{"X.java", xSource}, options);
        }
    }

    public void test1137() {
        this.runNegativeTest(new String[]{"X.java", "import java.awt.Container;\nimport java.util.Collection;\n\nabstract class Kollection<T extends Container> implements Collection<T> {}\nabstract class Kontainer extends Container {\n\tprivate static final long serialVersionUID = 1L;\n}\n\npublic class X {\n\tprivate <T extends Container> Collection<T> foo() {\n\t\treturn null;\n\t}\n\tprivate <T extends Container> Kollection<T> bar() {\n\t\treturn null;\n\t}\n\n\tprivate void showProblem() {\n\t\tCollection<?> result = foo();\n\t\tCollection<? extends Container> result1 = foo();\n\t\t\n\t\tCollection<?> result2 = (Collection<Container>)foo();\n\t\tString result3 = foo();\n\t\tString result4 = (String) foo();\t\t\n\n\t\tKollection<?> result5 = bar();\n\t\tKollection<? extends Kontainer> result6 = bar();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 21)\n\tCollection<?> result2 = (Collection<Container>)foo();\n\t                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Collection<Container> to Collection<Container>\n----------\n2. ERROR in X.java (at line 22)\n\tString result3 = foo();\n\t                 ^^^^^\nType mismatch: cannot convert from Collection<Container> to String\n----------\n3. ERROR in X.java (at line 23)\n\tString result4 = (String) foo();\t\t\n\t                 ^^^^^^^^^^^^^^\nCannot cast from Collection<Container> to String\n----------\n");
    }

    public void test1138() {
        this.runConformTest(new String[]{"p/E.java", "package p;\npublic enum E {\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.E.*;\npublic class X implements java.io.Serializable {\n}\n"}, "", null, false, null);
    }

    public void test1139() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport p.X.Super;\nimport static p.Top.*;\n\nclass Top<T> {\n\tstatic class A<U> {}\n}\n\npublic class X extends Super<A<X>> {\n\tstatic class Super<T> extends Top<T>{\n\t}\n}"}, "----------\n1. ERROR in p\\X.java (at line 9)\n\tpublic class X extends Super<A<X>> {\n\t                       ^^^^^\nCycle detected: the type X cannot extend/implement itself or one of its own member types\n----------\n");
    }

    public void test1140() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p.X.Super;\nimport static p.Top.*;\n\nclass Top<T> {\n        static class A<U> {}\n}\n\npublic class X extends Super<A<X>> {\n        class Super<T> extends Top<T>{\n        }\n}"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\timport static p.X.Super;\n\t              ^^^^^^^^^\nThe import p.X.Super cannot be resolved\n----------\n2. ERROR in p\\X.java (at line 9)\n\tpublic class X 