/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTestMixed
extends JavadocTest {
    String docCommentSupport = "enabled";
    String reportInvalidJavadoc = "error";
    String reportMissingJavadocTags = "error";
    String reportMissingJavadocComments = null;
    static /* synthetic */ Class class$0;

    public JavadocTestMixed(String name) {
        super(name);
    }

    public static Class javadocTestClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.JavadocTestMixed");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public static Test suite() {
        return JavadocTestMixed.buildAllCompliancesTestSuite(JavadocTestMixed.javadocTestClass());
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        return options;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocComments = null;
    }

    public void test001() {
        this.runConformTest(new String[]{"test/X.java", "package test;\n/** */\npublic class X {\n  /** */\n  public int x;\n  /** */\n\t public X() {}\n  /** */\n\t public void foo() {}\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"test/X.java", "package test;\n/** */\nclass X {\n  /** */\n  int x;\n  /** */\n\t X() {}\n  /** */\n  void foo() {}\n}\n"});
    }

    public void test003() {
        this.runConformTest(new String[]{"test/X.java", "package test;\n/** */\nclass X {\n  /** */\n  protected int x;\n  /** */\n  protected X() {}\n  /** */\n  protected void foo() {}\n}\n"});
    }

    public void test004() {
        this.runConformTest(new String[]{"test/X.java", "package test;\n/** */\nclass X {\n  /** */\n  private int x;\n  /** */\n  private X() {}\n  /** */\n  private void foo() {}\n}\n"});
    }

    public void test005() {
        this.reportInvalidJavadoc = "ignore";
        this.runConformTest(new String[]{"test/X.java", "package test;\npublic class X {\n\tpublic int x;\n\n\tpublic X() {}\n\n\tpublic void foo() {}\n}\n"});
    }

    public void test006() {
        this.reportMissingJavadocComments = "ignore";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString s1 = \"non-terminated;\n\tvoid foo() {}\n\tString s2 = \"terminated\";\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tString s1 = \"non-terminated;\n\t            ^^^^^^^^^^^^^^^^\nString literal is not properly closed by a double-quote\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\npublic class X {\n\t/** Field javadoc comment */\n\tpublic int x;\n\n\t/** Constructor javadoc comment */\n\tpublic X() {\n\t}\n\t/** Method javadoc comment */\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 2)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test011() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/** Class javadoc comment */\npublic class X {\n\tpublic int x;\n\n\t/** Constructor javadoc comment */\n\tpublic X() {\n\t}\n\t/** Method javadoc comment */\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 4)\n\tpublic int x;\n\t           ^\nJavadoc: Missing comment for public declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test012() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/** Class javadoc comment */\npublic class X {\n\t/** Field javadoc comment */\n\tpublic int x;\n\n\tpublic X() {\n\t}\n\t/** Method javadoc comment */\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\tpublic X() {\n\t       ^^^\nJavadoc: Missing comment for public declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test013() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/** Class javadoc comment */\npublic class X {\n\t/** Field javadoc comment */\n\tpublic int x;\n\n\t/** Constructor javadoc comment */\n\tpublic X() {\n\t}\n\tpublic void foo(int a) {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 10)\n\tpublic void foo(int a) {\n\t            ^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test021() {
        this.runConformTest(new String[]{"test/X.java", "package test;\n/**\n * Valid class javadoc\n * @author ffr\n * @see \"Test class X\"\n */\npublic class X {\n/**\n * Valid field javadoc\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>\n */\n\tpublic int x;\n\n/**\n * Valid constructor javadoc\n * @param str Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic X(String str) {\n\t}\n/**\n * Valid method javadoc\n * @param list Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @return Valid return tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector list) {\n\t\treturn \"\";\n\t}\n}\n"});
    }

    public void test022() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/**\n * Unexpected tag in class javadoc\n * @author ffr\n * @see \"Test class X\"\n * @param x\n */\npublic class X {\n/**\n * Valid field javadoc\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>\n */\n\tpublic int x;\n\n/**\n * Valid constructor javadoc\n * @param str Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic X(String str) {\n\t}\n/**\n * Valid method javadoc\n * @param list Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @return Valid return tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector list) {\n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @param x\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test023() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/**\n * Valid class javadoc\n * @author ffr\n * @see \"Test class X\"\n */\npublic class X {\n/**\n * Unexpected tag in field javadoc\n * @throws InvalidException\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>\n */\n\tpublic int x;\n\n/**\n * Valid constructor javadoc\n * @param str Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic X(String str) {\n\t}\n/**\n * Valid method javadoc\n * @param list Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @return Valid return tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector list) {\n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 10)\n\t* @throws InvalidException\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test024() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/**\n * Valid class javadoc\n * @author ffr\n * @see \"Test class X\"\n */\npublic class X {\n/**\n * Valid field javadoc\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>\n */\n\tpublic int x;\n\n/**\n * Wrong tags order in constructor javadoc\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @param str Valid param tag\n * @deprecated\n */\n\tpublic X(String str) {\n\t}\n/**\n * Valid method javadoc\n * @param list Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @return Valid return tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector list) {\n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 19)\n\t* @param str Valid param tag\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in test\\X.java (at line 22)\n\tpublic X(String str) {\n\t                ^^^\nJavadoc: Missing tag for parameter str\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test025() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/**\n * Valid class javadoc\n * @author ffr\n * @see \"Test class X\"\n */\npublic class X {\n/**\n * Valid field javadoc\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>\n */\n\tpublic int x;\n\n/**\n * Valid constructor javadoc\n * @param str Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic X(String str) {\n\t}\n/**\n * Wrong param tag in method javadoc\n * @param vector Invalid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @return Valid return tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector list) {\n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 26)\n\t* @param vector Invalid param tag\n\t         ^^^^^^\nJavadoc: Parameter vector is not declared\n----------\n2. ERROR in test\\X.java (at line 33)\n\tpublic String foo(java.util.Vector list) {\n\t                                   ^^^^\nJavadoc: Missing tag for parameter list\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test026() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/**\n * Invalid see tag in class javadoc\n * @author ffr\n * @see \"Test class X\n */\npublic class X {\n/**\n * Invalid field javadoc\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>unexpected text\n */\n\tpublic int x;\n\n/**\n * Missing throws tag in constructor javadoc\n * @param str Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic X(String str) throws java.io.IOException {\n\t}\n/**\n * Missing return tag in method javadoc\n * @param list Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector list) {\n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 5)\n\t* @see \"Test class X\n\t       ^^^^^^^^^^^^^\nJavadoc: Invalid reference\n----------\n2. ERROR in test\\X.java (at line 10)\n\t* @see <a href=\"http://www.ibm.com\">Valid URL</a>unexpected text\n\t                                              ^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n3. ERROR in test\\X.java (at line 22)\n\tpublic X(String str) throws java.io.IOException {\n\t                            ^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IOException\n----------\n4. ERROR in test\\X.java (at line 32)\n\tpublic String foo(java.util.Vector list) {\n\t       ^^^^^^\nJavadoc: Missing tag for return type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test030() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/**\n * Valid class javadoc on invalid declaration\n * @author ffr\n * @see \"Test class X\"\n */\nprotected class X {\n/**\n * Valid field javadoc\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>\n */\n\tpublic int x;\n\n/**\n * Valid constructor javadoc\n * @param str Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic X(String str) {\n\t}\n/**\n * Valid method javadoc\n * @param list Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @return Valid return tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector list) {\n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\tprotected class X {\n\t                ^\nIllegal modifier for the class X; only public, abstract & final are permitted\n----------\n");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/**\n * Valid class javadoc\n * @author ffr\n * @see \"Test class X\"\n */\npublic class X {\n/**\n * Valid field javadoc on invalid declaration\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>\n */\n\tpublic int x\n\n/**\n * Valid constructor javadoc\n * @param str Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic X(String str) {\n\t}\n/**\n * Valid method javadoc\n * @param list Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @return Valid return tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector list) {\n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 12)\n\tpublic int x\n\t           ^\nSyntax error, insert \";\" to complete ClassBodyDeclarations\n----------\n");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/**\n * Valid class javadoc\n * @author ffr\n * @see \"Test class X\"\n */\npublic class X {\n/**\n * Valid field javadoc\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>\n */\n\tpublic int x;\n\n/**\n * Valid constructor javadoc on invalid declaration\n * @param str Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic X(String str) \n\t}\n/**\n * Valid method javadoc\n * @param list Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @return Valid return tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector list) {\n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 22)\n\tpublic X(String str) \n\t                   ^\nSyntax error on token \")\", { expected after this token\n----------\n");
    }

    public void _test033() {
        this.runNegativeTest(new String[]{"test/X.java", "package test;\n/**\n * Valid class javadoc\n * @author ffr\n * @see \"Test class X\"\n */\npublic class X {\n/**\n * Valid field javadoc\n * @see <a href=\"http://www.ibm.com\">Valid URL</a>\n */\n\tpublic int x;\n\n/**\n * Valid constructor javadoc\n * @param str Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic X(String str) {\n\t}\n/**\n * Valid method javadoc on invalid declaration\n * @param list Valid param tag\n * @throws NullPointerException Valid throws tag\n * @exception IllegalArgumentException Valid throws tag\n * @return Valid return tag\n * @see X Valid see tag\n * @deprecated\n */\n\tpublic String foo(java.util.Vector ) {\n\t\treturn \"\";\n\t}\n}\n"}, this.complianceLevel < 0x310000L ? "----------\n1. ERROR in test\\X.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in test\\X.java (at line 26)\n\t* @param list Valid param tag\n\t         ^^^^\nJavadoc: Parameter list is not declared\n----------\n3. ERROR in test\\X.java (at line 33)\n\tpublic String foo(java.util.Vector ) {\n\t                            ^^^^^^\nSyntax error on token \"Vector\", VariableDeclaratorId expected after this token\n----------\n4. ERROR in test\\X.java (at line 36)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n" : "----------\n1. ERROR in test\\X.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in test\\X.java (at line 26)\n\t* @param list Valid param tag\n\t         ^^^^\nJavadoc: Parameter list is not declared\n----------\n3. ERROR in test\\X.java (at line 33)\n\tpublic String foo(java.util.Vector ) {\n\t                           ^\nSyntax error on token \".\", ... expected\n----------\n4. ERROR in test\\X.java (at line 36)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n");
    }

    public void test040() {
        this.reportMissingJavadocComments = "ignore";
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t/**\n\t/**\n\t/** \n\t * @param str\n\t * @param x\n\t */\n\tpublic void bar(String str, int x) {\n\t}\n\tpublic void foo() {\n\t\tbar(\"toto\", 0 /* block comment inline */);\n\t}\n}\n"});
    }

    public void test041() {
        this.reportMissingJavadocComments = "ignore";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @see String\n\t * @see #\n\t * @return String\n\t */\n\tString bar() {return \"\";}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see #\n\t       ^\nJavadoc: Invalid reference\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }
}

