/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class Jsr14Test
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public Jsr14Test(String name) {
        super(name);
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        return options;
    }

    public static Test suite() {
        return Jsr14Test.buildMinimalComplianceTestSuite(Jsr14Test.testClass(), 2);
    }

    public void test1() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.class);\n\t}\n}"}, "class X");
        String expectedOutput = "  // Method descriptor #18 ([Ljava/lang/String;)V\n  // Stack: 3, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [19]\n     3  getstatic X.class$0 : java.lang.Class [25]\n     6  dup\n     7  ifnonnull 35\n    10  pop\n    11  ldc <String \"X\"> [27]\n    13  invokestatic java.lang.Class.forName(java.lang.String) : java.lang.Class [28]\n    16  dup\n    17  putstatic X.class$0 : java.lang.Class [25]\n    20  goto 35\n    23  new java.lang.NoClassDefFoundError [34]\n    26  dup_x1\n    27  swap\n    28  invokevirtual java.lang.Throwable.getMessage() : java.lang.String [36]\n    31  invokespecial java.lang.NoClassDefFoundError(java.lang.String) [42]\n    34  athrow\n    35  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [45]\n    38  return\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.Jsr14Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

