/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.RegressionTestSetup;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;

public class NegativeLambdaExpressionsTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public NegativeLambdaExpressionsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NegativeLambdaExpressionsTest.buildMinimalComplianceTestSuite(NegativeLambdaExpressionsTest.testClass(), 32);
    }

    public static Test setUpTest(Test test) throws Exception {
        TestCase.setUpTest(test);
        RegressionTestSetup suite = new RegressionTestSetup(0x340000L);
        suite.addTest(test);
        return suite;
    }

    protected Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        return defaultOptions;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void foo(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    int x, y;\n    I i = () -> {\n      int z = 10;\n    };\n    i++;\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = () -> {\n\t      ^^^^^\nLambda expression's signature does not match the signature of the functional interface method foo(int, int)\n----------\n2. ERROR in X.java (at line 10)\n\ti++;\n\t^^^\nType mismatch: cannot convert from I to int\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n void foo(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    int x, y;\n    I i = (p, q) -> {\n      int r = 10;\n    };\n    i++;\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ti++;\n\t^^^\nType mismatch: cannot convert from I to int\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n void foo(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    int x, y;\n    I i = null, i2 = (p, q) -> {\n      int r = 10;\n    }, i3 = null;\n    i++;\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ti++;\n\t^^^\nType mismatch: cannot convert from I to int\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "interface IX {\n    public void foo();\n}\npublic class X {\n     IX i = () -> 42;\n     int x\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tIX i = () -> 42;\n\t             ^^\nVoid methods cannot return a value\n----------\n2. ERROR in X.java (at line 6)\n\tint x\n\t    ^\nSyntax error, insert \";\" to complete FieldDeclaration\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "interface IX{\n\tpublic void foo();\n}\npublic class X {\n\tIX i = super::toString;\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "interface One{}\ninterface Two{}\ninterface Three{}\ninterface Four{}\ninterface Five{}\ninterface Blah{}\ninterface Outer<T1,T2>{interface Inner<T3,T4>{interface Leaf{ <T> void method(); } } }\ninterface IX{\n\tpublic void foo();\n}\npublic class X {\n\tIX i = Outer<One, Two>.Inner<Three, Four>.Deeper<Five, Six<String>>.Leaf::<Blah, Blah>method;\n   int x\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tIX i = Outer<One, Two>.Inner<Three, Four>.Deeper<Five, Six<String>>.Leaf::<Blah, Blah>method;\n\t       ^^^^^^^^^^^^^^^^^^^^^\nThe member type Outer<One,Two>.Inner cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type Outer<One,Two>\n----------\n2. ERROR in X.java (at line 12)\n\tIX i = Outer<One, Two>.Inner<Three, Four>.Deeper<Five, Six<String>>.Leaf::<Blah, Blah>method;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nOuter.Inner.Deeper cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 12)\n\tIX i = Outer<One, Two>.Inner<Three, Four>.Deeper<Five, Six<String>>.Leaf::<Blah, Blah>method;\n\t                                                       ^^^\nSix cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 13)\n\tint x\n\t    ^\nSyntax error, insert \";\" to complete FieldDeclaration\n----------\n");
    }

    public void _test007() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic class X {\n    void foo() {\n            I t1 = f -> {{};\n            I t2 = () -> 42;\n        } \n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tint\n\t^^^\nSyntax error on token \"int\", delete this token\n----------\n", true);
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  int foo(X x);\n}\npublic class X {\n  public static void main(String[] args) {\n    I i = (X this) -> 10;  \n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = (X this) -> 10;  \n\t         ^^^^\nLambda expressions cannot declare a this parameter\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "import java.awt.event.ActionListener;\ninterface I {\n    void doit(String s1, String s2);\n}\npublic class X {\n  public void test1(int x) {\n    ActionListener al = (public xyz) -> System.out.println(xyz); \n    I f = (abstract final s, @Nullable t) -> System.out.println(s + t); \n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tActionListener al = (public xyz) -> System.out.println(xyz); \n\t                            ^^^\nSyntax error, modifiers and annotations are not allowed for the lambda parameter xyz as its type is elided\n----------\n2. ERROR in X.java (at line 8)\n\tI f = (abstract final s, @Nullable t) -> System.out.println(s + t); \n\t                      ^\nSyntax error, modifiers and annotations are not allowed for the lambda parameter s as its type is elided\n----------\n3. ERROR in X.java (at line 8)\n\tI f = (abstract final s, @Nullable t) -> System.out.println(s + t); \n\t                                   ^\nSyntax error, modifiers and annotations are not allowed for the lambda parameter t as its type is elided\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tObject foo(int [] ia);\n}\npublic class X {\n\tI i = (int [] ia) -> {\n\t\t      return ia.clone();\n\t      };\n\tI i2 = int[]::clone;\n\tZork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tObject foo(int [] ia);\n}\npublic class X {\n\tI i = (int [] ia) -> {\n\t\tZork z;\n\t\tunknown = 0;\n;\t\tint a = 42 + ia;\n\t\treturn ia.clone();\n\t};\n\tstatic void staticLambda() {\n\t\tI i = (int [] ia) -> this;\n\t}\n\tI j = array -> {\n\t\tint a = array[2] + 3;\n\t\tint b = 42 + array;\n\t\tSystem.out.println(\"i(array) = \" + i.foo(array));\n\t\treturn;\n\t};\n\tRunnable r = () -> { return 42; };\n\tvoid anotherLambda() {\n\t\tfinal int beef = 0;\n\t\tI k = (int [] a) -> a.length + beef;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\tunknown = 0;\n\t^^^^^^^\nunknown cannot be resolved to a variable\n----------\n3. ERROR in X.java (at line 8)\n\t;\t\tint a = 42 + ia;\n\t \t\t        ^^^^^^^\nThe operator + is undefined for the argument type(s) int, int[]\n----------\n4. ERROR in X.java (at line 12)\n\tI i = (int [] ia) -> this;\n\t                     ^^^^\nCannot use this in a static context\n----------\n5. ERROR in X.java (at line 16)\n\tint b = 42 + array;\n\t        ^^^^^^^^^^\nThe operator + is undefined for the argument type(s) int, int[]\n----------\n6. ERROR in X.java (at line 18)\n\treturn;\n\t^^^^^^^\nThis method must return a result of type Object\n----------\n7. ERROR in X.java (at line 20)\n\tRunnable r = () -> { return 42; };\n\t                     ^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n\tstatic void foo() {\n\t\tI i = () -> {\n\t\t\tSystem.out.println(this);\n\t\t\tI j = () -> {\n\t\t\t\tSystem.out.println(this);\n\t\t\t\tI k = () -> {\n\t\t\t\t\tSystem.out.println(this);\n\t\t\t\t};\n\t\t\t};\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(this);\n\t                   ^^^^\nCannot use this in a static context\n----------\n2. ERROR in X.java (at line 9)\n\tSystem.out.println(this);\n\t                   ^^^^\nCannot use this in a static context\n----------\n3. ERROR in X.java (at line 11)\n\tSystem.out.println(this);\n\t                   ^^^^\nCannot use this in a static context\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n\tvoid foo(Zork z) {\n\t\tI i = () -> {\n\t\t\tSystem.out.println(this);\n\t\t\tI j = () -> {\n\t\t\t\tSystem.out.println(this);\n\t\t\t\tI k = () -> {\n\t\t\t\t\tSystem.out.println(this);\n\t\t\t\t};\n\t\t\t};\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo(Zork z) {\n\t         ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x, int y, int z);\t\n}\npublic class X {\n     I i = (final @Marker int x, @Undefined static strictfp public Object o, static volatile int p) -> x;\n}\n@interface Marker {\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tI i = (final @Marker int x, @Undefined static strictfp public Object o, static volatile int p) -> x;\n\t                             ^^^^^^^^^\nUndefined cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tI i = (final @Marker int x, @Undefined static strictfp public Object o, static volatile int p) -> x;\n\t                                                              ^^^^^^\nLambda expression's parameter o is expected to be of type int\n----------\n3. ERROR in X.java (at line 5)\n\tI i = (final @Marker int x, @Undefined static strictfp public Object o, static volatile int p) -> x;\n\t                                                                     ^\nIllegal modifier for parameter o; only final is permitted\n----------\n4. ERROR in X.java (at line 5)\n\tI i = (final @Marker int x, @Undefined static strictfp public Object o, static volatile int p) -> x;\n\t                                                                                            ^\nIllegal modifier for parameter p; only final is permitted\n----------\n5. ERROR in X.java (at line 5)\n\tI i = (final @Marker int x, @Undefined static strictfp public Object o, static volatile int p) -> x;\n\t                                                                                                  ^\nVoid methods cannot return a value\n----------\n");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.List;\ninterface I { void run(int x); }\ninterface J { void run(int x, String s); }\ninterface K { void run(Collection<String> jobs); }\nclass X {\n    I i1 = (String y) -> {};\n    I i2 = (y) -> {};\n    I i3 = y -> {};\n    I i4 = (int x, String y) -> {};\n    I i5 = (int x) -> {};\n    J j1 = () -> {};\n    J j2 = (x, s) -> {};\n    J j3 = (String x, int s) -> {};\n    J j4 = (int x, String s) -> {};\n    J j5 = x ->  {};\n    K k1 = (Collection l) -> {};\n    K k2 = (Collection <Integer> l) -> {};\n    K k3 = (Collection <String> l) -> {};\n    K k4 = (List <String> l) -> {};\n    K k5 = (l) -> {};\n    K k6 = l -> {};\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i1 = (String y) -> {};\n\t        ^^^^^^\nLambda expression's parameter y is expected to be of type int\n----------\n2. ERROR in X.java (at line 10)\n\tI i4 = (int x, String y) -> {};\n\t       ^^^^^^^^^^^^^^^^^^^^\nLambda expression's signature does not match the signature of the functional interface method run(int)\n----------\n3. ERROR in X.java (at line 12)\n\tJ j1 = () -> {};\n\t       ^^^^^\nLambda expression's signature does not match the signature of the functional interface method run(int, String)\n----------\n4. ERROR in X.java (at line 14)\n\tJ j3 = (String x, int s) -> {};\n\t        ^^^^^^\nLambda expression's parameter x is expected to be of type int\n----------\n5. ERROR in X.java (at line 14)\n\tJ j3 = (String x, int s) -> {};\n\t                  ^^^\nLambda expression's parameter s is expected to be of type String\n----------\n6. ERROR in X.java (at line 16)\n\tJ j5 = x ->  {};\n\t       ^^^^\nLambda expression's signature does not match the signature of the functional interface method run(int, String)\n----------\n7. WARNING in X.java (at line 17)\n\tK k1 = (Collection l) -> {};\n\t        ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n8. ERROR in X.java (at line 17)\n\tK k1 = (Collection l) -> {};\n\t        ^^^^^^^^^^\nLambda expression's parameter l is expected to be of type Collection<String>\n----------\n9. ERROR in X.java (at line 18)\n\tK k2 = (Collection <Integer> l) -> {};\n\t        ^^^^^^^^^^\nLambda expression's parameter l is expected to be of type Collection<String>\n----------\n10. ERROR in X.java (at line 20)\n\tK k4 = (List <String> l) -> {};\n\t        ^^^^\nLambda expression's parameter l is expected to be of type Collection<String>\n----------\n");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  String foo();\n}\npublic class X {\n  public static void main(String[] args) {\n    I i1 = () -> 42;\n    I i2 = () -> \"Hello\";\n    I i3 = () -> { return 42; };\n    I i4 = () -> { return \"Hello\"; };\n    I i5 = () -> {};\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i1 = () -> 42;\n\t             ^^\nType mismatch: cannot convert from int to String\n----------\n2. ERROR in X.java (at line 8)\n\tI i3 = () -> { return 42; };\n\t                      ^^\nType mismatch: cannot convert from int to String\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  Integer foo();\n}\npublic class X {\n  public static void main(String[] args) {\n    I i1 = () -> 42;\n    I i2 = () -> \"Hello\";\n    I i3 = () -> { return 42; };\n    I i4 = () -> { return \"Hello\"; };\n    I i5 = () -> {};\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i2 = () -> \"Hello\";\n\t             ^^^^^^^\nType mismatch: cannot convert from String to Integer\n----------\n2. ERROR in X.java (at line 9)\n\tI i4 = () -> { return \"Hello\"; };\n\t                      ^^^^^^^\nType mismatch: cannot convert from String to Integer\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  I foo();\n}\nclass P implements I {\n   public I foo() { return null; }\n}\npublic class X {\n  public static void main(String[] args) {\n    I i1 = () -> 42;\n    I i2 = () -> \"Hello\";\n    I i3 = () -> { return 42; };\n    I i4 = () -> { return \"Hello\"; };\n    I i5 = () -> { return new P(); };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i1 = () -> 42;\n\t             ^^\nType mismatch: cannot convert from int to I\n----------\n2. ERROR in X.java (at line 10)\n\tI i2 = () -> \"Hello\";\n\t             ^^^^^^^\nType mismatch: cannot convert from String to I\n----------\n3. ERROR in X.java (at line 11)\n\tI i3 = () -> { return 42; };\n\t                      ^^\nType mismatch: cannot convert from int to I\n----------\n4. ERROR in X.java (at line 12)\n\tI i4 = () -> { return \"Hello\"; };\n\t                      ^^^^^^^\nType mismatch: cannot convert from String to I\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void foo();\n}\npublic class X {\n    I i1 = () -> 42;\n    I i3 = () -> { return 42; };\n    I i4 = () -> System.out.println();\n    I i5 = () -> { System.out.println(); };\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tI i1 = () -> 42;\n\t             ^^\nVoid methods cannot return a value\n----------\n2. ERROR in X.java (at line 6)\n\tI i3 = () -> { return 42; };\n\t               ^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  int foo(int x);\n}\npublic class X {\n    I i5 = (x) -> { if (x == 0) throw new NullPointerException(); };\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tI i5 = (x) -> { if (x == 0) throw new NullPointerException(); };\n\t       ^^^^^^\nThis method must return a result of type int\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  int foo(int x);\n}\npublic class X {\n    I i5 = (x) -> { if (x == 0) throw new NullPointerException(); throw new NullPointerException(); };\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  J foo();\n}\ninterface J {\n  int foo();\n}\npublic class X {\n    I I = () -> () -> 10;\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  J foo();\n}\ninterface J {\n  int foo();\n}\npublic class X {\n    I i1 = () -> 10;\n    I i2 = () -> { return 10; };\n    I i3 = () -> () -> 10;\n    I i4 = () -> { return () -> 10; };\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tI i1 = () -> 10;\n\t             ^^\nType mismatch: cannot convert from int to J\n----------\n2. ERROR in X.java (at line 9)\n\tI i2 = () -> { return 10; };\n\t                      ^^\nType mismatch: cannot convert from int to J\n----------\n");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "interface I3 {\n  Object foo();\n}\npublic class X {\n  public static void main(String[] args) {\n    I3 i = () -> 42; // Warning: Autoboxing, but casting to Object??\n  }\n  Object foo(Zork z) {\n\t  return 42;\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tObject foo(Zork z) {\n\t           ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\r\n  String foo();\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\r\n    I i = () -> 42;\r\n    I i2 = () -> \"Hello, Lambda\";\r\n  }\r\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = () -> 42;\n\t            ^^\nType mismatch: cannot convert from int to String\n----------\n");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\r\n  String foo();\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\r\n    I i = () -> {\r\n      return 42;\r\n    };\r\n    I i2 = () -> {\r\n      return \"Hello, Lambda as a block!\";\r\n    };\r\n  }\r\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\treturn 42;\n\t       ^^\nType mismatch: cannot convert from int to String\n----------\n");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\r\n  int baz();\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\n    I i1 = () -> {\n      System.out.println(\"No return\");\n    }; // Error: Lambda block should return value\n    I i2 = () -> {\n      if (Math.random() < 0.5) return 42;\n    }; // Error: Lambda block doesn't always return a value\n    I i3 = () -> {\n      return 42;\n      System.out.println(\"Dead!\");\n    }; // Error: Lambda block has dead code\n  }\n  public static I doesFlowInfoEscape() {\n    I i1 = () -> {\n      return 42;\n    };\n    return i1; // Must not complain about unreachable code!\n  }\n  public static I areExpresionsCheckedForReturns() {\n    I i1 = () -> 42;  // Must not complain about missing return!\n    return i1;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i1 = () -> {\n\t       ^^^^^\nThis method must return a result of type int\n----------\n2. ERROR in X.java (at line 9)\n\tI i2 = () -> {\n\t       ^^^^^\nThis method must return a result of type int\n----------\n3. ERROR in X.java (at line 14)\n\tSystem.out.println(\"Dead!\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void foo();\n}\npublic class X {\n  int data;\n  public void main(String[] args) {\n    I i1 = () -> data++;\n    I i2 = () -> data = 10;\n    I i3 = () -> data += 10;\n    I i4 = () -> --data;\n    I i5 = () -> bar();\n    I i6 = () -> new X();\n    I i7 = () -> 0;\n    I i = () -> 1 + data++;\n  }\n  int bar() {\n\t  return 0;\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tI i7 = () -> 0;\n\t             ^\nVoid methods cannot return a value\n----------\n2. ERROR in X.java (at line 14)\n\tI i = () -> 1 + data++;\n\t            ^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X extends Y {\n\tstatic void foo() {\n\t\tI i1 = this::zoo;\n\t\tI i2 = super::boo;\n\t\tI i3 = () -> super.zoo();\n\t\tI i4 = () -> this.boo();\n\t}\n\tvoid boo () {\n\t\tI i1 = this::zoo;\n\t\tI i2 = super::boo;\n\t\tI i3 = () -> super.zoo();\n\t\tI i4 = () -> this.boo();\n\t}\n\tvoid zoo() {\n\t}\n}\nclass Y {\n\tvoid boo() {\n\t}\n\tvoid zoo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i1 = this::zoo;\n\t       ^^^^\nCannot use this in a static context\n----------\n2. ERROR in X.java (at line 7)\n\tI i2 = super::boo;\n\t       ^^^^^\nCannot use super in a static context\n----------\n3. ERROR in X.java (at line 8)\n\tI i3 = () -> super.zoo();\n\t             ^^^^^\nCannot use super in a static context\n----------\n4. ERROR in X.java (at line 9)\n\tI i4 = () -> this.boo();\n\t             ^^^^\nCannot use this in a static context\n----------\n");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void foo();\n  void goo();\n}\npublic class X {\n  public static void main(String[] args) {\n    X x = () -> 10;\n    I i = () -> 10;\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tX x = () -> 10;\n\t      ^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n2. ERROR in X.java (at line 8)\n\tI i = () -> 10;\n\t      ^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void foo();\n}\npublic class X {\n  public void main(String[] args) {\n    I i = () -> {\n            \t\tp = 10;\n            \t\tZork z = this.blank;\n            \t\tsuper.foo();\n            \t\tgoo();\n           \t};\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tp = 10;\n\t^\np cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 8)\n\tZork z = this.blank;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 8)\n\tZork z = this.blank;\n\t              ^^^^^\nblank cannot be resolved or is not a field\n----------\n4. ERROR in X.java (at line 9)\n\tsuper.foo();\n\t      ^^^\nThe method foo() is undefined for the type Object\n----------\n5. ERROR in X.java (at line 10)\n\tgoo();\n\t^^^\nThe method goo() is undefined for the type X\n----------\n");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", "interface IA {\r\n  void snazz();\r\n}\r\ninterface IB {\r\n  void baz() throws java.io.IOException;\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\n    IA i1 = () -> {\n      throw new java.io.EOFException(); // Error: not declared\n    };\n    IB i2 = () -> {\n      throw new java.io.EOFException(); // Fine: IOException is declared\n    }; // No error, it's all good\n  }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tthrow new java.io.EOFException(); // Error: not declared\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type EOFException\n----------\n");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X.java", "interface IA {\r\n  void snazz();\r\n}\r\ninterface IB {\r\n  void baz() throws java.io.IOException;\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\n    IA i1 = () -> {\n      throw new java.io.EOFException(); // Error: not declared\n    };\n    IB i2 = () -> {\n      throw new java.io.EOFException(); // Fine: IOException is declared\n    }; // No error, it's all good\n  }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tthrow new java.io.EOFException(); // Error: not declared\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type EOFException\n----------\n");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\r\n  int foo(int x, int y);\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\r\n    int x = 2;\r\n    I i = (a, b) -> {\r\n      return 42.0 + a + args.length; // Type mismatch: cannot convert from double to int\r\n    };\r\n  }\r\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\treturn 42.0 + a + args.length; // Type mismatch: cannot convert from double to int\n\t       ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from double to int\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tObject foo(int [] ia);\n}\npublic class X {\n\tI i = (int [] ia) -> ia.clone();\n\tI i2 = int[]::clone;\n\tZork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\r\n  void foo(int x, int y);\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\r\n    int x, y;\r\n    I i = (x, y) -> { // Error: x,y being redeclared\r\n      int args = 10; //  Error args is being redeclared\r\n    };\r\n  }\r\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = (x, y) -> { // Error: x,y being redeclared\n\t       ^\nLambda expression's parameter x cannot redeclare another local variable defined in an enclosing scope. \n----------\n2. ERROR in X.java (at line 7)\n\tI i = (x, y) -> { // Error: x,y being redeclared\n\t          ^\nLambda expression's parameter y cannot redeclare another local variable defined in an enclosing scope. \n----------\n3. ERROR in X.java (at line 8)\n\tint args = 10; //  Error args is being redeclared\n\t    ^^^^\nLambda expression's local variable args cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\r\n  int foo1(String x);\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\r\n    System.out.println(\"Lambda in illegal context: \" + (() -> \"Illegal Lambda\"));\r\n    System.out.println(\"Method Reference in illegal context: \" + System::exit);\r\n    System.out.println(\"Constructor Reference in illegal context: \" + String::new);\r\n    I sam1 = (x) -> x.length(); // OK\r\n    int x = (x) -> 10;\n    X x2 = (x) -> 10;\n  }\r\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tSystem.out.println(\"Lambda in illegal context: \" + (() -> \"Illegal Lambda\"));\n\t                                                   ^^^^^^^^^^^^^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n2. ERROR in X.java (at line 7)\n\tSystem.out.println(\"Method Reference in illegal context: \" + System::exit);\n\t                                                             ^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n3. ERROR in X.java (at line 8)\n\tSystem.out.println(\"Constructor Reference in illegal context: \" + String::new);\n\t                                                                  ^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n4. ERROR in X.java (at line 10)\n\tint x = (x) -> 10;\n\t        ^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n5. ERROR in X.java (at line 11)\n\tX x2 = (x) -> 10;\n\t       ^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.EOFException;\nimport java.io.IOException;\ninterface I { void m() throws IOException; }\ninterface J { void m() throws EOFException; }\ninterface K { void m() throws ClassNotFoundException; }\ninterface IJ extends I, J {}\ninterface IJK extends I, J, K {}\npublic class X {\n\tint var;\n\tIJ ij = () -> {\n\t\tif (var == 0) {\n\t\t\tthrow new IOException();\n\t\t} else if (var == 2) {\n\t\t\tthrow new EOFException();\n\t\t} else {\n\t\t\tthrow new ClassNotFoundException(); \n\t\t}\n\t};\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tthrow new IOException();\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n2. ERROR in X.java (at line 16)\n\tthrow new ClassNotFoundException(); \n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type ClassNotFoundException\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.EOFException;\nimport java.io.IOException;\nimport java.sql.SQLException;\nimport java.sql.SQLTransientException;\nimport java.util.List;\nimport java.util.concurrent.TimeoutException;\ninterface A {\n  List<String> foo(List<String> arg) throws IOException, SQLTransientException;\n}\ninterface B {\n  List foo(List<String> arg) throws EOFException, SQLException, TimeoutException;\n}\ninterface C {\n  List foo(List arg) throws Exception;\n}\ninterface D extends A, B {}\ninterface E extends A, B, C {}\npublic class X {\n\tint var;\n\tD d = (x) -> {\n\t\tswitch (var) {\n\t\tcase 0 : throw new EOFException();\n\t\tcase 1: throw new IOException();\n\t\tcase 2: throw new SQLException();\n\t\tcase 3: throw new SQLTransientException();\n\t\tcase 4: throw new TimeoutException();\n\t\tdefault: throw new NullPointerException();\n\t\t}\n\t};\n\tE e = (x) -> {\n\t\tswitch (var) {\n\t\tcase 0 : throw new EOFException();\n\t\tcase 1: throw new IOException();\n\t\tcase 2: throw new SQLException();\n\t\tcase 3: throw new SQLTransientException();\n\t\tcase 4: throw new TimeoutException();\n\t\tdefault: throw new NullPointerException();\n\t\t}\n\t};\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tList foo(List<String> arg) throws EOFException, SQLException, TimeoutException;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 14)\n\tList foo(List arg) throws Exception;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 14)\n\tList foo(List arg) throws Exception;\n\t         ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. ERROR in X.java (at line 23)\n\tcase 1: throw new IOException();\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n5. ERROR in X.java (at line 24)\n\tcase 2: throw new SQLException();\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type SQLException\n----------\n6. ERROR in X.java (at line 26)\n\tcase 4: throw new TimeoutException();\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type TimeoutException\n----------\n7. ERROR in X.java (at line 33)\n\tcase 1: throw new IOException();\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n8. ERROR in X.java (at line 34)\n\tcase 2: throw new SQLException();\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type SQLException\n----------\n9. ERROR in X.java (at line 36)\n\tcase 4: throw new TimeoutException();\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type TimeoutException\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  <P extends Exception> Object m() throws P;\n}\ninterface J {\n  <Q extends Exception> String m() throws Exception;\n}\ninterface G extends I, J {}\npublic class X {\n\tint var;\n\tG g1 = () -> {\n\t    throw new Exception(); \n\t};\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tG g1 = () -> {\n\t       ^^^^^\nIllegal lambda expression: Method m of type J is generic \n----------\n");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\nimport java.sql.SQLException;\ninterface G1 {\n  <E extends Exception> Object m(E p) throws E;\n}\ninterface G2 {\n  <F extends Exception> String m(F q) throws Exception;\n}\ninterface G extends G1, G2 {} // G has descriptor <F extends Exception> ()->String throws F\npublic class X {\n\tG g = (x) -> { // Elided type is inferred from descriptor to be F\n\t    throw x;    // ~== throw new F()\n\t};\n}\nclass Y implements G {\n\tpublic <T extends Exception> String m(T t) throws T {\n\t\tthrow t;\n\t}\n\tvoid foo(G1 g1) {\n\t\t\tg1.m(new IOException());\n\t}\n\tvoid foo(G2 g2) {\n\t\t\tg2.m(new SQLException());\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tG g = (x) -> { // Elided type is inferred from descriptor to be F\n\t      ^^^^^^\nIllegal lambda expression: Method m of type G2 is generic \n----------\n2. ERROR in X.java (at line 20)\n\tg1.m(new IOException());\n\t^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n3. ERROR in X.java (at line 23)\n\tg2.m(new SQLException());\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type Exception\n----------\n");
    }

    public void test042() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\nimport java.sql.SQLException;\ninterface G1 {\n  <E extends Exception> Object m(E p) throws E;\n}\ninterface G2 {\n  <F extends Exception> String m(F q) throws Exception;\n}\ninterface G extends G1, G2 {} // G has descriptor <F extends Exception> ()->String throws F\npublic class X {\n\tG g1 = (F x) -> {\n\t    throw x;\n\t};\n\tG g2 = (IOException x) -> {\n\t    throw x;\n\t};\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tG g1 = (F x) -> {\n\t       ^^^^^^^^\nIllegal lambda expression: Method m of type G2 is generic \n----------\n2. ERROR in X.java (at line 11)\n\tG g1 = (F x) -> {\n\t        ^\nF cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 14)\n\tG g2 = (IOException x) -> {\n\t       ^^^^^^^^^^^^^^^^^^\nIllegal lambda expression: Method m of type G2 is generic \n----------\n");
    }

    public void test043() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface A { void foo(); }\ninterface B { boolean equals(Object obj); }\ninterface C extends B { void foo(); }\ninterface D<T> { boolean equals(Object obj); void foo(); }\ninterface E { void foo(); Object clone(); }\ninterface F { void foo(List<String> p); }\ninterface G { void foo(List<String> p); }\ninterface H extends F, G {}\ninterface I { List foo(List<String> p); }\ninterface J { List<String> foo(List arg); }\ninterface K extends I, J {}\ninterface L { void foo(List<Integer> p); }\ninterface M extends I, L {}\ninterface N { void foo(List<String> p, Class q); }\ninterface O { void foo(List p, Class<?> q); }\ninterface P extends N, O {}\ninterface Q { long foo(); }\ninterface R { int foo(); }\ninterface S extends Q, R {}\ninterface T<P> { void foo(P p); }\ninterface U<P> { void foo(P p); }\ninterface V<P, Q> extends T<P>, U<Q> {}\ninterface W<T, N extends Number> { void m(T arg); void m(N arg); }\ninterface X extends W<String, Integer> {}\ninterface Y extends W<Integer, Integer> {}\nclass Z {\n    A a              =    () -> {};\n    B b              =    () -> {};\n    C c              =    () -> {};\n    D<?> d           =    () -> {};\n    E e              =    () -> {};\n    F f              =    (p0) -> {};\n    G g              =    (p0) -> {};\n    H h              =    (p0) -> {};\n    I i              =    (p0) -> { return null; };\n    J j              =    (p0) -> { return null; };\n    K k              =    (p0) -> { return null; };\n    L l              =    (p0) -> {};\n    M m              =    (p0) -> {};\n    N n              =    (p0, q0) -> {};\n    O o              =    (p0, q0) -> {};\n    P p              =    (p0, q0) -> {};\n    Q q              =    () -> { return 0;};\n    R r              =    () -> { return 0;};\n    S s              =    () -> {};\n    T<?> t           =    (p0) -> {};\n    U<?> u           =    (p0) -> {};\n    V<?,?> v         =    (p0) -> {};\n    W<?,?> w         =    (p0) -> {};\n    X x              =    (p0) -> {};\n    Y y              =    (p0) -> {};\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tinterface P extends N, O {}\n\t          ^\nName clash: The method foo(List, Class<?>) of type O has the same erasure as foo(List<String>, Class) of type N but does not override it\n----------\n2. ERROR in X.java (at line 20)\n\tinterface S extends Q, R {}\n\t          ^\nThe return types are incompatible for the inherited methods Q.foo(), R.foo()\n----------\n3. ERROR in X.java (at line 23)\n\tinterface V<P, Q> extends T<P>, U<Q> {}\n\t          ^\nName clash: The method foo(P) of type U<P> has the same erasure as foo(P) of type T<P> but does not override it\n----------\n4. ERROR in X.java (at line 29)\n\tB b              =    () -> {};\n\t                      ^^^^^\nThe target type of this expression must be a functional interface\n----------\n5. ERROR in X.java (at line 32)\n\tE e              =    () -> {};\n\t                      ^^^^^\nThe target type of this expression must be a functional interface\n----------\n6. ERROR in X.java (at line 40)\n\tM m              =    (p0) -> {};\n\t                      ^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n7. ERROR in X.java (at line 43)\n\tP p              =    (p0, q0) -> {};\n\t                      ^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n8. ERROR in X.java (at line 46)\n\tS s              =    () -> {};\n\t                      ^^^^^\nThe target type of this expression must be a functional interface\n----------\n9. ERROR in X.java (at line 49)\n\tV<?,?> v         =    (p0) -> {};\n\t                      ^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n10. ERROR in X.java (at line 50)\n\tW<?,?> w         =    (p0) -> {};\n\t                      ^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n11. ERROR in X.java (at line 51)\n\tX x              =    (p0) -> {};\n\t                      ^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n", null, false, options);
    }

    public void test044() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface A { <T> T foo(List<T> p); }\ninterface B { <S> S foo(List<S> p); }\ninterface C { <T, S> S foo(List<T> p); }\ninterface D extends A, B {}\ninterface E extends A, C {}\nclass Z {\n    A a              =    (p) -> { return null;};\n    B b              =    (p) -> { return null;};\n    C c              =    (p) -> { return null;};\n    D d              =    (p) -> { return null;};\n    E e              =    (p) -> { return null;};\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tinterface E extends A, C {}\n\t          ^\nName clash: The method foo(List<T>) of type C has the same erasure as foo(List<T>) of type A but does not override it\n----------\n2. ERROR in X.java (at line 8)\n\tA a              =    (p) -> { return null;};\n\t                      ^^^^^^\nIllegal lambda expression: Method foo of type A is generic \n----------\n3. ERROR in X.java (at line 9)\n\tB b              =    (p) -> { return null;};\n\t                      ^^^^^^\nIllegal lambda expression: Method foo of type B is generic \n----------\n4. ERROR in X.java (at line 10)\n\tC c              =    (p) -> { return null;};\n\t                      ^^^^^^\nIllegal lambda expression: Method foo of type C is generic \n----------\n5. ERROR in X.java (at line 11)\n\tD d              =    (p) -> { return null;};\n\t                      ^^^^^^\nIllegal lambda expression: Method foo of type B is generic \n----------\n6. ERROR in X.java (at line 12)\n\tE e              =    (p) -> { return null;};\n\t                      ^^^^^^\nThe target type of this expression must be a functional interface\n----------\n", null, false, options);
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "interface I { Object m(); }\ninterface J<S> { S m(); }\ninterface K<T> { T m(); }\ninterface Functional<S,T> extends I, J<S>, K<T> {}\nclass X {\n    Functional<String,Integer> f = () -> { };\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tinterface Functional<S,T> extends I, J<S>, K<T> {}\n\t          ^^^^^^^^^^\nThe return types are incompatible for the inherited methods I.m(), J<S>.m(), K<T>.m()\n----------\n2. ERROR in X.java (at line 6)\n\tFunctional<String,Integer> f = () -> { };\n\t                               ^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface A { void f(List<String> ls); }\ninterface B { void f(List<Integer> li); }\ninterface C extends A,B {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tinterface C extends A,B {}\n\t          ^\nName clash: The method f(List<Integer>) of type B has the same erasure as f(List<String>) of type A but does not override it\n----------\n");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    int var = 2;\n    I x = new I() {\n      public void doit() {\n        System.out.println(args); // OK: args is not re-assignment since declaration/first assignment\n        System.out.println(var); // Error: var is not effectively final\n      }\n    };\n    var=2;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tSystem.out.println(var); // Error: var is not effectively final\n\t                   ^^^\nLocal variable var defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    int var = 2;\n    I x2 = () -> {\n      System.out.println(var); // Error: var is not effectively final\n    };\n    var=2;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(var); // Error: var is not effectively final\n\t                   ^^^\nLocal variable var defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    int var = 2;\n    I x2 = () -> {\n      System.out.println(args); // OK: args is not re-assignment since declaration/first assignment\n    };\n    var=2;\n  }\n}"}, "");
    }

    public void test050() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    try {\n      new java.io.File(\"dweep\").getCanonicalPath();\n    } catch (java.io.IOException ioe) {\n      I x2 = () -> {\n        System.out.println(ioe.getMessage()); // OK: args is not re-assignment since declaration/first assignment\n      };\n    };\n  }\n}\n"}, "");
    }

    public void test051() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    java.util.List<String> list = new java.util.ArrayList<>();\n    for (String s : list) {\n      I x2 = () -> {\n        System.out.println(s); // OK: args is not re-assignment since declaration/first assignment\n      };\n    };\n  }\n\n}\n"}, "");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    java.util.List<String> list = new java.util.ArrayList<>();\n    for (String s2 : list) {\n      s2 = \"Nice!\";\n      I x2 = () -> {\n        System.out.println(s2); // Error: var is not effectively final\n      };\n    };\n  }\n\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tSystem.out.println(s2); // Error: var is not effectively final\n\t                   ^^\nLocal variable s2 defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  void foo() {\n    try {\n       System.out.println(\"try\");\n  } catch (NullPointerException | ArrayIndexOutOfBoundsException e) {\n    I i = () -> {\n      System.out.println(e);\n     };\n    }\n  }\n}\n"}, "");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  void foo2(String[] args) {\n   int var;\n   if (args != null)\n      var = args.length;\n   else\n      var = 2;\n   I x = new I() {\n     public void doit() {\n       System.out.println(var);\n       args = null;\n     }\n   };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\targs = null;\n\t^^^^\nLocal variable args defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  void foo(final int x) {\n    I i = () -> {\n      x = 10;\n     };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tx = 10;\n\t^\nThe final local variable x cannot be assigned. It must be blank and not using a compound assignment\n----------\n");
    }

    public void test056() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  void foo(final int x) {\n    X i = new X() {\n      { x = 10; }\n     };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t{ x = 10; }\n\t  ^\nThe final local variable x cannot be assigned, since it is defined in an enclosing type\n----------\n");
    }

    public void test057() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  void foo(int x) {\n    I i = () -> {\n      x = 10;\n     };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tx = 10;\n\t^\nLocal variable x defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  void foo(int x) {\n    X i = new X() {\n      { x = 10; }\n     };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t{ x = 10; }\n\t  ^\nLocal variable x defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test059() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\nclass X {\n\tvoid foo(int [] p) {\n\t\tfor (int is : p) {\n\t\t\tI j = new I () {\n\t\t\t\tpublic void foo() {\n\t\t\t\t\tSystem.out.println(is);\n\t\t\t\t};\n\t\t\t};\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test060() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\nclass X {\n\tvoid foo(int [] p) {\n\t\tfor (int is : p) {\n\t\t\tI j = () -> {\n\t\t\t\t\tSystem.out.println(is);\n\t\t\t};\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  void foo2(String[] args) {\n   int var;\n   if (args != null)\n      var = args.length;\n   else\n      var = 2;\n   I x = () ->  {\n       System.out.println(var);\n       args = null;\n   };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\targs = null;\n\t^^^^\nLocal variable args defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test062() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    int var;\n    if (args != null) {\n       var = args.length;\n       I x = new I() {\n         public void doit() {\n           System.out.println(var);\n         }\n       };\n    } else {\n       var = 2; // HERE\n    }\n  }\n}\n"}, "");
    }

    public void test063() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\ninterface I {\n    void doit();\n}\npublic class X {\n  public static void main(String[] args) throws IOException {\n\n\ttry {\n\t\tthrow new IOException();\n\t} catch (Exception e) {\n\t\tif (args == null) {\n\t\t\tthrow e;\n\t\t} \n                else {\n\t\t\te = null;\n\t\t}\n\t}\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tthrow e;\n\t^^^^^^^^\nUnhandled exception type Exception\n----------\n2. WARNING in X.java (at line 14)\n\telse {\n\t\t\te = null;\n\t\t}\n\t     ^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void test064() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\ninterface I {\n    void doit();\n}\npublic class X {\n  public static void main(String[] args) throws IOException {\n\n\ttry {\n\t\tthrow new IOException();\n\t} catch (Exception e) {\n\t\tif (args == null) {\n\t\t\tthrow e;\n\t\t} \n\t}\n  }\n}\n"}, "");
    }

    public void test065() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\nclass X {\n\tvoid foo() {\n\t\tint x = 10;\n\t\tI i = () -> {\n\t\t\tSystem.out.println(x++);\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(x++);\n\t                   ^\nLocal variable x defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test066() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\nclass X {\n\tvoid foo(int x) throws IOException {\n\t\ttry {\n\t\t\tthrow new IOException();\n\t\t} catch (Exception e) {\n\t\t\tif (x == 0) {\n\t\t\t\tthrow e;\n\t\t\t} else {\n\t\t\t\te = null;\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tthrow e;\n\t^^^^^^^^\nUnhandled exception type Exception\n----------\n2. WARNING in X.java (at line 9)\n\t} else {\n\t\t\t\te = null;\n\t\t\t}\n\t       ^^^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void test067() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit ();\n}\nclass X {\n\tint p;\n\tvoid foo(int p) {\n\t\tint i = 10;\n\t\tX x = new X();\n\t\tx = new X();\n\t\tI l = () -> {\n\t\t\tx.p = i++;\n\t\t};\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tvoid foo(int p) {\n\t             ^\nThe parameter p is hiding a field from type X\n----------\n2. ERROR in X.java (at line 11)\n\tx.p = i++;\n\t      ^\nLocal variable i defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test068() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit ();\n}\nclass X {\n\tint p;\n\tvoid foo(int p) {\n\t\tint i = 10;\n\t\tX x = new X();\n\t\tx = new X();\n\t\tI l = () -> {\n\t\t\tx.p = i;\n\t\t};\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tvoid foo(int p) {\n\t             ^\nThe parameter p is hiding a field from type X\n----------\n2. ERROR in X.java (at line 11)\n\tx.p = i;\n\t^\nLocal variable x defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test069() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p);\n}\npublic class X {\n\tint f1;\n\tint f2;\n\n\tvoid foo() {\n\t\tI i = (int f1)  -> {\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tI i = (int f1)  -> {\n\t           ^^\nThe parameter f1 is hiding a field from type X\n----------\n");
    }

    public void test070() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p);\n}\npublic class X {\n\tvoid foo(int x) {\n\t\tI i = (int x)  -> {\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = (int x)  -> {\n\t           ^\nLambda expression's parameter x cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test071() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p);\n}\npublic class X {\n\tvoid foo(int x) {\n       int l;\n\t\tI i = (int l)  -> {\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = (int l)  -> {\n\t           ^\nLambda expression's parameter l cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test072() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n\tvoid foo(int x) {\n       int l;\n\t\tI i = (int p, int p)  -> {\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = (int p, int p)  -> {\n\t                  ^\nDuplicate parameter p\n----------\n");
    }

    public void test073() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo() {\n\t\tI i = (int p, int q)  -> {\n           int f;\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tint f;\n\t    ^\nThe local variable f is hiding a field from type X\n----------\n");
    }

    public void test074() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int a) {\n\t\tI i = (int p, int q)  -> {\n           int a;\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tint a;\n\t    ^\nLambda expression's local variable a cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test075() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int a) {\n       int loc;\n\t\tI i = (int p, int q)  -> {\n           int loc;\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tint loc;\n\t    ^^^\nLambda expression's local variable loc cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test076() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int a) {\n       int loc;\n\t\tI i = (int p, int q)  -> {\n           int p;\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tint p;\n\t    ^\nDuplicate local variable p\n----------\n");
    }

    public void test077() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int a) {\n       int loc;\n\t\tI i = (int p, int q)  -> {\n           int self, self;\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tint self, self;\n\t          ^^^^\nDuplicate local variable self\n----------\n");
    }

    public void test078() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int a) {\n       int loc;\n\t\tI i = (int p, int q)  -> {\n           I i2 = (int f, int p0) -> {};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tI i2 = (int f, int p0) -> {};\n\t            ^\nThe parameter f is hiding a field from type X\n----------\n");
    }

    public void test079() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int loc;\n\t\tI i = (int p, int q)  -> {\n           I i2 = (int f, int outerp) -> {};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tI i2 = (int f, int outerp) -> {};\n\t            ^\nThe parameter f is hiding a field from type X\n----------\n2. ERROR in X.java (at line 9)\n\tI i2 = (int f, int outerp) -> {};\n\t                   ^^^^^^\nLambda expression's parameter outerp cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test080() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n           I i2 = (int locouter, int outerp) -> {};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i2 = (int locouter, int outerp) -> {};\n\t            ^^^^^^^^\nLambda expression's parameter locouter cannot redeclare another local variable defined in an enclosing scope. \n----------\n2. ERROR in X.java (at line 9)\n\tI i2 = (int locouter, int outerp) -> {};\n\t                          ^^^^^^\nLambda expression's parameter outerp cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test081() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n           I i2 = (int p, int q) -> {};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i2 = (int p, int q) -> {};\n\t            ^\nLambda expression's parameter p cannot redeclare another local variable defined in an enclosing scope. \n----------\n2. ERROR in X.java (at line 9)\n\tI i2 = (int p, int q) -> {};\n\t                   ^\nLambda expression's parameter q cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test082() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = (int lamlocal, int q) -> {};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i2 = (int lamlocal, int q) -> {};\n\t            ^^^^^^^^\nLambda expression's parameter lamlocal cannot redeclare another local variable defined in an enclosing scope. \n----------\n2. ERROR in X.java (at line 10)\n\tI i2 = (int lamlocal, int q) -> {};\n\t                          ^\nLambda expression's parameter q cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test083() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = (int lamlocal, int q) -> {int f;};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i2 = (int lamlocal, int q) -> {int f;};\n\t            ^^^^^^^^\nLambda expression's parameter lamlocal cannot redeclare another local variable defined in an enclosing scope. \n----------\n2. ERROR in X.java (at line 10)\n\tI i2 = (int lamlocal, int q) -> {int f;};\n\t                          ^\nLambda expression's parameter q cannot redeclare another local variable defined in an enclosing scope. \n----------\n3. WARNING in X.java (at line 10)\n\tI i2 = (int lamlocal, int q) -> {int f;};\n\t                                     ^\nThe local variable f is hiding a field from type X\n----------\n");
    }

    public void test084() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = (int lamlocal, int q) -> {int locouter;};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i2 = (int lamlocal, int q) -> {int locouter;};\n\t            ^^^^^^^^\nLambda expression's parameter lamlocal cannot redeclare another local variable defined in an enclosing scope. \n----------\n2. ERROR in X.java (at line 10)\n\tI i2 = (int lamlocal, int q) -> {int locouter;};\n\t                          ^\nLambda expression's parameter q cannot redeclare another local variable defined in an enclosing scope. \n----------\n3. ERROR in X.java (at line 10)\n\tI i2 = (int lamlocal, int q) -> {int locouter;};\n\t                                     ^^^^^^^^\nLambda expression's local variable locouter cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test085() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = (int j, int q) -> {int p, lamlocal;};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i2 = (int j, int q) -> {int p, lamlocal;};\n\t                   ^\nLambda expression's parameter q cannot redeclare another local variable defined in an enclosing scope. \n----------\n2. ERROR in X.java (at line 10)\n\tI i2 = (int j, int q) -> {int p, lamlocal;};\n\t                              ^\nLambda expression's local variable p cannot redeclare another local variable defined in an enclosing scope. \n----------\n3. ERROR in X.java (at line 10)\n\tI i2 = (int j, int q) -> {int p, lamlocal;};\n\t                                 ^^^^^^^^\nLambda expression's local variable lamlocal cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test086() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = (int x1, int x2) -> {int x1, x2;};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i2 = (int x1, int x2) -> {int x1, x2;};\n\t                                ^^\nDuplicate local variable x1\n----------\n2. ERROR in X.java (at line 10)\n\tI i2 = (int x1, int x2) -> {int x1, x2;};\n\t                                    ^^\nDuplicate local variable x2\n----------\n");
    }

    public void test087() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           class X { void foo(int f) {} }\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tclass X { void foo(int f) {} }\n\t      ^\nThe nested type X cannot hide an enclosing type\n----------\n2. WARNING in X.java (at line 10)\n\tclass X { void foo(int f) {} }\n\t                       ^\nThe parameter f is hiding a field from type X\n----------\n");
    }

    public void test088() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int a) {\n       int loc;\n\t\tI i = (int p, int q)  -> {\n           I i2 = new I() { public void foo(int f, int p0) {};\n\t\t};};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tI i2 = new I() { public void foo(int f, int p0) {};\n\t                                     ^\nThe parameter f is hiding a field from type X\n----------\n");
    }

    public void test089() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int loc;\n\t\tI i = (int p, int q)  -> {\n           I i2 = new I() { public void foo(int f, int outerp) {}};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tI i2 = new I() { public void foo(int f, int outerp) {}};\n\t                                     ^\nThe parameter f is hiding a field from type X\n----------\n2. WARNING in X.java (at line 9)\n\tI i2 = new I() { public void foo(int f, int outerp) {}};\n\t                                            ^^^^^^\nThe parameter outerp is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void test090() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n           I i2 = new I() { public void foo(int locouter, int outerp)  {}};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tI i2 = new I() { public void foo(int locouter, int outerp)  {}};\n\t                                     ^^^^^^^^\nThe parameter locouter is hiding another local variable defined in an enclosing scope\n----------\n2. WARNING in X.java (at line 9)\n\tI i2 = new I() { public void foo(int locouter, int outerp)  {}};\n\t                                                   ^^^^^^\nThe parameter outerp is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void test091() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n           I i2 = new I() { public void foo (int p, int q) {}};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tI i2 = new I() { public void foo (int p, int q) {}};\n\t                                      ^\nThe parameter p is hiding another local variable defined in an enclosing scope\n----------\n2. WARNING in X.java (at line 9)\n\tI i2 = new I() { public void foo (int p, int q) {}};\n\t                                             ^\nThe parameter q is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void test092() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = new I() { public void foo (int lamlocal, int q)  {} };\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo (int lamlocal, int q)  {} };\n\t                                      ^^^^^^^^\nThe parameter lamlocal is hiding another local variable defined in an enclosing scope\n----------\n2. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo (int lamlocal, int q)  {} };\n\t                                                    ^\nThe parameter q is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void test093() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = new I() { public void foo (int lamlocal, int q) {int f;}};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo (int lamlocal, int q) {int f;}};\n\t                                      ^^^^^^^^\nThe parameter lamlocal is hiding another local variable defined in an enclosing scope\n----------\n2. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo (int lamlocal, int q) {int f;}};\n\t                                                    ^\nThe parameter q is hiding another local variable defined in an enclosing scope\n----------\n3. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo (int lamlocal, int q) {int f;}};\n\t                                                            ^\nThe local variable f is hiding a field from type X\n----------\n");
    }

    public void test094() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = new I() { public void foo(int lamlocal, int q) {int locouter;}};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo(int lamlocal, int q) {int locouter;}};\n\t                                     ^^^^^^^^\nThe parameter lamlocal is hiding another local variable defined in an enclosing scope\n----------\n2. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo(int lamlocal, int q) {int locouter;}};\n\t                                                   ^\nThe parameter q is hiding another local variable defined in an enclosing scope\n----------\n3. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo(int lamlocal, int q) {int locouter;}};\n\t                                                           ^^^^^^^^\nThe local variable locouter is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void test095() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = new I() { public void foo(int j, int q) {int p, lamlocal;}};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo(int j, int q) {int p, lamlocal;}};\n\t                                            ^\nThe parameter q is hiding another local variable defined in an enclosing scope\n----------\n2. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo(int j, int q) {int p, lamlocal;}};\n\t                                                    ^\nThe local variable p is hiding another local variable defined in an enclosing scope\n----------\n3. WARNING in X.java (at line 10)\n\tI i2 = new I() { public void foo(int j, int q) {int p, lamlocal;}};\n\t                                                       ^^^^^^^^\nThe local variable lamlocal is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void test096() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n       int lamlocal;\n           I i2 = new I() { public void foo(int x1, int x2) {int x1, x2;}};\n\t\t};\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i2 = new I() { public void foo(int x1, int x2) {int x1, x2;}};\n\t                                                      ^^\nDuplicate local variable x1\n----------\n2. ERROR in X.java (at line 10)\n\tI i2 = new I() { public void foo(int x1, int x2) {int x1, x2;}};\n\t                                                          ^^\nDuplicate local variable x2\n----------\n");
    }

    public void test097() {
        this.runNegativeTest(new String[]{"X.java", "class Action<K> {\r\n  static <T1> int fooMethod(Object x) { return 0; }\r\n}\r\ninterface I {\r\n  int foo(Object x);\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\r\n    I functional = Action::<?>fooMethod;\r\n  }\r\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tI functional = Action::<?>fooMethod;\n\t                        ^\nWildcard is not allowed at this location\n----------\n");
    }

    public void test098() {
        this.runNegativeTest(new String[]{"X.java", "class Action<K> {\r\n  int foo(Object x, Object y, Object z) { return 0; }\r\n}\r\ninterface I {\r\n  void foo(Object x);\r\n}\r\npublic class X {\r\n  public static void main(String[] args) {\r\n    Action<Object> exp = new Action<Object>();\r\n    int x,y,z;\r\n    I len6 = foo->exp.<?>method(x, y, z);\r\n  }\r\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tI len6 = foo->exp.<?>method(x, y, z);\n\t                   ^\nWildcard is not allowed at this location\n----------\n");
    }

    public void test_bug399770_1() {
        this.runConformTest(new String[]{"YYY.java", "interface BASE { void run(); }\n@FunctionalInterface\ninterface DERIVED extends BASE {void run();}public class YYY {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Hello\");\t}\n}"}, "Hello");
    }

    public void test_bug399770_2() {
        this.runNegativeTest(new String[]{"YYY.java", "interface BASE { void run(); }\n@FunctionalInterface\ninterface DERIVED extends BASE {void run1();}@FunctionalInterface public class YYY {\n   @FunctionalInterface int x;\t@FunctionalInterface public static void main(String[] args) {\n       @FunctionalInterface int y;\t\tSystem.out.println(\"Hello\");\t}\n}"}, "----------\n1. ERROR in YYY.java (at line 3)\n\tinterface DERIVED extends BASE {void run1();}@FunctionalInterface public class YYY {\n\t          ^^^^^^^\nInvalid '@FunctionalInterface' annotation; DERIVED is not a functional interface\n----------\n2. ERROR in YYY.java (at line 3)\n\tinterface DERIVED extends BASE {void run1();}@FunctionalInterface public class YYY {\n\t                                                                               ^^^\nInvalid '@FunctionalInterface' annotation; YYY is not a functional interface\n----------\n3. ERROR in YYY.java (at line 4)\n\t@FunctionalInterface int x;\t@FunctionalInterface public static void main(String[] args) {\n\t^^^^^^^^^^^^^^^^^^^^\nThe annotation @FunctionalInterface is disallowed for this location\n----------\n4. ERROR in YYY.java (at line 4)\n\t@FunctionalInterface int x;\t@FunctionalInterface public static void main(String[] args) {\n\t                           \t^^^^^^^^^^^^^^^^^^^^\nThe annotation @FunctionalInterface is disallowed for this location\n----------\n5. ERROR in YYY.java (at line 5)\n\t@FunctionalInterface int y;\t\tSystem.out.println(\"Hello\");\t}\n\t^^^^^^^^^^^^^^^^^^^^\nThe annotation @FunctionalInterface is disallowed for this location\n----------\n");
    }

    public void test400745() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\npublic class X {\n\tpublic void foo() {\n\t\tclass Y {};\n\t\tI i = ()  -> {\n\t\t\tclass Y{} ;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tclass Y{} ;\n\t      ^\nDuplicate nested type Y\n----------\n");
    }

    public void test400745a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\npublic class X {\n\tprivate void foo() {\n\t\tclass Y {}\n\t\tX x = new X() {\n\t\t\tprivate void foo() {\n\t\t\t\tclass Y {};\n\t\t\t}\n\t\t};\n\t\tI i = () -> {\n\t\t\tclass LX {\n\t\t\t\tvoid foo() {\n\t\t\t\t\tclass Y {};\n\t\t\t\t}\n\t\t\t};\n\t\t};\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tprivate void foo() {\n\t             ^^^^^\nThe method foo() from the type X is never used locally\n----------\n2. WARNING in X.java (at line 6)\n\tclass Y {}\n\t      ^\nThe type Y is never used locally\n----------\n3. WARNING in X.java (at line 8)\n\tprivate void foo() {\n\t             ^^^^^\nThe method foo() from the type new X(){} is never used locally\n----------\n4. WARNING in X.java (at line 9)\n\tclass Y {};\n\t      ^\nThe type Y is hiding the type Y\n----------\n5. WARNING in X.java (at line 9)\n\tclass Y {};\n\t      ^\nThe type Y is never used locally\n----------\n6. WARNING in X.java (at line 13)\n\tclass LX {\n\t      ^^\nThe type LX is never used locally\n----------\n7. WARNING in X.java (at line 14)\n\tvoid foo() {\n\t     ^^^^^\nThe method foo() from the type LX is never used locally\n----------\n8. WARNING in X.java (at line 15)\n\tclass Y {};\n\t      ^\nThe type Y is hiding the type Y\n----------\n9. WARNING in X.java (at line 15)\n\tclass Y {};\n\t      ^\nThe type Y is never used locally\n----------\n");
    }

    public void test400556() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\npublic interface I<P extends ParameterType> {\n\t<T extends ExceptionType , R extends ReturnType> R doit(P p) throws T;\n}\n\nclass ReturnType {\n}\n\nclass ParameterType {\n}\n\nclass ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\npublic class X {\n\tI i = (p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\I.java (at line 12)\n\tclass ExceptionType extends Exception {\n\t      ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in X.java (at line 3)\n\tI i = (p) -> { return null; };\n\t^\nI is a raw type. References to generic type I<P> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tI i = (p) -> { return null; };\n\t      ^^^^^^\nThe type ReturnType from the descriptor computed for the target context is not visible here.  \n----------\n3. ERROR in X.java (at line 3)\n\tI i = (p) -> { return null; };\n\t      ^^^^^^\nThe type ParameterType from the descriptor computed for the target context is not visible here.  \n----------\n4. ERROR in X.java (at line 3)\n\tI i = (p) -> { return null; };\n\t      ^^^^^^\nThe type ExceptionType from the descriptor computed for the target context is not visible here.  \n----------\n");
    }

    public void test400556a() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\npublic interface I<P extends ParameterType> {\n\t<T extends ExceptionType , R extends ReturnType> R doit(P p) throws T;\n}\n", "p/ReturnType.java", "package p;\npublic class ReturnType {\n}\n\nclass ParameterType {\n}\n", "p/ExceptionType.java", "package p;\npublic class ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\npublic class X {\n\tI i = (p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\ExceptionType.java (at line 2)\n\tpublic class ExceptionType extends Exception {\n\t             ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in X.java (at line 3)\n\tI i = (p) -> { return null; };\n\t^\nI is a raw type. References to generic type I<P> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tI i = (p) -> { return null; };\n\t      ^^^^^^\nThe type ParameterType from the descriptor computed for the target context is not visible here.  \n----------\n");
    }

    public void test400556b() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType> {\n\t<T extends ExceptionType , R extends ReturnType> R doit(List<? extends List<P>>[] p) throws T;\n}\n\nclass ReturnType {\n}\n\nclass ParameterType {\n}\n\nclass ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\npublic class X {\n\tI i = (p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\I.java (at line 13)\n\tclass ExceptionType extends Exception {\n\t      ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in X.java (at line 3)\n\tI i = (p) -> { return null; };\n\t^\nI is a raw type. References to generic type I<P> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tI i = (p) -> { return null; };\n\t      ^^^^^^\nThe type ReturnType from the descriptor computed for the target context is not visible here.  \n----------\n3. ERROR in X.java (at line 3)\n\tI i = (p) -> { return null; };\n\t      ^^^^^^\nThe type ExceptionType from the descriptor computed for the target context is not visible here.  \n----------\n");
    }

    public void test400556c() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType, T extends ExceptionType , R extends ReturnType> {\n\tR doit(List<? extends List<P>>[] p) throws T;\n}\nclass ParameterType {\n}\nclass ReturnType {\n}\nclass ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\npublic class X {\n\tI<?, ?, ?> i = (p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\I.java (at line 10)\n\tclass ExceptionType extends Exception {\n\t      ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. ERROR in X.java (at line 3)\n\tI<?, ?, ?> i = (p) -> { return null; };\n\t               ^^^^^^\nThe type ReturnType from the descriptor computed for the target context is not visible here.  \n----------\n2. ERROR in X.java (at line 3)\n\tI<?, ?, ?> i = (p) -> { return null; };\n\t               ^^^^^^\nThe type ParameterType from the descriptor computed for the target context is not visible here.  \n----------\n3. ERROR in X.java (at line 3)\n\tI<?, ?, ?> i = (p) -> { return null; };\n\t               ^^^^^^\nThe type ExceptionType from the descriptor computed for the target context is not visible here.  \n----------\n");
    }

    public void test400556d() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType, T extends ExceptionType , R extends ReturnType> {\n\tR doit(List<? extends List<P>>[] p) throws T;\n}\n", "p/ParameterType.java", "package p;\npublic class ParameterType {\n}\n", "p/ReturnType.java", "package p;\npublic class ReturnType {\n}\n", "p/ExceptionType.java", "package p;\npublic class ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\npublic class X {\n\tI<?, ?, ?> i = (p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\ExceptionType.java (at line 2)\n\tpublic class ExceptionType extends Exception {\n\t             ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test400556e() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType, T extends ExceptionType , R extends ReturnType> {\n\tR doit(List<? extends List<P>>[] p) throws T;\n}\n", "p/ParameterType.java", "package p;\npublic class ParameterType {\n}\n", "p/ReturnType.java", "package p;\npublic class ReturnType {\n}\n", "p/ExceptionType.java", "package p;\npublic class ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\npublic class X {\n\tI<?, ?, ?> i = (String p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\ExceptionType.java (at line 2)\n\tpublic class ExceptionType extends Exception {\n\t             ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. ERROR in X.java (at line 3)\n\tI<?, ?, ?> i = (String p) -> { return null; };\n\t                ^^^^^^\nLambda expression's parameter p is expected to be of type List<? extends List<ParameterType>>[]\n----------\n");
    }

    public void test400556f() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType, T extends ExceptionType , R extends ReturnType> {\n\tR doit(List<? extends List<P>>[] p) throws T;\n}\n", "p/ParameterType.java", "package p;\npublic class ParameterType {\n}\n", "p/ReturnType.java", "package p;\npublic class ReturnType {\n}\n", "p/ExceptionType.java", "package p;\npublic class ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\npublic class X {\n\tI<? extends p.ParameterType, ? extends p.ExceptionType, ? extends p.ReturnType> i = (String p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\ExceptionType.java (at line 2)\n\tpublic class ExceptionType extends Exception {\n\t             ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. ERROR in X.java (at line 3)\n\tI<? extends p.ParameterType, ? extends p.ExceptionType, ? extends p.ReturnType> i = (String p) -> { return null; };\n\t                                                                                     ^^^^^^\nLambda expression's parameter p is expected to be of type List<? extends List<ParameterType>>[]\n----------\n");
    }

    public void test400556g() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType, T extends ExceptionType , R extends ReturnType> {\n\tR doit(List<? extends List<P>>[] p) throws T;\n}\n", "p/ParameterType.java", "package p;\npublic class ParameterType {\n}\n", "p/ReturnType.java", "package p;\npublic class ReturnType {\n}\n", "p/ExceptionType.java", "package p;\npublic class ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\nclass P extends p.ParameterType {}\nclass T extends p.ExceptionType {}\nclass R extends p.ReturnType {}\npublic class X {\n\tI<P, T, R> i = (String p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\ExceptionType.java (at line 2)\n\tpublic class ExceptionType extends Exception {\n\t             ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in X.java (at line 3)\n\tclass T extends p.ExceptionType {}\n\t      ^\nThe serializable class T does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 6)\n\tI<P, T, R> i = (String p) -> { return null; };\n\t                ^^^^^^\nLambda expression's parameter p is expected to be of type List<? extends List<P>>[]\n----------\n");
    }

    public void test400556h() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType, T extends ExceptionType , R extends ReturnType> {\n\tR doit(List<? extends List<P>>[] p) throws T;\n}\n", "p/ParameterType.java", "package p;\npublic class ParameterType {\n}\n", "p/ReturnType.java", "package p;\npublic class ReturnType {\n}\n", "p/ExceptionType.java", "package p;\npublic class ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\nclass P extends p.ParameterType {}\nclass T extends p.ExceptionType {}\nclass R extends p.ReturnType {}\npublic class X {\n\tI<T, R, P> i = (String p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\ExceptionType.java (at line 2)\n\tpublic class ExceptionType extends Exception {\n\t             ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in X.java (at line 3)\n\tclass T extends p.ExceptionType {}\n\t      ^\nThe serializable class T does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 6)\n\tI<T, R, P> i = (String p) -> { return null; };\n\t  ^\nBound mismatch: The type T is not a valid substitute for the bounded parameter <P extends ParameterType> of the type I<P,T,R>\n----------\n3. ERROR in X.java (at line 6)\n\tI<T, R, P> i = (String p) -> { return null; };\n\t     ^\nBound mismatch: The type R is not a valid substitute for the bounded parameter <T extends ExceptionType> of the type I<P,T,R>\n----------\n4. ERROR in X.java (at line 6)\n\tI<T, R, P> i = (String p) -> { return null; };\n\t        ^\nBound mismatch: The type P is not a valid substitute for the bounded parameter <R extends ReturnType> of the type I<P,T,R>\n----------\n5. ERROR in X.java (at line 6)\n\tI<T, R, P> i = (String p) -> { return null; };\n\t               ^^^^^^^^^^^^^\nThe target type of this expression is not a well formed parameterized type due to bound(s) mismatch\n----------\n");
    }

    public void test400556i() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType, T extends ExceptionType , R extends ReturnType> {\n\tR doit(List<? extends List<P>>[] p) throws T;\n}\n", "p/ParameterType.java", "package p;\npublic class ParameterType {\n}\n", "p/ReturnType.java", "package p;\npublic class ReturnType {\n}\n", "p/ExceptionType.java", "package p;\npublic class ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\nclass P extends p.ParameterType {}\nclass T extends p.ExceptionType {}\nclass R extends p.ReturnType {}\npublic class X {\n\tI<? super P, ? super T, ? super R> i = (String p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\ExceptionType.java (at line 2)\n\tpublic class ExceptionType extends Exception {\n\t             ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in X.java (at line 3)\n\tclass T extends p.ExceptionType {}\n\t      ^\nThe serializable class T does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 6)\n\tI<? super P, ? super T, ? super R> i = (String p) -> { return null; };\n\t                                        ^^^^^^\nLambda expression's parameter p is expected to be of type List<? extends List<P>>[]\n----------\n");
    }

    public void test400556j() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType, T extends P , R extends T> {\n\tR doit(List<? extends List<P>>[] p) throws T;\n}\n", "p/ParameterType.java", "package p;\npublic class ParameterType {\n}\n", "p/ReturnType.java", "package p;\npublic class ReturnType {\n}\n", "p/ExceptionType.java", "package p;\npublic class ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\nclass P extends p.ParameterType {}\nclass T extends p.ExceptionType {}\nclass R extends p.ReturnType {}\npublic class X {\n\tI<?, ?, ?> i = (String p) -> { return null; };\n}\n"}, "----------\n1. ERROR in p\\I.java (at line 4)\n\tR doit(List<? extends List<P>>[] p) throws T;\n\t                                           ^\nNo exception of type T can be thrown; an exception type must be a subclass of Throwable\n----------\n----------\n1. WARNING in p\\ExceptionType.java (at line 2)\n\tpublic class ExceptionType extends Exception {\n\t             ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in X.java (at line 3)\n\tclass T extends p.ExceptionType {}\n\t      ^\nThe serializable class T does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 6)\n\tI<?, ?, ?> i = (String p) -> { return null; };\n\t               ^^^^^^^^^^^^^\nThe target type of this expression is not a well formed parameterized type due to bound(s) mismatch\n----------\n");
    }

    public void test400556k() {
        this.runNegativeTest(new String[]{"p/I.java", "package p;\nimport java.util.List;\npublic interface I<P extends ParameterType, T extends ExceptionType , R extends ReturnType> {\n\tR doit(List<? extends List<P>>[] p) throws T;\n}\n", "p/ParameterType.java", "package p;\npublic class ParameterType {\n}\n", "p/ReturnType.java", "package p;\npublic class ReturnType {\n}\n", "p/ExceptionType.java", "package p;\npublic class ExceptionType extends Exception {\n}\n", "X.java", "import p.I;\npublic class X {\n\tI i = (String p) -> { return null; };\n}\n"}, "----------\n1. WARNING in p\\ExceptionType.java (at line 2)\n\tpublic class ExceptionType extends Exception {\n\t             ^^^^^^^^^^^^^\nThe serializable class ExceptionType does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in X.java (at line 3)\n\tI i = (String p) -> { return null; };\n\t^\nI is a raw type. References to generic type I<P,T,R> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tI i = (String p) -> { return null; };\n\t       ^^^^^^\nLambda expression's parameter p is expected to be of type List[]\n----------\n");
    }

    public void test384750() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void zoo(int x, String p);\n}\npublic class X {\n\tint x = 0;\n\tI i = x::zoo;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = x::zoo;\n\t      ^\nCannot invoke zoo(int, String) on the primitive type int\n----------\n");
    }

    public void test384750a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void zoo(int x, String p);\n}\npublic class X {\n\tint x = 0;\n\tI i = I::new;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = I::new;\n\t      ^\nCannot instantiate the type I\n----------\n");
    }

    public void test384750b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void zoo(int x, String p);\n}\nabstract public class X {\n\tint x = 0;\n\tI i = X::new;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = X::new;\n\t      ^\nCannot instantiate the type X\n----------\n");
    }

    public void test384750c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void zoo(int x, String p);\n}\nabstract public class X {\n\tint x = 0;\n\tI i = E::new;\n}\nenum E {}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = E::new;\n\t      ^\nCannot instantiate the type E\n----------\n");
    }

    public void test384750d() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  X<?> zoo(int x, String p);\n}\npublic class X<T> {\n\tX(int x, String p) {}\n\tI i = X<? extends String>::new;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = X<? extends String>::new;\n\t      ^^^^^^^^^^^^^^^^^^^\nCannot instantiate the type X<? extends String>\n----------\n");
    }

    public void test384750e() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  X<?> zoo(int x, String p);\n}\npublic class X<T> {\n\tX(int x, String p) {}\n\tI i = T::new;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = T::new;\n\t      ^\nCannot instantiate the type T\n----------\n");
    }

    public void test384750f() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  X<?> zoo(int x, String p);\n}\npublic class X<T> {\n\tX(int x, String p) {}\n\tI i = Annot::new;\n}\n@interface Annot {}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = Annot::new;\n\t      ^^^^^\nCannot instantiate the type Annot\n----------\n");
    }

    public void test384750g() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  X<?> zoo(int x, String p);\n}\npublic class X<T> {\n\tX(int x, String p) {}\n   static {\n\t    I i = this::foo;\n   }\n   X<?> foo(int x, String p) { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = this::foo;\n\t      ^^^^\nCannot use this in a static context\n----------\n");
    }

    public void test384750h() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  X<?> zoo(int x, String p);\n}\npublic class X<T> {\n\tX(int x, String p) {}\n\tI i = this::foo;\n   X<?> foo(int x, String p) { return null; }\n}\n"}, "");
    }

    public void test384750i() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  X<?> zoo(int x, String p);\n}\npublic class X<T> extends Y {\n   static {\n\t    I i = super::foo;\n   }\n}\nclass Y {\n    X<?> foo(int x, String p) { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = super::foo;\n\t      ^^^^^\nCannot use super in a static context\n----------\n");
    }

    public void test384750j() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  X<?> zoo(int x, String p);\n}\npublic class X<T> extends Y {\n\tI i = super::foo;\n}\nclass Y {\n    X<?> foo(int x, String p) { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tI i = super::foo;\n\t      ^^^^^^^^^^\nAccess to enclosing method foo(int, String) from the type Y is emulated by a synthetic accessor method\n----------\n");
    }

    public void test384750k() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void zoo();\n}\nclass Z {\n\tvoid zoo() {}\n}\nclass X extends Z {\n    static class N {\n    \tI i = X.super::zoo;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i = X.super::zoo;\n\t      ^^^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n");
    }

    public void test384750l() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void zoo();\n}\nclass Z {\n\tvoid zoo() {}\n}\nclass X extends Z {\n    class N {\n    \tI i = X.super::zoo;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tI i = X.super::zoo;\n\t      ^^^^^^^^^^^^\nAccess to enclosing method zoo() from the type Z is emulated by a synthetic accessor method\n----------\n");
    }

    public void test384750m() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\ninterface I {\n\tList<String> doit();\n}\ninterface J {\n\tint size(ArrayList<String> als);\n}\nclass X {\n   I i1 = ArrayList::new;\n   I i2 = ArrayList<String>::new;\n   I i3 = ArrayList<Integer>::new;\n   I i4 = List<String>::new;\n   J j1 = String::length;\n   J j2 = List::size;\n   J j3 = List<String>::size;\n   J j4 = List<Integer>::size;\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tI i3 = ArrayList<Integer>::new;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nThe constructed object of type ArrayList<Integer> is incompatible with the descriptor's return type: List<String>\n----------\n2. ERROR in X.java (at line 13)\n\tI i4 = List<String>::new;\n\t       ^^^^^^^^^^^^\nCannot instantiate the type List<String>\n----------\n3. ERROR in X.java (at line 14)\n\tJ j1 = String::length;\n\t       ^^^^^^^^^^^^^^\nThe type String does not define length(ArrayList<String>) that is applicable here\n----------\n4. ERROR in X.java (at line 17)\n\tJ j4 = List<Integer>::size;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe type List<Integer> does not define size(ArrayList<String>) that is applicable here\n----------\n");
    }

    public void test384750n() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\ninterface I {\n\tList<String> doit();\n}\npublic class X {\n   I i1 = ArrayList<String>[]::new;\n   I i2 = List<String>[]::new;\n   I i3 = ArrayList<String>::new;\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i1 = ArrayList<String>[]::new;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nCannot create a generic array of ArrayList<String>\n----------\n2. ERROR in X.java (at line 8)\n\tI i2 = List<String>[]::new;\n\t       ^^^^^^^^^^^^^^^^^^^\nCannot create a generic array of List<String>\n----------\n");
    }

    public void test384750o() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\ninterface I {\n\tList<String> [] doit();\n}\ninterface J {\n\tList<String> [] doit(long l);\n}\ninterface K {\n\tList<String> [] doit(String s, long l);\n}\ninterface L {\n\tList<String> [] doit(short s);\n}\ninterface M {\n\tList<String> [] doit(byte b);\n}\ninterface N {\n\tList<String> [] doit(int i);\n}\ninterface O {\n\tList<String> [] doit(Integer i);\n}\ninterface P {\n\tList<String> [] doit(Short i);\n}\ninterface Q {\n\tList<String> [] doit(Float i);\n}\ninterface R {\n\tList<String> [] doit(int i);\n}\npublic class X {\n   I i = List[]::new;\n   J j = ArrayList[]::new;\n   K k = ArrayList[]::new;\n   L l = ArrayList[]::new;\n   M m = ArrayList[]::new;\n   N n = ArrayList[]::new;\n   O o = ArrayList[]::new;\n   P p = ArrayList[]::new;\n   Q q = ArrayList[]::new;\n   R r = ArrayList[][][]::new;\n}\n"}, "----------\n1. ERROR in X.java (at line 34)\n\tI i = List[]::new;\n\t      ^^^^^^^^^^^\nIncompatible parameter list for array constructor. Expected (int), but found ()\n----------\n2. ERROR in X.java (at line 35)\n\tJ j = ArrayList[]::new;\n\t      ^^^^^^^^^^^^^^^^\nIncompatible parameter list for array constructor. Expected (int), but found (long)\n----------\n3. ERROR in X.java (at line 36)\n\tK k = ArrayList[]::new;\n\t      ^^^^^^^^^^^^^^^^\nIncompatible parameter list for array constructor. Expected (int), but found (String, long)\n----------\n4. ERROR in X.java (at line 42)\n\tQ q = ArrayList[]::new;\n\t      ^^^^^^^^^^^^^^^^\nIncompatible parameter list for array constructor. Expected (int), but found (Float)\n----------\n5. ERROR in X.java (at line 43)\n\tR r = ArrayList[][][]::new;\n\t      ^^^^^^^^^^^^^^^^^^^^\nConstructed array ArrayList[][][] cannot be assigned to List<String>[] as required in the interface descriptor  \n----------\n");
    }

    public void test384750p() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tList<String> doit();\n}\nclass X<T> {\n\tstatic void foo() {}\n\t{\n\t\tX<String> x = new X<String>();\n\t\tI i1 = x::foo;\n\t\tI i2 = X<String>::foo;\n\t\tI i3 = X::foo;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i1 = x::foo;\n\t       ^^^^^^\nThe method foo() from the type X<String> should be accessed in a static way \n----------\n2. ERROR in X.java (at line 10)\n\tI i2 = X<String>::foo;\n\t       ^^^^^^^^^^^^^^\nThe method foo() from the type X<String> should be accessed in a static way \n----------\n3. ERROR in X.java (at line 11)\n\tI i3 = X::foo;\n\t       ^^^^^^\nThe type of foo() from the type X is void, this is incompatible with the descriptor's return type: List<String>\n----------\n");
    }

    public void test384750q() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tList<String> doit();\n}\nclass X<T> {\n\tvoid foo() {}\n\t{\n\t\tX<String> x = new X<String>();\n\t\tI i1 = x::foo;\n\t\tI i2 = X<String>::foo;\n\t\tI i3 = X::foo;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i1 = x::foo;\n\t       ^^^^^^\nThe type of foo() from the type X<String> is void, this is incompatible with the descriptor's return type: List<String>\n----------\n2. ERROR in X.java (at line 10)\n\tI i2 = X<String>::foo;\n\t       ^^^^^^^^^^^^^^\nCannot make a static reference to the non-static method foo() from the type X<String>\n----------\n3. ERROR in X.java (at line 11)\n\tI i3 = X::foo;\n\t       ^^^^^^\nCannot make a static reference to the non-static method foo() from the type X\n----------\n");
    }

    public void test384750r() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tList<String> doit(X<String> xs);\n}\nclass X<T> {\n\tvoid foo() {}\n\t{\n\t\tX<String> x = new X<String>();\n\t\tI i1 = X::foo;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i1 = X::foo;\n\t       ^^^^^^\nThe type of foo() from the type X<String> is void, this is incompatible with the descriptor's return type: List<String>\n----------\n");
    }

    public void test384750s() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tList<String> doit(X<String> xs);\n}\nclass X<T> {\n\tvoid foo() {}\n\t{\n\t\tX<String> x = new X<String>();\n\t\tI i1 = X<String>::foo;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i1 = X<String>::foo;\n\t       ^^^^^^^^^^^^^^\nThe type of foo() from the type X<String> is void, this is incompatible with the descriptor's return type: List<String>\n----------\n");
    }

    public void test384750t() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tList<String> doit(X<String> xs);\n}\nclass X<T> {\n\tstatic List<String> foo() {}\n\t{\n\t\tX<String> x = new X<String>();\n\t\tI i1 = X<String>::foo;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i1 = X<String>::foo;\n\t       ^^^^^^^^^^^^^^\nThe method foo() from the type X<String> should be accessed in a static way \n----------\n");
    }

    public void test384750u() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tList<String> doit(X<String> xs, int x);\n}\nclass X<T> {\n\tstatic List<String> foo() {}\n\t{\n\t\tX<String> x = new X<String>();\n\t\tI i1 = X::foo;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i1 = X::foo;\n\t       ^^^^^^\nThe type X does not define foo(X<String>, int) that is applicable here\n----------\n");
    }

    public void test384750v() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tList<String> doit(X<String> xs, int x);\n}\nclass X<T> {\n\tstatic List<String> foo(X<String> xs, int x) {}\n\tList<String> foo(int x) {}\n\t{\n\t\tX<String> x = new X<String>();\n\t\tI i1 = X::foo;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i1 = X::foo;\n\t       ^^^^^^\nAmbiguous method reference: both foo(int) and foo(X<String>, int) from the type X<String> are eligible\n----------\n");
    }

    public void test384750w() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tX<String> doit(int x);\n}\ninterface J {\n\tX<String> doit(int x, int p);\n}\ninterface K {\n\tX<String> doit(int x);\n   void goo();\n}\ninterface L {\n\tX<String> doit(short x);\n}\ninterface M {\n\tX<String> doit(String s);\n}\nclass X<T> {\n\tX(int x, int y) {}\n\tX(int x) {}\n\t{\n\t\tI i = X::new;\n       J j = X<Integer>::new;\n       K k = X::new;\n       L l = X<String>::new;\n       M m = X<String>::new;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 23)\n\tJ j = X<Integer>::new;\n\t      ^^^^^^^^^^^^^^^\nThe constructed object of type X<Integer> is incompatible with the descriptor's return type: X<String>\n----------\n2. ERROR in X.java (at line 24)\n\tK k = X::new;\n\t      ^^^^^^\nThe target type of this expression must be a functional interface\n----------\n3. ERROR in X.java (at line 26)\n\tM m = X<String>::new;\n\t      ^^^^^^^^^^^^^^\nThe type X<String> does not define X(String) that is applicable here\n----------\n");
    }

    public void test384750x() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.io.IOException;\nimport java.io.FileNotFoundException;\ninterface I {\n\tX<String> doit(int x);\n}\ninterface J {\n\tX<String> doit(int x) throws IOException;\n}\ninterface K {\n\tX<String> doit(int x) throws FileNotFoundException;\n}\ninterface L {\n\tX<String> doit(short x) throws Exception;\n}\nclass X<T> {\n\tX(int x) throws IOException, FileNotFoundException {}\n\t{\n\t\tI i = X::new;\n       J j = X<Integer>::new;\n       K k = X::new;\n       L l = X<String>::new;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 19)\n\tI i = X::new;\n\t      ^^^^^^\nUnhandled exception type IOException\n----------\n2. ERROR in X.java (at line 19)\n\tI i = X::new;\n\t      ^^^^^^\nUnhandled exception type FileNotFoundException\n----------\n3. ERROR in X.java (at line 20)\n\tJ j = X<Integer>::new;\n\t      ^^^^^^^^^^^^^^^\nThe constructed object of type X<Integer> is incompatible with the descriptor's return type: X<String>\n----------\n4. ERROR in X.java (at line 21)\n\tK k = X::new;\n\t      ^^^^^^\nUnhandled exception type IOException\n----------\n");
    }

    public void test384750y() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tvoid doit();\n}\nabstract class Y {\n    abstract void foo();\n}\nclass X extends Y {\n\tvoid foo() {}\n   I i = super::foo;\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i = super::foo;\n\t      ^^^^^^^^^^\nCannot directly invoke the abstract method foo() for the type Y\n----------\n");
    }

    public void test384750z() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "warning");
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\nclass Y {\n    static void foo() {}\n}\nclass X extends Y {\n   I i = X::foo;\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tI i = X::foo;\n\t      ^^^^^^\nThe static method foo() from the type Y should be accessed directly \n----------\n", null, false, customOptions);
    }

    public void test384750z1() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\nclass X extends Y {\n   I i = X::foo;\n}\n", "Y.java", "@Deprecated class Y {\n    @Deprecated static void foo() {}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tclass X extends Y {\n\t                ^\nThe type Y is deprecated\n----------\n2. WARNING in X.java (at line 5)\n\tI i = X::foo;\n\t      ^^^^^^\nThe method foo() from the type Y is deprecated\n----------\n", null, false, customOptions);
    }

    public void test384750z2() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", "warning");
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\nclass X extends Y {\n   I i = X::<String>foo;\n}\n", "Y.java", "@Deprecated class Y {\n    @Deprecated static void foo() {}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tclass X extends Y {\n\t                ^\nThe type Y is deprecated\n----------\n2. WARNING in X.java (at line 5)\n\tI i = X::<String>foo;\n\t      ^^^^^^^^^^^^^^\nThe method foo() from the type Y is deprecated\n----------\n3. WARNING in X.java (at line 5)\n\tI i = X::<String>foo;\n\t          ^^^^^^\nUnused type arguments for the non generic method foo() of type Y; it should not be parameterized with arguments <String>\n----------\n", null, false, customOptions);
    }

    public void test384750z3() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\nclass X {\n   String foo() { return null; }\n   I i = new X()::foo;\n}\n"}, "");
    }

    public void test384750z4() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tList<String> doit();\n}\nclass X {\n   void foo() { return; }\n   I i = new X()::foo;\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = new X()::foo;\n\t      ^^^^^^^^^^^^\nThe type of foo() from the type X is void, this is incompatible with the descriptor's return type: List<String>\n----------\n");
    }

    public void test384750z5() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\ninterface I {\n\tList<String> doit();\n}\nclass X {\n   ArrayList<Integer> foo() { return null; }\n   I i = new X()::foo;\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tI i = new X()::foo;\n\t      ^^^^^^^^^^^^\nThe type of foo() from the type X is ArrayList<Integer>, this is incompatible with the descriptor's return type: List<String>\n----------\n");
    }

    public void test384750z6() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\ninterface I {\n\tList<String> doit(X<String> x, int y);\n}\nclass X<T> {\n   ArrayList<String> foo(int x) { return null; }\n   I i = X::foo;\n}\n"}, "");
    }

    public void test384750z7() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\ninterface I {\n\tList<String> doit(X x, int y);\n}\nclass X<T> {\n   ArrayList<Integer> foo(int x) { return null; }\n   I i = X::foo;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tList<String> doit(X x, int y);\n\t                  ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test384750z8() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint [] doit(int [] ia);\n}\nclass X<T> {\n   I i = int []::clone;\n}\n"}, "");
    }

    public void test384750z9() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint [] doit(X x);\n}\npublic class X {\n\tZork foo() {\n\t}\n   I i = X::foo;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork foo() {\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\tI i = X::foo;\n\t      ^^^^^^\nThe method foo() from the type X refers to the missing type Zork\n----------\n3. ERROR in X.java (at line 7)\n\tI i = X::foo;\n\t      ^^^^^^\nThe type of foo() from the type X is Zork, this is incompatible with the descriptor's return type: int[]\n----------\n");
    }

    public void test401610() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    void foo();\n}\npublic class X {\n\tvoid foo(I i) {\n\t\tSystem.out.println(\"foo\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(()->{});\n\t}\n}\n"}, "foo");
    }

    public void test401610a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    void foo();\n}\ninterface J {\n    void foo(int x, int y);\n}\ninterface K {\n    void foo(String s);\n}\npublic class X {\n\tvoid foo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tvoid foo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tvoid foo(K k) {\n\t\tSystem.out.println(\"foo(K)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(()->{});\n\t\tnew X().foo((x, y)->{});\n\t\tnew X().foo((s)->{});\n\t}\n}\n"}, "foo(I)\nfoo(J)\nfoo(K)");
    }

    public void test401610b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    void foo();\n}\ninterface J {\n    void foo(int x, int y);\n}\ninterface K {\n    void foo(String s);\n}\npublic class X {\n\tvoid foo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tvoid foo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(()->{});\n\t\tnew X().foo((x, y)->{});\n\t\tnew X().foo((s)->{});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 20)\n\tnew X().foo((s)->{});\n\t        ^^^\nThe method foo(I) in the type X is not applicable for the arguments ((<no type> s) -> {})\n----------\n2. ERROR in X.java (at line 20)\n\tnew X().foo((s)->{});\n\t            ^^^^^\nLambda expression's signature does not match the signature of the functional interface method foo()\n----------\n");
    }

    public void test401610c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    void foo();\n}\ninterface K {\n    String foo(String s);\n}\npublic class X {\n\tvoid foo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tvoid foo(K k) {\n\t\tSystem.out.println(\"foo(K)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(()->{ return \"\";});\n\t\tnew X().foo(()-> 10);\n\t\tnew X().foo((s)->{});\n\t\tnew X().foo((s)->{ return;});\n\t\tnew X().foo((s)->{ return \"\";});\n\t\tnew X().foo((s)-> \"hello\");\n\t\tnew X().foo(()->{ return;});\n\t\tnew X().foo(()-> System.out.println());\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 15)\n\tnew X().foo(()->{ return \"\";});\n\t        ^^^\nThe method foo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n2. ERROR in X.java (at line 15)\n\tnew X().foo(()->{ return \"\";});\n\t                  ^^^^^^^^^^\nVoid methods cannot return a value\n----------\n3. ERROR in X.java (at line 16)\n\tnew X().foo(()-> 10);\n\t        ^^^\nThe method foo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n4. ERROR in X.java (at line 16)\n\tnew X().foo(()-> 10);\n\t                 ^^\nVoid methods cannot return a value\n----------\n5. ERROR in X.java (at line 18)\n\tnew X().foo((s)->{ return;});\n\t                   ^^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test401610d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    <T> T id(T arg) { return arg; }\n    Runnable r = id(() -> { System.out.println(); });\n}\n"}, "");
    }

    public void test401610e() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T extends String> {\n\tvoid foo();\n}\npublic class X {\n\t<T> T foo(I<T> it) { return null; }\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(()->{});\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tinterface I<T extends String> {\n\t                      ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 5)\n\t<T> T foo(I<T> it) { return null; }\n\t            ^\nBound mismatch: The type T is not a valid substitute for the bounded parameter <T extends String> of the type I<T>\n----------\n3. ERROR in X.java (at line 7)\n\tnew X().foo(()->{});\n\t            ^^^^\nThe target type of this expression is not a well formed parameterized type due to bound(s) mismatch\n----------\n");
    }

    public void test401610ee() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T extends String> {\n\tvoid foo();\n}\npublic class X {\n\t<T extends String> T foo(I<T> it) { return null; }\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(()->{});\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tinterface I<T extends String> {\n\t                      ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. WARNING in X.java (at line 5)\n\t<T extends String> T foo(I<T> it) { return null; }\n\t           ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n");
    }

    public void test401610f() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T> {\n\tvoid foo();\n}\npublic class X {\n\t<T> T foo(I<T> it) { return null; }\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(()->{});\n\t}\n}\n"}, "");
    }

    public void test401610g() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J { \n    String foo();\n}\npublic class X {\n\tvoid foo(I it) { System.out.println(\"foo(I)\");}\n\tvoid foo(J it) { System.out.println(\"foo(J)\");}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(()->{});\n\t}\n}\n"}, "foo(I)");
    }

    public void test401610h() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J { \n    String foo();\n}\npublic class X {\n\tvoid foo(I it) { System.out.println(\"foo(I)\");}\n\tvoid foo(J it) { System.out.println(\"foo(J)\");}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(()->{ return 10; });\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tnew X().foo(()->{ return 10; });\n\t        ^^^\nThe method foo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n2. ERROR in X.java (at line 11)\n\tnew X().foo(()->{ return 10; });\n\t                  ^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test401610i() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J { \n    void foo(String s);\n}\npublic class X {\n\tvoid foo(I it) { System.out.println(\"foo(I)\");}\n\tvoid foo(J it) { System.out.println(\"foo(J)\");}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo((String s)->{});\n\t}\n}\n"}, "foo(J)");
    }

    public void test401610j() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J { \n    void foo(String s);\n}\npublic class X {\n\tvoid foo(I it) { System.out.println(\"foo(I)\");}\n\tvoid foo(J it) { System.out.println(\"foo(J)\");}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo((Object o)->{});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tnew X().foo((Object o)->{});\n\t        ^^^\nThe method foo(I) in the type X is not applicable for the arguments ((Object o) -> {})\n----------\n2. ERROR in X.java (at line 11)\n\tnew X().foo((Object o)->{});\n\t             ^^^^^^\nLambda expression's parameter o is expected to be of type int\n----------\n");
    }

    public void test401789_401790() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tInteger foo(X x);\n}\npublic class X {\n\tint foo(I i) { return 10;}\n\tclass Y {\n\t\tY (I i) {}\n\t\tY() {\n\t\t\tthis(X::goo);\n\t\t}\n\t}\n\tX(I i) {}\n\tX() {\n\t\tthis((x) -> { return 10;});\n\t}\n\tint goo() { return 0;}\n\t{\n\t\tfoo(X::goo);\n\t\tnew X((x)->{ return 10;});\n\t\tnew X((x)->{ return 10;}).new Y((x) -> { return 0;});\n\t\tnew X((x)->{ return 10;}) {};\n\t}\n}\nclass Z extends X {\n\tZ() {\n\t\tsuper(X::goo);\n\t}\n\tZ(int i) {\n\t\tsuper (x -> 10);\n\t}\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 31)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test401789_401790a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(X x);\n}\npublic class X {\n\tint foo(I i) { return 10;}\n\tclass Y {\n\t\tY (I i) {}\n\t\tY() {\n\t\t\tthis(X::goo);\n\t\t}\n\t}\n\tX(I i) {}\n\tX() {\n\t\tthis((x) -> { return 10;});\n\t}\n\tint goo() { return 0;}\n\t{\n\t\tfoo(X::goo);\n\t\tnew X((x)->{ return 10;});\n\t\tnew X((x)->{ return 10;}).new Y((x) -> { return 0;});\n\t\tnew X((x)->{ return 10;}) {};\n\t}\n}\nclass Z extends X {\n\tZ() {\n\t\tsuper(X::goo);\n\t}\n\tZ(int i) {\n\t\tsuper (x -> 10);\n\t}\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tthis(X::goo);\n\t^^^^^^^^^^^^^\nThe constructor X.Y(X::goo) is undefined\n----------\n2. ERROR in X.java (at line 9)\n\tthis(X::goo);\n\t     ^^^^^^\nThe type of goo() from the type X is int, this is incompatible with the descriptor's return type: String\n----------\n3. ERROR in X.java (at line 14)\n\tthis((x) -> { return 10;});\n\t                     ^^\nType mismatch: cannot convert from int to String\n----------\n4. ERROR in X.java (at line 18)\n\tfoo(X::goo);\n\t^^^\nThe method foo(I) in the type X is not applicable for the arguments (X::goo)\n----------\n5. ERROR in X.java (at line 18)\n\tfoo(X::goo);\n\t    ^^^^^^\nThe type of goo() from the type X is int, this is incompatible with the descriptor's return type: String\n----------\n6. ERROR in X.java (at line 19)\n\tnew X((x)->{ return 10;});\n\t                    ^^\nType mismatch: cannot convert from int to String\n----------\n7. ERROR in X.java (at line 20)\n\tnew X((x)->{ return 10;}).new Y((x) -> { return 0;});\n\t                    ^^\nType mismatch: cannot convert from int to String\n----------\n8. ERROR in X.java (at line 20)\n\tnew X((x)->{ return 10;}).new Y((x) -> { return 0;});\n\t                                                ^\nType mismatch: cannot convert from int to String\n----------\n9. ERROR in X.java (at line 21)\n\tnew X((x)->{ return 10;}) {};\n\t                    ^^\nType mismatch: cannot convert from int to String\n----------\n10. ERROR in X.java (at line 26)\n\tsuper(X::goo);\n\t^^^^^^^^^^^^^^\nThe constructor X(X::goo) is undefined\n----------\n11. ERROR in X.java (at line 26)\n\tsuper(X::goo);\n\t      ^^^^^^\nThe type of goo() from the type X is int, this is incompatible with the descriptor's return type: String\n----------\n12. ERROR in X.java (at line 29)\n\tsuper (x -> 10);\n\t            ^^\nType mismatch: cannot convert from int to String\n----------\n13. ERROR in X.java (at line 31)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test401845() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tInteger foo(X x);\n}\npublic class X extends Zork {\n\tint foo(I ...i) { return 10;}\n\tint goo() { return 0;}\n\t{\n\t\tfoo(X::goo);\n\t\tfoo((x)-> {return 10;});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X extends Zork {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test401845a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tInteger foo(X x);\n}\npublic class X {\n\tint foo(I [] ...i) { return 10;}\n\tint goo() { return 0;}\n\t{\n\t\tfoo(X::goo);\n\t\tfoo((x)-> {return 10;});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tfoo(X::goo);\n\t^^^\nThe method foo(I[]...) in the type X is not applicable for the arguments (X::goo)\n----------\n2. ERROR in X.java (at line 8)\n\tfoo(X::goo);\n\t    ^^^^^^\nThe target type of this expression must be a functional interface\n----------\n3. ERROR in X.java (at line 9)\n\tfoo((x)-> {return 10;});\n\t^^^\nThe method foo(I[]...) in the type X is not applicable for the arguments ((<no type> x) -> {})\n----------\n4. ERROR in X.java (at line 9)\n\tfoo((x)-> {return 10;});\n\t    ^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test401845b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tInteger foo(X x);\n}\npublic class X extends Zork {\n\tX(I ...i) {}\n\tint goo() { return 0;}\n\t{\n\t\tnew X(X::goo);\n\t\tnew X((x)-> {return 10;});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X extends Zork {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test401845c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tInteger foo(X x);\n}\npublic class X extends Zork {\n\tX(I ...i) {}\n   X() {\n       this((x)-> {return 10;});\n}\n\tint goo() { return 0;}\n\t{\n\t\tnew X(X::goo);\n\t\tnew X((x)-> {return 10;});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X extends Zork {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test401845d() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tInteger foo(X x);\n}\npublic class X extends Zork {\n    class Y {\n        Y(I ... i) {}\n    }\n\tint goo() { return 0;}\n\t{\n\t\tnew X().new Y(X::goo);\n\t\tnew X().new Y((x)-> {return 10;});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X extends Zork {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test401845e() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tInteger foo(X x);\n}\npublic class X extends Zork {\n\tX(I ...i) {}\n   X() {\n       this((x)-> {return 10;});\n}\n\tint goo() { return 0;}\n\t{\n\t\tnew X(X::goo) {};\n\t\tnew X((x)-> {return 10;}){};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X extends Zork {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test401847() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tInteger foo(X x);\n}\npublic class X {\n\tint foo(I ...i) { return 10;}\n\tint goo() { return 0;}\n\t{\n\t\tfoo(true ? X::goo : X::goo);\n\t\tfoo(true ? x-> 1 : x->0);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tfoo(true ? X::goo : X::goo);\n\t                    ^^^^^^\nDead code\n----------\n2. WARNING in X.java (at line 9)\n\tfoo(true ? x-> 1 : x->0);\n\t                   ^^^^\nDead code\n----------\n");
    }

    public void test401847a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(X x);\n}\npublic class X {\n\tint foo(I ...i) { return 10;}\n\tint goo() { return 0;}\n\t{\n\t\tfoo(true ? X::goo : X::goo);\n\t\tfoo(true ? x-> 1 : x->0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tfoo(true ? X::goo : X::goo);\n\t^^^\nThe method foo(I...) in the type X is not applicable for the arguments ((true ? X::goo : X::goo))\n----------\n2. ERROR in X.java (at line 8)\n\tfoo(true ? X::goo : X::goo);\n\t           ^^^^^^\nThe type of goo() from the type X is int, this is incompatible with the descriptor's return type: String\n----------\n3. ERROR in X.java (at line 8)\n\tfoo(true ? X::goo : X::goo);\n\t                    ^^^^^^\nThe type of goo() from the type X is int, this is incompatible with the descriptor's return type: String\n----------\n4. ERROR in X.java (at line 9)\n\tfoo(true ? x-> 1 : x->0);\n\t               ^\nType mismatch: cannot convert from int to String\n----------\n5. ERROR in X.java (at line 9)\n\tfoo(true ? x-> 1 : x->0);\n\t                      ^\nType mismatch: cannot convert from int to String\n----------\n");
    }

    public void test401939() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\nclass X {\n\tvoid foo(I i) {}\n\tI i = ()->{ throw new RuntimeException(); }; // OK\n\t{\n\t\tfoo(()->{ throw new RuntimeException(); });\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid foo(I i) {}\n\t           ^\nThe parameter i is hiding a field from type X\n----------\n");
    }

    public void test401939a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\nclass X {\n\tvoid foo(I i) {}\n\tI i = ()->{ throw new RuntimeException(); }; // OK\n\t{\n\t\tfoo(()->{ if (1 == 2) throw new RuntimeException(); });\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid foo(I i) {}\n\t           ^\nThe parameter i is hiding a field from type X\n----------\n2. ERROR in X.java (at line 8)\n\tfoo(()->{ if (1 == 2) throw new RuntimeException(); });\n\t^^^\nThe method foo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void test401939b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    String foo(String x) throws Exception;\n}\npublic class X {\n\tstatic final boolean FALSE = false;\n\tstatic final boolean TRUE = true;\n\tvoid goo(I i) {\n\t}\n\tvoid zoo() {\n\t\tfinal boolean NIJAM = true;\n\t\tfinal boolean POI = false;\n       final boolean BLANK;\n       BLANK = true;\n\t\tgoo((x) -> { while (FALSE) throw new Exception(); });\n\t\tgoo((x) -> { while (TRUE) throw new Exception(); });\n\t\tgoo((x) -> { while (NIJAM) throw new Exception(); });\n\t\tgoo((x) -> { while (POI) throw new Exception(); });\n\t\tgoo((x) -> { if (TRUE) throw new Exception(); else throw new Exception(); });\n\t\tgoo((x) -> { if (TRUE) throw new Exception(); });\n\t\tgoo((x) -> { if (true) throw new Exception(); else throw new Exception(); });\n\t\tgoo((x) -> { if (false) throw new Exception(); else throw new Exception(); });\n\t\tgoo((x) -> { while (BLANK) throw new Exception(); });\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tgoo((x) -> { while (FALSE) throw new Exception(); });\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n2. ERROR in X.java (at line 14)\n\tgoo((x) -> { while (FALSE) throw new Exception(); });\n\t                           ^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n3. ERROR in X.java (at line 17)\n\tgoo((x) -> { while (POI) throw new Exception(); });\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n4. ERROR in X.java (at line 17)\n\tgoo((x) -> { while (POI) throw new Exception(); });\n\t                         ^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n5. WARNING in X.java (at line 18)\n\tgoo((x) -> { if (TRUE) throw new Exception(); else throw new Exception(); });\n\t                                                   ^^^^^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n6. ERROR in X.java (at line 19)\n\tgoo((x) -> { if (TRUE) throw new Exception(); });\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n7. WARNING in X.java (at line 20)\n\tgoo((x) -> { if (true) throw new Exception(); else throw new Exception(); });\n\t                                                   ^^^^^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n8. WARNING in X.java (at line 20)\n\tgoo((x) -> { if (true) throw new Exception(); else throw new Exception(); });\n\t                                                   ^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n9. WARNING in X.java (at line 21)\n\tgoo((x) -> { if (false) throw new Exception(); else throw new Exception(); });\n\t                        ^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n10. WARNING in X.java (at line 21)\n\tgoo((x) -> { if (false) throw new Exception(); else throw new Exception(); });\n\t                                                    ^^^^^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n11. ERROR in X.java (at line 22)\n\tgoo((x) -> { while (BLANK) throw new Exception(); });\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test401939c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    String foo(String x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {\n\t}\n\tvoid zoo() {\n\t\tgoo((x) -> { if (x) return null; });\n\t\tgoo((x) -> {});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgoo((x) -> { if (x) return null; });\n\t                 ^\nType mismatch: cannot convert from String to boolean\n----------\n");
    }

    public void test401939ca() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    String foo(String x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {\n\t}\n\tvoid zoo() {\n\t\tgoo((x) -> {});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgoo((x) -> {});\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test401939d() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    String foo(boolean x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {\n\t}\n\tvoid zoo() {\n\t\tgoo((x) -> { if (x) return null; });\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgoo((x) -> { if (x) return null; });\n\t    ^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test401939e() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    void foo(boolean x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {\n\t}\n\tvoid zoo() {\n\t\tgoo((x) -> { return null; });\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tgoo((x) -> { return null; });\n\t             ^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test401939f() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    void foo(boolean x) throws Exception;\n}\npublic class X {\n\tvoid goo(I i) {\n\t}\n\tvoid zoo() {\n\t\tgoo((x) -> { throw new Exception(); });\n\t}\n}\n"}, "");
    }

    public void test402219() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(String s1, String s2);\n}\ninterface J {\n\tX foo(X x1, X x2);\n}\npublic class X { \n\tvoid goo(I i) {}\n\tvoid goo(J j) {}\n    public static void main(String [] args) {\n\t\tnew X().goo((p1, p2) -> p1 = p1 + p2);\n    }\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tnew X().goo((p1, p2) -> p1 = p1 + p2);\n\t        ^^^\nThe method goo(I) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test402219a() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(String s1, String s2);\n}\ninterface J {\n\tX foo(X x1, X x2);\n}\npublic class X { \n\tvoid goo(I i) {/* */}\n\tvoid goo(J j) {/* */}\n    public static void main(String [] args) {\n\t\tnew X().goo((p1, p2) -> {});\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tnew X().goo((p1, p2) -> {});\n\t        ^^^\nThe method goo(I) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 11)\n\tnew X().goo((p1, p2) -> {});\n\t                        ^^\nEmpty block should be documented\n----------\n", null, false, options);
    }

    public void test402219b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(String s1, String s2);\n}\ninterface J {\n\tX foo(X x1, X x2);\n}\npublic class X { \n\tvoid goo(I i) {}\n\tvoid goo(J j) {}\n    public static void main(String [] args) {\n\t\tnew X().goo((p1, p2) -> p1 + p2);\n    }\n    Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tnew X().goo((p1, p2) -> p1 + p2);\n\t        ^^^\nThe method goo(I) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test402259() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tJ foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tvoid foo(I i) {};\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(() -> { return () -> { return}; });\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tnew X().foo(() -> { return () -> { return}; });\n\t                                   ^^^^^^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
    }

    public void test402261() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tJ foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tvoid foo(I i) {};\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(() -> { class local { void foo() { return; }} return () -> { return;}; });\n\t}\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test402261a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tJ foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tvoid foo(I i) {};\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(() -> { J j = () -> { return; }; return () -> { return;}; });\n\t}\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test402261b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tJ foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tvoid foo(I i) {};\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(() -> { J j = new J() { public void foo() { return; } }; return () -> { return;}; });\n\t}\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test402261c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tJ foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tvoid foo(I i) {};\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(() -> { return new J() { public void foo() { return; } }; });\n\t}\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test401769() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tvoid foo();\n}\nclass X {\n\tvoid g(I i) {}\n\tvoid g(J j) {}\n\tint f;\n\t{\n\t\tg(() -> f++);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tg(() -> f++);\n\t^\nThe method g(I) is ambiguous for the type X\n----------\n");
    }

    public void test402609() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tvoid foo();\n}\nabstract class Y {\n\tabstract void foo();\n}\npublic class X extends Y {\n\tvoid f(I i) {}\n\tvoid f(J j) {}\n\t\n\tvoid foo() {\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tf(super::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tf(super::foo);\n\t^\nThe method f(I) in the type X is not applicable for the arguments (super::foo)\n----------\n2. ERROR in X.java (at line 18)\n\tf(super::foo);\n\t  ^^^^^\nCannot use super in a static context\n----------\n");
    }

    public void test402609a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tvoid foo();\n}\nabstract class Y {\n\tabstract void foo();\n}\npublic class X extends Y {\n\tvoid f(I i) {}\n\t\n\tvoid foo() {\n\t}\n\t\n\tpublic void main(String[] args) {\n\t\tf(super::foo);\n       I i = super::foo;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tf(super::foo);\n\t  ^^^^^^^^^^\nCannot directly invoke the abstract method foo() for the type Y\n----------\n2. ERROR in X.java (at line 18)\n\tI i = super::foo;\n\t      ^^^^^^^^^^\nCannot directly invoke the abstract method foo() for the type Y\n----------\n");
    }

    public void test402609b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tvoid foo();\n}\nabstract class Y {\n\tabstract void foo();\n}\npublic class X extends Y {\n\tvoid f(I i) {}\n\tvoid f(J j) {}\n\t\n\tvoid foo() {\n\t}\n\t\n\tpublic void zoo(String[] args) {\n\t\tf(super::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tf(super::foo);\n\t^\nThe method f(I) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 18)\n\tf(super::foo);\n\t  ^^^^^^^^^^\nCannot directly invoke the abstract method foo() for the type Y\n----------\n");
    }

    public void test402609c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tvoid foo();\n}\nabstract class Y {\n\tvoid foo() {}\n}\npublic class X extends Y {\n\tvoid f(I i) {}\n\tvoid f(J j) {}\n\t\n\tvoid foo() {\n\t}\n\t\n\tpublic void main(String[] args) {\n\t\tf(super::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tf(super::foo);\n\t^\nThe method f(I) is ambiguous for the type X\n----------\n");
    }

    public void testSuperReference01() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements I2, I1 {\n\t@Override\n\tpublic void print() {\n\t\tSystem.out.print(\"!\");\t}\n   void test() {\n\t\tdoOutput(I1.super::print); // illegal attempt to skip I2.print()\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().test();\n\t}\n   void doOutput(CanPrint printer) {\n      printer.print();   }\n}\ninterface CanPrint {\n\tvoid print();\n}\ninterface I1 {\n\tdefault void print() {\n\t\tSystem.out.print(\"O\");\n\t}\n}\ninterface I2 extends I1 {\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tdoOutput(I1.super::print); // illegal attempt to skip I2.print()\n\t         ^^^^^^^^\nIllegal reference to super type I1, cannot bypass the more specific direct super type I2\n----------\n");
    }

    public void testSuperReference02() {
        this.runNegativeTest(new String[]{"X.java", "interface I0 {\n\tdefault void print() { System.out.println(\"I0\"); }\n}\n\ninterface IA extends I0 {}\n\ninterface IB extends I0 {\n\t@Override default void print() {\n\t\tSystem.out.println(\"IB\");\n\t}\n}\npublic class X implements IA, IB {\n\t@Override\n\tpublic void print() {\n\t\tSystem.out.print(\"!\");\t}\n   void test() {\n\t\tdoOutput(IA.super::print); // illegal attempt to skip IB.print()\n\t}\n\tpublic static void main(String... args) {\n\t\tnew X().test();\n\t}\n   void doOutput(CanPrint printer) {\n      printer.print();   }\n}\ninterface CanPrint {\n\tvoid print();\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tdoOutput(IA.super::print); // illegal attempt to skip IB.print()\n\t         ^^^^^^^^^^^^^^^\nIllegal reference to super method print() from type I0, cannot bypass the more specific override from type IB\n----------\n");
    }

    public void testSuperReference03() {
        this.runNegativeTest(new String[]{"XY.java", "interface J {\n\tvoid foo(int x);\n}\nclass XX {\n\tpublic  void foo(int x) {}\n}\nclass Y extends XX {\n\tstatic class Z {\n\t\tpublic static void foo(int x) {\n\t\t\tSystem.out.print(x);\n\t\t}\n\t}\n\t\tpublic void foo(int x) {\n\t\t\tSystem.out.print(x);\n\t\t}\n}\n\npublic class XY extends XX {\n\t@SuppressWarnings(\"unused\")\n\tpublic  void bar(String [] args) {\n\t\t Y y = new Y();\n\t\t J jj = y :: foo;\n\t\t J jx = y.super ::  foo;\n\t}\n\tpublic static void main (String [] args) {}\n}"}, "----------\n1. ERROR in XY.java (at line 23)\n\tJ jx = y.super ::  foo;\n\t       ^\ny cannot be resolved to a type\n----------\n");
    }

    public void test406614() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint doit();\n}\npublic class X {\n\tint f;\n\tX(I i) {\n\t}\n\tX() {\n\t\tthis(() -> this.f);\n\t}\n\tX(short s) {\n\t\tthis(() -> this.g());\n\t}\n\tX (int x) {\n\t    this(() -> f);\n\t}\n\tX (long x) {\n\t    this(() -> g());\n\t}\n\tint g() {\n\t\treturn 0;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tthis(() -> this.f);\n\t^^^^^^^^^^^^^^^^^^^\nThe constructor X(() -> {}) is undefined\n----------\n2. ERROR in X.java (at line 9)\n\tthis(() -> this.f);\n\t           ^^^^\nCannot refer to 'this' nor 'super' while explicitly invoking a constructor\n----------\n3. ERROR in X.java (at line 12)\n\tthis(() -> this.g());\n\t^^^^^^^^^^^^^^^^^^^^^\nThe constructor X(() -> {}) is undefined\n----------\n4. ERROR in X.java (at line 12)\n\tthis(() -> this.g());\n\t           ^^^^\nCannot refer to 'this' nor 'super' while explicitly invoking a constructor\n----------\n5. ERROR in X.java (at line 15)\n\tthis(() -> f);\n\t^^^^^^^^^^^^^^\nThe constructor X(() -> {}) is undefined\n----------\n6. ERROR in X.java (at line 15)\n\tthis(() -> f);\n\t           ^\nCannot refer to an instance field f while explicitly invoking a constructor\n----------\n7. ERROR in X.java (at line 18)\n\tthis(() -> g());\n\t           ^\nCannot refer to an instance method while explicitly invoking a constructor\n----------\n");
    }

    public void test406588() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tX.Y.Z makeY(int x);\n}\npublic class X {\n\tclass Y {\n\t\tY(I i) {\n\t\t\t\n\t\t}\n\t\tY() {\n\t\t\tthis(Z::new);\n\t\t}\n\t\tclass Z {\n\t\t\tZ(int x) {\n\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tthis(Z::new);\n\t     ^^^^^^\nNo enclosing instance of the type X.Y is accessible in scope\n----------\n");
    }

    public void test406586() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tX.Y makeY();\n}\npublic class X {\n\tpublic class Y {\n\t}\n\tstatic void foo() {\n\t\tI i = Y::new;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tI i = Y::new;\n\t      ^^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n");
    }

    public void test401989() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid make();\n}\npublic class X {\n\tint val;\n\tprivate I test() {\n\t\treturn () -> System.out.println(val);\n\t}\n\tprivate I testCanBeStatic() {\n\t\treturn () -> System.out.println();\n\t}\n\tpublic void call() { test().make(); testCanBeStatic().make();}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tprivate I testCanBeStatic() {\n\t          ^^^^^^^^^^^^^^^^^\nThe method testCanBeStatic() from the type X can be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test406773() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tvoid foo() {\n\t\tint local = 10;\n\t\tclass Y extends X {\n\t\t\tclass Z extends X {\n\t\t\t\tvoid f() {\n\t\t\t\t\tI i = X::new;\n\t\t\t\t\ti.makeX(123456);\n\t\t\t\t\ti = Y::new;\n\t\t\t\t\ti.makeX(987654);\n\t\t\t\t\ti = Z::new;\n\t\t\t\t\ti.makeX(456789);\n\t\t\t\t}\n\t\t\t\tprivate Z(int z) {\n\t\t\t\t}\n\t\t\t\tZ() {}\n\t\t\t}\n\t\t\tprivate Y(int y) {\n\t\t\t\tSystem.out.println(local);\n\t\t\t}\n\t\t\tprivate Y() {\n\t\t\t}\n\t\t}\n\t\tnew Y().new Z().f();\n\t}\n\tprivate X(int x) {\n\t}\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo() {\n\t     ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n2. WARNING in X.java (at line 10)\n\tI i = X::new;\n\t      ^^^^^^\nAccess to enclosing constructor X(int) is emulated by a synthetic accessor method\n----------\n3. ERROR in X.java (at line 12)\n\ti = Y::new;\n\t    ^^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n", null, true, compilerOptions);
    }

    public void test406859a() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo(int i);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tI i = x::foo;\n\t\ti.foo(3);\n\t}\n\tint foo(int x) {\n\t\treturn x;\n\t}   \n}\n"}, "", null, true, compilerOptions);
    }

    public void test406859b() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit (Y y);\n}\n\nclass Y {\n\tvoid foo() {\n\t\treturn;\n\t}\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = Y::foo; \n\t\tY y = new Y();\n\t\ti.doit(y);\n\t}\n}\n"}, "", null, true, compilerOptions);
    }

    public void test406859c() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit ();\n}\n\nclass Y {\n\tvoid foo() {  \n\t\treturn;\n\t}\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = new Y()::foo;\n\t\ti.doit();\n\t}\n}\n"}, "", null, true, compilerOptions);
    }

    public void test406859d() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "warning");
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n\tvoid foo() {\n\t\treturn;\n\t}\n}", "X.java", "interface I {\n\tvoid doit ();\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = new Y()::foo;\n\t\ti.doit();\n\t}\n}\n"}, "----------\n1. WARNING in Y.java (at line 2)\n\tvoid foo() {\n\t     ^^^^^\nThe method foo() from the type Y can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test410114() throws IOException {
        String source = "interface I {\n    void foo(Y<String> y);\n}\npublic class Y<T> {\n    class Z<K> {\n        Z(Y<String> y) {\n            System.out.println(\"Y<T>.Z<K>:: new\");\n        }\n        void bar() {\n            I i = Y<String>.Z<Integer>::<String> new;\n            i.foo(new Y<String>());\n            i = Y<String>.Z<Integer>:: new;\n            i.foo(new Y<String>());\n            i = Y.Z:: new;\n            i.foo(new Y<String>());\n        }\n    }\n}\n";
        this.runNegativeTest(new String[]{"Y.java", source}, "----------\n1. WARNING in Y.java (at line 10)\n\tI i = Y<String>.Z<Integer>::<String> new;\n\t                             ^^^^^^\nUnused type arguments for the non generic constructor Y<String>.Z<Integer>(Y<String>) of type Y<String>.Z<Integer>; it should not be parameterized with arguments <String>\n----------\n2. WARNING in Y.java (at line 14)\n\ti = Y.Z:: new;\n\t    ^^^^^^^^^\nType safety: The constructor Y.Z(Y) belongs to the raw type Y.Z. References to generic type Y<T>.Z<K> should be parameterized\n----------\n");
    }

    public void test412453() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.AbstractList;\nimport java.util.Comparator;\nimport java.util.Optional;\n\nimport java.util.function.*;\n\nabstract class Y<E> extends AbstractList<E> {\n\tpublic <C extends Comparable<? super C>> Optional<E> minBy(Function<E, C> propertyFun) { return null;} \n}\n\npublic class X {\n\tpublic void foo(Y<Integer> empty) throws Exception {\n\t\tfinal Optional<Integer> min = empty.minBy((a, b) -> a - b);\n\t}\n}\n\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tfinal Optional<Integer> min = empty.minBy((a, b) -> a - b);\n\t                                          ^^^^^^^^^^^^^^^\nLambda expression's signature does not match the signature of the functional interface method apply(Integer)\n----------\n", null, true, null);
    }

    public void test412284a() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\ninterface I { void foo() throws IOException; }\npublic class X {\n void bar() {\n\t I i = () -> {\n\t\t try {\n\t\t\t throw new IOException();\n\t\t } catch (IOException e) {\t\t\t \n\t\t } finally {\n\t\t\t i.foo();\n\t\t }\n\t };\n }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\ti.foo();\n\t^\nThe local variable i may not have been initialized\n----------\n", null, true, null);
    }

    public void test412284b() {
        this.runNegativeTest(new String[]{"X.java", "interface I { void foo();}\nclass X { \n   final int t;\n   X(){\n       I x = () ->  {\n    \t try {\n           t = 3;\n         } catch (Exception e) {\n           t = 4;\n         }\n      };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX(){\n\t^^^\nThe blank final field t may not have been initialized\n----------\n2. ERROR in X.java (at line 7)\n\tt = 3;\n\t^\nThe final field X.t cannot be assigned\n----------\n3. ERROR in X.java (at line 9)\n\tt = 4;\n\t^\nThe final field X.t cannot be assigned\n----------\n", null, true, null);
    }

    public void test412284c() {
        this.runNegativeTest(new String[]{"X.java", "interface I { void foo();}\nclass X { \n   final int t;\n   X(){\n       I x = () ->  {\n    \t try {\n           t += 3;\n         } catch (Exception e) {\n           t += 4;\n         }\n      };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX(){\n\t^^^\nThe blank final field t may not have been initialized\n----------\n2. ERROR in X.java (at line 7)\n\tt += 3;\n\t^\nThe final field X.t cannot be assigned\n----------\n3. ERROR in X.java (at line 9)\n\tt += 4;\n\t^\nThe final field X.t cannot be assigned\n----------\n", null, true, null);
    }

    public void test412650() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString sam();\n}\npublic class X {\n\tstatic String foo(I i) { return \"\"; }\n\tpublic static void main(String[] args) {\n\t\tfoo(() -> foo(X::getInt));\n\t}\n\tstatic Integer getInt() { return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tfoo(() -> foo(X::getInt));\n\t^^^\nThe method foo(I) in the type X is not applicable for the arguments (() -> {})\n----------\n2. ERROR in X.java (at line 7)\n\tfoo(() -> foo(X::getInt));\n\t          ^^^\nThe method foo(I) in the type X is not applicable for the arguments (X::getInt)\n----------\n3. ERROR in X.java (at line 7)\n\tfoo(() -> foo(X::getInt));\n\t              ^^^^^^^^^\nThe type of getInt() from the type X is Integer, this is incompatible with the descriptor's return type: String\n----------\n", null, true, null);
    }

    public void test409544() {
        this.runNegativeTest(new String[]{"Sample.java", "public class Sample{\n\tinterface Int { void setInt(int[] i); }\n\tpublic static void main(String[] args) {\n\t\tint j;\n\t\tInt int1 = (int... i) -> {\n\t\t\t\t\t\t\t\t\t\tj=10;\n\t\t\t\t\t\t\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in Sample.java (at line 6)\n\tj=10;\n\t^\nLocal variable j defined in an enclosing scope must be final or effectively final\n----------\n", null, true, null);
    }

    public void test409544b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    interface Int {\n\tvoid setInt(int[] i);\n    }\n    public static void main(String[] args) {\n\n    int j = 0;\n    Int i = new Int() {\n\t\t@Override\n\t\tpublic void setInt(int[] i) {\n\t\t\tj = 10;\n\t\t}\n\t};\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tpublic void setInt(int[] i) {\n\t                         ^\nThe parameter i is hiding another local variable defined in an enclosing scope\n----------\n2. ERROR in X.java (at line 11)\n\tj = 10;\n\t^\nLocal variable j defined in an enclosing scope must be final or effectively final\n----------\n", null, true, null);
    }

    public void test415844a() {
        this.runNegativeTest(new String[]{"Sample.java", "public class Sample{\n\tinterface Int { void setInt(int i); }\n\tpublic static void main(String[] args) {\n\t\tfinal int j;\n\t\tInt int1 = (int i) -> {\n\t\t\t\t\t\t\t\tj=10;\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in Sample.java (at line 6)\n\tj=10;\n\t^\nThe final local variable j cannot be assigned, since it is defined in an enclosing type\n----------\n", null, true, null);
    }

    public void test415844b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    interface Int {\n\t\tvoid setInt(int[] i);\n    }\n    public static void main(String[] args) {\n    \tfinal int j;\n    \tInt i = new Int() {\n\t\t\t@Override\n\t\t\tpublic void setInt(int[] i) {\n\t\t\t\tj = 10;\n\t\t\t}\n\t\t};\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tpublic void setInt(int[] i) {\n\t                         ^\nThe parameter i is hiding another local variable defined in an enclosing scope\n----------\n2. ERROR in X.java (at line 10)\n\tj = 10;\n\t^\nThe final local variable j cannot be assigned, since it is defined in an enclosing type\n----------\n", null, true, null);
    }

    public void test404657_final() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n void executeLater(Runnable r) { /* ... */\n }\n public int testFinally() {\n  int n;\n  try {\n   n = 42;\n    executeLater(() -> System.out.println(n)); // Error: n is not effectively final\n  } finally {\n   n = 23;\n  }\n  return n;\n }\n\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\texecuteLater(() -> System.out.println(n)); // Error: n is not effectively final\n\t                                      ^\nLocal variable n defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void test404657_loop() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n void executeLater(Runnable r) { /* ... */\n }\n public void testLoop() {\n  int n;\n  for (int i = 0; i < 3; i++) {\n   n = i;\n   executeLater(() -> System.out.println(n)); // Error: n is not effectively final\n  }\n }\n\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\texecuteLater(() -> System.out.println(n)); // Error: n is not effectively final\n\t                                      ^\nLocal variable n defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public void testExplicitTypeArgument() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid sam(X t, Integer s);\n}\npublic class X {\n\t<T> void function(T t) {}\n\tpublic static void main(String [] args) {\n\t\tI i = X::<String>function;\n\t\ti = X::function;\n\t\ti = X::<Integer>function;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = X::<String>function;\n\t      ^^^^^^^^^^^^^^^^^^^\nThe type X does not define function(X, Integer) that is applicable here\n----------\n");
    }

    public void testGenericArrayCreation() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tX<?, ?, ?>[] makeArray(int i);\n}\npublic class X<T, U, V> {\n\tpublic static void main(String [] args) {\n\t\tI i = X<?, ?, ?>[]::new; // OK.\n\t\ti = X<String, Integer, ?>[]::new; // ! OK\n\t\tX<?, ?, ?> [] a = new X<?, ?, ?>[10]; // OK\n\t\ta = new X<String, Integer, ?>[10]; // ! OK\n\t\tSystem.out.println(i.makeArray(1024).length);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\ti = X<String, Integer, ?>[]::new; // ! OK\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot create a generic array of X<String,Integer,?>\n----------\n2. ERROR in X.java (at line 9)\n\ta = new X<String, Integer, ?>[10]; // ! OK\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot create a generic array of X<String,Integer,?>\n----------\n");
    }

    public void testIntersectionCast() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\ninterface I {\n\tvoid foo();\n}\ninterface J extends I {\n\tvoid foo();\n}\ninterface K {\n}\ninterface L {\n\tvoid foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (I & Serializable) () -> {};\n\t\ti = (I & J & K) () -> {};\n\t\ti = (J & I & K) () -> {};  \n\t\ti = (J & I & K & L) () -> {};  \n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\ti = (J & I & K & L) () -> {};  \n\t                    ^^^^^\nThe target type of this expression is not a functional interface: more than one of the intersecting interfaces are functional\n----------\n");
    }

    public void testUnderScoreParameter() {
        this.runNegativeTest(new String[]{"X.java", "interface F {\n\tvoid foo(int x);\n}\ninterface I {\n\tdefault void foo() {\n\t\tF f = (int _) -> {\n\t\t};\n\t\tF f2 = _ -> {};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tF f = (int _) -> {\n\t           ^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n2. WARNING in X.java (at line 8)\n\tF f2 = _ -> {};\n\t       ^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n3. ERROR in X.java (at line 8)\n\tF f2 = _ -> {};\n\t       ^\n'_' should not be used as an identifier, since it is a reserved keyword from source level 1.8 on\n----------\n");
    }

    public void test383096() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\nclass XI {\n\tvoid foo() {\n        \tI t1 = f -> {{};\n        \tI t2 = () -> 42;\n        } \n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tI t2 = () -> 42;\n\t       ^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n2. ERROR in X.java (at line 6)\n\t} \n\t^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n3. ERROR in X.java (at line 7)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n", true);
    }

    public void test422516() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws InterruptedException {\n        final int[] result= { 0 };\n        Thread t = new Thread(() -> {\n            sysoresult[0]= 42;\n        });\n        t.start();\n        t.join();\n        System.out.println(result[0]);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tsysoresult[0]= 42;\n\t^^^^^^^^^^\nsysoresult cannot be resolved to a variable\n----------\n", true);
    }

    public void test422516a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws InterruptedException {\n        final int[] result= { 0 };\n        Thread t = new Thread(() -> {\n            System.out.printlnresult[0]= 42;\n        });\n        t.start();\n        t.join();\n        System.out.println(result[0]);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.printlnresult[0]= 42;\n\t           ^^^^^^^^^^^^^\nprintlnresult cannot be resolved or is not a field\n----------\n");
    }

    public void test422489() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(String [] x, String y);\n}\ninterface J {\n\tvoid foo(int x, int y);\n}\npublic class X {\n    static void goo(I i) {\n    }\n    static void goo(J j) {\n    }\n    public static void main(String[] args) throws InterruptedException {\n\t\tgoo((x, y) -> { x[0] += 1; });\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tgoo((x, y) -> { x[0] += 1; });\n\t^^^\nThe method goo(I) is ambiguous for the type X\n----------\n");
    }

    public void test422489a() {
        this.runNegativeTest(new String[]{"X.java", "interface J {\n\tvoid foo(int x, int y);\n}\ninterface I {\n\tvoid foo(String [] x, String y);\n}\npublic class X {\n    static void goo(J j) {\n    }\n    static void goo(I i) {\n    }\n    public static void main(String[] args) throws InterruptedException {\n\t\tgoo((x, y) -> { x[0] += 1; });\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tgoo((x, y) -> { x[0] += 1; });\n\t^^^\nThe method goo(J) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 13)\n\tgoo((x, y) -> { x[0] += 1; });\n\t                ^^^^\nThe type of the expression must be an array type but it resolved to int\n----------\n");
    }

    public void test422489b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(String [] x, String y);\n}\ninterface J {\n\tvoid foo(int x, int y);\n}\npublic class X {\n    static void goo(J j) {\n    }\n    static void goo(I i) {\n    }\n    public static void main(String[] args) throws InterruptedException {\n\t\tgoo((x, y) -> { return x[0] += 1; });\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tgoo((x, y) -> { return x[0] += 1; });\n\t^^^\nThe method goo(J) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 13)\n\tgoo((x, y) -> { return x[0] += 1; });\n\t                       ^^^^\nThe type of the expression must be an array type but it resolved to int\n----------\n");
    }

    public void test422489c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(String [] x, String y);\n}\ninterface J {\n\tvoid foo(int x, int y);\n}\npublic class X {\n    static void goo(J j) {\n    }\n    static void goo(I i) {\n    }\n    public static void main(String[] args) throws InterruptedException {\n\t\tgoo((x, y) -> x[0] += 1);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tgoo((x, y) -> x[0] += 1);\n\t^^^\nThe method goo(J) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 13)\n\tgoo((x, y) -> x[0] += 1);\n\t              ^^^^\nThe type of the expression must be an array type but it resolved to int\n----------\n");
    }

    public void test422489d() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(String x, String y);\n}\ninterface J {\n\tvoid foo(int x, int y);\n}\npublic class X {\n    static void goo(J j) {\n    }\n    static void goo(I i) {\n    }\n    public static void main(String[] args) throws InterruptedException {\n\t\tgoo((x, y) -> x[0] += 1);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tgoo((x, y) -> x[0] += 1);\n\t^^^\nThe method goo(J) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 13)\n\tgoo((x, y) -> x[0] += 1);\n\t              ^^^^\nThe type of the expression must be an array type but it resolved to int\n----------\n");
    }

    public void test422801() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void foo(Random arg) {\n        new Thread(() -> {\n            arg.intValue();\n        });\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(Random arg) {\n\t                ^^^^^^\nRandom cannot be resolved to a type\n----------\n");
    }

    public void test422801a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    Random arg;\n    public void foo() {\n        new Thread(() -> {\n            arg.intValue();\n        });\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tRandom arg;\n\t^^^^^^\nRandom cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\targ.intValue();\n\t^^^\nRandom cannot be resolved to a type\n----------\n");
    }

    public void test405134a() {
        this.runNegativeTest(new String[]{"X.java", "interface Foo { \n\tint run1(int s1, int s2);\n\tstatic int x2 = 0;\n}\ninterface Foo1 {\n\tFoo run2(int argFoo1);\n}\ninterface X extends Foo{\n    static int x1 = 2;\n    static Foo f = (x5, x6) -> x5;\n    static Foo1 f1 = af1 -> (a1,b1) -> {int uniqueName = 4; return uniqueName};\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tstatic Foo1 f1 = af1 -> (a1,b1) -> {int uniqueName = 4; return uniqueName};\n\t                                                                         ^\nSyntax error on token \"}\", delete this token\n----------\n2. ERROR in X.java (at line 12)\n\t}\n\t^\nSyntax error, insert \";\" to complete FieldDeclaration\n----------\n3. ERROR in X.java (at line 12)\n\t}\n\t^\nSyntax error, insert \"}\" to complete InterfaceBody\n----------\n", true);
    }

    public void test421927() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tint foo();\n}\npublic class X {\n    I i  = (I & java.io.Serializable) () -> 42;\n}\n"}, "", true);
    }

    public void test421927a() {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tint foo();\n}\npublic class X {\n    I i;\n    { i = (I & java.io.Serializable) () -> 42;\n       I j = (I & java.io.Serializable) () -> 42;\n       j = (I & java.io.Serializable) j == null ? () -> 42 : () -> 42;\n       j = goo((I & java.io.Serializable) () -> 42);\n    }\n    I goo(I i) {\n        return (I & java.io.Serializable) () -> 42;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tI goo(I i) {\n\t        ^\nThe parameter i is hiding a field from type X\n----------\n", true);
    }

    public void test423429() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tJ foo(String x, String y);\n}\ninterface J {\n\tK foo(String x, String y);\n}\ninterface K {\n\tint foo(String x, int y);\n}\npublic class X {\n\tstatic void goo(K i) {}\n\tpublic static void main(String[] args) {\n\t\tgoo ((first, second) -> {\n\t\t\treturn (xyz, pqr) -> first.length();\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\treturn (xyz, pqr) -> first.length();\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test423129() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tString foo(Integer x);\n}\npublic class X {\n\tstatic void goo(String s) {\n\t}\n\tstatic void goo(I i) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo((xyz) -> {\n\t\t\tSystem.out.println(xyz);\n\t\t\treturn xyz.\n\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tSystem.out.println(xyz);\n\t                   ^^^\nxyz cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 12)\n\treturn xyz.\n\t          ^\nSyntax error, insert \"new ClassType ( )\" to complete ClassInstanceCreationExpression\n----------\n3. ERROR in X.java (at line 12)\n\treturn xyz.\n\t          ^\nSyntax error, insert \";\" to complete ReturnStatement\n----------\n", true);
    }

    public void test423129b() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Collections;\nimport java.util.Comparator;\npublic class X {\n   int compareTo(X x) { return 0; }\n\tvoid foo() {\n\t\tCollections.sort(new ArrayList<X>(Arrays.asList(new X(), new X(), new X())),\n\t\t\t\t(X o1, X o2) -> o1.compareTo(o2)); //[2]\n\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n", true);
    }

    public void test423129c() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Arrays;\nclass MySorter { static <T> void sort(List<T> l, MyComparator<T> comp) { } }\ninterface MyComparator<T> { byte compare(T t1, T t2); }\npublic class X {\n   int compareTo(X x) { return 0; }\n\tvoid foo() {\n\t\tMySorter.sort(new ArrayList<X>(Arrays.asList(new X(), new X(), new X())),\n\t\t\t\t(X o1, X o2) -> 13);\n\t}\n}\n"});
    }

    public void test424400() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> implements MyComparable<T>{\n    public static void main(String argv[]) {\n    \tint result = ((Comparable<Integer> & MyComparable) new X()).compareTo(1);\n    }\n    public int compareTo(T o) {\n\t\treturn 0;\n\t}\n}\ninterface MyComparable<T> extends Comparable<T> {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint result = ((Comparable<Integer> & MyComparable) new X()).compareTo(1);\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe interface Comparable cannot be implemented more than once with different arguments: Comparable and Comparable<Integer>\n----------\n2. WARNING in X.java (at line 3)\n\tint result = ((Comparable<Integer> & MyComparable) new X()).compareTo(1);\n\t                                     ^^^^^^^^^^^^\nMyComparable is a raw type. References to generic type MyComparable<T> should be parameterized\n----------\n3. WARNING in X.java (at line 3)\n\tint result = ((Comparable<Integer> & MyComparable) new X()).compareTo(1);\n\t                                                       ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void _test424400() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> implements MyComparable<T> {\n    public static void main(String argv[]) {\n    \tint result = ((Comparable<Integer> & MyComparable) new X()).compareTo(1);\n    }\n    public int compareTo(T o) {\n\treturn 0;\n    }\n}\ninterface MyComparable<T> {\n     public int compareTo(T value);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint result = ((Comparable<Integer> & MyComparable) new X()).compareTo(1);\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe interface Comparable cannot be implemented more than once with different arguments: Comparable and Comparable<Integer>\n----------\n2. WARNING in X.java (at line 3)\n\tint result = ((Comparable<Integer> & MyComparable) new X()).compareTo(1);\n\t                                     ^^^^^^^^^^^^\nMyComparable is a raw type. References to generic type MyComparable<T> should be parameterized\n----------\n3. WARNING in X.java (at line 3)\n\tint result = ((Comparable<Integer> & MyComparable) new X()).compareTo(1);\n\t                                                       ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test424444() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface Functional<T> {\n    T foo(int size);\n}\npublic class X  {\n    public static void main(String argv[]) {\n    \tint [] a = goo(10);\n    \tFunctional<Integer []> contr = int[]::new;\n        System.out.println(\"Done\");\n    }\n    static int [] goo(int x) {\n    \treturn new int [x];\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tFunctional<Integer []> contr = int[]::new;\n\t                               ^^^^^^^^^^\nConstructed array int[] cannot be assigned to Integer[] as required in the interface descriptor  \n----------\n");
    }

    public void test425512() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface IJK {\n    void foo(int size);\n}\npublic class X  {\n    public static void main(String argv[]) {\n    \tint [] a = (int [] & IJK) null;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tint [] a = (int [] & IJK) null;\n\t            ^^^^^^\nArrays are not allowed in intersection cast operator\n----------\n");
    }

    public void test425512a() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\ninterface IJK {\n    void foo(int size);\n}\npublic class X  {\n    public static void main(String argv[]) {\n    \tint [] a = (int [] & Serializable & IJK) null;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tint [] a = (int [] & Serializable & IJK) null;\n\t            ^^^^^^\nArrays are not allowed in intersection cast operator\n----------\n");
    }

    public void test425512b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\ninterface IJK {\n    void foo(int size);\n}\npublic class X  {\n    public static void main(String argv[]) {\n    \tint [] a = (int [] & IJK & Serializable) null;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tint [] a = (int [] & IJK & Serializable) null;\n\t            ^^^^^^\nArrays are not allowed in intersection cast operator\n----------\n");
    }

    public void test425512c() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\ninterface IJK {\n    void foo(int size);\n}\npublic class X  {\n    public static void main(String argv[]) {\n    \tint [] a = (IJK & Serializable & int []) null;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tint [] a = (IJK & Serializable & int []) null;\n\t                                 ^^^^^^\nThe type int[] is not an interface; it cannot be specified as a bounded parameter\n----------\n");
    }

    public void test425512cd() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\ninterface I {\n    void foo(int size);\n}\npublic class X  {\n    public static void main(String argv[]) {\n    \tI i = (int [] & I) (i) -> {};\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = (int [] & I) (i) -> {};\n\t       ^^^^^^\nArrays are not allowed in intersection cast operator\n----------\n2. ERROR in X.java (at line 7)\n\tI i = (int [] & I) (i) -> {};\n\t                   ^^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test425512ce() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\ninterface I {\n    void foo(int size);\n}\npublic class X  {\n    public static void main(String argv[]) {\n    \tI i = (int [] & Serializable) (i) -> {};\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = (int [] & Serializable) (i) -> {};\n\t       ^^^^^^\nArrays are not allowed in intersection cast operator\n----------\n2. ERROR in X.java (at line 7)\n\tI i = (int [] & Serializable) (i) -> {};\n\t                              ^^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test425621() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class Y<T> {\n    Y() {}\n}    \ninterface I {\n    Y<Y> foo();\n}\npublic class X  {\n    I i = Y::<X>new;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tY<Y> foo();\n\t  ^\nY is a raw type. References to generic type Y<T> should be parameterized\n----------\n2. ERROR in X.java (at line 8)\n\tI i = Y::<X>new;\n\t          ^\nExplicit type arguments cannot be specified in raw constructor reference expression\n----------\n");
    }

    public void test423803() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class C2 implements C2_Sup {\n    public static final FI fi = x -> x++;\n    public static final FL fl = x -> x++;\n    {\n        bar(x -> x++); // [1]\n        bar(fl); \n    }\n    void bar(FI fi) { }\n}\ninterface C2_Sup {\t\n\tdefault void bar(FL fl) { }\n}\n@FunctionalInterface\ninterface FI {\n\tint foo(int x);\n}\n@FunctionalInterface\ninterface FL {\n    long foo(long x);\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tbar(x -> x++); // [1]\n\t^^^\nThe method bar(FI) is ambiguous for the type C2\n----------\n2. WARNING in X.java (at line 8)\n\tvoid bar(FI fi) { }\n\t            ^^\nThe parameter fi is hiding a field from type C2\n----------\n");
    }

    public void test423803b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X implements K {\n    {\n        bar(x -> x++); // [1]\n    }\n    void bar(I fi) { }\n}\ninterface K {\t\n\tdefault void bar(J fl) { }\n}\ninterface I {\n\tint foo(int x);\n}\ninterface J {\n    long foo(long x);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tbar(x -> x++); // [1]\n\t^^^\nThe method bar(I) is ambiguous for the type X\n----------\n");
    }

    public void test425712() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class C2 {\n    {\n        bar( () -> (char) 0); // [1]\n    }\n    void bar(FC fc) { }\n    void bar(FB fb) { }\n}\ninterface FB {\n\tbyte foo();\n}\ninterface FC {\n    char foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tbar( () -> (char) 0); // [1]\n\t^^^\nThe method bar(FC) is ambiguous for the type C2\n----------\n");
    }

    public void test421926() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tI run(int s1);\n}\nclass X {\t\n   public static final int f = f;\n\tpublic static final I fi = x -> fi;\n\tpublic static final I fj = x -> fk;\n\tpublic static final I fk = x -> fj;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic static final int f = f;\n\t                            ^\nCannot reference a field before it is defined\n----------\n2. ERROR in X.java (at line 6)\n\tpublic static final I fi = x -> fi;\n\t                                ^^\nCannot reference a field before it is defined\n----------\n3. ERROR in X.java (at line 7)\n\tpublic static final I fj = x -> fk;\n\t                                ^^\nCannot reference a field before it is defined\n----------\n");
    }

    public void test421926b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tint run(int s1, int s2); \n}\npublic class X {\n    static int f = ((I) (int x5, int x2) -> x1).run(10,  20);\n    static int x1 = 2;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tstatic int f = ((I) (int x5, int x2) -> x1).run(10,  20);\n\t                                        ^^\nCannot reference a field before it is defined\n----------\n");
    }

    public void test421926c() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I { \n\tint run(int s1, int s2); \n}\npublic class X {\n    int f = ((I) (int x5, int x2) -> x1).run(10,  20);\n    static int x1 = 2;\n}\n"}, "");
    }

    public void test426206() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Comparator;\npublic class X  {\n    public static void main(String argv[]) {\n        Comparator<? extends String> c = true ? (Integer i, Integer j) -> { return 0; } : (Long i, Long j) -> { return 1; };\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tComparator<? extends String> c = true ? (Integer i, Integer j) -> { return 0; } : (Long i, Long j) -> { return 1; };\n\t                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Comparator<Integer> to Comparator<? extends String>\n----------\n2. ERROR in X.java (at line 4)\n\tComparator<? extends String> c = true ? (Integer i, Integer j) -> { return 0; } : (Long i, Long j) -> { return 1; };\n\t                                                                                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Comparator<Long> to Comparator<? extends String>\n----------\n");
    }

    public void testBug426563() {
        this.runNegativeTest(new String[]{"X.java", "interface I<U, V extends J<U>> { \n    void foo(U u, V v); \n}\n\ninterface J<T> {}\n\npublic class X  {\n\n    public void bar(FI<?, ?> fi) {}\n\n    public static void main(String args[]) {\n      new X().bar((p, q) -> {}); \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tpublic void bar(FI<?, ?> fi) {}\n\t                ^^\nFI cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 12)\n\tnew X().bar((p, q) -> {}); \n\t        ^^^\nThe method bar(FI<?,?>) from the type X refers to the missing type FI\n----------\n3. ERROR in X.java (at line 12)\n\tnew X().bar((p, q) -> {}); \n\t            ^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test426965() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tinterface I<U extends List<X>, V> {\n\t\tV foo(U p);\n\t}\n\tpublic void main() {\n\t\tI<List<X>, Object> fi = p -> p.toArray(new X[] {});\n\t}\n}\n"}, "");
    }

    public void test427207() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (I) ((args == null) ? ()->{} : ()-> {});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI i = (I) ((args == null) ? ()->{} : ()-> {});\n\t                            ^^^^\nThe target type of this expression must be a functional interface\n----------\n2. ERROR in X.java (at line 6)\n\tI i = (I) ((args == null) ? ()->{} : ()-> {});\n\t                                     ^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test425278() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T, S extends X<T>> { \n    T foo(S p);\n}\npublic class X<T>  {\n    public void bar() {\n    \tI<Object, ? extends X<Object>> f = (p) -> p;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI<Object, ? extends X<Object>> f = (p) -> p;\n\t                                   ^^^^^^^^\nThe target type of this expression is not a well formed parameterized type due to bound(s) mismatch\n----------\n");
    }

    public void test427265() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n    public static void main(String[] args) {\n\t     List<String> ss = Arrays.asList(\"1\", \"2\", \"3\");\n\t     ss.stream().map(s -> new Object() {});\n    }\n}\n"}, "");
    }

    public void test427749() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    void foo(X<String> y);\n}\npublic class X<T> {\n    class Z<K> {\n        Z(X<String> y) {\n            System.out.println(\"Y<T>.Z<K>::new\");\n        }\n        public void bar() {\n            I i = Y<String>.Z<Integer>::<String> new;\n            i.foo(new Y<String>());\n        }\n    }\n\tpublic void foo() {\n\t\tZ<String> z = new Z<String>(null);\n\t\tz.bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new Y<String>();\n\t\ty.foo();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tI i = Y<String>.Z<Integer>::<String> new;\n\t      ^\nY cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 11)\n\ti.foo(new Y<String>());\n\t          ^\nY cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 19)\n\tY<String> y = new Y<String>();\n\t^\nY cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 19)\n\tY<String> y = new Y<String>();\n\t                  ^\nY cannot be resolved to a type\n----------\n");
    }

    public void test428300() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.concurrent.ConcurrentHashMap;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tConcurrentHashMap<String, String[]> map = new ConcurrentHashMap<>();\n\t\tmap.computeIfAbsent(\"doo\", e -> new String[] {});\n\t}\n}\n"}, "");
    }

    public void test428300a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.concurrent.ConcurrentHashMap;\nimport java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tConcurrentHashMap<String, String[]> map = new ConcurrentHashMap<>();\n\t\tFunction<String, String[]> f = e -> new String[] {};\n\t\tmap.computeIfAbsent(\"doo\", f);\n\t}\n}\n"}, "");
    }

    public void _test428177() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\nimport java.nio.file.Path;\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.jar.JarEntry;\nimport java.util.jar.JarFile;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\nclass InsistentCapture {\n  static void processJar(Path plugin) throws IOException {\n    try(JarFile jar = new JarFile(plugin.toFile())) {\n      try(Stream<JarEntry> entries = jar.stream()) {\n        Function<? super JarEntry, ? extends String> toName =\n          entry -> entry.getName();\n        Stream<? extends String> stream = entries.map(toName).distinct(); // Ok\n        withWildcard(entries.map(toName).distinct()); // Ok\n        withWildcard(stream); // Ok\n        Stream<String> stream2 = entries.map(toName).distinct(); // ERROR\n        withoutWildcard(entries.map(toName).distinct()); // ERROR\n        withoutWildcard(stream); // ERROR\n        withoutWildcard(stream2); // Ok\n        withoutWildcard(coerce(stream)); // Ok\n        withoutWildcard(stream.map((String v1) -> { // ERROR\n          String r = \"\" + v1; // Hover on v: Ok\n          return r;\n        }));\n        withoutWildcard(stream.map((v2) -> { // Ok\n          String r = \"\" + v2; // Hover on v: NOT OK\n          return r;\n        }));\n      }\n    }\n  }\n  private static Stream<String> coerce(Stream<? extends String> stream) {\n    if(\"1\" == \"\") { return stream.collect(Collectors.toList()).stream(); // ERROR\n    }\n    return stream.collect(Collectors.toList()); // NO ERROR\n  }\n  private static void withWildcard(Stream<? extends String> distinct) {\n    distinct.forEach(s1 -> System.out.println(s1)); // hover on s: NOT OK\n  }\n  private static void withoutWildcard(Stream<String> distinct) {\n    distinct.forEach(s2 -> System.out.println(s2)); // hover on s: Ok\n  }\n}\n"}, "valid error messages go here - some are expected since javac also complains");
    }

    public void test428795() {
        this.runNegativeTest(new String[]{"X.java", "import java.net.NetworkInterface;\nimport java.util.Optional;\npublic class X {\n  public static void main( String[] args ) {\n    Optional.ofNullable( NetworkInterface.getByIndex( 2 ) ).ifPresent( ni -> {\n      Optional.ofNullable( ni.getDisplayName() ).ifPresent( name ->\n        System.out.println( name.get().toUpperCase() )\n      );\n    });\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println( name.get().toUpperCase() )\n\t                         ^^^\nThe method get() is undefined for the type String\n----------\n");
    }

    public void test428857() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\npublic class X {\n    public static void main (String[] args) {\n        Function<List<String>, String> func = ArrayList::toString;\n        System.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tFunction<List<String>, String> func = ArrayList::toString;\n\t                                      ^^^^^^^^^^^^^^^^^^^\nThe type ArrayList does not define toString(List<String>) that is applicable here\n----------\n", null, false, customOptions);
    }

    public void test428857a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\npublic class X {\n    public static void main (String[] args) {\n        Function<ArrayList<String>, String> func = ArrayList::toString;\n        System.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n\t                        ^^^^^\nThe method apply(ArrayList<String>) in the type Function<ArrayList<String>,String> is not applicable for the arguments (List<String>)\n----------\n2. ERROR in X.java (at line 8)\n\tSystem.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n\t                              ^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<String> to ArrayList<String>\n----------\n", null, false, customOptions);
    }

    public void test428857b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\npublic class X {\n    public static void main (String[] args) {\n        Function<ArrayList<String>, String> func = List::toString;\n        System.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n\t                        ^^^^^\nThe method apply(ArrayList<String>) in the type Function<ArrayList<String>,String> is not applicable for the arguments (List<String>)\n----------\n2. ERROR in X.java (at line 8)\n\tSystem.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n\t                              ^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<String> to ArrayList<String>\n----------\n", null, false, customOptions);
    }

    public void test428857c() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\nclass Vector<E> extends ArrayList<E> {}\ninterface I {\n    ArrayList<String> get();\n}\npublic class X {\n    public static void main (String[] args) {\n        I i = ArrayList::new;\n        System.out.println(i.get());\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tclass Vector<E> extends ArrayList<E> {}\n\t      ^^^^^^\nThe serializable class Vector does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, false, customOptions);
    }

    public void test428857d() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\nclass Vector<E> extends ArrayList<E> {}\ninterface I {\n    List<String> get();\n}\npublic class X {\n    public static void main (String[] args) {\n        I i = ArrayList::new;\n        System.out.println(i.get());\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tclass Vector<E> extends ArrayList<E> {}\n\t      ^^^^^^\nThe serializable class Vector does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, false, customOptions);
    }

    public void test428857e() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\nclass Vector<E> extends ArrayList<E> {}\ninterface I {\n    Vector<String> get();\n}\npublic class X {\n    public static void main (String[] args) {\n        I i = ArrayList::new;\n        System.out.println(i.get());\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tclass Vector<E> extends ArrayList<E> {}\n\t      ^^^^^^\nThe serializable class Vector does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 11)\n\tI i = ArrayList::new;\n\t      ^^^^^^^^^^^^^^\nThe constructed object of type ArrayList is incompatible with the descriptor's return type: Vector<String>\n----------\n3. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, false, customOptions);
    }

    public void test428857f() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\nclass Vector<E> extends ArrayList<E> {}\ninterface I {\n    ArrayList<String> get();\n}\npublic class X {\n    public static void main (String[] args) {\n        I i = Vector::new;\n        System.out.println(i.get());\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tclass Vector<E> extends ArrayList<E> {}\n\t      ^^^^^^\nThe serializable class Vector does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, false, customOptions);
    }

    public void test428857g() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\npublic class X {\n    public static void main (String[] args) {\n        Function<? extends ArrayList<String>, String> func = ArrayList::toString;\n        System.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n\t                        ^^^^^\nThe method apply(capture#1-of ? extends ArrayList<String>) in the type Function<capture#1-of ? extends ArrayList<String>,String> is not applicable for the arguments (List<String>)\n----------\n2. ERROR in X.java (at line 8)\n\tSystem.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n\t                              ^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<String> to capture#1-of ? extends ArrayList<String>\n----------\n", null, false, customOptions);
    }

    public void test429833() {
        this.runNegativeTest(new String[]{"X.java", "interface I1 { int foo(Strin i); }\nclass Y {\n\tI1 i = (a) -> { \n\t\ta.charAt(0);\n\t};\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface I1 { int foo(Strin i); }\n\t                       ^^^^^\nStrin cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tI1 i = (a) -> { \n\t       ^^^^^^\nThis lambda expression refers to the missing type Strin\n----------\n");
    }

    public void test429934() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tFunction<String, String> f1= (String s, Function this) -> s;\n\t\tFunction<String, String> f2= (Function this, String s) -> s;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tFunction<String, String> f1= (String s, Function this) -> s;\n\t^^^^^^^^\nFunction cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tFunction<String, String> f1= (String s, Function this) -> s;\n\t                             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n3. ERROR in X.java (at line 3)\n\tFunction<String, String> f1= (String s, Function this) -> s;\n\t                                        ^^^^^^^^\nFunction cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 3)\n\tFunction<String, String> f1= (String s, Function this) -> s;\n\t                                                 ^^^^\nLambda expressions cannot declare a this parameter\n----------\n5. ERROR in X.java (at line 4)\n\tFunction<String, String> f2= (Function this, String s) -> s;\n\t^^^^^^^^\nFunction cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\tFunction<String, String> f2= (Function this, String s) -> s;\n\t                             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n7. ERROR in X.java (at line 4)\n\tFunction<String, String> f2= (Function this, String s) -> s;\n\t                              ^^^^^^^^\nFunction cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 4)\n\tFunction<String, String> f2= (Function this, String s) -> s;\n\t                                       ^^^^\nLambda expressions cannot declare a this parameter\n----------\n");
    }

    public void test429969() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.Optional;\npublic class X {\n    public static void main(String[] args) {\n        final String s = Arrays.asList(\"done\").stream().reduce(null, (s1,s2) -> {\n                // THE FOLLOWING LINE CAUSES THE PROBLEM\n                require(s1 != null || s2 != null, \"both strings are null\");\n                    return (s1 != null) ? s1 : s2;\n            }, (s1,s2) -> (s1 != null) ? s1 : s2);\n\t\n        System.out.println(s);\n    }\n    static void require(boolean condition, String msg) throws java.io.IOException {\n        if (!condition) {\n            throw new java.io.IOException(msg);\n        }\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\timport java.util.Optional;\n\t       ^^^^^^^^^^^^^^^^^^\nThe import java.util.Optional is never used\n----------\n2. ERROR in X.java (at line 7)\n\trequire(s1 != null || s2 != null, \"both strings are null\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n");
    }

    public void test429969a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n    void foo() throws RuntimeException;\n}\npublic class X {\n\tstatic void goo() throws Exception {\n\t\tthrow new Exception();\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::goo;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI i = X::goo;\n\t      ^^^^^^\nUnhandled exception type Exception\n----------\n");
    }

    public void test430310() {
        this.runNegativeTest(new String[]{"X.java", "interface Func1<T1, R> {\n        R apply(T1 v1);\n        void other();\n}\n@FunctionalInterface // spurious error: F1<T, R> is not a functional interface\ninterface F1<T1, R> extends Func1<T1, R> {\n\tdefault void other() {}\n}\n@FunctionalInterface\ninterface F2<T1, R> extends Func1<T1, R> {\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tinterface F2<T1, R> extends Func1<T1, R> {\n\t          ^^\nInvalid '@FunctionalInterface' annotation; F2<T1,R> is not a functional interface\n----------\n");
    }

    public void test424154a() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;public class X {\n\tvoid foo(List<Process> list) {\n\t\tlist.removeIf((int x) -> \"\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tlist.removeIf((int x) -> \"\");\n\t     ^^^^^^^^\nThe method removeIf(Predicate<? super Process>) in the type Collection<Process> is not applicable for the arguments ((int x) -> {})\n----------\n2. ERROR in X.java (at line 3)\n\tlist.removeIf((int x) -> \"\");\n\t              ^^^^^^^^^^^^^\nThe target type of this expression is not a well formed parameterized type due to bound(s) mismatch\n----------\n");
    }

    public void test424154b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tinterface I {int foo(int x);}\n\tvoid foo2(I i) {}\n\tvoid foo() {}\n\tvoid bar() {\n\t\tfoo(0, (int x, int y) -> {return 2;}, 0);\n\t\tfoo2((int x) -> \"\");\n\t\tfoo2((float x) -> 0);\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tfoo(0, (int x, int y) -> {return 2;}, 0);\n\t^^^\nThe method foo() in the type X is not applicable for the arguments (int, (int x, int y) -> {}, int)\n----------\n2. ERROR in X.java (at line 7)\n\tfoo2((int x) -> \"\");\n\t^^^^\nThe method foo2(X.I) in the type X is not applicable for the arguments ((int x) -> {})\n----------\n3. ERROR in X.java (at line 7)\n\tfoo2((int x) -> \"\");\n\t                ^^\nType mismatch: cannot convert from String to int\n----------\n4. ERROR in X.java (at line 8)\n\tfoo2((float x) -> 0);\n\t^^^^\nThe method foo2(X.I) in the type X is not applicable for the arguments ((float x) -> {})\n----------\n5. ERROR in X.java (at line 8)\n\tfoo2((float x) -> 0);\n\t      ^^^^^\nLambda expression's parameter x is expected to be of type int\n----------\n");
    }

    public void test431514() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.Supplier;\npublic class X {\n\tpublic void foo() {\n\t\tclass Z {\n\t\t\tpublic Supplier<Object> get() {\n\t\t\t\treturn () -> {\n\t\t\t\t\tclass Z { }\n\t\t\t\t\treturn new Z();\n\t\t\t\t};\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tclass Z { }\n\t      ^\nThe nested type Z cannot hide an enclosing type\n----------\n");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.NegativeLambdaExpressionsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

