/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractNullAnnotationTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class NullAnnotationTest
extends AbstractNullAnnotationTest {
    private String TEST_JAR_SUFFIX = ".jar";
    static /* synthetic */ Class class$0;

    public NullAnnotationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NullAnnotationTest.buildComparableTestSuite(NullAnnotationTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.NullAnnotationTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    String mismatch_NonNull_Nullable(String type) {
        return this.complianceLevel < 0x340000L ? "Null type mismatch: required '@NonNull " + type + "' but the provided value is specified as @Nullable\n" : "Null type mismatch (type annotations): required '@NonNull " + type + "' but this expression has type '@Nullable " + type + "'\n";
    }

    String nullTypeSafety() {
        return this.complianceLevel < 0x340000L ? "Null type safety: " : "Null type safety (type annotations): ";
    }

    String variableMayBeNull(String var) {
        return this.complianceLevel < 0x340000L ? "Potential null pointer access: The variable " + var + " may be null at this location\n" : "Potential null pointer access: this expression has a '@Nullable' type\n";
    }

    String redundant_check_nonnull(String expr, String type) {
        return this.complianceLevel < 0x340000L ? "Redundant null check: " + expr + " is specified as @NonNull\n" : "Redundant null check: comparing '" + type + "' against null\n";
    }

    String redundantCheck_method_cannot_return_null(String method, String type) {
        return this.complianceLevel < 0x340000L ? "Redundant null check: The method " + method + " cannot return null\n" : "Redundant null check: comparing '@NonNull " + type + "' against null\n";
    }

    String checkAlwaysFalse_method_cannot_return_null(String method, String type) {
        return this.complianceLevel < 0x340000L ? "Null comparison always yields false: The method " + method + " cannot return null\n" : "Redundant null check: comparing '@NonNull " + type + "' against null\n";
    }

    String redundant_check_canonlynull(String expr, String type) {
        return this.complianceLevel < 0x340000L ? "Redundant null check: " + expr + " can only be null at this location\n" : "Redundant null check: comparing '@NonNull " + type + "' against null\n";
    }

    String checkAlwaysFalse_nonnull(String expr, String type) {
        return this.complianceLevel < 0x340000L ? "Null comparison always yields false: " + expr + " is specified as @NonNull\n" : "Redundant null check: comparing '@NonNull " + type + "' against null\n";
    }

    String potNPE_nullable(String expr) {
        return this.complianceLevel < 0x340000L ? "Potential null pointer access: " + expr + " is specified as @Nullable\n" : "Potential null pointer access: this expression has a '@Nullable' type\n";
    }

    String potNPE_nullable_maybenull(String expr) {
        return this.complianceLevel < 0x340000L ? "Potential null pointer access: " + expr + " may be null at this location\n" : "Potential null pointer access: this expression has a '@Nullable' type\n";
    }

    String nonNullArrayOf(String string) {
        return this.complianceLevel < 0x340000L ? "@NonNull Object[]" : "Object @NonNull[]";
    }

    String targetTypeUseIfAvailable() {
        return this.complianceLevel >= 0x340000L ? "@Target(ElementType.TYPE_USE)\n" : "";
    }

    String cancenNonNullByDefault() {
        return this.complianceLevel < 0x340000L ? "    @NonNullByDefault(false)\n" : "    @NonNullByDefault({})\n";
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.complianceLevel >= 0x340000L) {
            this.TEST_JAR_SUFFIX = "_1.8.jar";
        }
        if (this.LIBS == null) {
            this.LIBS = this.getLibsWithNullAnnotations(this.complianceLevel);
        }
    }

    public void test_nullable_paramter_001() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void foo(@Nullable Object o) {\n        System.out.print(o.toString());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tSystem.out.print(o.toString());\n\t                 ^\n" + this.variableMayBeNull("o") + "----------\n", this.LIBS, true);
    }

    public void test_nullable_paramter_002() {
        this.runConformTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void foo(@Nullable Object o) {\n        // nop\n    }\n    void bar() {\n        foo(null);\n    }\n}\n"}, "", this.LIBS, false, null);
    }

    public void test_nonnull_parameter_001() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void foo(@NonNull Object o) {\n        if (o != null)\n              System.out.print(o.toString());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o != null)\n\t    ^\n" + this.redundant_check_nonnull("The variable o", "@NonNull Object") + "----------\n", this.LIBS, true);
    }

    public void test_nonnull_parameter_002() {
        this.runConformTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void foo(@NonNull Object o) {\n        System.out.print(o.toString());\n    }\n    public static void main(String... args) {\n        new X().foo(\"OK\");\n    }\n}\n"}, "OK", this.LIBS, false, null);
    }

    public void test_nonnull_parameter_003() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    int i00, i01, i02, i03, i04, i05, i06, i07, i08, i09;    int i10, i11, i12, i13, i14, i15, i16, i17, i18, i19;    int i20, i21, i22, i23, i24, i25, i26, i27, i28, i29;    int i30, i31, i32, i33, i34, i35, i36, i37, i38, i39;    int i40, i41, i42, i43, i44, i45, i46, i47, i48, i49;    int i50, i51, i52, i53, i54, i55, i56, i57, i58, i59;    int i60, i61, i62, i63, i64, i65, i66, i67, i68, i69;    void foo(@NonNull Object o) {\n        System.out.print(o.toString());\n    }\n    void bar() {\n        foo(null);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tfoo(null);\n\t    ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n", this.LIBS, true);
    }

    public void test_nonnull_parameter_004() {
        this.runConformTestWithLibs(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    void setObject(@NonNull Object o) { }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "public class X {\n    void bar(Lib l, boolean b) {\n        Object o = null;\n        if (b) o = new Object();\n        l.setObject(o);\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\tl.setObject(o);\n\t            ^\nNull type mismatch: required '@NonNull Object' but the provided value is inferred as @Nullable\n----------\n");
    }

    public void test_nonnull_parameter_005() {
        this.runConformTestWithLibs(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    void setObject(@NonNull Object o) { }\n}\n"}, null, "");
        this.runConformTestWithLibs(false, new String[]{"X.java", "public class X {\n    void bar(Lib l, Object o) {\n        l.setObject(o);\n    }\n}\n"}, null, "----------\n1. WARNING in X.java (at line 3)\n\tl.setObject(o);\n\t            ^\n" + this.nullTypeSafety() + "The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object'\n" + "----------\n");
    }

    public void test_nonnull_parameter_006() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    \tvoid m1(@NonNull String a) {}\n\t\tvoid m2(@Nullable String b) {\n\t\t\tm1(b == null ? \"\" : b);\n\t\t}\n}\n"}, customOptions, "");
    }

    public void test_nonnull_parameter_007() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"XSub.java", "import org.eclipse.jdt.annotation.*;\npublic class XSub extends XSuper {\n    \tXSub(@Nullable String b) {\n\t\t\tsuper(b);\n\t\t}\n}\n", "XSuper.java", "import org.eclipse.jdt.annotation.*;\npublic class XSuper {\n    \tXSuper(@NonNull String b) {\n\t\t}\n}\n"}, customOptions, "----------\n1. ERROR in XSub.java (at line 4)\n\tsuper(b);\n\t      ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n");
    }

    public void test_nonnull_parameter_008() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    \tX(@NonNull String a) {}\n\t\tstatic X create(@Nullable String b) {\n\t\t\treturn new X(b);\n\t\t}\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 5)\n\treturn new X(b);\n\t             ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n");
    }

    public void test_nonnull_parameter_009() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    class Local {\n    \t   Local(@NonNull String a) {}\n    }\n\t   Local create(@Nullable String b) {\n\t       return this.new Local(b);\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 7)\n\treturn this.new Local(b);\n\t                      ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n");
    }

    public void test_nonnull_parameter_010() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"ContainingInner2.java", "public class ContainingInner2 {\n    public ContainingInner2 (@org.eclipse.jdt.annotation.NonNull Object o) {\n    }\n    public class Inner {\n        public Inner (@org.eclipse.jdt.annotation.NonNull Object o) {\n        }\n    }\n}\n", "X.java", "public class X {\n\t void create() {\n          ContainingInner2 container = new ContainingInner2(null);\n\t       ContainingInner2.Inner inner = container.new Inner(null);\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tContainingInner2 container = new ContainingInner2(null);\n\t                                                  ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in X.java (at line 4)\n\tContainingInner2.Inner inner = container.new Inner(null);\n\t                                                   ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_parameter_011() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runConformTestWithLibs(new String[]{"ContainingInner2.java", "public class ContainingInner2 {\n    public ContainingInner2 (@org.eclipse.jdt.annotation.NonNull Object o) {\n    }\n    public class Inner {\n        public Inner (@org.eclipse.jdt.annotation.NonNull Object o) {\n        }\n    }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "public class X {\n\t void create() {\n          ContainingInner2 container = new ContainingInner2(null);\n\t       ContainingInner2.Inner inner = container.new Inner(null);\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tContainingInner2 container = new ContainingInner2(null);\n\t                                                  ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in X.java (at line 4)\n\tContainingInner2.Inner inner = container.new Inner(null);\n\t                                                   ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_parameter_012() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runConformTestWithLibs(new String[]{"ContainingInner2.java", "public class ContainingInner2 {\n    public ContainingInner2 (@org.eclipse.jdt.annotation.NonNull Object o) {\n    }\n    public class Inner {\n        public <T> Inner (@org.eclipse.jdt.annotation.NonNull T o) {\n        }\n    }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "public class X {\n\t void create() {\n          ContainingInner2 container = new ContainingInner2(null);\n\t       ContainingInner2.Inner inner = container.new Inner(null);\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tContainingInner2 container = new ContainingInner2(null);\n\t                                                  ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in X.java (at line 4)\n\tContainingInner2.Inner inner = container.new Inner(null);\n\t                                                   ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_parameter_013() {
        this.runNegativeTestWithLibs(new String[]{"B.java", "class B {\n    void bar () {\n        class Local {\n            void callMe(@org.eclipse.jdt.annotation.NonNull Object o){\n            }\n        }\n        Local l = new Local();\n        l.callMe(null);\n    } \n}\n"}, "----------\n1. ERROR in B.java (at line 8)\n\tl.callMe(null);\n\t         ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_parameter_015() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n" + (this.complianceLevel < 0x340000L ? "    void foo(@NonNull Object ... o) {\n" : "    void foo(Object @NonNull... o) {\n") + "        if (o != null)\n" + "              System.out.print(o.toString());\n" + "    }\n" + (this.complianceLevel < 0x340000L ? "    void foo2(int i, @NonNull Object ... o) {\n" : "    void foo2(int i, Object @NonNull ... o) {\n") + "        if (o.length > 0 && o[0] != null)\n" + "              System.out.print(o[0].toString());\n" + "    }\n" + "    void bar() {\n" + "        foo((Object)null);\n" + "        Object[] objs = null;\n" + "        foo(objs);\n" + "        foo(this, null);\n" + "        foo2(2, (Object)null);\n" + "        foo2(2, null, this);\n" + "        foo2(2, null);\n" + "    }\n" + "}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o != null)\n\t    ^\n" + this.redundant_check_nonnull("The variable o", "Object @NonNull[]") + "----------\n" + "2. ERROR in X.java (at line 14)\n" + "\tfoo(objs);\n" + "\t    ^^^^\n" + "Null type mismatch: required '" + this.nonNullArrayOf("Object") + "' but the provided value is null\n" + "----------\n" + "3. WARNING in X.java (at line 18)\n" + "\tfoo2(2, null);\n" + "\t^^^^^^^^^^^^^\n" + "Type null of the last argument to method foo2(int, Object...) doesn't exactly match the vararg parameter type. Cast to Object[] to confirm the non-varargs invocation, or pass individual arguments of type Object for a varargs invocation.\n" + "----------\n" + "4. ERROR in X.java (at line 18)\n" + "\tfoo2(2, null);\n" + "\t        ^^^^\n" + "Null type mismatch: required '" + this.nonNullArrayOf("Object") + "' but the provided value is null\n" + "----------\n", this.LIBS, true);
    }

    public void test_nonnull_parameter_016() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n" + (this.complianceLevel < 0x340000L ? "    X(@NonNull Object ... o) {\n" : "    X(Object @NonNull... o) {\n") + "        if (o != null)\n" + "              System.out.print(o.toString());\n" + "    }\n" + "    class Y extends X {\n" + (this.complianceLevel < 0x340000L ? "    Y(int i, @NonNull Object ... o) {\n" : "    Y(int i, Object @NonNull... o) {\n") + "        \tsuper(i, (Object)null);\n" + "        }\n" + (this.complianceLevel < 0x340000L ? "    Y(char c, @NonNull Object ... o) {\n" : "    Y(char c, Object @NonNull... o) {\n") + "        \tthis(1, new Object(), null);\n" + "        }\n" + "    }\n" + "    void bar() {\n" + "        new X((Object[])null);\n" + "        new X(this, null);\n" + "        X x = new X(null, this);\n" + "        x.new Y(2, (Object)null);\n" + "        this.new Y(2, null, this);\n" + "        this.new Y(2, (Object[])null);\n" + "    }\n" + "}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o != null)\n\t    ^\n" + this.redundant_check_nonnull("The variable o", "Object @NonNull[]") + "----------\n" + "2. ERROR in X.java (at line 16)\n" + "\tnew X((Object[])null);\n" + "\t      ^^^^^^^^^^^^^^\n" + "Null type mismatch: required '" + this.nonNullArrayOf("Object") + "' but the provided value is null\n" + "----------\n" + "3. ERROR in X.java (at line 21)\n" + "\tthis.new Y(2, (Object[])null);\n" + "\t              ^^^^^^^^^^^^^^\n" + "Null type mismatch: required '" + this.nonNullArrayOf("Object") + "' but the provided value is null\n" + "----------\n", this.LIBS, true);
    }

    public void test_nonnull_argument_001() {
        this.runNegativeTestWithLibs(new String[]{"ShowNPE2.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\npublic class ShowNPE2 {\n     public Object foo(Object o1, final boolean b) {\n         o1 = null;   // expect NPE error\n         System.out.println(o1.toString());   \n         return null;  // expect NPE error\n    }\n}"}, "----------\n1. ERROR in ShowNPE2.java (at line 5)\n\to1 = null;   // expect NPE error\n\t     ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in ShowNPE2.java (at line 7)\n\treturn null;  // expect NPE error\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_argument_002() {
        this.runNegativeTestWithLibs(new String[]{"ShowNPE2.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\npublic class ShowNPE2 {\n    public Object foo(Object o1, final boolean b) {\n        bar(o1); // expecting no problem\n        return null;  // expect NPE error\n    }\n    void bar(Object o2) {}\n}"}, "----------\n1. ERROR in ShowNPE2.java (at line 6)\n\treturn null;  // expect NPE error\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_parameter_014() {
        this.runNegativeTestWithLibs(new String[]{"B.java", "class B {\n    void bar () {\n        class Local {\n            void callMe(@org.eclipse.jdt.annotation.NonNull Object o){\n            }\n        }\n        Local l = new Local();\n        l.callMe(getNull());\n    }\n    @org.eclipse.jdt.annotation.Nullable Object getNull() { return null; }}\n"}, "----------\n1. ERROR in B.java (at line 8)\n\tl.callMe(getNull());\n\t         ^^^^^^^^^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n");
    }

    public void test_nonnull_local_001() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void foo(boolean b, Object p) {\n        @NonNull Object o1 = b ? null : new Object();\n        @NonNull String o2 = \"\";\n        o2 = null;\n        @NonNull Object o3 = p;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@NonNull Object o1 = b ? null : new Object();\n" + (this.complianceLevel < 0x340000L ? "\t                     ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is inferred as @Nullable\n" : "\t                         ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n") + "----------\n" + "2. ERROR in X.java (at line 6)\n" + "\to2 = null;\n" + "\t     ^^^^\n" + "Null type mismatch: required '@NonNull String' but the provided value is null\n" + "----------\n" + "3. WARNING in X.java (at line 7)\n" + "\t@NonNull Object o3 = p;\n" + "\t                     ^\n" + this.nullTypeSafety() + "The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object'\n" + "----------\n", this.LIBS, true);
    }

    public void test_nonnull_local_002() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void foo(boolean b, Object p) {\n        @NonNull Object o1;\n        o1 = b ? null : new Object();\n        @NonNull String o2;\n        o2 = \"\";\n        o2 = null;\n        @NonNull Object o3;\n        o3 = p;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\to1 = b ? null : new Object();\n" + (this.complianceLevel < 0x340000L ? "\t     ^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is inferred as @Nullable\n" : "\t         ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n") + "----------\n" + "2. ERROR in X.java (at line 8)\n" + "\to2 = null;\n" + "\t     ^^^^\n" + "Null type mismatch: required '@NonNull String' but the provided value is null\n" + "----------\n" + "3. WARNING in X.java (at line 10)\n" + "\to3 = p;\n" + "\t     ^\n" + this.nullTypeSafety() + "The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object'\n" + "----------\n", this.LIBS, true);
    }

    public void test_parameter_specification_inheritance_001() {
        this.runConformTestWithLibs(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    void foo(String s, @Nullable Object o, Object third) { }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X extends Lib {\n    @Override\n    void foo(@Nullable String s, @NonNull Object o, @NonNull Object third) { System.out.print(o.toString()); }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 4)\n\tvoid foo(@Nullable String s, @NonNull Object o, @NonNull Object third) { System.out.print(o.toString()); }\n\t                             ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter o, inherited method from Lib declares this parameter as @Nullable\n----------\n2. ERROR in X.java (at line 4)\n\tvoid foo(@Nullable String s, @NonNull Object o, @NonNull Object third) { System.out.print(o.toString()); }\n\t                                                ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter third, inherited method from Lib does not constrain this parameter\n----------\n");
    }

    public void test_parameter_specification_inheritance_002() {
        this.runConformTest(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    void foo(@Nullable Object o) { }\n}\n"}, "", this.LIBS, false, null);
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "public class X extends Lib {\n    @Override\n    void foo(Object o) {\n        System.out.print(o.toString());\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo(Object o) {\n\t         ^^^^^^\nMissing nullable annotation: inherited method from Lib specifies this parameter as @Nullable\n----------\n");
    }

    public void test_parameter_specification_inheritance_003() {
        this.runConformTest(new String[]{"IX.java", "import org.eclipse.jdt.annotation.*;\npublic interface IX {\n    void foo(@NonNull String s, @NonNull Object o);\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\npublic class X implements IX {\n    public void foo(@NonNull String s, @Nullable Object o) { ; }\n    void bar() { foo(\"OK\", null); }\n}\n"}, "", this.LIBS, false, null);
    }

    public void test_parameter_specification_inheritance_004() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n    void foo(Object o, Object other);\n}\n"});
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X implements IX {\n    public void foo(@NonNull Object o, @Nullable Object other) { System.out.print(o.toString()); }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(@NonNull Object o, @Nullable Object other) { System.out.print(o.toString()); }\n\t                ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter o, inherited method from IX does not constrain this parameter\n----------\n");
    }

    public void test_parameter_specification_inheritance_005() {
        this.runConformTestWithLibs(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    @NonNull Object getObject() { return new Object(); }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X extends Lib {\n    @Override\n    @Nullable Object getObject() { return null; }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 4)\n\t@Nullable Object getObject() { return null; }\n\t^^^^^^^^^^^^^^^^\nThe return type is incompatible with the @NonNull return from Lib.getObject()\n----------\n");
    }

    public void test_parameter_specification_inheritance_006() {
        this.runConformTest(new String[]{"Lib.java", "public class Lib {\n    Object getObject() { return null; }\n}\n"});
        this.runConformTestWithLibs(false, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X extends Lib {\n    @Override\n    @Nullable Object getObject() { return null; }\n}\n"}, null, "");
    }

    public void test_parameter_specification_inheritance_007() {
        this.runConformTestWithLibs(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    @NonNull Object getObject() { return new Object(); }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "public class X extends Lib {\n    @Override\n    Object getObject() { return null; }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 3)\n\tObject getObject() { return null; }\n\t^^^^^^\nThe return type is incompatible with the @NonNull return from Lib.getObject()\n----------\n");
    }

    public void test_parameter_specification_inheritance_007a() {
        this.runConformTestWithLibs(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    @NonNull Object getObject() { return new Object(); }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X extends Lib {\n    @Override\n    @NonNull Object getObject() { return null; }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 4)\n\t@NonNull Object getObject() { return null; }\n\t                                     ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_parameter_specification_inheritance_008() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void printObject(@NonNull Object o) { System.out.print(o.toString()); }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"XSub.java", "public class XSub extends X {\n    @Override\n    public void printObject(Object o) { super.printObject(o); }\n}\n", "M.java", "public class M{\n    void foo(X x, Object o) {\n        x.printObject(o);\n    }\n}\n"}, options, "----------\n1. WARNING in XSub.java (at line 3)\n\tpublic void printObject(Object o) { super.printObject(o); }\n\t                        ^^^^^^\nMissing non-null annotation: inherited method from X specifies this parameter as @NonNull\n----------\n2. ERROR in XSub.java (at line 3)\n\tpublic void printObject(Object o) { super.printObject(o); }\n\t                                                      ^\n" + this.nullTypeSafety() + "The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object'\n" + "----------\n" + "----------\n" + "1. ERROR in M.java (at line 3)\n" + "\tx.printObject(o);\n" + "\t              ^\n" + this.nullTypeSafety() + "The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object'\n" + "----------\n");
    }

    public void test_parameter_specification_inheritance_009() {
        this.runConformTestWithLibs(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    @NonNull static Object getObject() { return new Object(); }\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\npublic class X extends Lib {\n    @Nullable static Object getObject() { return null; }\n}\n"}, null, "");
    }

    public void test_parameter_specification_inheritance_010() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runConformTestWithLibs(new String[]{"p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    protected String getString(String s) {\n        if (Character.isLowerCase(s.charAt(0)))\n\t        return getString(s);\n\t     return s;\n    }\n}\n", "p1/Y.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y extends X {\n    @Override\n    protected String getString(String s) {\n\t     return super.getString(s);\n    }\n}\n"}, customOptions, "");
    }

    public void test_parameter_specification_inheritance_011() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    protected String getString(String s) {\n        if (Character.isLowerCase(s.charAt(0)))\n\t        return getString(s);\n\t     return s;\n    }\n}\n", "p1/Y.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y extends X {\n    @Override\n    protected String getString(String s) {\n\t     return super.getString(null);\n    }\n}\n"}, customOptions, "----------\n1. ERROR in p1\\Y.java (at line 7)\n\treturn super.getString(null);\n\t                       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void test_parameter_specification_inheritance_012() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runConformTestWithLibs(new String[]{"p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n    public @Nullable String getString(String s1, @Nullable String s2, @NonNull String s3) {\n\t     return s1;\n    }\n}\n", "p1/IY.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic interface IY {\n    @NonNull String getString(@NonNull String s1, @NonNull String s2, @Nullable String s3);\n}\n", "p1/Y.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic class Y extends X implements IY {\n    @Override\n    public @NonNull String getString(@Nullable String s1, @Nullable String s2, @Nullable String s3) {\n\t     return \"\";\n    }\n}\n"}, customOptions, "");
    }

    public void test_parameter_specification_inheritance_013() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n    public @Nullable String getString(String s1, @Nullable String s2, @NonNull String s3) {\n\t     return s1;\n    }\n}\n", "p1/IY.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic interface IY {\n    @NonNull String getString(@NonNull String s1, @NonNull String s2, @Nullable String s3);\n}\n", "p1/Y.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic class Y extends X implements IY {\n    @Override\n    public @Nullable String getString(String s1, @NonNull String s2, @NonNull String s3) {\n\t     return \"\";\n    }\n}\n"}, customOptions, "----------\n1. ERROR in p1\\Y.java (at line 5)\n\tpublic @Nullable String getString(String s1, @NonNull String s2, @NonNull String s3) {\n\t       ^^^^^^^^^^^^^^^^\nThe return type is incompatible with the @NonNull return from IY.getString(String, String, String)\n----------\n2. ERROR in p1\\Y.java (at line 5)\n\tpublic @Nullable String getString(String s1, @NonNull String s2, @NonNull String s3) {\n\t                                             ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter s2, inherited method from X declares this parameter as @Nullable\n----------\n3. ERROR in p1\\Y.java (at line 5)\n\tpublic @Nullable String getString(String s1, @NonNull String s2, @NonNull String s3) {\n\t                                                                 ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter s3, inherited method from IY declares this parameter as @Nullable\n----------\n");
    }

    public void test_parameter_specification_inheritance_014() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"p1/IY.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic interface IY {\n    public @NonNull String getString1(String s);\n    public @NonNull String getString2(String s);\n    public String getString3(@Nullable String s);\n    public @NonNull String getString4(@Nullable String s);\n    public @NonNull String getString5(@Nullable String s);\n    public @Nullable String getString6(@NonNull String s);\n}\n", "p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n    public @Nullable String getString1(String s) {\n\t     return s;\n    }\n    public String getString2(String s) {\n\t     return s;\n    }\n    public String getString3(String s) {\n\t     return \"\";\n    }\n    public @NonNull String getString4(@Nullable String s) {\n\t     return \"\";\n    }\n    public @NonNull String getString5(@NonNull String s) {\n\t     return s;\n    }\n    public @NonNull String getString6(@Nullable String s) {\n\t     return \"\";\n    }\n}\n", "p1/Y.java", "package p1;\npublic class Y extends X implements IY {\n}\n"}, customOptions, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in p1\\Y.java (at line 2)\n\tpublic class Y extends X implements IY {\n\t             ^\nThe method getString1(String) from X cannot implement the corresponding method from IY due to incompatible nullness constraints\n----------\n2. ERROR in p1\\Y.java (at line 2)\n\tpublic class Y extends X implements IY {\n\t             ^\nThe method getString2(String) from X cannot implement the corresponding method from IY due to incompatible nullness constraints\n----------\n3. ERROR in p1\\Y.java (at line 2)\n\tpublic class Y extends X implements IY {\n\t             ^\nThe method getString5(String) from X cannot implement the corresponding method from IY due to incompatible nullness constraints\n----------\n4. ERROR in p1\\Y.java (at line 2)\n\tpublic class Y extends X implements IY {\n\t             ^\nThe method getString3(String) from X cannot implement the corresponding method from IY due to incompatible nullness constraints\n----------\n" : "----------\n1. ERROR in p1\\Y.java (at line 2)\n\tpublic class Y extends X implements IY {\n\t             ^\nThe method @Nullable String getString1(String) from X cannot implement the corresponding method from IY due to incompatible nullness constraints\n----------\n2. ERROR in p1\\Y.java (at line 2)\n\tpublic class Y extends X implements IY {\n\t             ^\nThe method String getString2(String) from X cannot implement the corresponding method from IY due to incompatible nullness constraints\n----------\n3. ERROR in p1\\Y.java (at line 2)\n\tpublic class Y extends X implements IY {\n\t             ^\nThe method getString5(@NonNull String) from X cannot implement the corresponding method from IY due to incompatible nullness constraints\n----------\n4. ERROR in p1\\Y.java (at line 2)\n\tpublic class Y extends X implements IY {\n\t             ^\nThe method getString3(String) from X cannot implement the corresponding method from IY due to incompatible nullness constraints\n----------\n");
    }

    public void test_parameter_specification_inheritance_015() {
        this.runConformTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void foo(@NonNull String s) { System.out.println(s); }\n}\n", "XSub.java", "import org.eclipse.jdt.annotation.*;\npublic class XSub extends X {\n    public void foo(String s) { if (s != null) super.foo(s); }\n    void bar() { foo(null); }\n}\n"}, "", this.LIBS, false, null);
    }

    public void test_parameter_specification_inheritance_016() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void foo(@NonNull String s) { System.out.println(s); }\n}\n", "XSub.java", "public class XSub extends X {\n    @Override\n    public void foo(String s) { if (s != null) super.foo(s); }\n    void bar() { foo(null); }\n}\n"}, options, "----------\n1. ERROR in XSub.java (at line 3)\n\tpublic void foo(String s) { if (s != null) super.foo(s); }\n\t                ^^^^^^\nMissing non-null annotation: inherited method from X specifies this parameter as @NonNull\n----------\n");
    }

    public void test_parameter_specification_inheritance_017() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "public class X {\n    public void foo(String s) { System.out.println(s); }\n}\n", "IX.java", "import org.eclipse.jdt.annotation.*;\npublic interface IX {\n    void foo(@NonNull String s);\n}\n", "XSub.java", "public class XSub extends X implements IX {\n    void bar() { foo(null); }\n    static void zork(XSub sub) {\n        sub.foo(null);\n    }\n}\n"}, "----------\n1. WARNING in XSub.java (at line 1)\n\tpublic class XSub extends X implements IX {\n\t             ^^^^\nMissing non-null annotation: inherited method from IX specifies this parameter as @NonNull\n----------\n");
    }

    public void test_parameter_specification_inheritance_018() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped", "ignore");
        this.runConformTestWithLibs(new String[]{"X.java", "public class X {\n    public void foo(String s) { System.out.println(s); }\n}\n", "IX.java", "import org.eclipse.jdt.annotation.*;\npublic interface IX {\n    void foo(@NonNull String s);\n}\n", "XSub.java", "public class XSub extends X implements IX {\n    void bar() { foo(null); }\n    static void zork(XSub sub) {\n        sub.foo(null);\n    }\n}\n"}, options, "");
    }

    public void test_nullable_return_001() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object getObject() { return null; }\n    void foo() {\n        Object o = getObject();\n        System.out.print(o.toString());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tSystem.out.print(o.toString());\n\t                 ^\nPotential null pointer access: The variable o may be null at this location\n----------\n");
    }

    public void test_nullable_return_002() {
        this.runConformTestWithLibs(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    @Nullable Object getObject() { return null; }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "public class X {\n    void foo(Lib l) {\n        Object o = l.getObject();\n        System.out.print(o.toString());\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 4)\n\tSystem.out.print(o.toString());\n\t                 ^\nPotential null pointer access: The variable o may be null at this location\n----------\n");
    }

    public void test_nonnull_return_001() {
        this.runConformTestWithLibs(new String[]{"Lib.java", "import org.eclipse.jdt.annotation.*;\npublic class Lib {\n    @NonNull Object getObject() { return new Object(); }\n}\n"}, null, "");
        this.runNegativeTestWithLibs(false, new String[]{"X.java", "public class X {\n    void foo(Lib l) {\n        Object o = l.getObject();\n        if (o != null)\n            System.out.print(o.toString());\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 4)\n\tif (o != null)\n\t    ^\nRedundant null check: The variable o cannot be null at this location\n----------\n");
    }

    public void test_nonnull_return_003() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object getObject(boolean b) {\n        if (b)\n            return null;\n        return new Object();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_return_004() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object getObject(@Nullable Object o) {\n        return o;\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 4)\n\treturn o;\n\t       ^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n");
    }

    public void test_nonnull_return_005() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object getObject(@NonNull Object o) {\n        return o;\n    }\n}\n"}, null, "");
    }

    public void test_nonnull_return_006() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object getObject(Object o) {\n        return o;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\treturn o;\n\t       ^\n" + this.nullTypeSafety() + "The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object'\n" + "----------\n");
    }

    public void test_nonnull_return_007() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object getObject() {\n        return null;\n    }\n    void test() {\n        getObject().toString();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tgetObject().toString();\n\t^^^^^^^^^^^\nPotential null pointer access: The method getObject() may return null\n----------\n");
    }

    public void test_nonnull_return_008() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object getObject() {\n        return new Object();\n    }\n    void test() {\n        if (getObject() == null)\n\t\t     throw new RuntimeException();\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 7)\n\tif (getObject() == null)\n\t    ^^^^^^^^^^^\n" + this.checkAlwaysFalse_method_cannot_return_null("getObject()", "Object") + "----------\n" + "2. WARNING in X.java (at line 8)\n" + "\tthrow new RuntimeException();\n" + "\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n" + "Dead code\n" + "----------\n");
    }

    public void test_nonnull_return_009() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object getObject() {\n        return new Object();\n    }\n    void test() {\n        Object left = null;\n        if (left != getObject())\n\t\t     throw new RuntimeException();\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 8)\n\tif (left != getObject())\n\t    ^^^^\nRedundant null check: The variable left can only be null at this location\n----------\n2. ERROR in X.java (at line 8)\n\tif (left != getObject())\n\t            ^^^^^^^^^^^\n" + this.redundantCheck_method_cannot_return_null("getObject()", "Object") + "----------\n");
    }

    public void test_nonnull_return_009a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object getObject() {\n        return new Object();\n    }\n    void test() {\n        Object left = null;\n        for (int i=0; i<3; i++) {\n            if (left != getObject())\n\t    \t     throw new RuntimeException();\n            left = new Object();\n        }\n    }\n}\n"}, customOptions, "");
    }

    public void _test_nonnull_return_009b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object getObject() {\n        return new Object();\n    }\n    void test() {\n        Object left = null;\n        for (int i=0; i<3; i++) {\n            if (left != getObject())\n\t    \t     throw new RuntimeException();\n            // left remains null\n        }\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 9)\n\tif (left != getObject())\n\t    ^^^^\n" + this.redundant_check_canonlynull("The variable left", "Object") + "----------\n" + "2. ERROR in X.java (at line 9)\n" + "\tif (left != getObject())\n" + "\t            ^^^^^^^^^^^\n" + "Redundant null check: The method getObject() cannot return null\n" + "----------\n");
    }

    public void test_nonnull_return_010() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable X getX() {\n        return new X();\n    }\n    void test() {\n        X left = this;\n        do {\n            if (left == null) \n\t   \t         throw new RuntimeException();\n        } while ((left = left.getX()) != null);\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 9)\n\tif (left == null) \n\t    ^^^^\nNull comparison always yields false: The variable left cannot be null at this location\n----------\n");
    }

    public void test_nonnull_return_011() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    Object getObject(Object dubious) {\n        if (dubious == null)\n            return dubious;\n        return new Object();\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 5)\n\tif (dubious == null)\n\t    ^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Null comparison always yields false: The variable dubious is specified as @NonNull\n" : "Redundant null check: comparing '@NonNull Object' against null\n") + "----------\n" + "2. WARNING in X.java (at line 6)\n" + "\treturn dubious;\n" + "\t^^^^^^^^^^^^^^^\n" + "Dead code\n" + "----------\n");
    }

    public void _test_nonnull_return_012() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    Object getObject(Object dubious) {\n        return dubious == null ? dubious : null;\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 5)\n\treturn dubious == null ? dubious : null;\n\t       ^^^^^^^\nNull comparison always yields false: The variable dubious cannot be null at this location\n----------\n2. ERROR in X.java (at line 5)\n\treturn dubious == null ? dubious : null;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_return_013() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    void getObject() {}\n}\n", "Y.java", "public class Y extends X {\n    @Override\n    void getObject() {}\n}\n"}, customOptions, "");
    }

    public void test_nonnull_return_014() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X {\n\t@NonNull\n\tpublic Object foo(Object x, int y) {\n\t\t@NonNull Object local;\n\t\twhile (true) {\n\t\t\tif (y == 4) {\n\t\t\t\tlocal = x;  // error\n\t\t\t\treturn x;   // only a warning.\n\t\t\t}\n\t\t\tx = null;\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tlocal = x;  // error\n\t        ^\nNull type mismatch: required '@NonNull Object' but the provided value is inferred as @Nullable\n----------\n2. ERROR in X.java (at line 10)\n\treturn x;   // only a warning.\n\t       ^\nNull type mismatch: required '@NonNull Object' but the provided value is inferred as @Nullable\n----------\n");
    }

    public void test_suppress_001() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @SuppressWarnings(\"null\")\n    @NonNull Object getObject(@Nullable Object o) {\n        return o;\n    }\n}\n"}, customOptions, "");
    }

    public void test_annotation_import_001() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        this.runConformTestWithLibs(new String[]{"org/foo/Nullable.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface Nullable {\n}\n", "org/foo/NonNull.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}\n", "Lib.java", "public class Lib {\n    @org.foo.NonNull Object getObject() { return new Object(); }\n}\n", "X.java", "import org.foo.NonNull;\npublic class X {\n    @NonNull Object getObject(@NonNull Lib l) {\n        return l.getObject();\n    }\n}\n"}, customOptions, "");
    }

    public void test_annotation_import_002() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        this.runConformTest(new String[]{"org/foo/Nullable.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface Nullable {\n}\n", "org/foo/NonNull.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}\n", "Lib.java", "import org.foo.NonNull;\npublic class Lib {\n    @NonNull Object getObject() { return new Object(); }\n}\n", "X.java", "import org.foo.NonNull;\npublic class X {\n    @NonNull Object getObject(@org.foo.Nullable String dummy, @NonNull Lib l) {\n        Object o = l.getObject();        return o;\n    }\n}\n"}, customOptions, "");
    }

    public void test_annotation_import_005() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.MayBeNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.MustNotBeNull");
        this.runNegativeTest(true, new String[]{"org/foo/MayBeNull.java", "package org.foo;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n" + this.targetTypeUseIfAvailable() + "public @interface MayBeNull {}\n", "org/foo/MustNotBeNull.java", "package org.foo;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n" + this.targetTypeUseIfAvailable() + "public @interface MustNotBeNull {}\n", "Lib.java", "public class Lib {\n    public Object getObject() { return new Object(); }\n}\n", "X.java", "import org.foo.*;\npublic class X {\n    @MustNotBeNull Object getObject(@MustNotBeNull Lib l) {\n        return l.getObject();\n    }\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\treturn l.getObject();\n\t       ^^^^^^^^^^^^^\n" + this.nullTypeSafety() + "The expression of type 'Object' needs unchecked conversion to conform to '@MustNotBeNull Object'\n" + "----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test_annotation_import_006() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.MayBeNull");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.MustNotBeNull");
        this.runNegativeTest(true, new String[]{"Lib.java", "public class Lib {\n    Object getObject() { return new Object(); }\n}\n", "X.java", "public class X {\n    @MustNotBeNull Object getObject(@MustNotBeNull Lib l) {\n        return l.getObject();\n    }\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\t@MustNotBeNull Object getObject(@MustNotBeNull Lib l) {\n\t ^^^^^^^^^^^^^\nMustNotBeNull cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\t@MustNotBeNull Object getObject(@MustNotBeNull Lib l) {\n\t                                 ^^^^^^^^^^^^^\nMustNotBeNull cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test_illegal_annotation_001() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNull public class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@NonNull public class X {\n\t^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "The annotation @NonNull is disallowed for this location\n" : "The nullness annotation 'NonNull' is not applicable at this location\n") + "----------\n", this.LIBS, false);
    }

    public void _test_illegal_annotation_002() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "NichtNull");
        this.runNegativeTestWithLibs(new String[]{"X.java", "public class X {\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t^\nCannot use the unqualified name 'NichtNull' as an annotation name for null specification\n----------\n");
    }

    public void test_illegal_annotation_003() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull void foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@NonNull void foo() {}\n\t^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "The nullness annotation @NonNull is not applicable for the primitive type void\n" : "Type annotation is illegal for a method that returns void\n") + "----------\n", this.LIBS, false);
    }

    public void test_illegal_annotation_003b() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull int foo() { return 1; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@NonNull int foo() { return 1; }\n\t^^^^^^^^\nThe nullness annotation @NonNull is not applicable for the primitive type int\n----------\n", this.LIBS, false);
    }

    public void test_illegal_annotation_004() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid foo(@Nullable int i) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo(@Nullable int i) {}\n\t         ^^^^^^^^^\nThe nullness annotation @Nullable is not applicable for the primitive type int\n----------\n", this.LIBS, false);
    }

    public void test_illegal_annotation_005() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tint foo() {\n       @Nullable int i = 3;\n       return i;\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Nullable int i = 3;\n\t^^^^^^^^^\nThe nullness annotation @Nullable is not applicable for the primitive type int\n----------\n", this.LIBS, false);
    }

    public void test_illegal_annotation_006() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "nullAnn.Nullable");
        this.runNegativeTestWithLibs(new String[]{"p/Test.java", "package p;\nimport nullAnn.*;  // 1 \n\npublic class Test { \n\n        void foo(@nullAnn.Nullable  Object o) {   // 2\n            o.toString();           \n        }\n}"}, customOptions, "----------\n1. ERROR in p\\Test.java (at line 2)\n\timport nullAnn.*;  // 1 \n\t       ^^^^^^^\nThe import nullAnn cannot be resolved\n----------\n2. ERROR in p\\Test.java (at line 6)\n\tvoid foo(@nullAnn.Nullable  Object o) {   // 2\n\t          ^^^^^^^\nnullAnn cannot be resolved to a type\n----------\n");
    }

    public void test_illegal_annotation_007() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"p/Test.java", "package p;\nimport org.eclipse.jdt.annotation.*;\ninterface TestInt{\n\t@NonNull Object foo();\n}\n\npublic class Test { \n\tvoid bar() {\t\tnew TestInt() {\n        \t@org public Object foo() {\n        \t}\n\t\t};\n\t}\n}"}, customOptions, "----------\n1. ERROR in p\\Test.java (at line 9)\n\t@org public Object foo() {\n\t ^^^\norg cannot be resolved to a type\n----------\n2. ERROR in p\\Test.java (at line 9)\n\t@org public Object foo() {\n\t            ^^^^^^\nThe return type is incompatible with the @NonNull return from TestInt.foo()\n----------\n");
    }

    public void test_illegal_annotation_008() {
        this.runNegativeTest(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull X() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@NonNull X() {}\n\t^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "The annotation @NonNull is disallowed for this location\n" : "The nullness annotation 'NonNull' is not applicable at this location\n") + "----------\n", this.LIBS, false);
    }

    public void test_default_nullness_002() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    Object getObject(@Nullable Object o) {\n        return new Object();\n    }\n}\n", "Y.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y extends X {\n    @Override\n    @Nullable Object getObject(Object o) {\n        return o;\n    }\n}\n"}, customOptions, "----------\n1. ERROR in Y.java (at line 5)\n\t@Nullable Object getObject(Object o) {\n\t^^^^^^^^^^^^^^^^\nThe return type is incompatible with the @NonNull return from X.getObject(Object)\n----------\n2. ERROR in Y.java (at line 5)\n\t@Nullable Object getObject(Object o) {\n\t                           ^^^^^^\nIllegal redefinition of parameter o, inherited method from X declares this parameter as @Nullable\n----------\n");
    }

    public void test_default_nullness_003() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    protected Object getObject(@Nullable Object o) {\n        return new Object();\n    }\n}\n", "p2/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p2;\n", "p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y extends p1.X {\n    @Override\n    protected @Nullable Object getObject(@Nullable Object o) {\n        bar(o);\n        return o;\n    }\n\t void bar(Object o2) { }\n}\n"}, customOptions, "----------\n1. ERROR in p2\\Y.java (at line 5)\n\tprotected @Nullable Object getObject(@Nullable Object o) {\n\t          ^^^^^^^^^^^^^^^^\nThe return type is incompatible with the @NonNull return from X.getObject(Object)\n----------\n2. ERROR in p2\\Y.java (at line 6)\n\tbar(o);\n\t    ^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n");
    }

    public void test_default_nullness_003a() {
        Map customOptions = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    protected Object getObject(@Nullable Object o) {\n        return new Object();\n    }\n\t protected void bar(Object o2) { }\n}\n", "p2/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p2;\n"}, customOptions, "");
        this.runNegativeTestWithLibs(false, new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y extends p1.X {\n    @Override\n    protected @Nullable Object getObject(@Nullable Object o) {\n        bar(o);\n        accept(o);\n        return o;\n    }\n    void accept(Object a) {}\n}\n"}, customOptions, "----------\n1. ERROR in p2\\Y.java (at line 5)\n\tprotected @Nullable Object getObject(@Nullable Object o) {\n\t          ^^^^^^^^^^^^^^^^\nThe return type is incompatible with the @NonNull return from X.getObject(Object)\n----------\n2. ERROR in p2\\Y.java (at line 6)\n\tbar(o);\n\t    ^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n" + "3. ERROR in p2\\Y.java (at line 7)\n" + "\taccept(o);\n" + "\t       ^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n");
    }

    public void test_default_nullness_003b() {
        Map customOptions = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"p1/Annot.java", "package p1;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER})\npublic @interface Annot {}\n", "p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    protected @Annot Object getObject(@Annot @Nullable Object o) {\n        return new Object();\n    }\n\t protected @Annot void bar(@Annot Object o2) { }\n}\n", "p2/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p2;\n"}, customOptions, "");
        this.runNegativeTestWithLibs(false, new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y extends p1.X {\n    @Override\n    protected @Nullable Object getObject(@Nullable Object o) {\n        bar(o);\n        accept(o);\n        return o;\n    }\n    void accept(@p1.Annot Object a) {}\n}\n"}, customOptions, "----------\n1. ERROR in p2\\Y.java (at line 5)\n\tprotected @Nullable Object getObject(@Nullable Object o) {\n\t          ^^^^^^^^^^^^^^^^\nThe return type is incompatible with the @NonNull return from X.getObject(Object)\n----------\n2. ERROR in p2\\Y.java (at line 6)\n\tbar(o);\n\t    ^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n" + "3. ERROR in p2\\Y.java (at line 7)\n" + "\taccept(o);\n" + "\t       ^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n");
    }

    public void test_default_nullness_003c() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    protected Object getObject(@Nullable Object o) {\n        return new Object();\n    }\n\t protected void bar(Object o2) { }\n}\n", "p2/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault({org.eclipse.jdt.annotation.DefaultLocation.PARAMETER})\npackage p2;\n"}, customOptions, "");
        this.runNegativeTestWithLibs(false, new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y extends p1.X {\n    @Override\n    protected @Nullable Object getObject(@Nullable Object o) {\n        bar(o);\n        @NonNull Object nno = accept(o); // 2xERR\n        return o;\n    }\n    Object accept(Object a) { return a; }\n}\n"}, customOptions, "----------\n1. ERROR in p2\\Y.java (at line 5)\n\tprotected @Nullable Object getObject(@Nullable Object o) {\n\t          ^^^^^^^^^^^^^^^^\nThe return type is incompatible with the @NonNull return from X.getObject(Object)\n----------\n2. ERROR in p2\\Y.java (at line 6)\n\tbar(o);\n\t    ^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable Object'\n----------\n3. WARNING in p2\\Y.java (at line 7)\n\t@NonNull Object nno = accept(o); // 2xERR\n\t                      ^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object'\n----------\n4. ERROR in p2\\Y.java (at line 7)\n\t@NonNull Object nno = accept(o); // 2xERR\n\t                             ^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable Object'\n----------\n");
    }

    public void test_default_nullness_004() {
        Map customOptions = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    protected Object getObject(boolean o) {\n        return new Object();\n    }\n}\n", "p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y extends p1.X {\n    @Override\n    protected @NonNull Object getObject(boolean o) {\n        return o ? this : new Object();\n    }\n}\n"}, customOptions, "");
    }

    public void test_default_nullness_005() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        this.runNegativeTestWithLibs(new String[]{"p1/X.java", "package p1;\npublic class X {\n    class Inner {        protected Object getObject(String s) {\n            return null;\n        }\n    }\n}\n", "p1/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p1;\n", "org/foo/NonNull.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}\n"}, customOptions, "----------\n1. ERROR in p1\\X.java (at line 4)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_default_nullness_006() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        this.runNegativeTestWithLibs(new String[]{"p1/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p1;\n", "p1/X.java", "package p1;\npublic class X {\n    class Inner {        protected Object getObject(String s) {\n            return null;\n        }\n    }\n}\n", "org/foo/NonNull.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}\n"}, customOptions, "----------\n1. ERROR in p1\\X.java (at line 4)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void _test_default_nullness_007() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object dangerous() {\n        return null;\n    }\n    Object broken() {\n        return dangerous();\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 7)\n\treturn dangerous();\n\t       ^^^^^^^^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is inferred as @Nullable\n----------\n");
    }

    public void test_default_nullness_008() {
        Map customOptions = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"p1/X.java", "package p1;\npublic class X {\n    protected Object getObject(Object o) {\n        return new Object();\n    }\n}\n", "p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y extends p1.X {\n    @Override\n" + this.cancenNonNullByDefault() + "    protected Object getObject(Object o) {\n" + "        if (o.toString().length() == 0)\n" + "\t        return null;\n" + "        return o.toString();\n" + "    }\n" + "}\n"}, customOptions, "");
    }

    public void test_default_nullness_009() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"p1/X.java", "package p1;\npublic class X {\n    protected Object getObject(Object o) {\n        return new Object();\n    }\n}\n", "p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y { \n" + this.cancenNonNullByDefault() + "    static class Z extends p1.X {\n" + "        @Override\n" + "        protected Object getObject(Object o) {\n" + "            if (o.toString().length() == 0) {\n" + "                o = null;\n" + "                bar(o); // error: arg is declared @NonNull\n" + "\t             return null;\n" + "            }\n" + "            return o.toString();\n" + "        }\n" + "        String bar(@NonNull Object o) {\n" + "            return getObject(o).toString();" + "        }\n" + "    }\n" + "}\n"}, customOptions, "----------\n1. ERROR in p2\\Y.java (at line 11)\n\tbar(o); // error: arg is declared @NonNull\n\t    ^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_default_nullness_010() {
        Map customOptions = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y {\n    protected @NonNull Object getObject(@NonNull Object o) {\n        return o;\n    }\n}\n"}, customOptions, "----------\n1. WARNING in p2\\Y.java (at line 5)\n\tprotected @NonNull Object getObject(@NonNull Object o) {\n\t          ^^^^^^^^^^^^^^^\nThe nullness annotation is redundant with a default that applies to this location\n----------\n2. WARNING in p2\\Y.java (at line 5)\n\tprotected @NonNull Object getObject(@NonNull Object o) {\n\t                                    ^^^^^^^^^^^^^^^^^\nThe nullness annotation is redundant with a default that applies to this location\n----------\n");
    }

    public void test_default_nullness_011() {
        this.runNegativeTestWithLibs(new String[]{"Main.java", "import p1.C;\npublic class Main {\n    void test(@org.eclipse.jdt.annotation.NonNull Object o) {\n        o = null;\n        new C(null);\n    }\n}\n", "p1/C.java", "package p1;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class C {\n    public C (Object o) {}\n}\n", "p1/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p1;\n"}, "----------\n1. ERROR in Main.java (at line 4)\n\to = null;\n\t    ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in Main.java (at line 5)\n\tnew C(null);\n\t      ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n----------\n1. WARNING in p1\\C.java (at line 2)\n\t@org.eclipse.jdt.annotation.NonNullByDefault\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing package p1\n----------\n");
    }

    public void test_default_nullness_012() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X {\n    @NonNullByDefault \n    public void foo(@Nullable String [] args) {\n        class local {\n            void zoo(Object o) {\n            }\n        };\n        new local().zoo(null); // defaults applying from foo\n    }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tnew local().zoo(null); // defaults applying from foo\n\t                ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_default_nullness_013() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@SuppressWarnings(\"unused\")\npublic class X {\n    @NonNullByDefault \n    public void foo(@Nullable String [] args) {\n        class local {\n            class Deeply {\n                Object zoo() {\n                    return null; // defaults applying from foo\n                }\n            }\n        };\n    }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\treturn null; // defaults applying from foo\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_default_nullness_014() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@SuppressWarnings(\"unused\")\npublic class X {\n\n    public void foo(@Nullable String [] args) {\n        @NonNullByDefault\n        class local {\n            class Deeply {\n                Object zoo() {\n                    return null;  // expect error here\n                }\n            }\n        };\n    }\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn null;  // expect error here\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_default_nullness_015() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@SuppressWarnings(\"unused\")\n@NonNullByDefault\npublic class X {\n    {\n        class local {\n            class Deeply {\n                Object zoo() {\n                    return null;  // expect error here\n                }\n            }\n        };\n    }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\treturn null;  // expect error here\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_default_nullness_016() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    Object foo;\n    void doFoo() {\n        foo = null;\n    }\n    class Inner {\n        Object iFoo;\n        void diFoo(@Nullable Object arg) {\n            iFoo = arg;\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tObject foo;\n\t       ^^^\nThe @NonNull field foo may not have been initialized\n----------\n2. ERROR in X.java (at line 6)\n\tfoo = null;\n\t      ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n3. ERROR in X.java (at line 9)\n\tObject iFoo;\n\t       ^^^^\nThe @NonNull field iFoo may not have been initialized\n----------\n4. ERROR in X.java (at line 11)\n\tiFoo = arg;\n\t       ^^^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n");
    }

    public void test_default_nullness_017() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNullByDefault\n    Object doFoo() {\n        class Local {\n            Object foo;\n            @NonNull Object goo;\n        };        return new Local();\n    }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 6)\n\tObject foo;\n\t       ^^^\nThe @NonNull field foo may not have been initialized\n----------\n2. WARNING in X.java (at line 7)\n\t@NonNull Object goo;\n\t^^^^^^^^^^^^^^^\nThe nullness annotation is redundant with a default that applies to this location\n----------\n3. ERROR in X.java (at line 7)\n\t@NonNull Object goo;\n\t                ^^^\nThe @NonNull field goo may not have been initialized\n----------\n");
    }

    public void test_redundant_annotation_01() {
        Map customOptions = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y {\n    @NonNullByDefault class Inner {\n        @NonNullByDefault class DeepInner {}\n    }\n    class Inner2 {\n        @NonNullByDefault class DeepInner2 {\n        }\n        void foo() {\n            @SuppressWarnings(\"unused\") @NonNullByDefault class Local {}\n        }\n    }\n}\n@NonNullByDefault class V {}\n", "p3/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault package p3;\n", "p3/Z.java", "package p3;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Z {\n}\nclass X {\n    @NonNullByDefault class Inner {}\n    class Inner2 {\n        @NonNullByDefault class DeepInner {}\n    }\n}\n"}, customOptions, "----------\n1. WARNING in p2\\Y.java (at line 5)\n\t@NonNullByDefault class Inner {\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Y\n----------\n2. WARNING in p2\\Y.java (at line 6)\n\t@NonNullByDefault class DeepInner {}\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Y.Inner\n----------\n3. WARNING in p2\\Y.java (at line 9)\n\t@NonNullByDefault class DeepInner2 {\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Y\n----------\n4. WARNING in p2\\Y.java (at line 12)\n\t@SuppressWarnings(\"unused\") @NonNullByDefault class Local {}\n\t                            ^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Y\n----------\n----------\n1. WARNING in p3\\Z.java (at line 3)\n\t@NonNullByDefault\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing package p3\n----------\n2. WARNING in p3\\Z.java (at line 7)\n\t@NonNullByDefault class Inner {}\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing package p3\n----------\n3. WARNING in p3\\Z.java (at line 9)\n\t@NonNullByDefault class DeepInner {}\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing package p3\n----------\n");
    }

    public void test_redundant_annotation_02() {
        Map customOptions = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y {\n    @NonNullByDefault void foo() {}\n}\nclass Z {\n    @NonNullByDefault void bar() {\n         @NonNullByDefault @SuppressWarnings(\"unused\") class Zork {\n             @NonNullByDefault void fubar() {}\n         }\n    }\n    @NonNullByDefault void zink() {\n         @SuppressWarnings(\"unused\") class Bork {\n             @NonNullByDefault void jubar() {}\n         }\n    }\n}\n"}, customOptions, "----------\n1. WARNING in p2\\Y.java (at line 5)\n\t@NonNullByDefault void foo() {}\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Y\n----------\n2. WARNING in p2\\Y.java (at line 9)\n\t@NonNullByDefault @SuppressWarnings(\"unused\") class Zork {\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing method bar()\n----------\n3. WARNING in p2\\Y.java (at line 10)\n\t@NonNullByDefault void fubar() {}\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Zork\n----------\n4. WARNING in p2\\Y.java (at line 15)\n\t@NonNullByDefault void jubar() {}\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing method zink()\n----------\n");
    }

    public void test_redundant_annotation_02g() {
        Map customOptions = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y<TY> {\n    @NonNullByDefault <TF> void foo(TF arg) {}\n}\nclass Z {\n    @NonNullByDefault <TB> void bar() {\n         @NonNullByDefault @SuppressWarnings(\"unused\") class Zork {\n             @NonNullByDefault void fubar(TB arg) {}\n         }\n    }\n}\n"}, customOptions, "----------\n1. WARNING in p2\\Y.java (at line 5)\n\t@NonNullByDefault <TF> void foo(TF arg) {}\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Y<TY>\n----------\n2. WARNING in p2\\Y.java (at line 9)\n\t@NonNullByDefault @SuppressWarnings(\"unused\") class Zork {\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing method bar()\n----------\n3. WARNING in p2\\Y.java (at line 10)\n\t@NonNullByDefault void fubar(TB arg) {}\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing type Zork\n----------\n");
    }

    public void test_missing_default_annotation_01() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "error");
        this.runNegativeTestWithLibs(new String[]{"Lib.java", "public class Lib {\n    Object getObject() { return new Object(); }\n}\n", "X.java", "public class X {\n\t class XInner{}\n    Object getObject(Lib l) {\n        return l.getObject();\n    }\n}\n"}, customOptions, "----------\n1. ERROR in Lib.java (at line 1)\n\tpublic class Lib {\n\t             ^^^\nA default nullness annotation has not been specified for the type Lib\n----------\n----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t             ^\nA default nullness annotation has not been specified for the type X\n----------\n");
    }

    public void test_missing_default_annotation_02() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "error");
        this.runNegativeTestWithLibs(new String[]{"p2/package-info.java", "package p2;\n", "p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y {\n   void foo() {}\n}\n", "p3/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault package p3;\n", "p3/Z.java", "package p3;\nimport org.eclipse.jdt.annotation.*;\npublic class Z {\n    @NonNullByDefault void bar() {}\n}\n"}, customOptions, "----------\n1. ERROR in p2\\package-info.java (at line 1)\n\tpackage p2;\n\t        ^^\nA default nullness annotation has not been specified for the package p2\n----------\n----------\n1. WARNING in p3\\Z.java (at line 4)\n\t@NonNullByDefault void bar() {}\n\t^^^^^^^^^^^^^^^^^\nNullness default is redundant with a default specified for the enclosing package p3\n----------\n");
    }

    public void test_redundant_annotation_04() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "disabled");
        this.runConformTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Y {\n    @NonNullByDefault class Inner {\n        @NonNullByDefault class DeepInner {}\n    }\n    class Inner2 {\n        @NonNullByDefault class DeepInner2 {\n        }\n        @NonNullByDefault void foo(@Nullable @NonNull Object arg) {\n            @NonNullByDefault class Local {}\n        }\n    }\n}\n@NonNullByDefault class V {}\n", "p3/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault package p3;\n", "p3/Z.java", "package p3;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Z {\n}\nclass X {\n    @NonNullByDefault class Inner {}\n    class Inner2 {\n        @NonNullByDefault class DeepInner {}\n    }\n}\n"}, customOptions, "");
    }

    public void test_contradictory_annotations_01() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y {\n    void foo(@NonNull @Nullable Object o) {}\n    @Nullable @NonNull Object bar() {\n        @NonNull @Nullable Object o = null;\n        return o;\n    }\n}\nclass Z {\n    @NonNullByDefault void bar() {}\n}\n"}, customOptions, "----------\n1. ERROR in p2\\Y.java (at line 4)\n\tvoid foo(@NonNull @Nullable Object o) {}\n\t                  ^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n2. ERROR in p2\\Y.java (at line 5)\n\t@Nullable @NonNull Object bar() {\n\t          ^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n3. ERROR in p2\\Y.java (at line 6)\n\t@NonNull @Nullable Object o = null;\n\t         ^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n");
    }

    public void test_contradictory_annotations_02() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y {\n    @NonNull @Nullable Object o;\n}\n"}, customOptions, "----------\n1. ERROR in p2\\Y.java (at line 4)\n\t@NonNull @Nullable Object o;\n\t         ^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n");
    }

    public void test_contradictory_annotations_03() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y {\n    @NonNull @Nullable Object[] o;\n}\n"}, customOptions, "----------\n1. ERROR in p2\\Y.java (at line 4)\n\t@NonNull @Nullable Object[] o;\n\t         ^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n");
    }

    public void test_nonnull_var_in_constrol_structure_1() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    void print4(@NonNull String s) {\n        for (int i=0; i<4; i++)\n             print(s);\n    }\n    void print5(@Nullable String s) {\n        for (int i=0; i<5; i++)\n             print(s);\n    }\n    void print6(boolean b) {\n        String s = b ? null : \"\";\n        for (int i=0; i<5; i++)\n             print(s);\n    }\n    void print(@NonNull String s) {\n        System.out.print(s);\n    }\n}\n"}, customOptions, "----------\n1. WARNING in X.java (at line 4)\n\tvoid print4(@NonNull String s) {\n\t            ^^^^^^^^^^^^^^^^^\nThe nullness annotation is redundant with a default that applies to this location\n----------\n2. ERROR in X.java (at line 10)\n\tprint(s);\n\t      ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n" + "3. ERROR in X.java (at line 15)\n" + "\tprint(s);\n" + "\t      ^\n" + "Null type mismatch: required '@NonNull String' but the provided value is inferred as @Nullable\n" + "----------\n" + "4. WARNING in X.java (at line 17)\n" + "\tvoid print(@NonNull String s) {\n" + "\t           ^^^^^^^^^^^^^^^^^\n" + "The nullness annotation is redundant with a default that applies to this location\n" + "----------\n");
    }

    public void test_nonnull_var_in_constrol_structure_2() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;@NonNullByDefault\npublic class X {\n    void print4(String s) {\n        try { /*empty*/ } finally {\n             print(s);\n        }\n    }\n    void print5(@Nullable String s) {\n        try { /*empty*/ } finally {\n             print(s);\n        }\n    }\n    void print6(boolean b) {\n        String s = b ? null : \"\";\n        try { /*empty*/ } finally {\n             print(s);\n        }\n    }\n    void print(String s) {\n        System.out.print(s);\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 10)\n\tprint(s);\n\t      ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n" + "2. ERROR in X.java (at line 16)\n" + "\tprint(s);\n" + "\t      ^\n" + "Null type mismatch: required '@NonNull String' but the provided value is inferred as @Nullable\n" + "----------\n");
    }

    public void test_nonnull_var_in_constrol_structure_3() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "ignore");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    void print4(@NonNull String s) {\n        for (int i=0; i<4; i++)\n            try { /*empty*/ } finally {\n                 print(s);\n            }\n    }\n    void print5(@Nullable String s) {\n        for (int i=0; i<5; i++)\n            try { /*empty*/ } finally {\n                 print(s);\n            }\n    }\n    void print6(boolean b) {\n        String s = b ? null : \"\";\n        for (int i=0; i<4; i++)\n            try { /*empty*/ } finally {\n                 print(s);\n            }\n    }\n    void print(@NonNull String s) {\n        System.out.print(s);\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 12)\n\tprint(s);\n\t      ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n" + "2. ERROR in X.java (at line 19)\n" + "\tprint(s);\n" + "\t      ^\n" + "Null type mismatch: required '@NonNull String' but the provided value is inferred as @Nullable\n" + "----------\n");
    }

    public void test_message_send_in_control_structure_01() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "warning");
        this.runNegativeTestWithLibs(new String[]{"p/Scope.java", "package p;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic abstract class Scope {\n\tpublic ReferenceBinding findMemberType(char[] typeName, ReferenceBinding enclosingType) {\n\t\tReferenceBinding enclosingSourceType = enclosingSourceType();\n\t\tPackageBinding currentPackage = getCurrentPackage();\n\t\tCompilationUnitScope unitScope = compilationUnitScope();\n\t\tReferenceBinding memberType = enclosingType.getMemberType(typeName);\n\t\tReferenceBinding currentType = enclosingType;\n\t\tReferenceBinding[] interfacesToVisit = null;\n\t\twhile (true) {\n\t\t\tReferenceBinding[] itsInterfaces = currentType.superInterfaces();\n\t\t\tif (itsInterfaces != null) {\n\t\t\t\tif (interfacesToVisit == null) {\n\t\t\t\t\tinterfacesToVisit = itsInterfaces;\n\t\t\t\t}\n\t\t\t}\n\t\t\tunitScope.recordReference(currentType, typeName);\n\t\t\t\n\t\t\tif ((memberType = currentType.getMemberType(typeName)) != null) {\n\t\t\t\tif (enclosingSourceType == null\n\t\t\t\t\t? memberType.canBeSeenBy(currentPackage)\n\t\t\t\t\t: memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {\n\t\t\t\t\t\treturn memberType;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tprivate CompilationUnitScope compilationUnitScope() {\n\t\treturn compilationUnitScope();\n\t}\n\tprivate PackageBinding getCurrentPackage() {\n\t\treturn getCurrentPackage();\n\t}\n\tprivate ReferenceBinding enclosingSourceType() {\n\t\treturn enclosingSourceType();\n\t}\n}\n", "p/CompilationUnitScope.java", "package p;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class CompilationUnitScope {\n    void recordReference(ReferenceBinding rb, char[] name) {}\n}\n", "p/PackageBinding.java", "package p;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class PackageBinding {\n}\n", "p/ReferenceBinding.java", "package p;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class ReferenceBinding {\n    ReferenceBinding getMemberType(char[] name) { return this; }\n    ReferenceBinding[] superInterfaces() { return new ReferenceBinding[0]; }\n    boolean canBeSeenBy(PackageBinding ob) { return true; }\n    boolean canBeSeenBy(ReferenceBinding rb, ReferenceBinding rb2) { return true; }\n}\n"}, customOptions, "----------\n1. ERROR in p\\Scope.java (at line 13)\n\tif (itsInterfaces != null) {\n\t    ^^^^^^^^^^^^^\nRedundant null check: The variable itsInterfaces cannot be null at this location\n----------\n2. ERROR in p\\Scope.java (at line 20)\n\tif ((memberType = currentType.getMemberType(typeName)) != null) {\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nRedundant null check: The variable memberType cannot be null at this location\n----------\n3. ERROR in p\\Scope.java (at line 21)\n\tif (enclosingSourceType == null\n\t    ^^^^^^^^^^^^^^^^^^^\nNull comparison always yields false: The variable enclosingSourceType cannot be null at this location\n----------\n");
    }

    public void test_message_send_in_control_structure_02() {
        this.runNegativeTestWithLibs(new String[]{"Bug370930.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Bug370930 {\n\tvoid loop(Collection<String> list) {\n\t\tfor(@NonNull String s: list) { // warning here: insufficient info on elements\n\t\t\texpectNonNull(s); // no warning here\n\t\t}\n\t}\n\t\n\tvoid expectNonNull(@NonNull String s) {}\n}\n"}, "----------\n1. WARNING in Bug370930.java (at line 5)\n\tfor(@NonNull String s: list) { // warning here: insufficient info on elements\n\t                       ^^^^\n" + this.nullTypeSafety() + "The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n" + "----------\n");
    }

    public void test_message_send_in_control_structure_02a() {
        this.runNegativeTestWithLibs(new String[]{"Bug370930.java", "import org.eclipse.jdt.annotation.*;\npublic class Bug370930 {\n\tvoid loop(String[] array) {\n\t\tfor(@NonNull String s: array) { // warning here: insufficient info on elements\n\t\t\texpectNonNull(s); // no warning here\n\t\t}\n\t}\n\t\n\tvoid expectNonNull(@NonNull String s) {}\n}\n"}, "----------\n1. WARNING in Bug370930.java (at line 4)\n\tfor(@NonNull String s: array) { // warning here: insufficient info on elements\n\t                       ^^^^^\n" + this.nullTypeSafety() + "The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n" + "----------\n");
    }

    public void test_message_send_in_control_structure_03() {
        this.runNegativeTestWithLibs(new String[]{"Bug370930.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Bug370930 {\n\tvoid loop(Collection<String> list) {\n\t\tfor(@Nullable String s: list) {\n\t\t\texpectNonNull(s); // warning here\n\t\t}\n\t}\n\t\n\tvoid expectNonNull(@NonNull String s) {}\n}\n"}, "----------\n1. ERROR in Bug370930.java (at line 6)\n\texpectNonNull(s); // warning here\n\t              ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n");
    }

    public void test_assignment_expression_1() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@Nullable Object foo() {\n\t\tObject o = null;\n\t\tboolean keepLooking = true;\n\t\twhile(keepLooking) {\n\t\t\tif ((o=getO()) != null) {\n\t\t\t\treturn o;\n\t\t\t}\n\t\t}\n\t\treturn null;\n\t}\n\n\tprivate @Nullable Object getO() {\n\t\treturn new Object();\n\t}\n}\n"}, customOptions, "");
    }

    public void test_nesting_1() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    void print4(final String s1) {\n        for (int i=0; i<3; i++)\n            new Runnable() {\n                public void run() {\n                     print(s1);\n                }\n            }.run();\n    }\n    void print8(final @Nullable String s2) {\n        for (int i=0; i<3; i++)\n            new Runnable() {\n                public void run() {\n                     print(s2);\n                }\n            }.run();\n    }\n    void print16(boolean b) {\n        final String s3 = b ? null : \"\";\n        for (int i=0; i<3; i++)\n            new Runnable() {\n                public void run() {\n                     @NonNull String s3R = s3;\n                }\n            }.run();\n    }\n    void print(String s) {\n        System.out.print(s);\n    }\n}\n"}, customOptions, "----------\n1. ERROR in X.java (at line 16)\n\tprint(s2);\n\t      ^^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n" + "2. ERROR in X.java (at line 25)\n" + "\t@NonNull String s3R = s3;\n" + "\t                      ^^\n" + "Null type mismatch: required '@NonNull String' but the provided value is inferred as @Nullable\n" + "----------\n");
    }

    public void test_constructor_with_nested_class() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    final Object o1;\n    final Object o2;\n    public X() {\n         this.o1 = new Object() {\n             public String toString() { return \"O1\"; }\n         };\n         this.o2 = new Object();    }\n}\n"}, "");
    }

    public void test_options_01() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runConformTestWithLibs(new String[]{"ContainingInner2.java", "public class ContainingInner2 {\n    public ContainingInner2 (@org.eclipse.jdt.annotation.NonNull Object o) {\n    }\n    public class Inner {\n        public <T> Inner (@org.eclipse.jdt.annotation.NonNull T o) {\n        }\n    }\n}\n"}, null, "");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "disabled");
        this.runConformTestWithLibs(false, new String[]{"X.java", "public class X {\n\t void create() {\n          ContainingInner2 container = new ContainingInner2(null);\n\t       ContainingInner2.Inner inner = container.new Inner(null);\n    }\n}\n"}, customOptions, "");
    }

    public void test_options_02() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "ignore");
        this.runNegativeTestWithLibs(new String[]{"Test.java", "public class Test {\n    public void foo(@org.eclipse.jdt.annotation.NonNull Object o) {\n        o = null;\n        Object p = o;\n        if (p == null)\n            p.toString();\n    }\n}\n"}, customOptions, "----------\n1. ERROR in Test.java (at line 3)\n\to = null;\n\t    ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in Test.java (at line 5)\n\tif (p == null)\n\t    ^\nNull comparison always yields false: The variable p cannot be null at this location\n----------\n3. WARNING in Test.java (at line 6)\n\tp.toString();\n\t^^^^^^^^^^^^\nDead code\n----------\n");
    }

    public void test_options_03() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "warning");
        this.runNegativeTestWithLibs(new String[]{"Test.java", "public class Test {\n    public void foo(@org.eclipse.jdt.annotation.NonNull Object o) {\n        o = null;\n        Object p = o;\n        if (p == null)\n            p.toString();\n    }\n}\n"}, customOptions, "----------\n1. WARNING in Test.java (at line 3)\n\to = null;\n\t    ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in Test.java (at line 5)\n\tif (p == null)\n\t    ^\nNull comparison always yields false: The variable p cannot be null at this location\n----------\n3. WARNING in Test.java (at line 6)\n\tp.toString();\n\t^^^^^^^^^^^^\nDead code\n----------\n");
    }

    public void test_nonnull_field_1() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object o = new Object();\n    public String oString() {\n         return o.toString();\n    }\n}\n"}, null, "");
    }

    public void test_nonnull_field_2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object o;\n    public String oString() {\n         return o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 3)\n\t@NonNull Object o;\n\t                ^\nThe @NonNull field o may not have been initialized\n----------\n");
    }

    public void test_nonnull_field_2a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object o;\n    X (boolean b) { // only potentially initialized\n        if (b)\n            o = this;\n    }\n    X (@NonNull Object other) {\n        o = other;\n    }\n    public String oString() {\n        return o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 4)\n\tX (boolean b) { // only potentially initialized\n\t^^^^^^^^^^^^^\nThe @NonNull field o may not have been initialized\n----------\n");
    }

    public void test_nonnull_field_2b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nenum Color { BLACK, GREEN }\npublic class X {\n    @NonNull Object o;\n    X (Color c) { // only potentially initialized\n        switch (c) {\n            case BLACK: o = this; break;\n            case GREEN: o = new Object(); break;\n        }\n    }\n    public String oString() {\n        return o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\tX (Color c) { // only potentially initialized\n\t^^^^^^^^^^^\nThe @NonNull field o may not have been initialized. Note that a problem regarding missing 'default:' on 'switch' has been suppressed, which is perhaps related to this problem\n----------\n");
    }

    public void test_nonnull_field_2c() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    static @NonNull Object o;\n    static {\n        if (new Object().hashCode() == 42)\n            o = new Object();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 3)\n\tstatic @NonNull Object o;\n\t                       ^\nThe @NonNull field o may not have been initialized\n----------\n");
    }

    public void test_nonnull_field_2d() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    static @NonNull Object o;\n    static {\n         o = new Object();\n    }\n}\n"}, null, "");
    }

    public void test_nonnull_field_2e() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X<T> {\n    @NonNull Object f;\n    {\n         this.f = new Object();\n    }\n}\n"}, null, "");
    }

    public void test_nonnull_field_3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object o = null;\n    public String oString() {\n         return o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 3)\n\t@NonNull Object o = null;\n\t                    ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_field_4() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object o = new Object();\n    void breakIt1() {\n         o = null;\n    }\n    void breakIt2() {\n         this.o = null;\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\to = null;\n\t    ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in X.java (at line 8)\n\tthis.o = null;\n\t         ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nonnull_field_5() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object o = new Object();\n    boolean checkIt1() {\n         return o == null;\n    }\n    boolean checkIt() {\n         return this.o != null;\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\treturn o == null;\n\t       ^\n" + this.checkAlwaysFalse_nonnull("The field o", "Object") + "----------\n" + "2. ERROR in X.java (at line 8)\n" + "\treturn this.o != null;\n" + "\t            ^\n" + this.redundant_check_nonnull("The field o", "@NonNull Object") + "----------\n");
    }

    public void test_nonnull_field_6() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Object o = new Object();\n    boolean checkIt1() {\n         if (o != null)\n             System.out.print(\"not null\");\n         System.out.print(\"continue\");\n         return this.o == null;\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\tif (o != null)\n\t    ^\n" + this.redundant_check_nonnull("The field o", "@NonNull Object") + "----------\n" + "2. ERROR in X.java (at line 8)\n" + "\treturn this.o == null;\n" + "\t            ^\n" + this.checkAlwaysFalse_nonnull("The field o", "Object") + "----------\n");
    }

    public void test_nonnull_field_7() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nclass Objects {\n    static @NonNull Object o = new Object();\n}\npublic class X {\n    @NonNull Object getIt1() {\n         if (Objects.o != null) // redundant\n             System.out.print(\"not null\");\n         System.out.print(\"continue\");\n         return Objects.o;\n    }\n    @NonNull Object getIt2() {\n         if (null != Objects.o) // redundant\n             System.out.print(\"not null\");\n         System.out.print(\"continue\");\n         return Objects.o;\n    }\n    String getIt3() {\n         return Objects.o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 7)\n\tif (Objects.o != null) // redundant\n\t            ^\n" + this.redundant_check_nonnull("The field o", "@NonNull Object") + "----------\n" + "2. ERROR in X.java (at line 13)\n" + "\tif (null != Objects.o) // redundant\n" + "\t                    ^\n" + this.redundant_check_nonnull("The field o", "@NonNull Object") + "----------\n");
    }

    public void test_nonnull_field_8() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nclass Objects {\n    @NonNull Object o = new Object();\n}\npublic class X {\n    @NonNull Object getIt1(@NonNull Objects objs) {\n         if (objs.o == null) // always false\n             System.out.print(\"not null\");\n         System.out.print(\"continue\");\n         return objs.o;\n    }\n    String getIt2(@NonNull Objects objs) {\n         return objs.o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 7)\n\tif (objs.o == null) // always false\n\t         ^\n" + this.checkAlwaysFalse_nonnull("The field o", "Object") + "----------\n" + "2. WARNING in X.java (at line 8)\n" + "\tSystem.out.print(\"not null\");\n" + "\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n" + "Dead code\n" + "----------\n");
    }

    public void test_nonnull_field_9() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nclass Objects {\n    @NonNull Object o = new Object();\n}\npublic class X {\n    Objects objs = new Objects();\n    @NonNull Object getIt1() {\n         if (this.objs.o != null) // redundant\n             System.out.print(\"not null\");\n         System.out.print(\"continue\");\n         if (getObjs().o != null) // redundant\n             System.out.print(\"not null\");\n         return this.objs.o;\n    }\n    Objects getObjs() { return this.objs; }\n    String getIt2() {\n         return this.objs.o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 8)\n\tif (this.objs.o != null) // redundant\n\t              ^\n" + this.redundant_check_nonnull("The field o", "@NonNull Object") + "----------\n" + "2. ERROR in X.java (at line 11)\n" + "\tif (getObjs().o != null) // redundant\n" + "\t              ^\n" + this.redundant_check_nonnull("The field o", "@NonNull Object") + "----------\n");
    }

    public void test_nonnull_field_11() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nclass Objects {\n    @NonNull Object o = new Object();\n    void test0(@Nullable Object x) {\n         o = x;\n    }\n}\npublic class X {\n    void test(@NonNull Objects objs) {\n         objs.o = null;\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\to = x;\n\t    ^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n" + "2. ERROR in X.java (at line 10)\n" + "\tobjs.o = null;\n" + "\t         ^^^^\n" + "Null type mismatch: required '@NonNull Object' but the provided value is null\n" + "----------\n");
    }

    public void test_nonnull_field_12() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull int o = 1;\n}\n"}, null, "----------\n1. ERROR in X.java (at line 3)\n\t@NonNull int o = 1;\n\t^^^^^^^^\nThe nullness annotation @NonNull is not applicable for the primitive type int\n----------\n");
    }

    public void _test_nonnull_field_13() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    final String s1 = \"\";\n    @NonNull String s2;\n    X() {\n        s2 = s1;\n    }\n}\n"}, null, "");
    }

    public void test_nonnull_field_14() {
        this.runConformTestWithLibs(new String[]{"p1/X.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n    public String s1 = \"\";\n}\n"}, null, "");
        this.runConformTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\nimport p1.X;\npublic class Y {\n    @NonNull String s2 = \"\";\n    void foo(X other) {\n        s2 = other.s1;\n    }\n}\n"}, null, "");
    }

    public void test_nonnull_field_14b() {
        this.runConformTestWithLibs(new String[]{"p1/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p1;\n", "p1/X.java", "package p1;\npublic class X {\n    public String s1 = \"\";\n}\n"}, null, "");
        this.runConformTestWithLibs(new String[]{"p2/Y.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\nimport p1.X;\npublic class Y {\n    @NonNull String s2 = \"\";\n    void foo(X other) {\n        s2 = other.s1;\n    }\n}\n"}, null, "");
    }

    public void test_nonnull_field_15() {
        this.runConformTestWithLibs(new String[]{"com/google/inject/Inject.java", "package com.google.inject;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\nimport java.lang.annotation.Target;\n@Target({ METHOD, CONSTRUCTOR, FIELD })\n@Retention(RUNTIME)\npublic @interface Inject {\n\n  boolean optional() default false;\n}", "X.java", "import org.eclipse.jdt.annotation.*;\nimport com.google.inject.Inject;\npublic class X {\n    @NonNull @Inject Object o;\n    @NonNullByDefault class Inner {\n        @Inject String s;\n    }\n}\n"}, null, "");
    }

    public void test_nonnull_field_16() {
        this.runNegativeTestWithLibs(new String[]{"com/google/inject/Inject.java", "package com.google.inject;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\nimport java.lang.annotation.Target;\n@Target({ METHOD, CONSTRUCTOR, FIELD })\n@Retention(RUNTIME)\npublic @interface Inject {\n\n  boolean optional() default false;\n}", "X.java", "import org.eclipse.jdt.annotation.*;\nimport com.google.inject.Inject;\npublic class X {\n    @Inject(optional=true) @NonNull Object o;\n    @NonNullByDefault class Inner {\n        @Inject(optional=true) String s;\n        @Inject(optional=false) String t;\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 4)\n\t@Inject(optional=true) @NonNull Object o;\n\t                                       ^\nThe @NonNull field o may not have been initialized\n----------\n2. ERROR in X.java (at line 6)\n\t@Inject(optional=true) String s;\n\t                              ^\nThe @NonNull field s may not have been initialized\n----------\n");
    }

    public void test_nonnull_field_17() {
        this.runNegativeTestWithLibs(new String[]{"javax/inject/Inject.java", "package javax.inject;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\nimport java.lang.annotation.Target;\n@Target({ METHOD, CONSTRUCTOR, FIELD })\n@Retention(RUNTIME)\npublic @interface Inject {}\n", "X.java", "import org.eclipse.jdt.annotation.*;\nimport javax.inject.Inject;\npublic class X {\n    @NonNull @Inject static String s; // warn since injection of static field is less reliable\n    @NonNull @Inject @Deprecated Object o;\n    public X() {}\n}\n"}, null, "----------\n1. ERROR in X.java (at line 4)\n\t@NonNull @Inject static String s; // warn since injection of static field is less reliable\n\t                               ^\nThe @NonNull field s may not have been initialized\n----------\n");
    }

    public void test_nullable_field_1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o = new Object();\n    public String oString() {\n         return this.o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\treturn this.o.toString();\n\t            ^\n" + this.potNPE_nullable("The field o") + "----------\n");
    }

    public void test_nullable_field_2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o = new Object();\n    public String oString() {\n         return o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\treturn o.toString();\n\t       ^\n" + this.potNPE_nullable("The field o") + "----------\n");
    }

    public void test_nullable_field_3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o = new Object();\n    @Nullable X other;\n    public String oString() {\n         return other.o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 6)\n\treturn other.o.toString();\n\t       ^^^^^\n" + this.potNPE_nullable("The field other") + "----------\n" + "2. ERROR in X.java (at line 6)\n" + "\treturn other.o.toString();\n" + "\t             ^\n" + this.potNPE_nullable("The field o") + "----------\n");
    }

    public void test_nullable_field_3m() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o = new Object();\n    @Nullable X other;\n    public String oString() {\n         return other.other.o.toString();\n    }\n}\n"}, null, "----------\n1. ERROR in X.java (at line 6)\n\treturn other.other.o.toString();\n\t       ^^^^^\n" + this.potNPE_nullable("The field other") + "----------\n" + "2. ERROR in X.java (at line 6)\n" + "\treturn other.other.o.toString();\n" + "\t             ^^^^^\n" + this.potNPE_nullable("The field other") + "----------\n" + "3. ERROR in X.java (at line 6)\n" + "\treturn other.other.o.toString();\n" + "\t                   ^\n" + this.potNPE_nullable("The field o") + "----------\n");
    }

    public void test_nullable_field_4() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o = new Object();\n    public String oString() {\n         if (this.o != null)\n             return this.o.toString();\n         if (o != null)\n             return o.toString();\n         return \"\";\n    }\n    public String oString2() {\n         String local = o.toString();\n         if (this.o != null) {\n             this.toString();\n             return this.o.toString(); // warn here\n         }\n         return \"\";\n    }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 12)\n\tString local = o.toString();\n\t               ^\n" + this.potNPE_nullable("The field o") + "----------\n" + "2. ERROR in X.java (at line 15)\n" + "\treturn this.o.toString(); // warn here\n" + "\t            ^\n" + this.potNPE_nullable("The field o") + "----------\n");
    }

    public void test_nullable_field_5() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull Y y = new Y();\n    public String oString() {\n         return y.z.o.toString(); // pot.NPE on z\n    }\n}\n", "Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n    @Nullable Z z = new Z();\n}\n", "Z.java", "import org.eclipse.jdt.annotation.*;\npublic class Z {\n    @NonNull Object o = new Object();\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\treturn y.z.o.toString(); // pot.NPE on z\n\t         ^\n" + this.potNPE_nullable("The field z") + "----------\n");
    }

    public void test_nullable_field_6() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Y y = new Y();\n    public String oString() {\n         return y.z.o.toString(); // pot.NPE on y and o\n    }\n}\n", "Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n    @NonNull Z z = new Z();\n}\n", "Z.java", "import org.eclipse.jdt.annotation.*;\npublic class Z {\n    Object dummy;\n    @Nullable Object o = new Object();\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\treturn y.z.o.toString(); // pot.NPE on y and o\n\t       ^\n" + this.potNPE_nullable("The field y") + "----------\n" + "2. ERROR in X.java (at line 5)\n" + "\treturn y.z.o.toString(); // pot.NPE on y and o\n" + "\t           ^\n" + this.potNPE_nullable("The field o") + "----------\n");
    }

    public void test_nullable_field_7() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Y y = new Y();\n    public String oString() {\n         return this.y.o.toString(); // pot.NPE on y and o\n    }\n}\n", "Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n    @Nullable Object o = new Object();\n}\n"}, null, "----------\n1. ERROR in X.java (at line 5)\n\treturn this.y.o.toString(); // pot.NPE on y and o\n\t            ^\n" + this.potNPE_nullable("The field y") + "----------\n" + "2. ERROR in X.java (at line 5)\n" + "\treturn this.y.o.toString(); // pot.NPE on y and o\n" + "\t              ^\n" + this.potNPE_nullable("The field o") + "----------\n");
    }

    public void test_nullable_field_8() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable static final Object o = null;\n    public void foo() {\n         if (X.o == null){\n\t\t\t\tSystem.out.println(X.o);\n\t\t  }\n    }\n}\n"}, null, "");
    }

    public void test_nullable_field_9() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable int i;\n}\n"}, null, "----------\n1. ERROR in X.java (at line 3)\n\t@Nullable int i;\n\t^^^^^^^^^\nThe nullness annotation @Nullable is not applicable for the primitive type int\n----------\n");
    }

    public void test_nullable_field_10a() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o1, o2, o3;\n    @NonNull X x = new X();\n    public void foo(X other) {\n         if (other.o1 != null){\n             System.out.println(other.o1.toString());\n         }\n         if (this.o2 != null)\n             System.out.println(o2.toString());\n         if (this.o2 != null)\n             System.out.println(this.o2.toString());\n         System.out.println (null != o3 ? o3.toString() : \"nothing\");\n         if (this.x.o1 != null)\n             System.out.println(x.o1.toString());\n         if (x.o1 != null)\n             System.out.println(this.x.o1.toString());\n         if (this.x.o1 != null)\n             System.out.println(this.x.o1.toString());\n    }\n}\n"}, options, "");
    }

    public void test_nullable_field_10b() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "disabled");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o1, o2, o3;\n    @NonNull X x = new X();\n    public void foo(X other) {\n         if (other.o1 != null){\n             System.out.println(other.o1.toString());\n         }\n         if (this.o2 != null)\n             System.out.println(o2.toString());\n         if (this.o2 != null)\n             System.out.println(this.o2.toString());\n         System.out.println (null != o3 ? o3.toString() : \"nothing\");\n         if (this.x.o1 != null)\n             System.out.println(x.o1.toString());\n         if (x.o1 != null)\n             System.out.println(this.x.o1.toString());\n         if (this.x.o1 != null)\n             System.out.println(this.x.o1.toString());\n    }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(other.o1.toString());\n\t                         ^^\n" + this.potNPE_nullable("The field o1") + "----------\n" + "2. ERROR in X.java (at line 10)\n" + "\tSystem.out.println(o2.toString());\n" + "\t                   ^^\n" + this.potNPE_nullable("The field o2") + "----------\n" + "3. ERROR in X.java (at line 12)\n" + "\tSystem.out.println(this.o2.toString());\n" + "\t                        ^^\n" + this.potNPE_nullable("The field o2") + "----------\n" + "4. ERROR in X.java (at line 13)\n" + "\tSystem.out.println (null != o3 ? o3.toString() : \"nothing\");\n" + "\t                                 ^^\n" + this.potNPE_nullable("The field o3") + "----------\n" + "5. ERROR in X.java (at line 15)\n" + "\tSystem.out.println(x.o1.toString());\n" + "\t                     ^^\n" + this.potNPE_nullable("The field o1") + "----------\n" + "6. ERROR in X.java (at line 17)\n" + "\tSystem.out.println(this.x.o1.toString());\n" + "\t                          ^^\n" + this.potNPE_nullable("The field o1") + "----------\n" + "7. ERROR in X.java (at line 19)\n" + "\tSystem.out.println(this.x.o1.toString());\n" + "\t                          ^^\n" + this.potNPE_nullable("The field o1") + "----------\n");
    }

    public void test_nullable_field_10c() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o1, o2, o3;\n    public void foo(X other) {\n         if (o1 != null && o2 != null & o3 != null) \n             System.out.println(o2.toString());\n         if (o1 != null || o2 != null || o3 != null) \n             System.out.println(o2.toString()); // warn here: disjunktion is no protection\n         if (!(o1 != null)) \n             System.out.println(o1.toString()); // warn here: negated inequality is no protection\n         if (!(o1 == null || o2 == null)) \n             System.out.println(o1.toString()); // don't warn here\n         if (!(o1 == null && o2 == null)) \n             System.out.println(o2.toString()); // warn here: negated conjunction is no protection\n         if (!(!(o1 == null))) \n             System.out.println(o1.toString()); // warn here: double negation is no protection\n         if (!(!(o1 != null && o2 != null))) \n             System.out.println(o1.toString()); // don't warn here\n    }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 8)\n\tSystem.out.println(o2.toString()); // warn here: disjunktion is no protection\n\t                   ^^\n" + this.potNPE_nullable("The field o2") + "----------\n" + "2. ERROR in X.java (at line 10)\n" + "\tSystem.out.println(o1.toString()); // warn here: negated inequality is no protection\n" + "\t                   ^^\n" + this.potNPE_nullable("The field o1") + "----------\n" + "3. ERROR in X.java (at line 14)\n" + "\tSystem.out.println(o2.toString()); // warn here: negated conjunction is no protection\n" + "\t                   ^^\n" + this.potNPE_nullable("The field o2") + "----------\n" + "4. ERROR in X.java (at line 16)\n" + "\tSystem.out.println(o1.toString()); // warn here: double negation is no protection\n" + "\t                   ^^\n" + this.potNPE_nullable("The field o1") + "----------\n");
    }

    public void test_nullable_field_10d() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o1;\n    public void foo(@NonNull X other, X last) {\n         o1 = other;\n         if (o1 == last) \n             System.out.println(o1.toString());\n         if ((o1 = other) == last) \n             System.out.println(o1.toString());\n         if ((o1 = other) == last) {\n             o1 = null;\n             System.out.println(o1.toString()); // info is expired\n         }\n    }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 12)\n\tSystem.out.println(o1.toString()); // info is expired\n\t                   ^^\n" + this.potNPE_nullable("The field o1") + "----------\n");
    }

    public void test_nullable_field_10e() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nclass Y {\n    @Nullable Object o2;\n    void bar(Object o2) {\n        if (o2 != null)\n            System.out.println(this.o2.toString()); // field access is not protected\n    }\n}\npublic class X {\n    @NonNull Y o1 = new Y();\n    public void foo() {\n         Y o1 = new Y();\n         if (o1.o2 != null) \n             System.out.println(this.o1.o2.toString()); // field access via other field not protected\n         if (this.o1.o2 != null) \n             System.out.println(o1.o2.toString()); // field access via local not protected\n    }\n}\n"}, options, "----------\n1. WARNING in X.java (at line 4)\n\tvoid bar(Object o2) {\n\t                ^^\nThe parameter o2 is hiding a field from type Y\n----------\n2. ERROR in X.java (at line 6)\n\tSystem.out.println(this.o2.toString()); // field access is not protected\n\t                        ^^\n" + this.potNPE_nullable("The field o2") + "----------\n" + "3. WARNING in X.java (at line 12)\n" + "\tY o1 = new Y();\n" + "\t  ^^\n" + "The local variable o1 is hiding a field from type X\n" + "----------\n" + "4. ERROR in X.java (at line 14)\n" + "\tSystem.out.println(this.o1.o2.toString()); // field access via other field not protected\n" + "\t                           ^^\n" + this.potNPE_nullable("The field o2") + "----------\n" + "5. ERROR in X.java (at line 16)\n" + "\tSystem.out.println(o1.o2.toString()); // field access via local not protected\n" + "\t                      ^^\n" + this.potNPE_nullable("The field o2") + "----------\n");
    }

    public void test_nullable_field_10f() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o1;\n    public void foo(X other) {\n         if (o1 != null && o1 != null) // second term is redundant\n             System.out.println(o1.toString());\n         if (o1 != null)\n             if (o1 != null) // this if is redundant\n                 System.out.println(o1.toString());\n    }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 5)\n\tif (o1 != null && o1 != null) // second term is redundant\n\t                  ^^\nRedundant null check: The field o1 cannot be null at this location (ignoring concurrency)\n----------\n2. ERROR in X.java (at line 8)\n\tif (o1 != null) // this if is redundant\n\t    ^^\nRedundant null check: The field o1 cannot be null at this location (ignoring concurrency)\n----------\n");
    }

    public void test_nullable_field_11() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nclass X {\n    @Nullable Object o;\n    public @NonNull Object foo(X x) {\n    \treturn  x.o != null ? x.o : new Object();\n\t }\n    public void goo(X x) {\n    \tif (x.o != null) {\n    \t\tx.o.toString();\n    \t}\n    }\n    public void boo(X x) {\n    \tif (x.o instanceof String) {\n    \t\tx.o.toString();\n    \t}\n    }\n    public void zoo(X x) {\n    \tx.o = new Object();\n    \tSystem.out.println(\"hashCode of new Object = \" + x.o.hashCode());\n    }\n    public void doo(X x) {\n    \tx.o = foo(x); // foo is guaranteed to return @NonNull Object.\n    \tSystem.out.println(\"hashCode of new Object = \" + x.o.hashCode());\n    }\n}\n"}, options, "");
    }

    public void test_nullable_field_11a() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nclass X {\n    @Nullable Object o;\n    public @NonNull Object foo() {\n    \treturn  o != null ? o : new Object();\n    }\n    public void goo() {\n    \tif (o != null) {\n    \t\to.toString();\n    \t}\n    }\n    public void boo() {\n    \tif (o instanceof String) {\n    \t\to.toString();\n    \t}\n    }\n    public void zoo() {\n    \to = new Object();\n    \tSystem.out.println(\"hashCode of new Object = \" + o.hashCode());\n    }\n    public void doo() {\n    \to = foo(); // foo is guaranteed to return @NonNull Object.\n    \tSystem.out.println(\"hashCode of new Object = \" + o.hashCode());\n    }\n}\n"}, options, "");
    }

    public void test_nullable_field_12() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o1, o2, o3, o4;\n    public void foo(X other) {\n         if (other.o1 != null){\n\t\t\t\tSystem.out.println(goo()+other.o1.toString()); // warn here: expired by call to goo()\n\t\t  }\n         Object x = o2 != null ? o2 : o1;\n         System.out.println(o2.toString()); // warn here: not protected\n         if (o3 != null) /*nop*/;\n         System.out.println(o3.toString()); // warn here: expired by empty statement\n         if (o4 != null && hoo())\n             System.out.println(o4.toString()); // warn here: expired by call to hoo()\n    }\n    String goo() { return \"\"; }\n    boolean hoo() { return false; }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 6)\n\tSystem.out.println(goo()+other.o1.toString()); // warn here: expired by call to goo()\n\t                               ^^\n" + this.potNPE_nullable("The field o1") + "----------\n" + "2. ERROR in X.java (at line 9)\n" + "\tSystem.out.println(o2.toString()); // warn here: not protected\n" + "\t                   ^^\n" + this.potNPE_nullable("The field o2") + "----------\n" + "3. ERROR in X.java (at line 11)\n" + "\tSystem.out.println(o3.toString()); // warn here: expired by empty statement\n" + "\t                   ^^\n" + this.potNPE_nullable("The field o3") + "----------\n" + "4. ERROR in X.java (at line 13)\n" + "\tSystem.out.println(o4.toString()); // warn here: expired by call to hoo()\n" + "\t                   ^^\n" + this.potNPE_nullable("The field o4") + "----------\n");
    }

    public void test_nullable_field_13() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o1;\n    @NonNull Object o2 = new Object();\n    public void foo(X other) {\n         if (other.o1 == null){\n\t\t\t\tthis.o2 = other.o1; // warn here: assign @Nullable to @NonNull\n\t\t  }\n    }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 7)\n\tthis.o2 = other.o1; // warn here: assign @Nullable to @NonNull\n\t          ^^^^^^^^\n" + this.mismatch_NonNull_Nullable("Object") + "----------\n");
    }

    public void test_nullable_field_14() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o = new Object();\n    public String oString(@NonNull Object a) {\n         if (this.o == a)\n             return this.o.toString();\n         return \"\";\n    }\n}\n"}, options, "");
    }

    public void test_nullable_field_14a() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable Object o = new Object();\n    public String oString(@NonNull Object a) {\n         if (this.o != a)\n             return this.o.toString(); // warn here, check has no effect\n         return \"\";\n    }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 6)\n\treturn this.o.toString(); // warn here, check has no effect\n\t            ^\n" + this.potNPE_nullable("The field o") + "----------\n");
    }

    public void test_nullable_field_15() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @Nullable\n    private Object nullable;\n\n    public void test() {\n        if (nullable instanceof Number) {\n            ((Number)nullable).intValue(); // A\n        }\n        if (nullable != null) {\n            nullable.toString(); // B\n        }\n        nullable.toString(); // C\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t((Number)nullable).intValue(); // A\n\t         ^^^^^^^^\n" + this.potNPE_nullable("The field nullable") + "----------\n" + "2. ERROR in X.java (at line 11)\n" + "\tnullable.toString(); // B\n" + "\t^^^^^^^^\n" + this.potNPE_nullable("The field nullable") + "----------\n" + "3. ERROR in X.java (at line 13)\n" + "\tnullable.toString(); // C\n" + "\t^^^^^^^^\n" + this.potNPE_nullable("The field nullable") + "----------\n");
    }

    public void test_enum_field_01() {
        this.runConformTestWithLibs(new String[]{"tests/X.java", "package tests;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class X {\n    enum A { B }\n    public static void main(String ... args) {\n         System.out.println(A.B);\n    }\n}\n"}, null, "", "B");
    }

    public void test_enum_field_02() {
        this.runConformTestWithLibs(new String[]{"tests/X.java", "package tests;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n    enum A { B }\n    public static void main(String ... args) {\n         test(A.B);\n    }\n    static void test(@NonNull A a) {\n        System.out.println(a.ordinal());\n    }\n}\n"}, null, "", "0");
    }

    public void testBug372011() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test372011.jar";
        String[] libs = new String[this.LIBS.length + 1];
        System.arraycopy(this.LIBS, 0, libs, 0, this.LIBS.length);
        libs[this.LIBS.length] = path;
        this.runNegativeTest(new String[]{"X.java", "import p11.T11;\nimport p12.T12;\nimport p12.T12a;\nimport p12.Public;\npublic class X {\n\t  void foo() {\n     new T11().t11foo(null);\n     new T12().new T122().foo122(null);\n   }\n\t  void trigger1 (Public o){\n\t\t\to.bar(null);\n\t  }\n\t  @org.eclipse.jdt.annotation.NonNull Object foo2() {\n\t\tnew T12a().foo12a(new Object());\n     new T12().new T122().new T1222().foo1222(null);\n     return new T11().retSomething();\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tnew T11().t11foo(null);\n\t                 ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in X.java (at line 8)\n\tnew T12().new T122().foo122(null);\n\t                            ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n3. ERROR in X.java (at line 11)\n\to.bar(null);\n\t      ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n4. ERROR in X.java (at line 15)\n\tnew T12().new T122().new T1222().foo1222(null);\n\t                                         ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n", libs, true);
    }

    public void testBug374129() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test374129" + this.TEST_JAR_SUFFIX;
        String[] libs = new String[this.LIBS.length + 1];
        System.arraycopy(this.LIBS, 0, libs, 0, this.LIBS.length);
        libs[this.LIBS.length] = path;
        this.runNegativeTest(new String[]{"bug374129/Test.java", "package bug374129;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nimport p1bin.C1bin;\nimport p1bin.C1bin.C1binInner;\nimport p2bin.C2bin;\nimport p2bin.C2bin.C2binInner;\nimport p2bin.C3bin;\n\npublic class Test {\n\tstatic C1bin c1 = new C1bin();\n\tstatic C1binInner c1i = new C1binInner();\n\tstatic C2bin c2 = new C2bin();\n\tstatic C2binInner c2i = new C2binInner();\n\tstatic C3bin c3 = new C3bin();\n\t\n\tpublic static void main(String[] args) {\n\t\t@Nullable String n = getN();\n\t\t@NonNull String s;\n\t\ts = c1.getId(n, n); // error on first arg (package default)\n\t\ts = c1i.getId(n, n); // error on first arg (package default propagated into inner)\n\t\ts = c2.getId(n, n); // error on first arg (type default)\n\t\ts = c2i.getId(n, n); // no arg error (canceled default), return requires unchecked conversion\n\t\ts = c3.getId(n, n); // error on first arg (method default)\n\t}\n\tstatic String getN() { return null; }\n}\n\n"}, "----------\n1. ERROR in bug374129\\Test.java (at line 22)\n\ts = c1.getId(n, n); // error on first arg (package default)\n\t             ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n" + "2. ERROR in bug374129\\Test.java (at line 23)\n" + "\ts = c1i.getId(n, n); // error on first arg (package default propagated into inner)\n" + "\t              ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n" + "3. ERROR in bug374129\\Test.java (at line 24)\n" + "\ts = c2.getId(n, n); // error on first arg (type default)\n" + "\t             ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n" + "4. WARNING in bug374129\\Test.java (at line 25)\n" + "\ts = c2i.getId(n, n); // no arg error (canceled default), return requires unchecked conversion\n" + "\t    ^^^^^^^^^^^^^^^\n" + this.nullTypeSafety() + "The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n" + "----------\n" + "5. ERROR in bug374129\\Test.java (at line 26)\n" + "\ts = c3.getId(n, n); // error on first arg (method default)\n" + "\t             ^\n" + this.mismatch_NonNull_Nullable("String") + "----------\n", libs, true);
    }

    public void testBug385626_1() {
        this.runConformTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n    void test() {\n        for (Integer i : new ArrayList<Integer>()) {\n            if (i != null) {\n                for (Integer j : new ArrayList<Integer>()) {\n                    if (j != null) {\n                        @NonNull Integer j1 = i; // bogus error was here\n                    }\n                }\n            }\n        }\n    }\n}\n"}, null, "");
    }

    public void testBug385626_2() {
        this.runConformTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n    void test(Integer j) {\n        for (Integer i : new ArrayList<Integer>()) {\n            if (i != null) {\n                try {\n                    if (j != null) {\n                        @NonNull Integer j1 = i;\n                    }\n                } finally {\n                    if (j != null) {\n                        @NonNull Integer j1 = i; // bogus error was here\n                    }\n                }\n            }\n        }\n    }\n}\n"}, null, "");
    }

    public void testBug388630_1() {
        this.runConformTestWithLibs(new String[]{"C0.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class C0 {\n\tC0 (@NonNull Object o) { }\n\tvoid test() { }\n}\n", "X.java", "public class X {\n\tvoid foo() {\n\t\tnew C0(\"\") { }.test();\n\t}\n}\n"}, null, "");
    }

    public void testBug388630_2() {
        this.runNegativeTestWithLibs(new String[]{"C0.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class C0 {\n\tC0 (@NonNull Object o) { }\n\tvoid test() { }\n}\n", "X.java", "import org.eclipse.jdt.annotation.Nullable;\npublic class X {\n\tvoid foo(final @Nullable Object a) {\n\t\tnew C0(\"\") {\n           @Override\n           void test() {\n               System.out.println(a.toString());\n               super.test();\n           }\n       }.test();\n\t}\n}\n"}, null, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(a.toString());\n\t                   ^\n" + this.variableMayBeNull("a") + "----------\n");
    }

    public void testBug388281_01() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test388281" + this.TEST_JAR_SUFFIX;
        String[] libs = new String[this.LIBS.length + 1];
        System.arraycopy(this.LIBS, 0, libs, 0, this.LIBS.length);
        libs[this.LIBS.length] = path;
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTest(new String[]{"Client.java", "import c.C1;\npublic class Client {\n    void test(C1 c) {\n         String s = c.m2(null);               // (3)\n         System.out.println(s.toUpperCase()); // (4)\n    }\n}\n"}, "----------\n1. ERROR in Client.java (at line 4)\n\tString s = c.m2(null);               // (3)\n\t                ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in Client.java (at line 5)\n\tSystem.out.println(s.toUpperCase()); // (4)\n\t                   ^\nPotential null pointer access: The variable s may be null at this location\n----------\n", libs, true, options);
    }

    public void testBug388281_02() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test388281" + this.TEST_JAR_SUFFIX;
        String[] libs = new String[this.LIBS.length + 1];
        System.arraycopy(this.LIBS, 0, libs, 0, this.LIBS.length);
        libs[this.LIBS.length] = path;
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTest(new String[]{"ctest/C.java", "package ctest;\npublic class C extends c.C1 {\n    @Override\n    public Object m1(Object a1) {\n         System.out.println(a1.toString());   // (1)\n         return null;                         // (2)\n    }\n    @Override\n    public String m2(Object a2) {\n         System.out.println(a2.toString());\n         return null;\n    }\n}\n", "Client.java", "import ctest.C;\npublic class Client {\n    void test(C c) {\n         String s = c.m2(null);               // (3)\n         System.out.println(s.toUpperCase()); // (4)\n    }\n}\n"}, "----------\n1. ERROR in ctest\\C.java (at line 5)\n\tSystem.out.println(a1.toString());   // (1)\n\t                   ^^\n" + this.potNPE_nullable_maybenull("The variable a1") + "----------\n" + "2. ERROR in ctest\\C.java (at line 6)\n" + "\treturn null;                         // (2)\n" + "\t       ^^^^\n" + "Null type mismatch: required '@NonNull Object' but the provided value is null\n" + "----------\n" + "----------\n" + "1. ERROR in Client.java (at line 4)\n" + "\tString s = c.m2(null);               // (3)\n" + "\t                ^^^^\n" + "Null type mismatch: required '@NonNull Object' but the provided value is null\n" + "----------\n" + "2. ERROR in Client.java (at line 5)\n" + "\tSystem.out.println(s.toUpperCase()); // (4)\n" + "\t                   ^\n" + "Potential null pointer access: The variable s may be null at this location\n" + "----------\n", libs, true, options);
    }

    public void testBug388281_03() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test388281" + this.TEST_JAR_SUFFIX;
        String[] libs = new String[this.LIBS.length + 1];
        System.arraycopy(this.LIBS, 0, libs, 0, this.LIBS.length);
        libs[this.LIBS.length] = path;
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTest(new String[]{"ctest/C.java", "package ctest;\npublic class C implements i.I {\n    public Object m1(Object a1) {\n         System.out.println(a1.toString());   // (1)\n         return null;                         // (2)\n    }\n    public String m2(Object a2) {\n         System.out.println(a2.toString());\n         return null;\n    }\n    public Object m1(Object a1, Object a2) {\n        System.out.println(a1.toString());   // (3)\n        return null;\n    }\n}\n"}, "----------\n1. ERROR in ctest\\C.java (at line 4)\n\tSystem.out.println(a1.toString());   // (1)\n\t                   ^^\n" + this.potNPE_nullable_maybenull("The variable a1") + "----------\n" + "2. ERROR in ctest\\C.java (at line 5)\n" + "\treturn null;                         // (2)\n" + "\t       ^^^^\n" + "Null type mismatch: required '@NonNull Object' but the provided value is null\n" + "----------\n" + "3. ERROR in ctest\\C.java (at line 12)\n" + "\tSystem.out.println(a1.toString());   // (3)\n" + "\t                   ^^\n" + this.potNPE_nullable_maybenull("The variable a1") + "----------\n", libs, true, options);
    }

    public void testBug388281_04() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTestWithLibs(true, new String[]{"i/I.java", "package i;\nimport org.eclipse.jdt.annotation.*;\npublic interface I {\n    @NonNull Object m1(@NonNull Object s1, @Nullable String s2);\n    @Nullable Object m1(@Nullable String s1, @NonNull Object s2);\n}\n", "ctest/C.java", "package ctest;\nimport org.eclipse.jdt.annotation.*;\npublic class C implements i.I {\n    public Object m1(@Nullable Object o1, String s2) {\n         System.out.println(s2.toString());   // (1)\n         return null;                         // (2)\n    }\n    public @NonNull Object m1(String s1, Object o2) {\n         System.out.println(s1.toString());   // (3)\n         return new Object();\n    }\n}\n"}, options, "----------\n1. ERROR in ctest\\C.java (at line 5)\n\tSystem.out.println(s2.toString());   // (1)\n\t                   ^^\n" + this.variableMayBeNull("s2") + "----------\n" + "2. ERROR in ctest\\C.java (at line 6)\n" + "\treturn null;                         // (2)\n" + "\t       ^^^^\n" + "Null type mismatch: required '@NonNull Object' but the provided value is null\n" + "----------\n" + "3. ERROR in ctest\\C.java (at line 9)\n" + "\tSystem.out.println(s1.toString());   // (3)\n" + "\t                   ^^\n" + this.variableMayBeNull("s1") + "----------\n");
    }

    public void testBug388281_05() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test388281" + this.TEST_JAR_SUFFIX;
        String[] libs = new String[this.LIBS.length + 1];
        System.arraycopy(this.LIBS, 0, libs, 0, this.LIBS.length);
        libs[this.LIBS.length] = path;
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTest(new String[]{"ctest/C.java", "package ctest;\npublic class C implements i2.I2 {\n    public Object m1(Object a1) {\n         System.out.println(a1.toString());   // silent\n         return null;                         // (1)\n    }\n    public String m2(Object a2) {\n         System.out.println(a2.toString());\n         return null;\t\t\t\t\t\t   // (2)\n    }\n}\n", "Client.java", "import ctest.C;\npublic class Client {\n    void test(C c) {\n         String s = c.m2(null);               // (3)\n    }\n}\n"}, "----------\n1. ERROR in ctest\\C.java (at line 5)\n\treturn null;                         // (1)\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in ctest\\C.java (at line 9)\n\treturn null;\t\t\t\t\t\t   // (2)\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n----------\n1. ERROR in Client.java (at line 4)\n\tString s = c.m2(null);               // (3)\n\t                ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n", libs, true, options);
    }

    public void testBug388281_06() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test388281" + this.TEST_JAR_SUFFIX;
        String[] libs = new String[this.LIBS.length + 1];
        System.arraycopy(this.LIBS, 0, libs, 0, this.LIBS.length);
        libs[this.LIBS.length] = path;
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTest(new String[]{"ctest/C.java", "package ctest;\npublic class C extends c.C2 implements i2.I2A {\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in ctest\\C.java (at line 2)\n\tpublic class C extends c.C2 implements i2.I2A {\n\t             ^\nThe method m2(Object) from C2 cannot implement the corresponding method from I2A due to incompatible nullness constraints\n----------\n2. ERROR in ctest\\C.java (at line 2)\n\tpublic class C extends c.C2 implements i2.I2A {\n\t             ^\nThe method m1(Object) from C2 cannot implement the corresponding method from I2A due to incompatible nullness constraints\n----------\n" : "----------\n1. ERROR in ctest\\C.java (at line 2)\n\tpublic class C extends c.C2 implements i2.I2A {\n\t             ^\nThe method m2(@NonNull Object) from C2 cannot implement the corresponding method from I2A due to incompatible nullness constraints\n----------\n2. ERROR in ctest\\C.java (at line 2)\n\tpublic class C extends c.C2 implements i2.I2A {\n\t             ^\nThe method m1(@NonNull Object) from C2 cannot implement the corresponding method from I2A due to incompatible nullness constraints\n----------\n", libs, true, options);
    }

    public void testBug388281_07() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTestWithLibs(new String[]{"p1/Super.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic class Super {\n    public @Nullable Object m(@Nullable Object arg) {\n        return null;    }\n}\n", "p2/Sub.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Sub extends p1.Super {\n    @Override\n    public Object m(Object arg) { // (a)+(b) conflict at arg and return\n        System.out.println(arg.toString()); // (1)\n        return null;\n    }\n}\n", "Client.java", "public class Client {\n    void test(p2.Sub s) {\n        Object result = s.m(null);\n        System.out.println(result.toString());  // (2)\n    }\n}\n"}, options, "----------\n1. ERROR in p2\\Sub.java (at line 6)\n\tpublic Object m(Object arg) { // (a)+(b) conflict at arg and return\n\t       ^^^^^^\nThe default '@NonNull' conflicts with the inherited '@Nullable' annotation in the overridden method from Super \n----------\n2. ERROR in p2\\Sub.java (at line 6)\n\tpublic Object m(Object arg) { // (a)+(b) conflict at arg and return\n\t                       ^^^\nThe default '@NonNull' conflicts with the inherited '@Nullable' annotation in the overridden method from Super \n----------\n3. ERROR in p2\\Sub.java (at line 7)\n\tSystem.out.println(arg.toString()); // (1)\n\t                   ^^^\n" + this.variableMayBeNull("arg") + "----------\n" + "----------\n" + "1. ERROR in Client.java (at line 4)\n" + "\tSystem.out.println(result.toString());  // (2)\n" + "\t                   ^^^^^^\n" + "Potential null pointer access: The variable result may be null at this location\n" + "----------\n");
    }

    public void testBug388281_08() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test388281" + this.TEST_JAR_SUFFIX;
        String[] libs = new String[this.LIBS.length + 1];
        System.arraycopy(this.LIBS, 0, libs, 0, this.LIBS.length);
        libs[this.LIBS.length] = path;
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTest(new String[]{"ctest/Ctest.java", "package ctest;\nimport org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Ctest implements i2.II {\n    public Object m1(@Nullable Object a1) { // silent: conflict at a1 avoided\n\t\treturn new Object();\n    }\n    public String m2(Object a2) { // (a) conflict at return\n    \treturn null;\n    }\n    public String m1(Object o1, Object o2) { // (b) conflict at o1\n        System.out.println(o1.toString()); // (1) inherited @Nullable\n        return null; // (2) @NonNullByDefault in i2.II\n    }\n}\n", "Client.java", "public class Client {\n    void test(ctest.Ctest c) {\n        Object result = c.m1(null, null); // (3) 2nd arg @NonNullByDefault from i2.II\n    }\n}\n"}, "----------\n1. ERROR in ctest\\Ctest.java (at line 8)\n\tpublic String m2(Object a2) { // (a) conflict at return\n\t       ^^^^^^\nThe default '@NonNull' conflicts with the inherited '@Nullable' annotation in the overridden method from I \n----------\n2. ERROR in ctest\\Ctest.java (at line 11)\n\tpublic String m1(Object o1, Object o2) { // (b) conflict at o1\n\t                        ^^\nThe default '@NonNull' conflicts with the inherited '@Nullable' annotation in the overridden method from II \n----------\n3. ERROR in ctest\\Ctest.java (at line 12)\n\tSystem.out.println(o1.toString()); // (1) inherited @Nullable\n\t                   ^^\n" + this.potNPE_nullable_maybenull("The variable o1") + "----------\n" + "4. ERROR in ctest\\Ctest.java (at line 13)\n" + "\treturn null; // (2) @NonNullByDefault in i2.II\n" + "\t       ^^^^\n" + "Null type mismatch: required '@NonNull String' but the provided value is null\n" + "----------\n" + "----------\n" + "1. ERROR in Client.java (at line 3)\n" + "\tObject result = c.m1(null, null); // (3) 2nd arg @NonNullByDefault from i2.II\n" + "\t                           ^^^^\n" + "Null type mismatch: required '@NonNull Object' but the provided value is null\n" + "----------\n", libs, true, options);
    }

    public void testBug388281_09() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTestWithLibs(new String[]{"p1/Super.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class Super {\n    public abstract @NonNull Object compatible(@Nullable Object arg);\n    public @Nullable Object incompatible(int dummy, @NonNull Object arg) {\n        return null;    }\n}\n", "p1/I.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic interface I {\n    public @Nullable Object compatible(@NonNull Object arg);\n    public @NonNull Object incompatible(int dummy, @Nullable Object arg);\n}\n", "p2/Sub.java", "package p2;\npublic class Sub extends p1.Super implements p1.I {\n    @Override\n    public Object compatible(Object arg) {\n        return this;\n    }\n    @Override\n    public Object incompatible(int dummy, Object arg) {\n        return null;\n    }\n}\n"}, options, "----------\n1. ERROR in p2\\Sub.java (at line 4)\n\tpublic Object compatible(Object arg) {\n\t       ^^^^^^\nConflict between inherited null annotations '@Nullable' declared in I versus '@NonNull' declared in Super \n----------\n2. ERROR in p2\\Sub.java (at line 4)\n\tpublic Object compatible(Object arg) {\n\t                         ^^^^^^\nConflict between inherited null annotations '@NonNull' declared in I versus '@Nullable' declared in Super \n----------\n3. ERROR in p2\\Sub.java (at line 8)\n\tpublic Object incompatible(int dummy, Object arg) {\n\t       ^^^^^^\nConflict between inherited null annotations '@NonNull' declared in I versus '@Nullable' declared in Super \n----------\n4. ERROR in p2\\Sub.java (at line 8)\n\tpublic Object incompatible(int dummy, Object arg) {\n\t                                      ^^^^^^\nConflict between inherited null annotations '@Nullable' declared in I versus '@NonNull' declared in Super \n----------\n");
    }

    public void testBug388281_10() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", "enabled");
        this.runNegativeTestWithLibs(new String[]{"p1/Super.java", "package p1;\nimport org.eclipse.jdt.annotation.*;\npublic class Super {\n    public void m(@NonNull Object arg) {}\n}\n", "p2/Sub.java", "package p2;\npublic class Sub extends p1.Super  {\n    @Override\n    public void m(Object arg) {\n        arg = null;\n    }\n}\n"}, options, "----------\n1. ERROR in p2\\Sub.java (at line 5)\n\targ = null;\n\t      ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void testBug382069_j() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTestWithLibs(new String[]{"junit/framework/Assert.java", "package junit.framework;\npublic class Assert {\n    static public void assertNull(Object object) {}\n    static public void assertNull(String message, Object object) {}\n    static public void assertNotNull(Object object) {}\n    static public void assertNotNull(String message, Object object) {}\n    static public void assertTrue(boolean expression) {}\n    static public void assertTrue(String message, boolean expression) {}\n    static public void assertFalse(boolean expression) {}\n    static public void assertFalse(String message, boolean expression) {}\n}\n", "X.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class X {\n  @NonNull String o1 = \"\";\n  boolean foo() {\n    junit.framework.Assert.assertNull(\"something's wrong\", o1);\n    return false; // dead code\n  }\n  void bar() {\n      junit.framework.Assert.assertNull(\"\");\n      return; // dead code\n  }\n  void zork() {\n      junit.framework.Assert.assertNotNull(null);\n      return; // dead code\n  }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 6)\n\treturn false; // dead code\n\t^^^^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 10)\n\treturn; // dead code\n\t^^^^^^^\nDead code\n----------\n3. ERROR in X.java (at line 14)\n\treturn; // dead code\n\t^^^^^^^\nDead code\n----------\n");
    }

    public void testBug382069_k() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTestWithLibs(new String[]{"junit/framework/Assert.java", "package junit.framework;\npublic class Assert {\n    static public void assertNull(Object object) {}\n    static public void assertNull(String message, Object object) {}\n    static public void assertNotNull(Object object) {}\n    static public void assertNotNull(String message, Object object) {}\n    static public void assertTrue(boolean expression) {}\n    static public void assertTrue(String message, boolean expression) {}\n    static public void assertFalse(boolean expression) {}\n    static public void assertFalse(String message, boolean expression) {}\n}\n", "X.java", "import org.eclipse.jdt.annotation.Nullable;\npublic class X {\n  @Nullable String o1;\n  int foo() {\n    junit.framework.Assert.assertNotNull(\"something's wrong\", o1);\n    return o1.length();\n  }\n  int bar(int i) {\n    junit.framework.Assert.assertNotNull(o1);\n    i++;\n    return o1.length(); // no longer protected\n  }\n  int garp() {\n    junit.framework.Assert.assertFalse(\"something's wrong\", o1 == null);\n    return o1.length();\n  }\n  int zipp() {\n    junit.framework.Assert.assertTrue(\"something's wrong\", o1 != null);\n    return o1.length();\n  }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 11)\n\treturn o1.length(); // no longer protected\n\t       ^^\n" + this.potNPE_nullable("The field o1") + "----------\n");
    }

    public void test_conditional_expression_1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tboolean badFunction5(int i) {\n\t\t// expected a potential null problem:\n\t\treturn i > 0 ? true : getBoolean();\n\t}\n\tprivate @Nullable Boolean getBoolean() {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn i > 0 ? true : getBoolean();\n\t                      ^^^^^^^^^^^^\nPotential null pointer access: This expression of type Boolean may be null but requires auto-unboxing\n----------\n");
    }

    public void testBug403086_1() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.includeNullInfoFromAsserts", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runConformTestWithLibs(new String[]{"junit/framework/Assert.java", "package junit.framework;\npublic class Assert {\n    static public void assertNull(Object object) {}\n    static public void assertNull(String message, Object object) {}\n    static public void assertNotNull(Object object) {}\n    static public void assertNotNull(String message, Object object) {}\n    static public void assertTrue(boolean expression) {}\n    static public void assertTrue(String message, boolean expression) {}\n    static public void assertFalse(boolean expression) {}\n    static public void assertFalse(String message, boolean expression) {}\n}\n", "Y.java", "import org.eclipse.jdt.annotation.*;\nclass Y {\n\t@Nullable String str;\n\tint foo(@Nullable String str2) {\n\t\tint i;\n\t\tjunit.framework.Assert.assertNotNull(str);\n\t\ti = str.length();\n\n\t\tassert this.str != null;\n\t\ti = str.length();\n\n\t\treturn i;\n\t}\n}\n"}, customOptions, "");
    }

    public void testBug403086_2() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.includeNullInfoFromAsserts", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields", "enabled");
        this.runConformTestWithLibs(new String[]{"junit/framework/Assert.java", "package junit.framework;\npublic class Assert {\n    static public void assertNull(Object object) {}\n    static public void assertNull(String message, Object object) {}\n    static public void assertNotNull(Object object) {}\n    static public void assertNotNull(String message, Object object) {}\n    static public void assertTrue(boolean expression) {}\n    static public void assertTrue(String message, boolean expression) {}\n    static public void assertFalse(boolean expression) {}\n    static public void assertFalse(String message, boolean expression) {}\n}\n", "Y.java", "import org.eclipse.jdt.annotation.*;\nclass Y {\n\t@Nullable String str;\n\tint foo(@Nullable String str2) {\n\t\tint i;\n\t\tjunit.framework.Assert.assertNotNull(str);\n\t\ti = str.length();\n\n\t\tassert ! (this.str == null);\n\t\ti = str.length();\n\n\t\treturn i;\n\t}\n}\n"}, customOptions, "");
    }

    public void testBug412076() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "ignore");
        this.runConformTestWithLibs(new String[]{"Foo.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic interface Foo<V> {\n  V bar(String... values);\n  V foo(String value);\n}\n"}, options, "");
        this.runConformTestWithLibs(new String[]{"FooImpl.java", "import org.eclipse.jdt.annotation.*;\n" + (this.complianceLevel < 0x340000L ? "@NonNullByDefault\n" : "@NonNullByDefault({DefaultLocation.PARAMETER,DefaultLocation.RETURN_TYPE})\n") + "public class FooImpl implements Foo<String> {\n" + "  public String bar(final String... values) {\n" + "    return (\"\");\n" + "  }\n" + "  public String foo(final String value) {\n" + "    return (\"\");\n" + "  }\n" + "}\n"}, options, "");
    }

    public void testBug413460() {
        this.runConformTestWithLibs(new String[]{"Class2.java", "\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class Class2 {\n\tpublic class Class3 {\n\t\tpublic Class3(String nonNullArg) {\n\t\t\tassert nonNullArg != null;\n\t\t}\n\t}\n\n\tpublic Class2(String nonNullArg) {\n\t\tassert nonNullArg != null;\n\t}\n\n\tpublic static Class2 create(String nonNullArg) {\n\t\treturn new Class2(nonNullArg);\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(false, new String[]{"Class1.java", "public class Class1 {\n\tpublic static Class2 works() {\n\t\treturn Class2.create(null);\n\t}\n\n\tpublic static Class2 bug() {\n\t\treturn new Class2(null);\n\t}\n\n\tpublic static Class2.Class3 qualifiedbug() {\n\t\treturn new Class2(\"\").new Class3(null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Class1.java (at line 3)\n\treturn Class2.create(null);\n\t                     ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in Class1.java (at line 7)\n\treturn new Class2(null);\n\t                  ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n3. ERROR in Class1.java (at line 11)\n\treturn new Class2(\"\").new Class3(null);\n\t                                 ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug415850_a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = new X1(x1){};\n\t}\n}\n", "X1.java", "public class X1 {\n\tpublic X1(Zork z) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X1(x1){};\n\t               ^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1(Zork z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void testBug415850_b() {
        this.runConformTestWithLibs(new String[]{"p/package-info.java", "@p.Annot(state=p.MyEnum.BROKEN)\npackage p;", "p/Annot.java", "package p;\n@Annot(state=MyEnum.KO)\npublic @interface Annot {\n\tMyEnum state() default MyEnum.KO;\n}", "p/MyEnum.java", "package p;\n@Annot(state=MyEnum.KO)\npublic enum MyEnum {\n\tWORKS, OK, KO, BROKEN, ;\n}", "test180/Test.java", "package test180;\nimport p.MyEnum;\nimport p.Annot;\n@Annot(state=MyEnum.OK)\npublic class Test {}"}, this.getCompilerOptions(), "");
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTestWithLibs(new String[]{"X.java", "import test180.Test;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(Test.class);\n\t}\n}"}, options, "", "class test180.Test");
    }

    public void testBug417295_5() {
        this.runNegativeTestWithLibs(new String[]{"AllAreNonNull.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npublic class AllAreNonNull {\n\tString s3 = \"\";\n\tvoid test() {\n\t\tthis.s3 = null;\n\t}\n}\n"}, "----------\n1. ERROR in AllAreNonNull.java (at line 5)\n\tthis.s3 = null;\n\t          ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug417295_7() {
        this.runConformTestWithLibs(new String[]{"p1/AllAreNonNull.java", "package p1;\n@org.eclipse.jdt.annotation.NonNullByDefault\npublic class AllAreNonNull {\n\tpublic String s3 = \"\";\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(false, new String[]{"Client.java", "public class Client {\n\tvoid test(p1.AllAreNonNull aann) {\n\t\taann.s3 = null;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Client.java (at line 3)\n\taann.s3 = null;\n\t          ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug415413() {
        Map options = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"ClassF.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class ClassF {\n  public static void needNonNull(@NonNull Object o) {\n    o.hashCode();\n  }\n  public void method() {\n    for (int j = 0; j < 1; j++) {\n      try {\n        this.hashCode();\n      } finally {\n        for (int i = 0; i < 1; i++) {\n          Object o = null;\n          needNonNull(o);\n        }\n      }\n    }\n  }\n}\n"}, options, "----------\n1. ERROR in ClassF.java (at line 13)\n\tneedNonNull(o);\n\t            ^\nNull type mismatch: required '@NonNull Object' but the provided value is inferred as @Nullable\n----------\n");
    }

    public void testBug415413a() {
        Map options = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"ClassF.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class ClassF {\n  public static void needNonNull(@NonNull Object o) {\n    o.hashCode();\n  }\n  public void method() {\n    for (int j = 0; j < 1; j++) {\n      try {\n        this.hashCode();\n      } finally {\n        Object o = new Object();\n        for (int i = 0; i < 1; i++) {\n          needNonNull(o);\n          o = new Object();\n        }\n      }\n    }\n  }\n}\n"}, options, "");
    }

    public void testBug415413b() {
        Map options = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"ClassF.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class ClassF {\n  public static void needNonNull(@NonNull Object o) {\n    o.hashCode();\n  }\n  public void method() {\n    for (int j = 0; j < 1; j++) {\n      try {\n        this.hashCode();\n      } finally {\n        Object o = null;\n        for (int i = 0; i < 1; i++) {\n          needNonNull(o);\n          o = new Object();\n        }\n      }\n    }\n  }\n}\n"}, options, "----------\n1. ERROR in ClassF.java (at line 13)\n\tneedNonNull(o);\n\t            ^\nNull type mismatch: required '@NonNull Object' but the provided value is inferred as @Nullable\n----------\n");
    }

    public void testBug415413c() {
        Map options = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"ClassF.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class ClassF {\n  public static void needNonNull(@NonNull Object o) {\n    o.hashCode();\n  }\n  public void method() {\n    for (int j = 0; j < 1; j++) {\n      try {\n        this.hashCode();\n      } finally {\n        Object o = new Object();\n        for (int i = 0; i < 1; i++) {\n          needNonNull(o);\n          o = null;\n        }\n      }\n    }\n  }\n}\n"}, options, "----------\n1. ERROR in ClassF.java (at line 13)\n\tneedNonNull(o);\n\t            ^\nNull type mismatch: required '@NonNull Object' but the provided value is inferred as @Nullable\n----------\n");
    }

    public void testBug_415269() {
        Map options = this.getCompilerOptions();
        this.runConformTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class Y {\n  public static class C implements X.I {\n    public void method(@NonNull Object arg) {\n    }\n  }\n}\n", "X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\npublic class X {\n  public interface I {\n    public void method(Object arg);\n  }\n}\n"}, options, "");
    }

    public void testBug416267() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "public class X {\n\tvoid test() {\n\t\tMissing m = new Missing() { };\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tMissing m = new Missing() { };\n\t^^^^^^^\nMissing cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tMissing m = new Missing() { };\n\t                ^^^^^^^\nMissing cannot be resolved to a type\n----------\n");
    }

    public void testBug418843() {
        this.runNegativeTestWithLibs(new String[]{"TestEnum.java", "public enum TestEnum {\n\tTestEntry(1){};\n}"}, "----------\n1. ERROR in TestEnum.java (at line 2)\n\tTestEntry(1){};\n\t^^^^^^^^^\nThe constructor TestEnum(int) is undefined\n----------\n");
    }

    public void testBug418235() {
        String[] testFiles = new String[]{"GenericInterface.java", "public interface GenericInterface<T> {\n       T doSomethingGeneric(T o);\n}", "Implementation.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\npublic class Implementation implements GenericInterface<Object> {\n\n" + (this.complianceLevel < 0x320000L ? "\n" : "      @Override\n") + "       public Object doSomethingGeneric(Object o) {\n" + "               return o;\n" + "       }\n" + "}\n"};
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTestWithLibs(testFiles, "----------\n1. ERROR in Implementation.java (at line 6)\n\tpublic Object doSomethingGeneric(Object o) {\n\t                                 ^^^^^^\nIllegal redefinition of parameter o, inherited method from GenericInterface<Object> does not constrain this parameter\n----------\n");
        } else {
            this.runConformTestWithLibs(testFiles, this.getCompilerOptions(), "");
        }
    }

    public void testBug418235b() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runNegativeTestWithLibs(new String[]{"GenericInterface.java", "public interface GenericInterface<T> {\n       T doSomethingGeneric(T o);\n}", "Implementation.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault({DefaultLocation.PARAMETER,DefaultLocation.RETURN_TYPE})\npublic class Implementation implements GenericInterface<Object> {\n\n      @Override\n       public Object doSomethingGeneric(Object o) {\n               return o;\n       }\n}\n"}, "----------\n1. ERROR in Implementation.java (at line 6)\n\tpublic Object doSomethingGeneric(Object o) {\n\t                                 ^^^^^^\nIllegal redefinition of parameter o, inherited method from GenericInterface<Object> does not constrain this parameter\n----------\n");
    }

    public void testTypeAnnotationProblemNotIn17() {
        String source = "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tpublic @NonNull java.lang.String test(@NonNull java.lang.String arg) {\n\t\t@NonNull java.lang.String local = arg;\n\t\treturn local;\n\t}\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runConformTestWithLibs(new String[]{"X.java", source}, this.getCompilerOptions(), "");
        } else {
            this.runNegativeTestWithLibs(new String[]{"X.java", source}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 3)\n\tpublic @NonNull java.lang.String test(@NonNull java.lang.String arg) {\n\t       ^^^^^^^^\nThe annotation @NonNull is disallowed for this location\n----------\n2. ERROR in X.java (at line 3)\n\tpublic @NonNull java.lang.String test(@NonNull java.lang.String arg) {\n\t                                      ^^^^^^^^\nThe annotation @NonNull is disallowed for this location\n----------\n3. ERROR in X.java (at line 4)\n\t@NonNull java.lang.String local = arg;\n\t^^^^^^^^\nThe annotation @NonNull is disallowed for this location\n----------\n");
        }
    }

    public void testBug420313() {
        this.runNegativeTestWithLibs(new String[]{"OverrideTest.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class OverrideTest implements TypedBase<String>, UntypedBase\n{\n   public void doSomething(String text) // No warning\n   {\n      System.out.println(text);\n   }\n   \n   public void doSomethingElse(String text) // \"Missing non-null annotation\" warning\n   {\n      System.out.println(text);\n   }\n}\n\ninterface TypedBase<T>\n{\n   void doSomething(@NonNull T text);\n}\n\ninterface UntypedBase\n{\n   void doSomethingElse(@NonNull String text);\n}\n"}, "----------\n1. WARNING in OverrideTest.java (at line 5)\n\tpublic void doSomething(String text) // No warning\n\t                        ^^^^^^\nMissing non-null annotation: inherited method from TypedBase<String> specifies this parameter as @NonNull\n----------\n2. WARNING in OverrideTest.java (at line 10)\n\tpublic void doSomethingElse(String text) // \"Missing non-null annotation\" warning\n\t                            ^^^^^^\nMissing non-null annotation: inherited method from UntypedBase specifies this parameter as @NonNull\n----------\n");
    }

    public void testBug424624() {
        this.runConformTestWithLibs(new String[]{"Test3.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class Test3 {\n\n\tpublic Test3() {\n\t}\n\n\tstatic public class Test3aa extends Object {}\n\tstatic public final @NonNull Test3aa Test3a = new Test3aa();\n\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(new String[]{"Test4.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class Test4 {\n\n\tpublic Test4() {\n\t}\n\t\n\tpublic void test() {\n\t\ttest1( Test3.Test3a);\n\t}\n\t\n\tpublic void test1( @NonNull Object object) {\n\t}\n\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug424624a() {
        this.runConformTestWithLibs(new String[]{"test/Test3.java", "package test;\nimport org.eclipse.jdt.annotation.NonNull;\n" + (this.complianceLevel >= 0x340000L ? "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE) @interface Marker {}\n" : "") + "\n" + "public class Test3 {\n" + "\n" + "\tpublic Test3() {\n" + "\t}\n" + "\n" + "\tpublic class Inner extends Object {\n" + "\t\tclass DeepInner {}\n" + "\t}\n" + "\tpublic static class Nested extends Object {\n" + "\t\tclass InnerInNested {}\n" + "\t\tstatic class DeepNested {}\n" + "\t}\n" + "\tstatic public final @NonNull Inner field1 = new Test3().new Inner();\n" + (this.complianceLevel < 0x340000L ? "\tstatic public final @NonNull Inner.DeepInner field2 = field1.new DeepInner();\n\tstatic public final @NonNull Nested.InnerInNested field3 = new Nested().new InnerInNested();\n\tstatic public final @NonNull Nested.DeepNested field4 = new Nested.DeepNested();\n" : "\tstatic public final @Marker Inner.@NonNull DeepInner field2 = field1.new DeepInner();\n\tstatic public final Nested.@NonNull InnerInNested field3 = new Nested().new InnerInNested();\n\tstatic public final Nested.@NonNull DeepNested field4 = new Nested.DeepNested();\n") + "\n" + "}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(new String[]{"Test4.java", "import org.eclipse.jdt.annotation.NonNull;\nimport test.Test3;\n\npublic class Test4 {\n\n\tpublic Test4() {\n\t}\n\t\n\tpublic void test() {\n\t\ttest1( Test3.field1);\n\t\ttest1( Test3.field2);\n\t\ttest1( Test3.field3);\n\t\ttest1( Test3.field4);\n\t}\n\t\n\tpublic void test1( @NonNull Object object) {\n\t}\n\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug424624b() {
        this.runConformTestWithLibs(new String[]{"Test3.java", "import org.eclipse.jdt.annotation.NonNull;\n" + (this.complianceLevel >= 0x340000L ? "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE) @interface Marker {}\n" : "") + "\n" + "public class Test3 {\n" + "\n" + "\tpublic Test3() {\n" + "\t}\n" + "\n" + "\tpublic class Inner extends Object {\n" + "\t\tclass DeepInner {}\n" + "\t}\n" + "\tpublic static class Nested extends Object {\n" + "\t\tclass InnerInNested {}\n" + "\t\tstatic class DeepNested {}\n" + "\t}\n" + "\tstatic public final @NonNull Inner field1 = new Test3().new Inner();\n" + (this.complianceLevel < 0x340000L ? "\tstatic public final @NonNull Inner.DeepInner field2 = field1.new DeepInner();\n\tstatic public final @NonNull Nested.InnerInNested field3 = new Nested().new InnerInNested();\n\tstatic public final @NonNull Nested.DeepNested field4 = new Nested.DeepNested();\n" : "\tstatic public final @Marker Inner.@NonNull DeepInner field2 = field1.new DeepInner();\n\tstatic public final Nested.@NonNull InnerInNested field3 = new Nested().new InnerInNested();\n\tstatic public final Nested.@NonNull DeepNested field4 = new Nested.DeepNested();\n") + "\n" + "}\n", "Test4.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class Test4 {\n\n\tpublic Test4() {\n\t}\n\t\n\tpublic void test() {\n\t\ttest1( Test3.field1);\n\t\ttest1( Test3.field2);\n\t\ttest1( Test3.field3);\n\t\ttest1( Test3.field4);\n\t}\n\t\n\tpublic void test1( @NonNull Object object) {\n\t}\n\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug430084() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\npublic class X {\tY() {} }"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic class X {\tY() {} }\n\t                \t^^^\nReturn type for the method is missing\n----------\n");
    }

    public void testBug432348() {
        String sourceString = "import org.eclipse.jdt.annotation.NonNull;\nimport java.lang.annotation.*;\n\n@Target(ElementType.FIELD)\n@interface Marker {}\npublic enum E {\n\t@Marker @NonNull A, B, C\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runConformTestWithLibs(new String[]{"E.java", sourceString}, this.getCompilerOptions(), "");
        } else {
            this.runNegativeTestWithLibs(new String[]{"E.java", sourceString}, "----------\n1. ERROR in E.java (at line 7)\n\t@Marker @NonNull A, B, C\n\t        ^^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
        }
    }

    public void testBug403674() {
        Map options = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.Nullable;\npublic class X {\n   public static void main(String[] args) {\n      // Correctly flagged as \"Potential null pointer access.\"\n      switch (computeStringValue()) {}\n   }\n   private static @Nullable String computeStringValue() { return null; }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 5)\n\tswitch (computeStringValue()) {}\n\t        ^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x330000L ? "Cannot switch on a value of type String for source level below 1.7. Only convertible int values or enum variables are permitted\n" : "Potential null pointer access: The method computeStringValue() may return null\n") + "----------\n");
    }

    public void testBug403674a() {
        Map options = this.getCompilerOptions();
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.Nullable;\npublic class X {\n   private enum EnumValue{}\n   public static void main(String[] args) {\n      // Before Fix: Not flagged.\n      switch (computeEnumValue()) {}\n      @Nullable EnumValue value = computeEnumValue();\n      // Correctly flagged as \"Potential null pointer access.\"\n      // Before Fix: Not flagged.\n      switch (value) {}\n   }\n   private static @Nullable EnumValue computeEnumValue() { return null; }\n}\n"}, options, "----------\n1. ERROR in X.java (at line 6)\n\tswitch (computeEnumValue()) {}\n\t        ^^^^^^^^^^^^^^^^^^\nPotential null pointer access: The method computeEnumValue() may return null\n----------\n2. ERROR in X.java (at line 10)\n\tswitch (value) {}\n\t        ^^^^^\n" + (this.complianceLevel < 0x340000L ? "Potential null pointer access: The variable value may be null at this location\n" : "Potential null pointer access: this expression has a '@Nullable' type\n") + "----------\n");
    }

    public void testBug422796() {
        this.runConformTestWithLibs(new String[]{"NullExprTest.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault\npublic class NullExprTest {\n\t\n\tprivate @Nullable Boolean b() { return null; }\n\t\n\tpublic void testBoolean() {\n\t\tBoolean b1 = b();\n\t\tboolean b = b1 == null || \n\t\t\t\tb1; // <-- Previously bugggy: reported potential NPE (*)\n\t\tassertTrue(b);\n\t}\n\tstatic void assertTrue(boolean b) {}\n\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug422796a() {
        this.runConformTestWithLibs(new String[]{"NullExprTest.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault\npublic class NullExprTest {\n\t\n\tprivate @Nullable Boolean b() { return null; }\n\t\n\tpublic void testBoolean() {\n\t\tBoolean b1 = b();\n\t\tboolean b = b1 != null && \n\t\t\t\tb1; // <-- Previously bugggy: reported potential NPE (*)\n\t\tassertTrue(b);\n\t}\n\tstatic void assertTrue(boolean b) {}\n\n}"}, this.getCompilerOptions(), "");
    }

    public void testBug422796b() {
        this.runNegativeTestWithLibs(new String[]{"NullExprTest.java", "public class NullExprTest {\n\t\n\tprivate Boolean b() { return null; }\n\t\n\tpublic void testBoolean1() {\n\t\tBoolean b1 = b();\n\t\tboolean b = b1 == null && \n\t\t\t\tb1; // <-- definite NPE (*)\n\t\tassertTrue(b);\n\t}\n\tpublic void testBoolean2(boolean x) {\n\t\tBoolean b1 = b();\n\t\tboolean b = (b1 == null || x) && \n\t\t\t\tb1; // <-- potential NPE (*)\n\t\tassertTrue(b);\n\t}\n\tstatic void assertTrue(boolean b) {}\n\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in NullExprTest.java (at line 8)\n\tb1; // <-- definite NPE (*)\n\t^^\nNull pointer access: This expression of type Boolean is null but requires auto-unboxing\n----------\n2. ERROR in NullExprTest.java (at line 14)\n\tb1; // <-- potential NPE (*)\n\t^^\nPotential null pointer access: This expression of type Boolean may be null but requires auto-unboxing\n----------\n");
    }

    public void testBug434374() {
        this.runConformTestWithLibs(new String[]{"bal/AdapterService.java", "/*******************************************************************************\n * Copyright (c) 2013 BestSolution.at and others.\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * which accompanies this distribution, and is available at\n * http://www.eclipse.org/legal/epl-v10.html\n *\n * Contributors:\n *     Tom Schindl <tom.schindl@bestsolution.at> - initial API and implementation\n *******************************************************************************/\npackage bal;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\npublic interface AdapterService {\n\tpublic boolean canAdapt(@Nullable Object sourceObject, @NonNull Class<?> targetType);\n\n\t@Nullable\n\tpublic <A> A adapt(@Nullable Object sourceObject, @NonNull Class<A> targetType, ValueAccess... valueAccesses);\n\n\tpublic interface ValueAccess {\n\t\t@Nullable\n\t\tpublic <O> O getValue(@NonNull String key);\n\n\t\t@Nullable\n\t\tpublic <O> O getValue(@NonNull Class<O> key);\n\t}\n}\n", "bal/AdapterServiceImpl.java", "/*******************************************************************************\n * Copyright (c) 2013 BestSolution.at and others.\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * which accompanies this distribution, and is available at\n * http://www.eclipse.org/legal/epl-v10.html\n *\n * Contributors:\n *     Tom Schindl <tom.schindl@bestsolution.at> - initial API and implementation\n *******************************************************************************/\npackage bal;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class AdapterServiceImpl implements AdapterService {\n\n" + (this.complianceLevel >= 0x320000L ? "\t@Override\n" : "") + "\tpublic boolean canAdapt(@Nullable Object sourceObject, @NonNull Class<?> targetType) {\n" + "\t\treturn false;\n" + "\t}\n" + "\n" + (this.complianceLevel >= 0x320000L ? "\t@Override\n" : "") + "\t@Nullable\n" + "\tpublic <A> A adapt(@Nullable Object sourceObject, @NonNull Class<A> targetType, ValueAccess... valueAccesses) {\n" + "\t\treturn null;\n" + "\t}\n" + "}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug434374a() {
        this.runConformTestWithLibs(new String[]{"bug434374/AdapterService.java", "package bug434374;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic interface AdapterService {\n\tpublic @NonNull <A> Class<A> getClassOfA(A object);\n\n}\n", "bug434374/AdapterServiceImpl.java", "package bug434374;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class AdapterServiceImpl implements AdapterService {\n\n" + (this.complianceLevel >= 0x320000L ? "\t@Override\n" : "") + "\t@NonNull\n" + "\tpublic <A> Class<A> getClassOfA(A object) {\n" + "\t\tthrow new RuntimeException();\n" + "\t}\n" + "\n" + "}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug434374b() {
        this.runNegativeTestWithLibs(new String[]{"bal/TestGeneric.java", "package bal;\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class TestGeneric<T> {\n\t@NonNull\n\tpublic T test() {\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in bal\\TestGeneric.java (at line 7)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n");
    }

    public void testBug434374c() {
        this.runConformTestWithLibs(new String[]{"bal/TestGeneric.java", "package bal;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class TestGeneric<T> {\n\tpublic @Nullable T test() {\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }
}

