/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jdt.core.tests.compiler.regression.NullReferenceImplTransformations;
import org.eclipse.jdt.core.tests.compiler.regression.NullReferenceTest;
import org.eclipse.jdt.core.tests.compiler.regression.TestLocalVariableBinding;
import org.eclipse.jdt.core.tests.compiler.regression.UnconditionalFlowInfoTestHarness;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;

public class NullReferenceImplTests
extends NullReferenceTest {
    private static final int COMBINATION_TESTS_LOOP_NB = 1;
    private static final boolean MEASURE_PERFORMANCES = false;
    private static int coveragePointsNb = 45;
    static /* synthetic */ Class class$0;

    public NullReferenceImplTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class clazz = NullReferenceImplTests.testClass();
        TestSuite all = new TestSuite(clazz.getName());
        List tests = NullReferenceImplTests.buildTestsList(NullReferenceImplTests.testClass());
        int i = 0;
        int length = tests.size();
        while (i < length) {
            all.addTest((Test)tests.get(i));
            ++i;
        }
        return all;
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.NullReferenceImplTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test2050_markAsComparedEqualToNonNull() {
        int failures = NullReferenceImplTransformations.markAsComparedEqualToNonNull.test();
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2051_markAsComparedEqualToNull() {
        int failures = NullReferenceImplTransformations.markAsComparedEqualToNull.test();
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2055_markAsDefinitelyNonNull() {
        int failures = NullReferenceImplTransformations.markAsDefinitelyNonNull.test();
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2056_markAsDefinitelyNull() {
        int failures = NullReferenceImplTransformations.markAsDefinitelyNull.test();
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2057_markAsDefinitelyUnknown() {
        int failures = NullReferenceImplTransformations.markAsDefinitelyUnknown.test();
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2060_addInitializationsFrom() {
        int failures = NullReferenceImplTransformations.addInitializationsFrom.test();
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2061_addPotentialInitializationsFrom() {
        int failures = NullReferenceImplTransformations.addPotentialInitializationsFrom.test();
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2062_mergedWith() {
        int failures = NullReferenceImplTransformations.mergedWith.test();
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2400_state_consistency() {
        int failures = 0;
        String header = "state consistency failures: ";
        int l = 0;
        while (l < 1) {
            int i = 0;
            while (i < State.states.length) {
                if (State.states[i].symbolic) {
                    UnconditionalFlowInfoTestHarness state = UnconditionalFlowInfoTestHarness.testUnconditionalFlowInfo(State.states[i]);
                    boolean isDefinitelyNonNull = state.isDefinitelyNonNull(TestLocalVariableBinding.local0);
                    boolean isDefinitelyNull = state.isDefinitelyNull(TestLocalVariableBinding.local0);
                    boolean isDefinitelyUnknown = state.isDefinitelyUnknown(TestLocalVariableBinding.local0);
                    boolean isPotentiallyNonNull = state.isPotentiallyNonNull(TestLocalVariableBinding.local0);
                    boolean isPotentiallyNull = state.isPotentiallyNull(TestLocalVariableBinding.local0);
                    boolean isPotentiallyUnknown = state.isPotentiallyUnknown(TestLocalVariableBinding.local0);
                    boolean isProtectedNonNull = state.isProtectedNonNull(TestLocalVariableBinding.local0);
                    boolean isProtectedNull = state.isProtectedNull(TestLocalVariableBinding.local0);
                    boolean cannotBeDefinitelyNullOrNonNull = state.cannotBeDefinitelyNullOrNonNull(TestLocalVariableBinding.local0);
                    boolean cannotBeNull = state.cannotBeNull(TestLocalVariableBinding.local0);
                    boolean canOnlyBeNull = state.canOnlyBeNull(TestLocalVariableBinding.local0);
                    if (isDefinitelyNonNull && (isDefinitelyNull || isDefinitelyUnknown || isPotentiallyNull || isProtectedNull)) {
                        if (failures == 0) {
                            System.out.println(header);
                        }
                        ++failures;
                        System.out.println("\t\tconsistency breakage for definitely non null state " + State.states[i].name);
                    }
                    if (isDefinitelyNull && (isDefinitelyNonNull || isDefinitelyUnknown || isPotentiallyUnknown || isProtectedNonNull)) {
                        if (failures == 0) {
                            System.out.println(header);
                        }
                        ++failures;
                        System.out.println("\t\tconsistency breakage for definitely null state " + State.states[i].name);
                    }
                    if (isDefinitelyUnknown && (isDefinitelyNonNull || isDefinitelyNull || isPotentiallyNull || isProtectedNonNull || isProtectedNull)) {
                        if (failures == 0) {
                            System.out.println(header);
                        }
                        ++failures;
                        System.out.println("\t\tconsistency breakage for definitely unknown state " + State.states[i].name);
                    }
                    if (isProtectedNonNull && !isDefinitelyNonNull || isProtectedNull && !isDefinitelyNull || i > 0 && !State.states[i].name.equals("pot. non null") && !isDefinitelyNonNull && !isDefinitelyNull && !isDefinitelyUnknown && !isPotentiallyNull && !isPotentiallyUnknown && !isProtectedNonNull && !isProtectedNull || cannotBeDefinitelyNullOrNonNull != (isPotentiallyUnknown || isPotentiallyNull && isPotentiallyNonNull) || cannotBeNull != (isProtectedNonNull || isDefinitelyNonNull) || canOnlyBeNull != (isProtectedNull || isDefinitelyNull)) {
                        if (failures == 0) {
                            System.out.println(header);
                        }
                        ++failures;
                        System.out.println("\t\tconsistency breakage for " + State.states[i].name);
                    }
                }
                ++i;
            }
            ++l;
        }
        int i = 0;
        while (i < State.states.length) {
            if (State.states[i].symbolic) {
                UnconditionalFlowInfoTestHarness state = UnconditionalFlowInfoTestHarness.testUnconditionalFlowInfo(State.states[i], 64);
                boolean isDefinitelyNonNull = state.isDefinitelyNonNull(TestLocalVariableBinding.local64);
                boolean isDefinitelyNull = state.isDefinitelyNull(TestLocalVariableBinding.local64);
                boolean isDefinitelyUnknown = state.isDefinitelyUnknown(TestLocalVariableBinding.local64);
                boolean isPotentiallyNonNull = state.isPotentiallyNonNull(TestLocalVariableBinding.local64);
                boolean isPotentiallyNull = state.isPotentiallyNull(TestLocalVariableBinding.local64);
                boolean isPotentiallyUnknown = state.isPotentiallyUnknown(TestLocalVariableBinding.local64);
                boolean isProtectedNonNull = state.isProtectedNonNull(TestLocalVariableBinding.local64);
                boolean isProtectedNull = state.isProtectedNull(TestLocalVariableBinding.local64);
                boolean cannotBeDefinitelyNullOrNonNull = state.cannotBeDefinitelyNullOrNonNull(TestLocalVariableBinding.local64);
                boolean cannotBeNull = state.cannotBeNull(TestLocalVariableBinding.local64);
                boolean canOnlyBeNull = state.canOnlyBeNull(TestLocalVariableBinding.local64);
                if (isDefinitelyNonNull && (isDefinitelyNull || isDefinitelyUnknown || isPotentiallyNull || isProtectedNull)) {
                    if (failures == 0) {
                        System.out.println(header);
                    }
                    ++failures;
                    System.out.println("\t\tconsistency breakage (64) for definitely non null state " + State.states[i].name);
                }
                if (isDefinitelyNull && (isDefinitelyNonNull || isDefinitelyUnknown || isPotentiallyUnknown || isProtectedNonNull)) {
                    if (failures == 0) {
                        System.out.println(header);
                    }
                    ++failures;
                    System.out.println("\t\tconsistency breakage (64) for definitely null state " + State.states[i].name);
                }
                if (isDefinitelyUnknown && (isDefinitelyNonNull || isDefinitelyNull || isPotentiallyNull || isProtectedNonNull || isProtectedNull)) {
                    if (failures == 0) {
                        System.out.println(header);
                    }
                    ++failures;
                    System.out.println("\t\tconsistency breakage (64) for definitely unknown state " + State.states[i].name);
                }
                if (isProtectedNonNull && !isDefinitelyNonNull || isProtectedNull && !isDefinitelyNull || i > 0 && !State.states[i].name.equals("pot. non null") && !isDefinitelyNonNull && !isDefinitelyNull && !isDefinitelyUnknown && !isPotentiallyNull && !isPotentiallyUnknown && !isProtectedNonNull && !isProtectedNull || cannotBeDefinitelyNullOrNonNull != (isPotentiallyUnknown || isPotentiallyNull && isPotentiallyNonNull) || cannotBeNull != (isProtectedNonNull || isDefinitelyNonNull) || canOnlyBeNull != (isProtectedNull || isDefinitelyNull)) {
                    if (failures == 0) {
                        System.out.println(header);
                    }
                    ++failures;
                    System.out.println("\t\tconsistency breakage (64) for " + State.states[i].name);
                }
            }
            ++i;
        }
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2500_addInitializationsFrom_for_definites() {
        int failures = 0;
        int i = 0;
        while (i < State.states.length) {
            block8: {
                if (!State.states[i].symbolic) break block8;
                UnconditionalFlowInfoTestHarness source1 = UnconditionalFlowInfoTestHarness.testUnconditionalFlowInfo(State.states[i]);
                int j = 0;
                while (j < State.states.length) {
                    block9: {
                        UnconditionalFlowInfoTestHarness result2;
                        UnconditionalFlowInfoTestHarness result1;
                        UnconditionalFlowInfoTestHarness source2;
                        block11: {
                            block13: {
                                block12: {
                                    block10: {
                                        if (!State.states[j].symbolic) break block9;
                                        source2 = UnconditionalFlowInfoTestHarness.testUnconditionalFlowInfo(State.states[j]);
                                        result1 = (UnconditionalFlowInfoTestHarness)source1.copy();
                                        result2 = (UnconditionalFlowInfoTestHarness)source1.copy();
                                        if (!source2.isDefinitelyNonNull(TestLocalVariableBinding.local0)) break block10;
                                        if (source2.isProtectedNonNull(TestLocalVariableBinding.local0)) break block9;
                                        result1.markAsDefinitelyNonNull(TestLocalVariableBinding.local0);
                                        break block11;
                                    }
                                    if (!source2.isDefinitelyNull(TestLocalVariableBinding.local0)) break block12;
                                    if (source2.isProtectedNull(TestLocalVariableBinding.local0)) break block9;
                                    result1.markAsDefinitelyNull(TestLocalVariableBinding.local0);
                                    break block11;
                                }
                                if (!source2.isDefinitelyUnknown(TestLocalVariableBinding.local0)) break block13;
                                result1.markAsDefinitelyUnknown(TestLocalVariableBinding.local0);
                                break block11;
                            }
                            if (source2.nullBit1 == 0L) break block9;
                            if (failures == 0) {
                                System.out.println("addInitializationsFrom_for_definites failures: ");
                            }
                            ++failures;
                            System.out.println("\t\t" + State.states[j].name + " should answer true to at least one isDefinite* query");
                        }
                        result2.addInitializationsFrom((FlowInfo)source2);
                        if (!result1.testEquals(result2)) {
                            if (failures == 0) {
                                System.out.println("addInitializationsFrom_for_definites failures: ");
                            }
                            ++failures;
                            System.out.println("\t\t" + State.states[i].name + " + " + State.states[j].name + " => " + result2.asState().name + " instead of: " + result1.asState().name);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        NullReferenceImplTests.assertTrue((String)("nb of failures: " + failures), (failures == 0 ? 1 : 0) != 0);
    }

    public void test2998_coverage() {
    }

    public void test2999_coverage() {
    }

    String testCodedValueOf(long[] data) {
        int length = data.length;
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            result.append(data[i] == 0L ? (char)'0' : '1');
            ++i;
        }
        return result.toString();
    }

    static String testStringValueOf(long[] data) {
        int length = data.length;
        StringBuffer result = new StringBuffer(length * 2 + 1);
        result.append('{');
        int i = 0;
        while (i < length) {
            if (i > 0) {
                result.append(',');
            }
            result.append(data[i]);
            ++i;
        }
        result.append('}');
        return result.toString();
    }

    public static class State
    implements Comparable {
        public static final State[] states = new State[]{new State(0, "start"), new State(1), new State(2), new State(3), new State(4, "pot. unknown"), new State(5), new State(6), new State(7), new State(8, "pot. non null"), new State(9), new State(10), new State(11), new State(12, "pot. nn & pot. un"), new State(13), new State(14), new State(15), new State(16, "pot. null"), new State(17), new State(18), new State(19), new State(20, "pot. n & pot. un"), new State(21), new State(22), new State(23), new State(24, "pot. n & pot. nn"), new State(25), new State(26), new State(27), new State(28), new State(29), new State(30), new State(31), new State(32), new State(33), new State(34), new State(35), new State(36, "def. unknown"), new State(37), new State(38), new State(39), new State(40, "def. non null"), new State(41), new State(42), new State(43), new State(44, "pot. nn & prot. nn"), new State(45), new State(46), new State(47), new State(48, "def. null"), new State(49), new State(50), new State(51), new State(52, "pot. n & prot. n"), new State(53), new State(54), new State(55), new State(56, "prot. null"), new State(57), new State(58), new State(59), new State(60, "prot. non null"), new State(61), new State(62), new State(63)};
        public static final State start = states[0];
        public static final int stateMaxValue = 63;
        public static final int stateWidth = 6;
        public static final int statesNb = 64;
        String name;
        String printableBitsField;
        String hexString;
        public byte value;
        boolean symbolic;
        private static Map namesIndex;
        private static final String definitionStartMarker = "// STATES DEFINITION START";
        private static final String definitionEndMarker = "// STATES DEFINITION END";
        private static final String initializerStartMarker = "// STATES INITIALIZER START";
        private static final String initializerEndMarker = "// STATES INITIALIZER END";

        private State() {
        }

        private State(int numericValue) {
            this(numericValue, null);
        }

        private State(int numericValue, String publicName) {
            if (numericValue > 63) {
                throw new IllegalArgumentException("state value overflow");
            }
            this.value = (byte)numericValue;
            StringBuffer printableValue = new StringBuffer(6);
            int i = 5;
            while (i >= 0) {
                printableValue.append((numericValue >>> i & 1) != 0 ? (char)'1' : '0');
                --i;
            }
            this.printableBitsField = printableValue.toString();
            this.hexString = this.value > 15 ? "0x" + Integer.toHexString(this.value).toUpperCase() : "0x0" + Integer.toHexString(this.value).toUpperCase();
            if (publicName != null) {
                this.name = publicName;
                this.symbolic = true;
            } else {
                this.name = this.printableBitsField;
            }
        }

        private State(String commentLine) {
            int current = 32;
            int cursor = 0;
            int length = commentLine.length();
            while (cursor < length) {
                char c = commentLine.charAt(cursor);
                current = c;
                if (c == '0' || current == 49) break;
                ++cursor;
            }
            if (cursor == length) {
                throw new RuntimeException("bad state definition format (missing bits field): " + commentLine);
            }
            int valueDigits = 1;
            while (cursor < length - 1 && valueDigits < 6) {
                this.value = (byte)((this.value << 1) + (current - 48));
                char c = commentLine.charAt(++cursor);
                current = c;
                if (c != '0' && current != 49) {
                    throw new RuntimeException("bad state definition format (inappropriate character in bits field): " + commentLine);
                }
                ++valueDigits;
            }
            if (valueDigits < 6) {
                throw new RuntimeException("bad state definition format (bits field is too short): " + commentLine);
            }
            this.value = (byte)((this.value << 1) + (current - 48));
            this.printableBitsField = commentLine.substring(cursor - 6 + 1, cursor + 1);
            this.hexString = this.value > 15 ? "0x" + Integer.toHexString(this.value).toUpperCase() : "0x0" + Integer.toHexString(this.value).toUpperCase();
            while (++cursor < length) {
                char c = commentLine.charAt(++cursor);
                current = c;
                if (Character.isWhitespace(c) && current != 10) continue;
            }
            if (cursor < length && current != 10) {
                this.name = commentLine.substring(cursor, length);
            }
            if (this.name == null) {
                this.name = this.printableBitsField;
            } else {
                this.symbolic = true;
            }
        }

        private String asInitializer() {
            boolean nameIsSymbolic;
            StringBuffer result = new StringBuffer(70);
            result.append("\t\tnew State(");
            result.append(this.value);
            char first = this.name.charAt(0);
            boolean bl = nameIsSymbolic = first != '0' && first != '1';
            if (nameIsSymbolic) {
                result.append(", \"");
                result.append(this.name);
                result.append('\"');
            }
            result.append("), // ");
            result.append(this.printableBitsField);
            return result.toString();
        }

        long[] asLongArray() {
            long[] result = new long[6];
            int i = 0;
            while (i < 6) {
                result[i] = (this.value >> 6 - i - 1 & 1) == 0 ? 0 : 1;
                ++i;
            }
            return result;
        }

        private String asSourceComment() {
            boolean nameIsSymbolic;
            StringBuffer result = new StringBuffer(70);
            result.append("\t\t");
            result.append(this.printableBitsField);
            char first = this.name.charAt(0);
            boolean bl = nameIsSymbolic = first != '0' && first != '1';
            if (nameIsSymbolic) {
                result.append('\t');
                result.append(this.name);
            }
            return result.toString();
        }

        public int compareTo(Object o) {
            return this.value - ((State)o).value;
        }

        static State fromLongValues(long bit1, long bit2, long bit3, long bit4, long bit5, long bit6) {
            return states[(int)((bit6 & 1L) + 2L * ((bit5 & 1L) + 2L * ((bit4 & 1L) + 2L * ((bit3 & 1L) + 2L * ((bit2 & 1L) + 2L * (bit1 & 1L))))))];
        }

        static State fromSymbolicName(String name) {
            if (namesIndex == null) {
                namesIndex = new HashMap(states.length);
                int i = 0;
                while (i < states.length) {
                    if (State.states[i].name != null) {
                        namesIndex.put(State.states[i].name, states[i]);
                    }
                    ++i;
                }
            }
            return (State)namesIndex.get(name);
        }

        private static void grabDefinitionFromComment(BufferedReader input) {
            int i = 0;
            while (i <= 63) {
                State.states[i] = null;
                ++i;
            }
            try {
                String line;
                while ((line = input.readLine()) != null && line.indexOf(definitionEndMarker) == -1) {
                    State current = new State(line);
                    if (states[current.value] != null) {
                        throw new RuntimeException("duplicate state for index: " + current.value);
                    }
                    State.states[current.value] = current;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            i = 0;
            while (i < 63) {
                if (states[i] == null) {
                    State.states[i] = new State(i);
                }
                ++i;
            }
        }

        static void reinitializeFromComment(BufferedReader input, BufferedWriter output) {
            String tab = "";
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    int length;
                    char c;
                    int i;
                    boolean reachedStart;
                    output.write(line);
                    output.write(10);
                    int cursor = line.indexOf(definitionStartMarker);
                    if (cursor != -1) {
                        reachedStart = true;
                        i = 0;
                        while (i < cursor) {
                            c = line.charAt(i);
                            if (!Character.isWhitespace(c)) {
                                reachedStart = false;
                                break;
                            }
                            tab = String.valueOf(tab) + c;
                            ++i;
                        }
                        if (reachedStart) {
                            State.grabDefinitionFromComment(input);
                            i = 0;
                            length = states.length;
                            while (i < length) {
                                output.write(states[i].asSourceComment());
                                output.write(10);
                                ++i;
                            }
                            output.write(String.valueOf(tab) + definitionEndMarker + "\n");
                        }
                    }
                    if ((cursor = line.indexOf(initializerStartMarker)) == -1) continue;
                    reachedStart = true;
                    tab = "";
                    i = 0;
                    while (i < cursor) {
                        c = line.charAt(i);
                        if (!Character.isWhitespace(c)) {
                            reachedStart = false;
                            break;
                        }
                        tab = String.valueOf(tab) + c;
                        ++i;
                    }
                    if (!reachedStart) continue;
                    while ((line = input.readLine()) != null && line.indexOf(initializerEndMarker) == -1) {
                    }
                    i = 0;
                    length = states.length;
                    while (i < length) {
                        output.write(states[i].asInitializer());
                        output.write(10);
                        ++i;
                    }
                    output.write(String.valueOf(tab) + initializerEndMarker + "\n");
                }
                output.flush();
                namesIndex = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        static Iterator symbolicStates() {
            return new Iterator(){
                int nextSymbolic;
                {
                    this.nextSymbolic = -1;
                }

                /*
                 * Unable to fully structure code
                 */
                public boolean hasNext() {
                    block3: {
                        if (this.nextSymbolic != -1) ** GOTO lbl11
                        this.nextSymbolic = 0;
                        while (this.nextSymbolic < State.states.length) {
                            if (!State.states[this.nextSymbolic].symbolic) {
                                ++this.nextSymbolic;
                                continue;
                            }
                            break block3;
                        }
                        break block3;
                        while (!State.states[this.nextSymbolic].symbolic) {
                            ++this.nextSymbolic;
lbl11:
                            // 2 sources

                            if (this.nextSymbolic < State.states.length) continue;
                        }
                    }
                    return this.nextSymbolic < State.states.length;
                }

                public Object next() {
                    State result = null;
                    if (this.nextSymbolic < State.states.length) {
                        result = State.states[this.nextSymbolic];
                        ++this.nextSymbolic;
                    }
                    return result;
                }

                public void remove() {
                    throw new RuntimeException("unimplemented");
                }
            };
        }

        public String toString() {
            return this.name;
        }
    }
}

